use std::path::PathBuf;
use structopt::StructOpt;

use super::Command;
use crate::backup::FilesystemTree;

#[derive(Debug, StructOpt)]
pub struct BackupCommand {
    /// A list of files and/or directories
    #[structopt(name = "FILE/DIR", min_values = 1, required = true)]
    paths: Vec<PathBuf>,
}

impl Command for BackupCommand {
    fn run(&self) -> bool {
        let tree = FilesystemTree::from(self.paths.as_slice());

        let mut errs = 0usize;
        let mut tot = 0usize;
        for e in tree.iter() {
            tot += 1;
            if e.is_err() {
                errs += 1;
            }
            // println!("{:?}", e);
        }

        println!("Err: {} \t Total: {}", errs, tot);

        true
    }
}
