pub const MIN_SIZE: usize = 65_536; // Minimum chunk size (64 KiB)
pub const MAX_SIZE: usize = 1_048_576; // Maximum chunk size (1 MiB)
const NORMAL_SIZE: usize = 262_144; // Threshold for chunking difficulty (256 KiB)

const MASK_L: u32 = 0xe6b4c86a;
const MASK_S: u32 = 0xf6b7c8ea;

mod linear;

pub(crate) fn next_chunk_length(bytes: &[u8], gear: &[u32; 256]) -> usize {
    return unsafe { linear::next_chunk_length(bytes, gear) };
}
