pub(super) unsafe fn next_chunk_length(bytes: &[u8], gear: &[u32; 256]) -> usize {
    let mut i = super::MIN_SIZE; // Skip min len

    let mut fp = 0u32;

    while i < usize::min(bytes.len(), super::NORMAL_SIZE) {
        let b = *bytes.get_unchecked(i) as usize;
        fp = (fp << 1).wrapping_add(*gear.get_unchecked(b));
        i += 1;
        if fp & super::MASK_S == 0 {
            return i;
        }
    }

    while i < usize::min(bytes.len(), super::MAX_SIZE) {
        let b = *bytes.get_unchecked(i) as usize;
        fp = (fp << 1).wrapping_add(*gear.get_unchecked(b));
        i += 1;
        if fp & super::MASK_L == 0 {
            return i;
        }
    }

    return i;
}
