//! This module contains traits and structs related to behaviour.

/// This is an implementation of a [`Behaviour`].
#[derive(Default)]
pub struct Behaviour {
    /// The name of the [`Behaviour`].
    pub name: String,
    /// The UUID of the [`Behaviour`].
    pub uuid: uuid::Uuid,
}

impl Behaviour {
    /// Create a new [`Behaviour`].
    /// It takes just a `name` as an argument.
    /// The `uuid` is randomly generated.
    ///
    /// ```rust
    /// use belief_spread::behaviour::Behaviour;
    /// let x = Behaviour::new("name".to_string());
    /// ```
    pub fn new(name: String) -> Self {
        Self {
            name,
            uuid: uuid::Uuid::new_v4(),
        }
    }
}

#[cfg(test)]
mod tests {
    use super::Behaviour;

    #[test]
    fn new_assigns_name() {
        let x = Behaviour::new("name".to_string());
        assert_eq!(x.name, "name");
    }
}
