//! This module contains something with a [`uuid::Uuid`];

use mockall::predicate::*;
use mockall::*;

/// Something with a [`uuid::Uuid`].
#[automock]
pub trait UUIDd {
    /// Gets the [`uuid::Uuid`] of the [`UUIDd`] object.
    ///
    /// ```rust
    /// use belief_spread::uuidd::{UUIDd, MockUUIDd};
    ///
    /// let uuid_v = uuid::Uuid::new_v4();
    /// let mut mock = MockUUIDd::new();
    /// mock.expect_get_uuid()
    ///     .times(1)
    ///     .return_const(uuid_v);
    /// let y: &uuid::Uuid = mock.get_uuid();
    /// assert_eq!(y, &uuid_v);
    /// ```
    fn get_uuid(&self) -> &uuid::Uuid;
    /// Sets the [`uuid::Uuid`] of the [`UUIDd`] object to `new_uuid`.
    ///
    /// ```rust
    /// use belief_spread::uuidd::{UUIDd, MockUUIDd};
    ///
    /// use mockall::*;
    /// use mockall::predicate::*;
    ///
    /// let uuid_v = uuid::Uuid::new_v4();
    /// let mut mock = MockUUIDd::new();
    ///
    /// mock.expect_set_uuid()
    ///     .with(predicate::eq(uuid_v))
    ///     .times(1)
    ///     .returning(|_| ());
    ///
    /// mock.set_uuid(uuid_v);
    /// ```
    fn set_uuid(&mut self, new_uuid: uuid::Uuid);
}
