//! This module contains something with a name.

use mockall::predicate::*;
use mockall::*;

/// Something with a name.
#[automock]
pub trait Named {
    /// Gets the name of the [`Named`] object.
    ///
    /// ```rust
    /// use belief_spread::named::{Named, MockNamed};
    ///
    /// let name = "Name".to_string();
    /// let mut mock = MockNamed::new();
    /// mock.expect_get_name()
    ///     .times(1)
    ///     .return_const(name);
    /// let y: &str = mock.get_name();
    /// assert_eq!(y, "Name");
    /// ```
    fn get_name(&self) -> &str;
    /// Sets the name of the [`Named`] object to `name`.
    ///
    /// ```rust
    /// use belief_spread::named::{Named, MockNamed};
    ///
    /// use mockall::*;
    /// use mockall::predicate::*;
    ///
    /// let name = "Name".to_string();
    /// let mut mock = MockNamed::new();
    ///
    /// mock.expect_set_name()
    ///     .with(predicate::eq("New name".to_string()))
    ///     .times(1)
    ///     .returning(|_| ());
    ///
    /// mock.set_name("New name".to_string());
    /// ```
    fn set_name(&mut self, name: String);
}
