// Copyright 2020-2021 IOTA Stiftung
// SPDX-License-Identifier: Apache-2.0

use crate::backend::StorageBackend;

/// `Truncate<K, V>` trait extends the `StorageBackend` with `truncate` operation for the (key: K, value: V) pair;
/// therefore, it should be explicitly implemented for the corresponding `StorageBackend`.
#[async_trait::async_trait]
pub trait Truncate<K, V>: StorageBackend {
    /// Truncates all the entries associated with the (K, V) pair from the storage.
    async fn truncate(&self) -> Result<(), Self::Error>;
}
