# The atomic_ops library (`libatomic_ops`)

IN NEW CODE, PLEASE USE C11 OR C++14 STANDARD ATOMICS INSTEAD OF THE CORE
LIBRARY IN THIS PACKAGE.

[![Travis-CI build status](https://travis-ci.com/ivmai/libatomic_ops.svg?branch=master)](https://travis-ci.com/ivmai/libatomic_ops)
[![AppVeyor CI build status](https://ci.appveyor.com/api/projects/status/github/ivmai/libatomic_ops?branch=master&svg=true)](https://ci.appveyor.com/project/ivmai/libatomic-ops)
[![Codecov.io](https://codecov.io/github/ivmai/libatomic_ops/coverage.svg?branch=master)](https://codecov.io/github/ivmai/libatomic_ops?branch=master)
[![Coveralls test coverage status](https://coveralls.io/repos/ivmai/libatomic_ops/badge.png?branch=master)](https://coveralls.io/github/ivmai/libatomic_ops)
[![Coverity Scan build status](https://scan.coverity.com/projects/10809/badge.svg)](https://scan.coverity.com/projects/ivmai-libatomic_ops)
[![LGTM Code Quality: Cpp](https://img.shields.io/lgtm/grade/cpp/g/ivmai/libatomic_ops.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/ivmai/libatomic_ops/context:cpp)
[![LGTM Total Alerts](https://img.shields.io/lgtm/alerts/g/ivmai/libatomic_ops.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/ivmai/libatomic_ops/alerts)

[![Hits-of-Code](https://hitsofcode.com/github/ivmai/libatomic_ops?branch=master)](https://hitsofcode.com/github/ivmai/libatomic_ops/view)
[![Lines of code](https://img.shields.io/tokei/lines/github/ivmai/libatomic_ops)](https://shields.io/category/size)
[![GitHub code size in bytes](https://img.shields.io/github/languages/code-size/ivmai/libatomic_ops)](https://shields.io/category/size)
[![Github All Releases](https://img.shields.io/github/downloads/ivmai/libatomic_ops/total.svg)](https://shields.io/category/downloads)
[![Packaging status](https://repology.org/badge/tiny-repos/libatomic-ops.svg)](https://repology.org/project/libatomic-ops/versions)

This is version 7.7.0 (next release development) of libatomic_ops.

License: [MIT](LICENSE) for core library / [GPL-2.0](COPYING) for gpl
extension.


## Download

You might find a more recent/stable version on the
[Download](https://github.com/ivmai/libatomic_ops/wiki/Download) page, or
[BDWGC site](http://www.hboehm.info/gc/).

Also, the latest bug fixes and new features are available in the
[development repository](https://github.com/ivmai/libatomic_ops).


## Overview

This package provides semi-portable access to hardware-provided
atomic memory update operations on a number of architectures.  These might
allow you to write code:

* That does more interesting things in signal handlers.

* Makes more effective use of multiprocessors by allowing you to write
  clever lock-free code.  Note that such code is very difficult to get
  right, and will unavoidably be less portable than lock-based code.  It
  is also not always faster than lock-based code.  But it may occasionally
  be a large performance win.

* To experiment with new and much better thread programming paradigms, etc.

Please see other README files for the details:

* [README_details.txt](README_details.txt) - details about atomic_ops.h

* [README_malloc.txt](README_malloc.txt) - a simple almost-lock-free malloc
  implementation (part of libatomic_ops_gpl)

* [README_stack.txt](README_stack.txt) -  an almost lock-free LIFO linked
  lists (stack) implementation (part of libatomic_ops_gpl)


## Installation and Usage

The configuration and build scripts for this package were generated by
Automake/Autoconf.  `./configure; make; sudo make install` in this
directory should work.  For a more customized build, see the output of
`./configure --help`.  To build it from the development repository,
`./autogen.sh` should be executed first.

Alternatively, CMake could be use to build this package, e.g.
`cmake . && cmake --build .` in this directory should work.

Note that much of the content of this library is in the header files.
However, two small libraries are built and installed:

* `libatomic_ops.a` is a support (core) library, which is not needed on some
  platforms. This is intended to be usable, under some mild restrictions,
  in free or proprietary code, as are all the header files.
  See [LICENSE](LICENSE) for more details about the licensing.

* `libatomic_ops_gpl.a` is a so called gpl extension library containing some
  higher level facilities.  This code is covered by the GPL.  The contents
  correspond to the headers `atomic_ops_malloc.h` and `atomic_ops_stack.h`.
  Not built and not installed if `--disable-gpl` option is passed to
  `configure` (or if `-Denable_gpl=OFF` option is passed to `cmake` if the
  latter is used to build the package).  The licensing details are given in
  [COPYING](COPYING) and [LICENSE](LICENSE) files.


## Platform Specific Notes

Win32/64: src/Makefile.msft contains a very simple Makefile for building
and running tests and building the gpl library.  The core `libatomic_ops`
implementation is entirely in header files (libatomic_ops.lib is built anyway
to match that of the configure-based build process, but libatomic_ops.lib has
only the implementation of the internal AO_pause() used by the gpl library).
More information is provided in [README_win32.txt](README_win32.txt) file.

HP-UX/PA-RISC: `aCC -Ae` won't work as a C compiler, since it doesn't support
inline assembly code.  Use cc.


## Feedback, Contribution, Questions and Notifications

Please address bug reports and new feature ideas to
[GitHub issues](https://github.com/ivmai/libatomic_ops/issues).  Before the
submission please check that it has not been done yet by someone else.

If you want to contribute, submit
a [pull request](https://github.com/ivmai/libatomic_ops/pulls) to GitHub.

If you need help, use
[Stack Overflow](https://stackoverflow.com/questions/tagged/atomic-ops).
Older questions on the site can be found by
[this query](https://stackoverflow.com/search?q=atomic_ops).
Older technical discussions are also available in `bdwgc` mailing list
archive - it can be downloaded as a
[compressed file](https://github.com/ivmai/bdwgc/files/1038163/bdwgc-mailing-list-archive-2017_04.tar.gz)
or browsed at [Narkive](http://bdwgc.opendylan.narkive.com) (please search
for _atomic_ keyword).

To get new release announcements, subscribe to
[RSS feed](https://github.com/ivmai/libatomic_ops/releases.atom).
(To receive the notifications by email, a 3rd-party free service like
[IFTTT RSS Feed](https://ifttt.com/feed) can be setup.)
To be notified on all issues, please
[watch](https://github.com/ivmai/libatomic_ops/watchers) the project on
GitHub.


## Copyright & Warranty, Contributors

Please be aware of the dual nature of the license of libatomic_ops:

* the core part (implementing semi-portable access to hardware-provided
  atomic memory operations) is released under MIT license

* the gpl extension (almost lock-free malloc and stack implementations) and
  the tests are released under GPL-2.0 license

The exact licensing information is provided in [LICENSE](LICENSE) file.

The library contributors are listed in [AUTHORS](AUTHORS) file.
