//! # Cargo Extras
//!
//! I wrote this example while following along with the
//! rust book from this chapter - [https://doc.rust-lang.org/book/ch14-02-publishing-to-crates-io.html#commenting-contained-items](Comenting Contained Items)
//!
//! `cargo_extras` is a collection of utilities to make
//! calculations more convenient.
//!
//! There is also now an example about art and pub mod
//!

pub use self::kinds::PrimaryColor;
pub use self::kinds::SecondaryColor;
pub use self::utils::mix;

pub mod kinds {
    pub enum PrimaryColor {
        Red,
        Yellow,
        Blue,
    }

    pub enum SecondaryColor {
        Orange,
        Green,
        Purple,
    }
}

pub mod utils {
    use crate::kinds::*;

    pub fn mix(c1: PrimaryColor, c2: PrimaryColor) -> SecondaryColor {
        unimplemented!("Mix da collahs")
    }
}

/// Adds one to the number given.
///
/// # Examples
///
/// ```
/// let arg = 5;
/// let answer = cargo_extras::add_one(arg);
///
/// assert_eq!(answer, 6);
/// ```
pub fn add_one(x: i32) -> i32 {
    x + 11
}

#[cfg(test)]
mod tests {
    // use crate::add_one;
    #[test]
    fn it_works() {
        // let result = 2 + 2;
        // assert_eq!(result, 4);

        // let arg = 5;
        // let answer = add_one(arg);

        // assert_eq!(answer, 6);
    }
}
