/* automatically generated by rust-bindgen 0.59.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const BPF_LD: u32 = 0;
pub const BPF_LDX: u32 = 1;
pub const BPF_ST: u32 = 2;
pub const BPF_STX: u32 = 3;
pub const BPF_ALU: u32 = 4;
pub const BPF_JMP: u32 = 5;
pub const BPF_RET: u32 = 6;
pub const BPF_MISC: u32 = 7;
pub const BPF_W: u32 = 0;
pub const BPF_H: u32 = 8;
pub const BPF_B: u32 = 16;
pub const BPF_IMM: u32 = 0;
pub const BPF_ABS: u32 = 32;
pub const BPF_IND: u32 = 64;
pub const BPF_MEM: u32 = 96;
pub const BPF_LEN: u32 = 128;
pub const BPF_MSH: u32 = 160;
pub const BPF_ADD: u32 = 0;
pub const BPF_SUB: u32 = 16;
pub const BPF_MUL: u32 = 32;
pub const BPF_DIV: u32 = 48;
pub const BPF_OR: u32 = 64;
pub const BPF_AND: u32 = 80;
pub const BPF_LSH: u32 = 96;
pub const BPF_RSH: u32 = 112;
pub const BPF_NEG: u32 = 128;
pub const BPF_MOD: u32 = 144;
pub const BPF_XOR: u32 = 160;
pub const BPF_JA: u32 = 0;
pub const BPF_JEQ: u32 = 16;
pub const BPF_JGT: u32 = 32;
pub const BPF_JGE: u32 = 48;
pub const BPF_JSET: u32 = 64;
pub const BPF_K: u32 = 0;
pub const BPF_X: u32 = 8;
pub const BPF_MAXINSNS: u32 = 4096;
pub const BPF_ALU64: u32 = 7;
pub const BPF_DW: u32 = 24;
pub const BPF_XADD: u32 = 192;
pub const BPF_MOV: u32 = 176;
pub const BPF_ARSH: u32 = 192;
pub const BPF_END: u32 = 208;
pub const BPF_TO_LE: u32 = 0;
pub const BPF_TO_BE: u32 = 8;
pub const BPF_FROM_LE: u32 = 0;
pub const BPF_FROM_BE: u32 = 8;
pub const BPF_JNE: u32 = 80;
pub const BPF_JSGT: u32 = 96;
pub const BPF_JSGE: u32 = 112;
pub const BPF_CALL: u32 = 128;
pub const BPF_EXIT: u32 = 144;
pub const BPF_PSEUDO_MAP_FD: u32 = 1;
pub const BPF_ANY: u32 = 0;
pub const BPF_NOEXIST: u32 = 1;
pub const BPF_EXIST: u32 = 2;
pub const BPF_F_NO_PREALLOC: u32 = 1;
pub const BPF_F_RECOMPUTE_CSUM: u32 = 1;
pub const BPF_F_INVALIDATE_HASH: u32 = 2;
pub const BPF_F_HDR_FIELD_MASK: u32 = 15;
pub const BPF_F_PSEUDO_HDR: u32 = 16;
pub const BPF_F_MARK_MANGLED_0: u32 = 32;
pub const BPF_F_INGRESS: u32 = 1;
pub const BPF_F_TUNINFO_IPV6: u32 = 1;
pub const BPF_F_SKIP_FIELD_MASK: u32 = 255;
pub const BPF_F_USER_STACK: u32 = 256;
pub const BPF_F_FAST_STACK_CMP: u32 = 512;
pub const BPF_F_REUSE_STACKID: u32 = 1024;
pub const BPF_F_ZERO_CSUM_TX: u32 = 2;
pub const BPF_F_DONT_FRAGMENT: u32 = 4;
pub const BPF_F_INDEX_MASK: u32 = 4294967295;
pub const BPF_F_CURRENT_CPU: u32 = 4294967295;
pub const BPF_F_CTXLEN_MASK: u64 = 4503595332403200;
pub const LOG_BUF_SIZE: u32 = 65536;
pub const BPF_FN_PREFIX: &'static [u8; 9usize] = b".bpf.fn.\0";
pub const STT_GNU_IFUNC: u32 = 10;
pub type __pid_t = ::std::os::raw::c_int;
pub type pid_t = __pid_t;
extern "C" {
    pub fn bpf_module_create_b(
        filename: *const ::std::os::raw::c_char,
        proto_filename: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_uint,
        dev_name: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn bpf_module_create_c(
        filename: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_uint,
        cflags: *mut *const ::std::os::raw::c_char,
        ncflags: ::std::os::raw::c_int,
        allow_rlimit: bool,
        dev_name: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn bpf_module_create_c_from_string(
        text: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_uint,
        cflags: *mut *const ::std::os::raw::c_char,
        ncflags: ::std::os::raw::c_int,
        allow_rlimit: bool,
        dev_name: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn bpf_module_destroy(program: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn bpf_module_license(program: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_module_kern_version(program: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn bpf_num_functions(program: *mut ::std::os::raw::c_void) -> usize;
}
extern "C" {
    pub fn bpf_function_name(
        program: *mut ::std::os::raw::c_void,
        id: usize,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_function_start_id(
        program: *mut ::std::os::raw::c_void,
        id: usize,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn bpf_function_start(
        program: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn bpf_function_size_id(program: *mut ::std::os::raw::c_void, id: usize) -> usize;
}
extern "C" {
    pub fn bpf_function_size(
        program: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
    ) -> usize;
}
extern "C" {
    pub fn bpf_num_tables(program: *mut ::std::os::raw::c_void) -> usize;
}
extern "C" {
    pub fn bpf_table_id(
        program: *mut ::std::os::raw::c_void,
        table_name: *const ::std::os::raw::c_char,
    ) -> usize;
}
extern "C" {
    pub fn bpf_table_fd(
        program: *mut ::std::os::raw::c_void,
        table_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_table_fd_id(
        program: *mut ::std::os::raw::c_void,
        id: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_table_type(
        program: *mut ::std::os::raw::c_void,
        table_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_table_type_id(
        program: *mut ::std::os::raw::c_void,
        id: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_table_max_entries(
        program: *mut ::std::os::raw::c_void,
        table_name: *const ::std::os::raw::c_char,
    ) -> usize;
}
extern "C" {
    pub fn bpf_table_max_entries_id(program: *mut ::std::os::raw::c_void, id: usize) -> usize;
}
extern "C" {
    pub fn bpf_table_flags(
        program: *mut ::std::os::raw::c_void,
        table_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_table_flags_id(
        program: *mut ::std::os::raw::c_void,
        id: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_table_name(
        program: *mut ::std::os::raw::c_void,
        id: usize,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_table_key_desc(
        program: *mut ::std::os::raw::c_void,
        table_name: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_table_key_desc_id(
        program: *mut ::std::os::raw::c_void,
        id: usize,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_table_leaf_desc(
        program: *mut ::std::os::raw::c_void,
        table_name: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_table_leaf_desc_id(
        program: *mut ::std::os::raw::c_void,
        id: usize,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_table_key_size(
        program: *mut ::std::os::raw::c_void,
        table_name: *const ::std::os::raw::c_char,
    ) -> usize;
}
extern "C" {
    pub fn bpf_table_key_size_id(program: *mut ::std::os::raw::c_void, id: usize) -> usize;
}
extern "C" {
    pub fn bpf_table_leaf_size(
        program: *mut ::std::os::raw::c_void,
        table_name: *const ::std::os::raw::c_char,
    ) -> usize;
}
extern "C" {
    pub fn bpf_table_leaf_size_id(program: *mut ::std::os::raw::c_void, id: usize) -> usize;
}
extern "C" {
    pub fn bpf_table_key_snprintf(
        program: *mut ::std::os::raw::c_void,
        id: usize,
        buf: *mut ::std::os::raw::c_char,
        buflen: usize,
        key: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_table_leaf_snprintf(
        program: *mut ::std::os::raw::c_void,
        id: usize,
        buf: *mut ::std::os::raw::c_char,
        buflen: usize,
        leaf: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_table_key_sscanf(
        program: *mut ::std::os::raw::c_void,
        id: usize,
        buf: *const ::std::os::raw::c_char,
        key: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_table_leaf_sscanf(
        program: *mut ::std::os::raw::c_void,
        id: usize,
        buf: *const ::std::os::raw::c_char,
        leaf: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_perf_event_fields(
        program: *mut ::std::os::raw::c_void,
        event: *const ::std::os::raw::c_char,
    ) -> usize;
}
extern "C" {
    pub fn bpf_perf_event_field(
        program: *mut ::std::os::raw::c_void,
        event: *const ::std::os::raw::c_char,
        i: usize,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcc_func_load(
        program: *mut ::std::os::raw::c_void,
        prog_type: ::std::os::raw::c_int,
        name: *const ::std::os::raw::c_char,
        insns: *const bpf_insn,
        prog_len: ::std::os::raw::c_int,
        license: *const ::std::os::raw::c_char,
        kern_version: ::std::os::raw::c_uint,
        log_level: ::std::os::raw::c_int,
        log_buf: *mut ::std::os::raw::c_char,
        log_buf_size: ::std::os::raw::c_uint,
        dev_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
pub type __u8 = ::std::os::raw::c_uchar;
pub type __s16 = ::std::os::raw::c_short;
pub type __u16 = ::std::os::raw::c_ushort;
pub type __s32 = ::std::os::raw::c_int;
pub type __u32 = ::std::os::raw::c_uint;
pub type __u64 = ::std::os::raw::c_ulonglong;
pub const BPF_REG_0: ::std::os::raw::c_uint = 0;
pub const BPF_REG_1: ::std::os::raw::c_uint = 1;
pub const BPF_REG_2: ::std::os::raw::c_uint = 2;
pub const BPF_REG_3: ::std::os::raw::c_uint = 3;
pub const BPF_REG_4: ::std::os::raw::c_uint = 4;
pub const BPF_REG_5: ::std::os::raw::c_uint = 5;
pub const BPF_REG_6: ::std::os::raw::c_uint = 6;
pub const BPF_REG_7: ::std::os::raw::c_uint = 7;
pub const BPF_REG_8: ::std::os::raw::c_uint = 8;
pub const BPF_REG_9: ::std::os::raw::c_uint = 9;
pub const BPF_REG_10: ::std::os::raw::c_uint = 10;
pub const __MAX_BPF_REG: ::std::os::raw::c_uint = 11;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct bpf_insn {
    pub code: __u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub off: __s16,
    pub imm: __s32,
}
#[test]
fn bindgen_test_layout_bpf_insn() {
    assert_eq!(
        ::std::mem::size_of::<bpf_insn>(),
        8usize,
        concat!("Size of: ", stringify!(bpf_insn))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_insn>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_insn))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_insn>())).code as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_insn),
            "::",
            stringify!(code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_insn>())).off as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_insn),
            "::",
            stringify!(off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_insn>())).imm as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_insn),
            "::",
            stringify!(imm)
        )
    );
}
impl bpf_insn {
    #[inline]
    pub fn dst_reg(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_dst_reg(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn src_reg(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_src_reg(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(dst_reg: __u8, src_reg: __u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let dst_reg: u8 = unsafe { ::std::mem::transmute(dst_reg) };
            dst_reg as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let src_reg: u8 = unsafe { ::std::mem::transmute(src_reg) };
            src_reg as u64
        });
        __bindgen_bitfield_unit
    }
}
pub const bpf_cmd_BPF_MAP_CREATE: bpf_cmd = 0;
pub const bpf_cmd_BPF_MAP_LOOKUP_ELEM: bpf_cmd = 1;
pub const bpf_cmd_BPF_MAP_UPDATE_ELEM: bpf_cmd = 2;
pub const bpf_cmd_BPF_MAP_DELETE_ELEM: bpf_cmd = 3;
pub const bpf_cmd_BPF_MAP_GET_NEXT_KEY: bpf_cmd = 4;
pub const bpf_cmd_BPF_PROG_LOAD: bpf_cmd = 5;
pub const bpf_cmd_BPF_OBJ_PIN: bpf_cmd = 6;
pub const bpf_cmd_BPF_OBJ_GET: bpf_cmd = 7;
pub type bpf_cmd = ::std::os::raw::c_uint;
pub const bpf_map_type_BPF_MAP_TYPE_UNSPEC: bpf_map_type = 0;
pub const bpf_map_type_BPF_MAP_TYPE_HASH: bpf_map_type = 1;
pub const bpf_map_type_BPF_MAP_TYPE_ARRAY: bpf_map_type = 2;
pub const bpf_map_type_BPF_MAP_TYPE_PROG_ARRAY: bpf_map_type = 3;
pub const bpf_map_type_BPF_MAP_TYPE_PERF_EVENT_ARRAY: bpf_map_type = 4;
pub const bpf_map_type_BPF_MAP_TYPE_PERCPU_HASH: bpf_map_type = 5;
pub const bpf_map_type_BPF_MAP_TYPE_PERCPU_ARRAY: bpf_map_type = 6;
pub const bpf_map_type_BPF_MAP_TYPE_STACK_TRACE: bpf_map_type = 7;
pub const bpf_map_type_BPF_MAP_TYPE_CGROUP_ARRAY: bpf_map_type = 8;
pub type bpf_map_type = ::std::os::raw::c_uint;
pub const bpf_prog_type_BPF_PROG_TYPE_UNSPEC: bpf_prog_type = 0;
pub const bpf_prog_type_BPF_PROG_TYPE_SOCKET_FILTER: bpf_prog_type = 1;
pub const bpf_prog_type_BPF_PROG_TYPE_KPROBE: bpf_prog_type = 2;
pub const bpf_prog_type_BPF_PROG_TYPE_SCHED_CLS: bpf_prog_type = 3;
pub const bpf_prog_type_BPF_PROG_TYPE_SCHED_ACT: bpf_prog_type = 4;
pub const bpf_prog_type_BPF_PROG_TYPE_TRACEPOINT: bpf_prog_type = 5;
pub const bpf_prog_type_BPF_PROG_TYPE_XDP: bpf_prog_type = 6;
pub const bpf_prog_type_BPF_PROG_TYPE_PERF_EVENT: bpf_prog_type = 7;
pub type bpf_prog_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_attr {
    pub __bindgen_anon_1: bpf_attr__bindgen_ty_1,
    pub __bindgen_anon_2: bpf_attr__bindgen_ty_2,
    pub __bindgen_anon_3: bpf_attr__bindgen_ty_3,
    pub __bindgen_anon_4: bpf_attr__bindgen_ty_4,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct bpf_attr__bindgen_ty_1 {
    pub map_type: __u32,
    pub key_size: __u32,
    pub value_size: __u32,
    pub max_entries: __u32,
    pub map_flags: __u32,
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_1>(),
        20usize,
        concat!("Size of: ", stringify!(bpf_attr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_attr__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).map_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(map_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).key_size as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(key_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).value_size as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(value_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).max_entries as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(max_entries)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).map_flags as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(map_flags)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_attr__bindgen_ty_2 {
    pub map_fd: __u32,
    pub key: __u64,
    pub __bindgen_anon_1: bpf_attr__bindgen_ty_2__bindgen_ty_1,
    pub flags: __u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_attr__bindgen_ty_2__bindgen_ty_1 {
    pub value: __u64,
    pub next_key: __u64,
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(bpf_attr__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(bpf_attr__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_2__bindgen_ty_1>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_2__bindgen_ty_1>())).next_key as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(next_key)
        )
    );
}
impl Default for bpf_attr__bindgen_ty_2__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for bpf_attr__bindgen_ty_2__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "bpf_attr__bindgen_ty_2__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_2>(),
        32usize,
        concat!("Size of: ", stringify!(bpf_attr__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_attr__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_2>())).map_fd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_2),
            "::",
            stringify!(map_fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_2>())).key as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_2),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_2>())).flags as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_2),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for bpf_attr__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for bpf_attr__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "bpf_attr__bindgen_ty_2 {{ map_fd: {:?}, key: {:?}, __bindgen_anon_1: {:?}, flags: {:?} }}" , self . map_fd , self . key , self . __bindgen_anon_1 , self . flags)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct bpf_attr__bindgen_ty_3 {
    pub prog_type: __u32,
    pub insn_cnt: __u32,
    pub insns: __u64,
    pub license: __u64,
    pub log_level: __u32,
    pub log_size: __u32,
    pub log_buf: __u64,
    pub kern_version: __u32,
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_3>(),
        48usize,
        concat!("Size of: ", stringify!(bpf_attr__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_3>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_attr__bindgen_ty_3))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).prog_type as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(prog_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).insn_cnt as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(insn_cnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).insns as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(insns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).license as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(license)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).log_level as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(log_level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).log_size as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(log_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).log_buf as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(log_buf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).kern_version as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(kern_version)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct bpf_attr__bindgen_ty_4 {
    pub pathname: __u64,
    pub bpf_fd: __u32,
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_4>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_attr__bindgen_ty_4))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_4>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_attr__bindgen_ty_4))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_4>())).pathname as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_4),
            "::",
            stringify!(pathname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_4>())).bpf_fd as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_4),
            "::",
            stringify!(bpf_fd)
        )
    );
}
#[test]
fn bindgen_test_layout_bpf_attr() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr>(),
        48usize,
        concat!("Size of: ", stringify!(bpf_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_attr))
    );
}
impl Default for bpf_attr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for bpf_attr {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "bpf_attr {{ union }}")
    }
}
pub const bpf_func_id_BPF_FUNC_unspec: bpf_func_id = 0;
pub const bpf_func_id_BPF_FUNC_map_lookup_elem: bpf_func_id = 1;
pub const bpf_func_id_BPF_FUNC_map_update_elem: bpf_func_id = 2;
pub const bpf_func_id_BPF_FUNC_map_delete_elem: bpf_func_id = 3;
pub const bpf_func_id_BPF_FUNC_probe_read: bpf_func_id = 4;
pub const bpf_func_id_BPF_FUNC_ktime_get_ns: bpf_func_id = 5;
pub const bpf_func_id_BPF_FUNC_trace_printk: bpf_func_id = 6;
pub const bpf_func_id_BPF_FUNC_get_prandom_u32: bpf_func_id = 7;
pub const bpf_func_id_BPF_FUNC_get_smp_processor_id: bpf_func_id = 8;
pub const bpf_func_id_BPF_FUNC_skb_store_bytes: bpf_func_id = 9;
pub const bpf_func_id_BPF_FUNC_l3_csum_replace: bpf_func_id = 10;
pub const bpf_func_id_BPF_FUNC_l4_csum_replace: bpf_func_id = 11;
pub const bpf_func_id_BPF_FUNC_tail_call: bpf_func_id = 12;
pub const bpf_func_id_BPF_FUNC_clone_redirect: bpf_func_id = 13;
pub const bpf_func_id_BPF_FUNC_get_current_pid_tgid: bpf_func_id = 14;
pub const bpf_func_id_BPF_FUNC_get_current_uid_gid: bpf_func_id = 15;
pub const bpf_func_id_BPF_FUNC_get_current_comm: bpf_func_id = 16;
pub const bpf_func_id_BPF_FUNC_get_cgroup_classid: bpf_func_id = 17;
pub const bpf_func_id_BPF_FUNC_skb_vlan_push: bpf_func_id = 18;
pub const bpf_func_id_BPF_FUNC_skb_vlan_pop: bpf_func_id = 19;
pub const bpf_func_id_BPF_FUNC_skb_get_tunnel_key: bpf_func_id = 20;
pub const bpf_func_id_BPF_FUNC_skb_set_tunnel_key: bpf_func_id = 21;
pub const bpf_func_id_BPF_FUNC_perf_event_read: bpf_func_id = 22;
pub const bpf_func_id_BPF_FUNC_redirect: bpf_func_id = 23;
pub const bpf_func_id_BPF_FUNC_get_route_realm: bpf_func_id = 24;
pub const bpf_func_id_BPF_FUNC_perf_event_output: bpf_func_id = 25;
pub const bpf_func_id_BPF_FUNC_skb_load_bytes: bpf_func_id = 26;
pub const bpf_func_id_BPF_FUNC_get_stackid: bpf_func_id = 27;
pub const bpf_func_id_BPF_FUNC_csum_diff: bpf_func_id = 28;
pub const bpf_func_id_BPF_FUNC_skb_get_tunnel_opt: bpf_func_id = 29;
pub const bpf_func_id_BPF_FUNC_skb_set_tunnel_opt: bpf_func_id = 30;
pub const bpf_func_id_BPF_FUNC_skb_change_proto: bpf_func_id = 31;
pub const bpf_func_id_BPF_FUNC_skb_change_type: bpf_func_id = 32;
pub const bpf_func_id_BPF_FUNC_skb_under_cgroup: bpf_func_id = 33;
pub const bpf_func_id_BPF_FUNC_get_hash_recalc: bpf_func_id = 34;
pub const bpf_func_id_BPF_FUNC_get_current_task: bpf_func_id = 35;
pub const bpf_func_id_BPF_FUNC_probe_write_user: bpf_func_id = 36;
pub const bpf_func_id_BPF_FUNC_current_task_under_cgroup: bpf_func_id = 37;
pub const bpf_func_id_BPF_FUNC_skb_change_tail: bpf_func_id = 38;
pub const bpf_func_id_BPF_FUNC_skb_pull_data: bpf_func_id = 39;
pub const bpf_func_id_BPF_FUNC_csum_update: bpf_func_id = 40;
pub const bpf_func_id_BPF_FUNC_set_hash_invalid: bpf_func_id = 41;
pub const bpf_func_id___BPF_FUNC_MAX_ID: bpf_func_id = 42;
pub type bpf_func_id = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct __sk_buff {
    pub len: __u32,
    pub pkt_type: __u32,
    pub mark: __u32,
    pub queue_mapping: __u32,
    pub protocol: __u32,
    pub vlan_present: __u32,
    pub vlan_tci: __u32,
    pub vlan_proto: __u32,
    pub priority: __u32,
    pub ingress_ifindex: __u32,
    pub ifindex: __u32,
    pub tc_index: __u32,
    pub cb: [__u32; 5usize],
    pub hash: __u32,
    pub tc_classid: __u32,
    pub data: __u32,
    pub data_end: __u32,
}
#[test]
fn bindgen_test_layout___sk_buff() {
    assert_eq!(
        ::std::mem::size_of::<__sk_buff>(),
        84usize,
        concat!("Size of: ", stringify!(__sk_buff))
    );
    assert_eq!(
        ::std::mem::align_of::<__sk_buff>(),
        4usize,
        concat!("Alignment of ", stringify!(__sk_buff))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).len as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).pkt_type as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(pkt_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).mark as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(mark)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).queue_mapping as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(queue_mapping)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).protocol as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(protocol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).vlan_present as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(vlan_present)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).vlan_tci as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(vlan_tci)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).vlan_proto as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(vlan_proto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).priority as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(priority)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).ingress_ifindex as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(ingress_ifindex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).ifindex as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(ifindex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).tc_index as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(tc_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).cb as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).hash as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).tc_classid as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(tc_classid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).data as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).data_end as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(data_end)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_tunnel_key {
    pub tunnel_id: __u32,
    pub __bindgen_anon_1: bpf_tunnel_key__bindgen_ty_1,
    pub tunnel_tos: __u8,
    pub tunnel_ttl: __u8,
    pub tunnel_ext: __u16,
    pub tunnel_label: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_tunnel_key__bindgen_ty_1 {
    pub remote_ipv4: __u32,
    pub remote_ipv6: [__u32; 4usize],
}
#[test]
fn bindgen_test_layout_bpf_tunnel_key__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_tunnel_key__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_tunnel_key__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_tunnel_key__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_tunnel_key__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_tunnel_key__bindgen_ty_1>())).remote_ipv4 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tunnel_key__bindgen_ty_1),
            "::",
            stringify!(remote_ipv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_tunnel_key__bindgen_ty_1>())).remote_ipv6 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tunnel_key__bindgen_ty_1),
            "::",
            stringify!(remote_ipv6)
        )
    );
}
impl Default for bpf_tunnel_key__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for bpf_tunnel_key__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "bpf_tunnel_key__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_bpf_tunnel_key() {
    assert_eq!(
        ::std::mem::size_of::<bpf_tunnel_key>(),
        28usize,
        concat!("Size of: ", stringify!(bpf_tunnel_key))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_tunnel_key>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_tunnel_key))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tunnel_key>())).tunnel_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tunnel_key),
            "::",
            stringify!(tunnel_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tunnel_key>())).tunnel_tos as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tunnel_key),
            "::",
            stringify!(tunnel_tos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tunnel_key>())).tunnel_ttl as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tunnel_key),
            "::",
            stringify!(tunnel_ttl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tunnel_key>())).tunnel_ext as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tunnel_key),
            "::",
            stringify!(tunnel_ext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tunnel_key>())).tunnel_label as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tunnel_key),
            "::",
            stringify!(tunnel_label)
        )
    );
}
impl Default for bpf_tunnel_key {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for bpf_tunnel_key {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "bpf_tunnel_key {{ tunnel_id: {:?}, __bindgen_anon_1: {:?}, tunnel_tos: {:?}, tunnel_ttl: {:?}, tunnel_ext: {:?}, tunnel_label: {:?} }}" , self . tunnel_id , self . __bindgen_anon_1 , self . tunnel_tos , self . tunnel_ttl , self . tunnel_ext , self . tunnel_label)
    }
}
pub const xdp_action_XDP_ABORTED: xdp_action = 0;
pub const xdp_action_XDP_DROP: xdp_action = 1;
pub const xdp_action_XDP_PASS: xdp_action = 2;
pub const xdp_action_XDP_TX: xdp_action = 3;
pub type xdp_action = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct xdp_md {
    pub data: __u32,
    pub data_end: __u32,
}
#[test]
fn bindgen_test_layout_xdp_md() {
    assert_eq!(
        ::std::mem::size_of::<xdp_md>(),
        8usize,
        concat!("Size of: ", stringify!(xdp_md))
    );
    assert_eq!(
        ::std::mem::align_of::<xdp_md>(),
        4usize,
        concat!("Alignment of ", stringify!(xdp_md))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xdp_md>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xdp_md),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xdp_md>())).data_end as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xdp_md),
            "::",
            stringify!(data_end)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_create_map_attr {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_load_program_attr {
    _unused: [u8; 0],
}
pub const bpf_probe_attach_type_BPF_PROBE_ENTRY: bpf_probe_attach_type = 0;
pub const bpf_probe_attach_type_BPF_PROBE_RETURN: bpf_probe_attach_type = 1;
pub type bpf_probe_attach_type = ::std::os::raw::c_uint;
extern "C" {
    pub fn bcc_create_map(
        map_type: bpf_map_type,
        name: *const ::std::os::raw::c_char,
        key_size: ::std::os::raw::c_int,
        value_size: ::std::os::raw::c_int,
        max_entries: ::std::os::raw::c_int,
        map_flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_create_map_xattr(
        attr: *mut bpf_create_map_attr,
        allow_rlimit: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_update_elem(
        fd: ::std::os::raw::c_int,
        key: *mut ::std::os::raw::c_void,
        value: *mut ::std::os::raw::c_void,
        flags: ::std::os::raw::c_ulonglong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_lookup_elem(
        fd: ::std::os::raw::c_int,
        key: *mut ::std::os::raw::c_void,
        value: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_delete_elem(
        fd: ::std::os::raw::c_int,
        key: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_get_first_key(
        fd: ::std::os::raw::c_int,
        key: *mut ::std::os::raw::c_void,
        key_size: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_get_next_key(
        fd: ::std::os::raw::c_int,
        key: *mut ::std::os::raw::c_void,
        next_key: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_lookup_and_delete(
        fd: ::std::os::raw::c_int,
        key: *mut ::std::os::raw::c_void,
        value: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_prog_load(
        prog_type: bpf_prog_type,
        name: *const ::std::os::raw::c_char,
        insns: *const bpf_insn,
        prog_len: ::std::os::raw::c_int,
        license: *const ::std::os::raw::c_char,
        kern_version: ::std::os::raw::c_uint,
        log_level: ::std::os::raw::c_int,
        log_buf: *mut ::std::os::raw::c_char,
        log_buf_size: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_prog_load_xattr(
        attr: *mut bpf_load_program_attr,
        prog_len: ::std::os::raw::c_int,
        log_buf: *mut ::std::os::raw::c_char,
        log_buf_size: ::std::os::raw::c_uint,
        allow_rlimit: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_attach_socket(
        sockfd: ::std::os::raw::c_int,
        progfd: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_open_raw_sock(name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
pub type perf_reader_raw_cb = ::std::option::Option<
    unsafe extern "C" fn(
        cb_cookie: *mut ::std::os::raw::c_void,
        raw: *mut ::std::os::raw::c_void,
        raw_size: ::std::os::raw::c_int,
    ),
>;
pub type perf_reader_lost_cb =
    ::std::option::Option<unsafe extern "C" fn(cb_cookie: *mut ::std::os::raw::c_void, lost: u64)>;
extern "C" {
    pub fn bpf_attach_kprobe(
        progfd: ::std::os::raw::c_int,
        attach_type: bpf_probe_attach_type,
        ev_name: *const ::std::os::raw::c_char,
        fn_name: *const ::std::os::raw::c_char,
        fn_offset: u64,
        maxactive: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_detach_kprobe(ev_name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_attach_uprobe(
        progfd: ::std::os::raw::c_int,
        attach_type: bpf_probe_attach_type,
        ev_name: *const ::std::os::raw::c_char,
        binary_path: *const ::std::os::raw::c_char,
        offset: u64,
        pid: pid_t,
        ref_ctr_offset: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_detach_uprobe(ev_name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_attach_tracepoint(
        progfd: ::std::os::raw::c_int,
        tp_category: *const ::std::os::raw::c_char,
        tp_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_detach_tracepoint(
        tp_category: *const ::std::os::raw::c_char,
        tp_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_attach_raw_tracepoint(
        progfd: ::std::os::raw::c_int,
        tp_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_attach_kfunc(prog_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_attach_lsm(prog_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_has_kernel_btf() -> bool;
}
extern "C" {
    pub fn bpf_open_perf_buffer(
        raw_cb: perf_reader_raw_cb,
        lost_cb: perf_reader_lost_cb,
        cb_cookie: *mut ::std::os::raw::c_void,
        pid: ::std::os::raw::c_int,
        cpu: ::std::os::raw::c_int,
        page_cnt: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn bpf_attach_xdp(
        dev_name: *const ::std::os::raw::c_char,
        progfd: ::std::os::raw::c_int,
        flags: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_attach_perf_event_raw(
        progfd: ::std::os::raw::c_int,
        perf_event_attr: *mut ::std::os::raw::c_void,
        pid: pid_t,
        cpu: ::std::os::raw::c_int,
        group_fd: ::std::os::raw::c_int,
        extra_flags: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_attach_perf_event(
        progfd: ::std::os::raw::c_int,
        ev_type: u32,
        ev_config: u32,
        sample_period: u64,
        sample_freq: u64,
        pid: pid_t,
        cpu: ::std::os::raw::c_int,
        group_fd: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_open_perf_event(
        type_: u32,
        config: u64,
        pid: ::std::os::raw::c_int,
        cpu: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_close_perf_event_fd(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
pub type ring_buffer_sample_fn = ::std::option::Option<
    unsafe extern "C" fn(
        ctx: *mut ::std::os::raw::c_void,
        data: *mut ::std::os::raw::c_void,
        size: usize,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ring_buffer {
    _unused: [u8; 0],
}
extern "C" {
    pub fn bpf_new_ringbuf(
        map_fd: ::std::os::raw::c_int,
        sample_cb: ring_buffer_sample_fn,
        ctx: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn bpf_free_ringbuf(rb: *mut ring_buffer);
}
extern "C" {
    pub fn bpf_add_ringbuf(
        rb: *mut ring_buffer,
        map_fd: ::std::os::raw::c_int,
        sample_cb: ring_buffer_sample_fn,
        ctx: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_poll_ringbuf(
        rb: *mut ring_buffer,
        timeout_ms: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_consume_ringbuf(rb: *mut ring_buffer) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_obj_pin(
        fd: ::std::os::raw::c_int,
        pathname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_obj_get(pathname: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_obj_get_info(
        prog_map_fd: ::std::os::raw::c_int,
        info: *mut ::std::os::raw::c_void,
        info_len: *mut u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_compute_tag(
        insns: *const bpf_insn,
        prog_len: ::std::os::raw::c_int,
        tag: *mut ::std::os::raw::c_ulonglong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_get_tag(
        fd: ::std::os::raw::c_int,
        tag: *mut ::std::os::raw::c_ulonglong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_get_next_id(start_id: u32, next_id: *mut u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_get_fd_by_id(id: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_get_fd_by_id(id: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_obj_get_info_by_fd(
        prog_fd: ::std::os::raw::c_int,
        info: *mut ::std::os::raw::c_void,
        info_len: *mut u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_iter_attach(
        prog_fd: ::std::os::raw::c_int,
        link_info: *mut [u8; 0usize],
        link_info_len: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_iter_create(link_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_make_parent_dir(path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_check_bpffs_path(path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct mod_info {
    pub name: *mut ::std::os::raw::c_char,
    pub start_addr: u64,
    pub end_addr: u64,
    pub file_offset: ::std::os::raw::c_ulonglong,
    pub dev_major: u64,
    pub dev_minor: u64,
    pub inode: u64,
}
#[test]
fn bindgen_test_layout_mod_info() {
    assert_eq!(
        ::std::mem::size_of::<mod_info>(),
        56usize,
        concat!("Size of: ", stringify!(mod_info))
    );
    assert_eq!(
        ::std::mem::align_of::<mod_info>(),
        8usize,
        concat!("Alignment of ", stringify!(mod_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mod_info>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mod_info),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mod_info>())).start_addr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mod_info),
            "::",
            stringify!(start_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mod_info>())).end_addr as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mod_info),
            "::",
            stringify!(end_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mod_info>())).file_offset as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mod_info),
            "::",
            stringify!(file_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mod_info>())).dev_major as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(mod_info),
            "::",
            stringify!(dev_major)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mod_info>())).dev_minor as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(mod_info),
            "::",
            stringify!(dev_minor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mod_info>())).inode as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(mod_info),
            "::",
            stringify!(inode)
        )
    );
}
impl Default for mod_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type bcc_procutils_modulecb = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut mod_info,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub type bcc_procutils_ksymcb = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: u64,
        arg4: *mut ::std::os::raw::c_void,
    ),
>;
extern "C" {
    pub fn bcc_procutils_which_so(
        libname: *const ::std::os::raw::c_char,
        pid: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcc_procutils_which(
        binpath: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcc_mapping_is_file_backed(
        mapname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_procutils_each_module(
        pid: ::std::os::raw::c_int,
        callback: bcc_procutils_modulecb,
        payload: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_procutils_each_ksym(
        callback: bcc_procutils_ksymcb,
        payload: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_procutils_free(ptr: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn bcc_procutils_language(pid: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct bcc_symbol {
    pub name: *const ::std::os::raw::c_char,
    pub demangle_name: *const ::std::os::raw::c_char,
    pub module: *const ::std::os::raw::c_char,
    pub offset: u64,
}
#[test]
fn bindgen_test_layout_bcc_symbol() {
    assert_eq!(
        ::std::mem::size_of::<bcc_symbol>(),
        32usize,
        concat!("Size of: ", stringify!(bcc_symbol))
    );
    assert_eq!(
        ::std::mem::align_of::<bcc_symbol>(),
        8usize,
        concat!("Alignment of ", stringify!(bcc_symbol))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_symbol>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_symbol),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_symbol>())).demangle_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_symbol),
            "::",
            stringify!(demangle_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_symbol>())).module as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_symbol),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_symbol>())).offset as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_symbol),
            "::",
            stringify!(offset)
        )
    );
}
impl Default for bcc_symbol {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SYM_CB = ::std::option::Option<
    unsafe extern "C" fn(
        symname: *const ::std::os::raw::c_char,
        addr: u64,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct bcc_symbol_option {
    pub use_debug_file: ::std::os::raw::c_int,
    pub check_debug_file_crc: ::std::os::raw::c_int,
    pub lazy_symbolize: ::std::os::raw::c_int,
    pub use_symbol_type: u32,
}
#[test]
fn bindgen_test_layout_bcc_symbol_option() {
    assert_eq!(
        ::std::mem::size_of::<bcc_symbol_option>(),
        16usize,
        concat!("Size of: ", stringify!(bcc_symbol_option))
    );
    assert_eq!(
        ::std::mem::align_of::<bcc_symbol_option>(),
        4usize,
        concat!("Alignment of ", stringify!(bcc_symbol_option))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bcc_symbol_option>())).use_debug_file as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_symbol_option),
            "::",
            stringify!(use_debug_file)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bcc_symbol_option>())).check_debug_file_crc as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_symbol_option),
            "::",
            stringify!(check_debug_file_crc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bcc_symbol_option>())).lazy_symbolize as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_symbol_option),
            "::",
            stringify!(lazy_symbolize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bcc_symbol_option>())).use_symbol_type as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_symbol_option),
            "::",
            stringify!(use_symbol_type)
        )
    );
}
extern "C" {
    pub fn bcc_symcache_new(
        pid: ::std::os::raw::c_int,
        option: *mut bcc_symbol_option,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn bcc_free_symcache(symcache: *mut ::std::os::raw::c_void, pid: ::std::os::raw::c_int);
}
extern "C" {
    pub fn bcc_symbol_free_demangle_name(sym: *mut bcc_symbol);
}
extern "C" {
    pub fn bcc_symcache_resolve(
        symcache: *mut ::std::os::raw::c_void,
        addr: u64,
        sym: *mut bcc_symbol,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_symcache_resolve_no_demangle(
        symcache: *mut ::std::os::raw::c_void,
        addr: u64,
        sym: *mut bcc_symbol,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_symcache_resolve_name(
        resolver: *mut ::std::os::raw::c_void,
        module: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        addr: *mut u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_symcache_refresh(resolver: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn bcc_resolve_global_addr(
        pid: ::std::os::raw::c_int,
        module: *const ::std::os::raw::c_char,
        address: u64,
        inode_match_only: u8,
        global: *mut u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_buildsymcache_new() -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn bcc_free_buildsymcache(symcache: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn bcc_buildsymcache_add_module(
        resolver: *mut ::std::os::raw::c_void,
        module_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_buildsymcache_resolve(
        resolver: *mut ::std::os::raw::c_void,
        trace: *mut [u8; 0usize],
        sym: *mut bcc_symbol,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_foreach_function_symbol(
        module: *const ::std::os::raw::c_char,
        cb: SYM_CB,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_resolve_symname(
        module: *const ::std::os::raw::c_char,
        symname: *const ::std::os::raw::c_char,
        addr: u64,
        pid: ::std::os::raw::c_int,
        option: *mut bcc_symbol_option,
        sym: *mut bcc_symbol,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct perf_reader {
    _unused: [u8; 0],
}
extern "C" {
    pub fn perf_reader_new(
        raw_cb: perf_reader_raw_cb,
        lost_cb: perf_reader_lost_cb,
        cb_cookie: *mut ::std::os::raw::c_void,
        page_cnt: ::std::os::raw::c_int,
    ) -> *mut perf_reader;
}
extern "C" {
    pub fn perf_reader_free(ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn perf_reader_mmap(reader: *mut perf_reader) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perf_reader_event_read(reader: *mut perf_reader);
}
extern "C" {
    pub fn perf_reader_poll(
        num_readers: ::std::os::raw::c_int,
        readers: *mut *mut perf_reader,
        timeout: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perf_reader_fd(reader: *mut perf_reader) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perf_reader_set_fd(reader: *mut perf_reader, fd: ::std::os::raw::c_int);
}
extern "C" {
    pub fn bcc_usdt_new_frompid(
        pid: ::std::os::raw::c_int,
        path: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn bcc_usdt_new_frompath(
        path: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn bcc_usdt_close(usdt: *mut ::std::os::raw::c_void);
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct bcc_usdt {
    pub provider: *const ::std::os::raw::c_char,
    pub name: *const ::std::os::raw::c_char,
    pub bin_path: *const ::std::os::raw::c_char,
    pub semaphore: u64,
    pub num_locations: ::std::os::raw::c_int,
    pub num_arguments: ::std::os::raw::c_int,
    pub semaphore_offset: u64,
}
#[test]
fn bindgen_test_layout_bcc_usdt() {
    assert_eq!(
        ::std::mem::size_of::<bcc_usdt>(),
        48usize,
        concat!("Size of: ", stringify!(bcc_usdt))
    );
    assert_eq!(
        ::std::mem::align_of::<bcc_usdt>(),
        8usize,
        concat!("Alignment of ", stringify!(bcc_usdt))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_usdt>())).provider as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt),
            "::",
            stringify!(provider)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_usdt>())).name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_usdt>())).bin_path as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt),
            "::",
            stringify!(bin_path)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_usdt>())).semaphore as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt),
            "::",
            stringify!(semaphore)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_usdt>())).num_locations as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt),
            "::",
            stringify!(num_locations)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_usdt>())).num_arguments as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt),
            "::",
            stringify!(num_arguments)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_usdt>())).semaphore_offset as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt),
            "::",
            stringify!(semaphore_offset)
        )
    );
}
impl Default for bcc_usdt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct bcc_usdt_location {
    pub address: u64,
    pub bin_path: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_bcc_usdt_location() {
    assert_eq!(
        ::std::mem::size_of::<bcc_usdt_location>(),
        16usize,
        concat!("Size of: ", stringify!(bcc_usdt_location))
    );
    assert_eq!(
        ::std::mem::align_of::<bcc_usdt_location>(),
        8usize,
        concat!("Alignment of ", stringify!(bcc_usdt_location))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_usdt_location>())).address as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt_location),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_usdt_location>())).bin_path as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt_location),
            "::",
            stringify!(bin_path)
        )
    );
}
impl Default for bcc_usdt_location {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct bcc_usdt_argument {
    pub size: ::std::os::raw::c_int,
    pub valid: ::std::os::raw::c_int,
    pub constant: ::std::os::raw::c_longlong,
    pub deref_offset: ::std::os::raw::c_int,
    pub deref_ident: *const ::std::os::raw::c_char,
    pub base_register_name: *const ::std::os::raw::c_char,
    pub index_register_name: *const ::std::os::raw::c_char,
    pub scale: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bcc_usdt_argument() {
    assert_eq!(
        ::std::mem::size_of::<bcc_usdt_argument>(),
        56usize,
        concat!("Size of: ", stringify!(bcc_usdt_argument))
    );
    assert_eq!(
        ::std::mem::align_of::<bcc_usdt_argument>(),
        8usize,
        concat!("Alignment of ", stringify!(bcc_usdt_argument))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_usdt_argument>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt_argument),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_usdt_argument>())).valid as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt_argument),
            "::",
            stringify!(valid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_usdt_argument>())).constant as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt_argument),
            "::",
            stringify!(constant)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_usdt_argument>())).deref_offset as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt_argument),
            "::",
            stringify!(deref_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_usdt_argument>())).deref_ident as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt_argument),
            "::",
            stringify!(deref_ident)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bcc_usdt_argument>())).base_register_name as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt_argument),
            "::",
            stringify!(base_register_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bcc_usdt_argument>())).index_register_name as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt_argument),
            "::",
            stringify!(index_register_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bcc_usdt_argument>())).scale as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bcc_usdt_argument),
            "::",
            stringify!(scale)
        )
    );
}
impl Default for bcc_usdt_argument {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type bcc_usdt_cb = ::std::option::Option<unsafe extern "C" fn(arg1: *mut bcc_usdt)>;
extern "C" {
    pub fn bcc_usdt_foreach(usdt: *mut ::std::os::raw::c_void, callback: bcc_usdt_cb);
}
extern "C" {
    pub fn bcc_usdt_get_location(
        usdt: *mut ::std::os::raw::c_void,
        provider_name: *const ::std::os::raw::c_char,
        probe_name: *const ::std::os::raw::c_char,
        index: ::std::os::raw::c_int,
        location: *mut bcc_usdt_location,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_usdt_get_argument(
        usdt: *mut ::std::os::raw::c_void,
        provider_name: *const ::std::os::raw::c_char,
        probe_name: *const ::std::os::raw::c_char,
        location_index: ::std::os::raw::c_int,
        argument_index: ::std::os::raw::c_int,
        argument: *mut bcc_usdt_argument,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_usdt_enable_probe(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_usdt_addsem_probe(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
        arg4: i16,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_usdt_enable_fully_specified_probe(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_usdt_addsem_fully_specified_probe(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const ::std::os::raw::c_char,
        arg5: i16,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcc_usdt_genargs(
        ctx_array: *mut *mut ::std::os::raw::c_void,
        len: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcc_usdt_get_probe_argctype(
        ctx: *mut ::std::os::raw::c_void,
        probe_name: *const ::std::os::raw::c_char,
        arg_index: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcc_usdt_get_fully_specified_probe_argctype(
        ctx: *mut ::std::os::raw::c_void,
        provider_name: *const ::std::os::raw::c_char,
        probe_name: *const ::std::os::raw::c_char,
        arg_index: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
pub type bcc_usdt_uprobe_cb = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: u64,
        arg4: ::std::os::raw::c_int,
    ),
>;
extern "C" {
    pub fn bcc_usdt_foreach_uprobe(usdt: *mut ::std::os::raw::c_void, callback: bcc_usdt_uprobe_cb);
}
