// Copyright 2018 The Bazel Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.10.1
// source: build/bazel/remote/execution/v2/remote_execution.proto

package remoteexecution

import (
	context "context"
	semver "github.com/bazelbuild/remote-apis/build/bazel/semver"
	proto "github.com/golang/protobuf/proto"
	any "github.com/golang/protobuf/ptypes/any"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type ExecutionStage_Value int32

const (
	// Invalid value.
	ExecutionStage_UNKNOWN ExecutionStage_Value = 0
	// Checking the result against the cache.
	ExecutionStage_CACHE_CHECK ExecutionStage_Value = 1
	// Currently idle, awaiting a free machine to execute.
	ExecutionStage_QUEUED ExecutionStage_Value = 2
	// Currently being executed by a worker.
	ExecutionStage_EXECUTING ExecutionStage_Value = 3
	// Finished execution.
	ExecutionStage_COMPLETED ExecutionStage_Value = 4
)

// Enum value maps for ExecutionStage_Value.
var (
	ExecutionStage_Value_name = map[int32]string{
		0: "UNKNOWN",
		1: "CACHE_CHECK",
		2: "QUEUED",
		3: "EXECUTING",
		4: "COMPLETED",
	}
	ExecutionStage_Value_value = map[string]int32{
		"UNKNOWN":     0,
		"CACHE_CHECK": 1,
		"QUEUED":      2,
		"EXECUTING":   3,
		"COMPLETED":   4,
	}
)

func (x ExecutionStage_Value) Enum() *ExecutionStage_Value {
	p := new(ExecutionStage_Value)
	*p = x
	return p
}

func (x ExecutionStage_Value) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecutionStage_Value) Descriptor() protoreflect.EnumDescriptor {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_enumTypes[0].Descriptor()
}

func (ExecutionStage_Value) Type() protoreflect.EnumType {
	return &file_build_bazel_remote_execution_v2_remote_execution_proto_enumTypes[0]
}

func (x ExecutionStage_Value) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecutionStage_Value.Descriptor instead.
func (ExecutionStage_Value) EnumDescriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{21, 0}
}

type DigestFunction_Value int32

const (
	// It is an error for the server to return this value.
	DigestFunction_UNKNOWN DigestFunction_Value = 0
	// The SHA-256 digest function.
	DigestFunction_SHA256 DigestFunction_Value = 1
	// The SHA-1 digest function.
	DigestFunction_SHA1 DigestFunction_Value = 2
	// The MD5 digest function.
	DigestFunction_MD5 DigestFunction_Value = 3
	// The Microsoft "VSO-Hash" paged SHA256 digest function.
	// See https://github.com/microsoft/BuildXL/blob/master/Documentation/Specs/PagedHash.md .
	DigestFunction_VSO DigestFunction_Value = 4
	// The SHA-384 digest function.
	DigestFunction_SHA384 DigestFunction_Value = 5
	// The SHA-512 digest function.
	DigestFunction_SHA512 DigestFunction_Value = 6
	// Murmur3 128-bit digest function, x64 variant. Note that this is not a
	// cryptographic hash function and its collision properties are not strongly guaranteed.
	// See https://github.com/aappleby/smhasher/wiki/MurmurHash3 .
	DigestFunction_MURMUR3 DigestFunction_Value = 7
)

// Enum value maps for DigestFunction_Value.
var (
	DigestFunction_Value_name = map[int32]string{
		0: "UNKNOWN",
		1: "SHA256",
		2: "SHA1",
		3: "MD5",
		4: "VSO",
		5: "SHA384",
		6: "SHA512",
		7: "MURMUR3",
	}
	DigestFunction_Value_value = map[string]int32{
		"UNKNOWN": 0,
		"SHA256":  1,
		"SHA1":    2,
		"MD5":     3,
		"VSO":     4,
		"SHA384":  5,
		"SHA512":  6,
		"MURMUR3": 7,
	}
)

func (x DigestFunction_Value) Enum() *DigestFunction_Value {
	p := new(DigestFunction_Value)
	*p = x
	return p
}

func (x DigestFunction_Value) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DigestFunction_Value) Descriptor() protoreflect.EnumDescriptor {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_enumTypes[1].Descriptor()
}

func (DigestFunction_Value) Type() protoreflect.EnumType {
	return &file_build_bazel_remote_execution_v2_remote_execution_proto_enumTypes[1]
}

func (x DigestFunction_Value) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DigestFunction_Value.Descriptor instead.
func (DigestFunction_Value) EnumDescriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{36, 0}
}

type SymlinkAbsolutePathStrategy_Value int32

const (
	// Invalid value.
	SymlinkAbsolutePathStrategy_UNKNOWN SymlinkAbsolutePathStrategy_Value = 0
	// Server will return an `INVALID_ARGUMENT` on input symlinks with absolute
	// targets.
	// If an action tries to create an output symlink with an absolute target, a
	// `FAILED_PRECONDITION` will be returned.
	SymlinkAbsolutePathStrategy_DISALLOWED SymlinkAbsolutePathStrategy_Value = 1
	// Server will allow symlink targets to escape the input root tree, possibly
	// resulting in non-hermetic builds.
	SymlinkAbsolutePathStrategy_ALLOWED SymlinkAbsolutePathStrategy_Value = 2
)

// Enum value maps for SymlinkAbsolutePathStrategy_Value.
var (
	SymlinkAbsolutePathStrategy_Value_name = map[int32]string{
		0: "UNKNOWN",
		1: "DISALLOWED",
		2: "ALLOWED",
	}
	SymlinkAbsolutePathStrategy_Value_value = map[string]int32{
		"UNKNOWN":    0,
		"DISALLOWED": 1,
		"ALLOWED":    2,
	}
)

func (x SymlinkAbsolutePathStrategy_Value) Enum() *SymlinkAbsolutePathStrategy_Value {
	p := new(SymlinkAbsolutePathStrategy_Value)
	*p = x
	return p
}

func (x SymlinkAbsolutePathStrategy_Value) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SymlinkAbsolutePathStrategy_Value) Descriptor() protoreflect.EnumDescriptor {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_enumTypes[2].Descriptor()
}

func (SymlinkAbsolutePathStrategy_Value) Type() protoreflect.EnumType {
	return &file_build_bazel_remote_execution_v2_remote_execution_proto_enumTypes[2]
}

func (x SymlinkAbsolutePathStrategy_Value) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SymlinkAbsolutePathStrategy_Value.Descriptor instead.
func (SymlinkAbsolutePathStrategy_Value) EnumDescriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{39, 0}
}

type Compressor_Value int32

const (
	// No compression. Servers and clients MUST always support this, and do
	// not need to advertise it.
	Compressor_IDENTITY Compressor_Value = 0
	// Zstandard compression.
	Compressor_ZSTD Compressor_Value = 1
	// RFC 1951 Deflate. This format is identical to what is used by ZIP
	// files. Headers such as the one generated by gzip are not
	// included.
	//
	// It is advised to use algorithms such as Zstandard instead, as
	// those are faster and/or provide a better compression ratio.
	Compressor_DEFLATE Compressor_Value = 2
)

// Enum value maps for Compressor_Value.
var (
	Compressor_Value_name = map[int32]string{
		0: "IDENTITY",
		1: "ZSTD",
		2: "DEFLATE",
	}
	Compressor_Value_value = map[string]int32{
		"IDENTITY": 0,
		"ZSTD":     1,
		"DEFLATE":  2,
	}
)

func (x Compressor_Value) Enum() *Compressor_Value {
	p := new(Compressor_Value)
	*p = x
	return p
}

func (x Compressor_Value) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Compressor_Value) Descriptor() protoreflect.EnumDescriptor {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_enumTypes[3].Descriptor()
}

func (Compressor_Value) Type() protoreflect.EnumType {
	return &file_build_bazel_remote_execution_v2_remote_execution_proto_enumTypes[3]
}

func (x Compressor_Value) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Compressor_Value.Descriptor instead.
func (Compressor_Value) EnumDescriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{40, 0}
}

// An `Action` captures all the information about an execution which is required
// to reproduce it.
//
// `Action`s are the core component of the [Execution] service. A single
// `Action` represents a repeatable action that can be performed by the
// execution service. `Action`s can be succinctly identified by the digest of
// their wire format encoding and, once an `Action` has been executed, will be
// cached in the action cache. Future requests can then use the cached result
// rather than needing to run afresh.
//
// When a server completes execution of an
// [Action][build.bazel.remote.execution.v2.Action], it MAY choose to
// cache the [result][build.bazel.remote.execution.v2.ActionResult] in
// the [ActionCache][build.bazel.remote.execution.v2.ActionCache] unless
// `do_not_cache` is `true`. Clients SHOULD expect the server to do so. By
// default, future calls to
// [Execute][build.bazel.remote.execution.v2.Execution.Execute] the same
// `Action` will also serve their results from the cache. Clients must take care
// to understand the caching behaviour. Ideally, all `Action`s will be
// reproducible so that serving a result from cache is always desirable and
// correct.
type Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The digest of the [Command][build.bazel.remote.execution.v2.Command]
	// to run, which MUST be present in the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
	CommandDigest *Digest `protobuf:"bytes,1,opt,name=command_digest,json=commandDigest,proto3" json:"command_digest,omitempty"`
	// The digest of the root
	// [Directory][build.bazel.remote.execution.v2.Directory] for the input
	// files. The files in the directory tree are available in the correct
	// location on the build machine before the command is executed. The root
	// directory, as well as every subdirectory and content blob referred to, MUST
	// be in the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
	InputRootDigest *Digest `protobuf:"bytes,2,opt,name=input_root_digest,json=inputRootDigest,proto3" json:"input_root_digest,omitempty"`
	// A timeout after which the execution should be killed. If the timeout is
	// absent, then the client is specifying that the execution should continue
	// as long as the server will let it. The server SHOULD impose a timeout if
	// the client does not specify one, however, if the client does specify a
	// timeout that is longer than the server's maximum timeout, the server MUST
	// reject the request.
	//
	// The timeout is only intended to cover the "execution" of the specified
	// action and not time in queue nor any overheads before or after execution
	// such as marshalling inputs/outputs. The server SHOULD avoid including time
	// spent the client doesn't have control over, and MAY extend or reduce the
	// timeout to account for delays or speedups that occur during execution
	// itself (e.g., lazily loading data from the Content Addressable Storage,
	// live migration of virtual machines, emulation overhead).
	//
	// The timeout is a part of the
	// [Action][build.bazel.remote.execution.v2.Action] message, and
	// therefore two `Actions` with different timeouts are different, even if they
	// are otherwise identical. This is because, if they were not, running an
	// `Action` with a lower timeout than is required might result in a cache hit
	// from an execution run with a longer timeout, hiding the fact that the
	// timeout is too short. By encoding it directly in the `Action`, a lower
	// timeout will result in a cache miss and the execution timeout will fail
	// immediately, rather than whenever the cache entry gets evicted.
	Timeout *duration.Duration `protobuf:"bytes,6,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// If true, then the `Action`'s result cannot be cached, and in-flight
	// requests for the same `Action` may not be merged.
	DoNotCache bool `protobuf:"varint,7,opt,name=do_not_cache,json=doNotCache,proto3" json:"do_not_cache,omitempty"`
	// An optional additional salt value used to place this `Action` into a
	// separate cache namespace from other instances having the same field
	// contents. This salt typically comes from operational configuration
	// specific to sources such as repo and service configuration,
	// and allows disowning an entire set of ActionResults that might have been
	// poisoned by buggy software or tool failures.
	Salt []byte `protobuf:"bytes,9,opt,name=salt,proto3" json:"salt,omitempty"`
	// The optional platform requirements for the execution environment. The
	// server MAY choose to execute the action on any worker satisfying the
	// requirements, so the client SHOULD ensure that running the action on any
	// such worker will have the same result.  A detailed lexicon for this can be
	// found in the accompanying platform.md.
	// New in version 2.2: clients SHOULD set these platform properties as well
	// as those in the [Command][build.bazel.remote.execution.v2.Command]. Servers
	// SHOULD prefer those set here.
	Platform *Platform `protobuf:"bytes,10,opt,name=platform,proto3" json:"platform,omitempty"`
}

func (x *Action) Reset() {
	*x = Action{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action) ProtoMessage() {}

func (x *Action) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action.ProtoReflect.Descriptor instead.
func (*Action) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{0}
}

func (x *Action) GetCommandDigest() *Digest {
	if x != nil {
		return x.CommandDigest
	}
	return nil
}

func (x *Action) GetInputRootDigest() *Digest {
	if x != nil {
		return x.InputRootDigest
	}
	return nil
}

func (x *Action) GetTimeout() *duration.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *Action) GetDoNotCache() bool {
	if x != nil {
		return x.DoNotCache
	}
	return false
}

func (x *Action) GetSalt() []byte {
	if x != nil {
		return x.Salt
	}
	return nil
}

func (x *Action) GetPlatform() *Platform {
	if x != nil {
		return x.Platform
	}
	return nil
}

// A `Command` is the actual command executed by a worker running an
// [Action][build.bazel.remote.execution.v2.Action] and specifications of its
// environment.
//
// Except as otherwise required, the environment (such as which system
// libraries or binaries are available, and what filesystems are mounted where)
// is defined by and specific to the implementation of the remote execution API.
type Command struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The arguments to the command. The first argument must be the path to the
	// executable, which must be either a relative path, in which case it is
	// evaluated with respect to the input root, or an absolute path.
	Arguments []string `protobuf:"bytes,1,rep,name=arguments,proto3" json:"arguments,omitempty"`
	// The environment variables to set when running the program. The worker may
	// provide its own default environment variables; these defaults can be
	// overridden using this field. Additional variables can also be specified.
	//
	// In order to ensure that equivalent
	// [Command][build.bazel.remote.execution.v2.Command]s always hash to the same
	// value, the environment variables MUST be lexicographically sorted by name.
	// Sorting of strings is done by code point, equivalently, by the UTF-8 bytes.
	EnvironmentVariables []*Command_EnvironmentVariable `protobuf:"bytes,2,rep,name=environment_variables,json=environmentVariables,proto3" json:"environment_variables,omitempty"`
	// A list of the output files that the client expects to retrieve from the
	// action. Only the listed files, as well as directories listed in
	// `output_directories`, will be returned to the client as output.
	// Other files or directories that may be created during command execution
	// are discarded.
	//
	// The paths are relative to the working directory of the action execution.
	// The paths are specified using a single forward slash (`/`) as a path
	// separator, even if the execution platform natively uses a different
	// separator. The path MUST NOT include a trailing slash, nor a leading slash,
	// being a relative path.
	//
	// In order to ensure consistent hashing of the same Action, the output paths
	// MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
	// bytes).
	//
	// An output file cannot be duplicated, be a parent of another output file, or
	// have the same path as any of the listed output directories.
	//
	// Directories leading up to the output files are created by the worker prior
	// to execution, even if they are not explicitly part of the input root.
	//
	// DEPRECATED since v2.1: Use `output_paths` instead.
	OutputFiles []string `protobuf:"bytes,3,rep,name=output_files,json=outputFiles,proto3" json:"output_files,omitempty"`
	// A list of the output directories that the client expects to retrieve from
	// the action. Only the listed directories will be returned (an entire
	// directory structure will be returned as a
	// [Tree][build.bazel.remote.execution.v2.Tree] message digest, see
	// [OutputDirectory][build.bazel.remote.execution.v2.OutputDirectory]), as
	// well as files listed in `output_files`. Other files or directories that
	// may be created during command execution are discarded.
	//
	// The paths are relative to the working directory of the action execution.
	// The paths are specified using a single forward slash (`/`) as a path
	// separator, even if the execution platform natively uses a different
	// separator. The path MUST NOT include a trailing slash, nor a leading slash,
	// being a relative path. The special value of empty string is allowed,
	// although not recommended, and can be used to capture the entire working
	// directory tree, including inputs.
	//
	// In order to ensure consistent hashing of the same Action, the output paths
	// MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
	// bytes).
	//
	// An output directory cannot be duplicated or have the same path as any of
	// the listed output files. An output directory is allowed to be a parent of
	// another output directory.
	//
	// Directories leading up to the output directories (but not the output
	// directories themselves) are created by the worker prior to execution, even
	// if they are not explicitly part of the input root.
	//
	// DEPRECATED since 2.1: Use `output_paths` instead.
	OutputDirectories []string `protobuf:"bytes,4,rep,name=output_directories,json=outputDirectories,proto3" json:"output_directories,omitempty"`
	// A list of the output paths that the client expects to retrieve from the
	// action. Only the listed paths will be returned to the client as output.
	// The type of the output (file or directory) is not specified, and will be
	// determined by the server after action execution. If the resulting path is
	// a file, it will be returned in an
	// [OutputFile][build.bazel.remote.execution.v2.OutputFile] typed field.
	// If the path is a directory, the entire directory structure will be returned
	// as a [Tree][build.bazel.remote.execution.v2.Tree] message digest, see
	// [OutputDirectory][build.bazel.remote.execution.v2.OutputDirectory]
	// Other files or directories that may be created during command execution
	// are discarded.
	//
	// The paths are relative to the working directory of the action execution.
	// The paths are specified using a single forward slash (`/`) as a path
	// separator, even if the execution platform natively uses a different
	// separator. The path MUST NOT include a trailing slash, nor a leading slash,
	// being a relative path.
	//
	// In order to ensure consistent hashing of the same Action, the output paths
	// MUST be deduplicated and sorted lexicographically by code point (or,
	// equivalently, by UTF-8 bytes).
	//
	// Directories leading up to the output paths are created by the worker prior
	// to execution, even if they are not explicitly part of the input root.
	//
	// New in v2.1: this field supersedes the DEPRECATED `output_files` and
	// `output_directories` fields. If `output_paths` is used, `output_files` and
	// `output_directories` will be ignored!
	OutputPaths []string `protobuf:"bytes,7,rep,name=output_paths,json=outputPaths,proto3" json:"output_paths,omitempty"`
	// The platform requirements for the execution environment. The server MAY
	// choose to execute the action on any worker satisfying the requirements, so
	// the client SHOULD ensure that running the action on any such worker will
	// have the same result.  A detailed lexicon for this can be found in the
	// accompanying platform.md.
	// DEPRECATED as of v2.2: platform properties are now specified directly in
	// the action. See documentation note in the
	// [Action][build.bazel.remote.execution.v2.Action] for migration.
	Platform *Platform `protobuf:"bytes,5,opt,name=platform,proto3" json:"platform,omitempty"`
	// The working directory, relative to the input root, for the command to run
	// in. It must be a directory which exists in the input tree. If it is left
	// empty, then the action is run in the input root.
	WorkingDirectory string `protobuf:"bytes,6,opt,name=working_directory,json=workingDirectory,proto3" json:"working_directory,omitempty"`
	// A list of keys for node properties the client expects to retrieve for
	// output files and directories. Keys are either names of string-based
	// [NodeProperty][build.bazel.remote.execution.v2.NodeProperty] or
	// names of fields in [NodeProperties][build.bazel.remote.execution.v2.NodeProperties].
	// In order to ensure that equivalent `Action`s always hash to the same
	// value, the node properties MUST be lexicographically sorted by name.
	// Sorting of strings is done by code point, equivalently, by the UTF-8 bytes.
	//
	// The interpretation of string-based properties is server-dependent. If a
	// property is not recognized by the server, the server will return an
	// `INVALID_ARGUMENT`.
	OutputNodeProperties []string `protobuf:"bytes,8,rep,name=output_node_properties,json=outputNodeProperties,proto3" json:"output_node_properties,omitempty"`
}

func (x *Command) Reset() {
	*x = Command{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Command) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Command) ProtoMessage() {}

func (x *Command) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Command.ProtoReflect.Descriptor instead.
func (*Command) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{1}
}

func (x *Command) GetArguments() []string {
	if x != nil {
		return x.Arguments
	}
	return nil
}

func (x *Command) GetEnvironmentVariables() []*Command_EnvironmentVariable {
	if x != nil {
		return x.EnvironmentVariables
	}
	return nil
}

func (x *Command) GetOutputFiles() []string {
	if x != nil {
		return x.OutputFiles
	}
	return nil
}

func (x *Command) GetOutputDirectories() []string {
	if x != nil {
		return x.OutputDirectories
	}
	return nil
}

func (x *Command) GetOutputPaths() []string {
	if x != nil {
		return x.OutputPaths
	}
	return nil
}

func (x *Command) GetPlatform() *Platform {
	if x != nil {
		return x.Platform
	}
	return nil
}

func (x *Command) GetWorkingDirectory() string {
	if x != nil {
		return x.WorkingDirectory
	}
	return ""
}

func (x *Command) GetOutputNodeProperties() []string {
	if x != nil {
		return x.OutputNodeProperties
	}
	return nil
}

// A `Platform` is a set of requirements, such as hardware, operating system, or
// compiler toolchain, for an
// [Action][build.bazel.remote.execution.v2.Action]'s execution
// environment. A `Platform` is represented as a series of key-value pairs
// representing the properties that are required of the platform.
type Platform struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The properties that make up this platform. In order to ensure that
	// equivalent `Platform`s always hash to the same value, the properties MUST
	// be lexicographically sorted by name, and then by value. Sorting of strings
	// is done by code point, equivalently, by the UTF-8 bytes.
	Properties []*Platform_Property `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty"`
}

func (x *Platform) Reset() {
	*x = Platform{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Platform) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Platform) ProtoMessage() {}

func (x *Platform) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Platform.ProtoReflect.Descriptor instead.
func (*Platform) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{2}
}

func (x *Platform) GetProperties() []*Platform_Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

// A `Directory` represents a directory node in a file tree, containing zero or
// more children [FileNodes][build.bazel.remote.execution.v2.FileNode],
// [DirectoryNodes][build.bazel.remote.execution.v2.DirectoryNode] and
// [SymlinkNodes][build.bazel.remote.execution.v2.SymlinkNode].
// Each `Node` contains its name in the directory, either the digest of its
// content (either a file blob or a `Directory` proto) or a symlink target, as
// well as possibly some metadata about the file or directory.
//
// In order to ensure that two equivalent directory trees hash to the same
// value, the following restrictions MUST be obeyed when constructing a
// a `Directory`:
//
// * Every child in the directory must have a path of exactly one segment.
//   Multiple levels of directory hierarchy may not be collapsed.
// * Each child in the directory must have a unique path segment (file name).
//   Note that while the API itself is case-sensitive, the environment where
//   the Action is executed may or may not be case-sensitive. That is, it is
//   legal to call the API with a Directory that has both "Foo" and "foo" as
//   children, but the Action may be rejected by the remote system upon
//   execution.
// * The files, directories and symlinks in the directory must each be sorted
//   in lexicographical order by path. The path strings must be sorted by code
//   point, equivalently, by UTF-8 bytes.
// * The [NodeProperties][build.bazel.remote.execution.v2.NodeProperty] of files,
//   directories, and symlinks must be sorted in lexicographical order by
//   property name.
//
// A `Directory` that obeys the restrictions is said to be in canonical form.
//
// As an example, the following could be used for a file named `bar` and a
// directory named `foo` with an executable file named `baz` (hashes shortened
// for readability):
//
// ```json
// // (Directory proto)
// {
//   files: [
//     {
//       name: "bar",
//       digest: {
//         hash: "4a73bc9d03...",
//         size: 65534
//       },
//       node_properties: [
//         {
//           "name": "MTime",
//           "value": "2017-01-15T01:30:15.01Z"
//         }
//       ]
//     }
//   ],
//   directories: [
//     {
//       name: "foo",
//       digest: {
//         hash: "4cf2eda940...",
//         size: 43
//       }
//     }
//   ]
// }
//
// // (Directory proto with hash "4cf2eda940..." and size 43)
// {
//   files: [
//     {
//       name: "baz",
//       digest: {
//         hash: "b2c941073e...",
//         size: 1294,
//       },
//       is_executable: true
//     }
//   ]
// }
// ```
type Directory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The files in the directory.
	Files []*FileNode `protobuf:"bytes,1,rep,name=files,proto3" json:"files,omitempty"`
	// The subdirectories in the directory.
	Directories []*DirectoryNode `protobuf:"bytes,2,rep,name=directories,proto3" json:"directories,omitempty"`
	// The symlinks in the directory.
	Symlinks       []*SymlinkNode  `protobuf:"bytes,3,rep,name=symlinks,proto3" json:"symlinks,omitempty"`
	NodeProperties *NodeProperties `protobuf:"bytes,5,opt,name=node_properties,json=nodeProperties,proto3" json:"node_properties,omitempty"`
}

func (x *Directory) Reset() {
	*x = Directory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Directory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Directory) ProtoMessage() {}

func (x *Directory) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Directory.ProtoReflect.Descriptor instead.
func (*Directory) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{3}
}

func (x *Directory) GetFiles() []*FileNode {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *Directory) GetDirectories() []*DirectoryNode {
	if x != nil {
		return x.Directories
	}
	return nil
}

func (x *Directory) GetSymlinks() []*SymlinkNode {
	if x != nil {
		return x.Symlinks
	}
	return nil
}

func (x *Directory) GetNodeProperties() *NodeProperties {
	if x != nil {
		return x.NodeProperties
	}
	return nil
}

// A single property for [FileNodes][build.bazel.remote.execution.v2.FileNode],
// [DirectoryNodes][build.bazel.remote.execution.v2.DirectoryNode], and
// [SymlinkNodes][build.bazel.remote.execution.v2.SymlinkNode]. The server is
// responsible for specifying the property `name`s that it accepts. If
// permitted by the server, the same `name` may occur multiple times.
type NodeProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The property name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The property value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *NodeProperty) Reset() {
	*x = NodeProperty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeProperty) ProtoMessage() {}

func (x *NodeProperty) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeProperty.ProtoReflect.Descriptor instead.
func (*NodeProperty) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{4}
}

func (x *NodeProperty) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NodeProperty) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Node properties for [FileNodes][build.bazel.remote.execution.v2.FileNode],
// [DirectoryNodes][build.bazel.remote.execution.v2.DirectoryNode], and
// [SymlinkNodes][build.bazel.remote.execution.v2.SymlinkNode]. The server is
// responsible for specifying the properties that it accepts.
//
type NodeProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of string-based
	// [NodeProperties][build.bazel.remote.execution.v2.NodeProperty].
	Properties []*NodeProperty `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty"`
	// The file's last modification timestamp.
	Mtime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=mtime,proto3" json:"mtime,omitempty"`
	// The UNIX file mode, e.g., 0755.
	UnixMode *wrappers.UInt32Value `protobuf:"bytes,3,opt,name=unix_mode,json=unixMode,proto3" json:"unix_mode,omitempty"`
}

func (x *NodeProperties) Reset() {
	*x = NodeProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeProperties) ProtoMessage() {}

func (x *NodeProperties) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeProperties.ProtoReflect.Descriptor instead.
func (*NodeProperties) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{5}
}

func (x *NodeProperties) GetProperties() []*NodeProperty {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *NodeProperties) GetMtime() *timestamp.Timestamp {
	if x != nil {
		return x.Mtime
	}
	return nil
}

func (x *NodeProperties) GetUnixMode() *wrappers.UInt32Value {
	if x != nil {
		return x.UnixMode
	}
	return nil
}

// A `FileNode` represents a single file and associated metadata.
type FileNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the file.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The digest of the file's content.
	Digest *Digest `protobuf:"bytes,2,opt,name=digest,proto3" json:"digest,omitempty"`
	// True if file is executable, false otherwise.
	IsExecutable   bool            `protobuf:"varint,4,opt,name=is_executable,json=isExecutable,proto3" json:"is_executable,omitempty"`
	NodeProperties *NodeProperties `protobuf:"bytes,6,opt,name=node_properties,json=nodeProperties,proto3" json:"node_properties,omitempty"`
}

func (x *FileNode) Reset() {
	*x = FileNode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileNode) ProtoMessage() {}

func (x *FileNode) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileNode.ProtoReflect.Descriptor instead.
func (*FileNode) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{6}
}

func (x *FileNode) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FileNode) GetDigest() *Digest {
	if x != nil {
		return x.Digest
	}
	return nil
}

func (x *FileNode) GetIsExecutable() bool {
	if x != nil {
		return x.IsExecutable
	}
	return false
}

func (x *FileNode) GetNodeProperties() *NodeProperties {
	if x != nil {
		return x.NodeProperties
	}
	return nil
}

// A `DirectoryNode` represents a child of a
// [Directory][build.bazel.remote.execution.v2.Directory] which is itself
// a `Directory` and its associated metadata.
type DirectoryNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the directory.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The digest of the
	// [Directory][build.bazel.remote.execution.v2.Directory] object
	// represented. See [Digest][build.bazel.remote.execution.v2.Digest]
	// for information about how to take the digest of a proto message.
	Digest *Digest `protobuf:"bytes,2,opt,name=digest,proto3" json:"digest,omitempty"`
}

func (x *DirectoryNode) Reset() {
	*x = DirectoryNode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DirectoryNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectoryNode) ProtoMessage() {}

func (x *DirectoryNode) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectoryNode.ProtoReflect.Descriptor instead.
func (*DirectoryNode) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{7}
}

func (x *DirectoryNode) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DirectoryNode) GetDigest() *Digest {
	if x != nil {
		return x.Digest
	}
	return nil
}

// A `SymlinkNode` represents a symbolic link.
type SymlinkNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the symlink.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The target path of the symlink. The path separator is a forward slash `/`.
	// The target path can be relative to the parent directory of the symlink or
	// it can be an absolute path starting with `/`. Support for absolute paths
	// can be checked using the [Capabilities][build.bazel.remote.execution.v2.Capabilities]
	// API. `..` components are allowed anywhere in the target path as logical
	// canonicalization may lead to different behavior in the presence of
	// directory symlinks (e.g. `foo/../bar` may not be the same as `bar`).
	// To reduce potential cache misses, canonicalization is still recommended
	// where this is possible without impacting correctness.
	Target         string          `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	NodeProperties *NodeProperties `protobuf:"bytes,4,opt,name=node_properties,json=nodeProperties,proto3" json:"node_properties,omitempty"`
}

func (x *SymlinkNode) Reset() {
	*x = SymlinkNode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SymlinkNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SymlinkNode) ProtoMessage() {}

func (x *SymlinkNode) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SymlinkNode.ProtoReflect.Descriptor instead.
func (*SymlinkNode) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{8}
}

func (x *SymlinkNode) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SymlinkNode) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *SymlinkNode) GetNodeProperties() *NodeProperties {
	if x != nil {
		return x.NodeProperties
	}
	return nil
}

// A content digest. A digest for a given blob consists of the size of the blob
// and its hash. The hash algorithm to use is defined by the server.
//
// The size is considered to be an integral part of the digest and cannot be
// separated. That is, even if the `hash` field is correctly specified but
// `size_bytes` is not, the server MUST reject the request.
//
// The reason for including the size in the digest is as follows: in a great
// many cases, the server needs to know the size of the blob it is about to work
// with prior to starting an operation with it, such as flattening Merkle tree
// structures or streaming it to a worker. Technically, the server could
// implement a separate metadata store, but this results in a significantly more
// complicated implementation as opposed to having the client specify the size
// up-front (or storing the size along with the digest in every message where
// digests are embedded). This does mean that the API leaks some implementation
// details of (what we consider to be) a reasonable server implementation, but
// we consider this to be a worthwhile tradeoff.
//
// When a `Digest` is used to refer to a proto message, it always refers to the
// message in binary encoded form. To ensure consistent hashing, clients and
// servers MUST ensure that they serialize messages according to the following
// rules, even if there are alternate valid encodings for the same message:
//
// * Fields are serialized in tag order.
// * There are no unknown fields.
// * There are no duplicate fields.
// * Fields are serialized according to the default semantics for their type.
//
// Most protocol buffer implementations will always follow these rules when
// serializing, but care should be taken to avoid shortcuts. For instance,
// concatenating two messages to merge them may produce duplicate fields.
type Digest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The hash. In the case of SHA-256, it will always be a lowercase hex string
	// exactly 64 characters long.
	Hash string `protobuf:"bytes,1,opt,name=hash,proto3" json:"hash,omitempty"`
	// The size of the blob, in bytes.
	SizeBytes int64 `protobuf:"varint,2,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
}

func (x *Digest) Reset() {
	*x = Digest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Digest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Digest) ProtoMessage() {}

func (x *Digest) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Digest.ProtoReflect.Descriptor instead.
func (*Digest) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{9}
}

func (x *Digest) GetHash() string {
	if x != nil {
		return x.Hash
	}
	return ""
}

func (x *Digest) GetSizeBytes() int64 {
	if x != nil {
		return x.SizeBytes
	}
	return 0
}

// ExecutedActionMetadata contains details about a completed execution.
type ExecutedActionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the worker which ran the execution.
	Worker string `protobuf:"bytes,1,opt,name=worker,proto3" json:"worker,omitempty"`
	// When was the action added to the queue.
	QueuedTimestamp *timestamp.Timestamp `protobuf:"bytes,2,opt,name=queued_timestamp,json=queuedTimestamp,proto3" json:"queued_timestamp,omitempty"`
	// When the worker received the action.
	WorkerStartTimestamp *timestamp.Timestamp `protobuf:"bytes,3,opt,name=worker_start_timestamp,json=workerStartTimestamp,proto3" json:"worker_start_timestamp,omitempty"`
	// When the worker completed the action, including all stages.
	WorkerCompletedTimestamp *timestamp.Timestamp `protobuf:"bytes,4,opt,name=worker_completed_timestamp,json=workerCompletedTimestamp,proto3" json:"worker_completed_timestamp,omitempty"`
	// When the worker started fetching action inputs.
	InputFetchStartTimestamp *timestamp.Timestamp `protobuf:"bytes,5,opt,name=input_fetch_start_timestamp,json=inputFetchStartTimestamp,proto3" json:"input_fetch_start_timestamp,omitempty"`
	// When the worker finished fetching action inputs.
	InputFetchCompletedTimestamp *timestamp.Timestamp `protobuf:"bytes,6,opt,name=input_fetch_completed_timestamp,json=inputFetchCompletedTimestamp,proto3" json:"input_fetch_completed_timestamp,omitempty"`
	// When the worker started executing the action command.
	ExecutionStartTimestamp *timestamp.Timestamp `protobuf:"bytes,7,opt,name=execution_start_timestamp,json=executionStartTimestamp,proto3" json:"execution_start_timestamp,omitempty"`
	// When the worker completed executing the action command.
	ExecutionCompletedTimestamp *timestamp.Timestamp `protobuf:"bytes,8,opt,name=execution_completed_timestamp,json=executionCompletedTimestamp,proto3" json:"execution_completed_timestamp,omitempty"`
	// New in v2.3: the amount of time the worker spent executing the action
	// command, potentially computed using a worker-specific virtual clock.
	//
	// The virtual execution duration is only intended to cover the "execution" of
	// the specified action and not time in queue nor any overheads before or
	// after execution such as marshalling inputs/outputs. The server SHOULD avoid
	// including time spent the client doesn't have control over, and MAY extend
	// or reduce the execution duration to account for delays or speedups that
	// occur during execution itself (e.g., lazily loading data from the Content
	// Addressable Storage, live migration of virtual machines, emulation
	// overhead).
	//
	// The method of timekeeping used to compute the virtual execution duration
	// MUST be consistent with what is used to enforce the
	// [Action][[build.bazel.remote.execution.v2.Action]'s `timeout`. There is no
	// relationship between the virtual execution duration and the values of
	// `execution_start_timestamp` and `execution_completed_timestamp`.
	VirtualExecutionDuration *duration.Duration `protobuf:"bytes,12,opt,name=virtual_execution_duration,json=virtualExecutionDuration,proto3" json:"virtual_execution_duration,omitempty"`
	// When the worker started uploading action outputs.
	OutputUploadStartTimestamp *timestamp.Timestamp `protobuf:"bytes,9,opt,name=output_upload_start_timestamp,json=outputUploadStartTimestamp,proto3" json:"output_upload_start_timestamp,omitempty"`
	// When the worker finished uploading action outputs.
	OutputUploadCompletedTimestamp *timestamp.Timestamp `protobuf:"bytes,10,opt,name=output_upload_completed_timestamp,json=outputUploadCompletedTimestamp,proto3" json:"output_upload_completed_timestamp,omitempty"`
	// Details that are specific to the kind of worker used. For example,
	// on POSIX-like systems this could contain a message with
	// getrusage(2) statistics.
	AuxiliaryMetadata []*any.Any `protobuf:"bytes,11,rep,name=auxiliary_metadata,json=auxiliaryMetadata,proto3" json:"auxiliary_metadata,omitempty"`
}

func (x *ExecutedActionMetadata) Reset() {
	*x = ExecutedActionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutedActionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutedActionMetadata) ProtoMessage() {}

func (x *ExecutedActionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutedActionMetadata.ProtoReflect.Descriptor instead.
func (*ExecutedActionMetadata) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{10}
}

func (x *ExecutedActionMetadata) GetWorker() string {
	if x != nil {
		return x.Worker
	}
	return ""
}

func (x *ExecutedActionMetadata) GetQueuedTimestamp() *timestamp.Timestamp {
	if x != nil {
		return x.QueuedTimestamp
	}
	return nil
}

func (x *ExecutedActionMetadata) GetWorkerStartTimestamp() *timestamp.Timestamp {
	if x != nil {
		return x.WorkerStartTimestamp
	}
	return nil
}

func (x *ExecutedActionMetadata) GetWorkerCompletedTimestamp() *timestamp.Timestamp {
	if x != nil {
		return x.WorkerCompletedTimestamp
	}
	return nil
}

func (x *ExecutedActionMetadata) GetInputFetchStartTimestamp() *timestamp.Timestamp {
	if x != nil {
		return x.InputFetchStartTimestamp
	}
	return nil
}

func (x *ExecutedActionMetadata) GetInputFetchCompletedTimestamp() *timestamp.Timestamp {
	if x != nil {
		return x.InputFetchCompletedTimestamp
	}
	return nil
}

func (x *ExecutedActionMetadata) GetExecutionStartTimestamp() *timestamp.Timestamp {
	if x != nil {
		return x.ExecutionStartTimestamp
	}
	return nil
}

func (x *ExecutedActionMetadata) GetExecutionCompletedTimestamp() *timestamp.Timestamp {
	if x != nil {
		return x.ExecutionCompletedTimestamp
	}
	return nil
}

func (x *ExecutedActionMetadata) GetVirtualExecutionDuration() *duration.Duration {
	if x != nil {
		return x.VirtualExecutionDuration
	}
	return nil
}

func (x *ExecutedActionMetadata) GetOutputUploadStartTimestamp() *timestamp.Timestamp {
	if x != nil {
		return x.OutputUploadStartTimestamp
	}
	return nil
}

func (x *ExecutedActionMetadata) GetOutputUploadCompletedTimestamp() *timestamp.Timestamp {
	if x != nil {
		return x.OutputUploadCompletedTimestamp
	}
	return nil
}

func (x *ExecutedActionMetadata) GetAuxiliaryMetadata() []*any.Any {
	if x != nil {
		return x.AuxiliaryMetadata
	}
	return nil
}

// An ActionResult represents the result of an
// [Action][build.bazel.remote.execution.v2.Action] being run.
//
// It is advised that at least one field (for example
// `ActionResult.execution_metadata.Worker`) have a non-default value, to
// ensure that the serialized value is non-empty, which can then be used
// as a basic data sanity check.
type ActionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output files of the action. For each output file requested in the
	// `output_files` or `output_paths` field of the Action, if the corresponding
	// file existed after the action completed, a single entry will be present
	// either in this field, or the `output_file_symlinks` field if the file was
	// a symbolic link to another file (`output_symlinks` field after v2.1).
	//
	// If an output listed in `output_files` was found, but was a directory rather
	// than a regular file, the server will return a FAILED_PRECONDITION.
	// If the action does not produce the requested output, then that output
	// will be omitted from the list. The server is free to arrange the output
	// list as desired; clients MUST NOT assume that the output list is sorted.
	OutputFiles []*OutputFile `protobuf:"bytes,2,rep,name=output_files,json=outputFiles,proto3" json:"output_files,omitempty"`
	// The output files of the action that are symbolic links to other files. Those
	// may be links to other output files, or input files, or even absolute paths
	// outside of the working directory, if the server supports
	// [SymlinkAbsolutePathStrategy.ALLOWED][build.bazel.remote.execution.v2.CacheCapabilities.SymlinkAbsolutePathStrategy].
	// For each output file requested in the `output_files` or `output_paths`
	// field of the Action, if the corresponding file existed after
	// the action completed, a single entry will be present either in this field,
	// or in the `output_files` field, if the file was not a symbolic link.
	//
	// If an output symbolic link of the same name as listed in `output_files` of
	// the Command was found, but its target type was not a regular file, the
	// server will return a FAILED_PRECONDITION.
	// If the action does not produce the requested output, then that output
	// will be omitted from the list. The server is free to arrange the output
	// list as desired; clients MUST NOT assume that the output list is sorted.
	//
	// DEPRECATED as of v2.1. Servers that wish to be compatible with v2.0 API
	// should still populate this field in addition to `output_symlinks`.
	OutputFileSymlinks []*OutputSymlink `protobuf:"bytes,10,rep,name=output_file_symlinks,json=outputFileSymlinks,proto3" json:"output_file_symlinks,omitempty"`
	// New in v2.1: this field will only be populated if the command
	// `output_paths` field was used, and not the pre v2.1 `output_files` or
	// `output_directories` fields.
	// The output paths of the action that are symbolic links to other paths. Those
	// may be links to other outputs, or inputs, or even absolute paths
	// outside of the working directory, if the server supports
	// [SymlinkAbsolutePathStrategy.ALLOWED][build.bazel.remote.execution.v2.CacheCapabilities.SymlinkAbsolutePathStrategy].
	// A single entry for each output requested in `output_paths`
	// field of the Action, if the corresponding path existed after
	// the action completed and was a symbolic link.
	//
	// If the action does not produce a requested output, then that output
	// will be omitted from the list. The server is free to arrange the output
	// list as desired; clients MUST NOT assume that the output list is sorted.
	OutputSymlinks []*OutputSymlink `protobuf:"bytes,12,rep,name=output_symlinks,json=outputSymlinks,proto3" json:"output_symlinks,omitempty"`
	// The output directories of the action. For each output directory requested
	// in the `output_directories` or `output_paths` field of the Action, if the
	// corresponding directory existed after the action completed, a single entry
	// will be present in the output list, which will contain the digest of a
	// [Tree][build.bazel.remote.execution.v2.Tree] message containing the
	// directory tree, and the path equal exactly to the corresponding Action
	// output_directories member.
	//
	// As an example, suppose the Action had an output directory `a/b/dir` and the
	// execution produced the following contents in `a/b/dir`: a file named `bar`
	// and a directory named `foo` with an executable file named `baz`. Then,
	// output_directory will contain (hashes shortened for readability):
	//
	// ```json
	// // OutputDirectory proto:
	// {
	//   path: "a/b/dir"
	//   tree_digest: {
	//     hash: "4a73bc9d03...",
	//     size: 55
	//   }
	// }
	// // Tree proto with hash "4a73bc9d03..." and size 55:
	// {
	//   root: {
	//     files: [
	//       {
	//         name: "bar",
	//         digest: {
	//           hash: "4a73bc9d03...",
	//           size: 65534
	//         }
	//       }
	//     ],
	//     directories: [
	//       {
	//         name: "foo",
	//         digest: {
	//           hash: "4cf2eda940...",
	//           size: 43
	//         }
	//       }
	//     ]
	//   }
	//   children : {
	//     // (Directory proto with hash "4cf2eda940..." and size 43)
	//     files: [
	//       {
	//         name: "baz",
	//         digest: {
	//           hash: "b2c941073e...",
	//           size: 1294,
	//         },
	//         is_executable: true
	//       }
	//     ]
	//   }
	// }
	// ```
	// If an output of the same name as listed in `output_files` of
	// the Command was found in `output_directories`, but was not a directory, the
	// server will return a FAILED_PRECONDITION.
	OutputDirectories []*OutputDirectory `protobuf:"bytes,3,rep,name=output_directories,json=outputDirectories,proto3" json:"output_directories,omitempty"`
	// The output directories of the action that are symbolic links to other
	// directories. Those may be links to other output directories, or input
	// directories, or even absolute paths outside of the working directory,
	// if the server supports
	// [SymlinkAbsolutePathStrategy.ALLOWED][build.bazel.remote.execution.v2.CacheCapabilities.SymlinkAbsolutePathStrategy].
	// For each output directory requested in the `output_directories` field of
	// the Action, if the directory existed after the action completed, a
	// single entry will be present either in this field, or in the
	// `output_directories` field, if the directory was not a symbolic link.
	//
	// If an output of the same name was found, but was a symbolic link to a file
	// instead of a directory, the server will return a FAILED_PRECONDITION.
	// If the action does not produce the requested output, then that output
	// will be omitted from the list. The server is free to arrange the output
	// list as desired; clients MUST NOT assume that the output list is sorted.
	//
	// DEPRECATED as of v2.1. Servers that wish to be compatible with v2.0 API
	// should still populate this field in addition to `output_symlinks`.
	OutputDirectorySymlinks []*OutputSymlink `protobuf:"bytes,11,rep,name=output_directory_symlinks,json=outputDirectorySymlinks,proto3" json:"output_directory_symlinks,omitempty"`
	// The exit code of the command.
	ExitCode int32 `protobuf:"varint,4,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	// The standard output buffer of the action. The server SHOULD NOT inline
	// stdout unless requested by the client in the
	// [GetActionResultRequest][build.bazel.remote.execution.v2.GetActionResultRequest]
	// message. The server MAY omit inlining, even if requested, and MUST do so if inlining
	// would cause the response to exceed message size limits.
	// Clients SHOULD NOT populate this field when uploading to the cache.
	StdoutRaw []byte `protobuf:"bytes,5,opt,name=stdout_raw,json=stdoutRaw,proto3" json:"stdout_raw,omitempty"`
	// The digest for a blob containing the standard output of the action, which
	// can be retrieved from the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
	StdoutDigest *Digest `protobuf:"bytes,6,opt,name=stdout_digest,json=stdoutDigest,proto3" json:"stdout_digest,omitempty"`
	// The standard error buffer of the action. The server SHOULD NOT inline
	// stderr unless requested by the client in the
	// [GetActionResultRequest][build.bazel.remote.execution.v2.GetActionResultRequest]
	// message. The server MAY omit inlining, even if requested, and MUST do so if inlining
	// would cause the response to exceed message size limits.
	// Clients SHOULD NOT populate this field when uploading to the cache.
	StderrRaw []byte `protobuf:"bytes,7,opt,name=stderr_raw,json=stderrRaw,proto3" json:"stderr_raw,omitempty"`
	// The digest for a blob containing the standard error of the action, which
	// can be retrieved from the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
	StderrDigest *Digest `protobuf:"bytes,8,opt,name=stderr_digest,json=stderrDigest,proto3" json:"stderr_digest,omitempty"`
	// The details of the execution that originally produced this result.
	ExecutionMetadata *ExecutedActionMetadata `protobuf:"bytes,9,opt,name=execution_metadata,json=executionMetadata,proto3" json:"execution_metadata,omitempty"`
}

func (x *ActionResult) Reset() {
	*x = ActionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionResult) ProtoMessage() {}

func (x *ActionResult) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionResult.ProtoReflect.Descriptor instead.
func (*ActionResult) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{11}
}

func (x *ActionResult) GetOutputFiles() []*OutputFile {
	if x != nil {
		return x.OutputFiles
	}
	return nil
}

func (x *ActionResult) GetOutputFileSymlinks() []*OutputSymlink {
	if x != nil {
		return x.OutputFileSymlinks
	}
	return nil
}

func (x *ActionResult) GetOutputSymlinks() []*OutputSymlink {
	if x != nil {
		return x.OutputSymlinks
	}
	return nil
}

func (x *ActionResult) GetOutputDirectories() []*OutputDirectory {
	if x != nil {
		return x.OutputDirectories
	}
	return nil
}

func (x *ActionResult) GetOutputDirectorySymlinks() []*OutputSymlink {
	if x != nil {
		return x.OutputDirectorySymlinks
	}
	return nil
}

func (x *ActionResult) GetExitCode() int32 {
	if x != nil {
		return x.ExitCode
	}
	return 0
}

func (x *ActionResult) GetStdoutRaw() []byte {
	if x != nil {
		return x.StdoutRaw
	}
	return nil
}

func (x *ActionResult) GetStdoutDigest() *Digest {
	if x != nil {
		return x.StdoutDigest
	}
	return nil
}

func (x *ActionResult) GetStderrRaw() []byte {
	if x != nil {
		return x.StderrRaw
	}
	return nil
}

func (x *ActionResult) GetStderrDigest() *Digest {
	if x != nil {
		return x.StderrDigest
	}
	return nil
}

func (x *ActionResult) GetExecutionMetadata() *ExecutedActionMetadata {
	if x != nil {
		return x.ExecutionMetadata
	}
	return nil
}

// An `OutputFile` is similar to a
// [FileNode][build.bazel.remote.execution.v2.FileNode], but it is used as an
// output in an `ActionResult`. It allows a full file path rather than
// only a name.
type OutputFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full path of the file relative to the working directory, including the
	// filename. The path separator is a forward slash `/`. Since this is a
	// relative path, it MUST NOT begin with a leading forward slash.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// The digest of the file's content.
	Digest *Digest `protobuf:"bytes,2,opt,name=digest,proto3" json:"digest,omitempty"`
	// True if file is executable, false otherwise.
	IsExecutable bool `protobuf:"varint,4,opt,name=is_executable,json=isExecutable,proto3" json:"is_executable,omitempty"`
	// The contents of the file if inlining was requested. The server SHOULD NOT inline
	// file contents unless requested by the client in the
	// [GetActionResultRequest][build.bazel.remote.execution.v2.GetActionResultRequest]
	// message. The server MAY omit inlining, even if requested, and MUST do so if inlining
	// would cause the response to exceed message size limits.
	// Clients SHOULD NOT populate this field when uploading to the cache.
	Contents       []byte          `protobuf:"bytes,5,opt,name=contents,proto3" json:"contents,omitempty"`
	NodeProperties *NodeProperties `protobuf:"bytes,7,opt,name=node_properties,json=nodeProperties,proto3" json:"node_properties,omitempty"`
}

func (x *OutputFile) Reset() {
	*x = OutputFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputFile) ProtoMessage() {}

func (x *OutputFile) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputFile.ProtoReflect.Descriptor instead.
func (*OutputFile) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{12}
}

func (x *OutputFile) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *OutputFile) GetDigest() *Digest {
	if x != nil {
		return x.Digest
	}
	return nil
}

func (x *OutputFile) GetIsExecutable() bool {
	if x != nil {
		return x.IsExecutable
	}
	return false
}

func (x *OutputFile) GetContents() []byte {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *OutputFile) GetNodeProperties() *NodeProperties {
	if x != nil {
		return x.NodeProperties
	}
	return nil
}

// A `Tree` contains all the
// [Directory][build.bazel.remote.execution.v2.Directory] protos in a
// single directory Merkle tree, compressed into one message.
type Tree struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The root directory in the tree.
	Root *Directory `protobuf:"bytes,1,opt,name=root,proto3" json:"root,omitempty"`
	// All the child directories: the directories referred to by the root and,
	// recursively, all its children. In order to reconstruct the directory tree,
	// the client must take the digests of each of the child directories and then
	// build up a tree starting from the `root`.
	Children []*Directory `protobuf:"bytes,2,rep,name=children,proto3" json:"children,omitempty"`
}

func (x *Tree) Reset() {
	*x = Tree{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tree) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tree) ProtoMessage() {}

func (x *Tree) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tree.ProtoReflect.Descriptor instead.
func (*Tree) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{13}
}

func (x *Tree) GetRoot() *Directory {
	if x != nil {
		return x.Root
	}
	return nil
}

func (x *Tree) GetChildren() []*Directory {
	if x != nil {
		return x.Children
	}
	return nil
}

// An `OutputDirectory` is the output in an `ActionResult` corresponding to a
// directory's full contents rather than a single file.
type OutputDirectory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full path of the directory relative to the working directory. The path
	// separator is a forward slash `/`. Since this is a relative path, it MUST
	// NOT begin with a leading forward slash. The empty string value is allowed,
	// and it denotes the entire working directory.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// The digest of the encoded
	// [Tree][build.bazel.remote.execution.v2.Tree] proto containing the
	// directory's contents.
	TreeDigest *Digest `protobuf:"bytes,3,opt,name=tree_digest,json=treeDigest,proto3" json:"tree_digest,omitempty"`
}

func (x *OutputDirectory) Reset() {
	*x = OutputDirectory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputDirectory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputDirectory) ProtoMessage() {}

func (x *OutputDirectory) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputDirectory.ProtoReflect.Descriptor instead.
func (*OutputDirectory) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{14}
}

func (x *OutputDirectory) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *OutputDirectory) GetTreeDigest() *Digest {
	if x != nil {
		return x.TreeDigest
	}
	return nil
}

// An `OutputSymlink` is similar to a
// [Symlink][build.bazel.remote.execution.v2.SymlinkNode], but it is used as an
// output in an `ActionResult`.
//
// `OutputSymlink` is binary-compatible with `SymlinkNode`.
type OutputSymlink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full path of the symlink relative to the working directory, including the
	// filename. The path separator is a forward slash `/`. Since this is a
	// relative path, it MUST NOT begin with a leading forward slash.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// The target path of the symlink. The path separator is a forward slash `/`.
	// The target path can be relative to the parent directory of the symlink or
	// it can be an absolute path starting with `/`. Support for absolute paths
	// can be checked using the [Capabilities][build.bazel.remote.execution.v2.Capabilities]
	// API. `..` components are allowed anywhere in the target path.
	Target         string          `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	NodeProperties *NodeProperties `protobuf:"bytes,4,opt,name=node_properties,json=nodeProperties,proto3" json:"node_properties,omitempty"`
}

func (x *OutputSymlink) Reset() {
	*x = OutputSymlink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputSymlink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputSymlink) ProtoMessage() {}

func (x *OutputSymlink) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputSymlink.ProtoReflect.Descriptor instead.
func (*OutputSymlink) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{15}
}

func (x *OutputSymlink) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *OutputSymlink) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OutputSymlink) GetNodeProperties() *NodeProperties {
	if x != nil {
		return x.NodeProperties
	}
	return nil
}

// An `ExecutionPolicy` can be used to control the scheduling of the action.
type ExecutionPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The priority (relative importance) of this action. Generally, a lower value
	// means that the action should be run sooner than actions having a greater
	// priority value, but the interpretation of a given value is server-
	// dependent. A priority of 0 means the *default* priority. Priorities may be
	// positive or negative, and such actions should run later or sooner than
	// actions having the default priority, respectively. The particular semantics
	// of this field is up to the server. In particular, every server will have
	// their own supported range of priorities, and will decide how these map into
	// scheduling policy.
	Priority int32 `protobuf:"varint,1,opt,name=priority,proto3" json:"priority,omitempty"`
}

func (x *ExecutionPolicy) Reset() {
	*x = ExecutionPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionPolicy) ProtoMessage() {}

func (x *ExecutionPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionPolicy.ProtoReflect.Descriptor instead.
func (*ExecutionPolicy) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{16}
}

func (x *ExecutionPolicy) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

// A `ResultsCachePolicy` is used for fine-grained control over how action
// outputs are stored in the CAS and Action Cache.
type ResultsCachePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The priority (relative importance) of this content in the overall cache.
	// Generally, a lower value means a longer retention time or other advantage,
	// but the interpretation of a given value is server-dependent. A priority of
	// 0 means a *default* value, decided by the server.
	//
	// The particular semantics of this field is up to the server. In particular,
	// every server will have their own supported range of priorities, and will
	// decide how these map into retention/eviction policy.
	Priority int32 `protobuf:"varint,1,opt,name=priority,proto3" json:"priority,omitempty"`
}

func (x *ResultsCachePolicy) Reset() {
	*x = ResultsCachePolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResultsCachePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResultsCachePolicy) ProtoMessage() {}

func (x *ResultsCachePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResultsCachePolicy.ProtoReflect.Descriptor instead.
func (*ResultsCachePolicy) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{17}
}

func (x *ResultsCachePolicy) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

// A request message for
// [Execution.Execute][build.bazel.remote.execution.v2.Execution.Execute].
type ExecuteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// If true, the action will be executed even if its result is already
	// present in the [ActionCache][build.bazel.remote.execution.v2.ActionCache].
	// The execution is still allowed to be merged with other in-flight executions
	// of the same action, however - semantically, the service MUST only guarantee
	// that the results of an execution with this field set were not visible
	// before the corresponding execution request was sent.
	// Note that actions from execution requests setting this field set are still
	// eligible to be entered into the action cache upon completion, and services
	// SHOULD overwrite any existing entries that may exist. This allows
	// skip_cache_lookup requests to be used as a mechanism for replacing action
	// cache entries that reference outputs no longer available or that are
	// poisoned in any way.
	// If false, the result may be served from the action cache.
	SkipCacheLookup bool `protobuf:"varint,3,opt,name=skip_cache_lookup,json=skipCacheLookup,proto3" json:"skip_cache_lookup,omitempty"`
	// The digest of the [Action][build.bazel.remote.execution.v2.Action] to
	// execute.
	ActionDigest *Digest `protobuf:"bytes,6,opt,name=action_digest,json=actionDigest,proto3" json:"action_digest,omitempty"`
	// An optional policy for execution of the action.
	// The server will have a default policy if this is not provided.
	ExecutionPolicy *ExecutionPolicy `protobuf:"bytes,7,opt,name=execution_policy,json=executionPolicy,proto3" json:"execution_policy,omitempty"`
	// An optional policy for the results of this execution in the remote cache.
	// The server will have a default policy if this is not provided.
	// This may be applied to both the ActionResult and the associated blobs.
	ResultsCachePolicy *ResultsCachePolicy `protobuf:"bytes,8,opt,name=results_cache_policy,json=resultsCachePolicy,proto3" json:"results_cache_policy,omitempty"`
}

func (x *ExecuteRequest) Reset() {
	*x = ExecuteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteRequest) ProtoMessage() {}

func (x *ExecuteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteRequest.ProtoReflect.Descriptor instead.
func (*ExecuteRequest) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{18}
}

func (x *ExecuteRequest) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *ExecuteRequest) GetSkipCacheLookup() bool {
	if x != nil {
		return x.SkipCacheLookup
	}
	return false
}

func (x *ExecuteRequest) GetActionDigest() *Digest {
	if x != nil {
		return x.ActionDigest
	}
	return nil
}

func (x *ExecuteRequest) GetExecutionPolicy() *ExecutionPolicy {
	if x != nil {
		return x.ExecutionPolicy
	}
	return nil
}

func (x *ExecuteRequest) GetResultsCachePolicy() *ResultsCachePolicy {
	if x != nil {
		return x.ResultsCachePolicy
	}
	return nil
}

// A `LogFile` is a log stored in the CAS.
type LogFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The digest of the log contents.
	Digest *Digest `protobuf:"bytes,1,opt,name=digest,proto3" json:"digest,omitempty"`
	// This is a hint as to the purpose of the log, and is set to true if the log
	// is human-readable text that can be usefully displayed to a user, and false
	// otherwise. For instance, if a command-line client wishes to print the
	// server logs to the terminal for a failed action, this allows it to avoid
	// displaying a binary file.
	HumanReadable bool `protobuf:"varint,2,opt,name=human_readable,json=humanReadable,proto3" json:"human_readable,omitempty"`
}

func (x *LogFile) Reset() {
	*x = LogFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogFile) ProtoMessage() {}

func (x *LogFile) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogFile.ProtoReflect.Descriptor instead.
func (*LogFile) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{19}
}

func (x *LogFile) GetDigest() *Digest {
	if x != nil {
		return x.Digest
	}
	return nil
}

func (x *LogFile) GetHumanReadable() bool {
	if x != nil {
		return x.HumanReadable
	}
	return false
}

// The response message for
// [Execution.Execute][build.bazel.remote.execution.v2.Execution.Execute],
// which will be contained in the [response
// field][google.longrunning.Operation.response] of the
// [Operation][google.longrunning.Operation].
type ExecuteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result of the action.
	Result *ActionResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	// True if the result was served from cache, false if it was executed.
	CachedResult bool `protobuf:"varint,2,opt,name=cached_result,json=cachedResult,proto3" json:"cached_result,omitempty"`
	// If the status has a code other than `OK`, it indicates that the action did
	// not finish execution. For example, if the operation times out during
	// execution, the status will have a `DEADLINE_EXCEEDED` code. Servers MUST
	// use this field for errors in execution, rather than the error field on the
	// `Operation` object.
	//
	// If the status code is other than `OK`, then the result MUST NOT be cached.
	// For an error status, the `result` field is optional; the server may
	// populate the output-, stdout-, and stderr-related fields if it has any
	// information available, such as the stdout and stderr of a timed-out action.
	Status *status.Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	// An optional list of additional log outputs the server wishes to provide. A
	// server can use this to return execution-specific logs however it wishes.
	// This is intended primarily to make it easier for users to debug issues that
	// may be outside of the actual job execution, such as by identifying the
	// worker executing the action or by providing logs from the worker's setup
	// phase. The keys SHOULD be human readable so that a client can display them
	// to a user.
	ServerLogs map[string]*LogFile `protobuf:"bytes,4,rep,name=server_logs,json=serverLogs,proto3" json:"server_logs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Freeform informational message with details on the execution of the action
	// that may be displayed to the user upon failure or when requested explicitly.
	Message string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *ExecuteResponse) Reset() {
	*x = ExecuteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteResponse) ProtoMessage() {}

func (x *ExecuteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteResponse.ProtoReflect.Descriptor instead.
func (*ExecuteResponse) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{20}
}

func (x *ExecuteResponse) GetResult() *ActionResult {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *ExecuteResponse) GetCachedResult() bool {
	if x != nil {
		return x.CachedResult
	}
	return false
}

func (x *ExecuteResponse) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *ExecuteResponse) GetServerLogs() map[string]*LogFile {
	if x != nil {
		return x.ServerLogs
	}
	return nil
}

func (x *ExecuteResponse) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// The current stage of action execution.
//
// Even though these stages are numbered according to the order in which
// they generally occur, there is no requirement that the remote
// execution system reports events along this order. For example, an
// operation MAY transition from the EXECUTING stage back to QUEUED
// in case the hardware on which the operation executes fails.
//
// If and only if the remote execution system reports that an operation
// has reached the COMPLETED stage, it MUST set the [done
// field][google.longrunning.Operation.done] of the
// [Operation][google.longrunning.Operation] and terminate the stream.
type ExecutionStage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExecutionStage) Reset() {
	*x = ExecutionStage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionStage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionStage) ProtoMessage() {}

func (x *ExecutionStage) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionStage.ProtoReflect.Descriptor instead.
func (*ExecutionStage) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{21}
}

// Metadata about an ongoing
// [execution][build.bazel.remote.execution.v2.Execution.Execute], which
// will be contained in the [metadata
// field][google.longrunning.Operation.response] of the
// [Operation][google.longrunning.Operation].
type ExecuteOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current stage of execution.
	Stage ExecutionStage_Value `protobuf:"varint,1,opt,name=stage,proto3,enum=build.bazel.remote.execution.v2.ExecutionStage_Value" json:"stage,omitempty"`
	// The digest of the [Action][build.bazel.remote.execution.v2.Action]
	// being executed.
	ActionDigest *Digest `protobuf:"bytes,2,opt,name=action_digest,json=actionDigest,proto3" json:"action_digest,omitempty"`
	// If set, the client can use this resource name with
	// [ByteStream.Read][google.bytestream.ByteStream.Read] to stream the
	// standard output from the endpoint hosting streamed responses.
	StdoutStreamName string `protobuf:"bytes,3,opt,name=stdout_stream_name,json=stdoutStreamName,proto3" json:"stdout_stream_name,omitempty"`
	// If set, the client can use this resource name with
	// [ByteStream.Read][google.bytestream.ByteStream.Read] to stream the
	// standard error from the endpoint hosting streamed responses.
	StderrStreamName string `protobuf:"bytes,4,opt,name=stderr_stream_name,json=stderrStreamName,proto3" json:"stderr_stream_name,omitempty"`
}

func (x *ExecuteOperationMetadata) Reset() {
	*x = ExecuteOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteOperationMetadata) ProtoMessage() {}

func (x *ExecuteOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteOperationMetadata.ProtoReflect.Descriptor instead.
func (*ExecuteOperationMetadata) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{22}
}

func (x *ExecuteOperationMetadata) GetStage() ExecutionStage_Value {
	if x != nil {
		return x.Stage
	}
	return ExecutionStage_UNKNOWN
}

func (x *ExecuteOperationMetadata) GetActionDigest() *Digest {
	if x != nil {
		return x.ActionDigest
	}
	return nil
}

func (x *ExecuteOperationMetadata) GetStdoutStreamName() string {
	if x != nil {
		return x.StdoutStreamName
	}
	return ""
}

func (x *ExecuteOperationMetadata) GetStderrStreamName() string {
	if x != nil {
		return x.StderrStreamName
	}
	return ""
}

// A request message for
// [WaitExecution][build.bazel.remote.execution.v2.Execution.WaitExecution].
type WaitExecutionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the [Operation][google.longrunning.Operation]
	// returned by [Execute][build.bazel.remote.execution.v2.Execution.Execute].
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *WaitExecutionRequest) Reset() {
	*x = WaitExecutionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WaitExecutionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WaitExecutionRequest) ProtoMessage() {}

func (x *WaitExecutionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WaitExecutionRequest.ProtoReflect.Descriptor instead.
func (*WaitExecutionRequest) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{23}
}

func (x *WaitExecutionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request message for
// [ActionCache.GetActionResult][build.bazel.remote.execution.v2.ActionCache.GetActionResult].
type GetActionResultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The digest of the [Action][build.bazel.remote.execution.v2.Action]
	// whose result is requested.
	ActionDigest *Digest `protobuf:"bytes,2,opt,name=action_digest,json=actionDigest,proto3" json:"action_digest,omitempty"`
	// A hint to the server to request inlining stdout in the
	// [ActionResult][build.bazel.remote.execution.v2.ActionResult] message.
	InlineStdout bool `protobuf:"varint,3,opt,name=inline_stdout,json=inlineStdout,proto3" json:"inline_stdout,omitempty"`
	// A hint to the server to request inlining stderr in the
	// [ActionResult][build.bazel.remote.execution.v2.ActionResult] message.
	InlineStderr bool `protobuf:"varint,4,opt,name=inline_stderr,json=inlineStderr,proto3" json:"inline_stderr,omitempty"`
	// A hint to the server to inline the contents of the listed output files.
	// Each path needs to exactly match one file path in either `output_paths` or
	// `output_files` (DEPRECATED since v2.1) in the
	// [Command][build.bazel.remote.execution.v2.Command] message.
	InlineOutputFiles []string `protobuf:"bytes,5,rep,name=inline_output_files,json=inlineOutputFiles,proto3" json:"inline_output_files,omitempty"`
}

func (x *GetActionResultRequest) Reset() {
	*x = GetActionResultRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetActionResultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetActionResultRequest) ProtoMessage() {}

func (x *GetActionResultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetActionResultRequest.ProtoReflect.Descriptor instead.
func (*GetActionResultRequest) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{24}
}

func (x *GetActionResultRequest) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *GetActionResultRequest) GetActionDigest() *Digest {
	if x != nil {
		return x.ActionDigest
	}
	return nil
}

func (x *GetActionResultRequest) GetInlineStdout() bool {
	if x != nil {
		return x.InlineStdout
	}
	return false
}

func (x *GetActionResultRequest) GetInlineStderr() bool {
	if x != nil {
		return x.InlineStderr
	}
	return false
}

func (x *GetActionResultRequest) GetInlineOutputFiles() []string {
	if x != nil {
		return x.InlineOutputFiles
	}
	return nil
}

// A request message for
// [ActionCache.UpdateActionResult][build.bazel.remote.execution.v2.ActionCache.UpdateActionResult].
type UpdateActionResultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The digest of the [Action][build.bazel.remote.execution.v2.Action]
	// whose result is being uploaded.
	ActionDigest *Digest `protobuf:"bytes,2,opt,name=action_digest,json=actionDigest,proto3" json:"action_digest,omitempty"`
	// The [ActionResult][build.bazel.remote.execution.v2.ActionResult]
	// to store in the cache.
	ActionResult *ActionResult `protobuf:"bytes,3,opt,name=action_result,json=actionResult,proto3" json:"action_result,omitempty"`
	// An optional policy for the results of this execution in the remote cache.
	// The server will have a default policy if this is not provided.
	// This may be applied to both the ActionResult and the associated blobs.
	ResultsCachePolicy *ResultsCachePolicy `protobuf:"bytes,4,opt,name=results_cache_policy,json=resultsCachePolicy,proto3" json:"results_cache_policy,omitempty"`
}

func (x *UpdateActionResultRequest) Reset() {
	*x = UpdateActionResultRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateActionResultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateActionResultRequest) ProtoMessage() {}

func (x *UpdateActionResultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateActionResultRequest.ProtoReflect.Descriptor instead.
func (*UpdateActionResultRequest) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{25}
}

func (x *UpdateActionResultRequest) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *UpdateActionResultRequest) GetActionDigest() *Digest {
	if x != nil {
		return x.ActionDigest
	}
	return nil
}

func (x *UpdateActionResultRequest) GetActionResult() *ActionResult {
	if x != nil {
		return x.ActionResult
	}
	return nil
}

func (x *UpdateActionResultRequest) GetResultsCachePolicy() *ResultsCachePolicy {
	if x != nil {
		return x.ResultsCachePolicy
	}
	return nil
}

// A request message for
// [ContentAddressableStorage.FindMissingBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.FindMissingBlobs].
type FindMissingBlobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// A list of the blobs to check.
	BlobDigests []*Digest `protobuf:"bytes,2,rep,name=blob_digests,json=blobDigests,proto3" json:"blob_digests,omitempty"`
}

func (x *FindMissingBlobsRequest) Reset() {
	*x = FindMissingBlobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FindMissingBlobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindMissingBlobsRequest) ProtoMessage() {}

func (x *FindMissingBlobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindMissingBlobsRequest.ProtoReflect.Descriptor instead.
func (*FindMissingBlobsRequest) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{26}
}

func (x *FindMissingBlobsRequest) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *FindMissingBlobsRequest) GetBlobDigests() []*Digest {
	if x != nil {
		return x.BlobDigests
	}
	return nil
}

// A response message for
// [ContentAddressableStorage.FindMissingBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.FindMissingBlobs].
type FindMissingBlobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of the blobs requested *not* present in the storage.
	MissingBlobDigests []*Digest `protobuf:"bytes,2,rep,name=missing_blob_digests,json=missingBlobDigests,proto3" json:"missing_blob_digests,omitempty"`
}

func (x *FindMissingBlobsResponse) Reset() {
	*x = FindMissingBlobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FindMissingBlobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindMissingBlobsResponse) ProtoMessage() {}

func (x *FindMissingBlobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindMissingBlobsResponse.ProtoReflect.Descriptor instead.
func (*FindMissingBlobsResponse) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{27}
}

func (x *FindMissingBlobsResponse) GetMissingBlobDigests() []*Digest {
	if x != nil {
		return x.MissingBlobDigests
	}
	return nil
}

// A request message for
// [ContentAddressableStorage.BatchUpdateBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.BatchUpdateBlobs].
type BatchUpdateBlobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The individual upload requests.
	Requests []*BatchUpdateBlobsRequest_Request `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchUpdateBlobsRequest) Reset() {
	*x = BatchUpdateBlobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateBlobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateBlobsRequest) ProtoMessage() {}

func (x *BatchUpdateBlobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateBlobsRequest.ProtoReflect.Descriptor instead.
func (*BatchUpdateBlobsRequest) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{28}
}

func (x *BatchUpdateBlobsRequest) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *BatchUpdateBlobsRequest) GetRequests() []*BatchUpdateBlobsRequest_Request {
	if x != nil {
		return x.Requests
	}
	return nil
}

// A response message for
// [ContentAddressableStorage.BatchUpdateBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.BatchUpdateBlobs].
type BatchUpdateBlobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The responses to the requests.
	Responses []*BatchUpdateBlobsResponse_Response `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
}

func (x *BatchUpdateBlobsResponse) Reset() {
	*x = BatchUpdateBlobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateBlobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateBlobsResponse) ProtoMessage() {}

func (x *BatchUpdateBlobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateBlobsResponse.ProtoReflect.Descriptor instead.
func (*BatchUpdateBlobsResponse) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{29}
}

func (x *BatchUpdateBlobsResponse) GetResponses() []*BatchUpdateBlobsResponse_Response {
	if x != nil {
		return x.Responses
	}
	return nil
}

// A request message for
// [ContentAddressableStorage.BatchReadBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.BatchReadBlobs].
type BatchReadBlobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The individual blob digests.
	Digests []*Digest `protobuf:"bytes,2,rep,name=digests,proto3" json:"digests,omitempty"`
	// A list of acceptable encodings for the returned inlined data, in no
	// particular order. `IDENTITY` is always allowed even if not specified here.
	AcceptableCompressors []Compressor_Value `protobuf:"varint,3,rep,packed,name=acceptable_compressors,json=acceptableCompressors,proto3,enum=build.bazel.remote.execution.v2.Compressor_Value" json:"acceptable_compressors,omitempty"`
}

func (x *BatchReadBlobsRequest) Reset() {
	*x = BatchReadBlobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchReadBlobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchReadBlobsRequest) ProtoMessage() {}

func (x *BatchReadBlobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchReadBlobsRequest.ProtoReflect.Descriptor instead.
func (*BatchReadBlobsRequest) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{30}
}

func (x *BatchReadBlobsRequest) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *BatchReadBlobsRequest) GetDigests() []*Digest {
	if x != nil {
		return x.Digests
	}
	return nil
}

func (x *BatchReadBlobsRequest) GetAcceptableCompressors() []Compressor_Value {
	if x != nil {
		return x.AcceptableCompressors
	}
	return nil
}

// A response message for
// [ContentAddressableStorage.BatchReadBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.BatchReadBlobs].
type BatchReadBlobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The responses to the requests.
	Responses []*BatchReadBlobsResponse_Response `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
}

func (x *BatchReadBlobsResponse) Reset() {
	*x = BatchReadBlobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchReadBlobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchReadBlobsResponse) ProtoMessage() {}

func (x *BatchReadBlobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchReadBlobsResponse.ProtoReflect.Descriptor instead.
func (*BatchReadBlobsResponse) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{31}
}

func (x *BatchReadBlobsResponse) GetResponses() []*BatchReadBlobsResponse_Response {
	if x != nil {
		return x.Responses
	}
	return nil
}

// A request message for
// [ContentAddressableStorage.GetTree][build.bazel.remote.execution.v2.ContentAddressableStorage.GetTree].
type GetTreeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The digest of the root, which must be an encoded
	// [Directory][build.bazel.remote.execution.v2.Directory] message
	// stored in the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
	RootDigest *Digest `protobuf:"bytes,2,opt,name=root_digest,json=rootDigest,proto3" json:"root_digest,omitempty"`
	// A maximum page size to request. If present, the server will request no more
	// than this many items. Regardless of whether a page size is specified, the
	// server may place its own limit on the number of items to be returned and
	// require the client to retrieve more items using a subsequent request.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, which must be a value received in a previous
	// [GetTreeResponse][build.bazel.remote.execution.v2.GetTreeResponse].
	// If present, the server will use that token as an offset, returning only
	// that page and the ones that succeed it.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *GetTreeRequest) Reset() {
	*x = GetTreeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTreeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTreeRequest) ProtoMessage() {}

func (x *GetTreeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTreeRequest.ProtoReflect.Descriptor instead.
func (*GetTreeRequest) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{32}
}

func (x *GetTreeRequest) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *GetTreeRequest) GetRootDigest() *Digest {
	if x != nil {
		return x.RootDigest
	}
	return nil
}

func (x *GetTreeRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *GetTreeRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// A response message for
// [ContentAddressableStorage.GetTree][build.bazel.remote.execution.v2.ContentAddressableStorage.GetTree].
type GetTreeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The directories descended from the requested root.
	Directories []*Directory `protobuf:"bytes,1,rep,name=directories,proto3" json:"directories,omitempty"`
	// If present, signifies that there are more results which the client can
	// retrieve by passing this as the page_token in a subsequent
	// [request][build.bazel.remote.execution.v2.GetTreeRequest].
	// If empty, signifies that this is the last page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *GetTreeResponse) Reset() {
	*x = GetTreeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTreeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTreeResponse) ProtoMessage() {}

func (x *GetTreeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTreeResponse.ProtoReflect.Descriptor instead.
func (*GetTreeResponse) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{33}
}

func (x *GetTreeResponse) GetDirectories() []*Directory {
	if x != nil {
		return x.Directories
	}
	return nil
}

func (x *GetTreeResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request message for
// [Capabilities.GetCapabilities][build.bazel.remote.execution.v2.Capabilities.GetCapabilities].
type GetCapabilitiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
}

func (x *GetCapabilitiesRequest) Reset() {
	*x = GetCapabilitiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCapabilitiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCapabilitiesRequest) ProtoMessage() {}

func (x *GetCapabilitiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCapabilitiesRequest.ProtoReflect.Descriptor instead.
func (*GetCapabilitiesRequest) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{34}
}

func (x *GetCapabilitiesRequest) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

// A response message for
// [Capabilities.GetCapabilities][build.bazel.remote.execution.v2.Capabilities.GetCapabilities].
type ServerCapabilities struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Capabilities of the remote cache system.
	CacheCapabilities *CacheCapabilities `protobuf:"bytes,1,opt,name=cache_capabilities,json=cacheCapabilities,proto3" json:"cache_capabilities,omitempty"`
	// Capabilities of the remote execution system.
	ExecutionCapabilities *ExecutionCapabilities `protobuf:"bytes,2,opt,name=execution_capabilities,json=executionCapabilities,proto3" json:"execution_capabilities,omitempty"`
	// Earliest RE API version supported, including deprecated versions.
	DeprecatedApiVersion *semver.SemVer `protobuf:"bytes,3,opt,name=deprecated_api_version,json=deprecatedApiVersion,proto3" json:"deprecated_api_version,omitempty"`
	// Earliest non-deprecated RE API version supported.
	LowApiVersion *semver.SemVer `protobuf:"bytes,4,opt,name=low_api_version,json=lowApiVersion,proto3" json:"low_api_version,omitempty"`
	// Latest RE API version supported.
	HighApiVersion *semver.SemVer `protobuf:"bytes,5,opt,name=high_api_version,json=highApiVersion,proto3" json:"high_api_version,omitempty"`
}

func (x *ServerCapabilities) Reset() {
	*x = ServerCapabilities{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerCapabilities) ProtoMessage() {}

func (x *ServerCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerCapabilities.ProtoReflect.Descriptor instead.
func (*ServerCapabilities) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{35}
}

func (x *ServerCapabilities) GetCacheCapabilities() *CacheCapabilities {
	if x != nil {
		return x.CacheCapabilities
	}
	return nil
}

func (x *ServerCapabilities) GetExecutionCapabilities() *ExecutionCapabilities {
	if x != nil {
		return x.ExecutionCapabilities
	}
	return nil
}

func (x *ServerCapabilities) GetDeprecatedApiVersion() *semver.SemVer {
	if x != nil {
		return x.DeprecatedApiVersion
	}
	return nil
}

func (x *ServerCapabilities) GetLowApiVersion() *semver.SemVer {
	if x != nil {
		return x.LowApiVersion
	}
	return nil
}

func (x *ServerCapabilities) GetHighApiVersion() *semver.SemVer {
	if x != nil {
		return x.HighApiVersion
	}
	return nil
}

// The digest function used for converting values into keys for CAS and Action
// Cache.
type DigestFunction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DigestFunction) Reset() {
	*x = DigestFunction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DigestFunction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DigestFunction) ProtoMessage() {}

func (x *DigestFunction) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DigestFunction.ProtoReflect.Descriptor instead.
func (*DigestFunction) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{36}
}

// Describes the server/instance capabilities for updating the action cache.
type ActionCacheUpdateCapabilities struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UpdateEnabled bool `protobuf:"varint,1,opt,name=update_enabled,json=updateEnabled,proto3" json:"update_enabled,omitempty"`
}

func (x *ActionCacheUpdateCapabilities) Reset() {
	*x = ActionCacheUpdateCapabilities{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionCacheUpdateCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionCacheUpdateCapabilities) ProtoMessage() {}

func (x *ActionCacheUpdateCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionCacheUpdateCapabilities.ProtoReflect.Descriptor instead.
func (*ActionCacheUpdateCapabilities) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{37}
}

func (x *ActionCacheUpdateCapabilities) GetUpdateEnabled() bool {
	if x != nil {
		return x.UpdateEnabled
	}
	return false
}

// Allowed values for priority in
// [ResultsCachePolicy][build.bazel.remoteexecution.v2.ResultsCachePolicy] and
// [ExecutionPolicy][build.bazel.remoteexecution.v2.ResultsCachePolicy]
// Used for querying both cache and execution valid priority ranges.
type PriorityCapabilities struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Priorities []*PriorityCapabilities_PriorityRange `protobuf:"bytes,1,rep,name=priorities,proto3" json:"priorities,omitempty"`
}

func (x *PriorityCapabilities) Reset() {
	*x = PriorityCapabilities{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PriorityCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PriorityCapabilities) ProtoMessage() {}

func (x *PriorityCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PriorityCapabilities.ProtoReflect.Descriptor instead.
func (*PriorityCapabilities) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{38}
}

func (x *PriorityCapabilities) GetPriorities() []*PriorityCapabilities_PriorityRange {
	if x != nil {
		return x.Priorities
	}
	return nil
}

// Describes how the server treats absolute symlink targets.
type SymlinkAbsolutePathStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SymlinkAbsolutePathStrategy) Reset() {
	*x = SymlinkAbsolutePathStrategy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SymlinkAbsolutePathStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SymlinkAbsolutePathStrategy) ProtoMessage() {}

func (x *SymlinkAbsolutePathStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SymlinkAbsolutePathStrategy.ProtoReflect.Descriptor instead.
func (*SymlinkAbsolutePathStrategy) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{39}
}

// Compression formats which may be supported.
type Compressor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Compressor) Reset() {
	*x = Compressor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Compressor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Compressor) ProtoMessage() {}

func (x *Compressor) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Compressor.ProtoReflect.Descriptor instead.
func (*Compressor) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{40}
}

// Capabilities of the remote cache system.
type CacheCapabilities struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All the digest functions supported by the remote cache.
	// Remote cache may support multiple digest functions simultaneously.
	DigestFunctions []DigestFunction_Value `protobuf:"varint,1,rep,packed,name=digest_functions,json=digestFunctions,proto3,enum=build.bazel.remote.execution.v2.DigestFunction_Value" json:"digest_functions,omitempty"`
	// Capabilities for updating the action cache.
	ActionCacheUpdateCapabilities *ActionCacheUpdateCapabilities `protobuf:"bytes,2,opt,name=action_cache_update_capabilities,json=actionCacheUpdateCapabilities,proto3" json:"action_cache_update_capabilities,omitempty"`
	// Supported cache priority range for both CAS and ActionCache.
	CachePriorityCapabilities *PriorityCapabilities `protobuf:"bytes,3,opt,name=cache_priority_capabilities,json=cachePriorityCapabilities,proto3" json:"cache_priority_capabilities,omitempty"`
	// Maximum total size of blobs to be uploaded/downloaded using
	// batch methods. A value of 0 means no limit is set, although
	// in practice there will always be a message size limitation
	// of the protocol in use, e.g. GRPC.
	MaxBatchTotalSizeBytes int64 `protobuf:"varint,4,opt,name=max_batch_total_size_bytes,json=maxBatchTotalSizeBytes,proto3" json:"max_batch_total_size_bytes,omitempty"`
	// Whether absolute symlink targets are supported.
	SymlinkAbsolutePathStrategy SymlinkAbsolutePathStrategy_Value `protobuf:"varint,5,opt,name=symlink_absolute_path_strategy,json=symlinkAbsolutePathStrategy,proto3,enum=build.bazel.remote.execution.v2.SymlinkAbsolutePathStrategy_Value" json:"symlink_absolute_path_strategy,omitempty"`
	// Compressors supported by the "compressed-blobs" bytestream resources.
	// Servers MUST support identity/no-compression, even if it is not listed
	// here.
	//
	// Note that this does not imply which if any compressors are supported by
	// the server at the gRPC level.
	SupportedCompressors []Compressor_Value `protobuf:"varint,6,rep,packed,name=supported_compressors,json=supportedCompressors,proto3,enum=build.bazel.remote.execution.v2.Compressor_Value" json:"supported_compressors,omitempty"`
	// Compressors supported for inlined data in
	// [BatchUpdateBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.BatchUpdateBlobs]
	// requests.
	SupportedBatchUpdateCompressors []Compressor_Value `protobuf:"varint,7,rep,packed,name=supported_batch_update_compressors,json=supportedBatchUpdateCompressors,proto3,enum=build.bazel.remote.execution.v2.Compressor_Value" json:"supported_batch_update_compressors,omitempty"`
}

func (x *CacheCapabilities) Reset() {
	*x = CacheCapabilities{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CacheCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CacheCapabilities) ProtoMessage() {}

func (x *CacheCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CacheCapabilities.ProtoReflect.Descriptor instead.
func (*CacheCapabilities) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{41}
}

func (x *CacheCapabilities) GetDigestFunctions() []DigestFunction_Value {
	if x != nil {
		return x.DigestFunctions
	}
	return nil
}

func (x *CacheCapabilities) GetActionCacheUpdateCapabilities() *ActionCacheUpdateCapabilities {
	if x != nil {
		return x.ActionCacheUpdateCapabilities
	}
	return nil
}

func (x *CacheCapabilities) GetCachePriorityCapabilities() *PriorityCapabilities {
	if x != nil {
		return x.CachePriorityCapabilities
	}
	return nil
}

func (x *CacheCapabilities) GetMaxBatchTotalSizeBytes() int64 {
	if x != nil {
		return x.MaxBatchTotalSizeBytes
	}
	return 0
}

func (x *CacheCapabilities) GetSymlinkAbsolutePathStrategy() SymlinkAbsolutePathStrategy_Value {
	if x != nil {
		return x.SymlinkAbsolutePathStrategy
	}
	return SymlinkAbsolutePathStrategy_UNKNOWN
}

func (x *CacheCapabilities) GetSupportedCompressors() []Compressor_Value {
	if x != nil {
		return x.SupportedCompressors
	}
	return nil
}

func (x *CacheCapabilities) GetSupportedBatchUpdateCompressors() []Compressor_Value {
	if x != nil {
		return x.SupportedBatchUpdateCompressors
	}
	return nil
}

// Capabilities of the remote execution system.
type ExecutionCapabilities struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Remote execution may only support a single digest function.
	DigestFunction DigestFunction_Value `protobuf:"varint,1,opt,name=digest_function,json=digestFunction,proto3,enum=build.bazel.remote.execution.v2.DigestFunction_Value" json:"digest_function,omitempty"`
	// Whether remote execution is enabled for the particular server/instance.
	ExecEnabled bool `protobuf:"varint,2,opt,name=exec_enabled,json=execEnabled,proto3" json:"exec_enabled,omitempty"`
	// Supported execution priority range.
	ExecutionPriorityCapabilities *PriorityCapabilities `protobuf:"bytes,3,opt,name=execution_priority_capabilities,json=executionPriorityCapabilities,proto3" json:"execution_priority_capabilities,omitempty"`
	// Supported node properties.
	SupportedNodeProperties []string `protobuf:"bytes,4,rep,name=supported_node_properties,json=supportedNodeProperties,proto3" json:"supported_node_properties,omitempty"`
}

func (x *ExecutionCapabilities) Reset() {
	*x = ExecutionCapabilities{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionCapabilities) ProtoMessage() {}

func (x *ExecutionCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionCapabilities.ProtoReflect.Descriptor instead.
func (*ExecutionCapabilities) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{42}
}

func (x *ExecutionCapabilities) GetDigestFunction() DigestFunction_Value {
	if x != nil {
		return x.DigestFunction
	}
	return DigestFunction_UNKNOWN
}

func (x *ExecutionCapabilities) GetExecEnabled() bool {
	if x != nil {
		return x.ExecEnabled
	}
	return false
}

func (x *ExecutionCapabilities) GetExecutionPriorityCapabilities() *PriorityCapabilities {
	if x != nil {
		return x.ExecutionPriorityCapabilities
	}
	return nil
}

func (x *ExecutionCapabilities) GetSupportedNodeProperties() []string {
	if x != nil {
		return x.SupportedNodeProperties
	}
	return nil
}

// Details for the tool used to call the API.
type ToolDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the tool, e.g. bazel.
	ToolName string `protobuf:"bytes,1,opt,name=tool_name,json=toolName,proto3" json:"tool_name,omitempty"`
	// Version of the tool used for the request, e.g. 5.0.3.
	ToolVersion string `protobuf:"bytes,2,opt,name=tool_version,json=toolVersion,proto3" json:"tool_version,omitempty"`
}

func (x *ToolDetails) Reset() {
	*x = ToolDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ToolDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolDetails) ProtoMessage() {}

func (x *ToolDetails) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolDetails.ProtoReflect.Descriptor instead.
func (*ToolDetails) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{43}
}

func (x *ToolDetails) GetToolName() string {
	if x != nil {
		return x.ToolName
	}
	return ""
}

func (x *ToolDetails) GetToolVersion() string {
	if x != nil {
		return x.ToolVersion
	}
	return ""
}

// An optional Metadata to attach to any RPC request to tell the server about an
// external context of the request. The server may use this for logging or other
// purposes. To use it, the client attaches the header to the call using the
// canonical proto serialization:
//
// * name: `build.bazel.remote.execution.v2.requestmetadata-bin`
// * contents: the base64 encoded binary `RequestMetadata` message.
// Note: the gRPC library serializes binary headers encoded in base 64 by
// default (https://github.com/grpc/grpc/blob/master/doc/PROTOCOL-HTTP2.md#requests).
// Therefore, if the gRPC library is used to pass/retrieve this
// metadata, the user may ignore the base64 encoding and assume it is simply
// serialized as a binary message.
type RequestMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The details for the tool invoking the requests.
	ToolDetails *ToolDetails `protobuf:"bytes,1,opt,name=tool_details,json=toolDetails,proto3" json:"tool_details,omitempty"`
	// An identifier that ties multiple requests to the same action.
	// For example, multiple requests to the CAS, Action Cache, and Execution
	// API are used in order to compile foo.cc.
	ActionId string `protobuf:"bytes,2,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	// An identifier that ties multiple actions together to a final result.
	// For example, multiple actions are required to build and run foo_test.
	ToolInvocationId string `protobuf:"bytes,3,opt,name=tool_invocation_id,json=toolInvocationId,proto3" json:"tool_invocation_id,omitempty"`
	// An identifier to tie multiple tool invocations together. For example,
	// runs of foo_test, bar_test and baz_test on a post-submit of a given patch.
	CorrelatedInvocationsId string `protobuf:"bytes,4,opt,name=correlated_invocations_id,json=correlatedInvocationsId,proto3" json:"correlated_invocations_id,omitempty"`
	// A brief description of the kind of action, for example, CppCompile or GoLink.
	// There is no standard agreed set of values for this, and they are expected to vary between different client tools.
	ActionMnemonic string `protobuf:"bytes,5,opt,name=action_mnemonic,json=actionMnemonic,proto3" json:"action_mnemonic,omitempty"`
	// An identifier for the target which produced this action.
	// No guarantees are made around how many actions may relate to a single target.
	TargetId string `protobuf:"bytes,6,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// An identifier for the configuration in which the target was built,
	// e.g. for differentiating building host tools or different target platforms.
	// There is no expectation that this value will have any particular structure,
	// or equality across invocations, though some client tools may offer these guarantees.
	ConfigurationId string `protobuf:"bytes,7,opt,name=configuration_id,json=configurationId,proto3" json:"configuration_id,omitempty"`
}

func (x *RequestMetadata) Reset() {
	*x = RequestMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestMetadata) ProtoMessage() {}

func (x *RequestMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestMetadata.ProtoReflect.Descriptor instead.
func (*RequestMetadata) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{44}
}

func (x *RequestMetadata) GetToolDetails() *ToolDetails {
	if x != nil {
		return x.ToolDetails
	}
	return nil
}

func (x *RequestMetadata) GetActionId() string {
	if x != nil {
		return x.ActionId
	}
	return ""
}

func (x *RequestMetadata) GetToolInvocationId() string {
	if x != nil {
		return x.ToolInvocationId
	}
	return ""
}

func (x *RequestMetadata) GetCorrelatedInvocationsId() string {
	if x != nil {
		return x.CorrelatedInvocationsId
	}
	return ""
}

func (x *RequestMetadata) GetActionMnemonic() string {
	if x != nil {
		return x.ActionMnemonic
	}
	return ""
}

func (x *RequestMetadata) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *RequestMetadata) GetConfigurationId() string {
	if x != nil {
		return x.ConfigurationId
	}
	return ""
}

// An `EnvironmentVariable` is one variable to set in the running program's
// environment.
type Command_EnvironmentVariable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The variable name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The variable value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Command_EnvironmentVariable) Reset() {
	*x = Command_EnvironmentVariable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Command_EnvironmentVariable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Command_EnvironmentVariable) ProtoMessage() {}

func (x *Command_EnvironmentVariable) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Command_EnvironmentVariable.ProtoReflect.Descriptor instead.
func (*Command_EnvironmentVariable) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Command_EnvironmentVariable) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Command_EnvironmentVariable) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// A single property for the environment. The server is responsible for
// specifying the property `name`s that it accepts. If an unknown `name` is
// provided in the requirements for an
// [Action][build.bazel.remote.execution.v2.Action], the server SHOULD
// reject the execution request. If permitted by the server, the same `name`
// may occur multiple times.
//
// The server is also responsible for specifying the interpretation of
// property `value`s. For instance, a property describing how much RAM must be
// available may be interpreted as allowing a worker with 16GB to fulfill a
// request for 8GB, while a property describing the OS environment on which
// the action must be performed may require an exact match with the worker's
// OS.
//
// The server MAY use the `value` of one or more properties to determine how
// it sets up the execution environment, such as by making specific system
// files available to the worker.
//
// Both names and values are typically case-sensitive. Note that the platform
// is implicitly part of the action digest, so even tiny changes in the names
// or values (like changing case) may result in different action cache
// entries.
type Platform_Property struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The property name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The property value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Platform_Property) Reset() {
	*x = Platform_Property{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Platform_Property) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Platform_Property) ProtoMessage() {}

func (x *Platform_Property) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Platform_Property.ProtoReflect.Descriptor instead.
func (*Platform_Property) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{2, 0}
}

func (x *Platform_Property) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Platform_Property) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// A request corresponding to a single blob that the client wants to upload.
type BatchUpdateBlobsRequest_Request struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The digest of the blob. This MUST be the digest of `data`.
	Digest *Digest `protobuf:"bytes,1,opt,name=digest,proto3" json:"digest,omitempty"`
	// The raw binary data.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	// The format of `data`. Must be `IDENTITY`/unspecified, or one of the
	// compressors advertised by the
	// [CacheCapabilities.supported_batch_compressors][build.bazel.remote.execution.v2.CacheCapabilities.supported_batch_compressors]
	// field.
	Compressor Compressor_Value `protobuf:"varint,3,opt,name=compressor,proto3,enum=build.bazel.remote.execution.v2.Compressor_Value" json:"compressor,omitempty"`
}

func (x *BatchUpdateBlobsRequest_Request) Reset() {
	*x = BatchUpdateBlobsRequest_Request{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateBlobsRequest_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateBlobsRequest_Request) ProtoMessage() {}

func (x *BatchUpdateBlobsRequest_Request) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateBlobsRequest_Request.ProtoReflect.Descriptor instead.
func (*BatchUpdateBlobsRequest_Request) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{28, 0}
}

func (x *BatchUpdateBlobsRequest_Request) GetDigest() *Digest {
	if x != nil {
		return x.Digest
	}
	return nil
}

func (x *BatchUpdateBlobsRequest_Request) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *BatchUpdateBlobsRequest_Request) GetCompressor() Compressor_Value {
	if x != nil {
		return x.Compressor
	}
	return Compressor_IDENTITY
}

// A response corresponding to a single blob that the client tried to upload.
type BatchUpdateBlobsResponse_Response struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The blob digest to which this response corresponds.
	Digest *Digest `protobuf:"bytes,1,opt,name=digest,proto3" json:"digest,omitempty"`
	// The result of attempting to upload that blob.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *BatchUpdateBlobsResponse_Response) Reset() {
	*x = BatchUpdateBlobsResponse_Response{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateBlobsResponse_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateBlobsResponse_Response) ProtoMessage() {}

func (x *BatchUpdateBlobsResponse_Response) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateBlobsResponse_Response.ProtoReflect.Descriptor instead.
func (*BatchUpdateBlobsResponse_Response) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{29, 0}
}

func (x *BatchUpdateBlobsResponse_Response) GetDigest() *Digest {
	if x != nil {
		return x.Digest
	}
	return nil
}

func (x *BatchUpdateBlobsResponse_Response) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// A response corresponding to a single blob that the client tried to download.
type BatchReadBlobsResponse_Response struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The digest to which this response corresponds.
	Digest *Digest `protobuf:"bytes,1,opt,name=digest,proto3" json:"digest,omitempty"`
	// The raw binary data.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	// The format the data is encoded in. MUST be `IDENTITY`/unspecified,
	// or one of the acceptable compressors specified in the `BatchReadBlobsRequest`.
	Compressor Compressor_Value `protobuf:"varint,4,opt,name=compressor,proto3,enum=build.bazel.remote.execution.v2.Compressor_Value" json:"compressor,omitempty"`
	// The result of attempting to download that blob.
	Status *status.Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *BatchReadBlobsResponse_Response) Reset() {
	*x = BatchReadBlobsResponse_Response{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchReadBlobsResponse_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchReadBlobsResponse_Response) ProtoMessage() {}

func (x *BatchReadBlobsResponse_Response) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchReadBlobsResponse_Response.ProtoReflect.Descriptor instead.
func (*BatchReadBlobsResponse_Response) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{31, 0}
}

func (x *BatchReadBlobsResponse_Response) GetDigest() *Digest {
	if x != nil {
		return x.Digest
	}
	return nil
}

func (x *BatchReadBlobsResponse_Response) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *BatchReadBlobsResponse_Response) GetCompressor() Compressor_Value {
	if x != nil {
		return x.Compressor
	}
	return Compressor_IDENTITY
}

func (x *BatchReadBlobsResponse_Response) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// Supported range of priorities, including boundaries.
type PriorityCapabilities_PriorityRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum numeric value for this priority range, which represents the
	// most urgent task or longest retained item.
	MinPriority int32 `protobuf:"varint,1,opt,name=min_priority,json=minPriority,proto3" json:"min_priority,omitempty"`
	// The maximum numeric value for this priority range, which represents the
	// least urgent task or shortest retained item.
	MaxPriority int32 `protobuf:"varint,2,opt,name=max_priority,json=maxPriority,proto3" json:"max_priority,omitempty"`
}

func (x *PriorityCapabilities_PriorityRange) Reset() {
	*x = PriorityCapabilities_PriorityRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PriorityCapabilities_PriorityRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PriorityCapabilities_PriorityRange) ProtoMessage() {}

func (x *PriorityCapabilities_PriorityRange) ProtoReflect() protoreflect.Message {
	mi := &file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PriorityCapabilities_PriorityRange.ProtoReflect.Descriptor instead.
func (*PriorityCapabilities_PriorityRange) Descriptor() ([]byte, []int) {
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP(), []int{38, 0}
}

func (x *PriorityCapabilities_PriorityRange) GetMinPriority() int32 {
	if x != nil {
		return x.MinPriority
	}
	return 0
}

func (x *PriorityCapabilities_PriorityRange) GetMaxPriority() int32 {
	if x != nil {
		return x.MaxPriority
	}
	return 0
}

var File_build_bazel_remote_execution_v2_remote_execution_proto protoreflect.FileDescriptor

var file_build_bazel_remote_execution_v2_remote_execution_proto_rawDesc = []byte{
	0x0a, 0x36, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2f, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76,
	0x32, 0x2f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2f, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2f, 0x73, 0x65, 0x6d, 0x76, 0x65, 0x72, 0x2f, 0x73, 0x65,
	0x6d, 0x76, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61,
	0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70,
	0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xeb, 0x02, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a,
	0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61,
	0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x0d,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a,
	0x11, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x67, 0x65,
	0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x52, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x67, 0x65,
	0x73, 0x74, 0x12, 0x33, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x20, 0x0a, 0x0c, 0x64, 0x6f, 0x5f, 0x6e, 0x6f,
	0x74, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64,
	0x6f, 0x4e, 0x6f, 0x74, 0x43, 0x61, 0x63, 0x68, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x61, 0x6c,
	0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x73, 0x61, 0x6c, 0x74, 0x12, 0x45, 0x0a,
	0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x06, 0x4a, 0x04, 0x08, 0x08, 0x10, 0x09,
	0x22, 0xfa, 0x03, 0x0a, 0x07, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x1c, 0x0a, 0x09,
	0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x71, 0x0a, 0x15, 0x65, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x14, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x21, 0x0a,
	0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x73,
	0x12, 0x2d, 0x0a, 0x12, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12,
	0x21, 0x0a, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x50, 0x61, 0x74,
	0x68, 0x73, 0x12, 0x45, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a,
	0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x52,
	0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x2b, 0x0a, 0x11, 0x77, 0x6f, 0x72,
	0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x34, 0x0a, 0x16, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x3f, 0x0a, 0x13,
	0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61,
	0x62, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x94, 0x01,
	0x0a, 0x08, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x52, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x34,
	0x0a, 0x08, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0xc8, 0x02, 0x0a, 0x09, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x12, 0x3f, 0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e,
	0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x05, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x12, 0x50, 0x0a, 0x0b, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x79, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x0b, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x08, 0x73, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x79, 0x6d, 0x6c, 0x69, 0x6e,
	0x6b, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x08, 0x73, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x12,
	0x58, 0x0a, 0x0f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x0e, 0x6e, 0x6f, 0x64, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x22,
	0x38, 0x0a, 0x0c, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xcc, 0x01, 0x0a, 0x0e, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52,
	0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x05, 0x6d,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x05, 0x6d, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x39, 0x0a,
	0x09, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08,
	0x75, 0x6e, 0x69, 0x78, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0xea, 0x01, 0x0a, 0x08, 0x46, 0x69, 0x6c,
	0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x06, 0x64, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65,
	0x73, 0x74, 0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x73,
	0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0c, 0x69, 0x73, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x58, 0x0a, 0x0f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x0e, 0x6e, 0x6f, 0x64, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x4a,
	0x04, 0x08, 0x05, 0x10, 0x06, 0x22, 0x64, 0x0a, 0x0d, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x06, 0x64, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x22, 0x99, 0x01, 0x0a, 0x0b,
	0x53, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x16, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x58, 0x0a, 0x0f, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x52, 0x0e, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x22, 0x3b, 0x0a, 0x06, 0x44, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x61, 0x73, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x68, 0x61, 0x73, 0x68, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x73, 0x69, 0x7a, 0x65, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x22, 0xfd, 0x07, 0x0a, 0x16, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x16, 0x0a, 0x06, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x12, 0x45, 0x0a, 0x10, 0x71, 0x75, 0x65, 0x75, 0x65,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f, 0x71,
	0x75, 0x65, 0x75, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x50,
	0x0a, 0x16, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x14, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x12, 0x58, 0x0a, 0x1a, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x18, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x59, 0x0a, 0x1b, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x5f, 0x66, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x18, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x46, 0x65, 0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x61, 0x0a, 0x1f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x66,
	0x65, 0x74, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x1c, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x46, 0x65, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x56, 0x0a, 0x19, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x17, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x12, 0x5e, 0x0a, 0x1d, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x1b, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x12, 0x57, 0x0a, 0x1a, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x18, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x1d, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x1a, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x65, 0x0a, 0x21, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x5f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x1e, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12,
	0x43, 0x0a, 0x12, 0x61, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e,
	0x79, 0x52, 0x11, 0x61, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x22, 0xcb, 0x06, 0x0a, 0x0c, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x4e, 0x0a, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x14, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x0a, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65,
	0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x79, 0x6d, 0x6c,
	0x69, 0x6e, 0x6b, 0x52, 0x12, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x53,
	0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x57, 0x0a, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x73, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b,
	0x52, 0x0e, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x73,
	0x12, 0x5f, 0x0a, 0x12, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x11,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x6a, 0x0a, 0x19, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x0b,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a,
	0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x79, 0x6d,
	0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x17, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x1b, 0x0a,
	0x09, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x65, 0x78, 0x69, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74,
	0x64, 0x6f, 0x75, 0x74, 0x5f, 0x72, 0x61, 0x77, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09,
	0x73, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x52, 0x61, 0x77, 0x12, 0x4c, 0x0a, 0x0d, 0x73, 0x74, 0x64,
	0x6f, 0x75, 0x74, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x0c, 0x73, 0x74, 0x64, 0x6f, 0x75,
	0x74, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x64, 0x65, 0x72,
	0x72, 0x5f, 0x72, 0x61, 0x77, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x73, 0x74, 0x64,
	0x65, 0x72, 0x72, 0x52, 0x61, 0x77, 0x12, 0x4c, 0x0a, 0x0d, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72,
	0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e,
	0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x0c, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x44, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x12, 0x66, 0x0a, 0x12, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x11, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x04, 0x08, 0x01,
	0x10, 0x02, 0x22, 0x88, 0x02, 0x0a, 0x0a, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x46, 0x69, 0x6c,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x3f, 0x0a, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61,
	0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x06,
	0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x73, 0x5f, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69,
	0x73, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x58, 0x0a, 0x0f, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x52, 0x0e, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x4a, 0x04, 0x08, 0x06, 0x10, 0x07, 0x22, 0x8e, 0x01,
	0x0a, 0x04, 0x54, 0x72, 0x65, 0x65, 0x12, 0x3e, 0x0a, 0x04, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a,
	0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x52, 0x04, 0x72, 0x6f, 0x6f, 0x74, 0x12, 0x46, 0x0a, 0x08, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x08, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x22, 0x75,
	0x0a, 0x0f, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x48, 0x0a, 0x0b, 0x74, 0x72, 0x65, 0x65, 0x5f, 0x64, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x52, 0x0a, 0x74, 0x72, 0x65, 0x65, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x4a,
	0x04, 0x08, 0x02, 0x10, 0x03, 0x22, 0x9b, 0x01, 0x0a, 0x0d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x53, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x58, 0x0a, 0x0f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x0e, 0x6e,
	0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x4a, 0x04, 0x08,
	0x03, 0x10, 0x04, 0x22, 0x2d, 0x0a, 0x0f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x22, 0x30, 0x0a, 0x12, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x43, 0x61, 0x63,
	0x68, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x22, 0x85, 0x03, 0x0a, 0x0e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x11,
	0x73, 0x6b, 0x69, 0x70, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x6c, 0x6f, 0x6f, 0x6b, 0x75,
	0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x43, 0x61, 0x63,
	0x68, 0x65, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x12, 0x4c, 0x0a, 0x0d, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x0c, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x5b, 0x0a, 0x10, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x0f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x65, 0x0a, 0x14, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x63,
	0x61, 0x63, 0x68, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e,
	0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x12, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x43,
	0x61, 0x63, 0x68, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03,
	0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x4a, 0x04, 0x08, 0x05, 0x10, 0x06, 0x22, 0x71, 0x0a, 0x07,
	0x4c, 0x6f, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x3f, 0x0a, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74,
	0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x68, 0x75, 0x6d, 0x61,
	0x6e, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0d, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x61, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0x8f, 0x03, 0x0a, 0x0f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65,
	0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x61,
	0x63, 0x68, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0c, 0x63, 0x61, 0x63, 0x68, 0x65, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x61, 0x0a, 0x0b, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x40, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x73, 0x12, 0x18,
	0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x67, 0x0a, 0x0f, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x4c, 0x6f, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3e, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4c,
	0x6f, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x61, 0x0a, 0x0e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x67, 0x65, 0x22, 0x4f, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x0b, 0x0a, 0x07,
	0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x41, 0x43,
	0x48, 0x45, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x51, 0x55,
	0x45, 0x55, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54,
	0x45, 0x44, 0x10, 0x04, 0x22, 0x91, 0x02, 0x0a, 0x18, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x4b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x35, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67,
	0x65, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x67, 0x65, 0x12, 0x4c,
	0x0a, 0x0d, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61,
	0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x0c,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x2c, 0x0a, 0x12,
	0x73, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x74,
	0x64, 0x65, 0x72, 0x72, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x2a, 0x0a, 0x14, 0x57, 0x61, 0x69, 0x74,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x85, 0x02, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x0d, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x52, 0x0c, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x67, 0x65,
	0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x64,
	0x6f, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x53, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x64, 0x65, 0x72, 0x72, 0x12, 0x2e, 0x0a, 0x13,
	0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x69, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x22, 0xc9, 0x02, 0x0a,
	0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x4c, 0x0a, 0x0d, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62,
	0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52,
	0x0c, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a,
	0x0d, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a,
	0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x0c, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x65, 0x0a, 0x14, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x63, 0x61, 0x63,
	0x68, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x12, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x43, 0x61, 0x63,
	0x68, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x8a, 0x01, 0x0a, 0x17, 0x46, 0x69, 0x6e,
	0x64, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x42, 0x6c, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x0c, 0x62, 0x6c, 0x6f,
	0x62, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x0b, 0x62, 0x6c, 0x6f, 0x62, 0x44, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x73, 0x22, 0x75, 0x0a, 0x18, 0x46, 0x69, 0x6e, 0x64, 0x4d, 0x69, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x42, 0x6c, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x59, 0x0a, 0x14, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6c, 0x6f,
	0x62, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x12, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x42, 0x6c, 0x6f, 0x62, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x73, 0x22, 0xd0, 0x02, 0x0a,
	0x17, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x6c, 0x6f, 0x62,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5c, 0x0a,
	0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x6c, 0x6f,
	0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x1a, 0xb1, 0x01, 0x0a, 0x07,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74,
	0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x51, 0x0a, 0x0a,
	0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x31, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x2e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x22,
	0xf5, 0x01, 0x0a, 0x18, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42,
	0x6c, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x09,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x42, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x6c, 0x6f,
	0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x1a, 0x77,
	0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x06, 0x64, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x2a, 0x0a, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xe9, 0x01, 0x0a, 0x15, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x61, 0x64, 0x42, 0x6c, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x41, 0x0a, 0x07, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74,
	0x52, 0x07, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x73, 0x12, 0x68, 0x0a, 0x16, 0x61, 0x63, 0x63,
	0x65, 0x70, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x61, 0x63,
	0x63, 0x65, 0x70, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x73, 0x22, 0xd9, 0x02, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61,
	0x64, 0x42, 0x6c, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5e,
	0x0a, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x40, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e,
	0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x42, 0x6c, 0x6f,
	0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x1a, 0xde,
	0x01, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x06, 0x64,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x51, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a,
	0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22,
	0xbb, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x54, 0x72, 0x65, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x0b, 0x72, 0x6f, 0x6f, 0x74, 0x5f,
	0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x0a, 0x72, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x87, 0x01,
	0x0a, 0x0f, 0x47, 0x65, 0x74, 0x54, 0x72, 0x65, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4c, 0x0a, 0x0b, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62,
	0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x52, 0x0b, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x3d, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x43, 0x61,
	0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xc2, 0x03, 0x0a, 0x12, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x61, 0x0a,
	0x12, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x61, 0x63, 0x68,
	0x65, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x11, 0x63,
	0x61, 0x63, 0x68, 0x65, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x12, 0x6d, 0x0a, 0x16, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x61,
	0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x15, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12,
	0x50, 0x0a, 0x16, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x70,
	0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x73, 0x65,
	0x6d, 0x76, 0x65, 0x72, 0x2e, 0x53, 0x65, 0x6d, 0x56, 0x65, 0x72, 0x52, 0x14, 0x64, 0x65, 0x70,
	0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x41, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x42, 0x0a, 0x0f, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x73, 0x65, 0x6d, 0x76, 0x65, 0x72, 0x2e,
	0x53, 0x65, 0x6d, 0x56, 0x65, 0x72, 0x52, 0x0d, 0x6c, 0x6f, 0x77, 0x41, 0x70, 0x69, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x10, 0x68, 0x69, 0x67, 0x68, 0x5f, 0x61, 0x70,
	0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x73, 0x65,
	0x6d, 0x76, 0x65, 0x72, 0x2e, 0x53, 0x65, 0x6d, 0x56, 0x65, 0x72, 0x52, 0x0e, 0x68, 0x69, 0x67,
	0x68, 0x41, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x73, 0x0a, 0x0e, 0x44,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x61, 0x0a,
	0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x01, 0x12,
	0x08, 0x0a, 0x04, 0x53, 0x48, 0x41, 0x31, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x44, 0x35,
	0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x56, 0x53, 0x4f, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x53,
	0x48, 0x41, 0x33, 0x38, 0x34, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x48, 0x41, 0x35, 0x31,
	0x32, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x55, 0x52, 0x4d, 0x55, 0x52, 0x33, 0x10, 0x07,
	0x22, 0x46, 0x0a, 0x1d, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x63, 0x68, 0x65, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x25, 0x0a, 0x0e, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0xd2, 0x01, 0x0a, 0x14, 0x50, 0x72, 0x69,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x63, 0x0a, 0x0a, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61,
	0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79,
	0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x50, 0x72, 0x69,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x55, 0x0a, 0x0d, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x69, 0x6e, 0x5f, 0x70,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x6d,
	0x69, 0x6e, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61,
	0x78, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0b, 0x6d, 0x61, 0x78, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x22, 0x50, 0x0a,
	0x1b, 0x53, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x41, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65,
	0x50, 0x61, 0x74, 0x68, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x22, 0x31, 0x0a, 0x05,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e,
	0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x49, 0x53, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x45, 0x44, 0x10, 0x02, 0x22,
	0x3a, 0x0a, 0x0a, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x22, 0x2c, 0x0a,
	0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x49,
	0x54, 0x59, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x5a, 0x53, 0x54, 0x44, 0x10, 0x01, 0x12, 0x0b,
	0x0a, 0x07, 0x44, 0x45, 0x46, 0x4c, 0x41, 0x54, 0x45, 0x10, 0x02, 0x22, 0xa4, 0x06, 0x0a, 0x11,
	0x43, 0x61, 0x63, 0x68, 0x65, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x60, 0x0a, 0x10, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x87, 0x01, 0x0a, 0x20, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x61, 0x63, 0x68, 0x65, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e,
	0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x63, 0x68, 0x65, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x1d,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x63, 0x68, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x75, 0x0a,
	0x1b, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c,
	0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x43, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x19, 0x63, 0x61, 0x63, 0x68, 0x65,
	0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x1a, 0x6d, 0x61, 0x78, 0x5f, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x16, 0x6d, 0x61, 0x78, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x87, 0x01, 0x0a, 0x1e, 0x73, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x61, 0x62, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x79, 0x6d, 0x6c,
	0x69, 0x6e, 0x6b, 0x41, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x50, 0x61, 0x74, 0x68, 0x53,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1b, 0x73,
	0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x41, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x50, 0x61,
	0x74, 0x68, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x66, 0x0a, 0x15, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x73, 0x12, 0x7e, 0x0a, 0x22, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x31,
	0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x2e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x1f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x73, 0x22, 0xd5, 0x02, 0x0a, 0x15, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x5e, 0x0a, 0x0f,
	0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61,
	0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x64, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c,
	0x65, 0x78, 0x65, 0x63, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0b, 0x65, 0x78, 0x65, 0x63, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12,
	0x7d, 0x0a, 0x1f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x69,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52,
	0x1d, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x3a,
	0x0a, 0x19, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65,
	0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x17, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x22, 0x4d, 0x0a, 0x0b, 0x54, 0x6f,
	0x6f, 0x6c, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x6f, 0x6f,
	0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x6f,
	0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x74, 0x6f,
	0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xda, 0x02, 0x0a, 0x0f, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4f, 0x0a,
	0x0c, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65,
	0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x52, 0x0b, 0x74, 0x6f, 0x6f, 0x6c, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1b,
	0x0a, 0x09, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x12, 0x74,
	0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x74, 0x6f, 0x6f, 0x6c, 0x49, 0x6e, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x19, 0x63, 0x6f, 0x72,
	0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x63, 0x6f,
	0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6d, 0x6e, 0x65, 0x6d, 0x6f, 0x6e, 0x69, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6e, 0x65, 0x6d, 0x6f, 0x6e, 0x69, 0x63, 0x12, 0x1b,
	0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x32, 0xb9, 0x02, 0x0a, 0x09, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8e, 0x01, 0x0a, 0x07, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x12, 0x2f, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x31, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x22, 0x26, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2a, 0x7d,
	0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x3a, 0x01, 0x2a, 0x30, 0x01, 0x12, 0x9a, 0x01, 0x0a, 0x0d, 0x57, 0x61, 0x69, 0x74, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x61, 0x69, 0x74, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x31, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x22, 0x26, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x3a,
	0x77, 0x61, 0x69, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x01, 0x2a,
	0x30, 0x01, 0x32, 0xd6, 0x03, 0x0a, 0x0b, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x63,
	0x68, 0x65, 0x12, 0xd7, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x37, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62,
	0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2d, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x5c,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x12, 0x54, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2a, 0x7d, 0x2f, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x7d, 0x2f, 0x7b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74,
	0x2e, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x7d, 0x12, 0xec, 0x01, 0x0a,
	0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x3a, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65,
	0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2d, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x65, 0x1a, 0x54, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2a, 0x7d, 0x2f, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x7d, 0x2f, 0x7b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74,
	0x2e, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x7d, 0x3a, 0x0d, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x32, 0x9b, 0x06, 0x0a, 0x19,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0xbc, 0x01, 0x0a, 0x10, 0x46, 0x69,
	0x6e, 0x64, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x42, 0x6c, 0x6f, 0x62, 0x73, 0x12, 0x38,
	0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x46, 0x69, 0x6e, 0x64, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x42, 0x6c, 0x6f, 0x62,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x4d,
	0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x42, 0x6c, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x33, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x22, 0x28, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x2a, 0x2a, 0x7d, 0x2f, 0x62, 0x6c, 0x6f, 0x62, 0x73, 0x3a, 0x66, 0x69, 0x6e, 0x64, 0x4d, 0x69,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x3a, 0x01, 0x2a, 0x12, 0xbc, 0x01, 0x0a, 0x10, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x6c, 0x6f, 0x62, 0x73, 0x12, 0x38, 0x2e,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x6c, 0x6f, 0x62, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x6c, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x33, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x22, 0x28, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a,
	0x2a, 0x7d, 0x2f, 0x62, 0x6c, 0x6f, 0x62, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xb4, 0x01, 0x0a, 0x0e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x61, 0x64, 0x42, 0x6c, 0x6f, 0x62, 0x73, 0x12, 0x36, 0x2e, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x42, 0x6c, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x37, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c,
	0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x42, 0x6c,
	0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x31, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2b, 0x22, 0x26, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2a, 0x7d, 0x2f, 0x62, 0x6c, 0x6f, 0x62,
	0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x3a, 0x01, 0x2a, 0x12, 0xc8,
	0x01, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x54, 0x72, 0x65, 0x65, 0x12, 0x2f, 0x2e, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74,
	0x54, 0x72, 0x65, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65,
	0x74, 0x54, 0x72, 0x65, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x52, 0x12, 0x50, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2a, 0x7d, 0x2f, 0x62, 0x6c,
	0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x7d, 0x2f, 0x7b, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x7d, 0x3a,
	0x67, 0x65, 0x74, 0x54, 0x72, 0x65, 0x65, 0x30, 0x01, 0x32, 0xbd, 0x01, 0x0a, 0x0c, 0x43, 0x61,
	0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0xac, 0x01, 0x0a, 0x0f, 0x47,
	0x65, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x37,
	0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x47, 0x65, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0x2b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x25, 0x12, 0x23, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2a, 0x7d, 0x2f, 0x63, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x42, 0x72, 0x0a, 0x1f, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x2e,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x42, 0x14, 0x52, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x0f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0xa2, 0x02, 0x03, 0x52, 0x45, 0x58, 0xaa, 0x02, 0x1f, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x42, 0x61, 0x7a, 0x65, 0x6c, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x32, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescOnce sync.Once
	file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescData = file_build_bazel_remote_execution_v2_remote_execution_proto_rawDesc
)

func file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescGZIP() []byte {
	file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescOnce.Do(func() {
		file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescData = protoimpl.X.CompressGZIP(file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescData)
	})
	return file_build_bazel_remote_execution_v2_remote_execution_proto_rawDescData
}

var file_build_bazel_remote_execution_v2_remote_execution_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes = make([]protoimpl.MessageInfo, 52)
var file_build_bazel_remote_execution_v2_remote_execution_proto_goTypes = []interface{}{
	(ExecutionStage_Value)(0),                  // 0: build.bazel.remote.execution.v2.ExecutionStage.Value
	(DigestFunction_Value)(0),                  // 1: build.bazel.remote.execution.v2.DigestFunction.Value
	(SymlinkAbsolutePathStrategy_Value)(0),     // 2: build.bazel.remote.execution.v2.SymlinkAbsolutePathStrategy.Value
	(Compressor_Value)(0),                      // 3: build.bazel.remote.execution.v2.Compressor.Value
	(*Action)(nil),                             // 4: build.bazel.remote.execution.v2.Action
	(*Command)(nil),                            // 5: build.bazel.remote.execution.v2.Command
	(*Platform)(nil),                           // 6: build.bazel.remote.execution.v2.Platform
	(*Directory)(nil),                          // 7: build.bazel.remote.execution.v2.Directory
	(*NodeProperty)(nil),                       // 8: build.bazel.remote.execution.v2.NodeProperty
	(*NodeProperties)(nil),                     // 9: build.bazel.remote.execution.v2.NodeProperties
	(*FileNode)(nil),                           // 10: build.bazel.remote.execution.v2.FileNode
	(*DirectoryNode)(nil),                      // 11: build.bazel.remote.execution.v2.DirectoryNode
	(*SymlinkNode)(nil),                        // 12: build.bazel.remote.execution.v2.SymlinkNode
	(*Digest)(nil),                             // 13: build.bazel.remote.execution.v2.Digest
	(*ExecutedActionMetadata)(nil),             // 14: build.bazel.remote.execution.v2.ExecutedActionMetadata
	(*ActionResult)(nil),                       // 15: build.bazel.remote.execution.v2.ActionResult
	(*OutputFile)(nil),                         // 16: build.bazel.remote.execution.v2.OutputFile
	(*Tree)(nil),                               // 17: build.bazel.remote.execution.v2.Tree
	(*OutputDirectory)(nil),                    // 18: build.bazel.remote.execution.v2.OutputDirectory
	(*OutputSymlink)(nil),                      // 19: build.bazel.remote.execution.v2.OutputSymlink
	(*ExecutionPolicy)(nil),                    // 20: build.bazel.remote.execution.v2.ExecutionPolicy
	(*ResultsCachePolicy)(nil),                 // 21: build.bazel.remote.execution.v2.ResultsCachePolicy
	(*ExecuteRequest)(nil),                     // 22: build.bazel.remote.execution.v2.ExecuteRequest
	(*LogFile)(nil),                            // 23: build.bazel.remote.execution.v2.LogFile
	(*ExecuteResponse)(nil),                    // 24: build.bazel.remote.execution.v2.ExecuteResponse
	(*ExecutionStage)(nil),                     // 25: build.bazel.remote.execution.v2.ExecutionStage
	(*ExecuteOperationMetadata)(nil),           // 26: build.bazel.remote.execution.v2.ExecuteOperationMetadata
	(*WaitExecutionRequest)(nil),               // 27: build.bazel.remote.execution.v2.WaitExecutionRequest
	(*GetActionResultRequest)(nil),             // 28: build.bazel.remote.execution.v2.GetActionResultRequest
	(*UpdateActionResultRequest)(nil),          // 29: build.bazel.remote.execution.v2.UpdateActionResultRequest
	(*FindMissingBlobsRequest)(nil),            // 30: build.bazel.remote.execution.v2.FindMissingBlobsRequest
	(*FindMissingBlobsResponse)(nil),           // 31: build.bazel.remote.execution.v2.FindMissingBlobsResponse
	(*BatchUpdateBlobsRequest)(nil),            // 32: build.bazel.remote.execution.v2.BatchUpdateBlobsRequest
	(*BatchUpdateBlobsResponse)(nil),           // 33: build.bazel.remote.execution.v2.BatchUpdateBlobsResponse
	(*BatchReadBlobsRequest)(nil),              // 34: build.bazel.remote.execution.v2.BatchReadBlobsRequest
	(*BatchReadBlobsResponse)(nil),             // 35: build.bazel.remote.execution.v2.BatchReadBlobsResponse
	(*GetTreeRequest)(nil),                     // 36: build.bazel.remote.execution.v2.GetTreeRequest
	(*GetTreeResponse)(nil),                    // 37: build.bazel.remote.execution.v2.GetTreeResponse
	(*GetCapabilitiesRequest)(nil),             // 38: build.bazel.remote.execution.v2.GetCapabilitiesRequest
	(*ServerCapabilities)(nil),                 // 39: build.bazel.remote.execution.v2.ServerCapabilities
	(*DigestFunction)(nil),                     // 40: build.bazel.remote.execution.v2.DigestFunction
	(*ActionCacheUpdateCapabilities)(nil),      // 41: build.bazel.remote.execution.v2.ActionCacheUpdateCapabilities
	(*PriorityCapabilities)(nil),               // 42: build.bazel.remote.execution.v2.PriorityCapabilities
	(*SymlinkAbsolutePathStrategy)(nil),        // 43: build.bazel.remote.execution.v2.SymlinkAbsolutePathStrategy
	(*Compressor)(nil),                         // 44: build.bazel.remote.execution.v2.Compressor
	(*CacheCapabilities)(nil),                  // 45: build.bazel.remote.execution.v2.CacheCapabilities
	(*ExecutionCapabilities)(nil),              // 46: build.bazel.remote.execution.v2.ExecutionCapabilities
	(*ToolDetails)(nil),                        // 47: build.bazel.remote.execution.v2.ToolDetails
	(*RequestMetadata)(nil),                    // 48: build.bazel.remote.execution.v2.RequestMetadata
	(*Command_EnvironmentVariable)(nil),        // 49: build.bazel.remote.execution.v2.Command.EnvironmentVariable
	(*Platform_Property)(nil),                  // 50: build.bazel.remote.execution.v2.Platform.Property
	nil,                                        // 51: build.bazel.remote.execution.v2.ExecuteResponse.ServerLogsEntry
	(*BatchUpdateBlobsRequest_Request)(nil),    // 52: build.bazel.remote.execution.v2.BatchUpdateBlobsRequest.Request
	(*BatchUpdateBlobsResponse_Response)(nil),  // 53: build.bazel.remote.execution.v2.BatchUpdateBlobsResponse.Response
	(*BatchReadBlobsResponse_Response)(nil),    // 54: build.bazel.remote.execution.v2.BatchReadBlobsResponse.Response
	(*PriorityCapabilities_PriorityRange)(nil), // 55: build.bazel.remote.execution.v2.PriorityCapabilities.PriorityRange
	(*duration.Duration)(nil),                  // 56: google.protobuf.Duration
	(*timestamp.Timestamp)(nil),                // 57: google.protobuf.Timestamp
	(*wrappers.UInt32Value)(nil),               // 58: google.protobuf.UInt32Value
	(*any.Any)(nil),                            // 59: google.protobuf.Any
	(*status.Status)(nil),                      // 60: google.rpc.Status
	(*semver.SemVer)(nil),                      // 61: build.bazel.semver.SemVer
	(*longrunning.Operation)(nil),              // 62: google.longrunning.Operation
}
var file_build_bazel_remote_execution_v2_remote_execution_proto_depIdxs = []int32{
	13, // 0: build.bazel.remote.execution.v2.Action.command_digest:type_name -> build.bazel.remote.execution.v2.Digest
	13, // 1: build.bazel.remote.execution.v2.Action.input_root_digest:type_name -> build.bazel.remote.execution.v2.Digest
	56, // 2: build.bazel.remote.execution.v2.Action.timeout:type_name -> google.protobuf.Duration
	6,  // 3: build.bazel.remote.execution.v2.Action.platform:type_name -> build.bazel.remote.execution.v2.Platform
	49, // 4: build.bazel.remote.execution.v2.Command.environment_variables:type_name -> build.bazel.remote.execution.v2.Command.EnvironmentVariable
	6,  // 5: build.bazel.remote.execution.v2.Command.platform:type_name -> build.bazel.remote.execution.v2.Platform
	50, // 6: build.bazel.remote.execution.v2.Platform.properties:type_name -> build.bazel.remote.execution.v2.Platform.Property
	10, // 7: build.bazel.remote.execution.v2.Directory.files:type_name -> build.bazel.remote.execution.v2.FileNode
	11, // 8: build.bazel.remote.execution.v2.Directory.directories:type_name -> build.bazel.remote.execution.v2.DirectoryNode
	12, // 9: build.bazel.remote.execution.v2.Directory.symlinks:type_name -> build.bazel.remote.execution.v2.SymlinkNode
	9,  // 10: build.bazel.remote.execution.v2.Directory.node_properties:type_name -> build.bazel.remote.execution.v2.NodeProperties
	8,  // 11: build.bazel.remote.execution.v2.NodeProperties.properties:type_name -> build.bazel.remote.execution.v2.NodeProperty
	57, // 12: build.bazel.remote.execution.v2.NodeProperties.mtime:type_name -> google.protobuf.Timestamp
	58, // 13: build.bazel.remote.execution.v2.NodeProperties.unix_mode:type_name -> google.protobuf.UInt32Value
	13, // 14: build.bazel.remote.execution.v2.FileNode.digest:type_name -> build.bazel.remote.execution.v2.Digest
	9,  // 15: build.bazel.remote.execution.v2.FileNode.node_properties:type_name -> build.bazel.remote.execution.v2.NodeProperties
	13, // 16: build.bazel.remote.execution.v2.DirectoryNode.digest:type_name -> build.bazel.remote.execution.v2.Digest
	9,  // 17: build.bazel.remote.execution.v2.SymlinkNode.node_properties:type_name -> build.bazel.remote.execution.v2.NodeProperties
	57, // 18: build.bazel.remote.execution.v2.ExecutedActionMetadata.queued_timestamp:type_name -> google.protobuf.Timestamp
	57, // 19: build.bazel.remote.execution.v2.ExecutedActionMetadata.worker_start_timestamp:type_name -> google.protobuf.Timestamp
	57, // 20: build.bazel.remote.execution.v2.ExecutedActionMetadata.worker_completed_timestamp:type_name -> google.protobuf.Timestamp
	57, // 21: build.bazel.remote.execution.v2.ExecutedActionMetadata.input_fetch_start_timestamp:type_name -> google.protobuf.Timestamp
	57, // 22: build.bazel.remote.execution.v2.ExecutedActionMetadata.input_fetch_completed_timestamp:type_name -> google.protobuf.Timestamp
	57, // 23: build.bazel.remote.execution.v2.ExecutedActionMetadata.execution_start_timestamp:type_name -> google.protobuf.Timestamp
	57, // 24: build.bazel.remote.execution.v2.ExecutedActionMetadata.execution_completed_timestamp:type_name -> google.protobuf.Timestamp
	56, // 25: build.bazel.remote.execution.v2.ExecutedActionMetadata.virtual_execution_duration:type_name -> google.protobuf.Duration
	57, // 26: build.bazel.remote.execution.v2.ExecutedActionMetadata.output_upload_start_timestamp:type_name -> google.protobuf.Timestamp
	57, // 27: build.bazel.remote.execution.v2.ExecutedActionMetadata.output_upload_completed_timestamp:type_name -> google.protobuf.Timestamp
	59, // 28: build.bazel.remote.execution.v2.ExecutedActionMetadata.auxiliary_metadata:type_name -> google.protobuf.Any
	16, // 29: build.bazel.remote.execution.v2.ActionResult.output_files:type_name -> build.bazel.remote.execution.v2.OutputFile
	19, // 30: build.bazel.remote.execution.v2.ActionResult.output_file_symlinks:type_name -> build.bazel.remote.execution.v2.OutputSymlink
	19, // 31: build.bazel.remote.execution.v2.ActionResult.output_symlinks:type_name -> build.bazel.remote.execution.v2.OutputSymlink
	18, // 32: build.bazel.remote.execution.v2.ActionResult.output_directories:type_name -> build.bazel.remote.execution.v2.OutputDirectory
	19, // 33: build.bazel.remote.execution.v2.ActionResult.output_directory_symlinks:type_name -> build.bazel.remote.execution.v2.OutputSymlink
	13, // 34: build.bazel.remote.execution.v2.ActionResult.stdout_digest:type_name -> build.bazel.remote.execution.v2.Digest
	13, // 35: build.bazel.remote.execution.v2.ActionResult.stderr_digest:type_name -> build.bazel.remote.execution.v2.Digest
	14, // 36: build.bazel.remote.execution.v2.ActionResult.execution_metadata:type_name -> build.bazel.remote.execution.v2.ExecutedActionMetadata
	13, // 37: build.bazel.remote.execution.v2.OutputFile.digest:type_name -> build.bazel.remote.execution.v2.Digest
	9,  // 38: build.bazel.remote.execution.v2.OutputFile.node_properties:type_name -> build.bazel.remote.execution.v2.NodeProperties
	7,  // 39: build.bazel.remote.execution.v2.Tree.root:type_name -> build.bazel.remote.execution.v2.Directory
	7,  // 40: build.bazel.remote.execution.v2.Tree.children:type_name -> build.bazel.remote.execution.v2.Directory
	13, // 41: build.bazel.remote.execution.v2.OutputDirectory.tree_digest:type_name -> build.bazel.remote.execution.v2.Digest
	9,  // 42: build.bazel.remote.execution.v2.OutputSymlink.node_properties:type_name -> build.bazel.remote.execution.v2.NodeProperties
	13, // 43: build.bazel.remote.execution.v2.ExecuteRequest.action_digest:type_name -> build.bazel.remote.execution.v2.Digest
	20, // 44: build.bazel.remote.execution.v2.ExecuteRequest.execution_policy:type_name -> build.bazel.remote.execution.v2.ExecutionPolicy
	21, // 45: build.bazel.remote.execution.v2.ExecuteRequest.results_cache_policy:type_name -> build.bazel.remote.execution.v2.ResultsCachePolicy
	13, // 46: build.bazel.remote.execution.v2.LogFile.digest:type_name -> build.bazel.remote.execution.v2.Digest
	15, // 47: build.bazel.remote.execution.v2.ExecuteResponse.result:type_name -> build.bazel.remote.execution.v2.ActionResult
	60, // 48: build.bazel.remote.execution.v2.ExecuteResponse.status:type_name -> google.rpc.Status
	51, // 49: build.bazel.remote.execution.v2.ExecuteResponse.server_logs:type_name -> build.bazel.remote.execution.v2.ExecuteResponse.ServerLogsEntry
	0,  // 50: build.bazel.remote.execution.v2.ExecuteOperationMetadata.stage:type_name -> build.bazel.remote.execution.v2.ExecutionStage.Value
	13, // 51: build.bazel.remote.execution.v2.ExecuteOperationMetadata.action_digest:type_name -> build.bazel.remote.execution.v2.Digest
	13, // 52: build.bazel.remote.execution.v2.GetActionResultRequest.action_digest:type_name -> build.bazel.remote.execution.v2.Digest
	13, // 53: build.bazel.remote.execution.v2.UpdateActionResultRequest.action_digest:type_name -> build.bazel.remote.execution.v2.Digest
	15, // 54: build.bazel.remote.execution.v2.UpdateActionResultRequest.action_result:type_name -> build.bazel.remote.execution.v2.ActionResult
	21, // 55: build.bazel.remote.execution.v2.UpdateActionResultRequest.results_cache_policy:type_name -> build.bazel.remote.execution.v2.ResultsCachePolicy
	13, // 56: build.bazel.remote.execution.v2.FindMissingBlobsRequest.blob_digests:type_name -> build.bazel.remote.execution.v2.Digest
	13, // 57: build.bazel.remote.execution.v2.FindMissingBlobsResponse.missing_blob_digests:type_name -> build.bazel.remote.execution.v2.Digest
	52, // 58: build.bazel.remote.execution.v2.BatchUpdateBlobsRequest.requests:type_name -> build.bazel.remote.execution.v2.BatchUpdateBlobsRequest.Request
	53, // 59: build.bazel.remote.execution.v2.BatchUpdateBlobsResponse.responses:type_name -> build.bazel.remote.execution.v2.BatchUpdateBlobsResponse.Response
	13, // 60: build.bazel.remote.execution.v2.BatchReadBlobsRequest.digests:type_name -> build.bazel.remote.execution.v2.Digest
	3,  // 61: build.bazel.remote.execution.v2.BatchReadBlobsRequest.acceptable_compressors:type_name -> build.bazel.remote.execution.v2.Compressor.Value
	54, // 62: build.bazel.remote.execution.v2.BatchReadBlobsResponse.responses:type_name -> build.bazel.remote.execution.v2.BatchReadBlobsResponse.Response
	13, // 63: build.bazel.remote.execution.v2.GetTreeRequest.root_digest:type_name -> build.bazel.remote.execution.v2.Digest
	7,  // 64: build.bazel.remote.execution.v2.GetTreeResponse.directories:type_name -> build.bazel.remote.execution.v2.Directory
	45, // 65: build.bazel.remote.execution.v2.ServerCapabilities.cache_capabilities:type_name -> build.bazel.remote.execution.v2.CacheCapabilities
	46, // 66: build.bazel.remote.execution.v2.ServerCapabilities.execution_capabilities:type_name -> build.bazel.remote.execution.v2.ExecutionCapabilities
	61, // 67: build.bazel.remote.execution.v2.ServerCapabilities.deprecated_api_version:type_name -> build.bazel.semver.SemVer
	61, // 68: build.bazel.remote.execution.v2.ServerCapabilities.low_api_version:type_name -> build.bazel.semver.SemVer
	61, // 69: build.bazel.remote.execution.v2.ServerCapabilities.high_api_version:type_name -> build.bazel.semver.SemVer
	55, // 70: build.bazel.remote.execution.v2.PriorityCapabilities.priorities:type_name -> build.bazel.remote.execution.v2.PriorityCapabilities.PriorityRange
	1,  // 71: build.bazel.remote.execution.v2.CacheCapabilities.digest_functions:type_name -> build.bazel.remote.execution.v2.DigestFunction.Value
	41, // 72: build.bazel.remote.execution.v2.CacheCapabilities.action_cache_update_capabilities:type_name -> build.bazel.remote.execution.v2.ActionCacheUpdateCapabilities
	42, // 73: build.bazel.remote.execution.v2.CacheCapabilities.cache_priority_capabilities:type_name -> build.bazel.remote.execution.v2.PriorityCapabilities
	2,  // 74: build.bazel.remote.execution.v2.CacheCapabilities.symlink_absolute_path_strategy:type_name -> build.bazel.remote.execution.v2.SymlinkAbsolutePathStrategy.Value
	3,  // 75: build.bazel.remote.execution.v2.CacheCapabilities.supported_compressors:type_name -> build.bazel.remote.execution.v2.Compressor.Value
	3,  // 76: build.bazel.remote.execution.v2.CacheCapabilities.supported_batch_update_compressors:type_name -> build.bazel.remote.execution.v2.Compressor.Value
	1,  // 77: build.bazel.remote.execution.v2.ExecutionCapabilities.digest_function:type_name -> build.bazel.remote.execution.v2.DigestFunction.Value
	42, // 78: build.bazel.remote.execution.v2.ExecutionCapabilities.execution_priority_capabilities:type_name -> build.bazel.remote.execution.v2.PriorityCapabilities
	47, // 79: build.bazel.remote.execution.v2.RequestMetadata.tool_details:type_name -> build.bazel.remote.execution.v2.ToolDetails
	23, // 80: build.bazel.remote.execution.v2.ExecuteResponse.ServerLogsEntry.value:type_name -> build.bazel.remote.execution.v2.LogFile
	13, // 81: build.bazel.remote.execution.v2.BatchUpdateBlobsRequest.Request.digest:type_name -> build.bazel.remote.execution.v2.Digest
	3,  // 82: build.bazel.remote.execution.v2.BatchUpdateBlobsRequest.Request.compressor:type_name -> build.bazel.remote.execution.v2.Compressor.Value
	13, // 83: build.bazel.remote.execution.v2.BatchUpdateBlobsResponse.Response.digest:type_name -> build.bazel.remote.execution.v2.Digest
	60, // 84: build.bazel.remote.execution.v2.BatchUpdateBlobsResponse.Response.status:type_name -> google.rpc.Status
	13, // 85: build.bazel.remote.execution.v2.BatchReadBlobsResponse.Response.digest:type_name -> build.bazel.remote.execution.v2.Digest
	3,  // 86: build.bazel.remote.execution.v2.BatchReadBlobsResponse.Response.compressor:type_name -> build.bazel.remote.execution.v2.Compressor.Value
	60, // 87: build.bazel.remote.execution.v2.BatchReadBlobsResponse.Response.status:type_name -> google.rpc.Status
	22, // 88: build.bazel.remote.execution.v2.Execution.Execute:input_type -> build.bazel.remote.execution.v2.ExecuteRequest
	27, // 89: build.bazel.remote.execution.v2.Execution.WaitExecution:input_type -> build.bazel.remote.execution.v2.WaitExecutionRequest
	28, // 90: build.bazel.remote.execution.v2.ActionCache.GetActionResult:input_type -> build.bazel.remote.execution.v2.GetActionResultRequest
	29, // 91: build.bazel.remote.execution.v2.ActionCache.UpdateActionResult:input_type -> build.bazel.remote.execution.v2.UpdateActionResultRequest
	30, // 92: build.bazel.remote.execution.v2.ContentAddressableStorage.FindMissingBlobs:input_type -> build.bazel.remote.execution.v2.FindMissingBlobsRequest
	32, // 93: build.bazel.remote.execution.v2.ContentAddressableStorage.BatchUpdateBlobs:input_type -> build.bazel.remote.execution.v2.BatchUpdateBlobsRequest
	34, // 94: build.bazel.remote.execution.v2.ContentAddressableStorage.BatchReadBlobs:input_type -> build.bazel.remote.execution.v2.BatchReadBlobsRequest
	36, // 95: build.bazel.remote.execution.v2.ContentAddressableStorage.GetTree:input_type -> build.bazel.remote.execution.v2.GetTreeRequest
	38, // 96: build.bazel.remote.execution.v2.Capabilities.GetCapabilities:input_type -> build.bazel.remote.execution.v2.GetCapabilitiesRequest
	62, // 97: build.bazel.remote.execution.v2.Execution.Execute:output_type -> google.longrunning.Operation
	62, // 98: build.bazel.remote.execution.v2.Execution.WaitExecution:output_type -> google.longrunning.Operation
	15, // 99: build.bazel.remote.execution.v2.ActionCache.GetActionResult:output_type -> build.bazel.remote.execution.v2.ActionResult
	15, // 100: build.bazel.remote.execution.v2.ActionCache.UpdateActionResult:output_type -> build.bazel.remote.execution.v2.ActionResult
	31, // 101: build.bazel.remote.execution.v2.ContentAddressableStorage.FindMissingBlobs:output_type -> build.bazel.remote.execution.v2.FindMissingBlobsResponse
	33, // 102: build.bazel.remote.execution.v2.ContentAddressableStorage.BatchUpdateBlobs:output_type -> build.bazel.remote.execution.v2.BatchUpdateBlobsResponse
	35, // 103: build.bazel.remote.execution.v2.ContentAddressableStorage.BatchReadBlobs:output_type -> build.bazel.remote.execution.v2.BatchReadBlobsResponse
	37, // 104: build.bazel.remote.execution.v2.ContentAddressableStorage.GetTree:output_type -> build.bazel.remote.execution.v2.GetTreeResponse
	39, // 105: build.bazel.remote.execution.v2.Capabilities.GetCapabilities:output_type -> build.bazel.remote.execution.v2.ServerCapabilities
	97, // [97:106] is the sub-list for method output_type
	88, // [88:97] is the sub-list for method input_type
	88, // [88:88] is the sub-list for extension type_name
	88, // [88:88] is the sub-list for extension extendee
	0,  // [0:88] is the sub-list for field type_name
}

func init() { file_build_bazel_remote_execution_v2_remote_execution_proto_init() }
func file_build_bazel_remote_execution_v2_remote_execution_proto_init() {
	if File_build_bazel_remote_execution_v2_remote_execution_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Command); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Platform); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Directory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeProperty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileNode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DirectoryNode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SymlinkNode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Digest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutedActionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Tree); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputDirectory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputSymlink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResultsCachePolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionStage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WaitExecutionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetActionResultRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateActionResultRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FindMissingBlobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FindMissingBlobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateBlobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateBlobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchReadBlobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchReadBlobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTreeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTreeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCapabilitiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerCapabilities); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DigestFunction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionCacheUpdateCapabilities); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PriorityCapabilities); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SymlinkAbsolutePathStrategy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Compressor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CacheCapabilities); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionCapabilities); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ToolDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Command_EnvironmentVariable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Platform_Property); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateBlobsRequest_Request); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateBlobsResponse_Response); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchReadBlobsResponse_Response); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PriorityCapabilities_PriorityRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_build_bazel_remote_execution_v2_remote_execution_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   52,
			NumExtensions: 0,
			NumServices:   4,
		},
		GoTypes:           file_build_bazel_remote_execution_v2_remote_execution_proto_goTypes,
		DependencyIndexes: file_build_bazel_remote_execution_v2_remote_execution_proto_depIdxs,
		EnumInfos:         file_build_bazel_remote_execution_v2_remote_execution_proto_enumTypes,
		MessageInfos:      file_build_bazel_remote_execution_v2_remote_execution_proto_msgTypes,
	}.Build()
	File_build_bazel_remote_execution_v2_remote_execution_proto = out.File
	file_build_bazel_remote_execution_v2_remote_execution_proto_rawDesc = nil
	file_build_bazel_remote_execution_v2_remote_execution_proto_goTypes = nil
	file_build_bazel_remote_execution_v2_remote_execution_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ExecutionClient is the client API for Execution service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ExecutionClient interface {
	// Execute an action remotely.
	//
	// In order to execute an action, the client must first upload all of the
	// inputs, the
	// [Command][build.bazel.remote.execution.v2.Command] to run, and the
	// [Action][build.bazel.remote.execution.v2.Action] into the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
	// It then calls `Execute` with an `action_digest` referring to them. The
	// server will run the action and eventually return the result.
	//
	// The input `Action`'s fields MUST meet the various canonicalization
	// requirements specified in the documentation for their types so that it has
	// the same digest as other logically equivalent `Action`s. The server MAY
	// enforce the requirements and return errors if a non-canonical input is
	// received. It MAY also proceed without verifying some or all of the
	// requirements, such as for performance reasons. If the server does not
	// verify the requirement, then it will treat the `Action` as distinct from
	// another logically equivalent action if they hash differently.
	//
	// Returns a stream of
	// [google.longrunning.Operation][google.longrunning.Operation] messages
	// describing the resulting execution, with eventual `response`
	// [ExecuteResponse][build.bazel.remote.execution.v2.ExecuteResponse]. The
	// `metadata` on the operation is of type
	// [ExecuteOperationMetadata][build.bazel.remote.execution.v2.ExecuteOperationMetadata].
	//
	// If the client remains connected after the first response is returned after
	// the server, then updates are streamed as if the client had called
	// [WaitExecution][build.bazel.remote.execution.v2.Execution.WaitExecution]
	// until the execution completes or the request reaches an error. The
	// operation can also be queried using [Operations
	// API][google.longrunning.Operations.GetOperation].
	//
	// The server NEED NOT implement other methods or functionality of the
	// Operations API.
	//
	// Errors discovered during creation of the `Operation` will be reported
	// as gRPC Status errors, while errors that occurred while running the
	// action will be reported in the `status` field of the `ExecuteResponse`. The
	// server MUST NOT set the `error` field of the `Operation` proto.
	// The possible errors include:
	//
	// * `INVALID_ARGUMENT`: One or more arguments are invalid.
	// * `FAILED_PRECONDITION`: One or more errors occurred in setting up the
	//   action requested, such as a missing input or command or no worker being
	//   available. The client may be able to fix the errors and retry.
	// * `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to run
	//   the action.
	// * `UNAVAILABLE`: Due to a transient condition, such as all workers being
	//   occupied (and the server does not support a queue), the action could not
	//   be started. The client should retry.
	// * `INTERNAL`: An internal error occurred in the execution engine or the
	//   worker.
	// * `DEADLINE_EXCEEDED`: The execution timed out.
	// * `CANCELLED`: The operation was cancelled by the client. This status is
	//   only possible if the server implements the Operations API CancelOperation
	//   method, and it was called for the current execution.
	//
	// In the case of a missing input or command, the server SHOULD additionally
	// send a [PreconditionFailure][google.rpc.PreconditionFailure] error detail
	// where, for each requested blob not present in the CAS, there is a
	// `Violation` with a `type` of `MISSING` and a `subject` of
	// `"blobs/{hash}/{size}"` indicating the digest of the missing blob.
	//
	// The server does not need to guarantee that a call to this method leads to
	// at most one execution of the action. The server MAY execute the action
	// multiple times, potentially in parallel. These redundant executions MAY
	// continue to run, even if the operation is completed.
	Execute(ctx context.Context, in *ExecuteRequest, opts ...grpc.CallOption) (Execution_ExecuteClient, error)
	// Wait for an execution operation to complete. When the client initially
	// makes the request, the server immediately responds with the current status
	// of the execution. The server will leave the request stream open until the
	// operation completes, and then respond with the completed operation. The
	// server MAY choose to stream additional updates as execution progresses,
	// such as to provide an update as to the state of the execution.
	WaitExecution(ctx context.Context, in *WaitExecutionRequest, opts ...grpc.CallOption) (Execution_WaitExecutionClient, error)
}

type executionClient struct {
	cc grpc.ClientConnInterface
}

func NewExecutionClient(cc grpc.ClientConnInterface) ExecutionClient {
	return &executionClient{cc}
}

func (c *executionClient) Execute(ctx context.Context, in *ExecuteRequest, opts ...grpc.CallOption) (Execution_ExecuteClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Execution_serviceDesc.Streams[0], "/build.bazel.remote.execution.v2.Execution/Execute", opts...)
	if err != nil {
		return nil, err
	}
	x := &executionExecuteClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Execution_ExecuteClient interface {
	Recv() (*longrunning.Operation, error)
	grpc.ClientStream
}

type executionExecuteClient struct {
	grpc.ClientStream
}

func (x *executionExecuteClient) Recv() (*longrunning.Operation, error) {
	m := new(longrunning.Operation)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *executionClient) WaitExecution(ctx context.Context, in *WaitExecutionRequest, opts ...grpc.CallOption) (Execution_WaitExecutionClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Execution_serviceDesc.Streams[1], "/build.bazel.remote.execution.v2.Execution/WaitExecution", opts...)
	if err != nil {
		return nil, err
	}
	x := &executionWaitExecutionClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Execution_WaitExecutionClient interface {
	Recv() (*longrunning.Operation, error)
	grpc.ClientStream
}

type executionWaitExecutionClient struct {
	grpc.ClientStream
}

func (x *executionWaitExecutionClient) Recv() (*longrunning.Operation, error) {
	m := new(longrunning.Operation)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ExecutionServer is the server API for Execution service.
type ExecutionServer interface {
	// Execute an action remotely.
	//
	// In order to execute an action, the client must first upload all of the
	// inputs, the
	// [Command][build.bazel.remote.execution.v2.Command] to run, and the
	// [Action][build.bazel.remote.execution.v2.Action] into the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
	// It then calls `Execute` with an `action_digest` referring to them. The
	// server will run the action and eventually return the result.
	//
	// The input `Action`'s fields MUST meet the various canonicalization
	// requirements specified in the documentation for their types so that it has
	// the same digest as other logically equivalent `Action`s. The server MAY
	// enforce the requirements and return errors if a non-canonical input is
	// received. It MAY also proceed without verifying some or all of the
	// requirements, such as for performance reasons. If the server does not
	// verify the requirement, then it will treat the `Action` as distinct from
	// another logically equivalent action if they hash differently.
	//
	// Returns a stream of
	// [google.longrunning.Operation][google.longrunning.Operation] messages
	// describing the resulting execution, with eventual `response`
	// [ExecuteResponse][build.bazel.remote.execution.v2.ExecuteResponse]. The
	// `metadata` on the operation is of type
	// [ExecuteOperationMetadata][build.bazel.remote.execution.v2.ExecuteOperationMetadata].
	//
	// If the client remains connected after the first response is returned after
	// the server, then updates are streamed as if the client had called
	// [WaitExecution][build.bazel.remote.execution.v2.Execution.WaitExecution]
	// until the execution completes or the request reaches an error. The
	// operation can also be queried using [Operations
	// API][google.longrunning.Operations.GetOperation].
	//
	// The server NEED NOT implement other methods or functionality of the
	// Operations API.
	//
	// Errors discovered during creation of the `Operation` will be reported
	// as gRPC Status errors, while errors that occurred while running the
	// action will be reported in the `status` field of the `ExecuteResponse`. The
	// server MUST NOT set the `error` field of the `Operation` proto.
	// The possible errors include:
	//
	// * `INVALID_ARGUMENT`: One or more arguments are invalid.
	// * `FAILED_PRECONDITION`: One or more errors occurred in setting up the
	//   action requested, such as a missing input or command or no worker being
	//   available. The client may be able to fix the errors and retry.
	// * `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to run
	//   the action.
	// * `UNAVAILABLE`: Due to a transient condition, such as all workers being
	//   occupied (and the server does not support a queue), the action could not
	//   be started. The client should retry.
	// * `INTERNAL`: An internal error occurred in the execution engine or the
	//   worker.
	// * `DEADLINE_EXCEEDED`: The execution timed out.
	// * `CANCELLED`: The operation was cancelled by the client. This status is
	//   only possible if the server implements the Operations API CancelOperation
	//   method, and it was called for the current execution.
	//
	// In the case of a missing input or command, the server SHOULD additionally
	// send a [PreconditionFailure][google.rpc.PreconditionFailure] error detail
	// where, for each requested blob not present in the CAS, there is a
	// `Violation` with a `type` of `MISSING` and a `subject` of
	// `"blobs/{hash}/{size}"` indicating the digest of the missing blob.
	//
	// The server does not need to guarantee that a call to this method leads to
	// at most one execution of the action. The server MAY execute the action
	// multiple times, potentially in parallel. These redundant executions MAY
	// continue to run, even if the operation is completed.
	Execute(*ExecuteRequest, Execution_ExecuteServer) error
	// Wait for an execution operation to complete. When the client initially
	// makes the request, the server immediately responds with the current status
	// of the execution. The server will leave the request stream open until the
	// operation completes, and then respond with the completed operation. The
	// server MAY choose to stream additional updates as execution progresses,
	// such as to provide an update as to the state of the execution.
	WaitExecution(*WaitExecutionRequest, Execution_WaitExecutionServer) error
}

// UnimplementedExecutionServer can be embedded to have forward compatible implementations.
type UnimplementedExecutionServer struct {
}

func (*UnimplementedExecutionServer) Execute(*ExecuteRequest, Execution_ExecuteServer) error {
	return status1.Errorf(codes.Unimplemented, "method Execute not implemented")
}
func (*UnimplementedExecutionServer) WaitExecution(*WaitExecutionRequest, Execution_WaitExecutionServer) error {
	return status1.Errorf(codes.Unimplemented, "method WaitExecution not implemented")
}

func RegisterExecutionServer(s *grpc.Server, srv ExecutionServer) {
	s.RegisterService(&_Execution_serviceDesc, srv)
}

func _Execution_Execute_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ExecuteRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ExecutionServer).Execute(m, &executionExecuteServer{stream})
}

type Execution_ExecuteServer interface {
	Send(*longrunning.Operation) error
	grpc.ServerStream
}

type executionExecuteServer struct {
	grpc.ServerStream
}

func (x *executionExecuteServer) Send(m *longrunning.Operation) error {
	return x.ServerStream.SendMsg(m)
}

func _Execution_WaitExecution_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(WaitExecutionRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ExecutionServer).WaitExecution(m, &executionWaitExecutionServer{stream})
}

type Execution_WaitExecutionServer interface {
	Send(*longrunning.Operation) error
	grpc.ServerStream
}

type executionWaitExecutionServer struct {
	grpc.ServerStream
}

func (x *executionWaitExecutionServer) Send(m *longrunning.Operation) error {
	return x.ServerStream.SendMsg(m)
}

var _Execution_serviceDesc = grpc.ServiceDesc{
	ServiceName: "build.bazel.remote.execution.v2.Execution",
	HandlerType: (*ExecutionServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Execute",
			Handler:       _Execution_Execute_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "WaitExecution",
			Handler:       _Execution_WaitExecution_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "build/bazel/remote/execution/v2/remote_execution.proto",
}

// ActionCacheClient is the client API for ActionCache service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ActionCacheClient interface {
	// Retrieve a cached execution result.
	//
	// Implementations SHOULD ensure that any blobs referenced from the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage]
	// are available at the time of returning the
	// [ActionResult][build.bazel.remote.execution.v2.ActionResult] and will be
	// for some period of time afterwards. The lifetimes of the referenced blobs SHOULD be increased
	// if necessary and applicable.
	//
	// Errors:
	//
	// * `NOT_FOUND`: The requested `ActionResult` is not in the cache.
	GetActionResult(ctx context.Context, in *GetActionResultRequest, opts ...grpc.CallOption) (*ActionResult, error)
	// Upload a new execution result.
	//
	// In order to allow the server to perform access control based on the type of
	// action, and to assist with client debugging, the client MUST first upload
	// the [Action][build.bazel.remote.execution.v2.Execution] that produced the
	// result, along with its
	// [Command][build.bazel.remote.execution.v2.Command], into the
	// `ContentAddressableStorage`.
	//
	// Server implementations MAY modify the
	// `UpdateActionResultRequest.action_result` and return an equivalent value.
	//
	// Errors:
	//
	// * `INVALID_ARGUMENT`: One or more arguments are invalid.
	// * `FAILED_PRECONDITION`: One or more errors occurred in updating the
	//   action result, such as a missing command or action.
	// * `RESOURCE_EXHAUSTED`: There is insufficient storage space to add the
	//   entry to the cache.
	UpdateActionResult(ctx context.Context, in *UpdateActionResultRequest, opts ...grpc.CallOption) (*ActionResult, error)
}

type actionCacheClient struct {
	cc grpc.ClientConnInterface
}

func NewActionCacheClient(cc grpc.ClientConnInterface) ActionCacheClient {
	return &actionCacheClient{cc}
}

func (c *actionCacheClient) GetActionResult(ctx context.Context, in *GetActionResultRequest, opts ...grpc.CallOption) (*ActionResult, error) {
	out := new(ActionResult)
	err := c.cc.Invoke(ctx, "/build.bazel.remote.execution.v2.ActionCache/GetActionResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *actionCacheClient) UpdateActionResult(ctx context.Context, in *UpdateActionResultRequest, opts ...grpc.CallOption) (*ActionResult, error) {
	out := new(ActionResult)
	err := c.cc.Invoke(ctx, "/build.bazel.remote.execution.v2.ActionCache/UpdateActionResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ActionCacheServer is the server API for ActionCache service.
type ActionCacheServer interface {
	// Retrieve a cached execution result.
	//
	// Implementations SHOULD ensure that any blobs referenced from the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage]
	// are available at the time of returning the
	// [ActionResult][build.bazel.remote.execution.v2.ActionResult] and will be
	// for some period of time afterwards. The lifetimes of the referenced blobs SHOULD be increased
	// if necessary and applicable.
	//
	// Errors:
	//
	// * `NOT_FOUND`: The requested `ActionResult` is not in the cache.
	GetActionResult(context.Context, *GetActionResultRequest) (*ActionResult, error)
	// Upload a new execution result.
	//
	// In order to allow the server to perform access control based on the type of
	// action, and to assist with client debugging, the client MUST first upload
	// the [Action][build.bazel.remote.execution.v2.Execution] that produced the
	// result, along with its
	// [Command][build.bazel.remote.execution.v2.Command], into the
	// `ContentAddressableStorage`.
	//
	// Server implementations MAY modify the
	// `UpdateActionResultRequest.action_result` and return an equivalent value.
	//
	// Errors:
	//
	// * `INVALID_ARGUMENT`: One or more arguments are invalid.
	// * `FAILED_PRECONDITION`: One or more errors occurred in updating the
	//   action result, such as a missing command or action.
	// * `RESOURCE_EXHAUSTED`: There is insufficient storage space to add the
	//   entry to the cache.
	UpdateActionResult(context.Context, *UpdateActionResultRequest) (*ActionResult, error)
}

// UnimplementedActionCacheServer can be embedded to have forward compatible implementations.
type UnimplementedActionCacheServer struct {
}

func (*UnimplementedActionCacheServer) GetActionResult(context.Context, *GetActionResultRequest) (*ActionResult, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetActionResult not implemented")
}
func (*UnimplementedActionCacheServer) UpdateActionResult(context.Context, *UpdateActionResultRequest) (*ActionResult, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateActionResult not implemented")
}

func RegisterActionCacheServer(s *grpc.Server, srv ActionCacheServer) {
	s.RegisterService(&_ActionCache_serviceDesc, srv)
}

func _ActionCache_GetActionResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetActionResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ActionCacheServer).GetActionResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/build.bazel.remote.execution.v2.ActionCache/GetActionResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ActionCacheServer).GetActionResult(ctx, req.(*GetActionResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ActionCache_UpdateActionResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateActionResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ActionCacheServer).UpdateActionResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/build.bazel.remote.execution.v2.ActionCache/UpdateActionResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ActionCacheServer).UpdateActionResult(ctx, req.(*UpdateActionResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ActionCache_serviceDesc = grpc.ServiceDesc{
	ServiceName: "build.bazel.remote.execution.v2.ActionCache",
	HandlerType: (*ActionCacheServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetActionResult",
			Handler:    _ActionCache_GetActionResult_Handler,
		},
		{
			MethodName: "UpdateActionResult",
			Handler:    _ActionCache_UpdateActionResult_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "build/bazel/remote/execution/v2/remote_execution.proto",
}

// ContentAddressableStorageClient is the client API for ContentAddressableStorage service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ContentAddressableStorageClient interface {
	// Determine if blobs are present in the CAS.
	//
	// Clients can use this API before uploading blobs to determine which ones are
	// already present in the CAS and do not need to be uploaded again.
	//
	// Servers SHOULD increase the lifetimes of the referenced blobs if necessary and
	// applicable.
	//
	// There are no method-specific errors.
	FindMissingBlobs(ctx context.Context, in *FindMissingBlobsRequest, opts ...grpc.CallOption) (*FindMissingBlobsResponse, error)
	// Upload many blobs at once.
	//
	// The server may enforce a limit of the combined total size of blobs
	// to be uploaded using this API. This limit may be obtained using the
	// [Capabilities][build.bazel.remote.execution.v2.Capabilities] API.
	// Requests exceeding the limit should either be split into smaller
	// chunks or uploaded using the
	// [ByteStream API][google.bytestream.ByteStream], as appropriate.
	//
	// This request is equivalent to calling a Bytestream `Write` request
	// on each individual blob, in parallel. The requests may succeed or fail
	// independently.
	//
	// Errors:
	//
	// * `INVALID_ARGUMENT`: The client attempted to upload more than the
	//   server supported limit.
	//
	// Individual requests may return the following errors, additionally:
	//
	// * `RESOURCE_EXHAUSTED`: There is insufficient disk quota to store the blob.
	// * `INVALID_ARGUMENT`: The
	// [Digest][build.bazel.remote.execution.v2.Digest] does not match the
	// provided data.
	BatchUpdateBlobs(ctx context.Context, in *BatchUpdateBlobsRequest, opts ...grpc.CallOption) (*BatchUpdateBlobsResponse, error)
	// Download many blobs at once.
	//
	// The server may enforce a limit of the combined total size of blobs
	// to be downloaded using this API. This limit may be obtained using the
	// [Capabilities][build.bazel.remote.execution.v2.Capabilities] API.
	// Requests exceeding the limit should either be split into smaller
	// chunks or downloaded using the
	// [ByteStream API][google.bytestream.ByteStream], as appropriate.
	//
	// This request is equivalent to calling a Bytestream `Read` request
	// on each individual blob, in parallel. The requests may succeed or fail
	// independently.
	//
	// Errors:
	//
	// * `INVALID_ARGUMENT`: The client attempted to read more than the
	//   server supported limit.
	//
	// Every error on individual read will be returned in the corresponding digest
	// status.
	BatchReadBlobs(ctx context.Context, in *BatchReadBlobsRequest, opts ...grpc.CallOption) (*BatchReadBlobsResponse, error)
	// Fetch the entire directory tree rooted at a node.
	//
	// This request must be targeted at a
	// [Directory][build.bazel.remote.execution.v2.Directory] stored in the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage]
	// (CAS). The server will enumerate the `Directory` tree recursively and
	// return every node descended from the root.
	//
	// The GetTreeRequest.page_token parameter can be used to skip ahead in
	// the stream (e.g. when retrying a partially completed and aborted request),
	// by setting it to a value taken from GetTreeResponse.next_page_token of the
	// last successfully processed GetTreeResponse).
	//
	// The exact traversal order is unspecified and, unless retrieving subsequent
	// pages from an earlier request, is not guaranteed to be stable across
	// multiple invocations of `GetTree`.
	//
	// If part of the tree is missing from the CAS, the server will return the
	// portion present and omit the rest.
	//
	// Errors:
	//
	// * `NOT_FOUND`: The requested tree root is not present in the CAS.
	GetTree(ctx context.Context, in *GetTreeRequest, opts ...grpc.CallOption) (ContentAddressableStorage_GetTreeClient, error)
}

type contentAddressableStorageClient struct {
	cc grpc.ClientConnInterface
}

func NewContentAddressableStorageClient(cc grpc.ClientConnInterface) ContentAddressableStorageClient {
	return &contentAddressableStorageClient{cc}
}

func (c *contentAddressableStorageClient) FindMissingBlobs(ctx context.Context, in *FindMissingBlobsRequest, opts ...grpc.CallOption) (*FindMissingBlobsResponse, error) {
	out := new(FindMissingBlobsResponse)
	err := c.cc.Invoke(ctx, "/build.bazel.remote.execution.v2.ContentAddressableStorage/FindMissingBlobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contentAddressableStorageClient) BatchUpdateBlobs(ctx context.Context, in *BatchUpdateBlobsRequest, opts ...grpc.CallOption) (*BatchUpdateBlobsResponse, error) {
	out := new(BatchUpdateBlobsResponse)
	err := c.cc.Invoke(ctx, "/build.bazel.remote.execution.v2.ContentAddressableStorage/BatchUpdateBlobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contentAddressableStorageClient) BatchReadBlobs(ctx context.Context, in *BatchReadBlobsRequest, opts ...grpc.CallOption) (*BatchReadBlobsResponse, error) {
	out := new(BatchReadBlobsResponse)
	err := c.cc.Invoke(ctx, "/build.bazel.remote.execution.v2.ContentAddressableStorage/BatchReadBlobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contentAddressableStorageClient) GetTree(ctx context.Context, in *GetTreeRequest, opts ...grpc.CallOption) (ContentAddressableStorage_GetTreeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ContentAddressableStorage_serviceDesc.Streams[0], "/build.bazel.remote.execution.v2.ContentAddressableStorage/GetTree", opts...)
	if err != nil {
		return nil, err
	}
	x := &contentAddressableStorageGetTreeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ContentAddressableStorage_GetTreeClient interface {
	Recv() (*GetTreeResponse, error)
	grpc.ClientStream
}

type contentAddressableStorageGetTreeClient struct {
	grpc.ClientStream
}

func (x *contentAddressableStorageGetTreeClient) Recv() (*GetTreeResponse, error) {
	m := new(GetTreeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ContentAddressableStorageServer is the server API for ContentAddressableStorage service.
type ContentAddressableStorageServer interface {
	// Determine if blobs are present in the CAS.
	//
	// Clients can use this API before uploading blobs to determine which ones are
	// already present in the CAS and do not need to be uploaded again.
	//
	// Servers SHOULD increase the lifetimes of the referenced blobs if necessary and
	// applicable.
	//
	// There are no method-specific errors.
	FindMissingBlobs(context.Context, *FindMissingBlobsRequest) (*FindMissingBlobsResponse, error)
	// Upload many blobs at once.
	//
	// The server may enforce a limit of the combined total size of blobs
	// to be uploaded using this API. This limit may be obtained using the
	// [Capabilities][build.bazel.remote.execution.v2.Capabilities] API.
	// Requests exceeding the limit should either be split into smaller
	// chunks or uploaded using the
	// [ByteStream API][google.bytestream.ByteStream], as appropriate.
	//
	// This request is equivalent to calling a Bytestream `Write` request
	// on each individual blob, in parallel. The requests may succeed or fail
	// independently.
	//
	// Errors:
	//
	// * `INVALID_ARGUMENT`: The client attempted to upload more than the
	//   server supported limit.
	//
	// Individual requests may return the following errors, additionally:
	//
	// * `RESOURCE_EXHAUSTED`: There is insufficient disk quota to store the blob.
	// * `INVALID_ARGUMENT`: The
	// [Digest][build.bazel.remote.execution.v2.Digest] does not match the
	// provided data.
	BatchUpdateBlobs(context.Context, *BatchUpdateBlobsRequest) (*BatchUpdateBlobsResponse, error)
	// Download many blobs at once.
	//
	// The server may enforce a limit of the combined total size of blobs
	// to be downloaded using this API. This limit may be obtained using the
	// [Capabilities][build.bazel.remote.execution.v2.Capabilities] API.
	// Requests exceeding the limit should either be split into smaller
	// chunks or downloaded using the
	// [ByteStream API][google.bytestream.ByteStream], as appropriate.
	//
	// This request is equivalent to calling a Bytestream `Read` request
	// on each individual blob, in parallel. The requests may succeed or fail
	// independently.
	//
	// Errors:
	//
	// * `INVALID_ARGUMENT`: The client attempted to read more than the
	//   server supported limit.
	//
	// Every error on individual read will be returned in the corresponding digest
	// status.
	BatchReadBlobs(context.Context, *BatchReadBlobsRequest) (*BatchReadBlobsResponse, error)
	// Fetch the entire directory tree rooted at a node.
	//
	// This request must be targeted at a
	// [Directory][build.bazel.remote.execution.v2.Directory] stored in the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage]
	// (CAS). The server will enumerate the `Directory` tree recursively and
	// return every node descended from the root.
	//
	// The GetTreeRequest.page_token parameter can be used to skip ahead in
	// the stream (e.g. when retrying a partially completed and aborted request),
	// by setting it to a value taken from GetTreeResponse.next_page_token of the
	// last successfully processed GetTreeResponse).
	//
	// The exact traversal order is unspecified and, unless retrieving subsequent
	// pages from an earlier request, is not guaranteed to be stable across
	// multiple invocations of `GetTree`.
	//
	// If part of the tree is missing from the CAS, the server will return the
	// portion present and omit the rest.
	//
	// Errors:
	//
	// * `NOT_FOUND`: The requested tree root is not present in the CAS.
	GetTree(*GetTreeRequest, ContentAddressableStorage_GetTreeServer) error
}

// UnimplementedContentAddressableStorageServer can be embedded to have forward compatible implementations.
type UnimplementedContentAddressableStorageServer struct {
}

func (*UnimplementedContentAddressableStorageServer) FindMissingBlobs(context.Context, *FindMissingBlobsRequest) (*FindMissingBlobsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FindMissingBlobs not implemented")
}
func (*UnimplementedContentAddressableStorageServer) BatchUpdateBlobs(context.Context, *BatchUpdateBlobsRequest) (*BatchUpdateBlobsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchUpdateBlobs not implemented")
}
func (*UnimplementedContentAddressableStorageServer) BatchReadBlobs(context.Context, *BatchReadBlobsRequest) (*BatchReadBlobsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchReadBlobs not implemented")
}
func (*UnimplementedContentAddressableStorageServer) GetTree(*GetTreeRequest, ContentAddressableStorage_GetTreeServer) error {
	return status1.Errorf(codes.Unimplemented, "method GetTree not implemented")
}

func RegisterContentAddressableStorageServer(s *grpc.Server, srv ContentAddressableStorageServer) {
	s.RegisterService(&_ContentAddressableStorage_serviceDesc, srv)
}

func _ContentAddressableStorage_FindMissingBlobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindMissingBlobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContentAddressableStorageServer).FindMissingBlobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/build.bazel.remote.execution.v2.ContentAddressableStorage/FindMissingBlobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContentAddressableStorageServer).FindMissingBlobs(ctx, req.(*FindMissingBlobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContentAddressableStorage_BatchUpdateBlobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateBlobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContentAddressableStorageServer).BatchUpdateBlobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/build.bazel.remote.execution.v2.ContentAddressableStorage/BatchUpdateBlobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContentAddressableStorageServer).BatchUpdateBlobs(ctx, req.(*BatchUpdateBlobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContentAddressableStorage_BatchReadBlobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchReadBlobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContentAddressableStorageServer).BatchReadBlobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/build.bazel.remote.execution.v2.ContentAddressableStorage/BatchReadBlobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContentAddressableStorageServer).BatchReadBlobs(ctx, req.(*BatchReadBlobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContentAddressableStorage_GetTree_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetTreeRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ContentAddressableStorageServer).GetTree(m, &contentAddressableStorageGetTreeServer{stream})
}

type ContentAddressableStorage_GetTreeServer interface {
	Send(*GetTreeResponse) error
	grpc.ServerStream
}

type contentAddressableStorageGetTreeServer struct {
	grpc.ServerStream
}

func (x *contentAddressableStorageGetTreeServer) Send(m *GetTreeResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _ContentAddressableStorage_serviceDesc = grpc.ServiceDesc{
	ServiceName: "build.bazel.remote.execution.v2.ContentAddressableStorage",
	HandlerType: (*ContentAddressableStorageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FindMissingBlobs",
			Handler:    _ContentAddressableStorage_FindMissingBlobs_Handler,
		},
		{
			MethodName: "BatchUpdateBlobs",
			Handler:    _ContentAddressableStorage_BatchUpdateBlobs_Handler,
		},
		{
			MethodName: "BatchReadBlobs",
			Handler:    _ContentAddressableStorage_BatchReadBlobs_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetTree",
			Handler:       _ContentAddressableStorage_GetTree_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "build/bazel/remote/execution/v2/remote_execution.proto",
}

// CapabilitiesClient is the client API for Capabilities service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CapabilitiesClient interface {
	// GetCapabilities returns the server capabilities configuration of the
	// remote endpoint.
	// Only the capabilities of the services supported by the endpoint will
	// be returned:
	// * Execution + CAS + Action Cache endpoints should return both
	//   CacheCapabilities and ExecutionCapabilities.
	// * Execution only endpoints should return ExecutionCapabilities.
	// * CAS + Action Cache only endpoints should return CacheCapabilities.
	GetCapabilities(ctx context.Context, in *GetCapabilitiesRequest, opts ...grpc.CallOption) (*ServerCapabilities, error)
}

type capabilitiesClient struct {
	cc grpc.ClientConnInterface
}

func NewCapabilitiesClient(cc grpc.ClientConnInterface) CapabilitiesClient {
	return &capabilitiesClient{cc}
}

func (c *capabilitiesClient) GetCapabilities(ctx context.Context, in *GetCapabilitiesRequest, opts ...grpc.CallOption) (*ServerCapabilities, error) {
	out := new(ServerCapabilities)
	err := c.cc.Invoke(ctx, "/build.bazel.remote.execution.v2.Capabilities/GetCapabilities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CapabilitiesServer is the server API for Capabilities service.
type CapabilitiesServer interface {
	// GetCapabilities returns the server capabilities configuration of the
	// remote endpoint.
	// Only the capabilities of the services supported by the endpoint will
	// be returned:
	// * Execution + CAS + Action Cache endpoints should return both
	//   CacheCapabilities and ExecutionCapabilities.
	// * Execution only endpoints should return ExecutionCapabilities.
	// * CAS + Action Cache only endpoints should return CacheCapabilities.
	GetCapabilities(context.Context, *GetCapabilitiesRequest) (*ServerCapabilities, error)
}

// UnimplementedCapabilitiesServer can be embedded to have forward compatible implementations.
type UnimplementedCapabilitiesServer struct {
}

func (*UnimplementedCapabilitiesServer) GetCapabilities(context.Context, *GetCapabilitiesRequest) (*ServerCapabilities, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetCapabilities not implemented")
}

func RegisterCapabilitiesServer(s *grpc.Server, srv CapabilitiesServer) {
	s.RegisterService(&_Capabilities_serviceDesc, srv)
}

func _Capabilities_GetCapabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCapabilitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CapabilitiesServer).GetCapabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/build.bazel.remote.execution.v2.Capabilities/GetCapabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CapabilitiesServer).GetCapabilities(ctx, req.(*GetCapabilitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Capabilities_serviceDesc = grpc.ServiceDesc{
	ServiceName: "build.bazel.remote.execution.v2.Capabilities",
	HandlerType: (*CapabilitiesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCapabilities",
			Handler:    _Capabilities_GetCapabilities_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "build/bazel/remote/execution/v2/remote_execution.proto",
}
