pub mod cli_util;
pub mod home_dir;
pub mod io_util;
pub mod menu_builder;
pub mod parser;

#[cfg(test)]
mod test {
  use crate::cli_util;

  #[test]
  fn parse_arg_test() {
    let parse_arg = super::parser::parse_args(
      vec!["todo", "add", "-c", "true", "--lol", "-none"]
        .into_iter()
        .map(String::from)
        .collect(),
    );
    dbg!(parse_arg);
  }

  #[test]
  fn input_test() {
    let input = super::io_util::input("Type in your name: ");
    dbg!(input);

    let input_other: i32 = super::io_util::input_other("Type in your age: ");
    dbg!(input_other);

    let input_other_repeat: i32 =
      super::io_util::input_other_repeat("Input the year you were born: ");
    dbg!(input_other_repeat);
  }

  #[test]
  fn cli_util_test() {
    const NUM: i32 = 1_000_000;

    for i in 0..NUM {
      cli_util::draw_progress_bar_message(
        ((i + 1) as f64) / (NUM as f64),
        100,
        "looping... ",
      );
    }
  }
}
