use std::io::{stdout, Write};

use crate::io_util::input;

/// pause the terminal
pub fn pause() {
    input("Press Enter to continue...");
}

/// percentage = the percentage of task done (It will be between 0 and 1 instead of 0 and 100)
///
/// division = the division of the progress bar
///
/// returns if division is 0
pub fn draw_progress_bar_custom(
    percentage: f64,
    division: usize,
    unfinished: &str,
    finished: &str,
    message: &str,
) {
    if division == 0 {
        return;
    }

    let mut progress_bar = vec![unfinished; division].into_boxed_slice();

    for i in 0..((percentage * 100.0) / (100.0 / division as f64)) as usize {
        progress_bar[i] = finished;
    }

    print!(
        "\r{}{:.2}% [{}] 100.00%",
        message,
        percentage * 100.0,
        progress_bar.join("")
    );
    stdout().flush().unwrap();
}

pub fn draw_progress_bar(percentage: f64, division: usize) {
    draw_progress_bar_custom(percentage, division, "-", "#", "");
}

pub fn draw_progress_bar_message(percentage: f64, division: usize, message: &str) {
    draw_progress_bar_custom(percentage, division, "-", "#", message);
}
