use std::{
    fmt::Debug,
    io::{stdin, stdout, Write},
    str::FromStr,
};

/// get input with the given output, similar to how input function works in python
///
/// crashes if failed to flush or read line
pub fn input(output: &str) -> String {
    print!("{}", output);
    stdout().flush().expect("Flush Failed");

    let mut input = String::new();
    stdin().read_line(&mut input).expect("Unable to read line!");
    input
}

/// input with the given type, crashes if failed to convert
pub fn input_other<T>(output: &str) -> T
where
    T: FromStr,
    T::Err: Debug,
{
    input(output)
        .trim()
        .parse::<T>()
        .expect("Failed to convert value!")
}

/// repeat forever until the user gets the correct input
pub fn input_other_repeat<T>(output: &str) -> T
where
    T: FromStr,
{
    let mut input_str = input(output);
    loop {
        match input_str.trim().parse::<T>() {
            Ok(value) => return value,
            Err(_) => {
                input_str =
                    input(format!("{} is not a valid input! Try again: ", input_str).as_str());
                continue;
            }
        }
    }
}
