pub const DISALLOWED_SCALAR_VALUES: [char; 310] = [
    // All C0, U+007F, and C1 control codes other than U+000A (newline),
    // U+0009 (horizontal tab), U+000D (carriage return), U+000C (form feed),
    // U+0007 (alert), U+001B (escape) and U+0085 (NEL). Many of these are
    // nonetheless disallowed, but handled via different mechanisms.
    '\0',
    '\u{1}',
    '\u{2}',
    '\u{3}',
    '\u{4}',
    '\u{5}',
    '\u{6}',
    '\u{7}',
    '\u{8}',
    '\u{b}',
    '\u{e}',
    '\u{f}',
    '\u{10}',
    '\u{11}',
    '\u{12}',
    '\u{13}',
    '\u{14}',
    '\u{15}',
    '\u{16}',
    '\u{17}',
    '\u{18}',
    '\u{19}',
    '\u{1a}',
    '\u{1b}',
    '\u{1c}',
    '\u{1d}',
    '\u{1e}',
    '\u{1f}',
    '\u{7f}',
    '\u{80}',
    '\u{81}',
    '\u{82}',
    '\u{83}',
    '\u{84}',
    '\u{86}',
    '\u{87}',
    '\u{88}',
    '\u{89}',
    '\u{8a}',
    '\u{8b}',
    '\u{8c}',
    '\u{8d}',
    '\u{8e}',
    '\u{8f}',
    '\u{90}',
    '\u{91}',
    '\u{92}',
    '\u{93}',
    '\u{94}',
    '\u{95}',
    '\u{96}',
    '\u{97}',
    '\u{98}',
    '\u{99}',
    '\u{9a}',
    '\u{9b}',
    '\u{9c}',
    '\u{9d}',
    '\u{9e}',
    '\u{9f}',
    // Unassigned characters with replacements.
    '\u{9e4}',
    '\u{9e5}',
    '\u{a64}',
    '\u{a65}',
    '\u{ae4}',
    '\u{ae5}',
    '\u{b64}',
    '\u{b65}',
    '\u{be4}',
    '\u{be5}',
    '\u{c64}',
    '\u{c65}',
    '\u{ce4}',
    '\u{ce5}',
    '\u{d64}',
    '\u{d65}',
    // Khmer characters erroneously invented by Unicode.
    '\u{17b4}',
    '\u{17b5}',
    '\u{17d8}',
    // Deprecated Format Characters
    '\u{206a}',
    '\u{206b}',
    '\u{206c}',
    '\u{206d}',
    '\u{206e}',
    '\u{206f}',
    // Unassigned characters with replacements.
    '\u{2072}',
    '\u{2073}',
    // Discouraged characters
    '\u{2df5}',
    // Interlinear Annotations
    '\u{fff9}',
    '\u{fffa}',
    '\u{fffb}',
    // Object Replacement Character
    '\u{fffc}',
    // Tag Characters
    '\u{e0000}',
    '\u{e0001}',
    '\u{e0002}',
    '\u{e0003}',
    '\u{e0004}',
    '\u{e0005}',
    '\u{e0006}',
    '\u{e0007}',
    '\u{e0008}',
    '\u{e0009}',
    '\u{e000a}',
    '\u{e000b}',
    '\u{e000c}',
    '\u{e000d}',
    '\u{e000e}',
    '\u{e000f}',
    '\u{e0010}',
    '\u{e0011}',
    '\u{e0012}',
    '\u{e0013}',
    '\u{e0014}',
    '\u{e0015}',
    '\u{e0016}',
    '\u{e0017}',
    '\u{e0018}',
    '\u{e0019}',
    '\u{e001a}',
    '\u{e001b}',
    '\u{e001c}',
    '\u{e001d}',
    '\u{e001e}',
    '\u{e001f}',
    '\u{e0020}',
    '\u{e0021}',
    '\u{e0022}',
    '\u{e0023}',
    '\u{e0024}',
    '\u{e0025}',
    '\u{e0026}',
    '\u{e0027}',
    '\u{e0028}',
    '\u{e0029}',
    '\u{e002a}',
    '\u{e002b}',
    '\u{e002c}',
    '\u{e002d}',
    '\u{e002e}',
    '\u{e002f}',
    '\u{e0030}',
    '\u{e0031}',
    '\u{e0032}',
    '\u{e0033}',
    '\u{e0034}',
    '\u{e0035}',
    '\u{e0036}',
    '\u{e0037}',
    '\u{e0038}',
    '\u{e0039}',
    '\u{e003a}',
    '\u{e003b}',
    '\u{e003c}',
    '\u{e003d}',
    '\u{e003e}',
    '\u{e003f}',
    '\u{e0040}',
    '\u{e0041}',
    '\u{e0042}',
    '\u{e0043}',
    '\u{e0044}',
    '\u{e0045}',
    '\u{e0046}',
    '\u{e0047}',
    '\u{e0048}',
    '\u{e0049}',
    '\u{e004a}',
    '\u{e004b}',
    '\u{e004c}',
    '\u{e004d}',
    '\u{e004e}',
    '\u{e004f}',
    '\u{e0050}',
    '\u{e0051}',
    '\u{e0052}',
    '\u{e0053}',
    '\u{e0054}',
    '\u{e0055}',
    '\u{e0056}',
    '\u{e0057}',
    '\u{e0058}',
    '\u{e0059}',
    '\u{e005a}',
    '\u{e005b}',
    '\u{e005c}',
    '\u{e005d}',
    '\u{e005e}',
    '\u{e005f}',
    '\u{e0060}',
    '\u{e0061}',
    '\u{e0062}',
    '\u{e0063}',
    '\u{e0064}',
    '\u{e0065}',
    '\u{e0066}',
    '\u{e0067}',
    '\u{e0068}',
    '\u{e0069}',
    '\u{e006a}',
    '\u{e006b}',
    '\u{e006c}',
    '\u{e006d}',
    '\u{e006e}',
    '\u{e006f}',
    '\u{e0070}',
    '\u{e0071}',
    '\u{e0072}',
    '\u{e0073}',
    '\u{e0074}',
    '\u{e0075}',
    '\u{e0076}',
    '\u{e0077}',
    '\u{e0078}',
    '\u{e0079}',
    '\u{e007a}',
    '\u{e007b}',
    '\u{e007c}',
    '\u{e007d}',
    '\u{e007e}',
    '\u{e007f}',
    // Noncharacters
    '\u{fffe}',
    '\u{ffff}',
    '\u{1fffe}',
    '\u{1ffff}',
    '\u{2fffe}',
    '\u{2ffff}',
    '\u{3fffe}',
    '\u{3ffff}',
    '\u{4fffe}',
    '\u{4ffff}',
    '\u{5fffe}',
    '\u{5ffff}',
    '\u{6fffe}',
    '\u{6ffff}',
    '\u{7fffe}',
    '\u{7ffff}',
    '\u{8fffe}',
    '\u{8ffff}',
    '\u{9fffe}',
    '\u{9ffff}',
    '\u{afffe}',
    '\u{affff}',
    '\u{bfffe}',
    '\u{bffff}',
    '\u{cfffe}',
    '\u{cffff}',
    '\u{dfffe}',
    '\u{dffff}',
    '\u{efffe}',
    '\u{effff}',
    '\u{ffffe}',
    '\u{fffff}',
    '\u{10fffe}',
    '\u{10ffff}',
    '\u{fdd0}',
    '\u{fdd1}',
    '\u{fdd2}',
    '\u{fdd3}',
    '\u{fdd4}',
    '\u{fdd5}',
    '\u{fdd6}',
    '\u{fdd7}',
    '\u{fdd8}',
    '\u{fdd9}',
    '\u{fdda}',
    '\u{fddb}',
    '\u{fddc}',
    '\u{fddd}',
    '\u{fdde}',
    '\u{fddf}',
    '\u{fde0}',
    '\u{fde1}',
    '\u{fde2}',
    '\u{fde3}',
    '\u{fde4}',
    '\u{fde5}',
    '\u{fde6}',
    '\u{fde7}',
    '\u{fde8}',
    '\u{fde9}',
    '\u{fdea}',
    '\u{fdeb}',
    '\u{fdec}',
    '\u{fded}',
    '\u{fdee}',
    '\u{fdef}',
    '\u{1d455}',
    '\u{1d49d}',
    '\u{1d4a0}',
    '\u{1d4a1}',
    '\u{1d4a3}',
    '\u{1d4a4}',
    '\u{1d4a7}',
    '\u{1d4a8}',
    '\u{1d4ad}',
    '\u{1d4ba}',
    '\u{1d4bc}',
    '\u{1d4c4}',
    '\u{1d506}',
    '\u{1d50b}',
    '\u{1d50c}',
    '\u{1d515}',
    '\u{1d51d}',
    '\u{1d53a}',
    '\u{1d53f}',
    '\u{1d545}',
    '\u{1d547}',
    '\u{1d548}',
    '\u{1d549}',
    '\u{1d551}',
];
