#[derive(Debug, Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum Qwerty {
	Esc,
	F1,
	F2,
	F3,
	F4,
	F5,
	F6,
	F7,
	F8,
	F9,
	F10,
	F11,
	F12,
	Tilda,
	One,
	Two,
	Three,
	Four,
	Five,
	Six,
	Seven,
	Eight,
	Nine,
	Zero,
	Dash,
	Equal,
	Backspace,
	Tab,
	Q,
	W,
	E,
	R,
	T,
	Y,
	U,
	I,
	O,
	P,
	LSqBracket,
	RSqBracket,
	Backslash,
	Caps,
	A,
	S,
	D,
	F,
	G,
	H,
	J,
	K,
	L,
	SemiColon,
	Parenthesis,
	Enter,
	LShift,
	Z,
	X,
	C,
	V,
	B,
	N,
	M,
	Comma,
	Period,
	Slash,
	RShift,
	LCtrl,
	LSuper,
	LAlt,
	Space,
	RAlt,
	RSuper,
	RCtrl,
	PrintScreen,
	ScrollLock,
	Pause,
	Insert,
	Home,
	PageUp,
	Delete,
	End,
	PageDown,
	ArrowUp,
	ArrowDown,
	ArrowLeft,
	ArrowRight,
	TrackMute,
	TrackVolDown,
	TrackVolUp,
	TrackPlayPause,
	TrackBack,
	TrackNext,
}

#[derive(Debug, Clone)]
pub enum Character {
	Backspace,
	Value(char),
}

impl Qwerty {
	pub fn into_char(self, shift: bool) -> Option<Character> {
		match shift {
			false =>
				match self {
					Qwerty::Esc => None,
					Qwerty::F1 => None,
					Qwerty::F2 => None,
					Qwerty::F3 => None,
					Qwerty::F4 => None,
					Qwerty::F5 => None,
					Qwerty::F6 => None,
					Qwerty::F7 => None,
					Qwerty::F8 => None,
					Qwerty::F9 => None,
					Qwerty::F10 => None,
					Qwerty::F11 => None,
					Qwerty::F12 => None,
					Qwerty::Tilda => Some(Character::Value('`')),
					Qwerty::One => Some(Character::Value('1')),
					Qwerty::Two => Some(Character::Value('2')),
					Qwerty::Three => Some(Character::Value('3')),
					Qwerty::Four => Some(Character::Value('4')),
					Qwerty::Five => Some(Character::Value('5')),
					Qwerty::Six => Some(Character::Value('6')),
					Qwerty::Seven => Some(Character::Value('7')),
					Qwerty::Eight => Some(Character::Value('8')),
					Qwerty::Nine => Some(Character::Value('9')),
					Qwerty::Zero => Some(Character::Value('0')),
					Qwerty::Dash => Some(Character::Value('-')),
					Qwerty::Equal => Some(Character::Value('=')),
					Qwerty::Backspace => Some(Character::Backspace),
					Qwerty::Tab => None,
					Qwerty::Q => Some(Character::Value('q')),
					Qwerty::W => Some(Character::Value('w')),
					Qwerty::E => Some(Character::Value('e')),
					Qwerty::R => Some(Character::Value('r')),
					Qwerty::T => Some(Character::Value('t')),
					Qwerty::Y => Some(Character::Value('y')),
					Qwerty::U => Some(Character::Value('u')),
					Qwerty::I => Some(Character::Value('i')),
					Qwerty::O => Some(Character::Value('o')),
					Qwerty::P => Some(Character::Value('p')),
					Qwerty::LSqBracket => Some(Character::Value('[')),
					Qwerty::RSqBracket => Some(Character::Value(']')),
					Qwerty::Backslash => Some(Character::Value('\\')),
					Qwerty::Caps => None,
					Qwerty::A => Some(Character::Value('a')),
					Qwerty::S => Some(Character::Value('s')),
					Qwerty::D => Some(Character::Value('d')),
					Qwerty::F => Some(Character::Value('f')),
					Qwerty::G => Some(Character::Value('g')),
					Qwerty::H => Some(Character::Value('h')),
					Qwerty::J => Some(Character::Value('j')),
					Qwerty::K => Some(Character::Value('k')),
					Qwerty::L => Some(Character::Value('l')),
					Qwerty::SemiColon => Some(Character::Value(';')),
					Qwerty::Parenthesis => Some(Character::Value('\'')),
					Qwerty::Enter => Some(Character::Value('\n')),
					Qwerty::LShift => None,
					Qwerty::Z => Some(Character::Value('z')),
					Qwerty::X => Some(Character::Value('x')),
					Qwerty::C => Some(Character::Value('c')),
					Qwerty::V => Some(Character::Value('v')),
					Qwerty::B => Some(Character::Value('b')),
					Qwerty::N => Some(Character::Value('n')),
					Qwerty::M => Some(Character::Value('m')),
					Qwerty::Comma => Some(Character::Value(',')),
					Qwerty::Period => Some(Character::Value('.')),
					Qwerty::Slash => Some(Character::Value('/')),
					Qwerty::RShift => None,
					Qwerty::LCtrl => None,
					Qwerty::LSuper => None,
					Qwerty::LAlt => None,
					Qwerty::Space => Some(Character::Value(' ')),
					Qwerty::RAlt => None,
					Qwerty::RSuper => None,
					Qwerty::RCtrl => None,
					Qwerty::PrintScreen => None,
					Qwerty::ScrollLock => None,
					Qwerty::Pause => None,
					Qwerty::Insert => None,
					Qwerty::Home => None,
					Qwerty::PageUp => None,
					Qwerty::Delete => None,
					Qwerty::End => None,
					Qwerty::PageDown => None,
					Qwerty::ArrowUp => None,
					Qwerty::ArrowLeft => None,
					Qwerty::ArrowDown => None,
					Qwerty::ArrowRight => None,
					Qwerty::TrackMute => None,
					Qwerty::TrackVolDown => None,
					Qwerty::TrackVolUp => None,
					Qwerty::TrackPlayPause => None,
					Qwerty::TrackBack => None,
					Qwerty::TrackNext => None,
				},
			true =>
				match self {
					Qwerty::Esc => None,
					Qwerty::F1 => None,
					Qwerty::F2 => None,
					Qwerty::F3 => None,
					Qwerty::F4 => None,
					Qwerty::F5 => None,
					Qwerty::F6 => None,
					Qwerty::F7 => None,
					Qwerty::F8 => None,
					Qwerty::F9 => None,
					Qwerty::F10 => None,
					Qwerty::F11 => None,
					Qwerty::F12 => None,
					Qwerty::Tilda => Some(Character::Value('~')),
					Qwerty::One => Some(Character::Value('!')),
					Qwerty::Two => Some(Character::Value('@')),
					Qwerty::Three => Some(Character::Value('#')),
					Qwerty::Four => Some(Character::Value('$')),
					Qwerty::Five => Some(Character::Value('%')),
					Qwerty::Six => Some(Character::Value('^')),
					Qwerty::Seven => Some(Character::Value('&')),
					Qwerty::Eight => Some(Character::Value('*')),
					Qwerty::Nine => Some(Character::Value('(')),
					Qwerty::Zero => Some(Character::Value(')')),
					Qwerty::Dash => Some(Character::Value('_')),
					Qwerty::Equal => Some(Character::Value('+')),
					Qwerty::Backspace => Some(Character::Backspace),
					Qwerty::Tab => None,
					Qwerty::Q => Some(Character::Value('Q')),
					Qwerty::W => Some(Character::Value('W')),
					Qwerty::E => Some(Character::Value('E')),
					Qwerty::R => Some(Character::Value('R')),
					Qwerty::T => Some(Character::Value('T')),
					Qwerty::Y => Some(Character::Value('Y')),
					Qwerty::U => Some(Character::Value('U')),
					Qwerty::I => Some(Character::Value('I')),
					Qwerty::O => Some(Character::Value('O')),
					Qwerty::P => Some(Character::Value('P')),
					Qwerty::LSqBracket => Some(Character::Value('{')),
					Qwerty::RSqBracket => Some(Character::Value('}')),
					Qwerty::Backslash => Some(Character::Value('|')),
					Qwerty::Caps => None,
					Qwerty::A => Some(Character::Value('A')),
					Qwerty::S => Some(Character::Value('S')),
					Qwerty::D => Some(Character::Value('D')),
					Qwerty::F => Some(Character::Value('F')),
					Qwerty::G => Some(Character::Value('G')),
					Qwerty::H => Some(Character::Value('H')),
					Qwerty::J => Some(Character::Value('J')),
					Qwerty::K => Some(Character::Value('K')),
					Qwerty::L => Some(Character::Value('L')),
					Qwerty::SemiColon => Some(Character::Value(':')),
					Qwerty::Parenthesis => Some(Character::Value('"')),
					Qwerty::Enter => Some(Character::Value('\n')),
					Qwerty::LShift => None,
					Qwerty::Z => Some(Character::Value('Z')),
					Qwerty::X => Some(Character::Value('X')),
					Qwerty::C => Some(Character::Value('C')),
					Qwerty::V => Some(Character::Value('V')),
					Qwerty::B => Some(Character::Value('B')),
					Qwerty::N => Some(Character::Value('N')),
					Qwerty::M => Some(Character::Value('M')),
					Qwerty::Comma => Some(Character::Value('<')),
					Qwerty::Period => Some(Character::Value('>')),
					Qwerty::Slash => Some(Character::Value('?')),
					Qwerty::RShift => None,
					Qwerty::LCtrl => None,
					Qwerty::LSuper => None,
					Qwerty::LAlt => None,
					Qwerty::Space => Some(Character::Value(' ')),
					Qwerty::RAlt => None,
					Qwerty::RSuper => None,
					Qwerty::RCtrl => None,
					Qwerty::PrintScreen => None,
					Qwerty::ScrollLock => None,
					Qwerty::Pause => None,
					Qwerty::Insert => None,
					Qwerty::Home => None,
					Qwerty::PageUp => None,
					Qwerty::Delete => None,
					Qwerty::End => None,
					Qwerty::PageDown => None,
					Qwerty::ArrowUp => None,
					Qwerty::ArrowLeft => None,
					Qwerty::ArrowDown => None,
					Qwerty::ArrowRight => None,
					Qwerty::TrackMute => None,
					Qwerty::TrackVolDown => None,
					Qwerty::TrackVolUp => None,
					Qwerty::TrackPlayPause => None,
					Qwerty::TrackBack => None,
					Qwerty::TrackNext => None,
				},
		}
	}
}

impl Into<u32> for Qwerty {
	fn into(self) -> u32 {
		// Linux X11
		match self {
			Qwerty::Esc => 1,
			Qwerty::F1 => 59,
			Qwerty::F2 => 60,
			Qwerty::F3 => 61,
			Qwerty::F4 => 62,
			Qwerty::F5 => 63,
			Qwerty::F6 => 64,
			Qwerty::F7 => 65,
			Qwerty::F8 => 66,
			Qwerty::F9 => 67,
			Qwerty::F10 => 68,
			Qwerty::F11 => 87,
			Qwerty::F12 => 88,
			Qwerty::Tilda => 41,
			Qwerty::One => 2,
			Qwerty::Two => 3,
			Qwerty::Three => 4,
			Qwerty::Four => 5,
			Qwerty::Five => 6,
			Qwerty::Six => 7,
			Qwerty::Seven => 8,
			Qwerty::Eight => 9,
			Qwerty::Nine => 10,
			Qwerty::Zero => 11,
			Qwerty::Dash => 12,
			Qwerty::Equal => 13,
			Qwerty::Backspace => 14,
			Qwerty::Tab => 15,
			Qwerty::Q => 16,
			Qwerty::W => 17,
			Qwerty::E => 18,
			Qwerty::R => 19,
			Qwerty::T => 20,
			Qwerty::Y => 21,
			Qwerty::U => 22,
			Qwerty::I => 23,
			Qwerty::O => 24,
			Qwerty::P => 25,
			Qwerty::LSqBracket => 26,
			Qwerty::RSqBracket => 27,
			Qwerty::Backslash => 43,
			Qwerty::Caps => 58,
			Qwerty::A => 30,
			Qwerty::S => 31,
			Qwerty::D => 32,
			Qwerty::F => 33,
			Qwerty::G => 34,
			Qwerty::H => 35,
			Qwerty::J => 36,
			Qwerty::K => 37,
			Qwerty::L => 38,
			Qwerty::SemiColon => 39,
			Qwerty::Parenthesis => 40,
			Qwerty::Enter => 28,
			Qwerty::LShift => 42,
			Qwerty::Z => 44,
			Qwerty::X => 45,
			Qwerty::C => 46,
			Qwerty::V => 47,
			Qwerty::B => 48,
			Qwerty::N => 49,
			Qwerty::M => 50,
			Qwerty::Comma => 51,
			Qwerty::Period => 52,
			Qwerty::Slash => 53,
			Qwerty::RShift => 54,
			Qwerty::LCtrl => 29,
			Qwerty::LAlt => 56,
			Qwerty::Space => 57,
			Qwerty::RAlt => 100,
			Qwerty::RSuper => 126,
			Qwerty::RCtrl => 97,
			Qwerty::PrintScreen => 99,
			Qwerty::ScrollLock => 70,
			Qwerty::Insert => 110,
			Qwerty::TrackMute => 113,
			Qwerty::TrackVolDown => 114,
			Qwerty::TrackVolUp => 115,
			Qwerty::TrackPlayPause => 164,
			Qwerty::TrackBack => 165,
			Qwerty::TrackNext => 163,
			_ => {
				#[cfg(target_os = "windows")]
				{
					match self {
						Qwerty::LSuper => 71,
						Qwerty::RSuper => 92,
						Qwerty::RCtrl => 29,
						Qwerty::Pause => 69,
						Qwerty::Home => 71,
						Qwerty::PageUp => 73,
						Qwerty::Delete => 83,
						Qwerty::End => 79,
						Qwerty::PageDown => 81,
						Qwerty::ArrowUp => 72,
						Qwerty::ArrowLeft => 75,
						Qwerty::ArrowDown => 80,
						Qwerty::ArrowRight => 77,
						_ => unreachable!(),
					}
				}
				#[cfg(not(target_os = "windows"))]
				{
					match self {
						Qwerty::LSuper => 125,
						Qwerty::RSuper => 126,
						Qwerty::RCtrl => 97,
						Qwerty::Pause => 119,
						Qwerty::Home => 102,
						Qwerty::PageUp => 104,
						Qwerty::Delete => 111,
						Qwerty::End => 107,
						Qwerty::PageDown => 109,
						Qwerty::ArrowUp => 103,
						Qwerty::ArrowLeft => 105,
						Qwerty::ArrowDown => 108,
						Qwerty::ArrowRight => 106,
						_ => unreachable!(),
					}
				}
			},
		}
	}
}

// TODO: Replace with try_from when that is stable
impl From<u32> for Qwerty {
	fn from(code: u32) -> Qwerty {
		// Linux X11
		match code {
			1 => Qwerty::Esc,
			59 => Qwerty::F1,
			60 => Qwerty::F2,
			61 => Qwerty::F3,
			62 => Qwerty::F4,
			63 => Qwerty::F5,
			64 => Qwerty::F6,
			65 => Qwerty::F7,
			66 => Qwerty::F8,
			67 => Qwerty::F9,
			68 => Qwerty::F10,
			87 => Qwerty::F11,
			88 => Qwerty::F12,
			41 => Qwerty::Tilda,
			2 => Qwerty::One,
			3 => Qwerty::Two,
			4 => Qwerty::Three,
			5 => Qwerty::Four,
			6 => Qwerty::Five,
			7 => Qwerty::Six,
			8 => Qwerty::Seven,
			9 => Qwerty::Eight,
			10 => Qwerty::Nine,
			11 => Qwerty::Zero,
			12 => Qwerty::Dash,
			13 => Qwerty::Equal,
			14 => Qwerty::Backspace,
			15 => Qwerty::Tab,
			16 => Qwerty::Q,
			17 => Qwerty::W,
			18 => Qwerty::E,
			19 => Qwerty::R,
			20 => Qwerty::T,
			21 => Qwerty::Y,
			22 => Qwerty::U,
			23 => Qwerty::I,
			24 => Qwerty::O,
			25 => Qwerty::P,
			26 => Qwerty::LSqBracket,
			27 => Qwerty::RSqBracket,
			43 => Qwerty::Backslash,
			58 => Qwerty::Caps,
			30 => Qwerty::A,
			31 => Qwerty::S,
			32 => Qwerty::D,
			33 => Qwerty::F,
			34 => Qwerty::G,
			35 => Qwerty::H,
			36 => Qwerty::J,
			37 => Qwerty::K,
			38 => Qwerty::L,
			39 => Qwerty::SemiColon,
			40 => Qwerty::Parenthesis,
			28 => Qwerty::Enter,
			42 => Qwerty::LShift,
			44 => Qwerty::Z,
			45 => Qwerty::X,
			46 => Qwerty::C,
			47 => Qwerty::V,
			48 => Qwerty::B,
			49 => Qwerty::N,
			50 => Qwerty::M,
			51 => Qwerty::Comma,
			52 => Qwerty::Period,
			53 => Qwerty::Slash,
			54 => Qwerty::RShift,
			29 => Qwerty::LCtrl,
			56 => Qwerty::LAlt,
			57 => Qwerty::Space,
			100 => Qwerty::RAlt,
			99 => Qwerty::PrintScreen,
			70 => Qwerty::ScrollLock,
			110 => Qwerty::Insert,
			113 => Qwerty::TrackMute,
			114 => Qwerty::TrackVolDown,
			115 => Qwerty::TrackVolUp,
			164 => Qwerty::TrackPlayPause,
			165 => Qwerty::TrackBack,
			163 => Qwerty::TrackNext,
			_ => {
				#[cfg(target_os = "windows")]
				{
					match code {
						91 => Qwerty::LSuper,
						92 => Qwerty::RSuper,
						29 => Qwerty::RCtrl,
						69 => Qwerty::Pause,
						71 => Qwerty::Home,
						73 => Qwerty::PageUp,
						83 => Qwerty::Delete,
						79 => Qwerty::End,
						81 => Qwerty::PageDown,
						72 => Qwerty::ArrowUp,
						75 => Qwerty::ArrowLeft,
						80 => Qwerty::ArrowDown,
						77 => Qwerty::ArrowRight,
						_ => {
							println!("Qwerty from ScanCode: Unsupported keycode: {}", code);
							Qwerty::Esc
						},
					}
				}
				#[cfg(not(target_os = "windows"))]
				{
					match code {
						125 => Qwerty::LSuper,
						126 => Qwerty::RSuper,
						97 => Qwerty::RCtrl,
						119 => Qwerty::Pause,
						102 => Qwerty::Home,
						104 => Qwerty::PageUp,
						111 => Qwerty::Delete,
						107 => Qwerty::End,
						109 => Qwerty::PageDown,
						103 => Qwerty::ArrowUp,
						105 => Qwerty::ArrowLeft,
						108 => Qwerty::ArrowDown,
						106 => Qwerty::ArrowRight,
						_ => {
							println!("Qwerty from ScanCode: Unsupported keycode: {}", code);
							Qwerty::Esc
						},
					}
				}
			},
		}
	}
}
