use serde::{de, Deserialize, Deserializer};
use std::str::FromStr;

/// Binance WebSocket client implementing the ExchangeClient trait.
pub mod binance;

/// Bitstamp WebSocket client implementing the ExchangeClient trait.
pub mod bitstamp;

/// Custom [Deserializer] function to deserialize an input [str] to a [f64].
pub fn de_str_to_f64<'de, D>(deserializer: D) -> Result<f64, D::Error>
where
    D: Deserializer<'de>,
{
    let input_str: &str = Deserialize::deserialize(deserializer)?;
    f64::from_str(input_str).map_err(de::Error::custom)
}
