use bare_metrics_recorder::recording::BareMetricsRecorderCore;
use metrics::{histogram, register_histogram, Unit};
use std::fs::File;
use std::time::Duration;

pub fn main() -> anyhow::Result<()> {
    let (shard, stopper) =
        BareMetricsRecorderCore::new(File::create("/tmp/histogram-example.baremetrics")?)
            .start("histogramdemo".to_string())?;
    shard.install_as_metrics_recorder()?;
    register_histogram!("my_hist", Unit::BitsPerSecond, "Some thing :).");

    for x in 0..300 {
        histogram!("my_hist", x as f64);
        std::thread::sleep(Duration::from_secs(1));
    }

    stopper.stop();

    Ok(())
}
