use bare_metrics_recorder::recording::BareMetricsRecorderCore;
use metrics::{increment_counter, register_counter, Unit};
use std::fs::File;
use std::time::Duration;

pub fn main() -> anyhow::Result<()> {
    let (shard, stopper) =
        BareMetricsRecorderCore::new(File::create("/tmp/counter-example.baremetrics")?)
            .start("counterdemo".to_string())?;
    shard.install_as_metrics_recorder()?;
    register_counter!("my_counter", Unit::BitsPerSecond, "Some counter thing :).");

    for _ in 0..300 {
        increment_counter!("my_counter");
        std::thread::sleep(Duration::from_secs(1));
    }

    stopper.stop();

    Ok(())
}
