mod barbfile;
mod executor;
mod output;

use std::slice::Iter;

use executor::{Context, Executor};
use output::BarbOutput;

use clap::Parser;

use std::env;

use dotenv::dotenv;

#[derive(Parser, Debug)]
#[clap(version)]
struct Args {
    #[clap(short, long)]
    headers: bool,
    #[clap(short, long)]
    all_headers: bool,
    #[clap(short, long)]
    body: bool,
    #[clap(short, long)]
    raw: bool,
    #[clap(short, long)]
    filter: Option<String>,
    #[clap(short, long)]
    no_color: bool,
    files: Vec<String>,
}

impl Args {
    pub fn files_iter(&self) -> Iter<String> {
        self.files.iter()
    }

    pub fn jq_filter(&self) -> &Option<String> {
        &self.filter
    }

    pub fn output(&self) -> BarbOutput {
        BarbOutput::new(
            !self.body,
            self.all_headers,
            self.headers || self.all_headers || !self.body,
            !self.headers || self.body,
            self.raw,
            !self.no_color,
        )
    }
}

fn main() {
    let args = Args::parse();
    dotenv().ok();
    let mut executor = Executor::new(Context::new(env::vars()));
    let output = args.output();

    for file in args.files_iter() {
        match executor.execute(file, &output, args.jq_filter()) {
            Ok(()) => (),
            Err(err) => println!("{}", err),
        }
    }
}
