BARB
====

![Barb logo](doc/logo-readme.png)

Barb is a file-based API query tool that works nicely with version control and fits into UNIX terminal usage.

## Example usage

```
barb [options] <file 1> <file 2> ... <file n>
```

### CLI options

- `-a, --all-headers`: Print all headers, request and response
- `-b, --body`: Only print the response body
- `-h, --headers`: Only print the response headers
- `-r, --raw`: Don't format the response body
- `-V, --version`: Print the software version
- `-n, --no-color`: Don't use color output

## Barb format

Barb uses a custom file format to perform requests. Each file contains _one_ request and is started by a request preamble. Example:

```
#POST^http://my-blog.com/posts
#Authorization: TOKEN {API_TOKEN}
#|jq.filter

{
    "title": "A post",
    "content": "My pretty blog post"
}

```

The preamble contains the directives relevant to performing the request, such as the method, URL and headers. The preamble _must end with an empty line_.

### Verb line

The verb line indicates to _barb_ what sort of request to perform and where to. It follows this rigid format:

```
#<METHOD>^<URL>
```

The `URL` supports variable substitution, but `METHOD` does not.

Supported methods are:

- GET
- POST
- PUT
- DELETE
- PATCH

### Headers

Headers are formatted as follows:

```
#<HEADER NAME>: <HEADER VALUE>
```

The `HEADER VALUE` supports variable substitution, `HEADER NAME` does not.

There can be none or many headers.

### Filter

Barb supports JQ filtering of the response body. This has the following format:

```
#|<JQ FILTER>
```

The `JQ FILTER` supports variable substitution. Refer to the [JQ manual](https://stedolan.github.io/jq/manual/#Basicfilters) for more information on the filters and their syntax.

### Body

Anything after the preamble is considered as a body and will be send in the request for the following methods:

- PUT
- POST
- PATCH

Body does not support variable substitution.

### Variable substitution

Barb can include environment variable values and variables defined in `.env` into the requests with the following placeholder format:

```
{VARIABLE NAME}
```

This allows to do the following:

```
$ export BASE_URL="http://127.0.0.1:8000"
$ cat api-status.barb
#GET^{BASE_URL}/api/v1/status

$ barb api-status.barb
200 OK GET http://127.0.0.1:8000/api/v1/status
{
    "status": "OK"
}
```

## Credits

- Code: [Guillaume Pasquet](https://gitlab.com/guillaume54/)
- Logo: [Harpoon Chain Icon](https://game-icons.net/1x1/lorc/harpoon-chain.html) by Lorc under CC By 3.0

