#![allow(non_upper_case_globals)]

mod methods;
mod traits;

pub use float::*;

#[cfg(feature = "f32")]
mod float {
    /// Float Type
    pub type Float = f32;
    /// constant π
    pub const Pi: Float = std::f32::consts::PI;
}

#[cfg(feature = "f64")]
mod float {
    /// Float Type
    pub type Float = f64;
    /// constant π
    pub const Pi: Float = std::f64::consts::PI;
}

/// A circle in 2D plane.
pub type Circle = Ball<2>;

/// A ball in n-dimensional space.
pub struct Ball<const N: usize> {
    /// N dimensional center
    pub center: [Float; N],
    /// Radius of n-ball
    pub radius: Float,
}
