use core::fmt;

use cstr_core::CStr;
use num_traits::ToPrimitive;

use bad64_sys::*;

/// A system register
#[derive(Clone, Copy, Debug, Eq, Hash, PartialEq, FromPrimitive, ToPrimitive)]
#[repr(u32)]
#[allow(non_camel_case_types)]
pub enum SysReg {
    OSDTRRX_EL1 = SystemReg_REG_OSDTRRX_EL1 as u32,
    DBGBVR0_EL1 = SystemReg_REG_DBGBVR0_EL1 as u32,
    DBGBCR0_EL1 = SystemReg_REG_DBGBCR0_EL1 as u32,
    DBGWVR0_EL1 = SystemReg_REG_DBGWVR0_EL1 as u32,
    DBGWCR0_EL1 = SystemReg_REG_DBGWCR0_EL1 as u32,
    DBGBVR1_EL1 = SystemReg_REG_DBGBVR1_EL1 as u32,
    DBGBCR1_EL1 = SystemReg_REG_DBGBCR1_EL1 as u32,
    DBGWVR1_EL1 = SystemReg_REG_DBGWVR1_EL1 as u32,
    DBGWCR1_EL1 = SystemReg_REG_DBGWCR1_EL1 as u32,
    MDCCINT_EL1 = SystemReg_REG_MDCCINT_EL1 as u32,
    MDSCR_EL1 = SystemReg_REG_MDSCR_EL1 as u32,
    DBGBVR2_EL1 = SystemReg_REG_DBGBVR2_EL1 as u32,
    DBGBCR2_EL1 = SystemReg_REG_DBGBCR2_EL1 as u32,
    DBGWVR2_EL1 = SystemReg_REG_DBGWVR2_EL1 as u32,
    DBGWCR2_EL1 = SystemReg_REG_DBGWCR2_EL1 as u32,
    OSDTRTX_EL1 = SystemReg_REG_OSDTRTX_EL1 as u32,
    DBGBVR3_EL1 = SystemReg_REG_DBGBVR3_EL1 as u32,
    DBGBCR3_EL1 = SystemReg_REG_DBGBCR3_EL1 as u32,
    DBGWVR3_EL1 = SystemReg_REG_DBGWVR3_EL1 as u32,
    DBGWCR3_EL1 = SystemReg_REG_DBGWCR3_EL1 as u32,
    DBGBVR4_EL1 = SystemReg_REG_DBGBVR4_EL1 as u32,
    DBGBCR4_EL1 = SystemReg_REG_DBGBCR4_EL1 as u32,
    DBGWVR4_EL1 = SystemReg_REG_DBGWVR4_EL1 as u32,
    DBGWCR4_EL1 = SystemReg_REG_DBGWCR4_EL1 as u32,
    DBGBVR5_EL1 = SystemReg_REG_DBGBVR5_EL1 as u32,
    DBGBCR5_EL1 = SystemReg_REG_DBGBCR5_EL1 as u32,
    DBGWVR5_EL1 = SystemReg_REG_DBGWVR5_EL1 as u32,
    DBGWCR5_EL1 = SystemReg_REG_DBGWCR5_EL1 as u32,
    OSECCR_EL1 = SystemReg_REG_OSECCR_EL1 as u32,
    DBGBVR6_EL1 = SystemReg_REG_DBGBVR6_EL1 as u32,
    DBGBCR6_EL1 = SystemReg_REG_DBGBCR6_EL1 as u32,
    DBGWVR6_EL1 = SystemReg_REG_DBGWVR6_EL1 as u32,
    DBGWCR6_EL1 = SystemReg_REG_DBGWCR6_EL1 as u32,
    DBGBVR7_EL1 = SystemReg_REG_DBGBVR7_EL1 as u32,
    DBGBCR7_EL1 = SystemReg_REG_DBGBCR7_EL1 as u32,
    DBGWVR7_EL1 = SystemReg_REG_DBGWVR7_EL1 as u32,
    DBGWCR7_EL1 = SystemReg_REG_DBGWCR7_EL1 as u32,
    DBGBVR8_EL1 = SystemReg_REG_DBGBVR8_EL1 as u32,
    DBGBCR8_EL1 = SystemReg_REG_DBGBCR8_EL1 as u32,
    DBGWVR8_EL1 = SystemReg_REG_DBGWVR8_EL1 as u32,
    DBGWCR8_EL1 = SystemReg_REG_DBGWCR8_EL1 as u32,
    DBGBVR9_EL1 = SystemReg_REG_DBGBVR9_EL1 as u32,
    DBGBCR9_EL1 = SystemReg_REG_DBGBCR9_EL1 as u32,
    DBGWVR9_EL1 = SystemReg_REG_DBGWVR9_EL1 as u32,
    DBGWCR9_EL1 = SystemReg_REG_DBGWCR9_EL1 as u32,
    DBGBVR10_EL1 = SystemReg_REG_DBGBVR10_EL1 as u32,
    DBGBCR10_EL1 = SystemReg_REG_DBGBCR10_EL1 as u32,
    DBGWVR10_EL1 = SystemReg_REG_DBGWVR10_EL1 as u32,
    DBGWCR10_EL1 = SystemReg_REG_DBGWCR10_EL1 as u32,
    DBGBVR11_EL1 = SystemReg_REG_DBGBVR11_EL1 as u32,
    DBGBCR11_EL1 = SystemReg_REG_DBGBCR11_EL1 as u32,
    DBGWVR11_EL1 = SystemReg_REG_DBGWVR11_EL1 as u32,
    DBGWCR11_EL1 = SystemReg_REG_DBGWCR11_EL1 as u32,
    DBGBVR12_EL1 = SystemReg_REG_DBGBVR12_EL1 as u32,
    DBGBCR12_EL1 = SystemReg_REG_DBGBCR12_EL1 as u32,
    DBGWVR12_EL1 = SystemReg_REG_DBGWVR12_EL1 as u32,
    DBGWCR12_EL1 = SystemReg_REG_DBGWCR12_EL1 as u32,
    DBGBVR13_EL1 = SystemReg_REG_DBGBVR13_EL1 as u32,
    DBGBCR13_EL1 = SystemReg_REG_DBGBCR13_EL1 as u32,
    DBGWVR13_EL1 = SystemReg_REG_DBGWVR13_EL1 as u32,
    DBGWCR13_EL1 = SystemReg_REG_DBGWCR13_EL1 as u32,
    DBGBVR14_EL1 = SystemReg_REG_DBGBVR14_EL1 as u32,
    DBGBCR14_EL1 = SystemReg_REG_DBGBCR14_EL1 as u32,
    DBGWVR14_EL1 = SystemReg_REG_DBGWVR14_EL1 as u32,
    DBGWCR14_EL1 = SystemReg_REG_DBGWCR14_EL1 as u32,
    DBGBVR15_EL1 = SystemReg_REG_DBGBVR15_EL1 as u32,
    DBGBCR15_EL1 = SystemReg_REG_DBGBCR15_EL1 as u32,
    DBGWVR15_EL1 = SystemReg_REG_DBGWVR15_EL1 as u32,
    DBGWCR15_EL1 = SystemReg_REG_DBGWCR15_EL1 as u32,
    OSLAR_EL1 = SystemReg_REG_OSLAR_EL1 as u32,
    OSDLR_EL1 = SystemReg_REG_OSDLR_EL1 as u32,
    DBGPRCR_EL1 = SystemReg_REG_DBGPRCR_EL1 as u32,
    DBGCLAIMSET_EL1 = SystemReg_REG_DBGCLAIMSET_EL1 as u32,
    DBGCLAIMCLR_EL1 = SystemReg_REG_DBGCLAIMCLR_EL1 as u32,
    TRCTRACEIDR = SystemReg_REG_TRCTRACEIDR as u32,
    TRCVICTLR = SystemReg_REG_TRCVICTLR as u32,
    TRCSEQEVR0 = SystemReg_REG_TRCSEQEVR0 as u32,
    TRCCNTRLDVR0 = SystemReg_REG_TRCCNTRLDVR0 as u32,
    TRCIMSPEC0 = SystemReg_REG_TRCIMSPEC0 as u32,
    TRCPRGCTLR = SystemReg_REG_TRCPRGCTLR as u32,
    TRCQCTLR = SystemReg_REG_TRCQCTLR as u32,
    TRCVIIECTLR = SystemReg_REG_TRCVIIECTLR as u32,
    TRCSEQEVR1 = SystemReg_REG_TRCSEQEVR1 as u32,
    TRCCNTRLDVR1 = SystemReg_REG_TRCCNTRLDVR1 as u32,
    TRCIMSPEC1 = SystemReg_REG_TRCIMSPEC1 as u32,
    TRCPROCSELR = SystemReg_REG_TRCPROCSELR as u32,
    TRCVISSCTLR = SystemReg_REG_TRCVISSCTLR as u32,
    TRCSEQEVR2 = SystemReg_REG_TRCSEQEVR2 as u32,
    TRCCNTRLDVR2 = SystemReg_REG_TRCCNTRLDVR2 as u32,
    TRCIMSPEC2 = SystemReg_REG_TRCIMSPEC2 as u32,
    TRCVIPCSSCTLR = SystemReg_REG_TRCVIPCSSCTLR as u32,
    TRCCNTRLDVR3 = SystemReg_REG_TRCCNTRLDVR3 as u32,
    TRCIMSPEC3 = SystemReg_REG_TRCIMSPEC3 as u32,
    TRCCONFIGR = SystemReg_REG_TRCCONFIGR as u32,
    TRCCNTCTLR0 = SystemReg_REG_TRCCNTCTLR0 as u32,
    TRCIMSPEC4 = SystemReg_REG_TRCIMSPEC4 as u32,
    TRCCNTCTLR1 = SystemReg_REG_TRCCNTCTLR1 as u32,
    TRCIMSPEC5 = SystemReg_REG_TRCIMSPEC5 as u32,
    TRCAUXCTLR = SystemReg_REG_TRCAUXCTLR as u32,
    TRCSEQRSTEVR = SystemReg_REG_TRCSEQRSTEVR as u32,
    TRCCNTCTLR2 = SystemReg_REG_TRCCNTCTLR2 as u32,
    TRCIMSPEC6 = SystemReg_REG_TRCIMSPEC6 as u32,
    TRCSEQSTR = SystemReg_REG_TRCSEQSTR as u32,
    TRCCNTCTLR3 = SystemReg_REG_TRCCNTCTLR3 as u32,
    TRCIMSPEC7 = SystemReg_REG_TRCIMSPEC7 as u32,
    TRCEVENTCTL0R = SystemReg_REG_TRCEVENTCTL0R as u32,
    TRCVDCTLR = SystemReg_REG_TRCVDCTLR as u32,
    TRCEXTINSELR = SystemReg_REG_TRCEXTINSELR as u32,
    TRCCNTVR0 = SystemReg_REG_TRCCNTVR0 as u32,
    TRCEVENTCTL1R = SystemReg_REG_TRCEVENTCTL1R as u32,
    TRCVDSACCTLR = SystemReg_REG_TRCVDSACCTLR as u32,
    TRCEXTINSELR1 = SystemReg_REG_TRCEXTINSELR1 as u32,
    TRCCNTVR1 = SystemReg_REG_TRCCNTVR1 as u32,
    TRCRSR = SystemReg_REG_TRCRSR as u32,
    TRCVDARCCTLR = SystemReg_REG_TRCVDARCCTLR as u32,
    TRCEXTINSELR2 = SystemReg_REG_TRCEXTINSELR2 as u32,
    TRCCNTVR2 = SystemReg_REG_TRCCNTVR2 as u32,
    TRCSTALLCTLR = SystemReg_REG_TRCSTALLCTLR as u32,
    TRCEXTINSELR3 = SystemReg_REG_TRCEXTINSELR3 as u32,
    TRCCNTVR3 = SystemReg_REG_TRCCNTVR3 as u32,
    TRCTSCTLR = SystemReg_REG_TRCTSCTLR as u32,
    TRCSYNCPR = SystemReg_REG_TRCSYNCPR as u32,
    TRCCCCTLR = SystemReg_REG_TRCCCCTLR as u32,
    TRCBBCTLR = SystemReg_REG_TRCBBCTLR as u32,
    TRCRSCTLR16 = SystemReg_REG_TRCRSCTLR16 as u32,
    TRCSSCCR0 = SystemReg_REG_TRCSSCCR0 as u32,
    TRCSSPCICR0 = SystemReg_REG_TRCSSPCICR0 as u32,
    TRCOSLAR = SystemReg_REG_TRCOSLAR as u32,
    TRCRSCTLR17 = SystemReg_REG_TRCRSCTLR17 as u32,
    TRCSSCCR1 = SystemReg_REG_TRCSSCCR1 as u32,
    TRCSSPCICR1 = SystemReg_REG_TRCSSPCICR1 as u32,
    TRCRSCTLR2 = SystemReg_REG_TRCRSCTLR2 as u32,
    TRCRSCTLR18 = SystemReg_REG_TRCRSCTLR18 as u32,
    TRCSSCCR2 = SystemReg_REG_TRCSSCCR2 as u32,
    TRCSSPCICR2 = SystemReg_REG_TRCSSPCICR2 as u32,
    TRCRSCTLR3 = SystemReg_REG_TRCRSCTLR3 as u32,
    TRCRSCTLR19 = SystemReg_REG_TRCRSCTLR19 as u32,
    TRCSSCCR3 = SystemReg_REG_TRCSSCCR3 as u32,
    TRCSSPCICR3 = SystemReg_REG_TRCSSPCICR3 as u32,
    TRCRSCTLR4 = SystemReg_REG_TRCRSCTLR4 as u32,
    TRCRSCTLR20 = SystemReg_REG_TRCRSCTLR20 as u32,
    TRCSSCCR4 = SystemReg_REG_TRCSSCCR4 as u32,
    TRCSSPCICR4 = SystemReg_REG_TRCSSPCICR4 as u32,
    TRCPDCR = SystemReg_REG_TRCPDCR as u32,
    TRCRSCTLR5 = SystemReg_REG_TRCRSCTLR5 as u32,
    TRCRSCTLR21 = SystemReg_REG_TRCRSCTLR21 as u32,
    TRCSSCCR5 = SystemReg_REG_TRCSSCCR5 as u32,
    TRCSSPCICR5 = SystemReg_REG_TRCSSPCICR5 as u32,
    TRCRSCTLR6 = SystemReg_REG_TRCRSCTLR6 as u32,
    TRCRSCTLR22 = SystemReg_REG_TRCRSCTLR22 as u32,
    TRCSSCCR6 = SystemReg_REG_TRCSSCCR6 as u32,
    TRCSSPCICR6 = SystemReg_REG_TRCSSPCICR6 as u32,
    TRCRSCTLR7 = SystemReg_REG_TRCRSCTLR7 as u32,
    TRCRSCTLR23 = SystemReg_REG_TRCRSCTLR23 as u32,
    TRCSSCCR7 = SystemReg_REG_TRCSSCCR7 as u32,
    TRCSSPCICR7 = SystemReg_REG_TRCSSPCICR7 as u32,
    TRCRSCTLR8 = SystemReg_REG_TRCRSCTLR8 as u32,
    TRCRSCTLR24 = SystemReg_REG_TRCRSCTLR24 as u32,
    TRCSSCSR0 = SystemReg_REG_TRCSSCSR0 as u32,
    TRCRSCTLR9 = SystemReg_REG_TRCRSCTLR9 as u32,
    TRCRSCTLR25 = SystemReg_REG_TRCRSCTLR25 as u32,
    TRCSSCSR1 = SystemReg_REG_TRCSSCSR1 as u32,
    TRCRSCTLR10 = SystemReg_REG_TRCRSCTLR10 as u32,
    TRCRSCTLR26 = SystemReg_REG_TRCRSCTLR26 as u32,
    TRCSSCSR2 = SystemReg_REG_TRCSSCSR2 as u32,
    TRCRSCTLR11 = SystemReg_REG_TRCRSCTLR11 as u32,
    TRCRSCTLR27 = SystemReg_REG_TRCRSCTLR27 as u32,
    TRCSSCSR3 = SystemReg_REG_TRCSSCSR3 as u32,
    TRCRSCTLR12 = SystemReg_REG_TRCRSCTLR12 as u32,
    TRCRSCTLR28 = SystemReg_REG_TRCRSCTLR28 as u32,
    TRCSSCSR4 = SystemReg_REG_TRCSSCSR4 as u32,
    TRCRSCTLR13 = SystemReg_REG_TRCRSCTLR13 as u32,
    TRCRSCTLR29 = SystemReg_REG_TRCRSCTLR29 as u32,
    TRCSSCSR5 = SystemReg_REG_TRCSSCSR5 as u32,
    TRCRSCTLR14 = SystemReg_REG_TRCRSCTLR14 as u32,
    TRCRSCTLR30 = SystemReg_REG_TRCRSCTLR30 as u32,
    TRCSSCSR6 = SystemReg_REG_TRCSSCSR6 as u32,
    TRCRSCTLR15 = SystemReg_REG_TRCRSCTLR15 as u32,
    TRCRSCTLR31 = SystemReg_REG_TRCRSCTLR31 as u32,
    TRCSSCSR7 = SystemReg_REG_TRCSSCSR7 as u32,
    TRCACVR0 = SystemReg_REG_TRCACVR0 as u32,
    TRCACVR8 = SystemReg_REG_TRCACVR8 as u32,
    TRCACATR0 = SystemReg_REG_TRCACATR0 as u32,
    TRCACATR8 = SystemReg_REG_TRCACATR8 as u32,
    TRCDVCVR0 = SystemReg_REG_TRCDVCVR0 as u32,
    TRCDVCVR4 = SystemReg_REG_TRCDVCVR4 as u32,
    TRCDVCMR0 = SystemReg_REG_TRCDVCMR0 as u32,
    TRCDVCMR4 = SystemReg_REG_TRCDVCMR4 as u32,
    TRCACVR1 = SystemReg_REG_TRCACVR1 as u32,
    TRCACVR9 = SystemReg_REG_TRCACVR9 as u32,
    TRCACATR1 = SystemReg_REG_TRCACATR1 as u32,
    TRCACATR9 = SystemReg_REG_TRCACATR9 as u32,
    TRCACVR2 = SystemReg_REG_TRCACVR2 as u32,
    TRCACVR10 = SystemReg_REG_TRCACVR10 as u32,
    TRCACATR2 = SystemReg_REG_TRCACATR2 as u32,
    TRCACATR10 = SystemReg_REG_TRCACATR10 as u32,
    TRCDVCVR1 = SystemReg_REG_TRCDVCVR1 as u32,
    TRCDVCVR5 = SystemReg_REG_TRCDVCVR5 as u32,
    TRCDVCMR1 = SystemReg_REG_TRCDVCMR1 as u32,
    TRCDVCMR5 = SystemReg_REG_TRCDVCMR5 as u32,
    TRCACVR3 = SystemReg_REG_TRCACVR3 as u32,
    TRCACVR11 = SystemReg_REG_TRCACVR11 as u32,
    TRCACATR3 = SystemReg_REG_TRCACATR3 as u32,
    TRCACATR11 = SystemReg_REG_TRCACATR11 as u32,
    TRCACVR4 = SystemReg_REG_TRCACVR4 as u32,
    TRCACVR12 = SystemReg_REG_TRCACVR12 as u32,
    TRCACATR4 = SystemReg_REG_TRCACATR4 as u32,
    TRCACATR12 = SystemReg_REG_TRCACATR12 as u32,
    TRCDVCVR2 = SystemReg_REG_TRCDVCVR2 as u32,
    TRCDVCVR6 = SystemReg_REG_TRCDVCVR6 as u32,
    TRCDVCMR2 = SystemReg_REG_TRCDVCMR2 as u32,
    TRCDVCMR6 = SystemReg_REG_TRCDVCMR6 as u32,
    TRCACVR5 = SystemReg_REG_TRCACVR5 as u32,
    TRCACVR13 = SystemReg_REG_TRCACVR13 as u32,
    TRCACATR5 = SystemReg_REG_TRCACATR5 as u32,
    TRCACATR13 = SystemReg_REG_TRCACATR13 as u32,
    TRCACVR6 = SystemReg_REG_TRCACVR6 as u32,
    TRCACVR14 = SystemReg_REG_TRCACVR14 as u32,
    TRCACATR6 = SystemReg_REG_TRCACATR6 as u32,
    TRCACATR14 = SystemReg_REG_TRCACATR14 as u32,
    TRCDVCVR3 = SystemReg_REG_TRCDVCVR3 as u32,
    TRCDVCVR7 = SystemReg_REG_TRCDVCVR7 as u32,
    TRCDVCMR3 = SystemReg_REG_TRCDVCMR3 as u32,
    TRCDVCMR7 = SystemReg_REG_TRCDVCMR7 as u32,
    TRCACVR7 = SystemReg_REG_TRCACVR7 as u32,
    TRCACVR15 = SystemReg_REG_TRCACVR15 as u32,
    TRCACATR7 = SystemReg_REG_TRCACATR7 as u32,
    TRCACATR15 = SystemReg_REG_TRCACATR15 as u32,
    TRCCIDCVR0 = SystemReg_REG_TRCCIDCVR0 as u32,
    TRCVMIDCVR0 = SystemReg_REG_TRCVMIDCVR0 as u32,
    TRCCIDCCTLR0 = SystemReg_REG_TRCCIDCCTLR0 as u32,
    TRCCIDCCTLR1 = SystemReg_REG_TRCCIDCCTLR1 as u32,
    TRCCIDCVR1 = SystemReg_REG_TRCCIDCVR1 as u32,
    TRCVMIDCVR1 = SystemReg_REG_TRCVMIDCVR1 as u32,
    TRCVMIDCCTLR0 = SystemReg_REG_TRCVMIDCCTLR0 as u32,
    TRCVMIDCCTLR1 = SystemReg_REG_TRCVMIDCCTLR1 as u32,
    TRCCIDCVR2 = SystemReg_REG_TRCCIDCVR2 as u32,
    TRCVMIDCVR2 = SystemReg_REG_TRCVMIDCVR2 as u32,
    TRCCIDCVR3 = SystemReg_REG_TRCCIDCVR3 as u32,
    TRCVMIDCVR3 = SystemReg_REG_TRCVMIDCVR3 as u32,
    TRCCIDCVR4 = SystemReg_REG_TRCCIDCVR4 as u32,
    TRCVMIDCVR4 = SystemReg_REG_TRCVMIDCVR4 as u32,
    TRCCIDCVR5 = SystemReg_REG_TRCCIDCVR5 as u32,
    TRCVMIDCVR5 = SystemReg_REG_TRCVMIDCVR5 as u32,
    TRCCIDCVR6 = SystemReg_REG_TRCCIDCVR6 as u32,
    TRCVMIDCVR6 = SystemReg_REG_TRCVMIDCVR6 as u32,
    TRCCIDCVR7 = SystemReg_REG_TRCCIDCVR7 as u32,
    TRCVMIDCVR7 = SystemReg_REG_TRCVMIDCVR7 as u32,
    TRCITCTRL = SystemReg_REG_TRCITCTRL as u32,
    TRCCLAIMSET = SystemReg_REG_TRCCLAIMSET as u32,
    TRCCLAIMCLR = SystemReg_REG_TRCCLAIMCLR as u32,
    TRCLAR = SystemReg_REG_TRCLAR as u32,
    TEECR32_EL1 = SystemReg_REG_TEECR32_EL1 as u32,
    TEEHBR32_EL1 = SystemReg_REG_TEEHBR32_EL1 as u32,
    DBGDTR_EL0 = SystemReg_REG_DBGDTR_EL0 as u32,
    DBGDTRTX_EL0 = SystemReg_REG_DBGDTRTX_EL0 as u32,
    DBGVCR32_EL2 = SystemReg_REG_DBGVCR32_EL2 as u32,
    SCTLR_EL1 = SystemReg_REG_SCTLR_EL1 as u32,
    ACTLR_EL1 = SystemReg_REG_ACTLR_EL1 as u32,
    CPACR_EL1 = SystemReg_REG_CPACR_EL1 as u32,
    RGSR_EL1 = SystemReg_REG_RGSR_EL1 as u32,
    GCR_EL1 = SystemReg_REG_GCR_EL1 as u32,
    TRFCR_EL1 = SystemReg_REG_TRFCR_EL1 as u32,
    TTBR0_EL1 = SystemReg_REG_TTBR0_EL1 as u32,
    TTBR1_EL1 = SystemReg_REG_TTBR1_EL1 as u32,
    TCR_EL1 = SystemReg_REG_TCR_EL1 as u32,
    APIAKEYLO_EL1 = SystemReg_REG_APIAKEYLO_EL1 as u32,
    APIAKEYHI_EL1 = SystemReg_REG_APIAKEYHI_EL1 as u32,
    APIBKEYLO_EL1 = SystemReg_REG_APIBKEYLO_EL1 as u32,
    APIBKEYHI_EL1 = SystemReg_REG_APIBKEYHI_EL1 as u32,
    APDAKEYLO_EL1 = SystemReg_REG_APDAKEYLO_EL1 as u32,
    APDAKEYHI_EL1 = SystemReg_REG_APDAKEYHI_EL1 as u32,
    APDBKEYLO_EL1 = SystemReg_REG_APDBKEYLO_EL1 as u32,
    APDBKEYHI_EL1 = SystemReg_REG_APDBKEYHI_EL1 as u32,
    APGAKEYLO_EL1 = SystemReg_REG_APGAKEYLO_EL1 as u32,
    APGAKEYHI_EL1 = SystemReg_REG_APGAKEYHI_EL1 as u32,
    SPSR_EL1 = SystemReg_REG_SPSR_EL1 as u32,
    ELR_EL1 = SystemReg_REG_ELR_EL1 as u32,
    SP_EL0 = SystemReg_REG_SP_EL0 as u32,
    SPSEL = SystemReg_REG_SPSEL as u32,
    CURRENTEL = SystemReg_REG_CURRENTEL as u32,
    PAN = SystemReg_REG_PAN as u32,
    UAO = SystemReg_REG_UAO as u32,
    ICC_PMR_EL1 = SystemReg_REG_ICC_PMR_EL1 as u32,
    AFSR0_EL1 = SystemReg_REG_AFSR0_EL1 as u32,
    AFSR1_EL1 = SystemReg_REG_AFSR1_EL1 as u32,
    ESR_EL1 = SystemReg_REG_ESR_EL1 as u32,
    ERRSELR_EL1 = SystemReg_REG_ERRSELR_EL1 as u32,
    ERXCTLR_EL1 = SystemReg_REG_ERXCTLR_EL1 as u32,
    ERXSTATUS_EL1 = SystemReg_REG_ERXSTATUS_EL1 as u32,
    ERXADDR_EL1 = SystemReg_REG_ERXADDR_EL1 as u32,
    ERXPFGCTL_EL1 = SystemReg_REG_ERXPFGCTL_EL1 as u32,
    ERXPFGCDN_EL1 = SystemReg_REG_ERXPFGCDN_EL1 as u32,
    ERXMISC0_EL1 = SystemReg_REG_ERXMISC0_EL1 as u32,
    ERXMISC1_EL1 = SystemReg_REG_ERXMISC1_EL1 as u32,
    ERXMISC2_EL1 = SystemReg_REG_ERXMISC2_EL1 as u32,
    ERXMISC3_EL1 = SystemReg_REG_ERXMISC3_EL1 as u32,
    ERXTS_EL1 = SystemReg_REG_ERXTS_EL1 as u32,
    TFSR_EL1 = SystemReg_REG_TFSR_EL1 as u32,
    TFSRE0_EL1 = SystemReg_REG_TFSRE0_EL1 as u32,
    FAR_EL1 = SystemReg_REG_FAR_EL1 as u32,
    PAR_EL1 = SystemReg_REG_PAR_EL1 as u32,
    PMSCR_EL1 = SystemReg_REG_PMSCR_EL1 as u32,
    PMSICR_EL1 = SystemReg_REG_PMSICR_EL1 as u32,
    PMSIRR_EL1 = SystemReg_REG_PMSIRR_EL1 as u32,
    PMSFCR_EL1 = SystemReg_REG_PMSFCR_EL1 as u32,
    PMSEVFR_EL1 = SystemReg_REG_PMSEVFR_EL1 as u32,
    PMSLATFR_EL1 = SystemReg_REG_PMSLATFR_EL1 as u32,
    PMSIDR_EL1 = SystemReg_REG_PMSIDR_EL1 as u32,
    PMBLIMITR_EL1 = SystemReg_REG_PMBLIMITR_EL1 as u32,
    PMBPTR_EL1 = SystemReg_REG_PMBPTR_EL1 as u32,
    PMBSR_EL1 = SystemReg_REG_PMBSR_EL1 as u32,
    PMBIDR_EL1 = SystemReg_REG_PMBIDR_EL1 as u32,
    TRBLIMITR_EL1 = SystemReg_REG_TRBLIMITR_EL1 as u32,
    TRBPTR_EL1 = SystemReg_REG_TRBPTR_EL1 as u32,
    TRBBASER_EL1 = SystemReg_REG_TRBBASER_EL1 as u32,
    TRBSR_EL1 = SystemReg_REG_TRBSR_EL1 as u32,
    TRBMAR_EL1 = SystemReg_REG_TRBMAR_EL1 as u32,
    TRBTRG_EL1 = SystemReg_REG_TRBTRG_EL1 as u32,
    PMINTENSET_EL1 = SystemReg_REG_PMINTENSET_EL1 as u32,
    PMINTENCLR_EL1 = SystemReg_REG_PMINTENCLR_EL1 as u32,
    PMMIR_EL1 = SystemReg_REG_PMMIR_EL1 as u32,
    MAIR_EL1 = SystemReg_REG_MAIR_EL1 as u32,
    AMAIR_EL1 = SystemReg_REG_AMAIR_EL1 as u32,
    LORSA_EL1 = SystemReg_REG_LORSA_EL1 as u32,
    LOREA_EL1 = SystemReg_REG_LOREA_EL1 as u32,
    LORN_EL1 = SystemReg_REG_LORN_EL1 as u32,
    LORC_EL1 = SystemReg_REG_LORC_EL1 as u32,
    MPAM1_EL1 = SystemReg_REG_MPAM1_EL1 as u32,
    MPAM0_EL1 = SystemReg_REG_MPAM0_EL1 as u32,
    VBAR_EL1 = SystemReg_REG_VBAR_EL1 as u32,
    RMR_EL1 = SystemReg_REG_RMR_EL1 as u32,
    DISR_EL1 = SystemReg_REG_DISR_EL1 as u32,
    ICC_EOIR0_EL1 = SystemReg_REG_ICC_EOIR0_EL1 as u32,
    ICC_BPR0_EL1 = SystemReg_REG_ICC_BPR0_EL1 as u32,
    ICC_AP0R0_EL1 = SystemReg_REG_ICC_AP0R0_EL1 as u32,
    ICC_AP0R1_EL1 = SystemReg_REG_ICC_AP0R1_EL1 as u32,
    ICC_AP0R2_EL1 = SystemReg_REG_ICC_AP0R2_EL1 as u32,
    ICC_AP0R3_EL1 = SystemReg_REG_ICC_AP0R3_EL1 as u32,
    ICC_AP1R0_EL1 = SystemReg_REG_ICC_AP1R0_EL1 as u32,
    ICC_AP1R1_EL1 = SystemReg_REG_ICC_AP1R1_EL1 as u32,
    ICC_AP1R2_EL1 = SystemReg_REG_ICC_AP1R2_EL1 as u32,
    ICC_AP1R3_EL1 = SystemReg_REG_ICC_AP1R3_EL1 as u32,
    ICC_DIR_EL1 = SystemReg_REG_ICC_DIR_EL1 as u32,
    ICC_SGI1R_EL1 = SystemReg_REG_ICC_SGI1R_EL1 as u32,
    ICC_ASGI1R_EL1 = SystemReg_REG_ICC_ASGI1R_EL1 as u32,
    ICC_SGI0R_EL1 = SystemReg_REG_ICC_SGI0R_EL1 as u32,
    ICC_EOIR1_EL1 = SystemReg_REG_ICC_EOIR1_EL1 as u32,
    ICC_BPR1_EL1 = SystemReg_REG_ICC_BPR1_EL1 as u32,
    ICC_CTLR_EL1 = SystemReg_REG_ICC_CTLR_EL1 as u32,
    ICC_SRE_EL1 = SystemReg_REG_ICC_SRE_EL1 as u32,
    ICC_IGRPEN0_EL1 = SystemReg_REG_ICC_IGRPEN0_EL1 as u32,
    ICC_IGRPEN1_EL1 = SystemReg_REG_ICC_IGRPEN1_EL1 as u32,
    ICC_SEIEN_EL1 = SystemReg_REG_ICC_SEIEN_EL1 as u32,
    CONTEXTIDR_EL1 = SystemReg_REG_CONTEXTIDR_EL1 as u32,
    TPIDR_EL1 = SystemReg_REG_TPIDR_EL1 as u32,
    SCXTNUM_EL1 = SystemReg_REG_SCXTNUM_EL1 as u32,
    CNTKCTL_EL1 = SystemReg_REG_CNTKCTL_EL1 as u32,
    CSSELR_EL1 = SystemReg_REG_CSSELR_EL1 as u32,
    NZCV = SystemReg_REG_NZCV as u32,
    DAIFSET = SystemReg_REG_DAIFSET as u32,
    DIT = SystemReg_REG_DIT as u32,
    SSBS = SystemReg_REG_SSBS as u32,
    TCO = SystemReg_REG_TCO as u32,
    FPCR = SystemReg_REG_FPCR as u32,
    FPSR = SystemReg_REG_FPSR as u32,
    DSPSR_EL0 = SystemReg_REG_DSPSR_EL0 as u32,
    DLR_EL0 = SystemReg_REG_DLR_EL0 as u32,
    PMCR_EL0 = SystemReg_REG_PMCR_EL0 as u32,
    PMCNTENSET_EL0 = SystemReg_REG_PMCNTENSET_EL0 as u32,
    PMCNTENCLR_EL0 = SystemReg_REG_PMCNTENCLR_EL0 as u32,
    PMOVSCLR_EL0 = SystemReg_REG_PMOVSCLR_EL0 as u32,
    PMSWINC_EL0 = SystemReg_REG_PMSWINC_EL0 as u32,
    PMSELR_EL0 = SystemReg_REG_PMSELR_EL0 as u32,
    PMCCNTR_EL0 = SystemReg_REG_PMCCNTR_EL0 as u32,
    PMXEVTYPER_EL0 = SystemReg_REG_PMXEVTYPER_EL0 as u32,
    PMXEVCNTR_EL0 = SystemReg_REG_PMXEVCNTR_EL0 as u32,
    DAIFCLR = SystemReg_REG_DAIFCLR as u32,
    PMUSERENR_EL0 = SystemReg_REG_PMUSERENR_EL0 as u32,
    PMOVSSET_EL0 = SystemReg_REG_PMOVSSET_EL0 as u32,
    TPIDR_EL0 = SystemReg_REG_TPIDR_EL0 as u32,
    TPIDRRO_EL0 = SystemReg_REG_TPIDRRO_EL0 as u32,
    SCXTNUM_EL0 = SystemReg_REG_SCXTNUM_EL0 as u32,
    AMCR_EL0 = SystemReg_REG_AMCR_EL0 as u32,
    AMUSERENR_EL0 = SystemReg_REG_AMUSERENR_EL0 as u32,
    AMCNTENCLR0_EL0 = SystemReg_REG_AMCNTENCLR0_EL0 as u32,
    AMCNTENSET0_EL0 = SystemReg_REG_AMCNTENSET0_EL0 as u32,
    AMCNTENCLR1_EL0 = SystemReg_REG_AMCNTENCLR1_EL0 as u32,
    AMCNTENSET1_EL0 = SystemReg_REG_AMCNTENSET1_EL0 as u32,
    AMEVCNTR00_EL0 = SystemReg_REG_AMEVCNTR00_EL0 as u32,
    AMEVCNTR01_EL0 = SystemReg_REG_AMEVCNTR01_EL0 as u32,
    AMEVCNTR02_EL0 = SystemReg_REG_AMEVCNTR02_EL0 as u32,
    AMEVCNTR03_EL0 = SystemReg_REG_AMEVCNTR03_EL0 as u32,
    AMEVCNTR10_EL0 = SystemReg_REG_AMEVCNTR10_EL0 as u32,
    AMEVCNTR11_EL0 = SystemReg_REG_AMEVCNTR11_EL0 as u32,
    AMEVCNTR12_EL0 = SystemReg_REG_AMEVCNTR12_EL0 as u32,
    AMEVCNTR13_EL0 = SystemReg_REG_AMEVCNTR13_EL0 as u32,
    AMEVCNTR14_EL0 = SystemReg_REG_AMEVCNTR14_EL0 as u32,
    AMEVCNTR15_EL0 = SystemReg_REG_AMEVCNTR15_EL0 as u32,
    AMEVCNTR16_EL0 = SystemReg_REG_AMEVCNTR16_EL0 as u32,
    AMEVCNTR17_EL0 = SystemReg_REG_AMEVCNTR17_EL0 as u32,
    AMEVCNTR18_EL0 = SystemReg_REG_AMEVCNTR18_EL0 as u32,
    AMEVCNTR19_EL0 = SystemReg_REG_AMEVCNTR19_EL0 as u32,
    AMEVCNTR110_EL0 = SystemReg_REG_AMEVCNTR110_EL0 as u32,
    AMEVCNTR111_EL0 = SystemReg_REG_AMEVCNTR111_EL0 as u32,
    AMEVCNTR112_EL0 = SystemReg_REG_AMEVCNTR112_EL0 as u32,
    AMEVCNTR113_EL0 = SystemReg_REG_AMEVCNTR113_EL0 as u32,
    AMEVCNTR114_EL0 = SystemReg_REG_AMEVCNTR114_EL0 as u32,
    AMEVCNTR115_EL0 = SystemReg_REG_AMEVCNTR115_EL0 as u32,
    AMEVTYPER10_EL0 = SystemReg_REG_AMEVTYPER10_EL0 as u32,
    AMEVTYPER11_EL0 = SystemReg_REG_AMEVTYPER11_EL0 as u32,
    AMEVTYPER12_EL0 = SystemReg_REG_AMEVTYPER12_EL0 as u32,
    AMEVTYPER13_EL0 = SystemReg_REG_AMEVTYPER13_EL0 as u32,
    AMEVTYPER14_EL0 = SystemReg_REG_AMEVTYPER14_EL0 as u32,
    AMEVTYPER15_EL0 = SystemReg_REG_AMEVTYPER15_EL0 as u32,
    AMEVTYPER16_EL0 = SystemReg_REG_AMEVTYPER16_EL0 as u32,
    AMEVTYPER17_EL0 = SystemReg_REG_AMEVTYPER17_EL0 as u32,
    AMEVTYPER18_EL0 = SystemReg_REG_AMEVTYPER18_EL0 as u32,
    AMEVTYPER19_EL0 = SystemReg_REG_AMEVTYPER19_EL0 as u32,
    AMEVTYPER110_EL0 = SystemReg_REG_AMEVTYPER110_EL0 as u32,
    AMEVTYPER111_EL0 = SystemReg_REG_AMEVTYPER111_EL0 as u32,
    AMEVTYPER112_EL0 = SystemReg_REG_AMEVTYPER112_EL0 as u32,
    AMEVTYPER113_EL0 = SystemReg_REG_AMEVTYPER113_EL0 as u32,
    AMEVTYPER114_EL0 = SystemReg_REG_AMEVTYPER114_EL0 as u32,
    AMEVTYPER115_EL0 = SystemReg_REG_AMEVTYPER115_EL0 as u32,
    CNTFRQ_EL0 = SystemReg_REG_CNTFRQ_EL0 as u32,
    CNTP_TVAL_EL0 = SystemReg_REG_CNTP_TVAL_EL0 as u32,
    CNTP_CTL_EL0 = SystemReg_REG_CNTP_CTL_EL0 as u32,
    CNTP_CVAL_EL0 = SystemReg_REG_CNTP_CVAL_EL0 as u32,
    CNTV_TVAL_EL0 = SystemReg_REG_CNTV_TVAL_EL0 as u32,
    CNTV_CTL_EL0 = SystemReg_REG_CNTV_CTL_EL0 as u32,
    CNTV_CVAL_EL0 = SystemReg_REG_CNTV_CVAL_EL0 as u32,
    PMEVCNTR0_EL0 = SystemReg_REG_PMEVCNTR0_EL0 as u32,
    PMEVCNTR1_EL0 = SystemReg_REG_PMEVCNTR1_EL0 as u32,
    PMEVCNTR2_EL0 = SystemReg_REG_PMEVCNTR2_EL0 as u32,
    PMEVCNTR3_EL0 = SystemReg_REG_PMEVCNTR3_EL0 as u32,
    PMEVCNTR4_EL0 = SystemReg_REG_PMEVCNTR4_EL0 as u32,
    PMEVCNTR5_EL0 = SystemReg_REG_PMEVCNTR5_EL0 as u32,
    PMEVCNTR6_EL0 = SystemReg_REG_PMEVCNTR6_EL0 as u32,
    PMEVCNTR7_EL0 = SystemReg_REG_PMEVCNTR7_EL0 as u32,
    PMEVCNTR8_EL0 = SystemReg_REG_PMEVCNTR8_EL0 as u32,
    PMEVCNTR9_EL0 = SystemReg_REG_PMEVCNTR9_EL0 as u32,
    PMEVCNTR10_EL0 = SystemReg_REG_PMEVCNTR10_EL0 as u32,
    PMEVCNTR11_EL0 = SystemReg_REG_PMEVCNTR11_EL0 as u32,
    PMEVCNTR12_EL0 = SystemReg_REG_PMEVCNTR12_EL0 as u32,
    PMEVCNTR13_EL0 = SystemReg_REG_PMEVCNTR13_EL0 as u32,
    PMEVCNTR14_EL0 = SystemReg_REG_PMEVCNTR14_EL0 as u32,
    PMEVCNTR15_EL0 = SystemReg_REG_PMEVCNTR15_EL0 as u32,
    PMEVCNTR16_EL0 = SystemReg_REG_PMEVCNTR16_EL0 as u32,
    PMEVCNTR17_EL0 = SystemReg_REG_PMEVCNTR17_EL0 as u32,
    PMEVCNTR18_EL0 = SystemReg_REG_PMEVCNTR18_EL0 as u32,
    PMEVCNTR19_EL0 = SystemReg_REG_PMEVCNTR19_EL0 as u32,
    PMEVCNTR20_EL0 = SystemReg_REG_PMEVCNTR20_EL0 as u32,
    PMEVCNTR21_EL0 = SystemReg_REG_PMEVCNTR21_EL0 as u32,
    PMEVCNTR22_EL0 = SystemReg_REG_PMEVCNTR22_EL0 as u32,
    PMEVCNTR23_EL0 = SystemReg_REG_PMEVCNTR23_EL0 as u32,
    PMEVCNTR24_EL0 = SystemReg_REG_PMEVCNTR24_EL0 as u32,
    PMEVCNTR25_EL0 = SystemReg_REG_PMEVCNTR25_EL0 as u32,
    PMEVCNTR26_EL0 = SystemReg_REG_PMEVCNTR26_EL0 as u32,
    PMEVCNTR27_EL0 = SystemReg_REG_PMEVCNTR27_EL0 as u32,
    PMEVCNTR28_EL0 = SystemReg_REG_PMEVCNTR28_EL0 as u32,
    PMEVCNTR29_EL0 = SystemReg_REG_PMEVCNTR29_EL0 as u32,
    PMEVCNTR30_EL0 = SystemReg_REG_PMEVCNTR30_EL0 as u32,
    PMEVTYPER0_EL0 = SystemReg_REG_PMEVTYPER0_EL0 as u32,
    PMEVTYPER1_EL0 = SystemReg_REG_PMEVTYPER1_EL0 as u32,
    PMEVTYPER2_EL0 = SystemReg_REG_PMEVTYPER2_EL0 as u32,
    PMEVTYPER3_EL0 = SystemReg_REG_PMEVTYPER3_EL0 as u32,
    PMEVTYPER4_EL0 = SystemReg_REG_PMEVTYPER4_EL0 as u32,
    PMEVTYPER5_EL0 = SystemReg_REG_PMEVTYPER5_EL0 as u32,
    PMEVTYPER6_EL0 = SystemReg_REG_PMEVTYPER6_EL0 as u32,
    PMEVTYPER7_EL0 = SystemReg_REG_PMEVTYPER7_EL0 as u32,
    PMEVTYPER8_EL0 = SystemReg_REG_PMEVTYPER8_EL0 as u32,
    PMEVTYPER9_EL0 = SystemReg_REG_PMEVTYPER9_EL0 as u32,
    PMEVTYPER10_EL0 = SystemReg_REG_PMEVTYPER10_EL0 as u32,
    PMEVTYPER11_EL0 = SystemReg_REG_PMEVTYPER11_EL0 as u32,
    PMEVTYPER12_EL0 = SystemReg_REG_PMEVTYPER12_EL0 as u32,
    PMEVTYPER13_EL0 = SystemReg_REG_PMEVTYPER13_EL0 as u32,
    PMEVTYPER14_EL0 = SystemReg_REG_PMEVTYPER14_EL0 as u32,
    PMEVTYPER15_EL0 = SystemReg_REG_PMEVTYPER15_EL0 as u32,
    PMEVTYPER16_EL0 = SystemReg_REG_PMEVTYPER16_EL0 as u32,
    PMEVTYPER17_EL0 = SystemReg_REG_PMEVTYPER17_EL0 as u32,
    PMEVTYPER18_EL0 = SystemReg_REG_PMEVTYPER18_EL0 as u32,
    PMEVTYPER19_EL0 = SystemReg_REG_PMEVTYPER19_EL0 as u32,
    PMEVTYPER20_EL0 = SystemReg_REG_PMEVTYPER20_EL0 as u32,
    PMEVTYPER21_EL0 = SystemReg_REG_PMEVTYPER21_EL0 as u32,
    PMEVTYPER22_EL0 = SystemReg_REG_PMEVTYPER22_EL0 as u32,
    PMEVTYPER23_EL0 = SystemReg_REG_PMEVTYPER23_EL0 as u32,
    PMEVTYPER24_EL0 = SystemReg_REG_PMEVTYPER24_EL0 as u32,
    PMEVTYPER25_EL0 = SystemReg_REG_PMEVTYPER25_EL0 as u32,
    PMEVTYPER26_EL0 = SystemReg_REG_PMEVTYPER26_EL0 as u32,
    PMEVTYPER27_EL0 = SystemReg_REG_PMEVTYPER27_EL0 as u32,
    PMEVTYPER28_EL0 = SystemReg_REG_PMEVTYPER28_EL0 as u32,
    PMEVTYPER29_EL0 = SystemReg_REG_PMEVTYPER29_EL0 as u32,
    PMEVTYPER30_EL0 = SystemReg_REG_PMEVTYPER30_EL0 as u32,
    PMCCFILTR_EL0 = SystemReg_REG_PMCCFILTR_EL0 as u32,
    VPIDR_EL2 = SystemReg_REG_VPIDR_EL2 as u32,
    VMPIDR_EL2 = SystemReg_REG_VMPIDR_EL2 as u32,
    SCTLR_EL2 = SystemReg_REG_SCTLR_EL2 as u32,
    ACTLR_EL2 = SystemReg_REG_ACTLR_EL2 as u32,
    HCR_EL2 = SystemReg_REG_HCR_EL2 as u32,
    MDCR_EL2 = SystemReg_REG_MDCR_EL2 as u32,
    CPTR_EL2 = SystemReg_REG_CPTR_EL2 as u32,
    HSTR_EL2 = SystemReg_REG_HSTR_EL2 as u32,
    HACR_EL2 = SystemReg_REG_HACR_EL2 as u32,
    TRFCR_EL2 = SystemReg_REG_TRFCR_EL2 as u32,
    SDER32_EL2 = SystemReg_REG_SDER32_EL2 as u32,
    TTBR0_EL2 = SystemReg_REG_TTBR0_EL2 as u32,
    TTBR1_EL2 = SystemReg_REG_TTBR1_EL2 as u32,
    TCR_EL2 = SystemReg_REG_TCR_EL2 as u32,
    VTTBR_EL2 = SystemReg_REG_VTTBR_EL2 as u32,
    VTCR_EL2 = SystemReg_REG_VTCR_EL2 as u32,
    VNCR_EL2 = SystemReg_REG_VNCR_EL2 as u32,
    VSTTBR_EL2 = SystemReg_REG_VSTTBR_EL2 as u32,
    VSTCR_EL2 = SystemReg_REG_VSTCR_EL2 as u32,
    DACR32_EL2 = SystemReg_REG_DACR32_EL2 as u32,
    SPSR_EL2 = SystemReg_REG_SPSR_EL2 as u32,
    ELR_EL2 = SystemReg_REG_ELR_EL2 as u32,
    SP_EL1 = SystemReg_REG_SP_EL1 as u32,
    SPSR_IRQ = SystemReg_REG_SPSR_IRQ as u32,
    SPSR_ABT = SystemReg_REG_SPSR_ABT as u32,
    SPSR_UND = SystemReg_REG_SPSR_UND as u32,
    SPSR_FIQ = SystemReg_REG_SPSR_FIQ as u32,
    IFSR32_EL2 = SystemReg_REG_IFSR32_EL2 as u32,
    AFSR0_EL2 = SystemReg_REG_AFSR0_EL2 as u32,
    AFSR1_EL2 = SystemReg_REG_AFSR1_EL2 as u32,
    ESR_EL2 = SystemReg_REG_ESR_EL2 as u32,
    VSESR_EL2 = SystemReg_REG_VSESR_EL2 as u32,
    FPEXC32_EL2 = SystemReg_REG_FPEXC32_EL2 as u32,
    TFSR_EL2 = SystemReg_REG_TFSR_EL2 as u32,
    FAR_EL2 = SystemReg_REG_FAR_EL2 as u32,
    HPFAR_EL2 = SystemReg_REG_HPFAR_EL2 as u32,
    PMSCR_EL2 = SystemReg_REG_PMSCR_EL2 as u32,
    MAIR_EL2 = SystemReg_REG_MAIR_EL2 as u32,
    AMAIR_EL2 = SystemReg_REG_AMAIR_EL2 as u32,
    MPAMHCR_EL2 = SystemReg_REG_MPAMHCR_EL2 as u32,
    MPAMVPMV_EL2 = SystemReg_REG_MPAMVPMV_EL2 as u32,
    MPAM2_EL2 = SystemReg_REG_MPAM2_EL2 as u32,
    MPAMVPM0_EL2 = SystemReg_REG_MPAMVPM0_EL2 as u32,
    MPAMVPM1_EL2 = SystemReg_REG_MPAMVPM1_EL2 as u32,
    MPAMVPM2_EL2 = SystemReg_REG_MPAMVPM2_EL2 as u32,
    MPAMVPM3_EL2 = SystemReg_REG_MPAMVPM3_EL2 as u32,
    MPAMVPM4_EL2 = SystemReg_REG_MPAMVPM4_EL2 as u32,
    MPAMVPM5_EL2 = SystemReg_REG_MPAMVPM5_EL2 as u32,
    MPAMVPM6_EL2 = SystemReg_REG_MPAMVPM6_EL2 as u32,
    MPAMVPM7_EL2 = SystemReg_REG_MPAMVPM7_EL2 as u32,
    VBAR_EL2 = SystemReg_REG_VBAR_EL2 as u32,
    RMR_EL2 = SystemReg_REG_RMR_EL2 as u32,
    VDISR_EL2 = SystemReg_REG_VDISR_EL2 as u32,
    ICH_AP0R0_EL2 = SystemReg_REG_ICH_AP0R0_EL2 as u32,
    ICH_AP0R1_EL2 = SystemReg_REG_ICH_AP0R1_EL2 as u32,
    ICH_AP0R2_EL2 = SystemReg_REG_ICH_AP0R2_EL2 as u32,
    ICH_AP0R3_EL2 = SystemReg_REG_ICH_AP0R3_EL2 as u32,
    ICH_AP1R0_EL2 = SystemReg_REG_ICH_AP1R0_EL2 as u32,
    ICH_AP1R1_EL2 = SystemReg_REG_ICH_AP1R1_EL2 as u32,
    ICH_AP1R2_EL2 = SystemReg_REG_ICH_AP1R2_EL2 as u32,
    ICH_AP1R3_EL2 = SystemReg_REG_ICH_AP1R3_EL2 as u32,
    ICH_VSEIR_EL2 = SystemReg_REG_ICH_VSEIR_EL2 as u32,
    ICC_SRE_EL2 = SystemReg_REG_ICC_SRE_EL2 as u32,
    ICH_HCR_EL2 = SystemReg_REG_ICH_HCR_EL2 as u32,
    ICH_MISR_EL2 = SystemReg_REG_ICH_MISR_EL2 as u32,
    ICH_VMCR_EL2 = SystemReg_REG_ICH_VMCR_EL2 as u32,
    ICH_LR0_EL2 = SystemReg_REG_ICH_LR0_EL2 as u32,
    ICH_LR1_EL2 = SystemReg_REG_ICH_LR1_EL2 as u32,
    ICH_LR2_EL2 = SystemReg_REG_ICH_LR2_EL2 as u32,
    ICH_LR3_EL2 = SystemReg_REG_ICH_LR3_EL2 as u32,
    ICH_LR4_EL2 = SystemReg_REG_ICH_LR4_EL2 as u32,
    ICH_LR5_EL2 = SystemReg_REG_ICH_LR5_EL2 as u32,
    ICH_LR6_EL2 = SystemReg_REG_ICH_LR6_EL2 as u32,
    ICH_LR7_EL2 = SystemReg_REG_ICH_LR7_EL2 as u32,
    ICH_LR8_EL2 = SystemReg_REG_ICH_LR8_EL2 as u32,
    ICH_LR9_EL2 = SystemReg_REG_ICH_LR9_EL2 as u32,
    ICH_LR10_EL2 = SystemReg_REG_ICH_LR10_EL2 as u32,
    ICH_LR11_EL2 = SystemReg_REG_ICH_LR11_EL2 as u32,
    ICH_LR12_EL2 = SystemReg_REG_ICH_LR12_EL2 as u32,
    ICH_LR13_EL2 = SystemReg_REG_ICH_LR13_EL2 as u32,
    ICH_LR14_EL2 = SystemReg_REG_ICH_LR14_EL2 as u32,
    ICH_LR15_EL2 = SystemReg_REG_ICH_LR15_EL2 as u32,
    CONTEXTIDR_EL2 = SystemReg_REG_CONTEXTIDR_EL2 as u32,
    TPIDR_EL2 = SystemReg_REG_TPIDR_EL2 as u32,
    SCXTNUM_EL2 = SystemReg_REG_SCXTNUM_EL2 as u32,
    CNTVOFF_EL2 = SystemReg_REG_CNTVOFF_EL2 as u32,
    CNTHCTL_EL2 = SystemReg_REG_CNTHCTL_EL2 as u32,
    CNTHP_TVAL_EL2 = SystemReg_REG_CNTHP_TVAL_EL2 as u32,
    CNTHP_CTL_EL2 = SystemReg_REG_CNTHP_CTL_EL2 as u32,
    CNTHP_CVAL_EL2 = SystemReg_REG_CNTHP_CVAL_EL2 as u32,
    CNTHV_TVAL_EL2 = SystemReg_REG_CNTHV_TVAL_EL2 as u32,
    CNTHV_CTL_EL2 = SystemReg_REG_CNTHV_CTL_EL2 as u32,
    CNTHV_CVAL_EL2 = SystemReg_REG_CNTHV_CVAL_EL2 as u32,
    CNTHVS_TVAL_EL2 = SystemReg_REG_CNTHVS_TVAL_EL2 as u32,
    CNTHVS_CTL_EL2 = SystemReg_REG_CNTHVS_CTL_EL2 as u32,
    CNTHVS_CVAL_EL2 = SystemReg_REG_CNTHVS_CVAL_EL2 as u32,
    CNTHPS_TVAL_EL2 = SystemReg_REG_CNTHPS_TVAL_EL2 as u32,
    CNTHPS_CTL_EL2 = SystemReg_REG_CNTHPS_CTL_EL2 as u32,
    CNTHPS_CVAL_EL2 = SystemReg_REG_CNTHPS_CVAL_EL2 as u32,
    SCTLR_EL12 = SystemReg_REG_SCTLR_EL12 as u32,
    CPACR_EL12 = SystemReg_REG_CPACR_EL12 as u32,
    TRFCR_EL12 = SystemReg_REG_TRFCR_EL12 as u32,
    TTBR0_EL12 = SystemReg_REG_TTBR0_EL12 as u32,
    TTBR1_EL12 = SystemReg_REG_TTBR1_EL12 as u32,
    TCR_EL12 = SystemReg_REG_TCR_EL12 as u32,
    SPSR_EL12 = SystemReg_REG_SPSR_EL12 as u32,
    ELR_EL12 = SystemReg_REG_ELR_EL12 as u32,
    AFSR0_EL12 = SystemReg_REG_AFSR0_EL12 as u32,
    AFSR1_EL12 = SystemReg_REG_AFSR1_EL12 as u32,
    ESR_EL12 = SystemReg_REG_ESR_EL12 as u32,
    TFSR_EL12 = SystemReg_REG_TFSR_EL12 as u32,
    FAR_EL12 = SystemReg_REG_FAR_EL12 as u32,
    PMSCR_EL12 = SystemReg_REG_PMSCR_EL12 as u32,
    MAIR_EL12 = SystemReg_REG_MAIR_EL12 as u32,
    AMAIR_EL12 = SystemReg_REG_AMAIR_EL12 as u32,
    MPAM1_EL12 = SystemReg_REG_MPAM1_EL12 as u32,
    VBAR_EL12 = SystemReg_REG_VBAR_EL12 as u32,
    CONTEXTIDR_EL12 = SystemReg_REG_CONTEXTIDR_EL12 as u32,
    SCXTNUM_EL12 = SystemReg_REG_SCXTNUM_EL12 as u32,
    CNTKCTL_EL12 = SystemReg_REG_CNTKCTL_EL12 as u32,
    CNTP_TVAL_EL02 = SystemReg_REG_CNTP_TVAL_EL02 as u32,
    CNTP_CTL_EL02 = SystemReg_REG_CNTP_CTL_EL02 as u32,
    CNTP_CVAL_EL02 = SystemReg_REG_CNTP_CVAL_EL02 as u32,
    CNTV_TVAL_EL02 = SystemReg_REG_CNTV_TVAL_EL02 as u32,
    CNTV_CTL_EL02 = SystemReg_REG_CNTV_CTL_EL02 as u32,
    CNTV_CVAL_EL02 = SystemReg_REG_CNTV_CVAL_EL02 as u32,
    SCTLR_EL3 = SystemReg_REG_SCTLR_EL3 as u32,
    ACTLR_EL3 = SystemReg_REG_ACTLR_EL3 as u32,
    SCR_EL3 = SystemReg_REG_SCR_EL3 as u32,
    SDER32_EL3 = SystemReg_REG_SDER32_EL3 as u32,
    CPTR_EL3 = SystemReg_REG_CPTR_EL3 as u32,
    MDCR_EL3 = SystemReg_REG_MDCR_EL3 as u32,
    TTBR0_EL3 = SystemReg_REG_TTBR0_EL3 as u32,
    TCR_EL3 = SystemReg_REG_TCR_EL3 as u32,
    SPSR_EL3 = SystemReg_REG_SPSR_EL3 as u32,
    ELR_EL3 = SystemReg_REG_ELR_EL3 as u32,
    SP_EL2 = SystemReg_REG_SP_EL2 as u32,
    AFSR0_EL3 = SystemReg_REG_AFSR0_EL3 as u32,
    AFSR1_EL3 = SystemReg_REG_AFSR1_EL3 as u32,
    ESR_EL3 = SystemReg_REG_ESR_EL3 as u32,
    TFSR_EL3 = SystemReg_REG_TFSR_EL3 as u32,
    FAR_EL3 = SystemReg_REG_FAR_EL3 as u32,
    MAIR_EL3 = SystemReg_REG_MAIR_EL3 as u32,
    AMAIR_EL3 = SystemReg_REG_AMAIR_EL3 as u32,
    MPAM3_EL3 = SystemReg_REG_MPAM3_EL3 as u32,
    VBAR_EL3 = SystemReg_REG_VBAR_EL3 as u32,
    RMR_EL3 = SystemReg_REG_RMR_EL3 as u32,
    ICC_CTLR_EL3 = SystemReg_REG_ICC_CTLR_EL3 as u32,
    ICC_SRE_EL3 = SystemReg_REG_ICC_SRE_EL3 as u32,
    ICC_IGRPEN1_EL3 = SystemReg_REG_ICC_IGRPEN1_EL3 as u32,
    TPIDR_EL3 = SystemReg_REG_TPIDR_EL3 as u32,
    SCXTNUM_EL3 = SystemReg_REG_SCXTNUM_EL3 as u32,
    CNTPS_TVAL_EL1 = SystemReg_REG_CNTPS_TVAL_EL1 as u32,
    CNTPS_CTL_EL1 = SystemReg_REG_CNTPS_CTL_EL1 as u32,
    CNTPS_CVAL_EL1 = SystemReg_REG_CNTPS_CVAL_EL1 as u32,
    PSTATE_SPSEL = SystemReg_REG_PSTATE_SPSEL as u32,
}

const_assert_eq!(SystemReg_SYSREG_END, 65300);

impl SysReg {
    /// Get system register name
    ///
    /// # Examples
    /// ```
    /// use bad64::SysReg;
    /// assert_eq!(SysReg::VBAR_EL3.name(), "vbar_el3");
    /// ```
    ///
    /// ```
    /// use bad64::{decode, Operand, SysReg};
    /// // msr vbar_el3, x0
    /// let decoded = decode(0xd51ec000, 0).unwrap();
    ///
    /// let op = decoded.operands()[0];
    ///
    /// assert_eq!(op, Operand::SysReg(SysReg::VBAR_EL3));
    ///
    /// match op {
    ///     Operand::SysReg(sr) => assert_eq!(sr.name(), "vbar_el3"),
    ///     _ => assert!(false),
    /// };
    /// ```
    pub fn name(&self) -> &'static str {
        #[cfg(target_os = "windows")]
        {
            unsafe {
                CStr::from_ptr(bad64_sys::get_system_register_name(self.to_i32().unwrap()) as _)
            }
            .to_str()
            .unwrap()
        }
        #[cfg(not(target_os = "windows"))]
        {
            unsafe {
                CStr::from_ptr(bad64_sys::get_system_register_name(self.to_u32().unwrap()) as _)
            }
            .to_str()
            .unwrap()
        }
    }
}

impl fmt::Display for SysReg {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "{}", self.name())
    }
}
