use core::fmt;

use bad64_sys::*;

use cstr_core::CStr;
use num_traits::ToPrimitive;

// %s/^pub const \(Operation_ARM64_\(\w\+\)\): Operation = \d\+;/    \2 = \1 as u32,/g

/// An instruction operation
#[derive(Clone, Copy, Debug, Hash, Eq, PartialEq, FromPrimitive, ToPrimitive)]
#[repr(u32)]
#[allow(non_camel_case_types)]
pub enum Op {
    ABS = Operation_ARM64_ABS as u32,
    ADC = Operation_ARM64_ADC as u32,
    ADCLB = Operation_ARM64_ADCLB as u32,
    ADCLT = Operation_ARM64_ADCLT as u32,
    ADCS = Operation_ARM64_ADCS as u32,
    ADD = Operation_ARM64_ADD as u32,
    ADDG = Operation_ARM64_ADDG as u32,
    ADDHA = Operation_ARM64_ADDHA as u32,
    ADDHN = Operation_ARM64_ADDHN as u32,
    ADDHN2 = Operation_ARM64_ADDHN2 as u32,
    ADDHNB = Operation_ARM64_ADDHNB as u32,
    ADDHNT = Operation_ARM64_ADDHNT as u32,
    ADDP = Operation_ARM64_ADDP as u32,
    ADDPL = Operation_ARM64_ADDPL as u32,
    ADDS = Operation_ARM64_ADDS as u32,
    ADDV = Operation_ARM64_ADDV as u32,
    ADDVA = Operation_ARM64_ADDVA as u32,
    ADDVL = Operation_ARM64_ADDVL as u32,
    ADR = Operation_ARM64_ADR as u32,
    ADRP = Operation_ARM64_ADRP as u32,
    AESD = Operation_ARM64_AESD as u32,
    AESE = Operation_ARM64_AESE as u32,
    AESIMC = Operation_ARM64_AESIMC as u32,
    AESMC = Operation_ARM64_AESMC as u32,
    AND = Operation_ARM64_AND as u32,
    ANDS = Operation_ARM64_ANDS as u32,
    ANDV = Operation_ARM64_ANDV as u32,
    ASR = Operation_ARM64_ASR as u32,
    ASRD = Operation_ARM64_ASRD as u32,
    ASRR = Operation_ARM64_ASRR as u32,
    ASRV = Operation_ARM64_ASRV as u32,
    AT = Operation_ARM64_AT as u32,
    AUTDA = Operation_ARM64_AUTDA as u32,
    AUTDB = Operation_ARM64_AUTDB as u32,
    AUTDZA = Operation_ARM64_AUTDZA as u32,
    AUTDZB = Operation_ARM64_AUTDZB as u32,
    AUTIA = Operation_ARM64_AUTIA as u32,
    AUTIA1716 = Operation_ARM64_AUTIA1716 as u32,
    AUTIASP = Operation_ARM64_AUTIASP as u32,
    AUTIAZ = Operation_ARM64_AUTIAZ as u32,
    AUTIB = Operation_ARM64_AUTIB as u32,
    AUTIB1716 = Operation_ARM64_AUTIB1716 as u32,
    AUTIBSP = Operation_ARM64_AUTIBSP as u32,
    AUTIBZ = Operation_ARM64_AUTIBZ as u32,
    AUTIZA = Operation_ARM64_AUTIZA as u32,
    AUTIZB = Operation_ARM64_AUTIZB as u32,
    AXFLAG = Operation_ARM64_AXFLAG as u32,
    B = Operation_ARM64_B as u32,
    BCAX = Operation_ARM64_BCAX as u32,
    BDEP = Operation_ARM64_BDEP as u32,
    BEXT = Operation_ARM64_BEXT as u32,
    BFC = Operation_ARM64_BFC as u32,
    BFCVT = Operation_ARM64_BFCVT as u32,
    BFCVTN = Operation_ARM64_BFCVTN as u32,
    BFCVTN2 = Operation_ARM64_BFCVTN2 as u32,
    BFCVTNT = Operation_ARM64_BFCVTNT as u32,
    BFDOT = Operation_ARM64_BFDOT as u32,
    BFI = Operation_ARM64_BFI as u32,
    BFM = Operation_ARM64_BFM as u32,
    BFMLAL = Operation_ARM64_BFMLAL as u32,
    BFMLALB = Operation_ARM64_BFMLALB as u32,
    BFMLALT = Operation_ARM64_BFMLALT as u32,
    BFMMLA = Operation_ARM64_BFMMLA as u32,
    BFMOPA = Operation_ARM64_BFMOPA as u32,
    BFMOPS = Operation_ARM64_BFMOPS as u32,
    BFXIL = Operation_ARM64_BFXIL as u32,
    BGRP = Operation_ARM64_BGRP as u32,
    BIC = Operation_ARM64_BIC as u32,
    BICS = Operation_ARM64_BICS as u32,
    BIF = Operation_ARM64_BIF as u32,
    BIT = Operation_ARM64_BIT as u32,
    BL = Operation_ARM64_BL as u32,
    BLR = Operation_ARM64_BLR as u32,
    BLRAA = Operation_ARM64_BLRAA as u32,
    BLRAAZ = Operation_ARM64_BLRAAZ as u32,
    BLRAB = Operation_ARM64_BLRAB as u32,
    BLRABZ = Operation_ARM64_BLRABZ as u32,
    BR = Operation_ARM64_BR as u32,
    BRAA = Operation_ARM64_BRAA as u32,
    BRAAZ = Operation_ARM64_BRAAZ as u32,
    BRAB = Operation_ARM64_BRAB as u32,
    BRABZ = Operation_ARM64_BRABZ as u32,
    BRK = Operation_ARM64_BRK as u32,
    BRKA = Operation_ARM64_BRKA as u32,
    BRKAS = Operation_ARM64_BRKAS as u32,
    BRKB = Operation_ARM64_BRKB as u32,
    BRKBS = Operation_ARM64_BRKBS as u32,
    BRKN = Operation_ARM64_BRKN as u32,
    BRKNS = Operation_ARM64_BRKNS as u32,
    BRKPA = Operation_ARM64_BRKPA as u32,
    BRKPAS = Operation_ARM64_BRKPAS as u32,
    BRKPB = Operation_ARM64_BRKPB as u32,
    BRKPBS = Operation_ARM64_BRKPBS as u32,
    BSL = Operation_ARM64_BSL as u32,
    BSL1N = Operation_ARM64_BSL1N as u32,
    BSL2N = Operation_ARM64_BSL2N as u32,
    BTI = Operation_ARM64_BTI as u32,
    B_AL = Operation_ARM64_B_AL as u32,
    B_CC = Operation_ARM64_B_CC as u32,
    B_CS = Operation_ARM64_B_CS as u32,
    B_EQ = Operation_ARM64_B_EQ as u32,
    B_GE = Operation_ARM64_B_GE as u32,
    B_GT = Operation_ARM64_B_GT as u32,
    B_HI = Operation_ARM64_B_HI as u32,
    B_LE = Operation_ARM64_B_LE as u32,
    B_LS = Operation_ARM64_B_LS as u32,
    B_LT = Operation_ARM64_B_LT as u32,
    B_MI = Operation_ARM64_B_MI as u32,
    B_NE = Operation_ARM64_B_NE as u32,
    B_NV = Operation_ARM64_B_NV as u32,
    B_PL = Operation_ARM64_B_PL as u32,
    B_VC = Operation_ARM64_B_VC as u32,
    B_VS = Operation_ARM64_B_VS as u32,
    CADD = Operation_ARM64_CADD as u32,
    CAS = Operation_ARM64_CAS as u32,
    CASA = Operation_ARM64_CASA as u32,
    CASAB = Operation_ARM64_CASAB as u32,
    CASAH = Operation_ARM64_CASAH as u32,
    CASAL = Operation_ARM64_CASAL as u32,
    CASALB = Operation_ARM64_CASALB as u32,
    CASALH = Operation_ARM64_CASALH as u32,
    CASB = Operation_ARM64_CASB as u32,
    CASH = Operation_ARM64_CASH as u32,
    CASL = Operation_ARM64_CASL as u32,
    CASLB = Operation_ARM64_CASLB as u32,
    CASLH = Operation_ARM64_CASLH as u32,
    CASP = Operation_ARM64_CASP as u32,
    CASPA = Operation_ARM64_CASPA as u32,
    CASPAL = Operation_ARM64_CASPAL as u32,
    CASPL = Operation_ARM64_CASPL as u32,
    CBNZ = Operation_ARM64_CBNZ as u32,
    CBZ = Operation_ARM64_CBZ as u32,
    CCMN = Operation_ARM64_CCMN as u32,
    CCMP = Operation_ARM64_CCMP as u32,
    CDOT = Operation_ARM64_CDOT as u32,
    CFINV = Operation_ARM64_CFINV as u32,
    CFP = Operation_ARM64_CFP as u32,
    CINC = Operation_ARM64_CINC as u32,
    CINV = Operation_ARM64_CINV as u32,
    CLASTA = Operation_ARM64_CLASTA as u32,
    CLASTB = Operation_ARM64_CLASTB as u32,
    CLREX = Operation_ARM64_CLREX as u32,
    CLS = Operation_ARM64_CLS as u32,
    CLZ = Operation_ARM64_CLZ as u32,
    CMEQ = Operation_ARM64_CMEQ as u32,
    CMGE = Operation_ARM64_CMGE as u32,
    CMGT = Operation_ARM64_CMGT as u32,
    CMHI = Operation_ARM64_CMHI as u32,
    CMHS = Operation_ARM64_CMHS as u32,
    CMLA = Operation_ARM64_CMLA as u32,
    CMLE = Operation_ARM64_CMLE as u32,
    CMLT = Operation_ARM64_CMLT as u32,
    CMN = Operation_ARM64_CMN as u32,
    CMP = Operation_ARM64_CMP as u32,
    CMPEQ = Operation_ARM64_CMPEQ as u32,
    CMPGE = Operation_ARM64_CMPGE as u32,
    CMPGT = Operation_ARM64_CMPGT as u32,
    CMPHI = Operation_ARM64_CMPHI as u32,
    CMPHS = Operation_ARM64_CMPHS as u32,
    CMPLE = Operation_ARM64_CMPLE as u32,
    CMPLO = Operation_ARM64_CMPLO as u32,
    CMPLS = Operation_ARM64_CMPLS as u32,
    CMPLT = Operation_ARM64_CMPLT as u32,
    CMPNE = Operation_ARM64_CMPNE as u32,
    CMPP = Operation_ARM64_CMPP as u32,
    CMTST = Operation_ARM64_CMTST as u32,
    CNEG = Operation_ARM64_CNEG as u32,
    CNOT = Operation_ARM64_CNOT as u32,
    CNT = Operation_ARM64_CNT as u32,
    CNTB = Operation_ARM64_CNTB as u32,
    CNTD = Operation_ARM64_CNTD as u32,
    CNTH = Operation_ARM64_CNTH as u32,
    CNTP = Operation_ARM64_CNTP as u32,
    CNTW = Operation_ARM64_CNTW as u32,
    COMPACT = Operation_ARM64_COMPACT as u32,
    CPP = Operation_ARM64_CPP as u32,
    CPY = Operation_ARM64_CPY as u32,
    CRC32B = Operation_ARM64_CRC32B as u32,
    CRC32CB = Operation_ARM64_CRC32CB as u32,
    CRC32CH = Operation_ARM64_CRC32CH as u32,
    CRC32CW = Operation_ARM64_CRC32CW as u32,
    CRC32CX = Operation_ARM64_CRC32CX as u32,
    CRC32H = Operation_ARM64_CRC32H as u32,
    CRC32W = Operation_ARM64_CRC32W as u32,
    CRC32X = Operation_ARM64_CRC32X as u32,
    CSDB = Operation_ARM64_CSDB as u32,
    CSEL = Operation_ARM64_CSEL as u32,
    CSET = Operation_ARM64_CSET as u32,
    CSETM = Operation_ARM64_CSETM as u32,
    CSINC = Operation_ARM64_CSINC as u32,
    CSINV = Operation_ARM64_CSINV as u32,
    CSNEG = Operation_ARM64_CSNEG as u32,
    CTERMEQ = Operation_ARM64_CTERMEQ as u32,
    CTERMNE = Operation_ARM64_CTERMNE as u32,
    DC = Operation_ARM64_DC as u32,
    DCPS1 = Operation_ARM64_DCPS1 as u32,
    DCPS2 = Operation_ARM64_DCPS2 as u32,
    DCPS3 = Operation_ARM64_DCPS3 as u32,
    DECB = Operation_ARM64_DECB as u32,
    DECD = Operation_ARM64_DECD as u32,
    DECH = Operation_ARM64_DECH as u32,
    DECP = Operation_ARM64_DECP as u32,
    DECW = Operation_ARM64_DECW as u32,
    DGH = Operation_ARM64_DGH as u32,
    DMB = Operation_ARM64_DMB as u32,
    DRPS = Operation_ARM64_DRPS as u32,
    DSB = Operation_ARM64_DSB as u32,
    DUP = Operation_ARM64_DUP as u32,
    DUPM = Operation_ARM64_DUPM as u32,
    DVP = Operation_ARM64_DVP as u32,
    EON = Operation_ARM64_EON as u32,
    EOR = Operation_ARM64_EOR as u32,
    EOR3 = Operation_ARM64_EOR3 as u32,
    EORBT = Operation_ARM64_EORBT as u32,
    EORS = Operation_ARM64_EORS as u32,
    EORTB = Operation_ARM64_EORTB as u32,
    EORV = Operation_ARM64_EORV as u32,
    ERET = Operation_ARM64_ERET as u32,
    ERETAA = Operation_ARM64_ERETAA as u32,
    ERETAB = Operation_ARM64_ERETAB as u32,
    ESB = Operation_ARM64_ESB as u32,
    EXT = Operation_ARM64_EXT as u32,
    EXTR = Operation_ARM64_EXTR as u32,
    FABD = Operation_ARM64_FABD as u32,
    FABS = Operation_ARM64_FABS as u32,
    FACGE = Operation_ARM64_FACGE as u32,
    FACGT = Operation_ARM64_FACGT as u32,
    FACLE = Operation_ARM64_FACLE as u32,
    FACLT = Operation_ARM64_FACLT as u32,
    FADD = Operation_ARM64_FADD as u32,
    FADDA = Operation_ARM64_FADDA as u32,
    FADDP = Operation_ARM64_FADDP as u32,
    FADDV = Operation_ARM64_FADDV as u32,
    FCADD = Operation_ARM64_FCADD as u32,
    FCCMP = Operation_ARM64_FCCMP as u32,
    FCCMPE = Operation_ARM64_FCCMPE as u32,
    FCMEQ = Operation_ARM64_FCMEQ as u32,
    FCMGE = Operation_ARM64_FCMGE as u32,
    FCMGT = Operation_ARM64_FCMGT as u32,
    FCMLA = Operation_ARM64_FCMLA as u32,
    FCMLE = Operation_ARM64_FCMLE as u32,
    FCMLT = Operation_ARM64_FCMLT as u32,
    FCMNE = Operation_ARM64_FCMNE as u32,
    FCMP = Operation_ARM64_FCMP as u32,
    FCMPE = Operation_ARM64_FCMPE as u32,
    FCMUO = Operation_ARM64_FCMUO as u32,
    FCPY = Operation_ARM64_FCPY as u32,
    FCSEL = Operation_ARM64_FCSEL as u32,
    FCVT = Operation_ARM64_FCVT as u32,
    FCVTAS = Operation_ARM64_FCVTAS as u32,
    FCVTAU = Operation_ARM64_FCVTAU as u32,
    FCVTL = Operation_ARM64_FCVTL as u32,
    FCVTL2 = Operation_ARM64_FCVTL2 as u32,
    FCVTLT = Operation_ARM64_FCVTLT as u32,
    FCVTMS = Operation_ARM64_FCVTMS as u32,
    FCVTMU = Operation_ARM64_FCVTMU as u32,
    FCVTN = Operation_ARM64_FCVTN as u32,
    FCVTN2 = Operation_ARM64_FCVTN2 as u32,
    FCVTNS = Operation_ARM64_FCVTNS as u32,
    FCVTNT = Operation_ARM64_FCVTNT as u32,
    FCVTNU = Operation_ARM64_FCVTNU as u32,
    FCVTPS = Operation_ARM64_FCVTPS as u32,
    FCVTPU = Operation_ARM64_FCVTPU as u32,
    FCVTX = Operation_ARM64_FCVTX as u32,
    FCVTXN = Operation_ARM64_FCVTXN as u32,
    FCVTXN2 = Operation_ARM64_FCVTXN2 as u32,
    FCVTXNT = Operation_ARM64_FCVTXNT as u32,
    FCVTZS = Operation_ARM64_FCVTZS as u32,
    FCVTZU = Operation_ARM64_FCVTZU as u32,
    FDIV = Operation_ARM64_FDIV as u32,
    FDIVR = Operation_ARM64_FDIVR as u32,
    FDUP = Operation_ARM64_FDUP as u32,
    FEXPA = Operation_ARM64_FEXPA as u32,
    FJCVTZS = Operation_ARM64_FJCVTZS as u32,
    FLOGB = Operation_ARM64_FLOGB as u32,
    FMAD = Operation_ARM64_FMAD as u32,
    FMADD = Operation_ARM64_FMADD as u32,
    FMAX = Operation_ARM64_FMAX as u32,
    FMAXNM = Operation_ARM64_FMAXNM as u32,
    FMAXNMP = Operation_ARM64_FMAXNMP as u32,
    FMAXNMV = Operation_ARM64_FMAXNMV as u32,
    FMAXP = Operation_ARM64_FMAXP as u32,
    FMAXV = Operation_ARM64_FMAXV as u32,
    FMIN = Operation_ARM64_FMIN as u32,
    FMINNM = Operation_ARM64_FMINNM as u32,
    FMINNMP = Operation_ARM64_FMINNMP as u32,
    FMINNMV = Operation_ARM64_FMINNMV as u32,
    FMINP = Operation_ARM64_FMINP as u32,
    FMINV = Operation_ARM64_FMINV as u32,
    FMLA = Operation_ARM64_FMLA as u32,
    FMLAL = Operation_ARM64_FMLAL as u32,
    FMLAL2 = Operation_ARM64_FMLAL2 as u32,
    FMLALB = Operation_ARM64_FMLALB as u32,
    FMLALT = Operation_ARM64_FMLALT as u32,
    FMLS = Operation_ARM64_FMLS as u32,
    FMLSL = Operation_ARM64_FMLSL as u32,
    FMLSL2 = Operation_ARM64_FMLSL2 as u32,
    FMLSLB = Operation_ARM64_FMLSLB as u32,
    FMLSLT = Operation_ARM64_FMLSLT as u32,
    FMMLA = Operation_ARM64_FMMLA as u32,
    FMOPA = Operation_ARM64_FMOPA as u32,
    FMOPS = Operation_ARM64_FMOPS as u32,
    FMOV = Operation_ARM64_FMOV as u32,
    FMSB = Operation_ARM64_FMSB as u32,
    FMSUB = Operation_ARM64_FMSUB as u32,
    FMUL = Operation_ARM64_FMUL as u32,
    FMULX = Operation_ARM64_FMULX as u32,
    FNEG = Operation_ARM64_FNEG as u32,
    FNMAD = Operation_ARM64_FNMAD as u32,
    FNMADD = Operation_ARM64_FNMADD as u32,
    FNMLA = Operation_ARM64_FNMLA as u32,
    FNMLS = Operation_ARM64_FNMLS as u32,
    FNMSB = Operation_ARM64_FNMSB as u32,
    FNMSUB = Operation_ARM64_FNMSUB as u32,
    FNMUL = Operation_ARM64_FNMUL as u32,
    FRECPE = Operation_ARM64_FRECPE as u32,
    FRECPS = Operation_ARM64_FRECPS as u32,
    FRECPX = Operation_ARM64_FRECPX as u32,
    FRINT32X = Operation_ARM64_FRINT32X as u32,
    FRINT32Z = Operation_ARM64_FRINT32Z as u32,
    FRINT64X = Operation_ARM64_FRINT64X as u32,
    FRINT64Z = Operation_ARM64_FRINT64Z as u32,
    FRINTA = Operation_ARM64_FRINTA as u32,
    FRINTI = Operation_ARM64_FRINTI as u32,
    FRINTM = Operation_ARM64_FRINTM as u32,
    FRINTN = Operation_ARM64_FRINTN as u32,
    FRINTP = Operation_ARM64_FRINTP as u32,
    FRINTX = Operation_ARM64_FRINTX as u32,
    FRINTZ = Operation_ARM64_FRINTZ as u32,
    FRSQRTE = Operation_ARM64_FRSQRTE as u32,
    FRSQRTS = Operation_ARM64_FRSQRTS as u32,
    FSCALE = Operation_ARM64_FSCALE as u32,
    FSQRT = Operation_ARM64_FSQRT as u32,
    FSUB = Operation_ARM64_FSUB as u32,
    FSUBR = Operation_ARM64_FSUBR as u32,
    FTMAD = Operation_ARM64_FTMAD as u32,
    FTSMUL = Operation_ARM64_FTSMUL as u32,
    FTSSEL = Operation_ARM64_FTSSEL as u32,
    GMI = Operation_ARM64_GMI as u32,
    HINT = Operation_ARM64_HINT as u32,
    HISTCNT = Operation_ARM64_HISTCNT as u32,
    HISTSEG = Operation_ARM64_HISTSEG as u32,
    HLT = Operation_ARM64_HLT as u32,
    HVC = Operation_ARM64_HVC as u32,
    IC = Operation_ARM64_IC as u32,
    INCB = Operation_ARM64_INCB as u32,
    INCD = Operation_ARM64_INCD as u32,
    INCH = Operation_ARM64_INCH as u32,
    INCP = Operation_ARM64_INCP as u32,
    INCW = Operation_ARM64_INCW as u32,
    INDEX = Operation_ARM64_INDEX as u32,
    INS = Operation_ARM64_INS as u32,
    INSR = Operation_ARM64_INSR as u32,
    IRG = Operation_ARM64_IRG as u32,
    ISB = Operation_ARM64_ISB as u32,
    LASTA = Operation_ARM64_LASTA as u32,
    LASTB = Operation_ARM64_LASTB as u32,
    LD1 = Operation_ARM64_LD1 as u32,
    LD1B = Operation_ARM64_LD1B as u32,
    LD1D = Operation_ARM64_LD1D as u32,
    LD1H = Operation_ARM64_LD1H as u32,
    LD1Q = Operation_ARM64_LD1Q as u32,
    LD1R = Operation_ARM64_LD1R as u32,
    LD1RB = Operation_ARM64_LD1RB as u32,
    LD1RD = Operation_ARM64_LD1RD as u32,
    LD1RH = Operation_ARM64_LD1RH as u32,
    LD1ROB = Operation_ARM64_LD1ROB as u32,
    LD1ROD = Operation_ARM64_LD1ROD as u32,
    LD1ROH = Operation_ARM64_LD1ROH as u32,
    LD1ROW = Operation_ARM64_LD1ROW as u32,
    LD1RQB = Operation_ARM64_LD1RQB as u32,
    LD1RQD = Operation_ARM64_LD1RQD as u32,
    LD1RQH = Operation_ARM64_LD1RQH as u32,
    LD1RQW = Operation_ARM64_LD1RQW as u32,
    LD1RSB = Operation_ARM64_LD1RSB as u32,
    LD1RSH = Operation_ARM64_LD1RSH as u32,
    LD1RSW = Operation_ARM64_LD1RSW as u32,
    LD1RW = Operation_ARM64_LD1RW as u32,
    LD1SB = Operation_ARM64_LD1SB as u32,
    LD1SH = Operation_ARM64_LD1SH as u32,
    LD1SW = Operation_ARM64_LD1SW as u32,
    LD1W = Operation_ARM64_LD1W as u32,
    LD2 = Operation_ARM64_LD2 as u32,
    LD2B = Operation_ARM64_LD2B as u32,
    LD2D = Operation_ARM64_LD2D as u32,
    LD2H = Operation_ARM64_LD2H as u32,
    LD2R = Operation_ARM64_LD2R as u32,
    LD2W = Operation_ARM64_LD2W as u32,
    LD3 = Operation_ARM64_LD3 as u32,
    LD3B = Operation_ARM64_LD3B as u32,
    LD3D = Operation_ARM64_LD3D as u32,
    LD3H = Operation_ARM64_LD3H as u32,
    LD3R = Operation_ARM64_LD3R as u32,
    LD3W = Operation_ARM64_LD3W as u32,
    LD4 = Operation_ARM64_LD4 as u32,
    LD4B = Operation_ARM64_LD4B as u32,
    LD4D = Operation_ARM64_LD4D as u32,
    LD4H = Operation_ARM64_LD4H as u32,
    LD4R = Operation_ARM64_LD4R as u32,
    LD4W = Operation_ARM64_LD4W as u32,
    LD64B = Operation_ARM64_LD64B as u32,
    LDADD = Operation_ARM64_LDADD as u32,
    LDADDA = Operation_ARM64_LDADDA as u32,
    LDADDAB = Operation_ARM64_LDADDAB as u32,
    LDADDAH = Operation_ARM64_LDADDAH as u32,
    LDADDAL = Operation_ARM64_LDADDAL as u32,
    LDADDALB = Operation_ARM64_LDADDALB as u32,
    LDADDALH = Operation_ARM64_LDADDALH as u32,
    LDADDB = Operation_ARM64_LDADDB as u32,
    LDADDH = Operation_ARM64_LDADDH as u32,
    LDADDL = Operation_ARM64_LDADDL as u32,
    LDADDLB = Operation_ARM64_LDADDLB as u32,
    LDADDLH = Operation_ARM64_LDADDLH as u32,
    LDAPR = Operation_ARM64_LDAPR as u32,
    LDAPRB = Operation_ARM64_LDAPRB as u32,
    LDAPRH = Operation_ARM64_LDAPRH as u32,
    LDAPUR = Operation_ARM64_LDAPUR as u32,
    LDAPURB = Operation_ARM64_LDAPURB as u32,
    LDAPURH = Operation_ARM64_LDAPURH as u32,
    LDAPURSB = Operation_ARM64_LDAPURSB as u32,
    LDAPURSH = Operation_ARM64_LDAPURSH as u32,
    LDAPURSW = Operation_ARM64_LDAPURSW as u32,
    LDAR = Operation_ARM64_LDAR as u32,
    LDARB = Operation_ARM64_LDARB as u32,
    LDARH = Operation_ARM64_LDARH as u32,
    LDAXP = Operation_ARM64_LDAXP as u32,
    LDAXR = Operation_ARM64_LDAXR as u32,
    LDAXRB = Operation_ARM64_LDAXRB as u32,
    LDAXRH = Operation_ARM64_LDAXRH as u32,
    LDCLR = Operation_ARM64_LDCLR as u32,
    LDCLRA = Operation_ARM64_LDCLRA as u32,
    LDCLRAB = Operation_ARM64_LDCLRAB as u32,
    LDCLRAH = Operation_ARM64_LDCLRAH as u32,
    LDCLRAL = Operation_ARM64_LDCLRAL as u32,
    LDCLRALB = Operation_ARM64_LDCLRALB as u32,
    LDCLRALH = Operation_ARM64_LDCLRALH as u32,
    LDCLRB = Operation_ARM64_LDCLRB as u32,
    LDCLRH = Operation_ARM64_LDCLRH as u32,
    LDCLRL = Operation_ARM64_LDCLRL as u32,
    LDCLRLB = Operation_ARM64_LDCLRLB as u32,
    LDCLRLH = Operation_ARM64_LDCLRLH as u32,
    LDEOR = Operation_ARM64_LDEOR as u32,
    LDEORA = Operation_ARM64_LDEORA as u32,
    LDEORAB = Operation_ARM64_LDEORAB as u32,
    LDEORAH = Operation_ARM64_LDEORAH as u32,
    LDEORAL = Operation_ARM64_LDEORAL as u32,
    LDEORALB = Operation_ARM64_LDEORALB as u32,
    LDEORALH = Operation_ARM64_LDEORALH as u32,
    LDEORB = Operation_ARM64_LDEORB as u32,
    LDEORH = Operation_ARM64_LDEORH as u32,
    LDEORL = Operation_ARM64_LDEORL as u32,
    LDEORLB = Operation_ARM64_LDEORLB as u32,
    LDEORLH = Operation_ARM64_LDEORLH as u32,
    LDFF1B = Operation_ARM64_LDFF1B as u32,
    LDFF1D = Operation_ARM64_LDFF1D as u32,
    LDFF1H = Operation_ARM64_LDFF1H as u32,
    LDFF1SB = Operation_ARM64_LDFF1SB as u32,
    LDFF1SH = Operation_ARM64_LDFF1SH as u32,
    LDFF1SW = Operation_ARM64_LDFF1SW as u32,
    LDFF1W = Operation_ARM64_LDFF1W as u32,
    LDG = Operation_ARM64_LDG as u32,
    LDGM = Operation_ARM64_LDGM as u32,
    LDLAR = Operation_ARM64_LDLAR as u32,
    LDLARB = Operation_ARM64_LDLARB as u32,
    LDLARH = Operation_ARM64_LDLARH as u32,
    LDNF1B = Operation_ARM64_LDNF1B as u32,
    LDNF1D = Operation_ARM64_LDNF1D as u32,
    LDNF1H = Operation_ARM64_LDNF1H as u32,
    LDNF1SB = Operation_ARM64_LDNF1SB as u32,
    LDNF1SH = Operation_ARM64_LDNF1SH as u32,
    LDNF1SW = Operation_ARM64_LDNF1SW as u32,
    LDNF1W = Operation_ARM64_LDNF1W as u32,
    LDNP = Operation_ARM64_LDNP as u32,
    LDNT1B = Operation_ARM64_LDNT1B as u32,
    LDNT1D = Operation_ARM64_LDNT1D as u32,
    LDNT1H = Operation_ARM64_LDNT1H as u32,
    LDNT1SB = Operation_ARM64_LDNT1SB as u32,
    LDNT1SH = Operation_ARM64_LDNT1SH as u32,
    LDNT1SW = Operation_ARM64_LDNT1SW as u32,
    LDNT1W = Operation_ARM64_LDNT1W as u32,
    LDP = Operation_ARM64_LDP as u32,
    LDPSW = Operation_ARM64_LDPSW as u32,
    LDR = Operation_ARM64_LDR as u32,
    LDRAA = Operation_ARM64_LDRAA as u32,
    LDRAB = Operation_ARM64_LDRAB as u32,
    LDRB = Operation_ARM64_LDRB as u32,
    LDRH = Operation_ARM64_LDRH as u32,
    LDRSB = Operation_ARM64_LDRSB as u32,
    LDRSH = Operation_ARM64_LDRSH as u32,
    LDRSW = Operation_ARM64_LDRSW as u32,
    LDSET = Operation_ARM64_LDSET as u32,
    LDSETA = Operation_ARM64_LDSETA as u32,
    LDSETAB = Operation_ARM64_LDSETAB as u32,
    LDSETAH = Operation_ARM64_LDSETAH as u32,
    LDSETAL = Operation_ARM64_LDSETAL as u32,
    LDSETALB = Operation_ARM64_LDSETALB as u32,
    LDSETALH = Operation_ARM64_LDSETALH as u32,
    LDSETB = Operation_ARM64_LDSETB as u32,
    LDSETH = Operation_ARM64_LDSETH as u32,
    LDSETL = Operation_ARM64_LDSETL as u32,
    LDSETLB = Operation_ARM64_LDSETLB as u32,
    LDSETLH = Operation_ARM64_LDSETLH as u32,
    LDSMAX = Operation_ARM64_LDSMAX as u32,
    LDSMAXA = Operation_ARM64_LDSMAXA as u32,
    LDSMAXAB = Operation_ARM64_LDSMAXAB as u32,
    LDSMAXAH = Operation_ARM64_LDSMAXAH as u32,
    LDSMAXAL = Operation_ARM64_LDSMAXAL as u32,
    LDSMAXALB = Operation_ARM64_LDSMAXALB as u32,
    LDSMAXALH = Operation_ARM64_LDSMAXALH as u32,
    LDSMAXB = Operation_ARM64_LDSMAXB as u32,
    LDSMAXH = Operation_ARM64_LDSMAXH as u32,
    LDSMAXL = Operation_ARM64_LDSMAXL as u32,
    LDSMAXLB = Operation_ARM64_LDSMAXLB as u32,
    LDSMAXLH = Operation_ARM64_LDSMAXLH as u32,
    LDSMIN = Operation_ARM64_LDSMIN as u32,
    LDSMINA = Operation_ARM64_LDSMINA as u32,
    LDSMINAB = Operation_ARM64_LDSMINAB as u32,
    LDSMINAH = Operation_ARM64_LDSMINAH as u32,
    LDSMINAL = Operation_ARM64_LDSMINAL as u32,
    LDSMINALB = Operation_ARM64_LDSMINALB as u32,
    LDSMINALH = Operation_ARM64_LDSMINALH as u32,
    LDSMINB = Operation_ARM64_LDSMINB as u32,
    LDSMINH = Operation_ARM64_LDSMINH as u32,
    LDSMINL = Operation_ARM64_LDSMINL as u32,
    LDSMINLB = Operation_ARM64_LDSMINLB as u32,
    LDSMINLH = Operation_ARM64_LDSMINLH as u32,
    LDTR = Operation_ARM64_LDTR as u32,
    LDTRB = Operation_ARM64_LDTRB as u32,
    LDTRH = Operation_ARM64_LDTRH as u32,
    LDTRSB = Operation_ARM64_LDTRSB as u32,
    LDTRSH = Operation_ARM64_LDTRSH as u32,
    LDTRSW = Operation_ARM64_LDTRSW as u32,
    LDUMAX = Operation_ARM64_LDUMAX as u32,
    LDUMAXA = Operation_ARM64_LDUMAXA as u32,
    LDUMAXAB = Operation_ARM64_LDUMAXAB as u32,
    LDUMAXAH = Operation_ARM64_LDUMAXAH as u32,
    LDUMAXAL = Operation_ARM64_LDUMAXAL as u32,
    LDUMAXALB = Operation_ARM64_LDUMAXALB as u32,
    LDUMAXALH = Operation_ARM64_LDUMAXALH as u32,
    LDUMAXB = Operation_ARM64_LDUMAXB as u32,
    LDUMAXH = Operation_ARM64_LDUMAXH as u32,
    LDUMAXL = Operation_ARM64_LDUMAXL as u32,
    LDUMAXLB = Operation_ARM64_LDUMAXLB as u32,
    LDUMAXLH = Operation_ARM64_LDUMAXLH as u32,
    LDUMIN = Operation_ARM64_LDUMIN as u32,
    LDUMINA = Operation_ARM64_LDUMINA as u32,
    LDUMINAB = Operation_ARM64_LDUMINAB as u32,
    LDUMINAH = Operation_ARM64_LDUMINAH as u32,
    LDUMINAL = Operation_ARM64_LDUMINAL as u32,
    LDUMINALB = Operation_ARM64_LDUMINALB as u32,
    LDUMINALH = Operation_ARM64_LDUMINALH as u32,
    LDUMINB = Operation_ARM64_LDUMINB as u32,
    LDUMINH = Operation_ARM64_LDUMINH as u32,
    LDUMINL = Operation_ARM64_LDUMINL as u32,
    LDUMINLB = Operation_ARM64_LDUMINLB as u32,
    LDUMINLH = Operation_ARM64_LDUMINLH as u32,
    LDUR = Operation_ARM64_LDUR as u32,
    LDURB = Operation_ARM64_LDURB as u32,
    LDURH = Operation_ARM64_LDURH as u32,
    LDURSB = Operation_ARM64_LDURSB as u32,
    LDURSH = Operation_ARM64_LDURSH as u32,
    LDURSW = Operation_ARM64_LDURSW as u32,
    LDXP = Operation_ARM64_LDXP as u32,
    LDXR = Operation_ARM64_LDXR as u32,
    LDXRB = Operation_ARM64_LDXRB as u32,
    LDXRH = Operation_ARM64_LDXRH as u32,
    LSL = Operation_ARM64_LSL as u32,
    LSLR = Operation_ARM64_LSLR as u32,
    LSLV = Operation_ARM64_LSLV as u32,
    LSR = Operation_ARM64_LSR as u32,
    LSRR = Operation_ARM64_LSRR as u32,
    LSRV = Operation_ARM64_LSRV as u32,
    MAD = Operation_ARM64_MAD as u32,
    MADD = Operation_ARM64_MADD as u32,
    MATCH = Operation_ARM64_MATCH as u32,
    MLA = Operation_ARM64_MLA as u32,
    MLS = Operation_ARM64_MLS as u32,
    MNEG = Operation_ARM64_MNEG as u32,
    MOV = Operation_ARM64_MOV as u32,
    MOVA = Operation_ARM64_MOVA as u32,
    MOVI = Operation_ARM64_MOVI as u32,
    MOVK = Operation_ARM64_MOVK as u32,
    MOVN = Operation_ARM64_MOVN as u32,
    MOVPRFX = Operation_ARM64_MOVPRFX as u32,
    MOVS = Operation_ARM64_MOVS as u32,
    MOVZ = Operation_ARM64_MOVZ as u32,
    MRS = Operation_ARM64_MRS as u32,
    MSB = Operation_ARM64_MSB as u32,
    MSR = Operation_ARM64_MSR as u32,
    MSUB = Operation_ARM64_MSUB as u32,
    MUL = Operation_ARM64_MUL as u32,
    MVN = Operation_ARM64_MVN as u32,
    MVNI = Operation_ARM64_MVNI as u32,
    NAND = Operation_ARM64_NAND as u32,
    NANDS = Operation_ARM64_NANDS as u32,
    NBSL = Operation_ARM64_NBSL as u32,
    NEG = Operation_ARM64_NEG as u32,
    NEGS = Operation_ARM64_NEGS as u32,
    NGC = Operation_ARM64_NGC as u32,
    NGCS = Operation_ARM64_NGCS as u32,
    NMATCH = Operation_ARM64_NMATCH as u32,
    NOP = Operation_ARM64_NOP as u32,
    NOR = Operation_ARM64_NOR as u32,
    NORS = Operation_ARM64_NORS as u32,
    NOT = Operation_ARM64_NOT as u32,
    NOTS = Operation_ARM64_NOTS as u32,
    ORN = Operation_ARM64_ORN as u32,
    ORNS = Operation_ARM64_ORNS as u32,
    ORR = Operation_ARM64_ORR as u32,
    ORRS = Operation_ARM64_ORRS as u32,
    ORV = Operation_ARM64_ORV as u32,
    PACDA = Operation_ARM64_PACDA as u32,
    PACDB = Operation_ARM64_PACDB as u32,
    PACDZA = Operation_ARM64_PACDZA as u32,
    PACDZB = Operation_ARM64_PACDZB as u32,
    PACGA = Operation_ARM64_PACGA as u32,
    PACIA = Operation_ARM64_PACIA as u32,
    PACIA1716 = Operation_ARM64_PACIA1716 as u32,
    PACIASP = Operation_ARM64_PACIASP as u32,
    PACIAZ = Operation_ARM64_PACIAZ as u32,
    PACIB = Operation_ARM64_PACIB as u32,
    PACIB1716 = Operation_ARM64_PACIB1716 as u32,
    PACIBSP = Operation_ARM64_PACIBSP as u32,
    PACIBZ = Operation_ARM64_PACIBZ as u32,
    PACIZA = Operation_ARM64_PACIZA as u32,
    PACIZB = Operation_ARM64_PACIZB as u32,
    PFALSE = Operation_ARM64_PFALSE as u32,
    PFIRST = Operation_ARM64_PFIRST as u32,
    PMUL = Operation_ARM64_PMUL as u32,
    PMULL = Operation_ARM64_PMULL as u32,
    PMULL2 = Operation_ARM64_PMULL2 as u32,
    PMULLB = Operation_ARM64_PMULLB as u32,
    PMULLT = Operation_ARM64_PMULLT as u32,
    PNEXT = Operation_ARM64_PNEXT as u32,
    PRFB = Operation_ARM64_PRFB as u32,
    PRFD = Operation_ARM64_PRFD as u32,
    PRFH = Operation_ARM64_PRFH as u32,
    PRFM = Operation_ARM64_PRFM as u32,
    PRFUM = Operation_ARM64_PRFUM as u32,
    PRFW = Operation_ARM64_PRFW as u32,
    PSB = Operation_ARM64_PSB as u32,
    PSSBB = Operation_ARM64_PSSBB as u32,
    PTEST = Operation_ARM64_PTEST as u32,
    PTRUE = Operation_ARM64_PTRUE as u32,
    PTRUES = Operation_ARM64_PTRUES as u32,
    PUNPKHI = Operation_ARM64_PUNPKHI as u32,
    PUNPKLO = Operation_ARM64_PUNPKLO as u32,
    RADDHN = Operation_ARM64_RADDHN as u32,
    RADDHN2 = Operation_ARM64_RADDHN2 as u32,
    RADDHNB = Operation_ARM64_RADDHNB as u32,
    RADDHNT = Operation_ARM64_RADDHNT as u32,
    RAX1 = Operation_ARM64_RAX1 as u32,
    RBIT = Operation_ARM64_RBIT as u32,
    RDFFR = Operation_ARM64_RDFFR as u32,
    RDFFRS = Operation_ARM64_RDFFRS as u32,
    RDVL = Operation_ARM64_RDVL as u32,
    RET = Operation_ARM64_RET as u32,
    RETAA = Operation_ARM64_RETAA as u32,
    RETAB = Operation_ARM64_RETAB as u32,
    REV = Operation_ARM64_REV as u32,
    REV16 = Operation_ARM64_REV16 as u32,
    REV32 = Operation_ARM64_REV32 as u32,
    REV64 = Operation_ARM64_REV64 as u32,
    REVB = Operation_ARM64_REVB as u32,
    REVD = Operation_ARM64_REVD as u32,
    REVH = Operation_ARM64_REVH as u32,
    REVW = Operation_ARM64_REVW as u32,
    RMIF = Operation_ARM64_RMIF as u32,
    ROR = Operation_ARM64_ROR as u32,
    RORV = Operation_ARM64_RORV as u32,
    RSHRN = Operation_ARM64_RSHRN as u32,
    RSHRN2 = Operation_ARM64_RSHRN2 as u32,
    RSHRNB = Operation_ARM64_RSHRNB as u32,
    RSHRNT = Operation_ARM64_RSHRNT as u32,
    RSUBHN = Operation_ARM64_RSUBHN as u32,
    RSUBHN2 = Operation_ARM64_RSUBHN2 as u32,
    RSUBHNB = Operation_ARM64_RSUBHNB as u32,
    RSUBHNT = Operation_ARM64_RSUBHNT as u32,
    SABA = Operation_ARM64_SABA as u32,
    SABAL = Operation_ARM64_SABAL as u32,
    SABAL2 = Operation_ARM64_SABAL2 as u32,
    SABALB = Operation_ARM64_SABALB as u32,
    SABALT = Operation_ARM64_SABALT as u32,
    SABD = Operation_ARM64_SABD as u32,
    SABDL = Operation_ARM64_SABDL as u32,
    SABDL2 = Operation_ARM64_SABDL2 as u32,
    SABDLB = Operation_ARM64_SABDLB as u32,
    SABDLT = Operation_ARM64_SABDLT as u32,
    SADALP = Operation_ARM64_SADALP as u32,
    SADDL = Operation_ARM64_SADDL as u32,
    SADDL2 = Operation_ARM64_SADDL2 as u32,
    SADDLB = Operation_ARM64_SADDLB as u32,
    SADDLBT = Operation_ARM64_SADDLBT as u32,
    SADDLP = Operation_ARM64_SADDLP as u32,
    SADDLT = Operation_ARM64_SADDLT as u32,
    SADDLV = Operation_ARM64_SADDLV as u32,
    SADDV = Operation_ARM64_SADDV as u32,
    SADDW = Operation_ARM64_SADDW as u32,
    SADDW2 = Operation_ARM64_SADDW2 as u32,
    SADDWB = Operation_ARM64_SADDWB as u32,
    SADDWT = Operation_ARM64_SADDWT as u32,
    SB = Operation_ARM64_SB as u32,
    SBC = Operation_ARM64_SBC as u32,
    SBCLB = Operation_ARM64_SBCLB as u32,
    SBCLT = Operation_ARM64_SBCLT as u32,
    SBCS = Operation_ARM64_SBCS as u32,
    SBFIZ = Operation_ARM64_SBFIZ as u32,
    SBFM = Operation_ARM64_SBFM as u32,
    SBFX = Operation_ARM64_SBFX as u32,
    SCLAMP = Operation_ARM64_SCLAMP as u32,
    SCVTF = Operation_ARM64_SCVTF as u32,
    SDIV = Operation_ARM64_SDIV as u32,
    SDIVR = Operation_ARM64_SDIVR as u32,
    SDOT = Operation_ARM64_SDOT as u32,
    SEL = Operation_ARM64_SEL as u32,
    SETF16 = Operation_ARM64_SETF16 as u32,
    SETF8 = Operation_ARM64_SETF8 as u32,
    SETFFR = Operation_ARM64_SETFFR as u32,
    SEV = Operation_ARM64_SEV as u32,
    SEVL = Operation_ARM64_SEVL as u32,
    SHA1C = Operation_ARM64_SHA1C as u32,
    SHA1H = Operation_ARM64_SHA1H as u32,
    SHA1M = Operation_ARM64_SHA1M as u32,
    SHA1P = Operation_ARM64_SHA1P as u32,
    SHA1SU0 = Operation_ARM64_SHA1SU0 as u32,
    SHA1SU1 = Operation_ARM64_SHA1SU1 as u32,
    SHA256H = Operation_ARM64_SHA256H as u32,
    SHA256H2 = Operation_ARM64_SHA256H2 as u32,
    SHA256SU0 = Operation_ARM64_SHA256SU0 as u32,
    SHA256SU1 = Operation_ARM64_SHA256SU1 as u32,
    SHA512H = Operation_ARM64_SHA512H as u32,
    SHA512H2 = Operation_ARM64_SHA512H2 as u32,
    SHA512SU0 = Operation_ARM64_SHA512SU0 as u32,
    SHA512SU1 = Operation_ARM64_SHA512SU1 as u32,
    SHADD = Operation_ARM64_SHADD as u32,
    SHL = Operation_ARM64_SHL as u32,
    SHLL = Operation_ARM64_SHLL as u32,
    SHLL2 = Operation_ARM64_SHLL2 as u32,
    SHRN = Operation_ARM64_SHRN as u32,
    SHRN2 = Operation_ARM64_SHRN2 as u32,
    SHRNB = Operation_ARM64_SHRNB as u32,
    SHRNT = Operation_ARM64_SHRNT as u32,
    SHSUB = Operation_ARM64_SHSUB as u32,
    SHSUBR = Operation_ARM64_SHSUBR as u32,
    SLI = Operation_ARM64_SLI as u32,
    SM3PARTW1 = Operation_ARM64_SM3PARTW1 as u32,
    SM3PARTW2 = Operation_ARM64_SM3PARTW2 as u32,
    SM3SS1 = Operation_ARM64_SM3SS1 as u32,
    SM3TT1A = Operation_ARM64_SM3TT1A as u32,
    SM3TT1B = Operation_ARM64_SM3TT1B as u32,
    SM3TT2A = Operation_ARM64_SM3TT2A as u32,
    SM3TT2B = Operation_ARM64_SM3TT2B as u32,
    SM4E = Operation_ARM64_SM4E as u32,
    SM4EKEY = Operation_ARM64_SM4EKEY as u32,
    SMADDL = Operation_ARM64_SMADDL as u32,
    SMAX = Operation_ARM64_SMAX as u32,
    SMAXP = Operation_ARM64_SMAXP as u32,
    SMAXV = Operation_ARM64_SMAXV as u32,
    SMC = Operation_ARM64_SMC as u32,
    SMIN = Operation_ARM64_SMIN as u32,
    SMINP = Operation_ARM64_SMINP as u32,
    SMINV = Operation_ARM64_SMINV as u32,
    SMLAL = Operation_ARM64_SMLAL as u32,
    SMLAL2 = Operation_ARM64_SMLAL2 as u32,
    SMLALB = Operation_ARM64_SMLALB as u32,
    SMLALT = Operation_ARM64_SMLALT as u32,
    SMLSL = Operation_ARM64_SMLSL as u32,
    SMLSL2 = Operation_ARM64_SMLSL2 as u32,
    SMLSLB = Operation_ARM64_SMLSLB as u32,
    SMLSLT = Operation_ARM64_SMLSLT as u32,
    SMMLA = Operation_ARM64_SMMLA as u32,
    SMNEGL = Operation_ARM64_SMNEGL as u32,
    SMOPA = Operation_ARM64_SMOPA as u32,
    SMOPS = Operation_ARM64_SMOPS as u32,
    SMOV = Operation_ARM64_SMOV as u32,
    SMSTART = Operation_ARM64_SMSTART as u32,
    SMSTOP = Operation_ARM64_SMSTOP as u32,
    SMSUBL = Operation_ARM64_SMSUBL as u32,
    SMULH = Operation_ARM64_SMULH as u32,
    SMULL = Operation_ARM64_SMULL as u32,
    SMULL2 = Operation_ARM64_SMULL2 as u32,
    SMULLB = Operation_ARM64_SMULLB as u32,
    SMULLT = Operation_ARM64_SMULLT as u32,
    SPLICE = Operation_ARM64_SPLICE as u32,
    SQABS = Operation_ARM64_SQABS as u32,
    SQADD = Operation_ARM64_SQADD as u32,
    SQCADD = Operation_ARM64_SQCADD as u32,
    SQDECB = Operation_ARM64_SQDECB as u32,
    SQDECD = Operation_ARM64_SQDECD as u32,
    SQDECH = Operation_ARM64_SQDECH as u32,
    SQDECP = Operation_ARM64_SQDECP as u32,
    SQDECW = Operation_ARM64_SQDECW as u32,
    SQDMLAL = Operation_ARM64_SQDMLAL as u32,
    SQDMLAL2 = Operation_ARM64_SQDMLAL2 as u32,
    SQDMLALB = Operation_ARM64_SQDMLALB as u32,
    SQDMLALBT = Operation_ARM64_SQDMLALBT as u32,
    SQDMLALT = Operation_ARM64_SQDMLALT as u32,
    SQDMLSL = Operation_ARM64_SQDMLSL as u32,
    SQDMLSL2 = Operation_ARM64_SQDMLSL2 as u32,
    SQDMLSLB = Operation_ARM64_SQDMLSLB as u32,
    SQDMLSLBT = Operation_ARM64_SQDMLSLBT as u32,
    SQDMLSLT = Operation_ARM64_SQDMLSLT as u32,
    SQDMULH = Operation_ARM64_SQDMULH as u32,
    SQDMULL = Operation_ARM64_SQDMULL as u32,
    SQDMULL2 = Operation_ARM64_SQDMULL2 as u32,
    SQDMULLB = Operation_ARM64_SQDMULLB as u32,
    SQDMULLT = Operation_ARM64_SQDMULLT as u32,
    SQINCB = Operation_ARM64_SQINCB as u32,
    SQINCD = Operation_ARM64_SQINCD as u32,
    SQINCH = Operation_ARM64_SQINCH as u32,
    SQINCP = Operation_ARM64_SQINCP as u32,
    SQINCW = Operation_ARM64_SQINCW as u32,
    SQNEG = Operation_ARM64_SQNEG as u32,
    SQRDCMLAH = Operation_ARM64_SQRDCMLAH as u32,
    SQRDMLAH = Operation_ARM64_SQRDMLAH as u32,
    SQRDMLSH = Operation_ARM64_SQRDMLSH as u32,
    SQRDMULH = Operation_ARM64_SQRDMULH as u32,
    SQRSHL = Operation_ARM64_SQRSHL as u32,
    SQRSHLR = Operation_ARM64_SQRSHLR as u32,
    SQRSHRN = Operation_ARM64_SQRSHRN as u32,
    SQRSHRN2 = Operation_ARM64_SQRSHRN2 as u32,
    SQRSHRNB = Operation_ARM64_SQRSHRNB as u32,
    SQRSHRNT = Operation_ARM64_SQRSHRNT as u32,
    SQRSHRUN = Operation_ARM64_SQRSHRUN as u32,
    SQRSHRUN2 = Operation_ARM64_SQRSHRUN2 as u32,
    SQRSHRUNB = Operation_ARM64_SQRSHRUNB as u32,
    SQRSHRUNT = Operation_ARM64_SQRSHRUNT as u32,
    SQSHL = Operation_ARM64_SQSHL as u32,
    SQSHLR = Operation_ARM64_SQSHLR as u32,
    SQSHLU = Operation_ARM64_SQSHLU as u32,
    SQSHRN = Operation_ARM64_SQSHRN as u32,
    SQSHRN2 = Operation_ARM64_SQSHRN2 as u32,
    SQSHRNB = Operation_ARM64_SQSHRNB as u32,
    SQSHRNT = Operation_ARM64_SQSHRNT as u32,
    SQSHRUN = Operation_ARM64_SQSHRUN as u32,
    SQSHRUN2 = Operation_ARM64_SQSHRUN2 as u32,
    SQSHRUNB = Operation_ARM64_SQSHRUNB as u32,
    SQSHRUNT = Operation_ARM64_SQSHRUNT as u32,
    SQSUB = Operation_ARM64_SQSUB as u32,
    SQSUBR = Operation_ARM64_SQSUBR as u32,
    SQXTN = Operation_ARM64_SQXTN as u32,
    SQXTN2 = Operation_ARM64_SQXTN2 as u32,
    SQXTNB = Operation_ARM64_SQXTNB as u32,
    SQXTNT = Operation_ARM64_SQXTNT as u32,
    SQXTUN = Operation_ARM64_SQXTUN as u32,
    SQXTUN2 = Operation_ARM64_SQXTUN2 as u32,
    SQXTUNB = Operation_ARM64_SQXTUNB as u32,
    SQXTUNT = Operation_ARM64_SQXTUNT as u32,
    SRHADD = Operation_ARM64_SRHADD as u32,
    SRI = Operation_ARM64_SRI as u32,
    SRSHL = Operation_ARM64_SRSHL as u32,
    SRSHLR = Operation_ARM64_SRSHLR as u32,
    SRSHR = Operation_ARM64_SRSHR as u32,
    SRSRA = Operation_ARM64_SRSRA as u32,
    SSBB = Operation_ARM64_SSBB as u32,
    SSHL = Operation_ARM64_SSHL as u32,
    SSHLL = Operation_ARM64_SSHLL as u32,
    SSHLL2 = Operation_ARM64_SSHLL2 as u32,
    SSHLLB = Operation_ARM64_SSHLLB as u32,
    SSHLLT = Operation_ARM64_SSHLLT as u32,
    SSHR = Operation_ARM64_SSHR as u32,
    SSRA = Operation_ARM64_SSRA as u32,
    SSUBL = Operation_ARM64_SSUBL as u32,
    SSUBL2 = Operation_ARM64_SSUBL2 as u32,
    SSUBLB = Operation_ARM64_SSUBLB as u32,
    SSUBLBT = Operation_ARM64_SSUBLBT as u32,
    SSUBLT = Operation_ARM64_SSUBLT as u32,
    SSUBLTB = Operation_ARM64_SSUBLTB as u32,
    SSUBW = Operation_ARM64_SSUBW as u32,
    SSUBW2 = Operation_ARM64_SSUBW2 as u32,
    SSUBWB = Operation_ARM64_SSUBWB as u32,
    SSUBWT = Operation_ARM64_SSUBWT as u32,
    ST1 = Operation_ARM64_ST1 as u32,
    ST1B = Operation_ARM64_ST1B as u32,
    ST1D = Operation_ARM64_ST1D as u32,
    ST1H = Operation_ARM64_ST1H as u32,
    ST1Q = Operation_ARM64_ST1Q as u32,
    ST1W = Operation_ARM64_ST1W as u32,
    ST2 = Operation_ARM64_ST2 as u32,
    ST2B = Operation_ARM64_ST2B as u32,
    ST2D = Operation_ARM64_ST2D as u32,
    ST2G = Operation_ARM64_ST2G as u32,
    ST2H = Operation_ARM64_ST2H as u32,
    ST2W = Operation_ARM64_ST2W as u32,
    ST3 = Operation_ARM64_ST3 as u32,
    ST3B = Operation_ARM64_ST3B as u32,
    ST3D = Operation_ARM64_ST3D as u32,
    ST3H = Operation_ARM64_ST3H as u32,
    ST3W = Operation_ARM64_ST3W as u32,
    ST4 = Operation_ARM64_ST4 as u32,
    ST4B = Operation_ARM64_ST4B as u32,
    ST4D = Operation_ARM64_ST4D as u32,
    ST4H = Operation_ARM64_ST4H as u32,
    ST4W = Operation_ARM64_ST4W as u32,
    ST64B = Operation_ARM64_ST64B as u32,
    ST64BV = Operation_ARM64_ST64BV as u32,
    ST64BV0 = Operation_ARM64_ST64BV0 as u32,
    STADD = Operation_ARM64_STADD as u32,
    STADDB = Operation_ARM64_STADDB as u32,
    STADDH = Operation_ARM64_STADDH as u32,
    STADDL = Operation_ARM64_STADDL as u32,
    STADDLB = Operation_ARM64_STADDLB as u32,
    STADDLH = Operation_ARM64_STADDLH as u32,
    STCLR = Operation_ARM64_STCLR as u32,
    STCLRB = Operation_ARM64_STCLRB as u32,
    STCLRH = Operation_ARM64_STCLRH as u32,
    STCLRL = Operation_ARM64_STCLRL as u32,
    STCLRLB = Operation_ARM64_STCLRLB as u32,
    STCLRLH = Operation_ARM64_STCLRLH as u32,
    STEOR = Operation_ARM64_STEOR as u32,
    STEORB = Operation_ARM64_STEORB as u32,
    STEORH = Operation_ARM64_STEORH as u32,
    STEORL = Operation_ARM64_STEORL as u32,
    STEORLB = Operation_ARM64_STEORLB as u32,
    STEORLH = Operation_ARM64_STEORLH as u32,
    STG = Operation_ARM64_STG as u32,
    STGM = Operation_ARM64_STGM as u32,
    STGP = Operation_ARM64_STGP as u32,
    STLLR = Operation_ARM64_STLLR as u32,
    STLLRB = Operation_ARM64_STLLRB as u32,
    STLLRH = Operation_ARM64_STLLRH as u32,
    STLR = Operation_ARM64_STLR as u32,
    STLRB = Operation_ARM64_STLRB as u32,
    STLRH = Operation_ARM64_STLRH as u32,
    STLUR = Operation_ARM64_STLUR as u32,
    STLURB = Operation_ARM64_STLURB as u32,
    STLURH = Operation_ARM64_STLURH as u32,
    STLXP = Operation_ARM64_STLXP as u32,
    STLXR = Operation_ARM64_STLXR as u32,
    STLXRB = Operation_ARM64_STLXRB as u32,
    STLXRH = Operation_ARM64_STLXRH as u32,
    STNP = Operation_ARM64_STNP as u32,
    STNT1B = Operation_ARM64_STNT1B as u32,
    STNT1D = Operation_ARM64_STNT1D as u32,
    STNT1H = Operation_ARM64_STNT1H as u32,
    STNT1W = Operation_ARM64_STNT1W as u32,
    STP = Operation_ARM64_STP as u32,
    STR = Operation_ARM64_STR as u32,
    STRB = Operation_ARM64_STRB as u32,
    STRH = Operation_ARM64_STRH as u32,
    STSET = Operation_ARM64_STSET as u32,
    STSETB = Operation_ARM64_STSETB as u32,
    STSETH = Operation_ARM64_STSETH as u32,
    STSETL = Operation_ARM64_STSETL as u32,
    STSETLB = Operation_ARM64_STSETLB as u32,
    STSETLH = Operation_ARM64_STSETLH as u32,
    STSMAX = Operation_ARM64_STSMAX as u32,
    STSMAXB = Operation_ARM64_STSMAXB as u32,
    STSMAXH = Operation_ARM64_STSMAXH as u32,
    STSMAXL = Operation_ARM64_STSMAXL as u32,
    STSMAXLB = Operation_ARM64_STSMAXLB as u32,
    STSMAXLH = Operation_ARM64_STSMAXLH as u32,
    STSMIN = Operation_ARM64_STSMIN as u32,
    STSMINB = Operation_ARM64_STSMINB as u32,
    STSMINH = Operation_ARM64_STSMINH as u32,
    STSMINL = Operation_ARM64_STSMINL as u32,
    STSMINLB = Operation_ARM64_STSMINLB as u32,
    STSMINLH = Operation_ARM64_STSMINLH as u32,
    STTR = Operation_ARM64_STTR as u32,
    STTRB = Operation_ARM64_STTRB as u32,
    STTRH = Operation_ARM64_STTRH as u32,
    STUMAX = Operation_ARM64_STUMAX as u32,
    STUMAXB = Operation_ARM64_STUMAXB as u32,
    STUMAXH = Operation_ARM64_STUMAXH as u32,
    STUMAXL = Operation_ARM64_STUMAXL as u32,
    STUMAXLB = Operation_ARM64_STUMAXLB as u32,
    STUMAXLH = Operation_ARM64_STUMAXLH as u32,
    STUMIN = Operation_ARM64_STUMIN as u32,
    STUMINB = Operation_ARM64_STUMINB as u32,
    STUMINH = Operation_ARM64_STUMINH as u32,
    STUMINL = Operation_ARM64_STUMINL as u32,
    STUMINLB = Operation_ARM64_STUMINLB as u32,
    STUMINLH = Operation_ARM64_STUMINLH as u32,
    STUR = Operation_ARM64_STUR as u32,
    STURB = Operation_ARM64_STURB as u32,
    STURH = Operation_ARM64_STURH as u32,
    STXP = Operation_ARM64_STXP as u32,
    STXR = Operation_ARM64_STXR as u32,
    STXRB = Operation_ARM64_STXRB as u32,
    STXRH = Operation_ARM64_STXRH as u32,
    STZ2G = Operation_ARM64_STZ2G as u32,
    STZG = Operation_ARM64_STZG as u32,
    STZGM = Operation_ARM64_STZGM as u32,
    SUB = Operation_ARM64_SUB as u32,
    SUBG = Operation_ARM64_SUBG as u32,
    SUBHN = Operation_ARM64_SUBHN as u32,
    SUBHN2 = Operation_ARM64_SUBHN2 as u32,
    SUBHNB = Operation_ARM64_SUBHNB as u32,
    SUBHNT = Operation_ARM64_SUBHNT as u32,
    SUBP = Operation_ARM64_SUBP as u32,
    SUBPS = Operation_ARM64_SUBPS as u32,
    SUBR = Operation_ARM64_SUBR as u32,
    SUBS = Operation_ARM64_SUBS as u32,
    SUDOT = Operation_ARM64_SUDOT as u32,
    SUMOPA = Operation_ARM64_SUMOPA as u32,
    SUMOPS = Operation_ARM64_SUMOPS as u32,
    SUNPKHI = Operation_ARM64_SUNPKHI as u32,
    SUNPKLO = Operation_ARM64_SUNPKLO as u32,
    SUQADD = Operation_ARM64_SUQADD as u32,
    SVC = Operation_ARM64_SVC as u32,
    SWP = Operation_ARM64_SWP as u32,
    SWPA = Operation_ARM64_SWPA as u32,
    SWPAB = Operation_ARM64_SWPAB as u32,
    SWPAH = Operation_ARM64_SWPAH as u32,
    SWPAL = Operation_ARM64_SWPAL as u32,
    SWPALB = Operation_ARM64_SWPALB as u32,
    SWPALH = Operation_ARM64_SWPALH as u32,
    SWPB = Operation_ARM64_SWPB as u32,
    SWPH = Operation_ARM64_SWPH as u32,
    SWPL = Operation_ARM64_SWPL as u32,
    SWPLB = Operation_ARM64_SWPLB as u32,
    SWPLH = Operation_ARM64_SWPLH as u32,
    SXTB = Operation_ARM64_SXTB as u32,
    SXTH = Operation_ARM64_SXTH as u32,
    SXTL = Operation_ARM64_SXTL as u32,
    SXTL2 = Operation_ARM64_SXTL2 as u32,
    SXTW = Operation_ARM64_SXTW as u32,
    SYS = Operation_ARM64_SYS as u32,
    SYSL = Operation_ARM64_SYSL as u32,
    TBL = Operation_ARM64_TBL as u32,
    TBNZ = Operation_ARM64_TBNZ as u32,
    TBX = Operation_ARM64_TBX as u32,
    TBZ = Operation_ARM64_TBZ as u32,
    TCANCEL = Operation_ARM64_TCANCEL as u32,
    TCOMMIT = Operation_ARM64_TCOMMIT as u32,
    TLBI = Operation_ARM64_TLBI as u32,
    TRN1 = Operation_ARM64_TRN1 as u32,
    TRN2 = Operation_ARM64_TRN2 as u32,
    TSB = Operation_ARM64_TSB as u32,
    TST = Operation_ARM64_TST as u32,
    TSTART = Operation_ARM64_TSTART as u32,
    TTEST = Operation_ARM64_TTEST as u32,
    UABA = Operation_ARM64_UABA as u32,
    UABAL = Operation_ARM64_UABAL as u32,
    UABAL2 = Operation_ARM64_UABAL2 as u32,
    UABALB = Operation_ARM64_UABALB as u32,
    UABALT = Operation_ARM64_UABALT as u32,
    UABD = Operation_ARM64_UABD as u32,
    UABDL = Operation_ARM64_UABDL as u32,
    UABDL2 = Operation_ARM64_UABDL2 as u32,
    UABDLB = Operation_ARM64_UABDLB as u32,
    UABDLT = Operation_ARM64_UABDLT as u32,
    UADALP = Operation_ARM64_UADALP as u32,
    UADDL = Operation_ARM64_UADDL as u32,
    UADDL2 = Operation_ARM64_UADDL2 as u32,
    UADDLB = Operation_ARM64_UADDLB as u32,
    UADDLP = Operation_ARM64_UADDLP as u32,
    UADDLT = Operation_ARM64_UADDLT as u32,
    UADDLV = Operation_ARM64_UADDLV as u32,
    UADDV = Operation_ARM64_UADDV as u32,
    UADDW = Operation_ARM64_UADDW as u32,
    UADDW2 = Operation_ARM64_UADDW2 as u32,
    UADDWB = Operation_ARM64_UADDWB as u32,
    UADDWT = Operation_ARM64_UADDWT as u32,
    UBFIZ = Operation_ARM64_UBFIZ as u32,
    UBFM = Operation_ARM64_UBFM as u32,
    UBFX = Operation_ARM64_UBFX as u32,
    UCLAMP = Operation_ARM64_UCLAMP as u32,
    UCVTF = Operation_ARM64_UCVTF as u32,
    UDF = Operation_ARM64_UDF as u32,
    UDIV = Operation_ARM64_UDIV as u32,
    UDIVR = Operation_ARM64_UDIVR as u32,
    UDOT = Operation_ARM64_UDOT as u32,
    UHADD = Operation_ARM64_UHADD as u32,
    UHSUB = Operation_ARM64_UHSUB as u32,
    UHSUBR = Operation_ARM64_UHSUBR as u32,
    UMADDL = Operation_ARM64_UMADDL as u32,
    UMAX = Operation_ARM64_UMAX as u32,
    UMAXP = Operation_ARM64_UMAXP as u32,
    UMAXV = Operation_ARM64_UMAXV as u32,
    UMIN = Operation_ARM64_UMIN as u32,
    UMINP = Operation_ARM64_UMINP as u32,
    UMINV = Operation_ARM64_UMINV as u32,
    UMLAL = Operation_ARM64_UMLAL as u32,
    UMLAL2 = Operation_ARM64_UMLAL2 as u32,
    UMLALB = Operation_ARM64_UMLALB as u32,
    UMLALT = Operation_ARM64_UMLALT as u32,
    UMLSL = Operation_ARM64_UMLSL as u32,
    UMLSL2 = Operation_ARM64_UMLSL2 as u32,
    UMLSLB = Operation_ARM64_UMLSLB as u32,
    UMLSLT = Operation_ARM64_UMLSLT as u32,
    UMMLA = Operation_ARM64_UMMLA as u32,
    UMNEGL = Operation_ARM64_UMNEGL as u32,
    UMOPA = Operation_ARM64_UMOPA as u32,
    UMOPS = Operation_ARM64_UMOPS as u32,
    UMOV = Operation_ARM64_UMOV as u32,
    UMSUBL = Operation_ARM64_UMSUBL as u32,
    UMULH = Operation_ARM64_UMULH as u32,
    UMULL = Operation_ARM64_UMULL as u32,
    UMULL2 = Operation_ARM64_UMULL2 as u32,
    UMULLB = Operation_ARM64_UMULLB as u32,
    UMULLT = Operation_ARM64_UMULLT as u32,
    UQADD = Operation_ARM64_UQADD as u32,
    UQDECB = Operation_ARM64_UQDECB as u32,
    UQDECD = Operation_ARM64_UQDECD as u32,
    UQDECH = Operation_ARM64_UQDECH as u32,
    UQDECP = Operation_ARM64_UQDECP as u32,
    UQDECW = Operation_ARM64_UQDECW as u32,
    UQINCB = Operation_ARM64_UQINCB as u32,
    UQINCD = Operation_ARM64_UQINCD as u32,
    UQINCH = Operation_ARM64_UQINCH as u32,
    UQINCP = Operation_ARM64_UQINCP as u32,
    UQINCW = Operation_ARM64_UQINCW as u32,
    UQRSHL = Operation_ARM64_UQRSHL as u32,
    UQRSHLR = Operation_ARM64_UQRSHLR as u32,
    UQRSHRN = Operation_ARM64_UQRSHRN as u32,
    UQRSHRN2 = Operation_ARM64_UQRSHRN2 as u32,
    UQRSHRNB = Operation_ARM64_UQRSHRNB as u32,
    UQRSHRNT = Operation_ARM64_UQRSHRNT as u32,
    UQSHL = Operation_ARM64_UQSHL as u32,
    UQSHLR = Operation_ARM64_UQSHLR as u32,
    UQSHRN = Operation_ARM64_UQSHRN as u32,
    UQSHRN2 = Operation_ARM64_UQSHRN2 as u32,
    UQSHRNB = Operation_ARM64_UQSHRNB as u32,
    UQSHRNT = Operation_ARM64_UQSHRNT as u32,
    UQSUB = Operation_ARM64_UQSUB as u32,
    UQSUBR = Operation_ARM64_UQSUBR as u32,
    UQXTN = Operation_ARM64_UQXTN as u32,
    UQXTN2 = Operation_ARM64_UQXTN2 as u32,
    UQXTNB = Operation_ARM64_UQXTNB as u32,
    UQXTNT = Operation_ARM64_UQXTNT as u32,
    URECPE = Operation_ARM64_URECPE as u32,
    URHADD = Operation_ARM64_URHADD as u32,
    URSHL = Operation_ARM64_URSHL as u32,
    URSHLR = Operation_ARM64_URSHLR as u32,
    URSHR = Operation_ARM64_URSHR as u32,
    URSQRTE = Operation_ARM64_URSQRTE as u32,
    URSRA = Operation_ARM64_URSRA as u32,
    USDOT = Operation_ARM64_USDOT as u32,
    USHL = Operation_ARM64_USHL as u32,
    USHLL = Operation_ARM64_USHLL as u32,
    USHLL2 = Operation_ARM64_USHLL2 as u32,
    USHLLB = Operation_ARM64_USHLLB as u32,
    USHLLT = Operation_ARM64_USHLLT as u32,
    USHR = Operation_ARM64_USHR as u32,
    USMMLA = Operation_ARM64_USMMLA as u32,
    USMOPA = Operation_ARM64_USMOPA as u32,
    USMOPS = Operation_ARM64_USMOPS as u32,
    USQADD = Operation_ARM64_USQADD as u32,
    USRA = Operation_ARM64_USRA as u32,
    USUBL = Operation_ARM64_USUBL as u32,
    USUBL2 = Operation_ARM64_USUBL2 as u32,
    USUBLB = Operation_ARM64_USUBLB as u32,
    USUBLT = Operation_ARM64_USUBLT as u32,
    USUBW = Operation_ARM64_USUBW as u32,
    USUBW2 = Operation_ARM64_USUBW2 as u32,
    USUBWB = Operation_ARM64_USUBWB as u32,
    USUBWT = Operation_ARM64_USUBWT as u32,
    UUNPKHI = Operation_ARM64_UUNPKHI as u32,
    UUNPKLO = Operation_ARM64_UUNPKLO as u32,
    UXTB = Operation_ARM64_UXTB as u32,
    UXTH = Operation_ARM64_UXTH as u32,
    UXTL = Operation_ARM64_UXTL as u32,
    UXTL2 = Operation_ARM64_UXTL2 as u32,
    UXTW = Operation_ARM64_UXTW as u32,
    UZP1 = Operation_ARM64_UZP1 as u32,
    UZP2 = Operation_ARM64_UZP2 as u32,
    WFE = Operation_ARM64_WFE as u32,
    WFET = Operation_ARM64_WFET as u32,
    WFI = Operation_ARM64_WFI as u32,
    WFIT = Operation_ARM64_WFIT as u32,
    WHILEGE = Operation_ARM64_WHILEGE as u32,
    WHILEGT = Operation_ARM64_WHILEGT as u32,
    WHILEHI = Operation_ARM64_WHILEHI as u32,
    WHILEHS = Operation_ARM64_WHILEHS as u32,
    WHILELE = Operation_ARM64_WHILELE as u32,
    WHILELO = Operation_ARM64_WHILELO as u32,
    WHILELS = Operation_ARM64_WHILELS as u32,
    WHILELT = Operation_ARM64_WHILELT as u32,
    WHILERW = Operation_ARM64_WHILERW as u32,
    WHILEWR = Operation_ARM64_WHILEWR as u32,
    WRFFR = Operation_ARM64_WRFFR as u32,
    XAFLAG = Operation_ARM64_XAFLAG as u32,
    XAR = Operation_ARM64_XAR as u32,
    XPACD = Operation_ARM64_XPACD as u32,
    XPACI = Operation_ARM64_XPACI as u32,
    XPACLRI = Operation_ARM64_XPACLRI as u32,
    XTN = Operation_ARM64_XTN as u32,
    XTN2 = Operation_ARM64_XTN2 as u32,
    YIELD = Operation_ARM64_YIELD as u32,
    ZERO = Operation_ARM64_ZERO as u32,
    ZIP1 = Operation_ARM64_ZIP1 as u32,
    ZIP2 = Operation_ARM64_ZIP2 as u32,
}

// this is a guard to try to detect if new instructions get added
const_assert_eq!(Operation_ARM64_ZIP2, 1183);

impl Op {
    /// Get the operation name
    ///
    /// This is an alias for the instruction mnemonic
    ///
    /// # Examples
    /// ```
    /// use bad64::{decode, Op};
    ///
    /// // nop
    /// let decoded = decode(0xd503201f, 0x1000).unwrap();
    ///
    /// assert_eq!(decoded.op(), Op::NOP);
    /// assert_eq!(decoded.op().mnem(), "nop");
    /// ```
    pub fn mnem(&self) -> &'static str {
        #[cfg(target_os = "windows")]
        {
            unsafe { CStr::from_ptr(operation_to_str(self.to_i32().unwrap()) as _) }
                .to_str()
                .unwrap()
        }
        #[cfg(not(target_os = "windows"))]
        {
            unsafe { CStr::from_ptr(operation_to_str(self.to_u32().unwrap()) as _) }
                .to_str()
                .unwrap()
        }
    }
}

impl fmt::Display for Op {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "{}", self.mnem())
    }
}
