/* GENERATED FILE */
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>

#include "decode.h"
#include "decode2.h"
#include "pcode.h"
#include "decode_fields32.h"

/* abs_advsimd.xml */
int ABS_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|10000|opcode=01011|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x5E20B800) {
		decode_fields32(ENC_ABS_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size!=3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->neg = (ctx->U==1);
		OK(ENC_ABS_ASISDMISC_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|10000|opcode=01011|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE20B800) {
		decode_fields32(ENC_ABS_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->neg = (ctx->U==1);
		OK(ENC_ABS_ASIMDMISC_R);
	}
	return rc;
}

/* adc.xml */
int ADC(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|op=0|S=0|11010000|Rm=xxxxx|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0FC00)==0x1A000000) {
		decode_fields32(ENC_ADC_32_ADDSUB_CARRY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		instr->setflags = (ctx->S==1);
		ctx->setflags = (ctx->S==1);
		if(ctx->sf==0) OK(ENC_ADC_32_ADDSUB_CARRY);
		if(ctx->sf==1) OK(ENC_ADC_64_ADDSUB_CARRY);
	}
	return rc;
}

/* adcs.xml */
int ADCS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|op=0|S=1|11010000|Rm=xxxxx|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0FC00)==0x3A000000) {
		decode_fields32(ENC_ADCS_32_ADDSUB_CARRY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		instr->setflags = (ctx->S==1);
		ctx->setflags = (ctx->S==1);
		if(ctx->sf==0) OK(ENC_ADCS_32_ADDSUB_CARRY);
		if(ctx->sf==1) OK(ENC_ADCS_64_ADDSUB_CARRY);
	}
	return rc;
}

/* addg.xml */
int ADDG(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|op=0|S=0|100011|o2=0|uimm6=xxxxxx|op3=(0)(0)|uimm4=xxxx|Xn=xxxxx|Xd=xxxxx */
	if((INSWORD & 0xFFC00000)==0x91800000) {
		decode_fields32(ENC_ADDG_64_ADDSUB_IMMTAGS, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Xd);
		ctx->n = UINT(ctx->Xn);
		ctx->tag_offset = ctx->uimm4;
		ctx->offset = LSL(ZeroExtend(ctx->uimm6,0x40),LOG2_TAG_GRANULE);
		ctx->ADD = TRUE;
		OK(ENC_ADDG_64_ADDSUB_IMMTAGS);
	}
	return rc;
}

/* addhn_advsimd.xml */
int ADDHN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|01|o1=0|0|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE204000) {
		decode_fields32(ENC_ADDHN_ASIMDDIFF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		ctx->round = (ctx->U==1);
		OK(ENC_ADDHN_ASIMDDIFF_N);
	}
	return rc;
}

/* addp_advsimd_pair.xml */
int ADDP_advsimd_pair(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 01|U=0|11110|size=xx|11000|opcode=11011|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x5E31B800) {
		decode_fields32(ENC_ADDP_ASISDPAIR_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size!=3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->esize) * (2);
		ctx->elements = 2;
		ctx->op = ReduceOp_ADD;
		OK(ENC_ADDP_ASISDPAIR_ONLY);
	}
	return rc;
}

/* addp_advsimd_vec.xml */
int ADDP_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|opcode=10111|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE20BC00) {
		decode_fields32(ENC_ADDP_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_ADDP_ASIMDSAME_ONLY);
	}
	return rc;
}

/* adds_addsub_ext.xml */
int ADDS_addsub_ext(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|op=0|S=1|01011|opt=00|1|Rm=xxxxx|option=xxx|imm3=xxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE00000)==0x2B200000) {
		decode_fields32(ENC_ADDS_32S_ADDSUB_EXT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		instr->setflags = (ctx->S==1);
		ctx->setflags = (ctx->S==1);
		ctx->extend_type = DecodeRegExtend(ctx->option);
		ctx->shift = UINT(ctx->imm3);
		if(ctx->shift>4) {
			UNDEFINED;
		}
		/* regular aliases */
		if(ctx->Rd==0x1f) return CMN_ADDS_addsub_ext(ctx, instr);
		if(ctx->sf==0) OK(ENC_ADDS_32S_ADDSUB_EXT);
		if(ctx->sf==1) OK(ENC_ADDS_64S_ADDSUB_EXT);
	}
	return rc;
}

/* adds_addsub_imm.xml */
int ADDS_addsub_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|op=0|S=1|100010|sh=x|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x31000000) {
		decode_fields32(ENC_ADDS_32S_ADDSUB_IMM, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		instr->setflags = (ctx->S==1);
		ctx->setflags = (ctx->S==1);
		if(!ctx->sh) {
			ctx->imm = ZeroExtend(ctx->imm12,ctx->datasize);
		}
		else if(ctx->sh) {
			ctx->imm = ZeroExtend(((ctx->imm12<<12)|0),ctx->datasize);
		}
		/* regular aliases */
		if(ctx->Rd==0x1f) return CMN_ADDS_addsub_imm(ctx, instr);
		if(ctx->sf==0) OK(ENC_ADDS_32S_ADDSUB_IMM);
		if(ctx->sf==1) OK(ENC_ADDS_64S_ADDSUB_IMM);
	}
	return rc;
}

/* adds_addsub_shift.xml */
int ADDS_addsub_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|op=0|S=1|01011|shift=xx|0|Rm=xxxxx|imm6=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F200000)==0x2B000000) {
		decode_fields32(ENC_ADDS_32_ADDSUB_SHIFT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		instr->setflags = (ctx->S==1);
		ctx->setflags = (ctx->S==1);
		if(ctx->shift==3) {
			UNDEFINED;
		}
		if(ctx->sf==0 && SLICE(ctx->imm6,5,5)==1) {
			UNDEFINED;
		}
		ctx->shift_type = DecodeShift(ctx->shift);
		ctx->shift_amount = UINT(ctx->imm6);
		/* regular aliases */
		if(ctx->Rd==0x1f) return CMN_ADDS_addsub_shift(ctx, instr);
		if(ctx->sf==0) OK(ENC_ADDS_32_ADDSUB_SHIFT);
		if(ctx->sf==1) OK(ENC_ADDS_64_ADDSUB_SHIFT);
	}
	return rc;
}

/* addv_advsimd.xml */
int ADDV_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|U=0|01110|size=xx|11000|opcode=11011|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE31B800) {
		decode_fields32(ENC_ADDV_ASIMDALL_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==4) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->op = ReduceOp_ADD;
		OK(ENC_ADDV_ASIMDALL_ONLY);
	}
	return rc;
}

/* add_addsub_ext.xml */
int ADD_addsub_ext(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|op=0|S=0|01011|opt=00|1|Rm=xxxxx|option=xxx|imm3=xxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE00000)==0xB200000) {
		decode_fields32(ENC_ADD_32_ADDSUB_EXT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		instr->setflags = (ctx->S==1);
		ctx->setflags = (ctx->S==1);
		ctx->extend_type = DecodeRegExtend(ctx->option);
		ctx->shift = UINT(ctx->imm3);
		if(ctx->shift>4) {
			UNDEFINED;
		}
		if(ctx->sf==0) OK(ENC_ADD_32_ADDSUB_EXT);
		if(ctx->sf==1) OK(ENC_ADD_64_ADDSUB_EXT);
	}
	return rc;
}

/* add_addsub_imm.xml */
int ADD_addsub_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|op=0|S=0|100010|sh=x|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x11000000) {
		decode_fields32(ENC_ADD_32_ADDSUB_IMM, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		instr->setflags = (ctx->S==1);
		ctx->setflags = (ctx->S==1);
		if(!ctx->sh) {
			ctx->imm = ZeroExtend(ctx->imm12,ctx->datasize);
		}
		else if(ctx->sh) {
			ctx->imm = ZeroExtend(((ctx->imm12<<12)|0),ctx->datasize);
		}
		/* regular aliases */
		if(ctx->sh==0 && ctx->imm12==0 && (ctx->Rd==0x1f || ctx->Rn==0x1f)) return MOV_ADD_addsub_imm(ctx, instr);
		if(ctx->sf==0) OK(ENC_ADD_32_ADDSUB_IMM);
		if(ctx->sf==1) OK(ENC_ADD_64_ADDSUB_IMM);
	}
	return rc;
}

/* add_addsub_shift.xml */
int ADD_addsub_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|op=0|S=0|01011|shift=xx|0|Rm=xxxxx|imm6=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F200000)==0xB000000) {
		decode_fields32(ENC_ADD_32_ADDSUB_SHIFT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		instr->setflags = (ctx->S==1);
		ctx->setflags = (ctx->S==1);
		if(ctx->shift==3) {
			UNDEFINED;
		}
		if(ctx->sf==0 && SLICE(ctx->imm6,5,5)==1) {
			UNDEFINED;
		}
		ctx->shift_type = DecodeShift(ctx->shift);
		ctx->shift_amount = UINT(ctx->imm6);
		if(ctx->sf==0) OK(ENC_ADD_32_ADDSUB_SHIFT);
		if(ctx->sf==1) OK(ENC_ADD_64_ADDSUB_SHIFT);
	}
	return rc;
}

/* add_advsimd.xml */
int ADD_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|1|Rm=xxxxx|opcode=10000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x5E208400) {
		decode_fields32(ENC_ADD_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size!=3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->sub_op = (ctx->U==1);
		OK(ENC_ADD_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|opcode=10000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE208400) {
		decode_fields32(ENC_ADD_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->U==1);
		OK(ENC_ADD_ASIMDSAME_ONLY);
	}
	return rc;
}

/* adr.xml */
int ADR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_literal */
	/* op=0|immlo=xx|10000|immhi=xxxxxxxxxxxxxxxxxxx|Rd=xxxxx */
	if((INSWORD & 0x9F000000)==0x10000000) {
		decode_fields32(ENC_ADR_ONLY_PCRELADDR, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->page = (ctx->op==1);
		if(ctx->page) {
			ctx->imm = SignExtend(((ctx->immhi<<14)|(ctx->immlo<<12)|0),33);
		}
		else {
			ctx->imm = SignExtend(((ctx->immhi<<2)|ctx->immlo),21);
		}
		OK(ENC_ADR_ONLY_PCRELADDR);
	}
	return rc;
}

/* adrp.xml */
int ADRP(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_literal */
	/* op=1|immlo=xx|10000|immhi=xxxxxxxxxxxxxxxxxxx|Rd=xxxxx */
	if((INSWORD & 0x9F000000)==0x90000000) {
		decode_fields32(ENC_ADRP_ONLY_PCRELADDR, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->page = (ctx->op==1);
		if(ctx->page) {
			ctx->imm = SignExtend(((ctx->immhi<<14)|(ctx->immlo<<12)|0),33);
		}
		else {
			ctx->imm = SignExtend(((ctx->immhi<<2)|ctx->immlo),21);
		}
		OK(ENC_ADRP_ONLY_PCRELADDR);
	}
	return rc;
}

/* aesd_advsimd.xml */
int AESD_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 01001110|size=00|10100|0010|D=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x4E285800) {
		decode_fields32(ENC_AESD_B_CRYPTOAES, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!HaveAESExt()) {
			UNDEFINED;
		}
		ctx->decrypt = (ctx->D==1);
		OK(ENC_AESD_B_CRYPTOAES);
	}
	return rc;
}

/* aese_advsimd.xml */
int AESE_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 01001110|size=00|10100|0010|D=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x4E284800) {
		decode_fields32(ENC_AESE_B_CRYPTOAES, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!HaveAESExt()) {
			UNDEFINED;
		}
		ctx->decrypt = (ctx->D==1);
		OK(ENC_AESE_B_CRYPTOAES);
	}
	return rc;
}

/* aesimc_advsimd.xml */
int AESIMC_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 01001110|size=00|10100|0011|D=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x4E287800) {
		decode_fields32(ENC_AESIMC_B_CRYPTOAES, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!HaveAESExt()) {
			UNDEFINED;
		}
		ctx->decrypt = (ctx->D==1);
		OK(ENC_AESIMC_B_CRYPTOAES);
	}
	return rc;
}

/* aesmc_advsimd.xml */
int AESMC_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 01001110|size=00|10100|0011|D=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x4E286800) {
		decode_fields32(ENC_AESMC_B_CRYPTOAES, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!HaveAESExt()) {
			UNDEFINED;
		}
		ctx->decrypt = (ctx->D==1);
		OK(ENC_AESMC_B_CRYPTOAES);
	}
	return rc;
}

/* ands_log_imm.xml */
int ANDS_log_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|opc=11|100100|N=x|immr=xxxxxx|imms=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x72000000) {
		decode_fields32(ENC_ANDS_32S_LOG_IMM, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==1) {
			ctx->op = LogicalOp_ORR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==2) {
			ctx->op = LogicalOp_EOR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==3) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = TRUE;
		}
		if(ctx->sf==0 && ctx->N!=0) {
			UNDEFINED;
		}
		DecodeBitMasksCheckUndefined(ctx->N,ctx->imms);
		DecodeBitMasks_ReturnType dbmrt = DecodeBitMasks(ctx->N,ctx->imms,ctx->immr);
		ctx->imm = dbmrt.wmask;
		/* regular aliases */
		if(ctx->Rd==0x1f) return TST_ANDS_log_imm(ctx, instr);
		if(ctx->sf==0 && ctx->N==0) OK(ENC_ANDS_32S_LOG_IMM);
		if(ctx->sf==1) OK(ENC_ANDS_64S_LOG_IMM);
	}
	return rc;
}

/* ands_log_shift.xml */
int ANDS_log_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|opc=11|01010|shift=xx|N=0|Rm=xxxxx|imm6=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F200000)==0x6A000000) {
		decode_fields32(ENC_ANDS_32_LOG_SHIFT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==1) {
			ctx->op = LogicalOp_ORR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==2) {
			ctx->op = LogicalOp_EOR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==3) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = TRUE;
		}
		if(ctx->sf==0 && SLICE(ctx->imm6,5,5)==1) {
			UNDEFINED;
		}
		ctx->shift_type = DecodeShift(ctx->shift);
		ctx->shift_amount = UINT(ctx->imm6);
		ctx->invert = (ctx->N==1);
		/* regular aliases */
		if(ctx->Rd==0x1f) return TST_ANDS_log_shift(ctx, instr);
		if(ctx->sf==0) OK(ENC_ANDS_32_LOG_SHIFT);
		if(ctx->sf==1) OK(ENC_ANDS_64_LOG_SHIFT);
	}
	return rc;
}

/* and_advsimd.xml */
int AND_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=00|1|Rm=xxxxx|opcode=00011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xE201C00) {
		decode_fields32(ENC_AND_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 8;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->invert = (SLICE(ctx->size,0,0)==1);
		ctx->op = (SLICE(ctx->size,1,1)==1) ? LogicalOp_ORR : LogicalOp_AND;
		OK(ENC_AND_ASIMDSAME_ONLY);
	}
	return rc;
}

/* and_log_imm.xml */
int AND_log_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|opc=00|100100|N=x|immr=xxxxxx|imms=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x12000000) {
		decode_fields32(ENC_AND_32_LOG_IMM, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==1) {
			ctx->op = LogicalOp_ORR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==2) {
			ctx->op = LogicalOp_EOR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==3) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = TRUE;
		}
		if(ctx->sf==0 && ctx->N!=0) {
			UNDEFINED;
		}
		DecodeBitMasksCheckUndefined(ctx->N,ctx->imms);
		DecodeBitMasks_ReturnType dbmrt = DecodeBitMasks(ctx->N,ctx->imms,ctx->immr);
		ctx->imm = dbmrt.wmask;
		if(ctx->sf==0 && ctx->N==0) OK(ENC_AND_32_LOG_IMM);
		if(ctx->sf==1) OK(ENC_AND_64_LOG_IMM);
	}
	return rc;
}

/* and_log_shift.xml */
int AND_log_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|opc=00|01010|shift=xx|N=0|Rm=xxxxx|imm6=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F200000)==0xA000000) {
		decode_fields32(ENC_AND_32_LOG_SHIFT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==1) {
			ctx->op = LogicalOp_ORR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==2) {
			ctx->op = LogicalOp_EOR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==3) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = TRUE;
		}
		if(ctx->sf==0 && SLICE(ctx->imm6,5,5)==1) {
			UNDEFINED;
		}
		ctx->shift_type = DecodeShift(ctx->shift);
		ctx->shift_amount = UINT(ctx->imm6);
		ctx->invert = (ctx->N==1);
		if(ctx->sf==0) OK(ENC_AND_32_LOG_SHIFT);
		if(ctx->sf==1) OK(ENC_AND_64_LOG_SHIFT);
	}
	return rc;
}

/* asrv.xml */
int ASRV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=0|S=0|11010110|Rm=xxxxx|opcode2<5:2>=0010|op2=10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0FC00)==0x1AC02800) {
		decode_fields32(ENC_ASRV_32_DP_2SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->shift_type = DecodeShift(ctx->op2);
		/* unconditional alias */
		if(ASR_ASRV(ctx, instr)==0) return 0;
		if(ctx->sf==0) OK(ENC_ASRV_32_DP_2SRC);
		if(ctx->sf==1) OK(ENC_ASRV_64_DP_2SRC);
	}
	return rc;
}

/* asr_asrv.xml */
int ASR_ASRV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=0|S=0|11010110|Rm=xxxxx|opcode2<5:2>=0010|op2=10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0FC00)==0x1AC02800) {
		decode_fields32(ENC_ASR_ASRV_32_DP_2SRC, ctx, instr);
		if(ctx->sf==0) OK(ENC_ASR_ASRV_32_DP_2SRC);
		if(ctx->sf==1) OK(ENC_ASR_ASRV_64_DP_2SRC);
	}
	return rc;
}

/* asr_sbfm.xml */
int ASR_SBFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_signed_fill */
	/* sf=x|opc=00|100110|N=x|immr=xxxxxx|imms=x11111|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F807C00)==0x13007C00) {
		decode_fields32(ENC_ASR_SBFM_32M_BITFIELD, ctx, instr);
		if(ctx->sf==0 && ctx->N==0 && ctx->imms==0x1f) OK(ENC_ASR_SBFM_32M_BITFIELD);
		if(ctx->sf==1 && ctx->N==1 && ctx->imms==0x3f) OK(ENC_ASR_SBFM_64M_BITFIELD);
	}
	return rc;
}

/* at_sys.xml */
int AT_SYS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=01|op1=xxx|CRn=0111|CRm=100x|op2=xxx|Rt=xxxxx */
	if((INSWORD & 0xFFF8FE00)==0xD5087800) {
		decode_fields32(ENC_AT_SYS_CR_SYSTEMINSTRS, ctx, instr);
		OK(ENC_AT_SYS_CR_SYSTEMINSTRS);
	}
	return rc;
}

/* autda.xml */
int AUTDA(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|1|S=0|11010110|opcode2=00001|opcode[5]=0|opcode[4]=0|Z=x|opcode[2:0]=110|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFDC00)==0xDAC11800) {
		decode_fields32(ENC_AUTDA_64P_DP_1SRC, ctx, instr);
		ctx->source_is_sp = FALSE;
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!HavePACExt()) {
			UNDEFINED;
		}
		if(ctx->Z==0) {
			if(ctx->n==0x1f) {
				ctx->source_is_sp = TRUE;
			}
		}
		else {
			if(ctx->n!=0x1f) {
				UNDEFINED;
			}
		}
		if(ctx->Z==0) OK(ENC_AUTDA_64P_DP_1SRC);
		if(ctx->Z==1 && ctx->Rn==0x1f) OK(ENC_AUTDZA_64Z_DP_1SRC);
	}
	return rc;
}

/* autdb.xml */
int AUTDB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|1|S=0|11010110|opcode2=00001|opcode[5]=0|opcode[4]=0|Z=x|opcode[2:0]=111|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFDC00)==0xDAC11C00) {
		decode_fields32(ENC_AUTDB_64P_DP_1SRC, ctx, instr);
		ctx->source_is_sp = FALSE;
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!HavePACExt()) {
			UNDEFINED;
		}
		if(ctx->Z==0) {
			if(ctx->n==0x1f) {
				ctx->source_is_sp = TRUE;
			}
		}
		else {
			if(ctx->n!=0x1f) {
				UNDEFINED;
			}
		}
		if(ctx->Z==0) OK(ENC_AUTDB_64P_DP_1SRC);
		if(ctx->Z==1 && ctx->Rn==0x1f) OK(ENC_AUTDZB_64Z_DP_1SRC);
	}
	return rc;
}

/* autia.xml */
int AUTIA(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|1|S=0|11010110|opcode2=00001|opcode[5]=0|opcode[4]=0|Z=x|opcode[2:0]=100|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFDC00)==0xDAC11000) {
		decode_fields32(ENC_AUTIA_64P_DP_1SRC, ctx, instr);
		ctx->source_is_sp = FALSE;
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!HavePACExt()) {
			UNDEFINED;
		}
		if(ctx->Z==0) {
			if(ctx->n==0x1f) {
				ctx->source_is_sp = TRUE;
			}
		}
		else {
			if(ctx->n!=0x1f) {
				UNDEFINED;
			}
		}
		if(ctx->Z==0) OK(ENC_AUTIA_64P_DP_1SRC);
		if(ctx->Z==1 && ctx->Rn==0x1f) OK(ENC_AUTIZA_64Z_DP_1SRC);
	}
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=00x1|op2=10x|Rt=11111 */
	if((INSWORD & 0xFFFFFDDF)==0xD503219F) {
		decode_fields32(ENC_AUTIA1716_HI_HINTS, ctx, instr);
		if(ctx->CRm==1 && ctx->op2==4) OK(ENC_AUTIA1716_HI_HINTS);
		if(ctx->CRm==3 && ctx->op2==5) OK(ENC_AUTIASP_HI_HINTS);
		if(ctx->CRm==3 && ctx->op2==4) OK(ENC_AUTIAZ_HI_HINTS);
	}
	return rc;
}

/* autib.xml */
int AUTIB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|1|S=0|11010110|opcode2=00001|opcode[5]=0|opcode[4]=0|Z=x|opcode[2:0]=101|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFDC00)==0xDAC11400) {
		decode_fields32(ENC_AUTIB_64P_DP_1SRC, ctx, instr);
		ctx->source_is_sp = FALSE;
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!HavePACExt()) {
			UNDEFINED;
		}
		if(ctx->Z==0) {
			if(ctx->n==0x1f) {
				ctx->source_is_sp = TRUE;
			}
		}
		else {
			if(ctx->n!=0x1f) {
				UNDEFINED;
			}
		}
		if(ctx->Z==0) OK(ENC_AUTIB_64P_DP_1SRC);
		if(ctx->Z==1 && ctx->Rn==0x1f) OK(ENC_AUTIZB_64Z_DP_1SRC);
	}
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=00x1|op2=11x|Rt=11111 */
	if((INSWORD & 0xFFFFFDDF)==0xD50321DF) {
		decode_fields32(ENC_AUTIB1716_HI_HINTS, ctx, instr);
		if(ctx->CRm==1 && ctx->op2==6) OK(ENC_AUTIB1716_HI_HINTS);
		if(ctx->CRm==3 && ctx->op2==7) OK(ENC_AUTIBSP_HI_HINTS);
		if(ctx->CRm==3 && ctx->op2==6) OK(ENC_AUTIBZ_HI_HINTS);
	}
	return rc;
}

/* axflag.xml */
int AXFLAG(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=000|CRn=0100|CRm=(0)(0)(0)(0)|op2=010|Rt =11111 */
	if((INSWORD & 0xFFFFF0FF)==0xD500405F) {
		decode_fields32(ENC_AXFLAG_M_PSTATE, ctx, instr);
		if(!HaveFlagFormatExt()) {
			UNDEFINED;
		}
		OK(ENC_AXFLAG_M_PSTATE);
	}
	return rc;
}

/* bcax_advsimd.xml */
int BCAX_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 110011100|Op0=01|Rm=xxxxx|0|Ra=xxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE08000)==0xCE200000) {
		decode_fields32(ENC_BCAX_VVV16_CRYPTO4, ctx, instr);
		if(!HaveSHA3Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->a = UINT(ctx->Ra);
		OK(ENC_BCAX_VVV16_CRYPTO4);
	}
	return rc;
}

/* bfcvtn_advsimd.xml */
int BFCVTN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd_single_and_bf16 */
	/* 0|Q=x|U=0|01110|size=10|10000|opcode=10110|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xEA16800) {
		decode_fields32(ENC_BFCVTN_ASIMDMISC_4S, ctx, instr);
		if(!HaveBF16Ext()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->d = UINT(ctx->Rd);
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((0x10) ? ((0x40) / (0x10)) : 0);
		OK(ENC_BFCVTN_ASIMDMISC_4S);
	}
	return rc;
}

/* bfcvt_float.xml */
int BFCVT_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_single_to_bf16 */
	/* M=0|0|S=0|11110|ptype=01|1|opcode=000110|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x1E634000) {
		decode_fields32(ENC_BFCVT_BS_FLOATDP1, ctx, instr);
		if(!HaveBF16Ext()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->d = UINT(ctx->Rd);
		OK(ENC_BFCVT_BS_FLOATDP1);
	}
	return rc;
}

/* bfc_bfm.xml */
int BFC_BFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_nofill */
	/* sf=x|opc=01|100110|N=x|immr=xxxxxx|imms=xxxxxx|Rn=11111|Rd=xxxxx */
	if((INSWORD & 0x7F8003E0)==0x330003E0) {
		decode_fields32(ENC_BFC_BFM_32M_BITFIELD, ctx, instr);
		if(ctx->sf==0 && ctx->N==0) OK(ENC_BFC_BFM_32M_BITFIELD);
		if(ctx->sf==1 && ctx->N==1) OK(ENC_BFC_BFM_64M_BITFIELD);
	}
	return rc;
}

/* bfdot_advsimd_elt.xml */
int BFDOT_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_element */
	/* 0|Q=x|U=0|01111|size=01|L=x|M=x|Rm=xxxx|opcode=1111|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFC0F400)==0xF40F000) {
		decode_fields32(ENC_BFDOT_ASIMDELEM_E, ctx, instr);
		if(!HaveBF16Ext()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->M<<4)|ctx->Rm));
		ctx->d = UINT(ctx->Rd);
		ctx->i = UINT(((ctx->H<<1)|ctx->L));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((0x20) ? ((ctx->datasize) / (0x20)) : 0);
		OK(ENC_BFDOT_ASIMDELEM_E);
	}
	return rc;
}

/* bfdot_advsimd_vec.xml */
int BFDOT_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=01|0|Rm=xxxxx|1|opcode=1111|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2E40FC00) {
		decode_fields32(ENC_BFDOT_ASIMDSAME2_D, ctx, instr);
		if(!HaveBF16Ext()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->d = UINT(ctx->Rd);
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((0x20) ? ((ctx->datasize) / (0x20)) : 0);
		OK(ENC_BFDOT_ASIMDSAME2_D);
	}
	return rc;
}

/* bfi_bfm.xml */
int BFI_BFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_nofill */
	/* sf=x|opc=01|100110|N=x|immr=xxxxxx|imms=xxxxxx|Rn!=11111|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x33000000 && (INSWORD & 0x3E0)!=0x3E0) {
		decode_fields32(ENC_BFI_BFM_32M_BITFIELD, ctx, instr);
		if(ctx->sf==0 && ctx->N==0) OK(ENC_BFI_BFM_32M_BITFIELD);
		if(ctx->sf==1 && ctx->N==1) OK(ENC_BFI_BFM_64M_BITFIELD);
	}
	return rc;
}

/* bfm.xml */
int BFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_nofill */
	/* sf=x|opc=01|100110|N=x|immr=xxxxxx|imms=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x33000000) {
		decode_fields32(ENC_BFM_32M_BITFIELD, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ctx->inzero = TRUE;
			ctx->extend = TRUE;
		}
		else if(ctx->opc==1) {
			ctx->inzero = FALSE;
			ctx->extend = FALSE;
		}
		else if(ctx->opc==2) {
			ctx->inzero = TRUE;
			ctx->extend = FALSE;
		}
		else if(ctx->opc==3) {
			UNDEFINED;
		}
		if(ctx->sf==1 && ctx->N!=1) {
			UNDEFINED;
		}
		if(ctx->sf==0 && (ctx->N!=0 || SLICE(ctx->immr,5,5)!=0 || SLICE(ctx->imms,5,5)!=0)) {
			UNDEFINED;
		}
		ctx->R = UINT(ctx->immr);
		ctx->S = UINT(ctx->imms);
		DecodeBitMasks_ReturnType dbmrt = DecodeBitMasks(ctx->N,ctx->imms,ctx->immr);
		ctx->wmask = dbmrt.wmask;
		ctx->tmask = dbmrt.tmask;
		/* regular aliases */
		if(ctx->Rn==0x1f && UINT(ctx->imms)<UINT(ctx->immr)) return BFC_BFM(ctx, instr);
		if(ctx->Rn!=0x1f && UINT(ctx->imms)<UINT(ctx->immr)) return BFI_BFM(ctx, instr);
		if((UINT(ctx->imms)) >= (UINT(ctx->immr))) return BFXIL_BFM(ctx, instr);
		if(ctx->sf==0 && ctx->N==0) OK(ENC_BFM_32M_BITFIELD);
		if(ctx->sf==1 && ctx->N==1) OK(ENC_BFM_64M_BITFIELD);
	}
	return rc;
}

/* bfmlal_advsimd_elt.xml */
int BFMLAL_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_element */
	/* 0|Q=x|U=0|01111|size=11|L=x|M=x|Rm=xxxx|opcode<3>=1|opcode<2>=1|opcode<1:0>=11|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFC0F400)==0xFC0F000) {
		decode_fields32(ENC_BFMLAL_ASIMDELEM_F, ctx, instr);
		if(!HaveBF16Ext()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->d = UINT(ctx->Rd);
		ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
		ctx->elements = ((0x20) ? ((0x80) / (0x20)) : 0);
		ctx->sel = UINT(ctx->Q);
		OK(ENC_BFMLAL_ASIMDELEM_F);
	}
	return rc;
}

/* bfmlal_advsimd_vec.xml */
int BFMLAL_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=11|0|Rm=xxxxx|1|opcode<3:2>=11|opcode=11|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2EC0FC00) {
		decode_fields32(ENC_BFMLAL_ASIMDSAME2_F_, ctx, instr);
		if(!HaveBF16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->elements = ((0x20) ? ((0x80) / (0x20)) : 0);
		ctx->sel = UINT(ctx->Q);
		OK(ENC_BFMLAL_ASIMDSAME2_F_);
	}
	return rc;
}

/* bfmmla_advsimd.xml */
int BFMMLA_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=1|U=1|01110|size=01|0|Rm=xxxxx|1|opcode=1101|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x6E40EC00) {
		decode_fields32(ENC_BFMMLA_ASIMDSAME2_E, ctx, instr);
		if(!HaveBF16Ext()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->d = UINT(ctx->Rd);
		OK(ENC_BFMMLA_ASIMDSAME2_E);
	}
	return rc;
}

/* bfxil_bfm.xml */
int BFXIL_BFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_nofill */
	/* sf=x|opc=01|100110|N=x|immr=xxxxxx|imms=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x33000000) {
		decode_fields32(ENC_BFXIL_BFM_32M_BITFIELD, ctx, instr);
		if(ctx->sf==0 && ctx->N==0) OK(ENC_BFXIL_BFM_32M_BITFIELD);
		if(ctx->sf==1 && ctx->N==1) OK(ENC_BFXIL_BFM_64M_BITFIELD);
	}
	return rc;
}

/* bics.xml */
int BICS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|opc=11|01010|shift=xx|N=1|Rm=xxxxx|imm6=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F200000)==0x6A200000) {
		decode_fields32(ENC_BICS_32_LOG_SHIFT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==1) {
			ctx->op = LogicalOp_ORR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==2) {
			ctx->op = LogicalOp_EOR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==3) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = TRUE;
		}
		if(ctx->sf==0 && SLICE(ctx->imm6,5,5)==1) {
			UNDEFINED;
		}
		ctx->shift_type = DecodeShift(ctx->shift);
		ctx->shift_amount = UINT(ctx->imm6);
		ctx->invert = (ctx->N==1);
		if(ctx->sf==0) OK(ENC_BICS_32_LOG_SHIFT);
		if(ctx->sf==1) OK(ENC_BICS_64_LOG_SHIFT);
	}
	return rc;
}

/* bic_advsimd_imm.xml */
int BIC_advsimd_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_shifted_immediate */
	/* 0|Q=x|op=1|0111100000|a=x|b=x|c=x|cmode=xxx1|o2=0|1|d=x|e=x|f=x|g=x|h=x|Rd=xxxxx */
	if((INSWORD & 0xBFF81C00)==0x2F001400) {
		decode_fields32(ENC_BIC_ASIMDIMM_L_HL, ctx, instr);
		ctx->rd = UINT(ctx->Rd);
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		if(!(((ctx->cmode<<1)|ctx->op)&0x13)) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x13)==1) {
			ctx->operation_ = ImmediateOp_MVNI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x13)==2) {
			ctx->operation_ = ImmediateOp_ORR;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x13)==3) {
			ctx->operation_ = ImmediateOp_BIC;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x10) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x11) {
			ctx->operation_ = ImmediateOp_MVNI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x12) {
			ctx->operation_ = ImmediateOp_ORR;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x13) {
			ctx->operation_ = ImmediateOp_BIC;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1d)==0x18) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1d)==0x19) {
			ctx->operation_ = ImmediateOp_MVNI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1e)==0x1c) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if(((ctx->cmode<<1)|ctx->op)==0x1e) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if(((ctx->cmode<<1)|ctx->op)==0x1f) {
			if(ctx->Q==0) {
				UNDEFINED;
			}
			ctx->operation_ = ImmediateOp_MOVI;
		}
		ctx->imm64 = AdvSIMDExpandImm(ctx->op,ctx->cmode,((ctx->a<<7)|(ctx->b<<6)|(ctx->c<<5)|(ctx->d<<4)|(ctx->e<<3)|(ctx->f<<2)|(ctx->g<<1)|ctx->h));
		ctx->imm = Replicate(ctx->imm64, ((0x40) ? ((ctx->datasize) / (0x40)) : 0), 64);
		if((ctx->cmode&13)==9) OK(ENC_BIC_ASIMDIMM_L_HL);
		if((ctx->cmode&9)==1) OK(ENC_BIC_ASIMDIMM_L_SL);
	}
	return rc;
}

/* bic_advsimd_reg.xml */
int BIC_advsimd_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=01|1|Rm=xxxxx|opcode=00011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xE601C00) {
		decode_fields32(ENC_BIC_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 8;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->invert = (SLICE(ctx->size,0,0)==1);
		ctx->op = (SLICE(ctx->size,1,1)==1) ? LogicalOp_ORR : LogicalOp_AND;
		OK(ENC_BIC_ASIMDSAME_ONLY);
	}
	return rc;
}

/* bic_and_z_zi.xml */
int BIC_and_z_zi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|opc=10|0000|imm13=xxxxxxxxxxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFFFC0000)==0x5800000) {
		decode_fields32(ENC_BIC_AND_Z_ZI_, ctx, instr);
		OK(ENC_BIC_AND_Z_ZI_);
	}
	return rc;
}

/* bic_log_shift.xml */
int BIC_log_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|opc=00|01010|shift=xx|N=1|Rm=xxxxx|imm6=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F200000)==0xA200000) {
		decode_fields32(ENC_BIC_32_LOG_SHIFT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==1) {
			ctx->op = LogicalOp_ORR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==2) {
			ctx->op = LogicalOp_EOR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==3) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = TRUE;
		}
		if(ctx->sf==0 && SLICE(ctx->imm6,5,5)==1) {
			UNDEFINED;
		}
		ctx->shift_type = DecodeShift(ctx->shift);
		ctx->shift_amount = UINT(ctx->imm6);
		ctx->invert = (ctx->N==1);
		if(ctx->sf==0) OK(ENC_BIC_32_LOG_SHIFT);
		if(ctx->sf==1) OK(ENC_BIC_64_LOG_SHIFT);
	}
	return rc;
}

/* bif_advsimd.xml */
int BIF_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=1|01110|opc2=11|1|Rm=xxxxx|opcode=00011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2EE01C00) {
		decode_fields32(ENC_BIF_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 8;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!ctx->opc2) {
			ctx->op = VBitOp_VEOR;
		}
		else if(ctx->opc2==1) {
			ctx->op = VBitOp_VBSL;
		}
		else if(ctx->opc2==2) {
			ctx->op = VBitOp_VBIT;
		}
		else if(ctx->opc2==3) {
			ctx->op = VBitOp_VBIF;
		}
		OK(ENC_BIF_ASIMDSAME_ONLY);
	}
	return rc;
}

/* bit_advsimd.xml */
int BIT_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=1|01110|opc2=10|1|Rm=xxxxx|opcode=00011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2EA01C00) {
		decode_fields32(ENC_BIT_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 8;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!ctx->opc2) {
			ctx->op = VBitOp_VEOR;
		}
		else if(ctx->opc2==1) {
			ctx->op = VBitOp_VBSL;
		}
		else if(ctx->opc2==2) {
			ctx->op = VBitOp_VBIT;
		}
		else if(ctx->opc2==3) {
			ctx->op = VBitOp_VBIF;
		}
		OK(ENC_BIT_ASIMDSAME_ONLY);
	}
	return rc;
}

/* bl.xml */
int BL(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_br26 */
	/* op=1|00101|imm26=xxxxxxxxxxxxxxxxxxxxxxxxxx */
	if((INSWORD & 0xFC000000)==0x94000000) {
		decode_fields32(ENC_BL_ONLY_BRANCH_IMM, ctx, instr);
		ctx->branch_type = (ctx->op==1) ? BranchType_DIRCALL : BranchType_DIR;
		ctx->offset = SignExtend((ctx->imm26<<2),28);
		OK(ENC_BL_ONLY_BRANCH_IMM);
	}
	return rc;
}

/* blr.xml */
int BLR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* 1101011|Z=0|opc[2:1]=0|op=01|op2=11111|op3[5:2]=0000|A=0|M=0|Rn=xxxxx|Rm=00000 */
	if((INSWORD & 0xFFFFFC1F)==0xD63F0000) {
		decode_fields32(ENC_BLR_64_BRANCH_REG, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->pac = (ctx->A==1);
		ctx->use_key_a = (ctx->M==0);
		ctx->source_is_sp = ((ctx->Z==1) && (ctx->m==0x1f));
		if(!ctx->pac && ctx->m!=0) {
			UNDEFINED;
		}
		else if(ctx->pac && !HavePACExt()) {
			UNDEFINED;
		}
		if(!ctx->op) {
			ctx->branch_type = BranchType_INDIR;
		}
		else if(ctx->op==1) {
			ctx->branch_type = BranchType_INDCALL;
		}
		else if(ctx->op==2) {
			ctx->branch_type = BranchType_RET;
		}
		else {
			UNDEFINED;
		}
		if(ctx->pac) {
			if(ctx->Z==0 && ctx->m!=0x1f) {
				UNDEFINED;
			}
			if(ctx->branch_type==BranchType_RET) {
				if(ctx->n!=0x1f) {
					UNDEFINED;
				}
				ctx->n = 0x1e;
				ctx->source_is_sp = TRUE;
			}
		}
		OK(ENC_BLR_64_BRANCH_REG);
	}
	return rc;
}

/* blra.xml */
int BLRA(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* 1101011|Z=x|opc[2:1]=0|op=01|op2=11111|op3[5:2]=0000|A=1|M=x|Rn=xxxxx|Rm=xxxxx */
	if((INSWORD & 0xFEFFF800)==0xD63F0800) {
		decode_fields32(ENC_BLRAAZ_64_BRANCH_REG, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->pac = (ctx->A==1);
		ctx->use_key_a = (ctx->M==0);
		ctx->source_is_sp = ((ctx->Z==1) && (ctx->m==0x1f));
		if(!ctx->pac && ctx->m!=0) {
			UNDEFINED;
		}
		else if(ctx->pac && !HavePACExt()) {
			UNDEFINED;
		}
		if(!ctx->op) {
			ctx->branch_type = BranchType_INDIR;
		}
		else if(ctx->op==1) {
			ctx->branch_type = BranchType_INDCALL;
		}
		else if(ctx->op==2) {
			ctx->branch_type = BranchType_RET;
		}
		else {
			UNDEFINED;
		}
		if(ctx->pac) {
			if(ctx->Z==0 && ctx->m!=0x1f) {
				UNDEFINED;
			}
			if(ctx->branch_type==BranchType_RET) {
				if(ctx->n!=0x1f) {
					UNDEFINED;
				}
				ctx->n = 0x1e;
				ctx->source_is_sp = TRUE;
			}
		}
		if(ctx->Z==0 && ctx->M==0 && ctx->Rm==0x1f) OK(ENC_BLRAAZ_64_BRANCH_REG);
		if(ctx->Z==1 && ctx->M==0) OK(ENC_BLRAA_64P_BRANCH_REG);
		if(ctx->Z==0 && ctx->M==1 && ctx->Rm==0x1f) OK(ENC_BLRABZ_64_BRANCH_REG);
		if(ctx->Z==1 && ctx->M==1) OK(ENC_BLRAB_64P_BRANCH_REG);
	}
	return rc;
}

/* br.xml */
int BR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* 1101011|Z=0|opc[2:1]=0|op=00|op2=11111|op3[5:2]=0000|A=0|M=0|Rn=xxxxx|Rm=00000 */
	if((INSWORD & 0xFFFFFC1F)==0xD61F0000) {
		decode_fields32(ENC_BR_64_BRANCH_REG, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->pac = (ctx->A==1);
		ctx->use_key_a = (ctx->M==0);
		ctx->source_is_sp = ((ctx->Z==1) && (ctx->m==0x1f));
		if(!ctx->pac && ctx->m!=0) {
			UNDEFINED;
		}
		else if(ctx->pac && !HavePACExt()) {
			UNDEFINED;
		}
		if(!ctx->op) {
			ctx->branch_type = BranchType_INDIR;
		}
		else if(ctx->op==1) {
			ctx->branch_type = BranchType_INDCALL;
		}
		else if(ctx->op==2) {
			ctx->branch_type = BranchType_RET;
		}
		else {
			UNDEFINED;
		}
		if(ctx->pac) {
			if(ctx->Z==0 && ctx->m!=0x1f) {
				UNDEFINED;
			}
			if(ctx->branch_type==BranchType_RET) {
				if(ctx->n!=0x1f) {
					UNDEFINED;
				}
				ctx->n = 0x1e;
				ctx->source_is_sp = TRUE;
			}
		}
		OK(ENC_BR_64_BRANCH_REG);
	}
	return rc;
}

/* bra.xml */
int BRA(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* 1101011|Z=x|opc[2:1]=0|op=00|op2=11111|op3[5:2]=0000|A=1|M=x|Rn=xxxxx|Rm=xxxxx */
	if((INSWORD & 0xFEFFF800)==0xD61F0800) {
		decode_fields32(ENC_BRAAZ_64_BRANCH_REG, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->pac = (ctx->A==1);
		ctx->use_key_a = (ctx->M==0);
		ctx->source_is_sp = ((ctx->Z==1) && (ctx->m==0x1f));
		if(!ctx->pac && ctx->m!=0) {
			UNDEFINED;
		}
		else if(ctx->pac && !HavePACExt()) {
			UNDEFINED;
		}
		if(!ctx->op) {
			ctx->branch_type = BranchType_INDIR;
		}
		else if(ctx->op==1) {
			ctx->branch_type = BranchType_INDCALL;
		}
		else if(ctx->op==2) {
			ctx->branch_type = BranchType_RET;
		}
		else {
			UNDEFINED;
		}
		if(ctx->pac) {
			if(ctx->Z==0 && ctx->m!=0x1f) {
				UNDEFINED;
			}
			if(ctx->branch_type==BranchType_RET) {
				if(ctx->n!=0x1f) {
					UNDEFINED;
				}
				ctx->n = 0x1e;
				ctx->source_is_sp = TRUE;
			}
		}
		if(ctx->Z==0 && ctx->M==0 && ctx->Rm==0x1f) OK(ENC_BRAAZ_64_BRANCH_REG);
		if(ctx->Z==1 && ctx->M==0) OK(ENC_BRAA_64P_BRANCH_REG);
		if(ctx->Z==0 && ctx->M==1 && ctx->Rm==0x1f) OK(ENC_BRABZ_64_BRANCH_REG);
		if(ctx->Z==1 && ctx->M==1) OK(ENC_BRAB_64P_BRANCH_REG);
	}
	return rc;
}

/* brk.xml */
int BRK(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 11010100|opc=001|imm16=xxxxxxxxxxxxxxxx|op2=000|LL=00 */
	if((INSWORD & 0xFFE0001F)==0xD4200000) {
		decode_fields32(ENC_BRK_EX_EXCEPTION, ctx, instr);
		ctx->comment = ctx->imm16;
		if(HaveBTIExt()) {
			SetBTypeCompatible(TRUE);
		}
		OK(ENC_BRK_EX_EXCEPTION);
	}
	return rc;
}

/* bsl_advsimd.xml */
int BSL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=1|01110|opc2=01|1|Rm=xxxxx|opcode=00011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2E601C00) {
		decode_fields32(ENC_BSL_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 8;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!ctx->opc2) {
			ctx->op = VBitOp_VEOR;
		}
		else if(ctx->opc2==1) {
			ctx->op = VBitOp_VBSL;
		}
		else if(ctx->opc2==2) {
			ctx->op = VBitOp_VBIT;
		}
		else if(ctx->opc2==3) {
			ctx->op = VBitOp_VBIF;
		}
		OK(ENC_BSL_ASIMDSAME_ONLY);
	}
	return rc;
}

/* bti.xml */
int BTI(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=0100|op2=xx0|Rt=11111 */
	if((INSWORD & 0xFFFFFF3F)==0xD503241F) {
		decode_fields32(ENC_BTI_HB_HINTS, ctx, instr);
		if(!((ctx->CRm<<3)|ctx->op2)) {
			ctx->op = SystemHintOp_NOP;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==1) {
			ctx->op = SystemHintOp_YIELD;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==2) {
			ctx->op = SystemHintOp_WFE;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==3) {
			ctx->op = SystemHintOp_WFI;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==4) {
			ctx->op = SystemHintOp_SEV;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==5) {
			ctx->op = SystemHintOp_SEVL;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==6) {
			if(!HaveDGHExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_DGH;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==7) {
			SEE /* XPACLRI */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==8) {
			if(!ctx->op2) {
				SEE /* PACIA1716 */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIB1716 */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIA1716 */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIB1716 */;
			}
			else {
				ENDOFINSTRUCTION;
			}
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x10) {
			if(!HaveRASExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_ESB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x11) {
			if(!HaveStatisticalProfiling()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_PSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x12) {
			if(!HaveSelfHostedTrace()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_TSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x14) {
			ctx->op = SystemHintOp_CSDB;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==0x18) {
			if(!ctx->op2) {
				SEE /* PACIAZ */;
			}
			else if(ctx->op2==1) {
				SEE /* PACIASP */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIBZ */;
			}
			else if(ctx->op2==3) {
				SEE /* PACIBSP */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIAZ */;
			}
			else if(ctx->op2==5) {
				SEE /* AUTHASP */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIBZ */;
			}
			else if(ctx->op2==7) {
				SEE /* AUTIBSP */;
			}
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x79)==0x20) {
			ctx->op = SystemHintOp_BTI;
			SetBTypeCompatible(BTypeCompatible_BTI(SLICE(ctx->op2,2,1), ctx->pstate_btype));
		}
		else {
			ENDOFINSTRUCTION;
		}
		OK(ENC_BTI_HB_HINTS);
	}
	return rc;
}

/* b_cond.xml */
int B_cond(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_br19 */
	/* 0101010|o1=0|imm19=xxxxxxxxxxxxxxxxxxx|o0=0|cond=xxxx */
	if((INSWORD & 0xFF000010)==0x54000000) {
		decode_fields32(ENC_B_ONLY_CONDBRANCH, ctx, instr);
		ctx->offset = SignExtend((ctx->imm19<<2),21);
		ctx->condition = ctx->cond;
		OK(ENC_B_ONLY_CONDBRANCH);
	}
	return rc;
}

/* b_uncond.xml */
int B_uncond(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_br26 */
	/* op=0|00101|imm26=xxxxxxxxxxxxxxxxxxxxxxxxxx */
	if((INSWORD & 0xFC000000)==0x14000000) {
		decode_fields32(ENC_B_ONLY_BRANCH_IMM, ctx, instr);
		ctx->branch_type = (ctx->op==1) ? BranchType_DIRCALL : BranchType_DIR;
		ctx->offset = SignExtend((ctx->imm26<<2),28);
		OK(ENC_B_ONLY_BRANCH_IMM);
	}
	return rc;
}

/* cas.xml */
int CAS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=1x|0010001|L=x|1|Rs=xxxxx|o0=x|Rt2=11111|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFA07C00)==0x88A07C00) {
		decode_fields32(ENC_CAS_C32_COMSWAP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->L==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->o0==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->tag_checked = ctx->n!=0x1f;
		if(ctx->size==2 && ctx->L==0 && ctx->o0==0) OK(ENC_CAS_C32_COMSWAP);
		if(ctx->size==2 && ctx->L==1 && ctx->o0==0) OK(ENC_CASA_C32_COMSWAP);
		if(ctx->size==2 && ctx->L==1 && ctx->o0==1) OK(ENC_CASAL_C32_COMSWAP);
		if(ctx->size==2 && ctx->L==0 && ctx->o0==1) OK(ENC_CASL_C32_COMSWAP);
		if(ctx->size==3 && ctx->L==0 && ctx->o0==0) OK(ENC_CAS_C64_COMSWAP);
		if(ctx->size==3 && ctx->L==1 && ctx->o0==0) OK(ENC_CASA_C64_COMSWAP);
		if(ctx->size==3 && ctx->L==1 && ctx->o0==1) OK(ENC_CASAL_C64_COMSWAP);
		if(ctx->size==3 && ctx->L==0 && ctx->o0==1) OK(ENC_CASL_C64_COMSWAP);
	}
	return rc;
}

/* casb.xml */
int CASB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=00|0010001|L=x|1|Rs=xxxxx|o0=x|Rt2=11111|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFA07C00)==0x8A07C00) {
		decode_fields32(ENC_CASAB_C32_COMSWAP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->L==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->o0==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->tag_checked = ctx->n!=0x1f;
		if(ctx->L==1 && ctx->o0==0) OK(ENC_CASAB_C32_COMSWAP);
		if(ctx->L==1 && ctx->o0==1) OK(ENC_CASALB_C32_COMSWAP);
		if(ctx->L==0 && ctx->o0==0) OK(ENC_CASB_C32_COMSWAP);
		if(ctx->L==0 && ctx->o0==1) OK(ENC_CASLB_C32_COMSWAP);
	}
	return rc;
}

/* cash.xml */
int CASH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=01|0010001|L=x|1|Rs=xxxxx|o0=x|Rt2=11111|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFA07C00)==0x48A07C00) {
		decode_fields32(ENC_CASAH_C32_COMSWAP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->L==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->o0==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->tag_checked = ctx->n!=0x1f;
		if(ctx->L==1 && ctx->o0==0) OK(ENC_CASAH_C32_COMSWAP);
		if(ctx->L==1 && ctx->o0==1) OK(ENC_CASALH_C32_COMSWAP);
		if(ctx->L==0 && ctx->o0==0) OK(ENC_CASH_C32_COMSWAP);
		if(ctx->L==0 && ctx->o0==1) OK(ENC_CASLH_C32_COMSWAP);
	}
	return rc;
}

/* casp.xml */
int CASP(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* 0|sz=x|001000|o2=0|L=x|o1=1|Rs=xxxxx|o0=x|Rt2=11111|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFA07C00)==0x8207C00) {
		decode_fields32(ENC_CASP_CP32_COMSWAPPR, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		if(SLICE(ctx->Rs,0,0)==1) {
			UNDEFINED;
		}
		if(SLICE(ctx->Rt,0,0)==1) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (0x20) << (UINT(ctx->sz));
		ctx->regsize = ctx->datasize;
		ctx->ldacctype = (ctx->L==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->o0==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->tag_checked = ctx->n!=0x1f;
		if(ctx->sz==0 && ctx->L==0 && ctx->o0==0) OK(ENC_CASP_CP32_COMSWAPPR);
		if(ctx->sz==0 && ctx->L==1 && ctx->o0==0) OK(ENC_CASPA_CP32_COMSWAPPR);
		if(ctx->sz==0 && ctx->L==1 && ctx->o0==1) OK(ENC_CASPAL_CP32_COMSWAPPR);
		if(ctx->sz==0 && ctx->L==0 && ctx->o0==1) OK(ENC_CASPL_CP32_COMSWAPPR);
		if(ctx->sz==1 && ctx->L==0 && ctx->o0==0) OK(ENC_CASP_CP64_COMSWAPPR);
		if(ctx->sz==1 && ctx->L==1 && ctx->o0==0) OK(ENC_CASPA_CP64_COMSWAPPR);
		if(ctx->sz==1 && ctx->L==1 && ctx->o0==1) OK(ENC_CASPAL_CP64_COMSWAPPR);
		if(ctx->sz==1 && ctx->L==0 && ctx->o0==1) OK(ENC_CASPL_CP64_COMSWAPPR);
	}
	return rc;
}

/* cbnz.xml */
int CBNZ(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_br19 */
	/* sf=x|011010|op=1|imm19=xxxxxxxxxxxxxxxxxxx|Rt=xxxxx */
	if((INSWORD & 0x7F000000)==0x35000000) {
		decode_fields32(ENC_CBNZ_32_COMPBRANCH, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->iszero = (ctx->op==0);
		ctx->offset = SignExtend((ctx->imm19<<2),21);
		if(ctx->sf==0) OK(ENC_CBNZ_32_COMPBRANCH);
		if(ctx->sf==1) OK(ENC_CBNZ_64_COMPBRANCH);
	}
	return rc;
}

/* cbz.xml */
int CBZ(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_br19 */
	/* sf=x|011010|op=0|imm19=xxxxxxxxxxxxxxxxxxx|Rt=xxxxx */
	if((INSWORD & 0x7F000000)==0x34000000) {
		decode_fields32(ENC_CBZ_32_COMPBRANCH, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->iszero = (ctx->op==0);
		ctx->offset = SignExtend((ctx->imm19<<2),21);
		if(ctx->sf==0) OK(ENC_CBZ_32_COMPBRANCH);
		if(ctx->sf==1) OK(ENC_CBZ_64_COMPBRANCH);
	}
	return rc;
}

/* ccmn_imm.xml */
int CCMN_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_imm5u */
	/* sf=x|op=0|S=1|11010010|imm5=xxxxx|cond=xxxx|1|o2=0|Rn=xxxxx|o3=0|nzcv=xxxx */
	if((INSWORD & 0x7FE00C10)==0x3A400800) {
		decode_fields32(ENC_CCMN_32_CONDCMP_IMM, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		ctx->condition = ctx->cond;
		ctx->flags = ctx->nzcv;
		ctx->imm = ZeroExtend(ctx->imm5,ctx->datasize);
		if(ctx->sf==0) OK(ENC_CCMN_32_CONDCMP_IMM);
		if(ctx->sf==1) OK(ENC_CCMN_64_CONDCMP_IMM);
	}
	return rc;
}

/* ccmn_reg.xml */
int CCMN_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=0|S=1|11010010|Rm=xxxxx|cond=xxxx|0|o2=0|Rn=xxxxx|o3=0|nzcv=xxxx */
	if((INSWORD & 0x7FE00C10)==0x3A400000) {
		decode_fields32(ENC_CCMN_32_CONDCMP_REG, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		ctx->condition = ctx->cond;
		ctx->flags = ctx->nzcv;
		if(ctx->sf==0) OK(ENC_CCMN_32_CONDCMP_REG);
		if(ctx->sf==1) OK(ENC_CCMN_64_CONDCMP_REG);
	}
	return rc;
}

/* ccmp_imm.xml */
int CCMP_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_imm5u */
	/* sf=x|op=1|S=1|11010010|imm5=xxxxx|cond=xxxx|1|o2=0|Rn=xxxxx|o3=0|nzcv=xxxx */
	if((INSWORD & 0x7FE00C10)==0x7A400800) {
		decode_fields32(ENC_CCMP_32_CONDCMP_IMM, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		ctx->condition = ctx->cond;
		ctx->flags = ctx->nzcv;
		ctx->imm = ZeroExtend(ctx->imm5,ctx->datasize);
		if(ctx->sf==0) OK(ENC_CCMP_32_CONDCMP_IMM);
		if(ctx->sf==1) OK(ENC_CCMP_64_CONDCMP_IMM);
	}
	return rc;
}

/* ccmp_reg.xml */
int CCMP_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=1|S=1|11010010|Rm=xxxxx|cond=xxxx|0|o2=0|Rn=xxxxx|o3=0|nzcv=xxxx */
	if((INSWORD & 0x7FE00C10)==0x7A400000) {
		decode_fields32(ENC_CCMP_32_CONDCMP_REG, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		ctx->condition = ctx->cond;
		ctx->flags = ctx->nzcv;
		if(ctx->sf==0) OK(ENC_CCMP_32_CONDCMP_REG);
		if(ctx->sf==1) OK(ENC_CCMP_64_CONDCMP_REG);
	}
	return rc;
}

/* cfinv.xml */
int CFINV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=000|CRn=0100|CRm=(0)(0)(0)(0)|op2=000|Rt =11111 */
	if((INSWORD & 0xFFFFF0FF)==0xD500401F) {
		decode_fields32(ENC_CFINV_M_PSTATE, ctx, instr);
		if(!HaveFlagManipulateExt()) {
			UNDEFINED;
		}
		OK(ENC_CFINV_M_PSTATE);
	}
	return rc;
}

/* cfp_sys.xml */
int CFP_SYS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=01|op1=011|CRn=0111|CRm=0011|op2=100|Rt=xxxxx */
	if((INSWORD & 0xFFFFFFE0)==0xD50B7380) {
		decode_fields32(ENC_CFP_SYS_CR_SYSTEMINSTRS, ctx, instr);
		OK(ENC_CFP_SYS_CR_SYSTEMINSTRS);
	}
	return rc;
}

/* cinc_csinc.xml */
int CINC_CSINC(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=0|S=0|11010100|Rm!=11111|cond!=111x|0|o2=1|Rn!=11111|Rd=xxxxx */
	if((INSWORD & 0x7FE00C00)==0x1A800400 && (INSWORD & 0x1FE3E0)!=0x1FE3E0) {
		decode_fields32(ENC_CINC_CSINC_32_CONDSEL, ctx, instr);
		if(ctx->sf==0) OK(ENC_CINC_CSINC_32_CONDSEL);
		if(ctx->sf==1) OK(ENC_CINC_CSINC_64_CONDSEL);
	}
	return rc;
}

/* cinv_csinv.xml */
int CINV_CSINV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=1|S=0|11010100|Rm!=11111|cond!=111x|0|o2=0|Rn!=11111|Rd=xxxxx */
	if((INSWORD & 0x7FE00C00)==0x5A800000 && (INSWORD & 0x1FE3E0)!=0x1FE3E0) {
		decode_fields32(ENC_CINV_CSINV_32_CONDSEL, ctx, instr);
		if(ctx->sf==0) OK(ENC_CINV_CSINV_32_CONDSEL);
		if(ctx->sf==1) OK(ENC_CINV_CSINV_64_CONDSEL);
	}
	return rc;
}

/* clrex.xml */
int CLREX(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0011|CRm=xxxx|op2=010|Rt=11111 */
	if((INSWORD & 0xFFFFF0FF)==0xD503305F) {
		decode_fields32(ENC_CLREX_BN_BARRIERS, ctx, instr);
		OK(ENC_CLREX_BN_BARRIERS);
	}
	return rc;
}

/* cls_advsimd.xml */
int CLS_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|10000|opcode=00100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE204800) {
		decode_fields32(ENC_CLS_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->countop = (ctx->U==1) ? CountOp_CLZ : CountOp_CLS;
		OK(ENC_CLS_ASIMDMISC_R);
	}
	return rc;
}

/* cls_int.xml */
int CLS_int(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|1|S=0|11010110|opcode2=00000|opcode[5:1]=00010|op=1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FFFFC00)==0x5AC01400) {
		decode_fields32(ENC_CLS_32_DP_1SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->opcode = (ctx->op==0) ? CountOp_CLZ : CountOp_CLS;
		if(ctx->sf==0) OK(ENC_CLS_32_DP_1SRC);
		if(ctx->sf==1) OK(ENC_CLS_64_DP_1SRC);
	}
	return rc;
}

/* clz_advsimd.xml */
int CLZ_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|10000|opcode=00100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0x2E204800) {
		decode_fields32(ENC_CLZ_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->countop = (ctx->U==1) ? CountOp_CLZ : CountOp_CLS;
		OK(ENC_CLZ_ASIMDMISC_R);
	}
	return rc;
}

/* clz_int.xml */
int CLZ_int(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|1|S=0|11010110|opcode2=00000|opcode[5:1]=00010|op=0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FFFFC00)==0x5AC01000) {
		decode_fields32(ENC_CLZ_32_DP_1SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->opcode = (ctx->op==0) ? CountOp_CLZ : CountOp_CLS;
		if(ctx->sf==0) OK(ENC_CLZ_32_DP_1SRC);
		if(ctx->sf==1) OK(ENC_CLZ_64_DP_1SRC);
	}
	return rc;
}

/* cmeq_advsimd_reg.xml */
int CMEQ_advsimd_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|1|Rm=xxxxx|opcode=10001|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x7E208C00) {
		decode_fields32(ENC_CMEQ_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size!=3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->and_test = (ctx->U==0);
		OK(ENC_CMEQ_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|opcode=10001|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E208C00) {
		decode_fields32(ENC_CMEQ_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->and_test = (ctx->U==0);
		OK(ENC_CMEQ_ASIMDSAME_ONLY);
	}
	return rc;
}

/* cmeq_advsimd_zero.xml */
int CMEQ_advsimd_zero(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|10000|0100|op=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x5E209800) {
		decode_fields32(ENC_CMEQ_ASISDMISC_Z, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size!=3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_CMEQ_ASISDMISC_Z);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|10000|0100|op=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE209800) {
		decode_fields32(ENC_CMEQ_ASIMDMISC_Z, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_CMEQ_ASIMDMISC_Z);
	}
	return rc;
}

/* cmge_advsimd_reg.xml */
int CMGE_advsimd_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|1|Rm=xxxxx|0011|eq=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x5E203C00) {
		decode_fields32(ENC_CMGE_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size!=3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		ctx->cmp_eq = (ctx->eq==1);
		OK(ENC_CMGE_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|0011|eq=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE203C00) {
		decode_fields32(ENC_CMGE_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->cmp_eq = (ctx->eq==1);
		OK(ENC_CMGE_ASIMDSAME_ONLY);
	}
	return rc;
}

/* cmge_advsimd_zero.xml */
int CMGE_advsimd_zero(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|10000|0100|op=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x7E208800) {
		decode_fields32(ENC_CMGE_ASISDMISC_Z, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size!=3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_CMGE_ASISDMISC_Z);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|10000|0100|op=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0x2E208800) {
		decode_fields32(ENC_CMGE_ASIMDMISC_Z, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_CMGE_ASIMDMISC_Z);
	}
	return rc;
}

/* cmgt_advsimd_reg.xml */
int CMGT_advsimd_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|1|Rm=xxxxx|0011|eq=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x5E203400) {
		decode_fields32(ENC_CMGT_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size!=3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		ctx->cmp_eq = (ctx->eq==1);
		OK(ENC_CMGT_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|0011|eq=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE203400) {
		decode_fields32(ENC_CMGT_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->cmp_eq = (ctx->eq==1);
		OK(ENC_CMGT_ASIMDSAME_ONLY);
	}
	return rc;
}

/* cmgt_advsimd_zero.xml */
int CMGT_advsimd_zero(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|10000|0100|op=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x5E208800) {
		decode_fields32(ENC_CMGT_ASISDMISC_Z, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size!=3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_CMGT_ASISDMISC_Z);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|10000|0100|op=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE208800) {
		decode_fields32(ENC_CMGT_ASIMDMISC_Z, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_CMGT_ASIMDMISC_Z);
	}
	return rc;
}

/* cmhi_advsimd.xml */
int CMHI_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|1|Rm=xxxxx|0011|eq=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x7E203400) {
		decode_fields32(ENC_CMHI_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size!=3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		ctx->cmp_eq = (ctx->eq==1);
		OK(ENC_CMHI_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|0011|eq=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E203400) {
		decode_fields32(ENC_CMHI_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->cmp_eq = (ctx->eq==1);
		OK(ENC_CMHI_ASIMDSAME_ONLY);
	}
	return rc;
}

/* cmhs_advsimd.xml */
int CMHS_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|1|Rm=xxxxx|0011|eq=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x7E203C00) {
		decode_fields32(ENC_CMHS_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size!=3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		ctx->cmp_eq = (ctx->eq==1);
		OK(ENC_CMHS_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|0011|eq=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E203C00) {
		decode_fields32(ENC_CMHS_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->cmp_eq = (ctx->eq==1);
		OK(ENC_CMHS_ASIMDSAME_ONLY);
	}
	return rc;
}

/* cmle_advsimd.xml */
int CMLE_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|10000|0100|op=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x7E209800) {
		decode_fields32(ENC_CMLE_ASISDMISC_Z, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size!=3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_CMLE_ASISDMISC_Z);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|10000|0100|op=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0x2E209800) {
		decode_fields32(ENC_CMLE_ASIMDMISC_Z, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_CMLE_ASIMDMISC_Z);
	}
	return rc;
}

/* cmlt_advsimd.xml */
int CMLT_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|10000|opcode=01010|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x5E20A800) {
		decode_fields32(ENC_CMLT_ASISDMISC_Z, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size!=3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->comparison = CompareOp_LT;
		OK(ENC_CMLT_ASISDMISC_Z);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|10000|opcode=01010|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE20A800) {
		decode_fields32(ENC_CMLT_ASIMDMISC_Z, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->comparison = CompareOp_LT;
		OK(ENC_CMLT_ASIMDMISC_Z);
	}
	return rc;
}

/* cmn_adds_addsub_ext.xml */
int CMN_ADDS_addsub_ext(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|op=0|S=1|01011|opt=00|1|Rm=xxxxx|option=xxx|imm3=xxx|Rn=xxxxx|Rd=11111 */
	if((INSWORD & 0x7FE0001F)==0x2B20001F) {
		decode_fields32(ENC_CMN_ADDS_32S_ADDSUB_EXT, ctx, instr);
		if(ctx->sf==0) OK(ENC_CMN_ADDS_32S_ADDSUB_EXT);
		if(ctx->sf==1) OK(ENC_CMN_ADDS_64S_ADDSUB_EXT);
	}
	return rc;
}

/* cmn_adds_addsub_imm.xml */
int CMN_ADDS_addsub_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|op=0|S=1|100010|sh=x|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rd=11111 */
	if((INSWORD & 0x7F80001F)==0x3100001F) {
		decode_fields32(ENC_CMN_ADDS_32S_ADDSUB_IMM, ctx, instr);
		if(ctx->sf==0) OK(ENC_CMN_ADDS_32S_ADDSUB_IMM);
		if(ctx->sf==1) OK(ENC_CMN_ADDS_64S_ADDSUB_IMM);
	}
	return rc;
}

/* cmn_adds_addsub_shift.xml */
int CMN_ADDS_addsub_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|op=0|S=1|01011|shift=xx|0|Rm=xxxxx|imm6=xxxxxx|Rn=xxxxx|Rd=11111 */
	if((INSWORD & 0x7F20001F)==0x2B00001F) {
		decode_fields32(ENC_CMN_ADDS_32_ADDSUB_SHIFT, ctx, instr);
		if(ctx->sf==0) OK(ENC_CMN_ADDS_32_ADDSUB_SHIFT);
		if(ctx->sf==1) OK(ENC_CMN_ADDS_64_ADDSUB_SHIFT);
	}
	return rc;
}

/* cmple_cmpeq_p_p_zz.xml */
int CMPLE_cmpeq_p_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_ge */
	/* 00100100|size=xx|0|Zm=xxxxx|op=1|0|o2=0|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x24008000) {
		decode_fields32(ENC_CMPLE_CMPGE_P_P_ZZ_, ctx, instr);
		OK(ENC_CMPLE_CMPGE_P_P_ZZ_);
	}
	return rc;
}

/* cmplo_cmpeq_p_p_zz.xml */
int CMPLO_cmpeq_p_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_hi */
	/* 00100100|size=xx|0|Zm=xxxxx|op=0|0|o2=0|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x24000010) {
		decode_fields32(ENC_CMPLO_CMPHI_P_P_ZZ_, ctx, instr);
		OK(ENC_CMPLO_CMPHI_P_P_ZZ_);
	}
	return rc;
}

/* cmpls_cmpeq_p_p_zz.xml */
int CMPLS_cmpeq_p_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_hs */
	/* 00100100|size=xx|0|Zm=xxxxx|op=0|0|o2=0|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x24000000) {
		decode_fields32(ENC_CMPLS_CMPHS_P_P_ZZ_, ctx, instr);
		OK(ENC_CMPLS_CMPHS_P_P_ZZ_);
	}
	return rc;
}

/* cmplt_cmpeq_p_p_zz.xml */
int CMPLT_cmpeq_p_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_gt */
	/* 00100100|size=xx|0|Zm=xxxxx|op=1|0|o2=0|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x24008010) {
		decode_fields32(ENC_CMPLT_CMPGT_P_P_ZZ_, ctx, instr);
		OK(ENC_CMPLT_CMPGT_P_P_ZZ_);
	}
	return rc;
}

/* cmpp_subps.xml */
int CMPP_SUBPS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|0|S=1|11010110|Xm=xxxxx|opcode=000000|Xn=xxxxx|Xd=11111 */
	if((INSWORD & 0xFFE0FC1F)==0xBAC0001F) {
		decode_fields32(ENC_CMPP_SUBPS_64S_DP_2SRC, ctx, instr);
		OK(ENC_CMPP_SUBPS_64S_DP_2SRC);
	}
	return rc;
}

/* cmp_subs_addsub_ext.xml */
int CMP_SUBS_addsub_ext(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|op=1|S=1|01011|opt=00|1|Rm=xxxxx|option=xxx|imm3=xxx|Rn=xxxxx|Rd=11111 */
	if((INSWORD & 0x7FE0001F)==0x6B20001F) {
		decode_fields32(ENC_CMP_SUBS_32S_ADDSUB_EXT, ctx, instr);
		if(ctx->sf==0) OK(ENC_CMP_SUBS_32S_ADDSUB_EXT);
		if(ctx->sf==1) OK(ENC_CMP_SUBS_64S_ADDSUB_EXT);
	}
	return rc;
}

/* cmp_subs_addsub_imm.xml */
int CMP_SUBS_addsub_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|op=1|S=1|100010|sh=x|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rd=11111 */
	if((INSWORD & 0x7F80001F)==0x7100001F) {
		decode_fields32(ENC_CMP_SUBS_32S_ADDSUB_IMM, ctx, instr);
		if(ctx->sf==0) OK(ENC_CMP_SUBS_32S_ADDSUB_IMM);
		if(ctx->sf==1) OK(ENC_CMP_SUBS_64S_ADDSUB_IMM);
	}
	return rc;
}

/* cmp_subs_addsub_shift.xml */
int CMP_SUBS_addsub_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|op=1|S=1|01011|shift=xx|0|Rm=xxxxx|imm6=xxxxxx|Rn=xxxxx|Rd=11111 */
	if((INSWORD & 0x7F20001F)==0x6B00001F) {
		decode_fields32(ENC_CMP_SUBS_32_ADDSUB_SHIFT, ctx, instr);
		if(ctx->sf==0) OK(ENC_CMP_SUBS_32_ADDSUB_SHIFT);
		if(ctx->sf==1) OK(ENC_CMP_SUBS_64_ADDSUB_SHIFT);
	}
	return rc;
}

/* cmtst_advsimd.xml */
int CMTST_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|1|Rm=xxxxx|opcode=10001|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x5E208C00) {
		decode_fields32(ENC_CMTST_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size!=3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->and_test = (ctx->U==0);
		OK(ENC_CMTST_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|opcode=10001|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE208C00) {
		decode_fields32(ENC_CMTST_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->and_test = (ctx->U==0);
		OK(ENC_CMTST_ASIMDSAME_ONLY);
	}
	return rc;
}

/* cneg_csneg.xml */
int CNEG_CSNEG(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=1|S=0|11010100|Rm=xxxxx|cond!=111x|0|o2=1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE00C00)==0x5A800400 && (INSWORD & 0xE000)!=0xE000) {
		decode_fields32(ENC_CNEG_CSNEG_32_CONDSEL, ctx, instr);
		if(ctx->sf==0) OK(ENC_CNEG_CSNEG_32_CONDSEL);
		if(ctx->sf==1) OK(ENC_CNEG_CSNEG_64_CONDSEL);
	}
	return rc;
}

/* cnt_advsimd.xml */
int CNT_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|10000|opcode=00101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE205800) {
		decode_fields32(ENC_CNT_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size!=0) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((8) ? ((ctx->datasize) / (8)) : 0);
		OK(ENC_CNT_ASIMDMISC_R);
	}
	return rc;
}

/* cpp_sys.xml */
int CPP_SYS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=01|op1=011|CRn=0111|CRm=0011|op2=111|Rt=xxxxx */
	if((INSWORD & 0xFFFFFFE0)==0xD50B73E0) {
		decode_fields32(ENC_CPP_SYS_CR_SYSTEMINSTRS, ctx, instr);
		OK(ENC_CPP_SYS_CR_SYSTEMINSTRS);
	}
	return rc;
}

/* crc32.xml */
int CRC32(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_crc */
	/* sf=x|op=0|S=0|11010110|Rm=xxxxx|opcode2<5:3>=010|C=0|sz=xx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0F000)==0x1AC04000) {
		decode_fields32(ENC_CRC32B_32C_DP_2SRC, ctx, instr);
		if(!HaveCRCExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->sf==1 && ctx->sz!=3) {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->sz==3) {
			UNDEFINED;
		}
		ctx->size = (8) << (UINT(ctx->sz));
		ctx->crc32c = (ctx->C==1);
		if(ctx->sf==0 && ctx->sz==0) OK(ENC_CRC32B_32C_DP_2SRC);
		if(ctx->sf==0 && ctx->sz==1) OK(ENC_CRC32H_32C_DP_2SRC);
		if(ctx->sf==0 && ctx->sz==2) OK(ENC_CRC32W_32C_DP_2SRC);
		if(ctx->sf==1 && ctx->sz==3) OK(ENC_CRC32X_64C_DP_2SRC);
	}
	return rc;
}

/* crc32c.xml */
int CRC32C(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_crc */
	/* sf=x|op=0|S=0|11010110|Rm=xxxxx|opcode2<5:3>=010|C=1|sz=xx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0F000)==0x1AC05000) {
		decode_fields32(ENC_CRC32CB_32C_DP_2SRC, ctx, instr);
		if(!HaveCRCExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->sf==1 && ctx->sz!=3) {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->sz==3) {
			UNDEFINED;
		}
		ctx->size = (8) << (UINT(ctx->sz));
		ctx->crc32c = (ctx->C==1);
		if(ctx->sf==0 && ctx->sz==0) OK(ENC_CRC32CB_32C_DP_2SRC);
		if(ctx->sf==0 && ctx->sz==1) OK(ENC_CRC32CH_32C_DP_2SRC);
		if(ctx->sf==0 && ctx->sz==2) OK(ENC_CRC32CW_32C_DP_2SRC);
		if(ctx->sf==1 && ctx->sz==3) OK(ENC_CRC32CX_64C_DP_2SRC);
	}
	return rc;
}

/* csdb.xml */
int CSDB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=0010|op2=100|Rt=11111 */
	if((INSWORD & 0xFFFFFFFF)==0xD503229F) {
		decode_fields32(ENC_CSDB_HI_HINTS, ctx, instr);
		if(!((ctx->CRm<<3)|ctx->op2)) {
			ctx->op = SystemHintOp_NOP;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==1) {
			ctx->op = SystemHintOp_YIELD;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==2) {
			ctx->op = SystemHintOp_WFE;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==3) {
			ctx->op = SystemHintOp_WFI;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==4) {
			ctx->op = SystemHintOp_SEV;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==5) {
			ctx->op = SystemHintOp_SEVL;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==6) {
			if(!HaveDGHExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_DGH;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==7) {
			SEE /* XPACLRI */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==8) {
			if(!ctx->op2) {
				SEE /* PACIA1716 */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIB1716 */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIA1716 */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIB1716 */;
			}
			else {
				ENDOFINSTRUCTION;
			}
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x10) {
			if(!HaveRASExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_ESB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x11) {
			if(!HaveStatisticalProfiling()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_PSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x12) {
			if(!HaveSelfHostedTrace()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_TSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x14) {
			ctx->op = SystemHintOp_CSDB;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==0x18) {
			if(!ctx->op2) {
				SEE /* PACIAZ */;
			}
			else if(ctx->op2==1) {
				SEE /* PACIASP */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIBZ */;
			}
			else if(ctx->op2==3) {
				SEE /* PACIBSP */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIAZ */;
			}
			else if(ctx->op2==5) {
				SEE /* AUTHASP */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIBZ */;
			}
			else if(ctx->op2==7) {
				SEE /* AUTIBSP */;
			}
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x79)==0x20) {
			ctx->op = SystemHintOp_BTI;
			SetBTypeCompatible(BTypeCompatible_BTI(SLICE(ctx->op2,2,1), ctx->pstate_btype));
		}
		else {
			ENDOFINSTRUCTION;
		}
		OK(ENC_CSDB_HI_HINTS);
	}
	return rc;
}

/* csel.xml */
int CSEL(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=0|S=0|11010100|Rm=xxxxx|cond=xxxx|0|o2=0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE00C00)==0x1A800000) {
		decode_fields32(ENC_CSEL_32_CONDSEL, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->condition = ctx->cond;
		ctx->else_inv = (ctx->op==1);
		ctx->else_inc = (ctx->o2==1);
		if(ctx->sf==0) OK(ENC_CSEL_32_CONDSEL);
		if(ctx->sf==1) OK(ENC_CSEL_64_CONDSEL);
	}
	return rc;
}

/* csetm_csinv.xml */
int CSETM_CSINV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=1|S=0|11010100|Rm=11111|cond!=111x|0|o2=0|Rn=11111|Rd=xxxxx */
	if((INSWORD & 0x7FFF0FE0)==0x5A9F03E0 && (INSWORD & 0xE000)!=0xE000) {
		decode_fields32(ENC_CSETM_CSINV_32_CONDSEL, ctx, instr);
		if(ctx->sf==0) OK(ENC_CSETM_CSINV_32_CONDSEL);
		if(ctx->sf==1) OK(ENC_CSETM_CSINV_64_CONDSEL);
	}
	return rc;
}

/* cset_csinc.xml */
int CSET_CSINC(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=0|S=0|11010100|Rm=11111|cond!=111x|0|o2=1|Rn=11111|Rd=xxxxx */
	if((INSWORD & 0x7FFF0FE0)==0x1A9F07E0 && (INSWORD & 0xE000)!=0xE000) {
		decode_fields32(ENC_CSET_CSINC_32_CONDSEL, ctx, instr);
		if(ctx->sf==0) OK(ENC_CSET_CSINC_32_CONDSEL);
		if(ctx->sf==1) OK(ENC_CSET_CSINC_64_CONDSEL);
	}
	return rc;
}

/* csinc.xml */
int CSINC(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=0|S=0|11010100|Rm=xxxxx|cond=xxxx|0|o2=1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE00C00)==0x1A800400) {
		decode_fields32(ENC_CSINC_32_CONDSEL, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->condition = ctx->cond;
		ctx->else_inv = (ctx->op==1);
		ctx->else_inc = (ctx->o2==1);
		/* regular aliases */
		if(ctx->Rm!=0x1f && (ctx->cond&14)!=14 && ctx->Rn!=0x1f && ctx->Rn==ctx->Rm) return CINC_CSINC(ctx, instr);
		if(ctx->Rm==0x1f && (ctx->cond&14)!=14 && ctx->Rn==0x1f) return CSET_CSINC(ctx, instr);
		if(ctx->sf==0) OK(ENC_CSINC_32_CONDSEL);
		if(ctx->sf==1) OK(ENC_CSINC_64_CONDSEL);
	}
	return rc;
}

/* csinv.xml */
int CSINV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=1|S=0|11010100|Rm=xxxxx|cond=xxxx|0|o2=0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE00C00)==0x5A800000) {
		decode_fields32(ENC_CSINV_32_CONDSEL, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->condition = ctx->cond;
		ctx->else_inv = (ctx->op==1);
		ctx->else_inc = (ctx->o2==1);
		/* regular aliases */
		if(ctx->Rm!=0x1f && (ctx->cond&14)!=14 && ctx->Rn!=0x1f && ctx->Rn==ctx->Rm) return CINV_CSINV(ctx, instr);
		if(ctx->Rm==0x1f && (ctx->cond&14)!=14 && ctx->Rn==0x1f) return CSETM_CSINV(ctx, instr);
		if(ctx->sf==0) OK(ENC_CSINV_32_CONDSEL);
		if(ctx->sf==1) OK(ENC_CSINV_64_CONDSEL);
	}
	return rc;
}

/* csneg.xml */
int CSNEG(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=1|S=0|11010100|Rm=xxxxx|cond=xxxx|0|o2=1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE00C00)==0x5A800400) {
		decode_fields32(ENC_CSNEG_32_CONDSEL, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->condition = ctx->cond;
		ctx->else_inv = (ctx->op==1);
		ctx->else_inc = (ctx->o2==1);
		/* regular aliases */
		if((ctx->cond&14)!=14 && ctx->Rn==ctx->Rm) return CNEG_CSNEG(ctx, instr);
		if(ctx->sf==0) OK(ENC_CSNEG_32_CONDSEL);
		if(ctx->sf==1) OK(ENC_CSNEG_64_CONDSEL);
	}
	return rc;
}

/* dcps1.xml */
int DCPS1(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 11010100|opc=101|imm16=xxxxxxxxxxxxxxxx|op2=000|LL=01 */
	if((INSWORD & 0xFFE0001F)==0xD4A00001) {
		decode_fields32(ENC_DCPS1_DC_EXCEPTION, ctx, instr);
		ctx->target_level = ctx->LL;
		if(ctx->LL==0) {
			UNDEFINED;
		}
		/* if(!Halted()) { UNDEFINED; } */
		OK(ENC_DCPS1_DC_EXCEPTION);
	}
	return rc;
}

/* dcps2.xml */
int DCPS2(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 11010100|opc=101|imm16=xxxxxxxxxxxxxxxx|op2=000|LL=10 */
	if((INSWORD & 0xFFE0001F)==0xD4A00002) {
		decode_fields32(ENC_DCPS2_DC_EXCEPTION, ctx, instr);
		ctx->target_level = ctx->LL;
		if(ctx->LL==0) {
			UNDEFINED;
		}
		/* if(!Halted()) { UNDEFINED; } */
		OK(ENC_DCPS2_DC_EXCEPTION);
	}
	return rc;
}

/* dcps3.xml */
int DCPS3(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 11010100|opc=101|imm16=xxxxxxxxxxxxxxxx|op2=000|LL=11 */
	if((INSWORD & 0xFFE0001F)==0xD4A00003) {
		decode_fields32(ENC_DCPS3_DC_EXCEPTION, ctx, instr);
		ctx->target_level = ctx->LL;
		if(ctx->LL==0) {
			UNDEFINED;
		}
		/* if(!Halted()) { UNDEFINED; } */
		OK(ENC_DCPS3_DC_EXCEPTION);
	}
	return rc;
}

/* dc_sys.xml */
int DC_SYS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=01|op1=xxx|CRn=0111|CRm=xxxx|op2=xxx|Rt=xxxxx */
	if((INSWORD & 0xFFF8F000)==0xD5087000) {
		decode_fields32(ENC_DC_SYS_CR_SYSTEMINSTRS, ctx, instr);
		OK(ENC_DC_SYS_CR_SYSTEMINSTRS);
	}
	return rc;
}

/* dgh.xml */
int DGH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=0000|op2=110|Rt=11111 */
	if((INSWORD & 0xFFFFFFFF)==0xD50320DF) {
		decode_fields32(ENC_DGH_HI_HINTS, ctx, instr);
		if(!((ctx->CRm<<3)|ctx->op2)) {
			ctx->op = SystemHintOp_NOP;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==1) {
			ctx->op = SystemHintOp_YIELD;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==2) {
			ctx->op = SystemHintOp_WFE;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==3) {
			ctx->op = SystemHintOp_WFI;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==4) {
			ctx->op = SystemHintOp_SEV;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==5) {
			ctx->op = SystemHintOp_SEVL;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==6) {
			if(!HaveDGHExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_DGH;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==7) {
			SEE /* XPACLRI */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==8) {
			if(!ctx->op2) {
				SEE /* PACIA1716 */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIB1716 */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIA1716 */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIB1716 */;
			}
			else {
				ENDOFINSTRUCTION;
			}
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x10) {
			if(!HaveRASExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_ESB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x11) {
			if(!HaveStatisticalProfiling()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_PSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x12) {
			if(!HaveSelfHostedTrace()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_TSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x14) {
			ctx->op = SystemHintOp_CSDB;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==0x18) {
			if(!ctx->op2) {
				SEE /* PACIAZ */;
			}
			else if(ctx->op2==1) {
				SEE /* PACIASP */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIBZ */;
			}
			else if(ctx->op2==3) {
				SEE /* PACIBSP */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIAZ */;
			}
			else if(ctx->op2==5) {
				SEE /* AUTHASP */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIBZ */;
			}
			else if(ctx->op2==7) {
				SEE /* AUTIBSP */;
			}
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x79)==0x20) {
			ctx->op = SystemHintOp_BTI;
			SetBTypeCompatible(BTypeCompatible_BTI(SLICE(ctx->op2,2,1), ctx->pstate_btype));
		}
		else {
			ENDOFINSTRUCTION;
		}
		OK(ENC_DGH_HI_HINTS);
	}
	return rc;
}

/* dmb.xml */
int DMB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0011|CRm=xxxx|1|opc=01|Rt=11111 */
	if((INSWORD & 0xFFFFF0FF)==0xD50330BF) {
		decode_fields32(ENC_DMB_BO_BARRIERS, ctx, instr);
		if(!SLICE(ctx->CRm,3,2)) {
			ctx->domain = MBReqDomain_OuterShareable;
		}
		else if(SLICE(ctx->CRm,3,2)==1) {
			ctx->domain = MBReqDomain_Nonshareable;
		}
		else if(SLICE(ctx->CRm,3,2)==2) {
			ctx->domain = MBReqDomain_InnerShareable;
		}
		else if(SLICE(ctx->CRm,3,2)==3) {
			ctx->domain = MBReqDomain_FullSystem;
		}
		if(!SLICE(ctx->CRm,1,0)) {
			ctx->types = MBReqTypes_All;
			ctx->domain = MBReqDomain_FullSystem;
		}
		else if(SLICE(ctx->CRm,1,0)==1) {
			ctx->types = MBReqTypes_Reads;
		}
		else if(SLICE(ctx->CRm,1,0)==2) {
			ctx->types = MBReqTypes_Writes;
		}
		else if(SLICE(ctx->CRm,1,0)==3) {
			ctx->types = MBReqTypes_All;
		}
		OK(ENC_DMB_BO_BARRIERS);
	}
	return rc;
}

/* drps.xml */
int DRPS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101011|opc=0101|op2=11111|op3=000000|Rt=11111|op4=00000 */
	if((INSWORD & 0xFFFFFFFF)==0xD6BF03E0) {
		decode_fields32(ENC_DRPS_64E_BRANCH_REG, ctx, instr);
		/* if(!Halted() || ctx->pstate_el==EL0) { UNDEFINED; } */
		OK(ENC_DRPS_64E_BRANCH_REG);
	}
	return rc;
}

/* dsb.xml */
int DSB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_dsb_memory */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0011|CRm=xxxx|1|opc=00|Rt=11111 */
	if((INSWORD & 0xFFFFF0FF)==0xD503309F) {
		decode_fields32(ENC_DSB_BO_BARRIERS, ctx, instr);
		ctx->nXS = FALSE;
		if(!SLICE(ctx->CRm,3,2)) {
			ctx->domain = MBReqDomain_OuterShareable;
		}
		else if(SLICE(ctx->CRm,3,2)==1) {
			ctx->domain = MBReqDomain_Nonshareable;
		}
		else if(SLICE(ctx->CRm,3,2)==2) {
			ctx->domain = MBReqDomain_InnerShareable;
		}
		else if(SLICE(ctx->CRm,3,2)==3) {
			ctx->domain = MBReqDomain_FullSystem;
		}
		if(!SLICE(ctx->CRm,1,0)) {
			ctx->types = MBReqTypes_All;
			ctx->domain = MBReqDomain_FullSystem;
		}
		else if(SLICE(ctx->CRm,1,0)==1) {
			ctx->types = MBReqTypes_Reads;
		}
		else if(SLICE(ctx->CRm,1,0)==2) {
			ctx->types = MBReqTypes_Writes;
		}
		else if(SLICE(ctx->CRm,1,0)==3) {
			ctx->types = MBReqTypes_All;
		}
		/* regular aliases */
		if(ctx->CRm==4) return PSSBB_DSB(ctx, instr);
		if(ctx->CRm==0) return SSBB_DSB(ctx, instr);
		OK(ENC_DSB_BO_BARRIERS);
	}
	/* class iclass_dsb_nxs */
	/* 11010101000000110011|imm2=xx|10|op2<2>=0|op2<1:0>=01|Rt=11111 */
	if((INSWORD & 0xFFFFF3FF)==0xD503323F) {
		decode_fields32(ENC_DSB_BON_BARRIERS, ctx, instr);
		if(!HaveFeatXS()) {
			UNDEFINED;
		}
		ctx->types = MBReqTypes_All;
		ctx->nXS = TRUE;
		if(!ctx->imm2) {
			ctx->domain = MBReqDomain_OuterShareable;
		}
		else if(ctx->imm2==1) {
			ctx->domain = MBReqDomain_Nonshareable;
		}
		else if(ctx->imm2==2) {
			ctx->domain = MBReqDomain_InnerShareable;
		}
		else if(ctx->imm2==3) {
			ctx->domain = MBReqDomain_FullSystem;
		}
		/* regular aliases */
		// alias:PSSBB_DSB with preference:["CRm == '0100'"] does not apply
		// alias:SSBB_DSB with preference:["CRm == '0000'"] does not apply
		OK(ENC_DSB_BON_BARRIERS);
	}
	return rc;
}

/* dup_advsimd_elt.xml */
int DUP_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_scalar_from_element */
	/* 01|op=0|11110000|imm5=xxxxx|0|imm4=0000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x5E000400) {
		decode_fields32(ENC_DUP_ASISDONE_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->size = LowestSetBit(ctx->imm5);
		if(ctx->size>3) {
			UNDEFINED;
		}
		ctx->index = UINT(SLICE(ctx->imm5,4,ctx->size+1));
		ctx->idxdsize = (SLICE(ctx->imm5,4,4)==1) ? 0x80 : 0x40;
		ctx->esize = (8) << (ctx->size);
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		/* unconditional alias */
		if(MOV_DUP_advsimd_elt(ctx, instr)==0) return 0;
		OK(ENC_DUP_ASISDONE_ONLY);
	}
	/* class iclass_vector_from_element */
	/* 0|Q=x|op=0|01110000|imm5=xxxxx|0|imm4=0000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xE000400) {
		decode_fields32(ENC_DUP_ASIMDINS_DV_V, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->size = LowestSetBit(ctx->imm5);
		if(ctx->size>3) {
			UNDEFINED;
		}
		ctx->index = UINT(SLICE(ctx->imm5,4,ctx->size+1));
		ctx->idxdsize = (SLICE(ctx->imm5,4,4)==1) ? 0x80 : 0x40;
		if(ctx->size==3 && ctx->Q==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (ctx->size);
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		/* unconditional alias */
		if(MOV_DUP_advsimd_elt(ctx, instr)==0) return 0;
		OK(ENC_DUP_ASIMDINS_DV_V);
	}
	return rc;
}

/* dup_advsimd_gen.xml */
int DUP_advsimd_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|op=0|01110000|imm5=xxxxx|0|imm4=0001|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xE000C00) {
		decode_fields32(ENC_DUP_ASIMDINS_DR_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->size = LowestSetBit(ctx->imm5);
		if(ctx->size>3) {
			UNDEFINED;
		}
		if(ctx->size==3 && ctx->Q==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (ctx->size);
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_DUP_ASIMDINS_DR_R);
	}
	return rc;
}

/* dvp_sys.xml */
int DVP_SYS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=01|op1=011|CRn=0111|CRm=0011|op2=101|Rt=xxxxx */
	if((INSWORD & 0xFFFFFFE0)==0xD50B73A0) {
		decode_fields32(ENC_DVP_SYS_CR_SYSTEMINSTRS, ctx, instr);
		OK(ENC_DVP_SYS_CR_SYSTEMINSTRS);
	}
	return rc;
}

/* eon.xml */
int EON(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|opc=10|01010|shift=xx|N=1|Rm=xxxxx|imm6=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F200000)==0x4A200000) {
		decode_fields32(ENC_EON_32_LOG_SHIFT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==1) {
			ctx->op = LogicalOp_ORR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==2) {
			ctx->op = LogicalOp_EOR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==3) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = TRUE;
		}
		if(ctx->sf==0 && SLICE(ctx->imm6,5,5)==1) {
			UNDEFINED;
		}
		ctx->shift_type = DecodeShift(ctx->shift);
		ctx->shift_amount = UINT(ctx->imm6);
		ctx->invert = (ctx->N==1);
		if(ctx->sf==0) OK(ENC_EON_32_LOG_SHIFT);
		if(ctx->sf==1) OK(ENC_EON_64_LOG_SHIFT);
	}
	return rc;
}

/* eon_eor_z_zi.xml */
int EON_eor_z_zi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|opc=01|0000|imm13=xxxxxxxxxxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFFFC0000)==0x5400000) {
		decode_fields32(ENC_EON_EOR_Z_ZI_, ctx, instr);
		OK(ENC_EON_EOR_Z_ZI_);
	}
	return rc;
}

/* eor3_advsimd.xml */
int EOR3_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 110011100|Op0=00|Rm=xxxxx|0|Ra=xxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE08000)==0xCE000000) {
		decode_fields32(ENC_EOR3_VVV16_CRYPTO4, ctx, instr);
		if(!HaveSHA3Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->a = UINT(ctx->Ra);
		OK(ENC_EOR3_VVV16_CRYPTO4);
	}
	return rc;
}

/* eor_advsimd.xml */
int EOR_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=1|01110|opc2=00|1|Rm=xxxxx|opcode=00011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2E201C00) {
		decode_fields32(ENC_EOR_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 8;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!ctx->opc2) {
			ctx->op = VBitOp_VEOR;
		}
		else if(ctx->opc2==1) {
			ctx->op = VBitOp_VBSL;
		}
		else if(ctx->opc2==2) {
			ctx->op = VBitOp_VBIT;
		}
		else if(ctx->opc2==3) {
			ctx->op = VBitOp_VBIF;
		}
		OK(ENC_EOR_ASIMDSAME_ONLY);
	}
	return rc;
}

/* eor_log_imm.xml */
int EOR_log_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|opc=10|100100|N=x|immr=xxxxxx|imms=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x52000000) {
		decode_fields32(ENC_EOR_32_LOG_IMM, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==1) {
			ctx->op = LogicalOp_ORR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==2) {
			ctx->op = LogicalOp_EOR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==3) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = TRUE;
		}
		if(ctx->sf==0 && ctx->N!=0) {
			UNDEFINED;
		}
		DecodeBitMasksCheckUndefined(ctx->N,ctx->imms);
		DecodeBitMasks_ReturnType dbmrt = DecodeBitMasks(ctx->N,ctx->imms,ctx->immr);
		ctx->imm = dbmrt.wmask;
		if(ctx->sf==0 && ctx->N==0) OK(ENC_EOR_32_LOG_IMM);
		if(ctx->sf==1) OK(ENC_EOR_64_LOG_IMM);
	}
	return rc;
}

/* eor_log_shift.xml */
int EOR_log_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|opc=10|01010|shift=xx|N=0|Rm=xxxxx|imm6=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F200000)==0x4A000000) {
		decode_fields32(ENC_EOR_32_LOG_SHIFT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==1) {
			ctx->op = LogicalOp_ORR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==2) {
			ctx->op = LogicalOp_EOR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==3) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = TRUE;
		}
		if(ctx->sf==0 && SLICE(ctx->imm6,5,5)==1) {
			UNDEFINED;
		}
		ctx->shift_type = DecodeShift(ctx->shift);
		ctx->shift_amount = UINT(ctx->imm6);
		ctx->invert = (ctx->N==1);
		if(ctx->sf==0) OK(ENC_EOR_32_LOG_SHIFT);
		if(ctx->sf==1) OK(ENC_EOR_64_LOG_SHIFT);
	}
	return rc;
}

/* eret.xml */
int ERET(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101011|opc[3]=0|opc[2:0]=100|op2=11111|op3[5:2]=0000|A=0|M=0|Rn=11111|op4=00000 */
	if((INSWORD & 0xFFFFFFFF)==0xD69F03E0) {
		decode_fields32(ENC_ERET_64E_BRANCH_REG, ctx, instr);
		/* if(ctx->pstate_el==EL0) { UNDEFINED; } */
		ctx->pac = (ctx->A==1);
		ctx->use_key_a = (ctx->M==0);
		if(!ctx->pac && ctx->op4!=0) {
			UNDEFINED;
		}
		else if(ctx->pac && (!HavePACExt() || ctx->op4!=0x1f)) {
			UNDEFINED;
		}
		if(ctx->Rn!=0x1f) {
			UNDEFINED;
		}
		OK(ENC_ERET_64E_BRANCH_REG);
	}
	return rc;
}

/* ereta.xml */
int ERETA(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* 1101011|opc[3]=0|opc[2:0]=100|op2=11111|op3[5:2]=0000|A=1|M=x|Rn=11111|op4=11111 */
	if((INSWORD & 0xFFFFFBFF)==0xD69F0BFF) {
		decode_fields32(ENC_ERETAA_64E_BRANCH_REG, ctx, instr);
		/* if(ctx->pstate_el==EL0) { UNDEFINED; } */
		ctx->pac = (ctx->A==1);
		ctx->use_key_a = (ctx->M==0);
		if(!ctx->pac && ctx->op4!=0) {
			UNDEFINED;
		}
		else if(ctx->pac && (!HavePACExt() || ctx->op4!=0x1f)) {
			UNDEFINED;
		}
		if(ctx->Rn!=0x1f) {
			UNDEFINED;
		}
		if(ctx->M==0) OK(ENC_ERETAA_64E_BRANCH_REG);
		if(ctx->M==1) OK(ENC_ERETAB_64E_BRANCH_REG);
	}
	return rc;
}

/* esb.xml */
int ESB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=0010|op2=000|Rt=11111 */
	if((INSWORD & 0xFFFFFFFF)==0xD503221F) {
		decode_fields32(ENC_ESB_HI_HINTS, ctx, instr);
		if(!((ctx->CRm<<3)|ctx->op2)) {
			ctx->op = SystemHintOp_NOP;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==1) {
			ctx->op = SystemHintOp_YIELD;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==2) {
			ctx->op = SystemHintOp_WFE;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==3) {
			ctx->op = SystemHintOp_WFI;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==4) {
			ctx->op = SystemHintOp_SEV;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==5) {
			ctx->op = SystemHintOp_SEVL;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==6) {
			if(!HaveDGHExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_DGH;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==7) {
			SEE /* XPACLRI */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==8) {
			if(!ctx->op2) {
				SEE /* PACIA1716 */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIB1716 */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIA1716 */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIB1716 */;
			}
			else {
				ENDOFINSTRUCTION;
			}
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x10) {
			if(!HaveRASExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_ESB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x11) {
			if(!HaveStatisticalProfiling()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_PSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x12) {
			if(!HaveSelfHostedTrace()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_TSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x14) {
			ctx->op = SystemHintOp_CSDB;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==0x18) {
			if(!ctx->op2) {
				SEE /* PACIAZ */;
			}
			else if(ctx->op2==1) {
				SEE /* PACIASP */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIBZ */;
			}
			else if(ctx->op2==3) {
				SEE /* PACIBSP */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIAZ */;
			}
			else if(ctx->op2==5) {
				SEE /* AUTHASP */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIBZ */;
			}
			else if(ctx->op2==7) {
				SEE /* AUTIBSP */;
			}
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x79)==0x20) {
			ctx->op = SystemHintOp_BTI;
			SetBTypeCompatible(BTypeCompatible_BTI(SLICE(ctx->op2,2,1), ctx->pstate_btype));
		}
		else {
			ENDOFINSTRUCTION;
		}
		OK(ENC_ESB_HI_HINTS);
	}
	return rc;
}

/* extr.xml */
int EXTR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op21=00|100111|N=x|o0=0|Rm=xxxxx|imms=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FA00000)==0x13800000) {
		decode_fields32(ENC_EXTR_32_EXTRACT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(ctx->N!=ctx->sf) {
			UNDEFINED;
		}
		if(ctx->sf==0 && SLICE(ctx->imms,5,5)==1) {
			UNDEFINED;
		}
		ctx->lsb = UINT(ctx->imms);
		/* regular aliases */
		if(ctx->Rn==ctx->Rm) return ROR_EXTR(ctx, instr);
		if(ctx->sf==0 && ctx->N==0 && !(ctx->imms&0x20)) OK(ENC_EXTR_32_EXTRACT);
		if(ctx->sf==1 && ctx->N==1) OK(ENC_EXTR_64_EXTRACT);
	}
	return rc;
}

/* ext_advsimd.xml */
int EXT_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|101110|op2=00|0|Rm=xxxxx|0|imm4=xxxx|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE08400)==0x2E000000) {
		decode_fields32(ENC_EXT_ASIMDEXT_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->Q==0 && SLICE(ctx->imm4,3,3)==1) {
			UNDEFINED;
		}
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->position = (UINT(ctx->imm4)) << (3);
		OK(ENC_EXT_ASIMDEXT_ONLY);
	}
	return rc;
}

/* fabd_advsimd.xml */
int FABD_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=1|11110|a=1|10|Rm=xxxxx|00|opcode=010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x7EC01400) {
		decode_fields32(ENC_FABD_ASISDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->abs = TRUE;
		OK(ENC_FABD_ASISDSAMEFP16_ONLY);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=1|11110|1|sz=x|1|Rm=xxxxx|opcode=11010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFA0FC00)==0x7EA0D400) {
		decode_fields32(ENC_FABD_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->abs = TRUE;
		OK(ENC_FABD_ASISDSAME_ONLY);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=1|01110|a=1|10|Rm=xxxxx|00|opcode=010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2EC01400) {
		decode_fields32(ENC_FABD_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->abs = (ctx->U==1);
		OK(ENC_FABD_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=1|01110|1|sz=x|1|Rm=xxxxx|opcode=11010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0x2EA0D400) {
		decode_fields32(ENC_FABD_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->abs = (ctx->U==1);
		OK(ENC_FABD_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fabs_advsimd.xml */
int FABS_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|a=1|111100|opcode=01111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xEF8F800) {
		decode_fields32(ENC_FABS_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->neg = (ctx->U==1);
		OK(ENC_FABS_ASIMDMISCFP16_R);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=0|01110|1|sz=x|10000|opcode=01111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xEA0F800) {
		decode_fields32(ENC_FABS_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->neg = (ctx->U==1);
		OK(ENC_FABS_ASIMDMISC_R);
	}
	return rc;
}

/* fabs_float.xml */
int FABS_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|0000|opc=01|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x1E20C000) {
		decode_fields32(ENC_FABS_H_FLOATDP1, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!ctx->opc) {
			ctx->fpop = FPUnaryOp_MOV;
		}
		else if(ctx->opc==1) {
			ctx->fpop = FPUnaryOp_ABS;
		}
		else if(ctx->opc==2) {
			ctx->fpop = FPUnaryOp_NEG;
		}
		else if(ctx->opc==3) {
			ctx->fpop = FPUnaryOp_SQRT;
		}
		if(ctx->ftype==3) OK(ENC_FABS_H_FLOATDP1);
		if(ctx->ftype==0) OK(ENC_FABS_S_FLOATDP1);
		if(ctx->ftype==1) OK(ENC_FABS_D_FLOATDP1);
	}
	return rc;
}

/* facge_advsimd.xml */
int FACGE_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=1|11110|E=0|10|Rm=xxxxx|00|10|ac=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x7E402C00) {
		decode_fields32(ENC_FACGE_ASISDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FACGE_ASISDSAMEFP16_ONLY);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=1|11110|E=0|sz=x|1|Rm=xxxxx|1110|ac=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFA0FC00)==0x7E20EC00) {
		decode_fields32(ENC_FACGE_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FACGE_ASISDSAME_ONLY);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=1|01110|E=0|10|Rm=xxxxx|00|10|ac=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2E402C00) {
		decode_fields32(ENC_FACGE_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FACGE_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=1|01110|E=0|sz=x|1|Rm=xxxxx|1110|ac=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0x2E20EC00) {
		decode_fields32(ENC_FACGE_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FACGE_ASIMDSAME_ONLY);
	}
	return rc;
}

/* facgt_advsimd.xml */
int FACGT_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=1|11110|E=1|10|Rm=xxxxx|00|10|ac=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x7EC02C00) {
		decode_fields32(ENC_FACGT_ASISDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FACGT_ASISDSAMEFP16_ONLY);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=1|11110|E=1|sz=x|1|Rm=xxxxx|1110|ac=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFA0FC00)==0x7EA0EC00) {
		decode_fields32(ENC_FACGT_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FACGT_ASISDSAME_ONLY);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=1|01110|E=1|10|Rm=xxxxx|00|10|ac=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2EC02C00) {
		decode_fields32(ENC_FACGT_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FACGT_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=1|01110|E=1|sz=x|1|Rm=xxxxx|1110|ac=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0x2EA0EC00) {
		decode_fields32(ENC_FACGT_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FACGT_ASIMDSAME_ONLY);
	}
	return rc;
}

/* facle_facge_p_p_zz.xml */
int FACLE_facge_p_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_ge */
	/* 01100101|size=xx|0|Zm=xxxxx|op=1|1|o2=0|Pg=xxx|Zn=xxxxx|o3=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x6500C010) {
		decode_fields32(ENC_FACLE_FACGE_P_P_ZZ_, ctx, instr);
		OK(ENC_FACLE_FACGE_P_P_ZZ_);
	}
	return rc;
}

/* faclt_facge_p_p_zz.xml */
int FACLT_facge_p_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_gt */
	/* 01100101|size=xx|0|Zm=xxxxx|op=1|1|o2=1|Pg=xxx|Zn=xxxxx|o3=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x6500E010) {
		decode_fields32(ENC_FACLT_FACGT_P_P_ZZ_, ctx, instr);
		OK(ENC_FACLT_FACGT_P_P_ZZ_);
	}
	return rc;
}

/* faddp_advsimd_pair.xml */
int FADDP_advsimd_pair(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 01|U=0|11110|0|sz=x|11000|opcode=01101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x5E30D800) {
		decode_fields32(ENC_FADDP_ASISDPAIR_ONLY_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		if(ctx->sz==1) {
			UNDEFINED;
		}
		ctx->datasize = (ctx->esize) * (2);
		ctx->elements = 2;
		ctx->op = ReduceOp_FADD;
		OK(ENC_FADDP_ASISDPAIR_ONLY_H);
	}
	/* class iclass_single_and_double */
	/* 01|U=1|11110|0|sz=x|11000|opcode=01101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x7E30D800) {
		decode_fields32(ENC_FADDP_ASISDPAIR_ONLY_SD, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->esize) * (2);
		ctx->elements = 2;
		ctx->op = ReduceOp_FADD;
		OK(ENC_FADDP_ASISDPAIR_ONLY_SD);
	}
	return rc;
}

/* faddp_advsimd_vec.xml */
int FADDP_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=1|01110|a=0|10|Rm=xxxxx|00|opcode=010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2E401400) {
		decode_fields32(ENC_FADDP_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		OK(ENC_FADDP_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=1|01110|0|sz=x|1|Rm=xxxxx|opcode=11010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0x2E20D400) {
		decode_fields32(ENC_FADDP_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		OK(ENC_FADDP_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fadd_advsimd.xml */
int FADD_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|a=0|10|Rm=xxxxx|00|opcode=010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xE401400) {
		decode_fields32(ENC_FADD_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		OK(ENC_FADD_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=0|01110|0|sz=x|1|Rm=xxxxx|opcode=11010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0xE20D400) {
		decode_fields32(ENC_FADD_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		OK(ENC_FADD_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fadd_float.xml */
int FADD_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|Rm=xxxxx|001|op=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x1E202800) {
		decode_fields32(ENC_FADD_H_FLOATDP2, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->sub_op = (ctx->op==1);
		if(ctx->ftype==3) OK(ENC_FADD_H_FLOATDP2);
		if(ctx->ftype==0) OK(ENC_FADD_S_FLOATDP2);
		if(ctx->ftype==1) OK(ENC_FADD_D_FLOATDP2);
	}
	return rc;
}

/* fcadd_advsimd_vec.xml */
int FCADD_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|0|Rm=xxxxx|1|11|rot=x|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20EC00)==0x2E00E400) {
		decode_fields32(ENC_FCADD_ASIMDSAME2_C, ctx, instr);
		if(!HaveFCADDExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==0) {
			UNDEFINED;
		}
		if(ctx->Q==0 && ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		if(!HaveFP16Ext() && ctx->esize==0x10) {
			UNDEFINED;
		}
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FCADD_ASIMDSAME2_C);
	}
	return rc;
}

/* fccmpe_float.xml */
int FCCMPE_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|Rm=xxxxx|cond=xxxx|01|Rn=xxxxx|op=1|nzcv=xxxx */
	if((INSWORD & 0xFF200C10)==0x1E200410) {
		decode_fields32(ENC_FCCMPE_H_FLOATCCMP, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->datasize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->datasize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->datasize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->signal_all_nans = (ctx->op==1);
		ctx->condition = ctx->cond;
		ctx->flags = ctx->nzcv;
		if(ctx->ftype==3) OK(ENC_FCCMPE_H_FLOATCCMP);
		if(ctx->ftype==0) OK(ENC_FCCMPE_S_FLOATCCMP);
		if(ctx->ftype==1) OK(ENC_FCCMPE_D_FLOATCCMP);
	}
	return rc;
}

/* fccmp_float.xml */
int FCCMP_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|Rm=xxxxx|cond=xxxx|01|Rn=xxxxx|op=0|nzcv=xxxx */
	if((INSWORD & 0xFF200C10)==0x1E200400) {
		decode_fields32(ENC_FCCMP_H_FLOATCCMP, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->datasize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->datasize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->datasize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->signal_all_nans = (ctx->op==1);
		ctx->condition = ctx->cond;
		ctx->flags = ctx->nzcv;
		if(ctx->ftype==3) OK(ENC_FCCMP_H_FLOATCCMP);
		if(ctx->ftype==0) OK(ENC_FCCMP_S_FLOATCCMP);
		if(ctx->ftype==1) OK(ENC_FCCMP_D_FLOATCCMP);
	}
	return rc;
}

/* fcmeq_advsimd_reg.xml */
int FCMEQ_advsimd_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=0|11110|E=0|10|Rm=xxxxx|00|10|ac=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x5E402400) {
		decode_fields32(ENC_FCMEQ_ASISDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FCMEQ_ASISDSAMEFP16_ONLY);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=0|11110|E=0|sz=x|1|Rm=xxxxx|1110|ac=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFA0FC00)==0x5E20E400) {
		decode_fields32(ENC_FCMEQ_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FCMEQ_ASISDSAME_ONLY);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=0|01110|E=0|10|Rm=xxxxx|00|10|ac=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xE402400) {
		decode_fields32(ENC_FCMEQ_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FCMEQ_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|E=0|sz=x|1|Rm=xxxxx|1110|ac=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0xE20E400) {
		decode_fields32(ENC_FCMEQ_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FCMEQ_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fcmeq_advsimd_zero.xml */
int FCMEQ_advsimd_zero(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=0|11110|a=1|111100|0110|op=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x5EF8D800) {
		decode_fields32(ENC_FCMEQ_ASISDMISCFP16_FZ, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_FCMEQ_ASISDMISCFP16_FZ);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=0|11110|1|sz=x|10000|0110|op=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x5EA0D800) {
		decode_fields32(ENC_FCMEQ_ASISDMISC_FZ, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_FCMEQ_ASISDMISC_FZ);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=0|01110|a=1|111100|0110|op=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xEF8D800) {
		decode_fields32(ENC_FCMEQ_ASIMDMISCFP16_FZ, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_FCMEQ_ASIMDMISCFP16_FZ);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|1|sz=x|10000|0110|op=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xEA0D800) {
		decode_fields32(ENC_FCMEQ_ASIMDMISC_FZ, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_FCMEQ_ASIMDMISC_FZ);
	}
	return rc;
}

/* fcmge_advsimd_reg.xml */
int FCMGE_advsimd_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=1|11110|E=0|10|Rm=xxxxx|00|10|ac=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x7E402400) {
		decode_fields32(ENC_FCMGE_ASISDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FCMGE_ASISDSAMEFP16_ONLY);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=1|11110|E=0|sz=x|1|Rm=xxxxx|1110|ac=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFA0FC00)==0x7E20E400) {
		decode_fields32(ENC_FCMGE_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FCMGE_ASISDSAME_ONLY);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=1|01110|E=0|10|Rm=xxxxx|00|10|ac=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2E402400) {
		decode_fields32(ENC_FCMGE_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FCMGE_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=1|01110|E=0|sz=x|1|Rm=xxxxx|1110|ac=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0x2E20E400) {
		decode_fields32(ENC_FCMGE_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FCMGE_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fcmge_advsimd_zero.xml */
int FCMGE_advsimd_zero(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=1|11110|a=1|111100|0110|op=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x7EF8C800) {
		decode_fields32(ENC_FCMGE_ASISDMISCFP16_FZ, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_FCMGE_ASISDMISCFP16_FZ);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=1|11110|1|sz=x|10000|0110|op=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x7EA0C800) {
		decode_fields32(ENC_FCMGE_ASISDMISC_FZ, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_FCMGE_ASISDMISC_FZ);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=1|01110|a=1|111100|0110|op=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2EF8C800) {
		decode_fields32(ENC_FCMGE_ASIMDMISCFP16_FZ, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_FCMGE_ASIMDMISCFP16_FZ);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=1|01110|1|sz=x|10000|0110|op=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2EA0C800) {
		decode_fields32(ENC_FCMGE_ASIMDMISC_FZ, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_FCMGE_ASIMDMISC_FZ);
	}
	return rc;
}

/* fcmgt_advsimd_reg.xml */
int FCMGT_advsimd_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=1|11110|E=1|10|Rm=xxxxx|00|10|ac=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x7EC02400) {
		decode_fields32(ENC_FCMGT_ASISDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FCMGT_ASISDSAMEFP16_ONLY);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=1|11110|E=1|sz=x|1|Rm=xxxxx|1110|ac=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFA0FC00)==0x7EA0E400) {
		decode_fields32(ENC_FCMGT_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FCMGT_ASISDSAME_ONLY);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=1|01110|E=1|10|Rm=xxxxx|00|10|ac=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2EC02400) {
		decode_fields32(ENC_FCMGT_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FCMGT_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=1|01110|E=1|sz=x|1|Rm=xxxxx|1110|ac=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0x2EA0E400) {
		decode_fields32(ENC_FCMGT_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->E<<2)|(ctx->U<<1)|ctx->ac)) {
			ctx->cmp = CompareOp_EQ;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==2) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==3) {
			ctx->cmp = CompareOp_GE;
			ctx->abs = TRUE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==6) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = FALSE;
		}
		else if(((ctx->E<<2)|(ctx->U<<1)|ctx->ac)==7) {
			ctx->cmp = CompareOp_GT;
			ctx->abs = TRUE;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FCMGT_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fcmgt_advsimd_zero.xml */
int FCMGT_advsimd_zero(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=0|11110|a=1|111100|0110|op=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x5EF8C800) {
		decode_fields32(ENC_FCMGT_ASISDMISCFP16_FZ, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_FCMGT_ASISDMISCFP16_FZ);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=0|11110|1|sz=x|10000|0110|op=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x5EA0C800) {
		decode_fields32(ENC_FCMGT_ASISDMISC_FZ, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_FCMGT_ASISDMISC_FZ);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=0|01110|a=1|111100|0110|op=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xEF8C800) {
		decode_fields32(ENC_FCMGT_ASIMDMISCFP16_FZ, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_FCMGT_ASIMDMISCFP16_FZ);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|1|sz=x|10000|0110|op=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xEA0C800) {
		decode_fields32(ENC_FCMGT_ASIMDMISC_FZ, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_FCMGT_ASIMDMISC_FZ);
	}
	return rc;
}

/* fcmla_advsimd_elt.xml */
int FCMLA_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_element */
	/* 0|Q=x|U=1|01111|size=xx|L=x|M=x|Rm=xxxx|0|rot=xx|1|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF009400)==0x2F001000) {
		decode_fields32(ENC_FCMLA_ASIMDELEM_C_H, ctx, instr);
		if(!HaveFCADDExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->M<<4)|ctx->Rm));
		if(ctx->size==0 || ctx->size==3) {
			UNDEFINED;
		}
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
		}
		if(ctx->size==2) {
			ctx->index = UINT(ctx->H);
		}
		ctx->esize = (8) << (UINT(ctx->size));
		if(!HaveFP16Ext() && ctx->esize==0x10) {
			UNDEFINED;
		}
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(ctx->size==2 && (ctx->L==1 || ctx->Q==0)) {
			UNDEFINED;
		}
		if(ctx->size==1 && ctx->H==1 && ctx->Q==0) {
			UNDEFINED;
		}
		if(ctx->size==1) OK(ENC_FCMLA_ASIMDELEM_C_H);
		if(ctx->size==2) OK(ENC_FCMLA_ASIMDELEM_C_S);
	}
	return rc;
}

/* fcmla_advsimd_vec.xml */
int FCMLA_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|0|Rm=xxxxx|1|10|rot=xx|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20E400)==0x2E00C400) {
		decode_fields32(ENC_FCMLA_ASIMDSAME2_C, ctx, instr);
		if(!HaveFCADDExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==0) {
			UNDEFINED;
		}
		if(ctx->Q==0 && ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		if(!HaveFP16Ext() && ctx->esize==0x10) {
			UNDEFINED;
		}
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FCMLA_ASIMDSAME2_C);
	}
	return rc;
}

/* fcmle_advsimd.xml */
int FCMLE_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=1|11110|a=1|111100|0110|op=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x7EF8D800) {
		decode_fields32(ENC_FCMLE_ASISDMISCFP16_FZ, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_FCMLE_ASISDMISCFP16_FZ);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=1|11110|1|sz=x|10000|0110|op=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x7EA0D800) {
		decode_fields32(ENC_FCMLE_ASISDMISC_FZ, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_FCMLE_ASISDMISC_FZ);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=1|01110|a=1|111100|0110|op=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2EF8D800) {
		decode_fields32(ENC_FCMLE_ASIMDMISCFP16_FZ, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_FCMLE_ASIMDMISCFP16_FZ);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=1|01110|1|sz=x|10000|0110|op=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2EA0D800) {
		decode_fields32(ENC_FCMLE_ASIMDMISC_FZ, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		if(!((ctx->op<<1)|ctx->U)) {
			ctx->comparison = CompareOp_GT;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->comparison = CompareOp_GE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->comparison = CompareOp_EQ;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->comparison = CompareOp_LE;
		}
		OK(ENC_FCMLE_ASIMDMISC_FZ);
	}
	return rc;
}

/* fcmle_fcmeq_p_p_zz.xml */
int FCMLE_fcmeq_p_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_ge */
	/* 01100101|size=xx|0|Zm=xxxxx|op=0|1|cmph=0|Pg=xxx|Zn=xxxxx|cmpl=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x65004000) {
		decode_fields32(ENC_FCMLE_FCMGE_P_P_ZZ_, ctx, instr);
		OK(ENC_FCMLE_FCMGE_P_P_ZZ_);
	}
	return rc;
}

/* fcmlt_advsimd.xml */
int FCMLT_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=0|11110|a=1|111100|opcode=01110|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x5EF8E800) {
		decode_fields32(ENC_FCMLT_ASISDMISCFP16_FZ, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->comparison = CompareOp_LT;
		OK(ENC_FCMLT_ASISDMISCFP16_FZ);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=0|11110|1|sz=x|10000|opcode=01110|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x5EA0E800) {
		decode_fields32(ENC_FCMLT_ASISDMISC_FZ, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->comparison = CompareOp_LT;
		OK(ENC_FCMLT_ASISDMISC_FZ);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=0|01110|a=1|111100|opcode=01110|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xEF8E800) {
		decode_fields32(ENC_FCMLT_ASIMDMISCFP16_FZ, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->comparison = CompareOp_LT;
		OK(ENC_FCMLT_ASIMDMISCFP16_FZ);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|1|sz=x|10000|opcode=01110|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xEA0E800) {
		decode_fields32(ENC_FCMLT_ASIMDMISC_FZ, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->comparison = CompareOp_LT;
		OK(ENC_FCMLT_ASIMDMISC_FZ);
	}
	return rc;
}

/* fcmlt_fcmeq_p_p_zz.xml */
int FCMLT_fcmeq_p_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_gt */
	/* 01100101|size=xx|0|Zm=xxxxx|op=0|1|cmph=0|Pg=xxx|Zn=xxxxx|cmpl=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x65004010) {
		decode_fields32(ENC_FCMLT_FCMGT_P_P_ZZ_, ctx, instr);
		OK(ENC_FCMLT_FCMGT_P_P_ZZ_);
	}
	return rc;
}

/* fcmpe_float.xml */
int FCMPE_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|Rm=xxxxx|op=00|1000|Rn=xxxxx|opc=1x|000 */
	if((INSWORD & 0xFF20FC17)==0x1E202010) {
		decode_fields32(ENC_FCMPE_H_FLOATCMP, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->datasize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->datasize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->datasize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->signal_all_nans = (SLICE(ctx->opc,1,1)==1);
		ctx->cmp_with_zero = (SLICE(ctx->opc,0,0)==1);
		if(ctx->ftype==3 && ctx->opc==2) OK(ENC_FCMPE_H_FLOATCMP);
		if(ctx->ftype==3 && /* PreferBitsEqual(['ctx->Rm'],'00000') */ true && ctx->opc==3) OK(ENC_FCMPE_HZ_FLOATCMP);
		if(ctx->ftype==0 && ctx->opc==2) OK(ENC_FCMPE_S_FLOATCMP);
		if(ctx->ftype==0 && /* PreferBitsEqual(['ctx->Rm'],'00000') */ true && ctx->opc==3) OK(ENC_FCMPE_SZ_FLOATCMP);
		if(ctx->ftype==1 && ctx->opc==2) OK(ENC_FCMPE_D_FLOATCMP);
		if(ctx->ftype==1 && /* PreferBitsEqual(['ctx->Rm'],'00000') */ true && ctx->opc==3) OK(ENC_FCMPE_DZ_FLOATCMP);
	}
	return rc;
}

/* fcmp_float.xml */
int FCMP_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|Rm=xxxxx|op=00|1000|Rn=xxxxx|opc=0x|000 */
	if((INSWORD & 0xFF20FC17)==0x1E202000) {
		decode_fields32(ENC_FCMP_H_FLOATCMP, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->datasize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->datasize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->datasize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->signal_all_nans = (SLICE(ctx->opc,1,1)==1);
		ctx->cmp_with_zero = (SLICE(ctx->opc,0,0)==1);
		if(ctx->ftype==3 && ctx->opc==0) OK(ENC_FCMP_H_FLOATCMP);
		if(ctx->ftype==3 && /* PreferBitsEqual(['ctx->Rm'],'00000') */ true && ctx->opc==1) OK(ENC_FCMP_HZ_FLOATCMP);
		if(ctx->ftype==0 && ctx->opc==0) OK(ENC_FCMP_S_FLOATCMP);
		if(ctx->ftype==0 && /* PreferBitsEqual(['ctx->Rm'],'00000') */ true && ctx->opc==1) OK(ENC_FCMP_SZ_FLOATCMP);
		if(ctx->ftype==1 && ctx->opc==0) OK(ENC_FCMP_D_FLOATCMP);
		if(ctx->ftype==1 && /* PreferBitsEqual(['ctx->Rm'],'00000') */ true && ctx->opc==1) OK(ENC_FCMP_DZ_FLOATCMP);
	}
	return rc;
}

/* fcsel_float.xml */
int FCSEL_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|Rm=xxxxx|cond=xxxx|11|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF200C00)==0x1E200C00) {
		decode_fields32(ENC_FCSEL_H_FLOATSEL, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->datasize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->datasize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->datasize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->condition = ctx->cond;
		if(ctx->ftype==3) OK(ENC_FCSEL_H_FLOATSEL);
		if(ctx->ftype==0) OK(ENC_FCSEL_S_FLOATSEL);
		if(ctx->ftype==1) OK(ENC_FCSEL_D_FLOATSEL);
	}
	return rc;
}

/* fcvtas_advsimd.xml */
int FCVTAS_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=0|11110|size<1>=0|111100|opcode=11100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x5E79C800) {
		decode_fields32(ENC_FCVTAS_ASISDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPRounding_TIEAWAY;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTAS_ASISDMISCFP16_R);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=0|11110|0|sz=x|10000|opcode=11100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x5E21C800) {
		decode_fields32(ENC_FCVTAS_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPRounding_TIEAWAY;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTAS_ASISDMISC_R);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=0|01110|a=0|111100|opcode=11100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xE79C800) {
		decode_fields32(ENC_FCVTAS_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPRounding_TIEAWAY;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTAS_ASIMDMISCFP16_R);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|0|sz=x|10000|opcode=11100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xE21C800) {
		decode_fields32(ENC_FCVTAS_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPRounding_TIEAWAY;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTAS_ASIMDMISC_R);
	}
	return rc;
}

/* fcvtas_float.xml */
int FCVTAS_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|1|rmode=00|opcode=100|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F3FFC00)==0x1E240000) {
		decode_fields32(ENC_FCVTAS_32H_FLOAT2INT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)!=13) {
				UNDEFINED;
			}
			ctx->fltsize = 0x80;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)&12)) {
			ctx->rounding = FPDecodeRounding(ctx->rmode);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==8) {
			ctx->rounding = FPRounding_TIEAWAY;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==12) {
			if(ctx->fltsize!=0x10 && ctx->fltsize!=ctx->intsize) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 0;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==13) {
			if(ctx->intsize!=0x40 || ctx->fltsize!=0x80) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 1;
			ctx->fltsize = 0x40;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==15) {
			if(!HaveFJCVTZSExt()) {
				UNDEFINED;
			}
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI_JS;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3) OK(ENC_FCVTAS_32H_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==3) OK(ENC_FCVTAS_64H_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==0) OK(ENC_FCVTAS_32S_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==0) OK(ENC_FCVTAS_64S_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==1) OK(ENC_FCVTAS_32D_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==1) OK(ENC_FCVTAS_64D_FLOAT2INT);
	}
	return rc;
}

/* fcvtau_advsimd.xml */
int FCVTAU_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=1|11110|size<1>=0|111100|opcode=11100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x7E79C800) {
		decode_fields32(ENC_FCVTAU_ASISDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPRounding_TIEAWAY;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTAU_ASISDMISCFP16_R);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=1|11110|0|sz=x|10000|opcode=11100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x7E21C800) {
		decode_fields32(ENC_FCVTAU_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPRounding_TIEAWAY;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTAU_ASISDMISC_R);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=1|01110|a=0|111100|opcode=11100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2E79C800) {
		decode_fields32(ENC_FCVTAU_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPRounding_TIEAWAY;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTAU_ASIMDMISCFP16_R);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=1|01110|0|sz=x|10000|opcode=11100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2E21C800) {
		decode_fields32(ENC_FCVTAU_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPRounding_TIEAWAY;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTAU_ASIMDMISC_R);
	}
	return rc;
}

/* fcvtau_float.xml */
int FCVTAU_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|1|rmode=00|opcode=101|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F3FFC00)==0x1E250000) {
		decode_fields32(ENC_FCVTAU_32H_FLOAT2INT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)!=13) {
				UNDEFINED;
			}
			ctx->fltsize = 0x80;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)&12)) {
			ctx->rounding = FPDecodeRounding(ctx->rmode);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==8) {
			ctx->rounding = FPRounding_TIEAWAY;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==12) {
			if(ctx->fltsize!=0x10 && ctx->fltsize!=ctx->intsize) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 0;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==13) {
			if(ctx->intsize!=0x40 || ctx->fltsize!=0x80) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 1;
			ctx->fltsize = 0x40;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==15) {
			if(!HaveFJCVTZSExt()) {
				UNDEFINED;
			}
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI_JS;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3) OK(ENC_FCVTAU_32H_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==3) OK(ENC_FCVTAU_64H_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==0) OK(ENC_FCVTAU_32S_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==0) OK(ENC_FCVTAU_64S_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==1) OK(ENC_FCVTAU_32D_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==1) OK(ENC_FCVTAU_64D_FLOAT2INT);
	}
	return rc;
}

/* fcvtl_advsimd.xml */
int FCVTL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|0|sz=x|10000|opcode=10111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xE217800) {
		decode_fields32(ENC_FCVTL_ASIMDMISC_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x10) << (UINT(ctx->sz));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FCVTL_ASIMDMISC_L);
	}
	return rc;
}

/* fcvtms_advsimd.xml */
int FCVTMS_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=0|11110|o2=0|111100|1101|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x5E79B800) {
		decode_fields32(ENC_FCVTMS_ASISDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTMS_ASISDMISCFP16_R);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=0|11110|o2=0|sz=x|10000|1101|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x5E21B800) {
		decode_fields32(ENC_FCVTMS_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTMS_ASISDMISC_R);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=0|01110|o2=0|111100|1101|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xE79B800) {
		decode_fields32(ENC_FCVTMS_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTMS_ASIMDMISCFP16_R);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|o2=0|sz=x|10000|1101|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xE21B800) {
		decode_fields32(ENC_FCVTMS_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTMS_ASIMDMISC_R);
	}
	return rc;
}

/* fcvtms_float.xml */
int FCVTMS_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|1|rmode=10|opcode=000|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F3FFC00)==0x1E300000) {
		decode_fields32(ENC_FCVTMS_32H_FLOAT2INT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)!=13) {
				UNDEFINED;
			}
			ctx->fltsize = 0x80;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)&12)) {
			ctx->rounding = FPDecodeRounding(ctx->rmode);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==8) {
			ctx->rounding = FPRounding_TIEAWAY;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==12) {
			if(ctx->fltsize!=0x10 && ctx->fltsize!=ctx->intsize) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 0;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==13) {
			if(ctx->intsize!=0x40 || ctx->fltsize!=0x80) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 1;
			ctx->fltsize = 0x40;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==15) {
			if(!HaveFJCVTZSExt()) {
				UNDEFINED;
			}
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI_JS;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3) OK(ENC_FCVTMS_32H_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==3) OK(ENC_FCVTMS_64H_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==0) OK(ENC_FCVTMS_32S_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==0) OK(ENC_FCVTMS_64S_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==1) OK(ENC_FCVTMS_32D_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==1) OK(ENC_FCVTMS_64D_FLOAT2INT);
	}
	return rc;
}

/* fcvtmu_advsimd.xml */
int FCVTMU_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=1|11110|o2=0|111100|1101|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x7E79B800) {
		decode_fields32(ENC_FCVTMU_ASISDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTMU_ASISDMISCFP16_R);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=1|11110|o2=0|sz=x|10000|1101|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x7E21B800) {
		decode_fields32(ENC_FCVTMU_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTMU_ASISDMISC_R);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=1|01110|o2=0|111100|1101|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2E79B800) {
		decode_fields32(ENC_FCVTMU_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTMU_ASIMDMISCFP16_R);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=1|01110|o2=0|sz=x|10000|1101|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2E21B800) {
		decode_fields32(ENC_FCVTMU_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTMU_ASIMDMISC_R);
	}
	return rc;
}

/* fcvtmu_float.xml */
int FCVTMU_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|1|rmode=10|opcode=001|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F3FFC00)==0x1E310000) {
		decode_fields32(ENC_FCVTMU_32H_FLOAT2INT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)!=13) {
				UNDEFINED;
			}
			ctx->fltsize = 0x80;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)&12)) {
			ctx->rounding = FPDecodeRounding(ctx->rmode);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==8) {
			ctx->rounding = FPRounding_TIEAWAY;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==12) {
			if(ctx->fltsize!=0x10 && ctx->fltsize!=ctx->intsize) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 0;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==13) {
			if(ctx->intsize!=0x40 || ctx->fltsize!=0x80) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 1;
			ctx->fltsize = 0x40;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==15) {
			if(!HaveFJCVTZSExt()) {
				UNDEFINED;
			}
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI_JS;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3) OK(ENC_FCVTMU_32H_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==3) OK(ENC_FCVTMU_64H_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==0) OK(ENC_FCVTMU_32S_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==0) OK(ENC_FCVTMU_64S_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==1) OK(ENC_FCVTMU_32D_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==1) OK(ENC_FCVTMU_64D_FLOAT2INT);
	}
	return rc;
}

/* fcvtns_advsimd.xml */
int FCVTNS_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=0|11110|o2=0|111100|1101|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x5E79A800) {
		decode_fields32(ENC_FCVTNS_ASISDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTNS_ASISDMISCFP16_R);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=0|11110|o2=0|sz=x|10000|1101|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x5E21A800) {
		decode_fields32(ENC_FCVTNS_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTNS_ASISDMISC_R);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=0|01110|o2=0|111100|1101|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xE79A800) {
		decode_fields32(ENC_FCVTNS_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTNS_ASIMDMISCFP16_R);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|o2=0|sz=x|10000|1101|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xE21A800) {
		decode_fields32(ENC_FCVTNS_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTNS_ASIMDMISC_R);
	}
	return rc;
}

/* fcvtns_float.xml */
int FCVTNS_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|1|rmode=00|opcode=000|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F3FFC00)==0x1E200000) {
		decode_fields32(ENC_FCVTNS_32H_FLOAT2INT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)!=13) {
				UNDEFINED;
			}
			ctx->fltsize = 0x80;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)&12)) {
			ctx->rounding = FPDecodeRounding(ctx->rmode);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==8) {
			ctx->rounding = FPRounding_TIEAWAY;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==12) {
			if(ctx->fltsize!=0x10 && ctx->fltsize!=ctx->intsize) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 0;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==13) {
			if(ctx->intsize!=0x40 || ctx->fltsize!=0x80) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 1;
			ctx->fltsize = 0x40;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==15) {
			if(!HaveFJCVTZSExt()) {
				UNDEFINED;
			}
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI_JS;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3) OK(ENC_FCVTNS_32H_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==3) OK(ENC_FCVTNS_64H_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==0) OK(ENC_FCVTNS_32S_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==0) OK(ENC_FCVTNS_64S_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==1) OK(ENC_FCVTNS_32D_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==1) OK(ENC_FCVTNS_64D_FLOAT2INT);
	}
	return rc;
}

/* fcvtnu_advsimd.xml */
int FCVTNU_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=1|11110|o2=0|111100|1101|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x7E79A800) {
		decode_fields32(ENC_FCVTNU_ASISDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTNU_ASISDMISCFP16_R);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=1|11110|o2=0|sz=x|10000|1101|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x7E21A800) {
		decode_fields32(ENC_FCVTNU_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTNU_ASISDMISC_R);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=1|01110|o2=0|111100|1101|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2E79A800) {
		decode_fields32(ENC_FCVTNU_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTNU_ASIMDMISCFP16_R);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=1|01110|o2=0|sz=x|10000|1101|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2E21A800) {
		decode_fields32(ENC_FCVTNU_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTNU_ASIMDMISC_R);
	}
	return rc;
}

/* fcvtnu_float.xml */
int FCVTNU_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|1|rmode=00|opcode=001|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F3FFC00)==0x1E210000) {
		decode_fields32(ENC_FCVTNU_32H_FLOAT2INT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)!=13) {
				UNDEFINED;
			}
			ctx->fltsize = 0x80;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)&12)) {
			ctx->rounding = FPDecodeRounding(ctx->rmode);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==8) {
			ctx->rounding = FPRounding_TIEAWAY;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==12) {
			if(ctx->fltsize!=0x10 && ctx->fltsize!=ctx->intsize) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 0;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==13) {
			if(ctx->intsize!=0x40 || ctx->fltsize!=0x80) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 1;
			ctx->fltsize = 0x40;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==15) {
			if(!HaveFJCVTZSExt()) {
				UNDEFINED;
			}
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI_JS;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3) OK(ENC_FCVTNU_32H_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==3) OK(ENC_FCVTNU_64H_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==0) OK(ENC_FCVTNU_32S_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==0) OK(ENC_FCVTNU_64S_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==1) OK(ENC_FCVTNU_32D_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==1) OK(ENC_FCVTNU_64D_FLOAT2INT);
	}
	return rc;
}

/* fcvtn_advsimd.xml */
int FCVTN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|0|sz=x|10000|opcode=10110|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xE216800) {
		decode_fields32(ENC_FCVTN_ASIMDMISC_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x10) << (UINT(ctx->sz));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FCVTN_ASIMDMISC_N);
	}
	return rc;
}

/* fcvtps_advsimd.xml */
int FCVTPS_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=0|11110|o2=1|111100|1101|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x5EF9A800) {
		decode_fields32(ENC_FCVTPS_ASISDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTPS_ASISDMISCFP16_R);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=0|11110|o2=1|sz=x|10000|1101|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x5EA1A800) {
		decode_fields32(ENC_FCVTPS_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTPS_ASISDMISC_R);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=0|01110|o2=1|111100|1101|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xEF9A800) {
		decode_fields32(ENC_FCVTPS_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTPS_ASIMDMISCFP16_R);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|o2=1|sz=x|10000|1101|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xEA1A800) {
		decode_fields32(ENC_FCVTPS_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTPS_ASIMDMISC_R);
	}
	return rc;
}

/* fcvtps_float.xml */
int FCVTPS_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|1|rmode=01|opcode=000|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F3FFC00)==0x1E280000) {
		decode_fields32(ENC_FCVTPS_32H_FLOAT2INT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)!=13) {
				UNDEFINED;
			}
			ctx->fltsize = 0x80;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)&12)) {
			ctx->rounding = FPDecodeRounding(ctx->rmode);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==8) {
			ctx->rounding = FPRounding_TIEAWAY;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==12) {
			if(ctx->fltsize!=0x10 && ctx->fltsize!=ctx->intsize) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 0;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==13) {
			if(ctx->intsize!=0x40 || ctx->fltsize!=0x80) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 1;
			ctx->fltsize = 0x40;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==15) {
			if(!HaveFJCVTZSExt()) {
				UNDEFINED;
			}
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI_JS;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3) OK(ENC_FCVTPS_32H_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==3) OK(ENC_FCVTPS_64H_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==0) OK(ENC_FCVTPS_32S_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==0) OK(ENC_FCVTPS_64S_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==1) OK(ENC_FCVTPS_32D_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==1) OK(ENC_FCVTPS_64D_FLOAT2INT);
	}
	return rc;
}

/* fcvtpu_advsimd.xml */
int FCVTPU_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=1|11110|o2=1|111100|1101|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x7EF9A800) {
		decode_fields32(ENC_FCVTPU_ASISDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTPU_ASISDMISCFP16_R);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=1|11110|o2=1|sz=x|10000|1101|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x7EA1A800) {
		decode_fields32(ENC_FCVTPU_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTPU_ASISDMISC_R);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=1|01110|o2=1|111100|1101|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2EF9A800) {
		decode_fields32(ENC_FCVTPU_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTPU_ASIMDMISCFP16_R);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=1|01110|o2=1|sz=x|10000|1101|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2EA1A800) {
		decode_fields32(ENC_FCVTPU_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTPU_ASIMDMISC_R);
	}
	return rc;
}

/* fcvtpu_float.xml */
int FCVTPU_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|1|rmode=01|opcode=001|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F3FFC00)==0x1E290000) {
		decode_fields32(ENC_FCVTPU_32H_FLOAT2INT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)!=13) {
				UNDEFINED;
			}
			ctx->fltsize = 0x80;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)&12)) {
			ctx->rounding = FPDecodeRounding(ctx->rmode);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==8) {
			ctx->rounding = FPRounding_TIEAWAY;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==12) {
			if(ctx->fltsize!=0x10 && ctx->fltsize!=ctx->intsize) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 0;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==13) {
			if(ctx->intsize!=0x40 || ctx->fltsize!=0x80) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 1;
			ctx->fltsize = 0x40;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==15) {
			if(!HaveFJCVTZSExt()) {
				UNDEFINED;
			}
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI_JS;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3) OK(ENC_FCVTPU_32H_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==3) OK(ENC_FCVTPU_64H_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==0) OK(ENC_FCVTPU_32S_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==0) OK(ENC_FCVTPU_64S_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==1) OK(ENC_FCVTPU_32D_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==1) OK(ENC_FCVTPU_64D_FLOAT2INT);
	}
	return rc;
}

/* fcvtxn_advsimd.xml */
int FCVTXN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|0|sz=x|10000|opcode=10110|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x7E216800) {
		decode_fields32(ENC_FCVTXN_ASISDMISC_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->sz==0) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->part = 0;
		OK(ENC_FCVTXN_ASISDMISC_N);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|0|sz=x|10000|opcode=10110|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2E216800) {
		decode_fields32(ENC_FCVTXN_ASIMDMISC_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->sz==0) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->datasize = 0x40;
		ctx->elements = 2;
		ctx->part = UINT(ctx->Q);
		OK(ENC_FCVTXN_ASIMDMISC_N);
	}
	return rc;
}

/* fcvtzs_advsimd_fix.xml */
int FCVTZS_advsimd_fix(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|111110|immh!=0000|immb=xxx|opcode=11111|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x5F00FC00 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_FCVTZS_ASISDSHF_C, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!(ctx->immh&14) || ((ctx->immh&14)==2 && !HaveFP16Ext())) {
			UNDEFINED;
		}
		ctx->esize = ((ctx->immh&8)==8) ? 0x40 : (((ctx->immh&12)==4) ? 0x20 : 0x10);
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->fracbits = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZS_ASISDSHF_C);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|011110|immh!=0000|immb=xxx|opcode=11111|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0xF00FC00 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_FCVTZS_ASIMDSHF_C, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(!(ctx->immh&14) || ((ctx->immh&14)==2 && !HaveFP16Ext())) {
			UNDEFINED;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = ((ctx->immh&8)==8) ? 0x40 : (((ctx->immh&12)==4) ? 0x20 : 0x10);
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->fracbits = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZS_ASIMDSHF_C);
	}
	return rc;
}

/* fcvtzs_advsimd_int.xml */
int FCVTZS_advsimd_int(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=0|11110|o2=1|111100|1101|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x5EF9B800) {
		decode_fields32(ENC_FCVTZS_ASISDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTZS_ASISDMISCFP16_R);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=0|11110|o2=1|sz=x|10000|1101|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x5EA1B800) {
		decode_fields32(ENC_FCVTZS_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTZS_ASISDMISC_R);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=0|01110|o2=1|111100|1101|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xEF9B800) {
		decode_fields32(ENC_FCVTZS_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTZS_ASIMDMISCFP16_R);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|o2=1|sz=x|10000|1101|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xEA1B800) {
		decode_fields32(ENC_FCVTZS_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTZS_ASIMDMISC_R);
	}
	return rc;
}

/* fcvtzs_float_fix.xml */
int FCVTZS_float_fix(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|0|rmode=11|opcode=000|scale=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F3F0000)==0x1E180000) {
		decode_fields32(ENC_FCVTZS_32H_FLOAT2FIX, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(ctx->sf==0 && SLICE(ctx->scale,5,5)==0) {
			UNDEFINED;
		}
		ctx->fracbits = 0x40-UINT(ctx->scale);
		if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==3) {
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3) OK(ENC_FCVTZS_32H_FLOAT2FIX);
		if(ctx->sf==1 && ctx->ftype==3) OK(ENC_FCVTZS_64H_FLOAT2FIX);
		if(ctx->sf==0 && ctx->ftype==0) OK(ENC_FCVTZS_32S_FLOAT2FIX);
		if(ctx->sf==1 && ctx->ftype==0) OK(ENC_FCVTZS_64S_FLOAT2FIX);
		if(ctx->sf==0 && ctx->ftype==1) OK(ENC_FCVTZS_32D_FLOAT2FIX);
		if(ctx->sf==1 && ctx->ftype==1) OK(ENC_FCVTZS_64D_FLOAT2FIX);
	}
	return rc;
}

/* fcvtzs_float_int.xml */
int FCVTZS_float_int(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|1|rmode=11|opcode=000|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F3FFC00)==0x1E380000) {
		decode_fields32(ENC_FCVTZS_32H_FLOAT2INT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)!=13) {
				UNDEFINED;
			}
			ctx->fltsize = 0x80;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)&12)) {
			ctx->rounding = FPDecodeRounding(ctx->rmode);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==8) {
			ctx->rounding = FPRounding_TIEAWAY;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==12) {
			if(ctx->fltsize!=0x10 && ctx->fltsize!=ctx->intsize) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 0;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==13) {
			if(ctx->intsize!=0x40 || ctx->fltsize!=0x80) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 1;
			ctx->fltsize = 0x40;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==15) {
			if(!HaveFJCVTZSExt()) {
				UNDEFINED;
			}
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI_JS;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3) OK(ENC_FCVTZS_32H_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==3) OK(ENC_FCVTZS_64H_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==0) OK(ENC_FCVTZS_32S_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==0) OK(ENC_FCVTZS_64S_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==1) OK(ENC_FCVTZS_32D_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==1) OK(ENC_FCVTZS_64D_FLOAT2INT);
	}
	return rc;
}

/* fcvtzu_advsimd_fix.xml */
int FCVTZU_advsimd_fix(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|111110|immh!=0000|immb=xxx|opcode=11111|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x7F00FC00 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_FCVTZU_ASISDSHF_C, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!(ctx->immh&14) || ((ctx->immh&14)==2 && !HaveFP16Ext())) {
			UNDEFINED;
		}
		ctx->esize = ((ctx->immh&8)==8) ? 0x40 : (((ctx->immh&12)==4) ? 0x20 : 0x10);
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->fracbits = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZU_ASISDSHF_C);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|011110|immh!=0000|immb=xxx|opcode=11111|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0x2F00FC00 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_FCVTZU_ASIMDSHF_C, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(!(ctx->immh&14) || ((ctx->immh&14)==2 && !HaveFP16Ext())) {
			UNDEFINED;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = ((ctx->immh&8)==8) ? 0x40 : (((ctx->immh&12)==4) ? 0x20 : 0x10);
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->fracbits = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZU_ASIMDSHF_C);
	}
	return rc;
}

/* fcvtzu_advsimd_int.xml */
int FCVTZU_advsimd_int(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=1|11110|o2=1|111100|1101|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x7EF9B800) {
		decode_fields32(ENC_FCVTZU_ASISDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTZU_ASISDMISCFP16_R);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=1|11110|o2=1|sz=x|10000|1101|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x7EA1B800) {
		decode_fields32(ENC_FCVTZU_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTZU_ASISDMISC_R);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=1|01110|o2=1|111100|1101|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2EF9B800) {
		decode_fields32(ENC_FCVTZU_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTZU_ASIMDMISCFP16_R);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=1|01110|o2=1|sz=x|10000|1101|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2EA1B800) {
		decode_fields32(ENC_FCVTZU_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_FCVTZU_ASIMDMISC_R);
	}
	return rc;
}

/* fcvtzu_float_fix.xml */
int FCVTZU_float_fix(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|0|rmode=11|opcode=001|scale=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F3F0000)==0x1E190000) {
		decode_fields32(ENC_FCVTZU_32H_FLOAT2FIX, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(ctx->sf==0 && SLICE(ctx->scale,5,5)==0) {
			UNDEFINED;
		}
		ctx->fracbits = 0x40-UINT(ctx->scale);
		if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==3) {
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3) OK(ENC_FCVTZU_32H_FLOAT2FIX);
		if(ctx->sf==1 && ctx->ftype==3) OK(ENC_FCVTZU_64H_FLOAT2FIX);
		if(ctx->sf==0 && ctx->ftype==0) OK(ENC_FCVTZU_32S_FLOAT2FIX);
		if(ctx->sf==1 && ctx->ftype==0) OK(ENC_FCVTZU_64S_FLOAT2FIX);
		if(ctx->sf==0 && ctx->ftype==1) OK(ENC_FCVTZU_32D_FLOAT2FIX);
		if(ctx->sf==1 && ctx->ftype==1) OK(ENC_FCVTZU_64D_FLOAT2FIX);
	}
	return rc;
}

/* fcvtzu_float_int.xml */
int FCVTZU_float_int(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|1|rmode=11|opcode=001|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F3FFC00)==0x1E390000) {
		decode_fields32(ENC_FCVTZU_32H_FLOAT2INT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)!=13) {
				UNDEFINED;
			}
			ctx->fltsize = 0x80;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)&12)) {
			ctx->rounding = FPDecodeRounding(ctx->rmode);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==8) {
			ctx->rounding = FPRounding_TIEAWAY;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==12) {
			if(ctx->fltsize!=0x10 && ctx->fltsize!=ctx->intsize) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 0;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==13) {
			if(ctx->intsize!=0x40 || ctx->fltsize!=0x80) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 1;
			ctx->fltsize = 0x40;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==15) {
			if(!HaveFJCVTZSExt()) {
				UNDEFINED;
			}
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI_JS;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3) OK(ENC_FCVTZU_32H_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==3) OK(ENC_FCVTZU_64H_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==0) OK(ENC_FCVTZU_32S_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==0) OK(ENC_FCVTZU_64S_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==1) OK(ENC_FCVTZU_32D_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==1) OK(ENC_FCVTZU_64D_FLOAT2INT);
	}
	return rc;
}

/* fcvt_float.xml */
int FCVT_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|0001|opc=xx|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3E7C00)==0x1E224000) {
		decode_fields32(ENC_FCVT_SH_FLOATDP1, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->ftype==ctx->opc) {
			UNDEFINED;
		}
		if(!ctx->ftype) {
			ctx->srcsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->srcsize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			ctx->srcsize = 0x10;
		}
		if(!ctx->opc) {
			ctx->dstsize = 0x20;
		}
		else if(ctx->opc==1) {
			ctx->dstsize = 0x40;
		}
		else if(ctx->opc==2) {
			UNDEFINED;
		}
		else if(ctx->opc==3) {
			ctx->dstsize = 0x10;
		}
		if(ctx->ftype==3 && ctx->opc==0) OK(ENC_FCVT_SH_FLOATDP1);
		if(ctx->ftype==3 && ctx->opc==1) OK(ENC_FCVT_DH_FLOATDP1);
		if(ctx->ftype==0 && ctx->opc==3) OK(ENC_FCVT_HS_FLOATDP1);
		if(ctx->ftype==0 && ctx->opc==1) OK(ENC_FCVT_DS_FLOATDP1);
		if(ctx->ftype==1 && ctx->opc==3) OK(ENC_FCVT_HD_FLOATDP1);
		if(ctx->ftype==1 && ctx->opc==0) OK(ENC_FCVT_SD_FLOATDP1);
	}
	return rc;
}

/* fdiv_advsimd.xml */
int FDIV_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=1|01110|a=0|10|Rm=xxxxx|00|opcode=111|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2E403C00) {
		decode_fields32(ENC_FDIV_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FDIV_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=1|01110|0|sz=x|1|Rm=xxxxx|opcode=11111|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0x2E20FC00) {
		decode_fields32(ENC_FDIV_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FDIV_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fdiv_float.xml */
int FDIV_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|Rm=xxxxx|opcode=0001|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x1E201800) {
		decode_fields32(ENC_FDIV_H_FLOATDP2, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(ctx->ftype==3) OK(ENC_FDIV_H_FLOATDP2);
		if(ctx->ftype==0) OK(ENC_FDIV_S_FLOATDP2);
		if(ctx->ftype==1) OK(ENC_FDIV_D_FLOATDP2);
	}
	return rc;
}

/* fjcvtzs.xml */
int FJCVTZS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_double_to_32 */
	/* sf=0|0|S=0|11110|ftype=01|1|rmode=11|opcode=110|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x1E7E0000) {
		decode_fields32(ENC_FJCVTZS_32D_FLOAT2INT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)!=13) {
				UNDEFINED;
			}
			ctx->fltsize = 0x80;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)&12)) {
			ctx->rounding = FPDecodeRounding(ctx->rmode);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==8) {
			ctx->rounding = FPRounding_TIEAWAY;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==12) {
			if(ctx->fltsize!=0x10 && ctx->fltsize!=ctx->intsize) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 0;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==13) {
			if(ctx->intsize!=0x40 || ctx->fltsize!=0x80) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 1;
			ctx->fltsize = 0x40;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==15) {
			if(!HaveFJCVTZSExt()) {
				UNDEFINED;
			}
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI_JS;
		}
		else {
			UNDEFINED;
		}
		OK(ENC_FJCVTZS_32D_FLOAT2INT);
	}
	return rc;
}

/* fmadd_float.xml */
int FMADD_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11111|ftype=xx|o1=0|Rm=xxxxx|o0=0|Ra=xxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF208000)==0x1F000000) {
		decode_fields32(ENC_FMADD_H_FLOATDP3, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->a = UINT(ctx->Ra);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->opa_neg = (ctx->o1==1);
		ctx->op1_neg = (ctx->o0!=ctx->o1);
		if(ctx->ftype==3) OK(ENC_FMADD_H_FLOATDP3);
		if(ctx->ftype==0) OK(ENC_FMADD_S_FLOATDP3);
		if(ctx->ftype==1) OK(ENC_FMADD_D_FLOATDP3);
	}
	return rc;
}

/* fmaxnmp_advsimd_pair.xml */
int FMAXNMP_advsimd_pair(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 01|U=0|11110|o1=0|sz=x|11000|opcode=01100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x5E30C800) {
		decode_fields32(ENC_FMAXNMP_ASISDPAIR_ONLY_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		if(ctx->sz==1) {
			UNDEFINED;
		}
		ctx->datasize = (ctx->esize) * (2);
		ctx->elements = 2;
		ctx->op = (ctx->o1==1) ? ReduceOp_FMINNUM : ReduceOp_FMAXNUM;
		OK(ENC_FMAXNMP_ASISDPAIR_ONLY_H);
	}
	/* class iclass_single_and_double */
	/* 01|U=1|11110|o1=0|sz=x|11000|opcode=01100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x7E30C800) {
		decode_fields32(ENC_FMAXNMP_ASISDPAIR_ONLY_SD, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->esize) * (2);
		ctx->elements = 2;
		ctx->op = (ctx->o1==1) ? ReduceOp_FMINNUM : ReduceOp_FMAXNUM;
		OK(ENC_FMAXNMP_ASISDPAIR_ONLY_SD);
	}
	return rc;
}

/* fmaxnmp_advsimd_vec.xml */
int FMAXNMP_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=1|01110|a=0|10|Rm=xxxxx|00|Op3=000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2E400400) {
		decode_fields32(ENC_FMAXNMP_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		ctx->minimum = (ctx->a==1);
		OK(ENC_FMAXNMP_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=1|01110|o1=0|sz=x|1|Rm=xxxxx|opcode=11000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0x2E20C400) {
		decode_fields32(ENC_FMAXNMP_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_FMAXNMP_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fmaxnmv_advsimd.xml */
int FMAXNMV_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|o1=0|0|11000|opcode=01100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xE30C800) {
		decode_fields32(ENC_FMAXNMV_ASIMDALL_ONLY_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->op = (ctx->o1==1) ? ReduceOp_FMINNUM : ReduceOp_FMAXNUM;
		OK(ENC_FMAXNMV_ASIMDALL_ONLY_H);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=1|01110|o1=0|sz=x|11000|opcode=01100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2E30C800) {
		decode_fields32(ENC_FMAXNMV_ASIMDALL_ONLY_SD, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)!=1) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->op = (ctx->o1==1) ? ReduceOp_FMINNUM : ReduceOp_FMAXNUM;
		OK(ENC_FMAXNMV_ASIMDALL_ONLY_SD);
	}
	return rc;
}

/* fmaxnm_advsimd.xml */
int FMAXNM_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|a=0|10|Rm=xxxxx|00|Op3=000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xE400400) {
		decode_fields32(ENC_FMAXNM_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		ctx->minimum = (ctx->a==1);
		OK(ENC_FMAXNM_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=0|01110|o1=0|sz=x|1|Rm=xxxxx|opcode=11000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0xE20C400) {
		decode_fields32(ENC_FMAXNM_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_FMAXNM_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fmaxnm_float.xml */
int FMAXNM_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|Rm=xxxxx|01|op=10|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x1E206800) {
		decode_fields32(ENC_FMAXNM_H_FLOATDP2, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!ctx->op) {
			ctx->operation_ = FPMaxMinOp_MAX;
		}
		else if(ctx->op==1) {
			ctx->operation_ = FPMaxMinOp_MIN;
		}
		else if(ctx->op==2) {
			ctx->operation_ = FPMaxMinOp_MAXNUM;
		}
		else if(ctx->op==3) {
			ctx->operation_ = FPMaxMinOp_MINNUM;
		}
		if(ctx->ftype==3) OK(ENC_FMAXNM_H_FLOATDP2);
		if(ctx->ftype==0) OK(ENC_FMAXNM_S_FLOATDP2);
		if(ctx->ftype==1) OK(ENC_FMAXNM_D_FLOATDP2);
	}
	return rc;
}

/* fmaxp_advsimd_pair.xml */
int FMAXP_advsimd_pair(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 01|U=0|11110|o1=0|sz=x|11000|opcode=01111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x5E30F800) {
		decode_fields32(ENC_FMAXP_ASISDPAIR_ONLY_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		if(ctx->sz==1) {
			UNDEFINED;
		}
		ctx->datasize = (ctx->esize) * (2);
		ctx->elements = 2;
		ctx->op = (ctx->o1==1) ? ReduceOp_FMIN : ReduceOp_FMAX;
		OK(ENC_FMAXP_ASISDPAIR_ONLY_H);
	}
	/* class iclass_single_and_double */
	/* 01|U=1|11110|o1=0|sz=x|11000|opcode=01111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x7E30F800) {
		decode_fields32(ENC_FMAXP_ASISDPAIR_ONLY_SD, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->esize) * (2);
		ctx->elements = 2;
		ctx->op = (ctx->o1==1) ? ReduceOp_FMIN : ReduceOp_FMAX;
		OK(ENC_FMAXP_ASISDPAIR_ONLY_SD);
	}
	return rc;
}

/* fmaxp_advsimd_vec.xml */
int FMAXP_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=1|01110|o1=0|10|Rm=xxxxx|00|opcode=110|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2E403400) {
		decode_fields32(ENC_FMAXP_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_FMAXP_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=1|01110|o1=0|sz=x|1|Rm=xxxxx|opcode=11110|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0x2E20F400) {
		decode_fields32(ENC_FMAXP_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_FMAXP_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fmaxv_advsimd.xml */
int FMAXV_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|o1=0|0|11000|opcode=01111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xE30F800) {
		decode_fields32(ENC_FMAXV_ASIMDALL_ONLY_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->op = (ctx->o1==1) ? ReduceOp_FMIN : ReduceOp_FMAX;
		OK(ENC_FMAXV_ASIMDALL_ONLY_H);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=1|01110|o1=0|sz=x|11000|opcode=01111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2E30F800) {
		decode_fields32(ENC_FMAXV_ASIMDALL_ONLY_SD, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)!=1) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->op = (ctx->o1==1) ? ReduceOp_FMIN : ReduceOp_FMAX;
		OK(ENC_FMAXV_ASIMDALL_ONLY_SD);
	}
	return rc;
}

/* fmax_advsimd.xml */
int FMAX_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|o1=0|10|Rm=xxxxx|00|opcode=110|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xE403400) {
		decode_fields32(ENC_FMAX_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_FMAX_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=0|01110|o1=0|sz=x|1|Rm=xxxxx|opcode=11110|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0xE20F400) {
		decode_fields32(ENC_FMAX_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_FMAX_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fmax_float.xml */
int FMAX_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|Rm=xxxxx|01|op=00|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x1E204800) {
		decode_fields32(ENC_FMAX_H_FLOATDP2, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!ctx->op) {
			ctx->operation_ = FPMaxMinOp_MAX;
		}
		else if(ctx->op==1) {
			ctx->operation_ = FPMaxMinOp_MIN;
		}
		else if(ctx->op==2) {
			ctx->operation_ = FPMaxMinOp_MAXNUM;
		}
		else if(ctx->op==3) {
			ctx->operation_ = FPMaxMinOp_MINNUM;
		}
		if(ctx->ftype==3) OK(ENC_FMAX_H_FLOATDP2);
		if(ctx->ftype==0) OK(ENC_FMAX_S_FLOATDP2);
		if(ctx->ftype==1) OK(ENC_FMAX_D_FLOATDP2);
	}
	return rc;
}

/* fminnmp_advsimd_pair.xml */
int FMINNMP_advsimd_pair(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 01|U=0|11110|o1=1|sz=x|11000|opcode=01100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x5EB0C800) {
		decode_fields32(ENC_FMINNMP_ASISDPAIR_ONLY_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		if(ctx->sz==1) {
			UNDEFINED;
		}
		ctx->datasize = (ctx->esize) * (2);
		ctx->elements = 2;
		ctx->op = (ctx->o1==1) ? ReduceOp_FMINNUM : ReduceOp_FMAXNUM;
		OK(ENC_FMINNMP_ASISDPAIR_ONLY_H);
	}
	/* class iclass_single_and_double */
	/* 01|U=1|11110|o1=1|sz=x|11000|opcode=01100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x7EB0C800) {
		decode_fields32(ENC_FMINNMP_ASISDPAIR_ONLY_SD, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->esize) * (2);
		ctx->elements = 2;
		ctx->op = (ctx->o1==1) ? ReduceOp_FMINNUM : ReduceOp_FMAXNUM;
		OK(ENC_FMINNMP_ASISDPAIR_ONLY_SD);
	}
	return rc;
}

/* fminnmp_advsimd_vec.xml */
int FMINNMP_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=1|01110|a=1|10|Rm=xxxxx|00|Op3=000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2EC00400) {
		decode_fields32(ENC_FMINNMP_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		ctx->minimum = (ctx->a==1);
		OK(ENC_FMINNMP_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=1|01110|o1=1|sz=x|1|Rm=xxxxx|opcode=11000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0x2EA0C400) {
		decode_fields32(ENC_FMINNMP_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_FMINNMP_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fminnmv_advsimd.xml */
int FMINNMV_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|o1=1|0|11000|opcode=01100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xEB0C800) {
		decode_fields32(ENC_FMINNMV_ASIMDALL_ONLY_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->op = (ctx->o1==1) ? ReduceOp_FMINNUM : ReduceOp_FMAXNUM;
		OK(ENC_FMINNMV_ASIMDALL_ONLY_H);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=1|01110|o1=1|sz=x|11000|opcode=01100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2EB0C800) {
		decode_fields32(ENC_FMINNMV_ASIMDALL_ONLY_SD, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)!=1) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->op = (ctx->o1==1) ? ReduceOp_FMINNUM : ReduceOp_FMAXNUM;
		OK(ENC_FMINNMV_ASIMDALL_ONLY_SD);
	}
	return rc;
}

/* fminnm_advsimd.xml */
int FMINNM_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|a=1|10|Rm=xxxxx|00|Op3=000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xEC00400) {
		decode_fields32(ENC_FMINNM_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		ctx->minimum = (ctx->a==1);
		OK(ENC_FMINNM_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=0|01110|o1=1|sz=x|1|Rm=xxxxx|opcode=11000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0xEA0C400) {
		decode_fields32(ENC_FMINNM_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_FMINNM_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fminnm_float.xml */
int FMINNM_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|Rm=xxxxx|01|op=11|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x1E207800) {
		decode_fields32(ENC_FMINNM_H_FLOATDP2, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!ctx->op) {
			ctx->operation_ = FPMaxMinOp_MAX;
		}
		else if(ctx->op==1) {
			ctx->operation_ = FPMaxMinOp_MIN;
		}
		else if(ctx->op==2) {
			ctx->operation_ = FPMaxMinOp_MAXNUM;
		}
		else if(ctx->op==3) {
			ctx->operation_ = FPMaxMinOp_MINNUM;
		}
		if(ctx->ftype==3) OK(ENC_FMINNM_H_FLOATDP2);
		if(ctx->ftype==0) OK(ENC_FMINNM_S_FLOATDP2);
		if(ctx->ftype==1) OK(ENC_FMINNM_D_FLOATDP2);
	}
	return rc;
}

/* fminp_advsimd_pair.xml */
int FMINP_advsimd_pair(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 01|U=0|11110|o1=1|sz=x|11000|opcode=01111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x5EB0F800) {
		decode_fields32(ENC_FMINP_ASISDPAIR_ONLY_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		if(ctx->sz==1) {
			UNDEFINED;
		}
		ctx->datasize = (ctx->esize) * (2);
		ctx->elements = 2;
		ctx->op = (ctx->o1==1) ? ReduceOp_FMIN : ReduceOp_FMAX;
		OK(ENC_FMINP_ASISDPAIR_ONLY_H);
	}
	/* class iclass_single_and_double */
	/* 01|U=1|11110|o1=1|sz=x|11000|opcode=01111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x7EB0F800) {
		decode_fields32(ENC_FMINP_ASISDPAIR_ONLY_SD, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->esize) * (2);
		ctx->elements = 2;
		ctx->op = (ctx->o1==1) ? ReduceOp_FMIN : ReduceOp_FMAX;
		OK(ENC_FMINP_ASISDPAIR_ONLY_SD);
	}
	return rc;
}

/* fminp_advsimd_vec.xml */
int FMINP_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=1|01110|o1=1|10|Rm=xxxxx|00|opcode=110|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2EC03400) {
		decode_fields32(ENC_FMINP_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_FMINP_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=1|01110|o1=1|sz=x|1|Rm=xxxxx|opcode=11110|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0x2EA0F400) {
		decode_fields32(ENC_FMINP_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_FMINP_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fminv_advsimd.xml */
int FMINV_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|o1=1|0|11000|opcode=01111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xEB0F800) {
		decode_fields32(ENC_FMINV_ASIMDALL_ONLY_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->op = (ctx->o1==1) ? ReduceOp_FMIN : ReduceOp_FMAX;
		OK(ENC_FMINV_ASIMDALL_ONLY_H);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=1|01110|o1=1|sz=x|11000|opcode=01111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2EB0F800) {
		decode_fields32(ENC_FMINV_ASIMDALL_ONLY_SD, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)!=1) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->op = (ctx->o1==1) ? ReduceOp_FMIN : ReduceOp_FMAX;
		OK(ENC_FMINV_ASIMDALL_ONLY_SD);
	}
	return rc;
}

/* fmin_advsimd.xml */
int FMIN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|o1=1|10|Rm=xxxxx|00|opcode=110|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xEC03400) {
		decode_fields32(ENC_FMIN_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_FMIN_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=0|01110|o1=1|sz=x|1|Rm=xxxxx|opcode=11110|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0xEA0F400) {
		decode_fields32(ENC_FMIN_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->pair = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_FMIN_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fmin_float.xml */
int FMIN_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|Rm=xxxxx|01|op=01|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x1E205800) {
		decode_fields32(ENC_FMIN_H_FLOATDP2, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!ctx->op) {
			ctx->operation_ = FPMaxMinOp_MAX;
		}
		else if(ctx->op==1) {
			ctx->operation_ = FPMaxMinOp_MIN;
		}
		else if(ctx->op==2) {
			ctx->operation_ = FPMaxMinOp_MAXNUM;
		}
		else if(ctx->op==3) {
			ctx->operation_ = FPMaxMinOp_MINNUM;
		}
		if(ctx->ftype==3) OK(ENC_FMIN_H_FLOATDP2);
		if(ctx->ftype==0) OK(ENC_FMIN_S_FLOATDP2);
		if(ctx->ftype==1) OK(ENC_FMIN_D_FLOATDP2);
	}
	return rc;
}

/* fmlal_advsimd_elt.xml */
int FMLAL_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_fmlal */
	/* 0|Q=x|U=0|01111|size[1]=1|sz=0|L=x|M=x|Rm=xxxx|opcode[3]=0|S=0|opcode[1:0]=00|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFC0F400)==0xF800000) {
		decode_fields32(ENC_FMLAL_ASIMDELEM_LH, ctx, instr);
		if(!HaveFP16MulNoRoundingToFP32Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->sz==1) {
			UNDEFINED;
		}
		ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
		ctx->esize = 0x20;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->S==1);
		ctx->part = 0;
		OK(ENC_FMLAL_ASIMDELEM_LH);
	}
	/* class iclass_fmlal2 */
	/* 0|Q=x|U=1|01111|size[1]=1|sz=0|L=x|M=x|Rm=xxxx|opcode[3]=1|S=0|opcode[1:0]=00|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFC0F400)==0x2F808000) {
		decode_fields32(ENC_FMLAL2_ASIMDELEM_LH, ctx, instr);
		if(!HaveFP16MulNoRoundingToFP32Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->sz==1) {
			UNDEFINED;
		}
		ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
		ctx->esize = 0x20;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->S==1);
		ctx->part = 1;
		OK(ENC_FMLAL2_ASIMDELEM_LH);
	}
	return rc;
}

/* fmlal_advsimd_vec.xml */
int FMLAL_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_fmlal */
	/* 0|Q=x|U=0|01110|S=0|sz=0|1|Rm=xxxxx|opcode[4]=1|opcode[3:0]=1101|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xE20EC00) {
		decode_fields32(ENC_FMLAL_ASIMDSAME_F, ctx, instr);
		if(!HaveFP16MulNoRoundingToFP32Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->sz==1) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->S==1);
		ctx->part = 0;
		OK(ENC_FMLAL_ASIMDSAME_F);
	}
	/* class iclass_fmlal2 */
	/* 0|Q=x|U=1|01110|S=0|sz=0|1|Rm=xxxxx|opcode[4]=1|opcode[3:0]=1001|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2E20CC00) {
		decode_fields32(ENC_FMLAL2_ASIMDSAME_F, ctx, instr);
		if(!HaveFP16MulNoRoundingToFP32Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->sz==1) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->S==1);
		ctx->part = 1;
		OK(ENC_FMLAL2_ASIMDSAME_F);
	}
	return rc;
}

/* fmla_advsimd_elt.xml */
int FMLA_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_scalar_half */
	/* 01|U=0|11111|size=00|L=x|M=x|Rm=xxxx|0|o2=0|01|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFC0F400)==0x5F001000) {
		decode_fields32(ENC_FMLA_ASISDELEM_RH_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->d = UINT(ctx->Rd);
		ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_FMLA_ASISDELEM_RH_H);
	}
	/* class iclass_2reg_scalar_single_and_double */
	/* 01|U=0|11111|1|sz=x|L=x|M=x|Rm=xxxx|0|o2=0|01|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80F400)==0x5F801000) {
		decode_fields32(ENC_FMLA_ASISDELEM_R_SD, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		ctx->Rmhi = ctx->M;
		if(!(((ctx->sz<<1)|ctx->L)&2)) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
		}
		else if(((ctx->sz<<1)|ctx->L)==2) {
			ctx->index = UINT(ctx->H);
		}
		else if(((ctx->sz<<1)|ctx->L)==3) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_FMLA_ASISDELEM_R_SD);
	}
	/* class iclass_2reg_element_half */
	/* 0|Q=x|U=0|01111|size=00|L=x|M=x|Rm=xxxx|0|o2=0|01|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFC0F400)==0xF001000) {
		decode_fields32(ENC_FMLA_ASIMDELEM_RH_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->d = UINT(ctx->Rd);
		ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_FMLA_ASIMDELEM_RH_H);
	}
	/* class iclass_2reg_element_single_and_double */
	/* 0|Q=x|U=0|01111|1|sz=x|L=x|M=x|Rm=xxxx|0|o2=0|01|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80F400)==0xF801000) {
		decode_fields32(ENC_FMLA_ASIMDELEM_R_SD, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		ctx->Rmhi = ctx->M;
		if(!(((ctx->sz<<1)|ctx->L)&2)) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
		}
		else if(((ctx->sz<<1)|ctx->L)==2) {
			ctx->index = UINT(ctx->H);
		}
		else if(((ctx->sz<<1)|ctx->L)==3) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_FMLA_ASIMDELEM_R_SD);
	}
	return rc;
}

/* fmla_advsimd_vec.xml */
int FMLA_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|a=0|10|Rm=xxxxx|00|opcode=001|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xE400C00) {
		decode_fields32(ENC_FMLA_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->a==1);
		OK(ENC_FMLA_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=0|01110|op=0|sz=x|1|Rm=xxxxx|opcode=11001|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0xE20CC00) {
		decode_fields32(ENC_FMLA_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->op==1);
		OK(ENC_FMLA_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fmlsl_advsimd_elt.xml */
int FMLSL_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_fmlsl */
	/* 0|Q=x|U=0|01111|size[1]=1|sz=0|L=x|M=x|Rm=xxxx|opcode[3]=0|S=1|opcode[1:0]=00|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFC0F400)==0xF804000) {
		decode_fields32(ENC_FMLSL_ASIMDELEM_LH, ctx, instr);
		if(!HaveFP16MulNoRoundingToFP32Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->sz==1) {
			UNDEFINED;
		}
		ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
		ctx->esize = 0x20;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->S==1);
		ctx->part = 0;
		OK(ENC_FMLSL_ASIMDELEM_LH);
	}
	/* class iclass_fmlsl2 */
	/* 0|Q=x|U=1|01111|size[1]=1|sz=0|L=x|M=x|Rm=xxxx|opcode[3]=1|S=1|opcode[1:0]=00|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFC0F400)==0x2F80C000) {
		decode_fields32(ENC_FMLSL2_ASIMDELEM_LH, ctx, instr);
		if(!HaveFP16MulNoRoundingToFP32Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->sz==1) {
			UNDEFINED;
		}
		ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
		ctx->esize = 0x20;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->S==1);
		ctx->part = 1;
		OK(ENC_FMLSL2_ASIMDELEM_LH);
	}
	return rc;
}

/* fmlsl_advsimd_vec.xml */
int FMLSL_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_fmlsl */
	/* 0|Q=x|U=0|01110|S=1|sz=0|1|Rm=xxxxx|opcode[4]=1|opcode[3:0]=1101|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xEA0EC00) {
		decode_fields32(ENC_FMLSL_ASIMDSAME_F, ctx, instr);
		if(!HaveFP16MulNoRoundingToFP32Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->sz==1) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->S==1);
		ctx->part = 0;
		OK(ENC_FMLSL_ASIMDSAME_F);
	}
	/* class iclass_fmlsl2 */
	/* 0|Q=x|U=1|01110|S=1|sz=0|1|Rm=xxxxx|opcode[4]=1|opcode[3:0]=1001|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2EA0CC00) {
		decode_fields32(ENC_FMLSL2_ASIMDSAME_F, ctx, instr);
		if(!HaveFP16MulNoRoundingToFP32Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->sz==1) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->S==1);
		ctx->part = 1;
		OK(ENC_FMLSL2_ASIMDSAME_F);
	}
	return rc;
}

/* fmls_advsimd_elt.xml */
int FMLS_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_scalar_half */
	/* 01|U=0|11111|size=00|L=x|M=x|Rm=xxxx|0|o2=1|01|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFC0F400)==0x5F005000) {
		decode_fields32(ENC_FMLS_ASISDELEM_RH_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->d = UINT(ctx->Rd);
		ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_FMLS_ASISDELEM_RH_H);
	}
	/* class iclass_2reg_scalar_single_and_double */
	/* 01|U=0|11111|1|sz=x|L=x|M=x|Rm=xxxx|0|o2=1|01|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80F400)==0x5F805000) {
		decode_fields32(ENC_FMLS_ASISDELEM_R_SD, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		ctx->Rmhi = ctx->M;
		if(!(((ctx->sz<<1)|ctx->L)&2)) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
		}
		else if(((ctx->sz<<1)|ctx->L)==2) {
			ctx->index = UINT(ctx->H);
		}
		else if(((ctx->sz<<1)|ctx->L)==3) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_FMLS_ASISDELEM_R_SD);
	}
	/* class iclass_2reg_element_half */
	/* 0|Q=x|U=0|01111|size=00|L=x|M=x|Rm=xxxx|0|o2=1|01|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFC0F400)==0xF005000) {
		decode_fields32(ENC_FMLS_ASIMDELEM_RH_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->d = UINT(ctx->Rd);
		ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_FMLS_ASIMDELEM_RH_H);
	}
	/* class iclass_2reg_element_single_and_double */
	/* 0|Q=x|U=0|01111|1|sz=x|L=x|M=x|Rm=xxxx|0|o2=1|01|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80F400)==0xF805000) {
		decode_fields32(ENC_FMLS_ASIMDELEM_R_SD, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		ctx->Rmhi = ctx->M;
		if(!(((ctx->sz<<1)|ctx->L)&2)) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
		}
		else if(((ctx->sz<<1)|ctx->L)==2) {
			ctx->index = UINT(ctx->H);
		}
		else if(((ctx->sz<<1)|ctx->L)==3) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_FMLS_ASIMDELEM_R_SD);
	}
	return rc;
}

/* fmls_advsimd_vec.xml */
int FMLS_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|a=1|10|Rm=xxxxx|00|opcode=001|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xEC00C00) {
		decode_fields32(ENC_FMLS_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->a==1);
		OK(ENC_FMLS_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=0|01110|op=1|sz=x|1|Rm=xxxxx|opcode=11001|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0xEA0CC00) {
		decode_fields32(ENC_FMLS_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->op==1);
		OK(ENC_FMLS_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fmov_advsimd.xml */
int FMOV_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_per_half */
	/* 0|Q=x|op=0|0111100000|a=x|b=x|c=x|cmode=1111|o2=1|1|d=x|e=x|f=x|g=x|h=x|Rd=xxxxx */
	if((INSWORD & 0xBFF8FC00)==0xF00FC00) {
		decode_fields32(ENC_FMOV_ASIMDIMM_H_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->rd = UINT(ctx->Rd);
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->imm8 = ((ctx->a<<7)|(ctx->b<<6)|(ctx->c<<5)|(ctx->d<<4)|(ctx->e<<3)|(ctx->f<<2)|(ctx->g<<1)|ctx->h);
		ctx->imm16 = ((SLICE(ctx->imm8,7,7)<<15)|(NOT(SLICE(ctx->imm8,6,6),1)<<14)|(Replicate(SLICE(ctx->imm8,6,6), 2, 1)<<12)|(SLICE(ctx->imm8,5,0)<<6)|0);
		ctx->imm = Replicate(ctx->imm16, ((0x10) ? ((ctx->datasize) / (0x10)) : 0), 16);
		OK(ENC_FMOV_ASIMDIMM_H_H);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|op=x|0111100000|a=x|b=x|c=x|cmode=1111|o2=0|1|d=x|e=x|f=x|g=x|h=x|Rd=xxxxx */
	if((INSWORD & 0x9FF8FC00)==0xF00F400) {
		decode_fields32(ENC_FMOV_ASIMDIMM_S_S, ctx, instr);
		ctx->rd = UINT(ctx->Rd);
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		if(!(((ctx->cmode<<1)|ctx->op)&0x13)) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x13)==1) {
			ctx->operation_ = ImmediateOp_MVNI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x13)==2) {
			ctx->operation_ = ImmediateOp_ORR;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x13)==3) {
			ctx->operation_ = ImmediateOp_BIC;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x10) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x11) {
			ctx->operation_ = ImmediateOp_MVNI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x12) {
			ctx->operation_ = ImmediateOp_ORR;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x13) {
			ctx->operation_ = ImmediateOp_BIC;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1d)==0x18) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1d)==0x19) {
			ctx->operation_ = ImmediateOp_MVNI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1e)==0x1c) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if(((ctx->cmode<<1)|ctx->op)==0x1e) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if(((ctx->cmode<<1)|ctx->op)==0x1f) {
			if(ctx->Q==0) {
				UNDEFINED;
			}
			ctx->operation_ = ImmediateOp_MOVI;
		}
		ctx->imm64 = AdvSIMDExpandImm(ctx->op,ctx->cmode,((ctx->a<<7)|(ctx->b<<6)|(ctx->c<<5)|(ctx->d<<4)|(ctx->e<<3)|(ctx->f<<2)|(ctx->g<<1)|ctx->h));
		ctx->imm = Replicate(ctx->imm64, ((0x40) ? ((ctx->datasize) / (0x40)) : 0), 64);
		if(ctx->op==0) OK(ENC_FMOV_ASIMDIMM_S_S);
		if(ctx->Q==1 && ctx->op==1) OK(ENC_FMOV_ASIMDIMM_D2_D);
	}
	return rc;
}

/* fmov_cpy_z_p_i.xml */
int FMOV_cpy_z_p_i(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|01|Pg=xxxx|0|M=1|sh=0|imm8=00000000|Zd=xxxxx */
	if((INSWORD & 0xFF30FFE0)==0x5104000) {
		decode_fields32(ENC_FMOV_CPY_Z_P_I_, ctx, instr);
		OK(ENC_FMOV_CPY_Z_P_I_);
	}
	return rc;
}

/* fmov_dup_z_i.xml */
int FMOV_dup_z_i(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00100101|size=xx|111|opc=00|011|sh=0|imm8=00000000|Zd=xxxxx */
	if((INSWORD & 0xFF3FFFE0)==0x2538C000) {
		decode_fields32(ENC_FMOV_DUP_Z_I_, ctx, instr);
		OK(ENC_FMOV_DUP_Z_I_);
	}
	return rc;
}

/* fmov_fcpy_z_p_i.xml */
int FMOV_fcpy_z_p_i(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|01|Pg=xxxx|110|imm8=xxxxxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF30E000)==0x510C000) {
		decode_fields32(ENC_FMOV_FCPY_Z_P_I_, ctx, instr);
		OK(ENC_FMOV_FCPY_Z_P_I_);
	}
	return rc;
}

/* fmov_fdup_z_i.xml */
int FMOV_fdup_z_i(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00100101|size=xx|111|opc=00|111|o2=0|imm8=xxxxxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x2539C000) {
		decode_fields32(ENC_FMOV_FDUP_Z_I_, ctx, instr);
		OK(ENC_FMOV_FDUP_Z_I_);
	}
	return rc;
}

/* fmov_float.xml */
int FMOV_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|0000|opc=00|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x1E204000) {
		decode_fields32(ENC_FMOV_H_FLOATDP1, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!ctx->opc) {
			ctx->fpop = FPUnaryOp_MOV;
		}
		else if(ctx->opc==1) {
			ctx->fpop = FPUnaryOp_ABS;
		}
		else if(ctx->opc==2) {
			ctx->fpop = FPUnaryOp_NEG;
		}
		else if(ctx->opc==3) {
			ctx->fpop = FPUnaryOp_SQRT;
		}
		if(ctx->ftype==3) OK(ENC_FMOV_H_FLOATDP1);
		if(ctx->ftype==0) OK(ENC_FMOV_S_FLOATDP1);
		if(ctx->ftype==1) OK(ENC_FMOV_D_FLOATDP1);
	}
	return rc;
}

/* fmov_float_gen.xml */
int FMOV_float_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|1|rmode=0x|opcode=11x|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F36FC00)==0x1E260000) {
		decode_fields32(ENC_FMOV_32H_FLOAT2INT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)!=13) {
				UNDEFINED;
			}
			ctx->fltsize = 0x80;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)&12)) {
			ctx->rounding = FPDecodeRounding(ctx->rmode);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==8) {
			ctx->rounding = FPRounding_TIEAWAY;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==12) {
			if(ctx->fltsize!=0x10 && ctx->fltsize!=ctx->intsize) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 0;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==13) {
			if(ctx->intsize!=0x40 || ctx->fltsize!=0x80) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 1;
			ctx->fltsize = 0x40;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==15) {
			if(!HaveFJCVTZSExt()) {
				UNDEFINED;
			}
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI_JS;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3 && ctx->rmode==0 && ctx->opcode==6) OK(ENC_FMOV_32H_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==3 && ctx->rmode==0 && ctx->opcode==6) OK(ENC_FMOV_64H_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==3 && ctx->rmode==0 && ctx->opcode==7) OK(ENC_FMOV_H32_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==0 && ctx->rmode==0 && ctx->opcode==7) OK(ENC_FMOV_S32_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==0 && ctx->rmode==0 && ctx->opcode==6) OK(ENC_FMOV_32S_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==3 && ctx->rmode==0 && ctx->opcode==7) OK(ENC_FMOV_H64_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==1 && ctx->rmode==0 && ctx->opcode==7) OK(ENC_FMOV_D64_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==2 && ctx->rmode==1 && ctx->opcode==7) OK(ENC_FMOV_V64I_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==1 && ctx->rmode==0 && ctx->opcode==6) OK(ENC_FMOV_64D_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==2 && ctx->rmode==1 && ctx->opcode==6) OK(ENC_FMOV_64VX_FLOAT2INT);
	}
	return rc;
}

/* fmov_float_imm.xml */
int FMOV_float_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_imm8f */
	/* M=0|0|S=0|11110|ftype=xx|1|imm8=xxxxxxxx|100|imm5=00000|Rd=xxxxx */
	if((INSWORD & 0xFF201FE0)==0x1E201000) {
		decode_fields32(ENC_FMOV_H_FLOATIMM, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		if(!ctx->ftype) {
			ctx->datasize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->datasize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->datasize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->imm = VFPExpandImm(ctx->imm8,8);
		if(ctx->ftype==3) OK(ENC_FMOV_H_FLOATIMM);
		if(ctx->ftype==0) OK(ENC_FMOV_S_FLOATIMM);
		if(ctx->ftype==1) OK(ENC_FMOV_D_FLOATIMM);
	}
	return rc;
}

/* fmsub_float.xml */
int FMSUB_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11111|ftype=xx|o1=0|Rm=xxxxx|o0=1|Ra=xxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF208000)==0x1F008000) {
		decode_fields32(ENC_FMSUB_H_FLOATDP3, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->a = UINT(ctx->Ra);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->opa_neg = (ctx->o1==1);
		ctx->op1_neg = (ctx->o0!=ctx->o1);
		if(ctx->ftype==3) OK(ENC_FMSUB_H_FLOATDP3);
		if(ctx->ftype==0) OK(ENC_FMSUB_S_FLOATDP3);
		if(ctx->ftype==1) OK(ENC_FMSUB_D_FLOATDP3);
	}
	return rc;
}

/* fmulx_advsimd_elt.xml */
int FMULX_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_scalar_half */
	/* 01|U=1|11111|size=00|L=x|M=x|Rm=xxxx|opcode=1001|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFC0F400)==0x7F009000) {
		decode_fields32(ENC_FMULX_ASISDELEM_RH_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->d = UINT(ctx->Rd);
		ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->mulx_op = (ctx->U==1);
		OK(ENC_FMULX_ASISDELEM_RH_H);
	}
	/* class iclass_2reg_scalar_single_and_double */
	/* 01|U=1|11111|1|sz=x|L=x|M=x|Rm=xxxx|opcode=1001|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80F400)==0x7F809000) {
		decode_fields32(ENC_FMULX_ASISDELEM_R_SD, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		ctx->Rmhi = ctx->M;
		if(!(((ctx->sz<<1)|ctx->L)&2)) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
		}
		else if(((ctx->sz<<1)|ctx->L)==2) {
			ctx->index = UINT(ctx->H);
		}
		else if(((ctx->sz<<1)|ctx->L)==3) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->mulx_op = (ctx->U==1);
		OK(ENC_FMULX_ASISDELEM_R_SD);
	}
	/* class iclass_2reg_element_half */
	/* 0|Q=x|U=1|01111|size=00|L=x|M=x|Rm=xxxx|opcode=1001|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFC0F400)==0x2F009000) {
		decode_fields32(ENC_FMULX_ASIMDELEM_RH_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->d = UINT(ctx->Rd);
		ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->mulx_op = (ctx->U==1);
		OK(ENC_FMULX_ASIMDELEM_RH_H);
	}
	/* class iclass_2reg_element_single_and_double */
	/* 0|Q=x|U=1|01111|1|sz=x|L=x|M=x|Rm=xxxx|opcode=1001|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80F400)==0x2F809000) {
		decode_fields32(ENC_FMULX_ASIMDELEM_R_SD, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		ctx->Rmhi = ctx->M;
		if(!(((ctx->sz<<1)|ctx->L)&2)) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
		}
		else if(((ctx->sz<<1)|ctx->L)==2) {
			ctx->index = UINT(ctx->H);
		}
		else if(((ctx->sz<<1)|ctx->L)==3) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->mulx_op = (ctx->U==1);
		OK(ENC_FMULX_ASIMDELEM_R_SD);
	}
	return rc;
}

/* fmulx_advsimd_vec.xml */
int FMULX_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=0|11110|a=0|10|Rm=xxxxx|00|opcode=011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x5E401C00) {
		decode_fields32(ENC_FMULX_ASISDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		OK(ENC_FMULX_ASISDSAMEFP16_ONLY);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=0|11110|0|sz=x|1|Rm=xxxxx|opcode=11011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFA0FC00)==0x5E20DC00) {
		decode_fields32(ENC_FMULX_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		OK(ENC_FMULX_ASISDSAME_ONLY);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=0|01110|a=0|10|Rm=xxxxx|00|opcode=011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xE401C00) {
		decode_fields32(ENC_FMULX_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FMULX_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|0|sz=x|1|Rm=xxxxx|opcode=11011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0xE20DC00) {
		decode_fields32(ENC_FMULX_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FMULX_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fmul_advsimd_elt.xml */
int FMUL_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_scalar_half */
	/* 01|U=0|11111|size=00|L=x|M=x|Rm=xxxx|opcode=1001|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFC0F400)==0x5F009000) {
		decode_fields32(ENC_FMUL_ASISDELEM_RH_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->d = UINT(ctx->Rd);
		ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->mulx_op = (ctx->U==1);
		OK(ENC_FMUL_ASISDELEM_RH_H);
	}
	/* class iclass_2reg_scalar_single_and_double */
	/* 01|U=0|11111|1|sz=x|L=x|M=x|Rm=xxxx|opcode=1001|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80F400)==0x5F809000) {
		decode_fields32(ENC_FMUL_ASISDELEM_R_SD, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		ctx->Rmhi = ctx->M;
		if(!(((ctx->sz<<1)|ctx->L)&2)) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
		}
		else if(((ctx->sz<<1)|ctx->L)==2) {
			ctx->index = UINT(ctx->H);
		}
		else if(((ctx->sz<<1)|ctx->L)==3) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->mulx_op = (ctx->U==1);
		OK(ENC_FMUL_ASISDELEM_R_SD);
	}
	/* class iclass_2reg_element_half */
	/* 0|Q=x|U=0|01111|size=00|L=x|M=x|Rm=xxxx|opcode=1001|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFC0F400)==0xF009000) {
		decode_fields32(ENC_FMUL_ASIMDELEM_RH_H, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->d = UINT(ctx->Rd);
		ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->mulx_op = (ctx->U==1);
		OK(ENC_FMUL_ASIMDELEM_RH_H);
	}
	/* class iclass_2reg_element_single_and_double */
	/* 0|Q=x|U=0|01111|1|sz=x|L=x|M=x|Rm=xxxx|opcode=1001|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80F400)==0xF809000) {
		decode_fields32(ENC_FMUL_ASIMDELEM_R_SD, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		ctx->Rmhi = ctx->M;
		if(!(((ctx->sz<<1)|ctx->L)&2)) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
		}
		else if(((ctx->sz<<1)|ctx->L)==2) {
			ctx->index = UINT(ctx->H);
		}
		else if(((ctx->sz<<1)|ctx->L)==3) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->mulx_op = (ctx->U==1);
		OK(ENC_FMUL_ASIMDELEM_R_SD);
	}
	return rc;
}

/* fmul_advsimd_vec.xml */
int FMUL_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=1|01110|a=0|10|Rm=xxxxx|00|opcode=011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0x2E401C00) {
		decode_fields32(ENC_FMUL_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FMUL_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=1|01110|0|sz=x|1|Rm=xxxxx|opcode=11011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0x2E20DC00) {
		decode_fields32(ENC_FMUL_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FMUL_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fmul_float.xml */
int FMUL_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|Rm=xxxxx|op=0|000|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x1E200800) {
		decode_fields32(ENC_FMUL_H_FLOATDP2, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->negated = (ctx->op==1);
		if(ctx->ftype==3) OK(ENC_FMUL_H_FLOATDP2);
		if(ctx->ftype==0) OK(ENC_FMUL_S_FLOATDP2);
		if(ctx->ftype==1) OK(ENC_FMUL_D_FLOATDP2);
	}
	return rc;
}

/* fneg_advsimd.xml */
int FNEG_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=1|01110|a=1|111100|opcode=01111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2EF8F800) {
		decode_fields32(ENC_FNEG_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->neg = (ctx->U==1);
		OK(ENC_FNEG_ASIMDMISCFP16_R);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=1|01110|1|sz=x|10000|opcode=01111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2EA0F800) {
		decode_fields32(ENC_FNEG_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->neg = (ctx->U==1);
		OK(ENC_FNEG_ASIMDMISC_R);
	}
	return rc;
}

/* fneg_float.xml */
int FNEG_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|0000|opc=10|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x1E214000) {
		decode_fields32(ENC_FNEG_H_FLOATDP1, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!ctx->opc) {
			ctx->fpop = FPUnaryOp_MOV;
		}
		else if(ctx->opc==1) {
			ctx->fpop = FPUnaryOp_ABS;
		}
		else if(ctx->opc==2) {
			ctx->fpop = FPUnaryOp_NEG;
		}
		else if(ctx->opc==3) {
			ctx->fpop = FPUnaryOp_SQRT;
		}
		if(ctx->ftype==3) OK(ENC_FNEG_H_FLOATDP1);
		if(ctx->ftype==0) OK(ENC_FNEG_S_FLOATDP1);
		if(ctx->ftype==1) OK(ENC_FNEG_D_FLOATDP1);
	}
	return rc;
}

/* fnmadd_float.xml */
int FNMADD_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11111|ftype=xx|o1=1|Rm=xxxxx|o0=0|Ra=xxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF208000)==0x1F200000) {
		decode_fields32(ENC_FNMADD_H_FLOATDP3, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->a = UINT(ctx->Ra);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->opa_neg = (ctx->o1==1);
		ctx->op1_neg = (ctx->o0!=ctx->o1);
		if(ctx->ftype==3) OK(ENC_FNMADD_H_FLOATDP3);
		if(ctx->ftype==0) OK(ENC_FNMADD_S_FLOATDP3);
		if(ctx->ftype==1) OK(ENC_FNMADD_D_FLOATDP3);
	}
	return rc;
}

/* fnmsub_float.xml */
int FNMSUB_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11111|ftype=xx|o1=1|Rm=xxxxx|o0=1|Ra=xxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF208000)==0x1F208000) {
		decode_fields32(ENC_FNMSUB_H_FLOATDP3, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->a = UINT(ctx->Ra);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->opa_neg = (ctx->o1==1);
		ctx->op1_neg = (ctx->o0!=ctx->o1);
		if(ctx->ftype==3) OK(ENC_FNMSUB_H_FLOATDP3);
		if(ctx->ftype==0) OK(ENC_FNMSUB_S_FLOATDP3);
		if(ctx->ftype==1) OK(ENC_FNMSUB_D_FLOATDP3);
	}
	return rc;
}

/* fnmul_float.xml */
int FNMUL_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|Rm=xxxxx|op=1|000|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x1E208800) {
		decode_fields32(ENC_FNMUL_H_FLOATDP2, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->negated = (ctx->op==1);
		if(ctx->ftype==3) OK(ENC_FNMUL_H_FLOATDP2);
		if(ctx->ftype==0) OK(ENC_FNMUL_S_FLOATDP2);
		if(ctx->ftype==1) OK(ENC_FNMUL_D_FLOATDP2);
	}
	return rc;
}

/* frecpe_advsimd.xml */
int FRECPE_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=0|11110|size<1>=1|111100|opcode=11101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x5EF9D800) {
		decode_fields32(ENC_FRECPE_ASISDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		OK(ENC_FRECPE_ASISDMISCFP16_R);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=0|11110|1|sz=x|10000|opcode=11101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x5EA1D800) {
		decode_fields32(ENC_FRECPE_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		OK(ENC_FRECPE_ASISDMISC_R);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=0|01110|a=1|111100|opcode=11101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xEF9D800) {
		decode_fields32(ENC_FRECPE_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FRECPE_ASIMDMISCFP16_R);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|1|sz=x|10000|opcode=11101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xEA1D800) {
		decode_fields32(ENC_FRECPE_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FRECPE_ASIMDMISC_R);
	}
	return rc;
}

/* frecps_advsimd.xml */
int FRECPS_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=0|11110|a=0|10|Rm=xxxxx|00|opcode=111|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x5E403C00) {
		decode_fields32(ENC_FRECPS_ASISDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		OK(ENC_FRECPS_ASISDSAMEFP16_ONLY);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=0|11110|0|sz=x|1|Rm=xxxxx|opcode=11111|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFA0FC00)==0x5E20FC00) {
		decode_fields32(ENC_FRECPS_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		OK(ENC_FRECPS_ASISDSAME_ONLY);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=0|01110|a=0|10|Rm=xxxxx|00|opcode=111|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xE403C00) {
		decode_fields32(ENC_FRECPS_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FRECPS_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|0|sz=x|1|Rm=xxxxx|opcode=11111|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0xE20FC00) {
		decode_fields32(ENC_FRECPS_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FRECPS_ASIMDSAME_ONLY);
	}
	return rc;
}

/* frecpx_advsimd.xml */
int FRECPX_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 01|U=0|11110|a=1|111100|opcode=11111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x5EF9F800) {
		decode_fields32(ENC_FRECPX_ASISDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		OK(ENC_FRECPX_ASISDMISCFP16_R);
	}
	/* class iclass_single_and_double */
	/* 01|U=0|11110|1|sz=x|10000|opcode=11111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x5EA1F800) {
		decode_fields32(ENC_FRECPX_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		OK(ENC_FRECPX_ASISDMISC_R);
	}
	return rc;
}

/* frint32x_advsimd.xml */
int FRINT32X_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=1|01110|0|sz=x|10000|1111|op=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2E21E800) {
		decode_fields32(ENC_FRINT32X_ASIMDMISC_R, ctx, instr);
		if(!HaveFrintExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->intsize = (ctx->op==0) ? 0x20 : 0x40;
		ctx->rounding = (ctx->U==0) ? FPRounding_ZERO : FPRoundingMode(ctx->FPCR);
		OK(ENC_FRINT32X_ASIMDMISC_R);
	}
	return rc;
}

/* frint32x_float.xml */
int FRINT32X_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=0x|1|0100|op=01|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x1E28C000) {
		decode_fields32(ENC_FRINT32X_S_FLOATDP1, ctx, instr);
		if(!HaveFrintExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if((ctx->ftype&2)==2) {
			UNDEFINED;
		}
		ctx->intsize = (SLICE(ctx->op,1,1)==0) ? 0x20 : 0x40;
		ctx->rounding = (SLICE(ctx->op,0,0)==0) ? FPRounding_ZERO : FPRoundingMode(ctx->FPCR);
		if(ctx->ftype==0) OK(ENC_FRINT32X_S_FLOATDP1);
		if(ctx->ftype==1) OK(ENC_FRINT32X_D_FLOATDP1);
	}
	return rc;
}

/* frint32z_advsimd.xml */
int FRINT32Z_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|0|sz=x|10000|1111|op=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xE21E800) {
		decode_fields32(ENC_FRINT32Z_ASIMDMISC_R, ctx, instr);
		if(!HaveFrintExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->intsize = (ctx->op==0) ? 0x20 : 0x40;
		ctx->rounding = (ctx->U==0) ? FPRounding_ZERO : FPRoundingMode(ctx->FPCR);
		OK(ENC_FRINT32Z_ASIMDMISC_R);
	}
	return rc;
}

/* frint32z_float.xml */
int FRINT32Z_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=0x|1|0100|op=00|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x1E284000) {
		decode_fields32(ENC_FRINT32Z_S_FLOATDP1, ctx, instr);
		if(!HaveFrintExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if((ctx->ftype&2)==2) {
			UNDEFINED;
		}
		ctx->intsize = (SLICE(ctx->op,1,1)==0) ? 0x20 : 0x40;
		ctx->rounding = (SLICE(ctx->op,0,0)==0) ? FPRounding_ZERO : FPRoundingMode(ctx->FPCR);
		if(ctx->ftype==0) OK(ENC_FRINT32Z_S_FLOATDP1);
		if(ctx->ftype==1) OK(ENC_FRINT32Z_D_FLOATDP1);
	}
	return rc;
}

/* frint64x_advsimd.xml */
int FRINT64X_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=1|01110|0|sz=x|10000|1111|op=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2E21F800) {
		decode_fields32(ENC_FRINT64X_ASIMDMISC_R, ctx, instr);
		if(!HaveFrintExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->intsize = (ctx->op==0) ? 0x20 : 0x40;
		ctx->rounding = (ctx->U==0) ? FPRounding_ZERO : FPRoundingMode(ctx->FPCR);
		OK(ENC_FRINT64X_ASIMDMISC_R);
	}
	return rc;
}

/* frint64x_float.xml */
int FRINT64X_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=0x|1|0100|op=11|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x1E29C000) {
		decode_fields32(ENC_FRINT64X_S_FLOATDP1, ctx, instr);
		if(!HaveFrintExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if((ctx->ftype&2)==2) {
			UNDEFINED;
		}
		ctx->intsize = (SLICE(ctx->op,1,1)==0) ? 0x20 : 0x40;
		ctx->rounding = (SLICE(ctx->op,0,0)==0) ? FPRounding_ZERO : FPRoundingMode(ctx->FPCR);
		if(ctx->ftype==0) OK(ENC_FRINT64X_S_FLOATDP1);
		if(ctx->ftype==1) OK(ENC_FRINT64X_D_FLOATDP1);
	}
	return rc;
}

/* frint64z_advsimd.xml */
int FRINT64Z_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|0|sz=x|10000|1111|op=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xE21F800) {
		decode_fields32(ENC_FRINT64Z_ASIMDMISC_R, ctx, instr);
		if(!HaveFrintExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->intsize = (ctx->op==0) ? 0x20 : 0x40;
		ctx->rounding = (ctx->U==0) ? FPRounding_ZERO : FPRoundingMode(ctx->FPCR);
		OK(ENC_FRINT64Z_ASIMDMISC_R);
	}
	return rc;
}

/* frint64z_float.xml */
int FRINT64Z_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=0x|1|0100|op=10|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x1E294000) {
		decode_fields32(ENC_FRINT64Z_S_FLOATDP1, ctx, instr);
		if(!HaveFrintExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if((ctx->ftype&2)==2) {
			UNDEFINED;
		}
		ctx->intsize = (SLICE(ctx->op,1,1)==0) ? 0x20 : 0x40;
		ctx->rounding = (SLICE(ctx->op,0,0)==0) ? FPRounding_ZERO : FPRoundingMode(ctx->FPCR);
		if(ctx->ftype==0) OK(ENC_FRINT64Z_S_FLOATDP1);
		if(ctx->ftype==1) OK(ENC_FRINT64Z_D_FLOATDP1);
	}
	return rc;
}

/* frinta_advsimd.xml */
int FRINTA_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=1|01110|o2=0|111100|1100|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2E798800) {
		decode_fields32(ENC_FRINTA_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->exact = FALSE;
		if(!(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)&4)) {
			ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==5) {
			UNDEFINED;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		OK(ENC_FRINTA_ASIMDMISCFP16_R);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=1|01110|o2=0|sz=x|10000|1100|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2E218800) {
		decode_fields32(ENC_FRINTA_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->exact = FALSE;
		if(!(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)&4)) {
			ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==5) {
			UNDEFINED;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		OK(ENC_FRINTA_ASIMDMISC_R);
	}
	return rc;
}

/* frinta_float.xml */
int FRINTA_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|001|rmode=100|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x1E264000) {
		decode_fields32(ENC_FRINTA_H_FLOATDP1, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->exact = FALSE;
		if(!(ctx->rmode&4)) {
			ctx->rounding = FPDecodeRounding(SLICE(ctx->rmode,1,0));
		}
		else if(ctx->rmode==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(ctx->rmode==5) {
			UNDEFINED;
		}
		else if(ctx->rmode==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(ctx->rmode==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		if(ctx->ftype==3) OK(ENC_FRINTA_H_FLOATDP1);
		if(ctx->ftype==0) OK(ENC_FRINTA_S_FLOATDP1);
		if(ctx->ftype==1) OK(ENC_FRINTA_D_FLOATDP1);
	}
	return rc;
}

/* frinti_advsimd.xml */
int FRINTI_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=1|01110|o2=1|111100|1100|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2EF99800) {
		decode_fields32(ENC_FRINTI_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->exact = FALSE;
		if(!(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)&4)) {
			ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==5) {
			UNDEFINED;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		OK(ENC_FRINTI_ASIMDMISCFP16_R);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=1|01110|o2=1|sz=x|10000|1100|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2EA19800) {
		decode_fields32(ENC_FRINTI_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->exact = FALSE;
		if(!(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)&4)) {
			ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==5) {
			UNDEFINED;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		OK(ENC_FRINTI_ASIMDMISC_R);
	}
	return rc;
}

/* frinti_float.xml */
int FRINTI_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|001|rmode=111|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x1E27C000) {
		decode_fields32(ENC_FRINTI_H_FLOATDP1, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->exact = FALSE;
		if(!(ctx->rmode&4)) {
			ctx->rounding = FPDecodeRounding(SLICE(ctx->rmode,1,0));
		}
		else if(ctx->rmode==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(ctx->rmode==5) {
			UNDEFINED;
		}
		else if(ctx->rmode==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(ctx->rmode==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		if(ctx->ftype==3) OK(ENC_FRINTI_H_FLOATDP1);
		if(ctx->ftype==0) OK(ENC_FRINTI_S_FLOATDP1);
		if(ctx->ftype==1) OK(ENC_FRINTI_D_FLOATDP1);
	}
	return rc;
}

/* frintm_advsimd.xml */
int FRINTM_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|o2=0|111100|1100|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xE799800) {
		decode_fields32(ENC_FRINTM_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->exact = FALSE;
		if(!(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)&4)) {
			ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==5) {
			UNDEFINED;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		OK(ENC_FRINTM_ASIMDMISCFP16_R);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=0|01110|o2=0|sz=x|10000|1100|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xE219800) {
		decode_fields32(ENC_FRINTM_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->exact = FALSE;
		if(!(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)&4)) {
			ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==5) {
			UNDEFINED;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		OK(ENC_FRINTM_ASIMDMISC_R);
	}
	return rc;
}

/* frintm_float.xml */
int FRINTM_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|001|rmode=010|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x1E254000) {
		decode_fields32(ENC_FRINTM_H_FLOATDP1, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->exact = FALSE;
		if(!(ctx->rmode&4)) {
			ctx->rounding = FPDecodeRounding(SLICE(ctx->rmode,1,0));
		}
		else if(ctx->rmode==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(ctx->rmode==5) {
			UNDEFINED;
		}
		else if(ctx->rmode==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(ctx->rmode==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		if(ctx->ftype==3) OK(ENC_FRINTM_H_FLOATDP1);
		if(ctx->ftype==0) OK(ENC_FRINTM_S_FLOATDP1);
		if(ctx->ftype==1) OK(ENC_FRINTM_D_FLOATDP1);
	}
	return rc;
}

/* frintn_advsimd.xml */
int FRINTN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|o2=0|111100|1100|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xE798800) {
		decode_fields32(ENC_FRINTN_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->exact = FALSE;
		if(!(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)&4)) {
			ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==5) {
			UNDEFINED;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		OK(ENC_FRINTN_ASIMDMISCFP16_R);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=0|01110|o2=0|sz=x|10000|1100|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xE218800) {
		decode_fields32(ENC_FRINTN_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->exact = FALSE;
		if(!(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)&4)) {
			ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==5) {
			UNDEFINED;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		OK(ENC_FRINTN_ASIMDMISC_R);
	}
	return rc;
}

/* frintn_float.xml */
int FRINTN_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|001|rmode=000|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x1E244000) {
		decode_fields32(ENC_FRINTN_H_FLOATDP1, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->exact = FALSE;
		if(!(ctx->rmode&4)) {
			ctx->rounding = FPDecodeRounding(SLICE(ctx->rmode,1,0));
		}
		else if(ctx->rmode==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(ctx->rmode==5) {
			UNDEFINED;
		}
		else if(ctx->rmode==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(ctx->rmode==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		if(ctx->ftype==3) OK(ENC_FRINTN_H_FLOATDP1);
		if(ctx->ftype==0) OK(ENC_FRINTN_S_FLOATDP1);
		if(ctx->ftype==1) OK(ENC_FRINTN_D_FLOATDP1);
	}
	return rc;
}

/* frintp_advsimd.xml */
int FRINTP_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|o2=1|111100|1100|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xEF98800) {
		decode_fields32(ENC_FRINTP_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->exact = FALSE;
		if(!(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)&4)) {
			ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==5) {
			UNDEFINED;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		OK(ENC_FRINTP_ASIMDMISCFP16_R);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=0|01110|o2=1|sz=x|10000|1100|o1=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xEA18800) {
		decode_fields32(ENC_FRINTP_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->exact = FALSE;
		if(!(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)&4)) {
			ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==5) {
			UNDEFINED;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		OK(ENC_FRINTP_ASIMDMISC_R);
	}
	return rc;
}

/* frintp_float.xml */
int FRINTP_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|001|rmode=001|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x1E24C000) {
		decode_fields32(ENC_FRINTP_H_FLOATDP1, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->exact = FALSE;
		if(!(ctx->rmode&4)) {
			ctx->rounding = FPDecodeRounding(SLICE(ctx->rmode,1,0));
		}
		else if(ctx->rmode==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(ctx->rmode==5) {
			UNDEFINED;
		}
		else if(ctx->rmode==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(ctx->rmode==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		if(ctx->ftype==3) OK(ENC_FRINTP_H_FLOATDP1);
		if(ctx->ftype==0) OK(ENC_FRINTP_S_FLOATDP1);
		if(ctx->ftype==1) OK(ENC_FRINTP_D_FLOATDP1);
	}
	return rc;
}

/* frintx_advsimd.xml */
int FRINTX_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=1|01110|o2=0|111100|1100|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2E799800) {
		decode_fields32(ENC_FRINTX_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->exact = FALSE;
		if(!(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)&4)) {
			ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==5) {
			UNDEFINED;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		OK(ENC_FRINTX_ASIMDMISCFP16_R);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=1|01110|o2=0|sz=x|10000|1100|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2E219800) {
		decode_fields32(ENC_FRINTX_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->exact = FALSE;
		if(!(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)&4)) {
			ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==5) {
			UNDEFINED;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		OK(ENC_FRINTX_ASIMDMISC_R);
	}
	return rc;
}

/* frintx_float.xml */
int FRINTX_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|001|rmode=110|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x1E274000) {
		decode_fields32(ENC_FRINTX_H_FLOATDP1, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->exact = FALSE;
		if(!(ctx->rmode&4)) {
			ctx->rounding = FPDecodeRounding(SLICE(ctx->rmode,1,0));
		}
		else if(ctx->rmode==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(ctx->rmode==5) {
			UNDEFINED;
		}
		else if(ctx->rmode==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(ctx->rmode==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		if(ctx->ftype==3) OK(ENC_FRINTX_H_FLOATDP1);
		if(ctx->ftype==0) OK(ENC_FRINTX_S_FLOATDP1);
		if(ctx->ftype==1) OK(ENC_FRINTX_D_FLOATDP1);
	}
	return rc;
}

/* frintz_advsimd.xml */
int FRINTZ_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|o2=1|111100|1100|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xEF99800) {
		decode_fields32(ENC_FRINTZ_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->exact = FALSE;
		if(!(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)&4)) {
			ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==5) {
			UNDEFINED;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		OK(ENC_FRINTZ_ASIMDMISCFP16_R);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=0|01110|o2=1|sz=x|10000|1100|o1=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xEA19800) {
		decode_fields32(ENC_FRINTZ_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->exact = FALSE;
		if(!(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)&4)) {
			ctx->rounding = FPDecodeRounding(((ctx->o1<<1)|ctx->o2));
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==5) {
			UNDEFINED;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(((ctx->U<<2)|(ctx->o1<<1)|ctx->o2)==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		OK(ENC_FRINTZ_ASIMDMISC_R);
	}
	return rc;
}

/* frintz_float.xml */
int FRINTZ_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|001|rmode=011|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x1E25C000) {
		decode_fields32(ENC_FRINTZ_H_FLOATDP1, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->exact = FALSE;
		if(!(ctx->rmode&4)) {
			ctx->rounding = FPDecodeRounding(SLICE(ctx->rmode,1,0));
		}
		else if(ctx->rmode==4) {
			ctx->rounding = FPRounding_TIEAWAY;
		}
		else if(ctx->rmode==5) {
			UNDEFINED;
		}
		else if(ctx->rmode==6) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->exact = TRUE;
		}
		else if(ctx->rmode==7) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
		}
		if(ctx->ftype==3) OK(ENC_FRINTZ_H_FLOATDP1);
		if(ctx->ftype==0) OK(ENC_FRINTZ_S_FLOATDP1);
		if(ctx->ftype==1) OK(ENC_FRINTZ_D_FLOATDP1);
	}
	return rc;
}

/* frsqrte_advsimd.xml */
int FRSQRTE_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=1|11110|a=1|111100|opcode=11101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x7EF9D800) {
		decode_fields32(ENC_FRSQRTE_ASISDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		OK(ENC_FRSQRTE_ASISDMISCFP16_R);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=1|11110|1|sz=x|10000|opcode=11101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x7EA1D800) {
		decode_fields32(ENC_FRSQRTE_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		OK(ENC_FRSQRTE_ASISDMISC_R);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=1|01110|a=1|111100|opcode=11101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2EF9D800) {
		decode_fields32(ENC_FRSQRTE_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FRSQRTE_ASIMDMISCFP16_R);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=1|01110|1|sz=x|10000|opcode=11101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2EA1D800) {
		decode_fields32(ENC_FRSQRTE_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FRSQRTE_ASIMDMISC_R);
	}
	return rc;
}

/* frsqrts_advsimd.xml */
int FRSQRTS_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=0|11110|a=1|10|Rm=xxxxx|00|opcode=111|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x5EC03C00) {
		decode_fields32(ENC_FRSQRTS_ASISDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		OK(ENC_FRSQRTS_ASISDSAMEFP16_ONLY);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=0|11110|1|sz=x|1|Rm=xxxxx|opcode=11111|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFA0FC00)==0x5EA0FC00) {
		decode_fields32(ENC_FRSQRTS_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		OK(ENC_FRSQRTS_ASISDSAME_ONLY);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=0|01110|a=1|10|Rm=xxxxx|00|opcode=111|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xEC03C00) {
		decode_fields32(ENC_FRSQRTS_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FRSQRTS_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|1|sz=x|1|Rm=xxxxx|opcode=11111|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0xEA0FC00) {
		decode_fields32(ENC_FRSQRTS_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FRSQRTS_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fsqrt_advsimd.xml */
int FSQRT_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=1|01110|a=1|111100|opcode=11111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2EF9F800) {
		decode_fields32(ENC_FSQRT_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FSQRT_ASIMDMISCFP16_R);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=1|01110|1|sz=x|10000|opcode=11111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2EA1F800) {
		decode_fields32(ENC_FSQRT_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_FSQRT_ASIMDMISC_R);
	}
	return rc;
}

/* fsqrt_float.xml */
int FSQRT_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|0000|opc=11|10000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x1E21C000) {
		decode_fields32(ENC_FSQRT_H_FLOATDP1, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!ctx->opc) {
			ctx->fpop = FPUnaryOp_MOV;
		}
		else if(ctx->opc==1) {
			ctx->fpop = FPUnaryOp_ABS;
		}
		else if(ctx->opc==2) {
			ctx->fpop = FPUnaryOp_NEG;
		}
		else if(ctx->opc==3) {
			ctx->fpop = FPUnaryOp_SQRT;
		}
		if(ctx->ftype==3) OK(ENC_FSQRT_H_FLOATDP1);
		if(ctx->ftype==0) OK(ENC_FSQRT_S_FLOATDP1);
		if(ctx->ftype==1) OK(ENC_FSQRT_D_FLOATDP1);
	}
	return rc;
}

/* fsub_advsimd.xml */
int FSUB_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 0|Q=x|U=0|01110|a=1|10|Rm=xxxxx|00|opcode=010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xEC01400) {
		decode_fields32(ENC_FSUB_ASIMDSAMEFP16_ONLY, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->abs = (ctx->U==1);
		OK(ENC_FSUB_ASIMDSAMEFP16_ONLY);
	}
	/* class iclass_single_and_double */
	/* 0|Q=x|U=0|01110|1|sz=x|1|Rm=xxxxx|opcode=11010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFA0FC00)==0xEA0D400) {
		decode_fields32(ENC_FSUB_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->abs = (ctx->U==1);
		OK(ENC_FSUB_ASIMDSAME_ONLY);
	}
	return rc;
}

/* fsub_float.xml */
int FSUB_float(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* M=0|0|S=0|11110|ftype=xx|1|Rm=xxxxx|001|op=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x1E203800) {
		decode_fields32(ENC_FSUB_H_FLOATDP2, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!ctx->ftype) {
			ctx->esize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->esize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->esize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		ctx->sub_op = (ctx->op==1);
		if(ctx->ftype==3) OK(ENC_FSUB_H_FLOATDP2);
		if(ctx->ftype==0) OK(ENC_FSUB_S_FLOATDP2);
		if(ctx->ftype==1) OK(ENC_FSUB_D_FLOATDP2);
	}
	return rc;
}

/* gmi.xml */
int GMI(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|0|S=0|11010110|Xm=xxxxx|opcode=000101|Xn=xxxxx|Xd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x9AC01400) {
		decode_fields32(ENC_GMI_64G_DP_2SRC, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Xd);
		ctx->n = UINT(ctx->Xn);
		ctx->m = UINT(ctx->Xm);
		OK(ENC_GMI_64G_DP_2SRC);
	}
	return rc;
}

/* hint.xml */
int HINT(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=xxxx|op2=xxx|Rt=11111 */
	if((INSWORD & 0xFFFFF01F)==0xD503201F) {
		decode_fields32(ENC_HINT_HM_HINTS, ctx, instr);
		if(!((ctx->CRm<<3)|ctx->op2)) {
			ctx->op = SystemHintOp_NOP;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==1) {
			ctx->op = SystemHintOp_YIELD;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==2) {
			ctx->op = SystemHintOp_WFE;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==3) {
			ctx->op = SystemHintOp_WFI;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==4) {
			ctx->op = SystemHintOp_SEV;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==5) {
			ctx->op = SystemHintOp_SEVL;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==6) {
			if(!HaveDGHExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_DGH;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==7) {
			SEE /* XPACLRI */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==8) {
			if(!ctx->op2) {
				SEE /* PACIA1716 */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIB1716 */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIA1716 */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIB1716 */;
			}
			else {
				ENDOFINSTRUCTION;
			}
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x10) {
			if(!HaveRASExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_ESB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x11) {
			if(!HaveStatisticalProfiling()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_PSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x12) {
			if(!HaveSelfHostedTrace()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_TSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x14) {
			ctx->op = SystemHintOp_CSDB;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==0x18) {
			if(!ctx->op2) {
				SEE /* PACIAZ */;
			}
			else if(ctx->op2==1) {
				SEE /* PACIASP */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIBZ */;
			}
			else if(ctx->op2==3) {
				SEE /* PACIBSP */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIAZ */;
			}
			else if(ctx->op2==5) {
				SEE /* AUTHASP */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIBZ */;
			}
			else if(ctx->op2==7) {
				SEE /* AUTIBSP */;
			}
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x79)==0x20) {
			ctx->op = SystemHintOp_BTI;
			SetBTypeCompatible(BTypeCompatible_BTI(SLICE(ctx->op2,2,1), ctx->pstate_btype));
		}
		else {
			ENDOFINSTRUCTION;
		}
		OK(ENC_HINT_HM_HINTS);
	}
	return rc;
}

/* hlt.xml */
int HLT(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 11010100|opc=010|imm16=xxxxxxxxxxxxxxxx|op2=000|LL=00 */
	if((INSWORD & 0xFFE0001F)==0xD4400000) {
		decode_fields32(ENC_HLT_EX_EXCEPTION, ctx, instr);
		if(ctx->EDSCR_HDE==0 || !HaltingAllowed()) {
			UNDEFINED;
		}
		if(HaveBTIExt()) {
			SetBTypeCompatible(TRUE);
		}
		OK(ENC_HLT_EX_EXCEPTION);
	}
	return rc;
}

/* hvc.xml */
int HVC(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 11010100|opc=000|imm16=xxxxxxxxxxxxxxxx|op2=000|LL=10 */
	if((INSWORD & 0xFFE0001F)==0xD4000002) {
		decode_fields32(ENC_HVC_EX_EXCEPTION, ctx, instr);
		OK(ENC_HVC_EX_EXCEPTION);
	}
	return rc;
}

/* ic_sys.xml */
int IC_SYS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=01|op1=xxx|CRn=0111|CRm=xxxx|op2=xxx|Rt=xxxxx */
	if((INSWORD & 0xFFF8F000)==0xD5087000) {
		decode_fields32(ENC_IC_SYS_CR_SYSTEMINSTRS, ctx, instr);
		OK(ENC_IC_SYS_CR_SYSTEMINSTRS);
	}
	return rc;
}

/* ins_advsimd_elt.xml */
int INS_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=1|op=1|01110000|imm5=xxxxx|0|imm4=xxxx|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE08400)==0x6E000400) {
		decode_fields32(ENC_INS_ASIMDINS_IV_V, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->size = LowestSetBit(ctx->imm5);
		if(ctx->size>3) {
			UNDEFINED;
		}
		ctx->dst_index = UINT(SLICE(ctx->imm5,4,ctx->size+1));
		ctx->src_index = UINT(SLICE(ctx->imm4,3,ctx->size));
		ctx->idxdsize = (SLICE(ctx->imm4,3,3)==1) ? 0x80 : 0x40;
		ctx->esize = (8) << (ctx->size);
		/* unconditional alias */
		if(MOV_INS_advsimd_elt(ctx, instr)==0) return 0;
		OK(ENC_INS_ASIMDINS_IV_V);
	}
	return rc;
}

/* ins_advsimd_gen.xml */
int INS_advsimd_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=1|op=0|01110000|imm5=xxxxx|0|imm4=0011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x4E001C00) {
		decode_fields32(ENC_INS_ASIMDINS_IR_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->size = LowestSetBit(ctx->imm5);
		if(ctx->size>3) {
			UNDEFINED;
		}
		ctx->index = UINT(SLICE(ctx->imm5,4,ctx->size+1));
		ctx->esize = (8) << (ctx->size);
		ctx->datasize = 0x80;
		/* unconditional alias */
		if(MOV_INS_advsimd_gen(ctx, instr)==0) return 0;
		OK(ENC_INS_ASIMDINS_IR_R);
	}
	return rc;
}

/* irg.xml */
int IRG(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|0|S=0|11010110|Xm=xxxxx|opcode=000100|Xn=xxxxx|Xd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x9AC01000) {
		decode_fields32(ENC_IRG_64I_DP_2SRC, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Xd);
		ctx->n = UINT(ctx->Xn);
		ctx->m = UINT(ctx->Xm);
		OK(ENC_IRG_64I_DP_2SRC);
	}
	return rc;
}

/* isb.xml */
int ISB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0011|CRm=xxxx|1|opc=10|Rt=11111 */
	if((INSWORD & 0xFFFFF0FF)==0xD50330DF) {
		decode_fields32(ENC_ISB_BI_BARRIERS, ctx, instr);
		OK(ENC_ISB_BI_BARRIERS);
	}
	return rc;
}

/* ld1r_advsimd.xml */
int LD1R_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011010|L=1|R=0|00000|opcode=110|S=0|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFFF000)==0xD40C000) {
		decode_fields32(ENC_LD1R_ASISDLSO_R1, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		OK(ENC_LD1R_ASISDLSO_R1);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011011|L=1|R=0|Rm=xxxxx|opcode=110|S=0|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE0F000)==0xDC0C000) {
		decode_fields32(ENC_LD1R_ASISDLSOP_R1_I, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f) OK(ENC_LD1R_ASISDLSOP_R1_I);
		if(ctx->Rm!=0x1f) OK(ENC_LD1R_ASISDLSOP_RX1_R);
	}
	/* post-decode pcode */
	ctx->init_scale = UINT(SLICE(ctx->opcode,2,1));
	ctx->scale = ctx->init_scale;
	ctx->selem = UINT(((SLICE(ctx->opcode,0,0)<<1)|ctx->R))+1;
	ctx->replicate = FALSE;
	if(ctx->scale==3) {
		if(ctx->L==0 || ctx->S==1) {
			UNDEFINED;
		}
		ctx->scale = UINT(ctx->size);
		ctx->replicate = TRUE;
	}
	else if(ctx->scale==0) {
		ctx->index = UINT(((ctx->Q<<3)|(ctx->S<<2)|ctx->size));
	}
	else if(ctx->scale==1) {
		if(SLICE(ctx->size,0,0)==1) {
			UNDEFINED;
		}
		ctx->index = UINT(((ctx->Q<<2)|(ctx->S<<1)|SLICE(ctx->size,1,1)));
	}
	else if(ctx->scale==2) {
		if(SLICE(ctx->size,1,1)==1) {
			UNDEFINED;
		}
		if(SLICE(ctx->size,0,0)==0) {
			ctx->index = UINT(((ctx->Q<<1)|ctx->S));
		}
		else {
			if(ctx->S==1) {
				UNDEFINED;
			}
			ctx->index = UINT(ctx->Q);
			ctx->scale = 3;
		}
	}
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (ctx->scale);
	return rc;
}

/* ld1_advsimd_mult.xml */
int LD1_advsimd_mult(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011000|L=1|000000|opcode=xx1x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFF2000)==0xC402000) {
		decode_fields32(ENC_LD1_ASISDLSE_R1_1V, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->opcode==7) OK(ENC_LD1_ASISDLSE_R1_1V);
		if(ctx->opcode==10) OK(ENC_LD1_ASISDLSE_R2_2V);
		if(ctx->opcode==6) OK(ENC_LD1_ASISDLSE_R3_3V);
		if(ctx->opcode==2) OK(ENC_LD1_ASISDLSE_R4_4V);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011001|L=1|0|Rm=xxxxx|opcode=xx1x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE02000)==0xCC02000) {
		decode_fields32(ENC_LD1_ASISDLSEP_I1_I1, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f && ctx->opcode==7) OK(ENC_LD1_ASISDLSEP_I1_I1);
		if(ctx->Rm!=0x1f && ctx->opcode==7) OK(ENC_LD1_ASISDLSEP_R1_R1);
		if(ctx->Rm==0x1f && ctx->opcode==10) OK(ENC_LD1_ASISDLSEP_I2_I2);
		if(ctx->Rm!=0x1f && ctx->opcode==10) OK(ENC_LD1_ASISDLSEP_R2_R2);
		if(ctx->Rm==0x1f && ctx->opcode==6) OK(ENC_LD1_ASISDLSEP_I3_I3);
		if(ctx->Rm!=0x1f && ctx->opcode==6) OK(ENC_LD1_ASISDLSEP_R3_R3);
		if(ctx->Rm==0x1f && ctx->opcode==2) OK(ENC_LD1_ASISDLSEP_I4_I4);
		if(ctx->Rm!=0x1f && ctx->opcode==2) OK(ENC_LD1_ASISDLSEP_R4_R4);
	}
	/* post-decode pcode */
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (UINT(ctx->size));
	ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
	if(!ctx->opcode) {
		ctx->rpt = 1;
		ctx->selem = 4;
	}
	else if(ctx->opcode==2) {
		ctx->rpt = 4;
		ctx->selem = 1;
	}
	else if(ctx->opcode==4) {
		ctx->rpt = 1;
		ctx->selem = 3;
	}
	else if(ctx->opcode==6) {
		ctx->rpt = 3;
		ctx->selem = 1;
	}
	else if(ctx->opcode==7) {
		ctx->rpt = 1;
		ctx->selem = 1;
	}
	else if(ctx->opcode==8) {
		ctx->rpt = 1;
		ctx->selem = 2;
	}
	else if(ctx->opcode==10) {
		ctx->rpt = 2;
		ctx->selem = 1;
	}
	else {
		UNDEFINED;
	}
	if(((ctx->size<<1)|ctx->Q)==6 && ctx->selem!=1) {
		UNDEFINED;
	}
	return rc;
}

/* ld1_advsimd_sngl.xml */
int LD1_advsimd_sngl(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011010|L=1|R=0|00000|opcode=xx0|S=x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFF2000)==0xD400000) {
		decode_fields32(ENC_LD1_ASISDLSO_B1_1B, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->opcode==0) OK(ENC_LD1_ASISDLSO_B1_1B);
		if(ctx->opcode==2 && !(ctx->size&1)) OK(ENC_LD1_ASISDLSO_H1_1H);
		if(ctx->opcode==4 && ctx->size==0) OK(ENC_LD1_ASISDLSO_S1_1S);
		if(ctx->opcode==4 && ctx->S==0 && ctx->size==1) OK(ENC_LD1_ASISDLSO_D1_1D);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011011|L=1|R=0|Rm=xxxxx|opcode=xx0|S=x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE02000)==0xDC00000) {
		decode_fields32(ENC_LD1_ASISDLSOP_B1_I1B, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f && ctx->opcode==0) OK(ENC_LD1_ASISDLSOP_B1_I1B);
		if(ctx->Rm!=0x1f && ctx->opcode==0) OK(ENC_LD1_ASISDLSOP_BX1_R1B);
		if(ctx->Rm==0x1f && ctx->opcode==2 && !(ctx->size&1)) OK(ENC_LD1_ASISDLSOP_H1_I1H);
		if(ctx->Rm!=0x1f && ctx->opcode==2 && !(ctx->size&1)) OK(ENC_LD1_ASISDLSOP_HX1_R1H);
		if(ctx->Rm==0x1f && ctx->opcode==4 && ctx->size==0) OK(ENC_LD1_ASISDLSOP_S1_I1S);
		if(ctx->Rm!=0x1f && ctx->opcode==4 && ctx->size==0) OK(ENC_LD1_ASISDLSOP_SX1_R1S);
		if(ctx->Rm==0x1f && ctx->opcode==4 && ctx->S==0 && ctx->size==1) OK(ENC_LD1_ASISDLSOP_D1_I1D);
		if(ctx->Rm!=0x1f && ctx->opcode==4 && ctx->S==0 && ctx->size==1) OK(ENC_LD1_ASISDLSOP_DX1_R1D);
	}
	/* post-decode pcode */
	ctx->init_scale = UINT(SLICE(ctx->opcode,2,1));
	ctx->scale = ctx->init_scale;
	ctx->selem = UINT(((SLICE(ctx->opcode,0,0)<<1)|ctx->R))+1;
	ctx->replicate = FALSE;
	if(ctx->scale==3) {
		if(ctx->L==0 || ctx->S==1) {
			UNDEFINED;
		}
		ctx->scale = UINT(ctx->size);
		ctx->replicate = TRUE;
	}
	else if(ctx->scale==0) {
		ctx->index = UINT(((ctx->Q<<3)|(ctx->S<<2)|ctx->size));
	}
	else if(ctx->scale==1) {
		if(SLICE(ctx->size,0,0)==1) {
			UNDEFINED;
		}
		ctx->index = UINT(((ctx->Q<<2)|(ctx->S<<1)|SLICE(ctx->size,1,1)));
	}
	else if(ctx->scale==2) {
		if(SLICE(ctx->size,1,1)==1) {
			UNDEFINED;
		}
		if(SLICE(ctx->size,0,0)==0) {
			ctx->index = UINT(((ctx->Q<<1)|ctx->S));
		}
		else {
			if(ctx->S==1) {
				UNDEFINED;
			}
			ctx->index = UINT(ctx->Q);
			ctx->scale = 3;
		}
	}
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (ctx->scale);
	return rc;
}

/* ld2r_advsimd.xml */
int LD2R_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011010|L=1|R=1|00000|opcode=110|S=0|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFFF000)==0xD60C000) {
		decode_fields32(ENC_LD2R_ASISDLSO_R2, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		OK(ENC_LD2R_ASISDLSO_R2);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011011|L=1|R=1|Rm=xxxxx|opcode=110|S=0|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE0F000)==0xDE0C000) {
		decode_fields32(ENC_LD2R_ASISDLSOP_R2_I, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f) OK(ENC_LD2R_ASISDLSOP_R2_I);
		if(ctx->Rm!=0x1f) OK(ENC_LD2R_ASISDLSOP_RX2_R);
	}
	/* post-decode pcode */
	ctx->init_scale = UINT(SLICE(ctx->opcode,2,1));
	ctx->scale = ctx->init_scale;
	ctx->selem = UINT(((SLICE(ctx->opcode,0,0)<<1)|ctx->R))+1;
	ctx->replicate = FALSE;
	if(ctx->scale==3) {
		if(ctx->L==0 || ctx->S==1) {
			UNDEFINED;
		}
		ctx->scale = UINT(ctx->size);
		ctx->replicate = TRUE;
	}
	else if(ctx->scale==0) {
		ctx->index = UINT(((ctx->Q<<3)|(ctx->S<<2)|ctx->size));
	}
	else if(ctx->scale==1) {
		if(SLICE(ctx->size,0,0)==1) {
			UNDEFINED;
		}
		ctx->index = UINT(((ctx->Q<<2)|(ctx->S<<1)|SLICE(ctx->size,1,1)));
	}
	else if(ctx->scale==2) {
		if(SLICE(ctx->size,1,1)==1) {
			UNDEFINED;
		}
		if(SLICE(ctx->size,0,0)==0) {
			ctx->index = UINT(((ctx->Q<<1)|ctx->S));
		}
		else {
			if(ctx->S==1) {
				UNDEFINED;
			}
			ctx->index = UINT(ctx->Q);
			ctx->scale = 3;
		}
	}
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (ctx->scale);
	return rc;
}

/* ld2_advsimd_mult.xml */
int LD2_advsimd_mult(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011000|L=1|000000|opcode=1000|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFFF000)==0xC408000) {
		decode_fields32(ENC_LD2_ASISDLSE_R2, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		OK(ENC_LD2_ASISDLSE_R2);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011001|L=1|0|Rm=xxxxx|opcode=1000|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE0F000)==0xCC08000) {
		decode_fields32(ENC_LD2_ASISDLSEP_I2_I, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f) OK(ENC_LD2_ASISDLSEP_I2_I);
		if(ctx->Rm!=0x1f) OK(ENC_LD2_ASISDLSEP_R2_R);
	}
	/* post-decode pcode */
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (UINT(ctx->size));
	ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
	if(!ctx->opcode) {
		ctx->rpt = 1;
		ctx->selem = 4;
	}
	else if(ctx->opcode==2) {
		ctx->rpt = 4;
		ctx->selem = 1;
	}
	else if(ctx->opcode==4) {
		ctx->rpt = 1;
		ctx->selem = 3;
	}
	else if(ctx->opcode==6) {
		ctx->rpt = 3;
		ctx->selem = 1;
	}
	else if(ctx->opcode==7) {
		ctx->rpt = 1;
		ctx->selem = 1;
	}
	else if(ctx->opcode==8) {
		ctx->rpt = 1;
		ctx->selem = 2;
	}
	else if(ctx->opcode==10) {
		ctx->rpt = 2;
		ctx->selem = 1;
	}
	else {
		UNDEFINED;
	}
	if(((ctx->size<<1)|ctx->Q)==6 && ctx->selem!=1) {
		UNDEFINED;
	}
	return rc;
}

/* ld2_advsimd_sngl.xml */
int LD2_advsimd_sngl(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011010|L=1|R=1|00000|opcode=xx0|S=x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFF2000)==0xD600000) {
		decode_fields32(ENC_LD2_ASISDLSO_B2_2B, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->opcode==0) OK(ENC_LD2_ASISDLSO_B2_2B);
		if(ctx->opcode==2 && !(ctx->size&1)) OK(ENC_LD2_ASISDLSO_H2_2H);
		if(ctx->opcode==4 && ctx->size==0) OK(ENC_LD2_ASISDLSO_S2_2S);
		if(ctx->opcode==4 && ctx->S==0 && ctx->size==1) OK(ENC_LD2_ASISDLSO_D2_2D);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011011|L=1|R=1|Rm=xxxxx|opcode=xx0|S=x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE02000)==0xDE00000) {
		decode_fields32(ENC_LD2_ASISDLSOP_B2_I2B, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f && ctx->opcode==0) OK(ENC_LD2_ASISDLSOP_B2_I2B);
		if(ctx->Rm!=0x1f && ctx->opcode==0) OK(ENC_LD2_ASISDLSOP_BX2_R2B);
		if(ctx->Rm==0x1f && ctx->opcode==2 && !(ctx->size&1)) OK(ENC_LD2_ASISDLSOP_H2_I2H);
		if(ctx->Rm!=0x1f && ctx->opcode==2 && !(ctx->size&1)) OK(ENC_LD2_ASISDLSOP_HX2_R2H);
		if(ctx->Rm==0x1f && ctx->opcode==4 && ctx->size==0) OK(ENC_LD2_ASISDLSOP_S2_I2S);
		if(ctx->Rm!=0x1f && ctx->opcode==4 && ctx->size==0) OK(ENC_LD2_ASISDLSOP_SX2_R2S);
		if(ctx->Rm==0x1f && ctx->opcode==4 && ctx->S==0 && ctx->size==1) OK(ENC_LD2_ASISDLSOP_D2_I2D);
		if(ctx->Rm!=0x1f && ctx->opcode==4 && ctx->S==0 && ctx->size==1) OK(ENC_LD2_ASISDLSOP_DX2_R2D);
	}
	/* post-decode pcode */
	ctx->init_scale = UINT(SLICE(ctx->opcode,2,1));
	ctx->scale = ctx->init_scale;
	ctx->selem = UINT(((SLICE(ctx->opcode,0,0)<<1)|ctx->R))+1;
	ctx->replicate = FALSE;
	if(ctx->scale==3) {
		if(ctx->L==0 || ctx->S==1) {
			UNDEFINED;
		}
		ctx->scale = UINT(ctx->size);
		ctx->replicate = TRUE;
	}
	else if(ctx->scale==0) {
		ctx->index = UINT(((ctx->Q<<3)|(ctx->S<<2)|ctx->size));
	}
	else if(ctx->scale==1) {
		if(SLICE(ctx->size,0,0)==1) {
			UNDEFINED;
		}
		ctx->index = UINT(((ctx->Q<<2)|(ctx->S<<1)|SLICE(ctx->size,1,1)));
	}
	else if(ctx->scale==2) {
		if(SLICE(ctx->size,1,1)==1) {
			UNDEFINED;
		}
		if(SLICE(ctx->size,0,0)==0) {
			ctx->index = UINT(((ctx->Q<<1)|ctx->S));
		}
		else {
			if(ctx->S==1) {
				UNDEFINED;
			}
			ctx->index = UINT(ctx->Q);
			ctx->scale = 3;
		}
	}
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (ctx->scale);
	return rc;
}

/* ld3r_advsimd.xml */
int LD3R_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011010|L=1|R=0|00000|opcode=111|S=0|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFFF000)==0xD40E000) {
		decode_fields32(ENC_LD3R_ASISDLSO_R3, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		OK(ENC_LD3R_ASISDLSO_R3);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011011|L=1|R=0|Rm=xxxxx|opcode=111|S=0|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE0F000)==0xDC0E000) {
		decode_fields32(ENC_LD3R_ASISDLSOP_R3_I, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f) OK(ENC_LD3R_ASISDLSOP_R3_I);
		if(ctx->Rm!=0x1f) OK(ENC_LD3R_ASISDLSOP_RX3_R);
	}
	/* post-decode pcode */
	ctx->init_scale = UINT(SLICE(ctx->opcode,2,1));
	ctx->scale = ctx->init_scale;
	ctx->selem = UINT(((SLICE(ctx->opcode,0,0)<<1)|ctx->R))+1;
	ctx->replicate = FALSE;
	if(ctx->scale==3) {
		if(ctx->L==0 || ctx->S==1) {
			UNDEFINED;
		}
		ctx->scale = UINT(ctx->size);
		ctx->replicate = TRUE;
	}
	else if(ctx->scale==0) {
		ctx->index = UINT(((ctx->Q<<3)|(ctx->S<<2)|ctx->size));
	}
	else if(ctx->scale==1) {
		if(SLICE(ctx->size,0,0)==1) {
			UNDEFINED;
		}
		ctx->index = UINT(((ctx->Q<<2)|(ctx->S<<1)|SLICE(ctx->size,1,1)));
	}
	else if(ctx->scale==2) {
		if(SLICE(ctx->size,1,1)==1) {
			UNDEFINED;
		}
		if(SLICE(ctx->size,0,0)==0) {
			ctx->index = UINT(((ctx->Q<<1)|ctx->S));
		}
		else {
			if(ctx->S==1) {
				UNDEFINED;
			}
			ctx->index = UINT(ctx->Q);
			ctx->scale = 3;
		}
	}
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (ctx->scale);
	return rc;
}

/* ld3_advsimd_mult.xml */
int LD3_advsimd_mult(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011000|L=1|000000|opcode=0100|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFFF000)==0xC404000) {
		decode_fields32(ENC_LD3_ASISDLSE_R3, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		OK(ENC_LD3_ASISDLSE_R3);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011001|L=1|0|Rm=xxxxx|opcode=0100|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE0F000)==0xCC04000) {
		decode_fields32(ENC_LD3_ASISDLSEP_I3_I, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f) OK(ENC_LD3_ASISDLSEP_I3_I);
		if(ctx->Rm!=0x1f) OK(ENC_LD3_ASISDLSEP_R3_R);
	}
	/* post-decode pcode */
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (UINT(ctx->size));
	ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
	if(!ctx->opcode) {
		ctx->rpt = 1;
		ctx->selem = 4;
	}
	else if(ctx->opcode==2) {
		ctx->rpt = 4;
		ctx->selem = 1;
	}
	else if(ctx->opcode==4) {
		ctx->rpt = 1;
		ctx->selem = 3;
	}
	else if(ctx->opcode==6) {
		ctx->rpt = 3;
		ctx->selem = 1;
	}
	else if(ctx->opcode==7) {
		ctx->rpt = 1;
		ctx->selem = 1;
	}
	else if(ctx->opcode==8) {
		ctx->rpt = 1;
		ctx->selem = 2;
	}
	else if(ctx->opcode==10) {
		ctx->rpt = 2;
		ctx->selem = 1;
	}
	else {
		UNDEFINED;
	}
	if(((ctx->size<<1)|ctx->Q)==6 && ctx->selem!=1) {
		UNDEFINED;
	}
	return rc;
}

/* ld3_advsimd_sngl.xml */
int LD3_advsimd_sngl(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011010|L=1|R=0|00000|opcode=xx1|S=x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFF2000)==0xD402000) {
		decode_fields32(ENC_LD3_ASISDLSO_B3_3B, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->opcode==1) OK(ENC_LD3_ASISDLSO_B3_3B);
		if(ctx->opcode==3 && !(ctx->size&1)) OK(ENC_LD3_ASISDLSO_H3_3H);
		if(ctx->opcode==5 && ctx->size==0) OK(ENC_LD3_ASISDLSO_S3_3S);
		if(ctx->opcode==5 && ctx->S==0 && ctx->size==1) OK(ENC_LD3_ASISDLSO_D3_3D);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011011|L=1|R=0|Rm=xxxxx|opcode=xx1|S=x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE02000)==0xDC02000) {
		decode_fields32(ENC_LD3_ASISDLSOP_B3_I3B, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f && ctx->opcode==1) OK(ENC_LD3_ASISDLSOP_B3_I3B);
		if(ctx->Rm!=0x1f && ctx->opcode==1) OK(ENC_LD3_ASISDLSOP_BX3_R3B);
		if(ctx->Rm==0x1f && ctx->opcode==3 && !(ctx->size&1)) OK(ENC_LD3_ASISDLSOP_H3_I3H);
		if(ctx->Rm!=0x1f && ctx->opcode==3 && !(ctx->size&1)) OK(ENC_LD3_ASISDLSOP_HX3_R3H);
		if(ctx->Rm==0x1f && ctx->opcode==5 && ctx->size==0) OK(ENC_LD3_ASISDLSOP_S3_I3S);
		if(ctx->Rm!=0x1f && ctx->opcode==5 && ctx->size==0) OK(ENC_LD3_ASISDLSOP_SX3_R3S);
		if(ctx->Rm==0x1f && ctx->opcode==5 && ctx->S==0 && ctx->size==1) OK(ENC_LD3_ASISDLSOP_D3_I3D);
		if(ctx->Rm!=0x1f && ctx->opcode==5 && ctx->S==0 && ctx->size==1) OK(ENC_LD3_ASISDLSOP_DX3_R3D);
	}
	/* post-decode pcode */
	ctx->init_scale = UINT(SLICE(ctx->opcode,2,1));
	ctx->scale = ctx->init_scale;
	ctx->selem = UINT(((SLICE(ctx->opcode,0,0)<<1)|ctx->R))+1;
	ctx->replicate = FALSE;
	if(ctx->scale==3) {
		if(ctx->L==0 || ctx->S==1) {
			UNDEFINED;
		}
		ctx->scale = UINT(ctx->size);
		ctx->replicate = TRUE;
	}
	else if(ctx->scale==0) {
		ctx->index = UINT(((ctx->Q<<3)|(ctx->S<<2)|ctx->size));
	}
	else if(ctx->scale==1) {
		if(SLICE(ctx->size,0,0)==1) {
			UNDEFINED;
		}
		ctx->index = UINT(((ctx->Q<<2)|(ctx->S<<1)|SLICE(ctx->size,1,1)));
	}
	else if(ctx->scale==2) {
		if(SLICE(ctx->size,1,1)==1) {
			UNDEFINED;
		}
		if(SLICE(ctx->size,0,0)==0) {
			ctx->index = UINT(((ctx->Q<<1)|ctx->S));
		}
		else {
			if(ctx->S==1) {
				UNDEFINED;
			}
			ctx->index = UINT(ctx->Q);
			ctx->scale = 3;
		}
	}
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (ctx->scale);
	return rc;
}

/* ld4r_advsimd.xml */
int LD4R_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011010|L=1|R=1|00000|opcode=111|S=0|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFFF000)==0xD60E000) {
		decode_fields32(ENC_LD4R_ASISDLSO_R4, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		OK(ENC_LD4R_ASISDLSO_R4);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011011|L=1|R=1|Rm=xxxxx|opcode=111|S=0|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE0F000)==0xDE0E000) {
		decode_fields32(ENC_LD4R_ASISDLSOP_R4_I, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f) OK(ENC_LD4R_ASISDLSOP_R4_I);
		if(ctx->Rm!=0x1f) OK(ENC_LD4R_ASISDLSOP_RX4_R);
	}
	/* post-decode pcode */
	ctx->init_scale = UINT(SLICE(ctx->opcode,2,1));
	ctx->scale = ctx->init_scale;
	ctx->selem = UINT(((SLICE(ctx->opcode,0,0)<<1)|ctx->R))+1;
	ctx->replicate = FALSE;
	if(ctx->scale==3) {
		if(ctx->L==0 || ctx->S==1) {
			UNDEFINED;
		}
		ctx->scale = UINT(ctx->size);
		ctx->replicate = TRUE;
	}
	else if(ctx->scale==0) {
		ctx->index = UINT(((ctx->Q<<3)|(ctx->S<<2)|ctx->size));
	}
	else if(ctx->scale==1) {
		if(SLICE(ctx->size,0,0)==1) {
			UNDEFINED;
		}
		ctx->index = UINT(((ctx->Q<<2)|(ctx->S<<1)|SLICE(ctx->size,1,1)));
	}
	else if(ctx->scale==2) {
		if(SLICE(ctx->size,1,1)==1) {
			UNDEFINED;
		}
		if(SLICE(ctx->size,0,0)==0) {
			ctx->index = UINT(((ctx->Q<<1)|ctx->S));
		}
		else {
			if(ctx->S==1) {
				UNDEFINED;
			}
			ctx->index = UINT(ctx->Q);
			ctx->scale = 3;
		}
	}
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (ctx->scale);
	return rc;
}

/* ld4_advsimd_mult.xml */
int LD4_advsimd_mult(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011000|L=1|000000|opcode=0000|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFFF000)==0xC400000) {
		decode_fields32(ENC_LD4_ASISDLSE_R4, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		OK(ENC_LD4_ASISDLSE_R4);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011001|L=1|0|Rm=xxxxx|opcode=0000|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE0F000)==0xCC00000) {
		decode_fields32(ENC_LD4_ASISDLSEP_I4_I, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f) OK(ENC_LD4_ASISDLSEP_I4_I);
		if(ctx->Rm!=0x1f) OK(ENC_LD4_ASISDLSEP_R4_R);
	}
	/* post-decode pcode */
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (UINT(ctx->size));
	ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
	if(!ctx->opcode) {
		ctx->rpt = 1;
		ctx->selem = 4;
	}
	else if(ctx->opcode==2) {
		ctx->rpt = 4;
		ctx->selem = 1;
	}
	else if(ctx->opcode==4) {
		ctx->rpt = 1;
		ctx->selem = 3;
	}
	else if(ctx->opcode==6) {
		ctx->rpt = 3;
		ctx->selem = 1;
	}
	else if(ctx->opcode==7) {
		ctx->rpt = 1;
		ctx->selem = 1;
	}
	else if(ctx->opcode==8) {
		ctx->rpt = 1;
		ctx->selem = 2;
	}
	else if(ctx->opcode==10) {
		ctx->rpt = 2;
		ctx->selem = 1;
	}
	else {
		UNDEFINED;
	}
	if(((ctx->size<<1)|ctx->Q)==6 && ctx->selem!=1) {
		UNDEFINED;
	}
	return rc;
}

/* ld4_advsimd_sngl.xml */
int LD4_advsimd_sngl(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011010|L=1|R=1|00000|opcode=xx1|S=x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFF2000)==0xD602000) {
		decode_fields32(ENC_LD4_ASISDLSO_B4_4B, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->opcode==1) OK(ENC_LD4_ASISDLSO_B4_4B);
		if(ctx->opcode==3 && !(ctx->size&1)) OK(ENC_LD4_ASISDLSO_H4_4H);
		if(ctx->opcode==5 && ctx->size==0) OK(ENC_LD4_ASISDLSO_S4_4S);
		if(ctx->opcode==5 && ctx->S==0 && ctx->size==1) OK(ENC_LD4_ASISDLSO_D4_4D);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011011|L=1|R=1|Rm=xxxxx|opcode=xx1|S=x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE02000)==0xDE02000) {
		decode_fields32(ENC_LD4_ASISDLSOP_B4_I4B, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f && ctx->opcode==1) OK(ENC_LD4_ASISDLSOP_B4_I4B);
		if(ctx->Rm!=0x1f && ctx->opcode==1) OK(ENC_LD4_ASISDLSOP_BX4_R4B);
		if(ctx->Rm==0x1f && ctx->opcode==3 && !(ctx->size&1)) OK(ENC_LD4_ASISDLSOP_H4_I4H);
		if(ctx->Rm!=0x1f && ctx->opcode==3 && !(ctx->size&1)) OK(ENC_LD4_ASISDLSOP_HX4_R4H);
		if(ctx->Rm==0x1f && ctx->opcode==5 && ctx->size==0) OK(ENC_LD4_ASISDLSOP_S4_I4S);
		if(ctx->Rm!=0x1f && ctx->opcode==5 && ctx->size==0) OK(ENC_LD4_ASISDLSOP_SX4_R4S);
		if(ctx->Rm==0x1f && ctx->opcode==5 && ctx->S==0 && ctx->size==1) OK(ENC_LD4_ASISDLSOP_D4_I4D);
		if(ctx->Rm!=0x1f && ctx->opcode==5 && ctx->S==0 && ctx->size==1) OK(ENC_LD4_ASISDLSOP_DX4_R4D);
	}
	/* post-decode pcode */
	ctx->init_scale = UINT(SLICE(ctx->opcode,2,1));
	ctx->scale = ctx->init_scale;
	ctx->selem = UINT(((SLICE(ctx->opcode,0,0)<<1)|ctx->R))+1;
	ctx->replicate = FALSE;
	if(ctx->scale==3) {
		if(ctx->L==0 || ctx->S==1) {
			UNDEFINED;
		}
		ctx->scale = UINT(ctx->size);
		ctx->replicate = TRUE;
	}
	else if(ctx->scale==0) {
		ctx->index = UINT(((ctx->Q<<3)|(ctx->S<<2)|ctx->size));
	}
	else if(ctx->scale==1) {
		if(SLICE(ctx->size,0,0)==1) {
			UNDEFINED;
		}
		ctx->index = UINT(((ctx->Q<<2)|(ctx->S<<1)|SLICE(ctx->size,1,1)));
	}
	else if(ctx->scale==2) {
		if(SLICE(ctx->size,1,1)==1) {
			UNDEFINED;
		}
		if(SLICE(ctx->size,0,0)==0) {
			ctx->index = UINT(((ctx->Q<<1)|ctx->S));
		}
		else {
			if(ctx->S==1) {
				UNDEFINED;
			}
			ctx->index = UINT(ctx->Q);
			ctx->scale = 3;
		}
	}
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (ctx->scale);
	return rc;
}

/* ld64b.xml */
int LD64B(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=11|111|V=0|00|A=0|R=0|1|Rs=11111|o3=1|opc=101|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0xF83FD000) {
		decode_fields32(ENC_LD64B_64L_MEMOP, ctx, instr);
		if(!HaveFeatLS64()) {
			UNDEFINED;
		}
		if(SLICE(ctx->Rt,4,3)==3 || SLICE(ctx->Rt,0,0)==1) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->tag_checked = ctx->n!=0x1f;
		OK(ENC_LD64B_64L_MEMOP);
	}
	return rc;
}

/* ldadd.xml */
int LDADD(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=000|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xB8200000) {
		decode_fields32(ENC_LDADD_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STADD_LDADD(ctx, instr);
		if(ctx->size==2 && ctx->A==0 && ctx->R==0) OK(ENC_LDADD_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==0) OK(ENC_LDADDA_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==1) OK(ENC_LDADDAL_32_MEMOP);
		if(ctx->size==2 && ctx->A==0 && ctx->R==1) OK(ENC_LDADDL_32_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==0) OK(ENC_LDADD_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==0) OK(ENC_LDADDA_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==1) OK(ENC_LDADDAL_64_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==1) OK(ENC_LDADDL_64_MEMOP);
	}
	return rc;
}

/* ldaddb.xml */
int LDADDB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=000|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x38200000) {
		decode_fields32(ENC_LDADDAB_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STADDB_LDADDB(ctx, instr);
		if(ctx->A==1 && ctx->R==0) OK(ENC_LDADDAB_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_LDADDALB_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_LDADDB_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_LDADDLB_32_MEMOP);
	}
	return rc;
}

/* ldaddh.xml */
int LDADDH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=000|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x78200000) {
		decode_fields32(ENC_LDADDAH_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STADDH_LDADDH(ctx, instr);
		if(ctx->A==1 && ctx->R==0) OK(ENC_LDADDAH_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_LDADDALH_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_LDADDH_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_LDADDLH_32_MEMOP);
	}
	return rc;
}

/* ldapr.xml */
int LDAPR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=1|R=0|1|Rs=(1)(1)(1)(1)(1)|o3=1|opc=100|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xB8A0C000) {
		decode_fields32(ENC_LDAPR_32L_MEMOP, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = AccType_ORDERED;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		if(ctx->size==2) OK(ENC_LDAPR_32L_MEMOP);
		if(ctx->size==3) OK(ENC_LDAPR_64L_MEMOP);
	}
	return rc;
}

/* ldaprb.xml */
int LDAPRB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=1|R=0|1|Rs=(1)(1)(1)(1)(1)|o3=1|opc=100|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x38A0C000) {
		decode_fields32(ENC_LDAPRB_32L_MEMOP, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = AccType_ORDERED;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		OK(ENC_LDAPRB_32L_MEMOP);
	}
	return rc;
}

/* ldaprh.xml */
int LDAPRH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=1|R=0|1|Rs=(1)(1)(1)(1)(1)|o3=1|opc=100|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x78A0C000) {
		decode_fields32(ENC_LDAPRH_32L_MEMOP, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = AccType_ORDERED;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		OK(ENC_LDAPRH_32L_MEMOP);
	}
	return rc;
}

/* ldapurb.xml */
int LDAPURB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=00|011001|opc=01|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x19400000) {
		decode_fields32(ENC_LDAPURB_32_LDAPSTL_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_LDAPURB_32_LDAPSTL_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = AccType_ORDERED;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldapurh.xml */
int LDAPURH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=01|011001|opc=01|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x59400000) {
		decode_fields32(ENC_LDAPURH_32_LDAPSTL_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_LDAPURH_32_LDAPSTL_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = AccType_ORDERED;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldapursb.xml */
int LDAPURSB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=00|011001|opc=1x|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFA00C00)==0x19800000) {
		decode_fields32(ENC_LDAPURSB_32_LDAPSTL_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->opc==3) OK(ENC_LDAPURSB_32_LDAPSTL_UNSCALED);
		if(ctx->opc==2) OK(ENC_LDAPURSB_64_LDAPSTL_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = AccType_ORDERED;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldapursh.xml */
int LDAPURSH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=01|011001|opc=1x|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFA00C00)==0x59800000) {
		decode_fields32(ENC_LDAPURSH_32_LDAPSTL_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->opc==3) OK(ENC_LDAPURSH_32_LDAPSTL_UNSCALED);
		if(ctx->opc==2) OK(ENC_LDAPURSH_64_LDAPSTL_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = AccType_ORDERED;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldapursw.xml */
int LDAPURSW(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=10|011001|opc=10|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x99800000) {
		decode_fields32(ENC_LDAPURSW_64_LDAPSTL_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_LDAPURSW_64_LDAPSTL_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = AccType_ORDERED;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldapur_gen.xml */
int LDAPUR_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=1x|011001|opc=01|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE00C00)==0x99400000) {
		decode_fields32(ENC_LDAPUR_32_LDAPSTL_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->size==2) OK(ENC_LDAPUR_32_LDAPSTL_UNSCALED);
		if(ctx->size==3) OK(ENC_LDAPUR_64_LDAPSTL_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = AccType_ORDERED;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldar.xml */
int LDAR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=1x|001000|o2=1|L=1|o1=0|Rs=(1)(1)(1)(1)(1)|o0=1|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE08000)==0x88C08000) {
		decode_fields32(ENC_LDAR_LR32_LDSTORD, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==0) ? AccType_LIMITEDORDERED : AccType_ORDERED;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		if(ctx->size==2) OK(ENC_LDAR_LR32_LDSTORD);
		if(ctx->size==3) OK(ENC_LDAR_LR64_LDSTORD);
	}
	return rc;
}

/* ldarb.xml */
int LDARB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=00|001000|o2=1|L=1|o1=0|Rs=(1)(1)(1)(1)(1)|o0=1|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE08000)==0x8C08000) {
		decode_fields32(ENC_LDARB_LR32_LDSTORD, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==0) ? AccType_LIMITEDORDERED : AccType_ORDERED;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		OK(ENC_LDARB_LR32_LDSTORD);
	}
	return rc;
}

/* ldarh.xml */
int LDARH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=01|001000|o2=1|L=1|o1=0|Rs=(1)(1)(1)(1)(1)|o0=1|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE08000)==0x48C08000) {
		decode_fields32(ENC_LDARH_LR32_LDSTORD, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==0) ? AccType_LIMITEDORDERED : AccType_ORDERED;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		OK(ENC_LDARH_LR32_LDSTORD);
	}
	return rc;
}

/* ldaxp.xml */
int LDAXP(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* 1|sz=x|001000|o2=0|L=1|o1=1|Rs=(1)(1)(1)(1)(1)|o0=1|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE08000)==0x88608000) {
		decode_fields32(ENC_LDAXP_LP32_LDSTEXCLP, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==1) ? AccType_ORDEREDATOMIC : AccType_ATOMIC;
		ctx->pair = TRUE;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (0x20) << (UINT(ctx->sz));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = (ctx->pair) ? (ctx->elsize) * (2) : ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		ctx->rt_unknown = FALSE;
		ctx->rn_unknown = FALSE;
		if(ctx->memop==MemOp_LOAD && ctx->pair && ctx->t==ctx->t2) {
			ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
			// assert
			// switch on constraint
		}
		if(ctx->memop==MemOp_STORE) {
			if(ctx->s==ctx->t || (ctx->pair && ctx->s==ctx->t2)) {
				ctx->c = ConstrainUnpredictable(Unpredictable_DATAOVERLAP);
				// assert
				// switch on constraint
			}
			if(ctx->s==ctx->n && ctx->n!=0x1f) {
				ctx->c = ConstrainUnpredictable(Unpredictable_BASEOVERLAP);
				// assert
				// switch on constraint
			}
		}
		if(ctx->sz==0) OK(ENC_LDAXP_LP32_LDSTEXCLP);
		if(ctx->sz==1) OK(ENC_LDAXP_LP64_LDSTEXCLP);
	}
	return rc;
}

/* ldaxr.xml */
int LDAXR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=1x|001000|o2=0|L=1|o1=0|Rs=(1)(1)(1)(1)(1)|o0=1|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE08000)==0x88408000) {
		decode_fields32(ENC_LDAXR_LR32_LDSTEXCLR, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==1) ? AccType_ORDEREDATOMIC : AccType_ATOMIC;
		ctx->pair = FALSE;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = (ctx->pair) ? (ctx->elsize) * (2) : ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		ctx->rt_unknown = FALSE;
		ctx->rn_unknown = FALSE;
		if(ctx->memop==MemOp_LOAD && ctx->pair && ctx->t==ctx->t2) {
			ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
			// assert
			// switch on constraint
		}
		if(ctx->memop==MemOp_STORE) {
			if(ctx->s==ctx->t || (ctx->pair && ctx->s==ctx->t2)) {
				ctx->c = ConstrainUnpredictable(Unpredictable_DATAOVERLAP);
				// assert
				// switch on constraint
			}
			if(ctx->s==ctx->n && ctx->n!=0x1f) {
				ctx->c = ConstrainUnpredictable(Unpredictable_BASEOVERLAP);
				// assert
				// switch on constraint
			}
		}
		if(ctx->size==2) OK(ENC_LDAXR_LR32_LDSTEXCLR);
		if(ctx->size==3) OK(ENC_LDAXR_LR64_LDSTEXCLR);
	}
	return rc;
}

/* ldaxrb.xml */
int LDAXRB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=00|001000|o2=0|L=1|o1=0|Rs=(1)(1)(1)(1)(1)|o0=1|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE08000)==0x8408000) {
		decode_fields32(ENC_LDAXRB_LR32_LDSTEXCLR, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==1) ? AccType_ORDEREDATOMIC : AccType_ATOMIC;
		ctx->pair = FALSE;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = (ctx->pair) ? (ctx->elsize) * (2) : ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		ctx->rt_unknown = FALSE;
		ctx->rn_unknown = FALSE;
		if(ctx->memop==MemOp_LOAD && ctx->pair && ctx->t==ctx->t2) {
			ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
			// assert
			// switch on constraint
		}
		if(ctx->memop==MemOp_STORE) {
			if(ctx->s==ctx->t || (ctx->pair && ctx->s==ctx->t2)) {
				ctx->c = ConstrainUnpredictable(Unpredictable_DATAOVERLAP);
				// assert
				// switch on constraint
			}
			if(ctx->s==ctx->n && ctx->n!=0x1f) {
				ctx->c = ConstrainUnpredictable(Unpredictable_BASEOVERLAP);
				// assert
				// switch on constraint
			}
		}
		OK(ENC_LDAXRB_LR32_LDSTEXCLR);
	}
	return rc;
}

/* ldaxrh.xml */
int LDAXRH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=01|001000|o2=0|L=1|o1=0|Rs=(1)(1)(1)(1)(1)|o0=1|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE08000)==0x48408000) {
		decode_fields32(ENC_LDAXRH_LR32_LDSTEXCLR, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==1) ? AccType_ORDEREDATOMIC : AccType_ATOMIC;
		ctx->pair = FALSE;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = (ctx->pair) ? (ctx->elsize) * (2) : ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		ctx->rt_unknown = FALSE;
		ctx->rn_unknown = FALSE;
		if(ctx->memop==MemOp_LOAD && ctx->pair && ctx->t==ctx->t2) {
			ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
			// assert
			// switch on constraint
		}
		if(ctx->memop==MemOp_STORE) {
			if(ctx->s==ctx->t || (ctx->pair && ctx->s==ctx->t2)) {
				ctx->c = ConstrainUnpredictable(Unpredictable_DATAOVERLAP);
				// assert
				// switch on constraint
			}
			if(ctx->s==ctx->n && ctx->n!=0x1f) {
				ctx->c = ConstrainUnpredictable(Unpredictable_BASEOVERLAP);
				// assert
				// switch on constraint
			}
		}
		OK(ENC_LDAXRH_LR32_LDSTEXCLR);
	}
	return rc;
}

/* ldclr.xml */
int LDCLR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=001|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xB8201000) {
		decode_fields32(ENC_LDCLR_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STCLR_LDCLR(ctx, instr);
		if(ctx->size==2 && ctx->A==0 && ctx->R==0) OK(ENC_LDCLR_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==0) OK(ENC_LDCLRA_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==1) OK(ENC_LDCLRAL_32_MEMOP);
		if(ctx->size==2 && ctx->A==0 && ctx->R==1) OK(ENC_LDCLRL_32_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==0) OK(ENC_LDCLR_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==0) OK(ENC_LDCLRA_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==1) OK(ENC_LDCLRAL_64_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==1) OK(ENC_LDCLRL_64_MEMOP);
	}
	return rc;
}

/* ldclrb.xml */
int LDCLRB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=001|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x38201000) {
		decode_fields32(ENC_LDCLRAB_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STCLRB_LDCLRB(ctx, instr);
		if(ctx->A==1 && ctx->R==0) OK(ENC_LDCLRAB_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_LDCLRALB_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_LDCLRB_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_LDCLRLB_32_MEMOP);
	}
	return rc;
}

/* ldclrh.xml */
int LDCLRH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=001|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x78201000) {
		decode_fields32(ENC_LDCLRAH_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STCLRH_LDCLRH(ctx, instr);
		if(ctx->A==1 && ctx->R==0) OK(ENC_LDCLRAH_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_LDCLRALH_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_LDCLRH_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_LDCLRLH_32_MEMOP);
	}
	return rc;
}

/* ldeor.xml */
int LDEOR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=010|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xB8202000) {
		decode_fields32(ENC_LDEOR_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STEOR_LDEOR(ctx, instr);
		if(ctx->size==2 && ctx->A==0 && ctx->R==0) OK(ENC_LDEOR_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==0) OK(ENC_LDEORA_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==1) OK(ENC_LDEORAL_32_MEMOP);
		if(ctx->size==2 && ctx->A==0 && ctx->R==1) OK(ENC_LDEORL_32_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==0) OK(ENC_LDEOR_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==0) OK(ENC_LDEORA_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==1) OK(ENC_LDEORAL_64_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==1) OK(ENC_LDEORL_64_MEMOP);
	}
	return rc;
}

/* ldeorb.xml */
int LDEORB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=010|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x38202000) {
		decode_fields32(ENC_LDEORAB_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STEORB_LDEORB(ctx, instr);
		if(ctx->A==1 && ctx->R==0) OK(ENC_LDEORAB_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_LDEORALB_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_LDEORB_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_LDEORLB_32_MEMOP);
	}
	return rc;
}

/* ldeorh.xml */
int LDEORH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=010|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x78202000) {
		decode_fields32(ENC_LDEORAH_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STEORH_LDEORH(ctx, instr);
		if(ctx->A==1 && ctx->R==0) OK(ENC_LDEORAH_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_LDEORALH_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_LDEORH_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_LDEORLH_32_MEMOP);
	}
	return rc;
}

/* ldg.xml */
int LDG(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* 11011001|opc=01|1|imm9=xxxxxxxxx|op2=00|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xD9600000) {
		decode_fields32(ENC_LDG_64LOFFSET_LDSTTAGS, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Xt);
		ctx->n = UINT(ctx->Xn);
		ctx->offset = LSL(SignExtend(ctx->imm9,9),LOG2_TAG_GRANULE);
		OK(ENC_LDG_64LOFFSET_LDSTTAGS);
	}
	return rc;
}

/* ldgm.xml */
int LDGM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* 11011001|opc=11|1|imm9=000000000|op2=00|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0xD9E00000) {
		decode_fields32(ENC_LDGM_64BULK_LDSTTAGS, ctx, instr);
		if(!HaveMTE2Ext()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Xt);
		ctx->n = UINT(ctx->Xn);
		OK(ENC_LDGM_64BULK_LDSTTAGS);
	}
	return rc;
}

/* ldlar.xml */
int LDLAR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=1x|001000|o2=1|L=1|o1=0|Rs=(1)(1)(1)(1)(1)|o0=0|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE08000)==0x88C00000) {
		decode_fields32(ENC_LDLAR_LR32_LDSTORD, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==0) ? AccType_LIMITEDORDERED : AccType_ORDERED;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		if(ctx->size==2) OK(ENC_LDLAR_LR32_LDSTORD);
		if(ctx->size==3) OK(ENC_LDLAR_LR64_LDSTORD);
	}
	return rc;
}

/* ldlarb.xml */
int LDLARB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=00|001000|o2=1|L=1|o1=0|Rs=(1)(1)(1)(1)(1)|o0=0|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE08000)==0x8C00000) {
		decode_fields32(ENC_LDLARB_LR32_LDSTORD, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==0) ? AccType_LIMITEDORDERED : AccType_ORDERED;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		OK(ENC_LDLARB_LR32_LDSTORD);
	}
	return rc;
}

/* ldlarh.xml */
int LDLARH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=01|001000|o2=1|L=1|o1=0|Rs=(1)(1)(1)(1)(1)|o0=0|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE08000)==0x48C00000) {
		decode_fields32(ENC_LDLARH_LR32_LDSTORD, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==0) ? AccType_LIMITEDORDERED : AccType_ORDERED;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		OK(ENC_LDLARH_LR32_LDSTORD);
	}
	return rc;
}

/* ldnp_fpsimd.xml */
int LDNP_fpsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_signed_scaled_offset */
	/* opc=xx|101|V=1|000|L=1|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3FC00000)==0x2C400000) {
		decode_fields32(ENC_LDNP_S_LDSTNAPAIR_OFFS, ctx, instr);
		if(ctx->opc==0) OK(ENC_LDNP_S_LDSTNAPAIR_OFFS);
		if(ctx->opc==1) OK(ENC_LDNP_D_LDSTNAPAIR_OFFS);
		if(ctx->opc==2) OK(ENC_LDNP_Q_LDSTNAPAIR_OFFS);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->t2 = UINT(ctx->Rt2);
	ctx->acctype = ctx->AccType_VECSTREAM;
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	if(ctx->opc==3) {
		UNDEFINED;
	}
	ctx->scale = 2+UINT(ctx->opc);
	ctx->datasize = (8) << (ctx->scale);
	ctx->offset = LSL(SignExtend(ctx->imm7,7),ctx->scale);
	ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->t==ctx->t2) {
		ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldnp_gen.xml */
int LDNP_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_signed_scaled_offset */
	/* opc=x0|101|V=0|000|L=1|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x7FC00000)==0x28400000) {
		decode_fields32(ENC_LDNP_32_LDSTNAPAIR_OFFS, ctx, instr);
		if(ctx->opc==0) OK(ENC_LDNP_32_LDSTNAPAIR_OFFS);
		if(ctx->opc==2) OK(ENC_LDNP_64_LDSTNAPAIR_OFFS);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->t2 = UINT(ctx->Rt2);
	ctx->acctype = ctx->AccType_STREAM;
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	if(SLICE(ctx->opc,0,0)==1) {
		UNDEFINED;
	}
	ctx->scale = 2+UINT(SLICE(ctx->opc,1,1));
	ctx->datasize = (8) << (ctx->scale);
	ctx->offset = LSL(SignExtend(ctx->imm7,7),ctx->scale);
	ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->t==ctx->t2) {
		ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldpsw.xml */
int LDPSW(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* opc=01|101|V=0|001|L=1|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFC00000)==0x68C00000) {
		decode_fields32(ENC_LDPSW_64_LDSTPAIR_POST, ctx, instr);
		OK(ENC_LDPSW_64_LDSTPAIR_POST);
	}
	/* class iclass_pre_indexed */
	/* opc=01|101|V=0|011|L=1|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFC00000)==0x69C00000) {
		decode_fields32(ENC_LDPSW_64_LDSTPAIR_PRE, ctx, instr);
		OK(ENC_LDPSW_64_LDSTPAIR_PRE);
	}
	/* class iclass_signed_scaled_offset */
	/* opc=01|101|V=0|010|L=1|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFC00000)==0x69400000) {
		decode_fields32(ENC_LDPSW_64_LDSTPAIR_OFF, ctx, instr);
		OK(ENC_LDPSW_64_LDSTPAIR_OFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->t2 = UINT(ctx->Rt2);
	ctx->acctype = ctx->AccType_NORMAL;
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	if(((ctx->L<<1)|SLICE(ctx->opc,0,0))==1 || ctx->opc==3) {
		UNDEFINED;
	}
	ctx->signed_ = (SLICE(ctx->opc,0,0)!=0);
	ctx->scale = 2+UINT(SLICE(ctx->opc,1,1));
	ctx->datasize = (8) << (ctx->scale);
	ctx->offset = LSL(SignExtend(ctx->imm7,7),ctx->scale);
	ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
	ctx->rt_unknown = FALSE;
	ctx->wb_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && (ctx->t==ctx->n || ctx->t2==ctx->n) && ctx->n!=0x1f) {
		ctx->c = ConstrainUnpredictable(Unpredictable_WBOVERLAPLD);
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && (ctx->t==ctx->n || ctx->t2==ctx->n) && ctx->n!=0x1f) {
		ctx->c = ConstrainUnpredictable(Unpredictable_WBOVERLAPST);
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_LOAD && ctx->t==ctx->t2) {
		ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldp_fpsimd.xml */
int LDP_fpsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* opc=xx|101|V=1|001|L=1|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3FC00000)==0x2CC00000) {
		decode_fields32(ENC_LDP_S_LDSTPAIR_POST, ctx, instr);
		if(ctx->opc==0) OK(ENC_LDP_S_LDSTPAIR_POST);
		if(ctx->opc==1) OK(ENC_LDP_D_LDSTPAIR_POST);
		if(ctx->opc==2) OK(ENC_LDP_Q_LDSTPAIR_POST);
	}
	/* class iclass_pre_indexed */
	/* opc=xx|101|V=1|011|L=1|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3FC00000)==0x2DC00000) {
		decode_fields32(ENC_LDP_S_LDSTPAIR_PRE, ctx, instr);
		if(ctx->opc==0) OK(ENC_LDP_S_LDSTPAIR_PRE);
		if(ctx->opc==1) OK(ENC_LDP_D_LDSTPAIR_PRE);
		if(ctx->opc==2) OK(ENC_LDP_Q_LDSTPAIR_PRE);
	}
	/* class iclass_signed_scaled_offset */
	/* opc=xx|101|V=1|010|L=1|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3FC00000)==0x2D400000) {
		decode_fields32(ENC_LDP_S_LDSTPAIR_OFF, ctx, instr);
		if(ctx->opc==0) OK(ENC_LDP_S_LDSTPAIR_OFF);
		if(ctx->opc==1) OK(ENC_LDP_D_LDSTPAIR_OFF);
		if(ctx->opc==2) OK(ENC_LDP_Q_LDSTPAIR_OFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->t2 = UINT(ctx->Rt2);
	ctx->acctype = ctx->AccType_VEC;
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	if(ctx->opc==3) {
		UNDEFINED;
	}
	ctx->scale = 2+UINT(ctx->opc);
	ctx->datasize = (8) << (ctx->scale);
	ctx->offset = LSL(SignExtend(ctx->imm7,7),ctx->scale);
	ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->t==ctx->t2) {
		ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldp_gen.xml */
int LDP_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* opc=x0|101|V=0|001|L=1|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x7FC00000)==0x28C00000) {
		decode_fields32(ENC_LDP_32_LDSTPAIR_POST, ctx, instr);
		if(ctx->opc==0) OK(ENC_LDP_32_LDSTPAIR_POST);
		if(ctx->opc==2) OK(ENC_LDP_64_LDSTPAIR_POST);
	}
	/* class iclass_pre_indexed */
	/* opc=x0|101|V=0|011|L=1|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x7FC00000)==0x29C00000) {
		decode_fields32(ENC_LDP_32_LDSTPAIR_PRE, ctx, instr);
		if(ctx->opc==0) OK(ENC_LDP_32_LDSTPAIR_PRE);
		if(ctx->opc==2) OK(ENC_LDP_64_LDSTPAIR_PRE);
	}
	/* class iclass_signed_scaled_offset */
	/* opc=x0|101|V=0|010|L=1|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x7FC00000)==0x29400000) {
		decode_fields32(ENC_LDP_32_LDSTPAIR_OFF, ctx, instr);
		if(ctx->opc==0) OK(ENC_LDP_32_LDSTPAIR_OFF);
		if(ctx->opc==2) OK(ENC_LDP_64_LDSTPAIR_OFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->t2 = UINT(ctx->Rt2);
	ctx->acctype = ctx->AccType_NORMAL;
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	if(((ctx->L<<1)|SLICE(ctx->opc,0,0))==1 || ctx->opc==3) {
		UNDEFINED;
	}
	ctx->signed_ = (SLICE(ctx->opc,0,0)!=0);
	ctx->scale = 2+UINT(SLICE(ctx->opc,1,1));
	ctx->datasize = (8) << (ctx->scale);
	ctx->offset = LSL(SignExtend(ctx->imm7,7),ctx->scale);
	ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
	ctx->rt_unknown = FALSE;
	ctx->wb_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && (ctx->t==ctx->n || ctx->t2==ctx->n) && ctx->n!=0x1f) {
		ctx->c = ConstrainUnpredictable(Unpredictable_WBOVERLAPLD);
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && (ctx->t==ctx->n || ctx->t2==ctx->n) && ctx->n!=0x1f) {
		ctx->c = ConstrainUnpredictable(Unpredictable_WBOVERLAPST);
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_LOAD && ctx->t==ctx->t2) {
		ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldra.xml */
int LDRA(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=11|111|V=0|00|M=x|S=x|1|imm9=xxxxxxxxx|W=x|1|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF200400)==0xF8200400) {
		decode_fields32(ENC_LDRAA_64_LDST_PAC, ctx, instr);
		if(!HavePACExt() || ctx->size!=3) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->wback = (ctx->W==1);
		ctx->use_key_a = (ctx->M==0);
		ctx->S10 = ((ctx->S<<9)|ctx->imm9);
		ctx->scale = 3;
		ctx->offset = LSL(SignExtend(ctx->S10,10),ctx->scale);
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->M==0 && ctx->W==0) OK(ENC_LDRAA_64_LDST_PAC);
		if(ctx->M==0 && ctx->W==1) OK(ENC_LDRAA_64W_LDST_PAC);
		if(ctx->M==1 && ctx->W==0) OK(ENC_LDRAB_64_LDST_PAC);
		if(ctx->M==1 && ctx->W==1) OK(ENC_LDRAB_64W_LDST_PAC);
	}
	return rc;
}

/* ldrb_imm.xml */
int LDRB_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* size=00|111|V=0|00|opc=01|0|imm9=xxxxxxxxx|01|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x38400400) {
		decode_fields32(ENC_LDRB_32_LDST_IMMPOST, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = TRUE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_LDRB_32_LDST_IMMPOST);
	}
	/* class iclass_pre_indexed */
	/* size=00|111|V=0|00|opc=01|0|imm9=xxxxxxxxx|11|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x38400C00) {
		decode_fields32(ENC_LDRB_32_LDST_IMMPRE, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_LDRB_32_LDST_IMMPRE);
	}
	/* class iclass_unsigned_scaled_offset */
	/* size=00|111|V=0|01|opc=01|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFC00000)==0x39400000) {
		decode_fields32(ENC_LDRB_32_LDST_POS, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = LSL(ZeroExtend(ctx->imm12,0x40),ctx->scale);
		OK(ENC_LDRB_32_LDST_POS);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldrb_reg.xml */
int LDRB_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_32 */
	/* size=00|111|V=0|00|opc=01|1|Rm=xxxxx|option=xxx|S=x|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x38600800) {
		decode_fields32(ENC_LDRB_32B_LDST_REGOFF, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		if(SLICE(ctx->option,1,1)==0) {
			UNDEFINED;
		}
		ctx->extend_type = DecodeRegExtend(ctx->option);
		ctx->shift = (ctx->S==1) ? ctx->scale : 0;
		if(ctx->option!=3) OK(ENC_LDRB_32B_LDST_REGOFF);
		if(ctx->option==3) OK(ENC_LDRB_32BL_LDST_REGOFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->m = UINT(ctx->Rm);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH;
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldrh_imm.xml */
int LDRH_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* size=01|111|V=0|00|opc=01|0|imm9=xxxxxxxxx|01|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x78400400) {
		decode_fields32(ENC_LDRH_32_LDST_IMMPOST, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = TRUE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_LDRH_32_LDST_IMMPOST);
	}
	/* class iclass_pre_indexed */
	/* size=01|111|V=0|00|opc=01|0|imm9=xxxxxxxxx|11|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x78400C00) {
		decode_fields32(ENC_LDRH_32_LDST_IMMPRE, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_LDRH_32_LDST_IMMPRE);
	}
	/* class iclass_unsigned_scaled_offset */
	/* size=01|111|V=0|01|opc=01|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFC00000)==0x79400000) {
		decode_fields32(ENC_LDRH_32_LDST_POS, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = LSL(ZeroExtend(ctx->imm12,0x40),ctx->scale);
		OK(ENC_LDRH_32_LDST_POS);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldrh_reg.xml */
int LDRH_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_32 */
	/* size=01|111|V=0|00|opc=01|1|Rm=xxxxx|option=xxx|S=x|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x78600800) {
		decode_fields32(ENC_LDRH_32_LDST_REGOFF, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		if(SLICE(ctx->option,1,1)==0) {
			UNDEFINED;
		}
		ctx->extend_type = DecodeRegExtend(ctx->option);
		ctx->shift = (ctx->S==1) ? ctx->scale : 0;
		OK(ENC_LDRH_32_LDST_REGOFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->m = UINT(ctx->Rm);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH;
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldrsb_imm.xml */
int LDRSB_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* size=00|111|V=0|00|opc=1x|0|imm9=xxxxxxxxx|01|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFA00C00)==0x38800400) {
		decode_fields32(ENC_LDRSB_32_LDST_IMMPOST, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = TRUE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->opc==3) OK(ENC_LDRSB_32_LDST_IMMPOST);
		if(ctx->opc==2) OK(ENC_LDRSB_64_LDST_IMMPOST);
	}
	/* class iclass_pre_indexed */
	/* size=00|111|V=0|00|opc=1x|0|imm9=xxxxxxxxx|11|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFA00C00)==0x38800C00) {
		decode_fields32(ENC_LDRSB_32_LDST_IMMPRE, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->opc==3) OK(ENC_LDRSB_32_LDST_IMMPRE);
		if(ctx->opc==2) OK(ENC_LDRSB_64_LDST_IMMPRE);
	}
	/* class iclass_unsigned_scaled_offset */
	/* size=00|111|V=0|01|opc=1x|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF800000)==0x39800000) {
		decode_fields32(ENC_LDRSB_32_LDST_POS, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = LSL(ZeroExtend(ctx->imm12,0x40),ctx->scale);
		if(ctx->opc==3) OK(ENC_LDRSB_32_LDST_POS);
		if(ctx->opc==2) OK(ENC_LDRSB_64_LDST_POS);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldrsb_reg.xml */
int LDRSB_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|opc=1x|1|Rm=xxxxx|option=xxx|S=x|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFA00C00)==0x38A00800) {
		decode_fields32(ENC_LDRSB_32B_LDST_REGOFF, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		if(SLICE(ctx->option,1,1)==0) {
			UNDEFINED;
		}
		ctx->extend_type = DecodeRegExtend(ctx->option);
		ctx->shift = (ctx->S==1) ? ctx->scale : 0;
		if(ctx->opc==3 && ctx->option!=3) OK(ENC_LDRSB_32B_LDST_REGOFF);
		if(ctx->opc==3 && ctx->option==3) OK(ENC_LDRSB_32BL_LDST_REGOFF);
		if(ctx->opc==2 && ctx->option!=3) OK(ENC_LDRSB_64B_LDST_REGOFF);
		if(ctx->opc==2 && ctx->option==3) OK(ENC_LDRSB_64BL_LDST_REGOFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->m = UINT(ctx->Rm);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH;
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldrsh_imm.xml */
int LDRSH_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* size=01|111|V=0|00|opc=1x|0|imm9=xxxxxxxxx|01|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFA00C00)==0x78800400) {
		decode_fields32(ENC_LDRSH_32_LDST_IMMPOST, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = TRUE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->opc==3) OK(ENC_LDRSH_32_LDST_IMMPOST);
		if(ctx->opc==2) OK(ENC_LDRSH_64_LDST_IMMPOST);
	}
	/* class iclass_pre_indexed */
	/* size=01|111|V=0|00|opc=1x|0|imm9=xxxxxxxxx|11|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFA00C00)==0x78800C00) {
		decode_fields32(ENC_LDRSH_32_LDST_IMMPRE, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->opc==3) OK(ENC_LDRSH_32_LDST_IMMPRE);
		if(ctx->opc==2) OK(ENC_LDRSH_64_LDST_IMMPRE);
	}
	/* class iclass_unsigned_scaled_offset */
	/* size=01|111|V=0|01|opc=1x|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF800000)==0x79800000) {
		decode_fields32(ENC_LDRSH_32_LDST_POS, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = LSL(ZeroExtend(ctx->imm12,0x40),ctx->scale);
		if(ctx->opc==3) OK(ENC_LDRSH_32_LDST_POS);
		if(ctx->opc==2) OK(ENC_LDRSH_64_LDST_POS);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldrsh_reg.xml */
int LDRSH_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|opc=1x|1|Rm=xxxxx|option=xxx|S=x|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFA00C00)==0x78A00800) {
		decode_fields32(ENC_LDRSH_32_LDST_REGOFF, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		if(SLICE(ctx->option,1,1)==0) {
			UNDEFINED;
		}
		ctx->extend_type = DecodeRegExtend(ctx->option);
		ctx->shift = (ctx->S==1) ? ctx->scale : 0;
		if(ctx->opc==3) OK(ENC_LDRSH_32_LDST_REGOFF);
		if(ctx->opc==2) OK(ENC_LDRSH_64_LDST_REGOFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->m = UINT(ctx->Rm);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH;
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldrsw_imm.xml */
int LDRSW_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* size=10|111|V=0|00|opc=10|0|imm9=xxxxxxxxx|01|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xB8800400) {
		decode_fields32(ENC_LDRSW_64_LDST_IMMPOST, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = TRUE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_LDRSW_64_LDST_IMMPOST);
	}
	/* class iclass_pre_indexed */
	/* size=10|111|V=0|00|opc=10|0|imm9=xxxxxxxxx|11|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xB8800C00) {
		decode_fields32(ENC_LDRSW_64_LDST_IMMPRE, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_LDRSW_64_LDST_IMMPRE);
	}
	/* class iclass_unsigned_scaled_offset */
	/* size=10|111|V=0|01|opc=10|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFC00000)==0xB9800000) {
		decode_fields32(ENC_LDRSW_64_LDST_POS, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = LSL(ZeroExtend(ctx->imm12,0x40),ctx->scale);
		OK(ENC_LDRSW_64_LDST_POS);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldrsw_lit.xml */
int LDRSW_lit(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_literal */
	/* opc=10|011|V=0|00|imm19=xxxxxxxxxxxxxxxxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF000000)==0x98000000) {
		decode_fields32(ENC_LDRSW_64_LOADLIT, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->memop = MemOp_LOAD;
		ctx->signed_ = FALSE;
		if(!ctx->opc) {
			ctx->size = 4;
		}
		else if(ctx->opc==1) {
			ctx->size = 8;
		}
		else if(ctx->opc==2) {
			ctx->size = 4;
			ctx->signed_ = TRUE;
		}
		else if(ctx->opc==3) {
			ctx->memop = MemOp_PREFETCH;
		}
		ctx->offset = SignExtend((ctx->imm19<<2),21);
		ctx->tag_checked = FALSE;
		OK(ENC_LDRSW_64_LOADLIT);
	}
	return rc;
}

/* ldrsw_reg.xml */
int LDRSW_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_64 */
	/* size=10|111|V=0|00|opc=10|1|Rm=xxxxx|option=xxx|S=x|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xB8A00800) {
		decode_fields32(ENC_LDRSW_64_LDST_REGOFF, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		if(SLICE(ctx->option,1,1)==0) {
			UNDEFINED;
		}
		ctx->extend_type = DecodeRegExtend(ctx->option);
		ctx->shift = (ctx->S==1) ? ctx->scale : 0;
		OK(ENC_LDRSW_64_LDST_REGOFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->m = UINT(ctx->Rm);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH;
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldr_imm_fpsimd.xml */
int LDR_imm_fpsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* size=xx|111|V=1|00|opc=x1|0|imm9=xxxxxxxxx|01|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3F600C00)==0x3C400400) {
		decode_fields32(ENC_LDR_B_LDST_IMMPOST, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = TRUE;
		ctx->scale = UINT(((SLICE(ctx->opc,1,1)<<2)|ctx->size));
		if(ctx->scale>4) {
			UNDEFINED;
		}
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->size==0 && ctx->opc==1) OK(ENC_LDR_B_LDST_IMMPOST);
		if(ctx->size==1 && ctx->opc==1) OK(ENC_LDR_H_LDST_IMMPOST);
		if(ctx->size==2 && ctx->opc==1) OK(ENC_LDR_S_LDST_IMMPOST);
		if(ctx->size==3 && ctx->opc==1) OK(ENC_LDR_D_LDST_IMMPOST);
		if(ctx->size==0 && ctx->opc==3) OK(ENC_LDR_Q_LDST_IMMPOST);
	}
	/* class iclass_pre_indexed */
	/* size=xx|111|V=1|00|opc=x1|0|imm9=xxxxxxxxx|11|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3F600C00)==0x3C400C00) {
		decode_fields32(ENC_LDR_B_LDST_IMMPRE, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(((SLICE(ctx->opc,1,1)<<2)|ctx->size));
		if(ctx->scale>4) {
			UNDEFINED;
		}
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->size==0 && ctx->opc==1) OK(ENC_LDR_B_LDST_IMMPRE);
		if(ctx->size==1 && ctx->opc==1) OK(ENC_LDR_H_LDST_IMMPRE);
		if(ctx->size==2 && ctx->opc==1) OK(ENC_LDR_S_LDST_IMMPRE);
		if(ctx->size==3 && ctx->opc==1) OK(ENC_LDR_D_LDST_IMMPRE);
		if(ctx->size==0 && ctx->opc==3) OK(ENC_LDR_Q_LDST_IMMPRE);
	}
	/* class iclass_unsigned_scaled_offset */
	/* size=xx|111|V=1|01|opc=x1|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3F400000)==0x3D400000) {
		decode_fields32(ENC_LDR_B_LDST_POS, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(((SLICE(ctx->opc,1,1)<<2)|ctx->size));
		if(ctx->scale>4) {
			UNDEFINED;
		}
		ctx->offset = LSL(ZeroExtend(ctx->imm12,0x40),ctx->scale);
		if(ctx->size==0 && ctx->opc==1) OK(ENC_LDR_B_LDST_POS);
		if(ctx->size==1 && ctx->opc==1) OK(ENC_LDR_H_LDST_POS);
		if(ctx->size==2 && ctx->opc==1) OK(ENC_LDR_S_LDST_POS);
		if(ctx->size==3 && ctx->opc==1) OK(ENC_LDR_D_LDST_POS);
		if(ctx->size==0 && ctx->opc==3) OK(ENC_LDR_Q_LDST_POS);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_VEC;
	ctx->memop = (SLICE(ctx->opc,0,0)==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	return rc;
}

/* ldr_imm_gen.xml */
int LDR_imm_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* size=1x|111|V=0|00|opc=01|0|imm9=xxxxxxxxx|01|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE00C00)==0xB8400400) {
		decode_fields32(ENC_LDR_32_LDST_IMMPOST, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = TRUE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->size==2) OK(ENC_LDR_32_LDST_IMMPOST);
		if(ctx->size==3) OK(ENC_LDR_64_LDST_IMMPOST);
	}
	/* class iclass_pre_indexed */
	/* size=1x|111|V=0|00|opc=01|0|imm9=xxxxxxxxx|11|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE00C00)==0xB8400C00) {
		decode_fields32(ENC_LDR_32_LDST_IMMPRE, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->size==2) OK(ENC_LDR_32_LDST_IMMPRE);
		if(ctx->size==3) OK(ENC_LDR_64_LDST_IMMPRE);
	}
	/* class iclass_unsigned_scaled_offset */
	/* size=1x|111|V=0|01|opc=01|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFC00000)==0xB9400000) {
		decode_fields32(ENC_LDR_32_LDST_POS, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = LSL(ZeroExtend(ctx->imm12,0x40),ctx->scale);
		if(ctx->size==2) OK(ENC_LDR_32_LDST_POS);
		if(ctx->size==3) OK(ENC_LDR_64_LDST_POS);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldr_lit_fpsimd.xml */
int LDR_lit_fpsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_literal */
	/* opc=xx|011|V=1|00|imm19=xxxxxxxxxxxxxxxxxxx|Rt=xxxxx */
	if((INSWORD & 0x3F000000)==0x1C000000) {
		decode_fields32(ENC_LDR_S_LOADLIT, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		if(!ctx->opc) {
			ctx->size = 4;
		}
		else if(ctx->opc==1) {
			ctx->size = 8;
		}
		else if(ctx->opc==2) {
			ctx->size = 0x10;
		}
		else if(ctx->opc==3) {
			UNDEFINED;
		}
		ctx->offset = SignExtend((ctx->imm19<<2),21);
		ctx->tag_checked = FALSE;
		if(ctx->opc==0) OK(ENC_LDR_S_LOADLIT);
		if(ctx->opc==1) OK(ENC_LDR_D_LOADLIT);
		if(ctx->opc==2) OK(ENC_LDR_Q_LOADLIT);
	}
	return rc;
}

/* ldr_lit_gen.xml */
int LDR_lit_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_literal */
	/* opc=0x|011|V=0|00|imm19=xxxxxxxxxxxxxxxxxxx|Rt=xxxxx */
	if((INSWORD & 0xBF000000)==0x18000000) {
		decode_fields32(ENC_LDR_32_LOADLIT, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->memop = MemOp_LOAD;
		ctx->signed_ = FALSE;
		if(!ctx->opc) {
			ctx->size = 4;
		}
		else if(ctx->opc==1) {
			ctx->size = 8;
		}
		else if(ctx->opc==2) {
			ctx->size = 4;
			ctx->signed_ = TRUE;
		}
		else if(ctx->opc==3) {
			ctx->memop = MemOp_PREFETCH;
		}
		ctx->offset = SignExtend((ctx->imm19<<2),21);
		ctx->tag_checked = FALSE;
		if(ctx->opc==0) OK(ENC_LDR_32_LOADLIT);
		if(ctx->opc==1) OK(ENC_LDR_64_LOADLIT);
	}
	return rc;
}

/* ldr_reg_fpsimd.xml */
int LDR_reg_fpsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_fpsimd */
	/* size=xx|111|V=1|00|opc=x1|1|Rm=xxxxx|option=xxx|S=x|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3F600C00)==0x3C600800) {
		decode_fields32(ENC_LDR_B_LDST_REGOFF, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(((SLICE(ctx->opc,1,1)<<2)|ctx->size));
		if(ctx->scale>4) {
			UNDEFINED;
		}
		if(SLICE(ctx->option,1,1)==0) {
			UNDEFINED;
		}
		ctx->extend_type = DecodeRegExtend(ctx->option);
		ctx->shift = (ctx->S==1) ? ctx->scale : 0;
		if(ctx->size==0 && ctx->opc==1 && ctx->option!=3) OK(ENC_LDR_B_LDST_REGOFF);
		if(ctx->size==0 && ctx->opc==1 && ctx->option==3) OK(ENC_LDR_BL_LDST_REGOFF);
		if(ctx->size==1 && ctx->opc==1) OK(ENC_LDR_H_LDST_REGOFF);
		if(ctx->size==2 && ctx->opc==1) OK(ENC_LDR_S_LDST_REGOFF);
		if(ctx->size==3 && ctx->opc==1) OK(ENC_LDR_D_LDST_REGOFF);
		if(ctx->size==0 && ctx->opc==3) OK(ENC_LDR_Q_LDST_REGOFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->m = UINT(ctx->Rm);
	ctx->acctype = ctx->AccType_VEC;
	ctx->memop = (SLICE(ctx->opc,0,0)==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH;
	return rc;
}

/* ldr_reg_gen.xml */
int LDR_reg_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|opc=01|1|Rm=xxxxx|option=xxx|S=x|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE00C00)==0xB8600800) {
		decode_fields32(ENC_LDR_32_LDST_REGOFF, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		if(SLICE(ctx->option,1,1)==0) {
			UNDEFINED;
		}
		ctx->extend_type = DecodeRegExtend(ctx->option);
		ctx->shift = (ctx->S==1) ? ctx->scale : 0;
		if(ctx->size==2) OK(ENC_LDR_32_LDST_REGOFF);
		if(ctx->size==3) OK(ENC_LDR_64_LDST_REGOFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->m = UINT(ctx->Rm);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH;
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldset.xml */
int LDSET(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=011|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xB8203000) {
		decode_fields32(ENC_LDSET_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STSET_LDSET(ctx, instr);
		if(ctx->size==2 && ctx->A==0 && ctx->R==0) OK(ENC_LDSET_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==0) OK(ENC_LDSETA_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==1) OK(ENC_LDSETAL_32_MEMOP);
		if(ctx->size==2 && ctx->A==0 && ctx->R==1) OK(ENC_LDSETL_32_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==0) OK(ENC_LDSET_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==0) OK(ENC_LDSETA_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==1) OK(ENC_LDSETAL_64_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==1) OK(ENC_LDSETL_64_MEMOP);
	}
	return rc;
}

/* ldsetb.xml */
int LDSETB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=011|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x38203000) {
		decode_fields32(ENC_LDSETAB_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STSETB_LDSETB(ctx, instr);
		if(ctx->A==1 && ctx->R==0) OK(ENC_LDSETAB_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_LDSETALB_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_LDSETB_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_LDSETLB_32_MEMOP);
	}
	return rc;
}

/* ldseth.xml */
int LDSETH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=011|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x78203000) {
		decode_fields32(ENC_LDSETAH_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STSETH_LDSETH(ctx, instr);
		if(ctx->A==1 && ctx->R==0) OK(ENC_LDSETAH_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_LDSETALH_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_LDSETH_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_LDSETLH_32_MEMOP);
	}
	return rc;
}

/* ldsmax.xml */
int LDSMAX(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=100|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xB8204000) {
		decode_fields32(ENC_LDSMAX_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STSMAX_LDSMAX(ctx, instr);
		if(ctx->size==2 && ctx->A==0 && ctx->R==0) OK(ENC_LDSMAX_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==0) OK(ENC_LDSMAXA_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==1) OK(ENC_LDSMAXAL_32_MEMOP);
		if(ctx->size==2 && ctx->A==0 && ctx->R==1) OK(ENC_LDSMAXL_32_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==0) OK(ENC_LDSMAX_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==0) OK(ENC_LDSMAXA_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==1) OK(ENC_LDSMAXAL_64_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==1) OK(ENC_LDSMAXL_64_MEMOP);
	}
	return rc;
}

/* ldsmaxb.xml */
int LDSMAXB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=100|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x38204000) {
		decode_fields32(ENC_LDSMAXAB_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STSMAXB_LDSMAXB(ctx, instr);
		if(ctx->A==1 && ctx->R==0) OK(ENC_LDSMAXAB_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_LDSMAXALB_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_LDSMAXB_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_LDSMAXLB_32_MEMOP);
	}
	return rc;
}

/* ldsmaxh.xml */
int LDSMAXH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=100|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x78204000) {
		decode_fields32(ENC_LDSMAXAH_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STSMAXH_LDSMAXH(ctx, instr);
		if(ctx->A==1 && ctx->R==0) OK(ENC_LDSMAXAH_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_LDSMAXALH_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_LDSMAXH_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_LDSMAXLH_32_MEMOP);
	}
	return rc;
}

/* ldsmin.xml */
int LDSMIN(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=101|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xB8205000) {
		decode_fields32(ENC_LDSMIN_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STSMIN_LDSMIN(ctx, instr);
		if(ctx->size==2 && ctx->A==0 && ctx->R==0) OK(ENC_LDSMIN_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==0) OK(ENC_LDSMINA_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==1) OK(ENC_LDSMINAL_32_MEMOP);
		if(ctx->size==2 && ctx->A==0 && ctx->R==1) OK(ENC_LDSMINL_32_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==0) OK(ENC_LDSMIN_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==0) OK(ENC_LDSMINA_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==1) OK(ENC_LDSMINAL_64_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==1) OK(ENC_LDSMINL_64_MEMOP);
	}
	return rc;
}

/* ldsminb.xml */
int LDSMINB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=101|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x38205000) {
		decode_fields32(ENC_LDSMINAB_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STSMINB_LDSMINB(ctx, instr);
		if(ctx->A==1 && ctx->R==0) OK(ENC_LDSMINAB_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_LDSMINALB_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_LDSMINB_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_LDSMINLB_32_MEMOP);
	}
	return rc;
}

/* ldsminh.xml */
int LDSMINH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=101|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x78205000) {
		decode_fields32(ENC_LDSMINAH_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STSMINH_LDSMINH(ctx, instr);
		if(ctx->A==1 && ctx->R==0) OK(ENC_LDSMINAH_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_LDSMINALH_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_LDSMINH_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_LDSMINLH_32_MEMOP);
	}
	return rc;
}

/* ldtr.xml */
int LDTR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=1x|111|V=0|00|opc=01|0|imm9=xxxxxxxxx|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE00C00)==0xB8400800) {
		decode_fields32(ENC_LDTR_32_LDST_UNPRIV, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->size==2) OK(ENC_LDTR_32_LDST_UNPRIV);
		if(ctx->size==3) OK(ENC_LDTR_64_LDST_UNPRIV);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->unpriv_at_el1 = ctx->pstate_el==EL1 && !(EL2Enabled() && HaveNVExt() && CONCAT(ctx->HCR_EL2_NV,ctx->HCR_EL2_NV1,1)==3);
	ctx->unpriv_at_el2 = ctx->pstate_el==EL2 && HaveVirtHostExt() && CONCAT(ctx->HCR_EL2_E2H,ctx->HCR_EL2_TGE,1)==3;
	ctx->user_access_override = HaveUAOExt() && ctx->pstate_uao==1;
	if(!ctx->user_access_override && (ctx->unpriv_at_el1 || ctx->unpriv_at_el2)) {
		ctx->acctype = ctx->AccType_UNPRIV;
	}
	else {
		ctx->acctype = ctx->AccType_NORMAL;
	}
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldtrb.xml */
int LDTRB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=00|111|V=0|00|opc=01|0|imm9=xxxxxxxxx|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x38400800) {
		decode_fields32(ENC_LDTRB_32_LDST_UNPRIV, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_LDTRB_32_LDST_UNPRIV);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->unpriv_at_el1 = ctx->pstate_el==EL1 && !(EL2Enabled() && HaveNVExt() && CONCAT(ctx->HCR_EL2_NV,ctx->HCR_EL2_NV1,1)==3);
	ctx->unpriv_at_el2 = ctx->pstate_el==EL2 && HaveVirtHostExt() && CONCAT(ctx->HCR_EL2_E2H,ctx->HCR_EL2_TGE,1)==3;
	ctx->user_access_override = HaveUAOExt() && ctx->pstate_uao==1;
	if(!ctx->user_access_override && (ctx->unpriv_at_el1 || ctx->unpriv_at_el2)) {
		ctx->acctype = ctx->AccType_UNPRIV;
	}
	else {
		ctx->acctype = ctx->AccType_NORMAL;
	}
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldtrh.xml */
int LDTRH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=01|111|V=0|00|opc=01|0|imm9=xxxxxxxxx|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x78400800) {
		decode_fields32(ENC_LDTRH_32_LDST_UNPRIV, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_LDTRH_32_LDST_UNPRIV);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->unpriv_at_el1 = ctx->pstate_el==EL1 && !(EL2Enabled() && HaveNVExt() && CONCAT(ctx->HCR_EL2_NV,ctx->HCR_EL2_NV1,1)==3);
	ctx->unpriv_at_el2 = ctx->pstate_el==EL2 && HaveVirtHostExt() && CONCAT(ctx->HCR_EL2_E2H,ctx->HCR_EL2_TGE,1)==3;
	ctx->user_access_override = HaveUAOExt() && ctx->pstate_uao==1;
	if(!ctx->user_access_override && (ctx->unpriv_at_el1 || ctx->unpriv_at_el2)) {
		ctx->acctype = ctx->AccType_UNPRIV;
	}
	else {
		ctx->acctype = ctx->AccType_NORMAL;
	}
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldtrsb.xml */
int LDTRSB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=00|111|V=0|00|opc=1x|0|imm9=xxxxxxxxx|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFA00C00)==0x38800800) {
		decode_fields32(ENC_LDTRSB_32_LDST_UNPRIV, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->opc==3) OK(ENC_LDTRSB_32_LDST_UNPRIV);
		if(ctx->opc==2) OK(ENC_LDTRSB_64_LDST_UNPRIV);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->unpriv_at_el1 = ctx->pstate_el==EL1 && !(EL2Enabled() && HaveNVExt() && CONCAT(ctx->HCR_EL2_NV,ctx->HCR_EL2_NV1,1)==3);
	ctx->unpriv_at_el2 = ctx->pstate_el==EL2 && HaveVirtHostExt() && CONCAT(ctx->HCR_EL2_E2H,ctx->HCR_EL2_TGE,1)==3;
	ctx->user_access_override = HaveUAOExt() && ctx->pstate_uao==1;
	if(!ctx->user_access_override && (ctx->unpriv_at_el1 || ctx->unpriv_at_el2)) {
		ctx->acctype = ctx->AccType_UNPRIV;
	}
	else {
		ctx->acctype = ctx->AccType_NORMAL;
	}
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldtrsh.xml */
int LDTRSH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=01|111|V=0|00|opc=1x|0|imm9=xxxxxxxxx|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFA00C00)==0x78800800) {
		decode_fields32(ENC_LDTRSH_32_LDST_UNPRIV, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->opc==3) OK(ENC_LDTRSH_32_LDST_UNPRIV);
		if(ctx->opc==2) OK(ENC_LDTRSH_64_LDST_UNPRIV);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->unpriv_at_el1 = ctx->pstate_el==EL1 && !(EL2Enabled() && HaveNVExt() && CONCAT(ctx->HCR_EL2_NV,ctx->HCR_EL2_NV1,1)==3);
	ctx->unpriv_at_el2 = ctx->pstate_el==EL2 && HaveVirtHostExt() && CONCAT(ctx->HCR_EL2_E2H,ctx->HCR_EL2_TGE,1)==3;
	ctx->user_access_override = HaveUAOExt() && ctx->pstate_uao==1;
	if(!ctx->user_access_override && (ctx->unpriv_at_el1 || ctx->unpriv_at_el2)) {
		ctx->acctype = ctx->AccType_UNPRIV;
	}
	else {
		ctx->acctype = ctx->AccType_NORMAL;
	}
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldtrsw.xml */
int LDTRSW(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=10|111|V=0|00|opc=10|0|imm9=xxxxxxxxx|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xB8800800) {
		decode_fields32(ENC_LDTRSW_64_LDST_UNPRIV, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_LDTRSW_64_LDST_UNPRIV);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->unpriv_at_el1 = ctx->pstate_el==EL1 && !(EL2Enabled() && HaveNVExt() && CONCAT(ctx->HCR_EL2_NV,ctx->HCR_EL2_NV1,1)==3);
	ctx->unpriv_at_el2 = ctx->pstate_el==EL2 && HaveVirtHostExt() && CONCAT(ctx->HCR_EL2_E2H,ctx->HCR_EL2_TGE,1)==3;
	ctx->user_access_override = HaveUAOExt() && ctx->pstate_uao==1;
	if(!ctx->user_access_override && (ctx->unpriv_at_el1 || ctx->unpriv_at_el2)) {
		ctx->acctype = ctx->AccType_UNPRIV;
	}
	else {
		ctx->acctype = ctx->AccType_NORMAL;
	}
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldumax.xml */
int LDUMAX(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=110|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xB8206000) {
		decode_fields32(ENC_LDUMAX_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STUMAX_LDUMAX(ctx, instr);
		if(ctx->size==2 && ctx->A==0 && ctx->R==0) OK(ENC_LDUMAX_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==0) OK(ENC_LDUMAXA_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==1) OK(ENC_LDUMAXAL_32_MEMOP);
		if(ctx->size==2 && ctx->A==0 && ctx->R==1) OK(ENC_LDUMAXL_32_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==0) OK(ENC_LDUMAX_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==0) OK(ENC_LDUMAXA_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==1) OK(ENC_LDUMAXAL_64_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==1) OK(ENC_LDUMAXL_64_MEMOP);
	}
	return rc;
}

/* ldumaxb.xml */
int LDUMAXB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=110|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x38206000) {
		decode_fields32(ENC_LDUMAXAB_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STUMAXB_LDUMAXB(ctx, instr);
		if(ctx->A==1 && ctx->R==0) OK(ENC_LDUMAXAB_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_LDUMAXALB_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_LDUMAXB_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_LDUMAXLB_32_MEMOP);
	}
	return rc;
}

/* ldumaxh.xml */
int LDUMAXH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=110|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x78206000) {
		decode_fields32(ENC_LDUMAXAH_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STUMAXH_LDUMAXH(ctx, instr);
		if(ctx->A==1 && ctx->R==0) OK(ENC_LDUMAXAH_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_LDUMAXALH_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_LDUMAXH_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_LDUMAXLH_32_MEMOP);
	}
	return rc;
}

/* ldumin.xml */
int LDUMIN(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=111|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xB8207000) {
		decode_fields32(ENC_LDUMIN_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STUMIN_LDUMIN(ctx, instr);
		if(ctx->size==2 && ctx->A==0 && ctx->R==0) OK(ENC_LDUMIN_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==0) OK(ENC_LDUMINA_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==1) OK(ENC_LDUMINAL_32_MEMOP);
		if(ctx->size==2 && ctx->A==0 && ctx->R==1) OK(ENC_LDUMINL_32_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==0) OK(ENC_LDUMIN_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==0) OK(ENC_LDUMINA_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==1) OK(ENC_LDUMINAL_64_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==1) OK(ENC_LDUMINL_64_MEMOP);
	}
	return rc;
}

/* lduminb.xml */
int LDUMINB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=111|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x38207000) {
		decode_fields32(ENC_LDUMINAB_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STUMINB_LDUMINB(ctx, instr);
		if(ctx->A==1 && ctx->R==0) OK(ENC_LDUMINAB_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_LDUMINALB_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_LDUMINB_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_LDUMINLB_32_MEMOP);
	}
	return rc;
}

/* lduminh.xml */
int LDUMINH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=0|opc=111|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x78207000) {
		decode_fields32(ENC_LDUMINAH_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		if(!ctx->opc) {
			ctx->op = MemAtomicOp_ADD;
		}
		else if(ctx->opc==1) {
			ctx->op = MemAtomicOp_BIC;
		}
		else if(ctx->opc==2) {
			ctx->op = MemAtomicOp_EOR;
		}
		else if(ctx->opc==3) {
			ctx->op = MemAtomicOp_ORR;
		}
		else if(ctx->opc==4) {
			ctx->op = MemAtomicOp_SMAX;
		}
		else if(ctx->opc==5) {
			ctx->op = MemAtomicOp_SMIN;
		}
		else if(ctx->opc==6) {
			ctx->op = MemAtomicOp_UMAX;
		}
		else if(ctx->opc==7) {
			ctx->op = MemAtomicOp_UMIN;
		}
		ctx->tag_checked = ctx->n!=0x1f;
		/* regular aliases */
		if(ctx->A==0 && ctx->Rt==0x1f) return STUMINH_LDUMINH(ctx, instr);
		if(ctx->A==1 && ctx->R==0) OK(ENC_LDUMINAH_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_LDUMINALH_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_LDUMINH_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_LDUMINLH_32_MEMOP);
	}
	return rc;
}

/* ldurb.xml */
int LDURB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=00|111|V=0|00|opc=01|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x38400000) {
		decode_fields32(ENC_LDURB_32_LDST_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_LDURB_32_LDST_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldurh.xml */
int LDURH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=01|111|V=0|00|opc=01|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x78400000) {
		decode_fields32(ENC_LDURH_32_LDST_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_LDURH_32_LDST_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldursb.xml */
int LDURSB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=00|111|V=0|00|opc=1x|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFA00C00)==0x38800000) {
		decode_fields32(ENC_LDURSB_32_LDST_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->opc==3) OK(ENC_LDURSB_32_LDST_UNSCALED);
		if(ctx->opc==2) OK(ENC_LDURSB_64_LDST_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldursh.xml */
int LDURSH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=01|111|V=0|00|opc=1x|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFA00C00)==0x78800000) {
		decode_fields32(ENC_LDURSH_32_LDST_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->opc==3) OK(ENC_LDURSH_32_LDST_UNSCALED);
		if(ctx->opc==2) OK(ENC_LDURSH_64_LDST_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldursw.xml */
int LDURSW(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=10|111|V=0|00|opc=10|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xB8800000) {
		decode_fields32(ENC_LDURSW_64_LDST_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_LDURSW_64_LDST_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldur_fpsimd.xml */
int LDUR_fpsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=xx|111|V=1|00|opc=x1|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3F600C00)==0x3C400000) {
		decode_fields32(ENC_LDUR_B_LDST_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(((SLICE(ctx->opc,1,1)<<2)|ctx->size));
		if(ctx->scale>4) {
			UNDEFINED;
		}
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->size==0 && ctx->opc==1) OK(ENC_LDUR_B_LDST_UNSCALED);
		if(ctx->size==1 && ctx->opc==1) OK(ENC_LDUR_H_LDST_UNSCALED);
		if(ctx->size==2 && ctx->opc==1) OK(ENC_LDUR_S_LDST_UNSCALED);
		if(ctx->size==3 && ctx->opc==1) OK(ENC_LDUR_D_LDST_UNSCALED);
		if(ctx->size==0 && ctx->opc==3) OK(ENC_LDUR_Q_LDST_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_VEC;
	ctx->memop = (SLICE(ctx->opc,0,0)==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	return rc;
}

/* ldur_gen.xml */
int LDUR_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=1x|111|V=0|00|opc=01|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE00C00)==0xB8400000) {
		decode_fields32(ENC_LDUR_32_LDST_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->size==2) OK(ENC_LDUR_32_LDST_UNSCALED);
		if(ctx->size==3) OK(ENC_LDUR_64_LDST_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* ldxp.xml */
int LDXP(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* 1|sz=x|001000|o2=0|L=1|o1=1|Rs=(1)(1)(1)(1)(1)|o0=0|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE08000)==0x88600000) {
		decode_fields32(ENC_LDXP_LP32_LDSTEXCLP, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==1) ? AccType_ORDEREDATOMIC : AccType_ATOMIC;
		ctx->pair = TRUE;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (0x20) << (UINT(ctx->sz));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = (ctx->pair) ? (ctx->elsize) * (2) : ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		ctx->rt_unknown = FALSE;
		ctx->rn_unknown = FALSE;
		if(ctx->memop==MemOp_LOAD && ctx->pair && ctx->t==ctx->t2) {
			ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
			// assert
			// switch on constraint
		}
		if(ctx->memop==MemOp_STORE) {
			if(ctx->s==ctx->t || (ctx->pair && ctx->s==ctx->t2)) {
				ctx->c = ConstrainUnpredictable(Unpredictable_DATAOVERLAP);
				// assert
				// switch on constraint
			}
			if(ctx->s==ctx->n && ctx->n!=0x1f) {
				ctx->c = ConstrainUnpredictable(Unpredictable_BASEOVERLAP);
				// assert
				// switch on constraint
			}
		}
		if(ctx->sz==0) OK(ENC_LDXP_LP32_LDSTEXCLP);
		if(ctx->sz==1) OK(ENC_LDXP_LP64_LDSTEXCLP);
	}
	return rc;
}

/* ldxr.xml */
int LDXR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=1x|001000|o2=0|L=1|o1=0|Rs=(1)(1)(1)(1)(1)|o0=0|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE08000)==0x88400000) {
		decode_fields32(ENC_LDXR_LR32_LDSTEXCLR, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==1) ? AccType_ORDEREDATOMIC : AccType_ATOMIC;
		ctx->pair = FALSE;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = (ctx->pair) ? (ctx->elsize) * (2) : ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		ctx->rt_unknown = FALSE;
		ctx->rn_unknown = FALSE;
		if(ctx->memop==MemOp_LOAD && ctx->pair && ctx->t==ctx->t2) {
			ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
			// assert
			// switch on constraint
		}
		if(ctx->memop==MemOp_STORE) {
			if(ctx->s==ctx->t || (ctx->pair && ctx->s==ctx->t2)) {
				ctx->c = ConstrainUnpredictable(Unpredictable_DATAOVERLAP);
				// assert
				// switch on constraint
			}
			if(ctx->s==ctx->n && ctx->n!=0x1f) {
				ctx->c = ConstrainUnpredictable(Unpredictable_BASEOVERLAP);
				// assert
				// switch on constraint
			}
		}
		if(ctx->size==2) OK(ENC_LDXR_LR32_LDSTEXCLR);
		if(ctx->size==3) OK(ENC_LDXR_LR64_LDSTEXCLR);
	}
	return rc;
}

/* ldxrb.xml */
int LDXRB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=00|001000|o2=0|L=1|o1=0|Rs=(1)(1)(1)(1)(1)|o0=0|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE08000)==0x8400000) {
		decode_fields32(ENC_LDXRB_LR32_LDSTEXCLR, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==1) ? AccType_ORDEREDATOMIC : AccType_ATOMIC;
		ctx->pair = FALSE;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = (ctx->pair) ? (ctx->elsize) * (2) : ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		ctx->rt_unknown = FALSE;
		ctx->rn_unknown = FALSE;
		if(ctx->memop==MemOp_LOAD && ctx->pair && ctx->t==ctx->t2) {
			ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
			// assert
			// switch on constraint
		}
		if(ctx->memop==MemOp_STORE) {
			if(ctx->s==ctx->t || (ctx->pair && ctx->s==ctx->t2)) {
				ctx->c = ConstrainUnpredictable(Unpredictable_DATAOVERLAP);
				// assert
				// switch on constraint
			}
			if(ctx->s==ctx->n && ctx->n!=0x1f) {
				ctx->c = ConstrainUnpredictable(Unpredictable_BASEOVERLAP);
				// assert
				// switch on constraint
			}
		}
		OK(ENC_LDXRB_LR32_LDSTEXCLR);
	}
	return rc;
}

/* ldxrh.xml */
int LDXRH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=01|001000|o2=0|L=1|o1=0|Rs=(1)(1)(1)(1)(1)|o0=0|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE08000)==0x48400000) {
		decode_fields32(ENC_LDXRH_LR32_LDSTEXCLR, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==1) ? AccType_ORDEREDATOMIC : AccType_ATOMIC;
		ctx->pair = FALSE;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = (ctx->pair) ? (ctx->elsize) * (2) : ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		ctx->rt_unknown = FALSE;
		ctx->rn_unknown = FALSE;
		if(ctx->memop==MemOp_LOAD && ctx->pair && ctx->t==ctx->t2) {
			ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
			// assert
			// switch on constraint
		}
		if(ctx->memop==MemOp_STORE) {
			if(ctx->s==ctx->t || (ctx->pair && ctx->s==ctx->t2)) {
				ctx->c = ConstrainUnpredictable(Unpredictable_DATAOVERLAP);
				// assert
				// switch on constraint
			}
			if(ctx->s==ctx->n && ctx->n!=0x1f) {
				ctx->c = ConstrainUnpredictable(Unpredictable_BASEOVERLAP);
				// assert
				// switch on constraint
			}
		}
		OK(ENC_LDXRH_LR32_LDSTEXCLR);
	}
	return rc;
}

/* lslv.xml */
int LSLV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=0|S=0|11010110|Rm=xxxxx|opcode2<5:2>=0010|op2=00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0FC00)==0x1AC02000) {
		decode_fields32(ENC_LSLV_32_DP_2SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->shift_type = DecodeShift(ctx->op2);
		/* unconditional alias */
		if(LSL_LSLV(ctx, instr)==0) return 0;
		if(ctx->sf==0) OK(ENC_LSLV_32_DP_2SRC);
		if(ctx->sf==1) OK(ENC_LSLV_64_DP_2SRC);
	}
	return rc;
}

/* lsl_lslv.xml */
int LSL_LSLV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=0|S=0|11010110|Rm=xxxxx|opcode2<5:2>=0010|op2=00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0FC00)==0x1AC02000) {
		decode_fields32(ENC_LSL_LSLV_32_DP_2SRC, ctx, instr);
		if(ctx->sf==0) OK(ENC_LSL_LSLV_32_DP_2SRC);
		if(ctx->sf==1) OK(ENC_LSL_LSLV_64_DP_2SRC);
	}
	return rc;
}

/* lsl_ubfm.xml */
int LSL_UBFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_zero_fill */
	/* sf=x|opc=10|100110|N=x|immr=xxxxxx|imms=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x53000000) {
		decode_fields32(ENC_LSL_UBFM_32M_BITFIELD, ctx, instr);
		if(ctx->sf==0 && ctx->N==0 && ctx->imms!=0x1f) OK(ENC_LSL_UBFM_32M_BITFIELD);
		if(ctx->sf==1 && ctx->N==1 && ctx->imms!=0x3f) OK(ENC_LSL_UBFM_64M_BITFIELD);
	}
	return rc;
}

/* lsrv.xml */
int LSRV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=0|S=0|11010110|Rm=xxxxx|opcode2<5:2>=0010|op2=01|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0FC00)==0x1AC02400) {
		decode_fields32(ENC_LSRV_32_DP_2SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->shift_type = DecodeShift(ctx->op2);
		/* unconditional alias */
		if(LSR_LSRV(ctx, instr)==0) return 0;
		if(ctx->sf==0) OK(ENC_LSRV_32_DP_2SRC);
		if(ctx->sf==1) OK(ENC_LSRV_64_DP_2SRC);
	}
	return rc;
}

/* lsr_lsrv.xml */
int LSR_LSRV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=0|S=0|11010110|Rm=xxxxx|opcode2<5:2>=0010|op2=01|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0FC00)==0x1AC02400) {
		decode_fields32(ENC_LSR_LSRV_32_DP_2SRC, ctx, instr);
		if(ctx->sf==0) OK(ENC_LSR_LSRV_32_DP_2SRC);
		if(ctx->sf==1) OK(ENC_LSR_LSRV_64_DP_2SRC);
	}
	return rc;
}

/* lsr_ubfm.xml */
int LSR_UBFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_zero_fill */
	/* sf=x|opc=10|100110|N=x|immr=xxxxxx|imms=x11111|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F807C00)==0x53007C00) {
		decode_fields32(ENC_LSR_UBFM_32M_BITFIELD, ctx, instr);
		if(ctx->sf==0 && ctx->N==0 && ctx->imms==0x1f) OK(ENC_LSR_UBFM_32M_BITFIELD);
		if(ctx->sf==1 && ctx->N==1 && ctx->imms==0x3f) OK(ENC_LSR_UBFM_64M_BITFIELD);
	}
	return rc;
}

/* madd.xml */
int MADD(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op54=00|11011|op31=000|Rm=xxxxx|o0=0|Ra=xxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE08000)==0x1B000000) {
		decode_fields32(ENC_MADD_32A_DP_3SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->a = UINT(ctx->Ra);
		ctx->destsize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->datasize = ctx->destsize;
		ctx->sub_op = (ctx->o0==1);
		/* regular aliases */
		if(ctx->Ra==0x1f) return MUL_MADD(ctx, instr);
		if(ctx->sf==0) OK(ENC_MADD_32A_DP_3SRC);
		if(ctx->sf==1) OK(ENC_MADD_64A_DP_3SRC);
	}
	return rc;
}

/* mla_advsimd_elt.xml */
int MLA_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_element */
	/* 0|Q=x|U=1|01111|size=xx|L=x|M=x|Rm=xxxx|0|o2=0|00|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0x2F000000) {
		decode_fields32(ENC_MLA_ASIMDELEM_R, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_MLA_ASIMDELEM_R);
	}
	return rc;
}

/* mla_advsimd_vec.xml */
int MLA_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|opcode=10010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE209400) {
		decode_fields32(ENC_MLA_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->U==1);
		OK(ENC_MLA_ASIMDSAME_ONLY);
	}
	return rc;
}

/* mls_advsimd_elt.xml */
int MLS_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_element */
	/* 0|Q=x|U=1|01111|size=xx|L=x|M=x|Rm=xxxx|0|o2=1|00|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0x2F004000) {
		decode_fields32(ENC_MLS_ASIMDELEM_R, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_MLS_ASIMDELEM_R);
	}
	return rc;
}

/* mls_advsimd_vec.xml */
int MLS_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|opcode=10010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E209400) {
		decode_fields32(ENC_MLS_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->U==1);
		OK(ENC_MLS_ASIMDSAME_ONLY);
	}
	return rc;
}

/* mneg_msub.xml */
int MNEG_MSUB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op54=00|11011|op31=000|Rm=xxxxx|o0=1|Ra=11111|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0FC00)==0x1B00FC00) {
		decode_fields32(ENC_MNEG_MSUB_32A_DP_3SRC, ctx, instr);
		if(ctx->sf==0) OK(ENC_MNEG_MSUB_32A_DP_3SRC);
		if(ctx->sf==1) OK(ENC_MNEG_MSUB_64A_DP_3SRC);
	}
	return rc;
}

/* movi_advsimd.xml */
int MOVI_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|op=x|0111100000|a=x|b=x|c=x|cmode=xxxx|o2=0|1|d=x|e=x|f=x|g=x|h=x|Rd=xxxxx */
	if((INSWORD & 0x9FF80C00)==0xF000400) {
		decode_fields32(ENC_MOVI_ASIMDIMM_N_B, ctx, instr);
		ctx->rd = UINT(ctx->Rd);
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		if(!(((ctx->cmode<<1)|ctx->op)&0x13)) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x13)==1) {
			ctx->operation_ = ImmediateOp_MVNI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x13)==2) {
			ctx->operation_ = ImmediateOp_ORR;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x13)==3) {
			ctx->operation_ = ImmediateOp_BIC;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x10) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x11) {
			ctx->operation_ = ImmediateOp_MVNI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x12) {
			ctx->operation_ = ImmediateOp_ORR;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x13) {
			ctx->operation_ = ImmediateOp_BIC;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1d)==0x18) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1d)==0x19) {
			ctx->operation_ = ImmediateOp_MVNI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1e)==0x1c) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if(((ctx->cmode<<1)|ctx->op)==0x1e) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if(((ctx->cmode<<1)|ctx->op)==0x1f) {
			if(ctx->Q==0) {
				UNDEFINED;
			}
			ctx->operation_ = ImmediateOp_MOVI;
		}
		ctx->imm64 = AdvSIMDExpandImm(ctx->op,ctx->cmode,((ctx->a<<7)|(ctx->b<<6)|(ctx->c<<5)|(ctx->d<<4)|(ctx->e<<3)|(ctx->f<<2)|(ctx->g<<1)|ctx->h));
		ctx->imm = Replicate(ctx->imm64, ((0x40) ? ((ctx->datasize) / (0x40)) : 0), 64);
		if(ctx->op==0 && ctx->cmode==14) OK(ENC_MOVI_ASIMDIMM_N_B);
		if(ctx->op==0 && (ctx->cmode&13)==8) OK(ENC_MOVI_ASIMDIMM_L_HL);
		if(ctx->op==0 && !(ctx->cmode&9)) OK(ENC_MOVI_ASIMDIMM_L_SL);
		if(ctx->op==0 && (ctx->cmode&14)==12) OK(ENC_MOVI_ASIMDIMM_M_SM);
		if(ctx->Q==0 && ctx->op==1 && ctx->cmode==14) OK(ENC_MOVI_ASIMDIMM_D_DS);
		if(ctx->Q==1 && ctx->op==1 && ctx->cmode==14) OK(ENC_MOVI_ASIMDIMM_D2_D);
	}
	return rc;
}

/* movk.xml */
int MOVK(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_imm18_packed */
	/* sf=x|opc=11|100101|hw=xx|imm16=xxxxxxxxxxxxxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x72800000) {
		decode_fields32(ENC_MOVK_32_MOVEWIDE, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->imm = ctx->imm16;
		if(!ctx->opc) {
			ctx->opcode = MoveWideOp_N;
		}
		else if(ctx->opc==2) {
			ctx->opcode = MoveWideOp_Z;
		}
		else if(ctx->opc==3) {
			ctx->opcode = MoveWideOp_K;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && SLICE(ctx->hw,1,1)==1) {
			UNDEFINED;
		}
		ctx->pos = UINT((ctx->hw<<4));
		if(ctx->sf==0 && !(ctx->hw&2)) OK(ENC_MOVK_32_MOVEWIDE);
		if(ctx->sf==1) OK(ENC_MOVK_64_MOVEWIDE);
	}
	return rc;
}

/* movn.xml */
int MOVN(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_imm18_packed */
	/* sf=x|opc=00|100101|hw=xx|imm16=xxxxxxxxxxxxxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x12800000) {
		decode_fields32(ENC_MOVN_32_MOVEWIDE, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->imm = ctx->imm16;
		if(!ctx->opc) {
			ctx->opcode = MoveWideOp_N;
		}
		else if(ctx->opc==2) {
			ctx->opcode = MoveWideOp_Z;
		}
		else if(ctx->opc==3) {
			ctx->opcode = MoveWideOp_K;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && SLICE(ctx->hw,1,1)==1) {
			UNDEFINED;
		}
		ctx->pos = UINT((ctx->hw<<4));
		/* regular aliases */
		bool encoding32 = ctx->sf==0 && !(ctx->hw&2);
		bool encoding64 = ctx->sf==1;
		if((!(IsZero(ctx->imm16) && ctx->hw!=0) && EncodingLabeled64Bit()) || (!(IsZero(ctx->imm16) && ctx->hw!=0) && !IsOnes(ctx->imm16,16) && EncodingLabeled32Bit())) return MOV_MOVN(ctx, instr);
		if(ctx->sf==0 && !(ctx->hw&2)) OK(ENC_MOVN_32_MOVEWIDE);
		if(ctx->sf==1) OK(ENC_MOVN_64_MOVEWIDE);
	}
	return rc;
}

/* movs_and_p_p_pp.xml */
int MOVS_and_p_p_pp(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* 00100101|op=0|S=1|00|Pm=xxxx|01|Pg=xxxx|o2=0|Pn=xxxx|o3=0|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x25404000) {
		decode_fields32(ENC_MOVS_ANDS_P_P_PP_Z, ctx, instr);
		OK(ENC_MOVS_ANDS_P_P_PP_Z);
	}
	return rc;
}

/* movs_orr_p_p_pp.xml */
int MOVS_orr_p_p_pp(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* 00100101|op=1|S=1|00|Pm=xxxx|01|Pg=xxxx|o2=0|Pn=xxxx|o3=0|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x25C04000) {
		decode_fields32(ENC_MOVS_ORRS_P_P_PP_Z, ctx, instr);
		OK(ENC_MOVS_ORRS_P_P_PP_Z);
	}
	return rc;
}

/* movz.xml */
int MOVZ(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_imm18_packed */
	/* sf=x|opc=10|100101|hw=xx|imm16=xxxxxxxxxxxxxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x52800000) {
		decode_fields32(ENC_MOVZ_32_MOVEWIDE, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->imm = ctx->imm16;
		if(!ctx->opc) {
			ctx->opcode = MoveWideOp_N;
		}
		else if(ctx->opc==2) {
			ctx->opcode = MoveWideOp_Z;
		}
		else if(ctx->opc==3) {
			ctx->opcode = MoveWideOp_K;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && SLICE(ctx->hw,1,1)==1) {
			UNDEFINED;
		}
		ctx->pos = UINT((ctx->hw<<4));
		/* regular aliases */
		if(!(IsZero(ctx->imm16) && ctx->hw!=0)) return MOV_MOVZ(ctx, instr);
		if(ctx->sf==0 && !(ctx->hw&2)) OK(ENC_MOVZ_32_MOVEWIDE);
		if(ctx->sf==1) OK(ENC_MOVZ_64_MOVEWIDE);
	}
	return rc;
}

/* mov_add_addsub_imm.xml */
int MOV_ADD_addsub_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|op=0|S=0|100010|sh=0|imm12=000000000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FFFFC00)==0x11000000) {
		decode_fields32(ENC_MOV_ADD_32_ADDSUB_IMM, ctx, instr);
		if(ctx->sf==0) OK(ENC_MOV_ADD_32_ADDSUB_IMM);
		if(ctx->sf==1) OK(ENC_MOV_ADD_64_ADDSUB_IMM);
	}
	return rc;
}

/* mov_dup_advsimd_elt.xml */
int MOV_DUP_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_scalar_from_element */
	/* 01|op=0|11110000|imm5=xxxxx|0|imm4=0000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x5E000400) {
		decode_fields32(ENC_MOV_DUP_ASISDONE_ONLY, ctx, instr);
		OK(ENC_MOV_DUP_ASISDONE_ONLY);
	}
	return rc;
}

/* mov_ins_advsimd_elt.xml */
int MOV_INS_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=1|op=1|01110000|imm5=xxxxx|0|imm4=xxxx|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE08400)==0x6E000400) {
		decode_fields32(ENC_MOV_INS_ASIMDINS_IV_V, ctx, instr);
		OK(ENC_MOV_INS_ASIMDINS_IV_V);
	}
	return rc;
}

/* mov_ins_advsimd_gen.xml */
int MOV_INS_advsimd_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=1|op=0|01110000|imm5=xxxxx|0|imm4=0011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x4E001C00) {
		decode_fields32(ENC_MOV_INS_ASIMDINS_IR_R, ctx, instr);
		OK(ENC_MOV_INS_ASIMDINS_IR_R);
	}
	return rc;
}

/* mov_movn.xml */
int MOV_MOVN(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_imm18_packed */
	/* sf=x|opc=00|100101|hw=xx|imm16=xxxxxxxxxxxxxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x12800000) {
		decode_fields32(ENC_MOV_MOVN_32_MOVEWIDE, ctx, instr);
		if(ctx->sf==0 && !(ctx->hw&2)) OK(ENC_MOV_MOVN_32_MOVEWIDE);
		if(ctx->sf==1) OK(ENC_MOV_MOVN_64_MOVEWIDE);
	}
	return rc;
}

/* mov_movz.xml */
int MOV_MOVZ(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_imm18_packed */
	/* sf=x|opc=10|100101|hw=xx|imm16=xxxxxxxxxxxxxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x52800000) {
		decode_fields32(ENC_MOV_MOVZ_32_MOVEWIDE, ctx, instr);
		if(ctx->sf==0 && !(ctx->hw&2)) OK(ENC_MOV_MOVZ_32_MOVEWIDE);
		if(ctx->sf==1) OK(ENC_MOV_MOVZ_64_MOVEWIDE);
	}
	return rc;
}

/* mov_orr_advsimd_reg.xml */
int MOV_ORR_advsimd_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=10|1|Rm=xxxxx|opcode=00011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xEA01C00) {
		decode_fields32(ENC_MOV_ORR_ASIMDSAME_ONLY, ctx, instr);
		OK(ENC_MOV_ORR_ASIMDSAME_ONLY);
	}
	return rc;
}

/* mov_orr_log_imm.xml */
int MOV_ORR_log_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|opc=01|100100|N=x|immr=xxxxxx|imms=xxxxxx|Rn=11111|Rd=xxxxx */
	if((INSWORD & 0x7F8003E0)==0x320003E0) {
		decode_fields32(ENC_MOV_ORR_32_LOG_IMM, ctx, instr);
		if(ctx->sf==0 && ctx->N==0) OK(ENC_MOV_ORR_32_LOG_IMM);
		if(ctx->sf==1) OK(ENC_MOV_ORR_64_LOG_IMM);
	}
	return rc;
}

/* mov_orr_log_shift.xml */
int MOV_ORR_log_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|opc=01|01010|shift=00|N=0|Rm=xxxxx|imm6=000000|Rn=11111|Rd=xxxxx */
	if((INSWORD & 0x7FE0FFE0)==0x2A0003E0) {
		decode_fields32(ENC_MOV_ORR_32_LOG_SHIFT, ctx, instr);
		if(ctx->sf==0) OK(ENC_MOV_ORR_32_LOG_SHIFT);
		if(ctx->sf==1) OK(ENC_MOV_ORR_64_LOG_SHIFT);
	}
	return rc;
}

/* mov_umov_advsimd.xml */
int MOV_UMOV_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|op=0|01110000|imm5=xxx00|0|imm4<3:2>=01|imm4=11|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE3FC00)==0xE003C00) {
		decode_fields32(ENC_MOV_UMOV_ASIMDINS_W_W, ctx, instr);
		if(ctx->Q==0 && (ctx->imm5&7)==4) OK(ENC_MOV_UMOV_ASIMDINS_W_W);
		if(ctx->Q==1 && (ctx->imm5&15)==8) OK(ENC_MOV_UMOV_ASIMDINS_X_X);
	}
	return rc;
}

/* mov_and_p_p_pp.xml */
int MOV_and_p_p_pp(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* 00100101|op=0|S=0|00|Pm=xxxx|01|Pg=xxxx|o2=0|Pn=xxxx|o3=0|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x25004000) {
		decode_fields32(ENC_MOV_AND_P_P_PP_Z, ctx, instr);
		OK(ENC_MOV_AND_P_P_PP_Z);
	}
	return rc;
}

/* mov_cpy_z_o_i.xml */
int MOV_cpy_z_o_i(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|01|Pg=xxxx|0|M=0|sh=x|imm8=xxxxxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF30C000)==0x5100000) {
		decode_fields32(ENC_MOV_CPY_Z_O_I_, ctx, instr);
		OK(ENC_MOV_CPY_Z_O_I_);
	}
	return rc;
}

/* mov_cpy_z_p_i.xml */
int MOV_cpy_z_p_i(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|01|Pg=xxxx|0|M=1|sh=x|imm8=xxxxxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF30C000)==0x5104000) {
		decode_fields32(ENC_MOV_CPY_Z_P_I_, ctx, instr);
		OK(ENC_MOV_CPY_Z_P_I_);
	}
	return rc;
}

/* mov_cpy_z_p_r.xml */
int MOV_cpy_z_p_r(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|101000101|Pg=xxx|Rn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x528A000) {
		decode_fields32(ENC_MOV_CPY_Z_P_R_, ctx, instr);
		OK(ENC_MOV_CPY_Z_P_R_);
	}
	return rc;
}

/* mov_cpy_z_p_v.xml */
int MOV_cpy_z_p_v(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|100000100|Pg=xxx|Vn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x5208000) {
		decode_fields32(ENC_MOV_CPY_Z_P_V_, ctx, instr);
		OK(ENC_MOV_CPY_Z_P_V_);
	}
	return rc;
}

/* mov_dup_z_i.xml */
int MOV_dup_z_i(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00100101|size=xx|111|opc=00|011|sh=x|imm8=xxxxxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FC000)==0x2538C000) {
		decode_fields32(ENC_MOV_DUP_Z_I_, ctx, instr);
		OK(ENC_MOV_DUP_Z_I_);
	}
	return rc;
}

/* mov_dup_z_r.xml */
int MOV_dup_z_r(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|100000001110|Rn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x5203800) {
		decode_fields32(ENC_MOV_DUP_Z_R_, ctx, instr);
		OK(ENC_MOV_DUP_Z_R_);
	}
	return rc;
}

/* mov_dup_z_zi.xml */
int MOV_dup_z_zi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|imm2=xx|1|tsz=xxxxx|001000|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x5202000) {
		decode_fields32(ENC_MOV_DUP_Z_ZI_, ctx, instr);
		if(BitCount(((ctx->imm2<<5)|ctx->tsz))==1) OK(ENC_MOV_DUP_Z_ZI_);
		if(BitCount(((ctx->imm2<<5)|ctx->tsz))>1) OK(ENC_MOV_DUP_Z_ZI_2);
	}
	return rc;
}

/* mov_dupm_z_i.xml */
int MOV_dupm_z_i(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101110000|imm13=xxxxxxxxxxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFC0000)==0x5C00000) {
		decode_fields32(ENC_MOV_DUPM_Z_I_, ctx, instr);
		OK(ENC_MOV_DUPM_Z_I_);
	}
	return rc;
}

/* mov_orr_p_p_pp.xml */
int MOV_orr_p_p_pp(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* 00100101|op=1|S=0|00|Pm=xxxx|01|Pg=xxxx|o2=0|Pn=xxxx|o3=0|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x25804000) {
		decode_fields32(ENC_MOV_ORR_P_P_PP_Z, ctx, instr);
		OK(ENC_MOV_ORR_P_P_PP_Z);
	}
	return rc;
}

/* mov_orr_z_zz.xml */
int MOV_orr_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|opc=01|1|Zm=xxxxx|001100|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x4603000) {
		decode_fields32(ENC_MOV_ORR_Z_ZZ_, ctx, instr);
		OK(ENC_MOV_ORR_Z_ZZ_);
	}
	return rc;
}

/* mov_sel_p_p_pp.xml */
int MOV_sel_p_p_pp(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00100101|op=0|S=0|00|Pm=xxxx|01|Pg=xxxx|o2=1|Pn=xxxx|o3=1|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x25004210) {
		decode_fields32(ENC_MOV_SEL_P_P_PP_, ctx, instr);
		OK(ENC_MOV_SEL_P_P_PP_);
	}
	return rc;
}

/* mov_sel_z_p_zz.xml */
int MOV_sel_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|1|Zm=xxxxx|11|Pg=xxxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF20C000)==0x520C000) {
		decode_fields32(ENC_MOV_SEL_Z_P_ZZ_, ctx, instr);
		OK(ENC_MOV_SEL_Z_P_ZZ_);
	}
	return rc;
}

/* mrs.xml */
int MRS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=1|op0<1>=1|o0=x|op1=xxx|CRn=xxxx|CRm=xxxx|op2=xxx|Rt=xxxxx */
	if((INSWORD & 0xFFF00000)==0xD5300000) {
		decode_fields32(ENC_MRS_RS_SYSTEMMOVE, ctx, instr);
		CheckSystemAccess(((1<<1)|ctx->o0),ctx->op1,ctx->CRn,ctx->CRm,ctx->op2,ctx->Rt,ctx->L);
		ctx->t = UINT(ctx->Rt);
		ctx->sys_op0 = 2+UINT(ctx->o0);
		ctx->sys_op1 = UINT(ctx->op1);
		ctx->sys_op2 = UINT(ctx->op2);
		ctx->sys_crn = UINT(ctx->CRn);
		ctx->sys_crm = UINT(ctx->CRm);
		ctx->read = (ctx->L==1);
		OK(ENC_MRS_RS_SYSTEMMOVE);
	}
	return rc;
}

/* msr_imm.xml */
int MSR_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=xxx|CRn=0100|CRm=xxxx|op2=xxx|Rt =11111 */
	if((INSWORD & 0xFFF8F01F)==0xD500401F) {
		decode_fields32(ENC_MSR_SI_PSTATE, ctx, instr);
		if(ctx->op1==0 && ctx->op2==0) {
			SEE /* CFINV */;
		}
		if(ctx->op1==0 && ctx->op2==1) {
			SEE /* XAFLAG */;
		}
		if(ctx->op1==0 && ctx->op2==2) {
			SEE /* AXFLAG */;
		}
		CheckSystemAccess(0,ctx->op1,4,ctx->CRm,ctx->op2,0x1f,0);
		ctx->need_secure = FALSE;
		if(!(ctx->op1&6)) {
			ctx->min_EL = EL1;
		}
		else if(ctx->op1==2) {
			ctx->min_EL = EL1;
		}
		else if(ctx->op1==3) {
			ctx->min_EL = EL0;
		}
		else if(ctx->op1==4) {
			ctx->min_EL = EL2;
		}
		else if(ctx->op1==5) {
			if(!HaveVirtHostExt()) {
				UNDEFINED;
			}
			ctx->min_EL = EL2;
		}
		else if(ctx->op1==6) {
			ctx->min_EL = EL3;
		}
		else if(ctx->op1==7) {
			ctx->min_EL = EL1;
			ctx->need_secure = TRUE;
		}
		/* if(UINT(ctx->pstate_el)<UINT(ctx->min_EL) || (ctx->need_secure && !IsSecure())) { UNDEFINED; } */
		ctx->operand = ctx->CRm;
		if(((ctx->op1<<3)|ctx->op2)==3) {
			if(!HaveUAOExt()) {
				UNDEFINED;
			}
			ctx->field = PSTATEField_UAO;
		}
		else if(((ctx->op1<<3)|ctx->op2)==4) {
			if(!HavePANExt()) {
				UNDEFINED;
			}
			ctx->field = PSTATEField_PAN;
		}
		else if(((ctx->op1<<3)|ctx->op2)==5) {
			ctx->field = PSTATEField_SP;
		}
		else if(((ctx->op1<<3)|ctx->op2)==0x1a) {
			if(!HaveDITExt()) {
				UNDEFINED;
			}
			ctx->field = PSTATEField_DIT;
		}
		else if(((ctx->op1<<3)|ctx->op2)==0x1c) {
			if(!HaveMTEExt()) {
				UNDEFINED;
			}
			ctx->field = PSTATEField_TCO;
		}
		else if(((ctx->op1<<3)|ctx->op2)==0x1e) {
			ctx->field = PSTATEField_DAIFSet;
		}
		else if(((ctx->op1<<3)|ctx->op2)==0x1f) {
			ctx->field = PSTATEField_DAIFClr;
		}
		else if(((ctx->op1<<3)|ctx->op2)==0x19) {
			if(!HaveSSBSExt()) {
				UNDEFINED;
			}
			ctx->field = PSTATEField_SSBS;
		}
		else {
			UNDEFINED;
		}
		/* if(ctx->pstate_el==EL0 && (ctx->field==PSTATEField_DAIFSet || ctx->field==PSTATEField_DAIFClr)) { if(!ELUsingAArch32(EL1) && ((EL2Enabled() && CONCAT(ctx->HCR_EL2_E2H,ctx->HCR_EL2_TGE,1)==3) || ctx->SCTLR_EL1_UMA==0)) {	if(EL2Enabled() && !ELUsingAArch32(EL2) && ctx->HCR_EL2_TGE==1) {		SystemAccessTrap(EL2,0x18);	}	else {		SystemAccessTrap(EL1,0x18);	}} } */
		OK(ENC_MSR_SI_PSTATE);
	}
	return rc;
}

/* msr_reg.xml */
int MSR_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0<1>=1|o0=x|op1=xxx|CRn=xxxx|CRm=xxxx|op2=xxx|Rt=xxxxx */
	if((INSWORD & 0xFFF00000)==0xD5100000) {
		decode_fields32(ENC_MSR_SR_SYSTEMMOVE, ctx, instr);
		CheckSystemAccess(((1<<1)|ctx->o0),ctx->op1,ctx->CRn,ctx->CRm,ctx->op2,ctx->Rt,ctx->L);
		ctx->t = UINT(ctx->Rt);
		ctx->sys_op0 = 2+UINT(ctx->o0);
		ctx->sys_op1 = UINT(ctx->op1);
		ctx->sys_op2 = UINT(ctx->op2);
		ctx->sys_crn = UINT(ctx->CRn);
		ctx->sys_crm = UINT(ctx->CRm);
		ctx->read = (ctx->L==1);
		OK(ENC_MSR_SR_SYSTEMMOVE);
	}
	return rc;
}

/* msub.xml */
int MSUB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op54=00|11011|op31=000|Rm=xxxxx|o0=1|Ra=xxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE08000)==0x1B008000) {
		decode_fields32(ENC_MSUB_32A_DP_3SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->a = UINT(ctx->Ra);
		ctx->destsize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->datasize = ctx->destsize;
		ctx->sub_op = (ctx->o0==1);
		/* regular aliases */
		if(ctx->Ra==0x1f) return MNEG_MSUB(ctx, instr);
		if(ctx->sf==0) OK(ENC_MSUB_32A_DP_3SRC);
		if(ctx->sf==1) OK(ENC_MSUB_64A_DP_3SRC);
	}
	return rc;
}

/* mul_madd.xml */
int MUL_MADD(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op54=00|11011|op31=000|Rm=xxxxx|o0=0|Ra=11111|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0FC00)==0x1B007C00) {
		decode_fields32(ENC_MUL_MADD_32A_DP_3SRC, ctx, instr);
		if(ctx->sf==0) OK(ENC_MUL_MADD_32A_DP_3SRC);
		if(ctx->sf==1) OK(ENC_MUL_MADD_64A_DP_3SRC);
	}
	return rc;
}

/* mul_advsimd_elt.xml */
int MUL_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_element */
	/* 0|Q=x|U=0|01111|size=xx|L=x|M=x|Rm=xxxx|opcode=1000|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0xF008000) {
		decode_fields32(ENC_MUL_ASIMDELEM_R, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_MUL_ASIMDELEM_R);
	}
	return rc;
}

/* mul_advsimd_vec.xml */
int MUL_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|opcode=10011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE209C00) {
		decode_fields32(ENC_MUL_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->U==1 && ctx->size!=0) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->poly = (ctx->U==1);
		OK(ENC_MUL_ASIMDSAME_ONLY);
	}
	return rc;
}

/* mvni_advsimd.xml */
int MVNI_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|op=1|0111100000|a=x|b=x|c=x|cmode=xxxx|o2=0|1|d=x|e=x|f=x|g=x|h=x|Rd=xxxxx */
	if((INSWORD & 0xBFF80C00)==0x2F000400) {
		decode_fields32(ENC_MVNI_ASIMDIMM_L_HL, ctx, instr);
		ctx->rd = UINT(ctx->Rd);
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		if(!(((ctx->cmode<<1)|ctx->op)&0x13)) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x13)==1) {
			ctx->operation_ = ImmediateOp_MVNI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x13)==2) {
			ctx->operation_ = ImmediateOp_ORR;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x13)==3) {
			ctx->operation_ = ImmediateOp_BIC;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x10) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x11) {
			ctx->operation_ = ImmediateOp_MVNI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x12) {
			ctx->operation_ = ImmediateOp_ORR;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x13) {
			ctx->operation_ = ImmediateOp_BIC;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1d)==0x18) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1d)==0x19) {
			ctx->operation_ = ImmediateOp_MVNI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1e)==0x1c) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if(((ctx->cmode<<1)|ctx->op)==0x1e) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if(((ctx->cmode<<1)|ctx->op)==0x1f) {
			if(ctx->Q==0) {
				UNDEFINED;
			}
			ctx->operation_ = ImmediateOp_MOVI;
		}
		ctx->imm64 = AdvSIMDExpandImm(ctx->op,ctx->cmode,((ctx->a<<7)|(ctx->b<<6)|(ctx->c<<5)|(ctx->d<<4)|(ctx->e<<3)|(ctx->f<<2)|(ctx->g<<1)|ctx->h));
		ctx->imm = Replicate(ctx->imm64, ((0x40) ? ((ctx->datasize) / (0x40)) : 0), 64);
		if((ctx->cmode&13)==8) OK(ENC_MVNI_ASIMDIMM_L_HL);
		if(!(ctx->cmode&9)) OK(ENC_MVNI_ASIMDIMM_L_SL);
		if((ctx->cmode&14)==12) OK(ENC_MVNI_ASIMDIMM_M_SM);
	}
	return rc;
}

/* mvn_not_advsimd.xml */
int MVN_NOT_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=00|10000|opcode=00101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2E205800) {
		decode_fields32(ENC_MVN_NOT_ASIMDMISC_R, ctx, instr);
		OK(ENC_MVN_NOT_ASIMDMISC_R);
	}
	return rc;
}

/* mvn_orn_log_shift.xml */
int MVN_ORN_log_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|opc=01|01010|shift=xx|N=1|Rm=xxxxx|imm6=xxxxxx|Rn=11111|Rd=xxxxx */
	if((INSWORD & 0x7F2003E0)==0x2A2003E0) {
		decode_fields32(ENC_MVN_ORN_32_LOG_SHIFT, ctx, instr);
		if(ctx->sf==0) OK(ENC_MVN_ORN_32_LOG_SHIFT);
		if(ctx->sf==1) OK(ENC_MVN_ORN_64_LOG_SHIFT);
	}
	return rc;
}

/* negs_subs_addsub_shift.xml */
int NEGS_SUBS_addsub_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|op=1|S=1|01011|shift=xx|0|Rm=xxxxx|imm6=xxxxxx|Rn=11111|Rd!=11111 */
	if((INSWORD & 0x7F2003E0)==0x6B0003E0 && (INSWORD & 0x1F)!=0x1F) {
		decode_fields32(ENC_NEGS_SUBS_32_ADDSUB_SHIFT, ctx, instr);
		if(ctx->sf==0) OK(ENC_NEGS_SUBS_32_ADDSUB_SHIFT);
		if(ctx->sf==1) OK(ENC_NEGS_SUBS_64_ADDSUB_SHIFT);
	}
	return rc;
}

/* neg_sub_addsub_shift.xml */
int NEG_SUB_addsub_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|op=1|S=0|01011|shift=xx|0|Rm=xxxxx|imm6=xxxxxx|Rn=11111|Rd=xxxxx */
	if((INSWORD & 0x7F2003E0)==0x4B0003E0) {
		decode_fields32(ENC_NEG_SUB_32_ADDSUB_SHIFT, ctx, instr);
		if(ctx->sf==0) OK(ENC_NEG_SUB_32_ADDSUB_SHIFT);
		if(ctx->sf==1) OK(ENC_NEG_SUB_64_ADDSUB_SHIFT);
	}
	return rc;
}

/* neg_advsimd.xml */
int NEG_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|10000|opcode=01011|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x7E20B800) {
		decode_fields32(ENC_NEG_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size!=3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->neg = (ctx->U==1);
		OK(ENC_NEG_ASISDMISC_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|10000|opcode=01011|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0x2E20B800) {
		decode_fields32(ENC_NEG_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->neg = (ctx->U==1);
		OK(ENC_NEG_ASIMDMISC_R);
	}
	return rc;
}

/* ngcs_sbcs.xml */
int NGCS_SBCS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|op=1|S=1|11010000|Rm=xxxxx|000000|Rn=11111|Rd=xxxxx */
	if((INSWORD & 0x7FE0FFE0)==0x7A0003E0) {
		decode_fields32(ENC_NGCS_SBCS_32_ADDSUB_CARRY, ctx, instr);
		if(ctx->sf==0) OK(ENC_NGCS_SBCS_32_ADDSUB_CARRY);
		if(ctx->sf==1) OK(ENC_NGCS_SBCS_64_ADDSUB_CARRY);
	}
	return rc;
}

/* ngc_sbc.xml */
int NGC_SBC(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|op=1|S=0|11010000|Rm=xxxxx|000000|Rn=11111|Rd=xxxxx */
	if((INSWORD & 0x7FE0FFE0)==0x5A0003E0) {
		decode_fields32(ENC_NGC_SBC_32_ADDSUB_CARRY, ctx, instr);
		if(ctx->sf==0) OK(ENC_NGC_SBC_32_ADDSUB_CARRY);
		if(ctx->sf==1) OK(ENC_NGC_SBC_64_ADDSUB_CARRY);
	}
	return rc;
}

/* nop.xml */
int NOP(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=0000|op2=000|Rt=11111 */
	if((INSWORD & 0xFFFFFFFF)==0xD503201F) {
		decode_fields32(ENC_NOP_HI_HINTS, ctx, instr);
		if(!((ctx->CRm<<3)|ctx->op2)) {
			ctx->op = SystemHintOp_NOP;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==1) {
			ctx->op = SystemHintOp_YIELD;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==2) {
			ctx->op = SystemHintOp_WFE;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==3) {
			ctx->op = SystemHintOp_WFI;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==4) {
			ctx->op = SystemHintOp_SEV;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==5) {
			ctx->op = SystemHintOp_SEVL;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==6) {
			if(!HaveDGHExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_DGH;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==7) {
			SEE /* XPACLRI */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==8) {
			if(!ctx->op2) {
				SEE /* PACIA1716 */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIB1716 */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIA1716 */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIB1716 */;
			}
			else {
				ENDOFINSTRUCTION;
			}
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x10) {
			if(!HaveRASExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_ESB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x11) {
			if(!HaveStatisticalProfiling()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_PSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x12) {
			if(!HaveSelfHostedTrace()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_TSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x14) {
			ctx->op = SystemHintOp_CSDB;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==0x18) {
			if(!ctx->op2) {
				SEE /* PACIAZ */;
			}
			else if(ctx->op2==1) {
				SEE /* PACIASP */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIBZ */;
			}
			else if(ctx->op2==3) {
				SEE /* PACIBSP */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIAZ */;
			}
			else if(ctx->op2==5) {
				SEE /* AUTHASP */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIBZ */;
			}
			else if(ctx->op2==7) {
				SEE /* AUTIBSP */;
			}
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x79)==0x20) {
			ctx->op = SystemHintOp_BTI;
			SetBTypeCompatible(BTypeCompatible_BTI(SLICE(ctx->op2,2,1), ctx->pstate_btype));
		}
		else {
			ENDOFINSTRUCTION;
		}
		OK(ENC_NOP_HI_HINTS);
	}
	return rc;
}

/* nots_eor_p_p_pp.xml */
int NOTS_eor_p_p_pp(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* 00100101|op=0|S=1|00|Pm=xxxx|01|Pg=xxxx|o2=1|Pn=xxxx|o3=0|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x25404200) {
		decode_fields32(ENC_NOTS_EORS_P_P_PP_Z, ctx, instr);
		OK(ENC_NOTS_EORS_P_P_PP_Z);
	}
	return rc;
}

/* not_advsimd.xml */
int NOT_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=00|10000|opcode=00101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2E205800) {
		decode_fields32(ENC_NOT_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 8;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((8) ? ((ctx->datasize) / (8)) : 0);
		/* unconditional alias */
		if(MVN_NOT_advsimd(ctx, instr)==0) return 0;
		OK(ENC_NOT_ASIMDMISC_R);
	}
	return rc;
}

/* not_eor_p_p_pp.xml */
int NOT_eor_p_p_pp(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* 00100101|op=0|S=0|00|Pm=xxxx|01|Pg=xxxx|o2=1|Pn=xxxx|o3=0|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x25004200) {
		decode_fields32(ENC_NOT_EOR_P_P_PP_Z, ctx, instr);
		OK(ENC_NOT_EOR_P_P_PP_Z);
	}
	return rc;
}

/* orn_advsimd.xml */
int ORN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=11|1|Rm=xxxxx|opcode=00011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xEE01C00) {
		decode_fields32(ENC_ORN_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 8;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->invert = (SLICE(ctx->size,0,0)==1);
		ctx->op = (SLICE(ctx->size,1,1)==1) ? LogicalOp_ORR : LogicalOp_AND;
		OK(ENC_ORN_ASIMDSAME_ONLY);
	}
	return rc;
}

/* orn_log_shift.xml */
int ORN_log_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|opc=01|01010|shift=xx|N=1|Rm=xxxxx|imm6=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F200000)==0x2A200000) {
		decode_fields32(ENC_ORN_32_LOG_SHIFT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==1) {
			ctx->op = LogicalOp_ORR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==2) {
			ctx->op = LogicalOp_EOR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==3) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = TRUE;
		}
		if(ctx->sf==0 && SLICE(ctx->imm6,5,5)==1) {
			UNDEFINED;
		}
		ctx->shift_type = DecodeShift(ctx->shift);
		ctx->shift_amount = UINT(ctx->imm6);
		ctx->invert = (ctx->N==1);
		/* regular aliases */
		if(ctx->Rn==0x1f) return MVN_ORN_log_shift(ctx, instr);
		if(ctx->sf==0) OK(ENC_ORN_32_LOG_SHIFT);
		if(ctx->sf==1) OK(ENC_ORN_64_LOG_SHIFT);
	}
	return rc;
}

/* orn_orr_z_zi.xml */
int ORN_orr_z_zi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|opc=00|0000|imm13=xxxxxxxxxxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFFFC0000)==0x5000000) {
		decode_fields32(ENC_ORN_ORR_Z_ZI_, ctx, instr);
		OK(ENC_ORN_ORR_Z_ZI_);
	}
	return rc;
}

/* orr_advsimd_imm.xml */
int ORR_advsimd_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_shifted_immediate */
	/* 0|Q=x|op=0|0111100000|a=x|b=x|c=x|cmode=xxx1|o2=0|1|d=x|e=x|f=x|g=x|h=x|Rd=xxxxx */
	if((INSWORD & 0xBFF81C00)==0xF001400) {
		decode_fields32(ENC_ORR_ASIMDIMM_L_HL, ctx, instr);
		ctx->rd = UINT(ctx->Rd);
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		if(!(((ctx->cmode<<1)|ctx->op)&0x13)) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x13)==1) {
			ctx->operation_ = ImmediateOp_MVNI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x13)==2) {
			ctx->operation_ = ImmediateOp_ORR;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x13)==3) {
			ctx->operation_ = ImmediateOp_BIC;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x10) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x11) {
			ctx->operation_ = ImmediateOp_MVNI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x12) {
			ctx->operation_ = ImmediateOp_ORR;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1b)==0x13) {
			ctx->operation_ = ImmediateOp_BIC;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1d)==0x18) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1d)==0x19) {
			ctx->operation_ = ImmediateOp_MVNI;
		}
		else if((((ctx->cmode<<1)|ctx->op)&0x1e)==0x1c) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if(((ctx->cmode<<1)|ctx->op)==0x1e) {
			ctx->operation_ = ImmediateOp_MOVI;
		}
		else if(((ctx->cmode<<1)|ctx->op)==0x1f) {
			if(ctx->Q==0) {
				UNDEFINED;
			}
			ctx->operation_ = ImmediateOp_MOVI;
		}
		ctx->imm64 = AdvSIMDExpandImm(ctx->op,ctx->cmode,((ctx->a<<7)|(ctx->b<<6)|(ctx->c<<5)|(ctx->d<<4)|(ctx->e<<3)|(ctx->f<<2)|(ctx->g<<1)|ctx->h));
		ctx->imm = Replicate(ctx->imm64, ((0x40) ? ((ctx->datasize) / (0x40)) : 0), 64);
		if((ctx->cmode&13)==9) OK(ENC_ORR_ASIMDIMM_L_HL);
		if((ctx->cmode&9)==1) OK(ENC_ORR_ASIMDIMM_L_SL);
	}
	return rc;
}

/* orr_advsimd_reg.xml */
int ORR_advsimd_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=10|1|Rm=xxxxx|opcode=00011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xEA01C00) {
		decode_fields32(ENC_ORR_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = 8;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->invert = (SLICE(ctx->size,0,0)==1);
		ctx->op = (SLICE(ctx->size,1,1)==1) ? LogicalOp_ORR : LogicalOp_AND;
		/* regular aliases */
		if(ctx->Rm==ctx->Rn) return MOV_ORR_advsimd_reg(ctx, instr);
		OK(ENC_ORR_ASIMDSAME_ONLY);
	}
	return rc;
}

/* orr_log_imm.xml */
int ORR_log_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|opc=01|100100|N=x|immr=xxxxxx|imms=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x32000000) {
		decode_fields32(ENC_ORR_32_LOG_IMM, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==1) {
			ctx->op = LogicalOp_ORR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==2) {
			ctx->op = LogicalOp_EOR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==3) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = TRUE;
		}
		if(ctx->sf==0 && ctx->N!=0) {
			UNDEFINED;
		}
		DecodeBitMasksCheckUndefined(ctx->N,ctx->imms);
		DecodeBitMasks_ReturnType dbmrt = DecodeBitMasks(ctx->N,ctx->imms,ctx->immr);
		ctx->imm = dbmrt.wmask;
		/* regular aliases */
		if(ctx->Rn==0x1f && !MoveWidePreferred(ctx->sf,ctx->N,ctx->imms,ctx->immr)) return MOV_ORR_log_imm(ctx, instr);
		if(ctx->sf==0 && ctx->N==0) OK(ENC_ORR_32_LOG_IMM);
		if(ctx->sf==1) OK(ENC_ORR_64_LOG_IMM);
	}
	return rc;
}

/* orr_log_shift.xml */
int ORR_log_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|opc=01|01010|shift=xx|N=0|Rm=xxxxx|imm6=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F200000)==0x2A000000) {
		decode_fields32(ENC_ORR_32_LOG_SHIFT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==1) {
			ctx->op = LogicalOp_ORR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==2) {
			ctx->op = LogicalOp_EOR;
			ctx->setflags = FALSE;
		}
		else if(ctx->opc==3) {
			ctx->op = LogicalOp_AND;
			ctx->setflags = TRUE;
		}
		if(ctx->sf==0 && SLICE(ctx->imm6,5,5)==1) {
			UNDEFINED;
		}
		ctx->shift_type = DecodeShift(ctx->shift);
		ctx->shift_amount = UINT(ctx->imm6);
		ctx->invert = (ctx->N==1);
		/* regular aliases */
		if(ctx->shift==0 && ctx->imm6==0 && ctx->Rn==0x1f) return MOV_ORR_log_shift(ctx, instr);
		if(ctx->sf==0) OK(ENC_ORR_32_LOG_SHIFT);
		if(ctx->sf==1) OK(ENC_ORR_64_LOG_SHIFT);
	}
	return rc;
}

/* pacda.xml */
int PACDA(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|1|S=0|11010110|opcode2=00001|opcode[5]=0|opcode[4]=0|Z=x|opcode[2:0]=010|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFDC00)==0xDAC10800) {
		decode_fields32(ENC_PACDA_64P_DP_1SRC, ctx, instr);
		ctx->source_is_sp = FALSE;
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!HavePACExt()) {
			UNDEFINED;
		}
		if(ctx->Z==0) {
			if(ctx->n==0x1f) {
				ctx->source_is_sp = TRUE;
			}
		}
		else {
			if(ctx->n!=0x1f) {
				UNDEFINED;
			}
		}
		if(ctx->Z==0) OK(ENC_PACDA_64P_DP_1SRC);
		if(ctx->Z==1 && ctx->Rn==0x1f) OK(ENC_PACDZA_64Z_DP_1SRC);
	}
	return rc;
}

/* pacdb.xml */
int PACDB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|1|S=0|11010110|opcode2=00001|opcode[5]=0|opcode[4]=0|Z=x|opcode[2:0]=011|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFDC00)==0xDAC10C00) {
		decode_fields32(ENC_PACDB_64P_DP_1SRC, ctx, instr);
		ctx->source_is_sp = FALSE;
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!HavePACExt()) {
			UNDEFINED;
		}
		if(ctx->Z==0) {
			if(ctx->n==0x1f) {
				ctx->source_is_sp = TRUE;
			}
		}
		else {
			if(ctx->n!=0x1f) {
				UNDEFINED;
			}
		}
		if(ctx->Z==0) OK(ENC_PACDB_64P_DP_1SRC);
		if(ctx->Z==1 && ctx->Rn==0x1f) OK(ENC_PACDZB_64Z_DP_1SRC);
	}
	return rc;
}

/* pacga.xml */
int PACGA(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|op=0|S=0|11010110|Rm=xxxxx|opcode2=001100|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x9AC03000) {
		decode_fields32(ENC_PACGA_64P_DP_2SRC, ctx, instr);
		ctx->source_is_sp = FALSE;
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!HavePACExt()) {
			UNDEFINED;
		}
		if(ctx->m==0x1f) {
			ctx->source_is_sp = TRUE;
		}
		OK(ENC_PACGA_64P_DP_2SRC);
	}
	return rc;
}

/* pacia.xml */
int PACIA(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|1|S=0|11010110|opcode2=00001|opcode[5]=0|opcode[4]=0|Z=x|opcode[2:0]=000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFDC00)==0xDAC10000) {
		decode_fields32(ENC_PACIA_64P_DP_1SRC, ctx, instr);
		ctx->source_is_sp = FALSE;
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!HavePACExt()) {
			UNDEFINED;
		}
		if(ctx->Z==0) {
			if(ctx->n==0x1f) {
				ctx->source_is_sp = TRUE;
			}
		}
		else {
			if(ctx->n!=0x1f) {
				UNDEFINED;
			}
		}
		if(ctx->Z==0) OK(ENC_PACIA_64P_DP_1SRC);
		if(ctx->Z==1 && ctx->Rn==0x1f) OK(ENC_PACIZA_64Z_DP_1SRC);
	}
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=00x1|op2=00x|Rt=11111 */
	if((INSWORD & 0xFFFFFDDF)==0xD503211F) {
		decode_fields32(ENC_PACIA1716_HI_HINTS, ctx, instr);
		ctx->source_is_sp = FALSE;
		if(((ctx->CRm<<3)|ctx->op2)==0x18) {
			ctx->d = 0x1e;
			ctx->n = 0x1f;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x19) {
			ctx->d = 0x1e;
			ctx->source_is_sp = TRUE;
			if(HaveBTIExt()) {
				SetBTypeCompatible(BTypeCompatible_PACIXSP());
			}
		}
		else if(((ctx->CRm<<3)|ctx->op2)==8) {
			ctx->d = 0x11;
			ctx->n = 0x10;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==10) {
			SEE /* PACIB */;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==12) {
			SEE /* AUTIA */;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==14) {
			SEE /* AUTIB */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x7e)==0x1a) {
			SEE /* PACIB */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x7e)==0x1c) {
			SEE /* AUTIA */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x7e)==0x1e) {
			SEE /* AUTIB */;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==7) {
			SEE /* XPACLRI */;
		}
		else {
			SEE /* HINT */;
		}
		if(ctx->CRm==1 && ctx->op2==0) OK(ENC_PACIA1716_HI_HINTS);
		if(ctx->CRm==3 && ctx->op2==1) OK(ENC_PACIASP_HI_HINTS);
		if(ctx->CRm==3 && ctx->op2==0) OK(ENC_PACIAZ_HI_HINTS);
	}
	return rc;
}

/* pacib.xml */
int PACIB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|1|S=0|11010110|opcode2=00001|opcode[5]=0|opcode[4]=0|Z=x|opcode[2:0]=001|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFDC00)==0xDAC10400) {
		decode_fields32(ENC_PACIB_64P_DP_1SRC, ctx, instr);
		ctx->source_is_sp = FALSE;
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!HavePACExt()) {
			UNDEFINED;
		}
		if(ctx->Z==0) {
			if(ctx->n==0x1f) {
				ctx->source_is_sp = TRUE;
			}
		}
		else {
			if(ctx->n!=0x1f) {
				UNDEFINED;
			}
		}
		if(ctx->Z==0) OK(ENC_PACIB_64P_DP_1SRC);
		if(ctx->Z==1 && ctx->Rn==0x1f) OK(ENC_PACIZB_64Z_DP_1SRC);
	}
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=00x1|op2=01x|Rt=11111 */
	if((INSWORD & 0xFFFFFDDF)==0xD503215F) {
		decode_fields32(ENC_PACIB1716_HI_HINTS, ctx, instr);
		ctx->source_is_sp = FALSE;
		if(((ctx->CRm<<3)|ctx->op2)==0x1a) {
			ctx->d = 0x1e;
			ctx->n = 0x1f;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x1b) {
			ctx->d = 0x1e;
			ctx->source_is_sp = TRUE;
			if(HaveBTIExt()) {
				SetBTypeCompatible(BTypeCompatible_PACIXSP());
			}
		}
		else if(((ctx->CRm<<3)|ctx->op2)==10) {
			ctx->d = 0x11;
			ctx->n = 0x10;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==8) {
			SEE /* PACIA */;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==12) {
			SEE /* AUTIA */;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==14) {
			SEE /* AUTIB */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x7e)==0x18) {
			SEE /* PACIA */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x7e)==0x1c) {
			SEE /* AUTIA */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x7e)==0x1e) {
			SEE /* AUTIB */;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==7) {
			SEE /* XPACLRI */;
		}
		else {
			SEE /* HINT */;
		}
		if(ctx->CRm==1 && ctx->op2==2) OK(ENC_PACIB1716_HI_HINTS);
		if(ctx->CRm==3 && ctx->op2==3) OK(ENC_PACIBSP_HI_HINTS);
		if(ctx->CRm==3 && ctx->op2==2) OK(ENC_PACIBZ_HI_HINTS);
	}
	return rc;
}

/* pmull_advsimd.xml */
int PMULL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|opcode=1110|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE20E000) {
		decode_fields32(ENC_PMULL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==1 || ctx->size==2) {
			UNDEFINED;
		}
		if(ctx->size==3 && !HaveBit128PMULLExt()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_PMULL_ASIMDDIFF_L);
	}
	return rc;
}

/* pmul_advsimd.xml */
int PMUL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|opcode=10011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E209C00) {
		decode_fields32(ENC_PMUL_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->U==1 && ctx->size!=0) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->poly = (ctx->U==1);
		OK(ENC_PMUL_ASIMDSAME_ONLY);
	}
	return rc;
}

/* prfm_imm.xml */
int PRFM_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_unsigned_scaled_offset */
	/* size=11|111|V=0|01|opc=10|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFC00000)==0xF9800000) {
		decode_fields32(ENC_PRFM_P_LDST_POS, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = LSL(ZeroExtend(ctx->imm12,0x40),ctx->scale);
		OK(ENC_PRFM_P_LDST_POS);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* prfm_lit.xml */
int PRFM_lit(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_literal */
	/* opc=11|011|V=0|00|imm19=xxxxxxxxxxxxxxxxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF000000)==0xD8000000) {
		decode_fields32(ENC_PRFM_P_LOADLIT, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->memop = MemOp_LOAD;
		ctx->signed_ = FALSE;
		if(!ctx->opc) {
			ctx->size = 4;
		}
		else if(ctx->opc==1) {
			ctx->size = 8;
		}
		else if(ctx->opc==2) {
			ctx->size = 4;
			ctx->signed_ = TRUE;
		}
		else if(ctx->opc==3) {
			ctx->memop = MemOp_PREFETCH;
		}
		ctx->offset = SignExtend((ctx->imm19<<2),21);
		ctx->tag_checked = FALSE;
		OK(ENC_PRFM_P_LOADLIT);
	}
	return rc;
}

/* prfm_reg.xml */
int PRFM_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=11|111|V=0|00|opc=10|1|Rm=xxxxx|option=xxx|S=x|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xF8A00800) {
		decode_fields32(ENC_PRFM_P_LDST_REGOFF, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		if(SLICE(ctx->option,1,1)==0) {
			UNDEFINED;
		}
		ctx->extend_type = DecodeRegExtend(ctx->option);
		ctx->shift = (ctx->S==1) ? ctx->scale : 0;
		OK(ENC_PRFM_P_LDST_REGOFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->m = UINT(ctx->Rm);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH;
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* prfum.xml */
int PRFUM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=11|111|V=0|00|opc=10|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xF8800000) {
		decode_fields32(ENC_PRFUM_P_LDST_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_PRFUM_P_LDST_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* psb.xml */
int PSB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=0010|op2=001|Rt=11111 */
	if((INSWORD & 0xFFFFFFFF)==0xD503223F) {
		decode_fields32(ENC_PSB_HC_HINTS, ctx, instr);
		if(!((ctx->CRm<<3)|ctx->op2)) {
			ctx->op = SystemHintOp_NOP;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==1) {
			ctx->op = SystemHintOp_YIELD;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==2) {
			ctx->op = SystemHintOp_WFE;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==3) {
			ctx->op = SystemHintOp_WFI;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==4) {
			ctx->op = SystemHintOp_SEV;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==5) {
			ctx->op = SystemHintOp_SEVL;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==6) {
			if(!HaveDGHExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_DGH;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==7) {
			SEE /* XPACLRI */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==8) {
			if(!ctx->op2) {
				SEE /* PACIA1716 */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIB1716 */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIA1716 */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIB1716 */;
			}
			else {
				ENDOFINSTRUCTION;
			}
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x10) {
			if(!HaveRASExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_ESB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x11) {
			if(!HaveStatisticalProfiling()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_PSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x12) {
			if(!HaveSelfHostedTrace()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_TSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x14) {
			ctx->op = SystemHintOp_CSDB;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==0x18) {
			if(!ctx->op2) {
				SEE /* PACIAZ */;
			}
			else if(ctx->op2==1) {
				SEE /* PACIASP */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIBZ */;
			}
			else if(ctx->op2==3) {
				SEE /* PACIBSP */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIAZ */;
			}
			else if(ctx->op2==5) {
				SEE /* AUTHASP */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIBZ */;
			}
			else if(ctx->op2==7) {
				SEE /* AUTIBSP */;
			}
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x79)==0x20) {
			ctx->op = SystemHintOp_BTI;
			SetBTypeCompatible(BTypeCompatible_BTI(SLICE(ctx->op2,2,1), ctx->pstate_btype));
		}
		else {
			ENDOFINSTRUCTION;
		}
		OK(ENC_PSB_HC_HINTS);
	}
	return rc;
}

/* pssbb_dsb.xml */
int PSSBB_DSB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_dsb_memory */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0011|CRm=0100|1|opc=00|Rt=11111 */
	if((INSWORD & 0xFFFFFFFF)==0xD503349F) {
		decode_fields32(ENC_PSSBB_DSB_BO_BARRIERS, ctx, instr);
		OK(ENC_PSSBB_DSB_BO_BARRIERS);
	}
	return rc;
}

/* raddhn_advsimd.xml */
int RADDHN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|01|o1=0|0|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E204000) {
		decode_fields32(ENC_RADDHN_ASIMDDIFF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		ctx->round = (ctx->U==1);
		OK(ENC_RADDHN_ASIMDDIFF_N);
	}
	return rc;
}

/* rax1_advsimd.xml */
int RAX1_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 11001110011|Rm=xxxxx|1|O=0|00|opcode=11|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0xCE608C00) {
		decode_fields32(ENC_RAX1_VVV2_CRYPTOSHA512_3, ctx, instr);
		if(!HaveSHA3Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		OK(ENC_RAX1_VVV2_CRYPTOSHA512_3);
	}
	return rc;
}

/* rbit_advsimd.xml */
int RBIT_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=01|10000|opcode=00101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2E605800) {
		decode_fields32(ENC_RBIT_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 8;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((8) ? ((ctx->datasize) / (8)) : 0);
		OK(ENC_RBIT_ASIMDMISC_R);
	}
	return rc;
}

/* rbit_int.xml */
int RBIT_int(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|1|S=0|11010110|opcode2=00000|opcode[5:2]=0000|opcode[1:0]=00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FFFFC00)==0x5AC00000) {
		decode_fields32(ENC_RBIT_32_DP_1SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(ctx->sf==0) OK(ENC_RBIT_32_DP_1SRC);
		if(ctx->sf==1) OK(ENC_RBIT_64_DP_1SRC);
	}
	return rc;
}

/* ret.xml */
int RET(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* 1101011|Z=0|opc[2:1]=0|op=10|op2=11111|op3[5:2]=0000|A=0|M=0|Rn=xxxxx|Rm=00000 */
	if((INSWORD & 0xFFFFFC1F)==0xD65F0000) {
		decode_fields32(ENC_RET_64R_BRANCH_REG, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->pac = (ctx->A==1);
		ctx->use_key_a = (ctx->M==0);
		ctx->source_is_sp = ((ctx->Z==1) && (ctx->m==0x1f));
		if(!ctx->pac && ctx->m!=0) {
			UNDEFINED;
		}
		else if(ctx->pac && !HavePACExt()) {
			UNDEFINED;
		}
		if(!ctx->op) {
			ctx->branch_type = BranchType_INDIR;
		}
		else if(ctx->op==1) {
			ctx->branch_type = BranchType_INDCALL;
		}
		else if(ctx->op==2) {
			ctx->branch_type = BranchType_RET;
		}
		else {
			UNDEFINED;
		}
		if(ctx->pac) {
			if(ctx->Z==0 && ctx->m!=0x1f) {
				UNDEFINED;
			}
			if(ctx->branch_type==BranchType_RET) {
				if(ctx->n!=0x1f) {
					UNDEFINED;
				}
				ctx->n = 0x1e;
				ctx->source_is_sp = TRUE;
			}
		}
		OK(ENC_RET_64R_BRANCH_REG);
	}
	return rc;
}

/* reta.xml */
int RETA(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* 1101011|Z=0|opc[2:1]=0|op=10|op2=11111|op3[5:2]=0000|A=1|M=x|Rn=11111|Rm=11111 */
	if((INSWORD & 0xFFFFFBFF)==0xD65F0BFF) {
		decode_fields32(ENC_RETAA_64E_BRANCH_REG, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->pac = (ctx->A==1);
		ctx->use_key_a = (ctx->M==0);
		ctx->source_is_sp = ((ctx->Z==1) && (ctx->m==0x1f));
		if(!ctx->pac && ctx->m!=0) {
			UNDEFINED;
		}
		else if(ctx->pac && !HavePACExt()) {
			UNDEFINED;
		}
		if(!ctx->op) {
			ctx->branch_type = BranchType_INDIR;
		}
		else if(ctx->op==1) {
			ctx->branch_type = BranchType_INDCALL;
		}
		else if(ctx->op==2) {
			ctx->branch_type = BranchType_RET;
		}
		else {
			UNDEFINED;
		}
		if(ctx->pac) {
			if(ctx->Z==0 && ctx->m!=0x1f) {
				UNDEFINED;
			}
			if(ctx->branch_type==BranchType_RET) {
				if(ctx->n!=0x1f) {
					UNDEFINED;
				}
				ctx->n = 0x1e;
				ctx->source_is_sp = TRUE;
			}
		}
		if(ctx->M==0) OK(ENC_RETAA_64E_BRANCH_REG);
		if(ctx->M==1) OK(ENC_RETAB_64E_BRANCH_REG);
	}
	return rc;
}

/* rev.xml */
int REV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|1|S=0|11010110|opcode2=00000|opcode[5:2]=0000|opc=1x|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FFFF800)==0x5AC00800) {
		decode_fields32(ENC_REV_32_DP_1SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ENDOFINSTRUCTION;
		}
		else if(ctx->opc==1) {
			ctx->container_size = 0x10;
		}
		else if(ctx->opc==2) {
			ctx->container_size = 0x20;
		}
		else if(ctx->opc==3) {
			if(ctx->sf==0) {
				UNDEFINED;
			}
			ctx->container_size = 0x40;
		}
		if(ctx->sf==0 && ctx->opc==2) OK(ENC_REV_32_DP_1SRC);
		if(ctx->sf==1 && ctx->opc==3) OK(ENC_REV_64_DP_1SRC);
	}
	return rc;
}

/* rev16_advsimd.xml */
int REV16_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|10000|0000|o0=1|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE201800) {
		decode_fields32(ENC_REV16_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->op = ((ctx->o0<<1)|ctx->U);
		if((UINT(ctx->op)+UINT(ctx->size)) >= (3)) {
			UNDEFINED;
		}
		if(ctx->op==2) {
			ctx->container_size = 0x10;
		}
		else if(ctx->op==1) {
			ctx->container_size = 0x20;
		}
		else if(!ctx->op) {
			ctx->container_size = 0x40;
		}
		ctx->containers = ((ctx->container_size) ? ((ctx->datasize) / (ctx->container_size)) : 0);
		ctx->elements_per_container = ((ctx->esize) ? ((ctx->container_size) / (ctx->esize)) : 0);
		OK(ENC_REV16_ASIMDMISC_R);
	}
	return rc;
}

/* rev16_int.xml */
int REV16_int(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|1|S=0|11010110|opcode2=00000|opcode[5:2]=0000|opc=01|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FFFFC00)==0x5AC00400) {
		decode_fields32(ENC_REV16_32_DP_1SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ENDOFINSTRUCTION;
		}
		else if(ctx->opc==1) {
			ctx->container_size = 0x10;
		}
		else if(ctx->opc==2) {
			ctx->container_size = 0x20;
		}
		else if(ctx->opc==3) {
			if(ctx->sf==0) {
				UNDEFINED;
			}
			ctx->container_size = 0x40;
		}
		if(ctx->sf==0) OK(ENC_REV16_32_DP_1SRC);
		if(ctx->sf==1) OK(ENC_REV16_64_DP_1SRC);
	}
	return rc;
}

/* rev32_advsimd.xml */
int REV32_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|10000|0000|o0=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0x2E200800) {
		decode_fields32(ENC_REV32_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->op = ((ctx->o0<<1)|ctx->U);
		if((UINT(ctx->op)+UINT(ctx->size)) >= (3)) {
			UNDEFINED;
		}
		if(ctx->op==2) {
			ctx->container_size = 0x10;
		}
		else if(ctx->op==1) {
			ctx->container_size = 0x20;
		}
		else if(!ctx->op) {
			ctx->container_size = 0x40;
		}
		ctx->containers = ((ctx->container_size) ? ((ctx->datasize) / (ctx->container_size)) : 0);
		ctx->elements_per_container = ((ctx->esize) ? ((ctx->container_size) / (ctx->esize)) : 0);
		OK(ENC_REV32_ASIMDMISC_R);
	}
	return rc;
}

/* rev32_int.xml */
int REV32_int(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_64 */
	/* sf=1|1|S=0|11010110|opcode2=00000|opcode[5:2]=0000|opc=10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0xDAC00800) {
		decode_fields32(ENC_REV32_64_DP_1SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ENDOFINSTRUCTION;
		}
		else if(ctx->opc==1) {
			ctx->container_size = 0x10;
		}
		else if(ctx->opc==2) {
			ctx->container_size = 0x20;
		}
		else if(ctx->opc==3) {
			if(ctx->sf==0) {
				UNDEFINED;
			}
			ctx->container_size = 0x40;
		}
		OK(ENC_REV32_64_DP_1SRC);
	}
	return rc;
}

/* rev64_rev.xml */
int REV64_REV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|1|S=0|11010110|opcode2=00000|opcode[5:2]=0000|opc=11|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0xDAC00C00) {
		decode_fields32(ENC_REV64_REV_64_DP_1SRC, ctx, instr);
		OK(ENC_REV64_REV_64_DP_1SRC);
	}
	return rc;
}

/* rev64_advsimd.xml */
int REV64_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|10000|0000|o0=0|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE200800) {
		decode_fields32(ENC_REV64_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->op = ((ctx->o0<<1)|ctx->U);
		if((UINT(ctx->op)+UINT(ctx->size)) >= (3)) {
			UNDEFINED;
		}
		if(ctx->op==2) {
			ctx->container_size = 0x10;
		}
		else if(ctx->op==1) {
			ctx->container_size = 0x20;
		}
		else if(!ctx->op) {
			ctx->container_size = 0x40;
		}
		ctx->containers = ((ctx->container_size) ? ((ctx->datasize) / (ctx->container_size)) : 0);
		ctx->elements_per_container = ((ctx->esize) ? ((ctx->container_size) / (ctx->esize)) : 0);
		OK(ENC_REV64_ASIMDMISC_R);
	}
	return rc;
}

/* rmif.xml */
int RMIF(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|op=0|S=1|11010000|imm6=xxxxxx|00001|Rn=xxxxx|o2=0|mask=xxxx */
	if((INSWORD & 0xFFE07C10)==0xBA000400) {
		decode_fields32(ENC_RMIF_ONLY_RMIF, ctx, instr);
		if(!HaveFlagManipulateExt() || ctx->sf!=1) {
			UNDEFINED;
		}
		ctx->lsb = UINT(ctx->imm6);
		ctx->n = UINT(ctx->Rn);
		OK(ENC_RMIF_ONLY_RMIF);
	}
	return rc;
}

/* rorv.xml */
int RORV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=0|S=0|11010110|Rm=xxxxx|opcode2<5:2>=0010|op2=11|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0FC00)==0x1AC02C00) {
		decode_fields32(ENC_RORV_32_DP_2SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->shift_type = DecodeShift(ctx->op2);
		/* unconditional alias */
		if(ROR_RORV(ctx, instr)==0) return 0;
		if(ctx->sf==0) OK(ENC_RORV_32_DP_2SRC);
		if(ctx->sf==1) OK(ENC_RORV_64_DP_2SRC);
	}
	return rc;
}

/* ror_extr.xml */
int ROR_EXTR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op21=00|100111|N=x|o0=0|Rm=xxxxx|imms=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FA00000)==0x13800000) {
		decode_fields32(ENC_ROR_EXTR_32_EXTRACT, ctx, instr);
		if(ctx->sf==0 && ctx->N==0 && !(ctx->imms&0x20)) OK(ENC_ROR_EXTR_32_EXTRACT);
		if(ctx->sf==1 && ctx->N==1) OK(ENC_ROR_EXTR_64_EXTRACT);
	}
	return rc;
}

/* ror_rorv.xml */
int ROR_RORV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=0|S=0|11010110|Rm=xxxxx|opcode2<5:2>=0010|op2=11|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0FC00)==0x1AC02C00) {
		decode_fields32(ENC_ROR_RORV_32_DP_2SRC, ctx, instr);
		if(ctx->sf==0) OK(ENC_ROR_RORV_32_DP_2SRC);
		if(ctx->sf==1) OK(ENC_ROR_RORV_64_DP_2SRC);
	}
	return rc;
}

/* rshrn_advsimd.xml */
int RSHRN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=0|011110|immh!=0000|immb=xxx|1000|op=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0xF008C00 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_RSHRN_ASIMDSHF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(SLICE(ctx->immh,3,3)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->round = (ctx->op==1);
		OK(ENC_RSHRN_ASIMDSHF_N);
	}
	return rc;
}

/* rsubhn_advsimd.xml */
int RSUBHN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|01|o1=1|0|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E206000) {
		decode_fields32(ENC_RSUBHN_ASIMDDIFF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		ctx->round = (ctx->U==1);
		OK(ENC_RSUBHN_ASIMDDIFF_N);
	}
	return rc;
}

/* sabal_advsimd.xml */
int SABAL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|01|op=0|1|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE205000) {
		decode_fields32(ENC_SABAL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->accumulate = (ctx->op==0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SABAL_ASIMDDIFF_L);
	}
	return rc;
}

/* saba_advsimd.xml */
int SABA_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|0111|ac=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE207C00) {
		decode_fields32(ENC_SABA_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->accumulate = (ctx->ac==1);
		OK(ENC_SABA_ASIMDSAME_ONLY);
	}
	return rc;
}

/* sabdl_advsimd.xml */
int SABDL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|01|op=1|1|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE207000) {
		decode_fields32(ENC_SABDL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->accumulate = (ctx->op==0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SABDL_ASIMDDIFF_L);
	}
	return rc;
}

/* sabd_advsimd.xml */
int SABD_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|0111|ac=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE207400) {
		decode_fields32(ENC_SABD_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->accumulate = (ctx->ac==1);
		OK(ENC_SABD_ASIMDSAME_ONLY);
	}
	return rc;
}

/* sadalp_advsimd.xml */
int SADALP_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|10000|00|op=1|10|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE206800) {
		decode_fields32(ENC_SADALP_ASIMDMISC_P, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((((2) * (ctx->esize))) ? ((ctx->datasize) / (((2) * (ctx->esize)))) : 0);
		ctx->acc = (ctx->op==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SADALP_ASIMDMISC_P);
	}
	return rc;
}

/* saddlp_advsimd.xml */
int SADDLP_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|10000|00|op=0|10|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE202800) {
		decode_fields32(ENC_SADDLP_ASIMDMISC_P, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((((2) * (ctx->esize))) ? ((ctx->datasize) / (((2) * (ctx->esize)))) : 0);
		ctx->acc = (ctx->op==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SADDLP_ASIMDMISC_P);
	}
	return rc;
}

/* saddlv_advsimd.xml */
int SADDLV_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|U=0|01110|size=xx|11000|opcode=00011|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE303800) {
		decode_fields32(ENC_SADDLV_ASIMDALL_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==4) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SADDLV_ASIMDALL_ONLY);
	}
	return rc;
}

/* saddl_advsimd.xml */
int SADDL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|00|o1=0|0|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE200000) {
		decode_fields32(ENC_SADDL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SADDL_ASIMDDIFF_L);
	}
	return rc;
}

/* saddw_advsimd.xml */
int SADDW_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|00|o1=0|1|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE201000) {
		decode_fields32(ENC_SADDW_ASIMDDIFF_W, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SADDW_ASIMDDIFF_W);
	}
	return rc;
}

/* sb.xml */
int SB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0011|CRm=(0)(0)(0)(0)|1|opc=11|Rt=11111 */
	if((INSWORD & 0xFFFFF0FF)==0xD50330FF) {
		decode_fields32(ENC_SB_ONLY_BARRIERS, ctx, instr);
		if(!HaveSBExt()) {
			UNDEFINED;
		}
		OK(ENC_SB_ONLY_BARRIERS);
	}
	return rc;
}

/* sbc.xml */
int SBC(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|op=1|S=0|11010000|Rm=xxxxx|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0FC00)==0x5A000000) {
		decode_fields32(ENC_SBC_32_ADDSUB_CARRY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		instr->setflags = (ctx->S==1);
		ctx->setflags = (ctx->S==1);
		/* regular aliases */
		if(ctx->Rn==0x1f) return NGC_SBC(ctx, instr);
		if(ctx->sf==0) OK(ENC_SBC_32_ADDSUB_CARRY);
		if(ctx->sf==1) OK(ENC_SBC_64_ADDSUB_CARRY);
	}
	return rc;
}

/* sbcs.xml */
int SBCS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|op=1|S=1|11010000|Rm=xxxxx|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0FC00)==0x7A000000) {
		decode_fields32(ENC_SBCS_32_ADDSUB_CARRY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		instr->setflags = (ctx->S==1);
		ctx->setflags = (ctx->S==1);
		/* regular aliases */
		if(ctx->Rn==0x1f) return NGCS_SBCS(ctx, instr);
		if(ctx->sf==0) OK(ENC_SBCS_32_ADDSUB_CARRY);
		if(ctx->sf==1) OK(ENC_SBCS_64_ADDSUB_CARRY);
	}
	return rc;
}

/* sbfiz_sbfm.xml */
int SBFIZ_SBFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_signed_fill */
	/* sf=x|opc=00|100110|N=x|immr=xxxxxx|imms=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x13000000) {
		decode_fields32(ENC_SBFIZ_SBFM_32M_BITFIELD, ctx, instr);
		if(ctx->sf==0 && ctx->N==0) OK(ENC_SBFIZ_SBFM_32M_BITFIELD);
		if(ctx->sf==1 && ctx->N==1) OK(ENC_SBFIZ_SBFM_64M_BITFIELD);
	}
	return rc;
}

/* sbfm.xml */
int SBFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_signed_fill */
	/* sf=x|opc=00|100110|N=x|immr=xxxxxx|imms=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x13000000) {
		decode_fields32(ENC_SBFM_32M_BITFIELD, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ctx->inzero = TRUE;
			ctx->extend = TRUE;
		}
		else if(ctx->opc==1) {
			ctx->inzero = FALSE;
			ctx->extend = FALSE;
		}
		else if(ctx->opc==2) {
			ctx->inzero = TRUE;
			ctx->extend = FALSE;
		}
		else if(ctx->opc==3) {
			UNDEFINED;
		}
		if(ctx->sf==1 && ctx->N!=1) {
			UNDEFINED;
		}
		if(ctx->sf==0 && (ctx->N!=0 || SLICE(ctx->immr,5,5)!=0 || SLICE(ctx->imms,5,5)!=0)) {
			UNDEFINED;
		}
		ctx->R = UINT(ctx->immr);
		ctx->S = UINT(ctx->imms);
		DecodeBitMasks_ReturnType dbmrt = DecodeBitMasks(ctx->N,ctx->imms,ctx->immr);
		ctx->wmask = dbmrt.wmask;
		ctx->tmask = dbmrt.tmask;
		/* regular aliases */
		bool encoding32 = ctx->sf==0 && ctx->N==0;
		bool encoding64 = ctx->sf==1 && ctx->N==1;
		if((ctx->imms==0x1f && EncodingLabeled32Bit()) || (ctx->imms==0x3f && EncodingLabeled64Bit())) return ASR_SBFM(ctx, instr);
		if(UINT(ctx->imms)<UINT(ctx->immr)) return SBFIZ_SBFM(ctx, instr);
		if(BFXPreferred(ctx->sf,SLICE(ctx->opc,1,1),ctx->imms,ctx->immr)) return SBFX_SBFM(ctx, instr);
		if(ctx->immr==0 && ctx->imms==7) return SXTB_SBFM(ctx, instr);
		if(ctx->immr==0 && ctx->imms==15) return SXTH_SBFM(ctx, instr);
		if(ctx->immr==0 && ctx->imms==0x1f) return SXTW_SBFM(ctx, instr);
		if(ctx->sf==0 && ctx->N==0) OK(ENC_SBFM_32M_BITFIELD);
		if(ctx->sf==1 && ctx->N==1) OK(ENC_SBFM_64M_BITFIELD);
	}
	return rc;
}

/* sbfx_sbfm.xml */
int SBFX_SBFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_signed_fill */
	/* sf=x|opc=00|100110|N=x|immr=xxxxxx|imms=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x13000000) {
		decode_fields32(ENC_SBFX_SBFM_32M_BITFIELD, ctx, instr);
		if(ctx->sf==0 && ctx->N==0) OK(ENC_SBFX_SBFM_32M_BITFIELD);
		if(ctx->sf==1 && ctx->N==1) OK(ENC_SBFX_SBFM_64M_BITFIELD);
	}
	return rc;
}

/* scvtf_advsimd_fix.xml */
int SCVTF_advsimd_fix(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|111110|immh!=0000|immb=xxx|opcode=11100|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x5F00E400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SCVTF_ASISDSHF_C, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!(ctx->immh&14) || ((ctx->immh&14)==2 && !HaveFP16Ext())) {
			UNDEFINED;
		}
		ctx->esize = ((ctx->immh&8)==8) ? 0x40 : (((ctx->immh&12)==4) ? 0x20 : 0x10);
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->fracbits = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = FPRoundingMode(ctx->FPCR);
		OK(ENC_SCVTF_ASISDSHF_C);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|011110|immh!=0000|immb=xxx|opcode=11100|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0xF00E400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SCVTF_ASIMDSHF_C, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(!(ctx->immh&14) || ((ctx->immh&14)==2 && !HaveFP16Ext())) {
			UNDEFINED;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = ((ctx->immh&8)==8) ? 0x40 : (((ctx->immh&12)==4) ? 0x20 : 0x10);
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->fracbits = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = FPRoundingMode(ctx->FPCR);
		OK(ENC_SCVTF_ASIMDSHF_C);
	}
	return rc;
}

/* scvtf_advsimd_int.xml */
int SCVTF_advsimd_int(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=0|11110|a=0|111100|opcode=11101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x5E79D800) {
		decode_fields32(ENC_SCVTF_ASISDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SCVTF_ASISDMISCFP16_R);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=0|11110|0|sz=x|10000|opcode=11101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x5E21D800) {
		decode_fields32(ENC_SCVTF_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SCVTF_ASISDMISC_R);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=0|01110|a=0|111100|opcode=11101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0xE79D800) {
		decode_fields32(ENC_SCVTF_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SCVTF_ASIMDMISCFP16_R);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=0|01110|0|sz=x|10000|opcode=11101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xE21D800) {
		decode_fields32(ENC_SCVTF_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SCVTF_ASIMDMISC_R);
	}
	return rc;
}

/* scvtf_float_fix.xml */
int SCVTF_float_fix(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|0|rmode=00|opcode=010|scale=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F3F0000)==0x1E020000) {
		decode_fields32(ENC_SCVTF_H32_FLOAT2FIX, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(ctx->sf==0 && SLICE(ctx->scale,5,5)==0) {
			UNDEFINED;
		}
		ctx->fracbits = 0x40-UINT(ctx->scale);
		if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==3) {
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3) OK(ENC_SCVTF_H32_FLOAT2FIX);
		if(ctx->sf==0 && ctx->ftype==0) OK(ENC_SCVTF_S32_FLOAT2FIX);
		if(ctx->sf==0 && ctx->ftype==1) OK(ENC_SCVTF_D32_FLOAT2FIX);
		if(ctx->sf==1 && ctx->ftype==3) OK(ENC_SCVTF_H64_FLOAT2FIX);
		if(ctx->sf==1 && ctx->ftype==0) OK(ENC_SCVTF_S64_FLOAT2FIX);
		if(ctx->sf==1 && ctx->ftype==1) OK(ENC_SCVTF_D64_FLOAT2FIX);
	}
	return rc;
}

/* scvtf_float_int.xml */
int SCVTF_float_int(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|1|rmode=00|opcode=010|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F3FFC00)==0x1E220000) {
		decode_fields32(ENC_SCVTF_H32_FLOAT2INT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)!=13) {
				UNDEFINED;
			}
			ctx->fltsize = 0x80;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)&12)) {
			ctx->rounding = FPDecodeRounding(ctx->rmode);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==8) {
			ctx->rounding = FPRounding_TIEAWAY;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==12) {
			if(ctx->fltsize!=0x10 && ctx->fltsize!=ctx->intsize) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 0;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==13) {
			if(ctx->intsize!=0x40 || ctx->fltsize!=0x80) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 1;
			ctx->fltsize = 0x40;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==15) {
			if(!HaveFJCVTZSExt()) {
				UNDEFINED;
			}
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI_JS;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3) OK(ENC_SCVTF_H32_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==0) OK(ENC_SCVTF_S32_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==1) OK(ENC_SCVTF_D32_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==3) OK(ENC_SCVTF_H64_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==0) OK(ENC_SCVTF_S64_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==1) OK(ENC_SCVTF_D64_FLOAT2INT);
	}
	return rc;
}

/* sdiv.xml */
int SDIV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=0|S=0|11010110|Rm=xxxxx|opcode2<5:1>=00001|o1=1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0FC00)==0x1AC00C00) {
		decode_fields32(ENC_SDIV_32_DP_2SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->unsigned_ = (ctx->o1==0);
		if(ctx->sf==0) OK(ENC_SDIV_32_DP_2SRC);
		if(ctx->sf==1) OK(ENC_SDIV_64_DP_2SRC);
	}
	return rc;
}

/* sdot_advsimd_elt.xml */
int SDOT_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_element */
	/* 0|Q=x|U=0|01111|size=xx|L=x|M=x|Rm=xxxx|opcode=1110|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0xF00E000) {
		decode_fields32(ENC_SDOT_ASIMDELEM_D, ctx, instr);
		if(!HaveDOTPExt()) {
			UNDEFINED;
		}
		if(ctx->size!=2) {
			UNDEFINED;
		}
		ctx->signed_ = (ctx->U==0);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->M<<4)|ctx->Rm));
		ctx->index = UINT(((ctx->H<<1)|ctx->L));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_SDOT_ASIMDELEM_D);
	}
	return rc;
}

/* sdot_advsimd_vec.xml */
int SDOT_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|0|Rm=xxxxx|1|opcode=0010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE009400) {
		decode_fields32(ENC_SDOT_ASIMDSAME2_D, ctx, instr);
		if(!HaveDOTPExt()) {
			UNDEFINED;
		}
		if(ctx->size!=2) {
			UNDEFINED;
		}
		ctx->signed_ = (ctx->U==0);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_SDOT_ASIMDSAME2_D);
	}
	return rc;
}

/* setf.xml */
int SETF(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=0|op=0|S=1|11010000|opcode2=000000|sz=x|0010|Rn=xxxxx|o3=0|mask=1101 */
	if((INSWORD & 0xFFFFBC1F)==0x3A00080D) {
		decode_fields32(ENC_SETF8_ONLY_SETF, ctx, instr);
		if(!HaveFlagManipulateExt() || ctx->sf!=0) {
			UNDEFINED;
		}
		ctx->msb = (ctx->sz==1) ? 15 : 7;
		ctx->n = UINT(ctx->Rn);
		if(ctx->sz==0) OK(ENC_SETF8_ONLY_SETF);
		if(ctx->sz==1) OK(ENC_SETF16_ONLY_SETF);
	}
	return rc;
}

/* sev.xml */
int SEV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=0000|op2=100|Rt=11111 */
	if((INSWORD & 0xFFFFFFFF)==0xD503209F) {
		decode_fields32(ENC_SEV_HI_HINTS, ctx, instr);
		if(!((ctx->CRm<<3)|ctx->op2)) {
			ctx->op = SystemHintOp_NOP;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==1) {
			ctx->op = SystemHintOp_YIELD;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==2) {
			ctx->op = SystemHintOp_WFE;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==3) {
			ctx->op = SystemHintOp_WFI;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==4) {
			ctx->op = SystemHintOp_SEV;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==5) {
			ctx->op = SystemHintOp_SEVL;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==6) {
			if(!HaveDGHExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_DGH;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==7) {
			SEE /* XPACLRI */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==8) {
			if(!ctx->op2) {
				SEE /* PACIA1716 */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIB1716 */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIA1716 */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIB1716 */;
			}
			else {
				ENDOFINSTRUCTION;
			}
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x10) {
			if(!HaveRASExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_ESB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x11) {
			if(!HaveStatisticalProfiling()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_PSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x12) {
			if(!HaveSelfHostedTrace()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_TSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x14) {
			ctx->op = SystemHintOp_CSDB;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==0x18) {
			if(!ctx->op2) {
				SEE /* PACIAZ */;
			}
			else if(ctx->op2==1) {
				SEE /* PACIASP */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIBZ */;
			}
			else if(ctx->op2==3) {
				SEE /* PACIBSP */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIAZ */;
			}
			else if(ctx->op2==5) {
				SEE /* AUTHASP */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIBZ */;
			}
			else if(ctx->op2==7) {
				SEE /* AUTIBSP */;
			}
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x79)==0x20) {
			ctx->op = SystemHintOp_BTI;
			SetBTypeCompatible(BTypeCompatible_BTI(SLICE(ctx->op2,2,1), ctx->pstate_btype));
		}
		else {
			ENDOFINSTRUCTION;
		}
		OK(ENC_SEV_HI_HINTS);
	}
	return rc;
}

/* sevl.xml */
int SEVL(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=0000|op2=101|Rt=11111 */
	if((INSWORD & 0xFFFFFFFF)==0xD50320BF) {
		decode_fields32(ENC_SEVL_HI_HINTS, ctx, instr);
		if(!((ctx->CRm<<3)|ctx->op2)) {
			ctx->op = SystemHintOp_NOP;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==1) {
			ctx->op = SystemHintOp_YIELD;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==2) {
			ctx->op = SystemHintOp_WFE;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==3) {
			ctx->op = SystemHintOp_WFI;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==4) {
			ctx->op = SystemHintOp_SEV;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==5) {
			ctx->op = SystemHintOp_SEVL;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==6) {
			if(!HaveDGHExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_DGH;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==7) {
			SEE /* XPACLRI */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==8) {
			if(!ctx->op2) {
				SEE /* PACIA1716 */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIB1716 */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIA1716 */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIB1716 */;
			}
			else {
				ENDOFINSTRUCTION;
			}
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x10) {
			if(!HaveRASExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_ESB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x11) {
			if(!HaveStatisticalProfiling()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_PSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x12) {
			if(!HaveSelfHostedTrace()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_TSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x14) {
			ctx->op = SystemHintOp_CSDB;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==0x18) {
			if(!ctx->op2) {
				SEE /* PACIAZ */;
			}
			else if(ctx->op2==1) {
				SEE /* PACIASP */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIBZ */;
			}
			else if(ctx->op2==3) {
				SEE /* PACIBSP */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIAZ */;
			}
			else if(ctx->op2==5) {
				SEE /* AUTHASP */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIBZ */;
			}
			else if(ctx->op2==7) {
				SEE /* AUTIBSP */;
			}
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x79)==0x20) {
			ctx->op = SystemHintOp_BTI;
			SetBTypeCompatible(BTypeCompatible_BTI(SLICE(ctx->op2,2,1), ctx->pstate_btype));
		}
		else {
			ENDOFINSTRUCTION;
		}
		OK(ENC_SEVL_HI_HINTS);
	}
	return rc;
}

/* sha1c_advsimd.xml */
int SHA1C_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 01011110|size=00|0|Rm=xxxxx|0|opcode=000|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x5E000000) {
		decode_fields32(ENC_SHA1C_QSV_CRYPTOSHA3, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!HaveSHA1Ext()) {
			UNDEFINED;
		}
		OK(ENC_SHA1C_QSV_CRYPTOSHA3);
	}
	return rc;
}

/* sha1h_advsimd.xml */
int SHA1H_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 01011110|size=00|10100|opcode=00000|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x5E280800) {
		decode_fields32(ENC_SHA1H_SS_CRYPTOSHA2, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!HaveSHA1Ext()) {
			UNDEFINED;
		}
		OK(ENC_SHA1H_SS_CRYPTOSHA2);
	}
	return rc;
}

/* sha1m_advsimd.xml */
int SHA1M_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 01011110|size=00|0|Rm=xxxxx|0|opcode=010|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x5E002000) {
		decode_fields32(ENC_SHA1M_QSV_CRYPTOSHA3, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!HaveSHA1Ext()) {
			UNDEFINED;
		}
		OK(ENC_SHA1M_QSV_CRYPTOSHA3);
	}
	return rc;
}

/* sha1p_advsimd.xml */
int SHA1P_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 01011110|size=00|0|Rm=xxxxx|0|opcode=001|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x5E001000) {
		decode_fields32(ENC_SHA1P_QSV_CRYPTOSHA3, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!HaveSHA1Ext()) {
			UNDEFINED;
		}
		OK(ENC_SHA1P_QSV_CRYPTOSHA3);
	}
	return rc;
}

/* sha1su0_advsimd.xml */
int SHA1SU0_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 01011110|size=00|0|Rm=xxxxx|0|opcode=011|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x5E003000) {
		decode_fields32(ENC_SHA1SU0_VVV_CRYPTOSHA3, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!HaveSHA1Ext()) {
			UNDEFINED;
		}
		OK(ENC_SHA1SU0_VVV_CRYPTOSHA3);
	}
	return rc;
}

/* sha1su1_advsimd.xml */
int SHA1SU1_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 01011110|size=00|10100|opcode=00001|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x5E281800) {
		decode_fields32(ENC_SHA1SU1_VV_CRYPTOSHA2, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!HaveSHA1Ext()) {
			UNDEFINED;
		}
		OK(ENC_SHA1SU1_VV_CRYPTOSHA2);
	}
	return rc;
}

/* sha256h2_advsimd.xml */
int SHA256H2_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 01011110|size=00|0|Rm=xxxxx|0|10|P=1|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x5E005000) {
		decode_fields32(ENC_SHA256H2_QQV_CRYPTOSHA3, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!HaveSHA256Ext()) {
			UNDEFINED;
		}
		ctx->part1 = (ctx->P==0);
		OK(ENC_SHA256H2_QQV_CRYPTOSHA3);
	}
	return rc;
}

/* sha256h_advsimd.xml */
int SHA256H_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 01011110|size=00|0|Rm=xxxxx|0|10|P=0|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x5E004000) {
		decode_fields32(ENC_SHA256H_QQV_CRYPTOSHA3, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!HaveSHA256Ext()) {
			UNDEFINED;
		}
		ctx->part1 = (ctx->P==0);
		OK(ENC_SHA256H_QQV_CRYPTOSHA3);
	}
	return rc;
}

/* sha256su0_advsimd.xml */
int SHA256SU0_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 01011110|size=00|10100|opcode=00010|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x5E282800) {
		decode_fields32(ENC_SHA256SU0_VV_CRYPTOSHA2, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!HaveSHA256Ext()) {
			UNDEFINED;
		}
		OK(ENC_SHA256SU0_VV_CRYPTOSHA2);
	}
	return rc;
}

/* sha256su1_advsimd.xml */
int SHA256SU1_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 01011110|size=00|0|Rm=xxxxx|0|opcode=110|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x5E006000) {
		decode_fields32(ENC_SHA256SU1_VVV_CRYPTOSHA3, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(!HaveSHA256Ext()) {
			UNDEFINED;
		}
		OK(ENC_SHA256SU1_VVV_CRYPTOSHA3);
	}
	return rc;
}

/* sha512h2_advsimd.xml */
int SHA512H2_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 11001110011|Rm=xxxxx|1|O=0|00|opcode=01|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0xCE608400) {
		decode_fields32(ENC_SHA512H2_QQV_CRYPTOSHA512_3, ctx, instr);
		if(!HaveSHA512Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		OK(ENC_SHA512H2_QQV_CRYPTOSHA512_3);
	}
	return rc;
}

/* sha512h_advsimd.xml */
int SHA512H_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 11001110011|Rm=xxxxx|1|O=0|00|opcode=00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0xCE608000) {
		decode_fields32(ENC_SHA512H_QQV_CRYPTOSHA512_3, ctx, instr);
		if(!HaveSHA512Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		OK(ENC_SHA512H_QQV_CRYPTOSHA512_3);
	}
	return rc;
}

/* sha512su0_advsimd.xml */
int SHA512SU0_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 11001110110000001000|opcode=00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0xCEC08000) {
		decode_fields32(ENC_SHA512SU0_VV2_CRYPTOSHA512_2, ctx, instr);
		if(!HaveSHA512Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		OK(ENC_SHA512SU0_VV2_CRYPTOSHA512_2);
	}
	return rc;
}

/* sha512su1_advsimd.xml */
int SHA512SU1_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 11001110011|Rm=xxxxx|1|O=0|00|opcode=10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0xCE608800) {
		decode_fields32(ENC_SHA512SU1_VVV2_CRYPTOSHA512_3, ctx, instr);
		if(!HaveSHA512Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		OK(ENC_SHA512SU1_VVV2_CRYPTOSHA512_3);
	}
	return rc;
}

/* shadd_advsimd.xml */
int SHADD_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|opcode=00000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE200400) {
		decode_fields32(ENC_SHADD_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SHADD_ASIMDSAME_ONLY);
	}
	return rc;
}

/* shll_advsimd.xml */
int SHLL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|10000|opcode=10011|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0x2E213800) {
		decode_fields32(ENC_SHLL_ASIMDMISC_S, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ctx->esize;
		ctx->unsigned_ = FALSE;
		OK(ENC_SHLL_ASIMDMISC_S);
	}
	return rc;
}

/* shl_advsimd.xml */
int SHL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|111110|immh!=0000|immb=xxx|opcode=01010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x5F005400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SHL_ASISDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(SLICE(ctx->immh,3,3)!=1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (3);
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->shift = UINT(((ctx->immh<<3)|ctx->immb))-ctx->esize;
		OK(ENC_SHL_ASISDSHF_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|011110|immh!=0000|immb=xxx|opcode=01010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0xF005400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SHL_ASIMDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = UINT(((ctx->immh<<3)|ctx->immb))-ctx->esize;
		OK(ENC_SHL_ASIMDSHF_R);
	}
	return rc;
}

/* shrn_advsimd.xml */
int SHRN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=0|011110|immh!=0000|immb=xxx|1000|op=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0xF008400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SHRN_ASIMDSHF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(SLICE(ctx->immh,3,3)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->round = (ctx->op==1);
		OK(ENC_SHRN_ASIMDSHF_N);
	}
	return rc;
}

/* shsub_advsimd.xml */
int SHSUB_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|opcode=00100|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE202400) {
		decode_fields32(ENC_SHSUB_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SHSUB_ASIMDSAME_ONLY);
	}
	return rc;
}

/* sli_advsimd.xml */
int SLI_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|111110|immh!=0000|immb=xxx|opcode=01010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x7F005400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SLI_ASISDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(SLICE(ctx->immh,3,3)!=1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (3);
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->shift = UINT(((ctx->immh<<3)|ctx->immb))-ctx->esize;
		OK(ENC_SLI_ASISDSHF_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|011110|immh!=0000|immb=xxx|opcode=01010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0x2F005400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SLI_ASIMDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = UINT(((ctx->immh<<3)|ctx->immb))-ctx->esize;
		OK(ENC_SLI_ASIMDSHF_R);
	}
	return rc;
}

/* sm3partw1_advsimd.xml */
int SM3PARTW1_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 11001110011|Rm=xxxxx|1|O=1|00|opcode=00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0xCE60C000) {
		decode_fields32(ENC_SM3PARTW1_VVV4_CRYPTOSHA512_3, ctx, instr);
		if(!HaveSM3Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		OK(ENC_SM3PARTW1_VVV4_CRYPTOSHA512_3);
	}
	return rc;
}

/* sm3partw2_advsimd.xml */
int SM3PARTW2_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 11001110011|Rm=xxxxx|1|O=1|00|opcode=01|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0xCE60C400) {
		decode_fields32(ENC_SM3PARTW2_VVV4_CRYPTOSHA512_3, ctx, instr);
		if(!HaveSM3Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		OK(ENC_SM3PARTW2_VVV4_CRYPTOSHA512_3);
	}
	return rc;
}

/* sm3ss1_advsimd.xml */
int SM3SS1_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 110011100|Op0=10|Rm=xxxxx|0|Ra=xxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE08000)==0xCE400000) {
		decode_fields32(ENC_SM3SS1_VVV4_CRYPTO4, ctx, instr);
		if(!HaveSM3Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->a = UINT(ctx->Ra);
		OK(ENC_SM3SS1_VVV4_CRYPTO4);
	}
	return rc;
}

/* sm3tt1a_advsimd.xml */
int SM3TT1A_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 11001110010|Rm=xxxxx|10|imm2=xx|opcode=00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0CC00)==0xCE408000) {
		decode_fields32(ENC_SM3TT1A_VVV4_CRYPTO3_IMM2, ctx, instr);
		if(!HaveSM3Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->i = UINT(ctx->imm2);
		OK(ENC_SM3TT1A_VVV4_CRYPTO3_IMM2);
	}
	return rc;
}

/* sm3tt1b_advsimd.xml */
int SM3TT1B_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 11001110010|Rm=xxxxx|10|imm2=xx|opcode=01|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0CC00)==0xCE408400) {
		decode_fields32(ENC_SM3TT1B_VVV4_CRYPTO3_IMM2, ctx, instr);
		if(!HaveSM3Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->i = UINT(ctx->imm2);
		OK(ENC_SM3TT1B_VVV4_CRYPTO3_IMM2);
	}
	return rc;
}

/* sm3tt2a_advsimd.xml */
int SM3TT2A_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 11001110010|Rm=xxxxx|10|imm2=xx|opcode=10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0CC00)==0xCE408800) {
		decode_fields32(ENC_SM3TT2A_VVV4_CRYPTO3_IMM2, ctx, instr);
		if(!HaveSM3Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->i = UINT(ctx->imm2);
		OK(ENC_SM3TT2A_VVV4_CRYPTO3_IMM2);
	}
	return rc;
}

/* sm3tt2b_advsimd.xml */
int SM3TT2B_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 11001110010|Rm=xxxxx|10|imm2=xx|opcode=11|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0CC00)==0xCE408C00) {
		decode_fields32(ENC_SM3TT2B_VVV_CRYPTO3_IMM2, ctx, instr);
		if(!HaveSM3Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->i = UINT(ctx->imm2);
		OK(ENC_SM3TT2B_VVV_CRYPTO3_IMM2);
	}
	return rc;
}

/* sm4ekey_advsimd.xml */
int SM4EKEY_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 11001110011|Rm=xxxxx|1|O=1|00|opcode=10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0xCE60C800) {
		decode_fields32(ENC_SM4EKEY_VVV4_CRYPTOSHA512_3, ctx, instr);
		if(!HaveSM4Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		OK(ENC_SM4EKEY_VVV4_CRYPTOSHA512_3);
	}
	return rc;
}

/* sm4e_advsimd.xml */
int SM4E_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 11001110110000001000|opcode=01|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0xCEC08400) {
		decode_fields32(ENC_SM4E_VV4_CRYPTOSHA512_2, ctx, instr);
		if(!HaveSM4Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		OK(ENC_SM4E_VV4_CRYPTOSHA512_2);
	}
	return rc;
}

/* smaddl.xml */
int SMADDL(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_64 */
	/* sf=1|op54=00|11011|U=0|01|Rm=xxxxx|o0=0|Ra=xxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE08000)==0x9B200000) {
		decode_fields32(ENC_SMADDL_64WA_DP_3SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->a = UINT(ctx->Ra);
		ctx->destsize = 0x40;
		ctx->datasize = 0x20;
		ctx->sub_op = (ctx->o0==1);
		ctx->unsigned_ = (ctx->U==1);
		/* regular aliases */
		if(ctx->Ra==0x1f) return SMULL_SMADDL(ctx, instr);
		OK(ENC_SMADDL_64WA_DP_3SRC);
	}
	return rc;
}

/* smaxp_advsimd.xml */
int SMAXP_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|1010|o1=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE20A400) {
		decode_fields32(ENC_SMAXP_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_SMAXP_ASIMDSAME_ONLY);
	}
	return rc;
}

/* smaxv_advsimd.xml */
int SMAXV_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|U=0|01110|size=xx|11000|op=0|1010|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE30A800) {
		decode_fields32(ENC_SMAXV_ASIMDALL_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==4) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->min = (ctx->op==1);
		OK(ENC_SMAXV_ASIMDALL_ONLY);
	}
	return rc;
}

/* smax_advsimd.xml */
int SMAX_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|0110|o1=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE206400) {
		decode_fields32(ENC_SMAX_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_SMAX_ASIMDSAME_ONLY);
	}
	return rc;
}

/* smc.xml */
int SMC(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 11010100|opc=000|imm16=xxxxxxxxxxxxxxxx|op2=000|LL=11 */
	if((INSWORD & 0xFFE0001F)==0xD4000003) {
		decode_fields32(ENC_SMC_EX_EXCEPTION, ctx, instr);
		OK(ENC_SMC_EX_EXCEPTION);
	}
	return rc;
}

/* sminp_advsimd.xml */
int SMINP_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|1010|o1=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE20AC00) {
		decode_fields32(ENC_SMINP_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_SMINP_ASIMDSAME_ONLY);
	}
	return rc;
}

/* sminv_advsimd.xml */
int SMINV_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|U=0|01110|size=xx|11000|op=1|1010|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE31A800) {
		decode_fields32(ENC_SMINV_ASIMDALL_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==4) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->min = (ctx->op==1);
		OK(ENC_SMINV_ASIMDALL_ONLY);
	}
	return rc;
}

/* smin_advsimd.xml */
int SMIN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|0110|o1=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE206C00) {
		decode_fields32(ENC_SMIN_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_SMIN_ASIMDSAME_ONLY);
	}
	return rc;
}

/* smlal_advsimd_elt.xml */
int SMLAL_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_element */
	/* 0|Q=x|U=0|01111|size=xx|L=x|M=x|Rm=xxxx|0|o2=0|10|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0xF002000) {
		decode_fields32(ENC_SMLAL_ASIMDELEM_L, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_SMLAL_ASIMDELEM_L);
	}
	return rc;
}

/* smlal_advsimd_vec.xml */
int SMLAL_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|10|o1=0|0|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE208000) {
		decode_fields32(ENC_SMLAL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SMLAL_ASIMDDIFF_L);
	}
	return rc;
}

/* smlsl_advsimd_elt.xml */
int SMLSL_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_element */
	/* 0|Q=x|U=0|01111|size=xx|L=x|M=x|Rm=xxxx|0|o2=1|10|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0xF006000) {
		decode_fields32(ENC_SMLSL_ASIMDELEM_L, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_SMLSL_ASIMDELEM_L);
	}
	return rc;
}

/* smlsl_advsimd_vec.xml */
int SMLSL_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|10|o1=1|0|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE20A000) {
		decode_fields32(ENC_SMLSL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SMLSL_ASIMDDIFF_L);
	}
	return rc;
}

/* smmla_advsimd_vec.xml */
int SMMLA_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=1|U=0|01110|size=10|0|Rm=xxxxx|1|010|B=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x4E80A400) {
		decode_fields32(ENC_SMMLA_ASIMDSAME2_G, ctx, instr);
		if(!HaveInt8MatMulExt()) {
			UNDEFINED;
		}
		if(!((ctx->B<<1)|ctx->U)) {
			ctx->op1_unsigned = FALSE;
			ctx->op2_unsigned = FALSE;
		}
		else if(((ctx->B<<1)|ctx->U)==1) {
			ctx->op1_unsigned = TRUE;
			ctx->op2_unsigned = TRUE;
		}
		else if(((ctx->B<<1)|ctx->U)==2) {
			ctx->op1_unsigned = TRUE;
			ctx->op2_unsigned = FALSE;
		}
		else if(((ctx->B<<1)|ctx->U)==3) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->d = UINT(ctx->Rd);
		OK(ENC_SMMLA_ASIMDSAME2_G);
	}
	return rc;
}

/* smnegl_smsubl.xml */
int SMNEGL_SMSUBL(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_64 */
	/* sf=1|op54=00|11011|U=0|01|Rm=xxxxx|o0=1|Ra=11111|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x9B20FC00) {
		decode_fields32(ENC_SMNEGL_SMSUBL_64WA_DP_3SRC, ctx, instr);
		OK(ENC_SMNEGL_SMSUBL_64WA_DP_3SRC);
	}
	return rc;
}

/* smov_advsimd.xml */
int SMOV_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|op=0|01110000|imm5=xxxxx|0|imm4<3:2>=01|imm4=01|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xE002C00) {
		decode_fields32(ENC_SMOV_ASIMDINS_W_W, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->Q<<5)|ctx->imm5)&1) {
			ctx->size = 0;
		}
		else if((((ctx->Q<<5)|ctx->imm5)&3)==2) {
			ctx->size = 1;
		}
		else if((((ctx->Q<<5)|ctx->imm5)&0x27)==0x24) {
			ctx->size = 2;
		}
		else {
			UNDEFINED;
		}
		ctx->idxdsize = (SLICE(ctx->imm5,4,4)==1) ? 0x80 : 0x40;
		ctx->index = UINT(SLICE(ctx->imm5,4,ctx->size+1));
		ctx->esize = (8) << (ctx->size);
		ctx->datasize = (ctx->Q==1) ? 0x40 : 0x20;
		if(ctx->Q==0) OK(ENC_SMOV_ASIMDINS_W_W);
		if(ctx->Q==1) OK(ENC_SMOV_ASIMDINS_X_X);
	}
	return rc;
}

/* smsubl.xml */
int SMSUBL(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_64 */
	/* sf=1|op54=00|11011|U=0|01|Rm=xxxxx|o0=1|Ra=xxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE08000)==0x9B208000) {
		decode_fields32(ENC_SMSUBL_64WA_DP_3SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->a = UINT(ctx->Ra);
		ctx->destsize = 0x40;
		ctx->datasize = 0x20;
		ctx->sub_op = (ctx->o0==1);
		ctx->unsigned_ = (ctx->U==1);
		/* regular aliases */
		if(ctx->Ra==0x1f) return SMNEGL_SMSUBL(ctx, instr);
		OK(ENC_SMSUBL_64WA_DP_3SRC);
	}
	return rc;
}

/* smulh.xml */
int SMULH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_64 */
	/* sf=1|op54=00|11011|U=0|10|Rm=xxxxx|o0=0|Ra=(1)(1)(1)(1)(1)|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE08000)==0x9B400000) {
		decode_fields32(ENC_SMULH_64_DP_3SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->a = UINT(ctx->Ra);
		ctx->destsize = 0x40;
		ctx->datasize = ctx->destsize;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SMULH_64_DP_3SRC);
	}
	return rc;
}

/* smull_smaddl.xml */
int SMULL_SMADDL(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_64 */
	/* sf=1|op54=00|11011|U=0|01|Rm=xxxxx|o0=0|Ra=11111|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x9B207C00) {
		decode_fields32(ENC_SMULL_SMADDL_64WA_DP_3SRC, ctx, instr);
		OK(ENC_SMULL_SMADDL_64WA_DP_3SRC);
	}
	return rc;
}

/* smull_advsimd_elt.xml */
int SMULL_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_element */
	/* 0|Q=x|U=0|01111|size=xx|L=x|M=x|Rm=xxxx|opcode=1010|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0xF00A000) {
		decode_fields32(ENC_SMULL_ASIMDELEM_L, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SMULL_ASIMDELEM_L);
	}
	return rc;
}

/* smull_advsimd_vec.xml */
int SMULL_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|opcode=1100|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE20C000) {
		decode_fields32(ENC_SMULL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SMULL_ASIMDDIFF_L);
	}
	return rc;
}

/* sqabs_advsimd.xml */
int SQABS_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|10000|opcode=00111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x5E207800) {
		decode_fields32(ENC_SQABS_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->neg = (ctx->U==1);
		OK(ENC_SQABS_ASISDMISC_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|10000|opcode=00111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE207800) {
		decode_fields32(ENC_SQABS_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->neg = (ctx->U==1);
		OK(ENC_SQABS_ASIMDMISC_R);
	}
	return rc;
}

/* sqadd_advsimd.xml */
int SQADD_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|1|Rm=xxxxx|opcode=00001|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x5E200C00) {
		decode_fields32(ENC_SQADD_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SQADD_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|opcode=00001|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE200C00) {
		decode_fields32(ENC_SQADD_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SQADD_ASIMDSAME_ONLY);
	}
	return rc;
}

/* sqdmlal_advsimd_elt.xml */
int SQDMLAL_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_scalar */
	/* 01|U=0|11111|size=xx|L=x|M=x|Rm=xxxx|0|o2=0|11|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF00F400)==0x5F003000) {
		decode_fields32(ENC_SQDMLAL_ASISDELEM_L, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->part = 0;
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_SQDMLAL_ASISDELEM_L);
	}
	/* class iclass_2reg_element */
	/* 0|Q=x|U=0|01111|size=xx|L=x|M=x|Rm=xxxx|0|o2=0|11|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0xF003000) {
		decode_fields32(ENC_SQDMLAL_ASIMDELEM_L, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_SQDMLAL_ASIMDELEM_L);
	}
	return rc;
}

/* sqdmlal_advsimd_vec.xml */
int SQDMLAL_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|1|Rm=xxxxx|10|o1=0|1|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x5E209000) {
		decode_fields32(ENC_SQDMLAL_ASISDDIFF_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==0 || ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->part = 0;
		ctx->sub_op = (ctx->o1==1);
		OK(ENC_SQDMLAL_ASISDDIFF_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|10|o1=0|1|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE209000) {
		decode_fields32(ENC_SQDMLAL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==0 || ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		OK(ENC_SQDMLAL_ASIMDDIFF_L);
	}
	return rc;
}

/* sqdmlsl_advsimd_elt.xml */
int SQDMLSL_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_scalar */
	/* 01|U=0|11111|size=xx|L=x|M=x|Rm=xxxx|0|o2=1|11|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF00F400)==0x5F007000) {
		decode_fields32(ENC_SQDMLSL_ASISDELEM_L, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->part = 0;
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_SQDMLSL_ASISDELEM_L);
	}
	/* class iclass_2reg_element */
	/* 0|Q=x|U=0|01111|size=xx|L=x|M=x|Rm=xxxx|0|o2=1|11|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0xF007000) {
		decode_fields32(ENC_SQDMLSL_ASIMDELEM_L, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_SQDMLSL_ASIMDELEM_L);
	}
	return rc;
}

/* sqdmlsl_advsimd_vec.xml */
int SQDMLSL_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|1|Rm=xxxxx|10|o1=1|1|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x5E20B000) {
		decode_fields32(ENC_SQDMLSL_ASISDDIFF_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==0 || ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->part = 0;
		ctx->sub_op = (ctx->o1==1);
		OK(ENC_SQDMLSL_ASISDDIFF_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|10|o1=1|1|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE20B000) {
		decode_fields32(ENC_SQDMLSL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==0 || ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		OK(ENC_SQDMLSL_ASIMDDIFF_L);
	}
	return rc;
}

/* sqdmulh_advsimd_elt.xml */
int SQDMULH_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_scalar */
	/* 01|U=0|11111|size=xx|L=x|M=x|Rm=xxxx|110|op=0|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF00F400)==0x5F00C000) {
		decode_fields32(ENC_SQDMULH_ASISDELEM_R, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->round = (ctx->op==1);
		OK(ENC_SQDMULH_ASISDELEM_R);
	}
	/* class iclass_2reg_element */
	/* 0|Q=x|U=0|01111|size=xx|L=x|M=x|Rm=xxxx|110|op=0|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0xF00C000) {
		decode_fields32(ENC_SQDMULH_ASIMDELEM_R, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->round = (ctx->op==1);
		OK(ENC_SQDMULH_ASIMDELEM_R);
	}
	return rc;
}

/* sqdmulh_advsimd_vec.xml */
int SQDMULH_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|1|Rm=xxxxx|opcode=10110|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x5E20B400) {
		decode_fields32(ENC_SQDMULH_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3 || ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = (ctx->U==1);
		OK(ENC_SQDMULH_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|opcode=10110|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE20B400) {
		decode_fields32(ENC_SQDMULH_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3 || ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = (ctx->U==1);
		OK(ENC_SQDMULH_ASIMDSAME_ONLY);
	}
	return rc;
}

/* sqdmull_advsimd_elt.xml */
int SQDMULL_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_scalar */
	/* 01|U=0|11111|size=xx|L=x|M=x|Rm=xxxx|opcode=1011|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF00F400)==0x5F00B000) {
		decode_fields32(ENC_SQDMULL_ASISDELEM_L, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->part = 0;
		OK(ENC_SQDMULL_ASISDELEM_L);
	}
	/* class iclass_2reg_element */
	/* 0|Q=x|U=0|01111|size=xx|L=x|M=x|Rm=xxxx|opcode=1011|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0xF00B000) {
		decode_fields32(ENC_SQDMULL_ASIMDELEM_L, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_SQDMULL_ASIMDELEM_L);
	}
	return rc;
}

/* sqdmull_advsimd_vec.xml */
int SQDMULL_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|1|Rm=xxxxx|opcode=1101|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x5E20D000) {
		decode_fields32(ENC_SQDMULL_ASISDDIFF_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==0 || ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->part = 0;
		OK(ENC_SQDMULL_ASISDDIFF_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|opcode=1101|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE20D000) {
		decode_fields32(ENC_SQDMULL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==0 || ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_SQDMULL_ASIMDDIFF_L);
	}
	return rc;
}

/* sqneg_advsimd.xml */
int SQNEG_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|10000|opcode=00111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x7E207800) {
		decode_fields32(ENC_SQNEG_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->neg = (ctx->U==1);
		OK(ENC_SQNEG_ASISDMISC_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|10000|opcode=00111|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0x2E207800) {
		decode_fields32(ENC_SQNEG_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->neg = (ctx->U==1);
		OK(ENC_SQNEG_ASIMDMISC_R);
	}
	return rc;
}

/* sqrdmlah_advsimd_elt.xml */
int SQRDMLAH_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_scalar */
	/* 01|U=1|11111|size=xx|L=x|M=x|Rm=xxxx|11|S=0|1|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF00F400)==0x7F00D000) {
		decode_fields32(ENC_SQRDMLAH_ASISDELEM_R, ctx, instr);
		if(!HaveQRDMLAHExt()) {
			UNDEFINED;
		}
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = TRUE;
		ctx->sub_op = (ctx->S==1);
		OK(ENC_SQRDMLAH_ASISDELEM_R);
	}
	/* class iclass_2reg_element */
	/* 0|Q=x|U=1|01111|size=xx|L=x|M=x|Rm=xxxx|11|S=0|1|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0x2F00D000) {
		decode_fields32(ENC_SQRDMLAH_ASIMDELEM_R, ctx, instr);
		if(!HaveQRDMLAHExt()) {
			UNDEFINED;
		}
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = TRUE;
		ctx->sub_op = (ctx->S==1);
		OK(ENC_SQRDMLAH_ASIMDELEM_R);
	}
	return rc;
}

/* sqrdmlah_advsimd_vec.xml */
int SQRDMLAH_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|0|Rm=xxxxx|1|000|S=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x7E008400) {
		decode_fields32(ENC_SQRDMLAH_ASISDSAME2_ONLY, ctx, instr);
		if(!HaveQRDMLAHExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3 || ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = TRUE;
		ctx->sub_op = (ctx->S==1);
		OK(ENC_SQRDMLAH_ASISDSAME2_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|0|Rm=xxxxx|1|000|S=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E008400) {
		decode_fields32(ENC_SQRDMLAH_ASIMDSAME2_ONLY, ctx, instr);
		if(!HaveQRDMLAHExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3 || ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = TRUE;
		ctx->sub_op = (ctx->S==1);
		OK(ENC_SQRDMLAH_ASIMDSAME2_ONLY);
	}
	return rc;
}

/* sqrdmlsh_advsimd_elt.xml */
int SQRDMLSH_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_scalar */
	/* 01|U=1|11111|size=xx|L=x|M=x|Rm=xxxx|11|S=1|1|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF00F400)==0x7F00F000) {
		decode_fields32(ENC_SQRDMLSH_ASISDELEM_R, ctx, instr);
		if(!HaveQRDMLAHExt()) {
			UNDEFINED;
		}
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = TRUE;
		ctx->sub_op = (ctx->S==1);
		OK(ENC_SQRDMLSH_ASISDELEM_R);
	}
	/* class iclass_2reg_element */
	/* 0|Q=x|U=1|01111|size=xx|L=x|M=x|Rm=xxxx|11|S=1|1|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0x2F00F000) {
		decode_fields32(ENC_SQRDMLSH_ASIMDELEM_R, ctx, instr);
		if(!HaveQRDMLAHExt()) {
			UNDEFINED;
		}
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = TRUE;
		ctx->sub_op = (ctx->S==1);
		OK(ENC_SQRDMLSH_ASIMDELEM_R);
	}
	return rc;
}

/* sqrdmlsh_advsimd_vec.xml */
int SQRDMLSH_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|0|Rm=xxxxx|1|000|S=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x7E008C00) {
		decode_fields32(ENC_SQRDMLSH_ASISDSAME2_ONLY, ctx, instr);
		if(!HaveQRDMLAHExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3 || ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = TRUE;
		ctx->sub_op = (ctx->S==1);
		OK(ENC_SQRDMLSH_ASISDSAME2_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|0|Rm=xxxxx|1|000|S=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E008C00) {
		decode_fields32(ENC_SQRDMLSH_ASIMDSAME2_ONLY, ctx, instr);
		if(!HaveQRDMLAHExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3 || ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = TRUE;
		ctx->sub_op = (ctx->S==1);
		OK(ENC_SQRDMLSH_ASIMDSAME2_ONLY);
	}
	return rc;
}

/* sqrdmulh_advsimd_elt.xml */
int SQRDMULH_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_scalar */
	/* 01|U=0|11111|size=xx|L=x|M=x|Rm=xxxx|110|op=1|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF00F400)==0x5F00D000) {
		decode_fields32(ENC_SQRDMULH_ASISDELEM_R, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->round = (ctx->op==1);
		OK(ENC_SQRDMULH_ASISDELEM_R);
	}
	/* class iclass_2reg_element */
	/* 0|Q=x|U=0|01111|size=xx|L=x|M=x|Rm=xxxx|110|op=1|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0xF00D000) {
		decode_fields32(ENC_SQRDMULH_ASIMDELEM_R, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->round = (ctx->op==1);
		OK(ENC_SQRDMULH_ASIMDELEM_R);
	}
	return rc;
}

/* sqrdmulh_advsimd_vec.xml */
int SQRDMULH_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|1|Rm=xxxxx|opcode=10110|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x7E20B400) {
		decode_fields32(ENC_SQRDMULH_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3 || ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->rounding = (ctx->U==1);
		OK(ENC_SQRDMULH_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|opcode=10110|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E20B400) {
		decode_fields32(ENC_SQRDMULH_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3 || ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->rounding = (ctx->U==1);
		OK(ENC_SQRDMULH_ASIMDSAME_ONLY);
	}
	return rc;
}

/* sqrshl_advsimd.xml */
int SQRSHL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|1|Rm=xxxxx|010|R=1|S=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x5E205C00) {
		decode_fields32(ENC_SQRSHL_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = (ctx->R==1);
		ctx->saturating = (ctx->S==1);
		if(ctx->S==0 && ctx->size!=3) {
			UNDEFINED;
		}
		OK(ENC_SQRSHL_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|010|R=1|S=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE205C00) {
		decode_fields32(ENC_SQRSHL_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = (ctx->R==1);
		ctx->saturating = (ctx->S==1);
		OK(ENC_SQRSHL_ASIMDSAME_ONLY);
	}
	return rc;
}

/* sqrshrn_advsimd.xml */
int SQRSHRN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|111110|immh!=0000|immb=xxx|1001|op=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x5F009C00 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SQRSHRN_ASISDSHF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			UNDEFINED;
		}
		if(SLICE(ctx->immh,3,3)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->part = 0;
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->round = (ctx->op==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SQRSHRN_ASISDSHF_N);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|011110|immh!=0000|immb=xxx|1001|op=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0xF009C00 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SQRSHRN_ASIMDSHF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(SLICE(ctx->immh,3,3)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->round = (ctx->op==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SQRSHRN_ASIMDSHF_N);
	}
	return rc;
}

/* sqrshrun_advsimd.xml */
int SQRSHRUN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|111110|immh!=0000|immb=xxx|1000|op=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x7F008C00 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SQRSHRUN_ASISDSHF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			UNDEFINED;
		}
		if(SLICE(ctx->immh,3,3)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->part = 0;
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->round = (ctx->op==1);
		OK(ENC_SQRSHRUN_ASISDSHF_N);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|011110|immh!=0000|immb=xxx|1000|op=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0x2F008C00 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SQRSHRUN_ASIMDSHF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(SLICE(ctx->immh,3,3)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->round = (ctx->op==1);
		OK(ENC_SQRSHRUN_ASIMDSHF_N);
	}
	return rc;
}

/* sqshlu_advsimd.xml */
int SQSHLU_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|111110|immh!=0000|immb=xxx|011|op=0|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x7F006400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SQSHLU_ASISDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->shift = UINT(((ctx->immh<<3)|ctx->immb))-ctx->esize;
		if(!((ctx->op<<1)|ctx->U)) {
			UNDEFINED;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->src_unsigned = FALSE;
			ctx->dst_unsigned = TRUE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->src_unsigned = FALSE;
			ctx->dst_unsigned = FALSE;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->src_unsigned = TRUE;
			ctx->dst_unsigned = TRUE;
		}
		OK(ENC_SQSHLU_ASISDSHF_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|011110|immh!=0000|immb=xxx|011|op=0|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0x2F006400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SQSHLU_ASIMDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = UINT(((ctx->immh<<3)|ctx->immb))-ctx->esize;
		if(!((ctx->op<<1)|ctx->U)) {
			UNDEFINED;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->src_unsigned = FALSE;
			ctx->dst_unsigned = TRUE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->src_unsigned = FALSE;
			ctx->dst_unsigned = FALSE;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->src_unsigned = TRUE;
			ctx->dst_unsigned = TRUE;
		}
		OK(ENC_SQSHLU_ASIMDSHF_R);
	}
	return rc;
}

/* sqshl_advsimd_imm.xml */
int SQSHL_advsimd_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|111110|immh!=0000|immb=xxx|011|op=1|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x5F007400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SQSHL_ASISDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->shift = UINT(((ctx->immh<<3)|ctx->immb))-ctx->esize;
		if(!((ctx->op<<1)|ctx->U)) {
			UNDEFINED;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->src_unsigned = FALSE;
			ctx->dst_unsigned = TRUE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->src_unsigned = FALSE;
			ctx->dst_unsigned = FALSE;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->src_unsigned = TRUE;
			ctx->dst_unsigned = TRUE;
		}
		OK(ENC_SQSHL_ASISDSHF_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|011110|immh!=0000|immb=xxx|011|op=1|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0xF007400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SQSHL_ASIMDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = UINT(((ctx->immh<<3)|ctx->immb))-ctx->esize;
		if(!((ctx->op<<1)|ctx->U)) {
			UNDEFINED;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->src_unsigned = FALSE;
			ctx->dst_unsigned = TRUE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->src_unsigned = FALSE;
			ctx->dst_unsigned = FALSE;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->src_unsigned = TRUE;
			ctx->dst_unsigned = TRUE;
		}
		OK(ENC_SQSHL_ASIMDSHF_R);
	}
	return rc;
}

/* sqshl_advsimd_reg.xml */
int SQSHL_advsimd_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|1|Rm=xxxxx|010|R=0|S=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x5E204C00) {
		decode_fields32(ENC_SQSHL_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = (ctx->R==1);
		ctx->saturating = (ctx->S==1);
		if(ctx->S==0 && ctx->size!=3) {
			UNDEFINED;
		}
		OK(ENC_SQSHL_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|010|R=0|S=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE204C00) {
		decode_fields32(ENC_SQSHL_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = (ctx->R==1);
		ctx->saturating = (ctx->S==1);
		OK(ENC_SQSHL_ASIMDSAME_ONLY);
	}
	return rc;
}

/* sqshrn_advsimd.xml */
int SQSHRN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|111110|immh!=0000|immb=xxx|1001|op=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x5F009400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SQSHRN_ASISDSHF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			UNDEFINED;
		}
		if(SLICE(ctx->immh,3,3)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->part = 0;
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->round = (ctx->op==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SQSHRN_ASISDSHF_N);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|011110|immh!=0000|immb=xxx|1001|op=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0xF009400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SQSHRN_ASIMDSHF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(SLICE(ctx->immh,3,3)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->round = (ctx->op==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SQSHRN_ASIMDSHF_N);
	}
	return rc;
}

/* sqshrun_advsimd.xml */
int SQSHRUN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|111110|immh!=0000|immb=xxx|1000|op=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x7F008400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SQSHRUN_ASISDSHF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			UNDEFINED;
		}
		if(SLICE(ctx->immh,3,3)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->part = 0;
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->round = (ctx->op==1);
		OK(ENC_SQSHRUN_ASISDSHF_N);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|011110|immh!=0000|immb=xxx|1000|op=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0x2F008400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SQSHRUN_ASIMDSHF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(SLICE(ctx->immh,3,3)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->round = (ctx->op==1);
		OK(ENC_SQSHRUN_ASIMDSHF_N);
	}
	return rc;
}

/* sqsub_advsimd.xml */
int SQSUB_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|1|Rm=xxxxx|opcode=00101|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x5E202C00) {
		decode_fields32(ENC_SQSUB_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SQSUB_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|opcode=00101|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE202C00) {
		decode_fields32(ENC_SQSUB_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SQSUB_ASIMDSAME_ONLY);
	}
	return rc;
}

/* sqxtn_advsimd.xml */
int SQXTN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|10000|opcode=10100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x5E214800) {
		decode_fields32(ENC_SQXTN_ASISDMISC_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->part = 0;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SQXTN_ASISDMISC_N);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|10000|opcode=10100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE214800) {
		decode_fields32(ENC_SQXTN_ASIMDMISC_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SQXTN_ASIMDMISC_N);
	}
	return rc;
}

/* sqxtun_advsimd.xml */
int SQXTUN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|10000|opcode=10010|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x7E212800) {
		decode_fields32(ENC_SQXTUN_ASISDMISC_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->part = 0;
		ctx->elements = 1;
		OK(ENC_SQXTUN_ASISDMISC_N);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|10000|opcode=10010|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0x2E212800) {
		decode_fields32(ENC_SQXTUN_ASIMDMISC_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_SQXTUN_ASIMDMISC_N);
	}
	return rc;
}

/* srhadd_advsimd.xml */
int SRHADD_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|opcode=00010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE201400) {
		decode_fields32(ENC_SRHADD_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SRHADD_ASIMDSAME_ONLY);
	}
	return rc;
}

/* sri_advsimd.xml */
int SRI_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|111110|immh!=0000|immb=xxx|opcode=01000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x7F004400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SRI_ASISDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(SLICE(ctx->immh,3,3)!=1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (3);
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		OK(ENC_SRI_ASISDSHF_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|011110|immh!=0000|immb=xxx|opcode=01000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0x2F004400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SRI_ASIMDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		OK(ENC_SRI_ASIMDSHF_R);
	}
	return rc;
}

/* srshl_advsimd.xml */
int SRSHL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|1|Rm=xxxxx|010|R=1|S=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x5E205400) {
		decode_fields32(ENC_SRSHL_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = (ctx->R==1);
		ctx->saturating = (ctx->S==1);
		if(ctx->S==0 && ctx->size!=3) {
			UNDEFINED;
		}
		OK(ENC_SRSHL_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|010|R=1|S=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE205400) {
		decode_fields32(ENC_SRSHL_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = (ctx->R==1);
		ctx->saturating = (ctx->S==1);
		OK(ENC_SRSHL_ASIMDSAME_ONLY);
	}
	return rc;
}

/* srshr_advsimd.xml */
int SRSHR_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|111110|immh!=0000|immb=xxx|00|o1=1|o0=0|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x5F002400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SRSHR_ASISDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(SLICE(ctx->immh,3,3)!=1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (3);
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->round = (ctx->o1==1);
		ctx->accumulate = (ctx->o0==1);
		OK(ENC_SRSHR_ASISDSHF_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|011110|immh!=0000|immb=xxx|00|o1=1|o0=0|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0xF002400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SRSHR_ASIMDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->round = (ctx->o1==1);
		ctx->accumulate = (ctx->o0==1);
		OK(ENC_SRSHR_ASIMDSHF_R);
	}
	return rc;
}

/* srsra_advsimd.xml */
int SRSRA_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|111110|immh!=0000|immb=xxx|00|o1=1|o0=1|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x5F003400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SRSRA_ASISDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(SLICE(ctx->immh,3,3)!=1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (3);
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->round = (ctx->o1==1);
		ctx->accumulate = (ctx->o0==1);
		OK(ENC_SRSRA_ASISDSHF_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|011110|immh!=0000|immb=xxx|00|o1=1|o0=1|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0xF003400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SRSRA_ASIMDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->round = (ctx->o1==1);
		ctx->accumulate = (ctx->o0==1);
		OK(ENC_SRSRA_ASIMDSHF_R);
	}
	return rc;
}

/* ssbb_dsb.xml */
int SSBB_DSB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_dsb_memory */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0011|CRm=0000|1|opc=00|Rt=11111 */
	if((INSWORD & 0xFFFFFFFF)==0xD503309F) {
		decode_fields32(ENC_SSBB_DSB_BO_BARRIERS, ctx, instr);
		OK(ENC_SSBB_DSB_BO_BARRIERS);
	}
	return rc;
}

/* sshll_advsimd.xml */
int SSHLL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=0|011110|immh!=0000|immb=xxx|opcode=10100|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0xF00A400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SSHLL_ASIMDSHF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(SLICE(ctx->immh,3,3)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = UINT(((ctx->immh<<3)|ctx->immb))-ctx->esize;
		ctx->unsigned_ = (ctx->U==1);
		/* regular aliases */
		if(ctx->immb==0 && BitCount(ctx->immh)==1) return SXTL_SSHLL_advsimd(ctx, instr);
		OK(ENC_SSHLL_ASIMDSHF_L);
	}
	return rc;
}

/* sshl_advsimd.xml */
int SSHL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|1|Rm=xxxxx|010|R=0|S=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x5E204400) {
		decode_fields32(ENC_SSHL_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = (ctx->R==1);
		ctx->saturating = (ctx->S==1);
		if(ctx->S==0 && ctx->size!=3) {
			UNDEFINED;
		}
		OK(ENC_SSHL_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|010|R=0|S=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE204400) {
		decode_fields32(ENC_SSHL_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = (ctx->R==1);
		ctx->saturating = (ctx->S==1);
		OK(ENC_SSHL_ASIMDSAME_ONLY);
	}
	return rc;
}

/* sshr_advsimd.xml */
int SSHR_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|111110|immh!=0000|immb=xxx|00|o1=0|o0=0|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x5F000400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SSHR_ASISDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(SLICE(ctx->immh,3,3)!=1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (3);
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->round = (ctx->o1==1);
		ctx->accumulate = (ctx->o0==1);
		OK(ENC_SSHR_ASISDSHF_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|011110|immh!=0000|immb=xxx|00|o1=0|o0=0|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0xF000400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SSHR_ASIMDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->round = (ctx->o1==1);
		ctx->accumulate = (ctx->o0==1);
		OK(ENC_SSHR_ASIMDSHF_R);
	}
	return rc;
}

/* ssra_advsimd.xml */
int SSRA_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|111110|immh!=0000|immb=xxx|00|o1=0|o0=1|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x5F001400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SSRA_ASISDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(SLICE(ctx->immh,3,3)!=1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (3);
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->round = (ctx->o1==1);
		ctx->accumulate = (ctx->o0==1);
		OK(ENC_SSRA_ASISDSHF_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|011110|immh!=0000|immb=xxx|00|o1=0|o0=1|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0xF001400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SSRA_ASIMDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->round = (ctx->o1==1);
		ctx->accumulate = (ctx->o0==1);
		OK(ENC_SSRA_ASIMDSHF_R);
	}
	return rc;
}

/* ssubl_advsimd.xml */
int SSUBL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|00|o1=1|0|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE202000) {
		decode_fields32(ENC_SSUBL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SSUBL_ASIMDDIFF_L);
	}
	return rc;
}

/* ssubw_advsimd.xml */
int SSUBW_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|00|o1=1|1|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE203000) {
		decode_fields32(ENC_SSUBW_ASIMDDIFF_W, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SSUBW_ASIMDDIFF_W);
	}
	return rc;
}

/* st1_advsimd_mult.xml */
int ST1_advsimd_mult(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011000|L=0|000000|opcode=xx1x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFF2000)==0xC002000) {
		decode_fields32(ENC_ST1_ASISDLSE_R1_1V, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->opcode==7) OK(ENC_ST1_ASISDLSE_R1_1V);
		if(ctx->opcode==10) OK(ENC_ST1_ASISDLSE_R2_2V);
		if(ctx->opcode==6) OK(ENC_ST1_ASISDLSE_R3_3V);
		if(ctx->opcode==2) OK(ENC_ST1_ASISDLSE_R4_4V);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011001|L=0|0|Rm=xxxxx|opcode=xx1x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE02000)==0xC802000) {
		decode_fields32(ENC_ST1_ASISDLSEP_I1_I1, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f && ctx->opcode==7) OK(ENC_ST1_ASISDLSEP_I1_I1);
		if(ctx->Rm!=0x1f && ctx->opcode==7) OK(ENC_ST1_ASISDLSEP_R1_R1);
		if(ctx->Rm==0x1f && ctx->opcode==10) OK(ENC_ST1_ASISDLSEP_I2_I2);
		if(ctx->Rm!=0x1f && ctx->opcode==10) OK(ENC_ST1_ASISDLSEP_R2_R2);
		if(ctx->Rm==0x1f && ctx->opcode==6) OK(ENC_ST1_ASISDLSEP_I3_I3);
		if(ctx->Rm!=0x1f && ctx->opcode==6) OK(ENC_ST1_ASISDLSEP_R3_R3);
		if(ctx->Rm==0x1f && ctx->opcode==2) OK(ENC_ST1_ASISDLSEP_I4_I4);
		if(ctx->Rm!=0x1f && ctx->opcode==2) OK(ENC_ST1_ASISDLSEP_R4_R4);
	}
	/* post-decode pcode */
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (UINT(ctx->size));
	ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
	if(!ctx->opcode) {
		ctx->rpt = 1;
		ctx->selem = 4;
	}
	else if(ctx->opcode==2) {
		ctx->rpt = 4;
		ctx->selem = 1;
	}
	else if(ctx->opcode==4) {
		ctx->rpt = 1;
		ctx->selem = 3;
	}
	else if(ctx->opcode==6) {
		ctx->rpt = 3;
		ctx->selem = 1;
	}
	else if(ctx->opcode==7) {
		ctx->rpt = 1;
		ctx->selem = 1;
	}
	else if(ctx->opcode==8) {
		ctx->rpt = 1;
		ctx->selem = 2;
	}
	else if(ctx->opcode==10) {
		ctx->rpt = 2;
		ctx->selem = 1;
	}
	else {
		UNDEFINED;
	}
	if(((ctx->size<<1)|ctx->Q)==6 && ctx->selem!=1) {
		UNDEFINED;
	}
	return rc;
}

/* st1_advsimd_sngl.xml */
int ST1_advsimd_sngl(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011010|L=0|R=0|00000|opcode=xx0|S=x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFF2000)==0xD000000) {
		decode_fields32(ENC_ST1_ASISDLSO_B1_1B, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->opcode==0) OK(ENC_ST1_ASISDLSO_B1_1B);
		if(ctx->opcode==2 && !(ctx->size&1)) OK(ENC_ST1_ASISDLSO_H1_1H);
		if(ctx->opcode==4 && ctx->size==0) OK(ENC_ST1_ASISDLSO_S1_1S);
		if(ctx->opcode==4 && ctx->S==0 && ctx->size==1) OK(ENC_ST1_ASISDLSO_D1_1D);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011011|L=0|R=0|Rm=xxxxx|opcode=xx0|S=x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE02000)==0xD800000) {
		decode_fields32(ENC_ST1_ASISDLSOP_B1_I1B, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f && ctx->opcode==0) OK(ENC_ST1_ASISDLSOP_B1_I1B);
		if(ctx->Rm!=0x1f && ctx->opcode==0) OK(ENC_ST1_ASISDLSOP_BX1_R1B);
		if(ctx->Rm==0x1f && ctx->opcode==2 && !(ctx->size&1)) OK(ENC_ST1_ASISDLSOP_H1_I1H);
		if(ctx->Rm!=0x1f && ctx->opcode==2 && !(ctx->size&1)) OK(ENC_ST1_ASISDLSOP_HX1_R1H);
		if(ctx->Rm==0x1f && ctx->opcode==4 && ctx->size==0) OK(ENC_ST1_ASISDLSOP_S1_I1S);
		if(ctx->Rm!=0x1f && ctx->opcode==4 && ctx->size==0) OK(ENC_ST1_ASISDLSOP_SX1_R1S);
		if(ctx->Rm==0x1f && ctx->opcode==4 && ctx->S==0 && ctx->size==1) OK(ENC_ST1_ASISDLSOP_D1_I1D);
		if(ctx->Rm!=0x1f && ctx->opcode==4 && ctx->S==0 && ctx->size==1) OK(ENC_ST1_ASISDLSOP_DX1_R1D);
	}
	/* post-decode pcode */
	ctx->init_scale = UINT(SLICE(ctx->opcode,2,1));
	ctx->scale = ctx->init_scale;
	ctx->selem = UINT(((SLICE(ctx->opcode,0,0)<<1)|ctx->R))+1;
	ctx->replicate = FALSE;
	if(ctx->scale==3) {
		if(ctx->L==0 || ctx->S==1) {
			UNDEFINED;
		}
		ctx->scale = UINT(ctx->size);
		ctx->replicate = TRUE;
	}
	else if(ctx->scale==0) {
		ctx->index = UINT(((ctx->Q<<3)|(ctx->S<<2)|ctx->size));
	}
	else if(ctx->scale==1) {
		if(SLICE(ctx->size,0,0)==1) {
			UNDEFINED;
		}
		ctx->index = UINT(((ctx->Q<<2)|(ctx->S<<1)|SLICE(ctx->size,1,1)));
	}
	else if(ctx->scale==2) {
		if(SLICE(ctx->size,1,1)==1) {
			UNDEFINED;
		}
		if(SLICE(ctx->size,0,0)==0) {
			ctx->index = UINT(((ctx->Q<<1)|ctx->S));
		}
		else {
			if(ctx->S==1) {
				UNDEFINED;
			}
			ctx->index = UINT(ctx->Q);
			ctx->scale = 3;
		}
	}
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (ctx->scale);
	return rc;
}

/* st2g.xml */
int ST2G(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* 11011001|opc=10|1|imm9=xxxxxxxxx|op2=01|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xD9A00400) {
		decode_fields32(ENC_ST2G_64SPOST_LDSTTAGS, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Xn);
		ctx->t = UINT(ctx->Xt);
		ctx->offset = LSL(SignExtend(ctx->imm9,9),LOG2_TAG_GRANULE);
		ctx->writeback = TRUE;
		ctx->postindex = TRUE;
		ctx->zero_data = FALSE;
		OK(ENC_ST2G_64SPOST_LDSTTAGS);
	}
	/* class iclass_pre_indexed */
	/* 11011001|opc=10|1|imm9=xxxxxxxxx|op2=11|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xD9A00C00) {
		decode_fields32(ENC_ST2G_64SPRE_LDSTTAGS, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Xn);
		ctx->t = UINT(ctx->Xt);
		ctx->offset = LSL(SignExtend(ctx->imm9,9),LOG2_TAG_GRANULE);
		ctx->writeback = TRUE;
		ctx->postindex = FALSE;
		ctx->zero_data = FALSE;
		OK(ENC_ST2G_64SPRE_LDSTTAGS);
	}
	/* class iclass_signed_scaled_offset */
	/* 11011001|opc=10|1|imm9=xxxxxxxxx|op2=10|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xD9A00800) {
		decode_fields32(ENC_ST2G_64SOFFSET_LDSTTAGS, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Xn);
		ctx->t = UINT(ctx->Xt);
		ctx->offset = LSL(SignExtend(ctx->imm9,9),LOG2_TAG_GRANULE);
		ctx->writeback = FALSE;
		ctx->postindex = FALSE;
		ctx->zero_data = FALSE;
		OK(ENC_ST2G_64SOFFSET_LDSTTAGS);
	}
	return rc;
}

/* st2_advsimd_mult.xml */
int ST2_advsimd_mult(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011000|L=0|000000|opcode=1000|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFFF000)==0xC008000) {
		decode_fields32(ENC_ST2_ASISDLSE_R2, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		OK(ENC_ST2_ASISDLSE_R2);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011001|L=0|0|Rm=xxxxx|opcode=1000|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE0F000)==0xC808000) {
		decode_fields32(ENC_ST2_ASISDLSEP_I2_I, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f) OK(ENC_ST2_ASISDLSEP_I2_I);
		if(ctx->Rm!=0x1f) OK(ENC_ST2_ASISDLSEP_R2_R);
	}
	/* post-decode pcode */
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (UINT(ctx->size));
	ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
	if(!ctx->opcode) {
		ctx->rpt = 1;
		ctx->selem = 4;
	}
	else if(ctx->opcode==2) {
		ctx->rpt = 4;
		ctx->selem = 1;
	}
	else if(ctx->opcode==4) {
		ctx->rpt = 1;
		ctx->selem = 3;
	}
	else if(ctx->opcode==6) {
		ctx->rpt = 3;
		ctx->selem = 1;
	}
	else if(ctx->opcode==7) {
		ctx->rpt = 1;
		ctx->selem = 1;
	}
	else if(ctx->opcode==8) {
		ctx->rpt = 1;
		ctx->selem = 2;
	}
	else if(ctx->opcode==10) {
		ctx->rpt = 2;
		ctx->selem = 1;
	}
	else {
		UNDEFINED;
	}
	if(((ctx->size<<1)|ctx->Q)==6 && ctx->selem!=1) {
		UNDEFINED;
	}
	return rc;
}

/* st2_advsimd_sngl.xml */
int ST2_advsimd_sngl(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011010|L=0|R=1|00000|opcode=xx0|S=x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFF2000)==0xD200000) {
		decode_fields32(ENC_ST2_ASISDLSO_B2_2B, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->opcode==0) OK(ENC_ST2_ASISDLSO_B2_2B);
		if(ctx->opcode==2 && !(ctx->size&1)) OK(ENC_ST2_ASISDLSO_H2_2H);
		if(ctx->opcode==4 && ctx->size==0) OK(ENC_ST2_ASISDLSO_S2_2S);
		if(ctx->opcode==4 && ctx->S==0 && ctx->size==1) OK(ENC_ST2_ASISDLSO_D2_2D);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011011|L=0|R=1|Rm=xxxxx|opcode=xx0|S=x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE02000)==0xDA00000) {
		decode_fields32(ENC_ST2_ASISDLSOP_B2_I2B, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f && ctx->opcode==0) OK(ENC_ST2_ASISDLSOP_B2_I2B);
		if(ctx->Rm!=0x1f && ctx->opcode==0) OK(ENC_ST2_ASISDLSOP_BX2_R2B);
		if(ctx->Rm==0x1f && ctx->opcode==2 && !(ctx->size&1)) OK(ENC_ST2_ASISDLSOP_H2_I2H);
		if(ctx->Rm!=0x1f && ctx->opcode==2 && !(ctx->size&1)) OK(ENC_ST2_ASISDLSOP_HX2_R2H);
		if(ctx->Rm==0x1f && ctx->opcode==4 && ctx->size==0) OK(ENC_ST2_ASISDLSOP_S2_I2S);
		if(ctx->Rm!=0x1f && ctx->opcode==4 && ctx->size==0) OK(ENC_ST2_ASISDLSOP_SX2_R2S);
		if(ctx->Rm==0x1f && ctx->opcode==4 && ctx->S==0 && ctx->size==1) OK(ENC_ST2_ASISDLSOP_D2_I2D);
		if(ctx->Rm!=0x1f && ctx->opcode==4 && ctx->S==0 && ctx->size==1) OK(ENC_ST2_ASISDLSOP_DX2_R2D);
	}
	/* post-decode pcode */
	ctx->init_scale = UINT(SLICE(ctx->opcode,2,1));
	ctx->scale = ctx->init_scale;
	ctx->selem = UINT(((SLICE(ctx->opcode,0,0)<<1)|ctx->R))+1;
	ctx->replicate = FALSE;
	if(ctx->scale==3) {
		if(ctx->L==0 || ctx->S==1) {
			UNDEFINED;
		}
		ctx->scale = UINT(ctx->size);
		ctx->replicate = TRUE;
	}
	else if(ctx->scale==0) {
		ctx->index = UINT(((ctx->Q<<3)|(ctx->S<<2)|ctx->size));
	}
	else if(ctx->scale==1) {
		if(SLICE(ctx->size,0,0)==1) {
			UNDEFINED;
		}
		ctx->index = UINT(((ctx->Q<<2)|(ctx->S<<1)|SLICE(ctx->size,1,1)));
	}
	else if(ctx->scale==2) {
		if(SLICE(ctx->size,1,1)==1) {
			UNDEFINED;
		}
		if(SLICE(ctx->size,0,0)==0) {
			ctx->index = UINT(((ctx->Q<<1)|ctx->S));
		}
		else {
			if(ctx->S==1) {
				UNDEFINED;
			}
			ctx->index = UINT(ctx->Q);
			ctx->scale = 3;
		}
	}
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (ctx->scale);
	return rc;
}

/* st3_advsimd_mult.xml */
int ST3_advsimd_mult(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011000|L=0|000000|opcode=0100|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFFF000)==0xC004000) {
		decode_fields32(ENC_ST3_ASISDLSE_R3, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		OK(ENC_ST3_ASISDLSE_R3);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011001|L=0|0|Rm=xxxxx|opcode=0100|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE0F000)==0xC804000) {
		decode_fields32(ENC_ST3_ASISDLSEP_I3_I, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f) OK(ENC_ST3_ASISDLSEP_I3_I);
		if(ctx->Rm!=0x1f) OK(ENC_ST3_ASISDLSEP_R3_R);
	}
	/* post-decode pcode */
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (UINT(ctx->size));
	ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
	if(!ctx->opcode) {
		ctx->rpt = 1;
		ctx->selem = 4;
	}
	else if(ctx->opcode==2) {
		ctx->rpt = 4;
		ctx->selem = 1;
	}
	else if(ctx->opcode==4) {
		ctx->rpt = 1;
		ctx->selem = 3;
	}
	else if(ctx->opcode==6) {
		ctx->rpt = 3;
		ctx->selem = 1;
	}
	else if(ctx->opcode==7) {
		ctx->rpt = 1;
		ctx->selem = 1;
	}
	else if(ctx->opcode==8) {
		ctx->rpt = 1;
		ctx->selem = 2;
	}
	else if(ctx->opcode==10) {
		ctx->rpt = 2;
		ctx->selem = 1;
	}
	else {
		UNDEFINED;
	}
	if(((ctx->size<<1)|ctx->Q)==6 && ctx->selem!=1) {
		UNDEFINED;
	}
	return rc;
}

/* st3_advsimd_sngl.xml */
int ST3_advsimd_sngl(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011010|L=0|R=0|00000|opcode=xx1|S=x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFF2000)==0xD002000) {
		decode_fields32(ENC_ST3_ASISDLSO_B3_3B, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->opcode==1) OK(ENC_ST3_ASISDLSO_B3_3B);
		if(ctx->opcode==3 && !(ctx->size&1)) OK(ENC_ST3_ASISDLSO_H3_3H);
		if(ctx->opcode==5 && ctx->size==0) OK(ENC_ST3_ASISDLSO_S3_3S);
		if(ctx->opcode==5 && ctx->S==0 && ctx->size==1) OK(ENC_ST3_ASISDLSO_D3_3D);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011011|L=0|R=0|Rm=xxxxx|opcode=xx1|S=x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE02000)==0xD802000) {
		decode_fields32(ENC_ST3_ASISDLSOP_B3_I3B, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f && ctx->opcode==1) OK(ENC_ST3_ASISDLSOP_B3_I3B);
		if(ctx->Rm!=0x1f && ctx->opcode==1) OK(ENC_ST3_ASISDLSOP_BX3_R3B);
		if(ctx->Rm==0x1f && ctx->opcode==3 && !(ctx->size&1)) OK(ENC_ST3_ASISDLSOP_H3_I3H);
		if(ctx->Rm!=0x1f && ctx->opcode==3 && !(ctx->size&1)) OK(ENC_ST3_ASISDLSOP_HX3_R3H);
		if(ctx->Rm==0x1f && ctx->opcode==5 && ctx->size==0) OK(ENC_ST3_ASISDLSOP_S3_I3S);
		if(ctx->Rm!=0x1f && ctx->opcode==5 && ctx->size==0) OK(ENC_ST3_ASISDLSOP_SX3_R3S);
		if(ctx->Rm==0x1f && ctx->opcode==5 && ctx->S==0 && ctx->size==1) OK(ENC_ST3_ASISDLSOP_D3_I3D);
		if(ctx->Rm!=0x1f && ctx->opcode==5 && ctx->S==0 && ctx->size==1) OK(ENC_ST3_ASISDLSOP_DX3_R3D);
	}
	/* post-decode pcode */
	ctx->init_scale = UINT(SLICE(ctx->opcode,2,1));
	ctx->scale = ctx->init_scale;
	ctx->selem = UINT(((SLICE(ctx->opcode,0,0)<<1)|ctx->R))+1;
	ctx->replicate = FALSE;
	if(ctx->scale==3) {
		if(ctx->L==0 || ctx->S==1) {
			UNDEFINED;
		}
		ctx->scale = UINT(ctx->size);
		ctx->replicate = TRUE;
	}
	else if(ctx->scale==0) {
		ctx->index = UINT(((ctx->Q<<3)|(ctx->S<<2)|ctx->size));
	}
	else if(ctx->scale==1) {
		if(SLICE(ctx->size,0,0)==1) {
			UNDEFINED;
		}
		ctx->index = UINT(((ctx->Q<<2)|(ctx->S<<1)|SLICE(ctx->size,1,1)));
	}
	else if(ctx->scale==2) {
		if(SLICE(ctx->size,1,1)==1) {
			UNDEFINED;
		}
		if(SLICE(ctx->size,0,0)==0) {
			ctx->index = UINT(((ctx->Q<<1)|ctx->S));
		}
		else {
			if(ctx->S==1) {
				UNDEFINED;
			}
			ctx->index = UINT(ctx->Q);
			ctx->scale = 3;
		}
	}
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (ctx->scale);
	return rc;
}

/* st4_advsimd_mult.xml */
int ST4_advsimd_mult(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011000|L=0|000000|opcode=0000|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFFF000)==0xC000000) {
		decode_fields32(ENC_ST4_ASISDLSE_R4, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		OK(ENC_ST4_ASISDLSE_R4);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011001|L=0|0|Rm=xxxxx|opcode=0000|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE0F000)==0xC800000) {
		decode_fields32(ENC_ST4_ASISDLSEP_I4_I, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f) OK(ENC_ST4_ASISDLSEP_I4_I);
		if(ctx->Rm!=0x1f) OK(ENC_ST4_ASISDLSEP_R4_R);
	}
	/* post-decode pcode */
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (UINT(ctx->size));
	ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
	if(!ctx->opcode) {
		ctx->rpt = 1;
		ctx->selem = 4;
	}
	else if(ctx->opcode==2) {
		ctx->rpt = 4;
		ctx->selem = 1;
	}
	else if(ctx->opcode==4) {
		ctx->rpt = 1;
		ctx->selem = 3;
	}
	else if(ctx->opcode==6) {
		ctx->rpt = 3;
		ctx->selem = 1;
	}
	else if(ctx->opcode==7) {
		ctx->rpt = 1;
		ctx->selem = 1;
	}
	else if(ctx->opcode==8) {
		ctx->rpt = 1;
		ctx->selem = 2;
	}
	else if(ctx->opcode==10) {
		ctx->rpt = 2;
		ctx->selem = 1;
	}
	else {
		UNDEFINED;
	}
	if(((ctx->size<<1)|ctx->Q)==6 && ctx->selem!=1) {
		UNDEFINED;
	}
	return rc;
}

/* st4_advsimd_sngl.xml */
int ST4_advsimd_sngl(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_as_no_post_index */
	/* 0|Q=x|0011010|L=0|R=1|00000|opcode=xx1|S=x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFFF2000)==0xD202000) {
		decode_fields32(ENC_ST4_ASISDLSO_B4_4B, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = 0;
		ctx->wback = FALSE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->opcode==1) OK(ENC_ST4_ASISDLSO_B4_4B);
		if(ctx->opcode==3 && !(ctx->size&1)) OK(ENC_ST4_ASISDLSO_H4_4H);
		if(ctx->opcode==5 && ctx->size==0) OK(ENC_ST4_ASISDLSO_S4_4S);
		if(ctx->opcode==5 && ctx->S==0 && ctx->size==1) OK(ENC_ST4_ASISDLSO_D4_4D);
	}
	/* class iclass_as_post_index */
	/* 0|Q=x|0011011|L=0|R=1|Rm=xxxxx|opcode=xx1|S=x|size=xx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE02000)==0xDA02000) {
		decode_fields32(ENC_ST4_ASISDLSOP_B4_I4B, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->wback = TRUE;
		ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
		if(ctx->Rm==0x1f && ctx->opcode==1) OK(ENC_ST4_ASISDLSOP_B4_I4B);
		if(ctx->Rm!=0x1f && ctx->opcode==1) OK(ENC_ST4_ASISDLSOP_BX4_R4B);
		if(ctx->Rm==0x1f && ctx->opcode==3 && !(ctx->size&1)) OK(ENC_ST4_ASISDLSOP_H4_I4H);
		if(ctx->Rm!=0x1f && ctx->opcode==3 && !(ctx->size&1)) OK(ENC_ST4_ASISDLSOP_HX4_R4H);
		if(ctx->Rm==0x1f && ctx->opcode==5 && ctx->size==0) OK(ENC_ST4_ASISDLSOP_S4_I4S);
		if(ctx->Rm!=0x1f && ctx->opcode==5 && ctx->size==0) OK(ENC_ST4_ASISDLSOP_SX4_R4S);
		if(ctx->Rm==0x1f && ctx->opcode==5 && ctx->S==0 && ctx->size==1) OK(ENC_ST4_ASISDLSOP_D4_I4D);
		if(ctx->Rm!=0x1f && ctx->opcode==5 && ctx->S==0 && ctx->size==1) OK(ENC_ST4_ASISDLSOP_DX4_R4D);
	}
	/* post-decode pcode */
	ctx->init_scale = UINT(SLICE(ctx->opcode,2,1));
	ctx->scale = ctx->init_scale;
	ctx->selem = UINT(((SLICE(ctx->opcode,0,0)<<1)|ctx->R))+1;
	ctx->replicate = FALSE;
	if(ctx->scale==3) {
		if(ctx->L==0 || ctx->S==1) {
			UNDEFINED;
		}
		ctx->scale = UINT(ctx->size);
		ctx->replicate = TRUE;
	}
	else if(ctx->scale==0) {
		ctx->index = UINT(((ctx->Q<<3)|(ctx->S<<2)|ctx->size));
	}
	else if(ctx->scale==1) {
		if(SLICE(ctx->size,0,0)==1) {
			UNDEFINED;
		}
		ctx->index = UINT(((ctx->Q<<2)|(ctx->S<<1)|SLICE(ctx->size,1,1)));
	}
	else if(ctx->scale==2) {
		if(SLICE(ctx->size,1,1)==1) {
			UNDEFINED;
		}
		if(SLICE(ctx->size,0,0)==0) {
			ctx->index = UINT(((ctx->Q<<1)|ctx->S));
		}
		else {
			if(ctx->S==1) {
				UNDEFINED;
			}
			ctx->index = UINT(ctx->Q);
			ctx->scale = 3;
		}
	}
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
	ctx->esize = (8) << (ctx->scale);
	return rc;
}

/* st64b.xml */
int ST64B(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=11|111|V=0|00|A=0|R=0|1|Rs=11111|o3=1|opc=001|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0xF83F9000) {
		decode_fields32(ENC_ST64B_64L_MEMOP, ctx, instr);
		if(!HaveFeatLS64()) {
			UNDEFINED;
		}
		if(SLICE(ctx->Rt,4,3)==3 || SLICE(ctx->Rt,0,0)==1) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->tag_checked = ctx->n!=0x1f;
		OK(ENC_ST64B_64L_MEMOP);
	}
	return rc;
}

/* st64bv.xml */
int ST64BV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=11|111|V=0|00|A=0|R=0|1|Rs=xxxxx|o3=1|opc=011|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0xF820B000) {
		decode_fields32(ENC_ST64BV_64_MEMOP, ctx, instr);
		if(!HaveFeatLS64()) {
			UNDEFINED;
		}
		if(SLICE(ctx->Rt,4,3)==3 || SLICE(ctx->Rt,0,0)==1) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->s = UINT(ctx->Rs);
		ctx->tag_checked = ctx->n!=0x1f;
		OK(ENC_ST64BV_64_MEMOP);
	}
	return rc;
}

/* st64bv0.xml */
int ST64BV0(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=11|111|V=0|00|A=0|R=0|1|Rs=xxxxx|o3=1|opc=010|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0xF820A000) {
		decode_fields32(ENC_ST64BV0_64_MEMOP, ctx, instr);
		if(!HaveFeatLS64()) {
			UNDEFINED;
		}
		if(SLICE(ctx->Rt,4,3)==3 || SLICE(ctx->Rt,0,0)==1) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->s = UINT(ctx->Rs);
		ctx->tag_checked = ctx->n!=0x1f;
		OK(ENC_ST64BV0_64_MEMOP);
	}
	return rc;
}

/* staddb_ldaddb.xml */
int STADDB_LDADDB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=000|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xFFA0FC1F)==0x3820001F) {
		decode_fields32(ENC_STADDB_LDADDB_32_MEMOP, ctx, instr);
		if(ctx->R==0) OK(ENC_STADDB_LDADDB_32_MEMOP);
		if(ctx->R==1) OK(ENC_STADDLB_LDADDLB_32_MEMOP);
	}
	return rc;
}

/* staddh_ldaddh.xml */
int STADDH_LDADDH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=000|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xFFA0FC1F)==0x7820001F) {
		decode_fields32(ENC_STADDH_LDADDH_32_MEMOP, ctx, instr);
		if(ctx->R==0) OK(ENC_STADDH_LDADDH_32_MEMOP);
		if(ctx->R==1) OK(ENC_STADDLH_LDADDLH_32_MEMOP);
	}
	return rc;
}

/* stadd_ldadd.xml */
int STADD_LDADD(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=000|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xBFA0FC1F)==0xB820001F) {
		decode_fields32(ENC_STADD_LDADD_32_MEMOP, ctx, instr);
		if(ctx->size==2 && ctx->R==0) OK(ENC_STADD_LDADD_32_MEMOP);
		if(ctx->size==2 && ctx->R==1) OK(ENC_STADDL_LDADDL_32_MEMOP);
		if(ctx->size==3 && ctx->R==0) OK(ENC_STADD_LDADD_64_MEMOP);
		if(ctx->size==3 && ctx->R==1) OK(ENC_STADDL_LDADDL_64_MEMOP);
	}
	return rc;
}

/* stclrb_ldclrb.xml */
int STCLRB_LDCLRB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=001|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xFFA0FC1F)==0x3820101F) {
		decode_fields32(ENC_STCLRB_LDCLRB_32_MEMOP, ctx, instr);
		if(ctx->R==0) OK(ENC_STCLRB_LDCLRB_32_MEMOP);
		if(ctx->R==1) OK(ENC_STCLRLB_LDCLRLB_32_MEMOP);
	}
	return rc;
}

/* stclrh_ldclrh.xml */
int STCLRH_LDCLRH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=001|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xFFA0FC1F)==0x7820101F) {
		decode_fields32(ENC_STCLRH_LDCLRH_32_MEMOP, ctx, instr);
		if(ctx->R==0) OK(ENC_STCLRH_LDCLRH_32_MEMOP);
		if(ctx->R==1) OK(ENC_STCLRLH_LDCLRLH_32_MEMOP);
	}
	return rc;
}

/* stclr_ldclr.xml */
int STCLR_LDCLR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=001|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xBFA0FC1F)==0xB820101F) {
		decode_fields32(ENC_STCLR_LDCLR_32_MEMOP, ctx, instr);
		if(ctx->size==2 && ctx->R==0) OK(ENC_STCLR_LDCLR_32_MEMOP);
		if(ctx->size==2 && ctx->R==1) OK(ENC_STCLRL_LDCLRL_32_MEMOP);
		if(ctx->size==3 && ctx->R==0) OK(ENC_STCLR_LDCLR_64_MEMOP);
		if(ctx->size==3 && ctx->R==1) OK(ENC_STCLRL_LDCLRL_64_MEMOP);
	}
	return rc;
}

/* steorb_ldeorb.xml */
int STEORB_LDEORB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=010|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xFFA0FC1F)==0x3820201F) {
		decode_fields32(ENC_STEORB_LDEORB_32_MEMOP, ctx, instr);
		if(ctx->R==0) OK(ENC_STEORB_LDEORB_32_MEMOP);
		if(ctx->R==1) OK(ENC_STEORLB_LDEORLB_32_MEMOP);
	}
	return rc;
}

/* steorh_ldeorh.xml */
int STEORH_LDEORH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=010|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xFFA0FC1F)==0x7820201F) {
		decode_fields32(ENC_STEORH_LDEORH_32_MEMOP, ctx, instr);
		if(ctx->R==0) OK(ENC_STEORH_LDEORH_32_MEMOP);
		if(ctx->R==1) OK(ENC_STEORLH_LDEORLH_32_MEMOP);
	}
	return rc;
}

/* steor_ldeor.xml */
int STEOR_LDEOR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=010|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xBFA0FC1F)==0xB820201F) {
		decode_fields32(ENC_STEOR_LDEOR_32_MEMOP, ctx, instr);
		if(ctx->size==2 && ctx->R==0) OK(ENC_STEOR_LDEOR_32_MEMOP);
		if(ctx->size==2 && ctx->R==1) OK(ENC_STEORL_LDEORL_32_MEMOP);
		if(ctx->size==3 && ctx->R==0) OK(ENC_STEOR_LDEOR_64_MEMOP);
		if(ctx->size==3 && ctx->R==1) OK(ENC_STEORL_LDEORL_64_MEMOP);
	}
	return rc;
}

/* stg.xml */
int STG(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* 11011001|opc=00|1|imm9=xxxxxxxxx|op2=01|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xD9200400) {
		decode_fields32(ENC_STG_64SPOST_LDSTTAGS, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Xn);
		ctx->t = UINT(ctx->Xt);
		ctx->offset = LSL(SignExtend(ctx->imm9,9),LOG2_TAG_GRANULE);
		ctx->writeback = TRUE;
		ctx->postindex = TRUE;
		ctx->zero_data = FALSE;
		OK(ENC_STG_64SPOST_LDSTTAGS);
	}
	/* class iclass_pre_indexed */
	/* 11011001|opc=00|1|imm9=xxxxxxxxx|op2=11|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xD9200C00) {
		decode_fields32(ENC_STG_64SPRE_LDSTTAGS, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Xn);
		ctx->t = UINT(ctx->Xt);
		ctx->offset = LSL(SignExtend(ctx->imm9,9),LOG2_TAG_GRANULE);
		ctx->writeback = TRUE;
		ctx->postindex = FALSE;
		ctx->zero_data = FALSE;
		OK(ENC_STG_64SPRE_LDSTTAGS);
	}
	/* class iclass_signed_scaled_offset */
	/* 11011001|opc=00|1|imm9=xxxxxxxxx|op2=10|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xD9200800) {
		decode_fields32(ENC_STG_64SOFFSET_LDSTTAGS, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Xn);
		ctx->t = UINT(ctx->Xt);
		ctx->offset = LSL(SignExtend(ctx->imm9,9),LOG2_TAG_GRANULE);
		ctx->writeback = FALSE;
		ctx->postindex = FALSE;
		ctx->zero_data = FALSE;
		OK(ENC_STG_64SOFFSET_LDSTTAGS);
	}
	return rc;
}

/* stgm.xml */
int STGM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* 11011001|opc=10|1|imm9=000000000|op2=00|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0xD9A00000) {
		decode_fields32(ENC_STGM_64BULK_LDSTTAGS, ctx, instr);
		if(!HaveMTE2Ext()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Xt);
		ctx->n = UINT(ctx->Xn);
		OK(ENC_STGM_64BULK_LDSTTAGS);
	}
	return rc;
}

/* stgp.xml */
int STGP(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* opc=01|101|V=0|001|L=0|simm7=xxxxxxx|Xt2=xxxxx|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFC00000)==0x68800000) {
		decode_fields32(ENC_STGP_64_LDSTPAIR_POST, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Xn);
		ctx->t = UINT(ctx->Xt);
		ctx->t2 = UINT(ctx->Xt2);
		ctx->offset = LSL(SignExtend(ctx->simm7,7),LOG2_TAG_GRANULE);
		ctx->writeback = TRUE;
		ctx->postindex = TRUE;
		OK(ENC_STGP_64_LDSTPAIR_POST);
	}
	/* class iclass_pre_indexed */
	/* opc=01|101|V=0|011|L=0|simm7=xxxxxxx|Xt2=xxxxx|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFC00000)==0x69800000) {
		decode_fields32(ENC_STGP_64_LDSTPAIR_PRE, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Xn);
		ctx->t = UINT(ctx->Xt);
		ctx->t2 = UINT(ctx->Xt2);
		ctx->offset = LSL(SignExtend(ctx->simm7,7),LOG2_TAG_GRANULE);
		ctx->writeback = TRUE;
		ctx->postindex = FALSE;
		OK(ENC_STGP_64_LDSTPAIR_PRE);
	}
	/* class iclass_signed_scaled_offset */
	/* opc=01|101|V=0|010|L=0|simm7=xxxxxxx|Xt2=xxxxx|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFC00000)==0x69000000) {
		decode_fields32(ENC_STGP_64_LDSTPAIR_OFF, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Xn);
		ctx->t = UINT(ctx->Xt);
		ctx->t2 = UINT(ctx->Xt2);
		ctx->offset = LSL(SignExtend(ctx->simm7,7),LOG2_TAG_GRANULE);
		ctx->writeback = FALSE;
		ctx->postindex = FALSE;
		OK(ENC_STGP_64_LDSTPAIR_OFF);
	}
	return rc;
}

/* stllr.xml */
int STLLR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=1x|001000|o2=1|L=0|o1=0|Rs=(1)(1)(1)(1)(1)|o0=0|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE08000)==0x88800000) {
		decode_fields32(ENC_STLLR_SL32_LDSTORD, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==0) ? AccType_LIMITEDORDERED : AccType_ORDERED;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		if(ctx->size==2) OK(ENC_STLLR_SL32_LDSTORD);
		if(ctx->size==3) OK(ENC_STLLR_SL64_LDSTORD);
	}
	return rc;
}

/* stllrb.xml */
int STLLRB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=00|001000|o2=1|L=0|o1=0|Rs=(1)(1)(1)(1)(1)|o0=0|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE08000)==0x8800000) {
		decode_fields32(ENC_STLLRB_SL32_LDSTORD, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==0) ? AccType_LIMITEDORDERED : AccType_ORDERED;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		OK(ENC_STLLRB_SL32_LDSTORD);
	}
	return rc;
}

/* stllrh.xml */
int STLLRH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=01|001000|o2=1|L=0|o1=0|Rs=(1)(1)(1)(1)(1)|o0=0|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE08000)==0x48800000) {
		decode_fields32(ENC_STLLRH_SL32_LDSTORD, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==0) ? AccType_LIMITEDORDERED : AccType_ORDERED;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		OK(ENC_STLLRH_SL32_LDSTORD);
	}
	return rc;
}

/* stlr.xml */
int STLR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=1x|001000|o2=1|L=0|o1=0|Rs=(1)(1)(1)(1)(1)|o0=1|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE08000)==0x88808000) {
		decode_fields32(ENC_STLR_SL32_LDSTORD, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==0) ? AccType_LIMITEDORDERED : AccType_ORDERED;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		if(ctx->size==2) OK(ENC_STLR_SL32_LDSTORD);
		if(ctx->size==3) OK(ENC_STLR_SL64_LDSTORD);
	}
	return rc;
}

/* stlrb.xml */
int STLRB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=00|001000|o2=1|L=0|o1=0|Rs=(1)(1)(1)(1)(1)|o0=1|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE08000)==0x8808000) {
		decode_fields32(ENC_STLRB_SL32_LDSTORD, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==0) ? AccType_LIMITEDORDERED : AccType_ORDERED;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		OK(ENC_STLRB_SL32_LDSTORD);
	}
	return rc;
}

/* stlrh.xml */
int STLRH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=01|001000|o2=1|L=0|o1=0|Rs=(1)(1)(1)(1)(1)|o0=1|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE08000)==0x48808000) {
		decode_fields32(ENC_STLRH_SL32_LDSTORD, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==0) ? AccType_LIMITEDORDERED : AccType_ORDERED;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		OK(ENC_STLRH_SL32_LDSTORD);
	}
	return rc;
}

/* stlurb.xml */
int STLURB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=00|011001|opc=00|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x19000000) {
		decode_fields32(ENC_STLURB_32_LDAPSTL_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_STLURB_32_LDAPSTL_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = AccType_ORDERED;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* stlurh.xml */
int STLURH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=01|011001|opc=00|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x59000000) {
		decode_fields32(ENC_STLURH_32_LDAPSTL_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_STLURH_32_LDAPSTL_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = AccType_ORDERED;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* stlur_gen.xml */
int STLUR_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=1x|011001|opc=00|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE00C00)==0x99000000) {
		decode_fields32(ENC_STLUR_32_LDAPSTL_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->size==2) OK(ENC_STLUR_32_LDAPSTL_UNSCALED);
		if(ctx->size==3) OK(ENC_STLUR_64_LDAPSTL_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = AccType_ORDERED;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* stlxp.xml */
int STLXP(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* 1|sz=x|001000|o2=0|L=0|o1=1|Rs=xxxxx|o0=1|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE08000)==0x88208000) {
		decode_fields32(ENC_STLXP_SP32_LDSTEXCLP, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==1) ? AccType_ORDEREDATOMIC : AccType_ATOMIC;
		ctx->pair = TRUE;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (0x20) << (UINT(ctx->sz));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = (ctx->pair) ? (ctx->elsize) * (2) : ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		ctx->rt_unknown = FALSE;
		ctx->rn_unknown = FALSE;
		if(ctx->memop==MemOp_LOAD && ctx->pair && ctx->t==ctx->t2) {
			ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
			// assert
			// switch on constraint
		}
		if(ctx->memop==MemOp_STORE) {
			if(ctx->s==ctx->t || (ctx->pair && ctx->s==ctx->t2)) {
				ctx->c = ConstrainUnpredictable(Unpredictable_DATAOVERLAP);
				// assert
				// switch on constraint
			}
			if(ctx->s==ctx->n && ctx->n!=0x1f) {
				ctx->c = ConstrainUnpredictable(Unpredictable_BASEOVERLAP);
				// assert
				// switch on constraint
			}
		}
		if(ctx->sz==0) OK(ENC_STLXP_SP32_LDSTEXCLP);
		if(ctx->sz==1) OK(ENC_STLXP_SP64_LDSTEXCLP);
	}
	return rc;
}

/* stlxr.xml */
int STLXR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=1x|001000|o2=0|L=0|o1=0|Rs=xxxxx|o0=1|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE08000)==0x88008000) {
		decode_fields32(ENC_STLXR_SR32_LDSTEXCLR, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==1) ? AccType_ORDEREDATOMIC : AccType_ATOMIC;
		ctx->pair = FALSE;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = (ctx->pair) ? (ctx->elsize) * (2) : ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		ctx->rt_unknown = FALSE;
		ctx->rn_unknown = FALSE;
		if(ctx->memop==MemOp_LOAD && ctx->pair && ctx->t==ctx->t2) {
			ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
			// assert
			// switch on constraint
		}
		if(ctx->memop==MemOp_STORE) {
			if(ctx->s==ctx->t || (ctx->pair && ctx->s==ctx->t2)) {
				ctx->c = ConstrainUnpredictable(Unpredictable_DATAOVERLAP);
				// assert
				// switch on constraint
			}
			if(ctx->s==ctx->n && ctx->n!=0x1f) {
				ctx->c = ConstrainUnpredictable(Unpredictable_BASEOVERLAP);
				// assert
				// switch on constraint
			}
		}
		if(ctx->size==2) OK(ENC_STLXR_SR32_LDSTEXCLR);
		if(ctx->size==3) OK(ENC_STLXR_SR64_LDSTEXCLR);
	}
	return rc;
}

/* stlxrb.xml */
int STLXRB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=00|001000|o2=0|L=0|o1=0|Rs=xxxxx|o0=1|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE08000)==0x8008000) {
		decode_fields32(ENC_STLXRB_SR32_LDSTEXCLR, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==1) ? AccType_ORDEREDATOMIC : AccType_ATOMIC;
		ctx->pair = FALSE;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = (ctx->pair) ? (ctx->elsize) * (2) : ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		ctx->rt_unknown = FALSE;
		ctx->rn_unknown = FALSE;
		if(ctx->memop==MemOp_LOAD && ctx->pair && ctx->t==ctx->t2) {
			ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
			// assert
			// switch on constraint
		}
		if(ctx->memop==MemOp_STORE) {
			if(ctx->s==ctx->t || (ctx->pair && ctx->s==ctx->t2)) {
				ctx->c = ConstrainUnpredictable(Unpredictable_DATAOVERLAP);
				// assert
				// switch on constraint
			}
			if(ctx->s==ctx->n && ctx->n!=0x1f) {
				ctx->c = ConstrainUnpredictable(Unpredictable_BASEOVERLAP);
				// assert
				// switch on constraint
			}
		}
		OK(ENC_STLXRB_SR32_LDSTEXCLR);
	}
	return rc;
}

/* stlxrh.xml */
int STLXRH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=01|001000|o2=0|L=0|o1=0|Rs=xxxxx|o0=1|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE08000)==0x48008000) {
		decode_fields32(ENC_STLXRH_SR32_LDSTEXCLR, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==1) ? AccType_ORDEREDATOMIC : AccType_ATOMIC;
		ctx->pair = FALSE;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = (ctx->pair) ? (ctx->elsize) * (2) : ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		ctx->rt_unknown = FALSE;
		ctx->rn_unknown = FALSE;
		if(ctx->memop==MemOp_LOAD && ctx->pair && ctx->t==ctx->t2) {
			ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
			// assert
			// switch on constraint
		}
		if(ctx->memop==MemOp_STORE) {
			if(ctx->s==ctx->t || (ctx->pair && ctx->s==ctx->t2)) {
				ctx->c = ConstrainUnpredictable(Unpredictable_DATAOVERLAP);
				// assert
				// switch on constraint
			}
			if(ctx->s==ctx->n && ctx->n!=0x1f) {
				ctx->c = ConstrainUnpredictable(Unpredictable_BASEOVERLAP);
				// assert
				// switch on constraint
			}
		}
		OK(ENC_STLXRH_SR32_LDSTEXCLR);
	}
	return rc;
}

/* stnp_fpsimd.xml */
int STNP_fpsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_signed_scaled_offset */
	/* opc=xx|101|V=1|000|L=0|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3FC00000)==0x2C000000) {
		decode_fields32(ENC_STNP_S_LDSTNAPAIR_OFFS, ctx, instr);
		if(ctx->opc==0) OK(ENC_STNP_S_LDSTNAPAIR_OFFS);
		if(ctx->opc==1) OK(ENC_STNP_D_LDSTNAPAIR_OFFS);
		if(ctx->opc==2) OK(ENC_STNP_Q_LDSTNAPAIR_OFFS);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->t2 = UINT(ctx->Rt2);
	ctx->acctype = ctx->AccType_VECSTREAM;
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	if(ctx->opc==3) {
		UNDEFINED;
	}
	ctx->scale = 2+UINT(ctx->opc);
	ctx->datasize = (8) << (ctx->scale);
	ctx->offset = LSL(SignExtend(ctx->imm7,7),ctx->scale);
	ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->t==ctx->t2) {
		ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
		// assert
		// switch on constraint
	}
	return rc;
}

/* stnp_gen.xml */
int STNP_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_signed_scaled_offset */
	/* opc=x0|101|V=0|000|L=0|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x7FC00000)==0x28000000) {
		decode_fields32(ENC_STNP_32_LDSTNAPAIR_OFFS, ctx, instr);
		if(ctx->opc==0) OK(ENC_STNP_32_LDSTNAPAIR_OFFS);
		if(ctx->opc==2) OK(ENC_STNP_64_LDSTNAPAIR_OFFS);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->t2 = UINT(ctx->Rt2);
	ctx->acctype = ctx->AccType_STREAM;
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	if(SLICE(ctx->opc,0,0)==1) {
		UNDEFINED;
	}
	ctx->scale = 2+UINT(SLICE(ctx->opc,1,1));
	ctx->datasize = (8) << (ctx->scale);
	ctx->offset = LSL(SignExtend(ctx->imm7,7),ctx->scale);
	ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->t==ctx->t2) {
		ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
		// assert
		// switch on constraint
	}
	return rc;
}

/* stp_fpsimd.xml */
int STP_fpsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* opc=xx|101|V=1|001|L=0|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3FC00000)==0x2C800000) {
		decode_fields32(ENC_STP_S_LDSTPAIR_POST, ctx, instr);
		if(ctx->opc==0) OK(ENC_STP_S_LDSTPAIR_POST);
		if(ctx->opc==1) OK(ENC_STP_D_LDSTPAIR_POST);
		if(ctx->opc==2) OK(ENC_STP_Q_LDSTPAIR_POST);
	}
	/* class iclass_pre_indexed */
	/* opc=xx|101|V=1|011|L=0|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3FC00000)==0x2D800000) {
		decode_fields32(ENC_STP_S_LDSTPAIR_PRE, ctx, instr);
		if(ctx->opc==0) OK(ENC_STP_S_LDSTPAIR_PRE);
		if(ctx->opc==1) OK(ENC_STP_D_LDSTPAIR_PRE);
		if(ctx->opc==2) OK(ENC_STP_Q_LDSTPAIR_PRE);
	}
	/* class iclass_signed_scaled_offset */
	/* opc=xx|101|V=1|010|L=0|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3FC00000)==0x2D000000) {
		decode_fields32(ENC_STP_S_LDSTPAIR_OFF, ctx, instr);
		if(ctx->opc==0) OK(ENC_STP_S_LDSTPAIR_OFF);
		if(ctx->opc==1) OK(ENC_STP_D_LDSTPAIR_OFF);
		if(ctx->opc==2) OK(ENC_STP_Q_LDSTPAIR_OFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->t2 = UINT(ctx->Rt2);
	ctx->acctype = ctx->AccType_VEC;
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	if(ctx->opc==3) {
		UNDEFINED;
	}
	ctx->scale = 2+UINT(ctx->opc);
	ctx->datasize = (8) << (ctx->scale);
	ctx->offset = LSL(SignExtend(ctx->imm7,7),ctx->scale);
	ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->t==ctx->t2) {
		ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
		// assert
		// switch on constraint
	}
	return rc;
}

/* stp_gen.xml */
int STP_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* opc=x0|101|V=0|001|L=0|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x7FC00000)==0x28800000) {
		decode_fields32(ENC_STP_32_LDSTPAIR_POST, ctx, instr);
		if(ctx->opc==0) OK(ENC_STP_32_LDSTPAIR_POST);
		if(ctx->opc==2) OK(ENC_STP_64_LDSTPAIR_POST);
	}
	/* class iclass_pre_indexed */
	/* opc=x0|101|V=0|011|L=0|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x7FC00000)==0x29800000) {
		decode_fields32(ENC_STP_32_LDSTPAIR_PRE, ctx, instr);
		if(ctx->opc==0) OK(ENC_STP_32_LDSTPAIR_PRE);
		if(ctx->opc==2) OK(ENC_STP_64_LDSTPAIR_PRE);
	}
	/* class iclass_signed_scaled_offset */
	/* opc=x0|101|V=0|010|L=0|imm7=xxxxxxx|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x7FC00000)==0x29000000) {
		decode_fields32(ENC_STP_32_LDSTPAIR_OFF, ctx, instr);
		if(ctx->opc==0) OK(ENC_STP_32_LDSTPAIR_OFF);
		if(ctx->opc==2) OK(ENC_STP_64_LDSTPAIR_OFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->t2 = UINT(ctx->Rt2);
	ctx->acctype = ctx->AccType_NORMAL;
	ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
	if(((ctx->L<<1)|SLICE(ctx->opc,0,0))==1 || ctx->opc==3) {
		UNDEFINED;
	}
	ctx->signed_ = (SLICE(ctx->opc,0,0)!=0);
	ctx->scale = 2+UINT(SLICE(ctx->opc,1,1));
	ctx->datasize = (8) << (ctx->scale);
	ctx->offset = LSL(SignExtend(ctx->imm7,7),ctx->scale);
	ctx->tag_checked = ctx->wback || ctx->n!=0x1f;
	ctx->rt_unknown = FALSE;
	ctx->wb_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && (ctx->t==ctx->n || ctx->t2==ctx->n) && ctx->n!=0x1f) {
		ctx->c = ConstrainUnpredictable(Unpredictable_WBOVERLAPLD);
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && (ctx->t==ctx->n || ctx->t2==ctx->n) && ctx->n!=0x1f) {
		ctx->c = ConstrainUnpredictable(Unpredictable_WBOVERLAPST);
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_LOAD && ctx->t==ctx->t2) {
		ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
		// assert
		// switch on constraint
	}
	return rc;
}

/* strb_imm.xml */
int STRB_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* size=00|111|V=0|00|opc=00|0|imm9=xxxxxxxxx|01|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x38000400) {
		decode_fields32(ENC_STRB_32_LDST_IMMPOST, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = TRUE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_STRB_32_LDST_IMMPOST);
	}
	/* class iclass_pre_indexed */
	/* size=00|111|V=0|00|opc=00|0|imm9=xxxxxxxxx|11|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x38000C00) {
		decode_fields32(ENC_STRB_32_LDST_IMMPRE, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_STRB_32_LDST_IMMPRE);
	}
	/* class iclass_unsigned_scaled_offset */
	/* size=00|111|V=0|01|opc=00|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFC00000)==0x39000000) {
		decode_fields32(ENC_STRB_32_LDST_POS, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = LSL(ZeroExtend(ctx->imm12,0x40),ctx->scale);
		OK(ENC_STRB_32_LDST_POS);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* strb_reg.xml */
int STRB_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_32 */
	/* size=00|111|V=0|00|opc=00|1|Rm=xxxxx|option=xxx|S=x|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x38200800) {
		decode_fields32(ENC_STRB_32B_LDST_REGOFF, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		if(SLICE(ctx->option,1,1)==0) {
			UNDEFINED;
		}
		ctx->extend_type = DecodeRegExtend(ctx->option);
		ctx->shift = (ctx->S==1) ? ctx->scale : 0;
		if(ctx->option!=3) OK(ENC_STRB_32B_LDST_REGOFF);
		if(ctx->option==3) OK(ENC_STRB_32BL_LDST_REGOFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->m = UINT(ctx->Rm);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH;
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* strh_imm.xml */
int STRH_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* size=01|111|V=0|00|opc=00|0|imm9=xxxxxxxxx|01|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x78000400) {
		decode_fields32(ENC_STRH_32_LDST_IMMPOST, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = TRUE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_STRH_32_LDST_IMMPOST);
	}
	/* class iclass_pre_indexed */
	/* size=01|111|V=0|00|opc=00|0|imm9=xxxxxxxxx|11|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x78000C00) {
		decode_fields32(ENC_STRH_32_LDST_IMMPRE, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_STRH_32_LDST_IMMPRE);
	}
	/* class iclass_unsigned_scaled_offset */
	/* size=01|111|V=0|01|opc=00|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFC00000)==0x79000000) {
		decode_fields32(ENC_STRH_32_LDST_POS, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = LSL(ZeroExtend(ctx->imm12,0x40),ctx->scale);
		OK(ENC_STRH_32_LDST_POS);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* strh_reg.xml */
int STRH_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_32 */
	/* size=01|111|V=0|00|opc=00|1|Rm=xxxxx|option=xxx|S=x|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x78200800) {
		decode_fields32(ENC_STRH_32_LDST_REGOFF, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		if(SLICE(ctx->option,1,1)==0) {
			UNDEFINED;
		}
		ctx->extend_type = DecodeRegExtend(ctx->option);
		ctx->shift = (ctx->S==1) ? ctx->scale : 0;
		OK(ENC_STRH_32_LDST_REGOFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->m = UINT(ctx->Rm);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH;
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* str_imm_fpsimd.xml */
int STR_imm_fpsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* size=xx|111|V=1|00|opc=x0|0|imm9=xxxxxxxxx|01|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3F600C00)==0x3C000400) {
		decode_fields32(ENC_STR_B_LDST_IMMPOST, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = TRUE;
		ctx->scale = UINT(((SLICE(ctx->opc,1,1)<<2)|ctx->size));
		if(ctx->scale>4) {
			UNDEFINED;
		}
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->size==0 && ctx->opc==0) OK(ENC_STR_B_LDST_IMMPOST);
		if(ctx->size==1 && ctx->opc==0) OK(ENC_STR_H_LDST_IMMPOST);
		if(ctx->size==2 && ctx->opc==0) OK(ENC_STR_S_LDST_IMMPOST);
		if(ctx->size==3 && ctx->opc==0) OK(ENC_STR_D_LDST_IMMPOST);
		if(ctx->size==0 && ctx->opc==2) OK(ENC_STR_Q_LDST_IMMPOST);
	}
	/* class iclass_pre_indexed */
	/* size=xx|111|V=1|00|opc=x0|0|imm9=xxxxxxxxx|11|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3F600C00)==0x3C000C00) {
		decode_fields32(ENC_STR_B_LDST_IMMPRE, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(((SLICE(ctx->opc,1,1)<<2)|ctx->size));
		if(ctx->scale>4) {
			UNDEFINED;
		}
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->size==0 && ctx->opc==0) OK(ENC_STR_B_LDST_IMMPRE);
		if(ctx->size==1 && ctx->opc==0) OK(ENC_STR_H_LDST_IMMPRE);
		if(ctx->size==2 && ctx->opc==0) OK(ENC_STR_S_LDST_IMMPRE);
		if(ctx->size==3 && ctx->opc==0) OK(ENC_STR_D_LDST_IMMPRE);
		if(ctx->size==0 && ctx->opc==2) OK(ENC_STR_Q_LDST_IMMPRE);
	}
	/* class iclass_unsigned_scaled_offset */
	/* size=xx|111|V=1|01|opc=x0|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3F400000)==0x3D000000) {
		decode_fields32(ENC_STR_B_LDST_POS, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(((SLICE(ctx->opc,1,1)<<2)|ctx->size));
		if(ctx->scale>4) {
			UNDEFINED;
		}
		ctx->offset = LSL(ZeroExtend(ctx->imm12,0x40),ctx->scale);
		if(ctx->size==0 && ctx->opc==0) OK(ENC_STR_B_LDST_POS);
		if(ctx->size==1 && ctx->opc==0) OK(ENC_STR_H_LDST_POS);
		if(ctx->size==2 && ctx->opc==0) OK(ENC_STR_S_LDST_POS);
		if(ctx->size==3 && ctx->opc==0) OK(ENC_STR_D_LDST_POS);
		if(ctx->size==0 && ctx->opc==2) OK(ENC_STR_Q_LDST_POS);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_VEC;
	ctx->memop = (SLICE(ctx->opc,0,0)==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	return rc;
}

/* str_imm_gen.xml */
int STR_imm_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* size=1x|111|V=0|00|opc=00|0|imm9=xxxxxxxxx|01|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE00C00)==0xB8000400) {
		decode_fields32(ENC_STR_32_LDST_IMMPOST, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = TRUE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->size==2) OK(ENC_STR_32_LDST_IMMPOST);
		if(ctx->size==3) OK(ENC_STR_64_LDST_IMMPOST);
	}
	/* class iclass_pre_indexed */
	/* size=1x|111|V=0|00|opc=00|0|imm9=xxxxxxxxx|11|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE00C00)==0xB8000C00) {
		decode_fields32(ENC_STR_32_LDST_IMMPRE, ctx, instr);
		ctx->wback = TRUE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->size==2) OK(ENC_STR_32_LDST_IMMPRE);
		if(ctx->size==3) OK(ENC_STR_64_LDST_IMMPRE);
	}
	/* class iclass_unsigned_scaled_offset */
	/* size=1x|111|V=0|01|opc=00|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFC00000)==0xB9000000) {
		decode_fields32(ENC_STR_32_LDST_POS, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = LSL(ZeroExtend(ctx->imm12,0x40),ctx->scale);
		if(ctx->size==2) OK(ENC_STR_32_LDST_POS);
		if(ctx->size==3) OK(ENC_STR_64_LDST_POS);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* str_reg_fpsimd.xml */
int STR_reg_fpsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_fpsimd */
	/* size=xx|111|V=1|00|opc=x0|1|Rm=xxxxx|option=xxx|S=x|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3F600C00)==0x3C200800) {
		decode_fields32(ENC_STR_B_LDST_REGOFF, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(((SLICE(ctx->opc,1,1)<<2)|ctx->size));
		if(ctx->scale>4) {
			UNDEFINED;
		}
		if(SLICE(ctx->option,1,1)==0) {
			UNDEFINED;
		}
		ctx->extend_type = DecodeRegExtend(ctx->option);
		ctx->shift = (ctx->S==1) ? ctx->scale : 0;
		if(ctx->size==0 && ctx->opc==0 && ctx->option!=3) OK(ENC_STR_B_LDST_REGOFF);
		if(ctx->size==0 && ctx->opc==0 && ctx->option==3) OK(ENC_STR_BL_LDST_REGOFF);
		if(ctx->size==1 && ctx->opc==0) OK(ENC_STR_H_LDST_REGOFF);
		if(ctx->size==2 && ctx->opc==0) OK(ENC_STR_S_LDST_REGOFF);
		if(ctx->size==3 && ctx->opc==0) OK(ENC_STR_D_LDST_REGOFF);
		if(ctx->size==0 && ctx->opc==2) OK(ENC_STR_Q_LDST_REGOFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->m = UINT(ctx->Rm);
	ctx->acctype = ctx->AccType_VEC;
	ctx->memop = (SLICE(ctx->opc,0,0)==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH;
	return rc;
}

/* str_reg_gen.xml */
int STR_reg_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|opc=00|1|Rm=xxxxx|option=xxx|S=x|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE00C00)==0xB8200800) {
		decode_fields32(ENC_STR_32_LDST_REGOFF, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		if(SLICE(ctx->option,1,1)==0) {
			UNDEFINED;
		}
		ctx->extend_type = DecodeRegExtend(ctx->option);
		ctx->shift = (ctx->S==1) ? ctx->scale : 0;
		if(ctx->size==2) OK(ENC_STR_32_LDST_REGOFF);
		if(ctx->size==3) OK(ENC_STR_64_LDST_REGOFF);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->m = UINT(ctx->Rm);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH;
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* stsetb_ldsetb.xml */
int STSETB_LDSETB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=011|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xFFA0FC1F)==0x3820301F) {
		decode_fields32(ENC_STSETB_LDSETB_32_MEMOP, ctx, instr);
		if(ctx->R==0) OK(ENC_STSETB_LDSETB_32_MEMOP);
		if(ctx->R==1) OK(ENC_STSETLB_LDSETLB_32_MEMOP);
	}
	return rc;
}

/* stseth_ldseth.xml */
int STSETH_LDSETH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=011|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xFFA0FC1F)==0x7820301F) {
		decode_fields32(ENC_STSETH_LDSETH_32_MEMOP, ctx, instr);
		if(ctx->R==0) OK(ENC_STSETH_LDSETH_32_MEMOP);
		if(ctx->R==1) OK(ENC_STSETLH_LDSETLH_32_MEMOP);
	}
	return rc;
}

/* stset_ldset.xml */
int STSET_LDSET(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=011|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xBFA0FC1F)==0xB820301F) {
		decode_fields32(ENC_STSET_LDSET_32_MEMOP, ctx, instr);
		if(ctx->size==2 && ctx->R==0) OK(ENC_STSET_LDSET_32_MEMOP);
		if(ctx->size==2 && ctx->R==1) OK(ENC_STSETL_LDSETL_32_MEMOP);
		if(ctx->size==3 && ctx->R==0) OK(ENC_STSET_LDSET_64_MEMOP);
		if(ctx->size==3 && ctx->R==1) OK(ENC_STSETL_LDSETL_64_MEMOP);
	}
	return rc;
}

/* stsmaxb_ldsmaxb.xml */
int STSMAXB_LDSMAXB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=100|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xFFA0FC1F)==0x3820401F) {
		decode_fields32(ENC_STSMAXB_LDSMAXB_32_MEMOP, ctx, instr);
		if(ctx->R==0) OK(ENC_STSMAXB_LDSMAXB_32_MEMOP);
		if(ctx->R==1) OK(ENC_STSMAXLB_LDSMAXLB_32_MEMOP);
	}
	return rc;
}

/* stsmaxh_ldsmaxh.xml */
int STSMAXH_LDSMAXH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=100|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xFFA0FC1F)==0x7820401F) {
		decode_fields32(ENC_STSMAXH_LDSMAXH_32_MEMOP, ctx, instr);
		if(ctx->R==0) OK(ENC_STSMAXH_LDSMAXH_32_MEMOP);
		if(ctx->R==1) OK(ENC_STSMAXLH_LDSMAXLH_32_MEMOP);
	}
	return rc;
}

/* stsmax_ldsmax.xml */
int STSMAX_LDSMAX(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=100|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xBFA0FC1F)==0xB820401F) {
		decode_fields32(ENC_STSMAX_LDSMAX_32_MEMOP, ctx, instr);
		if(ctx->size==2 && ctx->R==0) OK(ENC_STSMAX_LDSMAX_32_MEMOP);
		if(ctx->size==2 && ctx->R==1) OK(ENC_STSMAXL_LDSMAXL_32_MEMOP);
		if(ctx->size==3 && ctx->R==0) OK(ENC_STSMAX_LDSMAX_64_MEMOP);
		if(ctx->size==3 && ctx->R==1) OK(ENC_STSMAXL_LDSMAXL_64_MEMOP);
	}
	return rc;
}

/* stsminb_ldsminb.xml */
int STSMINB_LDSMINB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=101|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xFFA0FC1F)==0x3820501F) {
		decode_fields32(ENC_STSMINB_LDSMINB_32_MEMOP, ctx, instr);
		if(ctx->R==0) OK(ENC_STSMINB_LDSMINB_32_MEMOP);
		if(ctx->R==1) OK(ENC_STSMINLB_LDSMINLB_32_MEMOP);
	}
	return rc;
}

/* stsminh_ldsminh.xml */
int STSMINH_LDSMINH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=101|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xFFA0FC1F)==0x7820501F) {
		decode_fields32(ENC_STSMINH_LDSMINH_32_MEMOP, ctx, instr);
		if(ctx->R==0) OK(ENC_STSMINH_LDSMINH_32_MEMOP);
		if(ctx->R==1) OK(ENC_STSMINLH_LDSMINLH_32_MEMOP);
	}
	return rc;
}

/* stsmin_ldsmin.xml */
int STSMIN_LDSMIN(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=101|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xBFA0FC1F)==0xB820501F) {
		decode_fields32(ENC_STSMIN_LDSMIN_32_MEMOP, ctx, instr);
		if(ctx->size==2 && ctx->R==0) OK(ENC_STSMIN_LDSMIN_32_MEMOP);
		if(ctx->size==2 && ctx->R==1) OK(ENC_STSMINL_LDSMINL_32_MEMOP);
		if(ctx->size==3 && ctx->R==0) OK(ENC_STSMIN_LDSMIN_64_MEMOP);
		if(ctx->size==3 && ctx->R==1) OK(ENC_STSMINL_LDSMINL_64_MEMOP);
	}
	return rc;
}

/* sttr.xml */
int STTR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=1x|111|V=0|00|opc=00|0|imm9=xxxxxxxxx|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE00C00)==0xB8000800) {
		decode_fields32(ENC_STTR_32_LDST_UNPRIV, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->size==2) OK(ENC_STTR_32_LDST_UNPRIV);
		if(ctx->size==3) OK(ENC_STTR_64_LDST_UNPRIV);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->unpriv_at_el1 = ctx->pstate_el==EL1 && !(EL2Enabled() && HaveNVExt() && CONCAT(ctx->HCR_EL2_NV,ctx->HCR_EL2_NV1,1)==3);
	ctx->unpriv_at_el2 = ctx->pstate_el==EL2 && HaveVirtHostExt() && CONCAT(ctx->HCR_EL2_E2H,ctx->HCR_EL2_TGE,1)==3;
	ctx->user_access_override = HaveUAOExt() && ctx->pstate_uao==1;
	if(!ctx->user_access_override && (ctx->unpriv_at_el1 || ctx->unpriv_at_el2)) {
		ctx->acctype = ctx->AccType_UNPRIV;
	}
	else {
		ctx->acctype = ctx->AccType_NORMAL;
	}
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* sttrb.xml */
int STTRB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=00|111|V=0|00|opc=00|0|imm9=xxxxxxxxx|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x38000800) {
		decode_fields32(ENC_STTRB_32_LDST_UNPRIV, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_STTRB_32_LDST_UNPRIV);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->unpriv_at_el1 = ctx->pstate_el==EL1 && !(EL2Enabled() && HaveNVExt() && CONCAT(ctx->HCR_EL2_NV,ctx->HCR_EL2_NV1,1)==3);
	ctx->unpriv_at_el2 = ctx->pstate_el==EL2 && HaveVirtHostExt() && CONCAT(ctx->HCR_EL2_E2H,ctx->HCR_EL2_TGE,1)==3;
	ctx->user_access_override = HaveUAOExt() && ctx->pstate_uao==1;
	if(!ctx->user_access_override && (ctx->unpriv_at_el1 || ctx->unpriv_at_el2)) {
		ctx->acctype = ctx->AccType_UNPRIV;
	}
	else {
		ctx->acctype = ctx->AccType_NORMAL;
	}
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* sttrh.xml */
int STTRH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=01|111|V=0|00|opc=00|0|imm9=xxxxxxxxx|10|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x78000800) {
		decode_fields32(ENC_STTRH_32_LDST_UNPRIV, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_STTRH_32_LDST_UNPRIV);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->unpriv_at_el1 = ctx->pstate_el==EL1 && !(EL2Enabled() && HaveNVExt() && CONCAT(ctx->HCR_EL2_NV,ctx->HCR_EL2_NV1,1)==3);
	ctx->unpriv_at_el2 = ctx->pstate_el==EL2 && HaveVirtHostExt() && CONCAT(ctx->HCR_EL2_E2H,ctx->HCR_EL2_TGE,1)==3;
	ctx->user_access_override = HaveUAOExt() && ctx->pstate_uao==1;
	if(!ctx->user_access_override && (ctx->unpriv_at_el1 || ctx->unpriv_at_el2)) {
		ctx->acctype = ctx->AccType_UNPRIV;
	}
	else {
		ctx->acctype = ctx->AccType_NORMAL;
	}
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			UNDEFINED;
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* stumaxb_ldumaxb.xml */
int STUMAXB_LDUMAXB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=110|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xFFA0FC1F)==0x3820601F) {
		decode_fields32(ENC_STUMAXB_LDUMAXB_32_MEMOP, ctx, instr);
		if(ctx->R==0) OK(ENC_STUMAXB_LDUMAXB_32_MEMOP);
		if(ctx->R==1) OK(ENC_STUMAXLB_LDUMAXLB_32_MEMOP);
	}
	return rc;
}

/* stumaxh_ldumaxh.xml */
int STUMAXH_LDUMAXH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=110|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xFFA0FC1F)==0x7820601F) {
		decode_fields32(ENC_STUMAXH_LDUMAXH_32_MEMOP, ctx, instr);
		if(ctx->R==0) OK(ENC_STUMAXH_LDUMAXH_32_MEMOP);
		if(ctx->R==1) OK(ENC_STUMAXLH_LDUMAXLH_32_MEMOP);
	}
	return rc;
}

/* stumax_ldumax.xml */
int STUMAX_LDUMAX(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=110|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xBFA0FC1F)==0xB820601F) {
		decode_fields32(ENC_STUMAX_LDUMAX_32_MEMOP, ctx, instr);
		if(ctx->size==2 && ctx->R==0) OK(ENC_STUMAX_LDUMAX_32_MEMOP);
		if(ctx->size==2 && ctx->R==1) OK(ENC_STUMAXL_LDUMAXL_32_MEMOP);
		if(ctx->size==3 && ctx->R==0) OK(ENC_STUMAX_LDUMAX_64_MEMOP);
		if(ctx->size==3 && ctx->R==1) OK(ENC_STUMAXL_LDUMAXL_64_MEMOP);
	}
	return rc;
}

/* stuminb_lduminb.xml */
int STUMINB_LDUMINB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=111|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xFFA0FC1F)==0x3820701F) {
		decode_fields32(ENC_STUMINB_LDUMINB_32_MEMOP, ctx, instr);
		if(ctx->R==0) OK(ENC_STUMINB_LDUMINB_32_MEMOP);
		if(ctx->R==1) OK(ENC_STUMINLB_LDUMINLB_32_MEMOP);
	}
	return rc;
}

/* stuminh_lduminh.xml */
int STUMINH_LDUMINH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=111|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xFFA0FC1F)==0x7820701F) {
		decode_fields32(ENC_STUMINH_LDUMINH_32_MEMOP, ctx, instr);
		if(ctx->R==0) OK(ENC_STUMINH_LDUMINH_32_MEMOP);
		if(ctx->R==1) OK(ENC_STUMINLH_LDUMINLH_32_MEMOP);
	}
	return rc;
}

/* stumin_ldumin.xml */
int STUMIN_LDUMIN(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=0|R=x|1|Rs=xxxxx|o3=0|opc=111|00|Rn=xxxxx|Rt=11111 */
	if((INSWORD & 0xBFA0FC1F)==0xB820701F) {
		decode_fields32(ENC_STUMIN_LDUMIN_32_MEMOP, ctx, instr);
		if(ctx->size==2 && ctx->R==0) OK(ENC_STUMIN_LDUMIN_32_MEMOP);
		if(ctx->size==2 && ctx->R==1) OK(ENC_STUMINL_LDUMINL_32_MEMOP);
		if(ctx->size==3 && ctx->R==0) OK(ENC_STUMIN_LDUMIN_64_MEMOP);
		if(ctx->size==3 && ctx->R==1) OK(ENC_STUMINL_LDUMINL_64_MEMOP);
	}
	return rc;
}

/* sturb.xml */
int STURB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=00|111|V=0|00|opc=00|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x38000000) {
		decode_fields32(ENC_STURB_32_LDST_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_STURB_32_LDST_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* sturh.xml */
int STURH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=01|111|V=0|00|opc=00|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0x78000000) {
		decode_fields32(ENC_STURH_32_LDST_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		OK(ENC_STURH_32_LDST_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* stur_fpsimd.xml */
int STUR_fpsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=xx|111|V=1|00|opc=x0|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0x3F600C00)==0x3C000000) {
		decode_fields32(ENC_STUR_B_LDST_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(((SLICE(ctx->opc,1,1)<<2)|ctx->size));
		if(ctx->scale>4) {
			UNDEFINED;
		}
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->size==0 && ctx->opc==0) OK(ENC_STUR_B_LDST_UNSCALED);
		if(ctx->size==1 && ctx->opc==0) OK(ENC_STUR_H_LDST_UNSCALED);
		if(ctx->size==2 && ctx->opc==0) OK(ENC_STUR_S_LDST_UNSCALED);
		if(ctx->size==3 && ctx->opc==0) OK(ENC_STUR_D_LDST_UNSCALED);
		if(ctx->size==0 && ctx->opc==2) OK(ENC_STUR_Q_LDST_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_VEC;
	ctx->memop = (SLICE(ctx->opc,0,0)==1) ? MemOp_LOAD : MemOp_STORE;
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	return rc;
}

/* stur_gen.xml */
int STUR_gen(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_plus_offset */
	/* size=1x|111|V=0|00|opc=00|0|imm9=xxxxxxxxx|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE00C00)==0xB8000000) {
		decode_fields32(ENC_STUR_32_LDST_UNSCALED, ctx, instr);
		ctx->wback = FALSE;
		ctx->postindex = FALSE;
		ctx->scale = UINT(ctx->size);
		ctx->offset = SignExtend(ctx->imm9,9);
		if(ctx->size==2) OK(ENC_STUR_32_LDST_UNSCALED);
		if(ctx->size==3) OK(ENC_STUR_64_LDST_UNSCALED);
	}
	/* post-decode pcode */
	ctx->n = UINT(ctx->Rn);
	ctx->t = UINT(ctx->Rt);
	ctx->acctype = ctx->AccType_NORMAL;
	if(SLICE(ctx->opc,1,1)==0) {
		if(SLICE(ctx->opc,0,0)==1) {
			ctx->memop = MemOp_LOAD;
		};
		if(ctx->size==3) {
			ctx->regsize = 0x40;
		};
		ctx->signed_ = FALSE;
	}
	else {
		if(ctx->size==3) {
			ctx->memop = MemOp_PREFETCH;
			if(SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
		}
		else {
			ctx->memop = MemOp_LOAD;
			if(ctx->size==2 && SLICE(ctx->opc,0,0)==1) {
				UNDEFINED;
			}
			if(SLICE(ctx->opc,0,0)==1) {
				ctx->regsize = 0x20;
			};
			ctx->signed_ = TRUE;
		}
	}
	ctx->datasize = (8) << (ctx->scale);
	ctx->tag_checked = ctx->memop!=MemOp_PREFETCH && (ctx->wback || ctx->n!=0x1f);
	ctx->wb_unknown = FALSE;
	ctx->rt_unknown = FALSE;
	if(ctx->memop==MemOp_LOAD && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	if(ctx->memop==MemOp_STORE && ctx->wback && ctx->n==ctx->t && ctx->n!=0x1f) {
		// assignment from ConstrainUnpredictable()
		// assert
		// switch on constraint
	}
	return rc;
}

/* stxp.xml */
int STXP(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* 1|sz=x|001000|o2=0|L=0|o1=1|Rs=xxxxx|o0=0|Rt2=xxxxx|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE08000)==0x88200000) {
		decode_fields32(ENC_STXP_SP32_LDSTEXCLP, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==1) ? AccType_ORDEREDATOMIC : AccType_ATOMIC;
		ctx->pair = TRUE;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (0x20) << (UINT(ctx->sz));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = (ctx->pair) ? (ctx->elsize) * (2) : ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		ctx->rt_unknown = FALSE;
		ctx->rn_unknown = FALSE;
		if(ctx->memop==MemOp_LOAD && ctx->pair && ctx->t==ctx->t2) {
			ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
			// assert
			// switch on constraint
		}
		if(ctx->memop==MemOp_STORE) {
			if(ctx->s==ctx->t || (ctx->pair && ctx->s==ctx->t2)) {
				ctx->c = ConstrainUnpredictable(Unpredictable_DATAOVERLAP);
				// assert
				// switch on constraint
			}
			if(ctx->s==ctx->n && ctx->n!=0x1f) {
				ctx->c = ConstrainUnpredictable(Unpredictable_BASEOVERLAP);
				// assert
				// switch on constraint
			}
		}
		if(ctx->sz==0) OK(ENC_STXP_SP32_LDSTEXCLP);
		if(ctx->sz==1) OK(ENC_STXP_SP64_LDSTEXCLP);
	}
	return rc;
}

/* stxr.xml */
int STXR(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=1x|001000|o2=0|L=0|o1=0|Rs=xxxxx|o0=0|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBFE08000)==0x88000000) {
		decode_fields32(ENC_STXR_SR32_LDSTEXCLR, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==1) ? AccType_ORDEREDATOMIC : AccType_ATOMIC;
		ctx->pair = FALSE;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = (ctx->pair) ? (ctx->elsize) * (2) : ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		ctx->rt_unknown = FALSE;
		ctx->rn_unknown = FALSE;
		if(ctx->memop==MemOp_LOAD && ctx->pair && ctx->t==ctx->t2) {
			ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
			// assert
			// switch on constraint
		}
		if(ctx->memop==MemOp_STORE) {
			if(ctx->s==ctx->t || (ctx->pair && ctx->s==ctx->t2)) {
				ctx->c = ConstrainUnpredictable(Unpredictable_DATAOVERLAP);
				// assert
				// switch on constraint
			}
			if(ctx->s==ctx->n && ctx->n!=0x1f) {
				ctx->c = ConstrainUnpredictable(Unpredictable_BASEOVERLAP);
				// assert
				// switch on constraint
			}
		}
		if(ctx->size==2) OK(ENC_STXR_SR32_LDSTEXCLR);
		if(ctx->size==3) OK(ENC_STXR_SR64_LDSTEXCLR);
	}
	return rc;
}

/* stxrb.xml */
int STXRB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=00|001000|o2=0|L=0|o1=0|Rs=xxxxx|o0=0|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE08000)==0x8000000) {
		decode_fields32(ENC_STXRB_SR32_LDSTEXCLR, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==1) ? AccType_ORDEREDATOMIC : AccType_ATOMIC;
		ctx->pair = FALSE;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = (ctx->pair) ? (ctx->elsize) * (2) : ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		ctx->rt_unknown = FALSE;
		ctx->rn_unknown = FALSE;
		if(ctx->memop==MemOp_LOAD && ctx->pair && ctx->t==ctx->t2) {
			ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
			// assert
			// switch on constraint
		}
		if(ctx->memop==MemOp_STORE) {
			if(ctx->s==ctx->t || (ctx->pair && ctx->s==ctx->t2)) {
				ctx->c = ConstrainUnpredictable(Unpredictable_DATAOVERLAP);
				// assert
				// switch on constraint
			}
			if(ctx->s==ctx->n && ctx->n!=0x1f) {
				ctx->c = ConstrainUnpredictable(Unpredictable_BASEOVERLAP);
				// assert
				// switch on constraint
			}
		}
		OK(ENC_STXRB_SR32_LDSTEXCLR);
	}
	return rc;
}

/* stxrh.xml */
int STXRH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_base_register */
	/* size=01|001000|o2=0|L=0|o1=0|Rs=xxxxx|o0=0|Rt2=(1)(1)(1)(1)(1)|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFFE08000)==0x48000000) {
		decode_fields32(ENC_STXRH_SR32_LDSTEXCLR, ctx, instr);
		ctx->n = UINT(ctx->Rn);
		ctx->t = UINT(ctx->Rt);
		ctx->t2 = UINT(ctx->Rt2);
		ctx->s = UINT(ctx->Rs);
		ctx->acctype = (ctx->o0==1) ? AccType_ORDEREDATOMIC : AccType_ATOMIC;
		ctx->pair = FALSE;
		ctx->memop = (ctx->L==1) ? MemOp_LOAD : MemOp_STORE;
		ctx->elsize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->elsize==0x40) ? 0x40 : 0x20;
		ctx->datasize = (ctx->pair) ? (ctx->elsize) * (2) : ctx->elsize;
		ctx->tag_checked = ctx->n!=0x1f;
		ctx->rt_unknown = FALSE;
		ctx->rn_unknown = FALSE;
		if(ctx->memop==MemOp_LOAD && ctx->pair && ctx->t==ctx->t2) {
			ctx->c = ConstrainUnpredictable(Unpredictable_LDPOVERLAP);
			// assert
			// switch on constraint
		}
		if(ctx->memop==MemOp_STORE) {
			if(ctx->s==ctx->t || (ctx->pair && ctx->s==ctx->t2)) {
				ctx->c = ConstrainUnpredictable(Unpredictable_DATAOVERLAP);
				// assert
				// switch on constraint
			}
			if(ctx->s==ctx->n && ctx->n!=0x1f) {
				ctx->c = ConstrainUnpredictable(Unpredictable_BASEOVERLAP);
				// assert
				// switch on constraint
			}
		}
		OK(ENC_STXRH_SR32_LDSTEXCLR);
	}
	return rc;
}

/* stz2g.xml */
int STZ2G(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* 11011001|opc=11|1|imm9=xxxxxxxxx|op2=01|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xD9E00400) {
		decode_fields32(ENC_STZ2G_64SPOST_LDSTTAGS, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Xn);
		ctx->t = UINT(ctx->Xt);
		ctx->offset = LSL(SignExtend(ctx->imm9,9),LOG2_TAG_GRANULE);
		ctx->writeback = TRUE;
		ctx->postindex = TRUE;
		ctx->zero_data = TRUE;
		OK(ENC_STZ2G_64SPOST_LDSTTAGS);
	}
	/* class iclass_pre_indexed */
	/* 11011001|opc=11|1|imm9=xxxxxxxxx|op2=11|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xD9E00C00) {
		decode_fields32(ENC_STZ2G_64SPRE_LDSTTAGS, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Xn);
		ctx->t = UINT(ctx->Xt);
		ctx->offset = LSL(SignExtend(ctx->imm9,9),LOG2_TAG_GRANULE);
		ctx->writeback = TRUE;
		ctx->postindex = FALSE;
		ctx->zero_data = TRUE;
		OK(ENC_STZ2G_64SPRE_LDSTTAGS);
	}
	/* class iclass_signed_scaled_offset */
	/* 11011001|opc=11|1|imm9=xxxxxxxxx|op2=10|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xD9E00800) {
		decode_fields32(ENC_STZ2G_64SOFFSET_LDSTTAGS, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Xn);
		ctx->t = UINT(ctx->Xt);
		ctx->offset = LSL(SignExtend(ctx->imm9,9),LOG2_TAG_GRANULE);
		ctx->writeback = FALSE;
		ctx->postindex = FALSE;
		ctx->zero_data = TRUE;
		OK(ENC_STZ2G_64SOFFSET_LDSTTAGS);
	}
	return rc;
}

/* stzg.xml */
int STZG(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_post_indexed */
	/* 11011001|opc=01|1|imm9=xxxxxxxxx|op2=01|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xD9600400) {
		decode_fields32(ENC_STZG_64SPOST_LDSTTAGS, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Xn);
		ctx->t = UINT(ctx->Xt);
		ctx->offset = LSL(SignExtend(ctx->imm9,9),LOG2_TAG_GRANULE);
		ctx->writeback = TRUE;
		ctx->postindex = TRUE;
		ctx->zero_data = TRUE;
		OK(ENC_STZG_64SPOST_LDSTTAGS);
	}
	/* class iclass_pre_indexed */
	/* 11011001|opc=01|1|imm9=xxxxxxxxx|op2=11|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xD9600C00) {
		decode_fields32(ENC_STZG_64SPRE_LDSTTAGS, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Xn);
		ctx->t = UINT(ctx->Xt);
		ctx->offset = LSL(SignExtend(ctx->imm9,9),LOG2_TAG_GRANULE);
		ctx->writeback = TRUE;
		ctx->postindex = FALSE;
		ctx->zero_data = TRUE;
		OK(ENC_STZG_64SPRE_LDSTTAGS);
	}
	/* class iclass_signed_scaled_offset */
	/* 11011001|opc=01|1|imm9=xxxxxxxxx|op2=10|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFE00C00)==0xD9600800) {
		decode_fields32(ENC_STZG_64SOFFSET_LDSTTAGS, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Xn);
		ctx->t = UINT(ctx->Xt);
		ctx->offset = LSL(SignExtend(ctx->imm9,9),LOG2_TAG_GRANULE);
		ctx->writeback = FALSE;
		ctx->postindex = FALSE;
		ctx->zero_data = TRUE;
		OK(ENC_STZG_64SOFFSET_LDSTTAGS);
	}
	return rc;
}

/* stzgm.xml */
int STZGM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* 11011001|opc=00|1|imm9=000000000|op2=00|Xn=xxxxx|Xt=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0xD9200000) {
		decode_fields32(ENC_STZGM_64BULK_LDSTTAGS, ctx, instr);
		if(!HaveMTE2Ext()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Xt);
		ctx->n = UINT(ctx->Xn);
		OK(ENC_STZGM_64BULK_LDSTTAGS);
	}
	return rc;
}

/* subg.xml */
int SUBG(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|op=1|S=0|100011|o2=0|uimm6=xxxxxx|op3=(0)(0)|uimm4=xxxx|Xn=xxxxx|Xd=xxxxx */
	if((INSWORD & 0xFFC00000)==0xD1800000) {
		decode_fields32(ENC_SUBG_64_ADDSUB_IMMTAGS, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Xd);
		ctx->n = UINT(ctx->Xn);
		ctx->tag_offset = ctx->uimm4;
		ctx->offset = LSL(ZeroExtend(ctx->uimm6,0x40),LOG2_TAG_GRANULE);
		ctx->ADD = FALSE;
		OK(ENC_SUBG_64_ADDSUB_IMMTAGS);
	}
	return rc;
}

/* subhn_advsimd.xml */
int SUBHN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=0|01110|size=xx|1|Rm=xxxxx|01|o1=1|0|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE206000) {
		decode_fields32(ENC_SUBHN_ASIMDDIFF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		ctx->round = (ctx->U==1);
		OK(ENC_SUBHN_ASIMDDIFF_N);
	}
	return rc;
}

/* subp.xml */
int SUBP(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|0|S=0|11010110|Xm=xxxxx|opcode=000000|Xn=xxxxx|Xd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x9AC00000) {
		decode_fields32(ENC_SUBP_64S_DP_2SRC, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Xd);
		ctx->n = UINT(ctx->Xn);
		ctx->m = UINT(ctx->Xm);
		instr->setflags = FALSE;
		ctx->setflags = FALSE;
		OK(ENC_SUBP_64S_DP_2SRC);
	}
	return rc;
}

/* subps.xml */
int SUBPS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|0|S=1|11010110|Xm=xxxxx|opcode=000000|Xn=xxxxx|Xd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0xBAC00000) {
		decode_fields32(ENC_SUBPS_64S_DP_2SRC, ctx, instr);
		if(!HaveMTEExt()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Xd);
		ctx->n = UINT(ctx->Xn);
		ctx->m = UINT(ctx->Xm);
		instr->setflags = TRUE;
		ctx->setflags = TRUE;
		/* regular aliases */
		if(ctx->S==1 && ctx->Xd==0x1f) return CMPP_SUBPS(ctx, instr);
		OK(ENC_SUBPS_64S_DP_2SRC);
	}
	return rc;
}

/* subs_addsub_ext.xml */
int SUBS_addsub_ext(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|op=1|S=1|01011|opt=00|1|Rm=xxxxx|option=xxx|imm3=xxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE00000)==0x6B200000) {
		decode_fields32(ENC_SUBS_32S_ADDSUB_EXT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		instr->setflags = (ctx->S==1);
		ctx->setflags = (ctx->S==1);
		ctx->extend_type = DecodeRegExtend(ctx->option);
		ctx->shift = UINT(ctx->imm3);
		if(ctx->shift>4) {
			UNDEFINED;
		}
		/* regular aliases */
		if(ctx->Rd==0x1f) return CMP_SUBS_addsub_ext(ctx, instr);
		if(ctx->sf==0) OK(ENC_SUBS_32S_ADDSUB_EXT);
		if(ctx->sf==1) OK(ENC_SUBS_64S_ADDSUB_EXT);
	}
	return rc;
}

/* subs_addsub_imm.xml */
int SUBS_addsub_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|op=1|S=1|100010|sh=x|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x71000000) {
		decode_fields32(ENC_SUBS_32S_ADDSUB_IMM, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		instr->setflags = (ctx->S==1);
		ctx->setflags = (ctx->S==1);
		if(!ctx->sh) {
			ctx->imm = ZeroExtend(ctx->imm12,ctx->datasize);
		}
		else if(ctx->sh) {
			ctx->imm = ZeroExtend(((ctx->imm12<<12)|0),ctx->datasize);
		}
		/* regular aliases */
		if(ctx->Rd==0x1f) return CMP_SUBS_addsub_imm(ctx, instr);
		if(ctx->sf==0) OK(ENC_SUBS_32S_ADDSUB_IMM);
		if(ctx->sf==1) OK(ENC_SUBS_64S_ADDSUB_IMM);
	}
	return rc;
}

/* subs_addsub_shift.xml */
int SUBS_addsub_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|op=1|S=1|01011|shift=xx|0|Rm=xxxxx|imm6=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F200000)==0x6B000000) {
		decode_fields32(ENC_SUBS_32_ADDSUB_SHIFT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		instr->setflags = (ctx->S==1);
		ctx->setflags = (ctx->S==1);
		if(ctx->shift==3) {
			UNDEFINED;
		}
		if(ctx->sf==0 && SLICE(ctx->imm6,5,5)==1) {
			UNDEFINED;
		}
		ctx->shift_type = DecodeShift(ctx->shift);
		ctx->shift_amount = UINT(ctx->imm6);
		/* regular aliases */
		if(ctx->Rd==0x1f) return CMP_SUBS_addsub_shift(ctx, instr);
		if(ctx->Rn==0x1f && ctx->Rd!=0x1f) return NEGS_SUBS_addsub_shift(ctx, instr);
		if(ctx->sf==0) OK(ENC_SUBS_32_ADDSUB_SHIFT);
		if(ctx->sf==1) OK(ENC_SUBS_64_ADDSUB_SHIFT);
	}
	return rc;
}

/* sub_addsub_ext.xml */
int SUB_addsub_ext(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|op=1|S=0|01011|opt=00|1|Rm=xxxxx|option=xxx|imm3=xxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE00000)==0x4B200000) {
		decode_fields32(ENC_SUB_32_ADDSUB_EXT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		instr->setflags = (ctx->S==1);
		ctx->setflags = (ctx->S==1);
		ctx->extend_type = DecodeRegExtend(ctx->option);
		ctx->shift = UINT(ctx->imm3);
		if(ctx->shift>4) {
			UNDEFINED;
		}
		if(ctx->sf==0) OK(ENC_SUB_32_ADDSUB_EXT);
		if(ctx->sf==1) OK(ENC_SUB_64_ADDSUB_EXT);
	}
	return rc;
}

/* sub_addsub_imm.xml */
int SUB_addsub_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|op=1|S=0|100010|sh=x|imm12=xxxxxxxxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x51000000) {
		decode_fields32(ENC_SUB_32_ADDSUB_IMM, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		instr->setflags = (ctx->S==1);
		ctx->setflags = (ctx->S==1);
		if(!ctx->sh) {
			ctx->imm = ZeroExtend(ctx->imm12,ctx->datasize);
		}
		else if(ctx->sh) {
			ctx->imm = ZeroExtend(((ctx->imm12<<12)|0),ctx->datasize);
		}
		if(ctx->sf==0) OK(ENC_SUB_32_ADDSUB_IMM);
		if(ctx->sf==1) OK(ENC_SUB_64_ADDSUB_IMM);
	}
	return rc;
}

/* sub_addsub_shift.xml */
int SUB_addsub_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* sf=x|op=1|S=0|01011|shift=xx|0|Rm=xxxxx|imm6=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F200000)==0x4B000000) {
		decode_fields32(ENC_SUB_32_ADDSUB_SHIFT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->sub_op = (ctx->op==1);
		instr->setflags = (ctx->S==1);
		ctx->setflags = (ctx->S==1);
		if(ctx->shift==3) {
			UNDEFINED;
		}
		if(ctx->sf==0 && SLICE(ctx->imm6,5,5)==1) {
			UNDEFINED;
		}
		ctx->shift_type = DecodeShift(ctx->shift);
		ctx->shift_amount = UINT(ctx->imm6);
		/* regular aliases */
		if(ctx->Rn==0x1f) return NEG_SUB_addsub_shift(ctx, instr);
		if(ctx->sf==0) OK(ENC_SUB_32_ADDSUB_SHIFT);
		if(ctx->sf==1) OK(ENC_SUB_64_ADDSUB_SHIFT);
	}
	return rc;
}

/* sub_advsimd.xml */
int SUB_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|1|Rm=xxxxx|opcode=10000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x7E208400) {
		decode_fields32(ENC_SUB_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size!=3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->sub_op = (ctx->U==1);
		OK(ENC_SUB_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|opcode=10000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E208400) {
		decode_fields32(ENC_SUB_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->U==1);
		OK(ENC_SUB_ASIMDSAME_ONLY);
	}
	return rc;
}

/* sudot_advsimd_elt.xml */
int SUDOT_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_element */
	/* 0|Q=x|U=0|01111|US=0|0|L=x|M=x|Rm=xxxx|opcode=1111|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFC0F400)==0xF00F000) {
		decode_fields32(ENC_SUDOT_ASIMDELEM_D, ctx, instr);
		if(!HaveInt8MatMulExt()) {
			UNDEFINED;
		}
		ctx->op1_unsigned = (ctx->US==1);
		ctx->op2_unsigned = (ctx->US==0);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->M<<4)|ctx->Rm));
		ctx->d = UINT(ctx->Rd);
		ctx->i = UINT(((ctx->H<<1)|ctx->L));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((0x20) ? ((ctx->datasize) / (0x20)) : 0);
		OK(ENC_SUDOT_ASIMDELEM_D);
	}
	return rc;
}

/* suqadd_advsimd.xml */
int SUQADD_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=0|11110|size=xx|10000|opcode=00011|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x5E203800) {
		decode_fields32(ENC_SUQADD_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SUQADD_ASISDMISC_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|10000|opcode=00011|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE203800) {
		decode_fields32(ENC_SUQADD_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_SUQADD_ASIMDMISC_R);
	}
	return rc;
}

/* svc.xml */
int SVC(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 11010100|opc=000|imm16=xxxxxxxxxxxxxxxx|op2=000|LL=01 */
	if((INSWORD & 0xFFE0001F)==0xD4000001) {
		decode_fields32(ENC_SVC_EX_EXCEPTION, ctx, instr);
		OK(ENC_SVC_EX_EXCEPTION);
	}
	return rc;
}

/* swp.xml */
int SWP(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=1x|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=1|opc=000|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xB8208000) {
		decode_fields32(ENC_SWP_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->tag_checked = ctx->n!=0x1f;
		if(ctx->size==2 && ctx->A==0 && ctx->R==0) OK(ENC_SWP_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==0) OK(ENC_SWPA_32_MEMOP);
		if(ctx->size==2 && ctx->A==1 && ctx->R==1) OK(ENC_SWPAL_32_MEMOP);
		if(ctx->size==2 && ctx->A==0 && ctx->R==1) OK(ENC_SWPL_32_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==0) OK(ENC_SWP_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==0) OK(ENC_SWPA_64_MEMOP);
		if(ctx->size==3 && ctx->A==1 && ctx->R==1) OK(ENC_SWPAL_64_MEMOP);
		if(ctx->size==3 && ctx->A==0 && ctx->R==1) OK(ENC_SWPL_64_MEMOP);
	}
	return rc;
}

/* swpb.xml */
int SWPB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=00|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=1|opc=000|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x38208000) {
		decode_fields32(ENC_SWPAB_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->tag_checked = ctx->n!=0x1f;
		if(ctx->A==1 && ctx->R==0) OK(ENC_SWPAB_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_SWPALB_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_SWPB_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_SWPLB_32_MEMOP);
	}
	return rc;
}

/* swph.xml */
int SWPH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* size=01|111|V=0|00|A=x|R=x|1|Rs=xxxxx|o3=1|opc=000|00|Rn=xxxxx|Rt=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x78208000) {
		decode_fields32(ENC_SWPAH_32_MEMOP, ctx, instr);
		if(!HaveAtomicExt()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		ctx->n = UINT(ctx->Rn);
		ctx->s = UINT(ctx->Rs);
		ctx->datasize = (8) << (UINT(ctx->size));
		ctx->regsize = (ctx->datasize==0x40) ? 0x40 : 0x20;
		ctx->ldacctype = (ctx->A==1 && ctx->Rt!=0x1f) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->stacctype = (ctx->R==1) ? AccType_ORDEREDATOMICRW : AccType_ATOMICRW;
		ctx->tag_checked = ctx->n!=0x1f;
		if(ctx->A==1 && ctx->R==0) OK(ENC_SWPAH_32_MEMOP);
		if(ctx->A==1 && ctx->R==1) OK(ENC_SWPALH_32_MEMOP);
		if(ctx->A==0 && ctx->R==0) OK(ENC_SWPH_32_MEMOP);
		if(ctx->A==0 && ctx->R==1) OK(ENC_SWPLH_32_MEMOP);
	}
	return rc;
}

/* sxtb_sbfm.xml */
int SXTB_SBFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_signed_fill */
	/* sf=x|opc=00|100110|N=x|immr=000000|imms=000111|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FBFFC00)==0x13001C00) {
		decode_fields32(ENC_SXTB_SBFM_32M_BITFIELD, ctx, instr);
		if(ctx->sf==0 && ctx->N==0) OK(ENC_SXTB_SBFM_32M_BITFIELD);
		if(ctx->sf==1 && ctx->N==1) OK(ENC_SXTB_SBFM_64M_BITFIELD);
	}
	return rc;
}

/* sxth_sbfm.xml */
int SXTH_SBFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_signed_fill */
	/* sf=x|opc=00|100110|N=x|immr=000000|imms=001111|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FBFFC00)==0x13003C00) {
		decode_fields32(ENC_SXTH_SBFM_32M_BITFIELD, ctx, instr);
		if(ctx->sf==0 && ctx->N==0) OK(ENC_SXTH_SBFM_32M_BITFIELD);
		if(ctx->sf==1 && ctx->N==1) OK(ENC_SXTH_SBFM_64M_BITFIELD);
	}
	return rc;
}

/* sxtl_sshll_advsimd.xml */
int SXTL_SSHLL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=0|011110|immh!=0000|immb=000|opcode=10100|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF87FC00)==0xF00A400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_SXTL_SSHLL_ASIMDSHF_L, ctx, instr);
		OK(ENC_SXTL_SSHLL_ASIMDSHF_L);
	}
	return rc;
}

/* sxtw_sbfm.xml */
int SXTW_SBFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_signed_fill */
	/* sf=1|opc=00|100110|N=1|immr=000000|imms=011111|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x93407C00) {
		decode_fields32(ENC_SXTW_SBFM_64M_BITFIELD, ctx, instr);
		OK(ENC_SXTW_SBFM_64M_BITFIELD);
	}
	return rc;
}

/* sys.xml */
int SYS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=01|op1=xxx|CRn=xxxx|CRm=xxxx|op2=xxx|Rt=xxxxx */
	if((INSWORD & 0xFFF80000)==0xD5080000) {
		decode_fields32(ENC_SYS_CR_SYSTEMINSTRS, ctx, instr);
		CheckSystemAccess(1,ctx->op1,ctx->CRn,ctx->CRm,ctx->op2,ctx->Rt,ctx->L);
		ctx->t = UINT(ctx->Rt);
		ctx->sys_op0 = 1;
		ctx->sys_op1 = UINT(ctx->op1);
		ctx->sys_op2 = UINT(ctx->op2);
		ctx->sys_crn = UINT(ctx->CRn);
		ctx->sys_crm = UINT(ctx->CRm);
		ctx->has_result = (ctx->L==1);
		/* regular aliases */
		if(ctx->CRn==7 && (ctx->CRm&14)==8 && SysOp(ctx->op1,7,ctx->CRm,ctx->op2)==Sys_AT) return AT_SYS(ctx, instr);
		if(ctx->op1==3 && ctx->CRn==7 && ctx->CRm==3 && ctx->op2==4) return CFP_SYS(ctx, instr);
		if(ctx->op1==3 && ctx->CRn==7 && ctx->CRm==3 && ctx->op2==7) return CPP_SYS(ctx, instr);
		if(ctx->CRn==7 && SysOp(ctx->op1,7,ctx->CRm,ctx->op2)==Sys_DC) return DC_SYS(ctx, instr);
		if(ctx->op1==3 && ctx->CRn==7 && ctx->CRm==3 && ctx->op2==5) return DVP_SYS(ctx, instr);
		if(ctx->CRn==7 && SysOp(ctx->op1,7,ctx->CRm,ctx->op2)==Sys_IC) return IC_SYS(ctx, instr);
		if(ctx->CRn==8 && SysOp(ctx->op1,8,ctx->CRm,ctx->op2)==Sys_TLBI) return TLBI_SYS(ctx, instr);
		OK(ENC_SYS_CR_SYSTEMINSTRS);
	}
	return rc;
}

/* sysl.xml */
int SYSL(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=1|op0=01|op1=xxx|CRn=xxxx|CRm=xxxx|op2=xxx|Rt=xxxxx */
	if((INSWORD & 0xFFF80000)==0xD5280000) {
		decode_fields32(ENC_SYSL_RC_SYSTEMINSTRS, ctx, instr);
		CheckSystemAccess(1,ctx->op1,ctx->CRn,ctx->CRm,ctx->op2,ctx->Rt,ctx->L);
		ctx->t = UINT(ctx->Rt);
		ctx->sys_op0 = 1;
		ctx->sys_op1 = UINT(ctx->op1);
		ctx->sys_op2 = UINT(ctx->op2);
		ctx->sys_crn = UINT(ctx->CRn);
		ctx->sys_crm = UINT(ctx->CRm);
		ctx->has_result = (ctx->L==1);
		OK(ENC_SYSL_RC_SYSTEMINSTRS);
	}
	return rc;
}

/* tbl_advsimd.xml */
int TBL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|001110|op2=00|0|Rm=xxxxx|0|len=xx|op=0|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE09C00)==0xE000000) {
		decode_fields32(ENC_TBL_ASIMDTBL_L2_2, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((8) ? ((ctx->datasize) / (8)) : 0);
		ctx->regs = UINT(ctx->len)+1;
		ctx->is_tbl = (ctx->op==0);
		if(ctx->len==1) OK(ENC_TBL_ASIMDTBL_L2_2);
		if(ctx->len==2) OK(ENC_TBL_ASIMDTBL_L3_3);
		if(ctx->len==3) OK(ENC_TBL_ASIMDTBL_L4_4);
		if(ctx->len==0) OK(ENC_TBL_ASIMDTBL_L1_1);
	}
	return rc;
}

/* tbnz.xml */
int TBNZ(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_br14 */
	/* b5=x|011011|op=1|b40=xxxxx|imm14=xxxxxxxxxxxxxx|Rt=xxxxx */
	if((INSWORD & 0x7F000000)==0x37000000) {
		decode_fields32(ENC_TBNZ_ONLY_TESTBRANCH, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->datasize = (ctx->b5==1) ? 0x40 : 0x20;
		ctx->bit_pos = UINT(((ctx->b5<<5)|ctx->b40));
		ctx->bit_val = ctx->op;
		ctx->offset = SignExtend((ctx->imm14<<2),16);
		OK(ENC_TBNZ_ONLY_TESTBRANCH);
	}
	return rc;
}

/* tbx_advsimd.xml */
int TBX_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|001110|op2=00|0|Rm=xxxxx|0|len=xx|op=1|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE09C00)==0xE001000) {
		decode_fields32(ENC_TBX_ASIMDTBL_L2_2, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((8) ? ((ctx->datasize) / (8)) : 0);
		ctx->regs = UINT(ctx->len)+1;
		ctx->is_tbl = (ctx->op==0);
		if(ctx->len==1) OK(ENC_TBX_ASIMDTBL_L2_2);
		if(ctx->len==2) OK(ENC_TBX_ASIMDTBL_L3_3);
		if(ctx->len==3) OK(ENC_TBX_ASIMDTBL_L4_4);
		if(ctx->len==0) OK(ENC_TBX_ASIMDTBL_L1_1);
	}
	return rc;
}

/* tbz.xml */
int TBZ(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_br14 */
	/* b5=x|011011|op=0|b40=xxxxx|imm14=xxxxxxxxxxxxxx|Rt=xxxxx */
	if((INSWORD & 0x7F000000)==0x36000000) {
		decode_fields32(ENC_TBZ_ONLY_TESTBRANCH, ctx, instr);
		ctx->t = UINT(ctx->Rt);
		ctx->datasize = (ctx->b5==1) ? 0x40 : 0x20;
		ctx->bit_pos = UINT(((ctx->b5<<5)|ctx->b40));
		ctx->bit_val = ctx->op;
		ctx->offset = SignExtend((ctx->imm14<<2),16);
		OK(ENC_TBZ_ONLY_TESTBRANCH);
	}
	return rc;
}

/* tcancel.xml */
int TCANCEL(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 11010100|opc=011|imm16=xxxxxxxxxxxxxxxx|op2=000|LL=00 */
	if((INSWORD & 0xFFE0001F)==0xD4600000) {
		decode_fields32(ENC_TCANCEL_EX_EXCEPTION, ctx, instr);
		if(!HaveTME()) {
			UNDEFINED;
		}
		ctx->retry = (SLICE(ctx->imm16,15,15)==1);
		ctx->reason = SLICE(ctx->imm16,14,0);
		OK(ENC_TCANCEL_EX_EXCEPTION);
	}
	return rc;
}

/* tcommit.xml */
int TCOMMIT(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0011|CRm=0000|op2=011|Rt=11111 */
	if((INSWORD & 0xFFFFFFFF)==0xD503307F) {
		decode_fields32(ENC_TCOMMIT_ONLY_BARRIERS, ctx, instr);
		if(!HaveTME()) {
			UNDEFINED;
		}
		OK(ENC_TCOMMIT_ONLY_BARRIERS);
	}
	return rc;
}

/* tlbi_sys.xml */
int TLBI_SYS(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=01|op1=xxx|CRn=1000|CRm=xxxx|op2=xxx|Rt=xxxxx */
	if((INSWORD & 0xFFF8F000)==0xD5088000) {
		decode_fields32(ENC_TLBI_SYS_CR_SYSTEMINSTRS, ctx, instr);
		OK(ENC_TLBI_SYS_CR_SYSTEMINSTRS);
	}
	return rc;
}

/* trn1_advsimd.xml */
int TRN1_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|001110|size=xx|0|Rm=xxxxx|0|op=0|10|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE002800) {
		decode_fields32(ENC_TRN1_ASIMDPERM_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->part = UINT(ctx->op);
		ctx->pairs = ((2) ? ((ctx->elements) / (2)) : 0);
		OK(ENC_TRN1_ASIMDPERM_ONLY);
	}
	return rc;
}

/* trn2_advsimd.xml */
int TRN2_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|001110|size=xx|0|Rm=xxxxx|0|op=1|10|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE006800) {
		decode_fields32(ENC_TRN2_ASIMDPERM_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->part = UINT(ctx->op);
		ctx->pairs = ((2) ? ((ctx->elements) / (2)) : 0);
		OK(ENC_TRN2_ASIMDPERM_ONLY);
	}
	return rc;
}

/* tsb.xml */
int TSB(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=0010|op2=010|Rt=11111 */
	if((INSWORD & 0xFFFFFFFF)==0xD503225F) {
		decode_fields32(ENC_TSB_HC_HINTS, ctx, instr);
		if(!((ctx->CRm<<3)|ctx->op2)) {
			ctx->op = SystemHintOp_NOP;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==1) {
			ctx->op = SystemHintOp_YIELD;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==2) {
			ctx->op = SystemHintOp_WFE;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==3) {
			ctx->op = SystemHintOp_WFI;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==4) {
			ctx->op = SystemHintOp_SEV;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==5) {
			ctx->op = SystemHintOp_SEVL;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==6) {
			if(!HaveDGHExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_DGH;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==7) {
			SEE /* XPACLRI */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==8) {
			if(!ctx->op2) {
				SEE /* PACIA1716 */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIB1716 */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIA1716 */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIB1716 */;
			}
			else {
				ENDOFINSTRUCTION;
			}
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x10) {
			if(!HaveRASExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_ESB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x11) {
			if(!HaveStatisticalProfiling()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_PSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x12) {
			if(!HaveSelfHostedTrace()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_TSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x14) {
			ctx->op = SystemHintOp_CSDB;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==0x18) {
			if(!ctx->op2) {
				SEE /* PACIAZ */;
			}
			else if(ctx->op2==1) {
				SEE /* PACIASP */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIBZ */;
			}
			else if(ctx->op2==3) {
				SEE /* PACIBSP */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIAZ */;
			}
			else if(ctx->op2==5) {
				SEE /* AUTHASP */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIBZ */;
			}
			else if(ctx->op2==7) {
				SEE /* AUTIBSP */;
			}
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x79)==0x20) {
			ctx->op = SystemHintOp_BTI;
			SetBTypeCompatible(BTypeCompatible_BTI(SLICE(ctx->op2,2,1), ctx->pstate_btype));
		}
		else {
			ENDOFINSTRUCTION;
		}
		OK(ENC_TSB_HC_HINTS);
	}
	return rc;
}

/* tstart.xml */
int TSTART(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=1|op0=00|op1=011|CRn=0011|CRm=0000|op2=011|Rt=xxxxx */
	if((INSWORD & 0xFFFFFFE0)==0xD5233060) {
		decode_fields32(ENC_TSTART_BR_SYSTEMRESULT, ctx, instr);
		if(!HaveTME()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		OK(ENC_TSTART_BR_SYSTEMRESULT);
	}
	return rc;
}

/* tst_ands_log_imm.xml */
int TST_ANDS_log_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|opc=11|100100|N=x|immr=xxxxxx|imms=xxxxxx|Rn=xxxxx|Rd=11111 */
	if((INSWORD & 0x7F80001F)==0x7200001F) {
		decode_fields32(ENC_TST_ANDS_32S_LOG_IMM, ctx, instr);
		if(ctx->sf==0 && ctx->N==0) OK(ENC_TST_ANDS_32S_LOG_IMM);
		if(ctx->sf==1) OK(ENC_TST_ANDS_64S_LOG_IMM);
	}
	return rc;
}

/* tst_ands_log_shift.xml */
int TST_ANDS_log_shift(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_s */
	/* sf=x|opc=11|01010|shift=xx|N=0|Rm=xxxxx|imm6=xxxxxx|Rn=xxxxx|Rd=11111 */
	if((INSWORD & 0x7F20001F)==0x6A00001F) {
		decode_fields32(ENC_TST_ANDS_32_LOG_SHIFT, ctx, instr);
		if(ctx->sf==0) OK(ENC_TST_ANDS_32_LOG_SHIFT);
		if(ctx->sf==1) OK(ENC_TST_ANDS_64_LOG_SHIFT);
	}
	return rc;
}

/* ttest.xml */
int TTEST(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=1|op0=00|op1=011|CRn=0011|CRm=0001|op2=011|Rt=xxxxx */
	if((INSWORD & 0xFFFFFFE0)==0xD5233160) {
		decode_fields32(ENC_TTEST_BR_SYSTEMRESULT, ctx, instr);
		if(!HaveTME()) {
			UNDEFINED;
		}
		ctx->t = UINT(ctx->Rt);
		OK(ENC_TTEST_BR_SYSTEMRESULT);
	}
	return rc;
}

/* uabal_advsimd.xml */
int UABAL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|01|op=0|1|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E205000) {
		decode_fields32(ENC_UABAL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->accumulate = (ctx->op==0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UABAL_ASIMDDIFF_L);
	}
	return rc;
}

/* uaba_advsimd.xml */
int UABA_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|0111|ac=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E207C00) {
		decode_fields32(ENC_UABA_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->accumulate = (ctx->ac==1);
		OK(ENC_UABA_ASIMDSAME_ONLY);
	}
	return rc;
}

/* uabdl_advsimd.xml */
int UABDL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|01|op=1|1|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E207000) {
		decode_fields32(ENC_UABDL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->accumulate = (ctx->op==0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UABDL_ASIMDDIFF_L);
	}
	return rc;
}

/* uabd_advsimd.xml */
int UABD_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|0111|ac=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E207400) {
		decode_fields32(ENC_UABD_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->accumulate = (ctx->ac==1);
		OK(ENC_UABD_ASIMDSAME_ONLY);
	}
	return rc;
}

/* uadalp_advsimd.xml */
int UADALP_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|10000|00|op=1|10|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0x2E206800) {
		decode_fields32(ENC_UADALP_ASIMDMISC_P, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((((2) * (ctx->esize))) ? ((ctx->datasize) / (((2) * (ctx->esize)))) : 0);
		ctx->acc = (ctx->op==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UADALP_ASIMDMISC_P);
	}
	return rc;
}

/* uaddlp_advsimd.xml */
int UADDLP_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|10000|00|op=0|10|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0x2E202800) {
		decode_fields32(ENC_UADDLP_ASIMDMISC_P, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((((2) * (ctx->esize))) ? ((ctx->datasize) / (((2) * (ctx->esize)))) : 0);
		ctx->acc = (ctx->op==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UADDLP_ASIMDMISC_P);
	}
	return rc;
}

/* uaddlv_advsimd.xml */
int UADDLV_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|U=1|01110|size=xx|11000|opcode=00011|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0x2E303800) {
		decode_fields32(ENC_UADDLV_ASIMDALL_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==4) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UADDLV_ASIMDALL_ONLY);
	}
	return rc;
}

/* uaddl_advsimd.xml */
int UADDL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|00|o1=0|0|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E200000) {
		decode_fields32(ENC_UADDL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UADDL_ASIMDDIFF_L);
	}
	return rc;
}

/* uaddw_advsimd.xml */
int UADDW_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|00|o1=0|1|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E201000) {
		decode_fields32(ENC_UADDW_ASIMDDIFF_W, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UADDW_ASIMDDIFF_W);
	}
	return rc;
}

/* ubfiz_ubfm.xml */
int UBFIZ_UBFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_zero_fill */
	/* sf=x|opc=10|100110|N=x|immr=xxxxxx|imms=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x53000000) {
		decode_fields32(ENC_UBFIZ_UBFM_32M_BITFIELD, ctx, instr);
		if(ctx->sf==0 && ctx->N==0) OK(ENC_UBFIZ_UBFM_32M_BITFIELD);
		if(ctx->sf==1 && ctx->N==1) OK(ENC_UBFIZ_UBFM_64M_BITFIELD);
	}
	return rc;
}

/* ubfm.xml */
int UBFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_zero_fill */
	/* sf=x|opc=10|100110|N=x|immr=xxxxxx|imms=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x53000000) {
		decode_fields32(ENC_UBFM_32M_BITFIELD, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->opc) {
			ctx->inzero = TRUE;
			ctx->extend = TRUE;
		}
		else if(ctx->opc==1) {
			ctx->inzero = FALSE;
			ctx->extend = FALSE;
		}
		else if(ctx->opc==2) {
			ctx->inzero = TRUE;
			ctx->extend = FALSE;
		}
		else if(ctx->opc==3) {
			UNDEFINED;
		}
		if(ctx->sf==1 && ctx->N!=1) {
			UNDEFINED;
		}
		if(ctx->sf==0 && (ctx->N!=0 || SLICE(ctx->immr,5,5)!=0 || SLICE(ctx->imms,5,5)!=0)) {
			UNDEFINED;
		}
		ctx->R = UINT(ctx->immr);
		ctx->S = UINT(ctx->imms);
		DecodeBitMasks_ReturnType dbmrt = DecodeBitMasks(ctx->N,ctx->imms,ctx->immr);
		ctx->wmask = dbmrt.wmask;
		ctx->tmask = dbmrt.tmask;
		/* regular aliases */
		bool encoding32 = ctx->sf==0 && ctx->N==0;
		bool encoding64 = ctx->sf==1 && ctx->N==1;
		if((ctx->imms!=0x1f && ctx->imms+1==ctx->immr && EncodingLabeled32Bit()) || (ctx->imms!=0x3f && ctx->imms+1==ctx->immr && EncodingLabeled64Bit())) return LSL_UBFM(ctx, instr);
		if((ctx->imms==0x1f && EncodingLabeled32Bit()) || (ctx->imms==0x3f && EncodingLabeled64Bit())) return LSR_UBFM(ctx, instr);
		if(UINT(ctx->imms)<UINT(ctx->immr)) return UBFIZ_UBFM(ctx, instr);
		if(BFXPreferred(ctx->sf,SLICE(ctx->opc,1,1),ctx->imms,ctx->immr)) return UBFX_UBFM(ctx, instr);
		if(ctx->immr==0 && ctx->imms==7) return UXTB_UBFM(ctx, instr);
		if(ctx->immr==0 && ctx->imms==15) return UXTH_UBFM(ctx, instr);
		if(ctx->sf==0 && ctx->N==0) OK(ENC_UBFM_32M_BITFIELD);
		if(ctx->sf==1 && ctx->N==1) OK(ENC_UBFM_64M_BITFIELD);
	}
	return rc;
}

/* ubfx_ubfm.xml */
int UBFX_UBFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_zero_fill */
	/* sf=x|opc=10|100110|N=x|immr=xxxxxx|imms=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F800000)==0x53000000) {
		decode_fields32(ENC_UBFX_UBFM_32M_BITFIELD, ctx, instr);
		if(ctx->sf==0 && ctx->N==0) OK(ENC_UBFX_UBFM_32M_BITFIELD);
		if(ctx->sf==1 && ctx->N==1) OK(ENC_UBFX_UBFM_64M_BITFIELD);
	}
	return rc;
}

/* ucvtf_advsimd_fix.xml */
int UCVTF_advsimd_fix(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|111110|immh!=0000|immb=xxx|opcode=11100|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x7F00E400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_UCVTF_ASISDSHF_C, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!(ctx->immh&14) || ((ctx->immh&14)==2 && !HaveFP16Ext())) {
			UNDEFINED;
		}
		ctx->esize = ((ctx->immh&8)==8) ? 0x40 : (((ctx->immh&12)==4) ? 0x20 : 0x10);
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->fracbits = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = FPRoundingMode(ctx->FPCR);
		OK(ENC_UCVTF_ASISDSHF_C);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|011110|immh!=0000|immb=xxx|opcode=11100|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0x2F00E400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_UCVTF_ASIMDSHF_C, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(!(ctx->immh&14) || ((ctx->immh&14)==2 && !HaveFP16Ext())) {
			UNDEFINED;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = ((ctx->immh&8)==8) ? 0x40 : (((ctx->immh&12)==4) ? 0x20 : 0x10);
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->fracbits = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = FPRoundingMode(ctx->FPCR);
		OK(ENC_UCVTF_ASIMDSHF_C);
	}
	return rc;
}

/* ucvtf_advsimd_int.xml */
int UCVTF_advsimd_int(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd_half */
	/* 01|U=1|11110|a=0|111100|opcode=11101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x7E79D800) {
		decode_fields32(ENC_UCVTF_ASISDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UCVTF_ASISDMISCFP16_R);
	}
	/* class iclass_sisd_single_and_double */
	/* 01|U=1|11110|0|sz=x|10000|opcode=11101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFBFFC00)==0x7E21D800) {
		decode_fields32(ENC_UCVTF_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UCVTF_ASISDMISC_R);
	}
	/* class iclass_simd_half */
	/* 0|Q=x|U=1|01110|a=0|111100|opcode=11101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFFFFC00)==0x2E79D800) {
		decode_fields32(ENC_UCVTF_ASIMDMISCFP16_R, ctx, instr);
		if(!HaveFP16Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = 0x10;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UCVTF_ASIMDMISCFP16_R);
	}
	/* class iclass_simd_single_and_double */
	/* 0|Q=x|U=1|01110|0|sz=x|10000|opcode=11101|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2E21D800) {
		decode_fields32(ENC_UCVTF_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->sz<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UCVTF_ASIMDMISC_R);
	}
	return rc;
}

/* ucvtf_float_fix.xml */
int UCVTF_float_fix(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|0|rmode=00|opcode=011|scale=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F3F0000)==0x1E030000) {
		decode_fields32(ENC_UCVTF_H32_FLOAT2FIX, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			UNDEFINED;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(ctx->sf==0 && SLICE(ctx->scale,5,5)==0) {
			UNDEFINED;
		}
		ctx->fracbits = 0x40-UINT(ctx->scale);
		if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==3) {
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3) OK(ENC_UCVTF_H32_FLOAT2FIX);
		if(ctx->sf==0 && ctx->ftype==0) OK(ENC_UCVTF_S32_FLOAT2FIX);
		if(ctx->sf==0 && ctx->ftype==1) OK(ENC_UCVTF_D32_FLOAT2FIX);
		if(ctx->sf==1 && ctx->ftype==3) OK(ENC_UCVTF_H64_FLOAT2FIX);
		if(ctx->sf==1 && ctx->ftype==0) OK(ENC_UCVTF_S64_FLOAT2FIX);
		if(ctx->sf==1 && ctx->ftype==1) OK(ENC_UCVTF_D64_FLOAT2FIX);
	}
	return rc;
}

/* ucvtf_float_int.xml */
int UCVTF_float_int(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_float */
	/* sf=x|0|S=0|11110|ftype=xx|1|rmode=00|opcode=011|000000|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7F3FFC00)==0x1E230000) {
		decode_fields32(ENC_UCVTF_H32_FLOAT2INT, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->intsize = (ctx->sf==1) ? 0x40 : 0x20;
		if(!ctx->ftype) {
			ctx->fltsize = 0x20;
		}
		else if(ctx->ftype==1) {
			ctx->fltsize = 0x40;
		}
		else if(ctx->ftype==2) {
			if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)!=13) {
				UNDEFINED;
			}
			ctx->fltsize = 0x80;
		}
		else if(ctx->ftype==3) {
			if(HaveFP16Ext()) {
				ctx->fltsize = 0x10;
			}
			else {
				UNDEFINED;
			}
		}
		if(!(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)&12)) {
			ctx->rounding = FPDecodeRounding(ctx->rmode);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==4) {
			ctx->rounding = FPRoundingMode(ctx->FPCR);
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_ItoF;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==8) {
			ctx->rounding = FPRounding_TIEAWAY;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==12) {
			if(ctx->fltsize!=0x10 && ctx->fltsize!=ctx->intsize) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 0;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==13) {
			if(ctx->intsize!=0x40 || ctx->fltsize!=0x80) {
				UNDEFINED;
			}
			if(SLICE(ctx->opcode,0,0)==1) {
				ctx->op = FPConvOp_MOV_ItoF;
			};
			ctx->part = 1;
			ctx->fltsize = 0x40;
		}
		else if(((SLICE(ctx->opcode,2,1)<<2)|ctx->rmode)==15) {
			if(!HaveFJCVTZSExt()) {
				UNDEFINED;
			}
			ctx->rounding = FPRounding_ZERO;
			ctx->unsigned_ = (SLICE(ctx->opcode,0,0)==1);
			ctx->op = FPConvOp_CVT_FtoI_JS;
		}
		else {
			UNDEFINED;
		}
		if(ctx->sf==0 && ctx->ftype==3) OK(ENC_UCVTF_H32_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==0) OK(ENC_UCVTF_S32_FLOAT2INT);
		if(ctx->sf==0 && ctx->ftype==1) OK(ENC_UCVTF_D32_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==3) OK(ENC_UCVTF_H64_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==0) OK(ENC_UCVTF_S64_FLOAT2INT);
		if(ctx->sf==1 && ctx->ftype==1) OK(ENC_UCVTF_D64_FLOAT2INT);
	}
	return rc;
}

/* udf_perm_undef.xml */
int UDF_perm_undef(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* 0000000000000000|imm16=xxxxxxxxxxxxxxxx */
	if((INSWORD & 0xFFFF0000)==0x0) {
		decode_fields32(ENC_UDF_ONLY_PERM_UNDEF, ctx, instr);
		OK(ENC_UDF_ONLY_PERM_UNDEF);
	}
	return rc;
}

/* udiv.xml */
int UDIV(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=x|op=0|S=0|11010110|Rm=xxxxx|opcode2<5:1>=00001|o1=0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0x7FE0FC00)==0x1AC00800) {
		decode_fields32(ENC_UDIV_32_DP_2SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->datasize = (ctx->sf==1) ? 0x40 : 0x20;
		ctx->unsigned_ = (ctx->o1==0);
		if(ctx->sf==0) OK(ENC_UDIV_32_DP_2SRC);
		if(ctx->sf==1) OK(ENC_UDIV_64_DP_2SRC);
	}
	return rc;
}

/* udot_advsimd_elt.xml */
int UDOT_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_element */
	/* 0|Q=x|U=1|01111|size=xx|L=x|M=x|Rm=xxxx|opcode=1110|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0x2F00E000) {
		decode_fields32(ENC_UDOT_ASIMDELEM_D, ctx, instr);
		if(!HaveDOTPExt()) {
			UNDEFINED;
		}
		if(ctx->size!=2) {
			UNDEFINED;
		}
		ctx->signed_ = (ctx->U==0);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->M<<4)|ctx->Rm));
		ctx->index = UINT(((ctx->H<<1)|ctx->L));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_UDOT_ASIMDELEM_D);
	}
	return rc;
}

/* udot_advsimd_vec.xml */
int UDOT_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|0|Rm=xxxxx|1|opcode=0010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E009400) {
		decode_fields32(ENC_UDOT_ASIMDSAME2_D, ctx, instr);
		if(!HaveDOTPExt()) {
			UNDEFINED;
		}
		if(ctx->size!=2) {
			UNDEFINED;
		}
		ctx->signed_ = (ctx->U==0);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_UDOT_ASIMDSAME2_D);
	}
	return rc;
}

/* uhadd_advsimd.xml */
int UHADD_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|opcode=00000|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E200400) {
		decode_fields32(ENC_UHADD_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UHADD_ASIMDSAME_ONLY);
	}
	return rc;
}

/* uhsub_advsimd.xml */
int UHSUB_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|opcode=00100|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E202400) {
		decode_fields32(ENC_UHSUB_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UHSUB_ASIMDSAME_ONLY);
	}
	return rc;
}

/* umaddl.xml */
int UMADDL(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_64 */
	/* sf=1|op54=00|11011|U=1|01|Rm=xxxxx|o0=0|Ra=xxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE08000)==0x9BA00000) {
		decode_fields32(ENC_UMADDL_64WA_DP_3SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->a = UINT(ctx->Ra);
		ctx->destsize = 0x40;
		ctx->datasize = 0x20;
		ctx->sub_op = (ctx->o0==1);
		ctx->unsigned_ = (ctx->U==1);
		/* regular aliases */
		if(ctx->Ra==0x1f) return UMULL_UMADDL(ctx, instr);
		OK(ENC_UMADDL_64WA_DP_3SRC);
	}
	return rc;
}

/* umaxp_advsimd.xml */
int UMAXP_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|1010|o1=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E20A400) {
		decode_fields32(ENC_UMAXP_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_UMAXP_ASIMDSAME_ONLY);
	}
	return rc;
}

/* umaxv_advsimd.xml */
int UMAXV_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|U=1|01110|size=xx|11000|op=0|1010|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0x2E30A800) {
		decode_fields32(ENC_UMAXV_ASIMDALL_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==4) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->min = (ctx->op==1);
		OK(ENC_UMAXV_ASIMDALL_ONLY);
	}
	return rc;
}

/* umax_advsimd.xml */
int UMAX_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|0110|o1=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E206400) {
		decode_fields32(ENC_UMAX_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_UMAX_ASIMDSAME_ONLY);
	}
	return rc;
}

/* uminp_advsimd.xml */
int UMINP_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|1010|o1=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E20AC00) {
		decode_fields32(ENC_UMINP_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_UMINP_ASIMDSAME_ONLY);
	}
	return rc;
}

/* uminv_advsimd.xml */
int UMINV_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|U=1|01110|size=xx|11000|op=1|1010|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0x2E31A800) {
		decode_fields32(ENC_UMINV_ASIMDALL_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==4) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->min = (ctx->op==1);
		OK(ENC_UMINV_ASIMDALL_ONLY);
	}
	return rc;
}

/* umin_advsimd.xml */
int UMIN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|0110|o1=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E206C00) {
		decode_fields32(ENC_UMIN_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->minimum = (ctx->o1==1);
		OK(ENC_UMIN_ASIMDSAME_ONLY);
	}
	return rc;
}

/* umlal_advsimd_elt.xml */
int UMLAL_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_element */
	/* 0|Q=x|U=1|01111|size=xx|L=x|M=x|Rm=xxxx|0|o2=0|10|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0x2F002000) {
		decode_fields32(ENC_UMLAL_ASIMDELEM_L, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_UMLAL_ASIMDELEM_L);
	}
	return rc;
}

/* umlal_advsimd_vec.xml */
int UMLAL_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|10|o1=0|0|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E208000) {
		decode_fields32(ENC_UMLAL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UMLAL_ASIMDDIFF_L);
	}
	return rc;
}

/* umlsl_advsimd_elt.xml */
int UMLSL_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_element */
	/* 0|Q=x|U=1|01111|size=xx|L=x|M=x|Rm=xxxx|0|o2=1|10|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0x2F006000) {
		decode_fields32(ENC_UMLSL_ASIMDELEM_L, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->sub_op = (ctx->o2==1);
		OK(ENC_UMLSL_ASIMDELEM_L);
	}
	return rc;
}

/* umlsl_advsimd_vec.xml */
int UMLSL_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|10|o1=1|0|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E20A000) {
		decode_fields32(ENC_UMLSL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UMLSL_ASIMDDIFF_L);
	}
	return rc;
}

/* ummla_advsimd_vec.xml */
int UMMLA_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=1|U=1|01110|size=10|0|Rm=xxxxx|1|010|B=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x6E80A400) {
		decode_fields32(ENC_UMMLA_ASIMDSAME2_G, ctx, instr);
		if(!HaveInt8MatMulExt()) {
			UNDEFINED;
		}
		if(!((ctx->B<<1)|ctx->U)) {
			ctx->op1_unsigned = FALSE;
			ctx->op2_unsigned = FALSE;
		}
		else if(((ctx->B<<1)|ctx->U)==1) {
			ctx->op1_unsigned = TRUE;
			ctx->op2_unsigned = TRUE;
		}
		else if(((ctx->B<<1)|ctx->U)==2) {
			ctx->op1_unsigned = TRUE;
			ctx->op2_unsigned = FALSE;
		}
		else if(((ctx->B<<1)|ctx->U)==3) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->d = UINT(ctx->Rd);
		OK(ENC_UMMLA_ASIMDSAME2_G);
	}
	return rc;
}

/* umnegl_umsubl.xml */
int UMNEGL_UMSUBL(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_64 */
	/* sf=1|op54=00|11011|U=1|01|Rm=xxxxx|o0=1|Ra=11111|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x9BA0FC00) {
		decode_fields32(ENC_UMNEGL_UMSUBL_64WA_DP_3SRC, ctx, instr);
		OK(ENC_UMNEGL_UMSUBL_64WA_DP_3SRC);
	}
	return rc;
}

/* umov_advsimd.xml */
int UMOV_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|op=0|01110000|imm5=xxxxx|0|imm4<3:2>=01|imm4=11|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xE003C00) {
		decode_fields32(ENC_UMOV_ASIMDINS_W_W, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if((((ctx->Q<<5)|ctx->imm5)&0x21)==1) {
			ctx->size = 0;
		}
		else if((((ctx->Q<<5)|ctx->imm5)&0x23)==2) {
			ctx->size = 1;
		}
		else if((((ctx->Q<<5)|ctx->imm5)&0x27)==4) {
			ctx->size = 2;
		}
		else if((((ctx->Q<<5)|ctx->imm5)&0x2f)==0x28) {
			ctx->size = 3;
		}
		else {
			UNDEFINED;
		}
		ctx->idxdsize = (SLICE(ctx->imm5,4,4)==1) ? 0x80 : 0x40;
		ctx->index = UINT(SLICE(ctx->imm5,4,ctx->size+1));
		ctx->esize = (8) << (ctx->size);
		ctx->datasize = (ctx->Q==1) ? 0x40 : 0x20;
		/* regular aliases */
		if(((ctx->imm5&15)==8) || ((ctx->imm5&7)==4)) return MOV_UMOV_advsimd(ctx, instr);
		if(ctx->Q==0) OK(ENC_UMOV_ASIMDINS_W_W);
		if(ctx->Q==1 && (ctx->imm5&15)==8) OK(ENC_UMOV_ASIMDINS_X_X);
	}
	return rc;
}

/* umsubl.xml */
int UMSUBL(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_64 */
	/* sf=1|op54=00|11011|U=1|01|Rm=xxxxx|o0=1|Ra=xxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE08000)==0x9BA08000) {
		decode_fields32(ENC_UMSUBL_64WA_DP_3SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->a = UINT(ctx->Ra);
		ctx->destsize = 0x40;
		ctx->datasize = 0x20;
		ctx->sub_op = (ctx->o0==1);
		ctx->unsigned_ = (ctx->U==1);
		/* regular aliases */
		if(ctx->Ra==0x1f) return UMNEGL_UMSUBL(ctx, instr);
		OK(ENC_UMSUBL_64WA_DP_3SRC);
	}
	return rc;
}

/* umulh.xml */
int UMULH(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_64 */
	/* sf=1|op54=00|11011|U=1|10|Rm=xxxxx|o0=0|Ra=(1)(1)(1)(1)(1)|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE08000)==0x9BC00000) {
		decode_fields32(ENC_UMULH_64_DP_3SRC, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->a = UINT(ctx->Ra);
		ctx->destsize = 0x40;
		ctx->datasize = ctx->destsize;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UMULH_64_DP_3SRC);
	}
	return rc;
}

/* umull_umaddl.xml */
int UMULL_UMADDL(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_64 */
	/* sf=1|op54=00|11011|U=1|01|Rm=xxxxx|o0=0|Ra=11111|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x9BA07C00) {
		decode_fields32(ENC_UMULL_UMADDL_64WA_DP_3SRC, ctx, instr);
		OK(ENC_UMULL_UMADDL_64WA_DP_3SRC);
	}
	return rc;
}

/* umull_advsimd_elt.xml */
int UMULL_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_element */
	/* 0|Q=x|U=1|01111|size=xx|L=x|M=x|Rm=xxxx|opcode=1010|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF00F400)==0x2F00A000) {
		decode_fields32(ENC_UMULL_ASIMDELEM_L, ctx, instr);
		ctx->idxdsize = (ctx->H==1) ? 0x80 : 0x40;
		if(ctx->size==1) {
			ctx->index = UINT(((ctx->H<<2)|(ctx->L<<1)|ctx->M));
			ctx->Rmhi = 0;
		}
		else if(ctx->size==2) {
			ctx->index = UINT(((ctx->H<<1)|ctx->L));
			ctx->Rmhi = ctx->M;
		}
		else {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->Rmhi<<4)|ctx->Rm));
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UMULL_ASIMDELEM_L);
	}
	return rc;
}

/* umull_advsimd_vec.xml */
int UMULL_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|opcode=1100|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E20C000) {
		decode_fields32(ENC_UMULL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UMULL_ASIMDDIFF_L);
	}
	return rc;
}

/* uqadd_advsimd.xml */
int UQADD_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|1|Rm=xxxxx|opcode=00001|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x7E200C00) {
		decode_fields32(ENC_UQADD_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UQADD_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|opcode=00001|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E200C00) {
		decode_fields32(ENC_UQADD_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UQADD_ASIMDSAME_ONLY);
	}
	return rc;
}

/* uqrshl_advsimd.xml */
int UQRSHL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|1|Rm=xxxxx|010|R=1|S=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x7E205C00) {
		decode_fields32(ENC_UQRSHL_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = (ctx->R==1);
		ctx->saturating = (ctx->S==1);
		if(ctx->S==0 && ctx->size!=3) {
			UNDEFINED;
		}
		OK(ENC_UQRSHL_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|010|R=1|S=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E205C00) {
		decode_fields32(ENC_UQRSHL_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = (ctx->R==1);
		ctx->saturating = (ctx->S==1);
		OK(ENC_UQRSHL_ASIMDSAME_ONLY);
	}
	return rc;
}

/* uqrshrn_advsimd.xml */
int UQRSHRN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|111110|immh!=0000|immb=xxx|1001|op=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x7F009C00 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_UQRSHRN_ASISDSHF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			UNDEFINED;
		}
		if(SLICE(ctx->immh,3,3)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->part = 0;
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->round = (ctx->op==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UQRSHRN_ASISDSHF_N);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|011110|immh!=0000|immb=xxx|1001|op=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0x2F009C00 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_UQRSHRN_ASIMDSHF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(SLICE(ctx->immh,3,3)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->round = (ctx->op==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UQRSHRN_ASIMDSHF_N);
	}
	return rc;
}

/* uqshl_advsimd_imm.xml */
int UQSHL_advsimd_imm(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|111110|immh!=0000|immb=xxx|011|op=1|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x7F007400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_UQSHL_ASISDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->shift = UINT(((ctx->immh<<3)|ctx->immb))-ctx->esize;
		if(!((ctx->op<<1)|ctx->U)) {
			UNDEFINED;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->src_unsigned = FALSE;
			ctx->dst_unsigned = TRUE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->src_unsigned = FALSE;
			ctx->dst_unsigned = FALSE;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->src_unsigned = TRUE;
			ctx->dst_unsigned = TRUE;
		}
		OK(ENC_UQSHL_ASISDSHF_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|011110|immh!=0000|immb=xxx|011|op=1|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0x2F007400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_UQSHL_ASIMDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = UINT(((ctx->immh<<3)|ctx->immb))-ctx->esize;
		if(!((ctx->op<<1)|ctx->U)) {
			UNDEFINED;
		}
		else if(((ctx->op<<1)|ctx->U)==1) {
			ctx->src_unsigned = FALSE;
			ctx->dst_unsigned = TRUE;
		}
		else if(((ctx->op<<1)|ctx->U)==2) {
			ctx->src_unsigned = FALSE;
			ctx->dst_unsigned = FALSE;
		}
		else if(((ctx->op<<1)|ctx->U)==3) {
			ctx->src_unsigned = TRUE;
			ctx->dst_unsigned = TRUE;
		}
		OK(ENC_UQSHL_ASIMDSHF_R);
	}
	return rc;
}

/* uqshl_advsimd_reg.xml */
int UQSHL_advsimd_reg(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|1|Rm=xxxxx|010|R=0|S=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x7E204C00) {
		decode_fields32(ENC_UQSHL_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = (ctx->R==1);
		ctx->saturating = (ctx->S==1);
		if(ctx->S==0 && ctx->size!=3) {
			UNDEFINED;
		}
		OK(ENC_UQSHL_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|010|R=0|S=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E204C00) {
		decode_fields32(ENC_UQSHL_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = (ctx->R==1);
		ctx->saturating = (ctx->S==1);
		OK(ENC_UQSHL_ASIMDSAME_ONLY);
	}
	return rc;
}

/* uqshrn_advsimd.xml */
int UQSHRN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|111110|immh!=0000|immb=xxx|1001|op=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x7F009400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_UQSHRN_ASISDSHF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			UNDEFINED;
		}
		if(SLICE(ctx->immh,3,3)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->part = 0;
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->round = (ctx->op==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UQSHRN_ASISDSHF_N);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|011110|immh!=0000|immb=xxx|1001|op=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0x2F009400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_UQSHRN_ASIMDSHF_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(SLICE(ctx->immh,3,3)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->round = (ctx->op==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UQSHRN_ASIMDSHF_N);
	}
	return rc;
}

/* uqsub_advsimd.xml */
int UQSUB_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|1|Rm=xxxxx|opcode=00101|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x7E202C00) {
		decode_fields32(ENC_UQSUB_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UQSUB_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|opcode=00101|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E202C00) {
		decode_fields32(ENC_UQSUB_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UQSUB_ASIMDSAME_ONLY);
	}
	return rc;
}

/* uqxtn_advsimd.xml */
int UQXTN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|10000|opcode=10100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x7E214800) {
		decode_fields32(ENC_UQXTN_ASISDMISC_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->part = 0;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UQXTN_ASISDMISC_N);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|10000|opcode=10100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0x2E214800) {
		decode_fields32(ENC_UQXTN_ASIMDMISC_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_UQXTN_ASIMDMISC_N);
	}
	return rc;
}

/* urecpe_advsimd.xml */
int URECPE_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|1|sz=x|10000|opcode=11100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0xEA1C800) {
		decode_fields32(ENC_URECPE_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->sz==1) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_URECPE_ASIMDMISC_R);
	}
	return rc;
}

/* urhadd_advsimd.xml */
int URHADD_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_same */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|opcode=00010|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E201400) {
		decode_fields32(ENC_URHADD_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_URHADD_ASIMDSAME_ONLY);
	}
	return rc;
}

/* urshl_advsimd.xml */
int URSHL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|1|Rm=xxxxx|010|R=1|S=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x7E205400) {
		decode_fields32(ENC_URSHL_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = (ctx->R==1);
		ctx->saturating = (ctx->S==1);
		if(ctx->S==0 && ctx->size!=3) {
			UNDEFINED;
		}
		OK(ENC_URSHL_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|010|R=1|S=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E205400) {
		decode_fields32(ENC_URSHL_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = (ctx->R==1);
		ctx->saturating = (ctx->S==1);
		OK(ENC_URSHL_ASIMDSAME_ONLY);
	}
	return rc;
}

/* urshr_advsimd.xml */
int URSHR_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|111110|immh!=0000|immb=xxx|00|o1=1|o0=0|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x7F002400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_URSHR_ASISDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(SLICE(ctx->immh,3,3)!=1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (3);
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->round = (ctx->o1==1);
		ctx->accumulate = (ctx->o0==1);
		OK(ENC_URSHR_ASISDSHF_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|011110|immh!=0000|immb=xxx|00|o1=1|o0=0|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0x2F002400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_URSHR_ASIMDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->round = (ctx->o1==1);
		ctx->accumulate = (ctx->o0==1);
		OK(ENC_URSHR_ASIMDSHF_R);
	}
	return rc;
}

/* ursqrte_advsimd.xml */
int URSQRTE_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|1|sz=x|10000|opcode=11100|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFBFFC00)==0x2EA1C800) {
		decode_fields32(ENC_URSQRTE_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->sz==1) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_URSQRTE_ASIMDMISC_R);
	}
	return rc;
}

/* ursra_advsimd.xml */
int URSRA_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|111110|immh!=0000|immb=xxx|00|o1=1|o0=1|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x7F003400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_URSRA_ASISDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(SLICE(ctx->immh,3,3)!=1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (3);
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->round = (ctx->o1==1);
		ctx->accumulate = (ctx->o0==1);
		OK(ENC_URSRA_ASISDSHF_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|011110|immh!=0000|immb=xxx|00|o1=1|o0=1|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0x2F003400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_URSRA_ASIMDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->round = (ctx->o1==1);
		ctx->accumulate = (ctx->o0==1);
		OK(ENC_URSRA_ASIMDSHF_R);
	}
	return rc;
}

/* usdot_advsimd_elt.xml */
int USDOT_advsimd_elt(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_2reg_element */
	/* 0|Q=x|U=0|01111|US=1|0|L=x|M=x|Rm=xxxx|opcode=1111|H=x|0|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFC0F400)==0xF80F000) {
		decode_fields32(ENC_USDOT_ASIMDELEM_D, ctx, instr);
		if(!HaveInt8MatMulExt()) {
			UNDEFINED;
		}
		ctx->op1_unsigned = (ctx->US==1);
		ctx->op2_unsigned = (ctx->US==0);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(((ctx->M<<4)|ctx->Rm));
		ctx->d = UINT(ctx->Rd);
		ctx->i = UINT(((ctx->H<<1)|ctx->L));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((0x20) ? ((ctx->datasize) / (0x20)) : 0);
		OK(ENC_USDOT_ASIMDELEM_D);
	}
	return rc;
}

/* usdot_advsimd_vec.xml */
int USDOT_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=10|0|Rm=xxxxx|1|opcode=0011|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBFE0FC00)==0xE809C00) {
		decode_fields32(ENC_USDOT_ASIMDSAME2_D, ctx, instr);
		if(!HaveInt8MatMulExt()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->d = UINT(ctx->Rd);
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((0x20) ? ((ctx->datasize) / (0x20)) : 0);
		OK(ENC_USDOT_ASIMDSAME2_D);
	}
	return rc;
}

/* ushll_advsimd.xml */
int USHLL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=1|011110|immh!=0000|immb=xxx|opcode=10100|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0x2F00A400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_USHLL_ASIMDSHF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(SLICE(ctx->immh,3,3)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = UINT(((ctx->immh<<3)|ctx->immb))-ctx->esize;
		ctx->unsigned_ = (ctx->U==1);
		/* regular aliases */
		if(ctx->immb==0 && BitCount(ctx->immh)==1) return UXTL_USHLL_advsimd(ctx, instr);
		OK(ENC_USHLL_ASIMDSHF_L);
	}
	return rc;
}

/* ushl_advsimd.xml */
int USHL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|1|Rm=xxxxx|010|R=0|S=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x7E204400) {
		decode_fields32(ENC_USHL_ASISDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = (ctx->R==1);
		ctx->saturating = (ctx->S==1);
		if(ctx->S==0 && ctx->size!=3) {
			UNDEFINED;
		}
		OK(ENC_USHL_ASISDSAME_ONLY);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|010|R=0|S=0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E204400) {
		decode_fields32(ENC_USHL_ASIMDSAME_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		ctx->rounding = (ctx->R==1);
		ctx->saturating = (ctx->S==1);
		OK(ENC_USHL_ASIMDSAME_ONLY);
	}
	return rc;
}

/* ushr_advsimd.xml */
int USHR_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|111110|immh!=0000|immb=xxx|00|o1=0|o0=0|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x7F000400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_USHR_ASISDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(SLICE(ctx->immh,3,3)!=1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (3);
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->round = (ctx->o1==1);
		ctx->accumulate = (ctx->o0==1);
		OK(ENC_USHR_ASISDSHF_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|011110|immh!=0000|immb=xxx|00|o1=0|o0=0|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0x2F000400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_USHR_ASIMDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->round = (ctx->o1==1);
		ctx->accumulate = (ctx->o0==1);
		OK(ENC_USHR_ASIMDSHF_R);
	}
	return rc;
}

/* usmmla_advsimd_vec.xml */
int USMMLA_advsimd_vec(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=1|U=0|01110|size=10|0|Rm=xxxxx|1|010|B=1|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x4E80AC00) {
		decode_fields32(ENC_USMMLA_ASIMDSAME2_G, ctx, instr);
		if(!HaveInt8MatMulExt()) {
			UNDEFINED;
		}
		if(!((ctx->B<<1)|ctx->U)) {
			ctx->op1_unsigned = FALSE;
			ctx->op2_unsigned = FALSE;
		}
		else if(((ctx->B<<1)|ctx->U)==1) {
			ctx->op1_unsigned = TRUE;
			ctx->op2_unsigned = TRUE;
		}
		else if(((ctx->B<<1)|ctx->U)==2) {
			ctx->op1_unsigned = TRUE;
			ctx->op2_unsigned = FALSE;
		}
		else if(((ctx->B<<1)|ctx->U)==3) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->d = UINT(ctx->Rd);
		OK(ENC_USMMLA_ASIMDSAME2_G);
	}
	return rc;
}

/* usqadd_advsimd.xml */
int USQADD_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|11110|size=xx|10000|opcode=00011|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x7E203800) {
		decode_fields32(ENC_USQADD_ASISDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_USQADD_ASISDMISC_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|01110|size=xx|10000|opcode=00011|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0x2E203800) {
		decode_fields32(ENC_USQADD_ASIMDMISC_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_USQADD_ASIMDMISC_R);
	}
	return rc;
}

/* usra_advsimd.xml */
int USRA_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sisd */
	/* 01|U=1|111110|immh!=0000|immb=xxx|00|o1=0|o0=1|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFF80FC00)==0x7F001400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_USRA_ASISDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(SLICE(ctx->immh,3,3)!=1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (3);
		ctx->datasize = ctx->esize;
		ctx->elements = 1;
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->round = (ctx->o1==1);
		ctx->accumulate = (ctx->o0==1);
		OK(ENC_USRA_ASISDSHF_R);
	}
	/* class iclass_simd */
	/* 0|Q=x|U=1|011110|immh!=0000|immb=xxx|00|o1=0|o0=1|0|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF80FC00)==0x2F001400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_USRA_ASIMDSHF_R, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->immh==0) {
			SEE /* asimdimm */;
		}
		if(((SLICE(ctx->immh,3,3)<<1)|ctx->Q)==2) {
			UNDEFINED;
		}
		ctx->esize = (8) << (HighestSetBit(ctx->immh));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->shift = ((ctx->esize) * (2))-UINT(((ctx->immh<<3)|ctx->immb));
		ctx->unsigned_ = (ctx->U==1);
		ctx->round = (ctx->o1==1);
		ctx->accumulate = (ctx->o0==1);
		OK(ENC_USRA_ASIMDSHF_R);
	}
	return rc;
}

/* usubl_advsimd.xml */
int USUBL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|00|o1=1|0|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E202000) {
		decode_fields32(ENC_USUBL_ASIMDDIFF_L, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_USUBL_ASIMDDIFF_L);
	}
	return rc;
}

/* usubw_advsimd.xml */
int USUBW_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_3reg_diff */
	/* 0|Q=x|U=1|01110|size=xx|1|Rm=xxxxx|00|o1=1|1|00|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0x2E203000) {
		decode_fields32(ENC_USUBW_ASIMDDIFF_W, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->sub_op = (ctx->o1==1);
		ctx->unsigned_ = (ctx->U==1);
		OK(ENC_USUBW_ASIMDDIFF_W);
	}
	return rc;
}

/* uxtb_ubfm.xml */
int UXTB_UBFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_zero_fill */
	/* sf=0|opc=10|100110|N=0|immr=000000|imms=000111|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x53001C00) {
		decode_fields32(ENC_UXTB_UBFM_32M_BITFIELD, ctx, instr);
		OK(ENC_UXTB_UBFM_32M_BITFIELD);
	}
	return rc;
}

/* uxth_ubfm.xml */
int UXTH_UBFM(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_zero_fill */
	/* sf=0|opc=10|100110|N=0|immr=000000|imms=001111|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x53003C00) {
		decode_fields32(ENC_UXTH_UBFM_32M_BITFIELD, ctx, instr);
		OK(ENC_UXTH_UBFM_32M_BITFIELD);
	}
	return rc;
}

/* uxtl_ushll_advsimd.xml */
int UXTL_USHLL_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=1|011110|immh!=0000|immb=000|opcode=10100|1|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF87FC00)==0x2F00A400 && (INSWORD & 0x780000)!=0x0) {
		decode_fields32(ENC_UXTL_USHLL_ASIMDSHF_L, ctx, instr);
		OK(ENC_UXTL_USHLL_ASIMDSHF_L);
	}
	return rc;
}

/* uzp1_advsimd.xml */
int UZP1_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|001110|size=xx|0|Rm=xxxxx|0|op=0|01|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE001800) {
		decode_fields32(ENC_UZP1_ASIMDPERM_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->part = UINT(ctx->op);
		OK(ENC_UZP1_ASIMDPERM_ONLY);
	}
	return rc;
}

/* uzp2_advsimd.xml */
int UZP2_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|001110|size=xx|0|Rm=xxxxx|0|op=1|01|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE005800) {
		decode_fields32(ENC_UZP2_ASIMDPERM_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->part = UINT(ctx->op);
		OK(ENC_UZP2_ASIMDPERM_ONLY);
	}
	return rc;
}

/* wfe.xml */
int WFE(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=0000|op2=010|Rt=11111 */
	if((INSWORD & 0xFFFFFFFF)==0xD503205F) {
		decode_fields32(ENC_WFE_HI_HINTS, ctx, instr);
		if(!((ctx->CRm<<3)|ctx->op2)) {
			ctx->op = SystemHintOp_NOP;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==1) {
			ctx->op = SystemHintOp_YIELD;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==2) {
			ctx->op = SystemHintOp_WFE;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==3) {
			ctx->op = SystemHintOp_WFI;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==4) {
			ctx->op = SystemHintOp_SEV;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==5) {
			ctx->op = SystemHintOp_SEVL;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==6) {
			if(!HaveDGHExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_DGH;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==7) {
			SEE /* XPACLRI */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==8) {
			if(!ctx->op2) {
				SEE /* PACIA1716 */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIB1716 */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIA1716 */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIB1716 */;
			}
			else {
				ENDOFINSTRUCTION;
			}
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x10) {
			if(!HaveRASExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_ESB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x11) {
			if(!HaveStatisticalProfiling()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_PSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x12) {
			if(!HaveSelfHostedTrace()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_TSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x14) {
			ctx->op = SystemHintOp_CSDB;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==0x18) {
			if(!ctx->op2) {
				SEE /* PACIAZ */;
			}
			else if(ctx->op2==1) {
				SEE /* PACIASP */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIBZ */;
			}
			else if(ctx->op2==3) {
				SEE /* PACIBSP */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIAZ */;
			}
			else if(ctx->op2==5) {
				SEE /* AUTHASP */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIBZ */;
			}
			else if(ctx->op2==7) {
				SEE /* AUTIBSP */;
			}
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x79)==0x20) {
			ctx->op = SystemHintOp_BTI;
			SetBTypeCompatible(BTypeCompatible_BTI(SLICE(ctx->op2,2,1), ctx->pstate_btype));
		}
		else {
			ENDOFINSTRUCTION;
		}
		OK(ENC_WFE_HI_HINTS);
	}
	return rc;
}

/* wfet.xml */
int WFET(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 11010101000000110001|CRm=0000|op2=000|Rd=xxxxx */
	if((INSWORD & 0xFFFFFFE0)==0xD5031000) {
		decode_fields32(ENC_WFET_ONLY_SYSTEMINSTRSWITHREG, ctx, instr);
		if(!HaveFeatWFxT()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		if(!ctx->op2) {
			ctx->op = SystemHintOp_WFET;
		}
		else if(ctx->op2==1) {
			ctx->op = SystemHintOp_WFIT;
		}
		OK(ENC_WFET_ONLY_SYSTEMINSTRSWITHREG);
	}
	return rc;
}

/* wfi.xml */
int WFI(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=0000|op2=011|Rt=11111 */
	if((INSWORD & 0xFFFFFFFF)==0xD503207F) {
		decode_fields32(ENC_WFI_HI_HINTS, ctx, instr);
		if(!((ctx->CRm<<3)|ctx->op2)) {
			ctx->op = SystemHintOp_NOP;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==1) {
			ctx->op = SystemHintOp_YIELD;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==2) {
			ctx->op = SystemHintOp_WFE;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==3) {
			ctx->op = SystemHintOp_WFI;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==4) {
			ctx->op = SystemHintOp_SEV;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==5) {
			ctx->op = SystemHintOp_SEVL;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==6) {
			if(!HaveDGHExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_DGH;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==7) {
			SEE /* XPACLRI */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==8) {
			if(!ctx->op2) {
				SEE /* PACIA1716 */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIB1716 */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIA1716 */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIB1716 */;
			}
			else {
				ENDOFINSTRUCTION;
			}
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x10) {
			if(!HaveRASExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_ESB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x11) {
			if(!HaveStatisticalProfiling()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_PSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x12) {
			if(!HaveSelfHostedTrace()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_TSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x14) {
			ctx->op = SystemHintOp_CSDB;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==0x18) {
			if(!ctx->op2) {
				SEE /* PACIAZ */;
			}
			else if(ctx->op2==1) {
				SEE /* PACIASP */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIBZ */;
			}
			else if(ctx->op2==3) {
				SEE /* PACIBSP */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIAZ */;
			}
			else if(ctx->op2==5) {
				SEE /* AUTHASP */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIBZ */;
			}
			else if(ctx->op2==7) {
				SEE /* AUTIBSP */;
			}
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x79)==0x20) {
			ctx->op = SystemHintOp_BTI;
			SetBTypeCompatible(BTypeCompatible_BTI(SLICE(ctx->op2,2,1), ctx->pstate_btype));
		}
		else {
			ENDOFINSTRUCTION;
		}
		OK(ENC_WFI_HI_HINTS);
	}
	return rc;
}

/* wfit.xml */
int WFIT(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 11010101000000110001|CRm=0000|op2=001|Rd=xxxxx */
	if((INSWORD & 0xFFFFFFE0)==0xD5031020) {
		decode_fields32(ENC_WFIT_ONLY_SYSTEMINSTRSWITHREG, ctx, instr);
		if(!HaveFeatWFxT()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		if(!ctx->op2) {
			ctx->op = SystemHintOp_WFET;
		}
		else if(ctx->op2==1) {
			ctx->op = SystemHintOp_WFIT;
		}
		OK(ENC_WFIT_ONLY_SYSTEMINSTRSWITHREG);
	}
	return rc;
}

/* xaflag.xml */
int XAFLAG(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=000|CRn=0100|CRm=(0)(0)(0)(0)|op2=001|Rt =11111 */
	if((INSWORD & 0xFFFFF0FF)==0xD500403F) {
		decode_fields32(ENC_XAFLAG_M_PSTATE, ctx, instr);
		if(!HaveFlagFormatExt()) {
			UNDEFINED;
		}
		OK(ENC_XAFLAG_M_PSTATE);
	}
	return rc;
}

/* xar_advsimd.xml */
int XAR_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 11001110100|Rm=xxxxx|imm6=xxxxxx|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE00000)==0xCE800000) {
		decode_fields32(ENC_XAR_VVV2_CRYPTO3_IMM6, ctx, instr);
		if(!HaveSHA3Ext()) {
			UNDEFINED;
		}
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		OK(ENC_XAR_VVV2_CRYPTO3_IMM6);
	}
	return rc;
}

/* xpac.xml */
int XPAC(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_general */
	/* sf=1|1|S=0|11010110|opcode2=00001|opcode[5]=0|opcode[4]=1|opcode[3:1]=000|D=x|Rn=11111|Rd=xxxxx */
	if((INSWORD & 0xFFFFFBE0)==0xDAC143E0) {
		decode_fields32(ENC_XPACD_64Z_DP_1SRC, ctx, instr);
		ctx->data = (ctx->D==1);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(!HavePACExt()) {
			UNDEFINED;
		}
		if(ctx->n!=0x1f) {
			UNDEFINED;
		}
		if(ctx->D==1) OK(ENC_XPACD_64Z_DP_1SRC);
		if(ctx->D==0) OK(ENC_XPACI_64Z_DP_1SRC);
	}
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=0000|op2=111|Rt=11111 */
	if((INSWORD & 0xFFFFFFFF)==0xD50320FF) {
		decode_fields32(ENC_XPACLRI_HI_HINTS, ctx, instr);
		OK(ENC_XPACLRI_HI_HINTS);
	}
	return rc;
}

/* xtn_advsimd.xml */
int XTN_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_simd */
	/* 0|Q=x|U=0|01110|size=xx|10000|opcode=10010|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF3FFC00)==0xE212800) {
		decode_fields32(ENC_XTN_ASIMDMISC_N, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = 0x40;
		ctx->part = UINT(ctx->Q);
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		OK(ENC_XTN_ASIMDMISC_N);
	}
	return rc;
}

/* yield.xml */
int YIELD(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_system */
	/* 1101010100|L=0|op0=00|op1=011|CRn=0010|CRm=0000|op2=001|Rt=11111 */
	if((INSWORD & 0xFFFFFFFF)==0xD503203F) {
		decode_fields32(ENC_YIELD_HI_HINTS, ctx, instr);
		if(!((ctx->CRm<<3)|ctx->op2)) {
			ctx->op = SystemHintOp_NOP;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==1) {
			ctx->op = SystemHintOp_YIELD;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==2) {
			ctx->op = SystemHintOp_WFE;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==3) {
			ctx->op = SystemHintOp_WFI;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==4) {
			ctx->op = SystemHintOp_SEV;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==5) {
			ctx->op = SystemHintOp_SEVL;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==6) {
			if(!HaveDGHExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_DGH;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==7) {
			SEE /* XPACLRI */;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==8) {
			if(!ctx->op2) {
				SEE /* PACIA1716 */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIB1716 */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIA1716 */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIB1716 */;
			}
			else {
				ENDOFINSTRUCTION;
			}
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x10) {
			if(!HaveRASExt()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_ESB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x11) {
			if(!HaveStatisticalProfiling()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_PSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x12) {
			if(!HaveSelfHostedTrace()) {
				ENDOFINSTRUCTION;
			}
			ctx->op = SystemHintOp_TSB;
		}
		else if(((ctx->CRm<<3)|ctx->op2)==0x14) {
			ctx->op = SystemHintOp_CSDB;
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x78)==0x18) {
			if(!ctx->op2) {
				SEE /* PACIAZ */;
			}
			else if(ctx->op2==1) {
				SEE /* PACIASP */;
			}
			else if(ctx->op2==2) {
				SEE /* PACIBZ */;
			}
			else if(ctx->op2==3) {
				SEE /* PACIBSP */;
			}
			else if(ctx->op2==4) {
				SEE /* AUTIAZ */;
			}
			else if(ctx->op2==5) {
				SEE /* AUTHASP */;
			}
			else if(ctx->op2==6) {
				SEE /* AUTIBZ */;
			}
			else if(ctx->op2==7) {
				SEE /* AUTIBSP */;
			}
		}
		else if((((ctx->CRm<<3)|ctx->op2)&0x79)==0x20) {
			ctx->op = SystemHintOp_BTI;
			SetBTypeCompatible(BTypeCompatible_BTI(SLICE(ctx->op2,2,1), ctx->pstate_btype));
		}
		else {
			ENDOFINSTRUCTION;
		}
		OK(ENC_YIELD_HI_HINTS);
	}
	return rc;
}

/* zip1_advsimd.xml */
int ZIP1_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|001110|size=xx|0|Rm=xxxxx|0|op=0|11|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE003800) {
		decode_fields32(ENC_ZIP1_ASIMDPERM_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->part = UINT(ctx->op);
		ctx->pairs = ((2) ? ((ctx->elements) / (2)) : 0);
		OK(ENC_ZIP1_ASIMDPERM_ONLY);
	}
	return rc;
}

/* zip2_advsimd.xml */
int ZIP2_advsimd(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_advsimd */
	/* 0|Q=x|001110|size=xx|0|Rm=xxxxx|0|op=1|11|10|Rn=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xBF20FC00)==0xE007800) {
		decode_fields32(ENC_ZIP2_ASIMDPERM_ONLY, ctx, instr);
		ctx->d = UINT(ctx->Rd);
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		if(((ctx->size<<1)|ctx->Q)==6) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->datasize = (ctx->Q==1) ? 0x80 : 0x40;
		ctx->elements = ((ctx->esize) ? ((ctx->datasize) / (ctx->esize)) : 0);
		ctx->part = UINT(ctx->op);
		ctx->pairs = ((2) ? ((ctx->elements) / (2)) : 0);
		OK(ENC_ZIP2_ASIMDPERM_ONLY);
	}
	return rc;
}

/* abs_z_p_z.xml */
int abs_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|010|opc<2:1>=11|opc<0>=0|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x416A000) {
		decode_fields32(ENC_ABS_Z_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_ABS_Z_P_Z_);
	}
	return rc;
}

/* adclb_z_zzz.xml */
int adclb_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000101|0|sz=x|0|Zm=xxxxx|11010|T=0|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFA0FC00)==0x4500D000) {
		decode_fields32(ENC_ADCLB_Z_ZZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		OK(ENC_ADCLB_Z_ZZZ_);
	}
	return rc;
}

/* adclt_z_zzz.xml */
int adclt_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000101|0|sz=x|0|Zm=xxxxx|11010|T=1|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFA0FC00)==0x4500D400) {
		decode_fields32(ENC_ADCLT_Z_ZZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		OK(ENC_ADCLT_Z_ZZZ_);
	}
	return rc;
}

/* add_z_p_zz.xml */
int add_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|000|opc<2:1>=00|opc<0>=0|000|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x4000000) {
		decode_fields32(ENC_ADD_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_ADD_Z_P_ZZ_);
	}
	return rc;
}

/* add_z_zi.xml */
int add_z_zi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00100101|size=xx|100|opc<2:1>=00|opc<0>=0|11|sh=x|imm8=xxxxxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FC000)==0x2520C000) {
		decode_fields32(ENC_ADD_Z_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(((ctx->size<<1)|ctx->sh)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->dn = UINT(ctx->Zdn);
		ctx->imm = UINT(ctx->imm8);
		if(ctx->sh==1) {
			ctx->imm = (ctx->imm) << (8);
		}
		OK(ENC_ADD_Z_ZI_);
	}
	return rc;
}

/* add_z_zz.xml */
int add_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|1|Zm=xxxxx|000|opc<2:1>=00|opc<0>=0|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x4200000) {
		decode_fields32(ENC_ADD_Z_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_ADD_Z_ZZ_);
	}
	return rc;
}

/* addhnb_z_zz.xml */
int addhnb_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000101|size=xx|1|Zm=xxxxx|011|S=0|R=0|T=0|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x45206000) {
		decode_fields32(ENC_ADDHNB_Z_ZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_ADDHNB_Z_ZZ_);
	}
	return rc;
}

/* addhnt_z_zz.xml */
int addhnt_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000101|size=xx|1|Zm=xxxxx|011|S=0|R=0|T=1|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x45206400) {
		decode_fields32(ENC_ADDHNT_Z_ZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_ADDHNT_Z_ZZ_);
	}
	return rc;
}

/* addp_z_p_zz.xml */
int addp_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000100|size=xx|010|opc=00|U=1|101|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x4411A000) {
		decode_fields32(ENC_ADDP_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->m = UINT(ctx->Zm);
		ctx->dn = UINT(ctx->Zdn);
		OK(ENC_ADDP_Z_P_ZZ_);
	}
	return rc;
}

/* addpl_r_ri.xml */
int addpl_r_ri(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 000001000|op=1|1|Rn=xxxxx|01010|imm6=xxxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0F800)==0x4605000) {
		decode_fields32(ENC_ADDPL_R_RI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->d = UINT(ctx->Rd);
		ctx->imm = SInt(ctx->imm6,6);
		OK(ENC_ADDPL_R_RI_);
	}
	return rc;
}

/* addvl_r_ri.xml */
int addvl_r_ri(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 000001000|op=0|1|Rn=xxxxx|01010|imm6=xxxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFE0F800)==0x4205000) {
		decode_fields32(ENC_ADDVL_R_RI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Rn);
		ctx->d = UINT(ctx->Rd);
		ctx->imm = SInt(ctx->imm6,6);
		OK(ENC_ADDVL_R_RI_);
	}
	return rc;
}

/* adr_z_az.xml */
int adr_z_az(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_off_pkd */
	/* 00000100|1|sz=x|1|Zm=xxxxx|1010|msz=xx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFA0F000)==0x4A0A000) {
		decode_fields32(ENC_ADR_Z_AZ_SD_SAME_SCALED, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		ctx->osize = ctx->esize;
		ctx->unsigned_ = TRUE;
		ctx->mbytes = (1) << (UINT(ctx->msz));
		OK(ENC_ADR_Z_AZ_SD_SAME_SCALED);
	}
	/* class iclass_off_s_s32 */
	/* 00000100|opc=00|1|Zm=xxxxx|1010|msz=xx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFE0F000)==0x420A000) {
		decode_fields32(ENC_ADR_Z_AZ_D_S32_SCALED, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		ctx->osize = 0x20;
		ctx->unsigned_ = FALSE;
		ctx->mbytes = (1) << (UINT(ctx->msz));
		OK(ENC_ADR_Z_AZ_D_S32_SCALED);
	}
	/* class iclass_off_s_u32 */
	/* 00000100|opc=01|1|Zm=xxxxx|1010|msz=xx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFE0F000)==0x460A000) {
		decode_fields32(ENC_ADR_Z_AZ_D_U32_SCALED, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		ctx->osize = 0x20;
		ctx->unsigned_ = TRUE;
		ctx->mbytes = (1) << (UINT(ctx->msz));
		OK(ENC_ADR_Z_AZ_D_U32_SCALED);
	}
	return rc;
}

/* aesd_z_zz.xml */
int aesd_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000101|size=00|10001|op=0|11100|o2=1|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x4522E400) {
		decode_fields32(ENC_AESD_Z_ZZ_, ctx, instr);
		if(!HaveSVE2AES()) {
			UNDEFINED;
		}
		ctx->m = UINT(ctx->Zm);
		ctx->dn = UINT(ctx->Zdn);
		OK(ENC_AESD_Z_ZZ_);
	}
	return rc;
}

/* aese_z_zz.xml */
int aese_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000101|size=00|10001|op=0|11100|o2=0|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFFFFFC00)==0x4522E000) {
		decode_fields32(ENC_AESE_Z_ZZ_, ctx, instr);
		if(!HaveSVE2AES()) {
			UNDEFINED;
		}
		ctx->m = UINT(ctx->Zm);
		ctx->dn = UINT(ctx->Zdn);
		OK(ENC_AESE_Z_ZZ_);
	}
	return rc;
}

/* aesimc_z_z.xml */
int aesimc_z_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000101|size=00|10000011100|op=1|00000|Zdn=xxxxx */
	if((INSWORD & 0xFFFFFFE0)==0x4520E400) {
		decode_fields32(ENC_AESIMC_Z_Z_, ctx, instr);
		if(!HaveSVE2AES()) {
			UNDEFINED;
		}
		ctx->dn = UINT(ctx->Zdn);
		OK(ENC_AESIMC_Z_Z_);
	}
	return rc;
}

/* aesmc_z_z.xml */
int aesmc_z_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000101|size=00|10000011100|op=0|00000|Zdn=xxxxx */
	if((INSWORD & 0xFFFFFFE0)==0x4520E000) {
		decode_fields32(ENC_AESMC_Z_Z_, ctx, instr);
		if(!HaveSVE2AES()) {
			UNDEFINED;
		}
		ctx->dn = UINT(ctx->Zdn);
		OK(ENC_AESMC_Z_Z_);
	}
	return rc;
}

/* and_p_p_pp.xml */
int and_p_p_pp(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* 00100101|op=0|S=0|00|Pm=xxxx|01|Pg=xxxx|o2=0|Pn=xxxx|o3=0|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x25004000) {
		decode_fields32(ENC_AND_P_P_PP_Z, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->m = UINT(ctx->Pm);
		ctx->d = UINT(ctx->Pd);
		instr->setflags = FALSE;
		ctx->setflags = FALSE;
		/* regular aliases */
		if(ctx->S==1 && ctx->Pn==ctx->Pm) return MOVS_and_p_p_pp(ctx, instr);
		if(ctx->S==0 && ctx->Pn==ctx->Pm) return MOV_and_p_p_pp(ctx, instr);
		OK(ENC_AND_P_P_PP_Z);
	}
	/* class iclass_s */
	/* 00100101|op=0|S=1|00|Pm=xxxx|01|Pg=xxxx|o2=0|Pn=xxxx|o3=0|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x25404000) {
		decode_fields32(ENC_ANDS_P_P_PP_Z, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->m = UINT(ctx->Pm);
		ctx->d = UINT(ctx->Pd);
		instr->setflags = TRUE;
		ctx->setflags = TRUE;
		/* regular aliases */
		if(ctx->S==1 && ctx->Pn==ctx->Pm) return MOVS_and_p_p_pp(ctx, instr);
		if(ctx->S==0 && ctx->Pn==ctx->Pm) return MOV_and_p_p_pp(ctx, instr);
		OK(ENC_ANDS_P_P_PP_Z);
	}
	return rc;
}

/* and_z_p_zz.xml */
int and_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|011|opc<2:1>=01|opc<0>=0|000|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x41A0000) {
		decode_fields32(ENC_AND_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_AND_Z_P_ZZ_);
	}
	return rc;
}

/* and_z_zi.xml */
int and_z_zi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|opc=10|0000|imm13=xxxxxxxxxxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFFFC0000)==0x5800000) {
		decode_fields32(ENC_AND_Z_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->dn = UINT(ctx->Zdn);
		DecodeBitMasksCheckUndefined(SLICE(ctx->imm13,12,12),SLICE(ctx->imm13,5,0));
		DecodeBitMasks_ReturnType dbmrt = DecodeBitMasks(SLICE(ctx->imm13,12,12),SLICE(ctx->imm13,5,0),SLICE(ctx->imm13,11,6));
		ctx->imm = dbmrt.wmask;
		OK(ENC_AND_Z_ZI_);
	}
	return rc;
}

/* and_z_zz.xml */
int and_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|opc=00|1|Zm=xxxxx|001100|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x4203000) {
		decode_fields32(ENC_AND_Z_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_AND_Z_ZZ_);
	}
	return rc;
}

/* andv_r_p_z.xml */
int andv_r_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|0110|opc=10|001|Pg=xxx|Zn=xxxxx|Vd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x41A2000) {
		decode_fields32(ENC_ANDV_R_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Vd);
		OK(ENC_ANDV_R_P_Z_);
	}
	return rc;
}

/* asr_z_p_zi.xml */
int asr_z_p_zi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|tszh=xx|00|opc=00|L=0|U=0|100|Pg=xxx|tszl=xx|imm3=xxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x4008000) {
		decode_fields32(ENC_ASR_Z_P_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->tsize = ((ctx->tszh<<2)|ctx->tszl);
		if(!ctx->tsize) {
			UNDEFINED;
		}
		else if(ctx->tsize==1) {
			ctx->esize = 8;
		}
		else if((ctx->tsize&14)==2) {
			ctx->esize = 0x10;
		}
		else if((ctx->tsize&12)==4) {
			ctx->esize = 0x20;
		}
		else if((ctx->tsize&8)==8) {
			ctx->esize = 0x40;
		}
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->tsize<<3)|ctx->imm3));
		OK(ENC_ASR_Z_P_ZI_);
	}
	return rc;
}

/* asr_z_p_zw.xml */
int asr_z_p_zw(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|011|R=0|L=0|U=0|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x4188000) {
		decode_fields32(ENC_ASR_Z_P_ZW_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_ASR_Z_P_ZW_);
	}
	return rc;
}

/* asr_z_p_zz.xml */
int asr_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|010|R=0|L=0|U=0|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x4108000) {
		decode_fields32(ENC_ASR_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_ASR_Z_P_ZZ_);
	}
	return rc;
}

/* asr_z_zi.xml */
int asr_z_zi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|tszh=xx|1|tszl=xx|imm3=xxx|1001|0|U=0|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x4209000) {
		decode_fields32(ENC_ASR_Z_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->tsize = ((ctx->tszh<<2)|ctx->tszl);
		if(!ctx->tsize) {
			UNDEFINED;
		}
		else if(ctx->tsize==1) {
			ctx->esize = 8;
		}
		else if((ctx->tsize&14)==2) {
			ctx->esize = 0x10;
		}
		else if((ctx->tsize&12)==4) {
			ctx->esize = 0x20;
		}
		else if((ctx->tsize&8)==8) {
			ctx->esize = 0x40;
		}
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->tsize<<3)|ctx->imm3));
		OK(ENC_ASR_Z_ZI_);
	}
	return rc;
}

/* asr_z_zw.xml */
int asr_z_zw(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|1|Zm=xxxxx|1000|0|U=0|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x4208000) {
		decode_fields32(ENC_ASR_Z_ZW_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_ASR_Z_ZW_);
	}
	return rc;
}

/* asrd_z_p_zi.xml */
int asrd_z_p_zi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|tszh=xx|00|opc=01|L=0|U=0|100|Pg=xxx|tszl=xx|imm3=xxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x4048000) {
		decode_fields32(ENC_ASRD_Z_P_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->tsize = ((ctx->tszh<<2)|ctx->tszl);
		if(!ctx->tsize) {
			UNDEFINED;
		}
		else if(ctx->tsize==1) {
			ctx->esize = 8;
		}
		else if((ctx->tsize&14)==2) {
			ctx->esize = 0x10;
		}
		else if((ctx->tsize&12)==4) {
			ctx->esize = 0x20;
		}
		else if((ctx->tsize&8)==8) {
			ctx->esize = 0x40;
		}
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->shift = ((2) * (ctx->esize))-UINT(((ctx->tsize<<3)|ctx->imm3));
		OK(ENC_ASRD_Z_P_ZI_);
	}
	return rc;
}

/* asrr_z_p_zz.xml */
int asrr_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|010|R=1|L=0|U=0|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x4148000) {
		decode_fields32(ENC_ASRR_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_ASRR_Z_P_ZZ_);
	}
	return rc;
}

/* bcax_z_zzz.xml */
int bcax_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 00000100|opc=01|1|Zm=xxxxx|00111|o2=0|Zk=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x4603800) {
		decode_fields32(ENC_BCAX_Z_ZZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->m = UINT(ctx->Zm);
		ctx->k = UINT(ctx->Zk);
		ctx->dn = UINT(ctx->Zdn);
		OK(ENC_BCAX_Z_ZZZ_);
	}
	return rc;
}

/* bdep_z_zz.xml */
int bdep_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000101|size=xx|0|Zm=xxxxx|1011|opc=01|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x4500B400) {
		decode_fields32(ENC_BDEP_Z_ZZ_, ctx, instr);
		if(!HaveSVE2BitPerm()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_BDEP_Z_ZZ_);
	}
	return rc;
}

/* bext_z_zz.xml */
int bext_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000101|size=xx|0|Zm=xxxxx|1011|opc=00|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x4500B000) {
		decode_fields32(ENC_BEXT_Z_ZZ_, ctx, instr);
		if(!HaveSVE2BitPerm()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_BEXT_Z_ZZ_);
	}
	return rc;
}

/* bfcvt_z_p_z.xml */
int bfcvt_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|opc=10|0010|opc2=10|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x658AA000) {
		decode_fields32(ENC_BFCVT_Z_P_Z_S2BF, ctx, instr);
		if(!HaveSVE() || !HaveBF16Ext()) {
			UNDEFINED;
		}
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_BFCVT_Z_P_Z_S2BF);
	}
	return rc;
}

/* bfcvtnt_z_p_z.xml */
int bfcvtnt_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100100|opc=10|0010|opc2=10|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x648AA000) {
		decode_fields32(ENC_BFCVTNT_Z_P_Z_S2BF, ctx, instr);
		if(!HaveSVE() || !HaveBF16Ext()) {
			UNDEFINED;
		}
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_BFCVTNT_Z_P_Z_S2BF);
	}
	return rc;
}

/* bfdot_z_zzz.xml */
int bfdot_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 011001000|op=1|1|Zm=xxxxx|100000|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x64608000) {
		decode_fields32(ENC_BFDOT_Z_ZZZ_, ctx, instr);
		if(!HaveSVE() || !HaveBF16Ext()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		OK(ENC_BFDOT_Z_ZZZ_);
	}
	return rc;
}

/* bfdot_z_zzzi.xml */
int bfdot_z_zzzi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 011001000|op=1|1|i2=xx|Zm=xxx|010000|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x64604000) {
		decode_fields32(ENC_BFDOT_Z_ZZZI_, ctx, instr);
		if(!HaveSVE() || !HaveBF16Ext()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->index = UINT(ctx->i2);
		OK(ENC_BFDOT_Z_ZZZI_);
	}
	return rc;
}

/* bfmlalb_z_zzz.xml */
int bfmlalb_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 011001001|o2=1|1|Zm=xxxxx|10|op=0|00|T=0|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x64E08000) {
		decode_fields32(ENC_BFMLALB_Z_ZZZ_, ctx, instr);
		if(!HaveSVE() || !HaveBF16Ext()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		OK(ENC_BFMLALB_Z_ZZZ_);
	}
	return rc;
}

/* bfmlalb_z_zzzi.xml */
int bfmlalb_z_zzzi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 011001001|o2=1|1|i3h=xx|Zm=xxx|01|op=0|0|i3l=x|T=0|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0F400)==0x64E04000) {
		decode_fields32(ENC_BFMLALB_Z_ZZZI_, ctx, instr);
		if(!HaveSVE() || !HaveBF16Ext()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->index = UINT(((ctx->i3h<<1)|ctx->i3l));
		OK(ENC_BFMLALB_Z_ZZZI_);
	}
	return rc;
}

/* bfmlalt_z_zzz.xml */
int bfmlalt_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 011001001|o2=1|1|Zm=xxxxx|10|op=0|00|T=1|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x64E08400) {
		decode_fields32(ENC_BFMLALT_Z_ZZZ_, ctx, instr);
		if(!HaveSVE() || !HaveBF16Ext()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		OK(ENC_BFMLALT_Z_ZZZ_);
	}
	return rc;
}

/* bfmlalt_z_zzzi.xml */
int bfmlalt_z_zzzi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 011001001|o2=1|1|i3h=xx|Zm=xxx|01|op=0|0|i3l=x|T=1|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0F400)==0x64E04400) {
		decode_fields32(ENC_BFMLALT_Z_ZZZI_, ctx, instr);
		if(!HaveSVE() || !HaveBF16Ext()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->index = UINT(((ctx->i3h<<1)|ctx->i3l));
		OK(ENC_BFMLALT_Z_ZZZI_);
	}
	return rc;
}

/* bfmmla_z_zzz.xml */
int bfmmla_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100100|opc=01|1|Zm=xxxxx|111001|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x6460E400) {
		decode_fields32(ENC_BFMMLA_Z_ZZZ_, ctx, instr);
		if(!HaveSVE() || !HaveBF16Ext()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		OK(ENC_BFMMLA_Z_ZZZ_);
	}
	return rc;
}

/* bgrp_z_zz.xml */
int bgrp_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000101|size=xx|0|Zm=xxxxx|1011|opc=10|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x4500B800) {
		decode_fields32(ENC_BGRP_Z_ZZ_, ctx, instr);
		if(!HaveSVE2BitPerm()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_BGRP_Z_ZZ_);
	}
	return rc;
}

/* bic_p_p_pp.xml */
int bic_p_p_pp(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* 00100101|op=0|S=0|00|Pm=xxxx|01|Pg=xxxx|o2=0|Pn=xxxx|o3=1|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x25004010) {
		decode_fields32(ENC_BIC_P_P_PP_Z, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->m = UINT(ctx->Pm);
		ctx->d = UINT(ctx->Pd);
		instr->setflags = FALSE;
		ctx->setflags = FALSE;
		OK(ENC_BIC_P_P_PP_Z);
	}
	/* class iclass_s */
	/* 00100101|op=0|S=1|00|Pm=xxxx|01|Pg=xxxx|o2=0|Pn=xxxx|o3=1|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x25404010) {
		decode_fields32(ENC_BICS_P_P_PP_Z, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->m = UINT(ctx->Pm);
		ctx->d = UINT(ctx->Pd);
		instr->setflags = TRUE;
		ctx->setflags = TRUE;
		OK(ENC_BICS_P_P_PP_Z);
	}
	return rc;
}

/* bic_z_p_zz.xml */
int bic_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|011|opc<2:1>=01|opc<0>=1|000|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x41B0000) {
		decode_fields32(ENC_BIC_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_BIC_Z_P_ZZ_);
	}
	return rc;
}

/* bic_z_zz.xml */
int bic_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|opc=11|1|Zm=xxxxx|001100|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x4E03000) {
		decode_fields32(ENC_BIC_Z_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_BIC_Z_ZZ_);
	}
	return rc;
}

/* brka_p_p_p.xml */
int brka_p_p_p(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* 00100101|B=0|S=0|01000001|Pg=xxxx|0|Pn=xxxx|M=x|Pd=xxxx */
	if((INSWORD & 0xFFFFC200)==0x25104000) {
		decode_fields32(ENC_BRKA_P_P_P_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->d = UINT(ctx->Pd);
		ctx->merging = (ctx->M==1);
		instr->setflags = FALSE;
		ctx->setflags = FALSE;
		OK(ENC_BRKA_P_P_P_);
	}
	/* class iclass_s */
	/* 00100101|B=0|S=1|01000001|Pg=xxxx|0|Pn=xxxx|M=0|Pd=xxxx */
	if((INSWORD & 0xFFFFC210)==0x25504000) {
		decode_fields32(ENC_BRKAS_P_P_P_Z, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->d = UINT(ctx->Pd);
		ctx->merging = FALSE;
		instr->setflags = TRUE;
		ctx->setflags = TRUE;
		OK(ENC_BRKAS_P_P_P_Z);
	}
	return rc;
}

/* brkb_p_p_p.xml */
int brkb_p_p_p(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* 00100101|B=1|S=0|01000001|Pg=xxxx|0|Pn=xxxx|M=x|Pd=xxxx */
	if((INSWORD & 0xFFFFC200)==0x25904000) {
		decode_fields32(ENC_BRKB_P_P_P_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->d = UINT(ctx->Pd);
		ctx->merging = (ctx->M==1);
		instr->setflags = FALSE;
		ctx->setflags = FALSE;
		OK(ENC_BRKB_P_P_P_);
	}
	/* class iclass_s */
	/* 00100101|B=1|S=1|01000001|Pg=xxxx|0|Pn=xxxx|M=0|Pd=xxxx */
	if((INSWORD & 0xFFFFC210)==0x25D04000) {
		decode_fields32(ENC_BRKBS_P_P_P_Z, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->d = UINT(ctx->Pd);
		ctx->merging = FALSE;
		instr->setflags = TRUE;
		ctx->setflags = TRUE;
		OK(ENC_BRKBS_P_P_P_Z);
	}
	return rc;
}

/* brkn_p_p_pp.xml */
int brkn_p_p_pp(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* 001001010|S=0|01100001|Pg=xxxx|0|Pn=xxxx|0|Pdm=xxxx */
	if((INSWORD & 0xFFFFC210)==0x25184000) {
		decode_fields32(ENC_BRKN_P_P_PP_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->dm = UINT(ctx->Pdm);
		instr->setflags = FALSE;
		ctx->setflags = FALSE;
		OK(ENC_BRKN_P_P_PP_);
	}
	/* class iclass_s */
	/* 001001010|S=1|01100001|Pg=xxxx|0|Pn=xxxx|0|Pdm=xxxx */
	if((INSWORD & 0xFFFFC210)==0x25584000) {
		decode_fields32(ENC_BRKNS_P_P_PP_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->dm = UINT(ctx->Pdm);
		instr->setflags = TRUE;
		ctx->setflags = TRUE;
		OK(ENC_BRKNS_P_P_PP_);
	}
	return rc;
}

/* brkpa_p_p_pp.xml */
int brkpa_p_p_pp(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* 00100101|op=0|S=0|00|Pm=xxxx|11|Pg=xxxx|0|Pn=xxxx|B=0|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x2500C000) {
		decode_fields32(ENC_BRKPA_P_P_PP_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->m = UINT(ctx->Pm);
		ctx->d = UINT(ctx->Pd);
		instr->setflags = FALSE;
		ctx->setflags = FALSE;
		OK(ENC_BRKPA_P_P_PP_);
	}
	/* class iclass_s */
	/* 00100101|op=0|S=1|00|Pm=xxxx|11|Pg=xxxx|0|Pn=xxxx|B=0|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x2540C000) {
		decode_fields32(ENC_BRKPAS_P_P_PP_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->m = UINT(ctx->Pm);
		ctx->d = UINT(ctx->Pd);
		instr->setflags = TRUE;
		ctx->setflags = TRUE;
		OK(ENC_BRKPAS_P_P_PP_);
	}
	return rc;
}

/* brkpb_p_p_pp.xml */
int brkpb_p_p_pp(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* 00100101|op=0|S=0|00|Pm=xxxx|11|Pg=xxxx|0|Pn=xxxx|B=1|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x2500C010) {
		decode_fields32(ENC_BRKPB_P_P_PP_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->m = UINT(ctx->Pm);
		ctx->d = UINT(ctx->Pd);
		instr->setflags = FALSE;
		ctx->setflags = FALSE;
		OK(ENC_BRKPB_P_P_PP_);
	}
	/* class iclass_s */
	/* 00100101|op=0|S=1|00|Pm=xxxx|11|Pg=xxxx|0|Pn=xxxx|B=1|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x2540C010) {
		decode_fields32(ENC_BRKPBS_P_P_PP_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->m = UINT(ctx->Pm);
		ctx->d = UINT(ctx->Pd);
		instr->setflags = TRUE;
		ctx->setflags = TRUE;
		OK(ENC_BRKPBS_P_P_PP_);
	}
	return rc;
}

/* bsl1n_z_zzz.xml */
int bsl1n_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 00000100|opc=01|1|Zm=xxxxx|00111|o2=1|Zk=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x4603C00) {
		decode_fields32(ENC_BSL1N_Z_ZZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->m = UINT(ctx->Zm);
		ctx->k = UINT(ctx->Zk);
		ctx->dn = UINT(ctx->Zdn);
		OK(ENC_BSL1N_Z_ZZZ_);
	}
	return rc;
}

/* bsl2n_z_zzz.xml */
int bsl2n_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 00000100|opc=10|1|Zm=xxxxx|00111|o2=1|Zk=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x4A03C00) {
		decode_fields32(ENC_BSL2N_Z_ZZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->m = UINT(ctx->Zm);
		ctx->k = UINT(ctx->Zk);
		ctx->dn = UINT(ctx->Zdn);
		OK(ENC_BSL2N_Z_ZZZ_);
	}
	return rc;
}

/* bsl_z_zzz.xml */
int bsl_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 00000100|opc=00|1|Zm=xxxxx|00111|o2=1|Zk=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x4203C00) {
		decode_fields32(ENC_BSL_Z_ZZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->m = UINT(ctx->Zm);
		ctx->k = UINT(ctx->Zk);
		ctx->dn = UINT(ctx->Zdn);
		OK(ENC_BSL_Z_ZZZ_);
	}
	return rc;
}

/* cadd_z_zz.xml */
int cadd_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000101|size=xx|00000|op=0|11011|rot=x|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FF800)==0x4500D800) {
		decode_fields32(ENC_CADD_Z_ZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->m = UINT(ctx->Zm);
		ctx->dn = UINT(ctx->Zdn);
		ctx->sub_i = (ctx->rot==0);
		ctx->sub_r = (ctx->rot==1);
		OK(ENC_CADD_Z_ZZ_);
	}
	return rc;
}

/* cdot_z_zzz.xml */
int cdot_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000100|size=xx|0|Zm=xxxxx|0001|rot=xx|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFF20F000)==0x44001000) {
		decode_fields32(ENC_CDOT_Z_ZZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		if(!(ctx->size&2)) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->sel_a = UINT(SLICE(ctx->rot,0,0));
		ctx->sel_b = UINT(NOT(SLICE(ctx->rot,0,0),1));
		ctx->sub_i = (SLICE(ctx->rot,0,0)==SLICE(ctx->rot,1,1));
		OK(ENC_CDOT_Z_ZZZ_);
	}
	return rc;
}

/* cdot_z_zzzi.xml */
int cdot_z_zzzi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_of_words */
	/* 01000100|size=10|1|i2=xx|Zm=xxx|0100|rot=xx|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0F000)==0x44A04000) {
		decode_fields32(ENC_CDOT_Z_ZZZI_S, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->index = UINT(ctx->i2);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->sel_a = UINT(SLICE(ctx->rot,0,0));
		ctx->sel_b = UINT(NOT(SLICE(ctx->rot,0,0),1));
		ctx->sub_i = (SLICE(ctx->rot,0,0)==SLICE(ctx->rot,1,1));
		OK(ENC_CDOT_Z_ZZZI_S);
	}
	/* class iclass_of_doublewords */
	/* 01000100|size=11|1|i1=x|Zm=xxxx|0100|rot=xx|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0F000)==0x44E04000) {
		decode_fields32(ENC_CDOT_Z_ZZZI_D, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->index = UINT(ctx->i1);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->sel_a = UINT(SLICE(ctx->rot,0,0));
		ctx->sel_b = UINT(NOT(SLICE(ctx->rot,0,0),1));
		ctx->sub_i = (SLICE(ctx->rot,0,0)==SLICE(ctx->rot,1,1));
		OK(ENC_CDOT_Z_ZZZI_D);
	}
	return rc;
}

/* clasta_r_p_z.xml */
int clasta_r_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|11000|B=0|101|Pg=xxx|Zm=xxxxx|Rdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x530A000) {
		decode_fields32(ENC_CLASTA_R_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Rdn);
		ctx->m = UINT(ctx->Zm);
		ctx->csize = (ctx->esize<0x40) ? 0x20 : 0x40;
		ctx->isBefore = FALSE;
		OK(ENC_CLASTA_R_P_Z_);
	}
	return rc;
}

/* clasta_v_p_z.xml */
int clasta_v_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|10101|B=0|100|Pg=xxx|Zm=xxxxx|Vdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x52A8000) {
		decode_fields32(ENC_CLASTA_V_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Vdn);
		ctx->m = UINT(ctx->Zm);
		ctx->isBefore = FALSE;
		OK(ENC_CLASTA_V_P_Z_);
	}
	return rc;
}

/* clasta_z_p_zz.xml */
int clasta_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|10100|B=0|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x5288000) {
		decode_fields32(ENC_CLASTA_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		ctx->isBefore = FALSE;
		OK(ENC_CLASTA_Z_P_ZZ_);
	}
	return rc;
}

/* clastb_r_p_z.xml */
int clastb_r_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|11000|B=1|101|Pg=xxx|Zm=xxxxx|Rdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x531A000) {
		decode_fields32(ENC_CLASTB_R_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Rdn);
		ctx->m = UINT(ctx->Zm);
		ctx->csize = (ctx->esize<0x40) ? 0x20 : 0x40;
		ctx->isBefore = TRUE;
		OK(ENC_CLASTB_R_P_Z_);
	}
	return rc;
}

/* clastb_v_p_z.xml */
int clastb_v_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|10101|B=1|100|Pg=xxx|Zm=xxxxx|Vdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x52B8000) {
		decode_fields32(ENC_CLASTB_V_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Vdn);
		ctx->m = UINT(ctx->Zm);
		ctx->isBefore = TRUE;
		OK(ENC_CLASTB_V_P_Z_);
	}
	return rc;
}

/* clastb_z_p_zz.xml */
int clastb_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|10100|B=1|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x5298000) {
		decode_fields32(ENC_CLASTB_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		ctx->isBefore = TRUE;
		OK(ENC_CLASTB_Z_P_ZZ_);
	}
	return rc;
}

/* cls_z_p_z.xml */
int cls_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|011|opc<2:1>=00|opc<0>=0|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x418A000) {
		decode_fields32(ENC_CLS_Z_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_CLS_Z_P_Z_);
	}
	return rc;
}

/* clz_z_p_z.xml */
int clz_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|011|opc<2:1>=00|opc<0>=1|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x419A000) {
		decode_fields32(ENC_CLZ_Z_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_CLZ_Z_P_Z_);
	}
	return rc;
}

/* cmla_z_zzz.xml */
int cmla_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000100|size=xx|0|Zm=xxxxx|001|op=0|rot=xx|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFF20F000)==0x44002000) {
		decode_fields32(ENC_CMLA_Z_ZZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->sel_a = UINT(SLICE(ctx->rot,0,0));
		ctx->sel_b = UINT(NOT(SLICE(ctx->rot,0,0),1));
		ctx->sub_r = (SLICE(ctx->rot,0,0)!=SLICE(ctx->rot,1,1));
		ctx->sub_i = (SLICE(ctx->rot,1,1)==1);
		OK(ENC_CMLA_Z_ZZZ_);
	}
	return rc;
}

/* cmla_z_zzzi.xml */
int cmla_z_zzzi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_of_halfwords */
	/* 01000100|size=10|1|i2=xx|Zm=xxx|0110|rot=xx|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0F000)==0x44A06000) {
		decode_fields32(ENC_CMLA_Z_ZZZI_H, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x10;
		ctx->index = UINT(ctx->i2);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->sel_a = UINT(SLICE(ctx->rot,0,0));
		ctx->sel_b = UINT(NOT(SLICE(ctx->rot,0,0),1));
		ctx->sub_r = (SLICE(ctx->rot,0,0)!=SLICE(ctx->rot,1,1));
		ctx->sub_i = (SLICE(ctx->rot,1,1)==1);
		OK(ENC_CMLA_Z_ZZZI_H);
	}
	/* class iclass_of_words */
	/* 01000100|size=11|1|i1=x|Zm=xxxx|0110|rot=xx|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0F000)==0x44E06000) {
		decode_fields32(ENC_CMLA_Z_ZZZI_S, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->index = UINT(ctx->i1);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->sel_a = UINT(SLICE(ctx->rot,0,0));
		ctx->sel_b = UINT(NOT(SLICE(ctx->rot,0,0),1));
		ctx->sub_r = (SLICE(ctx->rot,0,0)!=SLICE(ctx->rot,1,1));
		ctx->sub_i = (SLICE(ctx->rot,1,1)==1);
		OK(ENC_CMLA_Z_ZZZI_S);
	}
	return rc;
}

/* cmpeq_p_p_zi.xml */
int cmpeq_p_p_zi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_eq */
	/* 00100101|size=xx|0|imm5=xxxxx|op=1|0|o2=0|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x25008000) {
		decode_fields32(ENC_CMPEQ_P_P_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_EQ;
		ctx->imm = SInt(ctx->imm5,5);
		ctx->unsigned_ = FALSE;
		OK(ENC_CMPEQ_P_P_ZI_);
	}
	/* class iclass_gt */
	/* 00100101|size=xx|0|imm5=xxxxx|op=0|0|lt=0|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x25000010) {
		decode_fields32(ENC_CMPGT_P_P_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GT;
		ctx->imm = SInt(ctx->imm5,5);
		ctx->unsigned_ = FALSE;
		OK(ENC_CMPGT_P_P_ZI_);
	}
	/* class iclass_ge */
	/* 00100101|size=xx|0|imm5=xxxxx|op=0|0|lt=0|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x25000000) {
		decode_fields32(ENC_CMPGE_P_P_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GE;
		ctx->imm = SInt(ctx->imm5,5);
		ctx->unsigned_ = FALSE;
		OK(ENC_CMPGE_P_P_ZI_);
	}
	/* class iclass_hi */
	/* 00100100|size=xx|1|imm7=xxxxxxx|lt=0|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF202010)==0x24200010) {
		decode_fields32(ENC_CMPHI_P_P_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GT;
		ctx->imm = UINT(ctx->imm7);
		ctx->unsigned_ = TRUE;
		OK(ENC_CMPHI_P_P_ZI_);
	}
	/* class iclass_hs */
	/* 00100100|size=xx|1|imm7=xxxxxxx|lt=0|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF202010)==0x24200000) {
		decode_fields32(ENC_CMPHS_P_P_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GE;
		ctx->imm = UINT(ctx->imm7);
		ctx->unsigned_ = TRUE;
		OK(ENC_CMPHS_P_P_ZI_);
	}
	/* class iclass_lt */
	/* 00100101|size=xx|0|imm5=xxxxx|op=0|0|lt=1|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x25002000) {
		decode_fields32(ENC_CMPLT_P_P_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_LT;
		ctx->imm = SInt(ctx->imm5,5);
		ctx->unsigned_ = FALSE;
		OK(ENC_CMPLT_P_P_ZI_);
	}
	/* class iclass_le */
	/* 00100101|size=xx|0|imm5=xxxxx|op=0|0|lt=1|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x25002010) {
		decode_fields32(ENC_CMPLE_P_P_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_LE;
		ctx->imm = SInt(ctx->imm5,5);
		ctx->unsigned_ = FALSE;
		OK(ENC_CMPLE_P_P_ZI_);
	}
	/* class iclass_lo */
	/* 00100100|size=xx|1|imm7=xxxxxxx|lt=1|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF202010)==0x24202000) {
		decode_fields32(ENC_CMPLO_P_P_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_LT;
		ctx->imm = UINT(ctx->imm7);
		ctx->unsigned_ = TRUE;
		OK(ENC_CMPLO_P_P_ZI_);
	}
	/* class iclass_ls */
	/* 00100100|size=xx|1|imm7=xxxxxxx|lt=1|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF202010)==0x24202010) {
		decode_fields32(ENC_CMPLS_P_P_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_LE;
		ctx->imm = UINT(ctx->imm7);
		ctx->unsigned_ = TRUE;
		OK(ENC_CMPLS_P_P_ZI_);
	}
	/* class iclass_ne */
	/* 00100101|size=xx|0|imm5=xxxxx|op=1|0|o2=0|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x25008010) {
		decode_fields32(ENC_CMPNE_P_P_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_NE;
		ctx->imm = SInt(ctx->imm5,5);
		ctx->unsigned_ = FALSE;
		OK(ENC_CMPNE_P_P_ZI_);
	}
	return rc;
}

/* cmpeq_p_p_zw.xml */
int cmpeq_p_p_zw(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_eq */
	/* 00100100|size=xx|0|Zm=xxxxx|op=0|0|o2=1|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x24002000) {
		decode_fields32(ENC_CMPEQ_P_P_ZW_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_EQ;
		ctx->unsigned_ = FALSE;
		OK(ENC_CMPEQ_P_P_ZW_);
	}
	/* class iclass_gt */
	/* 00100100|size=xx|0|Zm=xxxxx|U=0|1|lt=0|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x24004010) {
		decode_fields32(ENC_CMPGT_P_P_ZW_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GT;
		ctx->unsigned_ = FALSE;
		OK(ENC_CMPGT_P_P_ZW_);
	}
	/* class iclass_ge */
	/* 00100100|size=xx|0|Zm=xxxxx|U=0|1|lt=0|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x24004000) {
		decode_fields32(ENC_CMPGE_P_P_ZW_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GE;
		ctx->unsigned_ = FALSE;
		OK(ENC_CMPGE_P_P_ZW_);
	}
	/* class iclass_hi */
	/* 00100100|size=xx|0|Zm=xxxxx|U=1|1|lt=0|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x2400C010) {
		decode_fields32(ENC_CMPHI_P_P_ZW_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GT;
		ctx->unsigned_ = TRUE;
		OK(ENC_CMPHI_P_P_ZW_);
	}
	/* class iclass_hs */
	/* 00100100|size=xx|0|Zm=xxxxx|U=1|1|lt=0|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x2400C000) {
		decode_fields32(ENC_CMPHS_P_P_ZW_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GE;
		ctx->unsigned_ = TRUE;
		OK(ENC_CMPHS_P_P_ZW_);
	}
	/* class iclass_lt */
	/* 00100100|size=xx|0|Zm=xxxxx|U=0|1|lt=1|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x24006000) {
		decode_fields32(ENC_CMPLT_P_P_ZW_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_LT;
		ctx->unsigned_ = FALSE;
		OK(ENC_CMPLT_P_P_ZW_);
	}
	/* class iclass_le */
	/* 00100100|size=xx|0|Zm=xxxxx|U=0|1|lt=1|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x24006010) {
		decode_fields32(ENC_CMPLE_P_P_ZW_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_LE;
		ctx->unsigned_ = FALSE;
		OK(ENC_CMPLE_P_P_ZW_);
	}
	/* class iclass_lo */
	/* 00100100|size=xx|0|Zm=xxxxx|U=1|1|lt=1|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x2400E000) {
		decode_fields32(ENC_CMPLO_P_P_ZW_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_LT;
		ctx->unsigned_ = TRUE;
		OK(ENC_CMPLO_P_P_ZW_);
	}
	/* class iclass_ls */
	/* 00100100|size=xx|0|Zm=xxxxx|U=1|1|lt=1|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x2400E010) {
		decode_fields32(ENC_CMPLS_P_P_ZW_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_LE;
		ctx->unsigned_ = TRUE;
		OK(ENC_CMPLS_P_P_ZW_);
	}
	/* class iclass_ne */
	/* 00100100|size=xx|0|Zm=xxxxx|op=0|0|o2=1|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x24002010) {
		decode_fields32(ENC_CMPNE_P_P_ZW_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==3) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_NE;
		ctx->unsigned_ = FALSE;
		OK(ENC_CMPNE_P_P_ZW_);
	}
	return rc;
}

/* cmpeq_p_p_zz.xml */
int cmpeq_p_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_eq */
	/* 00100100|size=xx|0|Zm=xxxxx|op=1|0|o2=1|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x2400A000) {
		decode_fields32(ENC_CMPEQ_P_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_EQ;
		ctx->unsigned_ = FALSE;
		OK(ENC_CMPEQ_P_P_ZZ_);
	}
	/* class iclass_gt */
	/* 00100100|size=xx|0|Zm=xxxxx|op=1|0|o2=0|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x24008010) {
		decode_fields32(ENC_CMPGT_P_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GT;
		ctx->unsigned_ = FALSE;
		OK(ENC_CMPGT_P_P_ZZ_);
	}
	/* class iclass_ge */
	/* 00100100|size=xx|0|Zm=xxxxx|op=1|0|o2=0|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x24008000) {
		decode_fields32(ENC_CMPGE_P_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GE;
		ctx->unsigned_ = FALSE;
		OK(ENC_CMPGE_P_P_ZZ_);
	}
	/* class iclass_hi */
	/* 00100100|size=xx|0|Zm=xxxxx|op=0|0|o2=0|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x24000010) {
		decode_fields32(ENC_CMPHI_P_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GT;
		ctx->unsigned_ = TRUE;
		OK(ENC_CMPHI_P_P_ZZ_);
	}
	/* class iclass_hs */
	/* 00100100|size=xx|0|Zm=xxxxx|op=0|0|o2=0|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x24000000) {
		decode_fields32(ENC_CMPHS_P_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GE;
		ctx->unsigned_ = TRUE;
		OK(ENC_CMPHS_P_P_ZZ_);
	}
	/* class iclass_ne */
	/* 00100100|size=xx|0|Zm=xxxxx|op=1|0|o2=1|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x2400A010) {
		decode_fields32(ENC_CMPNE_P_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_NE;
		ctx->unsigned_ = FALSE;
		OK(ENC_CMPNE_P_P_ZZ_);
	}
	return rc;
}

/* cnot_z_p_z.xml */
int cnot_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|011|opc<2:1>=01|opc<0>=1|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x41BA000) {
		decode_fields32(ENC_CNOT_Z_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_CNOT_Z_P_Z_);
	}
	return rc;
}

/* cnt_z_p_z.xml */
int cnt_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|011|opc<2:1>=01|opc<0>=0|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x41AA000) {
		decode_fields32(ENC_CNT_Z_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_CNT_Z_P_Z_);
	}
	return rc;
}

/* cntb_r_s.xml */
int cntb_r_s(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_esize_byte */
	/* 00000100|size=00|10|imm4=xxxx|11100|op=0|pattern=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFF0FC00)==0x420E000) {
		decode_fields32(ENC_CNTB_R_S_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->d = UINT(ctx->Rd);
		ctx->pat = ctx->pattern;
		ctx->imm = UINT(ctx->imm4)+1;
		OK(ENC_CNTB_R_S_);
	}
	/* class iclass_esize_doubleword */
	/* 00000100|size=11|10|imm4=xxxx|11100|op=0|pattern=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFF0FC00)==0x4E0E000) {
		decode_fields32(ENC_CNTD_R_S_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->d = UINT(ctx->Rd);
		ctx->pat = ctx->pattern;
		ctx->imm = UINT(ctx->imm4)+1;
		OK(ENC_CNTD_R_S_);
	}
	/* class iclass_esize_halfword */
	/* 00000100|size=01|10|imm4=xxxx|11100|op=0|pattern=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFF0FC00)==0x460E000) {
		decode_fields32(ENC_CNTH_R_S_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x10;
		ctx->d = UINT(ctx->Rd);
		ctx->pat = ctx->pattern;
		ctx->imm = UINT(ctx->imm4)+1;
		OK(ENC_CNTH_R_S_);
	}
	/* class iclass_esize_word */
	/* 00000100|size=10|10|imm4=xxxx|11100|op=0|pattern=xxxxx|Rd=xxxxx */
	if((INSWORD & 0xFFF0FC00)==0x4A0E000) {
		decode_fields32(ENC_CNTW_R_S_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->d = UINT(ctx->Rd);
		ctx->pat = ctx->pattern;
		ctx->imm = UINT(ctx->imm4)+1;
		OK(ENC_CNTW_R_S_);
	}
	return rc;
}

/* cntp_r_p_p.xml */
int cntp_r_p_p(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00100101|size=xx|100|opc<2:1>=00|opc<0>=0|10|Pg=xxxx|0|Pn=xxxx|Rd=xxxxx */
	if((INSWORD & 0xFF3FC200)==0x25208000) {
		decode_fields32(ENC_CNTP_R_P_P_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->d = UINT(ctx->Rd);
		OK(ENC_CNTP_R_P_P_);
	}
	return rc;
}

/* compact_z_p_z.xml */
int compact_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|100001100|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x5218000) {
		decode_fields32(ENC_COMPACT_Z_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(!(ctx->size&2)) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_COMPACT_Z_P_Z_);
	}
	return rc;
}

/* cpy_z_o_i.xml */
int cpy_z_o_i(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|01|Pg=xxxx|0|M=0|sh=x|imm8=xxxxxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF30C000)==0x5100000) {
		decode_fields32(ENC_CPY_Z_O_I_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(((ctx->size<<1)|ctx->sh)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->d = UINT(ctx->Zd);
		ctx->merging = FALSE;
		ctx->imm = SInt(ctx->imm8,8);
		if(ctx->sh==1) {
			ctx->imm = (ctx->imm) << (8);
		}
		/* unconditional alias */
		if(MOV_cpy_z_o_i(ctx, instr)==0) return 0;
		OK(ENC_CPY_Z_O_I_);
	}
	return rc;
}

/* cpy_z_p_i.xml */
int cpy_z_p_i(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|01|Pg=xxxx|0|M=1|sh=x|imm8=xxxxxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF30C000)==0x5104000) {
		decode_fields32(ENC_CPY_Z_P_I_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(((ctx->size<<1)|ctx->sh)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->d = UINT(ctx->Zd);
		ctx->merging = TRUE;
		ctx->imm = SInt(ctx->imm8,8);
		if(ctx->sh==1) {
			ctx->imm = (ctx->imm) << (8);
		}
		/* unconditional alias */
		if(MOV_cpy_z_p_i(ctx, instr)==0) return 0;
		OK(ENC_CPY_Z_P_I_);
	}
	return rc;
}

/* cpy_z_p_r.xml */
int cpy_z_p_r(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|101000101|Pg=xxx|Rn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x528A000) {
		decode_fields32(ENC_CPY_Z_P_R_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Rn);
		ctx->d = UINT(ctx->Zd);
		/* unconditional alias */
		if(MOV_cpy_z_p_r(ctx, instr)==0) return 0;
		OK(ENC_CPY_Z_P_R_);
	}
	return rc;
}

/* cpy_z_p_v.xml */
int cpy_z_p_v(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|100000100|Pg=xxx|Vn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x5208000) {
		decode_fields32(ENC_CPY_Z_P_V_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Vn);
		ctx->d = UINT(ctx->Zd);
		/* unconditional alias */
		if(MOV_cpy_z_p_v(ctx, instr)==0) return 0;
		OK(ENC_CPY_Z_P_V_);
	}
	return rc;
}

/* ctermeq_rr.xml */
int ctermeq_rr(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_eq */
	/* 00|100101|op=1|sz=x|1|Rm=xxxxx|001000|Rn=xxxxx|ne=0|0|0|00 */
	if((INSWORD & 0xFFA0FC1F)==0x25A02000) {
		decode_fields32(ENC_CTERMEQ_RR_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->op = Cmp_EQ;
		OK(ENC_CTERMEQ_RR_);
	}
	/* class iclass_ne */
	/* 00|100101|op=1|sz=x|1|Rm=xxxxx|001000|Rn=xxxxx|ne=1|0|0|00 */
	if((INSWORD & 0xFFA0FC1F)==0x25A02010) {
		decode_fields32(ENC_CTERMNE_RR_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (0x20) << (UINT(ctx->sz));
		ctx->n = UINT(ctx->Rn);
		ctx->m = UINT(ctx->Rm);
		ctx->op = Cmp_NE;
		OK(ENC_CTERMNE_RR_);
	}
	return rc;
}

/* decb_r_rs.xml */
int decb_r_rs(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_esize_byte */
	/* 00000100|size=00|11|imm4=xxxx|11100|D=1|pattern=xxxxx|Rdn=xxxxx */
	if((INSWORD & 0xFFF0FC00)==0x430E400) {
		decode_fields32(ENC_DECB_R_RS_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->dn = UINT(ctx->Rdn);
		ctx->pat = ctx->pattern;
		ctx->imm = UINT(ctx->imm4)+1;
		OK(ENC_DECB_R_RS_);
	}
	/* class iclass_esize_doubleword */
	/* 00000100|size=11|11|imm4=xxxx|11100|D=1|pattern=xxxxx|Rdn=xxxxx */
	if((INSWORD & 0xFFF0FC00)==0x4F0E400) {
		decode_fields32(ENC_DECD_R_RS_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->dn = UINT(ctx->Rdn);
		ctx->pat = ctx->pattern;
		ctx->imm = UINT(ctx->imm4)+1;
		OK(ENC_DECD_R_RS_);
	}
	/* class iclass_esize_halfword */
	/* 00000100|size=01|11|imm4=xxxx|11100|D=1|pattern=xxxxx|Rdn=xxxxx */
	if((INSWORD & 0xFFF0FC00)==0x470E400) {
		decode_fields32(ENC_DECH_R_RS_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x10;
		ctx->dn = UINT(ctx->Rdn);
		ctx->pat = ctx->pattern;
		ctx->imm = UINT(ctx->imm4)+1;
		OK(ENC_DECH_R_RS_);
	}
	/* class iclass_esize_word */
	/* 00000100|size=10|11|imm4=xxxx|11100|D=1|pattern=xxxxx|Rdn=xxxxx */
	if((INSWORD & 0xFFF0FC00)==0x4B0E400) {
		decode_fields32(ENC_DECW_R_RS_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->dn = UINT(ctx->Rdn);
		ctx->pat = ctx->pattern;
		ctx->imm = UINT(ctx->imm4)+1;
		OK(ENC_DECW_R_RS_);
	}
	return rc;
}

/* decd_z_zs.xml */
int decd_z_zs(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_esize_doubleword */
	/* 00000100|size=11|11|imm4=xxxx|11000|D=1|pattern=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFFF0FC00)==0x4F0C400) {
		decode_fields32(ENC_DECD_Z_ZS_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->dn = UINT(ctx->Zdn);
		ctx->pat = ctx->pattern;
		ctx->imm = UINT(ctx->imm4)+1;
		OK(ENC_DECD_Z_ZS_);
	}
	/* class iclass_esize_halfword */
	/* 00000100|size=01|11|imm4=xxxx|11000|D=1|pattern=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFFF0FC00)==0x470C400) {
		decode_fields32(ENC_DECH_Z_ZS_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x10;
		ctx->dn = UINT(ctx->Zdn);
		ctx->pat = ctx->pattern;
		ctx->imm = UINT(ctx->imm4)+1;
		OK(ENC_DECH_Z_ZS_);
	}
	/* class iclass_esize_word */
	/* 00000100|size=10|11|imm4=xxxx|11000|D=1|pattern=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFFF0FC00)==0x4B0C400) {
		decode_fields32(ENC_DECW_Z_ZS_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->dn = UINT(ctx->Zdn);
		ctx->pat = ctx->pattern;
		ctx->imm = UINT(ctx->imm4)+1;
		OK(ENC_DECW_Z_ZS_);
	}
	return rc;
}

/* decp_r_p_r.xml */
int decp_r_p_r(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00100101|size=xx|1011|op=0|D=1|10001|opc2=00|Pm=xxxx|Rdn=xxxxx */
	if((INSWORD & 0xFF3FFE00)==0x252D8800) {
		decode_fields32(ENC_DECP_R_P_R_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->m = UINT(ctx->Pm);
		ctx->dn = UINT(ctx->Rdn);
		OK(ENC_DECP_R_P_R_);
	}
	return rc;
}

/* decp_z_p_z.xml */
int decp_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00100101|size=xx|1011|op=0|D=1|10000|opc2=00|Pm=xxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FFE00)==0x252D8000) {
		decode_fields32(ENC_DECP_Z_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->m = UINT(ctx->Pm);
		ctx->dn = UINT(ctx->Zdn);
		OK(ENC_DECP_Z_P_Z_);
	}
	return rc;
}

/* dup_z_i.xml */
int dup_z_i(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00100101|size=xx|111|opc=00|011|sh=x|imm8=xxxxxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FC000)==0x2538C000) {
		decode_fields32(ENC_DUP_Z_I_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(((ctx->size<<1)|ctx->sh)==1) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->d = UINT(ctx->Zd);
		ctx->imm = SInt(ctx->imm8,8);
		if(ctx->sh==1) {
			ctx->imm = (ctx->imm) << (8);
		}
		/* unconditional alias */
		if(MOV_dup_z_i(ctx, instr)==0) return 0;
		OK(ENC_DUP_Z_I_);
	}
	return rc;
}

/* dup_z_r.xml */
int dup_z_r(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|100000001110|Rn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x5203800) {
		decode_fields32(ENC_DUP_Z_R_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Rn);
		ctx->d = UINT(ctx->Zd);
		/* unconditional alias */
		if(MOV_dup_z_r(ctx, instr)==0) return 0;
		OK(ENC_DUP_Z_R_);
	}
	return rc;
}

/* dup_z_zi.xml */
int dup_z_zi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|imm2=xx|1|tsz=xxxxx|001000|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x5202000) {
		decode_fields32(ENC_DUP_Z_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->imm = ((ctx->imm2<<5)|ctx->tsz);
		if(!ctx->tsz) {
			UNDEFINED;
		}
		else if(ctx->tsz==0x10) {
			ctx->esize = 0x80;
			ctx->index = UINT(SLICE(ctx->imm,6,5));
		}
		else if((ctx->tsz&15)==8) {
			ctx->esize = 0x40;
			ctx->index = UINT(SLICE(ctx->imm,6,4));
		}
		else if((ctx->tsz&7)==4) {
			ctx->esize = 0x20;
			ctx->index = UINT(SLICE(ctx->imm,6,3));
		}
		else if((ctx->tsz&3)==2) {
			ctx->esize = 0x10;
			ctx->index = UINT(SLICE(ctx->imm,6,2));
		}
		else if(ctx->tsz&1) {
			ctx->esize = 8;
			ctx->index = UINT(SLICE(ctx->imm,6,1));
		}
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		/* regular aliases */
		if((BitCount(((ctx->imm2<<5)|ctx->tsz))==1) || (BitCount(((ctx->imm2<<5)|ctx->tsz))>1)) return MOV_dup_z_zi(ctx, instr);
		OK(ENC_DUP_Z_ZI_);
	}
	return rc;
}

/* dupm_z_i.xml */
int dupm_z_i(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101110000|imm13=xxxxxxxxxxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFC0000)==0x5C00000) {
		decode_fields32(ENC_DUPM_Z_I_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->d = UINT(ctx->Zd);
		DecodeBitMasksCheckUndefined(SLICE(ctx->imm13,12,12),SLICE(ctx->imm13,5,0));
		DecodeBitMasks_ReturnType dbmrt = DecodeBitMasks(SLICE(ctx->imm13,12,12),SLICE(ctx->imm13,5,0),SLICE(ctx->imm13,11,6));
		ctx->imm = dbmrt.wmask;
		/* regular aliases */
		if(SVEMoveMaskPreferred(ctx->imm13)) return MOV_dupm_z_i(ctx, instr);
		OK(ENC_DUPM_Z_I_);
	}
	return rc;
}

/* eor3_z_zzz.xml */
int eor3_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 00000100|opc=00|1|Zm=xxxxx|00111|o2=0|Zk=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x4203800) {
		decode_fields32(ENC_EOR3_Z_ZZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->m = UINT(ctx->Zm);
		ctx->k = UINT(ctx->Zk);
		ctx->dn = UINT(ctx->Zdn);
		OK(ENC_EOR3_Z_ZZZ_);
	}
	return rc;
}

/* eor_p_p_pp.xml */
int eor_p_p_pp(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_no_s */
	/* 00100101|op=0|S=0|00|Pm=xxxx|01|Pg=xxxx|o2=1|Pn=xxxx|o3=0|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x25004200) {
		decode_fields32(ENC_EOR_P_P_PP_Z, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->m = UINT(ctx->Pm);
		ctx->d = UINT(ctx->Pd);
		instr->setflags = FALSE;
		ctx->setflags = FALSE;
		/* regular aliases */
		if(ctx->Pm==ctx->Pg) return NOTS_eor_p_p_pp(ctx, instr);
		if(ctx->Pm==ctx->Pg) return NOT_eor_p_p_pp(ctx, instr);
		OK(ENC_EOR_P_P_PP_Z);
	}
	/* class iclass_s */
	/* 00100101|op=0|S=1|00|Pm=xxxx|01|Pg=xxxx|o2=1|Pn=xxxx|o3=0|Pd=xxxx */
	if((INSWORD & 0xFFF0C210)==0x25404200) {
		decode_fields32(ENC_EORS_P_P_PP_Z, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Pn);
		ctx->m = UINT(ctx->Pm);
		ctx->d = UINT(ctx->Pd);
		instr->setflags = TRUE;
		ctx->setflags = TRUE;
		/* regular aliases */
		if(ctx->Pm==ctx->Pg) return NOTS_eor_p_p_pp(ctx, instr);
		if(ctx->Pm==ctx->Pg) return NOT_eor_p_p_pp(ctx, instr);
		OK(ENC_EORS_P_P_PP_Z);
	}
	return rc;
}

/* eor_z_p_zz.xml */
int eor_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|011|opc<2:1>=00|opc<0>=1|000|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x4190000) {
		decode_fields32(ENC_EOR_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_EOR_Z_P_ZZ_);
	}
	return rc;
}

/* eor_z_zi.xml */
int eor_z_zi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|opc=01|0000|imm13=xxxxxxxxxxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFFFC0000)==0x5400000) {
		decode_fields32(ENC_EOR_Z_ZI_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->dn = UINT(ctx->Zdn);
		DecodeBitMasksCheckUndefined(SLICE(ctx->imm13,12,12),SLICE(ctx->imm13,5,0));
		DecodeBitMasks_ReturnType dbmrt = DecodeBitMasks(SLICE(ctx->imm13,12,12),SLICE(ctx->imm13,5,0),SLICE(ctx->imm13,11,6));
		ctx->imm = dbmrt.wmask;
		OK(ENC_EOR_Z_ZI_);
	}
	return rc;
}

/* eor_z_zz.xml */
int eor_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|opc=10|1|Zm=xxxxx|001100|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x4A03000) {
		decode_fields32(ENC_EOR_Z_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_EOR_Z_ZZ_);
	}
	return rc;
}

/* eorbt_z_zz.xml */
int eorbt_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000101|size=xx|0|Zm=xxxxx|10010|tb=0|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x45009000) {
		decode_fields32(ENC_EORBT_Z_ZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		ctx->sel1 = 0;
		ctx->sel2 = 1;
		OK(ENC_EORBT_Z_ZZ_);
	}
	return rc;
}

/* eortb_z_zz.xml */
int eortb_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01000101|size=xx|0|Zm=xxxxx|10010|tb=1|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x45009400) {
		decode_fields32(ENC_EORTB_Z_ZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		ctx->sel1 = 1;
		ctx->sel2 = 0;
		OK(ENC_EORTB_Z_ZZ_);
	}
	return rc;
}

/* eorv_r_p_z.xml */
int eorv_r_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|0110|opc=01|001|Pg=xxx|Zn=xxxxx|Vd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x4192000) {
		decode_fields32(ENC_EORV_R_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Vd);
		OK(ENC_EORV_R_P_Z_);
	}
	return rc;
}

/* ext_z_zi.xml */
int ext_z_zi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve_const */
	/* 00000101011|imm8h=xxxxx|000|imm8l=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFE0E000)==0x5600000) {
		decode_fields32(ENC_EXT_Z_ZI_CON, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->dst = UINT(ctx->Zd);
		ctx->s1 = UINT(ctx->Zn);
		ctx->s2 = ((ctx->s1+1)) % 32;
		ctx->position = UINT(((ctx->imm8h<<3)|ctx->imm8l));
		OK(ENC_EXT_Z_ZI_CON);
	}
	/* class iclass_sve_dest */
	/* 00000101001|imm8h=xxxxx|000|imm8l=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFFE0E000)==0x5200000) {
		decode_fields32(ENC_EXT_Z_ZI_DES, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 8;
		ctx->dst = UINT(ctx->Zdn);
		ctx->s1 = ctx->dst;
		ctx->s2 = UINT(ctx->Zm);
		ctx->position = UINT(((ctx->imm8h<<3)|ctx->imm8l));
		OK(ENC_EXT_Z_ZI_DES);
	}
	return rc;
}

/* fabd_z_p_zz.xml */
int fabd_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|00|opc<3:1>=100|opc<0>=0|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x65088000) {
		decode_fields32(ENC_FABD_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_FABD_Z_P_ZZ_);
	}
	return rc;
}

/* fabs_z_p_z.xml */
int fabs_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|011|opc<2:1>=10|opc<0>=0|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x41CA000) {
		decode_fields32(ENC_FABS_Z_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FABS_Z_P_Z_);
	}
	return rc;
}

/* facge_p_p_zz.xml */
int facge_p_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_gt */
	/* 01100101|size=xx|0|Zm=xxxxx|op=1|1|o2=1|Pg=xxx|Zn=xxxxx|o3=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x6500E010) {
		decode_fields32(ENC_FACGT_P_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GT;
		OK(ENC_FACGT_P_P_ZZ_);
	}
	/* class iclass_ge */
	/* 01100101|size=xx|0|Zm=xxxxx|op=1|1|o2=0|Pg=xxx|Zn=xxxxx|o3=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x6500C010) {
		decode_fields32(ENC_FACGE_P_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GE;
		OK(ENC_FACGE_P_P_ZZ_);
	}
	return rc;
}

/* fadd_z_p_zs.xml */
int fadd_z_p_zs(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|011|opc<2:1>=00|opc<0>=0|100|Pg=xxx|0000|i1=x|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE3C0)==0x65188000) {
		decode_fields32(ENC_FADD_Z_P_ZS_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->imm = (ctx->i1==0) ? FPPointFive(0,ctx->esize) : FPOne(0,ctx->esize);
		OK(ENC_FADD_Z_P_ZS_);
	}
	return rc;
}

/* fadd_z_p_zz.xml */
int fadd_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|00|opc<3:1>=000|opc<0>=0|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x65008000) {
		decode_fields32(ENC_FADD_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_FADD_Z_P_ZZ_);
	}
	return rc;
}

/* fadd_z_zz.xml */
int fadd_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|0|Zm=xxxxx|000|opc<2:1>=00|opc<0>=0|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x65000000) {
		decode_fields32(ENC_FADD_Z_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FADD_Z_ZZ_);
	}
	return rc;
}

/* fadda_v_p_z.xml */
int fadda_v_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|0110|opc=00|001|Pg=xxx|Zm=xxxxx|Vdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x65182000) {
		decode_fields32(ENC_FADDA_V_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Vdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_FADDA_V_P_Z_);
	}
	return rc;
}

/* faddp_z_p_zz.xml */
int faddp_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01100100|size=xx|010|opc<2:1>=00|opc<0>=0|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x64108000) {
		decode_fields32(ENC_FADDP_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->m = UINT(ctx->Zm);
		ctx->dn = UINT(ctx->Zdn);
		OK(ENC_FADDP_Z_P_ZZ_);
	}
	return rc;
}

/* faddv_v_p_z.xml */
int faddv_v_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|000|opc<2:1>=00|opc<0>=0|001|Pg=xxx|Zn=xxxxx|Vd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x65002000) {
		decode_fields32(ENC_FADDV_V_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Vd);
		OK(ENC_FADDV_V_P_Z_);
	}
	return rc;
}

/* fcadd_z_p_zz.xml */
int fcadd_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100100|size=xx|00000|rot=x|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3EE000)==0x64008000) {
		decode_fields32(ENC_FCADD_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		ctx->sub_i = (ctx->rot==0);
		ctx->sub_r = (ctx->rot==1);
		OK(ENC_FCADD_Z_P_ZZ_);
	}
	return rc;
}

/* fcmeq_p_p_z0.xml */
int fcmeq_p_p_z0(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_eq */
	/* 01100101|size=xx|0100|eq=1|lt=0|001|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF3FE010)==0x65122000) {
		decode_fields32(ENC_FCMEQ_P_P_Z0_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_EQ;
		OK(ENC_FCMEQ_P_P_Z0_);
	}
	/* class iclass_gt */
	/* 01100101|size=xx|0100|eq=0|lt=0|001|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF3FE010)==0x65102010) {
		decode_fields32(ENC_FCMGT_P_P_Z0_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GT;
		OK(ENC_FCMGT_P_P_Z0_);
	}
	/* class iclass_ge */
	/* 01100101|size=xx|0100|eq=0|lt=0|001|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF3FE010)==0x65102000) {
		decode_fields32(ENC_FCMGE_P_P_Z0_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GE;
		OK(ENC_FCMGE_P_P_Z0_);
	}
	/* class iclass_lt */
	/* 01100101|size=xx|0100|eq=0|lt=1|001|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF3FE010)==0x65112000) {
		decode_fields32(ENC_FCMLT_P_P_Z0_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_LT;
		OK(ENC_FCMLT_P_P_Z0_);
	}
	/* class iclass_le */
	/* 01100101|size=xx|0100|eq=0|lt=1|001|Pg=xxx|Zn=xxxxx|ne=1|Pd=xxxx */
	if((INSWORD & 0xFF3FE010)==0x65112010) {
		decode_fields32(ENC_FCMLE_P_P_Z0_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_LE;
		OK(ENC_FCMLE_P_P_Z0_);
	}
	/* class iclass_ne */
	/* 01100101|size=xx|0100|eq=1|lt=1|001|Pg=xxx|Zn=xxxxx|ne=0|Pd=xxxx */
	if((INSWORD & 0xFF3FE010)==0x65132000) {
		decode_fields32(ENC_FCMNE_P_P_Z0_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_NE;
		OK(ENC_FCMNE_P_P_Z0_);
	}
	return rc;
}

/* fcmeq_p_p_zz.xml */
int fcmeq_p_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_eq */
	/* 01100101|size=xx|0|Zm=xxxxx|op=0|1|cmph=1|Pg=xxx|Zn=xxxxx|cmpl=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x65006000) {
		decode_fields32(ENC_FCMEQ_P_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_EQ;
		OK(ENC_FCMEQ_P_P_ZZ_);
	}
	/* class iclass_gt */
	/* 01100101|size=xx|0|Zm=xxxxx|op=0|1|cmph=0|Pg=xxx|Zn=xxxxx|cmpl=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x65004010) {
		decode_fields32(ENC_FCMGT_P_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GT;
		OK(ENC_FCMGT_P_P_ZZ_);
	}
	/* class iclass_ge */
	/* 01100101|size=xx|0|Zm=xxxxx|op=0|1|cmph=0|Pg=xxx|Zn=xxxxx|cmpl=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x65004000) {
		decode_fields32(ENC_FCMGE_P_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_GE;
		OK(ENC_FCMGE_P_P_ZZ_);
	}
	/* class iclass_ne */
	/* 01100101|size=xx|0|Zm=xxxxx|op=0|1|cmph=1|Pg=xxx|Zn=xxxxx|cmpl=1|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x65006010) {
		decode_fields32(ENC_FCMNE_P_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_NE;
		OK(ENC_FCMNE_P_P_ZZ_);
	}
	/* class iclass_uo */
	/* 01100101|size=xx|0|Zm=xxxxx|op=1|1|o2=0|Pg=xxx|Zn=xxxxx|o3=0|Pd=xxxx */
	if((INSWORD & 0xFF20E010)==0x6500C000) {
		decode_fields32(ENC_FCMUO_P_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Pd);
		ctx->op = Cmp_UN;
		OK(ENC_FCMUO_P_P_ZZ_);
	}
	return rc;
}

/* fcmla_z_p_zzz.xml */
int fcmla_z_p_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100100|size=xx|0|Zm=xxxxx|0|rot=xx|Pg=xxx|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFF208000)==0x64000000) {
		decode_fields32(ENC_FCMLA_Z_P_ZZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->sel_a = UINT(SLICE(ctx->rot,0,0));
		ctx->sel_b = UINT(NOT(SLICE(ctx->rot,0,0),1));
		ctx->neg_i = (SLICE(ctx->rot,1,1)==1);
		ctx->neg_r = (SLICE(ctx->rot,0,0)!=SLICE(ctx->rot,1,1));
		OK(ENC_FCMLA_Z_P_ZZZ_);
	}
	return rc;
}

/* fcmla_z_zzzi.xml */
int fcmla_z_zzzi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 01100100|size=10|1|i2=xx|Zm=xxx|0001|rot=xx|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0F000)==0x64A01000) {
		decode_fields32(ENC_FCMLA_Z_ZZZI_H, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x10;
		ctx->index = UINT(ctx->i2);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->sel_a = UINT(SLICE(ctx->rot,0,0));
		ctx->sel_b = UINT(NOT(SLICE(ctx->rot,0,0),1));
		ctx->neg_i = (SLICE(ctx->rot,1,1)==1);
		ctx->neg_r = (SLICE(ctx->rot,0,0)!=SLICE(ctx->rot,1,1));
		OK(ENC_FCMLA_Z_ZZZI_H);
	}
	/* class iclass_single */
	/* 01100100|size=11|1|i1=x|Zm=xxxx|0001|rot=xx|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0F000)==0x64E01000) {
		decode_fields32(ENC_FCMLA_Z_ZZZI_S, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->index = UINT(ctx->i1);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->sel_a = UINT(SLICE(ctx->rot,0,0));
		ctx->sel_b = UINT(NOT(SLICE(ctx->rot,0,0),1));
		ctx->neg_i = (SLICE(ctx->rot,1,1)==1);
		ctx->neg_r = (SLICE(ctx->rot,0,0)!=SLICE(ctx->rot,1,1));
		OK(ENC_FCMLA_Z_ZZZI_S);
	}
	return rc;
}

/* fcpy_z_p_i.xml */
int fcpy_z_p_i(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000101|size=xx|01|Pg=xxxx|110|imm8=xxxxxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF30E000)==0x510C000) {
		decode_fields32(ENC_FCPY_Z_P_I_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->d = UINT(ctx->Zd);
		ctx->imm = VFPExpandImm(ctx->imm8,8);
		/* unconditional alias */
		if(FMOV_fcpy_z_p_i(ctx, instr)==0) return 0;
		OK(ENC_FCPY_Z_P_I_);
	}
	return rc;
}

/* fcvt_z_p_z.xml */
int fcvt_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half_to_single */
	/* 01100101|opc=10|0010|opc2=01|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x6589A000) {
		decode_fields32(ENC_FCVT_Z_P_Z_H2S, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x10;
		ctx->d_esize = 0x20;
		OK(ENC_FCVT_Z_P_Z_H2S);
	}
	/* class iclass_half_to_double */
	/* 01100101|opc=11|0010|opc2=01|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x65C9A000) {
		decode_fields32(ENC_FCVT_Z_P_Z_H2D, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x10;
		ctx->d_esize = 0x40;
		OK(ENC_FCVT_Z_P_Z_H2D);
	}
	/* class iclass_single_to_half */
	/* 01100101|opc=10|0010|opc2=00|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x6588A000) {
		decode_fields32(ENC_FCVT_Z_P_Z_S2H, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x20;
		ctx->d_esize = 0x10;
		OK(ENC_FCVT_Z_P_Z_S2H);
	}
	/* class iclass_single_to_double */
	/* 01100101|opc=11|0010|opc2=11|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x65CBA000) {
		decode_fields32(ENC_FCVT_Z_P_Z_S2D, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x20;
		ctx->d_esize = 0x40;
		OK(ENC_FCVT_Z_P_Z_S2D);
	}
	/* class iclass_double_to_half */
	/* 01100101|opc=11|0010|opc2=00|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x65C8A000) {
		decode_fields32(ENC_FCVT_Z_P_Z_D2H, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x40;
		ctx->d_esize = 0x10;
		OK(ENC_FCVT_Z_P_Z_D2H);
	}
	/* class iclass_double_to_single */
	/* 01100101|opc=11|0010|opc2=10|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x65CAA000) {
		decode_fields32(ENC_FCVT_Z_P_Z_D2S, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x40;
		ctx->d_esize = 0x20;
		OK(ENC_FCVT_Z_P_Z_D2S);
	}
	return rc;
}

/* fcvtlt_z_p_z.xml */
int fcvtlt_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half_to_single */
	/* 01100100|opc=10|0010|opc2=01|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x6489A000) {
		decode_fields32(ENC_FCVTLT_Z_P_Z_H2S, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FCVTLT_Z_P_Z_H2S);
	}
	/* class iclass_single_to_double */
	/* 01100100|opc=11|0010|opc2=11|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x64CBA000) {
		decode_fields32(ENC_FCVTLT_Z_P_Z_S2D, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FCVTLT_Z_P_Z_S2D);
	}
	return rc;
}

/* fcvtnt_z_p_z.xml */
int fcvtnt_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_single_to_half */
	/* 01100100|opc=10|0010|opc2=00|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x6488A000) {
		decode_fields32(ENC_FCVTNT_Z_P_Z_S2H, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FCVTNT_Z_P_Z_S2H);
	}
	/* class iclass_double_to_single */
	/* 01100100|opc=11|0010|opc2=10|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x64CAA000) {
		decode_fields32(ENC_FCVTNT_Z_P_Z_D2S, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FCVTNT_Z_P_Z_D2S);
	}
	return rc;
}

/* fcvtx_z_p_z.xml */
int fcvtx_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_double_to_single */
	/* 01100101|opc=00|0010|opc2=10|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x650AA000) {
		decode_fields32(ENC_FCVTX_Z_P_Z_D2S, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x40;
		ctx->d_esize = 0x20;
		OK(ENC_FCVTX_Z_P_Z_D2S);
	}
	return rc;
}

/* fcvtxnt_z_p_z.xml */
int fcvtxnt_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_double_to_single */
	/* 01100100|opc=00|0010|opc2=10|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x640AA000) {
		decode_fields32(ENC_FCVTXNT_Z_P_Z_D2S, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FCVTXNT_Z_P_Z_D2S);
	}
	return rc;
}

/* fcvtzs_z_p_z.xml */
int fcvtzs_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half_to_16 */
	/* 01100101|opc=01|011|opc2=01|int_U=0|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x655AA000) {
		decode_fields32(ENC_FCVTZS_Z_P_Z_FP162H, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x10;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x10;
		ctx->d_esize = 0x10;
		ctx->unsigned_ = FALSE;
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZS_Z_P_Z_FP162H);
	}
	/* class iclass_half_to_32 */
	/* 01100101|opc=01|011|opc2=10|int_U=0|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x655CA000) {
		decode_fields32(ENC_FCVTZS_Z_P_Z_FP162W, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x10;
		ctx->d_esize = 0x20;
		ctx->unsigned_ = FALSE;
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZS_Z_P_Z_FP162W);
	}
	/* class iclass_half_to_64 */
	/* 01100101|opc=01|011|opc2=11|int_U=0|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x655EA000) {
		decode_fields32(ENC_FCVTZS_Z_P_Z_FP162X, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x10;
		ctx->d_esize = 0x40;
		ctx->unsigned_ = FALSE;
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZS_Z_P_Z_FP162X);
	}
	/* class iclass_single_to_32 */
	/* 01100101|opc=10|011|opc2=10|int_U=0|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x659CA000) {
		decode_fields32(ENC_FCVTZS_Z_P_Z_S2W, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x20;
		ctx->d_esize = 0x20;
		ctx->unsigned_ = FALSE;
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZS_Z_P_Z_S2W);
	}
	/* class iclass_single_to_64 */
	/* 01100101|opc=11|011|opc2=10|int_U=0|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x65DCA000) {
		decode_fields32(ENC_FCVTZS_Z_P_Z_S2X, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x20;
		ctx->d_esize = 0x40;
		ctx->unsigned_ = FALSE;
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZS_Z_P_Z_S2X);
	}
	/* class iclass_double_to_32 */
	/* 01100101|opc=11|011|opc2=00|int_U=0|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x65D8A000) {
		decode_fields32(ENC_FCVTZS_Z_P_Z_D2W, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x40;
		ctx->d_esize = 0x20;
		ctx->unsigned_ = FALSE;
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZS_Z_P_Z_D2W);
	}
	/* class iclass_double_to_64 */
	/* 01100101|opc=11|011|opc2=11|int_U=0|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x65DEA000) {
		decode_fields32(ENC_FCVTZS_Z_P_Z_D2X, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x40;
		ctx->d_esize = 0x40;
		ctx->unsigned_ = FALSE;
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZS_Z_P_Z_D2X);
	}
	return rc;
}

/* fcvtzu_z_p_z.xml */
int fcvtzu_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half_to_16 */
	/* 01100101|opc=01|011|opc2=01|int_U=1|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x655BA000) {
		decode_fields32(ENC_FCVTZU_Z_P_Z_FP162H, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x10;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x10;
		ctx->d_esize = 0x10;
		ctx->unsigned_ = TRUE;
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZU_Z_P_Z_FP162H);
	}
	/* class iclass_half_to_32 */
	/* 01100101|opc=01|011|opc2=10|int_U=1|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x655DA000) {
		decode_fields32(ENC_FCVTZU_Z_P_Z_FP162W, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x10;
		ctx->d_esize = 0x20;
		ctx->unsigned_ = TRUE;
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZU_Z_P_Z_FP162W);
	}
	/* class iclass_half_to_64 */
	/* 01100101|opc=01|011|opc2=11|int_U=1|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x655FA000) {
		decode_fields32(ENC_FCVTZU_Z_P_Z_FP162X, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x10;
		ctx->d_esize = 0x40;
		ctx->unsigned_ = TRUE;
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZU_Z_P_Z_FP162X);
	}
	/* class iclass_single_to_32 */
	/* 01100101|opc=10|011|opc2=10|int_U=1|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x659DA000) {
		decode_fields32(ENC_FCVTZU_Z_P_Z_S2W, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x20;
		ctx->d_esize = 0x20;
		ctx->unsigned_ = TRUE;
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZU_Z_P_Z_S2W);
	}
	/* class iclass_single_to_64 */
	/* 01100101|opc=11|011|opc2=10|int_U=1|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x65DDA000) {
		decode_fields32(ENC_FCVTZU_Z_P_Z_S2X, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x20;
		ctx->d_esize = 0x40;
		ctx->unsigned_ = TRUE;
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZU_Z_P_Z_S2X);
	}
	/* class iclass_double_to_32 */
	/* 01100101|opc=11|011|opc2=00|int_U=1|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x65D9A000) {
		decode_fields32(ENC_FCVTZU_Z_P_Z_D2W, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x40;
		ctx->d_esize = 0x20;
		ctx->unsigned_ = TRUE;
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZU_Z_P_Z_D2W);
	}
	/* class iclass_double_to_64 */
	/* 01100101|opc=11|011|opc2=11|int_U=1|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFFFE000)==0x65DFA000) {
		decode_fields32(ENC_FCVTZU_Z_P_Z_D2X, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		ctx->s_esize = 0x40;
		ctx->d_esize = 0x40;
		ctx->unsigned_ = TRUE;
		ctx->rounding = FPRounding_ZERO;
		OK(ENC_FCVTZU_Z_P_Z_D2X);
	}
	return rc;
}

/* fdiv_z_p_zz.xml */
int fdiv_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|00|opc<3:1>=110|opc<0>=1|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x650D8000) {
		decode_fields32(ENC_FDIV_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_FDIV_Z_P_ZZ_);
	}
	return rc;
}

/* fdivr_z_p_zz.xml */
int fdivr_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|00|opc<3:1>=110|opc<0>=0|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x650C8000) {
		decode_fields32(ENC_FDIVR_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_FDIVR_Z_P_ZZ_);
	}
	return rc;
}

/* fdup_z_i.xml */
int fdup_z_i(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00100101|size=xx|111|opc=00|111|o2=0|imm8=xxxxxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x2539C000) {
		decode_fields32(ENC_FDUP_Z_I_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->d = UINT(ctx->Zd);
		ctx->imm = VFPExpandImm(ctx->imm8,8);
		/* unconditional alias */
		if(FMOV_fdup_z_i(ctx, instr)==0) return 0;
		OK(ENC_FDUP_Z_I_);
	}
	return rc;
}

/* fexpa_z_z.xml */
int fexpa_z_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|1|opc<4:1>=0000|opc<0>=0|101110|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x420B800) {
		decode_fields32(ENC_FEXPA_Z_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FEXPA_Z_Z_);
	}
	return rc;
}

/* flogb_z_p_z.xml */
int flogb_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01100101|opc=00|011|size=xx|U=0|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFF9E000)==0x6518A000) {
		decode_fields32(ENC_FLOGB_Z_P_Z_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FLOGB_Z_P_Z_);
	}
	return rc;
}

/* fmad_z_p_zzz.xml */
int fmad_z_p_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|1|Za=xxxxx|1|N=0|op=0|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF20E000)==0x65208000) {
		decode_fields32(ENC_FMAD_Z_P_ZZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		ctx->a = UINT(ctx->Za);
		ctx->op1_neg = FALSE;
		ctx->op3_neg = FALSE;
		OK(ENC_FMAD_Z_P_ZZZ_);
	}
	return rc;
}

/* fmax_z_p_zs.xml */
int fmax_z_p_zs(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|011|opc<2:1>=11|opc<0>=0|100|Pg=xxx|0000|i1=x|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE3C0)==0x651E8000) {
		decode_fields32(ENC_FMAX_Z_P_ZS_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->imm = (ctx->i1==0) ? 0 : FPOne(0,ctx->esize);
		OK(ENC_FMAX_Z_P_ZS_);
	}
	return rc;
}

/* fmax_z_p_zz.xml */
int fmax_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|00|opc<3:1>=011|opc<0>=0|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x65068000) {
		decode_fields32(ENC_FMAX_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_FMAX_Z_P_ZZ_);
	}
	return rc;
}

/* fmaxnm_z_p_zs.xml */
int fmaxnm_z_p_zs(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|011|opc<2:1>=10|opc<0>=0|100|Pg=xxx|0000|i1=x|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE3C0)==0x651C8000) {
		decode_fields32(ENC_FMAXNM_Z_P_ZS_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->imm = (ctx->i1==0) ? 0 : FPOne(0,ctx->esize);
		OK(ENC_FMAXNM_Z_P_ZS_);
	}
	return rc;
}

/* fmaxnm_z_p_zz.xml */
int fmaxnm_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|00|opc<3:1>=010|opc<0>=0|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x65048000) {
		decode_fields32(ENC_FMAXNM_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_FMAXNM_Z_P_ZZ_);
	}
	return rc;
}

/* fmaxnmp_z_p_zz.xml */
int fmaxnmp_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01100100|size=xx|010|opc<2:1>=10|opc<0>=0|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x64148000) {
		decode_fields32(ENC_FMAXNMP_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->m = UINT(ctx->Zm);
		ctx->dn = UINT(ctx->Zdn);
		OK(ENC_FMAXNMP_Z_P_ZZ_);
	}
	return rc;
}

/* fmaxnmv_v_p_z.xml */
int fmaxnmv_v_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|000|opc<2:1>=10|opc<0>=0|001|Pg=xxx|Zn=xxxxx|Vd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x65042000) {
		decode_fields32(ENC_FMAXNMV_V_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Vd);
		OK(ENC_FMAXNMV_V_P_Z_);
	}
	return rc;
}

/* fmaxp_z_p_zz.xml */
int fmaxp_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01100100|size=xx|010|opc<2:1>=11|opc<0>=0|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x64168000) {
		decode_fields32(ENC_FMAXP_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->m = UINT(ctx->Zm);
		ctx->dn = UINT(ctx->Zdn);
		OK(ENC_FMAXP_Z_P_ZZ_);
	}
	return rc;
}

/* fmaxv_v_p_z.xml */
int fmaxv_v_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|000|opc<2:1>=11|opc<0>=0|001|Pg=xxx|Zn=xxxxx|Vd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x65062000) {
		decode_fields32(ENC_FMAXV_V_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Vd);
		OK(ENC_FMAXV_V_P_Z_);
	}
	return rc;
}

/* fmin_z_p_zs.xml */
int fmin_z_p_zs(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|011|opc<2:1>=11|opc<0>=1|100|Pg=xxx|0000|i1=x|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE3C0)==0x651F8000) {
		decode_fields32(ENC_FMIN_Z_P_ZS_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->imm = (ctx->i1==0) ? 0 : FPOne(0,ctx->esize);
		OK(ENC_FMIN_Z_P_ZS_);
	}
	return rc;
}

/* fmin_z_p_zz.xml */
int fmin_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|00|opc<3:1>=011|opc<0>=1|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x65078000) {
		decode_fields32(ENC_FMIN_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_FMIN_Z_P_ZZ_);
	}
	return rc;
}

/* fminnm_z_p_zs.xml */
int fminnm_z_p_zs(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|011|opc<2:1>=10|opc<0>=1|100|Pg=xxx|0000|i1=x|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE3C0)==0x651D8000) {
		decode_fields32(ENC_FMINNM_Z_P_ZS_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->imm = (ctx->i1==0) ? 0 : FPOne(0,ctx->esize);
		OK(ENC_FMINNM_Z_P_ZS_);
	}
	return rc;
}

/* fminnm_z_p_zz.xml */
int fminnm_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|00|opc<3:1>=010|opc<0>=1|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x65058000) {
		decode_fields32(ENC_FMINNM_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_FMINNM_Z_P_ZZ_);
	}
	return rc;
}

/* fminnmp_z_p_zz.xml */
int fminnmp_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01100100|size=xx|010|opc<2:1>=10|opc<0>=1|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x64158000) {
		decode_fields32(ENC_FMINNMP_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->m = UINT(ctx->Zm);
		ctx->dn = UINT(ctx->Zdn);
		OK(ENC_FMINNMP_Z_P_ZZ_);
	}
	return rc;
}

/* fminnmv_v_p_z.xml */
int fminnmv_v_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|000|opc<2:1>=10|opc<0>=1|001|Pg=xxx|Zn=xxxxx|Vd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x65052000) {
		decode_fields32(ENC_FMINNMV_V_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Vd);
		OK(ENC_FMINNMV_V_P_Z_);
	}
	return rc;
}

/* fminp_z_p_zz.xml */
int fminp_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 01100100|size=xx|010|opc<2:1>=11|opc<0>=1|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x64178000) {
		decode_fields32(ENC_FMINP_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->m = UINT(ctx->Zm);
		ctx->dn = UINT(ctx->Zdn);
		OK(ENC_FMINP_Z_P_ZZ_);
	}
	return rc;
}

/* fminv_v_p_z.xml */
int fminv_v_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|000|opc<2:1>=11|opc<0>=1|001|Pg=xxx|Zn=xxxxx|Vd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x65072000) {
		decode_fields32(ENC_FMINV_V_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Vd);
		OK(ENC_FMINV_V_P_Z_);
	}
	return rc;
}

/* fmla_z_p_zzz.xml */
int fmla_z_p_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|1|Zm=xxxxx|0|N=0|op=0|Pg=xxx|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFF20E000)==0x65200000) {
		decode_fields32(ENC_FMLA_Z_P_ZZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->op1_neg = FALSE;
		ctx->op3_neg = FALSE;
		OK(ENC_FMLA_Z_P_ZZZ_);
	}
	return rc;
}

/* fmla_z_zzzi.xml */
int fmla_z_zzzi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 01100100|0|i3h=x|1|i3l=xx|Zm=xxx|00000|op=0|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFA0FC00)==0x64200000) {
		decode_fields32(ENC_FMLA_Z_ZZZI_H, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x10;
		ctx->index = UINT(((ctx->i3h<<2)|ctx->i3l));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->op1_neg = FALSE;
		ctx->op3_neg = FALSE;
		OK(ENC_FMLA_Z_ZZZI_H);
	}
	/* class iclass_single */
	/* 01100100|size=10|1|i2=xx|Zm=xxx|00000|op=0|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x64A00000) {
		decode_fields32(ENC_FMLA_Z_ZZZI_S, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->index = UINT(ctx->i2);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->op1_neg = FALSE;
		ctx->op3_neg = FALSE;
		OK(ENC_FMLA_Z_ZZZI_S);
	}
	/* class iclass_double */
	/* 01100100|size=11|1|i1=x|Zm=xxxx|00000|op=0|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x64E00000) {
		decode_fields32(ENC_FMLA_Z_ZZZI_D, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->index = UINT(ctx->i1);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->op1_neg = FALSE;
		ctx->op3_neg = FALSE;
		OK(ENC_FMLA_Z_ZZZI_D);
	}
	return rc;
}

/* fmlalb_z_zzz.xml */
int fmlalb_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 011001001|o2=0|1|Zm=xxxxx|10|op=0|00|T=0|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x64A08000) {
		decode_fields32(ENC_FMLALB_Z_ZZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->op1_neg = FALSE;
		OK(ENC_FMLALB_Z_ZZZ_);
	}
	return rc;
}

/* fmlalb_z_zzzi.xml */
int fmlalb_z_zzzi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_single */
	/* 011001001|o2=0|1|i3h=xx|Zm=xxx|01|op=0|0|i3l=x|T=0|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0F400)==0x64A04000) {
		decode_fields32(ENC_FMLALB_Z_ZZZI_S, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->index = UINT(((ctx->i3h<<1)|ctx->i3l));
		ctx->op1_neg = FALSE;
		OK(ENC_FMLALB_Z_ZZZI_S);
	}
	return rc;
}

/* fmlalt_z_zzz.xml */
int fmlalt_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 011001001|o2=0|1|Zm=xxxxx|10|op=0|00|T=1|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x64A08400) {
		decode_fields32(ENC_FMLALT_Z_ZZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->op1_neg = FALSE;
		OK(ENC_FMLALT_Z_ZZZ_);
	}
	return rc;
}

/* fmlalt_z_zzzi.xml */
int fmlalt_z_zzzi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_single */
	/* 011001001|o2=0|1|i3h=xx|Zm=xxx|01|op=0|0|i3l=x|T=1|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0F400)==0x64A04400) {
		decode_fields32(ENC_FMLALT_Z_ZZZI_S, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->index = UINT(((ctx->i3h<<1)|ctx->i3l));
		ctx->op1_neg = FALSE;
		OK(ENC_FMLALT_Z_ZZZI_S);
	}
	return rc;
}

/* fmls_z_p_zzz.xml */
int fmls_z_p_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|1|Zm=xxxxx|0|N=0|op=1|Pg=xxx|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFF20E000)==0x65202000) {
		decode_fields32(ENC_FMLS_Z_P_ZZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->op1_neg = TRUE;
		ctx->op3_neg = FALSE;
		OK(ENC_FMLS_Z_P_ZZZ_);
	}
	return rc;
}

/* fmls_z_zzzi.xml */
int fmls_z_zzzi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 01100100|0|i3h=x|1|i3l=xx|Zm=xxx|00000|op=1|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFA0FC00)==0x64200400) {
		decode_fields32(ENC_FMLS_Z_ZZZI_H, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x10;
		ctx->index = UINT(((ctx->i3h<<2)|ctx->i3l));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->op1_neg = TRUE;
		ctx->op3_neg = FALSE;
		OK(ENC_FMLS_Z_ZZZI_H);
	}
	/* class iclass_single */
	/* 01100100|size=10|1|i2=xx|Zm=xxx|00000|op=1|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x64A00400) {
		decode_fields32(ENC_FMLS_Z_ZZZI_S, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->index = UINT(ctx->i2);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->op1_neg = TRUE;
		ctx->op3_neg = FALSE;
		OK(ENC_FMLS_Z_ZZZI_S);
	}
	/* class iclass_double */
	/* 01100100|size=11|1|i1=x|Zm=xxxx|00000|op=1|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x64E00400) {
		decode_fields32(ENC_FMLS_Z_ZZZI_D, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->index = UINT(ctx->i1);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->op1_neg = TRUE;
		ctx->op3_neg = FALSE;
		OK(ENC_FMLS_Z_ZZZI_D);
	}
	return rc;
}

/* fmlslb_z_zzz.xml */
int fmlslb_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 011001001|o2=0|1|Zm=xxxxx|10|op=1|00|T=0|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x64A0A000) {
		decode_fields32(ENC_FMLSLB_Z_ZZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->op1_neg = TRUE;
		OK(ENC_FMLSLB_Z_ZZZ_);
	}
	return rc;
}

/* fmlslb_z_zzzi.xml */
int fmlslb_z_zzzi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_single */
	/* 011001001|o2=0|1|i3h=xx|Zm=xxx|01|op=1|0|i3l=x|T=0|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0F400)==0x64A06000) {
		decode_fields32(ENC_FMLSLB_Z_ZZZI_S, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->index = UINT(((ctx->i3h<<1)|ctx->i3l));
		ctx->op1_neg = TRUE;
		OK(ENC_FMLSLB_Z_ZZZI_S);
	}
	return rc;
}

/* fmlslt_z_zzz.xml */
int fmlslt_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve2 */
	/* 011001001|o2=0|1|Zm=xxxxx|10|op=1|00|T=1|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x64A0A400) {
		decode_fields32(ENC_FMLSLT_Z_ZZZ_, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->op1_neg = TRUE;
		OK(ENC_FMLSLT_Z_ZZZ_);
	}
	return rc;
}

/* fmlslt_z_zzzi.xml */
int fmlslt_z_zzzi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_single */
	/* 011001001|o2=0|1|i3h=xx|Zm=xxx|01|op=1|0|i3l=x|T=1|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0F400)==0x64A06400) {
		decode_fields32(ENC_FMLSLT_Z_ZZZI_S, ctx, instr);
		if(!HaveSVE2()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->index = UINT(((ctx->i3h<<1)|ctx->i3l));
		ctx->op1_neg = TRUE;
		OK(ENC_FMLSLT_Z_ZZZI_S);
	}
	return rc;
}

/* fmmla_z_zzz.xml */
int fmmla_z_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_32_elem */
	/* 01100100|opc=10|1|Zm=xxxxx|111001|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x64A0E400) {
		decode_fields32(ENC_FMMLA_Z_ZZZ_S, ctx, instr);
		if(!HaveSVEFP32MatMulExt()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		OK(ENC_FMMLA_Z_ZZZ_S);
	}
	/* class iclass_64_elem */
	/* 01100100|opc=11|1|Zm=xxxxx|111001|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x64E0E400) {
		decode_fields32(ENC_FMMLA_Z_ZZZ_D, ctx, instr);
		if(!HaveSVEFP64MatMulExt()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		OK(ENC_FMMLA_Z_ZZZ_D);
	}
	return rc;
}

/* fmsb_z_p_zzz.xml */
int fmsb_z_p_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|1|Za=xxxxx|1|N=0|op=1|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF20E000)==0x6520A000) {
		decode_fields32(ENC_FMSB_Z_P_ZZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		ctx->a = UINT(ctx->Za);
		ctx->op1_neg = TRUE;
		ctx->op3_neg = FALSE;
		OK(ENC_FMSB_Z_P_ZZZ_);
	}
	return rc;
}

/* fmul_z_p_zs.xml */
int fmul_z_p_zs(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|011|opc<2:1>=01|opc<0>=0|100|Pg=xxx|0000|i1=x|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE3C0)==0x651A8000) {
		decode_fields32(ENC_FMUL_Z_P_ZS_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->imm = (ctx->i1==0) ? FPPointFive(0,ctx->esize) : FPTwo(0,ctx->esize);
		OK(ENC_FMUL_Z_P_ZS_);
	}
	return rc;
}

/* fmul_z_p_zz.xml */
int fmul_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|00|opc<3:1>=001|opc<0>=0|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x65028000) {
		decode_fields32(ENC_FMUL_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_FMUL_Z_P_ZZ_);
	}
	return rc;
}

/* fmul_z_zz.xml */
int fmul_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|0|Zm=xxxxx|000|opc<2:1>=01|opc<0>=0|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x65000800) {
		decode_fields32(ENC_FMUL_Z_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FMUL_Z_ZZ_);
	}
	return rc;
}

/* fmul_z_zzi.xml */
int fmul_z_zzi(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_half */
	/* 01100100|0|i3h=x|1|i3l=xx|Zm=xxx|001000|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFA0FC00)==0x64202000) {
		decode_fields32(ENC_FMUL_Z_ZZI_H, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x10;
		ctx->index = UINT(((ctx->i3h<<2)|ctx->i3l));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FMUL_Z_ZZI_H);
	}
	/* class iclass_single */
	/* 01100100|size=10|1|i2=xx|Zm=xxx|001000|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x64A02000) {
		decode_fields32(ENC_FMUL_Z_ZZI_S, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x20;
		ctx->index = UINT(ctx->i2);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FMUL_Z_ZZI_S);
	}
	/* class iclass_double */
	/* 01100100|size=11|1|i1=x|Zm=xxxx|001000|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFFE0FC00)==0x64E02000) {
		decode_fields32(ENC_FMUL_Z_ZZI_D, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		ctx->esize = 0x40;
		ctx->index = UINT(ctx->i1);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FMUL_Z_ZZI_D);
	}
	return rc;
}

/* fmulx_z_p_zz.xml */
int fmulx_z_p_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|00|opc<3:1>=101|opc<0>=0|100|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x650A8000) {
		decode_fields32(ENC_FMULX_Z_P_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		OK(ENC_FMULX_Z_P_ZZ_);
	}
	return rc;
}

/* fneg_z_p_z.xml */
int fneg_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 00000100|size=xx|011|opc<2:1>=10|opc<0>=1|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x41DA000) {
		decode_fields32(ENC_FNEG_Z_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FNEG_Z_P_Z_);
	}
	return rc;
}

/* fnmad_z_p_zzz.xml */
int fnmad_z_p_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|1|Za=xxxxx|1|N=1|op=0|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF20E000)==0x6520C000) {
		decode_fields32(ENC_FNMAD_Z_P_ZZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		ctx->a = UINT(ctx->Za);
		ctx->op1_neg = TRUE;
		ctx->op3_neg = TRUE;
		OK(ENC_FNMAD_Z_P_ZZZ_);
	}
	return rc;
}

/* fnmla_z_p_zzz.xml */
int fnmla_z_p_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|1|Zm=xxxxx|0|N=1|op=0|Pg=xxx|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFF20E000)==0x65204000) {
		decode_fields32(ENC_FNMLA_Z_P_ZZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->op1_neg = TRUE;
		ctx->op3_neg = TRUE;
		OK(ENC_FNMLA_Z_P_ZZZ_);
	}
	return rc;
}

/* fnmls_z_p_zzz.xml */
int fnmls_z_p_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|1|Zm=xxxxx|0|N=1|op=1|Pg=xxx|Zn=xxxxx|Zda=xxxxx */
	if((INSWORD & 0xFF20E000)==0x65206000) {
		decode_fields32(ENC_FNMLS_Z_P_ZZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->da = UINT(ctx->Zda);
		ctx->op1_neg = FALSE;
		ctx->op3_neg = TRUE;
		OK(ENC_FNMLS_Z_P_ZZZ_);
	}
	return rc;
}

/* fnmsb_z_p_zzz.xml */
int fnmsb_z_p_zzz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|1|Za=xxxxx|1|N=1|op=1|Pg=xxx|Zm=xxxxx|Zdn=xxxxx */
	if((INSWORD & 0xFF20E000)==0x6520E000) {
		decode_fields32(ENC_FNMSB_Z_P_ZZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->dn = UINT(ctx->Zdn);
		ctx->m = UINT(ctx->Zm);
		ctx->a = UINT(ctx->Za);
		ctx->op1_neg = FALSE;
		ctx->op3_neg = TRUE;
		OK(ENC_FNMSB_Z_P_ZZZ_);
	}
	return rc;
}

/* frecpe_z_z.xml */
int frecpe_z_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|001|opc<2:1>=11|opc<0>=0|001100|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FFC00)==0x650E3000) {
		decode_fields32(ENC_FRECPE_Z_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FRECPE_Z_Z_);
	}
	return rc;
}

/* frecps_z_zz.xml */
int frecps_z_zz(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|0|Zm=xxxxx|000|opc<2:1>=11|opc<0>=0|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF20FC00)==0x65001800) {
		decode_fields32(ENC_FRECPS_Z_ZZ_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->n = UINT(ctx->Zn);
		ctx->m = UINT(ctx->Zm);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FRECPS_Z_ZZ_);
	}
	return rc;
}

/* frecpx_z_p_z.xml */
int frecpx_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_sve */
	/* 01100101|size=xx|0011|opc=00|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x650CA000) {
		decode_fields32(ENC_FRECPX_Z_P_Z_, ctx, instr);
		if(!HaveSVE()) {
			UNDEFINED;
		}
		if(ctx->size==0) {
			UNDEFINED;
		}
		ctx->esize = (8) << (UINT(ctx->size));
		ctx->g = UINT(ctx->Pg);
		ctx->n = UINT(ctx->Zn);
		ctx->d = UINT(ctx->Zd);
		OK(ENC_FRECPX_Z_P_Z_);
	}
	return rc;
}

/* frinta_z_p_z.xml */
int frinta_z_p_z(context *ctx, Instruction *instr)
{
	int rc = DECODE_STATUS_UNMATCHED;
	/* class iclass_frint_i */
	/* 01100101|size=xx|000|opc<2:1>=11|opc<0>=1|101|Pg=xxx|Zn=xxxxx|Zd=xxxxx */
	if((INSWORD & 0xFF3FE000)==0x6507A000) {
		decode_fields32(ENC_FRI