
Those few recipes illustrate the logic of using bacon, and may serve as inspiration for your own practices.

Tell me about your recipes so that I may share them there.

# Open your lib's doc

Let's first assume your `bacon.toml` file has been generated by a recent version of bacon.

Then you can launch bacon on its default task, then when you want to check the doc, hit the <kbd>d</kbd> key: as soon as the doc compiles, it's opened in your browser and bacon switches back to the previous job.

If you want to complete an old `bacon.toml` file, or just understand how it works, here's the relevant configuration:

The job:

```TOML
[jobs.doc-open]
command = ["cargo", "doc", "--color", "always", "--no-deps", "--open"]
need_stdout = false
on_success = "back" # so that we don't open the browser at each change
```

And the key binding:

```TOML
[keybindings]
d = "job:doc-open"
```

# Configure Clippy lints

The jobs in the `bacon.toml` file are specific to your projects, there's no reason not to adapt them for its specificities.

You may for example want to tune the clippy rules:

```TOML
[jobs.clippy]
command = [
	"cargo", "clippy",
	"--color", "always",
	"--",
	"-A", "clippy::collapsible_else_if",
	"-A", "clippy::collapsible_if",
	"-A", "clippy::field_reassign_with_default",
	"-A", "clippy::match_like_matches_macro",
]
need_stdout = false
```

# Check compilation on other platforms

You may define specific jobs for specific targets:

```toml
[jobs.check-win]
command = ["cargo", "check", "--target", "x86_64-pc-windows-gnu", "--color", "always"]
```

# Run binaries and examples

If you configure a `cargo run` job, you'll get the usual warnings and errors until there's none, at which point you'll have the output of your binary (assuming its terminal output is interesting).

```toml
[jobs.exs]
command = ["cargo", "run", "--example", "simple", "--color", "always"]
need_stdout = true
```

You may add `on_success = "back"` if you don't want the executable to run again on changes.

# Variable arguments

Launch arguments after the `--` aren't interpreted by bacon but sent inchanged to the job commands.

This may be useful to add an argument only for one run without changing the `bacon.toml` file.

For example

```bash
bacon -- --target x86_64-pc-windows-gnu
```

Another example, a job which needs a complementary argument:


```toml
[jobs.ex]
command = ["cargo", "run", "--color", "always", "--example"]
need_stdout = true
```

You would call it with

```bash
bacon ex -- example4578
```



