use std::f64;

pub const WEIGHTS_LEGENDRE: &[&[(f64, f64)]] = &[
    &[(0.0, 2.0)],
    &[(0.5773502691896257, 1.0)],
    &[
        (0.0, 0.8888888888888888),
        (0.7745966692414834, 0.5555555555555557),
    ],
    &[
        (0.33998104358485626, 0.6521451548625461),
        (0.8611363115940526, 0.34785484513745396),
    ],
    &[
        (0.0, 0.5688888888888889),
        (0.5384693101056831, 0.47862867049936625),
        (0.906179845938664, 0.23692688505618917),
    ],
    &[
        (0.2386191860831969, 0.4679139345726909),
        (0.6612093864662646, 0.3607615730481386),
        (0.9324695142031522, 0.17132449237916977),
    ],
    &[
        (0.0, 0.4179591836734694),
        (0.4058451513773972, 0.3818300505051189),
        (0.7415311855993946, 0.2797053914892765),
        (0.9491079123427583, 0.1294849661688702),
    ],
    &[
        (0.1834346424956498, 0.36268378337836193),
        (0.525532409916329, 0.3137066458778865),
        (0.7966664774136271, 0.22238103445337515),
        (0.9602898564975364, 0.10122853629037544),
    ],
    &[
        (0.0, 0.3302393550012598),
        (0.3242534234038089, 0.31234707704000275),
        (0.6133714327005907, 0.26061069640293594),
        (0.8360311073266365, 0.1806481606948585),
        (0.9681602395076256, 0.08127438836157606),
    ],
    &[
        (0.1488743389816312, 0.2955242247147528),
        (0.43339539412924727, 0.26926671930999657),
        (0.6794095682990248, 0.21908636251598035),
        (0.8650633666889842, 0.14945134915058725),
        (0.9739065285171731, 0.06667134430868374),
    ],
    &[
        (0.0, 0.2729250867779006),
        (0.26954315595234496, 0.26280454451024654),
        (0.519096129206812, 0.23319376459199173),
        (0.7301520055740497, 0.18629021092774148),
        (0.8870625997680974, 0.1255803694649023),
        (0.9782286581460569, 0.05566856711617304),
    ],
    &[
        (0.1252334085114689, 0.24914704581340288),
        (0.3678314989981803, 0.2334925365383545),
        (0.5873179542866176, 0.20316742672306173),
        (0.7699026741943074, 0.16007832854332715),
        (0.9041172563704689, 0.10693932599532781),
        (0.9815606342467176, 0.04717533638652029),
    ],
];

pub const WEIGHTS_CHEBYSHEV: &[&[(f64, f64)]] = &[
    &[(0.0, f64::consts::PI)],
    &[(f64::consts::FRAC_1_SQRT_2, f64::consts::FRAC_PI_2)],
    &[
        (0.8660254037844387, 1.0471975511965976),
        (0.0, 1.0471975511965976),
    ],
    &[
        (0.9238795325112867, f64::consts::FRAC_PI_4),
        (0.38268343236508984, f64::consts::FRAC_PI_4),
    ],
    &[
        (0.9510565162951535, 0.6283185307179586),
        (0.5877852522924731, 0.6283185307179586),
        (0.0, 0.6283185307179586),
    ],
    &[
        (0.9659258262890683, 0.5235987755982988),
        (f64::consts::FRAC_1_SQRT_2, 0.5235987755982988),
        (0.25881904510252096, 0.5235987755982988),
    ],
    &[
        (0.9749279121818236, 0.4487989505128276),
        (0.7818314824680298, 0.4487989505128276),
        (0.4338837391175582, 0.4487989505128276),
        (0.0, 0.4487989505128276),
    ],
    &[
        (0.9807852804032304, f64::consts::FRAC_PI_8),
        (0.8314696123025452, f64::consts::FRAC_PI_8),
        (0.5555702330196023, f64::consts::FRAC_PI_8),
        (0.19509032201612833, f64::consts::FRAC_PI_8),
    ],
    &[
        (0.984807753012208, 0.3490658503988659),
        (0.8660254037844387, 0.3490658503988659),
        (0.6427876096865394, 0.3490658503988659),
        (0.3420201433256688, 0.3490658503988659),
        (0.0, 0.3490658503988659),
    ],
    &[
        (0.9876883405951378, 0.3141592653589793),
        (0.8910065241883679, 0.3141592653589793),
        (f64::consts::FRAC_1_SQRT_2, 0.3141592653589793),
        (0.4539904997395468, 0.3141592653589793),
        (0.15643446504023092, 0.3141592653589793),
    ],
    &[
        (0.9898214418809327, 0.28559933214452665),
        (0.9096319953545184, 0.28559933214452665),
        (0.7557495743542583, 0.28559933214452665),
        (0.5406408174555977, 0.28559933214452665),
        (0.2817325568414298, 0.28559933214452665),
        (0.0, 0.28559933214452665),
    ],
    &[
        (0.9914448613738104, 0.2617993877991494),
        (0.9238795325112867, 0.2617993877991494),
        (0.7933533402912353, 0.2617993877991494),
        (0.6087614290087207, 0.2617993877991494),
        (0.38268343236508984, 0.2617993877991494),
        (0.1305261922200517, 0.2617993877991494),
    ],
    &[
        (0.992708874098054, 0.241660973353061),
        (0.9350162426854148, 0.241660973353061),
        (0.8229838658936564, 0.241660973353061),
        (0.6631226582407952, 0.241660973353061),
        (0.4647231720437686, 0.241660973353061),
        (0.23931566428755763, 0.241660973353061),
        (0.0, 0.241660973353061),
    ],
    &[
        (0.9937122098932426, 0.2243994752564138),
        (0.9438833303083676, 0.2243994752564138),
        (0.8467241992282841, 0.2243994752564138),
        (f64::consts::FRAC_1_SQRT_2, 0.2243994752564138),
        (0.5320320765153366, 0.2243994752564138),
        (0.33027906195516715, 0.2243994752564138),
        (0.11196447610330791, 0.2243994752564138),
    ],
    &[
        (0.9945218953682733, 0.20943951023931953),
        (0.9510565162951535, 0.20943951023931953),
        (0.8660254037844387, 0.20943951023931953),
        (0.7431448254773944, 0.20943951023931953),
        (0.5877852522924731, 0.20943951023931953),
        (0.4067366430758004, 0.20943951023931953),
        (0.20791169081775945, 0.20943951023931953),
        (0.0, 0.20943951023931953),
    ],
    &[
        (0.9951847266721969, 0.19634954084936207),
        (0.9569403357322088, 0.19634954084936207),
        (0.881921264348355, 0.19634954084936207),
        (0.773010453362737, 0.19634954084936207),
        (0.6343932841636455, 0.19634954084936207),
        (0.4713967368259978, 0.19634954084936207),
        (0.29028467725446233, 0.19634954084936207),
        (0.09801714032956077, 0.19634954084936207),
    ],
    &[
        (0.9957341762950345, 0.18479956785822313),
        (0.961825643172819, 0.18479956785822313),
        (0.8951632913550623, 0.18479956785822313),
        (0.7980172272802395, 0.18479956785822313),
        (0.6736956436465572, 0.18479956785822313),
        (0.5264321628773558, 0.18479956785822313),
        (0.36124166618715303, 0.18479956785822313),
        (0.1837495178165703, 0.18479956785822313),
        (0.0, 0.18479956785822313),
    ],
    &[
        (0.9961946980917455, 0.17453292519943295),
        (0.9659258262890683, 0.17453292519943295),
        (0.9063077870366499, 0.17453292519943295),
        (0.8191520442889918, 0.17453292519943295),
        (f64::consts::FRAC_1_SQRT_2, 0.17453292519943295),
        (0.5735764363510462, 0.17453292519943295),
        (0.42261826174069944, 0.17453292519943295),
        (0.25881904510252074, 0.17453292519943295),
        (0.08715574274765836, 0.17453292519943295),
    ],
    &[
        (0.9965844930066698, 0.16534698176788384),
        (0.9694002659393304, 0.16534698176788384),
        (0.9157733266550574, 0.16534698176788384),
        (0.8371664782625287, 0.16534698176788384),
        (0.7357239106731317, 0.16534698176788384),
        (0.6142127126896678, 0.16534698176788384),
        (0.4759473930370736, 0.16534698176788384),
        (0.32469946920468357, 0.16534698176788384),
        (0.16459459028073398, 0.16534698176788384),
        (0.0, 0.16534698176788384),
    ],
    &[
        (0.996917333733128, 0.15707963267948966),
        (0.9723699203976766, 0.15707963267948966),
        (0.9238795325112867, 0.15707963267948966),
        (0.8526401643540922, 0.15707963267948966),
        (0.7604059656000309, 0.15707963267948966),
        (0.6494480483301837, 0.15707963267948966),
        (0.5224985647159489, 0.15707963267948966),
        (0.38268343236508984, 0.15707963267948966),
        (0.23344536385590547, 0.15707963267948966),
        (0.078459095727845, 0.15707963267948966),
    ],
    &[
        (0.9972037971811801, 0.14959965017094254),
        (0.9749279121818236, 0.14959965017094254),
        (0.9308737486442042, 0.14959965017094254),
        (0.8660254037844387, 0.14959965017094254),
        (0.7818314824680299, 0.14959965017094254),
        (0.6801727377709195, 0.14959965017094254),
        (0.5633200580636222, 0.14959965017094254),
        (0.43388373911755834, 0.14959965017094254),
        (0.2947551744109043, 0.14959965017094254),
        (0.14904226617617464, 0.14959965017094254),
        (0.0, 0.14959965017094254),
    ],
    &[
        (0.9974521146102535, 0.14279966607226333),
        (0.9771468659711595, 0.14279966607226333),
        (0.9369497249997617, 0.14279966607226333),
        (0.8776789895672557, 0.14279966607226333),
        (0.8005412409243604, 0.14279966607226333),
        (f64::consts::FRAC_1_SQRT_2, 0.14279966607226333),
        (0.599277666511347, 0.14279966607226333),
        (0.47924898672005684, 0.14279966607226333),
        (0.3494641795990984, 0.14279966607226333),
        (0.2125652895529766, 0.14279966607226333),
        (0.07133918319923235, 0.14279966607226333),
    ],
    &[
        (0.9976687691905392, 0.13659098493868665),
        (0.9790840876823229, 0.13659098493868665),
        (0.9422609221188205, 0.13659098493868665),
        (0.8878852184023752, 0.13659098493868665),
        (0.8169698930104421, 0.13659098493868665),
        (0.7308359642781241, 0.13659098493868665),
        (0.6310879443260529, 0.13659098493868665),
        (0.5195839500354336, 0.13659098493868665),
        (0.39840108984624156, 0.13659098493868665),
        (0.26979677115702444, 0.13659098493868665),
        (0.1361666490962466, 0.13659098493868665),
        (0.0, 0.13659098493868665),
    ],
    &[
        (0.9978589232386035, 0.1308996938995747),
        (0.9807852804032304, 0.1308996938995747),
        (0.9469301294951057, 0.1308996938995747),
        (0.8968727415326884, 0.1308996938995747),
        (0.8314696123025452, 0.1308996938995747),
        (0.7518398074789774, 0.1308996938995747),
        (0.659345815100069, 0.1308996938995747),
        (0.5555702330196024, 0.1308996938995747),
        (0.44228869021900147, 0.1308996938995747),
        (0.3214394653031617, 0.1308996938995747),
        (0.19509032201612833, 0.1308996938995747),
        (0.06540312923014327, 0.1308996938995747),
    ],
    &[
        (0.9980267284282716, 0.12566370614359174),
        (0.9822872507286887, 0.12566370614359174),
        (0.9510565162951535, 0.12566370614359174),
        (0.9048270524660195, 0.12566370614359174),
        (0.8443279255020151, 0.12566370614359174),
        (0.7705132427757891, 0.12566370614359174),
        (0.6845471059286886, 0.12566370614359174),
        (0.587785252292473, 0.12566370614359174),
        (0.48175367410171516, 0.12566370614359174),
        (0.36812455268467786, 0.12566370614359174),
        (0.24868988716485474, 0.12566370614359174),
        (0.12533323356430426, 0.12566370614359174),
        (0.0, 0.12566370614359174),
    ],
    &[
        (0.9981755542233175, 0.1208304866765305),
        (0.9836199069471436, 0.1208304866765305),
        (0.9547208665085456, 0.1208304866765305),
        (0.9118998459920901, 0.1208304866765305),
        (0.8557812723014475, 0.1208304866765305),
        (0.7871834806090501, 0.1208304866765305),
        (f64::consts::FRAC_1_SQRT_2, 0.1208304866765305),
        (0.616718872628543, 0.1208304866765305),
        (0.5173378141776568, 0.1208304866765305),
        (0.4104128054527567, 0.1208304866765305),
        (0.297503053855203, 0.1208304866765305),
        (0.18025503781390564, 0.1208304866765305),
        (0.060378497422286063, 0.1208304866765305),
    ],
    &[
        (0.9983081582712682, 0.11635528346628864),
        (0.984807753012208, 0.11635528346628864),
        (0.9579895123154889, 0.11635528346628864),
        (0.918216106880274, 0.11635528346628864),
        (0.8660254037844387, 0.11635528346628864),
        (0.8021231927550438, 0.11635528346628864),
        (0.7273736415730488, 0.11635528346628864),
        (0.6427876096865395, 0.11635528346628864),
        (0.5495089780708061, 0.11635528346628864),
        (0.4487991802004623, 0.11635528346628864),
        (0.3420201433256688, 0.11635528346628864),
        (0.23061587074244025, 0.11635528346628864),
        (0.11609291412523053, 0.11635528346628864),
        (0.0, 0.11635528346628864),
    ],
    &[
        (0.9984268150178166, 0.1121997376282069),
        (0.9858710185182359, 0.1121997376282069),
        (0.9609173219450996, 0.1121997376282069),
        (0.9238795325112867, 0.1121997376282069),
        (0.8752234219087537, 0.1121997376282069),
        (0.8155608689592602, 0.1121997376282069),
        (0.7456421648831656, 0.1121997376282069),
        (0.6663465779520039, 0.1121997376282069),
        (0.5786712961798057, 0.1121997376282069),
        (0.4837188871052398, 0.1121997376282069),
        (0.38268343236508984, 0.1121997376282069),
        (0.2768355114248494, 0.1121997376282069),
        (0.16750622330473647, 0.1121997376282069),
        (0.056070447237191845, 0.1121997376282069),
    ],
    &[
        (0.9985334138511238, 0.10833078115826873),
        (0.9868265225415261, 0.10833078115826873),
        (0.9635499925192229, 0.10833078115826873),
        (0.9289767198167914, 0.10833078115826873),
        (0.8835120444460229, 0.10833078115826873),
        (0.8276889981568906, 0.10833078115826873),
        (0.7621620551276365, 0.10833078115826873),
        (0.6876994588534233, 0.10833078115826873),
        (0.6051742151937651, 0.10833078115826873),
        (0.5155538571770217, 0.10833078115826873),
        (0.4198891015602646, 0.10833078115826873),
        (0.31930153013597995, 0.10833078115826873),
        (0.214970440211024, 0.10833078115826873),
        (0.10811901842394187, 0.10833078115826873),
        (0.0, 0.10833078115826873),
    ],
    &[
        (0.9986295347545738, 0.10471975511965977),
        (0.9876883405951378, 0.10471975511965977),
        (0.9659258262890683, 0.10471975511965977),
        (0.9335804264972017, 0.10471975511965977),
        (0.8910065241883679, 0.10471975511965977),
        (0.838670567945424, 0.10471975511965977),
        (0.7771459614569709, 0.10471975511965977),
        (f64::consts::FRAC_1_SQRT_2, 0.10471975511965977),
        (0.6293203910498375, 0.10471975511965977),
        (0.5446390350150272, 0.10471975511965977),
        (0.4539904997395468, 0.10471975511965977),
        (0.3583679495453004, 0.10471975511965977),
        (0.25881904510252096, 0.10471975511965977),
        (0.15643446504023092, 0.10471975511965977),
        (0.052335956242943966, 0.10471975511965977),
    ],
    &[
        (0.9987165071710528, 0.10134169850289655),
        (0.9884683243281114, 0.10134169850289655),
        (0.9680771188662043, 0.10134169850289655),
        (0.9377521321470804, 0.10134169850289655),
        (0.8978045395707417, 0.10134169850289655),
        (0.8486442574947509, 0.10134169850289655),
        (0.7907757369376985, 0.10134169850289655),
        (0.72479278722912, 0.10134169850289655),
        (0.6513724827222223, 0.10134169850289655),
        (0.5712682150947923, 0.10134169850289655),
        (0.485301962531081, 0.10134169850289655),
        (0.39435585511331855, 0.10134169850289655),
        (0.299363122973358, 0.10134169850289655),
        (0.20129852008866012, 0.10134169850289655),
        (0.10116832198743222, 0.10134169850289655),
        (0.0, 0.10134169850289655),
    ],
    &[
        (0.9987954562051724, 0.09817477042468103),
        (0.989176509964781, 0.09817477042468103),
        (0.970031253194544, 0.09817477042468103),
        (0.9415440651830208, 0.09817477042468103),
        (0.9039892931234433, 0.09817477042468103),
        (0.8577286100002721, 0.09817477042468103),
        (0.8032075314806449, 0.09817477042468103),
        (0.7409511253549591, 0.09817477042468103),
        (0.6715589548470183, 0.09817477042468103),
        (0.5956993044924335, 0.09817477042468103),
        (0.5141027441932217, 0.09817477042468103),
        (0.4275550934302822, 0.09817477042468103),
        (0.33688985339222005, 0.09817477042468103),
        (0.24298017990326398, 0.09817477042468103),
        (0.14673047445536175, 0.09817477042468103),
        (0.049067674327418126, 0.09817477042468103),
    ],
    &[
        (0.998867339183008, 0.09519977738150888),
        (0.9898214418809327, 0.09519977738150888),
        (0.9718115683235417, 0.09519977738150888),
        (0.9450008187146685, 0.09519977738150888),
        (0.9096319953545184, 0.09519977738150888),
        (0.8660254037844387, 0.09519977738150888),
        (0.8145759520503357, 0.09519977738150888),
        (0.7557495743542584, 0.09519977738150888),
        (0.690079011482112, 0.09519977738150888),
        (0.6181589862206053, 0.09519977738150888),
        (0.5406408174555977, 0.09519977738150888),
        (0.45822652172741046, 0.09519977738150888),
        (0.3716624556603275, 0.09519977738150888),
        (0.2817325568414298, 0.09519977738150888),
        (0.18925124436041021, 0.09519977738150888),
        (0.09505604330418281, 0.09519977738150888),
        (0.0, 0.09519977738150888),
    ],
    &[
        (0.9989329748023724, 0.09239978392911156),
        (0.9904104308752052, 0.09239978392911156),
        (0.9734380543606929, 0.09239978392911156),
        (0.9481606475909659, 0.09239978392911156),
        (0.914793868488021, 0.09239978392911156),
        (0.8736223906463696, 0.09239978392911156),
        (0.8249974745983023, 0.09239978392911156),
        (0.7693339709828789, 0.09239978392911156),
        (f64::consts::FRAC_1_SQRT_2, 0.09239978392911156),
        (0.6388468056519613, 0.09239978392911156),
        (0.5651364144225919, 0.09239978392911156),
        (0.48660447856685624, 0.09239978392911156),
        (0.4039210048718949, 0.09239978392911156),
        (0.31779141958190166, 0.09239978392911156),
        (0.22895054995013414, 0.09239978392911156),
        (0.1381563549518823, 0.09239978392911156),
        (0.04618345864573952, 0.09239978392911156),
    ],
    &[
        (0.9989930665413147, 0.08975979010256552),
        (0.9909497617679348, 0.08975979010256552),
        (0.9749279121818236, 0.08975979010256552),
        (0.9510565162951535, 0.08975979010256552),
        (0.9195277725514507, 0.08975979010256552),
        (0.880595531856738, 0.08975979010256552),
        (0.8345732537213026, 0.08975979010256552),
        (0.7818314824680298, 0.08975979010256552),
        (0.7227948638273916, 0.08975979010256552),
        (0.6579387259397126, 0.08975979010256552),
        (0.5877852522924731, 0.08975979010256552),
        (0.5128992774059061, 0.08975979010256552),
        (0.4338837391175582, 0.08975979010256552),
        (0.35137482408134274, 0.08975979010256552),
        (0.2660368455666752, 0.08975979010256552),
        (0.1785568947986367, 0.08975979010256552),
        (0.08963930890343355, 0.08975979010256552),
        (0.0, 0.08975979010256552),
    ],
    &[
        (0.9990482215818578, 0.08726646259971647),
        (0.9914448613738104, 0.08726646259971647),
        (0.9762960071199334, 0.08726646259971647),
        (0.9537169507482269, 0.08726646259971647),
        (0.9238795325112867, 0.08726646259971647),
        (0.8870108331782217, 0.08726646259971647),
        (0.8433914458128857, 0.08726646259971647),
        (0.7933533402912352, 0.08726646259971647),
        (0.7372773368101241, 0.08726646259971647),
        (0.6755902076156604, 0.08726646259971647),
        (0.6087614290087207, 0.08726646259971647),
        (0.5372996083468239, 0.08726646259971647),
        (0.4617486132350341, 0.08726646259971647),
        (0.38268343236508984, 0.08726646259971647),
        (0.3007057995042733, 0.08726646259971647),
        (0.2164396139381029, 0.08726646259971647),
        (0.1305261922200517, 0.08726646259971647),
        (0.04361938736533601, 0.08726646259971647),
    ],
    &[
        (0.9990989662046815, 0.08490790955648089),
        (0.9919004352588768, 0.08490790955648089),
        (0.9775552389476861, 0.08490790955648089),
        (0.956166734739251, 0.08490790955648089),
        (0.9278890272965093, 0.08490790955648089),
        (0.8929258581495685, 0.08490790955648089),
        (0.8515291377333113, 0.08490790955648089),
        (0.8039971303669405, 0.08490790955648089),
        (0.7506723052527243, 0.08490790955648089),
        (0.6919388689775461, 0.08490790955648089),
        (0.6282199972956423, 0.08490790955648089),
        (0.5599747861375953, 0.08490790955648089),
        (0.48769494381363443, 0.08490790955648089),
        (0.4119012482439926, 0.08490790955648089),
        (0.3331397947420575, 0.08490790955648089),
        (0.25197806138512513, 0.08490790955648089),
        (0.16900082032184885, 0.08490790955648089),
        (0.084805924475509, 0.08490790955648089),
        (0.0, 0.08490790955648089),
    ],
    &[
        (0.999145758387301, 0.08267349088394192),
        (0.992320579737045, 0.08267349088394192),
        (0.9787168453273545, 0.08267349088394192),
        (0.9584274824582527, 0.08267349088394192),
        (0.931591088051279, 0.08267349088394192),
        (0.8983909818919789, 0.08267349088394192),
        (0.8590539543698852, 0.08267349088394192),
        (0.813848717270195, 0.08267349088394192),
        (0.7630840681998066, 0.08267349088394192),
        (f64::consts::FRAC_1_SQRT_2, 0.08267349088394192),
        (0.6462992378609409, 0.08267349088394192),
        (0.5810768154019383, 0.08267349088394192),
        (0.511885049089601, 0.08267349088394192),
        (0.43919658884737034, 0.08267349088394192),
        (0.36350797056382983, 0.08267349088394192),
        (0.28533622424910526, 0.08267349088394192),
        (0.20521534219563448, 0.08267349088394192),
        (0.1236926312693478, 0.08267349088394192),
        (0.04132497424881339, 0.08267349088394192),
    ],
    &[
        (0.9991889981715696, 0.08055365778435367),
        (0.992708874098054, 0.08055365778435367),
        (0.9797906520422677, 0.08055365778435367),
        (0.9605181116313724, 0.08055365778435367),
        (0.9350162426854148, 0.08055365778435367),
        (0.9034504346103823, 0.08055365778435367),
        (0.8660254037844387, 0.08055365778435367),
        (0.8229838658936565, 0.08055365778435367),
        (0.7746049618276546, 0.08055365778435367),
        (0.7212024473438146, 0.08055365778435367),
        (0.6631226582407953, 0.08055365778435367),
        (0.600742264237979, 0.08055365778435367),
        (0.5344658261278012, 0.08055365778435367),
        (0.4647231720437686, 0.08055365778435367),
        (0.3919666098600751, 0.08055365778435367),
        (0.31666799380147265, 0.08055365778435367),
        (0.23931566428755782, 0.08055365778435367),
        (0.16041128085776046, 0.08055365778435367),
        (0.08046656871672601, 0.08055365778435367),
        (0.0, 0.08055365778435367),
    ],
    &[
        (0.9992290362407229, 0.07853981633974483),
        (0.9930684569549263, 0.07853981633974483),
        (0.9807852804032304, 0.07853981633974483),
        (0.9624552364536473, 0.07853981633974483),
        (0.9381913359224842, 0.07853981633974483),
        (0.9081431738250813, 0.07853981633974483),
        (0.8724960070727972, 0.07853981633974483),
        (0.8314696123025452, 0.07853981633974483),
        (0.785316930880745, 0.07853981633974483),
        (0.7343225094356856, 0.07853981633974483),
        (0.6788007455329418, 0.07853981633974483),
        (0.619093949309834, 0.07853981633974483),
        (0.5555702330196023, 0.07853981633974483),
        (0.48862124149695496, 0.07853981633974483),
        (0.41865973753742813, 0.07853981633974483),
        (0.346117057077493, 0.07853981633974483),
        (0.2714404498650743, 0.07853981633974483),
        (0.19509032201612833, 0.07853981633974483),
        (0.1175373974578377, 0.07853981633974483),
        (0.039259815759068666, 0.07853981633974483),
    ],
    &[
        (0.99926618105081, 0.07662421106316569),
        (0.993402089759675, 0.07662421106316569),
        (0.9817083199968549, 0.07662421106316569),
        (0.964253495453141, 0.07662421106316569),
        (0.9411400479795615, 0.07662421106316569),
        (0.91250361647655, 0.07662421106316569),
        (0.8785122509109424, 0.07662421106316569),
        (0.83936542613195, 0.07662421106316569),
        (0.7952928712734264, 0.07662421106316569),
        (0.7465532216119626, 0.07662421106316569),
        (0.6934325007922417, 0.07662421106316569),
        (0.6362424423265598, 0.07662421106316569),
        (0.5753186602186205, 0.07662421106316569),
        (0.5110186794471103, 0.07662421106316569),
        (0.4437198378669597, 0.07662421106316569),
        (0.3738170718407688, 0.07662421106316569),
        (0.3017205985951922, 0.07662421106316569),
        (0.2278535089031375, 0.07662421106316569),
        (0.15264928421887447, 0.07662421106316569),
        (0.07654925283649566, 0.07662421106316569),
        (0.0, 0.07662421106316569),
    ],
    &[
        (0.9993007047883986, 0.07479982508547127),
        (0.9937122098932426, 0.07479982508547127),
        (0.9825664732332883, 0.07479982508547127),
        (0.9659258262890683, 0.07479982508547127),
        (0.9438833303083676, 0.07479982508547127),
        (0.9165622558699762, 0.07479982508547127),
        (0.8841153935046099, 0.07479982508547127),
        (0.8467241992282842, 0.07479982508547127),
        (0.8045977797666684, 0.07479982508547127),
        (0.757971723145453, 0.07479982508547127),
        (f64::consts::FRAC_1_SQRT_2, 0.07479982508547127),
        (0.6522874112781213, 0.07479982508547127),
        (0.5938201855735017, 0.07479982508547127),
        (0.5320320765153368, 0.07479982508547127),
        (0.46726862827306215, 0.07479982508547127),
        (0.3998920243197411, 0.07479982508547127),
        (0.3302790619551673, 0.07479982508547127),
        (0.25881904510252096, 0.07479982508547127),
        (0.18591160716291472, 0.07479982508547127),
        (0.11196447610330813, 0.07479982508547127),
        (0.037391194276325826, 0.07479982508547127),
    ],
    &[
        (0.9993328483702394, 0.07306029426953008),
        (0.9940009752399459, 0.07306029426953008),
        (0.9833656768294661, 0.07306029426953008),
        (0.9674836970574252, 0.07306029426953008),
        (0.9464397731576093, 0.07306029426953008),
        (0.9203461835691594, 0.07306029426953008),
        (0.889342148882519, 0.07306029426953008),
        (0.8535930890373464, 0.07306029426953008),
        (0.8132897407355654, 0.07306029426953008),
        (0.768647139778532, 0.07306029426953008),
        (0.7199034737579959, 0.07306029426953008),
        (0.6673188112222395, 0.07306029426953008),
        (0.6111737140978493, 0.07306029426953008),
        (0.5517677407704459, 0.07306029426953008),
        (0.48941784781108555, 0.07306029426953008),
        (0.424456698875815, 0.07306029426953008),
        (0.3572308898011328, 0.07306029426953008),
        (0.2880990993652375, 0.07306029426953008),
        (0.21743017558155697, 0.07306029426953008),
        (0.14560116773500476, 0.07306029426953008),
        (0.07299531466090749, 0.07306029426953008),
        (0.0, 0.07306029426953008),
    ],
    &[
        (0.9993628256569916, 0.07139983303613166),
        (0.9942703017718973, 0.07139983303613166),
        (0.9841112043361161, 0.07139983303613166),
        (0.9689373017815074, 0.07139983303613166),
        (0.9488259168373196, 0.07139983303613166),
        (0.9238795325112867, 0.07139983303613166),
        (0.8942252698597113, 0.07139983303613166),
        (0.8600142402077006, 0.07139983303613166),
        (0.8214207751204916, 0.07139983303613166),
        (0.7786415380497551, 0.07139983303613166),
        (0.7318945221817255, 0.07139983303613166),
        (0.6814179395938912, 0.07139983303613166),
        (0.627469007380852, 0.07139983303613166),
        (0.5703226369349641, 0.07139983303613166),
        (0.5102700330608996, 0.07139983303613166),
        (0.44761721006271254, 0.07139983303613166),
        (0.38268343236508984, 0.07139983303613166),
        (0.315799587615025, 0.07139983303613166),
        (0.24730650055421563, 0.07139983303613166),
        (0.1775531962543032, 0.07139983303613166),
        (0.10689512156511279, 0.07139983303613166),
        (0.035692333838980496, 0.07139983303613166),
    ],
    &[
        (0.9993908270190958, 0.06981317007977318),
        (0.9945218953682733, 0.06981317007977318),
        (0.984807753012208, 0.06981317007977318),
        (0.9702957262759965, 0.06981317007977318),
        (0.9510565162951535, 0.06981317007977318),
        (0.9271838545667874, 0.06981317007977318),
        (0.898794046299167, 0.06981317007977318),
        (0.8660254037844387, 0.06981317007977318),
        (0.8290375725550416, 0.06981317007977318),
        (0.7880107536067219, 0.06981317007977318),
        (0.7431448254773942, 0.06981317007977318),
        (0.6946583704589973, 0.06981317007977318),
        (0.6427876096865394, 0.06981317007977318),
        (0.5877852522924731, 0.06981317007977318),
        (0.5299192642332049, 0.06981317007977318),
        (0.46947156278589086, 0.06981317007977318),
        (0.4067366430758002, 0.06981317007977318),
        (0.3420201433256688, 0.06981317007977318),
        (0.27563735581699916, 0.06981317007977318),
        (0.20791169081775945, 0.06981317007977318),
        (0.13917310096006547, 0.06981317007977318),
        (0.06975647374412523, 0.06981317007977318),
        (0.0, 0.06981317007977318),
    ],
    &[
        (0.999417022366174, 0.06829549246934333),
        (0.9947572788580948, 0.06829549246934333),
        (0.9854595177171969, 0.06829549246934333),
        (0.9715670893979415, 0.06829549246934333),
        (0.9531447668141608, 0.06829549246934333),
        (0.9302784433378332, 0.06829549246934333),
        (0.9030747323245327, 0.06829549246934333),
        (0.8716604700327513, 0.06829549246934333),
        (0.836182124254711, 0.06829549246934333),
        (0.7968051114159046, 0.06829549246934333),
        (0.7537130253273611, 0.06829549246934333),
        (f64::consts::FRAC_1_SQRT_2, 0.06829549246934333),
        (0.6572036788179725, 0.06829549246934333),
        (0.6042363895210946, 0.06829549246934333),
        (0.5484518712493187, 0.06829549246934333),
        (0.49011021717801734, 0.06829549246934333),
        (0.42948344303008185, 0.06829549246934333),
        (0.3668542188130565, 0.06829549246934333),
        (0.3025145508810758, 0.06829549246934333),
        (0.2367644204664468, 0.06829549246934333),
        (0.16991038502866676, 0.06829549246934333),
        (0.10226414894203437, 0.06829549246934333),
        (0.03414111018596805, 0.06829549246934333),
    ],
    &[
        (0.9994415637302546, 0.06684239688488922),
        (0.994977815088504, 0.06684239688488922),
        (0.9860702539900286, 0.06684239688488922),
        (0.9727586637650372, 0.06684239688488922),
        (0.9551024972069124, 0.06684239688488922),
        (0.9331806110416025, 0.06684239688488922),
        (0.9070909137343407, 0.06684239688488922),
        (0.8769499282066715, 0.06684239688488922),
        (0.842892271416797, 0.06684239688488922),
        (0.8050700531275629, 0.06684239688488922),
        (0.7636521965473321, 0.06684239688488922),
        (0.7188236838779294, 0.06684239688488922),
        (0.6707847301392235, 0.06684239688488922),
        (0.6197498889602449, 0.06684239688488922),
        (0.5659470943305952, 0.06684239688488922),
        (0.5096166425919175, 0.06684239688488922),
        (0.45101011921610185, 0.06684239688488922),
        (0.3903892751634948, 0.06684239688488922),
        (0.3280248578395691, 0.06684239688488922),
        (0.26419540187128593, 0.06684239688488922),
        (0.19918598510383623, 0.06684239688488922),
        (0.13328695537377896, 0.06684239688488922),
        (0.06679263374512164, 0.06684239688488922),
        (0.0, 0.06684239688488922),
    ],
    &[
        (0.9994645874763657, 0.06544984694978735),
        (0.9951847266721969, 0.06544984694978735),
        (0.986643332084879, 0.06544984694978735),
        (0.9738769792773336, 0.06544984694978735),
        (0.9569403357322088, 0.06544984694978735),
        (0.9359059267573258, 0.06544984694978735),
        (0.9108638249211758, 0.06544984694978735),
        (0.881921264348355, 0.06544984694978735),
        (0.8492021815265789, 0.06544984694978735),
        (0.8128466845916152, 0.06544984694978735),
        (0.773010453362737, 0.06544984694978735),
        (0.7298640726978357, 0.06544984694978735),
        (0.6835923020228714, 0.06544984694978735),
        (0.6343932841636456, 0.06544984694978735),
        (0.5824776968678023, 0.06544984694978735),
        (0.5280678506503681, 0.06544984694978735),
        (0.4713967368259978, 0.06544984694978735),
        (0.41270702980439494, 0.06544984694978735),
        (0.3522500479212336, 0.06544984694978735),
        (0.2902846772544625, 0.06544984694978735),
        (0.22707626303437345, 0.06544984694978735),
        (0.16289547339458882, 0.06544984694978735),
        (0.09801714032956077, 0.06544984694978735),
        (0.03271908282177639, 0.06544984694978735),
    ],
    &[
        (0.9994862162006879, 0.0641141357875468),
        (0.9953791129491982, 0.0641141357875468),
        (0.9871817834144502, 0.0641141357875468),
        (0.9749279121818236, 0.0641141357875468),
        (0.9586678530366607, 0.0641141357875468),
        (0.9384684220497604, 0.0641141357875468),
        (0.9144126230158125, 0.0641141357875468),
        (0.8865993063730001, 0.0641141357875468),
        (0.8551427630053462, 0.0641141357875468),
        (0.820172254596956, 0.0641141357875468),
        (0.7818314824680298, 0.0641141357875468),
        (0.7402779970753156, 0.0641141357875468),
        (0.6956825506034865, 0.0641141357875468),
        (0.6482283953077885, 0.0641141357875468),
        (0.598110530491216, 0.0641141357875468),
        (0.5455349012105487, 0.0641141357875468),
        (0.4907175520039379, 0.0641141357875468),
        (0.4338837391175582, 0.0641141357875468),
        (0.3752670048793742, 0.0641141357875468),
        (0.31510821802362077, 0.0641141357875468),
        (0.2536545839095075, 0.0641141357875468),
        (0.19115862870137248, 0.0641141357875468),
        (0.12787716168450622, 0.0641141357875468),
        (0.06407021998071318, 0.0641141357875468),
        (0.0, 0.0641141357875468),
    ],
    &[
        (0.9995065603657316, 0.06283185307179587),
        (0.99556196460308, 0.06283185307179587),
        (0.9876883405951378, 0.06283185307179587),
        (0.9759167619387474, 0.06283185307179587),
        (0.9602936856769431, 0.06283185307179587),
        (0.9408807689542255, 0.06283185307179587),
        (0.9177546256839811, 0.06283185307179587),
        (0.8910065241883679, 0.06283185307179587),
        (0.8607420270039436, 0.06283185307179587),
        (0.8270805742745618, 0.06283185307179587),
        (0.7901550123756903, 0.06283185307179587),
        (0.7501110696304596, 0.06283185307179587),
        (0.7071067811865475, 0.06283185307179587),
        (0.6613118653236518, 0.06283185307179587),
        (0.6129070536529765, 0.06283185307179587),
        (0.5620833778521306, 0.06283185307179587),
        (0.5090414157503712, 0.06283185307179587),
        (0.4539904997395468, 0.06283185307179587),
        (0.39714789063478056, 0.06283185307179587),
        (0.33873792024529126, 0.06283185307179587),
        (0.2789911060392293, 0.06283185307179587),
        (0.21814324139654248, 0.06283185307179587),
        (0.1564344650402307, 0.06283185307179587),
        (0.09410831331851428, 0.06283185307179587),
        (0.031410759078128174, 0.06283185307179587),
    ],
    &[
        (0.9995257197133659, 0.06159985595274104),
        (0.9957341762950345, 0.06159985595274104),
        (0.9881654720812594, 0.06159985595274104),
        (0.9768483177596007, 0.06159985595274104),
        (0.961825643172819, 0.06159985595274104),
        (0.9431544344712774, 0.06159985595274104),
        (0.9209055179449537, 0.06159985595274104),
        (0.8951632913550623, 0.06159985595274104),
        (0.8660254037844387, 0.06159985595274104),
        (0.8336023852211195, 0.06159985595274104),
        (0.7980172272802396, 0.06159985595274104),
        (0.7594049166547071, 0.06159985595274104),
        (0.717911923064442, 0.06159985595274104),
        (0.6736956436465572, 0.06159985595274104),
        (0.6269238058941065, 0.06159985595274104),
        (0.5777738314082511, 0.06159985595274104),
        (0.5264321628773558, 0.06159985595274104),
        (0.47309355683601007, 0.06159985595274104),
        (0.4179603448867836, 0.06159985595274104),
        (0.36124166618715303, 0.06159985595274104),
        (0.3031526741130436, 0.06159985595274104),
        (0.24391372010837717, 0.06159985595274104),
        (0.1837495178165703, 0.06159985595274104),
        (0.12288829066471427, 0.06159985595274104),
        (0.061560906133942946, 0.06159985595274104),
        (0.0, 0.06159985595274104),
    ],
    &[
        (0.9995437844895334, 0.06041524333826525),
        (0.995896557617091, 0.06041524333826525),
        (0.9886154122075342, 0.06041524333826525),
        (0.9777269163708469, 0.06041524333826525),
        (0.9632708010475163, 0.06041524333826525),
        (0.9452998150346402, 0.06041524333826525),
        (0.9238795325112867, 0.06041524333826525),
        (0.899088113765426, 0.06041524333826525),
        (0.8710160199955156, 0.06041524333826525),
        (0.8397656832273979, 0.06041524333826525),
        (0.8054511325509459, 0.06041524333826525),
        (0.7681975780402804, 0.06041524333826525),
        (0.7281409538757884, 0.06041524333826525),
        (0.6854274223350397, 0.06041524333826525),
        (0.640212840462488, 0.06041524333826525),
        (0.5926621913640168, 0.06041524333826525),
        (0.5429489822014787, 0.06041524333826525),
        (0.4912546110838773, 0.06041524333826525),
        (0.43776770516534047, 0.06041524333826525),
        (0.38268343236508984, 0.06041524333826525),
        (0.3262027892208692, 0.06041524333826525),
        (0.2685318674743767, 0.06041524333826525),
        (0.20988110206484756, 0.06041524333826525),
        (0.15046450327478306, 0.06041524333826525),
        (0.0904988758296377, 0.06041524333826525),
        (0.03020302780088877, 0.06041524333826525),
    ],
    &[
        (0.9995608365087943, 0.05927533308659987),
        (0.9960498426152169, 0.05927533308659987),
        (0.989040187322164, 0.05927533308659987),
        (0.978556492299504, 0.05927533308659987),
        (0.9646355819083587, 0.05927533308659987),
        (0.9473263538541914, 0.05927533308659987),
        (0.9266896074318335, 0.05927533308659987),
        (0.9027978299657435, 0.05927533308659987),
        (0.8757349421956369, 0.05927533308659987),
        (0.8455960035018261, 0.05927533308659987),
        (0.8124868780056813, 0.05927533308659987),
        (0.7765238627180425, 0.05927533308659987),
        (0.7378332790417274, 0.05927533308659987),
        (0.6965510290629972, 0.05927533308659987),
        (0.6528221181905217, 0.05927533308659987),
        (0.6068001458185934, 0.05927533308659987),
        (0.5586467658036526, 0.05927533308659987),
        (0.5085311186492205, 0.05927533308659987),
        (0.4566292373937132, 0.05927533308659987),
        (0.40312342928797235, 0.05927533308659987),
        (0.34820163543439897, 0.05927533308659987),
        (0.2920567706369759, 0.05927533308659987),
        (0.23488604578098377, 0.05927533308659987),
        (0.1768902751225731, 0.05927533308659987),
        (0.118273170921366, 0.05927533308659987),
        (0.05924062789371452, 0.05927533308659987),
        (0.0, 0.05927533308659987),
    ],
    &[
        (0.9995769500822006, 0.05817764173314432),
        (0.9961946980917455, 0.05817764173314432),
        (0.9894416385809445, 0.05817764173314432),
        (0.9793406217655515, 0.05817764173314432),
        (0.9659258262890683, 0.05817764173314432),
        (0.9492426435730339, 0.05817764173314432),
        (0.9293475242268224, 0.05817764173314432),
        (0.9063077870366499, 0.05817764173314432),
        (0.8802013911801112, 0.05817764173314432),
        (0.8511166724369997, 0.05817764173314432),
        (0.8191520442889918, 0.05817764173314432),
        (0.7844156649195757, 0.05817764173314432),
        (0.747025071240996, 0.05817764173314432),
        (f64::consts::FRAC_1_SQRT_2, 0.05817764173314432),
        (0.6647958656139379, 0.05817764173314432),
        (0.6202354912682602, 0.05817764173314432),
        (0.5735764363510462, 0.05817764173314432),
        (0.5249765803345604, 0.05817764173314432),
        (0.4746003697476406, 0.05817764173314432),
        (0.4226182617406996, 0.05817764173314432),
        (0.36920614731268464, 0.05817764173314432),
        (0.31454475615161387, 0.05817764173314432),
        (0.25881904510252096, 0.05817764173314432),
        (0.20221757233203813, 0.05817764173314432),
        (0.14493185930724692, 0.05817764173314432),
        (0.08715574274765836, 0.05817764173314432),
        (0.02908471874311158, 0.05817764173314432),
    ],
    &[
        (0.9995921928281892, 0.057119866428905326),
        (0.9963317308626913, 0.057119866428905326),
        (0.9898214418809327, 0.057119866428905326),
        (0.9800825610923934, 0.057119866428905326),
        (0.9671468547019572, 0.057119866428905326),
        (0.9510565162951535, 0.057119866428905326),
        (0.9318640292114523, 0.057119866428905326),
        (0.9096319953545184, 0.057119866428905326),
        (0.8844329309978144, 0.057119866428905326),
        (0.856349030251589, 0.057119866428905326),
        (0.825471896962774, 0.057119866428905326),
        (0.7919022459222751, 0.057119866428905326),
        (0.7557495743542584, 0.057119866428905326),
        (0.7171318047589635, 0.057119866428905326),
        (0.6761749002740195, 0.057119866428905326),
        (0.6330124538088705, 0.057119866428905326),
        (0.5877852522924731, 0.057119866428905326),
        (0.5406408174555977, 0.057119866428905326),
        (0.4917329246456038, 0.057119866428905326),
        (0.44122110124322145, 0.057119866428905326),
        (0.38927010631739156, 0.057119866428905326),
        (0.3360493932154303, 0.057119866428905326),
        (0.2817325568414298, 0.057119866428905326),
        (0.2264967674257646, 0.057119866428905326),
        (0.17052219263262391, 0.057119866428905326),
        (0.11399140989054066, 0.057119866428905326),
        (0.057088810862768145, 0.057119866428905326),
        (0.0, 0.057119866428905326),
    ],
    &[
        (0.9996066263830529, 0.05609986881410345),
        (0.9964614941176192, 0.05609986881410345),
        (0.9901811253364456, 0.05609986881410345),
        (0.9807852804032304, 0.05609986881410345),
        (0.9683035221222615, 0.05609986881410345),
        (0.9527751227228963, 0.05609986881410345),
        (0.9342489402945998, 0.05609986881410345),
        (0.9127832650613189, 0.05609986881410345),
        (0.8884456359788723, 0.05609986881410345),
        (0.861312628232409, 0.05609986881410345),
        (0.8314696123025452, 0.05609986881410345),
        (0.799010485358249, 0.05609986881410345),
        (0.7640373758216075, 0.05609986881410345),
        (0.7266603220340271, 0.05609986881410345),
        (0.6869969260349017, 0.05609986881410345),
        (0.6451719835420877, 0.05609986881410345),
        (0.6013170912984058, 0.05609986881410345),
        (0.5555702330196023, 0.05609986881410345),
        (0.5080753452465295, 0.05609986881410345),
        (0.4589818644675377, 0.05609986881410345),
        (0.4084442569359962, 0.05609986881410345),
        (0.35662153266231306, 0.05609986881410345),
        (0.3036767451096148, 0.05609986881410345),
        (0.2497764781672269, 0.05609986881410345),
        (0.19509032201612833, 0.05609986881410345),
        (0.13979033953549952, 0.05609986881410345),
        (0.0840505249292476, 0.05609986881410345),
        (0.028046256275869017, 0.05609986881410345),
    ],
    &[
        (0.9996203070249514, 0.05511566058929462),
        (0.9965844930066698, 0.05511566058929462),
        (0.9905220846375032, 0.05511566058929462),
        (0.9814514932524179, 0.05511566058929462),
        (0.9694002659393304, 0.05511566058929462),
        (0.9544050018795074, 0.05511566058929462),
        (0.9365112411970549, 0.05511566058929462),
        (0.9157733266550575, 0.05511566058929462),
        (0.892254238618394, 0.05511566058929462),
        (0.8660254037844387, 0.05511566058929462),
        (0.8371664782625287, 0.05511566058929462),
        (0.8057651056609781, 0.05511566058929462),
        (0.771916650916321, 0.05511566058929462),
        (0.7357239106731317, 0.05511566058929462),
        (0.6972968010939955, 0.05511566058929462),
        (0.6567520240477345, 0.05511566058929462),
        (0.6142127126896679, 0.05511566058929462),
        (0.5698080575102663, 0.05511566058929462),
        (0.523672913987878, 0.05511566058929462),
        (0.4759473930370736, 0.05511566058929462),
        (0.42677643549640376, 0.05511566058929462),
        (0.37630937194783554, 0.05511566058929462),
        (0.32469946920468357, 0.05511566058929462),
        (0.2721034648453351, 0.05511566058929462),
        (0.2186810912063761, 0.05511566058929462),
        (0.1645945902807342, 0.05511566058929462),
        (0.11000822099407959, 0.05511566058929462),
        (0.05508776035586573, 0.05511566058929462),
        (0.0, 0.05511566058929462),
    ],
    &[
        (0.999633286223284, 0.054165390579134366),
        (0.9967011895602228, 0.054165390579134366),
        (0.9908455965788068, 0.054165390579134366),
        (0.982083682742156, 0.054165390579134366),
        (0.9704411482532114, 0.054165390579134366),
        (0.9559521426716117, 0.054165390579134366),
        (0.9386591647471505, 0.054165390579134366),
        (0.9186129377636217, 0.054165390579134366),
        (0.895872260758688, 0.054165390579134366),
        (0.8705038360561721, 0.054165390579134366),
        (0.842582073616649, 0.054165390579134366),
        (0.8121888727802111, 0.054165390579134366),
        (0.7794133820415916, 0.054165390579134366),
        (0.7443517375622704, 0.054165390579134366),
        (f64::consts::FRAC_1_SQRT_2, 0.054165390579134366),
        (0.6677877587886957, 0.054165390579134366),
        (0.6265099998359867, 0.054165390579134366),
        (0.5833945791074939, 0.054165390579134366),
        (0.5385679615609043, 0.054165390579134366),
        (0.49216163138900726, 0.054165390579134366),
        (0.4443117063539035, 0.054165390579134366),
        (0.39515853853015553, 0.054165390579134366),
        (0.3448463026279705, 0.054165390579134366),
        (0.2935225731039348, 0.054165390579134366),
        (0.24133789129970568, 0.054165390579134366),
        (0.1884453238783183, 0.054165390579134366),
        (0.1350000138532901, 0.054165390579134366),
        (0.08115872552743125, 0.054165390579134366),
        (0.027079384676134455, 0.054165390579134366),
    ],
    &[
        (0.9996456111234526, 0.05324733311169141),
        (0.9968120070307501, 0.05324733311169141),
        (0.9911528310040072, 0.05324733311169141),
        (0.982684124592521, 0.05324733311169141),
        (0.97142989326471, 0.05324733311169141),
        (0.9574220383620055, 0.05324733311169141),
        (0.9407002666710333, 0.05324733311169141),
        (0.921311977870413, 0.05324733311169141),
        (0.8993121301712192, 0.05324733311169141),
        (0.8747630845319613, 0.05324733311169141),
        (0.8477344278896709, 0.05324733311169141),
        (0.8183027759081691, 0.05324733311169141),
        (0.7865515558026426, 0.05324733311169141),
        (0.7525707698561385, 0.05324733311169141),
        (0.7164567402983152, 0.05324733311169141),
        (0.6783118362696161, 0.05324733311169141),
        (0.6382441836448202, 0.05324733311169141),
        (0.5963673585385015, 0.05324733311169141),
        (0.5528000653611935, 0.05324733311169141),
        (0.50766580033884, 0.05324733311169141),
        (0.4610925014493259, 0.05324733311169141),
        (0.41321218576837826, 0.05324733311169141),
        (0.3641605752528223, 0.05324733311169141),
        (0.3140767120219489, 0.05324733311169141),
        (0.26310256422752143, 0.05324733311169141),
        (0.2113826236296245, 0.05324733311169141),
        (0.15906349601907227, 0.05324733311169141),
        (0.10629348564736542, 0.05324733311169141),
        (0.05322217484217869, 0.05324733311169141),
        (0.0, 0.05324733311169141),
    ],
    &[
        (0.9996573249755573, 0.05235987755982988),
        (0.996917333733128, 0.05235987755982988),
        (0.9914448613738104, 0.05235987755982988),
        (0.9832549075639546, 0.05235987755982988),
        (0.9723699203976766, 0.05235987755982988),
        (0.958819734868193, 0.05235987755982988),
        (0.9426414910921784, 0.05235987755982988),
        (0.9238795325112867, 0.05235987755982988),
        (0.9025852843498606, 0.05235987755982988),
        (0.8788171126619654, 0.05235987755982988),
        (0.8526401643540922, 0.05235987755982988),
        (0.8241261886220157, 0.05235987755982988),
        (0.7933533402912353, 0.05235987755982988),
        (0.7604059656000309, 0.05235987755982988),
        (0.7253743710122876, 0.05235987755982988),
        (0.688354575693754, 0.05235987755982988),
        (0.6494480483301837, 0.05235987755982988),
        (0.6087614290087207, 0.05235987755982988),
        (0.5664062369248329, 0.05235987755982988),
        (0.5224985647159489, 0.05235987755982988),
        (0.47715876025960857, 0.05235987755982988),
        (0.43051109680829525, 0.05235987755982988),
        (0.38268343236508984, 0.05235987755982988),
        (0.3338068592337711, 0.05235987755982988),
        (0.28401534470392276, 0.05235987755982988),
        (0.23344536385590547, 0.05235987755982988),
        (0.18223552549214767, 0.05235987755982988),
        (0.1305261922200517, 0.05235987755982988),
        (0.078459095727845, 0.05235987755982988),
        (0.02617694830787336, 0.05235987755982988),
    ],
    &[
        (0.999668467514313, 0.05150151891130808),
        (0.9970175264485267, 0.05150151891130808),
        (0.9917226741361015, 0.05150151891130808),
        (0.9837979515735163, 0.05150151891130808),
        (0.9732643737003825, 0.05150151891130808),
        (0.9601498736716018, 0.05150151891130808),
        (0.9444892287836613, 0.05150151891130808),
        (0.926323968251495, 0.05150151891130808),
        (0.9057022630804715, 0.05150151891130808),
        (0.8826787983255474, 0.05150151891130808),
        (0.8573146280763323, 0.05150151891130808),
        (0.8296770135526189, 0.05150151891130808),
        (0.7998392447397195, 0.05150151891130808),
        (0.7678804460366, 0.05150151891130808),
        (0.7338853664321991, 0.05150151891130808),
        (0.6979441547663435, 0.05150151891130808),
        (0.6601521206712317, 0.05150151891130808),
        (0.6206094818274228, 0.05150151891130808),
        (0.5794210982045637, 0.05150151891130808),
        (0.5366961939916005, 0.05150151891130808),
        (0.49254806795386435, 0.05150151891130808),
        (0.4470937929851138, 0.05150151891130808),
        (0.4004539056512665, 0.05150151891130808),
        (0.35275208654909473, 0.05150151891130808),
        (0.30411483232751774, 0.05150151891130808),
        (0.25467112024122873, 0.05150151891130808),
        (0.20455206612620075, 0.05150151891130808),
        (0.15389057670406164, 0.05150151891130808),
        (0.1028209971373604, 0.05150151891130808),
        (0.05147875477034645, 0.05150151891130808),
        (0.0, 0.05150151891130808),
    ],
    &[
        (0.9996790752964305, 0.050670849251448276),
        (0.9971129134476474, 0.050670849251448276),
        (0.991987177050743, 0.050670849251448276),
        (0.9843150237975341, 0.050670849251448276),
        (0.974116147995387, 0.050670849251448276),
        (0.9614167300122125, 0.050670849251448276),
        (0.9462493690718369, 0.050670849251448276),
        (0.9286529995722622, 0.050670849251448276),
        (0.9086727911416249, 0.050670849251448276),
        (0.8863600326884082, 0.050670849251448276),
        (0.8617720007435496, 0.050670849251448276),
        (0.8349718124324074, 0.050670849251448276),
        (0.806028263454005, 0.050670849251448276),
        (0.7750156514834587, 0.050670849251448276),
        (0.7420135854509108, 0.050670849251448276),
        (f64::consts::FRAC_1_SQRT_2, 0.050670849251448276),
        (0.6703848439562785, 0.050670849251448276),
        (0.631942038446304, 0.050670849251448276),
        (0.5918770467870174, 0.050670849251448276),
        (0.5502927152373914, 0.050670849251448276),
        (0.5072957901801074, 0.050670849251448276),
        (0.46299664410512087, 0.050670849251448276),
        (0.4175089922850632, 0.050670849251448276),
        (0.37094960086976786, 0.050670849251448276),
        (0.3234379871492382, 0.050670849251448276),
        (0.2750961127544782, 0.050670849251448276),
        (0.22604807058373497, 0.050670849251448276),
        (0.17641976625780859, 0.050670849251448276),
        (0.12633859492212934, 0.050670849251448276),
        (0.07593311422524644, 0.050670849251448276),
        (0.025332714313188093, 0.050670849251448276),
    ],
    &[
        (0.9996891820008162, 0.049866550056980846),
        (0.9972037971811801, 0.049866550056980846),
        (0.9922392066001721, 0.049866550056980846),
        (0.984807753012208, 0.049866550056980846),
        (0.9749279121818236, 0.049866550056980846),
        (0.962624246950012, 0.049866550056980846),
        (0.9479273461671318, 0.049866550056980846),
        (0.9308737486442042, 0.049866550056980846),
        (0.9115058523116731, 0.049866550056980846),
        (0.8898718088114687, 0.049866550056980846),
        (0.8660254037844387, 0.049866550056980846),
        (0.8400259231507715, 0.049866550056980846),
        (0.8119380057158566, 0.049866550056980846),
        (0.7818314824680298, 0.049866550056980846),
        (0.7497812029677342, 0.049866550056980846),
        (0.7158668492597184, 0.049866550056980846),
        (0.6801727377709195, 0.049866550056980846),
        (0.6427876096865395, 0.049866550056980846),
        (0.6038044103254775, 0.049866550056980846),
        (0.5633200580636221, 0.049866550056980846),
        (0.5214352033794982, 0.049866550056980846),
        (0.47825397862131824, 0.049866550056980846),
        (0.4338837391175582, 0.049866550056980846),
        (0.3884347962746948, 0.049866550056980846),
        (0.3420201433256688, 0.049866550056980846),
        (0.2947551744109043, 0.049866550056980846),
        (0.24675739769029378, 0.049866550056980846),
        (0.19814614319939775, 0.049866550056980846),
        (0.14904226617617464, 0.049866550056980846),
        (0.09956784659581688, 0.049866550056980846),
        (0.04984588566069742, 0.049866550056980846),
        (0.0, 0.049866550056980846),
    ],
    &[
        (0.9996988186962042, 0.04908738521234052),
        (0.9972904566786902, 0.04908738521234052),
        (0.99247953459871, 0.04908738521234052),
        (0.9852776423889412, 0.04908738521234052),
        (0.9757021300385286, 0.04908738521234052),
        (0.9637760657954398, 0.04908738521234052),
        (0.9495281805930367, 0.04908738521234052),
        (0.932992798834739, 0.04908738521234052),
        (0.9142097557035307, 0.04908738521234052),
        (0.8932243011955153, 0.04908738521234052),
        (0.8700869911087115, 0.04908738521234052),
        (0.8448535652497071, 0.04908738521234052),
        (0.8175848131515837, 0.04908738521234052),
        (0.7883464276266063, 0.04908738521234052),
        (0.7572088465064846, 0.04908738521234052),
        (0.724247082951467, 0.04908738521234052),
        (0.6895405447370669, 0.04908738521234052),
        (0.6531728429537768, 0.04908738521234052),
        (0.6152315905806268, 0.04908738521234052),
        (0.5758081914178453, 0.04908738521234052),
        (0.5349976198870973, 0.04908738521234052),
        (0.4928981922297841, 0.04908738521234052),
        (0.4496113296546066, 0.04908738521234052),
        (0.40524131400498986, 0.04908738521234052),
        (0.3598950365349883, 0.04908738521234052),
        (0.3136817403988916, 0.04908738521234052),
        (0.2667127574748984, 0.04908738521234052),
        (0.21910124015686977, 0.04908738521234052),
        (0.17096188876030136, 0.04908738521234052),
        (0.12241067519921628, 0.04908738521234052),
        (0.07356456359966745, 0.04908738521234052),
        (0.024541228522912264, 0.04908738521234052),
    ],
    &[
        (0.9997080140801929, 0.0483321946706122),
        (0.9973731496914912, 0.0483321946706122),
        (0.992708874098054, 0.0483321946706122),
        (0.9857260809316509, 0.0483321946706122),
        (0.9764410788292721, 0.0483321946706122),
        (0.9648755533435515, 0.0483321946706122),
        (0.9510565162951535, 0.0483321946706122),
        (0.9350162426854148, 0.0483321946706122),
        (0.9167921953165824, 0.0483321946706122),
        (0.8964269372957038, 0.0483321946706122),
        (0.8739680326265179, 0.0483321946706122),
        (0.8494679351215211, 0.0483321946706122),
        (0.8229838658936564, 0.0483321946706122),
        (0.7945776797137543, 0.0483321946706122),
        (0.7643157205458483, 0.0483321946706122),
        (0.7322686665977735, 0.0483321946706122),
        (0.698511365248937, 0.0483321946706122),
        (0.6631226582407952, 0.0483321946706122),
        (0.6261851975383137, 0.0483321946706122),
        (0.587785252292473, 0.0483321946706122),
        (0.5480125073546699, 0.0483321946706122),
        (0.5069598538135904, 0.0483321946706122),
        (0.4647231720437684, 0.0483321946706122),
        (0.42140110777252904, 0.0483321946706122),
        (0.37709484168832047, 0.0483321946706122),
        (0.33190785312852833, 0.0483321946706122),
        (0.28594567839868923, 0.0483321946706122),
        (0.23931566428755763, 0.0483321946706122),
        (0.19212671735370832, 0.0483321946706122),
        (0.14448904956922135, 0.0483321946706122),
        (0.09651392091451501, 0.0483321946706122),
        (0.048313379525507044, 0.0483321946706122),
        (0.0, 0.0483321946706122),
    ],
    &[
        (0.9997167946931291, 0.04759988869075444),
        (0.9974521146102535, 0.04759988869075444),
        (0.9929278846732883, 0.04759988869075444),
        (0.9861543537181866, 0.04759988869075444),
        (0.9771468659711595, 0.04759988869075444),
        (0.9659258262890683, 0.04759988869075444),
        (0.9525166539358605, 0.04759988869075444),
        (0.9369497249997617, 0.04759988869075444),
        (0.9192603035816655, 0.04759988869075444),
        (0.8994884619106032, 0.04759988869075444),
        (0.8776789895672557, 0.04759988869075444),
        (0.8538812920211482, 0.04759988869075444),
        (0.8281492787113708, 0.04759988869075444),
        (0.8005412409243604, 0.04759988869075444),
        (0.7711197197453876, 0.04759988869075444),
        (0.7399513643828839, 0.04759988869075444),
        (f64::consts::FRAC_1_SQRT_2, 0.04759988869075444),
        (0.6726603737012525, 0.04759988869075444),
        (0.6366901741190882, 0.04759988869075444),
        (0.5992776665113471, 0.04759988869075444),
        (0.560507602240894, 0.04759988869075444),
        (0.5204678079730722, 0.04759988869075444),
        (0.47924898672005684, 0.04759988869075444),
        (0.43694451236935966, 0.04759988869075444),
        (0.39365021816194146, 0.04759988869075444),
        (0.3494641795990984, 0.04759988869075444),
        (0.30448649226990704, 0.04759988869075444),
        (0.25881904510252096, 0.04759988869075444),
        (0.21256528955297682, 0.04759988869075444),
        (0.16583000525437425, 0.04759988869075444),
        (0.11871906265730525, 0.04759988869075444),
        (0.07133918319923235, 0.04759988869075444),
        (0.02379769754610771, 0.04759988869075444),
    ],
    &[
        (0.9997251851098159, 0.046889442590892436),
        (0.9975275721840101, 0.046889442590892436),
        (0.9931371771625542, 0.046889442590892436),
        (0.9865636510865465, 0.046889442590892436),
        (0.9778214439929451, 0.046889442590892436),
        (0.9669297731502506, 0.046889442590892436),
        (0.953912580814779, 0.046889442590892436),
        (0.9387984816003864, 0.046889442590892436),
        (0.9216206995773374, 0.046889442590892436),
        (0.9024169952385883, 0.046889442590892436),
        (0.8812295824940285, 0.046889442590892436),
        (0.8581050358751443, 0.046889442590892436),
        (0.8330941881540915, 0.046889442590892436),
        (0.8062520186022298, 0.046889442590892436),
        (0.777637532133752, 0.046889442590892436),
        (0.7473136296000771, 0.046889442590892436),
        (0.7153469695201276, 0.046889442590892436),
        (0.6818078215504377, 0.046889442590892436),
        (0.6467699120171987, 0.046889442590892436),
        (0.6103102618497921, 0.046889442590892436),
        (0.5725090172720719, 0.046889442590892436),
        (0.5334492736235703, 0.046889442590892436),
        (0.4932168926979074, 0.046889442590892436),
        (0.4519003139999338, 0.046889442590892436),
        (0.4095903603365064, 0.046889442590892436),
        (0.3663800381682461, 0.046889442590892436),
        (0.32236433316115376, 0.046889442590892436),
        (0.2776400013875005, 0.046889442590892436),
        (0.23230535663498325, 0.046889442590892436),
        (0.18646005429168128, 0.046889442590892436),
        (0.14020487228188572, 0.046889442590892436),
        (0.09364148953435085, 0.046889442590892436),
        (0.04687226246994003, 0.046889442590892436),
        (0.0, 0.046889442590892436),
    ],
    &[
        (0.9997332081116372, 0.04619989196455578),
        (0.9975997270637169, 0.04619989196455578),
        (0.99333731792395, 0.04619989196455578),
        (0.9869550768882457, 0.04619989196455578),
        (0.978466623980609, 0.04619989196455578),
        (0.9678900739873226, 0.04619989196455578),
        (0.95524799779908, 0.04619989196455578),
        (0.9405673742435676, 0.04619989196455578),
        (0.9238795325112867, 0.04619989196455578),
        (0.905220085297482, 0.04619989196455578),
        (0.8846288528028554, 0.04619989196455578),
        (0.8621497777552507, 0.04619989196455578),
        (0.8378308316336583, 0.04619989196455578),
        (0.8117239122946612, 0.04619989196455578),
        (0.7838847332197937, 0.04619989196455578),
        (0.7543727046201639, 0.04619989196455578),
        (0.7232508066520699, 0.04619989196455578),
        (0.6905854550141715, 0.04619989196455578),
        (0.6564463592130425, 0.04619989196455578),
        (0.6209063737995714, 0.04619989196455578),
        (0.5840413428936767, 0.04619989196455578),
        (0.5459299383291344, 0.04619989196455578),
        (0.5066534917639194, 0.04619989196455578),
        (0.46629582111434803, 0.04619989196455578),
        (0.4249430516834218, 0.04619989196455578),
        (0.38268343236508984, 0.04619989196455578),
        (0.33960714731666136, 0.04619989196455578),
        (0.2958061235012705, 0.04619989196455578),
        (0.2513738345111027, 0.04619989196455578),
        (0.20640510109003962, 0.04619989196455578),
        (0.16099588878141294, 0.04619989196455578),
        (0.1152431031326976, 0.04619989196455578),
        (0.06924438289419173, 0.04619989196455578),
        (0.023097891653001093, 0.04619989196455578),
    ],
    &[
        (0.9997408848413492, 0.04553032831289555),
        (0.9976687691905392, 0.04553032831289555),
        (0.9935288326650312, 0.04553032831289555),
        (0.9873296559154696, 0.04553032831289555),
        (0.9790840876823229, 0.04553032831289555),
        (0.9688092181649064, 0.04553032831289555),
        (0.9565263435993347, 0.04553032831289555),
        (0.9422609221188205, 0.04553032831289555),
        (0.9260425209878053, 0.04553032831289555),
        (0.9079047553192889, 0.04553032831289555),
        (0.8878852184023752, 0.04553032831289555),
        (0.8660254037844387, 0.04553032831289555),
        (0.8423706192694116, 0.04553032831289555),
        (0.8169698930104421, 0.04553032831289555),
        (0.7898758718915586, 0.04553032831289555),
        (0.7611447124089648, 0.04553032831289555),
        (0.7308359642781241, 0.04553032831289555),
        (0.6990124470078821, 0.04553032831289555),
        (0.6657401196974406, 0.04553032831289555),
        (0.6310879443260529, 0.04553032831289555),
        (0.5951277428187898, 0.04553032831289555),
        (0.5579340481846334, 0.04553032831289555),
        (0.5195839500354336, 0.04553032831289555),
        (0.4801569348059156, 0.04553032831289555),
        (0.439734721005906, 0.04553032831289555),
        (0.39840108984624156, 0.04553032831289555),
        (0.35624171158941687, 0.04553032831289555),
        (0.31334396798488223, 0.04553032831289555),
        (0.26979677115702444, 0.04553032831289555),
        (0.22569037932121072, 0.04553032831289555),
        (0.1811162097098558, 0.04553032831289555),
        (0.1361666490962466, 0.04553032831289555),
        (0.09093486230884712, 0.04553032831289555),
        (0.04551459913296371, 0.04553032831289555),
        (0.0, 0.04553032831289555),
    ],
    &[
        (0.9997482349425065, 0.04487989505128276),
        (0.9977348750464561, 0.04487989505128276),
        (0.9937122098932426, 0.04487989505128276),
        (0.9876883405951378, 0.04487989505128276),
        (0.9796753984232356, 0.04487989505128276),
        (0.9696895203766869, 0.04487989505128276),
        (0.9577508166849305, 0.04487989505128276),
        (0.9438833303083676, 0.04487989505128276),
        (0.928114988519039, 0.04487989505128276),
        (0.910477546658816, 0.04487989505128276),
        (0.8910065241883679, 0.04487989505128276),
        (0.8697411331556955, 0.04487989505128276),
        (0.8467241992282841, 0.04487989505128276),
        (0.8220020754479099, 0.04487989505128276),
        (0.795624548881781, 0.04487989505128276),
        (0.7676447403580111, 0.04487989505128276),
        (0.7381189974873407, 0.04487989505128276),
        (f64::consts::FRAC_1_SQRT_2, 0.04487989505128276),
        (0.6746705459320744, 0.04487989505128276),
        (0.6408756139850241, 0.04487989505128276),
        (0.6057900438408199, 0.04487989505128276),
        (0.5694844931684521, 0.04487989505128276),
        (0.5320320765153366, 0.04487989505128276),
        (0.4935082180643469, 0.04487989505128276),
        (0.4539904997395468, 0.04487989505128276),
        (0.4135585049665207, 0.04487989505128276),
        (0.3722936584019452, 0.04487989505128276),
        (0.33027906195516715, 0.04487989505128276),
        (0.2875993274320173, 0.04487989505128276),
        (0.24434040613789407, 0.04487989505128276),
        (0.20058941578327283, 0.04487989505128276),
        (0.15643446504023092, 0.04487989505128276),
        (0.11196447610330791, 0.04487989505128276),
        (0.06726900561203972, 0.04487989505128276),
        (0.022438064295805, 0.04487989505128276),
    ],
    &[
        (0.999755276685243, 0.04424778385337737),
        (0.9977982087825711, 0.04424778385337737),
        (0.9938879040295507, 0.04424778385337737),
        (0.988032017031364, 0.04424778385337737),
        (0.9802420109618029, 0.04424778385337737),
        (0.9705331351235673, 0.04424778385337737),
        (0.9589243950970401, 0.04424778385337737),
        (0.9454385155359702, 0.04424778385337737),
        (0.9301018956828963, 0.04424778385337737),
        (0.9129445576913887, 0.04424778385337737),
        (0.8940000878562757, 0.04424778385337737),
        (0.8733055708668928, 0.04424778385337737),
        (0.8509015172120621, 0.04424778385337737),
        (0.8268317838789088, 0.04424778385337737),
        (0.8011434885007481, 0.04424778385337737),
        (0.7738869171221069, 0.04424778385337737),
        (0.7451154257614285, 0.04424778385337737),
        (0.7148853359641625, 0.04424778385337737),
        (0.6832558245506934, 0.04424778385337737),
        (0.6502888077749369, 0.04424778385337737),
        (0.6160488201203642, 0.04424778385337737),
        (0.5806028879707208, 0.04424778385337737),
        (0.5440203984027323, 0.04424778385337737),
        (0.5063729633576439, 0.04424778385337737),
        (0.4677342794574818, 0.04424778385337737),
        (0.42817998374045535, 0.04424778385337737),
        (0.38778750559790215, 0.04424778385337737),
        (0.3466359152026195, 0.04424778385337737),
        (0.30480576872528664, 0.04424778385337737),
        (0.2623789506419791, 0.04424778385337737),
        (0.21943851344146065, 0.04424778385337737),
        (0.17606851504603618, 0.04424778385337737),
        (0.13235385426422255, 0.04424778385337737),
        (0.08838010459734251, 0.04424778385337737),
        (0.04423334672537901, 0.04424778385337737),
        (0.0, 0.04424778385337737),
    ],
    &[
        (0.9997620270799091, 0.04363323129985824),
        (0.9978589232386035, 0.04363323129985824),
        (0.9940563382223196, 0.04363323129985824),
        (0.9883615104677607, 0.04363323129985824),
        (0.9807852804032304, 0.04363323129985824),
        (0.9713420698132614, 0.04363323129985824),
        (0.9600498543859287, 0.04363323129985824),
        (0.9469301294951057, 0.04363323129985824),
        (0.9320078692827986, 0.04363323129985824),
        (0.9153114791194472, 0.04363323129985824),
        (0.8968727415326884, 0.04363323129985824),
        (0.8767267557075077, 0.04363323129985824),
        (0.8549118706729466, 0.04363323129985824),
        (0.8314696123025452, 0.04363323129985824),
        (0.8064446042674827, 0.04363323129985824),
        (0.7798844830928818, 0.04363323129985824),
        (0.7518398074789774, 0.04363323129985824),
        (0.7223639620597556, 0.04363323129985824),
        (0.6915130557822694, 0.04363323129985824),
        (0.6593458151000688, 0.04363323129985824),
        (0.6259234721840591, 0.04363323129985824),
        (0.5913096483635825, 0.04363323129985824),
        (0.5555702330196023, 0.04363323129985824),
        (0.5187732581605216, 0.04363323129985824),
        (0.48098876891938774, 0.04363323129985824),
        (0.44228869021900125, 0.04363323129985824),
        (0.40274668985873724, 0.04363323129985824),
        (0.3624380382837017, 0.04363323129985824),
        (0.3214394653031617, 0.04363323129985824),
        (0.27982901403099225, 0.04363323129985824),
        (0.2376858923261731, 0.04363323129985824),
        (0.19509032201612833, 0.04363323129985824),
        (0.1521233861899168, 0.04363323129985824),
        (0.10886687485196474, 0.04363323129985824),
        (0.06540312923014305, 0.04363323129985824),
        (0.02181488503456116, 0.04363323129985824),
    ],
    &[
        (0.9997685019798909, 0.04303551580259991),
        (0.9979171608653922, 0.04303551580259991),
        (0.994217906893952, 0.04303551580259991),
        (0.9886775902323404, 0.04303551580259991),
        (0.9813064702716093, 0.04303551580259991),
        (0.9721181966290613, 0.04303551580259991),
        (0.9611297838723007, 0.04303551580259991),
        (0.9483615800121715, 0.04303551580259991),
        (0.9338372288229252, 0.04303551580259991),
        (0.9175836260593937, 0.04303551580259991),
        (0.8996308696522434, 0.04303551580259991),
        (0.8800122039735356, 0.04303551580259991),
        (0.858763958275803, 0.04303551580259991),
        (0.8359254794186369, 0.04303551580259991),
        (0.811539059007361, 0.04303551580259991),
        (0.7856498550787143, 0.04303551580259991),
        (0.7583058084785625, 0.04303551580259991),
        (0.7295575540864875, 0.04303551580259991),
        (0.6994583270516471, 0.04303551580259991),
        (0.6680638642135335, 0.04303551580259991),
        (0.6354323008901775, 0.04303551580259991),
        (0.6016240632249226, 0.04303551580259991),
        (0.5667017562911176, 0.04303551580259991),
        (0.5307300481619333, 0.04303551580259991),
        (0.49377555015997726, 0.04303551580259991),
        (0.45590669350845875, 0.04303551580259991),
        (0.4171936026123168, 0.04303551580259991),
        (0.3777079652039648, 0.04303551580259991),
        (0.3375228995941133, 0.04303551580259991),
        (0.29671281927349025, 0.04303551580259991),
        (0.25535329511618704, 0.04303551580259991),
        (0.21352091543979607, 0.04303551580259991),
        (0.17129314418147762, 0.04303551580259991),
        (0.12874817745258083, 0.04303551580259991),
        (0.08596479873744652, 0.04303551580259991),
        (0.04302223300453053, 0.04303551580259991),
        (0.0, 0.04303551580259991),
    ],
    &[
        (0.9997747161747694, 0.042453954778240446),
        (0.9979730545608125, 0.042453954778240446),
        (0.9943729780489025, 0.042453954778240446),
        (0.9889809742202453, 0.042453954778240446),
        (0.9818067598301892, 0.042453954778240446),
        (0.9728632632979746, 0.042453954778240446),
        (0.9621666014088494, 0.042453954778240446),
        (0.9497360502705319, 0.042453954778240446),
        (0.9355940105763622, 0.042453954778240446),
        (0.9197659672377387, 0.042453954778240446),
        (0.9022804434585852, 0.042453954778240446),
        (0.8831689493346093, 0.042453954778240446),
        (0.8624659250699805, 0.042453954778240446),
        (0.8402086789137543, 0.042453954778240446),
        (0.8164373199278857, 0.042453954778240446),
        (0.7911946857079885, 0.042453954778240446),
        (0.7645262651870924, 0.042453954778240446),
        (0.7364801166615121, 0.042453954778240446),
        (0.7071067811865475, 0.042453954778240446),
        (0.6764591914980869, 0.042453954778240446),
        (0.644592576624239, 0.042453954778240446),
        (0.6115643623588912, 0.042453954778240446),
        (0.577434067776548, 0.042453954778240446),
        (0.542263197974935, 0.042453954778240446),
        (0.5061151332386561, 0.042453954778240446),
        (0.4690550148236368, 0.042453954778240446),
        (0.4311496275681782, 0.042453954778240446),
        (0.3924672795421636, 0.042453954778240446),
        (0.35307767895130077, 0.042453954778240446),
        (0.3130518085182222, 0.042453954778240446),
        (0.27246179756682265, 0.042453954778240446),
        (0.2313807920403414, 0.042453954778240446),
        (0.18988282268742812, 0.042453954778240446),
        (0.14804267165373136, 0.042453954778240446),
        (0.10593573771941588, 0.042453954778240446),
        (0.06363790042546599, 0.042453954778240446),
        (0.021225383333623424, 0.042453954778240446),
    ],
    &[
        (0.9997806834748455, 0.041887902047863905),
        (0.9980267284282716, 0.041887902047863905),
        (0.9945218953682733, 0.041887902047863905),
        (0.9892723329629883, 0.041887902047863905),
        (0.9822872507286887, 0.041887902047863905),
        (0.9735789028731603, 0.041887902047863905),
        (0.9631625667976581, 0.041887902047863905),
        (0.9510565162951535, 0.041887902047863905),
        (0.9372819894918915, 0.041887902047863905),
        (0.9218631515885005, 0.041887902047863905),
        (0.9048270524660195, 0.041887902047863905),
        (0.8862035792312147, 0.041887902047863905),
        (0.8660254037844386, 0.041887902047863905),
        (0.8443279255020151, 0.041887902047863905),
        (0.821149209133704, 0.041887902047863905),
        (0.7965299180241963, 0.041887902047863905),
        (0.7705132427757891, 0.041887902047863905),
        (0.7431448254773942, 0.041887902047863905),
        (0.7144726796328034, 0.041887902047863905),
        (0.6845471059286886, 0.041887902047863905),
        (0.6534206039901054, 0.041887902047863905),
        (0.6211477802783103, 0.041887902047863905),
        (0.587785252292473, 0.041887902047863905),
        (0.5533915492433441, 0.041887902047863905),
        (0.5180270093731302, 0.041887902047863905),
        (0.48175367410171516, 0.041887902047863905),
        (0.4446351791849275, 0.041887902047863905),
        (0.4067366430758002, 0.041887902047863905),
        (0.36812455268467786, 0.041887902047863905),
        (0.3288666467385831, 0.041887902047863905),
        (0.2890317969444716, 0.041887902047863905),
        (0.24868988716485474, 0.041887902047863905),
        (0.20791169081775923, 0.041887902047863905),
        (0.16676874671610212, 0.041887902047863905),
        (0.12533323356430426, 0.041887902047863905),
        (0.08367784333231544, 0.041887902047863905),
        (0.041875653729199526, 0.041887902047863905),
        (0.0, 0.041887902047863905),
    ],
    &[
        (0.999786416787931, 0.04133674544197096),
        (0.9980782984658682, 0.04133674544197096),
        (0.9946649801132426, 0.04133674544197096),
        (0.9895522933272027, 0.04133674544197096),
        (0.9827489730473594, 0.04133674544197096),
        (0.9742666426322876, 0.04133674544197096),
        (0.9641197940012136, 0.04133674544197096),
        (0.9523257628748145, 0.04133674544197096),
        (0.9389046991574296, 0.04133674544197096),
        (0.9238795325112867, 0.04133674544197096),
        (0.90727593318156, 0.04133674544197096),
        (0.8891222681391852, 0.04133674544197096),
        (0.8694495526163669, 0.04133674544197096),
        (0.8482913971175737, 0.04133674544197096),
        (0.8256839499965558, 0.04133674544197096),
        (0.8016658356974885, 0.04133674544197096),
        (0.7762780887657574, 0.04133674544197096),
        (0.7495640837411262, 0.04133674544197096),
        (0.7215694610530622, 0.04133674544197096),
        (0.6923420490448298, 0.04133674544197096),
        (0.6619317822595666, 0.04133674544197096),
        (0.6303906161279552, 0.04133674544197096),
        (0.5977724382032409, 0.04133674544197096),
        (0.564132976095251, 0.04133674544197096),
        (0.5295297022607087, 0.04133674544197096),
        (0.49402173581250414, 0.04133674544197096),
        (0.4576697415156817, 0.04133674544197096),
        (0.4205358261427077, 0.04133674544197096),
        (0.38268343236508984, 0.04133674544197096),
        (0.34417723036263864, 0.04133674544197096),
        (0.30508300733554883, 0.04133674544197096),
        (0.26546755510807246, 0.04133674544197096),
        (0.22539855601580633, 0.04133674544197096),
        (0.18494446727155847, 0.04133674544197096),
        (0.1441744040073468, 0.04133674544197096),
        (0.10315802119235704, 0.04133674544197096),
        (0.061965394628594676, 0.04133674544197096),
        (0.020666901227554418, 0.04133674544197096),
    ],
    &[
        (0.9997919281892065, 0.040799904592075234),
        (0.9981278731933669, 0.040799904592075234),
        (0.994802532857004, 0.040799904592075234),
        (0.9898214418809327, 0.040799904592075234),
        (0.983192890799503, 0.040799904592075234),
        (0.9749279121818236, 0.040799904592075234),
        (0.9650402622691399, 0.040799904592075234),
        (0.9535463980789276, 0.040799904592075234),
        (0.9404654500138115, 0.040799904592075234),
        (0.9258191900208981, 0.040799904592075234),
        (0.9096319953545183, 0.040799904592075234),
        (0.8919308080026938, 0.040799904592075234),
        (0.8727450898448561, 0.040799904592075234),
        (0.8521067736154565, 0.040799904592075234),
        (0.8300502097550806, 0.040799904592075234),
        (0.80661210923753, 0.040799904592075234),
        (0.7818314824680298, 0.040799904592075234),
        (0.7557495743542582, 0.040799904592075234),
        (0.728409795658269, 0.040799904592075234),
        (0.6998576507435618, 0.040799904592075234),
        (0.6701406618375594, 0.040799904592075234),
        (0.6393082899355514, 0.040799904592075234),
        (0.6074118524777474, 0.040799904592075234),
        (0.5745044379364632, 0.040799904592075234),
        (0.5406408174555976, 0.040799904592075234),
        (0.5058773536894682, 0.040799904592075234),
        (0.4702719069927367, 0.040799904592075234),
        (0.43388373911755795, 0.040799904592075234),
        (0.39677341457824233, 0.040799904592075234),
        (0.35900269984759864, 0.040799904592075234),
        (0.3206344605527354, 0.040799904592075234),
        (0.2817325568414296, 0.040799904592075234),
        (0.24236173709321218, 0.040799904592075234),
        (0.20258753015208078, 0.040799904592075234),
        (0.16247613626020557, 0.040799904592075234),
        (0.12209431687415982, 0.040799904592075234),
        (0.08150928354706308, 0.040799904592075234),
        (0.04078858606158545, 0.040799904592075234),
        (0.0, 0.040799904592075234),
    ],
    &[
        (0.9997972289848501, 0.04027682889217683),
        (0.9981755542233175, 0.04027682889217683),
        (0.9949348350626456, 0.04027682889217683),
        (0.9900803279611641, 0.04027682889217683),
        (0.9836199069471436, 0.04027682889217683),
        (0.9755640508470939, 0.04027682889217683),
        (0.9659258262890683, 0.04027682889217683),
        (0.9547208665085456, 0.04027682889217683),
        (0.9419673459912649, 0.04027682889217683),
        (0.9276859509941429, 0.04027682889217683),
        (0.9118998459920901, 0.04027682889217683),
        (0.8946346361051474, 0.04027682889217683),
        (0.8759183255668879, 0.04027682889217683),
        (0.8557812723014475, 0.04027682889217683),
        (0.8342561386828613, 0.04027682889217683),
        (0.8113778385565731, 0.04027682889217683),
        (0.7871834806090502, 0.04027682889217683),
        (0.7617123081773592, 0.04027682889217683),
        (0.7350056355963286, 0.04027682889217683),
        (f64::consts::FRAC_1_SQRT_2, 0.04027682889217683),
        (0.6780609969918909, 0.04027682889217683),
        (0.6479153953805388, 0.04027682889217683),
        (0.6167188726285431, 0.04027682889217683),
        (0.5845220296098889, 0.04027682889217683),
        (0.5513770897216917, 0.04027682889217683),
        (0.5173378141776568, 0.04027682889217683),
        (0.48245941480719334, 0.04027682889217683),
        (0.4467984645016259, 0.04027682889217683),
        (0.41041280545275693, 0.04027682889217683),
        (0.37336145533262105, 0.04027682889217683),
        (0.33570451156660486, 0.04027682889217683),
        (0.297503053855203, 0.04027682889217683),
        (0.25881904510252096, 0.04027682889217683),
        (0.2197152309122172, 0.04027682889217683),
        (0.18025503781390587, 0.04027682889217683),
        (0.14050247038509278, 0.04027682889217683),
        (0.10052200743551712, 0.04027682889217683),
        (0.060378497422286286, 0.04027682889217683),
        (0.020137053265440522, 0.04027682889217683),
    ],
    &[
        (0.9998023297700656, 0.039766995615060675),
        (0.998221436781933, 0.039766995615060675),
        (0.9950621505224274, 0.039766995615060675),
        (0.9903294664725019, 0.039766995615060675),
        (0.9840308679784207, 0.039766995615060675),
        (0.9761763144190508, 0.039766995615060675),
        (0.9667782254580372, 0.039766995615060675),
        (0.9558514614057608, 0.039766995615060675),
        (0.9434132997221345, 0.039766995615060675),
        (0.9294834076973871, 0.039766995615060675),
        (0.9140838113540346, 0.039766995615060675),
        (0.8972388606192123, 0.039766995615060675),
        (0.8789751908224338, 0.039766995615060675),
        (0.8593216805796611, 0.039766995615060675),
        (0.8383094061302766, 0.039766995615060675),
        (0.815971592199161, 0.039766995615060675),
        (0.7923435594615744, 0.039766995615060675),
        (0.767462668693908, 0.039766995615060675),
        (0.7413682616986182, 0.039766995615060675),
        (0.7141015990967498, 0.039766995615060675),
        (0.6857057950864133, 0.039766995615060675),
        (0.6562257492703757, 0.039766995615060675),
        (0.62570807566056, 0.039766995615060675),
        (0.5942010289717106, 0.039766995615060675),
        (0.561754428320771, 0.039766995615060675),
        (0.5284195784526197, 0.039766995615060675),
        (0.49424918861672307, 0.039766995615060675),
        (0.45929728922297797, 0.039766995615060675),
        (0.42361914640852827, 0.039766995615060675),
        (0.3872711746506411, 0.039766995615060675),
        (0.3503108475638244, 0.039766995615060675),
        (0.3127966070222274, 0.039766995615060675),
        (0.2747877707510254, 0.039766995615060675),
        (0.23634443853290507, 0.039766995615060675),
        (0.19752739717795295, 0.039766995615060675),
        (0.15839802440721512, 0.039766995615060675),
        (0.11901819180190501, 0.039766995615060675),
        (0.07945016697171448, 0.039766995615060675),
        (0.03975651509692583, 0.039766995615060675),
        (0.0, 0.039766995615060675),
    ],
    &[
        (0.9998072404820648, 0.039269908169872414),
        (0.9982656101847159, 0.039269908169872414),
        (0.9951847266721969, 0.039269908169872414),
        (0.9905693404435773, 0.039269908169872414),
        (0.9844265680898916, 0.039269908169872414),
        (0.9767658813208724, 0.039269908169872414),
        (0.9675990923602598, 0.039269908169872414),
        (0.9569403357322088, 0.039269908169872414),
        (0.944806046466878, 0.039269908169872414),
        (0.9312149347588036, 0.039269908169872414),
        (0.916187957117136, 0.039269908169872414),
        (0.8997482840522215, 0.039269908169872414),
        (0.881921264348355, 0.039269908169872414),
        (0.8627343859777918, 0.039269908169872414),
        (0.8422172337162865, 0.039269908169872414),
        (0.8204014435255136, 0.039269908169872414),
        (0.7973206537727071, 0.039269908169872414),
        (0.773010453362737, 0.039269908169872414),
        (0.7475083268625968, 0.039269908169872414),
        (0.7208535967029188, 0.039269908169872414),
        (0.6930873625456359, 0.039269908169872414),
        (0.6642524379112817, 0.039269908169872414),
        (0.6343932841636455, 0.039269908169872414),
        (0.6035559419535714, 0.039269908169872414),
        (0.5717879602276122, 0.039269908169872414),
        (0.5391383229110004, 0.039269908169872414),
        (0.5056573733779846, 0.039269908169872414),
        (0.4713967368259978, 0.039269908169872414),
        (0.436409240673342, 0.039269908169872414),
        (0.4007488331031411, 0.039269908169872414),
        (0.3644704998791496, 0.039269908169872414),
        (0.32763017956169366, 0.039269908169872414),
        (0.29028467725446233, 0.039269908169872414),
        (0.2524915770151581, 0.039269908169872414),
        (0.2143091530650507, 0.039269908169872414),
        (0.17579627993435468, 0.039269908169872414),
        (0.137012341681968, 0.039269908169872414),
        (0.09801714032956077, 0.039269908169872414),
        (0.058870803651188984, 0.039269908169872414),
        (0.019633692460628474, 0.039269908169872414),
    ],
    &[
        (0.9998119704485015, 0.038785094488762877),
        (0.9983081582712682, 0.038785094488762877),
        (0.9953027957931658, 0.038785094488762877),
        (0.9908004033648453, 0.038785094488762877),
        (0.984807753012208, 0.038785094488762877),
        (0.9773338582506356, 0.038785094488762877),
        (0.9683899605278059, 0.038785094488762877),
        (0.9579895123154889, 0.038785094488762877),
        (0.9461481568757505, 0.038785094488762877),
        (0.9328837047320006, 0.038785094488762877),
        (0.918216106880274, 0.038785094488762877),
        (0.9021674247810377, 0.038785094488762877),
        (0.8847617971766578, 0.038785094488762877),
        (0.8660254037844387, 0.038785094488762877),
        (0.8459864259198411, 0.038785094488762877),
        (0.8246750041091068, 0.038785094488762877),
        (0.8021231927550438, 0.038785094488762877),
        (0.77836491192416, 0.038785094488762877),
        (0.7534358963276607, 0.038785094488762877),
        (0.7273736415730487, 0.038785094488762877),
        (0.7002173477671685, 0.038785094488762877),
        (0.6720078605555224, 0.038785094488762877),
        (0.6427876096865394, 0.038785094488762877),
        (0.6126005451932028, 0.038785094488762877),
        (0.5814920712880268, 0.038785094488762877),
        (0.5495089780708061, 0.038785094488762877),
        (0.516699371151863, 0.038785094488762877),
        (0.4831125992966386, 0.038785094488762877),
        (0.4487991802004623, 0.038785094488762877),
        (0.4138107245051392, 0.038785094488762877),
        (0.3781998581716426, 0.038785094488762877),
        (0.3420201433256688, 0.038785094488762877),
        (0.3053259976951132, 0.038785094488762877),
        (0.2681726127606375, 0.038785094488762877),
        (0.23061587074244025, 0.038785094488762877),
        (0.19271226054808976, 0.038785094488762877),
        (0.15451879280784056, 0.038785094488762877),
        (0.1160929141252303, 0.038785094488762877),
        (0.07749242067193102, 0.038785094488762877),
        (0.03877537125681678, 0.038785094488762877),
        (0.0, 0.038785094488762877),
    ],
    &[
        (0.9998165284317944, 0.038312105531582846),
        (0.9983491598032411, 0.038312105531582846),
        (0.9954165761119449, 0.038312105531582846),
        (0.9910230813288712, 0.038312105531582846),
        (0.9851751235134699, 0.038312105531582846),
        (0.9778812853502592, 0.038312105531582846),
        (0.9691522715525518, 0.038312105531582846),
        (0.9590008931518129, 0.038312105531582846),
        (0.9474420486957043, 0.038312105531582846),
        (0.934492702382411, 0.038312105531582846),
        (0.9201718591633418, 0.038312105531582846),
        (0.9045005368507417, 0.038312105531582846),
        (0.8875017352711544, 0.038312105531582846),
        (0.8692004025100053, 0.038312105531582846),
        (0.8496233982968453, 0.038312105531582846),
        (0.8287994545849945, 0.038312105531582846),
        (0.8067591333834381, 0.038312105531582846),
        (0.7835347819028641, 0.038312105531582846),
        (0.7591604850816704, 0.038312105531582846),
        (0.7336720155616185, 0.038312105531582846),
        (0.7071067811865475, 0.038312105531582846),
        (0.6795037701012057, 0.038312105531582846),
        (0.6509034935307713, 0.038312105531582846),
        (0.6213479263250431, 0.038312105531582846),
        (0.5908804453545605, 0.038312105531582846),
        (0.559545765849064, 0.038312105531582846),
        (0.5273898757717294, 0.038312105531582846),
        (0.49445996832549016, 0.038312105531582846),
        (0.4608043726905049, 0.038312105531582846),
        (0.4264724830944196, 0.038312105531582846),
        (0.3915146863195288, 0.038312105531582846),
        (0.35598228775322327, 0.038312105531582846),
        (0.3199274360902589, 0.038312105531582846),
        (0.2834030467973572, 0.038312105531582846),
        (0.24646272445245912, 0.038312105531582846),
        (0.20916068407261662, 0.038312105531582846),
        (0.17155167154597828, 0.038312105531582846),
        (0.13369088328464843, 0.038312105531582846),
        (0.09563388521634211, 0.038312105531582846),
        (0.057436531233723206, 0.038312105531582846),
        (0.019154881221113987, 0.038312105531582846),
    ],
    &[
        (0.9998209226697378, 0.03785051389867221),
        (0.9983886888289513, 0.03785051389867221),
        (0.995526272808559, 0.03785051389867221),
        (0.9912377749919373, 0.03785051389867221),
        (0.9855293386108992, 0.03785051389867221),
        (0.9784091409455727, 0.03785051389867221),
        (0.9698873816105272, 0.03785051389867221),
        (0.9599762679439228, 0.03785051389867221),
        (0.9486899975206164, 0.03785051389867221),
        (0.9360447378142728, 0.03785051389867221),
        (0.9220586030376136, 0.03785051389867221),
        (0.9067516281939826, 0.03785051389867221),
        (0.8901457403773966, 0.03785051389867221),
        (0.8722647273621938, 0.03785051389867221),
        (0.8531342035272768, 0.03785051389867221),
        (0.832781573163761, 0.03785051389867221),
        (0.8112359912185922, 0.03785051389867221),
        (0.7885283215303658, 0.03785051389867221),
        (0.7646910926171746, 0.03785051389867221),
        (0.7397584510798207, 0.03785051389867221),
        (0.713766112687139, 0.03785051389867221),
        (0.6867513112135011, 0.03785051389867221),
        (0.6587527451017937, 0.03785051389867221),
        (0.6298105220282713, 0.03785051389867221),
        (0.5999661014486956, 0.03785051389867221),
        (0.569262235208066, 0.03785051389867221),
        (0.537742906299012, 0.03785051389867221),
        (0.5054532658565809, 0.03785051389867221),
        (0.472439568479671, 0.03785051389867221),
        (0.43874910597176514, 0.03785051389867221),
        (0.404430139595877, 0.03785051389867221),
        (0.36953183094075687, 0.03785051389867221),
        (0.33410417149738975, 0.03785051389867221),
        (0.29819791104666543, 0.03785051389867221),
        (0.26186448496080666, 0.03785051389867221),
        (0.22515594052269391, 0.03785051389867221),
        (0.18812486236863368, 0.03785051389867221),
        (0.15082429716137372, 0.03785051389867221),
        (0.11330767760126972, 0.03785051389867221),
        (0.07562874588445657, 0.03785051389867221),
        (0.037841476717670366, 0.03785051389867221),
        (0.0, 0.03785051389867221),
    ],
    &[
        (0.9998251609127464, 0.037399912542735635),
        (0.9984268150178166, 0.037399912542735635),
        (0.9956320789411338, 0.037399912542735635),
        (0.9914448613738104, 0.037399912542735635),
        (0.9858710185182359, 0.037399912542735635),
        (0.9789183458976485, 0.037399912542735635),
        (0.970596567453391, 0.037399912542735635),
        (0.9609173219450996, 0.037399912542735635),
        (0.949894146672846, 0.037399912542735635),
        (0.9375424585439992, 0.037399912542735635),
        (0.9238795325112867, 0.037399912542735635),
        (0.9089244774122108, 0.037399912542735635),
        (0.8926982092436115, 0.037399912542735635),
        (0.8752234219087538, 0.037399912542735635),
        (0.8565245554778514, 0.037399912542735635),
        (0.8366277620064198, 0.037399912542735635),
        (0.8155608689592603, 0.037399912542735635),
        (0.7933533402912353, 0.037399912542735635),
        (0.7700362352392629, 0.037399912542735635),
        (0.7456421648831657, 0.037399912542735635),
        (0.7202052465361266, 0.037399912542735635),
        (0.6937610560285417, 0.037399912542735635),
        (0.666346577952004, 0.037399912542735635),
        (0.6380001539330087, 0.037399912542735635),
        (0.6087614290087208, 0.037399912542735635),
        (0.5786712961798058, 0.037399912542735635),
        (0.5477718392178714, 0.037399912542735635),
        (0.5161062738075068, 0.037399912542735635),
        (0.48371888710524, 0.037399912542735635),
        (0.4506549757999453, 0.037399912542735635),
        (0.41696078276132825, 0.037399912542735635),
        (0.38268343236509, 0.037399912542735635),
        (0.34787086458522737, 0.037399912542735635),
        (0.3125717679456447, 0.037399912542735635),
        (0.27683551142484963, 0.037399912542735635),
        (0.24071207540897313, 0.037399912542735635),
        (0.20425198178968054, 0.037399912542735635),
        (0.1675062233047367, 0.037399912542735635),
        (0.1305261922200517, 0.037399912542735635),
        (0.09336360845295087, 0.037399912542735635),
        (0.05607044723719207, 0.037399912542735635),
        (0.018698866430902624, 0.037399912542735635),
    ],
    &[
        (0.9998292504580527, 0.036959913571644624),
        (0.9984636039674339, 0.036959913571644624),
        (0.9957341762950345, 0.036959913571644624),
        (0.9916446955107427, 0.036959913571644624),
        (0.9862007473534026, 0.036959913571644624),
        (0.9794097676013659, 0.036959913571644624),
        (0.9712810319161138, 0.036959913571644624),
        (0.961825643172819, 0.036959913571644624),
        (0.9510565162951535, 0.036959913571644624),
        (0.9389883606150565, 0.036959913571644624),
        (0.9256376597815563, 0.036959913571644624),
        (0.9110226492460883, 0.036959913571644624),
        (0.8951632913550623, 0.036959913571644624),
        (0.8780812480836979, 0.036959913571644624),
        (0.8597998514483725, 0.036959913571644624),
        (0.8403440716378927, 0.036959913571644624),
        (0.8197404829072211, 0.036959913571644624),
        (0.7980172272802396, 0.036959913571644624),
        (0.7752039761111299, 0.036959913571644624),
        (0.7513318895568734, 0.036959913571644624),
        (0.7264335740162242, 0.036959913571644624),
        (0.700543037593291, 0.036959913571644624),
        (0.6736956436465572, 0.036959913571644624),
        (0.6459280624867874, 0.036959913571644624),
        (0.617278221289793, 0.036959913571644624),
        (0.5877852522924731, 0.036959913571644624),
        (0.5574894393428855, 0.036959913571644624),
        (0.5264321628773558, 0.036959913571644624),
        (0.49465584339977897, 0.036959913571644624),
        (0.4622038835403132, 0.036959913571644624),
        (0.42912060877260905, 0.036959913571644624),
        (0.3954512068705426, 0.036959913571644624),
        (0.36124166618715303, 0.036959913571644624),
        (0.3265387128400833, 0.036959913571644624),
        (0.29138974688932473, 0.036959913571644624),
        (0.2558427775944356, 0.036959913571644624),
        (0.2199463578396687, 0.036959913571644624),
        (0.1837495178165703, 0.036959913571644624),
        (0.14730169805463758, 0.036959913571644624),
        (0.11065268189150082, 0.036959913571644624),
        (0.07385252747487403, 0.036959913571644624),
        (0.03695149938914507, 0.036959913571644624),
        (0.0, 0.036959913571644624),
    ],
    &[
        (0.9998331981811365, 0.03653014713476504),
        (0.9984991174858258, 0.03653014713476504),
        (0.9958327361634247, 0.03653014713476504),
        (0.9918376119752228, 0.03653014713476504),
        (0.9865190756284465, 0.03653014713476504),
        (0.9798842236634794, 0.03653014713476504),
        (0.9719419089849246, 0.03653014713476504),
        (0.9627027290491459, 0.03653014713476504),
        (0.952179011724047, 0.03653014713476504),
        (0.9403847988399568, 0.03653014713476504),
        (0.9273358274535703, 0.03653014713476504),
        (0.9130495088499416, 0.03653014713476504),
        (0.8975449053105503, 0.03653014713476504),
        (0.8808427046784363, 0.03653014713476504),
        (0.8629651927543444, 0.03653014713476504),
        (0.843936223560707, 0.03653014713476504),
        (0.8237811875131444, 0.03653014713476504),
        (0.8025269775419508, 0.03653014713476504),
        (0.7802019532087692, 0.03653014713476504),
        (0.7568359028663363, 0.03653014713476504),
        (0.7324600039117861, 0.03653014713476504),
        (f64::consts::FRAC_1_SQRT_2, 0.03653014713476504),
        (0.6808100635783421, 0.03653014713476504),
        (0.6536049388831893, 0.03653014713476504),
        (0.6255277069876454, 0.03653014713476504),
        (0.596615831433747, 0.03653014713476504),
        (0.5669078894312846, 0.03653014713476504),
        (0.5364435203841056, 0.03653014713476504),
        (0.5052633729991293, 0.03653014713476504),
        (0.4734090510486434, 0.03653014713476504),
        (0.4409230578582565, 0.03653014713476504),
        (0.4078487395945712, 0.03653014713476504),
        (0.37423022742825307, 0.03653014713476504),
        (0.3401123786496662, 0.03653014713476504),
        (0.3055407168156436, 0.03653014713476504),
        (0.2705613710072574, 0.03653014713476504),
        (0.2352210142796357, 0.03653014713476504),
        (0.19956680138595256, 0.03653014713476504),
        (0.16364630585868814, 0.03653014713476504),
        (0.12750745653210785, 0.03653014713476504),
        (0.0911984735906635, 0.03653014713476504),
        (0.05476780422864356, 0.03653014713476504),
        (0.018264058006924728, 0.03653014713476504),
    ],
    &[
        (0.9998370105646412, 0.036110260386089575),
        (0.9985334138511238, 0.036110260386089575),
        (0.9959279200655042, 0.036110260386089575),
        (0.9920239262746043, 0.036110260386089575),
        (0.9868265225415261, 0.036110260386089575),
        (0.9803424852891802, 0.036110260386089575),
        (0.9725802684651232, 0.036110260386089575),
        (0.9635499925192229, 0.036110260386089575),
        (0.9532634312085227, 0.036110260386089575),
        (0.9417339962465081, 0.036110260386089575),
        (0.9289767198167914, 0.036110260386089575),
        (0.9150082349740122, 0.036110260386089575),
        (0.8998467539575067, 0.036110260386089575),
        (0.8835120444460229, 0.036110260386089575),
        (0.8660254037844387, 0.036110260386089575),
        (0.8474096312160866, 0.036110260386089575),
        (0.8276889981568906, 0.036110260386089575),
        (0.8068892165500704, 0.036110260386089575),
        (0.7850374053426723, 0.036110260386089575),
        (0.7621620551276365, 0.036110260386089575),
        (0.7382929909974987, 0.036110260386089575),
        (0.7134613336581599, 0.036110260386089575),
        (0.6876994588534233, 0.036110260386089575),
        (0.6610409551532003, 0.036110260386089575),
        (0.6335205801604239, 0.036110260386089575),
        (0.6051742151937652, 0.036110260386089575),
        (0.5760388185052397, 0.036110260386089575),
        (0.546152377093697, 0.036110260386089575),
        (0.5155538571770217, 0.036110260386089575),
        (0.48428315338761946, 0.036110260386089575),
        (0.45238103675742697, 0.036110260386089575),
        (0.4198891015602646, 0.036110260386089575),
        (0.3868497110808393, 0.036110260386089575),
        (0.3533059423811024, 0.036110260386089575),
        (0.31930153013598017, 0.036110260386089575),
        (0.28488080961170004, 0.036110260386089575),
        (0.250088658861063, 0.036110260386089575),
        (0.2149704402110242, 0.036110260386089575),
        (0.1795719411188717, 0.036110260386089575),
        (0.1439393144741193, 0.036110260386089575),
        (0.10811901842394187, 0.036110260386089575),
        (0.07215775580061609, 0.036110260386089575),
        (0.03610241322993657, 0.036110260386089575),
        (0.0, 0.036110260386089575),
    ],
    &[
        (0.9998406937250033, 0.03569991651806583),
        (0.9985665480507289, 0.03569991651806583),
        (0.9960198804080459, 0.03569991651806583),
        (0.9922039361395185, 0.03569991651806583),
        (0.9871235780887112, 0.03569991651806583),
        (0.9807852804032304, 0.03569991651806583),
        (0.9731971202844034, 0.03569991651806583),
        (0.9643687676941068, 0.03569991651806583),
        (0.9543114730318638, 0.03569991651806583),
        (0.9430380527979121, 0.03569991651806583),
        (0.9305628732605136, 0.03569991651806583),
        (0.9169018321483198, 0.03569991651806583),
        (0.9020723383911214, 0.03569991651806583),
        (0.8860932899348025, 0.03569991651806583),
        (0.868985049658767, 0.03569991651806583),
        (0.8507694194265308, 0.03569991651806583),
        (0.8314696123025452, 0.03569991651806583),
        (0.8111102229706592, 0.03569991651806583),
        (0.7897171963919158, 0.03569991651806583),
        (0.7673177947416256, 0.03569991651806583),
        (0.7439405626678495, 0.03569991651806583),
        (0.7196152909155629, 0.03569991651806583),
        (0.6943729783628607, 0.03569991651806583),
        (0.6682457925175763, 0.03569991651806583),
        (0.641267028524661, 0.03569991651806583),
        (0.6134710667365595, 0.03569991651806583),
        (0.584893328900653, 0.03569991651806583),
        (0.5555702330196023, 0.03569991651806583),
        (0.5255391469421129, 0.03569991651806583),
        (0.49483834074326766, 0.03569991651806583),
        (0.46350693795510556, 0.03569991651806583),
        (0.43158486570960075, 0.03569991651806583),
        (0.3991128038575741, 0.03569991651806583),
        (0.3661321331283793, 0.03569991651806583),
        (0.3326848823964239, 0.03569991651806583),
        (0.298813675121729, 0.03569991651806583),
        (0.26456167503277894, 0.03569991651806583),
        (0.22997253112088056, 0.03569991651806583),
        (0.19509032201612833, 0.03569991651806583),
        (0.15995949981586027, 0.03569991651806583),
        (0.12462483343718603, 0.03569991651806583),
        (0.08913135156577605, 0.03569991651806583),
        (0.05352428527361534, 0.03569991651806583),
        (0.017849010378845998, 0.03569991651806583),
    ],
    &[
        (0.9998442534369986, 0.03529879386055947),
        (0.9985985720017784, 0.03529879386055947),
        (0.9961087610952891, 0.03529879386055947),
        (0.992377922711879, 0.03529879386055947),
        (0.9874107050115952, 0.03529879386055947),
        (0.9812132965291546, 0.03529879386055947),
        (0.9737934184638004, 0.03529879386055947),
        (0.9651603150596496, 0.03529879386055947),
        (0.9553247420885155, 0.03529879386055947),
        (0.9442989534495557, 0.03529879386055947),
        (0.9320966859024395, 0.03529879386055947),
        (0.9187331419530561, 0.03529879386055947),
        (0.904224970913085, 0.03529879386055947),
        (0.8885902481570269, 0.03529879386055947),
        (0.8718484526025386, 0.03529879386055947),
        (0.8540204424421264, 0.03529879386055947),
        (0.8351284291564356, 0.03529879386055947),
        (0.815195949841512, 0.03529879386055947),
        (0.7942478378845109, 0.03529879386055947),
        (0.7723101920243889, 0.03529879386055947),
        (0.7494103438361253, 0.03529879386055947),
        (0.7255768236789827, 0.03529879386055947),
        (0.700839325151233, 0.03529879386055947),
        (0.6752286680956305, 0.03529879386055947),
        (0.6487767602017261, 0.03529879386055947),
        (0.6215165572528595, 0.03529879386055947),
        (0.5934820220673563, 0.03529879386055947),
        (0.5647080821850868, 0.03529879386055947),
        (0.5352305863520994, 0.03529879386055947),
        (0.5050862598575474, 0.03529879386055947),
        (0.4743126587785522, 0.03529879386055947),
        (0.4429481231900081, 0.03529879386055947),
        (0.41103172939762184, 0.03529879386055947),
        (0.3786032412537035, 0.03529879386055947),
        (0.34570306061635636, 0.03529879386055947),
        (0.3123721770137941, 0.03529879386055947),
        (0.27865211657649225, 0.03529879386055947),
        (0.24458489030079994, 0.03529879386055947),
        (0.21021294170847124, 0.03529879386055947),
        (0.1755790939673208, 0.03529879386055947),
        (0.1407264965388905, 0.03529879386055947),
        (0.1056985714195931, 0.03529879386055947),
        (0.07053895904231097, 0.03529879386055947),
        (0.03529146390585262, 0.03529879386055947),
        (0.0, 0.03529879386055947),
    ],
    &[
        (0.9998476951563913, 0.03490658503988659),
        (0.9986295347545738, 0.03490658503988659),
        (0.9961946980917455, 0.03490658503988659),
        (0.992546151641322, 0.03490658503988659),
        (0.9876883405951378, 0.03490658503988659),
        (0.981627183447664, 0.03490658503988659),
        (0.9743700647852352, 0.03490658503988659),
        (0.9659258262890683, 0.03490658503988659),
        (0.9563047559630354, 0.03490658503988659),
        (0.9455185755993168, 0.03490658503988659),
        (0.9335804264972017, 0.03490658503988659),
        (0.9205048534524404, 0.03490658503988659),
        (0.9063077870366499, 0.03490658503988659),
        (0.8910065241883679, 0.03490658503988659),
        (0.8746197071393957, 0.03490658503988659),
        (0.8571673007021123, 0.03490658503988659),
        (0.838670567945424, 0.03490658503988659),
        (0.8191520442889918, 0.03490658503988659),
        (0.7986355100472928, 0.03490658503988659),
        (0.7771459614569709, 0.03490658503988659),
        (0.754709580222772, 0.03490658503988659),
        (0.7313537016191705, 0.03490658503988659),
        (f64::consts::FRAC_1_SQRT_2, 0.03490658503988659),
        (0.6819983600624985, 0.03490658503988659),
        (0.6560590289905073, 0.03490658503988659),
        (0.6293203910498375, 0.03490658503988659),
        (0.6018150231520484, 0.03490658503988659),
        (0.5735764363510462, 0.03490658503988659),
        (0.5446390350150271, 0.03490658503988659),
        (0.5150380749100542, 0.03490658503988659),
        (0.4848096202463371, 0.03490658503988659),
        (0.4539904997395468, 0.03490658503988659),
        (0.42261826174069944, 0.03490658503988659),
        (0.3907311284892737, 0.03490658503988659),
        (0.3583679495453004, 0.03490658503988659),
        (0.32556815445715676, 0.03490658503988659),
        (0.29237170472273677, 0.03490658503988659),
        (0.25881904510252074, 0.03490658503988659),
        (0.22495105434386492, 0.03490658503988659),
        (0.19080899537654492, 0.03490658503988659),
        (0.15643446504023092, 0.03490658503988659),
        (0.12186934340514749, 0.03490658503988659),
        (0.08715574274765814, 0.03490658503988659),
        (0.052335956242943966, 0.03490658503988659),
        (0.0174524064372836, 0.03490658503988659),
    ],
    &[
        (0.9998510240408495, 0.03452299619329443),
        (0.9986594826804561, 0.03452299619329443),
        (0.9962778199420265, 0.03452299619329443),
        (0.992708874098054, 0.03452299619329443),
        (0.9879568983287464, 0.03452299619329443),
        (0.9820275556534304, 0.03452299619329443),
        (0.9749279121818236, 0.03452299619329443),
        (0.9666664286932195, 0.03452299619329443),
        (0.9572529505536158, 0.03452299619329443),
        (0.946698695982806, 0.03452299619329443),
        (0.9350162426854148, 0.03452299619329443),
        (0.9222195128618104, 0.03452299619329443),
        (0.908323756616754, 0.03452299619329443),
        (0.8933455337855631, 0.03452299619329443),
        (0.877302694199442, 0.03452299619329443),
        (0.8602143564135007, 0.03452299619329443),
        (0.8421008849228118, 0.03452299619329443),
        (0.8229838658936564, 0.03452299619329443),
        (0.8028860814388825, 0.03452299619329443),
        (0.7818314824680298, 0.03452299619329443),
        (0.7598451601445788, 0.03452299619329443),
        (0.7369533159843368, 0.03452299619329443),
        (0.7131832306305963, 0.03452299619329443),
        (0.6885632313432771, 0.03452299619329443),
        (0.6631226582407953, 0.03452299619329443),
        (0.6368918293348893, 0.03452299619329443),
        (0.6099020044000728, 0.03452299619329443),
        (0.5821853477207708, 0.03452299619329443),
        (0.5537748897605331, 0.03452299619329443),
        (0.5247044877990081, 0.03452299619329443),
        (0.49500878558358147, 0.03452299619329443),
        (0.4647231720437686, 0.03452299619329443),
        (0.4338837391175582, 0.03452299619329443),
        (0.40252723873996754, 0.03452299619329443),
        (0.3706910390450675, 0.03452299619329443),
        (0.3384130798336706, 0.03452299619329443),
        (0.305731827359753, 0.03452299619329443),
        (0.27268622848949386, 0.03452299619329443),
        (0.23931566428755782, 0.03452299619329443),
        (0.20565990308593662, 0.03452299619329443),
        (0.17175905309127604, 0.03452299619329443),
        (0.13765351458716818, 0.03452299619329443),
        (0.10338393178837031, 0.03452299619329443),
        (0.06899114440432505, 0.03452299619329443),
        (0.03451613896970822, 0.03452299619329443),
        (0.0, 0.03452299619329443),
    ],
    &[
        (0.999854244969279, 0.034147746234671664),
        (0.9986884596454729, 0.034147746234671664),
        (0.9963582482514, 0.034147746234671664),
        (0.9928663277093099, 0.034147746234671664),
        (0.9882167694423529, 0.034147746234671664),
        (0.9824149946274826, 0.034147746234671664),
        (0.9754677678746061, 0.034147746234671664),
        (0.9673831893393515, 0.034147746234671664),
        (0.9581706852786488, 0.034147746234671664),
        (0.9478409970601358, 0.034147746234671664),
        (0.936406168638204, 0.034147746234671664),
        (0.9238795325112867, 0.034147746234671664),
        (0.9102756941767621, 0.034147746234671664),
        (0.8956105151015966, 0.034147746234671664),
        (0.879901094228584, 0.034147746234671664),
        (0.8631657480397428, 0.034147746234671664),
        (0.8454239892001179, 0.034147746234671664),
        (0.8266965038068858, 0.034147746234671664),
        (0.8070051272702906, 0.034147746234671664),
        (0.7863728188545325, 0.034147746234671664),
        (0.7648236349082926, 0.034147746234671664),
        (0.7423827008161068, 0.034147746234671664),
        (0.7190761817032908, 0.034147746234671664),
        (0.6949312519285747, 0.034147746234671664),
        (0.6699760634000165, 0.034147746234671664),
        (0.6442397127511363, 0.034147746234671664),
        (0.6177522074155435, 0.034147746234671664),
        (0.5905444306396108, 0.034147746234671664),
        (0.5626481054739915, 0.034147746234671664),
        (0.5340957577859603, 0.034147746234671664),
        (0.5049206783357079, 0.034147746234671664),
        (0.47515688396080374, 0.034147746234671664),
        (0.4448390779140843, 0.034147746234671664),
        (0.41400260940121364, 0.034147746234671664),
        (0.38268343236508984, 0.034147746234671664),
        (0.350918063565157, 0.034147746234671664),
        (0.31874354000049593, 0.034147746234671664),
        (0.2861973757263413, 0.034147746234671664),
        (0.25331751811437053, 0.034147746234671664),
        (0.22014230360776563, 0.034147746234671664),
        (0.1867104130226364, 0.034147746234671664),
        (0.15306082644791777, 0.034147746234671664),
        (0.11923277779633124, 0.034147746234671664),
        (0.08526570905939608, 0.034147746234671664),
        (0.051199224319833044, 0.034147746234671664),
        (0.017073043574974828, 0.034147746234671664),
    ],
    &[
        (0.9998573625597098, 0.033780566167632184),
        (0.9987165071710528, 0.033780566167632184),
        (0.996436098130433, 0.033780566167632184),
        (0.9930187374259336, 0.033780566167632184),
        (0.9884683243281114, 0.033780566167632184),
        (0.982790050940858, 0.033780566167632184),
        (0.9759903962771154, 0.033780566167632184),
        (0.9680771188662043, 0.033780566167632184),
        (0.9590592479012021, 0.033780566167632184),
        (0.9489470729364691, 0.033780566167632184),
        (0.9377521321470804, 0.033780566167632184),
        (0.9254871991635596, 0.033780566167632184),
        (0.9121662684969334, 0.033780566167632184),
        (0.8978045395707417, 0.033780566167632184),
        (0.8824183993782191, 0.033780566167632184),
        (0.8660254037844387, 0.033780566167632184),
        (0.8486442574947509, 0.033780566167632184),
        (0.8302947927123764, 0.033780566167632184),
        (0.8109979465095012, 0.033780566167632184),
        (0.7907757369376985, 0.033780566167632184),
        (0.7696512379049323, 0.033780566167632184),
        (0.747648552847809, 0.033780566167632184),
        (0.72479278722912, 0.033780566167632184),
        (0.7011100198920527, 0.033780566167632184),
        (0.6766272733037574, 0.033780566167632184),
        (0.6513724827222223, 0.033780566167632184),
        (0.6253744643216369, 0.033780566167632184),
        (0.5986628823126151, 0.033780566167632184),
        (0.5712682150947923, 0.033780566167632184),
        (0.5432217204804188, 0.033780566167632184),
        (0.5145554000286289, 0.033780566167632184),
        (0.485301962531081, 0.033780566167632184),
        (0.45549478669063415, 0.033780566167632184),
        (0.42516788303564074, 0.033780566167632184),
        (0.39435585511331855, 0.033780566167632184),
        (0.3630938600064747, 0.033780566167632184),
        (0.3314175682186358, 0.033780566167632184),
        (0.299363122973358, 0.033780566167632184),
        (0.26696709897415183, 0.033780566167632184),
        (0.23426646067208223, 0.033780566167632184),
        (0.20129852008866012, 0.033780566167632184),
        (0.16810089424214814, 0.033780566167632184),
        (0.13471146222586108, 0.033780566167632184),
        (0.10116832198743222, 0.033780566167632184),
        (0.06750974685836528, 0.033780566167632184),
        (0.03377414188346829, 0.033780566167632184),
        (0.0, 0.033780566167632184),
    ],
    &[
        (0.9998603811858571, 0.03342119844244461),
        (0.9987436645827857, 0.03342119844244461),
        (0.9965114786067516, 0.03342119844244461),
        (0.9931663163249741, 0.03342119844244461),
        (0.9887119138573461, 0.03342119844244461),
        (0.9831532462036635, 0.03342119844244461),
        (0.9764965216871847, 0.03342119844244461),
        (0.9687491750207252, 0.03342119844244461),
        (0.9599198590030308, 0.03342119844244461),
        (0.9500184348547039, 0.03342119844244461),
        (0.939055961204478, 0.03342119844244461),
        (0.9270446817381375, 0.03342119844244461),
        (0.9139980115238827, 0.03342119844244461),
        (0.8999305220294078, 0.03342119844244461),
        (0.8848579248474286, 0.03342119844244461),
        (0.8687970541478365, 0.03342119844244461),
        (0.8517658478760761, 0.03342119844244461),
        (0.833783327718747, 0.03342119844244461),
        (0.8148695778588034, 0.03342119844244461),
        (0.795045722544083, 0.03342119844244461),
        (0.7743339024942135, 0.03342119844244461),
        (0.7527572501722514, 0.03342119844244461),
        (0.7303398639486693, 0.03342119844244461),
        (f64::consts::FRAC_1_SQRT_2, 0.03342119844244461),
        (0.6830839502780308, 0.03342119844244461),
        (0.6582982016632816, 0.03342119844244461),
        (0.6327772178642985, 0.03342119844244461),
        (0.6065495025670674, 0.03342119844244461),
        (0.5796443487865776, 0.03342119844244461),
        (0.5520918061502568, 0.03342119844244461),
        (0.5239226473363687, 0.03342119844244461),
        (0.4951683337048536, 0.03342119844244461),
        (0.46586098015899824, 0.03342119844244461),
        (0.4360333192771828, 0.03342119844244461),
        (0.4057186647547637, 0.03342119844244461),
        (0.3749508741969212, 0.03342119844244461),
        (0.34376431130403, 0.03342119844244461),
        (0.3121938074917864, 0.03342119844244461),
        (0.2802746229889561, 0.03342119844244461),
        (0.24804240745619338, 0.03342119844244461),
        (0.21553316016991364, 0.03342119844244461),
        (0.18278318981569042, 0.03342119844244461),
        (0.14982907393608155, 0.03342119844244461),
        (0.11670761807817612, 0.03342119844244461),
        (0.0834558146864898, 0.03342119844244461),
        (0.050110801787119304, 0.03342119844244461),
        (0.01670982150930091, 0.03342119844244461),
    ],
    &[
        (0.999863304992469, 0.03306939635357677),
        (0.9987699691483047, 0.03306939635357677),
        (0.9965844930066698, 0.03306939635357677),
        (0.9933092663536381, 0.03306939635357677),
        (0.9889478706014685, 0.03306939635357677),
        (0.9835050748723824, 0.03306939635357677),
        (0.9769868307835993, 0.03306939635357677),
        (0.9694002659393304, 0.03306939635357677),
        (0.9607536761368481, 0.03306939635357677),
        (0.9510565162951536, 0.03306939635357677),
        (0.9403193901161613, 0.03306939635357677),
        (0.9285540384897071, 0.03306939635357677),
        (0.9157733266550575, 0.03306939635357677),
        (0.901991230132959, 0.03306939635357677),
        (0.8872228194436118, 0.03306939635357677),
        (0.8714842436272774, 0.03306939635357677),
        (0.854792712585539, 0.03306939635357677),
        (0.8371664782625287, 0.03306939635357677),
        (0.8186248146866925, 0.03306939635357677),
        (0.7991879968949248, 0.03306939635357677),
        (0.7788772787621125, 0.03306939635357677),
        (0.7577148697603348, 0.03306939635357677),
        (0.7357239106731317, 0.03306939635357677),
        (0.7129284482913972, 0.03306939635357677),
        (0.6893534091185659, 0.03306939635357677),
        (0.6650245721138484, 0.03306939635357677),
        (0.6399685405033166, 0.03306939635357677),
        (0.6142127126896679, 0.03306939635357677),
        (0.5877852522924732, 0.03306939635357677),
        (0.5607150573516728, 0.03306939635357677),
        (0.5330317287279939, 0.03306939635357677),
        (0.5047655377348439, 0.03306939635357677),
        (0.4759473930370736, 0.03306939635357677),
        (0.44660880685280674, 0.03306939635357677),
        (0.41678186049529053, 0.03306939635357677),
        (0.38649916929245254, 0.03306939635357677),
        (0.35579384692251664, 0.03306939635357677),
        (0.32469946920468357, 0.03306939635357677),
        (0.293250037384465, 0.03306939635357677),
        (0.2614799409538199, 0.03306939635357677),
        (0.22942392004675183, 0.03306939635357677),
        (0.1971170274514805, 0.03306939635357677),
        (0.1645945902807342, 0.03306939635357677),
        (0.1318921713420691, 0.03306939635357677),
        (0.09904553025046282, 0.03306939635357677),
        (0.0660905843256997, 0.03306939635357677),
        (0.03306336931730837, 0.03306939635357677),
        (0.0, 0.03306939635357677),
    ],
    &[
        (0.9998661379095618, 0.032724923474893676),
        (0.9987954562051724, 0.032724923474893676),
        (0.9966552393091803, 0.032724923474893676),
        (0.9934477790194444, 0.032724923474893676),
        (0.989176509964781, 0.032724923474893676),
        (0.9838460059270774, 0.032724923474893676),
        (0.9774619749435719, 0.032724923474893676),
        (0.970031253194544, 0.032724923474893676),
        (0.9615617976829619, 0.032724923474893676),
        (0.9520626777139243, 0.032724923474893676),
        (0.9415440651830208, 0.032724923474893676),
        (0.9300172236840122, 0.032724923474893676),
        (0.9174944964474914, 0.032724923474893676),
        (0.9039892931234433, 0.032724923474893676),
        (0.8895160754218561, 0.032724923474893676),
        (0.8740903416267589, 0.032724923474893676),
        (0.8577286100002721, 0.032724923474893676),
        (0.8404484010944381, 0.032724923474893676),
        (0.8222682189897751, 0.032724923474893676),
        (0.8032075314806449, 0.032724923474893676),
        (0.7832867492286505, 0.032724923474893676),
        (0.7625272039063882, 0.032724923474893676),
        (0.7409511253549591, 0.032724923474893676),
        (0.7185816177796981, 0.032724923474893676),
        (0.6954426350096117, 0.032724923474893676),
        (0.6715589548470184, 0.032724923474893676),
        (0.6469561525348575, 0.032724923474893676),
        (0.6216605733700774, 0.032724923474893676),
        (0.5956993044924335, 0.032724923474893676),
        (0.5691001458788983, 0.032724923474893676),
        (0.5418915805747517, 0.032724923474893676),
        (0.5141027441932219, 0.032724923474893676),
        (0.4857633937163401, 0.032724923474893676),
        (0.45690387563042073, 0.032724923474893676),
        (0.4275550934302822, 0.032724923474893676),
        (0.3977484745270112, 0.032724923474893676),
        (0.3675159365947037, 0.032724923474893676),
        (0.3368898533922203, 0.032724923474893676),
        (0.3059030200965535, 0.032724923474893676),
        (0.2745886181849324, 0.032724923474893676),
        (0.24298017990326398, 0.032724923474893676),
        (0.2111115523589653, 0.032724923474893676),
        (0.17901686127663285, 0.032724923474893676),
        (0.14673047445536197, 0.032724923474893676),
        (0.11428696496684666, 0.032724923474893676),
        (0.0817210741336683, 0.032724923474893676),
        (0.049067674327418126, 0.032724923474893676),
        (0.016361731626486936, 0.032724923474893676),
    ],
    &[
        (0.9998688836656322, 0.032387553129791684),
        (0.9988201592795908, 0.032387553129791684),
        (0.9967238104745694, 0.032387553129791684),
        (0.9935820360309777, 0.032387553129791684),
        (0.989398131236356, 0.032387553129791684),
        (0.9841764844290742, 0.032387553129791684),
        (0.9779225723955707, 0.032387553129791684),
        (0.9706429546259592, 0.032387553129791684),
        (0.9623452664340302, 0.032387553129791684),
        (0.9530382109488609, 0.032387553129791684),
        (0.9427315499864342, 0.032387553129791684),
        (0.9314360938108422, 0.032387553129791684),
        (0.9191636897958122, 0.032387553129791684),
        (0.9059272099984468, 0.032387553129791684),
        (0.8917405376582144, 0.032387553129791684),
        (0.8766185526353477, 0.032387553129791684),
        (0.8605771158039253, 0.032387553129791684),
        (0.8436330524160045, 0.032387553129791684),
        (0.8258041344542565, 0.032387553129791684),
        (0.8071090619916093, 0.032387553129791684),
        (0.7875674435774543, 0.032387553129791684),
        (0.7671997756709861, 0.032387553129791684),
        (0.7460274211432459, 0.032387553129791684),
        (0.7240725868704214, 0.032387553129791684),
        (0.7013583004418992, 0.032387553129791684),
        (0.6779083860075031, 0.032387553129791684),
        (0.6537474392892525, 0.032387553129791684),
        (0.6289008017838444, 0.032387553129791684),
        (0.6033945341829247, 0.032387553129791684),
        (0.5772553890390194, 0.032387553129791684),
        (0.5505107827058034, 0.032387553129791684),
        (0.5231887665821301, 0.032387553129791684),
        (0.4953179976899875, 0.032387553129791684),
        (0.4669277086172406, 0.032387553129791684),
        (0.4380476768566823, 0.032387553129791684),
        (0.4087081935735561, 0.032387553129791684),
        (0.37894003183430663, 0.032387553129791684),
        (0.3487744143298822, 0.032387553129791684),
        (0.3182429806274438, 0.032387553129791684),
        (0.28737775398482807, 0.032387553129791684),
        (0.2562111077625723, 0.032387553129791684),
        (0.22477573146872928, 0.032387553129791684),
        (0.1931045964720878, 0.032387553129791684),
        (0.1612309214197597, 0.032387553129791684),
        (0.12918813739540624, 0.032387553129791684),
        (0.09700985285464794, 0.032387553129791684),
        (0.0647298183744356, 0.032387553129791684),
        (0.03238189125335575, 0.032387553129791684),
        (0.0, 0.032387553129791684),
    ],
    &[
        (0.9998715457999312, 0.0320570678937734),
        (0.9988441101966808, 0.0320570678937734),
        (0.9967902947497157, 0.0320570678937734),
        (0.9937122098932426, 0.0320570678937734),
        (0.9896130185675259, 0.0320570678937734),
        (0.9844969329687524, 0.0320570678937734),
        (0.9783692102207153, 0.0320570678937734),
        (0.9712361469727638, 0.0320570678937734),
        (0.9631050729295704, 0.0320570678937734),
        (0.9539843433193639, 0.0320570678937734),
        (0.9438833303083676, 0.0320570678937734),
        (0.9328124133702648, 0.0320570678937734),
        (0.9207829686205883, 0.0320570678937734),
        (0.9078073571269921, 0.0320570678937734),
        (0.8938989122074196, 0.0320570678937734),
        (0.8790719257292172, 0.0320570678937734),
        (0.8633416334232752, 0.0320570678937734),
        (0.8467241992282841, 0.0320570678937734),
        (0.8292366986811951, 0.0320570678937734),
        (0.8108971013709511, 0.0320570678937734),
        (0.7917242524735199, 0.0320570678937734),
        (0.7717378533872018, 0.0320570678937734),
        (0.7509584414881113, 0.0320570678937734),
        (0.7294073690266343, 0.0320570678937734),
        (f64::consts::FRAC_1_SQRT_2, 0.0320570678937734),
        (0.6840795933293461, 0.0320570678937734),
        (0.6603494674471594, 0.0320570678937734),
        (0.6359407878484552, 0.0320570678937734),
        (0.6108786361015144, 0.0320570678937734),
        (0.5851887652614238, 0.0320570678937734),
        (0.5588975734070717, 0.0320570678937734),
        (0.5320320765153366, 0.0320570678937734),
        (0.5046198807003458, 0.0320570678937734),
        (0.47668915384632543, 0.0320570678937734),
        (0.4482685966631972, 0.0320570678937734),
        (0.4193874131946569, 0.0320570678937734),
        (0.3900752808090469, 0.0320570678937734),
        (0.3603623197038535, 0.0320570678937734),
        (0.33027906195516715, 0.0320570678937734),
        (0.2998564201439118, 0.0320570678937734),
        (0.26912565559107693, 0.0320570678937734),
        (0.23811834623459838, 0.0320570678937734),
        (0.20686635418089092, 0.0320570678937734),
        (0.17540179296438188, 0.0320570678937734),
        (0.14375699454868182, 0.0320570678937734),
        (0.11196447610330791, 0.0320570678937734),
        (0.08005690659009354, 0.0320570678937734),
        (0.04806707319362087, 0.0320570678937734),
        (0.016027847630173966, 0.0320570678937734),
    ],
    &[
        (0.9998741276738751, 0.03173325912716963),
        (0.998867339183008, 0.03173325912716963),
        (0.9968547759519424, 0.03173325912716963),
        (0.9938384644612541, 0.03173325912716963),
        (0.9898214418809327, 0.03173325912716963),
        (0.984807753012208, 0.03173325912716963),
        (0.9788024462147787, 0.03173325912716963),
        (0.9718115683235417, 0.03173325912716963),
        (0.963842158559942, 0.03173325912716963),
        (0.9549022414440739, 0.03173325912716963),
        (0.9450008187146685, 0.03173325912716963),
        (0.9341478602651068, 0.03173325912716963),
        (0.9223542941045814, 0.03173325912716963),
        (0.9096319953545183, 0.03173325912716963),
        (0.8959937742913359, 0.03173325912716963),
        (0.8814533634475821, 0.03173325912716963),
        (0.8660254037844386, 0.03173325912716963),
        (0.8497254299495144, 0.03173325912716963),
        (0.8325698546347713, 0.03173325912716963),
        (0.8145759520503357, 0.03173325912716963),
        (0.7957618405308321, 0.03173325912716963),
        (0.7761464642917568, 0.03173325912716963),
        (0.7557495743542583, 0.03173325912716963),
        (0.7345917086575332, 0.03173325912716963),
        (0.7126941713788629, 0.03173325912716963),
        (0.690079011482112, 0.03173325912716963),
        (0.6667690005162916, 0.03173325912716963),
        (0.6427876096865394, 0.03173325912716963),
        (0.6181589862206053, 0.03173325912716963),
        (0.5929079290546405, 0.03173325912716963),
        (0.5670598638627707, 0.03173325912716963),
        (0.5406408174555977, 0.03173325912716963),
        (0.5136773915734064, 0.03173325912716963),
        (0.48619673610046865, 0.03173325912716963),
        (0.45822652172741046, 0.03173325912716963),
        (0.4297949120891716, 0.03173325912716963),
        (0.4009305354066138, 0.03173325912716963),
        (0.3716624556603275, 0.03173325912716963),
        (0.3420201433256688, 0.03173325912716963),
        (0.3120334456984871, 0.03173325912716963),
        (0.2817325568414296, 0.03173325912716963),
        (0.2511479871810792, 0.03173325912716963),
        (0.22031053278654053, 0.03173325912716963),
        (0.18925124436041021, 0.03173325912716963),
        (0.1580013959733498, 0.03173325912716963),
        (0.1265924535737493, 0.03173325912716963),
        (0.09505604330418259, 0.03173325912716963),
        (0.06342391965656456, 0.03173325912716963),
        (0.031727933498067594, 0.03173325912716963),
        (0.0, 0.03173325912716963),
    ],
    &[
        (0.9998766324816606, 0.031415926535897934),
        (0.99888987496197, 0.031415926535897934),
        (0.996917333733128, 0.031415926535897934),
        (0.9939609554551797, 0.031415926535897934),
        (0.9900236577165575, 0.031415926535897934),
        (0.9851093261547739, 0.031415926535897934),
        (0.9792228106217657, 0.031415926535897934),
        (0.9723699203976766, 0.031415926535897934),
        (0.9645574184577981, 0.031415926535897934),
        (0.9557930147983301, 0.031415926535897934),
        (0.9460853588275453, 0.031415926535897934),
        (0.9354440308298674, 0.031415926535897934),
        (0.9238795325112867, 0.031415926535897934),
        (0.9114032766354453, 0.031415926535897934),
        (0.8980275757606156, 0.031415926535897934),
        (0.8837656300886935, 0.031415926535897934),
        (0.8686315144381912, 0.031415926535897934),
        (0.8526401643540922, 0.031415926535897934),
        (0.8358073613682703, 0.031415926535897934),
        (0.8181497174250234, 0.031415926535897934),
        (0.7996846584870906, 0.031415926535897934),
        (0.7804304073383297, 0.031415926535897934),
        (0.7604059656000309, 0.031415926535897934),
        (0.7396310949786097, 0.031415926535897934),
        (0.7181262977631888, 0.031415926535897934),
        (0.6959127965923143, 0.031415926535897934),
        (0.6730125135097733, 0.031415926535897934),
        (0.6494480483301835, 0.031415926535897934),
        (0.6252426563357052, 0.031415926535897934),
        (0.600420225325884, 0.031415926535897934),
        (0.5750052520432785, 0.031415926535897934),
        (0.5490228179981317, 0.031415926535897934),
        (0.5224985647159489, 0.031415926535897934),
        (0.49545866843240755, 0.031415926535897934),
        (0.46792981426057334, 0.031415926535897934),
        (0.4399391698559151, 0.031415926535897934),
        (0.41151435860510865, 0.031415926535897934),
        (0.38268343236508984, 0.031415926535897934),
        (0.35347484377925714, 0.031415926535897934),
        (0.3239174181981494, 0.031415926535897934),
        (0.2940403252323039, 0.031415926535897934),
        (0.26387304996537275, 0.031415926535897934),
        (0.23344536385590525, 0.031415926535897934),
        (0.2027872953565125, 0.031415926535897934),
        (0.17192910027940952, 0.031415926535897934),
        (0.14090123193758258, 0.031415926535897934),
        (0.10973431109104514, 0.031415926535897934),
        (0.07845909572784478, 0.031415926535897934),
        (0.04710645070964268, 0.031415926535897934),
        (0.015707317311820648, 0.031415926535897934),
    ],
];
pub const WEIGHTS_CHEBYSHEV_SECOND: &[&[(f64, f64)]] = &[
    &[(0.0, f64::consts::FRAC_PI_2)],
    &[(0.5000000000000001, 0.7853981633974481)],
    &[
        (f64::consts::FRAC_1_SQRT_2, 0.39269908169872403),
        (0.0, f64::consts::FRAC_PI_4),
    ],
    &[
        (0.8090169943749475, 0.217078713422706),
        (0.30901699437494745, 0.5683194499747423),
    ],
    &[
        (0.8660254037844387, 0.13089969389957468),
        (0.5000000000000001, 0.39269908169872403),
        (0.0, 0.5235987755982988),
    ],
    &[
        (0.9009688679024191, 0.08448869089158857),
        (0.6234898018587336, 0.2743330560697778),
        (0.22252093395631445, 0.42657641643608185),
    ],
    &[
        (0.9238795325112867, 0.05750944903191313),
        (f64::consts::FRAC_1_SQRT_2, 0.19634954084936201),
        (0.38268343236508984, 0.335189632666811),
        (0.0, f64::consts::FRAC_PI_8),
    ],
    &[
        (0.9396926207859084, 0.04083294770910708),
        (0.766044443118978, 0.14422560079567273),
        (0.5000000000000001, 0.2617993877991494),
        (0.17364817766693041, 0.338540227093519),
    ],
    &[
        (0.9510565162951535, 0.029999540371608163),
        (0.8090169943749475, 0.108539356711353),
        (0.5877852522924731, 0.20561990864762633),
        (0.30901699437494745, 0.28415972498737113),
        (0.0, 0.3141592653589793),
    ],
    &[
        (0.9594929736144974, 0.022668942501858837),
        (0.8412535328311812, 0.08347854093418902),
        (0.6548607339452851, 0.16312217745481658),
        (0.41541501300188644, 0.2363135602034873),
        (0.14231483827328512, 0.2798149423030965),
    ],
    &[
        (0.9659258262890683, 0.017537233634936096),
        (0.8660254037844387, 0.06544984694978734),
        (f64::consts::FRAC_1_SQRT_2, 0.13089969389957468),
        (0.5000000000000001, 0.19634954084936201),
        (0.25881904510252096, 0.24426215416421326),
        (0.0, 0.2617993877991494),
    ],
    &[
        (0.970941817426052, 0.013840404166186674),
        (0.8854560256532099, 0.052190946865224914),
        (0.7485107481711011, 0.10626598093890648),
        (0.5680647467311558, 0.16367756775575623),
        (0.35460488704253557, 0.21127340466065864),
        (0.120536680255323, 0.23814985901071542),
    ],
    &[
        (0.9749279121818236, 0.011111267038372872),
        (0.9009688679024191, 0.042244345445794286),
        (0.7818314824680298, 0.08723294722152485),
        (0.6234898018587336, 0.1371665280348889),
        (0.4338837391175582, 0.18215512981061951),
        (0.22252093395631445, 0.21328820821804093),
        (0.0, 0.2243994752564138),
    ],
    &[
        (0.9781476007338057, 0.009053498504649085),
        (0.9135454576426009, 0.03464856187869067),
        (0.8090169943749475, 0.072359571140902),
        (0.6691306063588582, 0.11566595019608279),
        (0.5000000000000001, 0.15707963267948963),
        (0.30901699437494745, 0.1894398166582474),
        (0.10452846326765368, 0.20715113233938662),
    ],
    &[
        (0.9807852804032304, 0.007473109420323819),
        (0.9238795325112867, 0.028754724515956565),
        (0.8314696123025452, 0.06060491230690939),
        (f64::consts::FRAC_1_SQRT_2, 0.09817477042468101),
        (0.5555702330196023, 0.13574462854245267),
        (0.38268343236508984, 0.1675948163334055),
        (0.19509032201612833, 0.18887643142903826),
        (0.0, 0.19634954084936207),
    ],
    &[
        (0.9829730996839018, 0.006239551412252137),
        (0.9324722294043558, 0.024115519656235967),
        (0.8502171357296142, 0.051213656166441954),
        (0.7390089172206591, 0.08387420745120885),
        (0.6026346363792564, 0.11768618508116663),
        (0.4457383557765383, 0.1480830941187536),
        (0.2736629900720828, 0.170959663563356),
        (0.09226835946330202, 0.1832262859480331),
    ],
    &[
        (0.984807753012208, 0.005262811652673444),
        (0.9396926207859084, 0.02041647385455354),
        (0.8660254037844387, 0.04363323129985823),
        (0.766044443118978, 0.07211280039783637),
        (0.6427876096865394, 0.10242012480159657),
        (0.5000000000000001, 0.1308996938995747),
        (0.3420201433256688, 0.15411645134487936),
        (0.17364817766693041, 0.1692701135467595),
        (0.0, 0.17453292519943295),
    ],
    &[
        (0.9863613034027223, 0.004479477774329408),
        (0.9458172417006346, 0.017432490174209888),
        (0.8794737512064891, 0.037455377319418635),
        (0.7891405093963936, 0.062378348700667025),
        (0.6772815716257411, 0.08950061364905067),
        (0.546948158122427, 0.11588305391211036),
        (0.40169542465296953, 0.1386667227216045),
        (0.24548548714079924, 0.1553826560369778),
        (0.0825793454723324, 0.16421942310907997),
    ],
    &[
        (0.9876883405951378, 0.003844012221205932),
        (0.9510565162951535, 0.014999770185804081),
        (0.8910065241883679, 0.032375270577483406),
        (0.8090169943749475, 0.0542696783556765),
        (f64::consts::FRAC_1_SQRT_2, 0.07853981633974481),
        (0.5877852522924731, 0.10280995432381317),
        (0.4539904997395468, 0.12470436210200622),
        (0.30901699437494745, 0.14207986249368557),
        (0.15643446504023092, 0.15323562045828373),
        (0.0, 0.15707963267948966),
    ],
    &[
        (0.9888308262251285, 0.003323146356234932),
        (0.9555728057861408, 0.012997309287800674),
        (0.9009688679024191, 0.028162896963862847),
        (0.8262387743159949, 0.047472380366318005),
        (0.7330518718298265, 0.0692100271565858),
        (0.6234898018587336, 0.09144435202325925),
        (0.5000000000000001, 0.11219973762820687),
        (0.3653410243663952, 0.12963197687691952),
        (0.22252093395631467, 0.14219213881202725),
        (0.0747300935864246, 0.14876419792623288),
    ],
    &[
        (0.9898214418809327, 0.002892194920715066),
        (0.9594929736144974, 0.011334471250929418),
        (0.9096319953545184, 0.024642885970519664),
        (0.8412535328311812, 0.04173927046709451),
        (0.7557495743542583, 0.06123857734485503),
        (0.6548607339452851, 0.08156108872740829),
        (0.5406408174555977, 0.1010603956051688),
        (0.41541501300188644, 0.11815678010174364),
        (0.2817325568414298, 0.1314651948213339),
        (0.14231483827328512, 0.13990747115154825),
        (0.0, 0.14279966607226333),
    ],
    &[
        (0.9906859460363308, 0.0025325821226811957),
        (0.9629172873477992, 0.00994249846047781),
        (0.917211301505453, 0.02168018941672712),
        (0.8544194045464886, 0.03687512414956727),
        (0.7757112907044199, 0.05440036386206456),
        (0.6825531432186541, 0.07295614169738002),
        (0.5766803221148672, 0.09116626050050351),
        (0.4600650377311522, 0.10768015906555772),
        (0.3348796121709863, 0.1212730770820316),
        (0.20345601305263397, 0.13093689000410558),
        (0.068242413364671, 0.1359548770363518),
    ],
    &[
        (0.9914448613738104, 0.0022301494543209475),
        (0.9659258262890683, 0.008768616817468048),
        (0.9238795325112867, 0.019169816343971042),
        (0.8660254037844387, 0.03272492347489367),
        (0.7933533402912353, 0.04851018006013724),
        (f64::consts::FRAC_1_SQRT_2, 0.06544984694978734),
        (0.6087614290087207, 0.08238951383943745),
        (0.5000000000000001, 0.09817477042468101),
        (0.38268343236508984, 0.11172987755560365),
        (0.25881904510252096, 0.12213107708210663),
        (0.1305261922200517, 0.12866954444525375),
        (0.0, 0.1308996938995747),
    ],
    &[
        (0.9921147013144779, 0.001973978203946135),
        (0.9685831611286311, 0.007771880505446599),
        (0.9297764858882513, 0.017029403379705037),
        (0.8763066800438636, 0.02916486261774427),
        (0.8090169943749475, 0.0434157426845412),
        (0.7289686274214116, 0.05888660837442833),
        (0.6374239897486896, 0.07460536829824607),
        (0.5358267949789965, 0.08958435496042584),
        (0.42577929156507266, 0.10288238354012347),
        (0.30901699437494745, 0.11366388999494846),
        (0.18738131458572452, 0.12125143262273717),
        (0.0627905195293133, 0.1251682582151558),
    ],
    &[
        (0.992708874098054, 0.0017555571711728062),
        (0.970941817426052, 0.006920202083093337),
        (0.9350162426854148, 0.015193784346201198),
        (0.8854560256532099, 0.026095473432612457),
        (0.8229838658936564, 0.038991702798652404),
        (0.7485107481711011, 0.05313299046945324),
        (0.6631226582407952, 0.06769749620707727),
        (0.5680647467311558, 0.08183878387787812),
        (0.4647231720437686, 0.09473501324391806),
        (0.35460488704253557, 0.10563670233032932),
        (0.23931566428755763, 0.11391028459343717),
        (0.120536680255323, 0.11907492950535771),
        (0.0, 0.12083048667653051),
    ],
    &[
        (0.993238357741943, 0.0015681858622775464),
        (0.9730448705798238, 0.006188202143365021),
        (0.9396926207859084, 0.013610982569702354),
        (0.8936326403234123, 0.023436363127190607),
        (0.8354878114129365, 0.035134655006770626),
        (0.7660444431189781, 0.04807520026522424),
        (0.6862416378687337, 0.06156037075813293),
        (0.5971585917027863, 0.07486317745371773),
        (0.5000000000000001, 0.08726646259971646),
        (0.3960797660391569, 0.09810156188343765),
        (0.2868032327110903, 0.10678435229793497),
        (0.17364817766693064, 0.11284674236450631),
        (0.05814482891047612, 0.11596190706547169),
    ],
    &[
        (0.9937122098932426, 0.0014065408374953766),
        (0.9749279121818236, 0.005555633519186436),
        (0.9438833303083676, 0.012239225212910957),
        (0.9009688679024191, 0.021122172722897143),
        (0.8467241992282841, 0.03175904796903575),
        (0.7818314824680298, 0.04361647361076242),
        (f64::consts::FRAC_1_SQRT_2, 0.056099868814103435),
        (0.6234898018587336, 0.06858326401744445),
        (0.5320320765153366, 0.08044068965917114),
        (0.4338837391175582, 0.09107756490530976),
        (0.33027906195516715, 0.09996051241529595),
        (0.22252093395631445, 0.10664410410902046),
        (0.11196447610330791, 0.11079319679071152),
        (0.0, 0.1121997376282069),
    ],
    &[
        (0.9941379571543596, 0.0012663567314862676),
        (0.9766205557100867, 0.00500621349263519),
        (0.9476531711828025, 0.011044698737847696),
        (0.907575419670957, 0.019099459608351965),
        (0.8568571761675893, 0.028793864438066936),
        (0.7960930657056438, 0.03967461363171225),
        (0.7259954919231308, 0.05123293545007718),
        (0.6473862847818277, 0.06292837561108704),
        (0.5611870653623824, 0.07421406833136114),
        (0.46840844069979015, 0.08456230716244602),
        (0.37013815533991434, 0.09348921995784154),
        (0.26752833852922075, 0.10057739419678599),
        (0.16178199655276462, 0.10549539472980614),
        (0.05413890858541761, 0.10801326131794299),
    ],
    &[
        (0.9945218953682733, 0.001144188949966453),
        (0.9781476007338057, 0.004526749252324542),
        (0.9510565162951535, 0.009999846790536053),
        (0.9135454576426009, 0.017324280939345335),
        (0.8660254037844387, 0.026179938779914935),
        (0.8090169943749475, 0.036179785570451),
        (0.7431448254773944, 0.046886780021618356),
        (0.6691306063588582, 0.057832975098041396),
        (0.5877852522924731, 0.06853996954920877),
        (0.5000000000000001, 0.07853981633974481),
        (0.4067366430758004, 0.08739547418031442),
        (0.30901699437494745, 0.0947199083291237),
        (0.20791169081775945, 0.10019300586733522),
        (0.10452846326765368, 0.10357556616969331),
        (0.0, 0.10471975511965977),
    ],
    &[
        (0.9948693233918952, 0.0010372352609631414),
        (0.9795299412524945, 0.004106476510398766),
        (0.9541392564000488, 0.009082068650934446),
        (0.9189578116202306, 0.015760310355729393),
        (0.8743466161445821, 0.023867793624729232),
        (0.8207634412072763, 0.033072597140312264),
        (0.7587581226927909, 0.042997875165032014),
        (0.6889669190756866, 0.05323728565038583),
        (0.6121059825476629, 0.06337162592802367),
        (0.5289640103269624, 0.07298599491624462),
        (0.4403941515576343, 0.08168677921903053),
        (0.3473052528448203, 0.08911776770472658),
        (0.25065253225872053, 0.0949747348316243),
        (0.1514277775045767, 0.0990178956773841),
        (0.05064916883871277, 0.10108172276192934),
    ],
    &[
        (0.9951847266721969, 0.0009432003425937352),
        (0.9807852804032304, 0.0037365547101619093),
        (0.9569403357322088, 0.008272716060890053),
        (0.9238795325112867, 0.014377362257978282),
        (0.881921264348355, 0.02181589517159752),
        (0.8314696123025452, 0.030302456153454695),
        (0.773010453362737, 0.03951091142433527),
        (f64::consts::FRAC_1_SQRT_2, 0.049087385212340504),
        (0.6343932841636455, 0.05866385900034577),
        (0.5555702330196023, 0.06787231427122634),
        (0.4713967368259978, 0.0763588752530835),
        (0.38268343236508984, 0.08379740816670275),
        (0.29028467725446233, 0.08990205436379099),
        (0.19509032201612833, 0.09443821571451913),
        (0.09801714032956077, 0.09723157008208728),
        (0.0, 0.09817477042468103),
    ],
    &[
        (0.9954719225730846, 0.000860191998792087),
        (0.9819286972627067, 0.0034096784151236093),
        (0.9594929736144974, 0.007556314167286278),
        (0.9283679330160726, 0.013150229035242869),
        (0.8888354486549235, 0.01998924436086239),
        (0.8412535328311812, 0.027826180311396338),
        (0.7860530947427875, 0.03637778960265494),
        (0.7237340381050702, 0.045334994793851446),
        (0.6548607339452851, 0.05437405915160553),
        (0.5800569095711983, 0.06316828733897545),
        (0.5000000000000001, 0.07139983303613165),
        (0.41541501300188644, 0.07877118673449576),
        (0.3270679633174218, 0.08501592850553417),
        (0.23575893550942728, 0.08990835711112558),
        (0.14231483827328534, 0.0932716474343655),
        (0.0475819158237424, 0.09498424140000458),
    ],
    &[
        (0.9957341762950345, 0.0007866409550949983),
        (0.9829730996839018, 0.0031197757061260686),
        (0.961825643172819, 0.006919952147433547),
        (0.9324722294043558, 0.012057759828117983),
        (0.8951632913550623, 0.018358236869734777),
        (0.8502171357296142, 0.025606828083220977),
        (0.7980172272802395, 0.03355669138852825),
        (0.7390089172206591, 0.04193710372560443),
        (0.6736956436465572, 0.050462680203507124),
        (0.6026346363792564, 0.058843092540583314),
        (0.5264321628773558, 0.06679295584589058),
        (0.4457383557765383, 0.0740415470593768),
        (0.36124166618715303, 0.08034202410099357),
        (0.2736629900720828, 0.085479831781678),
        (0.1837495178165703, 0.0892800082229855),
        (0.09226835946330202, 0.09161314297401656),
        (0.0, 0.09239978392911156),
    ],
    &[
        (0.9959742939952391, 0.0007212383771244389),
        (0.9839295885986297, 0.0028617723136200634),
        (0.9639628606958532, 0.006352803287530714),
        (0.9362348706397372, 0.011082126690925046),
        (0.9009688679024191, 0.016897738178317717),
        (0.8584487936018661, 0.023612719211402844),
        (0.8090169943749475, 0.03101124477467228),
        (0.753071466003611, 0.03885552016899544),
        (0.6910626489868646, 0.046893423928907475),
        (0.6234898018587336, 0.05486661121395557),
        (0.5508969814521025, 0.06251881722443793),
        (0.4738686624729987, 0.06960409376292158),
        (0.39302503165392366, 0.0758947142116747),
        (0.30901699437494745, 0.0811884928535346),
        (0.22252093395631445, 0.08531528328721638),
        (0.13423326581765554, 0.08814244707264694),
        (0.044864830350514986, 0.08957911683956452),
    ],
    &[
        (0.9961946980917455, 0.0006628868267829002),
        (0.984807753012208, 0.002631405826336722),
        (0.9659258262890683, 0.005845744544978699),
        (0.9396926207859084, 0.01020823692727677),
        (0.9063077870366499, 0.01558633084972247),
        (0.8660254037844387, 0.021816615649929115),
        (0.8191520442889918, 0.028709787276918662),
        (0.766044443118978, 0.03605640019891818),
        (f64::consts::FRAC_1_SQRT_2, 0.04363323129985823),
        (0.6427876096865394, 0.051210062400798284),
        (0.5735764363510462, 0.058556675322797805),
        (0.5000000000000001, 0.06544984694978735),
        (0.42261826174069944, 0.071680131749994),
        (0.3420201433256688, 0.07705822567243968),
        (0.25881904510252074, 0.08142071805473779),
        (0.17364817766693041, 0.08463505677337975),
        (0.08715574274765836, 0.08660357577293358),
        (0.0, 0.08726646259971647),
    ],
    &[
        (0.9963974885425265, 0.0006106614916245416),
        (0.9856159103477085, 0.0024250783472127076),
        (0.9677329469334989, 0.005391053097329676),
        (0.9428774454610842, 0.009423260048551223),
        (0.9112284903881357, 0.014405699948311418),
        (0.8730141131611882, 0.020195037072199645),
        (0.8285096492438421, 0.02662472273178122),
        (0.7780357543184395, 0.033509786577129184),
        (0.7219560939545244, 0.040652157857017056),
        (0.6606747233900814, 0.04784636355380515),
        (0.5946331763042866, 0.054885439468054166),
        (0.5243072835572317, 0.06156688420172446),
        (0.4502037448176733, 0.06769848475470412),
        (0.37285647778030845, 0.07310384614286096),
        (0.2928227712765502, 0.07762746596057439),
        (0.2106792699957262, 0.08113920790182269),
        (0.12701781974687865, 0.08353804554476858),
        (0.04244120319614824, 0.08475496869797725),
    ],
    &[
        (0.9965844930066698, 0.0005637793294019408),
        (0.9863613034027223, 0.002239738887164704),
        (0.9694002659393304, 0.00498216286545302),
        (0.9458172417006346, 0.008716245087104944),
        (0.9157733266550574, 0.013340129523139677),
        (0.8794737512064891, 0.018727688659709318),
        (0.8371664782625287, 0.024731963927886732),
        (0.7891405093963936, 0.031189174350333512),
        (0.7357239106731317, 0.03792318405941659),
        (0.6772815716257411, 0.044750306824525334),
        (0.6142127126896678, 0.0514843165336084),
        (0.546948158122427, 0.05794152695605518),
        (0.4759473930370736, 0.06394580222423259),
        (0.40169542465296953, 0.06933336136080225),
        (0.32469946920468357, 0.07395724579683698),
        (0.24548548714079924, 0.0776913280184889),
        (0.16459459028073398, 0.08043375199677721),
        (0.0825793454723324, 0.08210971155453999),
        (0.0, 0.08267349088394192),
    ],
    &[
        (0.99675730813421, 0.0005215743559314128),
        (0.9870502626379128, 0.002072788921877429),
        (0.970941817426052, 0.004613468055395556),
        (0.9485364419471455, 0.008077809501485008),
        (0.9199794436588242, 0.01237608863642688),
        (0.8854560256532099, 0.0173969822884083),
        (0.8451900855437947, 0.023010451949197003),
        (0.7994427634035012, 0.02907111170319848),
        (0.7485107481711012, 0.03542199364630214),
        (0.6927243535095995, 0.04189861327214638),
        (0.6324453755953773, 0.04833322953443354),
        (0.5680647467311559, 0.05455918925191873),
        (0.5000000000000001, 0.06041524333826524),
        (0.42869256140305423, 0.06574972306868034),
        (0.3546048870425358, 0.07042446822021951),
        (0.27821746391645275, 0.07431840534898855),
        (0.20002569377604446, 0.07733068352874332),
        (0.12053668025532323, 0.07938328633690513),
        (0.04026594010941524, 0.08042305243892518),
    ],
    &[
        (0.996917333733128, 0.0004834777342476875),
        (0.9876883405951378, 0.001922006110602966),
        (0.9723699203976766, 0.0042801637862380035),
        (0.9510565162951535, 0.007499885092902041),
        (0.9238795325112867, 0.011501889806382627),
        (0.8910065241883679, 0.016187635288741703),
        (0.8526401643540922, 0.02144174293510592),
        (0.8090169943749475, 0.02713483917783825),
        (0.7604059656000309, 0.033126741093139435),
        (f64::consts::FRAC_1_SQRT_2, 0.03926990816987241),
        (0.6494480483301837, 0.0454130752466054),
        (0.5877852522924731, 0.05140497716190658),
        (0.5224985647159489, 0.0570980734046389),
        (0.4539904997395468, 0.06235218105100311),
        (0.38268343236508984, 0.0670379265333622),
        (0.30901699437494745, 0.07103993124684278),
        (0.23344536385590547, 0.07425965255350682),
        (0.15643446504023092, 0.07661781022914187),
        (0.078459095727845, 0.07805633860549714),
        (0.0, 0.07853981633974483),
    ],
    &[
        (0.9970658011837404, 0.00044900164091271605),
        (0.9882804237803485, 0.0017854823457440136),
        (0.9736954238777791, 0.003978116139521165),
        (0.9533963920549305, 0.006975509544508263),
        (0.9275024511020946, 0.010707406199765247),
        (0.8961655569610556, 0.015086333610701832),
        (0.8595696069872011, 0.02000965343021243),
        (0.8179293607667176, 0.02536196721454009),
        (0.771489179821943, 0.031017821264990957),
        (0.7205215936007869, 0.0368446471563021),
        (0.6653257001655652, 0.04270586902816978),
        (0.606225410966638, 0.04846410480765871),
        (0.5435675500012211, 0.05398438632855199),
        (0.4777198185122628, 0.05913732287077358),
        (0.4090686371713398, 0.06380213396920024),
        (0.3380168784085027, 0.06786948040539544),
        (0.26498150219666167, 0.0712440270262177),
        (0.19039110916466842, 0.07384667731900806),
        (0.1146834253984003, 0.0756164273668076),
        (0.03830273369003527, 0.0765117957284665),
    ],
    &[
        (0.9972037971811801, 0.0004177261223548086),
        (0.9888308262251285, 0.001661573178117466),
        (0.9749279121818236, 0.0037037556794576225),
        (0.9555728057861408, 0.006498654643900337),
        (0.9308737486442042, 0.009983836647011472),
        (0.9009688679024191, 0.014081448481931423),
        (0.8660254037844387, 0.01869995627136781),
        (0.8262387743159949, 0.023736190183159003),
        (0.7818314824680299, 0.029077649073841604),
        (0.7330518718298265, 0.0346050135782929),
        (0.6801727377709195, 0.04019481150717833),
        (0.6234898018587336, 0.045722176011629624),
        (0.5633200580636222, 0.05106363490231224),
        (0.5000000000000001, 0.056099868814103435),
        (0.43388373911755834, 0.06071837660353981),
        (0.3653410243663952, 0.06481598843845976),
        (0.2947551744109043, 0.06830117044157091),
        (0.22252093395631467, 0.07109606940601362),
        (0.14904226617617464, 0.07313825190735378),
        (0.0747300935864246, 0.07438209896311644),
        (0.0, 0.07479982508547126),
    ],
    &[
        (0.9973322836635516, 0.0003892883321772589),
        (0.9893433680751103, 0.0015488563237717006),
        (0.9760758775559272, 0.003453989796226715),
        (0.957600599908406, 0.00606408413717482),
        (0.934016108732548, 0.009323509717254574),
        (0.9054482374931466, 0.01316279753907901),
        (0.8720494081438076, 0.017500119848306347),
        (0.8339978178898779, 0.02224303415015848),
        (0.7914964884292541, 0.02729045346070315),
        (0.7447721827437819, 0.032534800800414244),
        (0.6940741952206338, 0.03786430201072061),
        (0.6396730215588913, 0.04316536802613924),
        (0.5818589155579529, 0.04832501582799846),
        (0.5209403404879303, 0.05323327648132529),
        (0.45724232330463843, 0.057785538931771886),
        (0.391104720490156, 0.06188477960861842),
        (0.3228804047714463, 0.06544363031373554),
        (0.2529333823916807, 0.06838624032304311),
        (0.1816368509794365, 0.07064989301300571),
        (0.1093712083778743, 0.07218634255657795),
        (0.03652202305765885, 0.0729628421992458),
    ],
    &[
        (0.9974521146102535, 0.0003633736751249826),
        (0.9898214418809327, 0.001446097460357533),
        (0.9771468659711595, 0.003226130221747879),
        (0.9594929736144974, 0.005667235625464709),
        (0.9369497249997617, 0.008719719805055027),
        (0.9096319953545184, 0.012321442985259832),
        (0.8776789895672557, 0.01639908446864213),
        (0.8412535328311812, 0.020869635233547255),
        (0.8005412409243604, 0.025642087758405544),
        (0.7557495743542583, 0.030619288672427514),
        (f64::consts::FRAC_1_SQRT_2, 0.035699916518065825),
        (0.6548607339452851, 0.040780544363704145),
        (0.599277666511347, 0.04575774527772611),
        (0.5406408174555977, 0.0505301978025844),
        (0.47924898672005684, 0.05500074856748954),
        (0.41541501300188644, 0.05907839005087182),
        (0.3494641795990984, 0.06268011323107664),
        (0.2817325568414298, 0.06573259741066695),
        (0.2125652895529766, 0.06817370281438379),
        (0.14231483827328512, 0.06995373557577413),
        (0.07133918319923235, 0.07103645936100668),
        (0.0, 0.07139983303613166),
    ],
    &[
        (0.9975640502598242, 0.00033970848607470634),
        (0.9902680687415704, 0.0013522219050300566),
        (0.9781476007338057, 0.0030178328348830293),
        (0.9612616959383189, 0.005304122053488386),
        (0.9396926207859084, 0.008166589541821416),
        (0.9135454576426009, 0.011549520626230226),
        (0.882947592858927, 0.015387070401183874),
        (0.848048096156426, 0.019604545325461048),
        (0.8090169943749475, 0.02411985704696733),
        (0.766044443118978, 0.028845120159134544),
        (0.7193398003386512, 0.033688362790391495),
        (0.6691306063588582, 0.0385553167320276),
        (0.6156614753256583, 0.04335125226164696),
        (0.5591929034707468, 0.04798282194946135),
        (0.5000000000000001, 0.052359877559829876),
        (0.43837114678907746, 0.056397224684123726),
        (0.37460659341591196, 0.06001628095298276),
        (0.30901699437494745, 0.06314660555274913),
        (0.24192189559966767, 0.06572727027577989),
        (0.17364817766693041, 0.0677080454187038),
        (0.10452846326765346, 0.06905037744646221),
        (0.03489949670250108, 0.06972813939301485),
    ],
    &[
        (0.9976687691905392, 0.00031805395116741523),
        (0.9906859460363308, 0.0012662910613405979),
        (0.9790840876823229, 0.002827047467290534),
        (0.9629172873477992, 0.004971249230238905),
        (0.9422609221188205, 0.007658953928327514),
        (0.917211301505453, 0.01084009470836356),
        (0.8878852184023752, 0.01445541293656447),
        (0.8544194045464886, 0.018437562074783635),
        (0.8169698930104421, 0.02271236221909156),
        (0.7757112907044199, 0.02720018193103228),
        (0.7308359642781241, 0.03181742162065332),
        (0.6825531432186541, 0.03647807084869001),
        (0.6310879443260529, 0.041095310538311045),
        (0.5766803221148672, 0.045583130250251756),
        (0.5195839500354336, 0.04985793039455969),
        (0.4600650377311522, 0.05384007953277886),
        (0.39840108984624156, 0.05745539776097976),
        (0.3348796121709863, 0.0606365385410158),
        (0.26979677115702444, 0.06332424323910442),
        (0.20345601305263397, 0.06546844500205279),
        (0.1361666490962466, 0.06702920140800273),
        (0.068242413364671, 0.0679774385181759),
        (0.0, 0.06829549246934333),
    ],
    &[
        (0.9977668786231532, 0.0002982010389841569),
        (0.9910774881547801, 0.0011874827513314414),
        (0.9799617050365869, 0.0026519758838175417),
        (0.9644691750543766, 0.004665546521798756),
        (0.9446690916079188, 0.00719226244953794),
        (0.9206498866764288, 0.010187034361445567),
        (0.8925188358598812, 0.013596420481806188),
        (0.8604015792601394, 0.017359580234532115),
        (0.8244415603417603, 0.02140935994468504),
        (0.784799385278661, 0.025673491197396224),
        (0.7416521056479576, 0.03007588046944188),
        (0.6951924276746423, 0.034537967019967815),
        (0.6456278515588024, 0.03898012480877113),
        (0.5931797447293553, 0.04332308342487392),
        (0.5380823531633727, 0.047489342668885264),
        (0.48058175518668383, 0.05140455554589525),
        (0.420934762428335, 0.05499885498936051),
        (0.3594077728375128, 0.05820810064056189),
        (0.29627558088563394, 0.06097502343482525),
        (0.2318201502675282, 0.06325024756933735),
        (0.16632935458313017, 0.06499317161551675),
        (0.10009569162409844, 0.06617269305246874),
        (0.033414977007674644, 0.06676776329220756),
    ],
    &[
        (0.9978589232386035, 0.0002799662568591613),
        (0.9914448613738104, 0.0011150747271604737),
        (0.9807852804032304, 0.0024910364734412726),
        (0.9659258262890683, 0.004384308408734024),
        (0.9469301294951057, 0.006762496125311722),
        (0.9238795325112867, 0.009584908171985521),
        (0.8968727415326884, 0.012803252296116372),
        (0.8660254037844387, 0.016362461737446835),
        (0.8314696123025452, 0.020201637435636462),
        (0.7933533402912353, 0.02425509003006862),
        (0.7518398074789774, 0.02845346382302322),
        (f64::consts::FRAC_1_SQRT_2, 0.03272492347489367),
        (0.659345815100069, 0.036996383126764114),
        (0.6087614290087207, 0.041194756919718724),
        (0.5555702330196024, 0.04524820951415088),
        (0.5000000000000001, 0.049087385212340504),
        (0.44228869021900147, 0.05264659465367097),
        (0.38268343236508984, 0.055864938777801826),
        (0.3214394653031617, 0.05868735082447562),
        (0.25881904510252096, 0.061065538541053316),
        (0.19509032201612833, 0.06295881047634608),
        (0.1305261922200517, 0.06433477222262687),
        (0.06540312923014327, 0.06516988069292819),
        (0.0, 0.06544984694978735),
    ],
    &[
        (0.9979453927503363, 0.0002631880842751405),
        (0.9917900138232462, 0.0010484307960329916),
        (0.9815591569910653, 0.0023428344716556956),
        (0.9672948630390295, 0.004125145038575249),
        (0.9490557470106686, 0.006366097006557468),
        (0.9269167573460217, 0.009028894006242546),
        (0.9009688679024191, 0.012069812984512653),
        (0.8713187041233894, 0.01543892213581533),
        (0.8380881048918407, 0.019080900781030242),
        (0.8014136218679567, 0.022935947731490894),
        (0.7614459583691344, 0.026940763222849256),
        (0.7183493500977276, 0.031029588295456302),
        (0.6723008902613169, 0.035135284554661514),
        (0.6234898018587336, 0.03919043658139683),
        (0.5721166601221697, 0.043128458891494),
        (0.5183925683105252, 0.04688468926749371),
        (0.4625382902408354, 0.050397450510468664),
        (0.404783343122394, 0.053609063177924715),
        (0.3453650544213078, 0.05646679267865208),
        (0.28452758663103267, 0.05892371517325501),
        (0.22252093395631445, 0.0609394880622974),
        (0.15959989503337932, 0.06248101241067022),
        (0.09602302590768189, 0.06352297643119097),
        (0.03205157757165533, 0.06404827110344928),
    ],
    &[
        (0.9980267284282716, 0.000247723964217977),
        (0.9921147013144779, 0.0009869891019730675),
        (0.9822872507286887, 0.002206136760427286),
        (0.9685831611286311, 0.0038859402527232994),
        (0.9510565162951535, 0.005999908074321633),
        (0.9297764858882513, 0.008514701689852518),
        (0.9048270524660195, 0.011390661301734144),
        (0.8763066800438636, 0.014582431308872134),
        (0.8443279255020151, 0.018039675591582947),
        (0.8090169943749475, 0.0217078713422706),
        (0.7705132427757891, 0.025529168922672832),
        (0.7289686274214116, 0.029443304187214164),
        (0.6845471059286886, 0.03338854888458171),
        (0.6374239897486896, 0.037302684149123036),
        (0.587785252292473, 0.04112398172952527),
        (0.5358267949789965, 0.04479217748021292),
        (0.48175367410171516, 0.048249421762923746),
        (0.42577929156507266, 0.051441191770061734),
        (0.36812455268467786, 0.05431715138194336),
        (0.30901699437494745, 0.05683194499747423),
        (0.24868988716485474, 0.05894591281907256),
        (0.18738131458572452, 0.06062571631136859),
        (0.12533323356430426, 0.061844863969822805),
        (0.0627905195293133, 0.0625841291075779),
        (0.0, 0.06283185307179587),
    ],
    &[
        (0.9981033287370441, 0.0002334477562019756),
        (0.9924205096719357, 0.0009302521947874199),
        (0.9829730996839018, 0.0020798504707507126),
        (0.9697969360350095, 0.0036648158460642053),
        (0.9529420004271566, 0.005661121861262892),
        (0.9324722294043558, 0.008038506552078654),
        (0.9084652718195237, 0.01076093118997125),
        (0.8810121942857845, 0.01378712659251709),
        (0.8502171357296142, 0.017071218722147317),
        (0.8161969123562217, 0.02056342408979594),
        (0.7790805745256705, 0.024210804421847514),
        (0.7390089172206591, 0.027958069150402953),
        (0.6961339459629267, 0.03174841356192867),
        (0.6506183002042422, 0.03552437989881031),
        (0.6026346363792565, 0.039228728360388876),
        (0.5523649729605059, 0.04280530479999172),
        (0.5000000000000001, 0.046199891964555775),
        (0.4457383557765383, 0.049361031372917856),
        (0.3897858732926794, 0.05224080337393526),
        (0.3323547994796596, 0.054795553559550535),
        (0.273662990072083, 0.05698655452111867),
        (0.21393308320649754, 0.058780592917445716),
        (0.15339165487868545, 0.060150472955185386),
        (0.09226835946330202, 0.061075428649344364),
        (0.030795058556170325, 0.06154143861444715),
    ],
    &[
        (0.9981755542233175, 0.00022024757278799842),
        (0.992708874098054, 0.0008777785855864031),
        (0.9836199069471436, 0.0019630047555977198),
        (0.970941817426052, 0.0034601010415466686),
        (0.9547208665085456, 0.005347236408416873),
        (0.9350162426854148, 0.007596892173100599),
        (0.9118998459920901, 0.010176263288765156),
        (0.8854560256532099, 0.013047736716306229),
        (0.8557812723014475, 0.016169439907155234),
        (0.8229838658936564, 0.019495851399326202),
        (0.7871834806090501, 0.022978464622836932),
        (0.7485107481711011, 0.02656649523472662),
        (f64::consts::FRAC_1_SQRT_2, 0.03020762166913262),
        (0.6631226582407952, 0.033848748103538634),
        (0.616718872628543, 0.03743677871542833),
        (0.5680647467311558, 0.04091939193893906),
        (0.5173378141776568, 0.04424580343111002),
        (0.4647231720437686, 0.04736750662195903),
        (0.4104128054527567, 0.0502389800495001),
        (0.35460488704253557, 0.05281835116516466),
        (0.297503053855203, 0.05506800692984838),
        (0.23931566428755763, 0.05695514229671859),
        (0.18025503781390564, 0.05845223858266754),
        (0.120536680255323, 0.059537464752678855),
        (0.060378497422286063, 0.06019499576547726),
        (0.0, 0.060415243338265257),
    ],
    &[
        (0.9982437317643215, 0.00020802393585082283),
        (0.9929810960135169, 0.0008291755433380367),
        (0.9842305779475968, 0.0018547352154736371),
        (0.9720229140804107, 0.003270306342515367),
        (0.9564009842765224, 0.005056017408809739),
        (0.9374196611341209, 0.0071868009453129105),
        (0.9151456172430185, 0.009632745421907495),
        (0.8896570909947473, 0.012359515139718521),
        (0.8610436117673556, 0.01532883222906085),
        (0.8294056854502018, 0.01849901398682347),
        (0.7948544414133533, 0.021825558010251482),
        (0.7575112421616201, 0.025261766913130392),
        (0.7175072570443312, 0.02875940385472661),
        (0.6749830015182107, 0.032269369679294835),
        (0.6300878435817111, 0.035742392160598116),
        (0.5829794791144721, 0.03912971767595811),
        (0.5338233779647908, 0.04238379560024827),
        (0.4827922027307451, 0.04545894581243836),
        (0.4300652022765205, 0.04831199994436162),
        (0.3758275821142382, 0.0509029073699776),
        (0.32026985386283774, 0.053195297428369835),
        (0.2635871660690678, 0.05515698998809942),
        (0.2059786187410986, 0.0567604471857109),
        (0.1476465640024815, 0.05798315999697134),
        (0.0887958953229349, 0.05880796421423017),
        (0.02963332782255989, 0.05922328139427023),
    ],
    &[
        (0.9983081582712682, 0.00019668820040846482),
        (0.993238357741943, 0.0007840929311387732),
        (0.984807753012208, 0.0017542705508911472),
        (0.9730448705798238, 0.0030941010716825103),
        (0.9579895123154889, 0.004785465584176827),
        (0.9396926207859084, 0.006805491284851177),
        (0.918216106880274, 0.009126860791425481),
        (0.8936326403234123, 0.011718181563595303),
        (0.8660254037844387, 0.014544410433286074),
        (0.8354878114129365, 0.017567327503385313),
        (0.8021231927550438, 0.020746053006285445),
        (0.7660444431189781, 0.02403760013261212),
        (0.7273736415730488, 0.02739745635407783),
        (0.6862416378687337, 0.030780185379066464),
        (0.6427876096865395, 0.034140041600532176),
        (0.5971585917027863, 0.037431588726858867),
        (0.5495089780708061, 0.04061031422975899),
        (0.5000000000000001, 0.04363323129985823),
        (0.4487991802004623, 0.046459460169549),
        (0.3960797660391569, 0.04905078094171882),
        (0.3420201433256688, 0.05137215044829312),
        (0.2868032327110903, 0.053392176148967484),
        (0.23061587074244025, 0.055083540661461795),
        (0.17364817766693064, 0.05642337118225316),
        (0.11609291412523053, 0.057393548802005534),
        (0.05814482891047612, 0.05798095353273584),
        (0.0, 0.05817764173314431),
    ],
    &[
        (0.9983691039261356, 0.00018616120311953357),
        (0.9934817353485502, 0.0007422179164986034),
        (0.985353835847693, 0.0016609210904991695),
        (0.9740119169423335, 0.0029302940242727058),
        (0.9594929736144974, 0.004533788500371767),
        (0.9418443636395247, 0.00645050051607165),
        (0.9211236531148501, 0.008655442799014463),
        (0.8973984286913584, 0.01111987055451742),
        (0.8707460771197771, 0.01381165619793103),
        (0.8412535328311812, 0.016695708186837802),
        (0.8090169943749475, 0.019734428492973268),
        (0.7741416106390825, 0.022888202750023186),
        (0.7367411378764049, 0.026115916687470774),
        (0.6969375686552935, 0.029375492117989142),
        (0.6548607339452851, 0.03262443549096332),
        (0.6106478796354382, 0.03582039186090806),
        (0.5644432188667693, 0.03892169704895579),
        (0.5163974616389619, 0.041887920799145294),
        (0.4666673232256738, 0.04468039384863827),
        (0.41541501300188644, 0.04726271204069746),
        (0.36280770535064116, 0.049601210908542644),
        (0.30901699437494745, 0.051665404543158384),
        (0.2542183341934871, 0.05342838302374014),
        (0.19859046664574553, 0.05486716322966545),
        (0.14231483827328534, 0.0559629884606193),
        (0.08557500847883984, 0.05670157295886752),
        (0.028556050793696476, 0.05707328814595605),
    ],
    &[
        (0.9984268150178166, 0.0001763721000598543),
        (0.9937122098932426, 0.0007032704187476883),
        (0.9858710185182359, 0.0015740689039924775),
        (0.9749279121818236, 0.002777816759593218),
        (0.9609173219450996, 0.004299376157834956),
        (0.9438833303083676, 0.006119612606455479),
        (0.9238795325112867, 0.00821563557598759),
        (0.9009688679024191, 0.010561086361448572),
        (0.8752234219087537, 0.013126469558349008),
        (0.8467241992282841, 0.015879523984517877),
        (0.8155608689592602, 0.018785628383186714),
        (0.7818314824680298, 0.02180823680538121),
        (0.7456421648831656, 0.024909338196434025),
        (f64::consts::FRAC_1_SQRT_2, 0.028049934407051717),
        (0.6663465779520039, 0.03119053061766942),
        (0.6234898018587336, 0.03429163200872223),
        (0.5786712961798057, 0.03731424043091673),
        (0.5320320765153366, 0.04022034482958557),
        (0.4837188871052398, 0.04297339925575444),
        (0.4338837391175582, 0.04553878245265488),
        (0.38268343236508984, 0.04788423323811586),
        (0.33027906195516715, 0.049980256207647976),
        (0.2768355114248494, 0.05180049265626848),
        (0.22252093395631445, 0.05332205205451023),
        (0.16750622330473647, 0.05452579991011097),
        (0.11196447610330791, 0.05539659839535576),
        (0.056070447237191845, 0.0559234967140436),
        (0.0, 0.05609986881410345),
    ],
    &[
        (0.9984815164333162, 0.00016725736447540182),
        (0.9939306773179495, 0.0006669991800697063),
        (0.9863613034027224, 0.0014931592581098017),
        (0.9757963826274356, 0.0026357091343943823),
        (0.9622680003092504, 0.004080779801164431),
        (0.9458172417006347, 0.00581083005806996),
        (0.9264940672148018, 0.007804859438580325),
        (0.9043571606975775, 0.01003866312719991),
        (0.8794737512064891, 0.012485125773139543),
        (0.8519194088383271, 0.015114550633943642),
        (0.8217778152252452, 0.017895020053715353),
        (0.7891405093963937, 0.02079278290022233),
        (0.7541066097768964, 0.023772664257921572),
        (0.7167825131684513, 0.026798492403784877),
        (0.6772815716257412, 0.02983353788301689),
        (0.6357237482099681, 0.03284095935488127),
        (0.5922352526649801, 0.035784250796670705),
        (0.546948158122427, 0.03862768463737012),
        (0.5000000000000001, 0.041336745441970954),
        (0.4515333583108894, 0.043878548882096385),
        (0.40169542465296953, 0.046222240907201485),
        (0.35063755519275447, 0.04833937227095082),
        (0.29851481100169464, 0.05020424386653064),
        (0.24548548714079946, 0.051794218678992594),
        (0.19171063192373872, 0.05308999656795036),
        (0.13735355781840847, 0.05407584854513924),
        (0.08257934547233262, 0.054739807703026645),
        (0.02755434236816228, 0.05507381447685873),
    ],
    &[
        (0.9985334138511238, 0.00015875992016286603),
        (0.9941379571543596, 0.0006331783657431338),
        (0.9868265225415261, 0.001417693214231296),
        (0.9766205557100867, 0.002503106746317595),
        (0.9635499925192229, 0.003876693480741376),
        (0.9476531711828025, 0.005522349368923848),
        (0.9289767198167914, 0.007420780600213596),
        (0.907575419670957, 0.009549729804175983),
        (0.8835120444460229, 0.01188423699791136),
        (0.8568571761675893, 0.014396932219033468),
        (0.8276889981568906, 0.0170583564134538),
        (0.7960930657056438, 0.019837306815856125),
        (0.7621620551276365, 0.02270120277359085),
        (0.7259954919231308, 0.02561646772503859),
        (0.6876994588534233, 0.02854892285409578),
        (0.6473862847818277, 0.03146418780554352),
        (0.6051742151937651, 0.03432808376327825),
        (0.5611870653623824, 0.03710703416568057),
        (0.5155538571770217, 0.0397684583601009),
        (0.46840844069979015, 0.04228115358122301),
        (0.4198891015602646, 0.044615660774958384),
        (0.37013815533991434, 0.04674460997892077),
        (0.31930153013597995, 0.04864304121021052),
        (0.26752833852922075, 0.050288697098392995),
        (0.214970440211024, 0.05166228383281677),
        (0.16178199655276462, 0.05274769736490307),
        (0.10811901842394187, 0.05353221221339123),
        (0.05413890858541761, 0.054006630658971495),
        (0.0, 0.054165390579134366),
    ],
    &[
        (0.9985826956767619, 0.00015082839017755613),
        (0.9943348002101371, 0.0006016046147815461),
        (0.9872683547213446, 0.0013472211990661666),
        (0.9774033898178667, 0.0023792300091982025),
        (0.9647678688145159, 0.003685937972989061),
        (0.9493976084683813, 0.005252539567074979),
        (0.9313361774523384, 0.007061284569412735),
        (0.9106347728549132, 0.009091679176388),
        (0.8873520750565717, 0.01132071820579923),
        (0.8615540813938061, 0.013723145754764392),
        (0.833313919082515, 0.01627174135919237),
        (0.8027116379309637, 0.01893762841251786),
        (0.7698339834299063, 0.021690601349192273),
        (0.7347741508630673, 0.024499467885810915),
        (0.6976315211349847, 0.027332402442147758),
        (0.6585113790650386, 0.030157306737696312),
        (0.6175246149461919, 0.03294217347801353),
        (0.5747874102144069, 0.03565544901015532),
        (0.5304209081197425, 0.03826639083817263),
        (0.4845508703326502, 0.0407454159478746),
        (0.43730732045885545, 0.04306443599420013),
        (0.38882417547332077, 0.04519717555339096),
        (0.3392388661180304, 0.04711946983404197),
        (0.28869194733962117, 0.04880953847384357),
        (0.237326699871115, 0.050248232319789636),
        (0.18528872408711453, 0.051419250395732696),
        (0.13272552728372197, 0.05230932459895727),
        (0.0797861055530831, 0.05290837003308518),
        (0.026620521437774814, 0.05320959927398136),
    ],
    &[
        (0.9986295347545738, 0.00014341644388857252),
        (0.9945218953682733, 0.0005720944749832265),
        (0.9876883405951378, 0.001281337407068644),
        (0.9781476007338057, 0.002263374626162271),
        (0.9659258262890683, 0.0035074467269872196),
        (0.9510565162951535, 0.0049999233952680265),
        (0.9335804264972017, 0.006724452744306185),
        (0.9135454576426009, 0.008662140469672668),
        (0.8910065241883679, 0.010791756859161134),
        (0.8660254037844387, 0.013089969389957467),
        (0.838670567945424, 0.01553159836464237),
        (0.8090169943749475, 0.0180898927852255),
        (0.7771459614569709, 0.020736823442677393),
        (0.7431448254773944, 0.023443390010809178),
        (f64::consts::FRAC_1_SQRT_2, 0.026179938779914935),
        (0.6691306063588582, 0.028916487549020698),
        (0.6293203910498375, 0.03162305411715247),
        (0.5877852522924731, 0.034269984774604384),
        (0.5446390350150272, 0.0368282791951875),
        (0.5000000000000001, 0.03926990816987241),
        (0.4539904997395468, 0.04156812070066874),
        (0.4067366430758004, 0.04369773709015721),
        (0.3583679495453004, 0.0456354248155237),
        (0.30901699437494745, 0.04735995416456185),
        (0.25881904510252096, 0.04885243083284266),
        (0.20791169081775945, 0.05009650293366761),
        (0.15643446504023092, 0.05107854015276124),
        (0.10452846326765368, 0.051787783084846654),
        (0.052335956242943966, 0.052216461115941304),
        (0.0, 0.05235987755982988),
    ],
    &[
        (0.9986740898848305, 0.00013648222813376367),
        (0.9946998756145891, 0.0005444821669640408),
        (0.9880878960910772, 0.00121967491564075),
        (0.9788556850953578, 0.0021549032630596636),
        (0.9670277247913204, 0.0033402535560806156),
        (0.9526353808033825, 0.004763160786717019),
        (0.9357168190404936, 0.006408541784346324),
        (0.9163169044870048, 0.00825895510107088),
        (0.8944870822287956, 0.010294785895404564),
        (0.8702852410301553, 0.012494453854472135),
        (0.8437755598231856, 0.014834641950694272),
        (0.8150283375168114, 0.01729054360808052),
        (0.7841198065767104, 0.019836125658105882),
        (0.7511319308705199, 0.02244440429777357),
        (0.7161521883143933, 0.02508773112463949),
        (0.6792733388972931, 0.027738086216756257),
        (0.6405931786981751, 0.03036737515081642),
        (0.6002142805483681, 0.0329477268100286),
        (0.5582437220268647, 0.03545178882488892),
        (0.5147928015098308, 0.03785301751510229),
        (0.46997674302731995, 0.04012595925919684),
        (0.42391439070986076, 0.04224652030924355),
        (0.3767278936351851, 0.044192222190578244),
        (0.3285423819108346, 0.04594243997922489),
        (0.2794856348516095, 0.04747862093122073),
        (0.22968774213179552, 0.0487844811463176),
        (0.17928075881073555, 0.04984617818137556),
        (0.12839835514655099, 0.05065245778370375),
        (0.0771754621266463, 0.05119477318893866),
        (0.025747913654988436, 0.05146737571887255),
    ],
    &[
        (0.9987165071710528, 0.0001299878704836065),
        (0.9948693233918952, 0.0005186176304815707),
        (0.9884683243281114, 0.0011619014127562232),
        (0.9795299412524945, 0.002053238255199383),
        (0.9680771188662043, 0.003183481835636122),
        (0.9541392564000488, 0.004541034325467223),
        (0.9377521321470804, 0.006111965399084986),
        (0.9189578116202306, 0.007880155177864697),
        (0.8978045395707417, 0.00982745964193301),
        (0.8743466161445821, 0.011933896812364616),
        (0.8486442574947509, 0.014177851793325966),
        (0.8207634412072763, 0.016536298570156132),
        (0.7907757369376985, 0.018985036287436433),
        (0.7587581226927909, 0.021498937582516007),
        (0.72479278722912, 0.024052206426255354),
        (0.6889669190756866, 0.026618642825192915),
        (0.6513724827222223, 0.029171911668932262),
        (0.6121059825476629, 0.031685812964011836),
        (0.5712682150947923, 0.03413455068129214),
        (0.5289640103269624, 0.03649299745812231),
        (0.485301962531081, 0.038736952439083656),
        (0.4403941515576343, 0.040843389609515265),
        (0.39435585511331855, 0.042790694073583574),
        (0.3473052528448203, 0.04455888385236329),
        (0.299363122973358, 0.04612981492598105),
        (0.25065253225872053, 0.04748736741581215),
        (0.20129852008866012, 0.048617610996248894),
        (0.1514277775045767, 0.04950894783869205),
        (0.10116832198743222, 0.05015223162096671),
        (0.05064916883871277, 0.05054086138096467),
        (0.0, 0.050670849251448276),
    ],
    &[
        (0.9987569212189223, 0.00012389904449279642),
        (0.9950307753654014, 0.0004943648136029921),
        (0.9888308262251285, 0.0011077154520783108),
        (0.9801724878485438, 0.0019578552057140366),
        (0.969077286229078, 0.0030363350036969328),
        (0.9555728057861408, 0.004332436429266891),
        (0.9396926207859084, 0.005833278244158154),
        (0.9214762118704076, 0.007523944408132331),
        (0.9009688679024191, 0.009387632321287616),
        (0.8782215733702285, 0.011405819815845505),
        (0.8532908816321557, 0.013558449237775598),
        (0.8262387743159949, 0.01582412678877267),
        (0.7971325072229225, 0.01818033514743577),
        (0.766044443118978, 0.020603657256524674),
        (0.7330518718298263, 0.023070009052195275),
        (0.6982368180860729, 0.025554878822246295),
        (0.6616858375968595, 0.028033570814527543),
        (0.6234898018587336, 0.030481450674419753),
        (0.58374367223479, 0.032874190272118305),
        (0.5425462638657594, 0.035188009486517055),
        (0.5000000000000001, 0.03739991254273562),
        (0.4562106573531631, 0.0394879165544614),
        (0.4112871031306117, 0.041431269999749956),
        (0.3653410243663952, 0.04321065895897318),
        (0.31848665025168466, 0.04480839906522967),
        (0.27084046814300533, 0.046208611259528014),
        (0.22252093395631445, 0.047397379604009096),
        (0.17364817766693041, 0.048362889584788425),
        (0.12434370464748527, 0.04909554552990315),
        (0.07473009358642439, 0.04958806597541096),
        (0.024930691738073035, 0.049835556031850144),
    ],
    &[
        (0.9987954562051724, 0.00011818458837229014),
        (0.9951847266721969, 0.0004716001712968676),
        (0.989176509964781, 0.001056843163513559),
        (0.9807852804032304, 0.0018682773550809547),
        (0.970031253194544, 0.002898088191159211),
        (0.9569403357322088, 0.004136358030445026),
        (0.9415440651830208, 0.005571161657478932),
        (0.9238795325112867, 0.007188681128989141),
        (0.9039892931234433, 0.008973338848238924),
        (0.881921264348355, 0.01090794758579876),
        (0.8577286100002721, 0.012973876001961229),
        (0.8314696123025452, 0.015151228076727348),
        (0.8032075314806449, 0.01741903471935539),
        (0.773010453362737, 0.019755455712167636),
        (0.7409511253549591, 0.022137990043785666),
        (f64::consts::FRAC_1_SQRT_2, 0.024543692606170252),
        (0.6715589548470183, 0.026949395168554848),
        (0.6343932841636455, 0.029331929500172885),
        (0.5956993044924335, 0.031668350492985116),
        (0.5555702330196023, 0.03393615713561317),
        (0.5141027441932217, 0.03611350921037929),
        (0.4713967368259978, 0.03817943762654175),
        (0.4275550934302822, 0.04011404636410159),
        (0.38268343236508984, 0.041898704083351376),
        (0.33688985339222005, 0.04351622355486159),
        (0.29028467725446233, 0.044951027181895496),
        (0.24298017990326398, 0.046189297021181304),
        (0.19509032201612833, 0.047219107857259565),
        (0.14673047445536175, 0.048030542048826966),
        (0.09801714032956077, 0.04861578504104364),
        (0.049067674327418126, 0.04896920062396823),
        (0.0, 0.04908738521234052),
    ],
    &[
        (0.9988322268323266, 0.00011281616981006702),
        (0.9953316347176486, 0.00045021134505940965),
        (0.9895063994510511, 0.0010090353579028945),
        (0.9813701261394134, 0.0017840706190995154),
        (0.970941817426052, 0.002768080833237335),
        (0.9582458291091662, 0.003951878562074035),
        (0.943311813257743, 0.005324411005172358),
        (0.9261746489577765, 0.0068728631969197825),
        (0.9068743608505454, 0.008582777656409642),
        (0.8854560256532099, 0.010438189373044984),
        (0.8619696668800492, 0.012421774867540996),
        (0.8364701380102267, 0.014515013936583518),
        (0.8090169943749473, 0.01669836257097739),
        (0.7796743540632224, 0.018951435432794456),
        (0.7485107481711011, 0.021253196187781296),
        (0.715598960744121, 0.02358215391594419),
        (0.681015858786797, 0.025916563766478704),
        (0.6448422127361706, 0.028234629983582796),
        (0.6071625078187112, 0.030514709407556226),
        (0.5680647467311558, 0.03273551355115125),
        (0.5276402441061326, 0.034876307364442125),
        (0.485983413242606, 0.03691710283239959),
        (0.44319154559924134, 0.03883884559760163),
        (0.39936458356569543, 0.04062359286563492),
        (0.35460488704253557, 0.04225468093213173),
        (0.3090169943749473, 0.04371688076728788),
        (0.26270737819858686, 0.044996540205210746),
        (0.21578419676780614, 0.0460817114105139),
        (0.1683570413470384, 0.04696226243203682),
        (0.120536680255323, 0.04762997180214308),
        (0.07243480016176218, 0.048078605298348495),
        (0.024163745236132194, 0.04830397415057665),
    ],
    &[
        (0.998867339183008, 0.00010776799075214528),
        (0.9954719225730846, 0.0004300959993960435),
        (0.9898214418809327, 0.0009640649735716887),
        (0.9819286972627067, 0.0017048392075618046),
        (0.9718115683235417, 0.0026457101351916494),
        (0.9594929736144974, 0.003778157083643139),
        (0.9450008187146685, 0.005091924437987351),
        (0.9283679330160726, 0.006575114517621434),
        (0.9096319953545184, 0.008214295323506555),
        (0.8888354486549235, 0.009994622180431194),
        (0.8660254037844387, 0.011899972172688606),
        (0.8412535328311812, 0.013913090155698169),
        (0.8145759520503357, 0.016015745021266705),
        (0.7860530947427875, 0.01818889480132747),
        (0.7557495743542584, 0.02041285911495167),
        (0.7237340381050702, 0.022667497396925723),
        (0.690079011482112, 0.024932391293828716),
        (0.6548607339452851, 0.027187029575802765),
        (0.6181589862206053, 0.02941099388942697),
        (0.5800569095711983, 0.031584143669487724),
        (0.5406408174555977, 0.03368679853505626),
        (0.5000000000000001, 0.035699916518065825),
        (0.45822652172741046, 0.03760526651032325),
        (0.41541501300188644, 0.03938559336724788),
        (0.3716624556603275, 0.041024774173133),
        (0.3270679633174218, 0.04250796425276709),
        (0.2817325568414298, 0.043821731607111294),
        (0.23575893550942728, 0.04495417855556279),
        (0.18925124436041021, 0.04589504948319263),
        (0.14231483827328534, 0.04663582371718275),
        (0.09505604330418281, 0.047169792691358396),
        (0.0475819158237424, 0.04749212070000229),
        (0.0, 0.04759988869075444),
    ],
    &[
        (0.9989008914857115, 0.00010301652686377923),
        (0.9956059820218981, 0.0004111607945129548),
        (0.9901225145346509, 0.0009217248200437273),
        (0.9824625428755761, 0.0016302217484417889),
        (0.972642905324813, 0.002530425283225518),
        (0.9606851875768402, 0.0036144244033633303),
        (0.9466156752904341, 0.004872692885610964),
        (0.9304652963070866, 0.006294173021303871),
        (0.9122695526648967, 0.007866372791898548),
        (0.8920684425573865, 0.009575475649280676),
        (0.8699063724087903, 0.011406461936086732),
        (0.8458320592590974, 0.01334324087899294),
        (0.8198984236734246, 0.015368791995009835),
        (0.7921624734111293, 0.01746531466809872),
        (0.762685178110382, 0.019614384581625503),
        (0.731531335263669, 0.021797115631917708),
        (0.6987694277788417, 0.023994325900022647),
        (0.6644714734388217, 0.026186706223100868),
        (0.6287128665908849, 0.028354989884043502),
        (0.5915722124135223, 0.03048012192807491),
        (0.5531311541251995, 0.032543426618380486),
        (0.5134741935148419, 0.034526771559153215),
        (0.47268850518856526, 0.036412727043740024),
        (0.43086374494097046, 0.03818471922753056),
        (0.3880918526722497, 0.039827175779499596),
        (0.344466850284333, 0.04132566273241188),
        (0.30008463500034066, 0.04266701132904534),
        (0.2550427685616765, 0.04383943374970295),
        (0.20944026276614436, 0.04483262670399612),
        (0.16337736181853021, 0.045637861976531066),
        (0.11695532197208237, 0.046248063130779546),
        (0.070276188945293, 0.04665786769705751),
        (0.023442573603260568, 0.04686367429810149),
    ],
    &[
        (0.9989329748023724, 0.00009854029715462308),
        (0.9957341762950345, 0.00039332047754749917),
        (0.9904104308752052, 0.0008818255806160806),
        (0.9829730996839018, 0.0015598878530630343),
        (0.9734380543606929, 0.002421722306657866),
        (0.961825643172819, 0.0034599760737167736),
        (0.9481606475909659, 0.004665791139177181),
        (0.9324722294043558, 0.006028879914058992),
        (0.914793868488021, 0.007537613005546483),
        (0.8951632913550623, 0.009179118434867389),
        (0.8736223906463696, 0.010939391456477257),
        (0.8502171357296142, 0.012803414041610488),
        (0.8249974745983023, 0.014755283006806596),
        (0.7980172272802395, 0.016778345694264125),
        (0.7693339709828789, 0.018855342046445504),
        (0.7390089172206591, 0.020968551862802214),
        (f64::consts::FRAC_1_SQRT_2, 0.023099945982277888),
        (0.6736956436465572, 0.025231340101753562),
        (0.6388468056519613, 0.027344549918110278),
        (0.6026346363792564, 0.029421546270291657),
        (0.5651364144225919, 0.031444608957749184),
        (0.5264321628773558, 0.03339647792294529),
        (0.48660447856685624, 0.03526050050807853),
        (0.4457383557765383, 0.0370207735296884),
        (0.4039210048718949, 0.038662278959009304),
        (0.36124166618715303, 0.040171012050496786),
        (0.31779141958190166, 0.0415341008253786),
        (0.2736629900720828, 0.042739915890839),
        (0.22895054995013414, 0.04377816965789792),
        (0.1837495178165703, 0.04464000411149275),
        (0.1381563549518823, 0.045318066383939704),
        (0.09226835946330202, 0.04580657148700828),
        (0.04618345864573952, 0.04610135166740116),
        (0.0, 0.04619989196455578),
    ],
    &[
        (0.9989636736467276, 0.00009431965989570349),
        (0.9958568425315313, 0.0003764970771761732),
        (0.9906859460363308, 0.000844194040893732),
        (0.9834617016337421, 0.0014935350667119659),
        (0.9741990826734791, 0.0023191395103894716),
        (0.9629172873477992, 0.003314166153492603),
        (0.9496396989003193, 0.004470369891885962),
        (0.9343938371606711, 0.0057781700572619565),
        (0.917211301505453, 0.007226729805575707),
        (0.8981277053636961, 0.008804045914547707),
        (0.8771826024025943, 0.010497048246143914),
        (0.8544194045464886, 0.012291708049855757),
        (0.8298852919990252, 0.014173154209345009),
        (0.8036311154549782, 0.016125796469197255),
        (0.7757112907044199, 0.018133454620688185),
        (0.7461836858476856, 0.020179492576088837),
        (0.7151095013548994, 0.02224695622052783),
        (0.6825531432186541, 0.024318713899126675),
        (0.648582089462756, 0.026377598375287477),
        (0.6132667502837164, 0.02840654908382202),
        (0.5766803221148672, 0.03038875350016784),
        (0.5388986359155756, 0.03230778645426172),
        (0.5000000000000001, 0.03414774623467166),
        (0.4600650377311522, 0.03589338635518591),
        (0.41917652041666414, 0.037530241891999314),
        (0.3774191957526144, 0.03904474934462758),
        (0.3348796121709863, 0.04042435902734386),
        (0.29164593945482503, 0.04165763905982718),
        (0.24780778599289993, 0.042734370095322896),
        (0.20345601305263397, 0.04364563000136852),
        (0.15868254645625143, 0.04438386779139318),
        (0.11358018605047492, 0.04494296619457036),
        (0.068242413364671, 0.04531829234545061),
        (0.02276319785610566, 0.04550673617334365),
    ],
    &[
        (0.9989930665413147, 0.00009033663150049557),
        (0.9959742939952391, 0.00036061918856221945),
        (0.9909497617679348, 0.0008086715149592806),
        (0.9839295885986297, 0.0014308861568100317),
        (0.9749279121818236, 0.002222253407674574),
        (0.9639628606958532, 0.003176401643765357),
        (0.9510565162951535, 0.004285648624515452),
        (0.9362348706397372, 0.005541063345462523),
        (0.9195277725514507, 0.006932537945445408),
        (0.9009688679024191, 0.008448869089158859),
        (0.880595531856738, 0.010077848169821966),
        (0.8584487936018661, 0.011806359605701422),
        (0.8345732537213026, 0.013620486439063793),
        (0.8090169943749475, 0.01550562238733614),
        (0.7818314824680298, 0.01744658944430497),
        (0.753071466003611, 0.01942776008449772),
        (0.7227948638273916, 0.02143318308682902),
        (0.6910626489868646, 0.023446711964453738),
        (0.6579387259397126, 0.025452134966785035),
        (0.6234898018587336, 0.027433305606977786),
        (0.5877852522924731, 0.029374272663946616),
        (0.5508969814521025, 0.031259408612218965),
        (0.5128992774059061, 0.03307353544558134),
        (0.4738686624729987, 0.03480204688146079),
        (0.4338837391175582, 0.0364310259621239),
        (0.39302503165392366, 0.03794735710583735),
        (0.35137482408134274, 0.03933883170582023),
        (0.30901699437494745, 0.0405942464267673),
        (0.2660368455666752, 0.041703493407517396),
        (0.22252093395631445, 0.04265764164360819),
        (0.1785568947986367, 0.04344900889447273),
        (0.13423326581765554, 0.04407122353632347),
        (0.08963930890343355, 0.044519275862720545),
        (0.044864830350514986, 0.04478955841978226),
        (0.0, 0.04487989505128276),
    ],
    &[
        (0.9990212265199736, 0.00008657472550382442),
        (0.9960868220749448, 0.0003456213374058791),
        (0.9912025308994146, 0.0007751124447396532),
        (0.9843779142227256, 0.0013716866972646945),
        (0.9756263315525068, 0.0021306750925897283),
        (0.96496491452281, 0.0030461375174468384),
        (0.9524145333581313, 0.004110909237131684),
        (0.9379997560189675, 0.0053166569692668815),
        (0.9217488001088784, 0.006653944103035277),
        (0.9036934776372039, 0.00811230455345422),
        (0.8838691327455611, 0.009680324672681016),
        (0.8623145725200277, 0.011345732577282453),
        (0.8390719910244486, 0.013095494192361537),
        (0.8141868867035742, 0.01491591526086579),
        (0.7877079733177184, 0.01679274851971607),
        (0.7596870845832849, 0.01871130520395729),
        (0.7301790727058343, 0.02065657000625996),
        (0.6992417010043142, 0.02261331859205858),
        (0.6669355308366508, 0.024566236750611474),
        (0.633323803048047, 0.026500040249463678),
        (0.5984723141740574, 0.028399594454288985),
        (0.5624492876407806, 0.03025003277792385),
        (0.5253252402142988, 0.03203687303156883),
        (0.48717284396079646, 0.033746130767551605),
        (0.44806678398757854, 0.035364428726590805),
        (0.4080836122434649, 0.03687910153298749),
        (0.3673015976647569, 0.03827829481836231),
        (0.3258005729601175, 0.03955105799816085),
        (0.2836617783342968, 0.04068742997482508),
        (0.24096770245661442, 0.04167851709688753),
        (0.1978019209855174, 0.04251656276385248),
        (0.15424893296530237, 0.04319500813211161),
        (0.11039399541526972, 0.04370854344678809),
        (0.06632295643510404, 0.044053149597767634),
        (0.022122087153186896, 0.04422612957468455),
    ],
    &[
        (0.9990482215818578, 0.00008301880916432956),
        (0.9961946980917455, 0.0003314434133914501),
        (0.9914448613738104, 0.0007433831514403159),
        (0.984807753012208, 0.001315702913168361),
        (0.9762960071199334, 0.002044046999612714),
        (0.9659258262890683, 0.0029228722724893496),
        (0.9537169507482269, 0.0039454903408224695),
        (0.9396926207859084, 0.005104118463638385),
        (0.9238795325112867, 0.0063899387813236815),
        (0.9063077870366499, 0.007793165424861235),
        (0.8870108331782217, 0.009303118992202312),
        (0.8660254037844387, 0.010908307824964558),
        (0.8433914458128857, 0.012596515466891138),
        (0.8191520442889918, 0.014354893638459331),
        (0.7933533402912352, 0.016170060020045753),
        (0.766044443118978, 0.01802820009945909),
        (0.7372773368101241, 0.019915172308719357),
        (f64::consts::FRAC_1_SQRT_2, 0.021816615649929115),
        (0.6755902076156604, 0.02371805899113887),
        (0.6427876096865394, 0.025605031200399142),
        (0.6087614290087207, 0.027463171279812484),
        (0.5735764363510462, 0.029278337661398902),
        (0.5372996083468239, 0.031036715832967104),
        (0.5000000000000001, 0.032724923474893676),
        (0.4617486132350341, 0.03433011230765592),
        (0.42261826174069944, 0.035840065874997),
        (0.38268343236508984, 0.03724329251853455),
        (0.3420201433256688, 0.03852911283621984),
        (0.3007057995042733, 0.03968774095903576),
        (0.25881904510252074, 0.04071035902736889),
        (0.2164396139381029, 0.041589184300245524),
        (0.17364817766693041, 0.042317528386689875),
        (0.1305261922200517, 0.04288984814841792),
        (0.08715574274765836, 0.04330178788646679),
        (0.04361938736533601, 0.043550212490693914),
        (0.0, 0.04363323129985824),
    ],
    &[
        (0.99907411510223, 0.0000796549755500737),
        (0.9962981749346078, 0.0003180301646301459),
        (0.99167731989929, 0.0007133607207404082),
        (0.9852201067560606, 0.0012627197547574116),
        (0.9769384927771817, 0.0019620400045971087),
        (0.9668478136052775, 0.0028061439478003136),
        (0.9549667548552552, 0.003788782134097534),
        (0.9413173175128471, 0.0049026794541522775),
        (0.9259247771938498, 0.006139589001925238),
        (0.9088176373395029, 0.00749035313188128),
        (0.8900275764346767, 0.008944971258992995),
        (0.869589389346611, 0.010492673899573353),
        (0.8475409228928311, 0.012122002404765003),
        (0.8239230057575542, 0.01382089379636739),
        (0.7987793728863649, 0.015576770076906894),
        (0.7721565844991642, 0.01737663135272945),
        (0.7441039398713607, 0.01920715208066493),
        (0.7146733860429609, 0.021054779725686545),
        (0.6839194216246106, 0.022905835099138586),
        (0.6518989958787126, 0.02474661363466331),
        (0.6186714032625035, 0.02656348685201544),
        (0.5842981736283684, 0.028343003257561703),
        (0.5488429582847193, 0.030071987934433435),
        (0.5123714121284235, 0.03173764008500161),
        (0.47495107206705023, 0.03332762780350382),
        (0.43665123195606387, 0.034830179377160014),
        (0.3975428142825559, 0.03623417043981541),
        (0.35769823883312546, 0.03752920633285535),
        (0.317191288589106, 0.03870569906362095),
        (0.27609697309746883, 0.03975493829155222),
        (0.23449138957040977, 0.040669155816502066),
        (0.19245158197082998, 0.04144158309177231),
        (0.1500553983446527, 0.04206650133606539),
        (0.10738134666416309, 0.042539283873340224),
        (0.06450844944931636, 0.042856430387102865),
        (0.021516097436222254, 0.043015592835525224),
    ],
    &[
        (0.9990989662046815, 0.00007647042925183651),
        (0.9963974885425265, 0.0003053307458122708),
        (0.9919004352588768, 0.0006849320058561629),
        (0.9856159103477085, 0.0012125391736063538),
        (0.9775552389476861, 0.0018843508273291125),
        (0.9677329469334989, 0.002695526548664838),
        (0.956166734739251, 0.003640221797953261),
        (0.9428774454610842, 0.0047116300242756115),
        (0.9278890272965093, 0.005902031706809977),
        (0.9112284903881357, 0.007202849974155709),
        (0.8929258581495685, 0.008604712400888396),
        (0.8730141131611882, 0.010097518536099822),
        (0.8515291377333113, 0.011670512677378222),
        (0.8285096492438421, 0.01331236136589061),
        (0.8039971303669405, 0.015011235044213372),
        (0.7780357543184395, 0.016754893288564592),
        (0.7506723052527243, 0.018530773001337885),
        (0.7219560939545244, 0.020326078928508528),
        (0.6919388689775461, 0.02212787584973193),
        (0.6606747233900814, 0.023923181776902575),
        (0.6282199972956423, 0.025699061489675865),
        (0.5946331763042866, 0.027442719734027083),
        (0.5599747861375953, 0.02914159341234985),
        (0.5243072835572317, 0.03078344210086223),
        (0.48769494381363443, 0.032356436242140636),
        (0.4502037448176733, 0.03384924237735206),
        (0.4119012482439926, 0.03525110480408474),
        (0.37285647778030845, 0.03655192307143048),
        (0.3331397947420575, 0.03774232475396485),
        (0.2928227712765502, 0.038813732980287195),
        (0.25197806138512513, 0.03975842822957562),
        (0.2106792699957262, 0.040569603950911345),
        (0.16900082032184885, 0.0412414156046341),
        (0.12701781974687865, 0.04176902277238429),
        (0.084805924475509, 0.04214862403242818),
        (0.04244120319614824, 0.04237748434898862),
        (0.0, 0.04245395477824045),
    ],
    &[
        (0.9991228300988584, 0.0000734533841124171),
        (0.9964928592495044, 0.00029329831373630353),
        (0.9921147013144779, 0.0006579927346487117),
        (0.9859960370705049, 0.0011649785775195208),
        (0.9781476007338057, 0.0018106997009298177),
        (0.9685831611286311, 0.0025906268351488662),
        (0.9573194975320672, 0.0034992893517069934),
        (0.944376370237481, 0.004530313635923659),
        (0.9297764858882513, 0.0056764677932350125),
        (0.9135454576426009, 0.006929712375738136),
        (0.8957117602394129, 0.008281256773141767),
        (0.8763066800438636, 0.009721620872581422),
        (0.8553642601605066, 0.011240701554799715),
        (0.8329212407100994, 0.012827843560268842),
        (0.8090169943749475, 0.0144719142281804),
        (0.7836934573258397, 0.016161381584062138),
        (0.7569950556517564, 0.017884395228293156),
        (0.7289686274214116, 0.019628869458142777),
        (0.6996633405133654, 0.021382568040291604),
        (0.6691306063588582, 0.023133190039216562),
        (0.6374239897486896, 0.02486845609941536),
        (0.6045991148623748, 0.026576194576262646),
        (0.5707135676844317, 0.028244426911351747),
        (0.5358267949789965, 0.02986145165347528),
        (0.4999999999999999, 0.03141592653589794),
        (0.46329603511986156, 0.032896948034208166),
        (0.42577929156507266, 0.03429412784670782),
        (0.38751558645210293, 0.03559766576088451),
        (0.3485720473218151, 0.03679841839486099),
        (0.30901699437494745, 0.03788796333164948),
        (0.2689198206152657, 0.03885865819635541),
        (0.2283508701106557, 0.0397036942619461),
        (0.18738131458572452, 0.04041714420757906),
        (0.14608302856241143, 0.040994003694498724),
        (0.10452846326765346, 0.04143022646787733),
        (0.0627905195293133, 0.04172275273838526),
        (0.02094241988335683, 0.04186953064441473),
    ],
    &[
        (0.999145758387301, 0.00007059297156928),
        (0.9965844930066698, 0.0002818896647009704),
        (0.992320579737045, 0.0006324467087289533),
        (0.9863613034027223, 0.001119869443582352),
        (0.9787168453273545, 0.0017408282777419655),
        (0.9694002659393304, 0.00249108143272651),
        (0.9584274824582527, 0.0033655039187407494),
        (0.9458172417006346, 0.004358122543552472),
        (0.931591088051279, 0.005462156715452168),
        (0.9157733266550574, 0.006670064761569838),
        (0.8983909818919789, 0.007973595445147856),
        (0.8794737512064891, 0.009363844329854659),
        (0.8590539543698852, 0.010831314606113874),
        (0.8371664782625287, 0.012365981963943366),
        (0.813848717270195, 0.013957363069156932),
        (0.7891405093963936, 0.015594587175166756),
        (0.7630840681998066, 0.01726647038120538),
        (0.7357239106731317, 0.018961592029708294),
        (f64::consts::FRAC_1_SQRT_2, 0.020668372720985477),
        (0.6772815716257411, 0.022375153412262667),
        (0.6462992378609409, 0.02407027506076558),
        (0.6142127126896678, 0.0257421582668042),
        (0.5810768154019383, 0.027379382372814023),
        (0.546948158122427, 0.02897076347802759),
        (0.511885049089601, 0.030505430835857085),
        (0.4759473930370736, 0.03197290111211629),
        (0.43919658884737034, 0.0333631499968231),
        (0.40169542465296953, 0.03466668068040112),
        (0.36350797056382983, 0.035874588726518795),
        (0.32469946920468357, 0.03697862289841849),
        (0.28533622424910526, 0.03797124152323021),
        (0.24548548714079924, 0.03884566400924445),
        (0.20521534219563448, 0.03959591716422899),
        (0.16459459028073398, 0.04021687599838861),
        (0.1236926312693478, 0.040704298733242),
        (0.0825793454723324, 0.04105485577726999),
        (0.04132497424881339, 0.04126615247040168),
        (0.0, 0.04133674544197096),
    ],
    &[
        (0.9991677993445829, 0.00006787915838745812),
        (0.9966725824941932, 0.0002710649089500367),
        (0.9925185024910277, 0.0006082050840410309),
        (0.9867124733912889, 0.0010770560714194238),
        (0.9792641587574211, 0.0016744977451191804),
        (0.9701859555740645, 0.0023965542293727655),
        (0.9594929736144974, 0.003238420357408407),
        (0.9472030102919101, 0.004194493649042162),
        (0.9333365210373668, 0.005258411594259194),
        (0.9179165852537593, 0.006423093994668196),
        (0.9009688679024191, 0.00768079008105351),
        (0.8825215767863213, 0.00902313009346549),
        (0.8626054156009807, 0.010441180980592053),
        (0.8412535328311811, 0.011925505847741293),
        (0.8185014665785935, 0.013466226757818696),
        (0.7943870854121126, 0.01505309046736876),
        (0.7689505253393619, 0.016675536660218513),
        (0.7422341230042699, 0.018322768224639303),
        (0.7142823452219036, 0.019983823106344015),
        (0.6851417149678442, 0.02164764725914965),
        (0.654860733945285, 0.023303168207830946),
        (0.6234898018587335, 0.02493936873361617),
        (0.5910811325286764, 0.026545360191960313),
        (0.5576886669868294, 0.02811045497467801),
        (0.523367983696612, 0.02962423763421276),
        (0.4881762060482812, 0.031076634196721905),
        (0.4521719072826856, 0.03245797920271051),
        (0.41541501300188627, 0.033759080029069626),
        (0.37796670142890654, 0.03497127806446633),
        (0.33988930158261665, 0.036086506330973676),
        (0.30124618953723414, 0.037097343168477764),
        (0.2621016829391021, 0.037997061624601335),
        (0.22252093395631423, 0.038779674221461995),
        (0.18256982083936146, 0.03943997280134962),
        (0.1423148382732849, 0.039973563186156656),
        (0.10182298670383533, 0.040376894419908424),
        (0.06116166082184261, 0.040647282399789285),
        (0.02039853739140521, 0.040782927738404),
    ],
    &[
        (0.9991889981715696, 0.000065302672714239),
        (0.99675730813421, 0.0002607871779657064),
        (0.992708874098054, 0.0005851857237242685),
        (0.9870502626379128, 0.0010363944609387144),
        (0.9797906520422677, 0.0016114871278051662),
        (0.970941817426052, 0.002306734027697778),
        (0.9605181116313724, 0.003117626217682556),
        (0.9485364419471455, 0.004038904750742504),
        (0.9350162426854148, 0.005064594782067063),
        (0.9199794436588242, 0.00618804431821344),
        (0.9034504346103823, 0.007401967357836656),
        (0.8854560256532099, 0.00869849114420415),
        (0.8660254037844387, 0.010069207223044207),
        (0.8451900855437947, 0.011505225974598502),
        (0.8229838658936565, 0.012997234266217461),
        (0.7994427634035012, 0.01453555585159924),
        (0.7746049618276546, 0.016110214124960068),
        (0.7485107481711012, 0.01771099682315107),
        (0.7212024473438146, 0.019327522256103638),
        (0.6927243535095995, 0.02094930663607319),
        (0.6631226582407953, 0.02256583206902575),
        (0.6324453755953773, 0.02416661476721677),
        (0.600742264237979, 0.02574127304057758),
        (0.5680647467311559, 0.027279594625959365),
        (0.5344658261278012, 0.028771602917578326),
        (0.5000000000000001, 0.03020762166913262),
        (0.4647231720437686, 0.03157833774797268),
        (0.42869256140305423, 0.03287486153434017),
        (0.3919666098600751, 0.034088784573963395),
        (0.3546048870425358, 0.03521223411010976),
        (0.31666799380147265, 0.03623792414143433),
        (0.27821746391645275, 0.037159202674494275),
        (0.23931566428755782, 0.037970094864479054),
        (0.20002569377604446, 0.03866534176437166),
        (0.16041128085776046, 0.03924043443123811),
        (0.12053668025532323, 0.03969164316845256),
        (0.08046656871672601, 0.04001604171421112),
        (0.04026594010941524, 0.04021152621946259),
        (0.0, 0.04027682889217683),
    ],
    &[
        (0.9992093972273018, 0.00006285493752054551),
        (0.9968388390146958, 0.00025102236092973466),
        (0.9928920737019734, 0.0005633126151923948),
        (0.9873753419363334, 0.0009977513007727943),
        (0.9802973668046362, 0.0015515917564242058),
        (0.9716693400404101, 0.0022213324244656526),
        (0.9615049043274204, 0.0030027389887569674),
        (0.9498201317277827, 0.0038908711454087525),
        (0.9366334982687279, 0.0048801138369742045),
        (0.9219658547282067, 0.0059642127526501765),
        (0.9058403936655233, 0.007136313870043776),
        (0.8882826127491319, 0.008389006788508735),
        (0.8693202744395826, 0.009714371580084213),
        (0.8489833620913639, 0.011104028861829356),
        (0.8273040325430573, 0.012549192772980182),
        (0.8043165652707649, 0.014040726521990095),
        (0.7800573081852121, 0.015569200152267811),
        (0.7545646201582301, 0.01712495016139914),
        (0.7278788103694942, 0.018698140596920567),
        (0.7000420745694255, 0.020278825242377656),
        (0.6710984283590369, 0.021857010500507833),
        (0.6410936375922203, 0.023422718575979915),
        (0.6100751460105245, 0.024966050558228793),
        (0.5780920002248485, 0.02647724900555516),
        (0.5451947721626678, 0.02794675963481353),
        (0.5114354791034222, 0.029365291726666496),
        (0.47686750142850615, 0.030723876864503733),
        (0.44154549821591205, 0.032013925635659336),
        (0.40552532081299403, 0.033227281936444295),
        (0.36886392452400807, 0.03435627453765996),
        (0.33161927855206785, 0.03539376558457901),
        (0.29385027433792105, 0.03633319572476121),
        (0.25561663244047494, 0.037168625578391436),
        (0.21697880810631817, 0.03789477328895118),
        (0.17799789567755048, 0.03850704791681605),
        (0.13873553198906832, 0.03900157846465426),
        (0.09925379890806177, 0.03937523835111807),
        (0.05961512516982015, 0.03962566517809777),
        (0.019882187665070297, 0.03975127566656309),
    ],
    &[
        (0.9992290362407229, 0.00006052801060921389),
        (0.996917333733128, 0.00024173886712384375),
        (0.9930684569549263, 0.0005425153443547523),
        (0.9876883405951378, 0.000961003055301483),
        (0.9807852804032304, 0.0014946218840647637),
        (0.9723699203976766, 0.0021400818931190018),
        (0.9624552364536473, 0.0028934036068711455),
        (0.9510565162951535, 0.0037499425464510203),
        (0.9381913359224842, 0.004704417864468018),
        (0.9238795325112867, 0.005750944903191313),
        (0.9081431738250813, 0.00688307147542162),
        (0.8910065241883679, 0.008093817644370851),
        (0.8724960070727972, 0.00937571875729348),
        (0.8526401643540922, 0.01072087146755296),
        (0.8314696123025452, 0.012120982461381878),
        (0.8090169943749475, 0.013567419588919124),
        (0.785316930880745, 0.015051265084284277),
        (0.7604059656000309, 0.016563370546569717),
        (0.7343225094356856, 0.018094413342774354),
        (f64::consts::FRAC_1_SQRT_2, 0.019634954084936204),
        (0.6788007455329418, 0.02117549482709806),
        (0.6494480483301837, 0.0227065376233027),
        (0.619093949309834, 0.02421864308558814),
        (0.5877852522924731, 0.02570248858095329),
        (0.5555702330196023, 0.027148925708490538),
        (0.5224985647159489, 0.02854903670231945),
        (0.48862124149695496, 0.02989418941257893),
        (0.4539904997395468, 0.031176090525501556),
        (0.41865973753742813, 0.03238683669445079),
        (0.38268343236508984, 0.0335189632666811),
        (0.346117057077493, 0.0345654903054044),
        (0.30901699437494745, 0.03551996562342139),
        (0.2714404498650743, 0.03637650456300127),
        (0.23344536385590547, 0.03712982627675341),
        (0.19509032201612833, 0.03777528628580765),
        (0.15643446504023092, 0.03830890511457093),
        (0.1175373974578377, 0.03872739282551766),
        (0.078459095727845, 0.03902816930274857),
        (0.039259815759068666, 0.039209380159263195),
        (0.0, 0.039269908169872414),
    ],
    &[
        (0.99924795250423, 0.00005831453047022685),
        (0.996992941167792, 0.00023290741143311425),
        (0.993238357741943, 0.0005227286207591821),
        (0.987989849476809, 0.0009260351395939002),
        (0.9812553106273847, 0.0014404014350781708),
        (0.9730448705798238, 0.0020627340477883402),
        (0.9633708786158803, 0.0027892901961651694),
        (0.9522478853384153, 0.003615700286042512),
        (0.9396926207859084, 0.004536994189900787),
        (0.9257239692688904, 0.005547631137798681),
        (0.9103629409661467, 0.0066415330402155295),
        (0.8936326403234123, 0.00781212104239687),
        (0.8755582313020909, 0.009052355090361031),
        (0.8561668995302665, 0.01035477627061214),
        (0.8354878114129365, 0.011711551668923542),
        (0.8135520702629676, 0.013114521478405602),
        (0.7903926695187593, 0.01455524807354448),
        (0.766044443118978, 0.016025066755074747),
        (0.7405440131090046, 0.017515137860500334),
        (0.7139297345578991, 0.01901649992686486),
        (0.6862416378687336, 0.02052012358604431),
        (0.6575213685690636, 0.0220169658684294),
        (0.6278121246720986, 0.023498024588408776),
        (0.5971585917027863, 0.024954392484572575),
        (0.5656068754865388, 0.0263773107890306),
        (0.5332044328016914, 0.027758221903672973),
        (0.5000000000000001, 0.029088820866572152),
        (0.46604351970253893, 0.030361105299001104),
        (0.43138606568125354, 0.03156742353268059),
        (0.3960797660391569, 0.03270052062781255),
        (0.3601777248047105, 0.033753582005141634),
        (0.3237339420583211, 0.03472027442963674),
        (0.2868032327110903, 0.03559478409931166),
        (0.24944114405798137, 0.03637185161011429),
        (0.21170387222941084, 0.037046803586601465),
        (0.17364817766693041, 0.037615580788168776),
        (0.13533129975013117, 0.038074762521801156),
        (0.09681087070317916, 0.03842158721452318),
        (0.0581448289104759, 0.03865396902182389),
        (0.019391331771824435, 0.03877051037217114),
    ],
    &[
        (0.99926618105081, 0.00005620766734959045),
        (0.9970658011837404, 0.00022450082045635803),
        (0.993402089759675, 0.0005038918481790418),
        (0.9882804237803485, 0.0008927411728720068),
        (0.9817083199968549, 0.0013887668720788183),
        (0.9736954238777791, 0.0019890580697605824),
        (0.964253495453141, 0.0026900920184740025),
        (0.9533963920549305, 0.0034877547722541313),
        (0.9411400479795615, 0.004377365328885136),
        (0.9275024511020946, 0.0053537030998826235),
        (0.91250361647655, 0.006411038546982732),
        (0.8961655569610556, 0.007543166805350916),
        (0.8785122509109424, 0.008743444096196063),
        (0.8595696069872011, 0.010004826715106215),
        (0.83936542613195, 0.01131991236730685),
        (0.8179293607667176, 0.012680983607270045),
        (0.7952928712734264, 0.014080053127753497),
        (0.771489179821943, 0.015508910632495479),
        (0.7465532216119626, 0.01695917101749796),
        (0.7205215936007869, 0.01842232357815105),
        (0.6934325007922417, 0.019889781953431798),
        (0.6653257001655652, 0.02135293451408489),
        (0.6362424423265598, 0.02280319489908737),
        (0.606225410966638, 0.024232052403829356),
        (0.5753186602186205, 0.025631121924312803),
        (0.5435675500012211, 0.026992193164275997),
        (0.5110186794471103, 0.028307278816476638),
        (0.4777198185122628, 0.02956866143538679),
        (0.4437198378669597, 0.03076893872623193),
        (0.4090686371713398, 0.03190106698460012),
        (0.3738170718407688, 0.03295840243170022),
        (0.3380168784085027, 0.03393474020269772),
        (0.3017205985951922, 0.034824350759328715),
        (0.26498150219666167, 0.03562201351310885),
        (0.2278535089031375, 0.036323047461822265),
        (0.19039110916466842, 0.03692333865950403),
        (0.15264928421887447, 0.03741936435871084),
        (0.1146834253984003, 0.0378082136834038),
        (0.07654925283649566, 0.03808760471112649),
        (0.03830273369003527, 0.03825589786423325),
        (0.0, 0.038312105531582846),
    ],
    &[
        (0.9992837548163315, 0.000054201078973849275),
        (0.997136045279652, 0.00021649385702344684),
        (0.9935599479631849, 0.0004859487358132457),
        (0.9885605855918885, 0.000861022302199184),
        (0.9821451197042027, 0.0013395661687594048),
        (0.9743227403932134, 0.0019188392795628495),
        (0.9651046531419333, 0.0025955236106894063),
        (0.9545040627715552, 0.0033657431755704454),
        (0.9425361545256727, 0.004225086226288877),
        (0.9292180723175651, 0.005168630523671689),
        (0.9145688941717073, 0.006190971531430194),
        (0.8986096048946821, 0.007286253372854437),
        (0.8813630660146489, 0.008448202372744703),
        (0.8628539830324229, 0.009670162992454913),
        (0.8431088700310844, 0.010945135952215274),
        (0.82215601169481, 0.012265818322372935),
        (0.8000254227913345, 0.013624645353911719),
        (0.7767488051760856, 0.015013833808649395),
        (0.7523595023795813, 0.016425426540921165),
        (0.7268924518431437, 0.017851338075389432),
        (0.7003841348713508, 0.019283400919914314),
        (0.6728725243729189, 0.020713412348209004),
        (0.6443970304648771, 0.022133181384313055),
        (0.6149984440179536, 0.023534575719760965),
        (0.5847188782240471, 0.02490956829470858),
        (0.5536017082694845, 0.026250283276204968),
        (0.5216915092004846, 0.027549041170250338),
        (0.4890339920698333, 0.028798402809242212),
        (0.4556759384562416, 0.029991211962853762),
        (0.421665133450184, 0.031120636328273065),
        (0.3870502972022171, 0.03218020666501489),
        (0.35188101513183306, 0.03316385385014433),
        (0.3162076668968239, 0.03406594364166336),
        (0.2800813542249069, 0.03488130895093879),
        (0.24355382771099193, 0.035605279439318016),
        (0.20667741268495293, 0.03623370826940584),
        (0.16950493425609656, 0.03676299585777362),
        (0.13208964164170223, 0.037190110493047095),
        (0.09448513188803113, 0.037512605701274605),
        (0.05674527309307387, 0.037728634259108385),
        (0.01892412724101908, 0.03783695877453256),
    ],
    &[
        (0.9993007047883986, 0.000052288870437806636),
        (0.9972037971811801, 0.0002088630611774043),
        (0.9937122098932426, 0.00046884694583179204),
        (0.9888308262251285, 0.000830786589058733),
        (0.9825664732332883, 0.00129265787755696),
        (0.9749279121818236, 0.0018518778397288113),
        (0.9659258262890683, 0.0025053190907051567),
        (0.9555728057861408, 0.0032493273219501686),
        (0.9438833303083676, 0.004079741737636984),
        (0.9308737486442042, 0.004991918323505736),
        (0.9165622558699762, 0.005980755818075093),
        (0.9009688679024191, 0.007040724240965712),
        (0.8841153935046099, 0.008165895818793702),
        (0.8660254037844387, 0.009349978135683905),
        (0.8467241992282842, 0.010586349323011912),
        (0.8262387743159949, 0.011868095091579501),
        (0.8045977797666684, 0.01318804739912451),
        (0.7818314824680299, 0.014538824536920802),
        (0.757971723145453, 0.015912872411287787),
        (0.7330518718298265, 0.01730250678914645),
        (f64::consts::FRAC_1_SQRT_2, 0.01869995627136781),
        (0.6801727377709195, 0.020097405753589166),
        (0.6522874112781213, 0.021487040131447838),
        (0.6234898018587336, 0.022861088005814812),
        (0.5938201855735017, 0.02421186514361111),
        (0.5633200580636222, 0.02553181745115612),
        (0.5320320765153368, 0.026813563219723703),
        (0.5000000000000001, 0.028049934407051717),
        (0.46726862827306215, 0.029234016723941915),
        (0.43388373911755834, 0.030359188301769906),
        (0.3998920243197411, 0.03141915672466053),
        (0.3653410243663952, 0.03240799421922988),
        (0.3302790619551673, 0.03332017080509864),
        (0.2947551744109043, 0.03415058522078546),
        (0.25881904510252096, 0.03489459345203046),
        (0.22252093395631467, 0.03554803470300681),
        (0.18591160716291472, 0.03610725466517866),
        (0.14904226617617464, 0.03656912595367689),
        (0.11196447610330813, 0.03693106559690384),
        (0.0747300935864246, 0.03719104948155822),
        (0.037391194276325826, 0.03734762367229782),
        (0.0, 0.03739991254273563),
    ],
    &[
        (0.9993170601430229, 0.000050465557820210296),
        (0.997269173385788, 0.00020158660590404825),
        (0.9938591368952737, 0.0004525377734913639),
        (0.989091608371146, 0.0008019484523275273),
        (0.9829730996839018, 0.0012479102824504275),
        (0.9755119679804366, 0.0017879875749908186),
        (0.9667184042691874, 0.0024192306150603005),
        (0.9566044195004408, 0.003138191772071157),
        (0.9451838281608196, 0.003940944329499089),
        (0.9324722294043558, 0.004823103931247193),
        (0.918486985745923, 0.0057798525274785975),
        (0.9032471993461288, 0.006805964689133906),
        (0.8867736859200619, 0.007895836147412686),
        (0.8690889463055284, 0.009043514402346266),
        (0.8502171357296142, 0.010242731233288392),
        (0.8301840308155507, 0.011486936933762773),
        (0.8090169943749475, 0.012769336083688586),
        (0.7867449380334832, 0.014082924663608512),
        (0.763398282741103, 0.015420528308214214),
        (0.7390089172206591, 0.016774841490241773),
        (0.7136101544117524, 0.018138467420728274),
        (0.6872366859692627, 0.019503958447708115),
        (0.6599245348787226, 0.020863856732705403),
        (0.631711006253251, 0.02221073498286156),
        (0.6026346363792565, 0.023537237016233323),
        (0.5727351400805053, 0.024836117938707613),
        (0.5420533564724495, 0.026100283713100875),
        (0.510631193180907, 0.02732282990433011),
        (0.4785115691012865, 0.028497079389043112),
        (0.4457383557765383, 0.029616618823750714),
        (0.41235631747390344, 0.030675333672284994),
        (0.37841105004231035, 0.031667441601275485),
        (0.3439489186339283, 0.03258752406124885),
        (0.30901699437494745, 0.03343055588086719),
        (0.273662990072083, 0.0341919327126712),
        (0.2379351950426188, 0.034867496180429426),
        (0.2018824091570104, 0.035453556590747164),
        (0.16555387618413, 0.03594691308489236),
        (0.1289992165302034, 0.036344871120776),
        (0.09226835946330202, 0.036645257189606616),
        (0.05541147491597008, 0.03684643068684163),
        (0.018478904959129915, 0.036947292872600374),
    ],
    &[
        (0.9993328483702394, 0.00004872603514213688),
        (0.9973322836635516, 0.00019464416608862945),
        (0.9940009752399459, 0.0004369758564760577),
        (0.9893433680751103, 0.0007744281618858503),
        (0.9833656768294661, 0.0012052006282621797),
        (0.9760758775559272, 0.0017269948981133575),
        (0.9674836970574252, 0.0023370269732434883),
        (0.957600599908406, 0.00303204206858741),
        (0.9464397731576093, 0.003808331977897267),
        (0.934016108732548, 0.004661754858627287),
        (0.9203461835691594, 0.0055877573304558255),
        (0.9054482374931466, 0.006581398769539505),
        (0.889342148882519, 0.007637377668879097),
        (0.8720494081438076, 0.008750059924153173),
        (0.8535930890373464, 0.009913508894102398),
        (0.8339978178898779, 0.01112151707507924),
        (0.8132897407355654, 0.012367639220765805),
        (0.7914964884292541, 0.013645226730351574),
        (0.768647139778532, 0.014947463121695419),
        (0.7447721827437819, 0.016267400400207122),
        (0.7199034737579959, 0.017597996129404738),
        (0.6940741952206338, 0.018932151005360304),
        (0.6673188112222395, 0.02026274673455792),
        (0.6396730215588913, 0.02158268401306962),
        (0.6111737140978493, 0.022884920404413464),
        (0.5818589155579529, 0.02416250791399923),
        (0.5517677407704459, 0.025408630059685793),
        (0.5209403404879303, 0.026616638240662644),
        (0.48941784781108555, 0.027780087210611863),
        (0.45724232330463843, 0.028892769465885943),
        (0.424456698875815, 0.02994874836522553),
        (0.391104720490156, 0.03094238980430921),
        (0.3572308898011328, 0.031868392276137754),
        (0.3228804047714463, 0.03272181515686777),
        (0.2880990993652375, 0.033498105066177626),
        (0.2529333823916807, 0.034193120161521554),
        (0.21743017558155697, 0.03480315223665168),
        (0.1816368509794365, 0.035324946506502856),
        (0.14560116773500476, 0.03575571897287919),
        (0.1093712083778743, 0.036093171278288975),
        (0.07299531466090749, 0.03633550296867641),
        (0.03652202305765885, 0.0364814210996229),
        (0.0, 0.03653014713476504),
    ],
    &[
        (0.999348095389677, 0.00004706554432654166),
        (0.9973932315179498, 0.00018801679935108478),
        (0.9941379571543596, 0.00042211891049542236),
        (0.9895865165556373, 0.0007481513777497299),
        (0.9837448439320028, 0.0011644144187944797),
        (0.9766205557100867, 0.0016687378308783962),
        (0.9682229406025633, 0.0022584923052507196),
        (0.9585629474974413, 0.0029306031351595653),
        (0.9476531711828025, 0.0036815662459492304),
        (0.935507835925601, 0.004507466463682941),
        (0.9221427769259332, 0.005403997927046877),
        (0.9075754196709571, 0.006366486536117319),
        (0.8918247572153823, 0.007389914320953351),
        (0.8749113254181496, 0.008468945602968639),
        (0.8568571761675893, 0.009597954812688977),
        (0.8376858486299648, 0.010771055818866681),
        (0.8174223385588919, 0.011982132616043419),
        (0.7960930657056438, 0.013224871210570744),
        (0.7737258393728362, 0.014492792538849377),
        (0.7503498221564024, 0.015779286246166768),
        (0.7259954919231308, 0.017077645150025723),
        (0.7006946020733426, 0.018381100208288318),
        (0.674480140140514, 0.01968285580982725),
        (0.6473862847818277, 0.020976125203695673),
        (0.619448361215723, 0.02225416588210412),
        (0.5907027951645512, 0.023510314732734072),
        (0.5611870653623824, 0.024738022777120377),
        (0.5309396546898868, 0.025930889313992483),
        (0.5000000000000001, 0.027082695289567176),
        (0.46840844069979015, 0.028187435720815338),
        (0.4362061661555676, 0.029239351002662894),
        (0.40343516198980856, 0.03023295693590486),
        (0.37013815533991434, 0.03116307331928051),
        (0.33635855915017526, 0.03202485095664421),
        (0.3021404155695727, 0.032813796938428716),
        (0.267528338529221, 0.033525798065595316),
        (0.2325674555743105, 0.034157142293949075),
        (0.19730334902640004, 0.034704538087018365),
        (0.16178199655276485, 0.035165131576602046),
        (0.1260497112202894, 0.03553652144151674),
        (0.0901530811120654, 0.03581677142697362),
        (0.05413890858541761, 0.03600442043931433),
        (0.018054149250560435, 0.03609849016347675),
    ],
    &[
        (0.9993628256569916, 0.000045479647855774096),
        (0.9974521146102535, 0.0001816868375624913),
        (0.9942703017718973, 0.0004079274885028872),
        (0.9898214418809327, 0.0007230487301787665),
        (0.9841112043361161, 0.0011254447769747998),
        (0.9771468659711595, 0.0016130651108739395),
        (0.9689373017815074, 0.002183424930427217),
        (0.9594929736144974, 0.0028336178127323546),
        (0.9488259168373196, 0.0035603305238986692),
        (0.9369497249997617, 0.0043598599025275134),
        (0.9238795325112867, 0.005228131730173921),
        (0.9096319953545184, 0.006160721492629916),
        (0.8942252698597113, 0.007152876926234725),
        (0.8776789895672557, 0.008199542234321065),
        (0.8600142402077006, 0.00929538385039608),
        (0.8412535328311812, 0.010434817616773628),
        (0.8214207751204916, 0.011612037240161825),
        (0.8005412409243604, 0.012821043879202772),
        (0.7786415380497551, 0.014055676713193037),
        (0.7557495743542583, 0.015309644336213757),
        (0.7318945221817255, 0.016576556816693115),
        (f64::consts::FRAC_1_SQRT_2, 0.017849958259032912),
        (0.6814179395938912, 0.01912335970137271),
        (0.6548607339452851, 0.020390272181852073),
        (0.627469007380852, 0.021644239804872796),
        (0.599277666511347, 0.022878872638863054),
        (0.5703226369349641, 0.024087879277903998),
        (0.5406408174555977, 0.0252650989012922),
        (0.5102700330608996, 0.02640453266766975),
        (0.47924898672005684, 0.02750037428374477),
        (0.44761721006271254, 0.028547039591831108),
        (0.41541501300188644, 0.02953919502543591),
        (0.38268343236508984, 0.03047178478789191),
        (0.3494641795990984, 0.03134005661553832),
        (0.315799587615025, 0.032139585994167164),
        (0.2817325568414298, 0.032866298705333474),
        (0.24730650055421563, 0.033516491587638614),
        (0.2125652895529766, 0.03408685140719189),
        (0.1775531962543032, 0.03457447174109103),
        (0.14231483827328512, 0.03497686778788706),
        (0.10689512156511279, 0.035291989029562945),
        (0.07133918319923235, 0.03551822968050334),
        (0.035692333838980496, 0.035654436870210054),
        (0.0, 0.03569991651806583),
    ],
    &[
        (0.9993770622619782, 0.00004396420385751299),
        (0.9975090251507638, 0.0001756377879779004),
        (0.994398216007982, 0.0003943647611884569),
        (0.9900485105144543, 0.0006990554367109484),
        (0.9844653278615834, 0.0010881918609263286),
        (0.9776556239997144, 0.001559835375743312),
        (0.9696278829718882, 0.0021116362768954715),
        (0.9603921063437793, 0.002740845520049693),
        (0.9499598007429908, 0.00344432841640677),
        (0.9383439635232295, 0.0042185802495633175),
        (0.9255590665712211, 0.005059743735832595),
        (0.9116210382765418, 0.00596362824103782),
        (0.8965472436868285, 0.006925730658040833),
        (0.8803564628730913, 0.007941257840995343),
        (0.8630688675320841, 0.009005150484558444),
        (0.844705995854882, 0.010112108329095326),
        (0.8252907256929775, 0.011256616566306173),
        (0.8048472460553258, 0.012432973313723722),
        (0.7834010269718525, 0.013635318021204879),
        (0.7609787877609677, 0.01485766066789674),
        (0.7376084637406223, 0.016093911604219194),
        (0.7133191714243803, 0.017337911890192795),
        (0.6881411722458688, 0.018583463978967943),
        (0.6621058348568005, 0.01982436259269152),
        (0.6352455960455385, 0.021054425636889057),
        (0.607593920324899, 0.022267524999348413),
        (0.5791852582395335, 0.023457617080066565),
        (0.5500550034448414, 0.02461877290016082),
        (0.5202394486108822, 0.02574520763974339),
        (0.4897757402062284, 0.02683130945760306),
        (0.4587018322180907, 0.027871667449115834),
        (0.427056438866376, 0.02886109860309959),
        (0.39487898637059127, 0.029794673623315074),
        (0.3622095638296826, 0.030667741485971827),
        (0.32908887327601, 0.03147595261089474),
        (0.29555817896568415, 0.0322152805309137),
        (0.2616592559684407, 0.03288204195152051),
        (0.22743433812110633, 0.03347291510085681),
        (0.19292606540949692, 0.03398495627861443),
        (0.15817743084430402, 0.03441561452140223),
        (0.12323172689715887, 0.034762744311517414),
        (0.08813249156360183, 0.035024616265806795),
        (0.05292345412016307, 0.035199925751366656),
        (0.017648480643128704, 0.035287799385158275),
    ],
    &[
        (0.9993908270190958, 0.000042515343379167265),
        (0.9975640502598242, 0.00016985424303735317),
        (0.9945218953682733, 0.00038139631665548443),
        (0.9902680687415704, 0.0006761109525150283),
        (0.984807753012208, 0.0010525623305346888),
        (0.9781476007338057, 0.0015089164174415146),
        (0.9702957262759965, 0.0020429499019966476),
        (0.9612616959383189, 0.002652061026744193),
        (0.9510565162951535, 0.003333282263512018),
        (0.9396926207859084, 0.004083294770910708),
        (0.9271838545667874, 0.004898444563395211),
        (0.9135454576426009, 0.005774760313115113),
        (0.898794046299167, 0.00670797269782473),
        (0.882947592858927, 0.007693535200591937),
        (0.8660254037844387, 0.008726646259971646),
        (0.848048096156426, 0.009802272662730524),
        (0.8290375725550416, 0.010915174065155922),
        (0.8090169943749475, 0.012059928523483665),
        (0.7880107536067219, 0.013230958909063112),
        (0.766044443118978, 0.014422560079567272),
        (0.7431448254773942, 0.015628926673872792),
        (0.7193398003386512, 0.016844181395195747),
        (0.6946583704589973, 0.018062403644690837),
        (0.6691306063588582, 0.0192776583660138),
        (0.6427876096865394, 0.020484024960319314),
        (0.6156614753256583, 0.02167562613082348),
        (0.5877852522924731, 0.022846656516402924),
        (0.5591929034707468, 0.023991410974730676),
        (0.5299192642332049, 0.025104312377156063),
        (0.5000000000000001, 0.026179938779914938),
        (0.46947156278589086, 0.02721304983929465),
        (0.43837114678907746, 0.028198612342061863),
        (0.4067366430758002, 0.029131824726771473),
        (0.37460659341591196, 0.03000814047649138),
        (0.3420201433256688, 0.030823290268975876),
        (0.30901699437494745, 0.031573302776374566),
        (0.27563735581699916, 0.0322545240131424),
        (0.24192189559966767, 0.032863635137889945),
        (0.20791169081775945, 0.03339766862244507),
        (0.17364817766693041, 0.0338540227093519),
        (0.13917310096006547, 0.034230474087371565),
        (0.10452846326765346, 0.034525188723231105),
        (0.06975647374412523, 0.03473673079684923),
        (0.03489949670250108, 0.034864069696507426),
        (0.0, 0.03490658503988659),
    ],
    &[
        (0.9994041405510704, 0.000041129449636843294),
        (0.9976172723012476, 0.00016432179798960488),
        (0.9946415246951927, 0.00036898997741689564),
        (0.9904804439875632, 0.0006541586508383666),
        (0.9851389890168738, 0.0010184688596600621),
        (0.9786235252959553, 0.001460184499830986),
        (0.970941817426052, 0.0019772005951695245),
        (0.9621030198436006, 0.0025670533285335495),
        (0.9521176659107141, 0.0032269317830311167),
        (0.9409976553623765, 0.003953691337319548),
        (0.9287562401253023, 0.004743868651158166),
        (0.9154080085253664, 0.005593698169801754),
        (0.9009688679024191, 0.0064991300685837364),
        (0.8854560256532099, 0.007455849552174986),
        (0.8688879687250066, 0.008459297416548526),
        (0.8512844415843512, 0.009504691775662964),
        (0.8326664226872064, 0.010587050849327137),
        (0.8130560994785325, 0.011701216703651408),
        (0.7924768419510905, 0.01284187983095158),
        (0.7709531747949796, 0.01400360445197092),
        (0.7485107481711012, 0.015180854419843777),
        (0.7251763071433766, 0.016368019602356548),
        (0.7009776598061495, 0.017559442616782488),
        (0.6759436441447544, 0.018749445789886788),
        (0.6501040936687443, 0.01993235821462514),
        (0.6234898018587336, 0.021102542774598294),
        (0.5961324854692254, 0.022254423007478853),
        (0.5680647467311559, 0.023382509679393742),
        (0.5393200344991993, 0.024481426943623444),
        (0.509932604390136, 0.02554593795895973),
        (0.4799374779597864, 0.02657096984563885),
        (0.44937040096716135, 0.027551637859923817),
        (0.4182678007755652, 0.028483268672132807),
        (0.38666674294141884, 0.029361422637183287),
        (0.35460488704253557, 0.03018191495152266),
        (0.32212044179849075, 0.030940835595622954),
        (0.28925211953656776, 0.031634567967004465),
        (0.2560390900575472, 0.03225980611499358),
        (0.22252093395631445, 0.03281357049508322),
        (0.1887375954529167, 0.03329322216781934),
        (0.15472933479028123, 0.033696475374549194),
        (0.12053668025532323, 0.0340214084301022),
        (0.08620037988061954, 0.03426647288049494),
        (0.051761352884209494, 0.034430500882019564),
        (0.017260640905388574, 0.03451271076655086),
    ],
    &[
        (0.999417022366174, 0.00003980313904795784),
        (0.9976687691905392, 0.00015902697558370761),
        (0.9947572788580948, 0.0003571156330453408),
        (0.9906859460363308, 0.0006331455306702989),
        (0.9854595177171969, 0.0009858296896552306),
        (0.9790840876823229, 0.001413523733645267),
        (0.9715670893979415, 0.0019142335555756638),
        (0.9629172873477992, 0.0024856246151194524),
        (0.9531447668141608, 0.0031250328233921147),
        (0.9422609221188205, 0.003829476964163757),
        (0.9302784433378332, 0.0045956725936653585),
        (0.917211301505453, 0.00542004735418178),
        (0.9030747323245327, 0.006298757630032506),
        (0.8878852184023752, 0.007227706468282235),
        (0.8716604700327513, 0.008202562680626678),
        (0.8544194045464886, 0.009218781037391818),
        (0.836182124254711, 0.010271623459492793),
        (0.8169698930104421, 0.01135618110954578),
        (0.7968051114159046, 0.012467397279133905),
        (0.7757112907044199, 0.01360009096551614),
        (0.7537130253273611, 0.014748981027853726),
        (0.7308359642781241, 0.01590871081032666),
        (f64::consts::FRAC_1_SQRT_2, 0.01707387311733583),
        (0.6825531432186541, 0.018239035424345004),
        (0.6572036788179725, 0.019398765206817936),
        (0.6310879443260529, 0.020547655269155522),
        (0.6042363895210946, 0.02168034895553775),
        (0.5766803221148672, 0.022791565125125878),
        (0.5484518712493187, 0.02387612277517887),
        (0.5195839500354336, 0.024928965197279846),
        (0.49011021717801734, 0.02594518355404498),
        (0.4600650377311522, 0.02692003976638943),
        (0.42948344303008185, 0.027848988604639156),
        (0.39840108984624156, 0.02872769888048988),
        (0.3668542188130565, 0.029552073641006305),
        (0.3348796121709863, 0.0303182692705079),
        (0.3025145508810758, 0.03102271341127955),
        (0.26979677115702444, 0.03166212161955221),
        (0.2367644204664468, 0.032233512679096),
        (0.20345601305263397, 0.032734222501026394),
        (0.16991038502866676, 0.033161916545016434),
        (0.1361666490962466, 0.03351460070400136),
        (0.10226414894203437, 0.03379063060162633),
        (0.068242413364671, 0.03398871925908795),
        (0.03414111018596805, 0.034107943095623705),
        (0.0, 0.034147746234671664),
    ],
    &[
        (0.999429490929718, 0.00003853324387686782),
        (0.9977186146800707, 0.0001539571571536514),
        (0.9948693233918952, 0.0003457450869877138),
        (0.9908848681582388, 0.0006130219490437291),
        (0.9857697953148038, 0.0009545682203027944),
        (0.9795299412524945, 0.0013688255034662554),
        (0.9721724257579907, 0.001853903637565147),
        (0.9637056438899408, 0.002407589322331165),
        (0.9541392564000488, 0.0030273562169781487),
        (0.9434841787099802, 0.003710376467315647),
        (0.9317525684566684, 0.0044535336085989915),
        (0.9189578116202306, 0.005253436785243132),
        (0.9051145072503212, 0.006106436222518948),
        (0.8902384508083516, 0.007008639879638222),
        (0.8743466161445821, 0.007955931208243078),
        (0.857457136130651, 0.008943987935271961),
        (0.8395892819696389, 0.009968301784500271),
        (0.8207634412072763, 0.011024199046770756),
        (0.8010010944693846, 0.012106861905056405),
        (0.7803247909520918, 0.013211350417054585),
        (0.7587581226927909, 0.014332625055010671),
        (0.7363256976511974, 0.015465569699927394),
        (0.7130531116312203, 0.016605014985242344),
        (0.6889669190756866, 0.01774576188346194),
        (0.6640946027672391, 0.018882605428131506),
        (0.6384645424699835, 0.020010358462903288),
        (0.6121059825476629, 0.021123875309341223),
        (0.5850489985953077, 0.022218075245471397),
        (0.5573244631224364, 0.023287965687951113),
        (0.5289640103269624, 0.02432866497208154),
        (0.5000000000000001, 0.025335424625724134),
        (0.4704654806027556, 0.026303651035489865),
        (0.4403941515576343, 0.02722892640634351),
        (0.40982032479658764, 0.02810702891898915),
        (0.3787788856105761, 0.028933951993063315),
        (0.3473052528448203, 0.029705922568242192),
        (0.3154353384852556, 0.03041941831985051),
        (0.28320550668230415, 0.031071183730421184),
        (0.25065253225872053, 0.03165824494387477),
        (0.2178135587488515, 0.03217792333454273),
        (0.18472605601718942, 0.032627847729121945),
        (0.1514277775045767, 0.0330059652257947),
        (0.11795671715084598, 0.03331055056114873),
        (0.08435106604304499, 0.03354021398215857),
        (0.05064916883871277, 0.03369390758730978),
        (0.016889480013931084, 0.033770930107933236),
    ],
    &[
        (0.9994415637302546, 0.00003731679634083168),
        (0.9977668786231532, 0.00014910051949207844),
        (0.994977815088504, 0.0003348519162102351),
        (0.9910774881547801, 0.0005937413756657207),
        (0.9860702539900286, 0.0009246126346862348),
        (0.9799617050365869, 0.0013259879419087709),
        (0.9727586637650372, 0.001796074657775935),
        (0.9644691750543766, 0.002332773260899378),
        (0.9551024972069124, 0.0029336867250319833),
        (0.9446690916079188, 0.00359613122476897),
        (0.9331806110416025, 0.004317148122163662),
        (0.9206498866764288, 0.005093517180722784),
        (0.9070909137343407, 0.005921770947764352),
        (0.8925188358598812, 0.006798210240903094),
        (0.8769499282066715, 0.007718920669496984),
        (0.8604015792601394, 0.008679790117266058),
        (0.842892271416797, 0.009676527108001976),
        (0.8244415603417603, 0.01070467997234252),
        (0.8050700531275629, 0.011759656730007643),
        (0.784799385278661, 0.012836745598698112),
        (0.7636521965473321, 0.013931136038059039),
        (0.7416521056479576, 0.01503794023472094),
        (0.7188236838779294, 0.016152214932460697),
        (0.6951924276746423, 0.017268983509983907),
        (0.6707847301392235, 0.01838325820772367),
        (0.6456278515588024, 0.019490062404385566),
        (0.6197498889602449, 0.0205844528437465),
        (0.5931797447293553, 0.02166154171243696),
        (0.5659470943305952, 0.022716518470102087),
        (0.5380823531633727, 0.023744671334442632),
        (0.5096166425919175, 0.02474140832517855),
        (0.48058175518668383, 0.025702277772947625),
        (0.45101011921610185, 0.026622988201541513),
        (0.420934762428335, 0.027499427494680255),
        (0.3903892751634948, 0.028327681261721825),
        (0.3594077728375128, 0.029104050320280943),
        (0.3280248578395691, 0.029825067217675638),
        (0.29627558088563394, 0.030487511717412624),
        (0.26419540187128593, 0.03108842518154523),
        (0.2318201502675282, 0.031625123784668675),
        (0.19918598510383623, 0.032095210500535834),
        (0.16632935458313017, 0.032496585807758376),
        (0.13328695537377896, 0.032827457066778885),
        (0.10009569162409844, 0.03308634652623437),
        (0.06679263374512164, 0.03327209792295253),
        (0.033414977007674644, 0.03338388164610378),
        (0.0, 0.03342119844244461),
    ],
    &[
        (0.999453257340926, 0.00003615101403950796),
        (0.9978136272187745, 0.00014444597697181247),
        (0.9950829025450114, 0.0003244113424783155),
        (0.9912640693269752, 0.0005752601678056037),
        (0.9863613034027224, 0.0008958955548658811),
        (0.9803799658748094, 0.0012849154466932152),
        (0.9733265972480059, 0.001740618758281913),
        (0.9652089102773487, 0.0022610128149984305),
        (0.9560357815343576, 0.002843822066040535),
        (0.9458172417006347, 0.003486498034841976),
        (0.9345644645994609, 0.004186230462912086),
        (0.9222897549773847, 0.0049399595983811145),
        (0.9090065350491625, 0.005744389575516652),
        (0.8947293298207635, 0.0065960028267058775),
        (0.8794737512064891, 0.007491075463883726),
        (0.8632564809575739, 0.008425693562147908),
        (0.8460952524209355, 0.009395770274356651),
        (0.8280088311480202, 0.01039706370187141),
        (0.8090169943749475, 0.01142519544330031),
        (0.7891405093963937, 0.012475669740133399),
        (0.768401110856859, 0.013543893135550733),
        (0.7468214769841539, 0.0146251945604403),
        (0.724425204791089, 0.015714845758794727),
        (0.7012367842724887, 0.01680808196317181),
        (0.6772815716257412, 0.017900122729810133),
        (0.6525857615241687, 0.01898619284229337),
        (0.6271763584735371, 0.020061543192356642),
        (0.6010811472830252, 0.021121471546528645),
        (0.5743286626829437, 0.022161343107802146),
        (0.546948158122427, 0.023176610782422072),
        (0.5189695737812153, 0.02416283506316952),
        (0.49042350383050826, 0.02511570344219728),
        (0.4613411629786878, 0.02603104926852936),
        (0.43175435233849313, 0.02690486996776555),
        (0.40169542465296953, 0.027733344544320894),
        (0.371197248918221, 0.028512850289667144),
        (0.34029317444164314, 0.029239978623515458),
        (0.3090169943749477, 0.029911549998670642),
        (0.27740290876184476, 0.03052462780438213),
        (0.24548548714079946, 0.031076531207395557),
        (0.21329963074374705, 0.0315648468745545),
        (0.18088053433211, 0.0319874395256923),
        (0.1482636477118422, 0.032342461270668976),
        (0.11548463696958625, 0.03262835968972462),
        (0.08257934547233262, 0.03284388462181599),
        (0.0495837546732225, 0.03298809363125267),
        (0.01653394476635879, 0.03306035612872861),
    ],
    &[
        (0.9994645874763657, 0.000035033286585286706),
        (0.9978589232386035, 0.00013998312842958065),
        (0.9951847266721969, 0.0003144001141979117),
        (0.9914448613738104, 0.0005575373635802369),
        (0.986643332084879, 0.0008683537255475917),
        (0.9807852804032304, 0.0012455182367206363),
        (0.9738769792773336, 0.001687415820759178),
        (0.9659258262890683, 0.002192154204367012),
        (0.9569403357322088, 0.002757572020296684),
        (0.9469301294951057, 0.003381248062655861),
        (0.9359059267573258, 0.004060511654882673),
        (0.9238795325112867, 0.0047924540859927605),
        (0.9108638249211758, 0.005573941066126261),
        (0.8968727415326884, 0.006401626148058186),
        (0.881921264348355, 0.007271965057199171),
        (0.8660254037844387, 0.008181230868723417),
        (0.8492021815265789, 0.009125529966832947),
        (0.8314696123025452, 0.010100818717818231),
        (0.8128466845916152, 0.011102920785518486),
        (0.7933533402912353, 0.01212754501503431),
        (0.773010453362737, 0.013170303808111756),
        (0.7518398074789774, 0.01422673191151161),
        (0.7298640726978357, 0.01529230553790933),
        (f64::consts::FRAC_1_SQRT_2, 0.016362461737446835),
        (0.6835923020228714, 0.017432617936984342),
        (0.659345815100069, 0.018498191563382057),
        (0.6343932841636456, 0.019554619666781913),
        (0.6087614290087207, 0.020597378459859362),
        (0.5824776968678023, 0.021622002689375187),
        (0.5555702330196024, 0.02262410475707544),
        (0.5280678506503681, 0.023599393508060725),
        (0.5000000000000001, 0.024543692606170252),
        (0.4713967368259978, 0.0254529584176945),
        (0.44228869021900147, 0.026323297326835485),
        (0.41270702980439494, 0.027150982408767406),
        (0.38268343236508984, 0.027932469388900913),
        (0.3522500479212336, 0.028664411820010997),
        (0.3214394653031617, 0.02934367541223781),
        (0.2902846772544625, 0.029967351454596988),
        (0.25881904510252096, 0.030532769270526658),
        (0.22707626303437345, 0.031037507654134495),
        (0.19509032201612833, 0.03147940523817304),
        (0.16289547339458882, 0.03185656974934608),
        (0.1305261922200517, 0.03216738611131344),
        (0.09801714032956077, 0.03241052336069576),
        (0.06540312923014327, 0.03258494034646409),
        (0.03271908282177639, 0.032689890188308396),
        (0.0, 0.032724923474893676),
    ],
    &[
        (0.9994755690455149, 0.00003396116332425928),
        (0.9979028262377116, 0.00013570220837571625),
        (0.995283421166614, 0.00030479639785391157),
        (0.9916201012264251, 0.000540534491963787),
        (0.9869167087338907, 0.0008419277232138645),
        (0.981178176898239, 0.0012077119436507257),
        (0.974410524646926, 0.0016363529271348524),
        (0.9666208503126112, 0.0021260528044182363),
        (0.9578173241879872, 0.0026747576040328075),
        (0.9480091799562704, 0.0032801658673605803),
        (0.9372067050063436, 0.003939738301750906),
        (0.9254212296427042, 0.004650708431196321),
        (0.9126651152015401, 0.005410094199894339),
        (0.8989517410853953, 0.006214710480025824),
        (0.8842954907300236, 0.007061182431287967),
        (0.868711736518151, 0.007945959656147375),
        (0.8522168236559693, 0.008865331091441152),
        (0.8348280530292711, 0.00981544057386551),
        (0.816563663057211, 0.010792303014064763),
        (0.7974428105627208, 0.011791821111481011),
        (0.7774855506796493, 0.012809802539856587),
        (0.7567128158176952, 0.013841977531307316),
        (0.7351463937072004, 0.014884016785212882),
        (0.7128089045468293, 0.015931549626808143),
        (0.6897237772781042, 0.016980182339312058),
        (0.6659152250116811, 0.01802551659270274),
        (0.6414082196311399, 0.019063167891842116),
        (0.6162284656009273, 0.020088783966572273),
        (0.5904023730059227, 0.021098063026649003),
        (0.5639570298509065, 0.022086771804945064),
        (0.5369201736489838, 0.023050763313243686),
        (0.509320162328763, 0.023985994236148313),
        (0.481185944490805, 0.02488854189015256),
        (0.4525470290445388, 0.02575462067673805),
        (0.4234334542574901, 0.026580597960490164),
        (0.3938757562492871, 0.027363009305633446),
        (0.3639049369634874, 0.0280985730070792),
        (0.3335524316508205, 0.028784203855037084),
        (0.30285007589795065, 0.02941702607545721),
        (0.27183007223634276, 0.029994385392025855),
        (0.2405249563662535, 0.03051386015912277),
        (0.20896756303127498, 0.03097327151904451),
        (0.17719099157922263, 0.03137069254089082),
        (0.14522857124549016, 0.031704456302782506),
        (0.11311382619528415, 0.0319731628835111),
        (0.08088044036140402, 0.03217568523429486),
        (0.04856222211444808, 0.03231117390601312),
        (0.016193068802501567, 0.03237906061209104),
    ],
    &[
        (0.9994862162006879, 0.00003293234204875345),
        (0.9979453927503363, 0.00013159404213757025),
        (0.9953791129491982, 0.0002955796781779171),
        (0.9917900138232462, 0.0005242153980164958),
        (0.9871817834144502, 0.000816561688438281),
        (0.9815591569910653, 0.0011714172358278478),
        (0.9749279121818236, 0.001587323862624696),
        (0.9672948630390295, 0.0020625725192876245),
        (0.9586678530366607, 0.0025952103071458896),
        (0.9490557470106686, 0.003183048503278734),
        (0.9384684220497604, 0.0038236715544473507),
        (0.9269167573460217, 0.004514447003121273),
        (0.9144126230158125, 0.005252536304811033),
        (0.9009688679024191, 0.0060349064922563265),
        (0.8865993063730001, 0.006858342638539063),
        (0.8713187041233894, 0.007719461067907665),
        (0.8551427630053462, 0.008614723260026535),
        (0.8380881048918407, 0.009540450390515121),
        (0.820172254596956, 0.010492838448026395),
        (0.8014136218679567, 0.011467973865745447),
        (0.7818314824680298, 0.012461849603074978),
        (0.7614459583691344, 0.013470381611424628),
        (0.7402779970753156, 0.01448942561644264),
        (0.7183493500977276, 0.015514794147728151),
        (0.6956825506034865, 0.016542273746045243),
        (0.6723008902613169, 0.017567642277330757),
        (0.6482283953077885, 0.018586686282348764),
        (0.6234898018587336, 0.019595218290698414),
        (0.598110530491216, 0.020589094028027947),
        (0.5721166601221697, 0.021564229445747),
        (0.5455349012105487, 0.022516617503258275),
        (0.5183925683105252, 0.023442344633746854),
        (0.4907175520039379, 0.024337606825865728),
        (0.4625382902408354, 0.025198725255234332),
        (0.4338837391175582, 0.02602216140151707),
        (0.404783343122394, 0.026804531588962358),
        (0.3752670048793742, 0.027542620890652122),
        (0.3453650544213078, 0.02823339633932604),
        (0.31510821802362077, 0.02887401939049466),
        (0.28452758663103267, 0.029461857586627505),
        (0.2536545839095075, 0.029994495374485765),
        (0.22252093395631445, 0.0304697440311487),
        (0.19115862870137248, 0.03088565065794555),
        (0.15959989503337932, 0.03124050620533511),
        (0.12787716168450622, 0.0315328524957569),
        (0.09602302590768189, 0.03176148821559548),
        (0.06407021998071318, 0.03192547385163583),
        (0.03205157757165533, 0.03202413555172464),
        (0.0, 0.0320570678937734),
    ],
    &[
        (0.9994965423831851, 0.00003194465861225996),
        (0.9979866764718844, 0.00012765000458347651),
        (0.9954719225730846, 0.0002867306662640291),
        (0.9919548128307953, 0.0005085460819758582),
        (0.9874388886763943, 0.0007922030793282613),
        (0.9819286972627067, 0.0011365594717078701),
        (0.975429786885407, 0.0015402286574610147),
        (0.9679487013963562, 0.0020015852032491907),
        (0.9594929736144974, 0.0025187713890954264),
        (0.9500711177409454, 0.0030897046887669636),
        (0.9396926207859084, 0.003712086155373371),
        (0.9283679330160726, 0.0043834096784142905),
        (0.9161084574320696, 0.005100972075001886),
        (0.9029265382866212, 0.005861883974624277),
        (0.8888354486549235, 0.006663081453620798),
        (0.8738493770697849, 0.007501338372521189),
        (0.8579834132349771, 0.00837327936657059),
        (0.8412535328311812, 0.009275393437132113),
        (0.8236765814298328, 0.01020404808923914),
        (0.8052702575310586, 0.011155503958370507),
        (0.7860530947427875, 0.012125929867551647),
        (0.766044443118978, 0.013111418254152065),
        (0.7452644496757548, 0.01410800090426091),
        (0.7237340381050701, 0.015111664931283823),
        (0.7014748877063213, 0.016118368934420948),
        (0.6785094115571322, 0.017124059271961558),
        (0.654860733945285, 0.01812468638386851),
        (0.6305526670845225, 0.019116221097927273),
        (0.6056096871376666, 0.020094670853800314),
        (0.5800569095711982, 0.02105609577965849),
        (0.5539200638661103, 0.021996624556654302),
        (0.5272254676105024, 0.022912470007356557),
        (0.4999999999999999, 0.023799944345377227),
        (0.4722710747726827, 0.02465547402478563),
        (0.444066612605774, 0.025475614129516665),
        (0.41541501300188644, 0.026257062244831923),
        (0.38634512569312857, 0.026996671754978274),
        (0.3568862215918719, 0.02769146451349891),
        (0.32706796331742155, 0.02833864283517806),
        (0.2969203753282749, 0.028935600761331875),
        (0.266473813690035, 0.029479934553084303),
        (0.23575893550942728, 0.029969452370375193),
        (0.20480666806519066, 0.030402183097726573),
        (0.17364817766693041, 0.030776384281229),
        (0.14231483827328512, 0.0310905491447885),
        (0.1108381999010111, 0.031343412657382046),
        (0.07924995685678844, 0.03153395662689103),
        (0.04758191582374218, 0.03166141380000153),
        (0.01586596383480793, 0.031725270951662665),
    ],
    &[
        (0.9995065603657316, 0.000030996077366398226),
        (0.9980267284282716, 0.0001238619821089885),
        (0.99556196460308, 0.0002782312149281481),
        (0.9921147013144779, 0.0004934945509865338),
        (0.9876883405951378, 0.0007688024442411866),
        (0.9822872507286887, 0.001103068380213643),
        (0.9759167619387474, 0.0014949731639661995),
        (0.9685831611286311, 0.0019429701263616497),
        (0.9602936856769431, 0.002445291228059763),
        (0.9510565162951535, 0.0029999540371608165),
        (0.9408807689542255, 0.003604769552958626),
        (0.9297764858882513, 0.004257350844926259),
        (0.9177546256839811, 0.004955122472840355),
        (0.9048270524660195, 0.005695330650867072),
        (0.8910065241883679, 0.0064750541154966835),
        (0.8763066800438636, 0.007291215654436067),
        (0.8607420270039436, 0.008140594250959766),
        (0.8443279255020151, 0.009019837795791474),
        (0.8270805742745618, 0.0099254763163479),
        (0.8090169943749475, 0.0108539356711353),
        (0.7901550123756903, 0.011801551655253054),
        (0.7705132427757891, 0.012764584461336416),
        (0.7501110696304596, 0.013739233438867605),
        (0.7289686274214116, 0.014721652093607082),
        (0.7071067811865475, 0.01570796326794897),
        (0.6845471059286886, 0.016694274442290855),
        (0.6613118653236518, 0.017676693097030332),
        (0.6374239897486896, 0.018651342074561518),
        (0.6129070536529765, 0.01961437488064488),
        (0.587785252292473, 0.020561990864762635),
        (0.5620833778521306, 0.021490450219550032),
        (0.5358267949789965, 0.02239608874010646),
        (0.5090414157503712, 0.023275332284938166),
        (0.48175367410171516, 0.024124710881461873),
        (0.4539904997395468, 0.024940872420401248),
        (0.42577929156507266, 0.025720595885030867),
        (0.39714789063478056, 0.02646080406305758),
        (0.36812455268467786, 0.02715857569097168),
        (0.33873792024529126, 0.027811156982939313),
        (0.30901699437494745, 0.028415972498737115),
        (0.2789911060392293, 0.028970635307838173),
        (0.24868988716485474, 0.02947295640953628),
        (0.21814324139654248, 0.029920953371931736),
        (0.18738131458572452, 0.030312858155684293),
        (0.1564344650402307, 0.03064712409165675),
        (0.12533323356430426, 0.030922431984911403),
        (0.09410831331851428, 0.031137695320969785),
        (0.0627905195293133, 0.03129206455378895),
        (0.031410759078128174, 0.03138493045853154),
        (0.0, 0.031415926535897934),
    ],
    &[
        (0.9995162822919881, 0.000030084682347440752),
        (0.9980655971335943, 0.00012022233759822742),
        (0.9956493479690186, 0.0002700642406749836),
        (0.9922698723632765, 0.0004790306823640706),
        (0.9879304397407567, 0.0007463132120979165),
        (0.9826352482222637, 0.0010708777656932068),
        (0.976389420563607, 0.0014514686659443245),
        (0.9691989991996661, 0.001886613480594522),
        (0.9610709403987245, 0.0023746287188902778),
        (0.9520131075327299, 0.0029136263446799746),
        (0.9420342634699892, 0.0035015210808589836),
        (0.9311440620976595, 0.00413603847690169),
        (0.9193530389822363, 0.00481472370826871),
        (0.9066726011770726, 0.00553495107364616),
        (0.8931150161867916, 0.00629393415327394),
        (0.8786934000992688, 0.007088736589062477),
        (0.8634217048966635, 0.007916283444791745),
        (0.8473147049577775, 0.008773373102442117),
        (0.8303879827647975, 0.009656689648632559),
        (0.8126579138282503, 0.010562815703245267),
        (0.7941416508447535, 0.011488245640605514),
        (0.7748571071028899, 0.012429399152066322),
        (0.754822939153257, 0.0133826350975271),
        (0.7340585287594601, 0.014344265592297322),
        (0.712583964147507, 0.01531057027480598),
        (0.6904200205717468, 0.01627781069995774),
        (0.6675881402161536, 0.01724224480245077),
        (0.6441104114503978, 0.01820014137410042),
        (0.6200095474607752, 0.019147794499158852),
        (0.5953088642766661, 0.020081537891783133),
        (0.5700322582137828, 0.020997759080182896),
        (0.5442041827560273, 0.021892913382571946),
        (0.5178496248983255, 0.02276353762085343),
        (0.4909940809733222, 0.02360626351898318),
        (0.46366353198532734, 0.02441783073417531),
        (0.4358844184753712, 0.025195099470535127),
        (0.407683614941689, 0.02593506262631947),
        (0.3790884038403794, 0.026634857427829173),
        (0.3501264491913908, 0.02729177650492436),
        (0.3208257698153678, 0.027903278365313564),
        (0.2912147122272521, 0.028466997227093706),
        (0.26132192321286074, 0.02898075217150062),
        (0.23117632211496977, 0.029442555580460127),
        (0.20080707285571867, 0.02985062082629622),
        (0.17024355572239863, 0.030203369183846446),
        (0.13951533894392312, 0.03049943593824287),
        (0.10865215008547471, 0.03073767566472879),
        (0.07768384728900624, 0.030917166660084594),
        (0.04664039038741761, 0.03103721450851846),
        (0.015551811920351015, 0.031097354768226164),
    ],
];

pub const WEIGHTS_HERMITE: &[&[(f64, f64)]] = &[
    &[(0.0, 1.7724538509055159)],
    &[(f64::consts::FRAC_1_SQRT_2, 0.8862269254527577)],
    &[
        (0.0000000000000020867605332510614, 1.1816359006036774),
        (1.2247448713915892, 0.29540897515091924),
    ],
    &[
        (0.5246476232752904, 0.8049140900055128),
        (1.6506801238857847, 0.08131283544724513),
    ],
    &[
        (0.0, 0.9453087204829418),
        (0.9585724646138184, 0.39361932315224124),
        (2.0201828704560856, 0.01995324205904593),
    ],
    &[
        (0.4360774119276165, 0.7246295952243924),
        (1.335849074013697, 0.15706732032285667),
        (2.350604973674492, 0.004530009905508863),
    ],
    &[
        (0.8162878828589646, 0.42560725261012794),
        (1.6735516287674714, 0.05451558281912708),
        (2.6519613568352334, 0.0009717812450995206),
    ],
    &[
        (0.3811869902073221, 0.6611470125582413),
        (1.1571937124467804, 0.20780232581489166),
        (1.9816567566958425, 0.017077983007413533),
        (2.930637420257244, 0.00019960407221136727),
    ],
    &[
        (0.7235510187528376, 0.4326515590025556),
        (1.468553289216668, 0.08847452739437663),
        (3.1909932017815277, 0.00003960697726326427),
        (2.2665805845318427, 0.004943624275536939),
    ],
    &[
        (0.34290132722370464, 0.6108626337353256),
        (1.0366108297895136, 0.2401386110823146),
        (1.7566836492998819, 0.033874394455480836),
        (2.532731674232789, 0.0013436457467812467),
        (3.4361591188377383, 0.00000764043285523254),
    ],
    &[
        (0.0, 0.6547592869145917),
        (0.6568095668820997, 0.4293597523561252),
        (1.3265570844949333, 0.1172278751677079),
        (2.025948015825756, 0.011911395444911429),
        (3.6684708465595826, 0.000001439560393714253),
        (2.783290099781651, 0.0003468194663233478),
    ],
    &[
        (0.31424037625435913, 0.5701352362624794),
        (0.9477883912401637, 0.2604923102641614),
        (1.5976826351526041, 0.05160798561588446),
        (2.2795070805010624, 0.003905390584629015),
        (3.8897248978697827, 0.0000002658551684356262),
        (3.0206370251208883, 0.00008573687043587651),
    ],
    &[
        (0.6057638791710601, 0.42161629689854324),
        (1.2200550365907485, 0.14032332068702336),
        (1.8531076516015115, 0.020862775296170016),
        (2.519735685678236, 0.0012074599927194365),
        (4.101337596178638, 0.00000004825731850073284),
        (3.2466089783724073, 0.00002043036040270752),
        (0.0000000000000020561243904877227, 0.6043931879211616),
    ],
    &[
        (0.8787137873293992, 0.2731056090642469),
        (1.4766827311411403, 0.06850553422346557),
        (2.0951832585077144, 0.007850054726458165),
        (2.7484707249854052, 0.0003550926135518842),
        (4.304448570473632, 0.000000008628591168125228),
        (3.462656933602273, 0.000004716484355018683),
        (0.2917455106725621, 0.5364059097120901),
    ],
    &[
        (0.5650695832555758, 0.4120286874988989),
        (1.1361155852109206, 0.15848891579593533),
        (1.7199925751864868, 0.030780033872546457),
        (2.3257324861738566, 0.00277806884291274),
        (3.6699503734044576, 0.0000010591155477110144),
        (2.9671669279056, 0.00010000444123249368),
        (4.4999907073093866, 0.0000000015224758042536394),
    ],
    &[
        (4.688738939305813, 0.0000000002654807474011472),
        (0.27348104613815244, 0.5079294790166136),
        (1.3802585391988793, 0.08381004139898629),
        (1.9517879909162572, 0.012880311535510162),
        (2.5462021578474934, 0.000932284008624053),
        (3.8694479048601167, 0.00000023209808448655447),
        (3.1769991619799516, 0.0000271186009253837),
        (0.8229514491446557, 0.28064745852853384),
    ],
    &[
        (0.5316330013426547, 0.4018264694704118),
        (1.0676487257434508, 0.1726482976700975),
        (1.6129243142212313, 0.040920034149756424),
        (2.1735028266666245, 0.005067349957627136),
        (2.7577629157038923, 0.00029864328669771626),
        (4.871345193674406, 0.000000000045805789307981146),
        (4.061946675875511, 0.0000000497707898162795),
        (3.3789320911415084, 0.000007112289140019297),
    ],
    &[
        (1.3009208583896186, 0.09730174764131451),
        (0.7766829192674118, 0.28480728566997965),
        (1.8355316042616374, 0.018640042387542546),
        (2.386299089166682, 0.001888522630268459),
        (3.5737690684862033, 0.0000018106544810949903),
        (2.961377505531634, 0.00009181126867930403),
        (0.25826775051909673, 0.4834956947254555),
        (5.048364008874456, 0.000000000007828199772117288),
        (4.2481178735680984, 0.000000010467205795795588),
    ],
    &[
        (1.0103683871343112, 0.18363270130699702),
        (0.5035201634238882, 0.3916089886130303),
        (5.220271690537475, 0.0000000000013262970944986284),
        (1.524170619393532, 0.050810386909051944),
        (2.049231709850601, 0.007988866777723876),
        (2.591133789794568, 0.0006708775214069669),
        (3.762187351963988, 0.000000448824314722163),
        (3.1578488183475804, 0.000027209197763165388),
        (0.0, 0.5029748882761865),
        (4.428532806603742, 0.0000000021630510098654235),
    ],
    &[
        (1.2340762153953238, 0.1090172060200211),
        (1.7385377121165846, 0.024810520887464226),
        (2.254974002089305, 0.003243773342235725),
        (0.7374737285453944, 0.286675505362835),
        (2.78880605842807, 0.00022833863601637704),
        (3.347854567383257, 0.000007802556478534267),
        (4.603682449550751, 0.00000000043993409922740877),
        (5.387480890011245, 0.00000000000022293936455336517),
        (3.944764040115711, 0.00000010860693707686313),
        (0.24534070830090127, 0.46224366960061),
    ],
    &[
        (3.531972877137794, 0.000002171884898048788),
        (0.47945070707910753, 0.38166907361350244),
        (0.9614996344183693, 0.192120324066999),
        (1.4489342506507334, 0.06017964665891326),
        (1.9449629491862477, 0.01141406583743688),
        (2.453552124512811, 0.0012549820417267015),
        (2.9799912077046717, 0.00007478398867305183),
        (
            0.000000000000000000000000006462348535570529,
            0.4790237031201776,
        ),
        (5.550351873264615, 0.00000000000003720365070141905),
        (4.773992343411177, 0.00000000008818611242057148),
        (4.121995547491838, 0.00000002571230180058311),
    ],
    &[
        (0.703686097170007, 0.28697143324690716),
        (1.1767139584812443, 0.11910236095878116),
        (1.6558743732864287, 0.03114037088442125),
        (2.144233592798554, 0.004978399335052298),
        (2.6456374410581787, 0.0004648850508843284),
        (3.1652659092025375, 0.000023655128552354708),
        (4.9398341310599845, 0.00000000001744339007555653),
        (4.294312480593143, 0.000000005966990986060552),
        (3.710701532877414, 0.0000005884287563355937),
        (0.23417913993099063, 0.4435452264349592),
        (5.709201353205243, 0.000000000000006167183424407208),
    ],
    &[
        (0.4585383500681047, 0.37214382487756514),
        (0.9191514654425641, 0.19864489857802417),
        (1.3840395856824963, 0.06889028942908348),
        (1.855677037671392, 0.015207084004479742),
        (2.3370162114744453, 0.002069567874959676),
        (2.8318037871264155, 0.00016556169914145043),
        (3.345127159940965, 0.000007249295917998907),
        (4.462091173740272, 0.0000000013596296503880212),
        (5.864309498984492, 0.0000000000000010160384620658547),
        (3.884472708105962, 0.0000001555339329152806),
        (
            0.0000000000000000000000016543612251060553,
            0.4581965855932134,
        ),
        (5.101534610476862, 0.0000000000034083140980248967),
    ],
    &[
        (0.6741711070372122, 0.2861795353464431),
        (1.126760817611244, 0.12773962178455622),
        (1.584250010961693, 0.03744547050322833),
        (2.049003573661725, 0.0070483558100753),
        (2.5238810170115142, 0.0008236924826873838),
        (3.012546137565452, 0.00005688691636410299),
        (3.520006813033911, 0.000002158245704907957),
        (6.015925561425685, 0.00000000000000016643684964905528),
        (5.259382927667653, 0.0000000000006584620243144965),
        (4.6256627564235036, 0.00000000030462542699915223),
        (4.053664402447418, 0.00000004018971174972658),
        (0.2244145474725156, 0.4269311638686992),
    ],
    &[
        (0.44014729864530827, 0.3630889892758904),
        (0.0, 0.4398687221694848),
        (0.8819827562138218, 0.20362113667812456),
        (1.7780011243371694, 0.019243098965403146),
        (2.236420130267199, 0.00311570872012796),
        (2.70532023717262, 0.00031508363874643294),
        (3.188294924426567, 0.000018915972957056787),
        (3.69028287699787, 0.0000006257032499701357),
        (6.164272434052493, 0.000000000000000027119235140370137),
        (4.7853203673509705, 0.00000000006719638417833212),
        (4.218609444387147, 0.000000010170382502923877),
        (1.3272807020730844, 0.07688899517581167),
        (5.413636355279929, 0.0000000000001258814987742918),
    ],
    &[
        (0.6480952139934482, 0.2846322411767852),
        (1.0827330110778826, 0.13511332791179118),
        (1.5213615166519332, 0.043598227217242914),
        (1.9658547856411226, 0.009397901291169033),
        (2.418415764773397, 0.001319064722329061),
        (2.8817622195427477, 0.00011622970160242979),
        (3.359427182349851, 0.000006103291717458342),
        (4.941324957240534, 0.000000000014609999340386852),
        (3.856288419910406, 0.0000001770106337350004),
        (6.309550385625781, 0.000000000000000004396916094745849),
        (4.3796026629880425, 0.000000002524494034229863),
        (0.21577785624346346, 0.41204365059036935),
        (5.56452498194968, 0.000000000000023831486593989576),
    ],
    &[
        (0.42380790054385303, 0.3545173040997538),
        (1.7095607392603236, 0.023415933625335724),
        (1.2770668173398612, 0.08417308108405078),
        (2.1482966453617864, 0.00438127983579775),
        (2.5954163389102898, 0.000536769615688849),
        (3.053582419823145, 0.000041467580044010925),
        (4.018318670409682, 0.00000004895400409624011),
        (3.526275340134713, 0.0000019152809005796453),
        (0.8490113420601032, 0.20737048075100933),
        (5.7122555528145975, 0.000000000000004470772457581752),
        (5.093910003117675, 0.000000000003134117613177478),
        (6.451940140753698, 0.000000000000000000709577929700296),
        (4.536906663370579, 0.0000000006155031578527683),
        (0.0, 0.42357728801505945),
    ],
];

// Taken from https://github.com/Eh2406/quadrature/blob/master/src/double_exponential/constants.rs
// which is published under the BSD license
#[allow(clippy::excessive_precision)]
pub const WEIGHTS_DE: [&[(f64, f64)]; 7] = [
    &[
        // First layer weights
        (0.230022394514788685, 0.95136796407274694573),
        (0.00026620051375271690866, 0.99997747719246159286),
        (1.3581784274539090834e-12, 0.99999999999995705839),
    ],
    &[
        // 2nd layer weights and abcissas: transformed 1/2, 3/2, 5/2
        (0.5 * 0.96597657941230114801, 0.67427149224843582608),
        (0.5 * 0.018343166989927842087, 0.99751485645722438683),
        (0.5 * 2.1431204556943039358e-7, 0.99999998887566488198),
    ],
    &[
        // 3rd layer weights and abcissas: transformed 1/4, 3/4, ...
        (0.25 * 1.3896147592472563229, 0.37720973816403417379),
        (0.25 * 0.53107827542805397476, 0.85956905868989663517),
        (0.25 * 0.076385743570832304188, 0.98704056050737689169),
        (0.25 * 0.0029025177479013135936, 0.99968826402835320905),
        (0.25 * 0.000011983701363170720047, 0.99999920473711471266),
        (0.25 * 1.1631165814255782766e-9, 0.99999999995285644818),
    ],
    &[
        // 4th layer weights and abcissas: transformed 1/8, 3/8, ...
        (0.125 * 1.5232837186347052132, 0.19435700332493543161),
        (0.125 * 1.1934630258491569639, 0.53914670538796776905),
        (0.125 * 0.73743784836154784136, 0.78060743898320029925),
        (0.125 * 0.36046141846934367417, 0.91487926326457461091),
        (0.125 * 0.13742210773316772341, 0.97396686819567744856),
        (0.125 * 0.039175005493600779072, 0.99405550663140214329),
        (0.125 * 0.0077426010260642407123, 0.99906519645578584642),
        (0.125 * 0.00094994680428346871691, 0.99990938469514399984),
        (0.125 * 0.000062482559240744082891, 0.99999531604122052843),
        (0.125 * 1.8263320593710659699e-6, 0.99999989278161241838),
        (0.125 * 1.8687282268736410132e-8, 0.99999999914270509218),
        (0.125 * 4.9378538776631926964e-11, 0.99999999999823216531),
    ],
    &[
        //  5th layer weights and abcissa: transformed 1/16, 3/16, ...
        (0.0625 * 1.5587733555333301451, 0.097923885287832333262),
        (0.0625 * 1.466014426716965781, 0.28787993274271591456),
        (0.0625 * 1.297475750424977998, 0.46125354393958570440),
        (0.0625 * 1.0816349854900704074, 0.61027365750063894488),
        (0.0625 * 0.85017285645662006895, 0.73101803479256151149),
        (0.0625 * 0.63040513516474369106, 0.82331700550640237006),
        (0.0625 * 0.44083323627385823707, 0.88989140278426019808),
        (0.0625 * 0.290240679312454185, 0.93516085752198468323),
        (0.0625 * 0.17932441211072829296, 0.96411216422354729193),
        (0.0625 * 0.10343215422333290062, 0.98145482667733517003),
        (0.0625 * 0.055289683742240583845, 0.99112699244169880223),
        (0.0625 * 0.027133510013712003219, 0.99610866543750854254),
        (0.0625 * 0.012083543599157953493, 0.99845420876769773751),
        (0.0625 * 0.0048162981439284630173, 0.99945143443527460584),
        (0.0625 * 0.0016908739981426396472, 0.99982882207287494166),
        (0.0625 * 0.00051339382406790336017, 0.99995387100562796075),
        (0.0625 * 0.00013205234125609974879, 0.99998948201481850361),
        (0.0625 * 0.000028110164327940134749, 0.99999801714059543208),
        (0.0625 * 4.8237182032615502124e-6, 0.99999969889415261122),
        (0.0625 * 6.4777566035929719908e-7, 0.99999996423908091534),
        (0.0625 * 6.5835185127183396672e-8, 0.99999999678719909830),
        (0.0625 * 4.8760060974240625869e-9, 0.99999999978973286224),
        (0.0625 * 2.5216347918530148572e-10, 0.99999999999039393352),
        (0.0625 * 8.6759314149796046502e-12, 0.99999999999970809734),
    ],
    &[
        // 6th layer weights and abcissas: transformed 1/32, 3/32, ...
        (0.03125 * 1.5677814313072218572, 0.049055967305077886315),
        (0.03125 * 1.5438811161769592204, 0.14641798429058794053),
        (0.03125 * 1.4972262225410362896, 0.24156631953888365838),
        (0.03125 * 1.4300083548722996676, 0.33314226457763809244),
        (0.03125 * 1.3452788847662516615, 0.41995211127844715849),
        (0.03125 * 1.2467012074518577048, 0.50101338937930910152),
        (0.03125 * 1.1382722433763053734, 0.57558449063515165995),
        (0.03125 * 1.0240449331118114483, 0.64317675898520470128),
        (0.03125 * 0.90787937915489531693, 0.70355000514714201566),
        (0.03125 * 0.79324270082051671787, 0.75669390863372994941),
        (0.03125 * 0.68306851634426375464, 0.80279874134324126576),
        (0.03125 * 0.57967810308778764708, 0.84221924635075686382),
        (0.03125 * 0.48475809121475539287, 0.87543539763040867837),
        (0.03125 * 0.39938474152571713515, 0.90301328151357387064),
        (0.03125 * 0.32408253961152890402, 0.92556863406861266645),
        (0.03125 * 0.258904639514053516, 0.94373478605275715685),
        (0.03125 * 0.20352399885860174519, 0.95813602271021369012),
        (0.03125 * 0.15732620348436615027, 0.96936673289691733517),
        (0.03125 * 0.11949741128869592428, 0.97797623518666497298),
        (0.03125 * 0.089103139240941462841, 0.98445883116743083087),
        (0.03125 * 0.065155533432536205042, 0.98924843109013389601),
        (0.03125 * 0.046668208054846613644, 0.99271699719682728538),
        (0.03125 * 0.032698732726609031113, 0.99517602615532735426),
        (0.03125 * 0.022379471063648476483, 0.99688031812819187372),
        (0.03125 * 0.014937835096050129696, 0.99803333631543375402),
        (0.03125 * 0.0097072237393916892692, 0.99879353429880589929),
        (0.03125 * 0.0061300376320830301252, 0.99928111192179195541),
        (0.03125 * 0.0037542509774318343023, 0.99958475035151758732),
        (0.03125 * 0.0022250827064786427022, 0.99976797159956083506),
        (0.03125 * 0.0012733279447082382027, 0.99987486504878034648),
        (0.03125 * 0.0007018595156842422708, 0.99993501992508242369),
        (0.03125 * 0.00037166693621677760301, 0.99996759306794345976),
        (0.03125 * 0.00018856442976700318572, 0.99998451990227082442),
        (0.03125 * 0.000091390817490710122732, 0.99999293787666288565),
        (0.03125 * 0.000042183183841757600604, 0.99999693244919035751),
        (0.03125 * 0.000018481813599879217116, 0.99999873547186590954),
        (0.03125 * 7.6595758525203162562e-6, 0.99999950700571943689),
        (0.03125 * 2.9916615878138787094e-6, 0.99999981889371276701),
        (0.03125 * 1.0968835125901264732e-6, 0.99999993755407837378),
        (0.03125 * 3.7595411862360630091e-7, 0.99999997987450320175),
        (0.03125 * 1.1992442782902770219e-7, 0.99999999396413420165),
        (0.03125 * 3.5434777171421953043e-8, 0.99999999832336194826),
        (0.03125 * 9.6498888961089633609e-9, 0.99999999957078777261),
        (0.03125 * 2.4091773256475940779e-9, 0.99999999989927772326),
        (0.03125 * 5.482835779709497755e-10, 0.99999999997845533741),
        (0.03125 * 1.1306055347494680536e-10, 0.99999999999582460688),
        (0.03125 * 2.0989335404511469109e-11, 0.99999999999927152627),
        (0.03125 * 3.4841937670261059685e-12, 0.99999999999988636130),
    ],
    &[
        // 7th layer weights and abcissas: transformed 1/64, 3/64, ...
        (0.015625 * 1.5700420292795931467, 0.024539763574649160379),
        (0.015625 * 1.5640214037732320999, 0.073525122985671294475),
        (0.015625 * 1.5520531698454121192, 0.12222912220155764235),
        (0.015625 * 1.5342817381543034316, 0.17046797238201051811),
        (0.015625 * 1.5109197230741697127, 0.21806347346971200463),
        (0.015625 * 1.48224329788553807, 0.26484507658344795046),
        (0.015625 * 1.4485862549613225916, 0.31065178055284596083),
        (0.015625 * 1.4103329714462590129, 0.35533382516507453330),
        (0.015625 * 1.3679105116808964881, 0.39875415046723775644),
        (0.015625 * 1.3217801174437728579, 0.44078959903390086627),
        (0.015625 * 1.2724283455378627082, 0.48133184611690504422),
        (0.015625 * 1.2203581095793582207, 0.52028805069123015958),
        (0.015625 * 1.1660798699324345766, 0.55758122826077823080),
        (0.015625 * 1.1101031939653403796, 0.59315035359195315880),
        (0.015625 * 1.0529288799552666556, 0.62695020805104287950),
        (0.015625 * 0.99504180404613271514, 0.65895099174335012438),
        (0.015625 * 0.93690461274566793366, 0.68913772506166767176),
        (0.015625 * 0.87895234555278212039, 0.71750946748732412721),
        (0.015625 * 0.82158803526696470334, 0.74407838354734739913),
        (0.015625 * 0.7651792989089561367, 0.76886868676824658459),
        (0.015625 * 0.71005590120546898385, 0.79191549237614211447),
        (0.015625 * 0.65650824613162753076, 0.81326360850297385168),
        (0.015625 * 0.60478673057840362158, 0.83296629391941087564),
        (0.015625 * 0.55510187800363350959, 0.85108400798784873261),
        (0.015625 * 0.5076251588319080997, 0.86768317577564598669),
        (0.015625 * 0.4624903980553677613, 0.88283498824466895513),
        (0.015625 * 0.41979566844501548066, 0.89661425428007602579),
        (0.015625 * 0.37960556938665160999, 0.90909831816302043511),
        (0.015625 * 0.3419537959230168323, 0.92036605303195280235),
        (0.015625 * 0.30684590941791694932, 0.93049693799715340631),
        (0.015625 * 0.27426222968906810637, 0.93957022393327475539),
        (0.015625 * 0.24416077786983990868, 0.94766419061515309734),
        (0.015625 * 0.21648020911729617038, 0.95485549580502268541),
        (0.015625 * 0.19114268413342749532, 0.96121861515111640753),
        (0.015625 * 0.16805663794826916233, 0.96682537031235585284),
        (0.015625 * 0.14711941325785693248, 0.97174454156548730892),
        (0.015625 * 0.12821973363120098675, 0.97604156025657673933),
        (0.015625 * 0.11123999898874453035, 0.97977827580061576265),
        (0.015625 * 0.096058391865189467849, 0.98301279148110110558),
        (0.015625 * 0.082550788110701737654, 0.98579936302528343597),
        (0.015625 * 0.070592469906866999352, 0.98818835380074264243),
        (0.015625 * 0.060059642358636300319, 0.99022624046752774694),
        (0.015625 * 0.05083075757257047107, 0.99195566300267761562),
        (0.015625 * 0.042787652157725676034, 0.99341551316926403900),
        (0.015625 * 0.035816505604196436523, 0.99464105571251119672),
        (0.015625 * 0.029808628117310126969, 0.99566407681695316965),
        (0.015625 * 0.024661087314753282511, 0.99651305464025377317),
        (0.015625 * 0.020277183817500123926, 0.99721334704346870224),
        (0.015625 * 0.016566786254247575375, 0.99778739195890653083),
        (0.015625 * 0.013446536605285730674, 0.99825491617199629344),
        (0.015625 * 0.010839937168255907211, 0.99863314864067747762),
        (0.015625 * 0.0086773307495391815854, 0.99893703483351217373),
        (0.015625 * 0.0068957859690660035329, 0.99917944893488591716),
        (0.015625 * 0.0054388997976239984331, 0.99937140114093768690),
        (0.015625 * 0.0042565295990178580165, 0.99952223765121720422),
        (0.015625 * 0.0033044669940348302363, 0.99963983134560036519),
        (0.015625 * 0.0025440657675291729678, 0.99973076151980848263),
        (0.015625 * 0.0019418357759843675814, 0.99980048143113838630),
        (0.015625 * 0.0014690143599429791058, 0.99985347277311141171),
        (0.015625 * 0.0011011261134519383862, 0.99989338654759256426),
        (0.015625 * 0.00081754101332469493115, 0.99992317012928932869),
        (0.015625 * 0.00060103987991147422573, 0.99994518061445869309),
        (0.015625 * 0.00043739495615911687786, 0.99996128480785666613),
        (0.015625 * 0.00031497209186021200274, 0.99997294642523223656),
        (0.015625 * 0.00022435965205008549104, 0.99998130127012072679),
        (0.015625 * 0.00015802788400701191949, 0.99998722128200062811),
        (0.015625 * 0.00011002112846666697224, 0.99999136844834487344),
        (
            0.015625 * 0.000075683996586201477788,
            0.99999423962761663478,
        ),
        (
            0.015625 * 0.000051421497447658802092,
            0.99999620334716617675,
        ),
        (0.015625 * 0.0000344921247593431977, 0.99999752962380516793),
        (
            0.015625 * 0.000022832118109036146591,
            0.99999841381096473542,
        ),
        (
            0.015625 * 0.000014908514031870608449,
            0.99999899541068996962,
        ),
        (0.015625 * 9.5981941283784710776e-6, 0.99999937270733536947),
        (0.015625 * 6.0899100320949039256e-6, 0.99999961398855024275),
        (0.015625 * 3.8061983264644899045e-6, 0.99999976602333243312),
        (0.015625 * 2.3421667208528096843e-6, 0.99999986037121459941),
        (0.015625 * 1.4183067155493917523e-6, 0.99999991800479471056),
        (0.015625 * 8.4473756384859863469e-7, 0.99999995264266446185),
        (0.015625 * 4.9458288702754198508e-7, 0.99999997311323594362),
        (0.015625 * 2.8449923659159806339e-7, 0.99999998500307631173),
        (0.015625 * 1.6069394579076224911e-7, 0.99999999178645609907),
        (0.015625 * 8.9071395140242387124e-8, 0.99999999558563361584),
        (0.015625 * 4.8420950198072369669e-8, 0.99999999767323673790),
        (0.015625 * 2.579956822953589238e-8, 0.99999999879798350040),
        (0.015625 * 1.3464645522302038796e-8, 0.99999999939177687583),
        (0.015625 * 6.8784610955899001111e-9, 0.99999999969875436925),
        (0.015625 * 3.4371856744650090511e-9, 0.99999999985405611550),
        (0.015625 * 1.6788897682161906807e-9, 0.99999999993088839501),
        (0.015625 * 8.0099784479729665356e-10, 0.99999999996803321674),
        (0.015625 * 3.7299501843052790038e-10, 0.99999999998556879008),
        (0.015625 * 1.6939457789411646876e-10, 0.99999999999364632387),
        (0.015625 * 7.4967397573818224522e-11, 0.99999999999727404948),
        (0.015625 * 3.230446433325236576e-11, 0.99999999999886126543),
        (0.015625 * 1.3542512912336274432e-11, 0.99999999999953722654),
        (0.015625 * 5.5182369468174885821e-12, 0.99999999999981720098),
        (0.015625 * 2.1835922099233609052e-12, 0.99999999999992987953),
    ],
]; // end weights

pub const WEIGHTS_LAGUERRE: &[&[(f64, f64)]] = &[
    &[(1.0, 1.0)],
    &[
        (3.414213562373095, 0.1464466094067262),
        (0.5857864376269049, 0.8535533905932741),
    ],
    &[
        (0.415774556783479, 0.7110930099291731),
        (2.2942803602790414, 0.2785177335692415),
        (6.2899450829374794, 0.0103892565015861),
    ],
    &[
        (0.32254768961939234, 0.6031541043416327),
        (1.7457611011583463, 0.35741869243780167),
        (9.395070912301131, 0.0005392947055613306),
        (4.536620296921128, 0.03888790851500506),
    ],
    &[
        (0.2635603197181409, 0.5217556105828075),
        (1.4134030591065174, 0.39866681108317414),
        (3.5964257710407215, 0.07594244968170707),
        (7.085810005858829, 0.003611758679922193),
        (12.64080084427578, 0.000023369972385775425),
    ],
    &[
        (0.2228466041792607, 0.4589646739499644),
        (1.1889321016726224, 0.4170008307721208),
        (2.9927363260593127, 0.11337338207404515),
        (5.775143569104504, 0.01039919745314942),
        (15.982873980601713, 0.000000898547906429553),
        (9.837467418382557, 0.00026101720281495846),
    ],
    &[
        (0.19304367656036242, 0.40931895170127447),
        (1.0266648953391913, 0.42183127786172464),
        (2.5678767449507447, 0.14712634865749938),
        (4.90035308452649, 0.020633514468721345),
        (8.182153444562898, 0.001074010143280573),
        (12.734180291797822, 0.000015865464348562705),
        (19.39572786226255, 0.00000003170315478995339),
    ],
    &[
        (0.17027963230510101, 0.3691885893416387),
        (0.9037017767993802, 0.41878678081433957),
        (2.2510866298661223, 0.1757949866371806),
        (4.266700170287707, 0.03334349226121529),
        (7.045905402393452, 0.002794536235224991),
        (10.758516010181166, 0.00009076508773357571),
        (22.863131736889294, 0.0000000010480011748714847),
        (15.740678641278047, 0.0000008485746716267017),
    ],
    &[
        (0.15232222773180826, 0.33612642179796093),
        (0.8072200227422551, 0.41121398042399476),
        (2.005135155619351, 0.19928752537086228),
        (3.7834739733312293, 0.04746056276566921),
        (6.204956777876491, 0.0055996266107984334),
        (9.372985251687528, 0.00030524976709253967),
        (13.46623691109195, 0.000006592123026096812),
        (18.833597788991586, 0.00000004110769330351708),
        (26.374071890927514, 0.000000000032908740303513914),
    ],
    &[
        (0.13779347054049246, 0.3084411157650194),
        (0.7294545495031706, 0.40111992915527156),
        (1.8083429017403179, 0.218068287611829),
        (3.4014336978548716, 0.062087456098701116),
        (5.552496140063563, 0.009501516975197416),
        (8.33015274676417, 0.000753008388586491),
        (11.843785837902553, 0.000028259233496024502),
        (16.27925783137718, 0.000000424931398495275),
        (29.920697012274026, 0.0000000000009911827219597304),
        (21.996585811981028, 0.0000000018395648239857642),
    ],
    &[
        (0.1257964421879675, 0.2849332128942031),
        (0.665418255839228, 0.389720889527854),
        (1.6471505458721756, 0.2327818318489814),
        (3.0911381430352214, 0.07656445354616603),
        (5.029284401580054, 0.014393282767392346),
        (7.50988786380536, 0.0015188808464845465),
        (10.605950999549625, 0.00008513122435521024),
        (14.431613758059003, 0.0000022924038795707537),
        (19.178857403213787, 0.00000002486353702799373),
        (25.217709339676784, 0.00000000007712626933678658),
        (33.4971928471758, 0.000000000000028837758683163035),
    ],
    &[
        (0.11572211735802065, 0.26473137105544353),
        (0.6117574845151299, 0.3777592758731454),
        (1.5126102697764239, 0.24408201131986645),
        (2.833751337743385, 0.09044922221178123),
        (4.599227639419226, 0.020102381154568357),
        (6.844525453111944, 0.0026639735419284024),
        (9.62131684246349, 0.0002032315926546701),
        (13.006054993302694, 0.000008365055857489104),
        (17.116855187461553, 0.00000016684938765711436),
        (22.151090379399548, 0.0000000013423910305965858),
        (37.09912104446848, 0.0000000000000008148077467429861),
        (28.487967250987538, 0.000000000003061601634957796),
    ],
];
