use crate::postman::{Item, Request, Response};
use pulldown_cmark::{html, Options, Parser};

fn remove_braces(text: &String) -> String {
    if text.contains("{") {
        let mut fixed_text: String;
        fixed_text = text.replace("{", "");
        fixed_text = fixed_text.replace("}", "");
        fixed_text
    } else {
        text.to_string()
    }
}

fn wrap_literal(text: &String) -> String {
    let mut fixed_text = r#"{`"#.to_string();
    fixed_text.push_str(&text);
    fixed_text.push_str(r#"`}"#);
    fixed_text
}

pub fn folder(folder: &Item, loop_iter: i8) -> (String, String) {
    let folder_markup = format!(
        "<h6 class='folder-h{}' id={}>{}</h6>\n",
        loop_iter,
        wrap_literal(&folder.name),
        remove_braces(&folder.name),
    );
    let link = format!(
        "<a href='#{}' class='folder-a{}'>{}</a>\n",
        remove_braces(&folder.name),
        loop_iter,
        remove_braces(&folder.name)
    );
    return (folder_markup, link);
}

pub fn rest_header(name: String) -> String {
    format!(
        "<p class='headers' id={}>{}</p>\n",
        wrap_literal(&name),
        remove_braces(&name)
    )
}

pub fn request(request: &Request) -> String {
    if let Some(url) = &request.url {
        let mut path = String::new();
        if let Some((raw, _)) = url.raw.split_once('?') {
            path.push_str(&raw);
        } else {
            path.push_str(&url.raw);
        }
        return format!(
            "<p class='request' id={}>{}</p>\n",
            remove_braces(&path),
            wrap_literal(&path),
        );
    }
    if let Some(description) = &request.description {
        let mut options = Options::empty();
        options.insert(Options::ENABLE_TASKLISTS);
        let parser = Parser::new_ext(description, options);
        let mut html_output = String::new();
        html::push_html(&mut html_output, parser);

        return format!("<div>\n\n{}\n\n</div>", html_output);
    } else {
        return "".to_string();
    }
}

pub fn response(responses: &Vec<Response>) -> String {
    let mut responses_markup = String::new();
    for response in responses {
        let response_markup = format!(
            "<h6>{}</h6>\n<pre><code>{}</code></pre>",
            response.name,
            wrap_literal(&response.body)
        );
        responses_markup.push_str(&response_markup);
    }
    responses_markup
}
