# Backpub
***Currently in experimentation phase***

## Intro
Publish your backend documentation from a Postman Collection as a static website with an interactive API.

## Static Site
Uses Svelte, TailwindCSS and Vite to generate the website and allow for hot reloading, folders and requests have classes applied to them, and the styling is controlled for the classes via Tailwind directives in the [app.css file](./site/src/app.css).

## Configuration
`config.yaml` at the root of this repo can be changed to allow retrieval of remote Postman collections via the Postman API e.g.

[Get your Postman API key](`https://go.postman.co/settings/me/api-keys`)

Get your collection ID by clicking the three dots next to its name and clicking `settings`

```yaml
collection_from_api: true
postman_api_key: "XXXXX-XXXXX-XXXXX-XXXX"
collection_id: "XXXXXXX-XXXXXXXXX-XXXXXXXXX-XXXXXX"
```

You can override the base `config.yaml` by putting a new file in your config folder:

### Linux
#### Path
$XDG_CONFIG_HOME/backpub/config.yaml or $HOME/.config/backpub/config.yaml
#### Example
/home/alice/.config/backpub/config.yaml

### MacOS
#### Path
$HOME/Library/Application Support/backpub/config.yaml
#### Example
/Users/Alice/Library/Application Support/backpub/config.yaml

### Windows
#### Path
{FOLDERID_RoamingAppData}\backpub\config.yaml
#### Example
C:\Users\Alice\AppData\Roaming\backpub\config.yaml