use backproof_sdk::{
    api::{Candle, Order},
    BackproofStrategy, Options,
};
use std::time::Duration;
use tokio;
use tracing::{info, instrument};

#[instrument]
#[tokio::main]
async fn main() {
    tracing_subscriber::fmt::init();

    let address = std::env::args().nth(1).unwrap();

    let mut strategy = BackproofStrategy::builder()
        .api_key("A323FSDEO3123FSD".to_string())
        .api_strategy("flex".to_string(), |x: Candle| -> Order {
            println!("Strategy running with input {x:?}...");
            std::thread::sleep(Duration::from_secs(1));

            Order {
                symbol: "BTC".to_string(),
                quantity: "100".to_string(),
                side: 1,
            }
        })
        .build(address)
        .await
        .expect("strategy build failed");

    let session = strategy.register().await.expect("register");

    info!("Starting strategy");

    let closer = strategy
        .run(Options::default(), session)
        .await
        .expect("strategy run failed");

    std::thread::sleep(Duration::from_secs(5));
    info!("closing backend.");
    let _ = closer.send(()).expect("failed to close");
}
