#![cfg_attr(not(test), no_std)]

#[allow(dead_code)]
mod bindings;
#[allow(non_camel_case_types)]
mod ctypes;

pub mod blake2b;

use rand_core::{CryptoRng, RngCore};

pub trait GenerateSecret {
    fn generate<RNG: RngCore + CryptoRng>(rng: &mut RNG) -> Self;
}
