#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AggregateSeries {
    #[serde(rename = "timeSeriesId")]
    pub time_series_id: TimeSeriesId,
    #[serde(rename = "searchSpan")]
    pub search_span: DateTimeRange,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<Tsx>,
    pub interval: String,
    #[serde(rename = "projectedVariables", default, skip_serializing_if = "Vec::is_empty")]
    pub projected_variables: Vec<String>,
    #[serde(rename = "inlineVariables", default, skip_serializing_if = "Option::is_none")]
    pub inline_variables: Option<serde_json::Value>,
}
impl AggregateSeries {
    pub fn new(time_series_id: TimeSeriesId, search_span: DateTimeRange, interval: String) -> Self {
        Self {
            time_series_id,
            search_span,
            filter: None,
            interval,
            projected_variables: Vec::new(),
            inline_variables: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AggregateVariable {
    #[serde(flatten)]
    pub variable: Variable,
    pub aggregation: Tsx,
}
impl AggregateVariable {
    pub fn new(variable: Variable, aggregation: Tsx) -> Self {
        Self { variable, aggregation }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Availability {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub range: Option<DateTimeRange>,
    #[serde(rename = "intervalSize", default, skip_serializing_if = "Option::is_none")]
    pub interval_size: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub distribution: Option<serde_json::Value>,
}
impl Availability {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AvailabilityResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub availability: Option<Availability>,
}
impl AvailabilityResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CategoricalVariable {
    #[serde(flatten)]
    pub variable: Variable,
    pub value: Tsx,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interpolation: Option<Interpolation>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub categories: Vec<TimeSeriesAggregateCategory>,
    #[serde(rename = "defaultCategory")]
    pub default_category: TimeSeriesDefaultCategory,
}
impl CategoricalVariable {
    pub fn new(variable: Variable, value: Tsx, default_category: TimeSeriesDefaultCategory) -> Self {
        Self {
            variable,
            value,
            interpolation: None,
            categories: Vec::new(),
            default_category,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DateTimeRange {
    pub from: String,
    pub to: String,
}
impl DateTimeRange {
    pub fn new(from: String, to: String) -> Self {
        Self { from, to }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventProperty {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<PropertyType>,
}
impl EventProperty {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventSchema {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub properties: Vec<EventProperty>,
}
impl EventSchema {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetEventSchemaRequest {
    #[serde(rename = "searchSpan")]
    pub search_span: DateTimeRange,
}
impl GetEventSchemaRequest {
    pub fn new(search_span: DateTimeRange) -> Self {
        Self { search_span }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetEvents {
    #[serde(rename = "timeSeriesId")]
    pub time_series_id: TimeSeriesId,
    #[serde(rename = "searchSpan")]
    pub search_span: DateTimeRange,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<Tsx>,
    #[serde(rename = "projectedProperties", default, skip_serializing_if = "Vec::is_empty")]
    pub projected_properties: Vec<EventProperty>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub take: Option<i32>,
}
impl GetEvents {
    pub fn new(time_series_id: TimeSeriesId, search_span: DateTimeRange) -> Self {
        Self {
            time_series_id,
            search_span,
            filter: None,
            projected_properties: Vec::new(),
            take: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GetHierarchiesPage {
    #[serde(flatten)]
    pub paged_response: PagedResponse,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hierarchies: Vec<TimeSeriesHierarchy>,
}
impl GetHierarchiesPage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GetInstancesPage {
    #[serde(flatten)]
    pub paged_response: PagedResponse,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub instances: Vec<TimeSeriesInstance>,
}
impl GetInstancesPage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetSeries {
    #[serde(rename = "timeSeriesId")]
    pub time_series_id: TimeSeriesId,
    #[serde(rename = "searchSpan")]
    pub search_span: DateTimeRange,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<Tsx>,
    #[serde(rename = "projectedVariables", default, skip_serializing_if = "Vec::is_empty")]
    pub projected_variables: Vec<String>,
    #[serde(rename = "inlineVariables", default, skip_serializing_if = "Option::is_none")]
    pub inline_variables: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub take: Option<i32>,
}
impl GetSeries {
    pub fn new(time_series_id: TimeSeriesId, search_span: DateTimeRange) -> Self {
        Self {
            time_series_id,
            search_span,
            filter: None,
            projected_variables: Vec::new(),
            inline_variables: None,
            take: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GetTypesPage {
    #[serde(flatten)]
    pub paged_response: PagedResponse,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub types: Vec<TimeSeriesType>,
}
impl GetTypesPage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HierarchiesBatchRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub get: Option<HierarchiesRequestBatchGetDelete>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub put: Vec<TimeSeriesHierarchy>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub delete: Option<HierarchiesRequestBatchGetDelete>,
}
impl HierarchiesBatchRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HierarchiesBatchResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub get: Vec<TimeSeriesHierarchyOrError>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub put: Vec<TimeSeriesHierarchyOrError>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub delete: Vec<TsiErrorBody>,
}
impl HierarchiesBatchResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HierarchiesExpandParameter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<hierarchies_expand_parameter::Kind>,
}
impl HierarchiesExpandParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod hierarchies_expand_parameter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        UntilChildren,
        OneLevel,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HierarchiesRequestBatchGetDelete {
    #[serde(rename = "hierarchyIds", default, skip_serializing_if = "Vec::is_empty")]
    pub hierarchy_ids: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub names: Vec<String>,
}
impl HierarchiesRequestBatchGetDelete {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HierarchiesSortParameter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub by: Option<hierarchies_sort_parameter::By>,
}
impl HierarchiesSortParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod hierarchies_sort_parameter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum By {
        CumulativeInstanceCount,
        Name,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HierarchyHit {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "cumulativeInstanceCount", default, skip_serializing_if = "Option::is_none")]
    pub cumulative_instance_count: Option<i32>,
    #[serde(rename = "hierarchyNodes", default, skip_serializing_if = "Option::is_none")]
    pub hierarchy_nodes: Option<SearchHierarchyNodesResponse>,
}
impl HierarchyHit {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstanceHit {
    #[serde(rename = "timeSeriesId", default, skip_serializing_if = "Option::is_none")]
    pub time_series_id: Option<TimeSeriesId>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "typeId", default, skip_serializing_if = "Option::is_none")]
    pub type_id: Option<String>,
    #[serde(rename = "hierarchyIds", default, skip_serializing_if = "Vec::is_empty")]
    pub hierarchy_ids: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub highlights: Option<instance_hit::Highlights>,
}
impl InstanceHit {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod instance_hit {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Highlights {
        #[serde(rename = "timeSeriesId", default, skip_serializing_if = "Vec::is_empty")]
        pub time_series_id: Vec<String>,
        #[serde(rename = "typeName", default, skip_serializing_if = "Option::is_none")]
        pub type_name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub description: Option<String>,
        #[serde(rename = "hierarchyIds", default, skip_serializing_if = "Vec::is_empty")]
        pub hierarchy_ids: Vec<String>,
        #[serde(rename = "hierarchyNames", default, skip_serializing_if = "Vec::is_empty")]
        pub hierarchy_names: Vec<String>,
        #[serde(rename = "instanceFieldNames", default, skip_serializing_if = "Vec::is_empty")]
        pub instance_field_names: Vec<String>,
        #[serde(rename = "instanceFieldValues", default, skip_serializing_if = "Vec::is_empty")]
        pub instance_field_values: Vec<String>,
    }
    impl Highlights {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstanceOrError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub instance: Option<TimeSeriesInstance>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<TsiErrorBody>,
}
impl InstanceOrError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstancesBatchRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub get: Option<InstancesRequestBatchGetOrDelete>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub put: Vec<TimeSeriesInstance>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub update: Vec<TimeSeriesInstance>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub delete: Option<InstancesRequestBatchGetOrDelete>,
}
impl InstancesBatchRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstancesBatchResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub get: Vec<InstanceOrError>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub put: Vec<InstanceOrError>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub update: Vec<InstanceOrError>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub delete: Vec<TsiErrorBody>,
}
impl InstancesBatchResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstancesRequestBatchGetOrDelete {
    #[serde(rename = "timeSeriesIds", default, skip_serializing_if = "Vec::is_empty")]
    pub time_series_ids: Vec<TimeSeriesId>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub names: Vec<String>,
}
impl InstancesRequestBatchGetOrDelete {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstancesSearchStringSuggestion {
    #[serde(rename = "searchString", default, skip_serializing_if = "Option::is_none")]
    pub search_string: Option<String>,
    #[serde(rename = "highlightedSearchString", default, skip_serializing_if = "Option::is_none")]
    pub highlighted_search_string: Option<String>,
}
impl InstancesSearchStringSuggestion {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstancesSortParameter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub by: Option<instances_sort_parameter::By>,
}
impl InstancesSortParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod instances_sort_parameter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum By {
        Rank,
        DisplayName,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InstancesSuggestRequest {
    #[serde(rename = "searchString")]
    pub search_string: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub take: Option<i32>,
}
impl InstancesSuggestRequest {
    pub fn new(search_string: String) -> Self {
        Self { search_string, take: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InstancesSuggestResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub suggestions: Vec<InstancesSearchStringSuggestion>,
}
impl InstancesSuggestResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Interpolation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<interpolation::Kind>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub boundary: Option<interpolation::Boundary>,
}
impl Interpolation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod interpolation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Linear,
        Step,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Boundary {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub span: Option<String>,
    }
    impl Boundary {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ModelSettingsResponse {
    #[serde(rename = "modelSettings", default, skip_serializing_if = "Option::is_none")]
    pub model_settings: Option<TimeSeriesModelSettings>,
}
impl ModelSettingsResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NumericVariable {
    #[serde(flatten)]
    pub variable: Variable,
    pub value: Tsx,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interpolation: Option<Interpolation>,
    pub aggregation: Tsx,
}
impl NumericVariable {
    pub fn new(variable: Variable, value: Tsx, aggregation: Tsx) -> Self {
        Self {
            variable,
            value,
            interpolation: None,
            aggregation,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PagedResponse {
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl PagedResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PropertyType {
    Bool,
    DateTime,
    Double,
    String,
    TimeSpan,
    Long,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PropertyValues {
    #[serde(flatten)]
    pub event_property: EventProperty,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<serde_json::Value>,
}
impl PropertyValues {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryRequest {
    #[serde(rename = "getEvents", default, skip_serializing_if = "Option::is_none")]
    pub get_events: Option<GetEvents>,
    #[serde(rename = "getSeries", default, skip_serializing_if = "Option::is_none")]
    pub get_series: Option<GetSeries>,
    #[serde(rename = "aggregateSeries", default, skip_serializing_if = "Option::is_none")]
    pub aggregate_series: Option<AggregateSeries>,
}
impl QueryRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryResultPage {
    #[serde(flatten)]
    pub paged_response: PagedResponse,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub timestamps: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub properties: Vec<PropertyValues>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub progress: Option<f64>,
}
impl QueryResultPage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SearchHierarchyNodesResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hits: Vec<HierarchyHit>,
    #[serde(rename = "hitCount", default, skip_serializing_if = "Option::is_none")]
    pub hit_count: Option<i32>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl SearchHierarchyNodesResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SearchInstancesHierarchiesParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expand: Option<HierarchiesExpandParameter>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sort: Option<HierarchiesSortParameter>,
    #[serde(rename = "pageSize", default, skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i32>,
}
impl SearchInstancesHierarchiesParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SearchInstancesParameters {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sort: Option<InstancesSortParameter>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub highlights: Option<bool>,
    #[serde(rename = "pageSize", default, skip_serializing_if = "Option::is_none")]
    pub page_size: Option<i32>,
}
impl SearchInstancesParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SearchInstancesRequest {
    #[serde(rename = "searchString")]
    pub search_string: String,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub path: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub instances: Option<SearchInstancesParameters>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub hierarchies: Option<SearchInstancesHierarchiesParameters>,
}
impl SearchInstancesRequest {
    pub fn new(search_string: String) -> Self {
        Self {
            search_string,
            path: Vec::new(),
            instances: None,
            hierarchies: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SearchInstancesResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hits: Vec<InstanceHit>,
    #[serde(rename = "hitCount", default, skip_serializing_if = "Option::is_none")]
    pub hit_count: Option<i32>,
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl SearchInstancesResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SearchInstancesResponsePage {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub instances: Option<SearchInstancesResponse>,
    #[serde(rename = "hierarchyNodes", default, skip_serializing_if = "Option::is_none")]
    pub hierarchy_nodes: Option<SearchHierarchyNodesResponse>,
}
impl SearchInstancesResponsePage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TimeSeriesAggregateCategory {
    pub label: String,
    pub values: Vec<serde_json::Value>,
}
impl TimeSeriesAggregateCategory {
    pub fn new(label: String, values: Vec<serde_json::Value>) -> Self {
        Self { label, values }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TimeSeriesDefaultCategory {
    pub label: String,
}
impl TimeSeriesDefaultCategory {
    pub fn new(label: String) -> Self {
        Self { label }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TimeSeriesHierarchy {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    pub name: String,
    pub source: time_series_hierarchy::Source,
}
impl TimeSeriesHierarchy {
    pub fn new(name: String, source: time_series_hierarchy::Source) -> Self {
        Self { id: None, name, source }
    }
}
pub mod time_series_hierarchy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Source {
        #[serde(rename = "instanceFieldNames", default, skip_serializing_if = "Vec::is_empty")]
        pub instance_field_names: Vec<String>,
    }
    impl Source {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TimeSeriesHierarchyOrError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub hierarchy: Option<TimeSeriesHierarchy>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<TsiErrorBody>,
}
impl TimeSeriesHierarchyOrError {
    pub fn new() -> Self {
        Self::default()
    }
}
pub type TimeSeriesId = Vec<serde_json::Value>;
pub type TimeSeriesIdProperties = Vec<TimeSeriesIdProperty>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TimeSeriesIdProperty {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<time_series_id_property::Type>,
}
impl TimeSeriesIdProperty {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod time_series_id_property {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        String,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TimeSeriesInstance {
    #[serde(rename = "timeSeriesId")]
    pub time_series_id: TimeSeriesId,
    #[serde(rename = "typeId")]
    pub type_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "hierarchyIds", default, skip_serializing_if = "Vec::is_empty")]
    pub hierarchy_ids: Vec<String>,
    #[serde(rename = "instanceFields", default, skip_serializing_if = "Option::is_none")]
    pub instance_fields: Option<serde_json::Value>,
}
impl TimeSeriesInstance {
    pub fn new(time_series_id: TimeSeriesId, type_id: String) -> Self {
        Self {
            time_series_id,
            type_id,
            name: None,
            description: None,
            hierarchy_ids: Vec::new(),
            instance_fields: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TimeSeriesModelSettings {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "timeSeriesIdProperties", default, skip_serializing_if = "Option::is_none")]
    pub time_series_id_properties: Option<TimeSeriesIdProperties>,
    #[serde(rename = "defaultTypeId", default, skip_serializing_if = "Option::is_none")]
    pub default_type_id: Option<String>,
}
impl TimeSeriesModelSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TimeSeriesType {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    pub variables: serde_json::Value,
}
impl TimeSeriesType {
    pub fn new(name: String, variables: serde_json::Value) -> Self {
        Self {
            id: None,
            name,
            description: None,
            variables,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TimeSeriesTypeOrError {
    #[serde(rename = "timeSeriesType", default, skip_serializing_if = "Option::is_none")]
    pub time_series_type: Option<TimeSeriesType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<TsiErrorBody>,
}
impl TimeSeriesTypeOrError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TsiError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<TsiErrorBody>,
}
impl TsiError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TsiErrorBody {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(rename = "innerError", default, skip_serializing_if = "Option::is_none")]
    pub inner_error: Box<Option<TsiErrorBody>>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<TsiErrorDetails>,
}
impl TsiErrorBody {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TsiErrorDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl TsiErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Tsx {
    pub tsx: String,
}
impl Tsx {
    pub fn new(tsx: String) -> Self {
        Self { tsx }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TypesBatchRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub get: Option<TypesRequestBatchGetOrDelete>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub put: Vec<TimeSeriesType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub delete: Option<TypesRequestBatchGetOrDelete>,
}
impl TypesBatchRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TypesBatchResponse {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub get: Vec<TimeSeriesTypeOrError>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub put: Vec<TimeSeriesTypeOrError>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub delete: Vec<TsiErrorBody>,
}
impl TypesBatchResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TypesRequestBatchGetOrDelete {
    #[serde(rename = "typeIds", default, skip_serializing_if = "Vec::is_empty")]
    pub type_ids: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub names: Vec<String>,
}
impl TypesRequestBatchGetOrDelete {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateModelSettingsRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "defaultTypeId", default, skip_serializing_if = "Option::is_none")]
    pub default_type_id: Option<String>,
}
impl UpdateModelSettingsRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Variable {
    pub kind: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<Tsx>,
}
impl Variable {
    pub fn new(kind: String) -> Self {
        Self { kind, filter: None }
    }
}
