#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "The object that defines the structure of an Azure Synapse error response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloudError {
    #[doc = "The object that defines the structure of an Azure Synapse error."]
    pub error: CloudErrorBody,
}
impl CloudError {
    pub fn new(error: CloudErrorBody) -> Self {
        Self { error }
    }
}
#[doc = "The object that defines the structure of an Azure Synapse error."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloudErrorBody {
    #[doc = "Error code."]
    pub code: String,
    #[doc = "Error message."]
    pub message: String,
    #[doc = "Property name/path in request associated with error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "Array with additional error details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudError>,
}
impl CloudErrorBody {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            target: None,
            details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EditTablesRequest {
    #[doc = "Edit link tables request"]
    #[serde(rename = "linkTables", default, skip_serializing_if = "Vec::is_empty")]
    pub link_tables: Vec<LinkTableRequest>,
}
impl EditTablesRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkConnection {
    #[serde(rename = "sourceDatabase", default, skip_serializing_if = "Option::is_none")]
    pub source_database: Option<LinkConnectionSourceDatabase>,
    #[serde(rename = "targetDatabase", default, skip_serializing_if = "Option::is_none")]
    pub target_database: Option<LinkConnectionTargetDatabase>,
    #[serde(rename = "landingZone", default, skip_serializing_if = "Option::is_none")]
    pub landing_zone: Option<LinkConnectionLandingZone>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compute: Option<LinkConnectionCompute>,
}
impl LinkConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkConnectionCompute {
    #[doc = "Link connection's compute core count"]
    #[serde(rename = "coreCount", default, skip_serializing_if = "Option::is_none")]
    pub core_count: Option<i64>,
    #[doc = "Link connection's compute type"]
    #[serde(rename = "computeType", default, skip_serializing_if = "Option::is_none")]
    pub compute_type: Option<String>,
}
impl LinkConnectionCompute {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkConnectionDetailedStatus {
    #[doc = "Link connection id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Link connection name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Is link connection applying changes"]
    #[serde(rename = "isApplyingChanges", default, skip_serializing_if = "Option::is_none")]
    pub is_applying_changes: Option<bool>,
    #[doc = "Is link connection partially failed"]
    #[serde(rename = "isPartiallyFailed", default, skip_serializing_if = "Option::is_none")]
    pub is_partially_failed: Option<bool>,
    #[doc = "Link connection start time"]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<serde_json::Value>,
    #[doc = "Link connection stop time"]
    #[serde(rename = "stopTime", default, skip_serializing_if = "Option::is_none")]
    pub stop_time: Option<serde_json::Value>,
    #[doc = "Link connection status"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "Link connection's corresponding continuous run id"]
    #[serde(rename = "continuousRunId", default, skip_serializing_if = "Option::is_none")]
    pub continuous_run_id: Option<String>,
    #[doc = "Link connection error"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<serde_json::Value>,
}
impl LinkConnectionDetailedStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkConnectionLandingZone {
    #[doc = "Linked service reference type."]
    #[serde(rename = "linkedService", default, skip_serializing_if = "Option::is_none")]
    pub linked_service: Option<LinkedServiceReference>,
    #[doc = "Landing zone's file system name"]
    #[serde(rename = "fileSystem", default, skip_serializing_if = "Option::is_none")]
    pub file_system: Option<String>,
    #[doc = "Landing zone's folder path name"]
    #[serde(rename = "folderPath", default, skip_serializing_if = "Option::is_none")]
    pub folder_path: Option<String>,
    #[doc = "Azure Synapse secure string definition. The string value will be masked with asterisks '*' during Get or List API calls."]
    #[serde(rename = "sasToken", default, skip_serializing_if = "Option::is_none")]
    pub sas_token: Option<SecureString>,
}
impl LinkConnectionLandingZone {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkConnectionListResponse {
    #[doc = "List link connection value"]
    pub value: Vec<LinkConnectionResource>,
    #[doc = "List link connections next link"]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LinkConnectionListResponse {
    pub fn new(value: Vec<LinkConnectionResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkConnectionQueryTableStatus {
    #[doc = "Link tables' status"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LinkTableStatus>,
    #[doc = "Continuation token to query table status"]
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<serde_json::Value>,
}
impl LinkConnectionQueryTableStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkConnectionResource {
    #[doc = "Link connection id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Link connection name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Link connection type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    pub properties: LinkConnection,
}
impl LinkConnectionResource {
    pub fn new(properties: LinkConnection) -> Self {
        Self {
            id: None,
            name: None,
            type_: None,
            properties,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkConnectionSourceDatabase {
    #[doc = "Linked service reference type."]
    #[serde(rename = "linkedService", default, skip_serializing_if = "Option::is_none")]
    pub linked_service: Option<LinkedServiceReference>,
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<LinkConnectionSourceDatabaseTypeProperties>,
}
impl LinkConnectionSourceDatabase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkConnectionSourceDatabaseTypeProperties {
    #[doc = "Link connection source database server's resource id"]
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[doc = "Link connection source database server's principal id"]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
}
impl LinkConnectionSourceDatabaseTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkConnectionTargetDatabase {
    #[doc = "Linked service reference type."]
    #[serde(rename = "linkedService", default, skip_serializing_if = "Option::is_none")]
    pub linked_service: Option<LinkedServiceReference>,
}
impl LinkConnectionTargetDatabase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkTableListResponse {
    #[doc = "List link table value"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<LinkTableResource>,
}
impl LinkTableListResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkTableRequest {
    #[doc = "Link table id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<LinkTableRequestSource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<LinkTableRequestTarget>,
    #[doc = "Link table operation type"]
    #[serde(rename = "operationType", default, skip_serializing_if = "Option::is_none")]
    pub operation_type: Option<String>,
}
impl LinkTableRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkTableRequestSource {
    #[doc = "Source table table name"]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<String>,
    #[doc = "Source table schema name"]
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
}
impl LinkTableRequestSource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkTableRequestTarget {
    #[doc = "Target table table name"]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<String>,
    #[doc = "Target table schema name"]
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
    #[serde(rename = "distributionOptions", default, skip_serializing_if = "Option::is_none")]
    pub distribution_options: Option<LinkTableRequestTargetDistributionOptions>,
}
impl LinkTableRequestTarget {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkTableRequestTargetDistributionOptions {
    #[doc = "Target table distribution type"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Target table distribution column"]
    #[serde(rename = "distributionColumn", default, skip_serializing_if = "Option::is_none")]
    pub distribution_column: Option<String>,
}
impl LinkTableRequestTargetDistributionOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkTableResource {
    #[doc = "Link table id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Link table name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<LinkTableRequestSource>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<LinkTableRequestTarget>,
}
impl LinkTableResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinkTableStatus {
    #[doc = "Link table id"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "Link table status"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "Link table error message"]
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[doc = "Link table start time"]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<serde_json::Value>,
    #[doc = "Link table stop time"]
    #[serde(rename = "stopTime", default, skip_serializing_if = "Option::is_none")]
    pub stop_time: Option<serde_json::Value>,
}
impl LinkTableStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Linked service reference type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkedServiceReference {
    #[doc = "Linked service reference type."]
    #[serde(rename = "type")]
    pub type_: linked_service_reference::Type,
    #[doc = "Reference LinkedService name."]
    #[serde(rename = "referenceName")]
    pub reference_name: String,
    #[doc = "An object mapping parameter names to argument values."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterValueSpecification>,
}
impl LinkedServiceReference {
    pub fn new(type_: linked_service_reference::Type, reference_name: String) -> Self {
        Self {
            type_,
            reference_name,
            parameters: None,
        }
    }
}
pub mod linked_service_reference {
    use super::*;
    #[doc = "Linked service reference type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        LinkedServiceReference,
    }
}
#[doc = "An object mapping parameter names to argument values."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ParameterValueSpecification {}
impl ParameterValueSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryTableStatusRequest {
    #[doc = "Max segment count to query table status"]
    #[serde(rename = "maxSegmentCount", default, skip_serializing_if = "Option::is_none")]
    pub max_segment_count: Option<i64>,
    #[doc = "Continuation token to query table status"]
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<serde_json::Value>,
}
impl QueryTableStatusRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The base definition of a secret type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecretBase {
    #[doc = "Type of the secret."]
    #[serde(rename = "type")]
    pub type_: String,
}
impl SecretBase {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[doc = "Azure Synapse secure string definition. The string value will be masked with asterisks '*' during Get or List API calls."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecureString {
    #[serde(flatten)]
    pub secret_base: SecretBase,
    #[doc = "Value of secure string."]
    pub value: String,
}
impl SecureString {
    pub fn new(secret_base: SecretBase, value: String) -> Self {
        Self { secret_base, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UpdateLandingZoneCredential {
    #[doc = "Azure Synapse secure string definition. The string value will be masked with asterisks '*' during Get or List API calls."]
    #[serde(rename = "sasToken", default, skip_serializing_if = "Option::is_none")]
    pub sas_token: Option<SecureString>,
}
impl UpdateLandingZoneCredential {
    pub fn new() -> Self {
        Self::default()
    }
}
