#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "A pipeline activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Activity {
    #[doc = "Activity name."]
    pub name: String,
    #[doc = "Type of activity."]
    #[serde(rename = "type")]
    pub type_: String,
    #[doc = "Activity description."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Activity depends on condition."]
    #[serde(rename = "dependsOn", default, skip_serializing_if = "Vec::is_empty")]
    pub depends_on: Vec<ActivityDependency>,
    #[doc = "Activity user properties."]
    #[serde(rename = "userProperties", default, skip_serializing_if = "Vec::is_empty")]
    pub user_properties: Vec<UserProperty>,
}
impl Activity {
    pub fn new(name: String, type_: String) -> Self {
        Self {
            name,
            type_,
            description: None,
            depends_on: Vec::new(),
            user_properties: Vec::new(),
        }
    }
}
#[doc = "Activity dependency information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActivityDependency {
    #[doc = "Activity name."]
    pub activity: String,
    #[doc = "Match-Condition for the dependency."]
    #[serde(rename = "dependencyConditions")]
    pub dependency_conditions: Vec<String>,
}
impl ActivityDependency {
    pub fn new(activity: String, dependency_conditions: Vec<String>) -> Self {
        Self {
            activity,
            dependency_conditions,
        }
    }
}
#[doc = "Execution policy for an activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActivityPolicy {
    #[doc = "Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<serde_json::Value>,
    #[doc = "Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub retry: Option<serde_json::Value>,
    #[doc = "Interval between each retry attempt (in seconds). The default is 30 sec."]
    #[serde(rename = "retryIntervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub retry_interval_in_seconds: Option<i64>,
    #[doc = "When set to true, Input from activity is considered as secure and will not be logged to monitoring."]
    #[serde(rename = "secureInput", default, skip_serializing_if = "Option::is_none")]
    pub secure_input: Option<bool>,
    #[doc = "When set to true, Output from activity is considered as secure and will not be logged to monitoring."]
    #[serde(rename = "secureOutput", default, skip_serializing_if = "Option::is_none")]
    pub secure_output: Option<bool>,
}
impl ActivityPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Information about an activity run in a pipeline."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ActivityRun {
    #[doc = "The name of the pipeline."]
    #[serde(rename = "pipelineName", default, skip_serializing_if = "Option::is_none")]
    pub pipeline_name: Option<String>,
    #[doc = "The id of the pipeline run."]
    #[serde(rename = "pipelineRunId", default, skip_serializing_if = "Option::is_none")]
    pub pipeline_run_id: Option<String>,
    #[doc = "The name of the activity."]
    #[serde(rename = "activityName", default, skip_serializing_if = "Option::is_none")]
    pub activity_name: Option<String>,
    #[doc = "The type of the activity."]
    #[serde(rename = "activityType", default, skip_serializing_if = "Option::is_none")]
    pub activity_type: Option<String>,
    #[doc = "The id of the activity run."]
    #[serde(rename = "activityRunId", default, skip_serializing_if = "Option::is_none")]
    pub activity_run_id: Option<String>,
    #[doc = "The name of the compute linked service."]
    #[serde(rename = "linkedServiceName", default, skip_serializing_if = "Option::is_none")]
    pub linked_service_name: Option<String>,
    #[doc = "The status of the activity run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "The start time of the activity run in 'ISO 8601' format."]
    #[serde(rename = "activityRunStart", default, skip_serializing_if = "Option::is_none")]
    pub activity_run_start: Option<String>,
    #[doc = "The end time of the activity run in 'ISO 8601' format."]
    #[serde(rename = "activityRunEnd", default, skip_serializing_if = "Option::is_none")]
    pub activity_run_end: Option<String>,
    #[doc = "The duration of the activity run."]
    #[serde(rename = "durationInMs", default, skip_serializing_if = "Option::is_none")]
    pub duration_in_ms: Option<i64>,
    #[doc = "The input for the activity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub input: Option<serde_json::Value>,
    #[doc = "The output for the activity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub output: Option<serde_json::Value>,
    #[doc = "The error if any from the activity run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<serde_json::Value>,
}
impl ActivityRun {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list activity runs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ActivityRunsQueryResponse {
    #[doc = "List of activity runs."]
    pub value: Vec<ActivityRun>,
    #[doc = "The continuation token for getting the next page of results, if any remaining results exist, null otherwise."]
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl ActivityRunsQueryResponse {
    pub fn new(value: Vec<ActivityRun>) -> Self {
        Self {
            value,
            continuation_token: None,
        }
    }
}
#[doc = "Response body structure for starting data flow debug session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AddDataFlowToDebugSessionResponse {
    #[doc = "The ID of data flow debug job version."]
    #[serde(rename = "jobVersion", default, skip_serializing_if = "Option::is_none")]
    pub job_version: Option<String>,
}
impl AddDataFlowToDebugSessionResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Specify the column name and value of additional columns."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdditionalColumns {
    #[doc = "Additional column name. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<serde_json::Value>,
    #[doc = "Additional column value. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<serde_json::Value>,
}
impl AdditionalColumns {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Amazon Marketplace Web Service linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonMwsLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Amazon Marketplace Web Service linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AmazonMwsLinkedServiceTypeProperties,
}
impl AmazonMwsLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AmazonMwsLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Amazon Marketplace Web Service linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonMwsLinkedServiceTypeProperties {
    #[doc = "The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com)"]
    pub endpoint: serde_json::Value,
    #[doc = "The Amazon Marketplace ID you want to retrieve data from. To retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e. A2EUQ1WTGCTBG2)"]
    #[serde(rename = "marketplaceID")]
    pub marketplace_id: serde_json::Value,
    #[doc = "The Amazon seller ID."]
    #[serde(rename = "sellerID")]
    pub seller_id: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "mwsAuthToken", default, skip_serializing_if = "Option::is_none")]
    pub mws_auth_token: Option<SecretBase>,
    #[doc = "The access key id used to access data."]
    #[serde(rename = "accessKeyId")]
    pub access_key_id: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "secretKey", default, skip_serializing_if = "Option::is_none")]
    pub secret_key: Option<SecretBase>,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[doc = "Specifies whether to verify the identity of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AmazonMwsLinkedServiceTypeProperties {
    pub fn new(
        endpoint: serde_json::Value,
        marketplace_id: serde_json::Value,
        seller_id: serde_json::Value,
        access_key_id: serde_json::Value,
    ) -> Self {
        Self {
            endpoint,
            marketplace_id,
            seller_id,
            mws_auth_token: None,
            access_key_id,
            secret_key: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Amazon Marketplace Web Service dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonMwsObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl AmazonMwsObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Amazon Marketplace Web Service source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonMwsSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl AmazonMwsSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Linked service for Amazon Redshift."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonRedshiftLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Amazon Redshift linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AmazonRedshiftLinkedServiceTypeProperties,
}
impl AmazonRedshiftLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AmazonRedshiftLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Amazon Redshift linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonRedshiftLinkedServiceTypeProperties {
    #[doc = "The name of the Amazon Redshift server. Type: string (or Expression with resultType string)."]
    pub server: serde_json::Value,
    #[doc = "The username of the Amazon Redshift source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The database name of the Amazon Redshift source. Type: string (or Expression with resultType string)."]
    pub database: serde_json::Value,
    #[doc = "The TCP port number that the Amazon Redshift server uses to listen for client connections. The default value is 5439. Type: integer (or Expression with resultType integer)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AmazonRedshiftLinkedServiceTypeProperties {
    pub fn new(server: serde_json::Value, database: serde_json::Value) -> Self {
        Self {
            server,
            username: None,
            password: None,
            database,
            port: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "A copy activity source for Amazon Redshift Source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonRedshiftSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "Database query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3."]
    #[serde(rename = "redshiftUnloadSettings", default, skip_serializing_if = "Option::is_none")]
    pub redshift_unload_settings: Option<RedshiftUnloadSettings>,
}
impl AmazonRedshiftSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            redshift_unload_settings: None,
        }
    }
}
#[doc = "The Amazon Redshift table dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonRedshiftTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Amazon Redshift table dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AmazonRedshiftTableDatasetTypeProperties>,
}
impl AmazonRedshiftTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Amazon Redshift table dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonRedshiftTableDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The Amazon Redshift table name. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[doc = "The Amazon Redshift schema name. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl AmazonRedshiftTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A single Amazon Simple Storage Service (S3) object or a set of S3 objects."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3Dataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Amazon S3 dataset properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AmazonS3DatasetTypeProperties,
}
impl AmazonS3Dataset {
    pub fn new(dataset: Dataset, type_properties: AmazonS3DatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "Amazon S3 dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3DatasetTypeProperties {
    #[doc = "The name of the Amazon S3 bucket. Type: string (or Expression with resultType string)."]
    #[serde(rename = "bucketName")]
    pub bucket_name: serde_json::Value,
    #[doc = "The key of the Amazon S3 object. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<serde_json::Value>,
    #[doc = "The prefix filter for the S3 object name. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prefix: Option<serde_json::Value>,
    #[doc = "The version for the S3 object. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<serde_json::Value>,
    #[doc = "The start of S3 object's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[doc = "The end of S3 object's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
    #[doc = "The format definition of a storage."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<DatasetStorageFormat>,
    #[doc = "The compression method used on a dataset."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl AmazonS3DatasetTypeProperties {
    pub fn new(bucket_name: serde_json::Value) -> Self {
        Self {
            bucket_name,
            key: None,
            prefix: None,
            version: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
            format: None,
            compression: None,
        }
    }
}
#[doc = "Linked service for Amazon S3."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3LinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Amazon S3 linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AmazonS3LinkedServiceTypeProperties,
}
impl AmazonS3LinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AmazonS3LinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Amazon S3 linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonS3LinkedServiceTypeProperties {
    #[doc = "The authentication type of S3. Allowed value: AccessKey (default) or TemporarySecurityCredentials. Type: string (or Expression with resultType string)."]
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<serde_json::Value>,
    #[doc = "The access key identifier of the Amazon S3 Identity and Access Management (IAM) user. Type: string (or Expression with resultType string)."]
    #[serde(rename = "accessKeyId", default, skip_serializing_if = "Option::is_none")]
    pub access_key_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "secretAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub secret_access_key: Option<SecretBase>,
    #[doc = "This value specifies the endpoint to access with the S3 Connector. This is an optional property; change it only if you want to try a different service endpoint or want to switch between https and http. Type: string (or Expression with resultType string)."]
    #[serde(rename = "serviceUrl", default, skip_serializing_if = "Option::is_none")]
    pub service_url: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "sessionToken", default, skip_serializing_if = "Option::is_none")]
    pub session_token: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AmazonS3LinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The location of amazon S3 dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3Location {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
    #[doc = "Specify the bucketName of amazon S3. Type: string (or Expression with resultType string)"]
    #[serde(rename = "bucketName", default, skip_serializing_if = "Option::is_none")]
    pub bucket_name: Option<serde_json::Value>,
    #[doc = "Specify the version of amazon S3. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<serde_json::Value>,
}
impl AmazonS3Location {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self {
            dataset_location,
            bucket_name: None,
            version: None,
        }
    }
}
#[doc = "Azure data lake store read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3ReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[doc = "If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[doc = "AmazonS3 wildcardFolderPath. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[doc = "AmazonS3 wildcardFileName. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[doc = "The prefix filter for the S3 object name. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prefix: Option<serde_json::Value>,
    #[doc = "Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[doc = "Indicates whether to enable partition discovery."]
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[doc = "Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[doc = "Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[doc = "The start of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[doc = "The end of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
}
impl AmazonS3ReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            prefix: None,
            file_list_path: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
        }
    }
}
#[doc = "Append value for a Variable of type Array."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppendVariableActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[doc = "AppendVariable activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AppendVariableActivityTypeProperties,
}
impl AppendVariableActivity {
    pub fn new(control_activity: ControlActivity, type_properties: AppendVariableActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[doc = "AppendVariable activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppendVariableActivityTypeProperties {
    #[doc = "Name of the variable whose value needs to be appended to."]
    #[serde(rename = "variableName", default, skip_serializing_if = "Option::is_none")]
    pub variable_name: Option<String>,
    #[doc = "Value to be appended. Could be a static value or Expression"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<serde_json::Value>,
}
impl AppendVariableActivityTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Request body structure for rename artifact."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ArtifactRenameRequest {
    #[doc = "New name of the artifact."]
    #[serde(rename = "newName", default, skip_serializing_if = "Option::is_none")]
    pub new_name: Option<String>,
}
impl ArtifactRenameRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Auto-pausing properties of a Big Data pool powered by Apache Spark"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoPauseProperties {
    #[doc = "Number of minutes of idle time before the Big Data pool is automatically paused."]
    #[serde(rename = "delayInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub delay_in_minutes: Option<i32>,
    #[doc = "Whether auto-pausing is enabled for the Big Data pool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl AutoPauseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Auto-scaling properties of a Big Data pool powered by Apache Spark"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoScaleProperties {
    #[doc = "The minimum number of nodes the Big Data pool can support."]
    #[serde(rename = "minNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub min_node_count: Option<i32>,
    #[doc = "Whether automatic scaling is enabled for the Big Data pool."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[doc = "The maximum number of nodes the Big Data pool can support."]
    #[serde(rename = "maxNodeCount", default, skip_serializing_if = "Option::is_none")]
    pub max_node_count: Option<i32>,
}
impl AutoScaleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AvroCompressionCodecEnum {
    #[serde(rename = "none")]
    None,
    #[serde(rename = "deflate")]
    Deflate,
    #[serde(rename = "snappy")]
    Snappy,
    #[serde(rename = "xz")]
    Xz,
    #[serde(rename = "bzip2")]
    Bzip2,
}
#[doc = "Avro dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvroDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Avro dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AvroDatasetTypeProperties>,
}
impl AvroDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Avro dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvroDatasetTypeProperties {
    #[doc = "Dataset location."]
    pub location: DatasetLocation,
    #[doc = "A string from AvroCompressionCodecEnum or an expression"]
    #[serde(rename = "avroCompressionCodec", default, skip_serializing_if = "Option::is_none")]
    pub avro_compression_codec: Option<serde_json::Value>,
    #[serde(rename = "avroCompressionLevel", default, skip_serializing_if = "Option::is_none")]
    pub avro_compression_level: Option<i64>,
}
impl AvroDatasetTypeProperties {
    pub fn new(location: DatasetLocation) -> Self {
        Self {
            location,
            avro_compression_codec: None,
            avro_compression_level: None,
        }
    }
}
#[doc = "The data stored in Avro format."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvroFormat {
    #[serde(flatten)]
    pub dataset_storage_format: DatasetStorageFormat,
}
impl AvroFormat {
    pub fn new(dataset_storage_format: DatasetStorageFormat) -> Self {
        Self { dataset_storage_format }
    }
}
#[doc = "A copy activity Avro sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvroSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "Connector write settings."]
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreWriteSettings>,
    #[doc = "Avro write settings."]
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<AvroWriteSettings>,
}
impl AvroSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            store_settings: None,
            format_settings: None,
        }
    }
}
#[doc = "A copy activity Avro source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvroSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Connector read setting."]
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl AvroSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            store_settings: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "Avro write settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AvroWriteSettings {
    #[serde(flatten)]
    pub format_write_settings: FormatWriteSettings,
    #[doc = "Top level record name in write result, which is required in AVRO spec."]
    #[serde(rename = "recordName", default, skip_serializing_if = "Option::is_none")]
    pub record_name: Option<String>,
    #[doc = "Record namespace in the write result."]
    #[serde(rename = "recordNamespace", default, skip_serializing_if = "Option::is_none")]
    pub record_namespace: Option<String>,
    #[doc = "Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "maxRowsPerFile", default, skip_serializing_if = "Option::is_none")]
    pub max_rows_per_file: Option<serde_json::Value>,
    #[doc = "Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileNamePrefix", default, skip_serializing_if = "Option::is_none")]
    pub file_name_prefix: Option<serde_json::Value>,
}
impl AvroWriteSettings {
    pub fn new(format_write_settings: FormatWriteSettings) -> Self {
        Self {
            format_write_settings,
            record_name: None,
            record_namespace: None,
            max_rows_per_file: None,
            file_name_prefix: None,
        }
    }
}
#[doc = "Azure Batch linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBatchLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure Batch linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureBatchLinkedServiceTypeProperties,
}
impl AzureBatchLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureBatchLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure Batch linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBatchLinkedServiceTypeProperties {
    #[doc = "The Azure Batch account name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "accountName")]
    pub account_name: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "accessKey", default, skip_serializing_if = "Option::is_none")]
    pub access_key: Option<SecretBase>,
    #[doc = "The Azure Batch URI. Type: string (or Expression with resultType string)."]
    #[serde(rename = "batchUri")]
    pub batch_uri: serde_json::Value,
    #[doc = "The Azure Batch pool name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "poolName")]
    pub pool_name: serde_json::Value,
    #[doc = "Linked service reference type."]
    #[serde(rename = "linkedServiceName")]
    pub linked_service_name: LinkedServiceReference,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureBatchLinkedServiceTypeProperties {
    pub fn new(
        account_name: serde_json::Value,
        batch_uri: serde_json::Value,
        pool_name: serde_json::Value,
        linked_service_name: LinkedServiceReference,
    ) -> Self {
        Self {
            account_name,
            access_key: None,
            batch_uri,
            pool_name,
            linked_service_name,
            encrypted_credential: None,
        }
    }
}
#[doc = "The Azure Blob storage."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Azure Blob dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AzureBlobDatasetTypeProperties>,
}
impl AzureBlobDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Azure Blob dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureBlobDatasetTypeProperties {
    #[doc = "The path of the Azure Blob storage. Type: string (or Expression with resultType string)."]
    #[serde(rename = "folderPath", default, skip_serializing_if = "Option::is_none")]
    pub folder_path: Option<serde_json::Value>,
    #[doc = "The root of blob path. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableRootLocation", default, skip_serializing_if = "Option::is_none")]
    pub table_root_location: Option<serde_json::Value>,
    #[doc = "The name of the Azure Blob. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileName", default, skip_serializing_if = "Option::is_none")]
    pub file_name: Option<serde_json::Value>,
    #[doc = "The start of Azure Blob's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[doc = "The end of Azure Blob's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
    #[doc = "The format definition of a storage."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<DatasetStorageFormat>,
    #[doc = "The compression method used on a dataset."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl AzureBlobDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Azure Data Lake Storage Gen2 storage."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFsDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Azure Data Lake Storage Gen2 dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AzureBlobFsDatasetTypeProperties>,
}
impl AzureBlobFsDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Azure Data Lake Storage Gen2 dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureBlobFsDatasetTypeProperties {
    #[doc = "The path of the Azure Data Lake Storage Gen2 storage. Type: string (or Expression with resultType string)."]
    #[serde(rename = "folderPath", default, skip_serializing_if = "Option::is_none")]
    pub folder_path: Option<serde_json::Value>,
    #[doc = "The name of the Azure Data Lake Storage Gen2. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileName", default, skip_serializing_if = "Option::is_none")]
    pub file_name: Option<serde_json::Value>,
    #[doc = "The format definition of a storage."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<DatasetStorageFormat>,
    #[doc = "The compression method used on a dataset."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl AzureBlobFsDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Data Lake Storage Gen2 linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFsLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure Data Lake Storage Gen2 linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureBlobFsLinkedServiceTypeProperties,
}
impl AzureBlobFsLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureBlobFsLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure Data Lake Storage Gen2 linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFsLinkedServiceTypeProperties {
    #[doc = "Endpoint for the Azure Data Lake Storage Gen2 service. Type: string (or Expression with resultType string)."]
    pub url: serde_json::Value,
    #[doc = "Account key for the Azure Data Lake Storage Gen2 service. Type: string (or Expression with resultType string)."]
    #[serde(rename = "accountKey", default, skip_serializing_if = "Option::is_none")]
    pub account_key: Option<serde_json::Value>,
    #[doc = "The ID of the application used to authenticate against the Azure Data Lake Storage Gen2 account. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[doc = "The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[doc = "Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureBlobFsLinkedServiceTypeProperties {
    pub fn new(url: serde_json::Value) -> Self {
        Self {
            url,
            account_key: None,
            service_principal_id: None,
            service_principal_key: None,
            tenant: None,
            azure_cloud_type: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "The location of azure blobFS dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFsLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
    #[doc = "Specify the fileSystem of azure blobFS. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileSystem", default, skip_serializing_if = "Option::is_none")]
    pub file_system: Option<serde_json::Value>,
}
impl AzureBlobFsLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self {
            dataset_location,
            file_system: None,
        }
    }
}
#[doc = "Azure blobFS read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFsReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[doc = "If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[doc = "Azure blobFS wildcardFolderPath. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[doc = "Azure blobFS wildcardFileName. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[doc = "Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[doc = "Indicates whether to enable partition discovery."]
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[doc = "Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[doc = "Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[doc = "The start of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[doc = "The end of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
}
impl AzureBlobFsReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            file_list_path: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
        }
    }
}
#[doc = "A copy activity Azure Data Lake Storage Gen2 sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFsSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "The type of copy behavior for copy sink."]
    #[serde(rename = "copyBehavior", default, skip_serializing_if = "Option::is_none")]
    pub copy_behavior: Option<serde_json::Value>,
}
impl AzureBlobFsSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            copy_behavior: None,
        }
    }
}
#[doc = "A copy activity Azure BlobFS source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFsSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Treat empty as null. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "treatEmptyAsNull", default, skip_serializing_if = "Option::is_none")]
    pub treat_empty_as_null: Option<serde_json::Value>,
    #[doc = "Number of header lines to skip from each blob. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "skipHeaderLineCount", default, skip_serializing_if = "Option::is_none")]
    pub skip_header_line_count: Option<serde_json::Value>,
    #[doc = "If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
}
impl AzureBlobFsSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            treat_empty_as_null: None,
            skip_header_line_count: None,
            recursive: None,
        }
    }
}
#[doc = "Azure blobFS write settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobFsWriteSettings {
    #[serde(flatten)]
    pub store_write_settings: StoreWriteSettings,
    #[doc = "Indicates the block size(MB) when writing data to blob. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "blockSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub block_size_in_mb: Option<serde_json::Value>,
}
impl AzureBlobFsWriteSettings {
    pub fn new(store_write_settings: StoreWriteSettings) -> Self {
        Self {
            store_write_settings,
            block_size_in_mb: None,
        }
    }
}
#[doc = "The azure blob storage linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobStorageLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure Blob Storage linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureBlobStorageLinkedServiceTypeProperties,
}
impl AzureBlobStorageLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureBlobStorageLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure Blob Storage linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureBlobStorageLinkedServiceTypeProperties {
    #[doc = "The connection string. It is mutually exclusive with sasUri, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(rename = "accountKey", default, skip_serializing_if = "Option::is_none")]
    pub account_key: Option<AzureKeyVaultSecretReference>,
    #[doc = "SAS URI of the Azure Blob Storage resource. It is mutually exclusive with connectionString, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "sasUri", default, skip_serializing_if = "Option::is_none")]
    pub sas_uri: Option<serde_json::Value>,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(rename = "sasToken", default, skip_serializing_if = "Option::is_none")]
    pub sas_token: Option<AzureKeyVaultSecretReference>,
    #[doc = "Blob service endpoint of the Azure Blob Storage resource. It is mutually exclusive with connectionString, sasUri property."]
    #[serde(rename = "serviceEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub service_endpoint: Option<String>,
    #[doc = "The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[doc = "The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[doc = "Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<String>,
}
impl AzureBlobStorageLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The location of azure blob dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobStorageLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
    #[doc = "Specify the container of azure blob. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub container: Option<serde_json::Value>,
}
impl AzureBlobStorageLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self {
            dataset_location,
            container: None,
        }
    }
}
#[doc = "Azure blob read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobStorageReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[doc = "If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[doc = "Azure blob wildcardFolderPath. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[doc = "Azure blob wildcardFileName. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[doc = "The prefix filter for the Azure Blob name. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prefix: Option<serde_json::Value>,
    #[doc = "Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[doc = "Indicates whether to enable partition discovery."]
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[doc = "Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[doc = "Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[doc = "The start of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[doc = "The end of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
}
impl AzureBlobStorageReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            prefix: None,
            file_list_path: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
        }
    }
}
#[doc = "Azure blob write settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureBlobStorageWriteSettings {
    #[serde(flatten)]
    pub store_write_settings: StoreWriteSettings,
    #[doc = "Indicates the block size(MB) when writing data to blob. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "blockSizeInMB", default, skip_serializing_if = "Option::is_none")]
    pub block_size_in_mb: Option<serde_json::Value>,
}
impl AzureBlobStorageWriteSettings {
    pub fn new(store_write_settings: StoreWriteSettings) -> Self {
        Self {
            store_write_settings,
            block_size_in_mb: None,
        }
    }
}
#[doc = "Azure Data Explorer command activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerCommandActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Azure Data Explorer command activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureDataExplorerCommandActivityTypeProperties,
}
impl AzureDataExplorerCommandActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: AzureDataExplorerCommandActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "Azure Data Explorer command activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerCommandActivityTypeProperties {
    #[doc = "A control command, according to the Azure Data Explorer command syntax. Type: string (or Expression with resultType string)."]
    pub command: serde_json::Value,
    #[doc = "Control command timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..)"]
    #[serde(rename = "commandTimeout", default, skip_serializing_if = "Option::is_none")]
    pub command_timeout: Option<serde_json::Value>,
}
impl AzureDataExplorerCommandActivityTypeProperties {
    pub fn new(command: serde_json::Value) -> Self {
        Self {
            command,
            command_timeout: None,
        }
    }
}
#[doc = "Azure Data Explorer (Kusto) dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureDataExplorerDatasetTypeProperties {
    #[doc = "The table name of the Azure Data Explorer database. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl AzureDataExplorerDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Data Explorer (Kusto) linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure Data Explorer (Kusto) linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureDataExplorerLinkedServiceTypeProperties,
}
impl AzureDataExplorerLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureDataExplorerLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure Data Explorer (Kusto) linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerLinkedServiceTypeProperties {
    #[doc = "The endpoint of Azure Data Explorer (the engine's endpoint). URL will be in the format https://<clusterName>.<regionName>.kusto.windows.net. Type: string (or Expression with resultType string)"]
    pub endpoint: serde_json::Value,
    #[doc = "The ID of the service principal used to authenticate against Azure Data Explorer. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId")]
    pub service_principal_id: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalKey")]
    pub service_principal_key: SecretBase,
    #[doc = "Database name for connection. Type: string (or Expression with resultType string)."]
    pub database: serde_json::Value,
    #[doc = "The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string)."]
    pub tenant: serde_json::Value,
}
impl AzureDataExplorerLinkedServiceTypeProperties {
    pub fn new(
        endpoint: serde_json::Value,
        service_principal_id: serde_json::Value,
        service_principal_key: SecretBase,
        database: serde_json::Value,
        tenant: serde_json::Value,
    ) -> Self {
        Self {
            endpoint,
            service_principal_id,
            service_principal_key,
            database,
            tenant,
        }
    }
}
#[doc = "A copy activity Azure Data Explorer sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "A name of a pre-created csv mapping that was defined on the target Kusto table. Type: string."]
    #[serde(rename = "ingestionMappingName", default, skip_serializing_if = "Option::is_none")]
    pub ingestion_mapping_name: Option<serde_json::Value>,
    #[doc = "An explicit column mapping description provided in a json format. Type: string."]
    #[serde(rename = "ingestionMappingAsJson", default, skip_serializing_if = "Option::is_none")]
    pub ingestion_mapping_as_json: Option<serde_json::Value>,
    #[doc = "If set to true, any aggregation will be skipped. Default is false. Type: boolean."]
    #[serde(rename = "flushImmediately", default, skip_serializing_if = "Option::is_none")]
    pub flush_immediately: Option<serde_json::Value>,
}
impl AzureDataExplorerSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            ingestion_mapping_name: None,
            ingestion_mapping_as_json: None,
            flush_immediately: None,
        }
    }
}
#[doc = "A copy activity Azure Data Explorer (Kusto) source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Database query. Should be a Kusto Query Language (KQL) query. Type: string (or Expression with resultType string)."]
    pub query: serde_json::Value,
    #[doc = "The name of the Boolean option that controls whether truncation is applied to result-sets that go beyond a certain row-count limit."]
    #[serde(rename = "noTruncation", default, skip_serializing_if = "Option::is_none")]
    pub no_truncation: Option<serde_json::Value>,
    #[doc = "Query timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).."]
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<serde_json::Value>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl AzureDataExplorerSource {
    pub fn new(copy_source: CopySource, query: serde_json::Value) -> Self {
        Self {
            copy_source,
            query,
            no_truncation: None,
            query_timeout: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "The Azure Data Explorer (Kusto) dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Azure Data Explorer (Kusto) dataset properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureDataExplorerDatasetTypeProperties,
}
impl AzureDataExplorerTableDataset {
    pub fn new(dataset: Dataset, type_properties: AzureDataExplorerDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "Azure Data Lake Analytics linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeAnalyticsLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure Data Lake Analytics linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureDataLakeAnalyticsLinkedServiceTypeProperties,
}
impl AzureDataLakeAnalyticsLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureDataLakeAnalyticsLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure Data Lake Analytics linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeAnalyticsLinkedServiceTypeProperties {
    #[doc = "The Azure Data Lake Analytics account name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "accountName")]
    pub account_name: serde_json::Value,
    #[doc = "The ID of the application used to authenticate against the Azure Data Lake Analytics account. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[doc = "The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string)."]
    pub tenant: serde_json::Value,
    #[doc = "Data Lake Analytics account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string)."]
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<serde_json::Value>,
    #[doc = "Data Lake Analytics account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string)."]
    #[serde(rename = "resourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub resource_group_name: Option<serde_json::Value>,
    #[doc = "Azure Data Lake Analytics URI Type: string (or Expression with resultType string)."]
    #[serde(rename = "dataLakeAnalyticsUri", default, skip_serializing_if = "Option::is_none")]
    pub data_lake_analytics_uri: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureDataLakeAnalyticsLinkedServiceTypeProperties {
    pub fn new(account_name: serde_json::Value, tenant: serde_json::Value) -> Self {
        Self {
            account_name,
            service_principal_id: None,
            service_principal_key: None,
            tenant,
            subscription_id: None,
            resource_group_name: None,
            data_lake_analytics_uri: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Azure Data Lake Store dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeStoreDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Azure Data Lake Store dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AzureDataLakeStoreDatasetTypeProperties>,
}
impl AzureDataLakeStoreDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Azure Data Lake Store dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureDataLakeStoreDatasetTypeProperties {
    #[doc = "Path to the folder in the Azure Data Lake Store. Type: string (or Expression with resultType string)."]
    #[serde(rename = "folderPath", default, skip_serializing_if = "Option::is_none")]
    pub folder_path: Option<serde_json::Value>,
    #[doc = "The name of the file in the Azure Data Lake Store. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileName", default, skip_serializing_if = "Option::is_none")]
    pub file_name: Option<serde_json::Value>,
    #[doc = "The format definition of a storage."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<DatasetStorageFormat>,
    #[doc = "The compression method used on a dataset."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl AzureDataLakeStoreDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Data Lake Store linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeStoreLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure Data Lake Store linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureDataLakeStoreLinkedServiceTypeProperties,
}
impl AzureDataLakeStoreLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureDataLakeStoreLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure Data Lake Store linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeStoreLinkedServiceTypeProperties {
    #[doc = "Data Lake Store service URI. Type: string (or Expression with resultType string)."]
    #[serde(rename = "dataLakeStoreUri")]
    pub data_lake_store_uri: serde_json::Value,
    #[doc = "The ID of the application used to authenticate against the Azure Data Lake Store account. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[doc = "The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[doc = "Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[doc = "Data Lake Store account name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<serde_json::Value>,
    #[doc = "Data Lake Store account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string)."]
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<serde_json::Value>,
    #[doc = "Data Lake Store account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string)."]
    #[serde(rename = "resourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub resource_group_name: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureDataLakeStoreLinkedServiceTypeProperties {
    pub fn new(data_lake_store_uri: serde_json::Value) -> Self {
        Self {
            data_lake_store_uri,
            service_principal_id: None,
            service_principal_key: None,
            tenant: None,
            azure_cloud_type: None,
            account_name: None,
            subscription_id: None,
            resource_group_name: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "The location of azure data lake store dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeStoreLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
}
impl AzureDataLakeStoreLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self { dataset_location }
    }
}
#[doc = "Azure data lake store read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeStoreReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[doc = "If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[doc = "ADLS wildcardFolderPath. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[doc = "ADLS wildcardFileName. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[doc = "Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[doc = "Lists files after the value (exclusive) based on file/folder names’ lexicographical order. Applies under the folderPath in data set, and filter files/sub-folders under the folderPath. Type: string (or Expression with resultType string)."]
    #[serde(rename = "listAfter", default, skip_serializing_if = "Option::is_none")]
    pub list_after: Option<serde_json::Value>,
    #[doc = "Lists files before the value (inclusive) based on file/folder names’ lexicographical order. Applies under the folderPath in data set, and filter files/sub-folders under the folderPath. Type: string (or Expression with resultType string)."]
    #[serde(rename = "listBefore", default, skip_serializing_if = "Option::is_none")]
    pub list_before: Option<serde_json::Value>,
    #[doc = "Indicates whether to enable partition discovery."]
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[doc = "Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[doc = "Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[doc = "The start of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[doc = "The end of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
}
impl AzureDataLakeStoreReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            file_list_path: None,
            list_after: None,
            list_before: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
        }
    }
}
#[doc = "A copy activity Azure Data Lake Store sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeStoreSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "The type of copy behavior for copy sink."]
    #[serde(rename = "copyBehavior", default, skip_serializing_if = "Option::is_none")]
    pub copy_behavior: Option<serde_json::Value>,
    #[doc = "Single File Parallel."]
    #[serde(rename = "enableAdlsSingleFileParallel", default, skip_serializing_if = "Option::is_none")]
    pub enable_adls_single_file_parallel: Option<serde_json::Value>,
}
impl AzureDataLakeStoreSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            copy_behavior: None,
            enable_adls_single_file_parallel: None,
        }
    }
}
#[doc = "A copy activity Azure Data Lake source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeStoreSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
}
impl AzureDataLakeStoreSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            recursive: None,
        }
    }
}
#[doc = "Azure data lake store write settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataLakeStoreWriteSettings {
    #[serde(flatten)]
    pub store_write_settings: StoreWriteSettings,
    #[doc = "Specifies the expiry time of the written files. The time is applied to the UTC time zone in the format of \"2018-12-01T05:00:00Z\". Default value is NULL. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "expiryDateTime", default, skip_serializing_if = "Option::is_none")]
    pub expiry_date_time: Option<serde_json::Value>,
}
impl AzureDataLakeStoreWriteSettings {
    pub fn new(store_write_settings: StoreWriteSettings) -> Self {
        Self {
            store_write_settings,
            expiry_date_time: None,
        }
    }
}
#[doc = "Azure Databricks Delta Lake dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksDeltaLakeDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Azure Databricks Delta Lake Dataset Properties"]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AzureDatabricksDeltaLakeDatasetTypeProperties>,
}
impl AzureDatabricksDeltaLakeDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Azure Databricks Delta Lake Dataset Properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureDatabricksDeltaLakeDatasetTypeProperties {
    #[doc = "The name of delta table. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[doc = "The database name of delta table. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub database: Option<serde_json::Value>,
}
impl AzureDatabricksDeltaLakeDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Databricks Delta Lake export command settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksDeltaLakeExportCommand {
    #[serde(flatten)]
    pub export_settings: ExportSettings,
    #[doc = "Specify the date format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "dateFormat", default, skip_serializing_if = "Option::is_none")]
    pub date_format: Option<serde_json::Value>,
    #[doc = "Specify the timestamp format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "timestampFormat", default, skip_serializing_if = "Option::is_none")]
    pub timestamp_format: Option<serde_json::Value>,
}
impl AzureDatabricksDeltaLakeExportCommand {
    pub fn new(export_settings: ExportSettings) -> Self {
        Self {
            export_settings,
            date_format: None,
            timestamp_format: None,
        }
    }
}
#[doc = "Azure Databricks Delta Lake import command settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksDeltaLakeImportCommand {
    #[serde(flatten)]
    pub import_settings: ImportSettings,
    #[doc = "Specify the date format for csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "dateFormat", default, skip_serializing_if = "Option::is_none")]
    pub date_format: Option<serde_json::Value>,
    #[doc = "Specify the timestamp format for csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "timestampFormat", default, skip_serializing_if = "Option::is_none")]
    pub timestamp_format: Option<serde_json::Value>,
}
impl AzureDatabricksDeltaLakeImportCommand {
    pub fn new(import_settings: ImportSettings) -> Self {
        Self {
            import_settings,
            date_format: None,
            timestamp_format: None,
        }
    }
}
#[doc = "Azure Databricks Delta Lake linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksDeltaLakeLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure Databricks Delta Lake linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureDatabricksDetltaLakeLinkedServiceTypeProperties,
}
impl AzureDatabricksDeltaLakeLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureDatabricksDetltaLakeLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "A copy activity Azure Databricks Delta Lake sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksDeltaLakeSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "SQL pre-copy script. Type: string (or Expression with resultType string)."]
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
    #[doc = "Azure Databricks Delta Lake import command settings."]
    #[serde(rename = "importSettings", default, skip_serializing_if = "Option::is_none")]
    pub import_settings: Option<AzureDatabricksDeltaLakeImportCommand>,
}
impl AzureDatabricksDeltaLakeSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
            import_settings: None,
        }
    }
}
#[doc = "A copy activity Azure Databricks Delta Lake source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksDeltaLakeSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Azure Databricks Delta Lake Sql query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "Azure Databricks Delta Lake export command settings."]
    #[serde(rename = "exportSettings", default, skip_serializing_if = "Option::is_none")]
    pub export_settings: Option<AzureDatabricksDeltaLakeExportCommand>,
}
impl AzureDatabricksDeltaLakeSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            export_settings: None,
        }
    }
}
#[doc = "Azure Databricks Delta Lake linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksDetltaLakeLinkedServiceTypeProperties {
    #[doc = "<REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string)."]
    pub domain: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "accessToken")]
    pub access_token: SecretBase,
    #[doc = "The id of an existing interactive cluster that will be used for all runs of this job. Type: string (or Expression with resultType string)."]
    #[serde(rename = "clusterId", default, skip_serializing_if = "Option::is_none")]
    pub cluster_id: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureDatabricksDetltaLakeLinkedServiceTypeProperties {
    pub fn new(domain: serde_json::Value, access_token: SecretBase) -> Self {
        Self {
            domain,
            access_token,
            cluster_id: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Azure Databricks linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure Databricks linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureDatabricksLinkedServiceTypeProperties,
}
impl AzureDatabricksLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureDatabricksLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure Databricks linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDatabricksLinkedServiceTypeProperties {
    #[doc = "<REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string)."]
    pub domain: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "accessToken", default, skip_serializing_if = "Option::is_none")]
    pub access_token: Option<SecretBase>,
    #[doc = "Required to specify MSI, if using Workspace resource id for databricks REST API. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authentication: Option<serde_json::Value>,
    #[doc = "Workspace resource id for databricks REST API. Type: string (or Expression with resultType string)."]
    #[serde(rename = "workspaceResourceId", default, skip_serializing_if = "Option::is_none")]
    pub workspace_resource_id: Option<serde_json::Value>,
    #[doc = "The id of an existing interactive cluster that will be used for all runs of this activity. Type: string (or Expression with resultType string)."]
    #[serde(rename = "existingClusterId", default, skip_serializing_if = "Option::is_none")]
    pub existing_cluster_id: Option<serde_json::Value>,
    #[doc = "The id of an existing instance pool that will be used for all runs of this activity. Type: string (or Expression with resultType string)."]
    #[serde(rename = "instancePoolId", default, skip_serializing_if = "Option::is_none")]
    pub instance_pool_id: Option<serde_json::Value>,
    #[doc = "If not using an existing interactive cluster, this specifies the Spark version of a new job cluster or instance pool nodes created for each run of this activity. Required if instancePoolId is specified. Type: string (or Expression with resultType string)."]
    #[serde(rename = "newClusterVersion", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_version: Option<serde_json::Value>,
    #[doc = "If not using an existing interactive cluster, this specifies the number of worker nodes to use for the new job cluster or instance pool. For new job clusters, this a string-formatted Int32, like '1' means numOfWorker is 1 or '1:10' means auto-scale from 1 (min) to 10 (max). For instance pools, this is a string-formatted Int32, and can only specify a fixed number of worker nodes, such as '2'. Required if newClusterVersion is specified. Type: string (or Expression with resultType string)."]
    #[serde(rename = "newClusterNumOfWorker", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_num_of_worker: Option<serde_json::Value>,
    #[doc = "The node type of the new job cluster. This property is required if newClusterVersion is specified and instancePoolId is not specified. If instancePoolId is specified, this property is ignored. Type: string (or Expression with resultType string)."]
    #[serde(rename = "newClusterNodeType", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_node_type: Option<serde_json::Value>,
    #[doc = "A set of optional, user-specified Spark configuration key-value pairs."]
    #[serde(rename = "newClusterSparkConf", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_spark_conf: Option<serde_json::Value>,
    #[doc = "A set of optional, user-specified Spark environment variables key-value pairs."]
    #[serde(rename = "newClusterSparkEnvVars", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_spark_env_vars: Option<serde_json::Value>,
    #[doc = "Additional tags for cluster resources. This property is ignored in instance pool configurations."]
    #[serde(rename = "newClusterCustomTags", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_custom_tags: Option<serde_json::Value>,
    #[doc = "Specify a location to deliver Spark driver, worker, and event logs. Type: string (or Expression with resultType string)."]
    #[serde(rename = "newClusterLogDestination", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_log_destination: Option<serde_json::Value>,
    #[doc = "The driver node type for the new job cluster. This property is ignored in instance pool configurations. Type: string (or Expression with resultType string)."]
    #[serde(rename = "newClusterDriverNodeType", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_driver_node_type: Option<serde_json::Value>,
    #[doc = "User-defined initialization scripts for the new cluster. Type: array of strings (or Expression with resultType array of strings)."]
    #[serde(rename = "newClusterInitScripts", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_init_scripts: Option<serde_json::Value>,
    #[doc = "Enable the elastic disk on the new cluster. This property is now ignored, and takes the default elastic disk behavior in Databricks (elastic disks are always enabled). Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "newClusterEnableElasticDisk", default, skip_serializing_if = "Option::is_none")]
    pub new_cluster_enable_elastic_disk: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[doc = "The policy id for limiting the ability to configure clusters based on a user defined set of rules. Type: string (or Expression with resultType string)."]
    #[serde(rename = "policyId", default, skip_serializing_if = "Option::is_none")]
    pub policy_id: Option<serde_json::Value>,
}
impl AzureDatabricksLinkedServiceTypeProperties {
    pub fn new(domain: serde_json::Value) -> Self {
        Self {
            domain,
            access_token: None,
            authentication: None,
            workspace_resource_id: None,
            existing_cluster_id: None,
            instance_pool_id: None,
            new_cluster_version: None,
            new_cluster_num_of_worker: None,
            new_cluster_node_type: None,
            new_cluster_spark_conf: None,
            new_cluster_spark_env_vars: None,
            new_cluster_custom_tags: None,
            new_cluster_log_destination: None,
            new_cluster_driver_node_type: None,
            new_cluster_init_scripts: None,
            new_cluster_enable_elastic_disk: None,
            encrypted_credential: None,
            policy_id: None,
        }
    }
}
#[doc = "The resource model definition for an Azure Resource Manager resource with an etag."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureEntityResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Resource Etag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl AzureEntityResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure File Storage linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileStorageLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure File Storage linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureFileStorageLinkedServiceTypeProperties,
}
impl AzureFileStorageLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureFileStorageLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure File Storage linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileStorageLinkedServiceTypeProperties {
    #[doc = "Host name of the server. Type: string (or Expression with resultType string)."]
    pub host: serde_json::Value,
    #[doc = "User ID to logon the server. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userId", default, skip_serializing_if = "Option::is_none")]
    pub user_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(rename = "accountKey", default, skip_serializing_if = "Option::is_none")]
    pub account_key: Option<AzureKeyVaultSecretReference>,
    #[doc = "SAS URI of the Azure File resource. It is mutually exclusive with connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "sasUri", default, skip_serializing_if = "Option::is_none")]
    pub sas_uri: Option<serde_json::Value>,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(rename = "sasToken", default, skip_serializing_if = "Option::is_none")]
    pub sas_token: Option<AzureKeyVaultSecretReference>,
    #[doc = "The azure file share name. It is required when auth with accountKey/sasToken. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileShare", default, skip_serializing_if = "Option::is_none")]
    pub file_share: Option<serde_json::Value>,
    #[doc = "The azure file share snapshot version. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub snapshot: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureFileStorageLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value) -> Self {
        Self {
            host,
            user_id: None,
            password: None,
            connection_string: None,
            account_key: None,
            sas_uri: None,
            sas_token: None,
            file_share: None,
            snapshot: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "The location of file server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileStorageLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
}
impl AzureFileStorageLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self { dataset_location }
    }
}
#[doc = "Azure File Storage read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileStorageReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[doc = "If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[doc = "Azure File Storage wildcardFolderPath. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[doc = "Azure File Storage wildcardFileName. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[doc = "The prefix filter for the Azure File name starting from root path. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prefix: Option<serde_json::Value>,
    #[doc = "Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[doc = "Indicates whether to enable partition discovery."]
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[doc = "Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[doc = "Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[doc = "The start of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[doc = "The end of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
}
impl AzureFileStorageReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            prefix: None,
            file_list_path: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
        }
    }
}
#[doc = "Azure File Storage write settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileStorageWriteSettings {
    #[serde(flatten)]
    pub store_write_settings: StoreWriteSettings,
}
impl AzureFileStorageWriteSettings {
    pub fn new(store_write_settings: StoreWriteSettings) -> Self {
        Self { store_write_settings }
    }
}
#[doc = "Azure Function activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFunctionActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Azure Function activity type properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureFunctionActivityTypeProperties,
}
impl AzureFunctionActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: AzureFunctionActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "The list of HTTP methods supported by a AzureFunctionActivity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AzureFunctionActivityMethod {
    #[serde(rename = "GET")]
    Get,
    #[serde(rename = "POST")]
    Post,
    #[serde(rename = "PUT")]
    Put,
    #[serde(rename = "DELETE")]
    Delete,
    #[serde(rename = "OPTIONS")]
    Options,
    #[serde(rename = "HEAD")]
    Head,
    #[serde(rename = "TRACE")]
    Trace,
}
#[doc = "Azure Function activity type properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFunctionActivityTypeProperties {
    #[doc = "The list of HTTP methods supported by a AzureFunctionActivity."]
    pub method: AzureFunctionActivityMethod,
    #[doc = "Name of the Function that the Azure Function Activity will call. Type: string (or Expression with resultType string)"]
    #[serde(rename = "functionName")]
    pub function_name: serde_json::Value,
    #[doc = "Represents the headers that will be sent to the request. For example, to set the language and type on a request: \"headers\" : { \"Accept-Language\": \"en-us\", \"Content-Type\": \"application/json\" }. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub headers: Option<serde_json::Value>,
    #[doc = "Represents the payload that will be sent to the endpoint. Required for POST/PUT method, not allowed for GET method Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<serde_json::Value>,
}
impl AzureFunctionActivityTypeProperties {
    pub fn new(method: AzureFunctionActivityMethod, function_name: serde_json::Value) -> Self {
        Self {
            method,
            function_name,
            headers: None,
            body: None,
        }
    }
}
#[doc = "Azure Function linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFunctionLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure Function linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureFunctionLinkedServiceTypeProperties,
}
impl AzureFunctionLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureFunctionLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure Function linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFunctionLinkedServiceTypeProperties {
    #[doc = "The endpoint of the Azure Function App. URL will be in the format https://<accountName>.azurewebsites.net."]
    #[serde(rename = "functionAppUrl")]
    pub function_app_url: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "functionKey", default, skip_serializing_if = "Option::is_none")]
    pub function_key: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureFunctionLinkedServiceTypeProperties {
    pub fn new(function_app_url: serde_json::Value) -> Self {
        Self {
            function_app_url,
            function_key: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Azure Key Vault linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureKeyVaultLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure Key Vault linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureKeyVaultLinkedServiceTypeProperties,
}
impl AzureKeyVaultLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureKeyVaultLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure Key Vault linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureKeyVaultLinkedServiceTypeProperties {
    #[doc = "The base URL of the Azure Key Vault. e.g. https://myakv.vault.azure.net Type: string (or Expression with resultType string)."]
    #[serde(rename = "baseUrl")]
    pub base_url: serde_json::Value,
}
impl AzureKeyVaultLinkedServiceTypeProperties {
    pub fn new(base_url: serde_json::Value) -> Self {
        Self { base_url }
    }
}
#[doc = "Azure Key Vault secret reference."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureKeyVaultSecretReference {
    #[serde(flatten)]
    pub secret_base: SecretBase,
    #[doc = "Linked service reference type."]
    pub store: LinkedServiceReference,
    #[doc = "The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string)."]
    #[serde(rename = "secretName")]
    pub secret_name: serde_json::Value,
    #[doc = "The version of the secret in Azure Key Vault. The default value is the latest version of the secret. Type: string (or Expression with resultType string)."]
    #[serde(rename = "secretVersion", default, skip_serializing_if = "Option::is_none")]
    pub secret_version: Option<serde_json::Value>,
}
impl AzureKeyVaultSecretReference {
    pub fn new(secret_base: SecretBase, store: LinkedServiceReference, secret_name: serde_json::Value) -> Self {
        Self {
            secret_base,
            store,
            secret_name,
            secret_version: None,
        }
    }
}
#[doc = "Azure ML Batch Execution activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlBatchExecutionActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Azure ML Batch Execution activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureMlBatchExecutionActivityTypeProperties,
}
impl AzureMlBatchExecutionActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: AzureMlBatchExecutionActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "Azure ML Batch Execution activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureMlBatchExecutionActivityTypeProperties {
    #[doc = "Key,Value pairs to be passed to the Azure ML Batch Execution Service endpoint. Keys must match the names of web service parameters defined in the published Azure ML web service. Values will be passed in the GlobalParameters property of the Azure ML batch execution request."]
    #[serde(rename = "globalParameters", default, skip_serializing_if = "Option::is_none")]
    pub global_parameters: Option<serde_json::Value>,
    #[doc = "Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Outputs to AzureMLWebServiceFile objects specifying the output Blob locations. This information will be passed in the WebServiceOutputs property of the Azure ML batch execution request."]
    #[serde(rename = "webServiceOutputs", default, skip_serializing_if = "Option::is_none")]
    pub web_service_outputs: Option<serde_json::Value>,
    #[doc = "Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Inputs to AzureMLWebServiceFile objects specifying the input Blob locations.. This information will be passed in the WebServiceInputs property of the Azure ML batch execution request."]
    #[serde(rename = "webServiceInputs", default, skip_serializing_if = "Option::is_none")]
    pub web_service_inputs: Option<serde_json::Value>,
}
impl AzureMlBatchExecutionActivityTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure ML Execute Pipeline activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlExecutePipelineActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Azure ML Execute Pipeline activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureMlExecutePipelineActivityTypeProperties,
}
impl AzureMlExecutePipelineActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: AzureMlExecutePipelineActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "Azure ML Execute Pipeline activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlExecutePipelineActivityTypeProperties {
    #[doc = "ID of the published Azure ML pipeline. Type: string (or Expression with resultType string)."]
    #[serde(rename = "mlPipelineId")]
    pub ml_pipeline_id: serde_json::Value,
    #[doc = "Run history experiment name of the pipeline run. This information will be passed in the ExperimentName property of the published pipeline execution request. Type: string (or Expression with resultType string)."]
    #[serde(rename = "experimentName", default, skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<serde_json::Value>,
    #[doc = "Key,Value pairs to be passed to the published Azure ML pipeline endpoint. Keys must match the names of pipeline parameters defined in the published pipeline. Values will be passed in the ParameterAssignments property of the published pipeline execution request. Type: object with key value pairs (or Expression with resultType object)."]
    #[serde(rename = "mlPipelineParameters", default, skip_serializing_if = "Option::is_none")]
    pub ml_pipeline_parameters: Option<serde_json::Value>,
    #[doc = "The parent Azure ML Service pipeline run id. This information will be passed in the ParentRunId property of the published pipeline execution request. Type: string (or Expression with resultType string)."]
    #[serde(rename = "mlParentRunId", default, skip_serializing_if = "Option::is_none")]
    pub ml_parent_run_id: Option<serde_json::Value>,
    #[doc = "Whether to continue execution of other steps in the PipelineRun if a step fails. This information will be passed in the continueOnStepFailure property of the published pipeline execution request. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "continueOnStepFailure", default, skip_serializing_if = "Option::is_none")]
    pub continue_on_step_failure: Option<serde_json::Value>,
}
impl AzureMlExecutePipelineActivityTypeProperties {
    pub fn new(ml_pipeline_id: serde_json::Value) -> Self {
        Self {
            ml_pipeline_id,
            experiment_name: None,
            ml_pipeline_parameters: None,
            ml_parent_run_id: None,
            continue_on_step_failure: None,
        }
    }
}
#[doc = "Azure ML Studio Web Service linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure ML Studio Web Service linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureMlLinkedServiceTypeProperties,
}
impl AzureMlLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureMlLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure ML Studio Web Service linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlLinkedServiceTypeProperties {
    #[doc = "The Batch Execution REST URL for an Azure ML Studio Web Service endpoint. Type: string (or Expression with resultType string)."]
    #[serde(rename = "mlEndpoint")]
    pub ml_endpoint: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "apiKey")]
    pub api_key: SecretBase,
    #[doc = "The Update Resource REST URL for an Azure ML Studio Web Service endpoint. Type: string (or Expression with resultType string)."]
    #[serde(rename = "updateResourceEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub update_resource_endpoint: Option<serde_json::Value>,
    #[doc = "The ID of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML Studio web service. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[doc = "The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureMlLinkedServiceTypeProperties {
    pub fn new(ml_endpoint: serde_json::Value, api_key: SecretBase) -> Self {
        Self {
            ml_endpoint,
            api_key,
            update_resource_endpoint: None,
            service_principal_id: None,
            service_principal_key: None,
            tenant: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Key,Value pairs to be passed to the published Azure ML pipeline endpoint. Keys must match the names of pipeline parameters defined in the published pipeline. Values will be passed in the ParameterAssignments property of the published pipeline execution request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureMlPipelineParameters {}
impl AzureMlPipelineParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure ML Service linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlServiceLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure ML Service linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureMlServiceLinkedServiceTypeProperties,
}
impl AzureMlServiceLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureMlServiceLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure ML Service linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlServiceLinkedServiceTypeProperties {
    #[doc = "Azure ML Service workspace subscription ID. Type: string (or Expression with resultType string)."]
    #[serde(rename = "subscriptionId")]
    pub subscription_id: serde_json::Value,
    #[doc = "Azure ML Service workspace resource group name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "resourceGroupName")]
    pub resource_group_name: serde_json::Value,
    #[doc = "Azure ML Service workspace name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "mlWorkspaceName")]
    pub ml_workspace_name: serde_json::Value,
    #[doc = "The ID of the service principal used to authenticate against the endpoint of a published Azure ML Service pipeline. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[doc = "The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureMlServiceLinkedServiceTypeProperties {
    pub fn new(subscription_id: serde_json::Value, resource_group_name: serde_json::Value, ml_workspace_name: serde_json::Value) -> Self {
        Self {
            subscription_id,
            resource_group_name,
            ml_workspace_name,
            service_principal_id: None,
            service_principal_key: None,
            tenant: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Azure ML Update Resource management activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlUpdateResourceActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Azure ML Update Resource activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureMlUpdateResourceActivityTypeProperties,
}
impl AzureMlUpdateResourceActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: AzureMlUpdateResourceActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "Azure ML Update Resource activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlUpdateResourceActivityTypeProperties {
    #[doc = "Name of the Trained Model module in the Web Service experiment to be updated. Type: string (or Expression with resultType string)."]
    #[serde(rename = "trainedModelName")]
    pub trained_model_name: serde_json::Value,
    #[doc = "Linked service reference type."]
    #[serde(rename = "trainedModelLinkedServiceName")]
    pub trained_model_linked_service_name: LinkedServiceReference,
    #[doc = "The relative file path in trainedModelLinkedService to represent the .ilearner file that will be uploaded by the update operation.  Type: string (or Expression with resultType string)."]
    #[serde(rename = "trainedModelFilePath")]
    pub trained_model_file_path: serde_json::Value,
}
impl AzureMlUpdateResourceActivityTypeProperties {
    pub fn new(
        trained_model_name: serde_json::Value,
        trained_model_linked_service_name: LinkedServiceReference,
        trained_model_file_path: serde_json::Value,
    ) -> Self {
        Self {
            trained_model_name,
            trained_model_linked_service_name,
            trained_model_file_path,
        }
    }
}
#[doc = "Azure ML WebService Input/Output file"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMlWebServiceFile {
    #[doc = "The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type: string (or Expression with resultType string)."]
    #[serde(rename = "filePath")]
    pub file_path: serde_json::Value,
    #[doc = "Linked service reference type."]
    #[serde(rename = "linkedServiceName")]
    pub linked_service_name: LinkedServiceReference,
}
impl AzureMlWebServiceFile {
    pub fn new(file_path: serde_json::Value, linked_service_name: LinkedServiceReference) -> Self {
        Self {
            file_path,
            linked_service_name,
        }
    }
}
#[doc = "Azure Database for MariaDB linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMariaDbLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure Database for MariaDB linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureMariaDbLinkedServiceTypeProperties,
}
impl AzureMariaDbLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureMariaDbLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure Database for MariaDB linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureMariaDbLinkedServiceTypeProperties {
    #[doc = "An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pwd: Option<AzureKeyVaultSecretReference>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureMariaDbLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A copy activity Azure MariaDB source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMariaDbSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl AzureMariaDbSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Azure Database for MariaDB dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMariaDbTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl AzureMariaDbTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Azure MySQL database linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMySqlLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure MySQL database linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureMySqlLinkedServiceTypeProperties,
}
impl AzureMySqlLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureMySqlLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure MySQL database linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMySqlLinkedServiceTypeProperties {
    #[doc = "The connection string. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureMySqlLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "A copy activity Azure MySql sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMySqlSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "A query to execute before starting the copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
}
impl AzureMySqlSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
        }
    }
}
#[doc = "A copy activity Azure MySQL source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMySqlSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "Database query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl AzureMySqlSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "The Azure MySQL database dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMySqlTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Azure MySQL database dataset properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureMySqlTableDatasetTypeProperties,
}
impl AzureMySqlTableDataset {
    pub fn new(dataset: Dataset, type_properties: AzureMySqlTableDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "Azure MySQL database dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureMySqlTableDatasetTypeProperties {
    #[doc = "The Azure MySQL database table name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The name of Azure MySQL database table. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl AzureMySqlTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure PostgreSQL linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzurePostgreSqlLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure PostgreSQL linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzurePostgreSqlLinkedServiceTypeProperties,
}
impl AzurePostgreSqlLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzurePostgreSqlLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure PostgreSQL linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzurePostgreSqlLinkedServiceTypeProperties {
    #[doc = "An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzurePostgreSqlLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A copy activity Azure PostgreSQL sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzurePostgreSqlSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "A query to execute before starting the copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
}
impl AzurePostgreSqlSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
        }
    }
}
#[doc = "A copy activity Azure PostgreSQL source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzurePostgreSqlSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl AzurePostgreSqlSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Azure PostgreSQL dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzurePostgreSqlTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Azure PostgreSQL dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AzurePostgreSqlTableDatasetTypeProperties>,
}
impl AzurePostgreSqlTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Azure PostgreSQL dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzurePostgreSqlTableDatasetTypeProperties {
    #[doc = "The table name of the Azure PostgreSQL database which includes both schema and table. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The table name of the Azure PostgreSQL database. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[doc = "The schema name of the Azure PostgreSQL database. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl AzurePostgreSqlTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A copy activity Azure Queue sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureQueueSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
}
impl AzureQueueSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self { copy_sink }
    }
}
#[doc = "The Azure Search Index."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSearchIndexDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureSearchIndexDatasetTypeProperties,
}
impl AzureSearchIndexDataset {
    pub fn new(dataset: Dataset, type_properties: AzureSearchIndexDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "Properties specific to this dataset type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSearchIndexDatasetTypeProperties {
    #[doc = "The name of the Azure Search Index. Type: string (or Expression with resultType string)."]
    #[serde(rename = "indexName")]
    pub index_name: serde_json::Value,
}
impl AzureSearchIndexDatasetTypeProperties {
    pub fn new(index_name: serde_json::Value) -> Self {
        Self { index_name }
    }
}
#[doc = "A copy activity Azure Search Index sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSearchIndexSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "Specify the write behavior when upserting documents into Azure Search Index."]
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<azure_search_index_sink::WriteBehavior>,
}
impl AzureSearchIndexSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            write_behavior: None,
        }
    }
}
pub mod azure_search_index_sink {
    use super::*;
    #[doc = "Specify the write behavior when upserting documents into Azure Search Index."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WriteBehavior {
        Merge,
        Upload,
    }
}
#[doc = "Linked service for Windows Azure Search Service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSearchLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Windows Azure Search Service linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureSearchLinkedServiceTypeProperties,
}
impl AzureSearchLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureSearchLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Windows Azure Search Service linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSearchLinkedServiceTypeProperties {
    #[doc = "URL for Azure Search service. Type: string (or Expression with resultType string)."]
    pub url: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureSearchLinkedServiceTypeProperties {
    pub fn new(url: serde_json::Value) -> Self {
        Self {
            url,
            key: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Azure SQL Data Warehouse linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDwLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure SQL Data Warehouse linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureSqlDwLinkedServiceTypeProperties,
}
impl AzureSqlDwLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureSqlDwLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure SQL Data Warehouse linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDwLinkedServiceTypeProperties {
    #[doc = "The connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[doc = "The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[doc = "The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[doc = "Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureSqlDwLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            service_principal_id: None,
            service_principal_key: None,
            tenant: None,
            azure_cloud_type: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "The Azure SQL Data Warehouse dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDwTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Azure SQL Data Warehouse dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AzureSqlDwTableDatasetTypeProperties>,
}
impl AzureSqlDwTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Azure SQL Data Warehouse dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlDwTableDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The schema name of the Azure SQL Data Warehouse. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[doc = "The table name of the Azure SQL Data Warehouse. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl AzureSqlDwTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Microsoft Azure SQL Database linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDatabaseLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure SQL Database linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureSqlDatabaseLinkedServiceTypeProperties,
}
impl AzureSqlDatabaseLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureSqlDatabaseLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure SQL Database linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDatabaseLinkedServiceTypeProperties {
    #[doc = "The connection string. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[doc = "The ID of the service principal used to authenticate against Azure SQL Database. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[doc = "The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[doc = "Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureSqlDatabaseLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            service_principal_id: None,
            service_principal_key: None,
            tenant: None,
            azure_cloud_type: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Azure SQL Managed Instance linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlMiLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure SQL Managed Instance linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureSqlMiLinkedServiceTypeProperties,
}
impl AzureSqlMiLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureSqlMiLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure SQL Managed Instance linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlMiLinkedServiceTypeProperties {
    #[doc = "The connection string. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[doc = "The ID of the service principal used to authenticate against Azure SQL Managed Instance. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[doc = "The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[doc = "Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl AzureSqlMiLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            service_principal_id: None,
            service_principal_key: None,
            tenant: None,
            azure_cloud_type: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "The Azure SQL Managed Instance dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlMiTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Azure SQL Managed Instance dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AzureSqlMiTableDatasetTypeProperties>,
}
impl AzureSqlMiTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Azure SQL Managed Instance dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlMiTableDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The schema name of the Azure SQL Managed Instance. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[doc = "The table name of the Azure SQL Managed Instance dataset. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl AzureSqlMiTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A copy activity Azure SQL sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "SQL writer stored procedure name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlWriterStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_stored_procedure_name: Option<serde_json::Value>,
    #[doc = "SQL writer table type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlWriterTableType", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_table_type: Option<serde_json::Value>,
    #[doc = "SQL pre-copy script. Type: string (or Expression with resultType string)."]
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
    #[doc = "SQL stored procedure parameters."]
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[doc = "The stored procedure parameter name of the table type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "storedProcedureTableTypeParameterName", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_table_type_parameter_name: Option<serde_json::Value>,
    #[doc = "The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableOption", default, skip_serializing_if = "Option::is_none")]
    pub table_option: Option<serde_json::Value>,
}
impl AzureSqlSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            sql_writer_stored_procedure_name: None,
            sql_writer_table_type: None,
            pre_copy_script: None,
            stored_procedure_parameters: None,
            stored_procedure_table_type_parameter_name: None,
            table_option: None,
        }
    }
}
#[doc = "A copy activity Azure SQL source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "SQL reader query. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlReaderQuery", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_query: Option<serde_json::Value>,
    #[doc = "Name of the stored procedure for a SQL Database source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlReaderStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_stored_procedure_name: Option<serde_json::Value>,
    #[doc = "Value and type setting for stored procedure parameters. Example: \"{Parameter1: {value: \"1\", type: \"int\"}}\"."]
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[doc = "Which additional types to produce."]
    #[serde(rename = "produceAdditionalTypes", default, skip_serializing_if = "Option::is_none")]
    pub produce_additional_types: Option<serde_json::Value>,
    #[doc = "The partition mechanism that will be used for Sql read in parallel. Possible values include: \"None\", \"PhysicalPartitionsOfTable\", \"DynamicRange\"."]
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[doc = "The settings that will be leveraged for Sql source partitioning."]
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<SqlPartitionSettings>,
}
impl AzureSqlSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            sql_reader_query: None,
            sql_reader_stored_procedure_name: None,
            stored_procedure_parameters: None,
            produce_additional_types: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
#[doc = "The Azure SQL Server database dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Azure SQL dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<AzureSqlTableDatasetTypeProperties>,
}
impl AzureSqlTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Azure SQL dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlTableDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The schema name of the Azure SQL database. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[doc = "The table name of the Azure SQL database. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl AzureSqlTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The storage account linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureStorageLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure Storage linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureStorageLinkedServiceTypeProperties,
}
impl AzureStorageLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureStorageLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Azure Storage linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageLinkedServiceTypeProperties {
    #[doc = "The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(rename = "accountKey", default, skip_serializing_if = "Option::is_none")]
    pub account_key: Option<AzureKeyVaultSecretReference>,
    #[doc = "SAS URI of the Azure Storage resource. It is mutually exclusive with connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "sasUri", default, skip_serializing_if = "Option::is_none")]
    pub sas_uri: Option<serde_json::Value>,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(rename = "sasToken", default, skip_serializing_if = "Option::is_none")]
    pub sas_token: Option<AzureKeyVaultSecretReference>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<String>,
}
impl AzureStorageLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Azure Table storage dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Azure Table dataset properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureTableDatasetTypeProperties,
}
impl AzureTableDataset {
    pub fn new(dataset: Dataset, type_properties: AzureTableDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "Azure Table dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureTableDatasetTypeProperties {
    #[doc = "The table name of the Azure Table storage. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableName")]
    pub table_name: serde_json::Value,
}
impl AzureTableDatasetTypeProperties {
    pub fn new(table_name: serde_json::Value) -> Self {
        Self { table_name }
    }
}
#[doc = "A copy activity Azure Table sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureTableSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "Azure Table default partition key value. Type: string (or Expression with resultType string)."]
    #[serde(rename = "azureTableDefaultPartitionKeyValue", default, skip_serializing_if = "Option::is_none")]
    pub azure_table_default_partition_key_value: Option<serde_json::Value>,
    #[doc = "Azure Table partition key name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "azureTablePartitionKeyName", default, skip_serializing_if = "Option::is_none")]
    pub azure_table_partition_key_name: Option<serde_json::Value>,
    #[doc = "Azure Table row key name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "azureTableRowKeyName", default, skip_serializing_if = "Option::is_none")]
    pub azure_table_row_key_name: Option<serde_json::Value>,
    #[doc = "Azure Table insert type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "azureTableInsertType", default, skip_serializing_if = "Option::is_none")]
    pub azure_table_insert_type: Option<serde_json::Value>,
}
impl AzureTableSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            azure_table_default_partition_key_value: None,
            azure_table_partition_key_name: None,
            azure_table_row_key_name: None,
            azure_table_insert_type: None,
        }
    }
}
#[doc = "A copy activity Azure Table source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureTableSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "Azure Table source query. Type: string (or Expression with resultType string)."]
    #[serde(rename = "azureTableSourceQuery", default, skip_serializing_if = "Option::is_none")]
    pub azure_table_source_query: Option<serde_json::Value>,
    #[doc = "Azure Table source ignore table not found. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "azureTableSourceIgnoreTableNotFound", default, skip_serializing_if = "Option::is_none")]
    pub azure_table_source_ignore_table_not_found: Option<serde_json::Value>,
}
impl AzureTableSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            azure_table_source_query: None,
            azure_table_source_ignore_table_not_found: None,
        }
    }
}
#[doc = "The azure table storage linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureTableStorageLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Azure Storage linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: AzureStorageLinkedServiceTypeProperties,
}
impl AzureTableStorageLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: AzureStorageLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Big data pool reference."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BigDataPoolReference {
    #[doc = "Big data pool reference type."]
    #[serde(rename = "type")]
    pub type_: big_data_pool_reference::Type,
    #[doc = "Reference big data pool name."]
    #[serde(rename = "referenceName")]
    pub reference_name: String,
}
impl BigDataPoolReference {
    pub fn new(type_: big_data_pool_reference::Type, reference_name: String) -> Self {
        Self { type_, reference_name }
    }
}
pub mod big_data_pool_reference {
    use super::*;
    #[doc = "Big data pool reference type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        BigDataPoolReference,
    }
}
#[doc = "A Big Data pool"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BigDataPoolResourceInfo {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "Properties of a Big Data pool powered by Apache Spark"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<BigDataPoolResourceProperties>,
}
impl BigDataPoolResourceInfo {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
        }
    }
}
#[doc = "Collection of Big Data pool information"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BigDataPoolResourceInfoListResult {
    #[doc = "Link to the next page of results"]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "List of Big Data pools"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<BigDataPoolResourceInfo>,
}
impl BigDataPoolResourceInfoListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a Big Data pool powered by Apache Spark"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BigDataPoolResourceProperties {
    #[doc = "The state of the Big Data pool."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "Auto-scaling properties of a Big Data pool powered by Apache Spark"]
    #[serde(rename = "autoScale", default, skip_serializing_if = "Option::is_none")]
    pub auto_scale: Option<AutoScaleProperties>,
    #[doc = "The time when the Big Data pool was created."]
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    #[doc = "Auto-pausing properties of a Big Data pool powered by Apache Spark"]
    #[serde(rename = "autoPause", default, skip_serializing_if = "Option::is_none")]
    pub auto_pause: Option<AutoPauseProperties>,
    #[doc = "Whether compute isolation is required or not."]
    #[serde(rename = "isComputeIsolationEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_compute_isolation_enabled: Option<bool>,
    #[doc = "Whether session level packages enabled."]
    #[serde(rename = "sessionLevelPackagesEnabled", default, skip_serializing_if = "Option::is_none")]
    pub session_level_packages_enabled: Option<bool>,
    #[doc = "The cache size"]
    #[serde(rename = "cacheSize", default, skip_serializing_if = "Option::is_none")]
    pub cache_size: Option<i32>,
    #[doc = "Dynamic Executor Allocation Properties"]
    #[serde(rename = "dynamicExecutorAllocation", default, skip_serializing_if = "Option::is_none")]
    pub dynamic_executor_allocation: Option<DynamicExecutorAllocation>,
    #[doc = "The Spark events folder"]
    #[serde(rename = "sparkEventsFolder", default, skip_serializing_if = "Option::is_none")]
    pub spark_events_folder: Option<String>,
    #[doc = "The number of nodes in the Big Data pool."]
    #[serde(rename = "nodeCount", default, skip_serializing_if = "Option::is_none")]
    pub node_count: Option<i32>,
    #[doc = "Library requirements for a Big Data pool powered by Apache Spark"]
    #[serde(rename = "libraryRequirements", default, skip_serializing_if = "Option::is_none")]
    pub library_requirements: Option<LibraryRequirements>,
    #[doc = "List of custom libraries/packages associated with the spark pool."]
    #[serde(rename = "customLibraries", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_libraries: Vec<LibraryInfo>,
    #[doc = "Library requirements for a Big Data pool powered by Apache Spark"]
    #[serde(rename = "sparkConfigProperties", default, skip_serializing_if = "Option::is_none")]
    pub spark_config_properties: Option<LibraryRequirements>,
    #[doc = "The Apache Spark version."]
    #[serde(rename = "sparkVersion", default, skip_serializing_if = "Option::is_none")]
    pub spark_version: Option<String>,
    #[doc = "The default folder where Spark logs will be written."]
    #[serde(rename = "defaultSparkLogFolder", default, skip_serializing_if = "Option::is_none")]
    pub default_spark_log_folder: Option<String>,
    #[doc = "The level of compute power that each node in the Big Data pool has."]
    #[serde(rename = "nodeSize", default, skip_serializing_if = "Option::is_none")]
    pub node_size: Option<big_data_pool_resource_properties::NodeSize>,
    #[doc = "The kind of nodes that the Big Data pool provides."]
    #[serde(rename = "nodeSizeFamily", default, skip_serializing_if = "Option::is_none")]
    pub node_size_family: Option<big_data_pool_resource_properties::NodeSizeFamily>,
    #[doc = "The time when the Big Data pool was updated successfully."]
    #[serde(rename = "lastSucceededTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub last_succeeded_timestamp: Option<String>,
}
impl BigDataPoolResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod big_data_pool_resource_properties {
    use super::*;
    #[doc = "The level of compute power that each node in the Big Data pool has."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NodeSize {
        None,
        Small,
        Medium,
        Large,
        XLarge,
        #[serde(rename = "XXLarge")]
        XxLarge,
        #[serde(rename = "XXXLarge")]
        XxxLarge,
    }
    #[doc = "The kind of nodes that the Big Data pool provides."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NodeSizeFamily {
        None,
        MemoryOptimized,
    }
}
#[doc = "Binary dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BinaryDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Binary dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<BinaryDatasetTypeProperties>,
}
impl BinaryDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Binary dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BinaryDatasetTypeProperties {
    #[doc = "Dataset location."]
    pub location: DatasetLocation,
    #[doc = "The compression method used on a dataset."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl BinaryDatasetTypeProperties {
    pub fn new(location: DatasetLocation) -> Self {
        Self {
            location,
            compression: None,
        }
    }
}
#[doc = "Binary read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BinaryReadSettings {
    #[serde(flatten)]
    pub format_read_settings: FormatReadSettings,
    #[doc = "Compression read settings."]
    #[serde(rename = "compressionProperties", default, skip_serializing_if = "Option::is_none")]
    pub compression_properties: Option<CompressionReadSettings>,
}
impl BinaryReadSettings {
    pub fn new(format_read_settings: FormatReadSettings) -> Self {
        Self {
            format_read_settings,
            compression_properties: None,
        }
    }
}
#[doc = "A copy activity Binary sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BinarySink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "Connector write settings."]
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreWriteSettings>,
}
impl BinarySink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            store_settings: None,
        }
    }
}
#[doc = "A copy activity Binary source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BinarySource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Connector read setting."]
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[doc = "Binary read settings."]
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<BinaryReadSettings>,
}
impl BinarySource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            store_settings: None,
            format_settings: None,
        }
    }
}
pub type BlobEventTypes = Vec<String>;
#[doc = "Trigger that runs every time a Blob event occurs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobEventsTrigger {
    #[serde(flatten)]
    pub multiple_pipeline_trigger: MultiplePipelineTrigger,
    #[doc = "Blob Events Trigger properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: blob_events_trigger::TypeProperties,
}
impl BlobEventsTrigger {
    pub fn new(multiple_pipeline_trigger: MultiplePipelineTrigger, type_properties: blob_events_trigger::TypeProperties) -> Self {
        Self {
            multiple_pipeline_trigger,
            type_properties,
        }
    }
}
pub mod blob_events_trigger {
    use super::*;
    #[doc = "Blob Events Trigger properties."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct TypeProperties {
        #[doc = "The blob path must begin with the pattern provided for trigger to fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the december folder under the records container. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith."]
        #[serde(rename = "blobPathBeginsWith", default, skip_serializing_if = "Option::is_none")]
        pub blob_path_begins_with: Option<String>,
        #[doc = "The blob path must end with the pattern provided for trigger to fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith."]
        #[serde(rename = "blobPathEndsWith", default, skip_serializing_if = "Option::is_none")]
        pub blob_path_ends_with: Option<String>,
        #[doc = "If set to true, blobs with zero bytes will be ignored."]
        #[serde(rename = "ignoreEmptyBlobs", default, skip_serializing_if = "Option::is_none")]
        pub ignore_empty_blobs: Option<bool>,
        #[doc = "Blob event types."]
        pub events: BlobEventTypes,
        #[doc = "The ARM resource ID of the Storage Account."]
        pub scope: String,
    }
    impl TypeProperties {
        pub fn new(events: BlobEventTypes, scope: String) -> Self {
            Self {
                blob_path_begins_with: None,
                blob_path_ends_with: None,
                ignore_empty_blobs: None,
                events,
                scope,
            }
        }
    }
}
#[doc = "A copy activity Azure Blob sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "Blob writer overwrite files. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "blobWriterOverwriteFiles", default, skip_serializing_if = "Option::is_none")]
    pub blob_writer_overwrite_files: Option<serde_json::Value>,
    #[doc = "Blob writer date time format. Type: string (or Expression with resultType string)."]
    #[serde(rename = "blobWriterDateTimeFormat", default, skip_serializing_if = "Option::is_none")]
    pub blob_writer_date_time_format: Option<serde_json::Value>,
    #[doc = "Blob writer add header. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "blobWriterAddHeader", default, skip_serializing_if = "Option::is_none")]
    pub blob_writer_add_header: Option<serde_json::Value>,
    #[doc = "The type of copy behavior for copy sink."]
    #[serde(rename = "copyBehavior", default, skip_serializing_if = "Option::is_none")]
    pub copy_behavior: Option<serde_json::Value>,
}
impl BlobSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            blob_writer_overwrite_files: None,
            blob_writer_date_time_format: None,
            blob_writer_add_header: None,
            copy_behavior: None,
        }
    }
}
#[doc = "A copy activity Azure Blob source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Treat empty as null. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "treatEmptyAsNull", default, skip_serializing_if = "Option::is_none")]
    pub treat_empty_as_null: Option<serde_json::Value>,
    #[doc = "Number of header lines to skip from each blob. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "skipHeaderLineCount", default, skip_serializing_if = "Option::is_none")]
    pub skip_header_line_count: Option<serde_json::Value>,
    #[doc = "If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
}
impl BlobSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            treat_empty_as_null: None,
            skip_header_line_count: None,
            recursive: None,
        }
    }
}
#[doc = "Trigger that runs every time the selected Blob container changes."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobTrigger {
    #[serde(flatten)]
    pub multiple_pipeline_trigger: MultiplePipelineTrigger,
    #[doc = "Blob Trigger properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: blob_trigger::TypeProperties,
}
impl BlobTrigger {
    pub fn new(multiple_pipeline_trigger: MultiplePipelineTrigger, type_properties: blob_trigger::TypeProperties) -> Self {
        Self {
            multiple_pipeline_trigger,
            type_properties,
        }
    }
}
pub mod blob_trigger {
    use super::*;
    #[doc = "Blob Trigger properties."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct TypeProperties {
        #[doc = "The path of the container/folder that will trigger the pipeline."]
        #[serde(rename = "folderPath")]
        pub folder_path: String,
        #[doc = "The max number of parallel files to handle when it is triggered."]
        #[serde(rename = "maxConcurrency")]
        pub max_concurrency: i64,
        #[doc = "Linked service reference type."]
        #[serde(rename = "linkedService")]
        pub linked_service: LinkedServiceReference,
    }
    impl TypeProperties {
        pub fn new(folder_path: String, max_concurrency: i64, linked_service: LinkedServiceReference) -> Self {
            Self {
                folder_path,
                max_concurrency,
                linked_service,
            }
        }
    }
}
#[doc = "Linked service for Cassandra data source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Cassandra linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: CassandraLinkedServiceTypeProperties,
}
impl CassandraLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: CassandraLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Cassandra linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraLinkedServiceTypeProperties {
    #[doc = "Host name for connection. Type: string (or Expression with resultType string)."]
    pub host: serde_json::Value,
    #[doc = "AuthenticationType to be used for connection. Type: string (or Expression with resultType string)."]
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<serde_json::Value>,
    #[doc = "The port for the connection. Type: integer (or Expression with resultType integer)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[doc = "Username for authentication. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl CassandraLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value) -> Self {
        Self {
            host,
            authentication_type: None,
            port: None,
            username: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "A copy activity source for a Cassandra database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "Database query. Should be a SQL-92 query expression or Cassandra Query Language (CQL) command. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "The consistency level specifies how many Cassandra servers must respond to a read request before returning data to the client application. Cassandra checks the specified number of Cassandra servers for data to satisfy the read request. Must be one of cassandraSourceReadConsistencyLevels. The default value is 'ONE'. It is case-insensitive."]
    #[serde(rename = "consistencyLevel", default, skip_serializing_if = "Option::is_none")]
    pub consistency_level: Option<cassandra_source::ConsistencyLevel>,
}
impl CassandraSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            consistency_level: None,
        }
    }
}
pub mod cassandra_source {
    use super::*;
    #[doc = "The consistency level specifies how many Cassandra servers must respond to a read request before returning data to the client application. Cassandra checks the specified number of Cassandra servers for data to satisfy the read request. Must be one of cassandraSourceReadConsistencyLevels. The default value is 'ONE'. It is case-insensitive."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ConsistencyLevel {
        #[serde(rename = "ALL")]
        All,
        #[serde(rename = "EACH_QUORUM")]
        EachQuorum,
        #[serde(rename = "QUORUM")]
        Quorum,
        #[serde(rename = "LOCAL_QUORUM")]
        LocalQuorum,
        #[serde(rename = "ONE")]
        One,
        #[serde(rename = "TWO")]
        Two,
        #[serde(rename = "THREE")]
        Three,
        #[serde(rename = "LOCAL_ONE")]
        LocalOne,
        #[serde(rename = "SERIAL")]
        Serial,
        #[serde(rename = "LOCAL_SERIAL")]
        LocalSerial,
    }
}
#[doc = "The Cassandra database dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CassandraTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Cassandra dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<CassandraTableDatasetTypeProperties>,
}
impl CassandraTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Cassandra dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CassandraTableDatasetTypeProperties {
    #[doc = "The table name of the Cassandra database. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The keyspace of the Cassandra database. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub keyspace: Option<serde_json::Value>,
}
impl CassandraTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Trigger that allows the referenced pipeline to depend on other pipeline runs based on runDimension Name/Value pairs. Upstream pipelines should declare the same runDimension Name and their runs should have the values for those runDimensions. The referenced pipeline run would be triggered if the values for the runDimension match for all upstream pipeline runs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ChainingTrigger {
    #[serde(flatten)]
    pub trigger: Trigger,
    #[doc = "Pipeline that needs to be triggered with the given parameters."]
    pub pipeline: TriggerPipelineReference,
    #[doc = "Chaining Trigger properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: chaining_trigger::TypeProperties,
}
impl ChainingTrigger {
    pub fn new(trigger: Trigger, pipeline: TriggerPipelineReference, type_properties: chaining_trigger::TypeProperties) -> Self {
        Self {
            trigger,
            pipeline,
            type_properties,
        }
    }
}
pub mod chaining_trigger {
    use super::*;
    #[doc = "Chaining Trigger properties."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct TypeProperties {
        #[doc = "Upstream Pipelines."]
        #[serde(rename = "dependsOn")]
        pub depends_on: Vec<PipelineReference>,
        #[doc = "Run Dimension property that needs to be emitted by upstream pipelines."]
        #[serde(rename = "runDimension")]
        pub run_dimension: String,
    }
    impl TypeProperties {
        pub fn new(depends_on: Vec<PipelineReference>, run_dimension: String) -> Self {
            Self { depends_on, run_dimension }
        }
    }
}
#[doc = "The object that defines the structure of an Azure Synapse error response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloudError {
    #[doc = "The object that defines the structure of an Azure Synapse error."]
    pub error: CloudErrorBody,
}
impl CloudError {
    pub fn new(error: CloudErrorBody) -> Self {
        Self { error }
    }
}
#[doc = "The object that defines the structure of an Azure Synapse error."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloudErrorBody {
    #[doc = "Error code."]
    pub code: String,
    #[doc = "Error message."]
    pub message: String,
    #[doc = "Property name/path in request associated with error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "Array with additional error details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<CloudError>,
}
impl CloudErrorBody {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            target: None,
            details: Vec::new(),
        }
    }
}
#[doc = "The Common Data Service for Apps entity dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CommonDataServiceForAppsEntityDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Common Data Service for Apps entity dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<CommonDataServiceForAppsEntityDatasetTypeProperties>,
}
impl CommonDataServiceForAppsEntityDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Common Data Service for Apps entity dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CommonDataServiceForAppsEntityDatasetTypeProperties {
    #[doc = "The logical name of the entity. Type: string (or Expression with resultType string)."]
    #[serde(rename = "entityName", default, skip_serializing_if = "Option::is_none")]
    pub entity_name: Option<serde_json::Value>,
}
impl CommonDataServiceForAppsEntityDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Common Data Service for Apps linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CommonDataServiceForAppsLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Common Data Service for Apps linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: CommonDataServiceForAppsLinkedServiceTypeProperties,
}
impl CommonDataServiceForAppsLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: CommonDataServiceForAppsLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Common Data Service for Apps linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CommonDataServiceForAppsLinkedServiceTypeProperties {
    #[doc = "The deployment type of the Common Data Service for Apps instance. 'Online' for Common Data Service for Apps Online and 'OnPremisesWithIfd' for Common Data Service for Apps on-premises with Ifd. Type: string (or Expression with resultType string)."]
    #[serde(rename = "deploymentType")]
    pub deployment_type: common_data_service_for_apps_linked_service_type_properties::DeploymentType,
    #[doc = "The host name of the on-premises Common Data Service for Apps server. The property is required for on-prem and not allowed for online. Type: string (or Expression with resultType string)."]
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<serde_json::Value>,
    #[doc = "The port of on-premises Common Data Service for Apps server. The property is required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression with resultType integer), minimum: 0."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[doc = "The URL to the Microsoft Common Data Service for Apps server. The property is required for on-line and not allowed for on-prem. Type: string (or Expression with resultType string)."]
    #[serde(rename = "serviceUri", default, skip_serializing_if = "Option::is_none")]
    pub service_uri: Option<serde_json::Value>,
    #[doc = "The organization name of the Common Data Service for Apps instance. The property is required for on-prem and required for online when there are more than one Common Data Service for Apps instances associated with the user. Type: string (or Expression with resultType string)."]
    #[serde(rename = "organizationName", default, skip_serializing_if = "Option::is_none")]
    pub organization_name: Option<serde_json::Value>,
    #[doc = "The authentication type to connect to Common Data Service for Apps server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario. 'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or Expression with resultType string)."]
    #[serde(rename = "authenticationType")]
    pub authentication_type: common_data_service_for_apps_linked_service_type_properties::AuthenticationType,
    #[doc = "User name to access the Common Data Service for Apps instance. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[doc = "A string from ServicePrincipalCredentialEnum or an expression"]
    #[serde(rename = "servicePrincipalCredentialType", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_credential_type: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalCredential", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_credential: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl CommonDataServiceForAppsLinkedServiceTypeProperties {
    pub fn new(
        deployment_type: common_data_service_for_apps_linked_service_type_properties::DeploymentType,
        authentication_type: common_data_service_for_apps_linked_service_type_properties::AuthenticationType,
    ) -> Self {
        Self {
            deployment_type,
            host_name: None,
            port: None,
            service_uri: None,
            organization_name: None,
            authentication_type,
            username: None,
            password: None,
            service_principal_id: None,
            service_principal_credential_type: None,
            service_principal_credential: None,
            encrypted_credential: None,
        }
    }
}
pub mod common_data_service_for_apps_linked_service_type_properties {
    use super::*;
    #[doc = "The deployment type of the Common Data Service for Apps instance. 'Online' for Common Data Service for Apps Online and 'OnPremisesWithIfd' for Common Data Service for Apps on-premises with Ifd. Type: string (or Expression with resultType string)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeploymentType {
        Online,
        OnPremisesWithIfd,
    }
    #[doc = "The authentication type to connect to Common Data Service for Apps server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario. 'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or Expression with resultType string)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Office365,
        Ifd,
        #[serde(rename = "AADServicePrincipal")]
        AadServicePrincipal,
    }
}
#[doc = "A copy activity Common Data Service for Apps sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CommonDataServiceForAppsSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "Defines values for DynamicsSinkWriteBehavior."]
    #[serde(rename = "writeBehavior")]
    pub write_behavior: DynamicsSinkWriteBehavior,
    #[doc = "The flag indicating whether to ignore null values from input dataset (except key fields) during write operation. Default is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "ignoreNullValues", default, skip_serializing_if = "Option::is_none")]
    pub ignore_null_values: Option<serde_json::Value>,
    #[doc = "The logical name of the alternate key which will be used when upserting records. Type: string (or Expression with resultType string)."]
    #[serde(rename = "alternateKeyName", default, skip_serializing_if = "Option::is_none")]
    pub alternate_key_name: Option<serde_json::Value>,
}
impl CommonDataServiceForAppsSink {
    pub fn new(copy_sink: CopySink, write_behavior: DynamicsSinkWriteBehavior) -> Self {
        Self {
            copy_sink,
            write_behavior,
            ignore_null_values: None,
            alternate_key_name: None,
        }
    }
}
#[doc = "A copy activity Common Data Service for Apps source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CommonDataServiceForAppsSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "FetchXML is a proprietary query language that is used in Microsoft Common Data Service for Apps (online & on-premises). Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl CommonDataServiceForAppsSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "All available compression levels."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CompressionLevel {}
impl CompressionLevel {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Compression read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CompressionReadSettings {
    #[doc = "The Compression setting type."]
    #[serde(rename = "type")]
    pub type_: String,
}
impl CompressionReadSettings {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[doc = "Concur Service linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConcurLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Concur Service linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: ConcurLinkedServiceTypeProperties,
}
impl ConcurLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: ConcurLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Concur Service linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConcurLinkedServiceTypeProperties {
    #[doc = "Properties used to connect to Concur. It is mutually exclusive with any other properties in the linked service. Type: object."]
    #[serde(rename = "connectionProperties", default, skip_serializing_if = "Option::is_none")]
    pub connection_properties: Option<serde_json::Value>,
    #[doc = "Application client_id supplied by Concur App Management."]
    #[serde(rename = "clientId")]
    pub client_id: serde_json::Value,
    #[doc = "The user name that you use to access Concur Service."]
    pub username: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[doc = "Specifies whether to verify the identity of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl ConcurLinkedServiceTypeProperties {
    pub fn new(client_id: serde_json::Value, username: serde_json::Value) -> Self {
        Self {
            connection_properties: None,
            client_id,
            username,
            password: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Concur Service dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConcurObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl ConcurObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Concur Service source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConcurSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl ConcurSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Base class for all control activities like IfCondition, ForEach , Until."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ControlActivity {
    #[serde(flatten)]
    pub activity: Activity,
}
impl ControlActivity {
    pub fn new(activity: Activity) -> Self {
        Self { activity }
    }
}
#[doc = "Copy activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CopyActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Copy activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: CopyActivityTypeProperties,
    #[doc = "List of inputs for the activity."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub inputs: Vec<DatasetReference>,
    #[doc = "List of outputs for the activity."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub outputs: Vec<DatasetReference>,
}
impl CopyActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: CopyActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
            inputs: Vec::new(),
            outputs: Vec::new(),
        }
    }
}
#[doc = "Settings for copy activity log."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CopyActivityLogSettings {
    #[doc = "Gets or sets the log level, support: Info, Warning. Type: string (or Expression with resultType string)."]
    #[serde(rename = "logLevel", default, skip_serializing_if = "Option::is_none")]
    pub log_level: Option<serde_json::Value>,
    #[doc = "Specifies whether to enable reliable logging. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "enableReliableLogging", default, skip_serializing_if = "Option::is_none")]
    pub enable_reliable_logging: Option<serde_json::Value>,
}
impl CopyActivityLogSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Copy activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CopyActivityTypeProperties {
    #[doc = "A copy activity source."]
    pub source: CopySource,
    #[doc = "A copy activity sink."]
    pub sink: CopySink,
    #[doc = "Copy activity translator. If not specified, tabular translator is used."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub translator: Option<serde_json::Value>,
    #[doc = "Specifies whether to copy data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "enableStaging", default, skip_serializing_if = "Option::is_none")]
    pub enable_staging: Option<serde_json::Value>,
    #[doc = "Staging settings."]
    #[serde(rename = "stagingSettings", default, skip_serializing_if = "Option::is_none")]
    pub staging_settings: Option<StagingSettings>,
    #[doc = "Maximum number of concurrent sessions opened on the source or sink to avoid overloading the data store. Type: integer (or Expression with resultType integer), minimum: 0."]
    #[serde(rename = "parallelCopies", default, skip_serializing_if = "Option::is_none")]
    pub parallel_copies: Option<serde_json::Value>,
    #[doc = "Maximum number of data integration units that can be used to perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0."]
    #[serde(rename = "dataIntegrationUnits", default, skip_serializing_if = "Option::is_none")]
    pub data_integration_units: Option<serde_json::Value>,
    #[doc = "Whether to skip incompatible row. Default value is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "enableSkipIncompatibleRow", default, skip_serializing_if = "Option::is_none")]
    pub enable_skip_incompatible_row: Option<serde_json::Value>,
    #[doc = "Redirect incompatible row settings"]
    #[serde(rename = "redirectIncompatibleRowSettings", default, skip_serializing_if = "Option::is_none")]
    pub redirect_incompatible_row_settings: Option<RedirectIncompatibleRowSettings>,
    #[doc = "(Deprecated. Please use LogSettings) Log storage settings."]
    #[serde(rename = "logStorageSettings", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_settings: Option<LogStorageSettings>,
    #[doc = "Log settings."]
    #[serde(rename = "logSettings", default, skip_serializing_if = "Option::is_none")]
    pub log_settings: Option<LogSettings>,
    #[doc = "Preserve Rules."]
    #[serde(rename = "preserveRules", default, skip_serializing_if = "Vec::is_empty")]
    pub preserve_rules: Vec<serde_json::Value>,
    #[doc = "Preserve rules."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub preserve: Vec<serde_json::Value>,
    #[doc = "Whether to enable Data Consistency validation. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "validateDataConsistency", default, skip_serializing_if = "Option::is_none")]
    pub validate_data_consistency: Option<serde_json::Value>,
    #[doc = "Skip error file."]
    #[serde(rename = "skipErrorFile", default, skip_serializing_if = "Option::is_none")]
    pub skip_error_file: Option<SkipErrorFile>,
}
impl CopyActivityTypeProperties {
    pub fn new(source: CopySource, sink: CopySink) -> Self {
        Self {
            source,
            sink,
            translator: None,
            enable_staging: None,
            staging_settings: None,
            parallel_copies: None,
            data_integration_units: None,
            enable_skip_incompatible_row: None,
            redirect_incompatible_row_settings: None,
            log_storage_settings: None,
            log_settings: None,
            preserve_rules: Vec::new(),
            preserve: Vec::new(),
            validate_data_consistency: None,
            skip_error_file: None,
        }
    }
}
#[doc = "All available types of copy behavior."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CopyBehaviorType {
    PreserveHierarchy,
    FlattenHierarchy,
    MergeFiles,
}
#[doc = "A copy activity sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CopySink {
    #[doc = "Copy sink type."]
    #[serde(rename = "type")]
    pub type_: String,
    #[doc = "Write batch size. Type: integer (or Expression with resultType integer), minimum: 0."]
    #[serde(rename = "writeBatchSize", default, skip_serializing_if = "Option::is_none")]
    pub write_batch_size: Option<serde_json::Value>,
    #[doc = "Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "writeBatchTimeout", default, skip_serializing_if = "Option::is_none")]
    pub write_batch_timeout: Option<serde_json::Value>,
    #[doc = "Sink retry count. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "sinkRetryCount", default, skip_serializing_if = "Option::is_none")]
    pub sink_retry_count: Option<serde_json::Value>,
    #[doc = "Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "sinkRetryWait", default, skip_serializing_if = "Option::is_none")]
    pub sink_retry_wait: Option<serde_json::Value>,
    #[doc = "The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "maxConcurrentConnections", default, skip_serializing_if = "Option::is_none")]
    pub max_concurrent_connections: Option<serde_json::Value>,
}
impl CopySink {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            write_batch_size: None,
            write_batch_timeout: None,
            sink_retry_count: None,
            sink_retry_wait: None,
            max_concurrent_connections: None,
        }
    }
}
#[doc = "A copy activity source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CopySource {
    #[doc = "Copy source type."]
    #[serde(rename = "type")]
    pub type_: String,
    #[doc = "Source retry count. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "sourceRetryCount", default, skip_serializing_if = "Option::is_none")]
    pub source_retry_count: Option<serde_json::Value>,
    #[doc = "Source retry wait. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "sourceRetryWait", default, skip_serializing_if = "Option::is_none")]
    pub source_retry_wait: Option<serde_json::Value>,
    #[doc = "The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "maxConcurrentConnections", default, skip_serializing_if = "Option::is_none")]
    pub max_concurrent_connections: Option<serde_json::Value>,
}
impl CopySource {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            source_retry_count: None,
            source_retry_wait: None,
            max_concurrent_connections: None,
        }
    }
}
#[doc = "A copy activity translator."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CopyTranslator {
    #[doc = "Copy translator type."]
    #[serde(rename = "type")]
    pub type_: String,
}
impl CopyTranslator {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[doc = "Microsoft Azure Cosmos Database (CosmosDB) linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "CosmosDB linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: CosmosDbLinkedServiceTypeProperties,
}
impl CosmosDbLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: CosmosDbLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "CosmosDB linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CosmosDbLinkedServiceTypeProperties {
    #[doc = "The connection string. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[doc = "The endpoint of the Azure CosmosDB account. Type: string (or Expression with resultType string)"]
    #[serde(rename = "accountEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub account_endpoint: Option<serde_json::Value>,
    #[doc = "The name of the database. Type: string (or Expression with resultType string)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub database: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "accountKey", default, skip_serializing_if = "Option::is_none")]
    pub account_key: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl CosmosDbLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The CosmosDB (MongoDB API) database dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbMongoDbApiCollectionDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "CosmosDB (MongoDB API) database dataset properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: CosmosDbMongoDbApiCollectionDatasetTypeProperties,
}
impl CosmosDbMongoDbApiCollectionDataset {
    pub fn new(dataset: Dataset, type_properties: CosmosDbMongoDbApiCollectionDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "CosmosDB (MongoDB API) database dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbMongoDbApiCollectionDatasetTypeProperties {
    #[doc = "The collection name of the CosmosDB (MongoDB API) database. Type: string (or Expression with resultType string)."]
    pub collection: serde_json::Value,
}
impl CosmosDbMongoDbApiCollectionDatasetTypeProperties {
    pub fn new(collection: serde_json::Value) -> Self {
        Self { collection }
    }
}
#[doc = "Linked service for CosmosDB (MongoDB API) data source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbMongoDbApiLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "CosmosDB (MongoDB API) linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: CosmosDbMongoDbApiLinkedServiceTypeProperties,
}
impl CosmosDbMongoDbApiLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: CosmosDbMongoDbApiLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "CosmosDB (MongoDB API) linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbMongoDbApiLinkedServiceTypeProperties {
    #[doc = "The CosmosDB (MongoDB API) connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[doc = "The name of the CosmosDB (MongoDB API) database that you want to access. Type: string (or Expression with resultType string)."]
    pub database: serde_json::Value,
}
impl CosmosDbMongoDbApiLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value, database: serde_json::Value) -> Self {
        Self {
            connection_string,
            database,
        }
    }
}
#[doc = "A copy activity sink for a CosmosDB (MongoDB API) database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbMongoDbApiSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "Specifies whether the document with same key to be overwritten (upsert) rather than throw exception (insert). The default value is \"insert\". Type: string (or Expression with resultType string). Type: string (or Expression with resultType string)."]
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<serde_json::Value>,
}
impl CosmosDbMongoDbApiSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            write_behavior: None,
        }
    }
}
#[doc = "A copy activity source for a CosmosDB (MongoDB API) database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbMongoDbApiSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Specifies selection filter using query operators. To return all documents in a collection, omit this parameter or pass an empty document ({}). Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<serde_json::Value>,
    #[doc = "Cursor methods for Mongodb query"]
    #[serde(rename = "cursorMethods", default, skip_serializing_if = "Option::is_none")]
    pub cursor_methods: Option<MongoDbCursorMethodsProperties>,
    #[doc = "Specifies the number of documents to return in each batch of the response from MongoDB instance. In most cases, modifying the batch size will not affect the user or the application. This property's main purpose is to avoid hit the limitation of response size. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "batchSize", default, skip_serializing_if = "Option::is_none")]
    pub batch_size: Option<serde_json::Value>,
    #[doc = "Query timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<serde_json::Value>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl CosmosDbMongoDbApiSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            filter: None,
            cursor_methods: None,
            batch_size: None,
            query_timeout: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "Microsoft Azure CosmosDB (SQL API) Collection dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbSqlApiCollectionDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "CosmosDB (SQL API) Collection dataset properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: CosmosDbSqlApiCollectionDatasetTypeProperties,
}
impl CosmosDbSqlApiCollectionDataset {
    pub fn new(dataset: Dataset, type_properties: CosmosDbSqlApiCollectionDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "CosmosDB (SQL API) Collection dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbSqlApiCollectionDatasetTypeProperties {
    #[doc = "CosmosDB (SQL API) collection name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "collectionName")]
    pub collection_name: serde_json::Value,
}
impl CosmosDbSqlApiCollectionDatasetTypeProperties {
    pub fn new(collection_name: serde_json::Value) -> Self {
        Self { collection_name }
    }
}
#[doc = "A copy activity Azure CosmosDB (SQL API) Collection sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbSqlApiSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "Describes how to write data to Azure Cosmos DB. Type: string (or Expression with resultType string). Allowed values: insert and upsert."]
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<serde_json::Value>,
}
impl CosmosDbSqlApiSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            write_behavior: None,
        }
    }
}
#[doc = "A copy activity Azure CosmosDB (SQL API) Collection source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CosmosDbSqlApiSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "SQL API query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "Page size of the result. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "pageSize", default, skip_serializing_if = "Option::is_none")]
    pub page_size: Option<serde_json::Value>,
    #[doc = "Preferred regions. Type: array of strings (or Expression with resultType array of strings)."]
    #[serde(rename = "preferredRegions", default, skip_serializing_if = "Option::is_none")]
    pub preferred_regions: Option<serde_json::Value>,
    #[doc = "Whether detect primitive values as datetime values. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "detectDatetime", default, skip_serializing_if = "Option::is_none")]
    pub detect_datetime: Option<serde_json::Value>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl CosmosDbSqlApiSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            page_size: None,
            preferred_regions: None,
            detect_datetime: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "Couchbase server linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CouchbaseLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Couchbase server linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: CouchbaseLinkedServiceTypeProperties,
}
impl CouchbaseLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: CouchbaseLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Couchbase server linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CouchbaseLinkedServiceTypeProperties {
    #[doc = "An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(rename = "credString", default, skip_serializing_if = "Option::is_none")]
    pub cred_string: Option<AzureKeyVaultSecretReference>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl CouchbaseLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A copy activity Couchbase server source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CouchbaseSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl CouchbaseSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Couchbase server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CouchbaseTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl CouchbaseTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Request body structure for creating data flow debug session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateDataFlowDebugSessionRequest {
    #[doc = "Compute type of the cluster. The value will be overwritten by the same setting in integration runtime if provided."]
    #[serde(rename = "computeType", default, skip_serializing_if = "Option::is_none")]
    pub compute_type: Option<String>,
    #[doc = "Core count of the cluster. The value will be overwritten by the same setting in integration runtime if provided."]
    #[serde(rename = "coreCount", default, skip_serializing_if = "Option::is_none")]
    pub core_count: Option<i64>,
    #[doc = "Time to live setting of the cluster in minutes."]
    #[serde(rename = "timeToLive", default, skip_serializing_if = "Option::is_none")]
    pub time_to_live: Option<i64>,
    #[doc = "Integration runtime debug resource."]
    #[serde(rename = "integrationRuntime", default, skip_serializing_if = "Option::is_none")]
    pub integration_runtime: Option<IntegrationRuntimeDebugResource>,
}
impl CreateDataFlowDebugSessionRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response body structure for creating data flow debug session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CreateDataFlowDebugSessionResponse {
    #[doc = "The ID of data flow debug session."]
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
}
impl CreateDataFlowDebugSessionResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response body with a run identifier."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateRunResponse {
    #[doc = "Identifier of a run."]
    #[serde(rename = "runId")]
    pub run_id: String,
}
impl CreateRunResponse {
    pub fn new(run_id: String) -> Self {
        Self { run_id }
    }
}
#[doc = "Custom activity type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Custom activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: CustomActivityTypeProperties,
}
impl CustomActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: CustomActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "Reference objects for custom activity"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomActivityReferenceObject {
    #[doc = "Linked service references."]
    #[serde(rename = "linkedServices", default, skip_serializing_if = "Vec::is_empty")]
    pub linked_services: Vec<LinkedServiceReference>,
    #[doc = "Dataset references."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub datasets: Vec<DatasetReference>,
}
impl CustomActivityReferenceObject {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Custom activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomActivityTypeProperties {
    #[doc = "Command for custom activity Type: string (or Expression with resultType string)."]
    pub command: serde_json::Value,
    #[doc = "Linked service reference type."]
    #[serde(rename = "resourceLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub resource_linked_service: Option<LinkedServiceReference>,
    #[doc = "Folder path for resource files Type: string (or Expression with resultType string)."]
    #[serde(rename = "folderPath", default, skip_serializing_if = "Option::is_none")]
    pub folder_path: Option<serde_json::Value>,
    #[doc = "Reference objects for custom activity"]
    #[serde(rename = "referenceObjects", default, skip_serializing_if = "Option::is_none")]
    pub reference_objects: Option<CustomActivityReferenceObject>,
    #[doc = "User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity has the full responsibility to consume and interpret the content defined."]
    #[serde(rename = "extendedProperties", default, skip_serializing_if = "Option::is_none")]
    pub extended_properties: Option<serde_json::Value>,
    #[doc = "The retention time for the files submitted for custom activity. Type: double (or Expression with resultType double)."]
    #[serde(rename = "retentionTimeInDays", default, skip_serializing_if = "Option::is_none")]
    pub retention_time_in_days: Option<serde_json::Value>,
    #[doc = "Elevation level and scope for the user, default is nonadmin task. Type: string (or Expression with resultType double)."]
    #[serde(rename = "autoUserSpecification", default, skip_serializing_if = "Option::is_none")]
    pub auto_user_specification: Option<serde_json::Value>,
}
impl CustomActivityTypeProperties {
    pub fn new(command: serde_json::Value) -> Self {
        Self {
            command,
            resource_linked_service: None,
            folder_path: None,
            reference_objects: None,
            extended_properties: None,
            retention_time_in_days: None,
            auto_user_specification: None,
        }
    }
}
#[doc = "Custom linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomDataSourceLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Custom linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: serde_json::Value,
}
impl CustomDataSourceLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: serde_json::Value) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "The custom dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Custom dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<serde_json::Value>,
}
impl CustomDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Trigger that runs every time a custom event is received."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomEventsTrigger {
    #[serde(flatten)]
    pub multiple_pipeline_trigger: MultiplePipelineTrigger,
    #[doc = "Custom Events Trigger properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: custom_events_trigger::TypeProperties,
}
impl CustomEventsTrigger {
    pub fn new(multiple_pipeline_trigger: MultiplePipelineTrigger, type_properties: custom_events_trigger::TypeProperties) -> Self {
        Self {
            multiple_pipeline_trigger,
            type_properties,
        }
    }
}
pub mod custom_events_trigger {
    use super::*;
    #[doc = "Custom Events Trigger properties."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct TypeProperties {
        #[doc = "The event subject must begin with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith."]
        #[serde(rename = "subjectBeginsWith", default, skip_serializing_if = "Option::is_none")]
        pub subject_begins_with: Option<String>,
        #[doc = "The event subject must end with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith."]
        #[serde(rename = "subjectEndsWith", default, skip_serializing_if = "Option::is_none")]
        pub subject_ends_with: Option<String>,
        #[doc = "The list of event types that cause this trigger to fire."]
        pub events: Vec<serde_json::Value>,
        #[doc = "The ARM resource ID of the Azure Event Grid Topic."]
        pub scope: String,
    }
    impl TypeProperties {
        pub fn new(events: Vec<serde_json::Value>, scope: String) -> Self {
            Self {
                subject_begins_with: None,
                subject_ends_with: None,
                events,
                scope,
            }
        }
    }
}
#[doc = "Details of the customer managed key associated with the workspace"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomerManagedKeyDetails {
    #[doc = "The customer managed key status on the workspace"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "Details of the customer managed key associated with the workspace"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<WorkspaceKeyDetails>,
}
impl CustomerManagedKeyDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Default value."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DwCopyCommandDefaultValue {
    #[doc = "Column name. Type: object (or Expression with resultType string)."]
    #[serde(rename = "columnName", default, skip_serializing_if = "Option::is_none")]
    pub column_name: Option<serde_json::Value>,
    #[doc = "The default value of the column. Type: object (or Expression with resultType string)."]
    #[serde(rename = "defaultValue", default, skip_serializing_if = "Option::is_none")]
    pub default_value: Option<serde_json::Value>,
}
impl DwCopyCommandDefaultValue {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "DW Copy Command settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DwCopyCommandSettings {
    #[doc = "Specifies the default values for each target column in SQL DW. The default values in the property overwrite the DEFAULT constraint set in the DB, and identity column cannot have a default value. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "defaultValues", default, skip_serializing_if = "Vec::is_empty")]
    pub default_values: Vec<DwCopyCommandDefaultValue>,
    #[doc = "Additional options directly passed to SQL DW in Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: \"additionalOptions\": { \"MAXERRORS\": \"1000\", \"DATEFORMAT\": \"'ymd'\" }"]
    #[serde(rename = "additionalOptions", default, skip_serializing_if = "Option::is_none")]
    pub additional_options: Option<serde_json::Value>,
}
impl DwCopyCommandSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Synapse nested object which contains a flow with data movements and transformations."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFlow {
    #[doc = "Type of data flow."]
    #[serde(rename = "type")]
    pub type_: String,
    #[doc = "The description of the data flow."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "List of tags that can be used for describing the data flow."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub annotations: Vec<serde_json::Value>,
    #[doc = "The folder that this data flow is in. If not specified, Data flow will appear at the root level."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub folder: Option<data_flow::Folder>,
}
impl DataFlow {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            description: None,
            annotations: Vec::new(),
            folder: None,
        }
    }
}
pub mod data_flow {
    use super::*;
    #[doc = "The folder that this data flow is in. If not specified, Data flow will appear at the root level."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Folder {
        #[doc = "The name of the folder that this data flow is in."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
    }
    impl Folder {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Structure of command payload."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFlowDebugCommandPayload {
    #[doc = "The stream name which is used for preview."]
    #[serde(rename = "streamName")]
    pub stream_name: String,
    #[doc = "Row limits for preview response."]
    #[serde(rename = "rowLimits", default, skip_serializing_if = "Option::is_none")]
    pub row_limits: Option<i64>,
    #[doc = "Array of column names."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<String>,
    #[doc = "The expression which is used for preview."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expression: Option<String>,
}
impl DataFlowDebugCommandPayload {
    pub fn new(stream_name: String) -> Self {
        Self {
            stream_name,
            row_limits: None,
            columns: Vec::new(),
            expression: None,
        }
    }
}
#[doc = "Request body structure for data flow debug command."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFlowDebugCommandRequest {
    #[doc = "The ID of data flow debug session."]
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
    #[doc = "The command type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub command: Option<data_flow_debug_command_request::Command>,
    #[doc = "Structure of command payload."]
    #[serde(rename = "commandPayload", default, skip_serializing_if = "Option::is_none")]
    pub command_payload: Option<DataFlowDebugCommandPayload>,
}
impl DataFlowDebugCommandRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod data_flow_debug_command_request {
    use super::*;
    #[doc = "The command type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Command {
        #[serde(rename = "executePreviewQuery")]
        ExecutePreviewQuery,
        #[serde(rename = "executeStatisticsQuery")]
        ExecuteStatisticsQuery,
        #[serde(rename = "executeExpressionQuery")]
        ExecuteExpressionQuery,
    }
}
#[doc = "Response body structure of data flow result for data preview, statistics or expression preview."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFlowDebugCommandResponse {
    #[doc = "The run status of data preview, statistics or expression preview."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "The result data of data preview, statistics or expression preview."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<String>,
}
impl DataFlowDebugCommandResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Request body structure for starting data flow debug session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFlowDebugPackage {
    #[doc = "The ID of data flow debug session."]
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
    #[doc = "Data flow debug resource."]
    #[serde(rename = "dataFlow", default, skip_serializing_if = "Option::is_none")]
    pub data_flow: Option<DataFlowDebugResource>,
    #[doc = "List of Data flows"]
    #[serde(rename = "dataFlows", default, skip_serializing_if = "Vec::is_empty")]
    pub data_flows: Vec<DataFlowDebugResource>,
    #[doc = "List of datasets."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub datasets: Vec<DatasetDebugResource>,
    #[doc = "List of linked services."]
    #[serde(rename = "linkedServices", default, skip_serializing_if = "Vec::is_empty")]
    pub linked_services: Vec<LinkedServiceDebugResource>,
    #[doc = "Staging info for execute data flow activity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub staging: Option<DataFlowStagingInfo>,
    #[doc = "Data flow debug settings."]
    #[serde(rename = "debugSettings", default, skip_serializing_if = "Option::is_none")]
    pub debug_settings: Option<data_flow_debug_package::DebugSettings>,
}
impl DataFlowDebugPackage {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod data_flow_debug_package {
    use super::*;
    #[doc = "Data flow debug settings."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct DebugSettings {
        #[doc = "Source setting for data flow debug."]
        #[serde(rename = "sourceSettings", default, skip_serializing_if = "Vec::is_empty")]
        pub source_settings: Vec<DataFlowSourceSetting>,
        #[doc = "An object mapping parameter names to argument values."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub parameters: Option<ParameterValueSpecification>,
        #[doc = "Parameters for dataset."]
        #[serde(rename = "datasetParameters", default, skip_serializing_if = "Option::is_none")]
        pub dataset_parameters: Option<serde_json::Value>,
    }
    impl DebugSettings {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Request body structure for data flow preview data."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFlowDebugPreviewDataRequest {
    #[doc = "The ID of data flow debug session."]
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
    #[doc = "The data flow which contains the debug session."]
    #[serde(rename = "dataFlowName", default, skip_serializing_if = "Option::is_none")]
    pub data_flow_name: Option<String>,
    #[doc = "The output stream name."]
    #[serde(rename = "streamName", default, skip_serializing_if = "Option::is_none")]
    pub stream_name: Option<String>,
    #[doc = "The row limit for preview request."]
    #[serde(rename = "rowLimits", default, skip_serializing_if = "Option::is_none")]
    pub row_limits: Option<i64>,
}
impl DataFlowDebugPreviewDataRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response body structure of data flow query for data preview, statistics or expression preview."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFlowDebugQueryResponse {
    #[doc = "The run ID of data flow debug session."]
    #[serde(rename = "runId", default, skip_serializing_if = "Option::is_none")]
    pub run_id: Option<String>,
}
impl DataFlowDebugQueryResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Data flow debug resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFlowDebugResource {
    #[serde(flatten)]
    pub sub_resource_debug_resource: SubResourceDebugResource,
    #[doc = "Azure Synapse nested object which contains a flow with data movements and transformations."]
    pub properties: DataFlow,
}
impl DataFlowDebugResource {
    pub fn new(properties: DataFlow) -> Self {
        Self {
            sub_resource_debug_resource: SubResourceDebugResource::default(),
            properties,
        }
    }
}
#[doc = "Response body structure of data flow result for data preview, statistics or expression preview."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFlowDebugResultResponse {
    #[doc = "The run status of data preview, statistics or expression preview."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "The result data of data preview, statistics or expression preview."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<String>,
}
impl DataFlowDebugResultResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Data flow debug session info."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFlowDebugSessionInfo {
    #[doc = "The name of the data flow."]
    #[serde(rename = "dataFlowName", default, skip_serializing_if = "Option::is_none")]
    pub data_flow_name: Option<String>,
    #[doc = "Compute type of the cluster."]
    #[serde(rename = "computeType", default, skip_serializing_if = "Option::is_none")]
    pub compute_type: Option<String>,
    #[doc = "Core count of the cluster."]
    #[serde(rename = "coreCount", default, skip_serializing_if = "Option::is_none")]
    pub core_count: Option<i64>,
    #[doc = "Node count of the cluster. (deprecated property)"]
    #[serde(rename = "nodeCount", default, skip_serializing_if = "Option::is_none")]
    pub node_count: Option<i64>,
    #[doc = "Attached integration runtime name of data flow debug session."]
    #[serde(rename = "integrationRuntimeName", default, skip_serializing_if = "Option::is_none")]
    pub integration_runtime_name: Option<String>,
    #[doc = "The ID of data flow debug session."]
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
    #[doc = "Start time of data flow debug session."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "Compute type of the cluster."]
    #[serde(rename = "timeToLiveInMinutes", default, skip_serializing_if = "Option::is_none")]
    pub time_to_live_in_minutes: Option<i64>,
    #[doc = "Last activity time of data flow debug session."]
    #[serde(rename = "lastActivityTime", default, skip_serializing_if = "Option::is_none")]
    pub last_activity_time: Option<String>,
}
impl DataFlowDebugSessionInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Request body structure for data flow statistics."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFlowDebugStatisticsRequest {
    #[doc = "The ID of data flow debug session."]
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
    #[doc = "The data flow which contains the debug session."]
    #[serde(rename = "dataFlowName", default, skip_serializing_if = "Option::is_none")]
    pub data_flow_name: Option<String>,
    #[doc = "The output stream name."]
    #[serde(rename = "streamName", default, skip_serializing_if = "Option::is_none")]
    pub stream_name: Option<String>,
    #[doc = "List of column names."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<String>,
}
impl DataFlowDebugStatisticsRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of data flow resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFlowListResponse {
    #[doc = "List of data flows."]
    pub value: Vec<DataFlowResource>,
    #[doc = "The link to the next page of results, if any remaining results exist."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DataFlowListResponse {
    pub fn new(value: Vec<DataFlowResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Data flow reference type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFlowReference {
    #[doc = "Data flow reference type."]
    #[serde(rename = "type")]
    pub type_: data_flow_reference::Type,
    #[doc = "Reference data flow name."]
    #[serde(rename = "referenceName")]
    pub reference_name: String,
    #[doc = "Reference data flow parameters from dataset."]
    #[serde(rename = "datasetParameters", default, skip_serializing_if = "Option::is_none")]
    pub dataset_parameters: Option<serde_json::Value>,
}
impl DataFlowReference {
    pub fn new(type_: data_flow_reference::Type, reference_name: String) -> Self {
        Self {
            type_,
            reference_name,
            dataset_parameters: None,
        }
    }
}
pub mod data_flow_reference {
    use super::*;
    #[doc = "Data flow reference type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        DataFlowReference,
    }
}
#[doc = "Data flow resource type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFlowResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Azure Synapse nested object which contains a flow with data movements and transformations."]
    pub properties: DataFlow,
}
impl DataFlowResource {
    pub fn new(properties: DataFlow) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[doc = "Transformation for data flow sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFlowSink {
    #[serde(flatten)]
    pub transformation: Transformation,
    #[doc = "Dataset reference type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dataset: Option<DatasetReference>,
    #[doc = "Linked service reference type."]
    #[serde(rename = "linkedService", default, skip_serializing_if = "Option::is_none")]
    pub linked_service: Option<LinkedServiceReference>,
    #[doc = "Linked service reference type."]
    #[serde(rename = "schemaLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub schema_linked_service: Option<LinkedServiceReference>,
    #[doc = "Data flow reference type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub flowlet: Option<DataFlowReference>,
}
impl DataFlowSink {
    pub fn new(transformation: Transformation) -> Self {
        Self {
            transformation,
            dataset: None,
            linked_service: None,
            schema_linked_service: None,
            flowlet: None,
        }
    }
}
#[doc = "Transformation for data flow source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFlowSource {
    #[serde(flatten)]
    pub transformation: Transformation,
    #[doc = "Dataset reference type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dataset: Option<DatasetReference>,
    #[doc = "Linked service reference type."]
    #[serde(rename = "linkedService", default, skip_serializing_if = "Option::is_none")]
    pub linked_service: Option<LinkedServiceReference>,
    #[doc = "Linked service reference type."]
    #[serde(rename = "schemaLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub schema_linked_service: Option<LinkedServiceReference>,
    #[doc = "Data flow reference type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub flowlet: Option<DataFlowReference>,
}
impl DataFlowSource {
    pub fn new(transformation: Transformation) -> Self {
        Self {
            transformation,
            dataset: None,
            linked_service: None,
            schema_linked_service: None,
            flowlet: None,
        }
    }
}
#[doc = "Definition of data flow source setting for debug."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFlowSourceSetting {
    #[doc = "The data flow source name."]
    #[serde(rename = "sourceName", default, skip_serializing_if = "Option::is_none")]
    pub source_name: Option<String>,
    #[doc = "Defines the row limit of data flow source in debug."]
    #[serde(rename = "rowLimit", default, skip_serializing_if = "Option::is_none")]
    pub row_limit: Option<i64>,
}
impl DataFlowSourceSetting {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Staging info for execute data flow activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataFlowStagingInfo {
    #[doc = "Linked service reference type."]
    #[serde(rename = "linkedService", default, skip_serializing_if = "Option::is_none")]
    pub linked_service: Option<LinkedServiceReference>,
    #[doc = "Folder path for staging blob."]
    #[serde(rename = "folderPath", default, skip_serializing_if = "Option::is_none")]
    pub folder_path: Option<String>,
}
impl DataFlowStagingInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Data Lake Analytics U-SQL activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataLakeAnalyticsUsqlActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "DataLakeAnalyticsU-SQL activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: DataLakeAnalyticsUsqlActivityTypeProperties,
}
impl DataLakeAnalyticsUsqlActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: DataLakeAnalyticsUsqlActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "DataLakeAnalyticsU-SQL activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataLakeAnalyticsUsqlActivityTypeProperties {
    #[doc = "Case-sensitive path to folder that contains the U-SQL script. Type: string (or Expression with resultType string)."]
    #[serde(rename = "scriptPath")]
    pub script_path: serde_json::Value,
    #[doc = "Linked service reference type."]
    #[serde(rename = "scriptLinkedService")]
    pub script_linked_service: LinkedServiceReference,
    #[doc = "The maximum number of nodes simultaneously used to run the job. Default value is 1. Type: integer (or Expression with resultType integer), minimum: 1."]
    #[serde(rename = "degreeOfParallelism", default, skip_serializing_if = "Option::is_none")]
    pub degree_of_parallelism: Option<serde_json::Value>,
    #[doc = "Determines which jobs out of all that are queued should be selected to run first. The lower the number, the higher the priority. Default value is 1000. Type: integer (or Expression with resultType integer), minimum: 1."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<serde_json::Value>,
    #[doc = "Parameters for U-SQL job request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<serde_json::Value>,
    #[doc = "Runtime version of the U-SQL engine to use. Type: string (or Expression with resultType string)."]
    #[serde(rename = "runtimeVersion", default, skip_serializing_if = "Option::is_none")]
    pub runtime_version: Option<serde_json::Value>,
    #[doc = "Compilation mode of U-SQL. Must be one of these values : Semantic, Full and SingleBox. Type: string (or Expression with resultType string)."]
    #[serde(rename = "compilationMode", default, skip_serializing_if = "Option::is_none")]
    pub compilation_mode: Option<serde_json::Value>,
}
impl DataLakeAnalyticsUsqlActivityTypeProperties {
    pub fn new(script_path: serde_json::Value, script_linked_service: LinkedServiceReference) -> Self {
        Self {
            script_path,
            script_linked_service,
            degree_of_parallelism: None,
            priority: None,
            parameters: None,
            runtime_version: None,
            compilation_mode: None,
        }
    }
}
#[doc = "Details of the data lake storage account associated with the workspace"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataLakeStorageAccountDetails {
    #[doc = "Account URL"]
    #[serde(rename = "accountUrl", default, skip_serializing_if = "Option::is_none")]
    pub account_url: Option<String>,
    #[doc = "Filesystem name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filesystem: Option<String>,
}
impl DataLakeStorageAccountDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "DatabricksNotebook activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabricksNotebookActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Databricks Notebook activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: DatabricksNotebookActivityTypeProperties,
}
impl DatabricksNotebookActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: DatabricksNotebookActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "Databricks Notebook activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabricksNotebookActivityTypeProperties {
    #[doc = "The absolute path of the notebook to be run in the Databricks Workspace. This path must begin with a slash. Type: string (or Expression with resultType string)."]
    #[serde(rename = "notebookPath")]
    pub notebook_path: serde_json::Value,
    #[doc = "Base parameters to be used for each run of this job.If the notebook takes a parameter that is not specified, the default value from the notebook will be used."]
    #[serde(rename = "baseParameters", default, skip_serializing_if = "Option::is_none")]
    pub base_parameters: Option<serde_json::Value>,
    #[doc = "A list of libraries to be installed on the cluster that will execute the job."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub libraries: Vec<serde_json::Value>,
}
impl DatabricksNotebookActivityTypeProperties {
    pub fn new(notebook_path: serde_json::Value) -> Self {
        Self {
            notebook_path,
            base_parameters: None,
            libraries: Vec::new(),
        }
    }
}
#[doc = "DatabricksSparkJar activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabricksSparkJarActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Databricks SparkJar activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: DatabricksSparkJarActivityTypeProperties,
}
impl DatabricksSparkJarActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: DatabricksSparkJarActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "Databricks SparkJar activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabricksSparkJarActivityTypeProperties {
    #[doc = "The full name of the class containing the main method to be executed. This class must be contained in a JAR provided as a library. Type: string (or Expression with resultType string)."]
    #[serde(rename = "mainClassName")]
    pub main_class_name: serde_json::Value,
    #[doc = "Parameters that will be passed to the main method."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<serde_json::Value>,
    #[doc = "A list of libraries to be installed on the cluster that will execute the job."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub libraries: Vec<serde_json::Value>,
}
impl DatabricksSparkJarActivityTypeProperties {
    pub fn new(main_class_name: serde_json::Value) -> Self {
        Self {
            main_class_name,
            parameters: Vec::new(),
            libraries: Vec::new(),
        }
    }
}
#[doc = "DatabricksSparkPython activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabricksSparkPythonActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Databricks SparkPython activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: DatabricksSparkPythonActivityTypeProperties,
}
impl DatabricksSparkPythonActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: DatabricksSparkPythonActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "Databricks SparkPython activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatabricksSparkPythonActivityTypeProperties {
    #[doc = "The URI of the Python file to be executed. DBFS paths are supported. Type: string (or Expression with resultType string)."]
    #[serde(rename = "pythonFile")]
    pub python_file: serde_json::Value,
    #[doc = "Command line parameters that will be passed to the Python file."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub parameters: Vec<serde_json::Value>,
    #[doc = "A list of libraries to be installed on the cluster that will execute the job."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub libraries: Vec<serde_json::Value>,
}
impl DatabricksSparkPythonActivityTypeProperties {
    pub fn new(python_file: serde_json::Value) -> Self {
        Self {
            python_file,
            parameters: Vec::new(),
            libraries: Vec::new(),
        }
    }
}
#[doc = "The Azure Data Factory nested object which identifies data within different data stores, such as tables, files, folders, and documents."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Dataset {
    #[doc = "Type of dataset."]
    #[serde(rename = "type")]
    pub type_: String,
    #[doc = "Dataset description."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub structure: Option<serde_json::Value>,
    #[doc = "Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[doc = "Linked service reference type."]
    #[serde(rename = "linkedServiceName")]
    pub linked_service_name: LinkedServiceReference,
    #[doc = "Definition of all parameters for an entity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterDefinitionSpecification>,
    #[doc = "List of tags that can be used for describing the Dataset."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub annotations: Vec<serde_json::Value>,
    #[doc = "The folder that this Dataset is in. If not specified, Dataset will appear at the root level."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub folder: Option<dataset::Folder>,
}
impl Dataset {
    pub fn new(type_: String, linked_service_name: LinkedServiceReference) -> Self {
        Self {
            type_,
            description: None,
            structure: None,
            schema: None,
            linked_service_name,
            parameters: None,
            annotations: Vec::new(),
            folder: None,
        }
    }
}
pub mod dataset {
    use super::*;
    #[doc = "The folder that this Dataset is in. If not specified, Dataset will appear at the root level."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Folder {
        #[doc = "The name of the folder that this Dataset is in."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
    }
    impl Folder {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "The BZip2 compression method used on a dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetBZip2Compression {
    #[serde(flatten)]
    pub dataset_compression: DatasetCompression,
}
impl DatasetBZip2Compression {
    pub fn new(dataset_compression: DatasetCompression) -> Self {
        Self { dataset_compression }
    }
}
#[doc = "The compression method used on a dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetCompression {
    #[doc = "Type of dataset compression."]
    #[serde(rename = "type")]
    pub type_: String,
}
impl DatasetCompression {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DatasetCompressionLevelEnum {
    Optimal,
    Fastest,
}
#[doc = "Columns that define the structure of the dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatasetDataElement {
    #[doc = "Name of the column. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<serde_json::Value>,
    #[doc = "Type of the column. Type: string (or Expression with resultType string)."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<serde_json::Value>,
}
impl DatasetDataElement {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Dataset debug resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetDebugResource {
    #[serde(flatten)]
    pub sub_resource_debug_resource: SubResourceDebugResource,
    #[doc = "The Azure Data Factory nested object which identifies data within different data stores, such as tables, files, folders, and documents."]
    pub properties: Dataset,
}
impl DatasetDebugResource {
    pub fn new(properties: Dataset) -> Self {
        Self {
            sub_resource_debug_resource: SubResourceDebugResource::default(),
            properties,
        }
    }
}
#[doc = "The Deflate compression method used on a dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetDeflateCompression {
    #[serde(flatten)]
    pub dataset_compression: DatasetCompression,
    #[doc = "All available compression levels."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<CompressionLevel>,
}
impl DatasetDeflateCompression {
    pub fn new(dataset_compression: DatasetCompression) -> Self {
        Self {
            dataset_compression,
            level: None,
        }
    }
}
#[doc = "The GZip compression method used on a dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetGZipCompression {
    #[serde(flatten)]
    pub dataset_compression: DatasetCompression,
    #[doc = "All available compression levels."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<CompressionLevel>,
}
impl DatasetGZipCompression {
    pub fn new(dataset_compression: DatasetCompression) -> Self {
        Self {
            dataset_compression,
            level: None,
        }
    }
}
#[doc = "A list of dataset resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetListResponse {
    #[doc = "List of datasets."]
    pub value: Vec<DatasetResource>,
    #[doc = "The link to the next page of results, if any remaining results exist."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl DatasetListResponse {
    pub fn new(value: Vec<DatasetResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Dataset location."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetLocation {
    #[doc = "Type of dataset storage location."]
    #[serde(rename = "type")]
    pub type_: String,
    #[doc = "Specify the folder path of dataset. Type: string (or Expression with resultType string)"]
    #[serde(rename = "folderPath", default, skip_serializing_if = "Option::is_none")]
    pub folder_path: Option<serde_json::Value>,
    #[doc = "Specify the file name of dataset. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileName", default, skip_serializing_if = "Option::is_none")]
    pub file_name: Option<serde_json::Value>,
}
impl DatasetLocation {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            folder_path: None,
            file_name: None,
        }
    }
}
#[doc = "Dataset reference type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetReference {
    #[doc = "Dataset reference type."]
    #[serde(rename = "type")]
    pub type_: dataset_reference::Type,
    #[doc = "Reference dataset name."]
    #[serde(rename = "referenceName")]
    pub reference_name: String,
    #[doc = "An object mapping parameter names to argument values."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterValueSpecification>,
}
impl DatasetReference {
    pub fn new(type_: dataset_reference::Type, reference_name: String) -> Self {
        Self {
            type_,
            reference_name,
            parameters: None,
        }
    }
}
pub mod dataset_reference {
    use super::*;
    #[doc = "Dataset reference type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        DatasetReference,
    }
}
#[doc = "Dataset resource type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "The Azure Data Factory nested object which identifies data within different data stores, such as tables, files, folders, and documents."]
    pub properties: Dataset,
}
impl DatasetResource {
    pub fn new(properties: Dataset) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[doc = "Columns that define the physical type schema of the dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DatasetSchemaDataElement {
    #[doc = "Name of the schema column. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<serde_json::Value>,
    #[doc = "Type of the schema column. Type: string (or Expression with resultType string)."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<serde_json::Value>,
}
impl DatasetSchemaDataElement {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The format definition of a storage."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetStorageFormat {
    #[doc = "Type of dataset storage format."]
    #[serde(rename = "type")]
    pub type_: String,
    #[doc = "Serializer. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub serializer: Option<serde_json::Value>,
    #[doc = "Deserializer. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub deserializer: Option<serde_json::Value>,
}
impl DatasetStorageFormat {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            serializer: None,
            deserializer: None,
        }
    }
}
#[doc = "The Tar archive method used on a dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetTarCompression {
    #[serde(flatten)]
    pub dataset_compression: DatasetCompression,
}
impl DatasetTarCompression {
    pub fn new(dataset_compression: DatasetCompression) -> Self {
        Self { dataset_compression }
    }
}
#[doc = "The TarGZip compression method used on a dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetTarGZipCompression {
    #[serde(flatten)]
    pub dataset_compression: DatasetCompression,
    #[doc = "All available compression levels."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<CompressionLevel>,
}
impl DatasetTarGZipCompression {
    pub fn new(dataset_compression: DatasetCompression) -> Self {
        Self {
            dataset_compression,
            level: None,
        }
    }
}
#[doc = "The ZipDeflate compression method used on a dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DatasetZipDeflateCompression {
    #[serde(flatten)]
    pub dataset_compression: DatasetCompression,
    #[doc = "All available compression levels."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub level: Option<CompressionLevel>,
}
impl DatasetZipDeflateCompression {
    pub fn new(dataset_compression: DatasetCompression) -> Self {
        Self {
            dataset_compression,
            level: None,
        }
    }
}
#[doc = "The days of the week."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DayOfWeek {
    Sunday,
    Monday,
    Tuesday,
    Wednesday,
    Thursday,
    Friday,
    Saturday,
}
#[doc = "Linked service for DB2 data source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Db2LinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "DB2 linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: Db2LinkedServiceTypeProperties,
}
impl Db2LinkedService {
    pub fn new(linked_service: LinkedService, type_properties: Db2LinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "DB2 linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Db2LinkedServiceTypeProperties {
    #[doc = "The connection string. It is mutually exclusive with server, database, authenticationType, userName, packageCollection and certificateCommonName property. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[doc = "Server name for connection. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string)."]
    pub server: serde_json::Value,
    #[doc = "Database name for connection. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string)."]
    pub database: serde_json::Value,
    #[doc = "AuthenticationType to be used for connection. It is mutually exclusive with connectionString property."]
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<db2_linked_service_type_properties::AuthenticationType>,
    #[doc = "Username for authentication. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "Under where packages are created when querying database. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string)."]
    #[serde(rename = "packageCollection", default, skip_serializing_if = "Option::is_none")]
    pub package_collection: Option<serde_json::Value>,
    #[doc = "Certificate Common Name when TLS is enabled. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string)."]
    #[serde(rename = "certificateCommonName", default, skip_serializing_if = "Option::is_none")]
    pub certificate_common_name: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl Db2LinkedServiceTypeProperties {
    pub fn new(server: serde_json::Value, database: serde_json::Value) -> Self {
        Self {
            connection_string: None,
            server,
            database,
            authentication_type: None,
            username: None,
            password: None,
            package_collection: None,
            certificate_common_name: None,
            encrypted_credential: None,
        }
    }
}
pub mod db2_linked_service_type_properties {
    use super::*;
    #[doc = "AuthenticationType to be used for connection. It is mutually exclusive with connectionString property."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
    }
}
#[doc = "A copy activity source for Db2 databases."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Db2Source {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "Database query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl Db2Source {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "The Db2 table dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Db2TableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Db2 table dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<Db2TableDatasetTypeProperties>,
}
impl Db2TableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Db2 table dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Db2TableDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The Db2 schema name. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[doc = "The Db2 table name. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl Db2TableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Delete activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeleteActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Delete activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: DeleteActivityTypeProperties,
}
impl DeleteActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: DeleteActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "Delete activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeleteActivityTypeProperties {
    #[doc = "If true, files or sub-folders under current folder path will be deleted recursively. Default is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[doc = "The max concurrent connections to connect data source at the same time."]
    #[serde(rename = "maxConcurrentConnections", default, skip_serializing_if = "Option::is_none")]
    pub max_concurrent_connections: Option<i64>,
    #[doc = "Whether to record detailed logs of delete-activity execution. Default value is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "enableLogging", default, skip_serializing_if = "Option::is_none")]
    pub enable_logging: Option<serde_json::Value>,
    #[doc = "(Deprecated. Please use LogSettings) Log storage settings."]
    #[serde(rename = "logStorageSettings", default, skip_serializing_if = "Option::is_none")]
    pub log_storage_settings: Option<LogStorageSettings>,
    #[doc = "Dataset reference type."]
    pub dataset: DatasetReference,
    #[doc = "Connector read setting."]
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
}
impl DeleteActivityTypeProperties {
    pub fn new(dataset: DatasetReference) -> Self {
        Self {
            recursive: None,
            max_concurrent_connections: None,
            enable_logging: None,
            log_storage_settings: None,
            dataset,
            store_settings: None,
        }
    }
}
#[doc = "Request body structure for deleting data flow debug session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeleteDataFlowDebugSessionRequest {
    #[doc = "The ID of data flow debug session."]
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
}
impl DeleteDataFlowDebugSessionRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Delimited text dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DelimitedTextDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "DelimitedText dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<DelimitedTextDatasetTypeProperties>,
}
impl DelimitedTextDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "DelimitedText dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DelimitedTextDatasetTypeProperties {
    #[doc = "Dataset location."]
    pub location: DatasetLocation,
    #[doc = "The column delimiter. Type: string (or Expression with resultType string)."]
    #[serde(rename = "columnDelimiter", default, skip_serializing_if = "Option::is_none")]
    pub column_delimiter: Option<serde_json::Value>,
    #[doc = "The row delimiter. Type: string (or Expression with resultType string)."]
    #[serde(rename = "rowDelimiter", default, skip_serializing_if = "Option::is_none")]
    pub row_delimiter: Option<serde_json::Value>,
    #[doc = "The code page name of the preferred encoding. If miss, the default value is UTF-8, unless BOM denotes another Unicode encoding. Refer to the name column of the table in the following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encodingName", default, skip_serializing_if = "Option::is_none")]
    pub encoding_name: Option<serde_json::Value>,
    #[serde(rename = "compressionCodec", default, skip_serializing_if = "Option::is_none")]
    pub compression_codec: Option<delimited_text_dataset_type_properties::CompressionCodec>,
    #[doc = "All available compression levels."]
    #[serde(rename = "compressionLevel", default, skip_serializing_if = "Option::is_none")]
    pub compression_level: Option<CompressionLevel>,
    #[doc = "The quote character. Type: string (or Expression with resultType string)."]
    #[serde(rename = "quoteChar", default, skip_serializing_if = "Option::is_none")]
    pub quote_char: Option<serde_json::Value>,
    #[doc = "The escape character. Type: string (or Expression with resultType string)."]
    #[serde(rename = "escapeChar", default, skip_serializing_if = "Option::is_none")]
    pub escape_char: Option<serde_json::Value>,
    #[doc = "When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "firstRowAsHeader", default, skip_serializing_if = "Option::is_none")]
    pub first_row_as_header: Option<serde_json::Value>,
    #[doc = "The null value string. Type: string (or Expression with resultType string)."]
    #[serde(rename = "nullValue", default, skip_serializing_if = "Option::is_none")]
    pub null_value: Option<serde_json::Value>,
}
impl DelimitedTextDatasetTypeProperties {
    pub fn new(location: DatasetLocation) -> Self {
        Self {
            location,
            column_delimiter: None,
            row_delimiter: None,
            encoding_name: None,
            compression_codec: None,
            compression_level: None,
            quote_char: None,
            escape_char: None,
            first_row_as_header: None,
            null_value: None,
        }
    }
}
pub mod delimited_text_dataset_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CompressionCodec {
        #[serde(rename = "bzip2")]
        Bzip2,
        #[serde(rename = "gzip")]
        Gzip,
        #[serde(rename = "deflate")]
        Deflate,
        #[serde(rename = "zipDeflate")]
        ZipDeflate,
        #[serde(rename = "snappy")]
        Snappy,
        #[serde(rename = "lz4")]
        Lz4,
        #[serde(rename = "tar")]
        Tar,
        #[serde(rename = "tarGZip")]
        TarGZip,
    }
}
#[doc = "Delimited text read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DelimitedTextReadSettings {
    #[serde(flatten)]
    pub format_read_settings: FormatReadSettings,
    #[doc = "Indicates the number of non-empty rows to skip when reading data from input files. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "skipLineCount", default, skip_serializing_if = "Option::is_none")]
    pub skip_line_count: Option<serde_json::Value>,
    #[doc = "Compression read settings."]
    #[serde(rename = "compressionProperties", default, skip_serializing_if = "Option::is_none")]
    pub compression_properties: Option<CompressionReadSettings>,
}
impl DelimitedTextReadSettings {
    pub fn new(format_read_settings: FormatReadSettings) -> Self {
        Self {
            format_read_settings,
            skip_line_count: None,
            compression_properties: None,
        }
    }
}
#[doc = "A copy activity DelimitedText sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DelimitedTextSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "Connector write settings."]
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreWriteSettings>,
    #[doc = "Delimited text write settings."]
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<DelimitedTextWriteSettings>,
}
impl DelimitedTextSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            store_settings: None,
            format_settings: None,
        }
    }
}
#[doc = "A copy activity DelimitedText source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DelimitedTextSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Connector read setting."]
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[doc = "Delimited text read settings."]
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<DelimitedTextReadSettings>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl DelimitedTextSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            store_settings: None,
            format_settings: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "Delimited text write settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DelimitedTextWriteSettings {
    #[serde(flatten)]
    pub format_write_settings: FormatWriteSettings,
    #[doc = "Indicates whether string values should always be enclosed with quotes. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "quoteAllText", default, skip_serializing_if = "Option::is_none")]
    pub quote_all_text: Option<serde_json::Value>,
    #[doc = "The file extension used to create the files. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileExtension")]
    pub file_extension: serde_json::Value,
    #[doc = "Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "maxRowsPerFile", default, skip_serializing_if = "Option::is_none")]
    pub max_rows_per_file: Option<serde_json::Value>,
    #[doc = "Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileNamePrefix", default, skip_serializing_if = "Option::is_none")]
    pub file_name_prefix: Option<serde_json::Value>,
}
impl DelimitedTextWriteSettings {
    pub fn new(format_write_settings: FormatWriteSettings, file_extension: serde_json::Value) -> Self {
        Self {
            format_write_settings,
            quote_all_text: None,
            file_extension,
            max_rows_per_file: None,
            file_name_prefix: None,
        }
    }
}
#[doc = "Referenced dependency."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DependencyReference {
    #[doc = "The type of dependency reference."]
    #[serde(rename = "type")]
    pub type_: String,
}
impl DependencyReference {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[doc = "Distcp settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DistcpSettings {
    #[doc = "Specifies the Yarn ResourceManager endpoint. Type: string (or Expression with resultType string)."]
    #[serde(rename = "resourceManagerEndpoint")]
    pub resource_manager_endpoint: serde_json::Value,
    #[doc = "Specifies an existing folder path which will be used to store temp Distcp command script. The script file is generated by ADF and will be removed after Copy job finished. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tempScriptPath")]
    pub temp_script_path: serde_json::Value,
    #[doc = "Specifies the Distcp options. Type: string (or Expression with resultType string)."]
    #[serde(rename = "distcpOptions", default, skip_serializing_if = "Option::is_none")]
    pub distcp_options: Option<serde_json::Value>,
}
impl DistcpSettings {
    pub fn new(resource_manager_endpoint: serde_json::Value, temp_script_path: serde_json::Value) -> Self {
        Self {
            resource_manager_endpoint,
            temp_script_path,
            distcp_options: None,
        }
    }
}
#[doc = "Microsoft Azure Document Database Collection dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DocumentDbCollectionDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "DocumentDB Collection dataset properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: DocumentDbCollectionDatasetTypeProperties,
}
impl DocumentDbCollectionDataset {
    pub fn new(dataset: Dataset, type_properties: DocumentDbCollectionDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "DocumentDB Collection dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DocumentDbCollectionDatasetTypeProperties {
    #[doc = "Document Database collection name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "collectionName")]
    pub collection_name: serde_json::Value,
}
impl DocumentDbCollectionDatasetTypeProperties {
    pub fn new(collection_name: serde_json::Value) -> Self {
        Self { collection_name }
    }
}
#[doc = "A copy activity Document Database Collection sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DocumentDbCollectionSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "Nested properties separator. Default is . (dot). Type: string (or Expression with resultType string)."]
    #[serde(rename = "nestingSeparator", default, skip_serializing_if = "Option::is_none")]
    pub nesting_separator: Option<serde_json::Value>,
    #[doc = "Describes how to write data to Azure Cosmos DB. Type: string (or Expression with resultType string). Allowed values: insert and upsert."]
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<serde_json::Value>,
}
impl DocumentDbCollectionSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            nesting_separator: None,
            write_behavior: None,
        }
    }
}
#[doc = "A copy activity Document Database Collection source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DocumentDbCollectionSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Documents query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "Nested properties separator. Type: string (or Expression with resultType string)."]
    #[serde(rename = "nestingSeparator", default, skip_serializing_if = "Option::is_none")]
    pub nesting_separator: Option<serde_json::Value>,
    #[doc = "Query timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<serde_json::Value>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl DocumentDbCollectionSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            nesting_separator: None,
            query_timeout: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "Drill Dataset Properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DrillDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The table name of the Drill. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[doc = "The schema name of the Drill. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl DrillDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Drill server linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DrillLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Drill server linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: DrillLinkedServiceTypeProperties,
}
impl DrillLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: DrillLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Drill server linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DrillLinkedServiceTypeProperties {
    #[doc = "An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pwd: Option<AzureKeyVaultSecretReference>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl DrillLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A copy activity Drill server source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DrillSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl DrillSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Drill server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DrillTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Drill Dataset Properties"]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<DrillDatasetTypeProperties>,
}
impl DrillTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Dynamic Executor Allocation Properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DynamicExecutorAllocation {
    #[doc = "Indicates whether Dynamic Executor Allocation is enabled or not."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl DynamicExecutorAllocation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Dynamics AX linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsAxLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Dynamics AX linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: DynamicsAxLinkedServiceTypeProperties,
}
impl DynamicsAxLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: DynamicsAxLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Dynamics AX linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsAxLinkedServiceTypeProperties {
    #[doc = "The Dynamics AX (or Dynamics 365 Finance and Operations) instance OData endpoint."]
    pub url: serde_json::Value,
    #[doc = "Specify the application's client ID. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId")]
    pub service_principal_id: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalKey")]
    pub service_principal_key: SecretBase,
    #[doc = "Specify the tenant information (domain name or tenant ID) under which your application resides. Retrieve it by hovering the mouse in the top-right corner of the Azure portal. Type: string (or Expression with resultType string)."]
    pub tenant: serde_json::Value,
    #[doc = "Specify the resource you are requesting authorization. Type: string (or Expression with resultType string)."]
    #[serde(rename = "aadResourceId")]
    pub aad_resource_id: serde_json::Value,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl DynamicsAxLinkedServiceTypeProperties {
    pub fn new(
        url: serde_json::Value,
        service_principal_id: serde_json::Value,
        service_principal_key: SecretBase,
        tenant: serde_json::Value,
        aad_resource_id: serde_json::Value,
    ) -> Self {
        Self {
            url,
            service_principal_id,
            service_principal_key,
            tenant,
            aad_resource_id,
            encrypted_credential: None,
        }
    }
}
#[doc = "The path of the Dynamics AX OData entity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsAxResourceDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Dynamics AX OData resource dataset properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: DynamicsAxResourceDatasetTypeProperties,
}
impl DynamicsAxResourceDataset {
    pub fn new(dataset: Dataset, type_properties: DynamicsAxResourceDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "Dynamics AX OData resource dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsAxResourceDatasetTypeProperties {
    #[doc = "The path of the Dynamics AX OData entity. Type: string (or Expression with resultType string)."]
    pub path: serde_json::Value,
}
impl DynamicsAxResourceDatasetTypeProperties {
    pub fn new(path: serde_json::Value) -> Self {
        Self { path }
    }
}
#[doc = "A copy activity Dynamics AX source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsAxSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data. Default value: 00:05:00. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
}
impl DynamicsAxSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            http_request_timeout: None,
        }
    }
}
#[doc = "The Dynamics CRM entity dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsCrmEntityDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Dynamics CRM entity dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<DynamicsCrmEntityDatasetTypeProperties>,
}
impl DynamicsCrmEntityDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Dynamics CRM entity dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DynamicsCrmEntityDatasetTypeProperties {
    #[doc = "The logical name of the entity. Type: string (or Expression with resultType string)."]
    #[serde(rename = "entityName", default, skip_serializing_if = "Option::is_none")]
    pub entity_name: Option<serde_json::Value>,
}
impl DynamicsCrmEntityDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Dynamics CRM linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsCrmLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Dynamics CRM linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: DynamicsCrmLinkedServiceTypeProperties,
}
impl DynamicsCrmLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: DynamicsCrmLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Dynamics CRM linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsCrmLinkedServiceTypeProperties {
    #[doc = "The deployment type of the Dynamics CRM instance. 'Online' for Dynamics CRM Online and 'OnPremisesWithIfd' for Dynamics CRM on-premises with Ifd. Type: string (or Expression with resultType string)."]
    #[serde(rename = "deploymentType")]
    pub deployment_type: dynamics_crm_linked_service_type_properties::DeploymentType,
    #[doc = "The host name of the on-premises Dynamics CRM server. The property is required for on-prem and not allowed for online. Type: string (or Expression with resultType string)."]
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<serde_json::Value>,
    #[doc = "The port of on-premises Dynamics CRM server. The property is required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression with resultType integer), minimum: 0."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[doc = "The URL to the Microsoft Dynamics CRM server. The property is required for on-line and not allowed for on-prem. Type: string (or Expression with resultType string)."]
    #[serde(rename = "serviceUri", default, skip_serializing_if = "Option::is_none")]
    pub service_uri: Option<serde_json::Value>,
    #[doc = "The organization name of the Dynamics CRM instance. The property is required for on-prem and required for online when there are more than one Dynamics CRM instances associated with the user. Type: string (or Expression with resultType string)."]
    #[serde(rename = "organizationName", default, skip_serializing_if = "Option::is_none")]
    pub organization_name: Option<serde_json::Value>,
    #[doc = "The authentication type to connect to Dynamics CRM server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario, 'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or Expression with resultType string)."]
    #[serde(rename = "authenticationType")]
    pub authentication_type: dynamics_crm_linked_service_type_properties::AuthenticationType,
    #[doc = "User name to access the Dynamics CRM instance. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[doc = "A string from ServicePrincipalCredentialEnum or an expression"]
    #[serde(rename = "servicePrincipalCredentialType", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_credential_type: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalCredential", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_credential: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl DynamicsCrmLinkedServiceTypeProperties {
    pub fn new(
        deployment_type: dynamics_crm_linked_service_type_properties::DeploymentType,
        authentication_type: dynamics_crm_linked_service_type_properties::AuthenticationType,
    ) -> Self {
        Self {
            deployment_type,
            host_name: None,
            port: None,
            service_uri: None,
            organization_name: None,
            authentication_type,
            username: None,
            password: None,
            service_principal_id: None,
            service_principal_credential_type: None,
            service_principal_credential: None,
            encrypted_credential: None,
        }
    }
}
pub mod dynamics_crm_linked_service_type_properties {
    use super::*;
    #[doc = "The deployment type of the Dynamics CRM instance. 'Online' for Dynamics CRM Online and 'OnPremisesWithIfd' for Dynamics CRM on-premises with Ifd. Type: string (or Expression with resultType string)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeploymentType {
        Online,
        OnPremisesWithIfd,
    }
    #[doc = "The authentication type to connect to Dynamics CRM server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario, 'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or Expression with resultType string)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Office365,
        Ifd,
        #[serde(rename = "AADServicePrincipal")]
        AadServicePrincipal,
    }
}
#[doc = "A copy activity Dynamics CRM sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsCrmSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "Defines values for DynamicsSinkWriteBehavior."]
    #[serde(rename = "writeBehavior")]
    pub write_behavior: DynamicsSinkWriteBehavior,
    #[doc = "The flag indicating whether to ignore null values from input dataset (except key fields) during write operation. Default is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "ignoreNullValues", default, skip_serializing_if = "Option::is_none")]
    pub ignore_null_values: Option<serde_json::Value>,
    #[doc = "The logical name of the alternate key which will be used when upserting records. Type: string (or Expression with resultType string)."]
    #[serde(rename = "alternateKeyName", default, skip_serializing_if = "Option::is_none")]
    pub alternate_key_name: Option<serde_json::Value>,
}
impl DynamicsCrmSink {
    pub fn new(copy_sink: CopySink, write_behavior: DynamicsSinkWriteBehavior) -> Self {
        Self {
            copy_sink,
            write_behavior,
            ignore_null_values: None,
            alternate_key_name: None,
        }
    }
}
#[doc = "A copy activity Dynamics CRM source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsCrmSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "FetchXML is a proprietary query language that is used in Microsoft Dynamics CRM (online & on-premises). Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl DynamicsCrmSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "The Dynamics entity dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsEntityDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Dynamics entity dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<DynamicsEntityDatasetTypeProperties>,
}
impl DynamicsEntityDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Dynamics entity dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DynamicsEntityDatasetTypeProperties {
    #[doc = "The logical name of the entity. Type: string (or Expression with resultType string)."]
    #[serde(rename = "entityName", default, skip_serializing_if = "Option::is_none")]
    pub entity_name: Option<serde_json::Value>,
}
impl DynamicsEntityDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Dynamics linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Dynamics linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: DynamicsLinkedServiceTypeProperties,
}
impl DynamicsLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: DynamicsLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Dynamics linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsLinkedServiceTypeProperties {
    #[doc = "The deployment type of the Dynamics instance. 'Online' for Dynamics Online and 'OnPremisesWithIfd' for Dynamics on-premises with Ifd. Type: string (or Expression with resultType string)."]
    #[serde(rename = "deploymentType")]
    pub deployment_type: dynamics_linked_service_type_properties::DeploymentType,
    #[doc = "The host name of the on-premises Dynamics server. The property is required for on-prem and not allowed for online. Type: string (or Expression with resultType string)."]
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<serde_json::Value>,
    #[doc = "The port of on-premises Dynamics server. The property is required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression with resultType integer), minimum: 0."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[doc = "The URL to the Microsoft Dynamics server. The property is required for on-line and not allowed for on-prem. Type: string (or Expression with resultType string)."]
    #[serde(rename = "serviceUri", default, skip_serializing_if = "Option::is_none")]
    pub service_uri: Option<serde_json::Value>,
    #[doc = "The organization name of the Dynamics instance. The property is required for on-prem and required for online when there are more than one Dynamics instances associated with the user. Type: string (or Expression with resultType string)."]
    #[serde(rename = "organizationName", default, skip_serializing_if = "Option::is_none")]
    pub organization_name: Option<serde_json::Value>,
    #[doc = "The authentication type to connect to Dynamics server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario, 'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or Expression with resultType string)."]
    #[serde(rename = "authenticationType")]
    pub authentication_type: dynamics_linked_service_type_properties::AuthenticationType,
    #[doc = "User name to access the Dynamics instance. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[doc = "The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalCredentialType", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_credential_type: Option<dynamics_linked_service_type_properties::ServicePrincipalCredentialType>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalCredential", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_credential: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl DynamicsLinkedServiceTypeProperties {
    pub fn new(
        deployment_type: dynamics_linked_service_type_properties::DeploymentType,
        authentication_type: dynamics_linked_service_type_properties::AuthenticationType,
    ) -> Self {
        Self {
            deployment_type,
            host_name: None,
            port: None,
            service_uri: None,
            organization_name: None,
            authentication_type,
            username: None,
            password: None,
            service_principal_id: None,
            service_principal_credential_type: None,
            service_principal_credential: None,
            encrypted_credential: None,
        }
    }
}
pub mod dynamics_linked_service_type_properties {
    use super::*;
    #[doc = "The deployment type of the Dynamics instance. 'Online' for Dynamics Online and 'OnPremisesWithIfd' for Dynamics on-premises with Ifd. Type: string (or Expression with resultType string)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DeploymentType {
        Online,
        OnPremisesWithIfd,
    }
    #[doc = "The authentication type to connect to Dynamics server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario, 'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or Expression with resultType string)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Office365,
        Ifd,
        #[serde(rename = "AADServicePrincipal")]
        AadServicePrincipal,
    }
    #[doc = "The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with resultType string)."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServicePrincipalCredentialType {
        ServicePrincipalKey,
        ServicePrincipalCert,
    }
}
#[doc = "A copy activity Dynamics sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "Defines values for DynamicsSinkWriteBehavior."]
    #[serde(rename = "writeBehavior")]
    pub write_behavior: DynamicsSinkWriteBehavior,
    #[doc = "The flag indicating whether ignore null values from input dataset (except key fields) during write operation. Default is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "ignoreNullValues", default, skip_serializing_if = "Option::is_none")]
    pub ignore_null_values: Option<serde_json::Value>,
    #[doc = "The logical name of the alternate key which will be used when upserting records. Type: string (or Expression with resultType string)."]
    #[serde(rename = "alternateKeyName", default, skip_serializing_if = "Option::is_none")]
    pub alternate_key_name: Option<serde_json::Value>,
}
impl DynamicsSink {
    pub fn new(copy_sink: CopySink, write_behavior: DynamicsSinkWriteBehavior) -> Self {
        Self {
            copy_sink,
            write_behavior,
            ignore_null_values: None,
            alternate_key_name: None,
        }
    }
}
#[doc = "Defines values for DynamicsSinkWriteBehavior."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum DynamicsSinkWriteBehavior {
    Upsert,
}
#[doc = "A copy activity Dynamics source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DynamicsSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "FetchXML is a proprietary query language that is used in Microsoft Dynamics (online & on-premises). Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl DynamicsSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "Eloqua server linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EloquaLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Eloqua server linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: EloquaLinkedServiceTypeProperties,
}
impl EloquaLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: EloquaLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Eloqua server linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EloquaLinkedServiceTypeProperties {
    #[doc = "The endpoint of the Eloqua server. (i.e. eloqua.example.com)"]
    pub endpoint: serde_json::Value,
    #[doc = "The site name and user name of your Eloqua account in the form: sitename/username. (i.e. Eloqua/Alice)"]
    pub username: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[doc = "Specifies whether to verify the identity of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl EloquaLinkedServiceTypeProperties {
    pub fn new(endpoint: serde_json::Value, username: serde_json::Value) -> Self {
        Self {
            endpoint,
            username,
            password: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Eloqua server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EloquaObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl EloquaObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Eloqua server source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EloquaSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl EloquaSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Details of the encryption associated with the workspace"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EncryptionDetails {
    #[doc = "Double Encryption enabled"]
    #[serde(rename = "doubleEncryptionEnabled", default, skip_serializing_if = "Option::is_none")]
    pub double_encryption_enabled: Option<bool>,
    #[doc = "Details of the customer managed key associated with the workspace"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cmk: Option<CustomerManagedKeyDetails>,
}
impl EncryptionDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The resource management error additional info."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorAdditionalInfo {
    #[doc = "The additional info type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "The additional info."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
}
impl ErrorAdditionalInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Contains details when the response code indicates an error."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorContract {
    #[doc = "Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.)"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorResponse>,
}
impl ErrorContract {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.)"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[doc = "The error code."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[doc = "The error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "The error target."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The error details."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorResponse>,
    #[doc = "The error additional info."]
    #[serde(rename = "additionalInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_info: Vec<ErrorAdditionalInfo>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Request body structure for data flow expression preview."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EvaluateDataFlowExpressionRequest {
    #[doc = "The ID of data flow debug session."]
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
    #[doc = "The data flow which contains the debug session."]
    #[serde(rename = "dataFlowName", default, skip_serializing_if = "Option::is_none")]
    pub data_flow_name: Option<String>,
    #[doc = "The output stream name."]
    #[serde(rename = "streamName", default, skip_serializing_if = "Option::is_none")]
    pub stream_name: Option<String>,
    #[doc = "The row limit for preview request."]
    #[serde(rename = "rowLimits", default, skip_serializing_if = "Option::is_none")]
    pub row_limits: Option<i64>,
    #[doc = "The expression for preview."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub expression: Option<String>,
}
impl EvaluateDataFlowExpressionRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Excel dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExcelDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Excel dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<ExcelDatasetTypeProperties>,
}
impl ExcelDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Excel dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExcelDatasetTypeProperties {
    #[doc = "Dataset location."]
    pub location: DatasetLocation,
    #[doc = "The sheet of excel file. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sheetName")]
    pub sheet_name: serde_json::Value,
    #[doc = "The partial data of one sheet. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub range: Option<serde_json::Value>,
    #[doc = "When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "firstRowAsHeader", default, skip_serializing_if = "Option::is_none")]
    pub first_row_as_header: Option<serde_json::Value>,
    #[doc = "The compression method used on a dataset."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
    #[doc = "The null value string. Type: string (or Expression with resultType string)."]
    #[serde(rename = "nullValue", default, skip_serializing_if = "Option::is_none")]
    pub null_value: Option<serde_json::Value>,
}
impl ExcelDatasetTypeProperties {
    pub fn new(location: DatasetLocation, sheet_name: serde_json::Value) -> Self {
        Self {
            location,
            sheet_name,
            range: None,
            first_row_as_header: None,
            compression: None,
            null_value: None,
        }
    }
}
#[doc = "A copy activity excel source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExcelSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Connector read setting."]
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl ExcelSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            store_settings: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "Execute data flow activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExecuteDataFlowActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Execute data flow activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: ExecuteDataFlowActivityTypeProperties,
}
impl ExecuteDataFlowActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: ExecuteDataFlowActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "Execute data flow activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExecuteDataFlowActivityTypeProperties {
    #[doc = "Data flow reference type."]
    pub dataflow: DataFlowReference,
    #[doc = "Staging info for execute data flow activity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub staging: Option<DataFlowStagingInfo>,
    #[doc = "Integration runtime reference type."]
    #[serde(rename = "integrationRuntime", default, skip_serializing_if = "Option::is_none")]
    pub integration_runtime: Option<IntegrationRuntimeReference>,
    #[doc = "Compute properties for data flow activity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compute: Option<execute_data_flow_activity_type_properties::Compute>,
    #[doc = "Trace level setting used for data flow monitoring output. Supported values are: 'coarse', 'fine', and 'none'. Type: string (or Expression with resultType string)"]
    #[serde(rename = "traceLevel", default, skip_serializing_if = "Option::is_none")]
    pub trace_level: Option<serde_json::Value>,
    #[doc = "Continue on error setting used for data flow execution. Enables processing to continue if a sink fails. Type: boolean (or Expression with resultType boolean)"]
    #[serde(rename = "continueOnError", default, skip_serializing_if = "Option::is_none")]
    pub continue_on_error: Option<serde_json::Value>,
    #[doc = "Concurrent run setting used for data flow execution. Allows sinks with the same save order to be processed concurrently. Type: boolean (or Expression with resultType boolean)"]
    #[serde(rename = "runConcurrently", default, skip_serializing_if = "Option::is_none")]
    pub run_concurrently: Option<serde_json::Value>,
}
impl ExecuteDataFlowActivityTypeProperties {
    pub fn new(dataflow: DataFlowReference) -> Self {
        Self {
            dataflow,
            staging: None,
            integration_runtime: None,
            compute: None,
            trace_level: None,
            continue_on_error: None,
            run_concurrently: None,
        }
    }
}
pub mod execute_data_flow_activity_type_properties {
    use super::*;
    #[doc = "Compute properties for data flow activity."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Compute {
        #[doc = "Compute type of the cluster which will execute data flow job."]
        #[serde(rename = "computeType", default, skip_serializing_if = "Option::is_none")]
        pub compute_type: Option<compute::ComputeType>,
        #[doc = "Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272."]
        #[serde(rename = "coreCount", default, skip_serializing_if = "Option::is_none")]
        pub core_count: Option<i64>,
    }
    impl Compute {
        pub fn new() -> Self {
            Self::default()
        }
    }
    pub mod compute {
        use super::*;
        #[doc = "Compute type of the cluster which will execute data flow job."]
        #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
        pub enum ComputeType {
            General,
            MemoryOptimized,
            ComputeOptimized,
        }
    }
}
#[doc = "Execute pipeline activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExecutePipelineActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[doc = "Execute pipeline activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: ExecutePipelineActivityTypeProperties,
}
impl ExecutePipelineActivity {
    pub fn new(control_activity: ControlActivity, type_properties: ExecutePipelineActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[doc = "Execute pipeline activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExecutePipelineActivityTypeProperties {
    #[doc = "Pipeline reference type."]
    pub pipeline: PipelineReference,
    #[doc = "An object mapping parameter names to argument values."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterValueSpecification>,
    #[doc = "Defines whether activity execution will wait for the dependent pipeline execution to finish. Default is false."]
    #[serde(rename = "waitOnCompletion", default, skip_serializing_if = "Option::is_none")]
    pub wait_on_completion: Option<bool>,
}
impl ExecutePipelineActivityTypeProperties {
    pub fn new(pipeline: PipelineReference) -> Self {
        Self {
            pipeline,
            parameters: None,
            wait_on_completion: None,
        }
    }
}
#[doc = "Execute SSIS package activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExecuteSsisPackageActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Execute SSIS package activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: ExecuteSsisPackageActivityTypeProperties,
}
impl ExecuteSsisPackageActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: ExecuteSsisPackageActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "Execute SSIS package activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExecuteSsisPackageActivityTypeProperties {
    #[doc = "SSIS package location."]
    #[serde(rename = "packageLocation")]
    pub package_location: SsisPackageLocation,
    #[doc = "Specifies the runtime to execute SSIS package. The value should be \"x86\" or \"x64\". Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub runtime: Option<serde_json::Value>,
    #[doc = "The logging level of SSIS package execution. Type: string (or Expression with resultType string)."]
    #[serde(rename = "loggingLevel", default, skip_serializing_if = "Option::is_none")]
    pub logging_level: Option<serde_json::Value>,
    #[doc = "The environment path to execute the SSIS package. Type: string (or Expression with resultType string)."]
    #[serde(rename = "environmentPath", default, skip_serializing_if = "Option::is_none")]
    pub environment_path: Option<serde_json::Value>,
    #[doc = "SSIS package execution credential."]
    #[serde(rename = "executionCredential", default, skip_serializing_if = "Option::is_none")]
    pub execution_credential: Option<SsisExecutionCredential>,
    #[doc = "Integration runtime reference type."]
    #[serde(rename = "connectVia")]
    pub connect_via: IntegrationRuntimeReference,
    #[doc = "The project level parameters to execute the SSIS package."]
    #[serde(rename = "projectParameters", default, skip_serializing_if = "Option::is_none")]
    pub project_parameters: Option<serde_json::Value>,
    #[doc = "The package level parameters to execute the SSIS package."]
    #[serde(rename = "packageParameters", default, skip_serializing_if = "Option::is_none")]
    pub package_parameters: Option<serde_json::Value>,
    #[doc = "The project level connection managers to execute the SSIS package."]
    #[serde(rename = "projectConnectionManagers", default, skip_serializing_if = "Option::is_none")]
    pub project_connection_managers: Option<serde_json::Value>,
    #[doc = "The package level connection managers to execute the SSIS package."]
    #[serde(rename = "packageConnectionManagers", default, skip_serializing_if = "Option::is_none")]
    pub package_connection_managers: Option<serde_json::Value>,
    #[doc = "The property overrides to execute the SSIS package."]
    #[serde(rename = "propertyOverrides", default, skip_serializing_if = "Option::is_none")]
    pub property_overrides: Option<serde_json::Value>,
    #[doc = "SSIS package execution log location"]
    #[serde(rename = "logLocation", default, skip_serializing_if = "Option::is_none")]
    pub log_location: Option<SsisLogLocation>,
}
impl ExecuteSsisPackageActivityTypeProperties {
    pub fn new(package_location: SsisPackageLocation, connect_via: IntegrationRuntimeReference) -> Self {
        Self {
            package_location,
            runtime: None,
            logging_level: None,
            environment_path: None,
            execution_credential: None,
            connect_via,
            project_parameters: None,
            package_parameters: None,
            project_connection_managers: None,
            package_connection_managers: None,
            property_overrides: None,
            log_location: None,
        }
    }
}
#[doc = "Base class for all execution activities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExecutionActivity {
    #[serde(flatten)]
    pub activity: Activity,
    #[doc = "Linked service reference type."]
    #[serde(rename = "linkedServiceName", default, skip_serializing_if = "Option::is_none")]
    pub linked_service_name: Option<LinkedServiceReference>,
    #[doc = "Execution policy for an activity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub policy: Option<ActivityPolicy>,
}
impl ExecutionActivity {
    pub fn new(activity: Activity) -> Self {
        Self {
            activity,
            linked_service_name: None,
            policy: None,
        }
    }
}
#[doc = "Export command settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportSettings {
    #[doc = "The export setting type."]
    #[serde(rename = "type")]
    pub type_: String,
}
impl ExportSettings {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[doc = "The exposure control request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExposureControlRequest {
    #[doc = "The feature name."]
    #[serde(rename = "featureName", default, skip_serializing_if = "Option::is_none")]
    pub feature_name: Option<String>,
    #[doc = "The feature type."]
    #[serde(rename = "featureType", default, skip_serializing_if = "Option::is_none")]
    pub feature_type: Option<String>,
}
impl ExposureControlRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The exposure control response."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExposureControlResponse {
    #[doc = "The feature name."]
    #[serde(rename = "featureName", default, skip_serializing_if = "Option::is_none")]
    pub feature_name: Option<String>,
    #[doc = "The feature value."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl ExposureControlResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Synapse expression definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Expression {
    #[doc = "Expression type."]
    #[serde(rename = "type")]
    pub type_: expression::Type,
    #[doc = "Expression value."]
    pub value: String,
}
impl Expression {
    pub fn new(type_: expression::Type, value: String) -> Self {
        Self { type_, value }
    }
}
pub mod expression {
    use super::*;
    #[doc = "Expression type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Expression,
    }
}
#[doc = "File system linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileServerLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "File system linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: FileServerLinkedServiceTypeProperties,
}
impl FileServerLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: FileServerLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "File system linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileServerLinkedServiceTypeProperties {
    #[doc = "Host name of the server. Type: string (or Expression with resultType string)."]
    pub host: serde_json::Value,
    #[doc = "User ID to logon the server. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userId", default, skip_serializing_if = "Option::is_none")]
    pub user_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl FileServerLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value) -> Self {
        Self {
            host,
            user_id: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "The location of file server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileServerLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
}
impl FileServerLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self { dataset_location }
    }
}
#[doc = "File server read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileServerReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[doc = "If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[doc = "FileServer wildcardFolderPath. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[doc = "FileServer wildcardFileName. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[doc = "Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[doc = "Indicates whether to enable partition discovery."]
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[doc = "Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[doc = "Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[doc = "The start of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[doc = "The end of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
    #[doc = "Specify a filter to be used to select a subset of files in the folderPath rather than all files. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileFilter", default, skip_serializing_if = "Option::is_none")]
    pub file_filter: Option<serde_json::Value>,
}
impl FileServerReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            file_list_path: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
            file_filter: None,
        }
    }
}
#[doc = "File server write settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileServerWriteSettings {
    #[serde(flatten)]
    pub store_write_settings: StoreWriteSettings,
}
impl FileServerWriteSettings {
    pub fn new(store_write_settings: StoreWriteSettings) -> Self {
        Self { store_write_settings }
    }
}
#[doc = "An on-premises file system dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileShareDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "On-premises file system dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<FileShareDatasetTypeProperties>,
}
impl FileShareDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "On-premises file system dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FileShareDatasetTypeProperties {
    #[doc = "The path of the on-premises file system. Type: string (or Expression with resultType string)."]
    #[serde(rename = "folderPath", default, skip_serializing_if = "Option::is_none")]
    pub folder_path: Option<serde_json::Value>,
    #[doc = "The name of the on-premises file system. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileName", default, skip_serializing_if = "Option::is_none")]
    pub file_name: Option<serde_json::Value>,
    #[doc = "The start of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[doc = "The end of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
    #[doc = "The format definition of a storage."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<DatasetStorageFormat>,
    #[doc = "Specify a filter to be used to select a subset of files in the folderPath rather than all files. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileFilter", default, skip_serializing_if = "Option::is_none")]
    pub file_filter: Option<serde_json::Value>,
    #[doc = "The compression method used on a dataset."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl FileShareDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A copy activity file system sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileSystemSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "The type of copy behavior for copy sink."]
    #[serde(rename = "copyBehavior", default, skip_serializing_if = "Option::is_none")]
    pub copy_behavior: Option<serde_json::Value>,
}
impl FileSystemSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            copy_behavior: None,
        }
    }
}
#[doc = "A copy activity file system source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileSystemSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl FileSystemSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            recursive: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "Filter and return results from input array based on the conditions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FilterActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[doc = "Filter activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: FilterActivityTypeProperties,
}
impl FilterActivity {
    pub fn new(control_activity: ControlActivity, type_properties: FilterActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[doc = "Filter activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FilterActivityTypeProperties {
    #[doc = "Azure Synapse expression definition."]
    pub items: Expression,
    #[doc = "Azure Synapse expression definition."]
    pub condition: Expression,
}
impl FilterActivityTypeProperties {
    pub fn new(items: Expression, condition: Expression) -> Self {
        Self { items, condition }
    }
}
#[doc = "Data flow flowlet"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Flowlet {
    #[serde(flatten)]
    pub data_flow: DataFlow,
    #[doc = "Flowlet type properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<FlowletTypeProperties>,
}
impl Flowlet {
    pub fn new(data_flow: DataFlow) -> Self {
        Self {
            data_flow,
            type_properties: None,
        }
    }
}
#[doc = "Flowlet type properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FlowletTypeProperties {
    #[doc = "List of sources in Flowlet."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<DataFlowSource>,
    #[doc = "List of sinks in Flowlet."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sinks: Vec<DataFlowSink>,
    #[doc = "List of transformations in Flowlet."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transformations: Vec<Transformation>,
    #[doc = "Flowlet script."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub script: Option<String>,
    #[doc = "Flowlet script lines."]
    #[serde(rename = "scriptLines", default, skip_serializing_if = "Vec::is_empty")]
    pub script_lines: Vec<String>,
}
impl FlowletTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This activity is used for iterating over a collection and execute given activities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ForEachActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[doc = "ForEach activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: ForEachActivityTypeProperties,
}
impl ForEachActivity {
    pub fn new(control_activity: ControlActivity, type_properties: ForEachActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[doc = "ForEach activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ForEachActivityTypeProperties {
    #[doc = "Should the loop be executed in sequence or in parallel (max 50)"]
    #[serde(rename = "isSequential", default, skip_serializing_if = "Option::is_none")]
    pub is_sequential: Option<bool>,
    #[doc = "Batch count to be used for controlling the number of parallel execution (when isSequential is set to false)."]
    #[serde(rename = "batchCount", default, skip_serializing_if = "Option::is_none")]
    pub batch_count: Option<i64>,
    #[doc = "Azure Synapse expression definition."]
    pub items: Expression,
    #[doc = "List of activities to execute ."]
    pub activities: Vec<Activity>,
}
impl ForEachActivityTypeProperties {
    pub fn new(items: Expression, activities: Vec<Activity>) -> Self {
        Self {
            is_sequential: None,
            batch_count: None,
            items,
            activities,
        }
    }
}
#[doc = "Format read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FormatReadSettings {
    #[doc = "The read setting type."]
    #[serde(rename = "type")]
    pub type_: String,
}
impl FormatReadSettings {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[doc = "Format write settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FormatWriteSettings {
    #[doc = "The write setting type."]
    #[serde(rename = "type")]
    pub type_: String,
}
impl FormatWriteSettings {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[doc = "Ftp read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FtpReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[doc = "If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[doc = "Ftp wildcardFolderPath. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[doc = "Ftp wildcardFileName. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[doc = "Indicates whether to enable partition discovery."]
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[doc = "Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[doc = "Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[doc = "Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[doc = "Specify whether to use binary transfer mode for FTP stores."]
    #[serde(rename = "useBinaryTransfer", default, skip_serializing_if = "Option::is_none")]
    pub use_binary_transfer: Option<bool>,
}
impl FtpReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            file_list_path: None,
            use_binary_transfer: None,
        }
    }
}
#[doc = "A FTP server Linked Service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FtpServerLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Properties specific to this linked service type."]
    #[serde(rename = "typeProperties")]
    pub type_properties: FtpServerLinkedServiceTypeProperties,
}
impl FtpServerLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: FtpServerLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Properties specific to this linked service type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FtpServerLinkedServiceTypeProperties {
    #[doc = "Host name of the FTP server. Type: string (or Expression with resultType string)."]
    pub host: serde_json::Value,
    #[doc = "The TCP port number that the FTP server uses to listen for client connections. Default value is 21. Type: integer (or Expression with resultType integer), minimum: 0."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[doc = "The authentication type to be used to connect to the FTP server."]
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<ftp_server_linked_service_type_properties::AuthenticationType>,
    #[doc = "Username to logon the FTP server. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[doc = "If true, connect to the FTP server over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<serde_json::Value>,
    #[doc = "If true, validate the FTP server SSL certificate when connect over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "enableServerCertificateValidation", default, skip_serializing_if = "Option::is_none")]
    pub enable_server_certificate_validation: Option<serde_json::Value>,
}
impl FtpServerLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value) -> Self {
        Self {
            host,
            port: None,
            authentication_type: None,
            user_name: None,
            password: None,
            encrypted_credential: None,
            enable_ssl: None,
            enable_server_certificate_validation: None,
        }
    }
}
pub mod ftp_server_linked_service_type_properties {
    use super::*;
    #[doc = "The authentication type to be used to connect to the FTP server."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        Anonymous,
    }
}
#[doc = "The location of ftp server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FtpServerLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
}
impl FtpServerLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self { dataset_location }
    }
}
#[doc = "Properties specific to this dataset type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GenericDatasetTypeProperties {
    #[doc = "The table name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
}
impl GenericDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Activity to get metadata of dataset"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetMetadataActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "GetMetadata activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: GetMetadataActivityTypeProperties,
}
impl GetMetadataActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: GetMetadataActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "GetMetadata activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetMetadataActivityTypeProperties {
    #[doc = "Dataset reference type."]
    pub dataset: DatasetReference,
    #[doc = "Fields of metadata to get from dataset."]
    #[serde(rename = "fieldList", default, skip_serializing_if = "Vec::is_empty")]
    pub field_list: Vec<serde_json::Value>,
    #[doc = "Connector read setting."]
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[doc = "Format read settings."]
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<FormatReadSettings>,
}
impl GetMetadataActivityTypeProperties {
    pub fn new(dataset: DatasetReference) -> Self {
        Self {
            dataset,
            field_list: Vec::new(),
            store_settings: None,
            format_settings: None,
        }
    }
}
#[doc = "The request payload of get SSIS object metadata."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GetSsisObjectMetadataRequest {
    #[doc = "Metadata path."]
    #[serde(rename = "metadataPath", default, skip_serializing_if = "Option::is_none")]
    pub metadata_path: Option<String>,
}
impl GetSsisObjectMetadataRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GitHubAccessTokenRequest {
    #[doc = "The GitHub Client Id."]
    #[serde(rename = "gitHubClientId")]
    pub git_hub_client_id: String,
    #[doc = "Client secret information for factory's bring your own app repository configuration"]
    #[serde(rename = "gitHubClientSecret", default, skip_serializing_if = "Option::is_none")]
    pub git_hub_client_secret: Option<GitHubClientSecret>,
    #[doc = "The GitHub Access code."]
    #[serde(rename = "gitHubAccessCode")]
    pub git_hub_access_code: String,
    #[doc = "The GitHub access token base URL."]
    #[serde(rename = "gitHubAccessTokenBaseUrl")]
    pub git_hub_access_token_base_url: String,
}
impl GitHubAccessTokenRequest {
    pub fn new(git_hub_client_id: String, git_hub_access_code: String, git_hub_access_token_base_url: String) -> Self {
        Self {
            git_hub_client_id,
            git_hub_client_secret: None,
            git_hub_access_code,
            git_hub_access_token_base_url,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GitHubAccessTokenResponse {
    #[serde(rename = "gitHubAccessToken", default, skip_serializing_if = "Option::is_none")]
    pub git_hub_access_token: Option<String>,
}
impl GitHubAccessTokenResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Client secret information for factory's bring your own app repository configuration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GitHubClientSecret {
    #[doc = "Bring your own app client secret AKV URL"]
    #[serde(rename = "byoaSecretAkvUrl", default, skip_serializing_if = "Option::is_none")]
    pub byoa_secret_akv_url: Option<String>,
    #[doc = "Bring your own app client secret name in AKV"]
    #[serde(rename = "byoaSecretName", default, skip_serializing_if = "Option::is_none")]
    pub byoa_secret_name: Option<String>,
}
impl GitHubClientSecret {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Google AdWords service linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleAdWordsLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Google AdWords service linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: GoogleAdWordsLinkedServiceTypeProperties,
}
impl GoogleAdWordsLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: GoogleAdWordsLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Google AdWords service linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleAdWordsLinkedServiceTypeProperties {
    #[doc = "The Client customer ID of the AdWords account that you want to fetch report data for."]
    #[serde(rename = "clientCustomerID")]
    pub client_customer_id: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "developerToken")]
    pub developer_token: SecretBase,
    #[doc = "The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR."]
    #[serde(rename = "authenticationType")]
    pub authentication_type: google_ad_words_linked_service_type_properties::AuthenticationType,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "refreshToken", default, skip_serializing_if = "Option::is_none")]
    pub refresh_token: Option<SecretBase>,
    #[doc = "The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string)."]
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[doc = "The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<serde_json::Value>,
    #[doc = "The full path to the .p12 key file that is used to authenticate the service account email address and can only be used on self-hosted IR."]
    #[serde(rename = "keyFilePath", default, skip_serializing_if = "Option::is_none")]
    pub key_file_path: Option<serde_json::Value>,
    #[doc = "The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR."]
    #[serde(rename = "trustedCertPath", default, skip_serializing_if = "Option::is_none")]
    pub trusted_cert_path: Option<serde_json::Value>,
    #[doc = "Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false."]
    #[serde(rename = "useSystemTrustStore", default, skip_serializing_if = "Option::is_none")]
    pub use_system_trust_store: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl GoogleAdWordsLinkedServiceTypeProperties {
    pub fn new(
        client_customer_id: serde_json::Value,
        developer_token: SecretBase,
        authentication_type: google_ad_words_linked_service_type_properties::AuthenticationType,
    ) -> Self {
        Self {
            client_customer_id,
            developer_token,
            authentication_type,
            refresh_token: None,
            client_id: None,
            client_secret: None,
            email: None,
            key_file_path: None,
            trusted_cert_path: None,
            use_system_trust_store: None,
            encrypted_credential: None,
        }
    }
}
pub mod google_ad_words_linked_service_type_properties {
    use super::*;
    #[doc = "The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        ServiceAuthentication,
        UserAuthentication,
    }
}
#[doc = "Google AdWords service dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleAdWordsObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl GoogleAdWordsObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Google AdWords service source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleAdWordsSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl GoogleAdWordsSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Google BigQuery Dataset Properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GoogleBigQueryDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using database + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The table name of the Google BigQuery. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[doc = "The database name of the Google BigQuery. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dataset: Option<serde_json::Value>,
}
impl GoogleBigQueryDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Google BigQuery service linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleBigQueryLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Google BigQuery service linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: GoogleBigQueryLinkedServiceTypeProperties,
}
impl GoogleBigQueryLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: GoogleBigQueryLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Google BigQuery service linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleBigQueryLinkedServiceTypeProperties {
    #[doc = "The default BigQuery project to query against."]
    pub project: serde_json::Value,
    #[doc = "A comma-separated list of public BigQuery projects to access."]
    #[serde(rename = "additionalProjects", default, skip_serializing_if = "Option::is_none")]
    pub additional_projects: Option<serde_json::Value>,
    #[doc = "Whether to request access to Google Drive. Allowing Google Drive access enables support for federated tables that combine BigQuery data with data from Google Drive. The default value is false."]
    #[serde(rename = "requestGoogleDriveScope", default, skip_serializing_if = "Option::is_none")]
    pub request_google_drive_scope: Option<serde_json::Value>,
    #[doc = "The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR."]
    #[serde(rename = "authenticationType")]
    pub authentication_type: google_big_query_linked_service_type_properties::AuthenticationType,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "refreshToken", default, skip_serializing_if = "Option::is_none")]
    pub refresh_token: Option<SecretBase>,
    #[doc = "The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string)."]
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[doc = "The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub email: Option<serde_json::Value>,
    #[doc = "The full path to the .p12 key file that is used to authenticate the service account email address and can only be used on self-hosted IR."]
    #[serde(rename = "keyFilePath", default, skip_serializing_if = "Option::is_none")]
    pub key_file_path: Option<serde_json::Value>,
    #[doc = "The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR."]
    #[serde(rename = "trustedCertPath", default, skip_serializing_if = "Option::is_none")]
    pub trusted_cert_path: Option<serde_json::Value>,
    #[doc = "Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false."]
    #[serde(rename = "useSystemTrustStore", default, skip_serializing_if = "Option::is_none")]
    pub use_system_trust_store: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl GoogleBigQueryLinkedServiceTypeProperties {
    pub fn new(
        project: serde_json::Value,
        authentication_type: google_big_query_linked_service_type_properties::AuthenticationType,
    ) -> Self {
        Self {
            project,
            additional_projects: None,
            request_google_drive_scope: None,
            authentication_type,
            refresh_token: None,
            client_id: None,
            client_secret: None,
            email: None,
            key_file_path: None,
            trusted_cert_path: None,
            use_system_trust_store: None,
            encrypted_credential: None,
        }
    }
}
pub mod google_big_query_linked_service_type_properties {
    use super::*;
    #[doc = "The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        ServiceAuthentication,
        UserAuthentication,
    }
}
#[doc = "Google BigQuery service dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleBigQueryObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Google BigQuery Dataset Properties"]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GoogleBigQueryDatasetTypeProperties>,
}
impl GoogleBigQueryObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Google BigQuery service source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleBigQuerySource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl GoogleBigQuerySource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Linked service for Google Cloud Storage."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleCloudStorageLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Google Cloud Storage linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: GoogleCloudStorageLinkedServiceTypeProperties,
}
impl GoogleCloudStorageLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: GoogleCloudStorageLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Google Cloud Storage linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GoogleCloudStorageLinkedServiceTypeProperties {
    #[doc = "The access key identifier of the Google Cloud Storage Identity and Access Management (IAM) user. Type: string (or Expression with resultType string)."]
    #[serde(rename = "accessKeyId", default, skip_serializing_if = "Option::is_none")]
    pub access_key_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "secretAccessKey", default, skip_serializing_if = "Option::is_none")]
    pub secret_access_key: Option<SecretBase>,
    #[doc = "This value specifies the endpoint to access with the Google Cloud Storage Connector. This is an optional property; change it only if you want to try a different service endpoint or want to switch between https and http. Type: string (or Expression with resultType string)."]
    #[serde(rename = "serviceUrl", default, skip_serializing_if = "Option::is_none")]
    pub service_url: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl GoogleCloudStorageLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The location of Google Cloud Storage dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleCloudStorageLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
    #[doc = "Specify the bucketName of Google Cloud Storage. Type: string (or Expression with resultType string)"]
    #[serde(rename = "bucketName", default, skip_serializing_if = "Option::is_none")]
    pub bucket_name: Option<serde_json::Value>,
    #[doc = "Specify the version of Google Cloud Storage. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<serde_json::Value>,
}
impl GoogleCloudStorageLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self {
            dataset_location,
            bucket_name: None,
            version: None,
        }
    }
}
#[doc = "Google Cloud Storage read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GoogleCloudStorageReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[doc = "If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[doc = "Google Cloud Storage wildcardFolderPath. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[doc = "Google Cloud Storage wildcardFileName. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[doc = "The prefix filter for the Google Cloud Storage object name. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub prefix: Option<serde_json::Value>,
    #[doc = "Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[doc = "Indicates whether to enable partition discovery."]
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[doc = "Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[doc = "Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[doc = "The start of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[doc = "The end of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
}
impl GoogleCloudStorageReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            prefix: None,
            file_list_path: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
        }
    }
}
#[doc = "Greenplum Dataset Properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GreenplumDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The table name of Greenplum. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[doc = "The schema name of Greenplum. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl GreenplumDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Greenplum Database linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GreenplumLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Greenplum Database linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: GreenplumLinkedServiceTypeProperties,
}
impl GreenplumLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: GreenplumLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Greenplum Database linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct GreenplumLinkedServiceTypeProperties {
    #[doc = "An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pwd: Option<AzureKeyVaultSecretReference>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl GreenplumLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A copy activity Greenplum Database source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GreenplumSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl GreenplumSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Greenplum Database dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GreenplumTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Greenplum Dataset Properties"]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GreenplumDatasetTypeProperties>,
}
impl GreenplumTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "HBase server linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HBaseLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "HBase server linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: HBaseLinkedServiceTypeProperties,
}
impl HBaseLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: HBaseLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "HBase server linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HBaseLinkedServiceTypeProperties {
    #[doc = "The IP address or host name of the HBase server. (i.e. 192.168.222.160)"]
    pub host: serde_json::Value,
    #[doc = "The TCP port that the HBase instance uses to listen for client connections. The default value is 9090."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[doc = "The partial URL corresponding to the HBase server. (i.e. /gateway/sandbox/hbase/version)"]
    #[serde(rename = "httpPath", default, skip_serializing_if = "Option::is_none")]
    pub http_path: Option<serde_json::Value>,
    #[doc = "The authentication mechanism to use to connect to the HBase server."]
    #[serde(rename = "authenticationType")]
    pub authentication_type: h_base_linked_service_type_properties::AuthenticationType,
    #[doc = "The user name used to connect to the HBase instance."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "Specifies whether the connections to the server are encrypted using SSL. The default value is false."]
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<serde_json::Value>,
    #[doc = "The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR."]
    #[serde(rename = "trustedCertPath", default, skip_serializing_if = "Option::is_none")]
    pub trusted_cert_path: Option<serde_json::Value>,
    #[doc = "Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false."]
    #[serde(rename = "allowHostNameCNMismatch", default, skip_serializing_if = "Option::is_none")]
    pub allow_host_name_cn_mismatch: Option<serde_json::Value>,
    #[doc = "Specifies whether to allow self-signed certificates from the server. The default value is false."]
    #[serde(rename = "allowSelfSignedServerCert", default, skip_serializing_if = "Option::is_none")]
    pub allow_self_signed_server_cert: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl HBaseLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value, authentication_type: h_base_linked_service_type_properties::AuthenticationType) -> Self {
        Self {
            host,
            port: None,
            http_path: None,
            authentication_type,
            username: None,
            password: None,
            enable_ssl: None,
            trusted_cert_path: None,
            allow_host_name_cn_mismatch: None,
            allow_self_signed_server_cert: None,
            encrypted_credential: None,
        }
    }
}
pub mod h_base_linked_service_type_properties {
    use super::*;
    #[doc = "The authentication mechanism to use to connect to the HBase server."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Anonymous,
        Basic,
    }
}
#[doc = "HBase server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HBaseObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl HBaseObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity HBase server source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HBaseSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl HBaseSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "The HDInsightActivityDebugInfoOption settings to use."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum HdInsightActivityDebugInfoOption {
    None,
    Always,
    Failure,
}
#[doc = "HDInsight Hive activity type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightHiveActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "HDInsight Hive activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: HdInsightHiveActivityTypeProperties,
}
impl HdInsightHiveActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: HdInsightHiveActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "HDInsight Hive activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HdInsightHiveActivityTypeProperties {
    #[doc = "Storage linked service references."]
    #[serde(rename = "storageLinkedServices", default, skip_serializing_if = "Vec::is_empty")]
    pub storage_linked_services: Vec<LinkedServiceReference>,
    #[doc = "User specified arguments to HDInsightActivity."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub arguments: Vec<serde_json::Value>,
    #[doc = "The HDInsightActivityDebugInfoOption settings to use."]
    #[serde(rename = "getDebugInfo", default, skip_serializing_if = "Option::is_none")]
    pub get_debug_info: Option<HdInsightActivityDebugInfoOption>,
    #[doc = "Script path. Type: string (or Expression with resultType string)."]
    #[serde(rename = "scriptPath", default, skip_serializing_if = "Option::is_none")]
    pub script_path: Option<serde_json::Value>,
    #[doc = "Linked service reference type."]
    #[serde(rename = "scriptLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub script_linked_service: Option<LinkedServiceReference>,
    #[doc = "Allows user to specify defines for Hive job request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub defines: Option<serde_json::Value>,
    #[doc = "User specified arguments under hivevar namespace."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub variables: Vec<serde_json::Value>,
    #[doc = "Query timeout value (in minutes).  Effective when the HDInsight cluster is with ESP (Enterprise Security Package)"]
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<i64>,
}
impl HdInsightHiveActivityTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "HDInsight linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "HDInsight linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: HdInsightLinkedServiceTypeProperties,
}
impl HdInsightLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: HdInsightLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "HDInsight linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightLinkedServiceTypeProperties {
    #[doc = "HDInsight cluster URI. Type: string (or Expression with resultType string)."]
    #[serde(rename = "clusterUri")]
    pub cluster_uri: serde_json::Value,
    #[doc = "HDInsight cluster user name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "Linked service reference type."]
    #[serde(rename = "linkedServiceName", default, skip_serializing_if = "Option::is_none")]
    pub linked_service_name: Option<LinkedServiceReference>,
    #[doc = "Linked service reference type."]
    #[serde(rename = "hcatalogLinkedServiceName", default, skip_serializing_if = "Option::is_none")]
    pub hcatalog_linked_service_name: Option<LinkedServiceReference>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[doc = "Specify if the HDInsight is created with ESP (Enterprise Security Package). Type: Boolean."]
    #[serde(rename = "isEspEnabled", default, skip_serializing_if = "Option::is_none")]
    pub is_esp_enabled: Option<serde_json::Value>,
    #[doc = "Specify the FileSystem if the main storage for the HDInsight is ADLS Gen2. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileSystem", default, skip_serializing_if = "Option::is_none")]
    pub file_system: Option<serde_json::Value>,
}
impl HdInsightLinkedServiceTypeProperties {
    pub fn new(cluster_uri: serde_json::Value) -> Self {
        Self {
            cluster_uri,
            user_name: None,
            password: None,
            linked_service_name: None,
            hcatalog_linked_service_name: None,
            encrypted_credential: None,
            is_esp_enabled: None,
            file_system: None,
        }
    }
}
#[doc = "HDInsight MapReduce activity type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightMapReduceActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "HDInsight MapReduce activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: HdInsightMapReduceActivityTypeProperties,
}
impl HdInsightMapReduceActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: HdInsightMapReduceActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "HDInsight MapReduce activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightMapReduceActivityTypeProperties {
    #[doc = "Storage linked service references."]
    #[serde(rename = "storageLinkedServices", default, skip_serializing_if = "Vec::is_empty")]
    pub storage_linked_services: Vec<LinkedServiceReference>,
    #[doc = "User specified arguments to HDInsightActivity."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub arguments: Vec<serde_json::Value>,
    #[doc = "The HDInsightActivityDebugInfoOption settings to use."]
    #[serde(rename = "getDebugInfo", default, skip_serializing_if = "Option::is_none")]
    pub get_debug_info: Option<HdInsightActivityDebugInfoOption>,
    #[doc = "Class name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "className")]
    pub class_name: serde_json::Value,
    #[doc = "Jar path. Type: string (or Expression with resultType string)."]
    #[serde(rename = "jarFilePath")]
    pub jar_file_path: serde_json::Value,
    #[doc = "Linked service reference type."]
    #[serde(rename = "jarLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub jar_linked_service: Option<LinkedServiceReference>,
    #[doc = "Jar libs."]
    #[serde(rename = "jarLibs", default, skip_serializing_if = "Vec::is_empty")]
    pub jar_libs: Vec<serde_json::Value>,
    #[doc = "Allows user to specify defines for the MapReduce job request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub defines: Option<serde_json::Value>,
}
impl HdInsightMapReduceActivityTypeProperties {
    pub fn new(class_name: serde_json::Value, jar_file_path: serde_json::Value) -> Self {
        Self {
            storage_linked_services: Vec::new(),
            arguments: Vec::new(),
            get_debug_info: None,
            class_name,
            jar_file_path,
            jar_linked_service: None,
            jar_libs: Vec::new(),
            defines: None,
        }
    }
}
#[doc = "HDInsight ondemand linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightOnDemandLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "HDInsight ondemand linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: HdInsightOnDemandLinkedServiceTypeProperties,
}
impl HdInsightOnDemandLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: HdInsightOnDemandLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "HDInsight ondemand linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightOnDemandLinkedServiceTypeProperties {
    #[doc = "Number of worker/data nodes in the cluster. Suggestion value: 4. Type: string (or Expression with resultType string)."]
    #[serde(rename = "clusterSize")]
    pub cluster_size: serde_json::Value,
    #[doc = "The allowed idle time for the on-demand HDInsight cluster. Specifies how long the on-demand HDInsight cluster stays alive after completion of an activity run if there are no other active jobs in the cluster. The minimum value is 5 mins. Type: string (or Expression with resultType string)."]
    #[serde(rename = "timeToLive")]
    pub time_to_live: serde_json::Value,
    #[doc = "Version of the HDInsight cluster.\u{a0} Type: string (or Expression with resultType string)."]
    pub version: serde_json::Value,
    #[doc = "Linked service reference type."]
    #[serde(rename = "linkedServiceName")]
    pub linked_service_name: LinkedServiceReference,
    #[doc = "The customer’s subscription to host the cluster. Type: string (or Expression with resultType string)."]
    #[serde(rename = "hostSubscriptionId")]
    pub host_subscription_id: serde_json::Value,
    #[doc = "The service principal id for the hostSubscriptionId. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[doc = "The Tenant id/name to which the service principal belongs. Type: string (or Expression with resultType string)."]
    pub tenant: serde_json::Value,
    #[doc = "The resource group where the cluster belongs. Type: string (or Expression with resultType string)."]
    #[serde(rename = "clusterResourceGroup")]
    pub cluster_resource_group: serde_json::Value,
    #[doc = "The prefix of cluster name, postfix will be distinct with timestamp. Type: string (or Expression with resultType string)."]
    #[serde(rename = "clusterNamePrefix", default, skip_serializing_if = "Option::is_none")]
    pub cluster_name_prefix: Option<serde_json::Value>,
    #[doc = "The username to access the cluster. Type: string (or Expression with resultType string)."]
    #[serde(rename = "clusterUserName", default, skip_serializing_if = "Option::is_none")]
    pub cluster_user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "clusterPassword", default, skip_serializing_if = "Option::is_none")]
    pub cluster_password: Option<SecretBase>,
    #[doc = "The username to SSH remotely connect to cluster’s node (for Linux). Type: string (or Expression with resultType string)."]
    #[serde(rename = "clusterSshUserName", default, skip_serializing_if = "Option::is_none")]
    pub cluster_ssh_user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "clusterSshPassword", default, skip_serializing_if = "Option::is_none")]
    pub cluster_ssh_password: Option<SecretBase>,
    #[doc = "Specifies additional storage accounts for the HDInsight linked service so that the Data Factory service can register them on your behalf."]
    #[serde(rename = "additionalLinkedServiceNames", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_linked_service_names: Vec<LinkedServiceReference>,
    #[doc = "Linked service reference type."]
    #[serde(rename = "hcatalogLinkedServiceName", default, skip_serializing_if = "Option::is_none")]
    pub hcatalog_linked_service_name: Option<LinkedServiceReference>,
    #[doc = "The cluster type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "clusterType", default, skip_serializing_if = "Option::is_none")]
    pub cluster_type: Option<serde_json::Value>,
    #[doc = "The version of spark if the cluster type is 'spark'. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sparkVersion", default, skip_serializing_if = "Option::is_none")]
    pub spark_version: Option<serde_json::Value>,
    #[doc = "Specifies the core configuration parameters (as in core-site.xml) for the HDInsight cluster to be created."]
    #[serde(rename = "coreConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub core_configuration: Option<serde_json::Value>,
    #[doc = "Specifies the HBase configuration parameters (hbase-site.xml) for the HDInsight cluster."]
    #[serde(rename = "hBaseConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub h_base_configuration: Option<serde_json::Value>,
    #[doc = "Specifies the HDFS configuration parameters (hdfs-site.xml) for the HDInsight cluster."]
    #[serde(rename = "hdfsConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub hdfs_configuration: Option<serde_json::Value>,
    #[doc = "Specifies the hive configuration parameters (hive-site.xml) for the HDInsight cluster."]
    #[serde(rename = "hiveConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub hive_configuration: Option<serde_json::Value>,
    #[doc = "Specifies the MapReduce configuration parameters (mapred-site.xml) for the HDInsight cluster."]
    #[serde(rename = "mapReduceConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub map_reduce_configuration: Option<serde_json::Value>,
    #[doc = "Specifies the Oozie configuration parameters (oozie-site.xml) for the HDInsight cluster."]
    #[serde(rename = "oozieConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub oozie_configuration: Option<serde_json::Value>,
    #[doc = "Specifies the Storm configuration parameters (storm-site.xml) for the HDInsight cluster."]
    #[serde(rename = "stormConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub storm_configuration: Option<serde_json::Value>,
    #[doc = "Specifies the Yarn configuration parameters (yarn-site.xml) for the HDInsight cluster."]
    #[serde(rename = "yarnConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub yarn_configuration: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[doc = "Specifies the size of the head node for the HDInsight cluster."]
    #[serde(rename = "headNodeSize", default, skip_serializing_if = "Option::is_none")]
    pub head_node_size: Option<serde_json::Value>,
    #[doc = "Specifies the size of the data node for the HDInsight cluster."]
    #[serde(rename = "dataNodeSize", default, skip_serializing_if = "Option::is_none")]
    pub data_node_size: Option<serde_json::Value>,
    #[doc = "Specifies the size of the Zoo Keeper node for the HDInsight cluster."]
    #[serde(rename = "zookeeperNodeSize", default, skip_serializing_if = "Option::is_none")]
    pub zookeeper_node_size: Option<serde_json::Value>,
    #[doc = "Custom script actions to run on HDI ondemand cluster once it's up. Please refer to https://docs.microsoft.com/en-us/azure/hdinsight/hdinsight-hadoop-customize-cluster-linux?toc=%2Fen-us%2Fazure%2Fhdinsight%2Fr-server%2FTOC.json&bc=%2Fen-us%2Fazure%2Fbread%2Ftoc.json#understanding-script-actions."]
    #[serde(rename = "scriptActions", default, skip_serializing_if = "Vec::is_empty")]
    pub script_actions: Vec<ScriptAction>,
    #[doc = "The ARM resource ID for the vNet to which the cluster should be joined after creation. Type: string (or Expression with resultType string)."]
    #[serde(rename = "virtualNetworkId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_id: Option<serde_json::Value>,
    #[doc = "The ARM resource ID for the subnet in the vNet. If virtualNetworkId was specified, then this property is required. Type: string (or Expression with resultType string)."]
    #[serde(rename = "subnetName", default, skip_serializing_if = "Option::is_none")]
    pub subnet_name: Option<serde_json::Value>,
}
impl HdInsightOnDemandLinkedServiceTypeProperties {
    pub fn new(
        cluster_size: serde_json::Value,
        time_to_live: serde_json::Value,
        version: serde_json::Value,
        linked_service_name: LinkedServiceReference,
        host_subscription_id: serde_json::Value,
        tenant: serde_json::Value,
        cluster_resource_group: serde_json::Value,
    ) -> Self {
        Self {
            cluster_size,
            time_to_live,
            version,
            linked_service_name,
            host_subscription_id,
            service_principal_id: None,
            service_principal_key: None,
            tenant,
            cluster_resource_group,
            cluster_name_prefix: None,
            cluster_user_name: None,
            cluster_password: None,
            cluster_ssh_user_name: None,
            cluster_ssh_password: None,
            additional_linked_service_names: Vec::new(),
            hcatalog_linked_service_name: None,
            cluster_type: None,
            spark_version: None,
            core_configuration: None,
            h_base_configuration: None,
            hdfs_configuration: None,
            hive_configuration: None,
            map_reduce_configuration: None,
            oozie_configuration: None,
            storm_configuration: None,
            yarn_configuration: None,
            encrypted_credential: None,
            head_node_size: None,
            data_node_size: None,
            zookeeper_node_size: None,
            script_actions: Vec::new(),
            virtual_network_id: None,
            subnet_name: None,
        }
    }
}
#[doc = "HDInsight Pig activity type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightPigActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "HDInsight Pig activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: HdInsightPigActivityTypeProperties,
}
impl HdInsightPigActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: HdInsightPigActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "HDInsight Pig activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HdInsightPigActivityTypeProperties {
    #[doc = "Storage linked service references."]
    #[serde(rename = "storageLinkedServices", default, skip_serializing_if = "Vec::is_empty")]
    pub storage_linked_services: Vec<LinkedServiceReference>,
    #[doc = "User specified arguments to HDInsightActivity. Type: array (or Expression with resultType array)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub arguments: Option<serde_json::Value>,
    #[doc = "The HDInsightActivityDebugInfoOption settings to use."]
    #[serde(rename = "getDebugInfo", default, skip_serializing_if = "Option::is_none")]
    pub get_debug_info: Option<HdInsightActivityDebugInfoOption>,
    #[doc = "Script path. Type: string (or Expression with resultType string)."]
    #[serde(rename = "scriptPath", default, skip_serializing_if = "Option::is_none")]
    pub script_path: Option<serde_json::Value>,
    #[doc = "Linked service reference type."]
    #[serde(rename = "scriptLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub script_linked_service: Option<LinkedServiceReference>,
    #[doc = "Allows user to specify defines for Pig job request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub defines: Option<serde_json::Value>,
}
impl HdInsightPigActivityTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "HDInsight Spark activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightSparkActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "HDInsight spark activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: HdInsightSparkActivityTypeProperties,
}
impl HdInsightSparkActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: HdInsightSparkActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "HDInsight spark activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightSparkActivityTypeProperties {
    #[doc = "The root path in 'sparkJobLinkedService' for all the job’s files. Type: string (or Expression with resultType string)."]
    #[serde(rename = "rootPath")]
    pub root_path: serde_json::Value,
    #[doc = "The relative path to the root folder of the code/package to be executed. Type: string (or Expression with resultType string)."]
    #[serde(rename = "entryFilePath")]
    pub entry_file_path: serde_json::Value,
    #[doc = "The user-specified arguments to HDInsightSparkActivity."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub arguments: Vec<serde_json::Value>,
    #[doc = "The HDInsightActivityDebugInfoOption settings to use."]
    #[serde(rename = "getDebugInfo", default, skip_serializing_if = "Option::is_none")]
    pub get_debug_info: Option<HdInsightActivityDebugInfoOption>,
    #[doc = "Linked service reference type."]
    #[serde(rename = "sparkJobLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub spark_job_linked_service: Option<LinkedServiceReference>,
    #[doc = "The application's Java/Spark main class."]
    #[serde(rename = "className", default, skip_serializing_if = "Option::is_none")]
    pub class_name: Option<String>,
    #[doc = "The user to impersonate that will execute the job. Type: string (or Expression with resultType string)."]
    #[serde(rename = "proxyUser", default, skip_serializing_if = "Option::is_none")]
    pub proxy_user: Option<serde_json::Value>,
    #[doc = "Spark configuration property."]
    #[serde(rename = "sparkConfig", default, skip_serializing_if = "Option::is_none")]
    pub spark_config: Option<serde_json::Value>,
}
impl HdInsightSparkActivityTypeProperties {
    pub fn new(root_path: serde_json::Value, entry_file_path: serde_json::Value) -> Self {
        Self {
            root_path,
            entry_file_path,
            arguments: Vec::new(),
            get_debug_info: None,
            spark_job_linked_service: None,
            class_name: None,
            proxy_user: None,
            spark_config: None,
        }
    }
}
#[doc = "HDInsight streaming activity type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightStreamingActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "HDInsight streaming activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: HdInsightStreamingActivityTypeProperties,
}
impl HdInsightStreamingActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: HdInsightStreamingActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "HDInsight streaming activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdInsightStreamingActivityTypeProperties {
    #[doc = "Storage linked service references."]
    #[serde(rename = "storageLinkedServices", default, skip_serializing_if = "Vec::is_empty")]
    pub storage_linked_services: Vec<LinkedServiceReference>,
    #[doc = "User specified arguments to HDInsightActivity."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub arguments: Vec<serde_json::Value>,
    #[doc = "The HDInsightActivityDebugInfoOption settings to use."]
    #[serde(rename = "getDebugInfo", default, skip_serializing_if = "Option::is_none")]
    pub get_debug_info: Option<HdInsightActivityDebugInfoOption>,
    #[doc = "Mapper executable name. Type: string (or Expression with resultType string)."]
    pub mapper: serde_json::Value,
    #[doc = "Reducer executable name. Type: string (or Expression with resultType string)."]
    pub reducer: serde_json::Value,
    #[doc = "Input blob path. Type: string (or Expression with resultType string)."]
    pub input: serde_json::Value,
    #[doc = "Output blob path. Type: string (or Expression with resultType string)."]
    pub output: serde_json::Value,
    #[doc = "Paths to streaming job files. Can be directories."]
    #[serde(rename = "filePaths")]
    pub file_paths: Vec<serde_json::Value>,
    #[doc = "Linked service reference type."]
    #[serde(rename = "fileLinkedService", default, skip_serializing_if = "Option::is_none")]
    pub file_linked_service: Option<LinkedServiceReference>,
    #[doc = "Combiner executable name. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub combiner: Option<serde_json::Value>,
    #[doc = "Command line environment values."]
    #[serde(rename = "commandEnvironment", default, skip_serializing_if = "Vec::is_empty")]
    pub command_environment: Vec<serde_json::Value>,
    #[doc = "Allows user to specify defines for streaming job request."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub defines: Option<serde_json::Value>,
}
impl HdInsightStreamingActivityTypeProperties {
    pub fn new(
        mapper: serde_json::Value,
        reducer: serde_json::Value,
        input: serde_json::Value,
        output: serde_json::Value,
        file_paths: Vec<serde_json::Value>,
    ) -> Self {
        Self {
            storage_linked_services: Vec::new(),
            arguments: Vec::new(),
            get_debug_info: None,
            mapper,
            reducer,
            input,
            output,
            file_paths,
            file_linked_service: None,
            combiner: None,
            command_environment: Vec::new(),
            defines: None,
        }
    }
}
#[doc = "Hadoop Distributed File System (HDFS) linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdfsLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "HDFS linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: HdfsLinkedServiceTypeProperties,
}
impl HdfsLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: HdfsLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "HDFS linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdfsLinkedServiceTypeProperties {
    #[doc = "The URL of the HDFS service endpoint, e.g. http://myhostname:50070/webhdfs/v1 . Type: string (or Expression with resultType string)."]
    pub url: serde_json::Value,
    #[doc = "Type of authentication used to connect to the HDFS. Possible values are: Anonymous and Windows. Type: string (or Expression with resultType string)."]
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[doc = "User name for Windows authentication. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
}
impl HdfsLinkedServiceTypeProperties {
    pub fn new(url: serde_json::Value) -> Self {
        Self {
            url,
            authentication_type: None,
            encrypted_credential: None,
            user_name: None,
            password: None,
        }
    }
}
#[doc = "The location of HDFS."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdfsLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
}
impl HdfsLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self { dataset_location }
    }
}
#[doc = "HDFS read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdfsReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[doc = "If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[doc = "HDFS wildcardFolderPath. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[doc = "HDFS wildcardFileName. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[doc = "Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[doc = "Indicates whether to enable partition discovery."]
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[doc = "Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[doc = "The start of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[doc = "The end of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
    #[doc = "Distcp settings."]
    #[serde(rename = "distcpSettings", default, skip_serializing_if = "Option::is_none")]
    pub distcp_settings: Option<DistcpSettings>,
    #[doc = "Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
}
impl HdfsReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            file_list_path: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
            distcp_settings: None,
            delete_files_after_completion: None,
        }
    }
}
#[doc = "A copy activity HDFS source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HdfsSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[doc = "Distcp settings."]
    #[serde(rename = "distcpSettings", default, skip_serializing_if = "Option::is_none")]
    pub distcp_settings: Option<DistcpSettings>,
}
impl HdfsSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            recursive: None,
            distcp_settings: None,
        }
    }
}
#[doc = "Hive Properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HiveDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The table name of the Hive. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[doc = "The schema name of the Hive. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl HiveDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Hive Server linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HiveLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Hive Server linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: HiveLinkedServiceTypeProperties,
}
impl HiveLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: HiveLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Hive Server linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HiveLinkedServiceTypeProperties {
    #[doc = "IP address or host name of the Hive server, separated by ';' for multiple hosts (only when serviceDiscoveryMode is enable)."]
    pub host: serde_json::Value,
    #[doc = "The TCP port that the Hive server uses to listen for client connections."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[doc = "The type of Hive server."]
    #[serde(rename = "serverType", default, skip_serializing_if = "Option::is_none")]
    pub server_type: Option<hive_linked_service_type_properties::ServerType>,
    #[doc = "The transport protocol to use in the Thrift layer."]
    #[serde(rename = "thriftTransportProtocol", default, skip_serializing_if = "Option::is_none")]
    pub thrift_transport_protocol: Option<hive_linked_service_type_properties::ThriftTransportProtocol>,
    #[doc = "The authentication method used to access the Hive server."]
    #[serde(rename = "authenticationType")]
    pub authentication_type: hive_linked_service_type_properties::AuthenticationType,
    #[doc = "true to indicate using the ZooKeeper service, false not."]
    #[serde(rename = "serviceDiscoveryMode", default, skip_serializing_if = "Option::is_none")]
    pub service_discovery_mode: Option<serde_json::Value>,
    #[doc = "The namespace on ZooKeeper under which Hive Server 2 nodes are added."]
    #[serde(rename = "zooKeeperNameSpace", default, skip_serializing_if = "Option::is_none")]
    pub zoo_keeper_name_space: Option<serde_json::Value>,
    #[doc = "Specifies whether the driver uses native HiveQL queries,or converts them into an equivalent form in HiveQL."]
    #[serde(rename = "useNativeQuery", default, skip_serializing_if = "Option::is_none")]
    pub use_native_query: Option<serde_json::Value>,
    #[doc = "The user name that you use to access Hive Server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The partial URL corresponding to the Hive server."]
    #[serde(rename = "httpPath", default, skip_serializing_if = "Option::is_none")]
    pub http_path: Option<serde_json::Value>,
    #[doc = "Specifies whether the connections to the server are encrypted using SSL. The default value is false."]
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<serde_json::Value>,
    #[doc = "The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR."]
    #[serde(rename = "trustedCertPath", default, skip_serializing_if = "Option::is_none")]
    pub trusted_cert_path: Option<serde_json::Value>,
    #[doc = "Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false."]
    #[serde(rename = "useSystemTrustStore", default, skip_serializing_if = "Option::is_none")]
    pub use_system_trust_store: Option<serde_json::Value>,
    #[doc = "Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false."]
    #[serde(rename = "allowHostNameCNMismatch", default, skip_serializing_if = "Option::is_none")]
    pub allow_host_name_cn_mismatch: Option<serde_json::Value>,
    #[doc = "Specifies whether to allow self-signed certificates from the server. The default value is false."]
    #[serde(rename = "allowSelfSignedServerCert", default, skip_serializing_if = "Option::is_none")]
    pub allow_self_signed_server_cert: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl HiveLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value, authentication_type: hive_linked_service_type_properties::AuthenticationType) -> Self {
        Self {
            host,
            port: None,
            server_type: None,
            thrift_transport_protocol: None,
            authentication_type,
            service_discovery_mode: None,
            zoo_keeper_name_space: None,
            use_native_query: None,
            username: None,
            password: None,
            http_path: None,
            enable_ssl: None,
            trusted_cert_path: None,
            use_system_trust_store: None,
            allow_host_name_cn_mismatch: None,
            allow_self_signed_server_cert: None,
            encrypted_credential: None,
        }
    }
}
pub mod hive_linked_service_type_properties {
    use super::*;
    #[doc = "The type of Hive server."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServerType {
        HiveServer1,
        HiveServer2,
        HiveThriftServer,
    }
    #[doc = "The transport protocol to use in the Thrift layer."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ThriftTransportProtocol {
        Binary,
        #[serde(rename = "SASL")]
        Sasl,
        #[serde(rename = "HTTP ")]
        Http,
    }
    #[doc = "The authentication method used to access the Hive server."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Anonymous,
        Username,
        UsernameAndPassword,
        #[serde(rename = "WindowsAzureHDInsightService")]
        WindowsAzureHdInsightService,
    }
}
#[doc = "Hive Server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HiveObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Hive Properties"]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<HiveDatasetTypeProperties>,
}
impl HiveObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Hive Server source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HiveSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl HiveSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "A file in an HTTP web server."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HttpDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<HttpDatasetTypeProperties>,
}
impl HttpDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Properties specific to this dataset type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct HttpDatasetTypeProperties {
    #[doc = "The relative URL based on the URL in the HttpLinkedService refers to an HTTP file Type: string (or Expression with resultType string)."]
    #[serde(rename = "relativeUrl", default, skip_serializing_if = "Option::is_none")]
    pub relative_url: Option<serde_json::Value>,
    #[doc = "The HTTP method for the HTTP request. Type: string (or Expression with resultType string)."]
    #[serde(rename = "requestMethod", default, skip_serializing_if = "Option::is_none")]
    pub request_method: Option<serde_json::Value>,
    #[doc = "The body for the HTTP request. Type: string (or Expression with resultType string)."]
    #[serde(rename = "requestBody", default, skip_serializing_if = "Option::is_none")]
    pub request_body: Option<serde_json::Value>,
    #[doc = "The headers for the HTTP Request. e.g. request-header-name-1:request-header-value-1\r\n...\r\nrequest-header-name-n:request-header-value-n Type: string (or Expression with resultType string)."]
    #[serde(rename = "additionalHeaders", default, skip_serializing_if = "Option::is_none")]
    pub additional_headers: Option<serde_json::Value>,
    #[doc = "The format definition of a storage."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub format: Option<DatasetStorageFormat>,
    #[doc = "The compression method used on a dataset."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl HttpDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Linked service for an HTTP source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HttpLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Properties specific to this linked service type."]
    #[serde(rename = "typeProperties")]
    pub type_properties: HttpLinkedServiceTypeProperties,
}
impl HttpLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: HttpLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Properties specific to this linked service type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HttpLinkedServiceTypeProperties {
    #[doc = "The base URL of the HTTP endpoint, e.g. http://www.microsoft.com. Type: string (or Expression with resultType string)."]
    pub url: serde_json::Value,
    #[doc = "The authentication type to be used to connect to the HTTP server."]
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<http_linked_service_type_properties::AuthenticationType>,
    #[doc = "User name for Basic, Digest, or Windows authentication. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "Base64 encoded certificate data for ClientCertificate authentication. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string)."]
    #[serde(rename = "embeddedCertData", default, skip_serializing_if = "Option::is_none")]
    pub embedded_cert_data: Option<serde_json::Value>,
    #[doc = "Thumbprint of certificate for ClientCertificate authentication. Only valid for on-premises copy. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string)."]
    #[serde(rename = "certThumbprint", default, skip_serializing_if = "Option::is_none")]
    pub cert_thumbprint: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[doc = "If true, validate the HTTPS server SSL certificate. Default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "enableServerCertificateValidation", default, skip_serializing_if = "Option::is_none")]
    pub enable_server_certificate_validation: Option<serde_json::Value>,
}
impl HttpLinkedServiceTypeProperties {
    pub fn new(url: serde_json::Value) -> Self {
        Self {
            url,
            authentication_type: None,
            user_name: None,
            password: None,
            embedded_cert_data: None,
            cert_thumbprint: None,
            encrypted_credential: None,
            enable_server_certificate_validation: None,
        }
    }
}
pub mod http_linked_service_type_properties {
    use super::*;
    #[doc = "The authentication type to be used to connect to the HTTP server."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        Anonymous,
        Digest,
        Windows,
        ClientCertificate,
    }
}
#[doc = "Sftp read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HttpReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[doc = "The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string)."]
    #[serde(rename = "requestMethod", default, skip_serializing_if = "Option::is_none")]
    pub request_method: Option<serde_json::Value>,
    #[doc = "The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string)."]
    #[serde(rename = "requestBody", default, skip_serializing_if = "Option::is_none")]
    pub request_body: Option<serde_json::Value>,
    #[doc = "The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string)."]
    #[serde(rename = "additionalHeaders", default, skip_serializing_if = "Option::is_none")]
    pub additional_headers: Option<serde_json::Value>,
    #[doc = "Specifies the timeout for a HTTP client to get HTTP response from HTTP server."]
    #[serde(rename = "requestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub request_timeout: Option<serde_json::Value>,
    #[doc = "Indicates whether to enable partition discovery."]
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[doc = "Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
}
impl HttpReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            request_method: None,
            request_body: None,
            additional_headers: None,
            request_timeout: None,
            enable_partition_discovery: None,
            partition_root_path: None,
        }
    }
}
#[doc = "The location of http server."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HttpServerLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
    #[doc = "Specify the relativeUrl of http server. Type: string (or Expression with resultType string)"]
    #[serde(rename = "relativeUrl", default, skip_serializing_if = "Option::is_none")]
    pub relative_url: Option<serde_json::Value>,
}
impl HttpServerLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self {
            dataset_location,
            relative_url: None,
        }
    }
}
#[doc = "A copy activity source for an HTTP file."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HttpSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Specifies the timeout for a HTTP client to get HTTP response from HTTP server. The default value is equivalent to System.Net.HttpWebRequest.Timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
}
impl HttpSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            http_request_timeout: None,
        }
    }
}
#[doc = "Hubspot Service linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HubspotLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Hubspot Service linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: HubspotLinkedServiceTypeProperties,
}
impl HubspotLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: HubspotLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Hubspot Service linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HubspotLinkedServiceTypeProperties {
    #[doc = "The client ID associated with your Hubspot application."]
    #[serde(rename = "clientId")]
    pub client_id: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "accessToken", default, skip_serializing_if = "Option::is_none")]
    pub access_token: Option<SecretBase>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "refreshToken", default, skip_serializing_if = "Option::is_none")]
    pub refresh_token: Option<SecretBase>,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[doc = "Specifies whether to verify the identity of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl HubspotLinkedServiceTypeProperties {
    pub fn new(client_id: serde_json::Value) -> Self {
        Self {
            client_id,
            client_secret: None,
            access_token: None,
            refresh_token: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Hubspot Service dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HubspotObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl HubspotObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Hubspot Service source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HubspotSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl HubspotSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "This activity evaluates a boolean expression and executes either the activities under the ifTrueActivities property or the ifFalseActivities property depending on the result of the expression."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IfConditionActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[doc = "IfCondition activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: IfConditionActivityTypeProperties,
}
impl IfConditionActivity {
    pub fn new(control_activity: ControlActivity, type_properties: IfConditionActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[doc = "IfCondition activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IfConditionActivityTypeProperties {
    #[doc = "Azure Synapse expression definition."]
    pub expression: Expression,
    #[doc = "List of activities to execute if expression is evaluated to true. This is an optional property and if not provided, the activity will exit without any action."]
    #[serde(rename = "ifTrueActivities", default, skip_serializing_if = "Vec::is_empty")]
    pub if_true_activities: Vec<Activity>,
    #[doc = "List of activities to execute if expression is evaluated to false. This is an optional property and if not provided, the activity will exit without any action."]
    #[serde(rename = "ifFalseActivities", default, skip_serializing_if = "Vec::is_empty")]
    pub if_false_activities: Vec<Activity>,
}
impl IfConditionActivityTypeProperties {
    pub fn new(expression: Expression) -> Self {
        Self {
            expression,
            if_true_activities: Vec::new(),
            if_false_activities: Vec::new(),
        }
    }
}
#[doc = "Impala Dataset Properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImpalaDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The table name of the Impala. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[doc = "The schema name of the Impala. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl ImpalaDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Impala server linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImpalaLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Impala server linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: ImpalaLinkedServiceTypeProperties,
}
impl ImpalaLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: ImpalaLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Impala server linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImpalaLinkedServiceTypeProperties {
    #[doc = "The IP address or host name of the Impala server. (i.e. 192.168.222.160)"]
    pub host: serde_json::Value,
    #[doc = "The TCP port that the Impala server uses to listen for client connections. The default value is 21050."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[doc = "The authentication type to use."]
    #[serde(rename = "authenticationType")]
    pub authentication_type: impala_linked_service_type_properties::AuthenticationType,
    #[doc = "The user name used to access the Impala server. The default value is anonymous when using SASLUsername."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "Specifies whether the connections to the server are encrypted using SSL. The default value is false."]
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<serde_json::Value>,
    #[doc = "The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR."]
    #[serde(rename = "trustedCertPath", default, skip_serializing_if = "Option::is_none")]
    pub trusted_cert_path: Option<serde_json::Value>,
    #[doc = "Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false."]
    #[serde(rename = "useSystemTrustStore", default, skip_serializing_if = "Option::is_none")]
    pub use_system_trust_store: Option<serde_json::Value>,
    #[doc = "Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false."]
    #[serde(rename = "allowHostNameCNMismatch", default, skip_serializing_if = "Option::is_none")]
    pub allow_host_name_cn_mismatch: Option<serde_json::Value>,
    #[doc = "Specifies whether to allow self-signed certificates from the server. The default value is false."]
    #[serde(rename = "allowSelfSignedServerCert", default, skip_serializing_if = "Option::is_none")]
    pub allow_self_signed_server_cert: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl ImpalaLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value, authentication_type: impala_linked_service_type_properties::AuthenticationType) -> Self {
        Self {
            host,
            port: None,
            authentication_type,
            username: None,
            password: None,
            enable_ssl: None,
            trusted_cert_path: None,
            use_system_trust_store: None,
            allow_host_name_cn_mismatch: None,
            allow_self_signed_server_cert: None,
            encrypted_credential: None,
        }
    }
}
pub mod impala_linked_service_type_properties {
    use super::*;
    #[doc = "The authentication type to use."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Anonymous,
        #[serde(rename = "SASLUsername")]
        SaslUsername,
        UsernameAndPassword,
    }
}
#[doc = "Impala server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImpalaObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Impala Dataset Properties"]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<ImpalaDatasetTypeProperties>,
}
impl ImpalaObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Impala server source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImpalaSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl ImpalaSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Import command settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ImportSettings {
    #[doc = "The import setting type."]
    #[serde(rename = "type")]
    pub type_: String,
}
impl ImportSettings {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[doc = "Informix linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InformixLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Informix linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: InformixLinkedServiceTypeProperties,
}
impl InformixLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: InformixLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Informix linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InformixLinkedServiceTypeProperties {
    #[doc = "The non-access credential portion of the connection string as well as an optional encrypted credential. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[doc = "Type of authentication used to connect to the Informix as ODBC data store. Possible values are: Anonymous and Basic. Type: string (or Expression with resultType string)."]
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<SecretBase>,
    #[doc = "User name for Basic authentication. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl InformixLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            authentication_type: None,
            credential: None,
            user_name: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "A copy activity Informix sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InformixSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "A query to execute before starting the copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
}
impl InformixSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
        }
    }
}
#[doc = "A copy activity source for Informix."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InformixSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "Database query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl InformixSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "The Informix table dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InformixTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Informix table dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<InformixTableDatasetTypeProperties>,
}
impl InformixTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Informix table dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InformixTableDatasetTypeProperties {
    #[doc = "The Informix table name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
}
impl InformixTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Synapse nested object which serves as a compute resource for activities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationRuntime {
    #[doc = "The type of integration runtime."]
    #[serde(rename = "type")]
    pub type_: IntegrationRuntimeType,
    #[doc = "Integration runtime description."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl IntegrationRuntime {
    pub fn new(type_: IntegrationRuntimeType) -> Self {
        Self { type_, description: None }
    }
}
#[doc = "Integration runtime debug resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationRuntimeDebugResource {
    #[serde(flatten)]
    pub sub_resource_debug_resource: SubResourceDebugResource,
    #[doc = "Azure Synapse nested object which serves as a compute resource for activities."]
    pub properties: IntegrationRuntime,
}
impl IntegrationRuntimeDebugResource {
    pub fn new(properties: IntegrationRuntime) -> Self {
        Self {
            sub_resource_debug_resource: SubResourceDebugResource::default(),
            properties,
        }
    }
}
#[doc = "A list of integration runtime resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationRuntimeListResponse {
    #[doc = "List of integration runtimes."]
    pub value: Vec<IntegrationRuntimeResource>,
    #[doc = "The link to the next page of results, if any remaining results exist."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl IntegrationRuntimeListResponse {
    pub fn new(value: Vec<IntegrationRuntimeResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Integration runtime reference type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationRuntimeReference {
    #[doc = "Type of integration runtime."]
    #[serde(rename = "type")]
    pub type_: integration_runtime_reference::Type,
    #[doc = "Reference integration runtime name."]
    #[serde(rename = "referenceName")]
    pub reference_name: String,
    #[doc = "An object mapping parameter names to argument values."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterValueSpecification>,
}
impl IntegrationRuntimeReference {
    pub fn new(type_: integration_runtime_reference::Type, reference_name: String) -> Self {
        Self {
            type_,
            reference_name,
            parameters: None,
        }
    }
}
pub mod integration_runtime_reference {
    use super::*;
    #[doc = "Type of integration runtime."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        IntegrationRuntimeReference,
    }
}
#[doc = "Integration runtime resource type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IntegrationRuntimeResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Azure Synapse nested object which serves as a compute resource for activities."]
    pub properties: IntegrationRuntime,
}
impl IntegrationRuntimeResource {
    pub fn new(properties: IntegrationRuntime) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[doc = "The type of integration runtime."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum IntegrationRuntimeType {
    Managed,
    SelfHosted,
}
#[doc = "Jira Service linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JiraLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Jira Service linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: JiraLinkedServiceTypeProperties,
}
impl JiraLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: JiraLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Jira Service linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JiraLinkedServiceTypeProperties {
    #[doc = "The IP address or host name of the Jira service. (e.g. jira.example.com)"]
    pub host: serde_json::Value,
    #[doc = "The TCP port that the Jira server uses to listen for client connections. The default value is 443 if connecting through HTTPS, or 8080 if connecting through HTTP."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[doc = "The user name that you use to access Jira Service."]
    pub username: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[doc = "Specifies whether to verify the identity of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl JiraLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value, username: serde_json::Value) -> Self {
        Self {
            host,
            port: None,
            username,
            password: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Jira Service dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JiraObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl JiraObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Jira Service source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JiraSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl JiraSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Json dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JsonDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Json dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<JsonDatasetTypeProperties>,
}
impl JsonDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Json dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JsonDatasetTypeProperties {
    #[doc = "Dataset location."]
    pub location: DatasetLocation,
    #[doc = "The code page name of the preferred encoding. If not specified, the default value is UTF-8, unless BOM denotes another Unicode encoding. Refer to the name column of the table in the following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encodingName", default, skip_serializing_if = "Option::is_none")]
    pub encoding_name: Option<serde_json::Value>,
    #[doc = "The compression method used on a dataset."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl JsonDatasetTypeProperties {
    pub fn new(location: DatasetLocation) -> Self {
        Self {
            location,
            encoding_name: None,
            compression: None,
        }
    }
}
#[doc = "The data stored in JSON format."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JsonFormat {
    #[serde(flatten)]
    pub dataset_storage_format: DatasetStorageFormat,
    #[doc = "JSON format file pattern. A property of JsonFormat."]
    #[serde(rename = "filePattern", default, skip_serializing_if = "Option::is_none")]
    pub file_pattern: Option<JsonFormatFilePattern>,
    #[doc = "The character used to separate nesting levels. Default value is '.' (dot). Type: string (or Expression with resultType string)."]
    #[serde(rename = "nestingSeparator", default, skip_serializing_if = "Option::is_none")]
    pub nesting_separator: Option<serde_json::Value>,
    #[doc = "The code page name of the preferred encoding. If not provided, the default value is 'utf-8', unless the byte order mark (BOM) denotes another Unicode encoding. The full list of supported values can be found in the 'Name' column of the table of encodings in the following reference: https://go.microsoft.com/fwlink/?linkid=861078. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encodingName", default, skip_serializing_if = "Option::is_none")]
    pub encoding_name: Option<serde_json::Value>,
    #[doc = "The JSONPath of the JSON array element to be flattened. Example: \"$.ArrayPath\". Type: string (or Expression with resultType string)."]
    #[serde(rename = "jsonNodeReference", default, skip_serializing_if = "Option::is_none")]
    pub json_node_reference: Option<serde_json::Value>,
    #[doc = "The JSONPath definition for each column mapping with a customized column name to extract data from JSON file. For fields under root object, start with \"$\"; for fields inside the array chosen by jsonNodeReference property, start from the array element. Example: {\"Column1\": \"$.Column1Path\", \"Column2\": \"Column2PathInArray\"}. Type: object (or Expression with resultType object)."]
    #[serde(rename = "jsonPathDefinition", default, skip_serializing_if = "Option::is_none")]
    pub json_path_definition: Option<serde_json::Value>,
}
impl JsonFormat {
    pub fn new(dataset_storage_format: DatasetStorageFormat) -> Self {
        Self {
            dataset_storage_format,
            file_pattern: None,
            nesting_separator: None,
            encoding_name: None,
            json_node_reference: None,
            json_path_definition: None,
        }
    }
}
#[doc = "JSON format file pattern. A property of JsonFormat."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum JsonFormatFilePattern {
    #[serde(rename = "setOfObjects")]
    SetOfObjects,
    #[serde(rename = "arrayOfObjects")]
    ArrayOfObjects,
}
#[doc = "Json read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JsonReadSettings {
    #[serde(flatten)]
    pub format_read_settings: FormatReadSettings,
    #[doc = "Compression read settings."]
    #[serde(rename = "compressionProperties", default, skip_serializing_if = "Option::is_none")]
    pub compression_properties: Option<CompressionReadSettings>,
}
impl JsonReadSettings {
    pub fn new(format_read_settings: FormatReadSettings) -> Self {
        Self {
            format_read_settings,
            compression_properties: None,
        }
    }
}
#[doc = "A copy activity Json sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JsonSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "Connector write settings."]
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreWriteSettings>,
    #[doc = "Json write settings."]
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<JsonWriteSettings>,
}
impl JsonSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            store_settings: None,
            format_settings: None,
        }
    }
}
#[doc = "A copy activity Json source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JsonSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Connector read setting."]
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[doc = "Json read settings."]
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<JsonReadSettings>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl JsonSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            store_settings: None,
            format_settings: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "Json write settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JsonWriteSettings {
    #[serde(flatten)]
    pub format_write_settings: FormatWriteSettings,
    #[doc = "File pattern of JSON. This setting controls the way a collection of JSON objects will be treated. The default value is 'setOfObjects'. It is case-sensitive."]
    #[serde(rename = "filePattern", default, skip_serializing_if = "Option::is_none")]
    pub file_pattern: Option<json_write_settings::FilePattern>,
}
impl JsonWriteSettings {
    pub fn new(format_write_settings: FormatWriteSettings) -> Self {
        Self {
            format_write_settings,
            file_pattern: None,
        }
    }
}
pub mod json_write_settings {
    use super::*;
    #[doc = "File pattern of JSON. This setting controls the way a collection of JSON objects will be treated. The default value is 'setOfObjects'. It is case-sensitive."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum FilePattern {
        #[serde(rename = "setOfObjects")]
        SetOfObjects,
        #[serde(rename = "arrayOfObjects")]
        ArrayOfObjects,
    }
}
#[doc = "Library/package information of a Big Data pool powered by Apache Spark"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LibraryInfo {
    #[doc = "Name of the library."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Storage blob path of library."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "Storage blob container name."]
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[doc = "The last update time of the library."]
    #[serde(rename = "uploadedTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub uploaded_timestamp: Option<String>,
    #[doc = "Type of the library."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Provisioning status of the library/package."]
    #[serde(rename = "provisioningStatus", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_status: Option<String>,
    #[doc = "Creator Id of the library/package."]
    #[serde(rename = "creatorId", default, skip_serializing_if = "Option::is_none")]
    pub creator_id: Option<String>,
}
impl LibraryInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of Library resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LibraryListResponse {
    #[doc = "List of Library."]
    pub value: Vec<LibraryResource>,
    #[doc = "The link to the next page of results, if any remaining results exist."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LibraryListResponse {
    pub fn new(value: Vec<LibraryResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Library requirements for a Big Data pool powered by Apache Spark"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LibraryRequirements {
    #[doc = "The last update time of the library requirements file."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
    #[doc = "The library requirements."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
    #[doc = "The filename of the library requirements file."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filename: Option<String>,
}
impl LibraryRequirements {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Library response details"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LibraryResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Library/package properties"]
    pub properties: LibraryResourceProperties,
}
impl LibraryResource {
    pub fn new(properties: LibraryResourceProperties) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[doc = "Library resource info "]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LibraryResourceInfo {
    #[doc = "Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "record Id of the library/package."]
    #[serde(rename = "recordId", default, skip_serializing_if = "Option::is_none")]
    pub record_id: Option<i64>,
    #[doc = "Provisioning status of the library/package."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The creation time of the library/package."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    #[doc = "The last updated time of the library/package."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub changed: Option<String>,
    #[doc = "The type of the resource. E.g. LibraryArtifact"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Name of the library/package."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Operation Id of the operation performed on library/package."]
    #[serde(rename = "operationId", default, skip_serializing_if = "Option::is_none")]
    pub operation_id: Option<String>,
    #[doc = "artifact Id of the library/package."]
    #[serde(rename = "artifactId", default, skip_serializing_if = "Option::is_none")]
    pub artifact_id: Option<String>,
}
impl LibraryResourceInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Library/package properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LibraryResourceProperties {
    #[doc = "Name of the library/package."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Location of library/package in storage account."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[doc = "Container name of the library/package."]
    #[serde(rename = "containerName", default, skip_serializing_if = "Option::is_none")]
    pub container_name: Option<String>,
    #[doc = "The last update time of the library/package."]
    #[serde(rename = "uploadedTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub uploaded_timestamp: Option<String>,
    #[doc = "Type of the library/package."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Provisioning status of the library/package."]
    #[serde(rename = "provisioningStatus", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_status: Option<String>,
    #[doc = "Creator Id of the library/package."]
    #[serde(rename = "creatorId", default, skip_serializing_if = "Option::is_none")]
    pub creator_id: Option<String>,
}
impl LibraryResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Azure Synapse nested object which contains the information and credential which can be used to connect with related store or compute resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkedService {
    #[doc = "Type of linked service."]
    #[serde(rename = "type")]
    pub type_: String,
    #[doc = "Integration runtime reference type."]
    #[serde(rename = "connectVia", default, skip_serializing_if = "Option::is_none")]
    pub connect_via: Option<IntegrationRuntimeReference>,
    #[doc = "Linked service description."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Definition of all parameters for an entity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterDefinitionSpecification>,
    #[doc = "List of tags that can be used for describing the linked service."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub annotations: Vec<serde_json::Value>,
}
impl LinkedService {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            connect_via: None,
            description: None,
            parameters: None,
            annotations: Vec::new(),
        }
    }
}
#[doc = "Linked service debug resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkedServiceDebugResource {
    #[serde(flatten)]
    pub sub_resource_debug_resource: SubResourceDebugResource,
    #[doc = "The Azure Synapse nested object which contains the information and credential which can be used to connect with related store or compute resource."]
    pub properties: LinkedService,
}
impl LinkedServiceDebugResource {
    pub fn new(properties: LinkedService) -> Self {
        Self {
            sub_resource_debug_resource: SubResourceDebugResource::default(),
            properties,
        }
    }
}
#[doc = "A list of linked service resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkedServiceListResponse {
    #[doc = "List of linked services."]
    pub value: Vec<LinkedServiceResource>,
    #[doc = "The link to the next page of results, if any remaining results exist."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl LinkedServiceListResponse {
    pub fn new(value: Vec<LinkedServiceResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Linked service reference type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkedServiceReference {
    #[doc = "Linked service reference type."]
    #[serde(rename = "type")]
    pub type_: linked_service_reference::Type,
    #[doc = "Reference LinkedService name."]
    #[serde(rename = "referenceName")]
    pub reference_name: String,
    #[doc = "An object mapping parameter names to argument values."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterValueSpecification>,
}
impl LinkedServiceReference {
    pub fn new(type_: linked_service_reference::Type, reference_name: String) -> Self {
        Self {
            type_,
            reference_name,
            parameters: None,
        }
    }
}
pub mod linked_service_reference {
    use super::*;
    #[doc = "Linked service reference type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        LinkedServiceReference,
    }
}
#[doc = "Linked service resource type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LinkedServiceResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "The Azure Synapse nested object which contains the information and credential which can be used to connect with related store or compute resource."]
    pub properties: LinkedService,
}
impl LinkedServiceResource {
    pub fn new(properties: LinkedService) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[doc = "Log location settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogLocationSettings {
    #[doc = "Linked service reference type."]
    #[serde(rename = "linkedServiceName")]
    pub linked_service_name: LinkedServiceReference,
    #[doc = "The path to storage for storing detailed logs of activity execution. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<serde_json::Value>,
}
impl LogLocationSettings {
    pub fn new(linked_service_name: LinkedServiceReference) -> Self {
        Self {
            linked_service_name,
            path: None,
        }
    }
}
#[doc = "Log settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogSettings {
    #[doc = "Specifies whether to enable copy activity log. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "enableCopyActivityLog", default, skip_serializing_if = "Option::is_none")]
    pub enable_copy_activity_log: Option<serde_json::Value>,
    #[doc = "Settings for copy activity log."]
    #[serde(rename = "copyActivityLogSettings", default, skip_serializing_if = "Option::is_none")]
    pub copy_activity_log_settings: Option<CopyActivityLogSettings>,
    #[doc = "Log location settings."]
    #[serde(rename = "logLocationSettings")]
    pub log_location_settings: LogLocationSettings,
}
impl LogSettings {
    pub fn new(log_location_settings: LogLocationSettings) -> Self {
        Self {
            enable_copy_activity_log: None,
            copy_activity_log_settings: None,
            log_location_settings,
        }
    }
}
#[doc = "(Deprecated. Please use LogSettings) Log storage settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LogStorageSettings {
    #[doc = "Linked service reference type."]
    #[serde(rename = "linkedServiceName")]
    pub linked_service_name: LinkedServiceReference,
    #[doc = "The path to storage for storing detailed logs of activity execution. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<serde_json::Value>,
    #[doc = "Gets or sets the log level, support: Info, Warning. Type: string (or Expression with resultType string)."]
    #[serde(rename = "logLevel", default, skip_serializing_if = "Option::is_none")]
    pub log_level: Option<serde_json::Value>,
    #[doc = "Specifies whether to enable reliable logging. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "enableReliableLogging", default, skip_serializing_if = "Option::is_none")]
    pub enable_reliable_logging: Option<serde_json::Value>,
}
impl LogStorageSettings {
    pub fn new(linked_service_name: LinkedServiceReference) -> Self {
        Self {
            linked_service_name,
            path: None,
            log_level: None,
            enable_reliable_logging: None,
        }
    }
}
#[doc = "Lookup activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LookupActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Lookup activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: LookupActivityTypeProperties,
}
impl LookupActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: LookupActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "Lookup activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct LookupActivityTypeProperties {
    #[doc = "A copy activity source."]
    pub source: CopySource,
    #[doc = "Dataset reference type."]
    pub dataset: DatasetReference,
    #[doc = "Whether to return first row or all rows. Default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "firstRowOnly", default, skip_serializing_if = "Option::is_none")]
    pub first_row_only: Option<serde_json::Value>,
}
impl LookupActivityTypeProperties {
    pub fn new(source: CopySource, dataset: DatasetReference) -> Self {
        Self {
            source,
            dataset,
            first_row_only: None,
        }
    }
}
#[doc = "Magento server linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MagentoLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Magento server linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: MagentoLinkedServiceTypeProperties,
}
impl MagentoLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: MagentoLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Magento server linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MagentoLinkedServiceTypeProperties {
    #[doc = "The URL of the Magento instance. (i.e. 192.168.222.110/magento3)"]
    pub host: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "accessToken", default, skip_serializing_if = "Option::is_none")]
    pub access_token: Option<SecretBase>,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[doc = "Specifies whether to verify the identity of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl MagentoLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value) -> Self {
        Self {
            host,
            access_token: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Magento server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MagentoObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl MagentoObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Magento server source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MagentoSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl MagentoSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "The workspace managed identity"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedIdentity {
    #[doc = "The principal ID of the workspace managed identity"]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[doc = "The tenant ID of the workspace managed identity"]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "The type of managed identity for the workspace"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<managed_identity::Type>,
}
impl ManagedIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod managed_identity {
    use super::*;
    #[doc = "The type of managed identity for the workspace"]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        None,
        SystemAssigned,
    }
}
#[doc = "Managed Virtual Network Settings"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedVirtualNetworkSettings {
    #[doc = "Prevent Data Exfiltration"]
    #[serde(rename = "preventDataExfiltration", default, skip_serializing_if = "Option::is_none")]
    pub prevent_data_exfiltration: Option<bool>,
    #[doc = "Linked Access Check On Target Resource"]
    #[serde(rename = "linkedAccessCheckOnTargetResource", default, skip_serializing_if = "Option::is_none")]
    pub linked_access_check_on_target_resource: Option<bool>,
    #[doc = "Allowed Aad Tenant Ids For Linking"]
    #[serde(rename = "allowedAadTenantIdsForLinking", default, skip_serializing_if = "Vec::is_empty")]
    pub allowed_aad_tenant_ids_for_linking: Vec<String>,
}
impl ManagedVirtualNetworkSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Mapping data flow."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MappingDataFlow {
    #[serde(flatten)]
    pub data_flow: DataFlow,
    #[doc = "Mapping data flow type properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<MappingDataFlowTypeProperties>,
}
impl MappingDataFlow {
    pub fn new(data_flow: DataFlow) -> Self {
        Self {
            data_flow,
            type_properties: None,
        }
    }
}
#[doc = "Mapping data flow type properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MappingDataFlowTypeProperties {
    #[doc = "List of sources in data flow."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sources: Vec<DataFlowSource>,
    #[doc = "List of sinks in data flow."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub sinks: Vec<DataFlowSink>,
    #[doc = "List of transformations in data flow."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub transformations: Vec<Transformation>,
    #[doc = "DataFlow script."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub script: Option<String>,
    #[doc = "Data flow script lines."]
    #[serde(rename = "scriptLines", default, skip_serializing_if = "Vec::is_empty")]
    pub script_lines: Vec<String>,
}
impl MappingDataFlowTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "MariaDB server linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MariaDbLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "MariaDB server linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: MariaDbLinkedServiceTypeProperties,
}
impl MariaDbLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: MariaDbLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "MariaDB server linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MariaDbLinkedServiceTypeProperties {
    #[doc = "An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pwd: Option<AzureKeyVaultSecretReference>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl MariaDbLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A copy activity MariaDB server source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MariaDbSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl MariaDbSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "MariaDB server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MariaDbTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl MariaDbTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Marketo server linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MarketoLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Marketo server linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: MarketoLinkedServiceTypeProperties,
}
impl MarketoLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: MarketoLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Marketo server linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MarketoLinkedServiceTypeProperties {
    #[doc = "The endpoint of the Marketo server. (i.e. 123-ABC-321.mktorest.com)"]
    pub endpoint: serde_json::Value,
    #[doc = "The client Id of your Marketo service."]
    #[serde(rename = "clientId")]
    pub client_id: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[doc = "Specifies whether to verify the identity of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl MarketoLinkedServiceTypeProperties {
    pub fn new(endpoint: serde_json::Value, client_id: serde_json::Value) -> Self {
        Self {
            endpoint,
            client_id,
            client_secret: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Marketo server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MarketoObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl MarketoObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Marketo server source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MarketoSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl MarketoSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Microsoft Access linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftAccessLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Microsoft Access linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: MicrosoftAccessLinkedServiceTypeProperties,
}
impl MicrosoftAccessLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: MicrosoftAccessLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Microsoft Access linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftAccessLinkedServiceTypeProperties {
    #[doc = "The non-access credential portion of the connection string as well as an optional encrypted credential. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[doc = "Type of authentication used to connect to the Microsoft Access as ODBC data store. Possible values are: Anonymous and Basic. Type: string (or Expression with resultType string)."]
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<SecretBase>,
    #[doc = "User name for Basic authentication. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl MicrosoftAccessLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            authentication_type: None,
            credential: None,
            user_name: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "A copy activity Microsoft Access sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftAccessSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "A query to execute before starting the copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
}
impl MicrosoftAccessSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
        }
    }
}
#[doc = "A copy activity source for Microsoft Access."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftAccessSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Database query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl MicrosoftAccessSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "The Microsoft Access table dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftAccessTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Microsoft Access table dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<MicrosoftAccessTableDatasetTypeProperties>,
}
impl MicrosoftAccessTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Microsoft Access table dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MicrosoftAccessTableDatasetTypeProperties {
    #[doc = "The Microsoft Access table name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
}
impl MicrosoftAccessTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The MongoDB Atlas database dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbAtlasCollectionDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "MongoDB Atlas database dataset properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: MongoDbAtlasCollectionDatasetTypeProperties,
}
impl MongoDbAtlasCollectionDataset {
    pub fn new(dataset: Dataset, type_properties: MongoDbAtlasCollectionDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "MongoDB Atlas database dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbAtlasCollectionDatasetTypeProperties {
    #[doc = "The collection name of the MongoDB Atlas database. Type: string (or Expression with resultType string)."]
    pub collection: serde_json::Value,
}
impl MongoDbAtlasCollectionDatasetTypeProperties {
    pub fn new(collection: serde_json::Value) -> Self {
        Self { collection }
    }
}
#[doc = "Linked service for MongoDB Atlas data source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbAtlasLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "MongoDB Atlas linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: MongoDbAtlasLinkedServiceTypeProperties,
}
impl MongoDbAtlasLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: MongoDbAtlasLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "MongoDB Atlas linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbAtlasLinkedServiceTypeProperties {
    #[doc = "The MongoDB Atlas connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[doc = "The name of the MongoDB Atlas database that you want to access. Type: string (or Expression with resultType string)."]
    pub database: serde_json::Value,
}
impl MongoDbAtlasLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value, database: serde_json::Value) -> Self {
        Self {
            connection_string,
            database,
        }
    }
}
#[doc = "A copy activity source for a MongoDB Atlas database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbAtlasSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Specifies selection filter using query operators. To return all documents in a collection, omit this parameter or pass an empty document ({}). Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<serde_json::Value>,
    #[doc = "Cursor methods for Mongodb query"]
    #[serde(rename = "cursorMethods", default, skip_serializing_if = "Option::is_none")]
    pub cursor_methods: Option<MongoDbCursorMethodsProperties>,
    #[doc = "Specifies the number of documents to return in each batch of the response from MongoDB Atlas instance. In most cases, modifying the batch size will not affect the user or the application. This property's main purpose is to avoid hit the limitation of response size. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "batchSize", default, skip_serializing_if = "Option::is_none")]
    pub batch_size: Option<serde_json::Value>,
    #[doc = "Query timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<serde_json::Value>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl MongoDbAtlasSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            filter: None,
            cursor_methods: None,
            batch_size: None,
            query_timeout: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "The MongoDB database dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbCollectionDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "MongoDB database dataset properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: MongoDbCollectionDatasetTypeProperties,
}
impl MongoDbCollectionDataset {
    pub fn new(dataset: Dataset, type_properties: MongoDbCollectionDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "MongoDB database dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbCollectionDatasetTypeProperties {
    #[doc = "The table name of the MongoDB database. Type: string (or Expression with resultType string)."]
    #[serde(rename = "collectionName")]
    pub collection_name: serde_json::Value,
}
impl MongoDbCollectionDatasetTypeProperties {
    pub fn new(collection_name: serde_json::Value) -> Self {
        Self { collection_name }
    }
}
#[doc = "Cursor methods for Mongodb query"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MongoDbCursorMethodsProperties {
    #[doc = "Specifies the fields to return in the documents that match the query filter. To return all fields in the matching documents, omit this parameter. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub project: Option<serde_json::Value>,
    #[doc = "Specifies the order in which the query returns matching documents. Type: string (or Expression with resultType string). Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sort: Option<serde_json::Value>,
    #[doc = "Specifies the how many documents skipped and where MongoDB begins returning results. This approach may be useful in implementing paginated results. Type: integer (or Expression with resultType integer)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub skip: Option<serde_json::Value>,
    #[doc = "Specifies the maximum number of documents the server returns. limit() is analogous to the LIMIT statement in a SQL database. Type: integer (or Expression with resultType integer)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<serde_json::Value>,
}
impl MongoDbCursorMethodsProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Linked service for MongoDb data source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "MongoDB linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: MongoDbLinkedServiceTypeProperties,
}
impl MongoDbLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: MongoDbLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "MongoDB linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbLinkedServiceTypeProperties {
    #[doc = "The IP address or server name of the MongoDB server. Type: string (or Expression with resultType string)."]
    pub server: serde_json::Value,
    #[doc = "The authentication type to be used to connect to the MongoDB database."]
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<mongo_db_linked_service_type_properties::AuthenticationType>,
    #[doc = "The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string)."]
    #[serde(rename = "databaseName")]
    pub database_name: serde_json::Value,
    #[doc = "Username for authentication. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "Database to verify the username and password. Type: string (or Expression with resultType string)."]
    #[serde(rename = "authSource", default, skip_serializing_if = "Option::is_none")]
    pub auth_source: Option<serde_json::Value>,
    #[doc = "The TCP port number that the MongoDB server uses to listen for client connections. The default value is 27017. Type: integer (or Expression with resultType integer), minimum: 0."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[doc = "Specifies whether the connections to the server are encrypted using SSL. The default value is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<serde_json::Value>,
    #[doc = "Specifies whether to allow self-signed certificates from the server. The default value is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "allowSelfSignedServerCert", default, skip_serializing_if = "Option::is_none")]
    pub allow_self_signed_server_cert: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl MongoDbLinkedServiceTypeProperties {
    pub fn new(server: serde_json::Value, database_name: serde_json::Value) -> Self {
        Self {
            server,
            authentication_type: None,
            database_name,
            username: None,
            password: None,
            auth_source: None,
            port: None,
            enable_ssl: None,
            allow_self_signed_server_cert: None,
            encrypted_credential: None,
        }
    }
}
pub mod mongo_db_linked_service_type_properties {
    use super::*;
    #[doc = "The authentication type to be used to connect to the MongoDB database."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        Anonymous,
    }
}
#[doc = "A copy activity source for a MongoDB database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Database query. Should be a SQL-92 query expression. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl MongoDbSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "The MongoDB database dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbV2CollectionDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "MongoDB database dataset properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: MongoDbV2CollectionDatasetTypeProperties,
}
impl MongoDbV2CollectionDataset {
    pub fn new(dataset: Dataset, type_properties: MongoDbV2CollectionDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "MongoDB database dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbV2CollectionDatasetTypeProperties {
    #[doc = "The collection name of the MongoDB database. Type: string (or Expression with resultType string)."]
    pub collection: serde_json::Value,
}
impl MongoDbV2CollectionDatasetTypeProperties {
    pub fn new(collection: serde_json::Value) -> Self {
        Self { collection }
    }
}
#[doc = "Linked service for MongoDB data source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbV2LinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "MongoDB linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: MongoDbV2LinkedServiceTypeProperties,
}
impl MongoDbV2LinkedService {
    pub fn new(linked_service: LinkedService, type_properties: MongoDbV2LinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "MongoDB linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbV2LinkedServiceTypeProperties {
    #[doc = "The MongoDB connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[doc = "The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string)."]
    pub database: serde_json::Value,
}
impl MongoDbV2LinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value, database: serde_json::Value) -> Self {
        Self {
            connection_string,
            database,
        }
    }
}
#[doc = "A copy activity source for a MongoDB database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MongoDbV2Source {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Specifies selection filter using query operators. To return all documents in a collection, omit this parameter or pass an empty document ({}). Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub filter: Option<serde_json::Value>,
    #[doc = "Cursor methods for Mongodb query"]
    #[serde(rename = "cursorMethods", default, skip_serializing_if = "Option::is_none")]
    pub cursor_methods: Option<MongoDbCursorMethodsProperties>,
    #[doc = "Specifies the number of documents to return in each batch of the response from MongoDB instance. In most cases, modifying the batch size will not affect the user or the application. This property's main purpose is to avoid hit the limitation of response size. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "batchSize", default, skip_serializing_if = "Option::is_none")]
    pub batch_size: Option<serde_json::Value>,
    #[doc = "Query timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<serde_json::Value>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl MongoDbV2Source {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            filter: None,
            cursor_methods: None,
            batch_size: None,
            query_timeout: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "Base class for all triggers that support one to many model for trigger to pipeline."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MultiplePipelineTrigger {
    #[serde(flatten)]
    pub trigger: Trigger,
    #[doc = "Pipelines that need to be started."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub pipelines: Vec<TriggerPipelineReference>,
}
impl MultiplePipelineTrigger {
    pub fn new(trigger: Trigger) -> Self {
        Self {
            trigger,
            pipelines: Vec::new(),
        }
    }
}
#[doc = "Linked service for MySQL data source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MySqlLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "MySQL linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: MySqlLinkedServiceTypeProperties,
}
impl MySqlLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: MySqlLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "MySQL linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MySqlLinkedServiceTypeProperties {
    #[doc = "The connection string."]
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl MySqlLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "A copy activity source for MySQL databases."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MySqlSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "Database query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl MySqlSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "The MySQL table dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MySqlTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "MySql table dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<MySqlTableDatasetTypeProperties>,
}
impl MySqlTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "MySql table dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MySqlTableDatasetTypeProperties {
    #[doc = "The MySQL table name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
}
impl MySqlTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Netezza linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetezzaLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Netezza linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: NetezzaLinkedServiceTypeProperties,
}
impl NetezzaLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: NetezzaLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Netezza linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetezzaLinkedServiceTypeProperties {
    #[doc = "An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pwd: Option<AzureKeyVaultSecretReference>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl NetezzaLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The partition mechanism that will be used for Netezza read in parallel."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum NetezzaPartitionOption {
    None,
    DataSlice,
    DynamicRange,
}
#[doc = "The settings that will be leveraged for Netezza source partitioning."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetezzaPartitionSettings {
    #[doc = "The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionColumnName", default, skip_serializing_if = "Option::is_none")]
    pub partition_column_name: Option<serde_json::Value>,
    #[doc = "The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionUpperBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_upper_bound: Option<serde_json::Value>,
    #[doc = "The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionLowerBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_lower_bound: Option<serde_json::Value>,
}
impl NetezzaPartitionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A copy activity Netezza source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetezzaSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "The partition mechanism that will be used for Netezza read in parallel."]
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<netezza_source::PartitionOption>,
    #[doc = "The settings that will be leveraged for Netezza source partitioning."]
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<NetezzaPartitionSettings>,
}
impl NetezzaSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
pub mod netezza_source {
    use super::*;
    #[doc = "The partition mechanism that will be used for Netezza read in parallel."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PartitionOption {
        None,
        DataSlice,
        DynamicRange,
    }
}
#[doc = "Netezza dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetezzaTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Netezza dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<NetezzaTableDatasetTypeProperties>,
}
impl NetezzaTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Netezza dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetezzaTableDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The table name of the Netezza. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[doc = "The schema name of the Netezza. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl NetezzaTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Notebook."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Notebook {
    #[doc = "The description of the notebook."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Big data pool reference."]
    #[serde(rename = "bigDataPool", default, skip_serializing_if = "Option::is_none")]
    pub big_data_pool: Option<BigDataPoolReference>,
    #[doc = "Session properties."]
    #[serde(rename = "sessionProperties", default, skip_serializing_if = "Option::is_none")]
    pub session_properties: Option<NotebookSessionProperties>,
    #[doc = "Notebook root-level metadata."]
    pub metadata: NotebookMetadata,
    #[doc = "Notebook format (major number). Incremented between backwards incompatible changes to the notebook format."]
    pub nbformat: i64,
    #[doc = "Notebook format (minor number). Incremented for backward compatible changes to the notebook format."]
    pub nbformat_minor: i64,
    #[doc = "Array of cells of the current notebook."]
    pub cells: Vec<NotebookCell>,
}
impl Notebook {
    pub fn new(metadata: NotebookMetadata, nbformat: i64, nbformat_minor: i64, cells: Vec<NotebookCell>) -> Self {
        Self {
            description: None,
            big_data_pool: None,
            session_properties: None,
            metadata,
            nbformat,
            nbformat_minor,
            cells,
        }
    }
}
#[doc = "Notebook cell."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NotebookCell {
    #[doc = "String identifying the type of cell."]
    pub cell_type: String,
    #[doc = "Cell-level metadata."]
    pub metadata: serde_json::Value,
    #[doc = "Contents of the cell, represented as an array of lines."]
    pub source: Vec<String>,
    #[doc = "Attachments associated with the cell."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub attachments: Option<serde_json::Value>,
    #[doc = "Cell-level output items."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub outputs: Vec<NotebookCellOutputItem>,
}
impl NotebookCell {
    pub fn new(cell_type: String, metadata: serde_json::Value, source: Vec<String>) -> Self {
        Self {
            cell_type,
            metadata,
            source,
            attachments: None,
            outputs: Vec::new(),
        }
    }
}
#[doc = "An item of the notebook cell execution output."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NotebookCellOutputItem {
    #[doc = "For output_type=stream, determines the name of stream (stdout / stderr)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Execution sequence number."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub execution_count: Option<i64>,
    #[doc = "Execution, display, or stream outputs."]
    pub output_type: notebook_cell_output_item::OutputType,
    #[doc = "For output_type=stream, the stream's text output, represented as a string or an array of strings."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub text: Option<serde_json::Value>,
    #[doc = "Output data. Use MIME type as key, and content as value."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<serde_json::Value>,
    #[doc = "Metadata for the output item."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
}
impl NotebookCellOutputItem {
    pub fn new(output_type: notebook_cell_output_item::OutputType) -> Self {
        Self {
            name: None,
            execution_count: None,
            output_type,
            text: None,
            data: None,
            metadata: None,
        }
    }
}
pub mod notebook_cell_output_item {
    use super::*;
    #[doc = "Execution, display, or stream outputs."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OutputType {
        #[serde(rename = "execute_result")]
        ExecuteResult,
        #[serde(rename = "display_data")]
        DisplayData,
        #[serde(rename = "stream")]
        Stream,
        #[serde(rename = "error")]
        Error,
    }
}
#[doc = "Kernel information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NotebookKernelSpec {
    #[doc = "Name of the kernel specification."]
    pub name: String,
    #[doc = "Name to display in UI."]
    pub display_name: String,
}
impl NotebookKernelSpec {
    pub fn new(name: String, display_name: String) -> Self {
        Self { name, display_name }
    }
}
#[doc = "Language info."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NotebookLanguageInfo {
    #[doc = "The programming language which this kernel runs."]
    pub name: String,
    #[doc = "The codemirror mode to use for code in this language."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub codemirror_mode: Option<String>,
}
impl NotebookLanguageInfo {
    pub fn new(name: String) -> Self {
        Self {
            name,
            codemirror_mode: None,
        }
    }
}
#[doc = "A list of Notebook resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NotebookListResponse {
    #[doc = "List of Notebooks."]
    pub value: Vec<NotebookResource>,
    #[doc = "The link to the next page of results, if any remaining results exist."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl NotebookListResponse {
    pub fn new(value: Vec<NotebookResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Notebook root-level metadata."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NotebookMetadata {
    #[doc = "Kernel information."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kernelspec: Option<NotebookKernelSpec>,
    #[doc = "Language info."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub language_info: Option<NotebookLanguageInfo>,
}
impl NotebookMetadata {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Notebook resource type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NotebookResource {
    #[doc = "Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the resource"]
    pub name: String,
    #[doc = "The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource Etag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "Notebook."]
    pub properties: Notebook,
}
impl NotebookResource {
    pub fn new(name: String, properties: Notebook) -> Self {
        Self {
            id: None,
            name,
            type_: None,
            etag: None,
            properties,
        }
    }
}
#[doc = "Session properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NotebookSessionProperties {
    #[doc = "Amount of memory to use for the driver process."]
    #[serde(rename = "driverMemory")]
    pub driver_memory: String,
    #[doc = "Number of cores to use for the driver."]
    #[serde(rename = "driverCores")]
    pub driver_cores: i64,
    #[doc = "Amount of memory to use per executor process."]
    #[serde(rename = "executorMemory")]
    pub executor_memory: String,
    #[doc = "Number of cores to use for each executor."]
    #[serde(rename = "executorCores")]
    pub executor_cores: i64,
    #[doc = "Number of executors to launch for this session."]
    #[serde(rename = "numExecutors")]
    pub num_executors: i64,
}
impl NotebookSessionProperties {
    pub fn new(driver_memory: String, driver_cores: i64, executor_memory: String, executor_cores: i64, num_executors: i64) -> Self {
        Self {
            driver_memory,
            driver_cores,
            executor_memory,
            executor_cores,
            num_executors,
        }
    }
}
#[doc = "Open Data Protocol (OData) linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ODataLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "OData linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: ODataLinkedServiceTypeProperties,
}
impl ODataLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: ODataLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "OData linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ODataLinkedServiceTypeProperties {
    #[doc = "The URL of the OData service endpoint. Type: string (or Expression with resultType string)."]
    pub url: serde_json::Value,
    #[doc = "Type of authentication used to connect to the OData service."]
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<o_data_linked_service_type_properties::AuthenticationType>,
    #[doc = "User name of the OData service. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "Specify the tenant information (domain name or tenant ID) under which your application resides. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[doc = "Specify the application id of your application registered in Azure Active Directory. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[doc = "Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[doc = "Specify the resource you are requesting authorization to use Directory. Type: string (or Expression with resultType string)."]
    #[serde(rename = "aadResourceId", default, skip_serializing_if = "Option::is_none")]
    pub aad_resource_id: Option<serde_json::Value>,
    #[doc = "Specify the credential type (key or cert) is used for service principal."]
    #[serde(rename = "aadServicePrincipalCredentialType", default, skip_serializing_if = "Option::is_none")]
    pub aad_service_principal_credential_type: Option<o_data_linked_service_type_properties::AadServicePrincipalCredentialType>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalEmbeddedCert", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_embedded_cert: Option<SecretBase>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalEmbeddedCertPassword", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_embedded_cert_password: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl ODataLinkedServiceTypeProperties {
    pub fn new(url: serde_json::Value) -> Self {
        Self {
            url,
            authentication_type: None,
            user_name: None,
            password: None,
            tenant: None,
            service_principal_id: None,
            azure_cloud_type: None,
            aad_resource_id: None,
            aad_service_principal_credential_type: None,
            service_principal_key: None,
            service_principal_embedded_cert: None,
            service_principal_embedded_cert_password: None,
            encrypted_credential: None,
        }
    }
}
pub mod o_data_linked_service_type_properties {
    use super::*;
    #[doc = "Type of authentication used to connect to the OData service."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        Anonymous,
        Windows,
        AadServicePrincipal,
        ManagedServiceIdentity,
    }
    #[doc = "Specify the credential type (key or cert) is used for service principal."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AadServicePrincipalCredentialType {
        ServicePrincipalKey,
        ServicePrincipalCert,
    }
}
#[doc = "The Open Data Protocol (OData) resource dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ODataResourceDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "OData dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<ODataResourceDatasetTypeProperties>,
}
impl ODataResourceDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "OData dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ODataResourceDatasetTypeProperties {
    #[doc = "The OData resource path. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<serde_json::Value>,
}
impl ODataResourceDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A copy activity source for OData source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ODataSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "OData query. For example, \"$top=1\". Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data. Default value: 00:05:00. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl ODataSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            http_request_timeout: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "Open Database Connectivity (ODBC) linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OdbcLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "ODBC linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: OdbcLinkedServiceTypeProperties,
}
impl OdbcLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: OdbcLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "ODBC linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OdbcLinkedServiceTypeProperties {
    #[doc = "The non-access credential portion of the connection string as well as an optional encrypted credential. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[doc = "Type of authentication used to connect to the ODBC data store. Possible values are: Anonymous and Basic. Type: string (or Expression with resultType string)."]
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<SecretBase>,
    #[doc = "User name for Basic authentication. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl OdbcLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            authentication_type: None,
            credential: None,
            user_name: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "A copy activity ODBC sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OdbcSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "A query to execute before starting the copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
}
impl OdbcSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
        }
    }
}
#[doc = "A copy activity source for ODBC databases."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OdbcSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "Database query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl OdbcSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "The ODBC table dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OdbcTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "ODBC table dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<OdbcTableDatasetTypeProperties>,
}
impl OdbcTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "ODBC table dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OdbcTableDatasetTypeProperties {
    #[doc = "The ODBC table name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
}
impl OdbcTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Office365 account."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Office365Dataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Office365 dataset properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: Office365DatasetTypeProperties,
}
impl Office365Dataset {
    pub fn new(dataset: Dataset, type_properties: Office365DatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "Office365 dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Office365DatasetTypeProperties {
    #[doc = "Name of the dataset to extract from Office 365. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableName")]
    pub table_name: serde_json::Value,
    #[doc = "A predicate expression that can be used to filter the specific rows to extract from Office 365. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub predicate: Option<serde_json::Value>,
}
impl Office365DatasetTypeProperties {
    pub fn new(table_name: serde_json::Value) -> Self {
        Self {
            table_name,
            predicate: None,
        }
    }
}
#[doc = "Office365 linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Office365LinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Office365 linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: Office365LinkedServiceTypeProperties,
}
impl Office365LinkedService {
    pub fn new(linked_service: LinkedService, type_properties: Office365LinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Office365 linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Office365LinkedServiceTypeProperties {
    #[doc = "Azure tenant ID to which the Office 365 account belongs. Type: string (or Expression with resultType string)."]
    #[serde(rename = "office365TenantId")]
    pub office365_tenant_id: serde_json::Value,
    #[doc = "Specify the tenant information under which your Azure AD web application resides. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalTenantId")]
    pub service_principal_tenant_id: serde_json::Value,
    #[doc = "Specify the application's client ID. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId")]
    pub service_principal_id: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalKey")]
    pub service_principal_key: SecretBase,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl Office365LinkedServiceTypeProperties {
    pub fn new(
        office365_tenant_id: serde_json::Value,
        service_principal_tenant_id: serde_json::Value,
        service_principal_id: serde_json::Value,
        service_principal_key: SecretBase,
    ) -> Self {
        Self {
            office365_tenant_id,
            service_principal_tenant_id,
            service_principal_id,
            service_principal_key,
            encrypted_credential: None,
        }
    }
}
#[doc = "A copy activity source for an Office 365 service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Office365Source {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "The groups containing all the users. Type: array of strings (or Expression with resultType array of strings)."]
    #[serde(rename = "allowedGroups", default, skip_serializing_if = "Option::is_none")]
    pub allowed_groups: Option<serde_json::Value>,
    #[doc = "The user scope uri. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userScopeFilterUri", default, skip_serializing_if = "Option::is_none")]
    pub user_scope_filter_uri: Option<serde_json::Value>,
    #[doc = "The Column to apply the <paramref name=\"StartTime\"/> and <paramref name=\"EndTime\"/>. Type: string (or Expression with resultType string)."]
    #[serde(rename = "dateFilterColumn", default, skip_serializing_if = "Option::is_none")]
    pub date_filter_column: Option<serde_json::Value>,
    #[doc = "Start time of the requested range for this dataset. Type: string (or Expression with resultType string)."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<serde_json::Value>,
    #[doc = "End time of the requested range for this dataset. Type: string (or Expression with resultType string)."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<serde_json::Value>,
    #[doc = "The columns to be read out from the Office 365 table. Type: array of objects (or Expression with resultType array of objects). Example: [ { \"name\": \"Id\" }, { \"name\": \"CreatedDateTime\" } ]"]
    #[serde(rename = "outputColumns", default, skip_serializing_if = "Option::is_none")]
    pub output_columns: Option<serde_json::Value>,
}
impl Office365Source {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            allowed_groups: None,
            user_scope_filter_uri: None,
            date_filter_column: None,
            start_time: None,
            end_time: None,
            output_columns: None,
        }
    }
}
#[doc = "Operation status for the operation"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationResult {
    #[doc = "Operation status"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "The object that defines the structure of an Azure Synapse error."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<CloudErrorBody>,
}
impl OperationResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Oracle database."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Oracle database linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: OracleLinkedServiceTypeProperties,
}
impl OracleLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: OracleLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Oracle database linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleLinkedServiceTypeProperties {
    #[doc = "The connection string. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl OracleLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "The partition mechanism that will be used for Oracle read in parallel."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum OraclePartitionOption {
    None,
    PhysicalPartitionsOfTable,
    DynamicRange,
}
#[doc = "The settings that will be leveraged for Oracle source partitioning."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OraclePartitionSettings {
    #[doc = "Names of the physical partitions of Oracle table. "]
    #[serde(rename = "partitionNames", default, skip_serializing_if = "Option::is_none")]
    pub partition_names: Option<serde_json::Value>,
    #[doc = "The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionColumnName", default, skip_serializing_if = "Option::is_none")]
    pub partition_column_name: Option<serde_json::Value>,
    #[doc = "The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionUpperBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_upper_bound: Option<serde_json::Value>,
    #[doc = "The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionLowerBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_lower_bound: Option<serde_json::Value>,
}
impl OraclePartitionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Oracle Service Cloud linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleServiceCloudLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Oracle Service Cloud linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: OracleServiceCloudLinkedServiceTypeProperties,
}
impl OracleServiceCloudLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: OracleServiceCloudLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Oracle Service Cloud linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleServiceCloudLinkedServiceTypeProperties {
    #[doc = "The URL of the Oracle Service Cloud instance."]
    pub host: serde_json::Value,
    #[doc = "The user name that you use to access Oracle Service Cloud server."]
    pub username: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    pub password: SecretBase,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[doc = "Specifies whether to verify the identity of the server when connecting over SSL. The default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl OracleServiceCloudLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value, username: serde_json::Value, password: SecretBase) -> Self {
        Self {
            host,
            username,
            password,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Oracle Service Cloud dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleServiceCloudObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl OracleServiceCloudObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Oracle Service Cloud source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleServiceCloudSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl OracleServiceCloudSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "A copy activity Oracle sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "SQL pre-copy script. Type: string (or Expression with resultType string)."]
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
}
impl OracleSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
        }
    }
}
#[doc = "A copy activity Oracle source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Oracle reader query. Type: string (or Expression with resultType string)."]
    #[serde(rename = "oracleReaderQuery", default, skip_serializing_if = "Option::is_none")]
    pub oracle_reader_query: Option<serde_json::Value>,
    #[doc = "Query timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<serde_json::Value>,
    #[doc = "The partition mechanism that will be used for Oracle read in parallel."]
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<oracle_source::PartitionOption>,
    #[doc = "The settings that will be leveraged for Oracle source partitioning."]
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<OraclePartitionSettings>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl OracleSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            oracle_reader_query: None,
            query_timeout: None,
            partition_option: None,
            partition_settings: None,
            additional_columns: Vec::new(),
        }
    }
}
pub mod oracle_source {
    use super::*;
    #[doc = "The partition mechanism that will be used for Oracle read in parallel."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PartitionOption {
        None,
        PhysicalPartitionsOfTable,
        DynamicRange,
    }
}
#[doc = "The on-premises Oracle database dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "On-premises Oracle dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<OracleTableDatasetTypeProperties>,
}
impl OracleTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "On-premises Oracle dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OracleTableDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The schema name of the on-premises Oracle database. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[doc = "The table name of the on-premises Oracle database. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl OracleTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "ORC dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OrcDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "ORC dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<OrcDatasetTypeProperties>,
}
impl OrcDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "ORC dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OrcDatasetTypeProperties {
    #[doc = "Dataset location."]
    pub location: DatasetLocation,
    #[serde(rename = "orcCompressionCodec", default, skip_serializing_if = "Option::is_none")]
    pub orc_compression_codec: Option<orc_dataset_type_properties::OrcCompressionCodec>,
}
impl OrcDatasetTypeProperties {
    pub fn new(location: DatasetLocation) -> Self {
        Self {
            location,
            orc_compression_codec: None,
        }
    }
}
pub mod orc_dataset_type_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OrcCompressionCodec {
        #[serde(rename = "none")]
        None,
        #[serde(rename = "zlib")]
        Zlib,
        #[serde(rename = "snappy")]
        Snappy,
        #[serde(rename = "lzo")]
        Lzo,
    }
}
#[doc = "The data stored in Optimized Row Columnar (ORC) format."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OrcFormat {
    #[serde(flatten)]
    pub dataset_storage_format: DatasetStorageFormat,
}
impl OrcFormat {
    pub fn new(dataset_storage_format: DatasetStorageFormat) -> Self {
        Self { dataset_storage_format }
    }
}
#[doc = "A copy activity ORC sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OrcSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "Connector write settings."]
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreWriteSettings>,
    #[doc = "Orc write settings."]
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<OrcWriteSettings>,
}
impl OrcSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            store_settings: None,
            format_settings: None,
        }
    }
}
#[doc = "A copy activity ORC source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OrcSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Connector read setting."]
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl OrcSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            store_settings: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "Orc write settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OrcWriteSettings {
    #[serde(flatten)]
    pub format_write_settings: FormatWriteSettings,
    #[doc = "Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "maxRowsPerFile", default, skip_serializing_if = "Option::is_none")]
    pub max_rows_per_file: Option<serde_json::Value>,
    #[doc = "Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileNamePrefix", default, skip_serializing_if = "Option::is_none")]
    pub file_name_prefix: Option<serde_json::Value>,
}
impl OrcWriteSettings {
    pub fn new(format_write_settings: FormatWriteSettings) -> Self {
        Self {
            format_write_settings,
            max_rows_per_file: None,
            file_name_prefix: None,
        }
    }
}
#[doc = "Definition of all parameters for an entity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ParameterDefinitionSpecification {}
impl ParameterDefinitionSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Definition of a single parameter for an entity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ParameterSpecification {
    #[doc = "Parameter type."]
    #[serde(rename = "type")]
    pub type_: parameter_specification::Type,
    #[doc = "Default value of parameter."]
    #[serde(rename = "defaultValue", default, skip_serializing_if = "Option::is_none")]
    pub default_value: Option<serde_json::Value>,
}
impl ParameterSpecification {
    pub fn new(type_: parameter_specification::Type) -> Self {
        Self {
            type_,
            default_value: None,
        }
    }
}
pub mod parameter_specification {
    use super::*;
    #[doc = "Parameter type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Object,
        String,
        Int,
        Float,
        Bool,
        Array,
        SecureString,
    }
}
#[doc = "An object mapping parameter names to argument values."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ParameterValueSpecification {}
impl ParameterValueSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ParquetCompressionCodecEnum {
    #[serde(rename = "none")]
    None,
    #[serde(rename = "gzip")]
    Gzip,
    #[serde(rename = "snappy")]
    Snappy,
    #[serde(rename = "lzo")]
    Lzo,
}
#[doc = "Parquet dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ParquetDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Parquet dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<ParquetDatasetTypeProperties>,
}
impl ParquetDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Parquet dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ParquetDatasetTypeProperties {
    #[doc = "Dataset location."]
    pub location: DatasetLocation,
    #[doc = "A string from ParquetCompressionCodecEnum or an expression"]
    #[serde(rename = "compressionCodec", default, skip_serializing_if = "Option::is_none")]
    pub compression_codec: Option<serde_json::Value>,
}
impl ParquetDatasetTypeProperties {
    pub fn new(location: DatasetLocation) -> Self {
        Self {
            location,
            compression_codec: None,
        }
    }
}
#[doc = "The data stored in Parquet format."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ParquetFormat {
    #[serde(flatten)]
    pub dataset_storage_format: DatasetStorageFormat,
}
impl ParquetFormat {
    pub fn new(dataset_storage_format: DatasetStorageFormat) -> Self {
        Self { dataset_storage_format }
    }
}
#[doc = "A copy activity Parquet sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ParquetSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "Connector write settings."]
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreWriteSettings>,
    #[doc = "Parquet write settings."]
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<ParquetWriteSettings>,
}
impl ParquetSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            store_settings: None,
            format_settings: None,
        }
    }
}
#[doc = "A copy activity Parquet source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ParquetSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Connector read setting."]
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl ParquetSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            store_settings: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "Parquet write settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ParquetWriteSettings {
    #[serde(flatten)]
    pub format_write_settings: FormatWriteSettings,
    #[doc = "Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "maxRowsPerFile", default, skip_serializing_if = "Option::is_none")]
    pub max_rows_per_file: Option<serde_json::Value>,
    #[doc = "Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileNamePrefix", default, skip_serializing_if = "Option::is_none")]
    pub file_name_prefix: Option<serde_json::Value>,
}
impl ParquetWriteSettings {
    pub fn new(format_write_settings: FormatWriteSettings) -> Self {
        Self {
            format_write_settings,
            max_rows_per_file: None,
            file_name_prefix: None,
        }
    }
}
#[doc = "Paypal Service linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PaypalLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Paypal Service linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: PaypalLinkedServiceTypeProperties,
}
impl PaypalLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: PaypalLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Paypal Service linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PaypalLinkedServiceTypeProperties {
    #[doc = "The URL\u{a0}of the PayPal instance. (i.e. api.sandbox.paypal.com)"]
    pub host: serde_json::Value,
    #[doc = "The client ID associated with your PayPal application."]
    #[serde(rename = "clientId")]
    pub client_id: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[doc = "Specifies whether to verify the identity of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl PaypalLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value, client_id: serde_json::Value) -> Self {
        Self {
            host,
            client_id,
            client_secret: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Paypal Service dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PaypalObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl PaypalObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Paypal Service source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PaypalSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl PaypalSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Phoenix Dataset Properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PhoenixDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The table name of the Phoenix. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[doc = "The schema name of the Phoenix. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl PhoenixDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Phoenix server linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PhoenixLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Phoenix server linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: PhoenixLinkedServiceTypeProperties,
}
impl PhoenixLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: PhoenixLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Phoenix server linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PhoenixLinkedServiceTypeProperties {
    #[doc = "The IP address or host name of the Phoenix server. (i.e. 192.168.222.160)"]
    pub host: serde_json::Value,
    #[doc = "The TCP port that the Phoenix server uses to listen for client connections. The default value is 8765."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[doc = "The partial URL corresponding to the Phoenix server. (i.e. /gateway/sandbox/phoenix/version). The default value is hbasephoenix if using WindowsAzureHDInsightService."]
    #[serde(rename = "httpPath", default, skip_serializing_if = "Option::is_none")]
    pub http_path: Option<serde_json::Value>,
    #[doc = "The authentication mechanism used to connect to the Phoenix server."]
    #[serde(rename = "authenticationType")]
    pub authentication_type: phoenix_linked_service_type_properties::AuthenticationType,
    #[doc = "The user name used to connect to the Phoenix server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "Specifies whether the connections to the server are encrypted using SSL. The default value is false."]
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<serde_json::Value>,
    #[doc = "The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR."]
    #[serde(rename = "trustedCertPath", default, skip_serializing_if = "Option::is_none")]
    pub trusted_cert_path: Option<serde_json::Value>,
    #[doc = "Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false."]
    #[serde(rename = "useSystemTrustStore", default, skip_serializing_if = "Option::is_none")]
    pub use_system_trust_store: Option<serde_json::Value>,
    #[doc = "Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false."]
    #[serde(rename = "allowHostNameCNMismatch", default, skip_serializing_if = "Option::is_none")]
    pub allow_host_name_cn_mismatch: Option<serde_json::Value>,
    #[doc = "Specifies whether to allow self-signed certificates from the server. The default value is false."]
    #[serde(rename = "allowSelfSignedServerCert", default, skip_serializing_if = "Option::is_none")]
    pub allow_self_signed_server_cert: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl PhoenixLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value, authentication_type: phoenix_linked_service_type_properties::AuthenticationType) -> Self {
        Self {
            host,
            port: None,
            http_path: None,
            authentication_type,
            username: None,
            password: None,
            enable_ssl: None,
            trusted_cert_path: None,
            use_system_trust_store: None,
            allow_host_name_cn_mismatch: None,
            allow_self_signed_server_cert: None,
            encrypted_credential: None,
        }
    }
}
pub mod phoenix_linked_service_type_properties {
    use super::*;
    #[doc = "The authentication mechanism used to connect to the Phoenix server."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Anonymous,
        UsernameAndPassword,
        #[serde(rename = "WindowsAzureHDInsightService")]
        WindowsAzureHdInsightService,
    }
}
#[doc = "Phoenix server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PhoenixObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Phoenix Dataset Properties"]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<PhoenixDatasetTypeProperties>,
}
impl PhoenixObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Phoenix server source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PhoenixSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl PhoenixSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "A workspace pipeline."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Pipeline {
    #[doc = "The description of the pipeline."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "List of activities in pipeline."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub activities: Vec<Activity>,
    #[doc = "Definition of all parameters for an entity."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterDefinitionSpecification>,
    #[doc = "Definition of variable for a Pipeline."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub variables: Option<VariableDefinitionSpecification>,
    #[doc = "The max number of concurrent runs for the pipeline."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub concurrency: Option<i64>,
    #[doc = "List of tags that can be used for describing the Pipeline."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub annotations: Vec<serde_json::Value>,
    #[doc = "Dimensions emitted by Pipeline."]
    #[serde(rename = "runDimensions", default, skip_serializing_if = "Option::is_none")]
    pub run_dimensions: Option<serde_json::Value>,
    #[doc = "The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub folder: Option<pipeline::Folder>,
}
impl Pipeline {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod pipeline {
    use super::*;
    #[doc = "The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Folder {
        #[doc = "The name of the folder that this Pipeline is in."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
    }
    impl Folder {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "A list of pipeline resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PipelineListResponse {
    #[doc = "List of pipelines."]
    pub value: Vec<PipelineResource>,
    #[doc = "The link to the next page of results, if any remaining results exist."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl PipelineListResponse {
    pub fn new(value: Vec<PipelineResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Pipeline reference type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PipelineReference {
    #[doc = "Pipeline reference type."]
    #[serde(rename = "type")]
    pub type_: pipeline_reference::Type,
    #[doc = "Reference pipeline name."]
    #[serde(rename = "referenceName")]
    pub reference_name: String,
    #[doc = "Reference name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl PipelineReference {
    pub fn new(type_: pipeline_reference::Type, reference_name: String) -> Self {
        Self {
            type_,
            reference_name,
            name: None,
        }
    }
}
pub mod pipeline_reference {
    use super::*;
    #[doc = "Pipeline reference type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        PipelineReference,
    }
}
#[doc = "Pipeline resource type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PipelineResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "A workspace pipeline."]
    pub properties: Pipeline,
}
impl PipelineResource {
    pub fn new(properties: Pipeline) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[doc = "Information about a pipeline run."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PipelineRun {
    #[doc = "Identifier of a run."]
    #[serde(rename = "runId", default, skip_serializing_if = "Option::is_none")]
    pub run_id: Option<String>,
    #[doc = "Identifier that correlates all the recovery runs of a pipeline run."]
    #[serde(rename = "runGroupId", default, skip_serializing_if = "Option::is_none")]
    pub run_group_id: Option<String>,
    #[doc = "Indicates if the recovered pipeline run is the latest in its group."]
    #[serde(rename = "isLatest", default, skip_serializing_if = "Option::is_none")]
    pub is_latest: Option<bool>,
    #[doc = "The pipeline name."]
    #[serde(rename = "pipelineName", default, skip_serializing_if = "Option::is_none")]
    pub pipeline_name: Option<String>,
    #[doc = "The full or partial list of parameter name, value pair used in the pipeline run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<serde_json::Value>,
    #[doc = "Provides entity name and id that started the pipeline run."]
    #[serde(rename = "invokedBy", default, skip_serializing_if = "Option::is_none")]
    pub invoked_by: Option<PipelineRunInvokedBy>,
    #[doc = "The last updated timestamp for the pipeline run event in ISO8601 format."]
    #[serde(rename = "lastUpdated", default, skip_serializing_if = "Option::is_none")]
    pub last_updated: Option<String>,
    #[doc = "The start time of a pipeline run in ISO8601 format."]
    #[serde(rename = "runStart", default, skip_serializing_if = "Option::is_none")]
    pub run_start: Option<String>,
    #[doc = "The end time of a pipeline run in ISO8601 format."]
    #[serde(rename = "runEnd", default, skip_serializing_if = "Option::is_none")]
    pub run_end: Option<String>,
    #[doc = "The duration of a pipeline run."]
    #[serde(rename = "durationInMs", default, skip_serializing_if = "Option::is_none")]
    pub duration_in_ms: Option<i64>,
    #[doc = "The status of a pipeline run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "The message from a pipeline run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl PipelineRun {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Provides entity name and id that started the pipeline run."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PipelineRunInvokedBy {
    #[doc = "Name of the entity that started the pipeline run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The ID of the entity that started the run."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The type of the entity that started the run."]
    #[serde(rename = "invokedByType", default, skip_serializing_if = "Option::is_none")]
    pub invoked_by_type: Option<String>,
}
impl PipelineRunInvokedBy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list pipeline runs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PipelineRunsQueryResponse {
    #[doc = "List of pipeline runs."]
    pub value: Vec<PipelineRun>,
    #[doc = "The continuation token for getting the next page of results, if any remaining results exist, null otherwise."]
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl PipelineRunsQueryResponse {
    pub fn new(value: Vec<PipelineRun>) -> Self {
        Self {
            value,
            continuation_token: None,
        }
    }
}
#[doc = "PolyBase settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolybaseSettings {
    #[doc = "Indicates whether the RejectValue property is specified as a literal value or a percentage."]
    #[serde(rename = "rejectType", default, skip_serializing_if = "Option::is_none")]
    pub reject_type: Option<PolybaseSettingsRejectType>,
    #[doc = "Specifies the value or the percentage of rows that can be rejected before the query fails. Type: number (or Expression with resultType number), minimum: 0."]
    #[serde(rename = "rejectValue", default, skip_serializing_if = "Option::is_none")]
    pub reject_value: Option<serde_json::Value>,
    #[doc = "Determines the number of rows to attempt to retrieve before the PolyBase recalculates the percentage of rejected rows. Type: integer (or Expression with resultType integer), minimum: 0."]
    #[serde(rename = "rejectSampleValue", default, skip_serializing_if = "Option::is_none")]
    pub reject_sample_value: Option<serde_json::Value>,
    #[doc = "Specifies how to handle missing values in delimited text files when PolyBase retrieves data from the text file. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "useTypeDefault", default, skip_serializing_if = "Option::is_none")]
    pub use_type_default: Option<serde_json::Value>,
}
impl PolybaseSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Indicates whether the RejectValue property is specified as a literal value or a percentage."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum PolybaseSettingsRejectType {
    #[serde(rename = "value")]
    Value,
    #[serde(rename = "percentage")]
    Percentage,
}
#[doc = "Linked service for PostgreSQL data source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PostgreSqlLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "PostgreSQL linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: PostgreSqlLinkedServiceTypeProperties,
}
impl PostgreSqlLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: PostgreSqlLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "PostgreSQL linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PostgreSqlLinkedServiceTypeProperties {
    #[doc = "The connection string."]
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl PostgreSqlLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "A copy activity source for PostgreSQL databases."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PostgreSqlSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "Database query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl PostgreSqlSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "The PostgreSQL table dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PostgreSqlTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "PostgreSQL table dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<PostgreSqlTableDatasetTypeProperties>,
}
impl PostgreSqlTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "PostgreSQL table dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PostgreSqlTableDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The PostgreSQL table name. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[doc = "The PostgreSQL schema name. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl PostgreSqlTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Presto Dataset Properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrestoDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The table name of the Presto. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[doc = "The schema name of the Presto. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl PrestoDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Presto server linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrestoLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Presto server linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: PrestoLinkedServiceTypeProperties,
}
impl PrestoLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: PrestoLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Presto server linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrestoLinkedServiceTypeProperties {
    #[doc = "The IP address or host name of the Presto server. (i.e. 192.168.222.160)"]
    pub host: serde_json::Value,
    #[doc = "The version of the Presto server. (i.e. 0.148-t)"]
    #[serde(rename = "serverVersion")]
    pub server_version: serde_json::Value,
    #[doc = "The catalog context for all request against the server."]
    pub catalog: serde_json::Value,
    #[doc = "The TCP port that the Presto server uses to listen for client connections. The default value is 8080."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[doc = "The authentication mechanism used to connect to the Presto server."]
    #[serde(rename = "authenticationType")]
    pub authentication_type: presto_linked_service_type_properties::AuthenticationType,
    #[doc = "The user name used to connect to the Presto server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "Specifies whether the connections to the server are encrypted using SSL. The default value is false."]
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<serde_json::Value>,
    #[doc = "The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR."]
    #[serde(rename = "trustedCertPath", default, skip_serializing_if = "Option::is_none")]
    pub trusted_cert_path: Option<serde_json::Value>,
    #[doc = "Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false."]
    #[serde(rename = "useSystemTrustStore", default, skip_serializing_if = "Option::is_none")]
    pub use_system_trust_store: Option<serde_json::Value>,
    #[doc = "Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false."]
    #[serde(rename = "allowHostNameCNMismatch", default, skip_serializing_if = "Option::is_none")]
    pub allow_host_name_cn_mismatch: Option<serde_json::Value>,
    #[doc = "Specifies whether to allow self-signed certificates from the server. The default value is false."]
    #[serde(rename = "allowSelfSignedServerCert", default, skip_serializing_if = "Option::is_none")]
    pub allow_self_signed_server_cert: Option<serde_json::Value>,
    #[doc = "The local time zone used by the connection. Valid values for this option are specified in the IANA Time Zone Database. The default value is the system time zone."]
    #[serde(rename = "timeZoneID", default, skip_serializing_if = "Option::is_none")]
    pub time_zone_id: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl PrestoLinkedServiceTypeProperties {
    pub fn new(
        host: serde_json::Value,
        server_version: serde_json::Value,
        catalog: serde_json::Value,
        authentication_type: presto_linked_service_type_properties::AuthenticationType,
    ) -> Self {
        Self {
            host,
            server_version,
            catalog,
            port: None,
            authentication_type,
            username: None,
            password: None,
            enable_ssl: None,
            trusted_cert_path: None,
            use_system_trust_store: None,
            allow_host_name_cn_mismatch: None,
            allow_self_signed_server_cert: None,
            time_zone_id: None,
            encrypted_credential: None,
        }
    }
}
pub mod presto_linked_service_type_properties {
    use super::*;
    #[doc = "The authentication mechanism used to connect to the Presto server."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Anonymous,
        #[serde(rename = "LDAP")]
        Ldap,
    }
}
#[doc = "Presto server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrestoObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Presto Dataset Properties"]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<PrestoDatasetTypeProperties>,
}
impl PrestoObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Presto server source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PrestoSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl PrestoSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Private endpoint details"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpoint {
    #[doc = "Resource id of the private endpoint."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
}
impl PrivateEndpoint {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A private endpoint connection"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnection {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[doc = "Properties of a private endpoint connection."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<PrivateEndpointConnectionProperties>,
}
impl PrivateEndpointConnection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Properties of a private endpoint connection."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateEndpointConnectionProperties {
    #[doc = "Private endpoint details"]
    #[serde(rename = "privateEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub private_endpoint: Option<PrivateEndpoint>,
    #[doc = "Connection state details of the private endpoint"]
    #[serde(rename = "privateLinkServiceConnectionState", default, skip_serializing_if = "Option::is_none")]
    pub private_link_service_connection_state: Option<PrivateLinkServiceConnectionState>,
    #[doc = "Provisioning state of the private endpoint connection."]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
}
impl PrivateEndpointConnectionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Connection state details of the private endpoint"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PrivateLinkServiceConnectionState {
    #[doc = "The private link service connection status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "The private link service connection description."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The actions required for private link service connection."]
    #[serde(rename = "actionsRequired", default, skip_serializing_if = "Option::is_none")]
    pub actions_required: Option<String>,
}
impl PrivateLinkServiceConnectionState {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[serde(flatten)]
    pub resource: Resource,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Purview Configuration"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PurviewConfiguration {
    #[doc = "Purview Resource ID"]
    #[serde(rename = "purviewResourceId", default, skip_serializing_if = "Option::is_none")]
    pub purview_resource_id: Option<String>,
}
impl PurviewConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of active debug sessions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QueryDataFlowDebugSessionsResponse {
    #[doc = "Array with all active debug sessions."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DataFlowDebugSessionInfo>,
    #[doc = "The link to the next page of results, if any remaining results exist."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl QueryDataFlowDebugSessionsResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "QuickBooks server linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QuickBooksLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "QuickBooks server linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: QuickBooksLinkedServiceTypeProperties,
}
impl QuickBooksLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: QuickBooksLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "QuickBooks server linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QuickBooksLinkedServiceTypeProperties {
    #[doc = "Properties used to connect to QuickBooks. It is mutually exclusive with any other properties in the linked service. Type: object."]
    #[serde(rename = "connectionProperties", default, skip_serializing_if = "Option::is_none")]
    pub connection_properties: Option<serde_json::Value>,
    #[doc = "The endpoint of the QuickBooks server. (i.e. quickbooks.api.intuit.com)"]
    pub endpoint: serde_json::Value,
    #[doc = "The company ID of the QuickBooks company to authorize."]
    #[serde(rename = "companyId")]
    pub company_id: serde_json::Value,
    #[doc = "The consumer key for OAuth 1.0 authentication."]
    #[serde(rename = "consumerKey")]
    pub consumer_key: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "consumerSecret")]
    pub consumer_secret: SecretBase,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "accessToken")]
    pub access_token: SecretBase,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "accessTokenSecret")]
    pub access_token_secret: SecretBase,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl QuickBooksLinkedServiceTypeProperties {
    pub fn new(
        endpoint: serde_json::Value,
        company_id: serde_json::Value,
        consumer_key: serde_json::Value,
        consumer_secret: SecretBase,
        access_token: SecretBase,
        access_token_secret: SecretBase,
    ) -> Self {
        Self {
            connection_properties: None,
            endpoint,
            company_id,
            consumer_key,
            consumer_secret,
            access_token,
            access_token_secret,
            use_encrypted_endpoints: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "QuickBooks server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QuickBooksObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl QuickBooksObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity QuickBooks server source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QuickBooksSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl QuickBooksSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Enumerates possible frequency option for the schedule trigger."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum RecurrenceFrequency {
    NotSpecified,
    Minute,
    Hour,
    Day,
    Week,
    Month,
    Year,
}
#[doc = "The recurrence schedule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecurrenceSchedule {
    #[doc = "The minutes."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub minutes: Vec<i32>,
    #[doc = "The hours."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hours: Vec<i32>,
    #[doc = "The days of the week."]
    #[serde(rename = "weekDays", default, skip_serializing_if = "Vec::is_empty")]
    pub week_days: Vec<String>,
    #[doc = "The month days."]
    #[serde(rename = "monthDays", default, skip_serializing_if = "Vec::is_empty")]
    pub month_days: Vec<i32>,
    #[doc = "The monthly occurrences."]
    #[serde(rename = "monthlyOccurrences", default, skip_serializing_if = "Vec::is_empty")]
    pub monthly_occurrences: Vec<RecurrenceScheduleOccurrence>,
}
impl RecurrenceSchedule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The recurrence schedule occurrence."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecurrenceScheduleOccurrence {
    #[doc = "The days of the week."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub day: Option<DayOfWeek>,
    #[doc = "The occurrence."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub occurrence: Option<i32>,
}
impl RecurrenceScheduleOccurrence {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Redirect incompatible row settings"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RedirectIncompatibleRowSettings {
    #[doc = "Name of the Azure Storage, Storage SAS, or Azure Data Lake Store linked service used for redirecting incompatible row. Must be specified if redirectIncompatibleRowSettings is specified. Type: string (or Expression with resultType string)."]
    #[serde(rename = "linkedServiceName")]
    pub linked_service_name: serde_json::Value,
    #[doc = "The path for storing the redirect incompatible row data. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<serde_json::Value>,
}
impl RedirectIncompatibleRowSettings {
    pub fn new(linked_service_name: serde_json::Value) -> Self {
        Self {
            linked_service_name,
            path: None,
        }
    }
}
#[doc = "The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RedshiftUnloadSettings {
    #[doc = "Linked service reference type."]
    #[serde(rename = "s3LinkedServiceName")]
    pub s3_linked_service_name: LinkedServiceReference,
    #[doc = "The bucket of the interim Amazon S3 which will be used to store the unloaded data from Amazon Redshift source. The bucket must be in the same region as the Amazon Redshift source. Type: string (or Expression with resultType string)."]
    #[serde(rename = "bucketName")]
    pub bucket_name: serde_json::Value,
}
impl RedshiftUnloadSettings {
    pub fn new(s3_linked_service_name: LinkedServiceReference, bucket_name: serde_json::Value) -> Self {
        Self {
            s3_linked_service_name,
            bucket_name,
        }
    }
}
#[doc = "A copy activity source for various relational databases."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RelationalSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Database query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl RelationalSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "The relational table dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RelationalTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Relational table dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<RelationalTableDatasetTypeProperties>,
}
impl RelationalTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Relational table dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RelationalTableDatasetTypeProperties {
    #[doc = "The relational table name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
}
impl RelationalTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A list of rerun triggers."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RerunTriggerListResponse {
    #[doc = "List of rerun triggers."]
    pub value: Vec<RerunTriggerResource>,
    #[doc = "The continuation token for getting the next page of results, if any remaining results exist, null otherwise."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl RerunTriggerListResponse {
    pub fn new(value: Vec<RerunTriggerResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "RerunTrigger resource type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RerunTriggerResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Trigger that schedules pipeline reruns for all fixed time interval windows from a requested start time to requested end time."]
    pub properties: RerunTumblingWindowTrigger,
}
impl RerunTriggerResource {
    pub fn new(properties: RerunTumblingWindowTrigger) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[doc = "Trigger that schedules pipeline reruns for all fixed time interval windows from a requested start time to requested end time."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RerunTumblingWindowTrigger {
    #[serde(flatten)]
    pub trigger: Trigger,
    #[doc = "Rerun Trigger properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: rerun_tumbling_window_trigger::TypeProperties,
}
impl RerunTumblingWindowTrigger {
    pub fn new(trigger: Trigger, type_properties: rerun_tumbling_window_trigger::TypeProperties) -> Self {
        Self { trigger, type_properties }
    }
}
pub mod rerun_tumbling_window_trigger {
    use super::*;
    #[doc = "Rerun Trigger properties."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct TypeProperties {
        #[doc = "The parent trigger reference."]
        #[serde(rename = "parentTrigger")]
        pub parent_trigger: serde_json::Value,
        #[doc = "The start time for the time period for which restatement is initiated. Only UTC time is currently supported."]
        #[serde(rename = "requestedStartTime")]
        pub requested_start_time: String,
        #[doc = "The end time for the time period for which restatement is initiated. Only UTC time is currently supported."]
        #[serde(rename = "requestedEndTime")]
        pub requested_end_time: String,
        #[doc = "The max number of parallel time windows (ready for execution) for which a rerun is triggered."]
        #[serde(rename = "rerunConcurrency")]
        pub rerun_concurrency: i64,
    }
    impl TypeProperties {
        pub fn new(
            parent_trigger: serde_json::Value,
            requested_start_time: String,
            requested_end_time: String,
            rerun_concurrency: i64,
        ) -> Self {
            Self {
                parent_trigger,
                requested_start_time,
                requested_end_time,
                rerun_concurrency,
            }
        }
    }
}
#[doc = "Rerun tumbling window trigger Parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RerunTumblingWindowTriggerActionParameters {
    #[doc = "The start time for the time period for which restatement is initiated. Only UTC time is currently supported."]
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[doc = "The end time for the time period for which restatement is initiated. Only UTC time is currently supported."]
    #[serde(rename = "endTime")]
    pub end_time: String,
    #[doc = "The max number of parallel time windows (ready for execution) for which a rerun is triggered."]
    #[serde(rename = "maxConcurrency")]
    pub max_concurrency: i64,
}
impl RerunTumblingWindowTriggerActionParameters {
    pub fn new(start_time: String, end_time: String, max_concurrency: i64) -> Self {
        Self {
            start_time,
            end_time,
            max_concurrency,
        }
    }
}
#[doc = "Common fields that are returned in the response for all Azure Resource Manager resources"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Resource {
    #[doc = "Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the resource"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or \"Microsoft.Storage/storageAccounts\""]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Resource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Responsys linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResponsysLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Responsys linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: ResponsysLinkedServiceTypeProperties,
}
impl ResponsysLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: ResponsysLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Responsys linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResponsysLinkedServiceTypeProperties {
    #[doc = "The endpoint of the Responsys server."]
    pub endpoint: serde_json::Value,
    #[doc = "The client ID associated with the Responsys application. Type: string (or Expression with resultType string)."]
    #[serde(rename = "clientId")]
    pub client_id: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[doc = "Specifies whether to verify the identity of the server when connecting over SSL. The default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl ResponsysLinkedServiceTypeProperties {
    pub fn new(endpoint: serde_json::Value, client_id: serde_json::Value) -> Self {
        Self {
            endpoint,
            client_id,
            client_secret: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Responsys dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResponsysObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl ResponsysObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Responsys source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResponsysSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl ResponsysSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "A Rest service dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RestResourceDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<RestResourceDatasetTypeProperties>,
}
impl RestResourceDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Properties specific to this dataset type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RestResourceDatasetTypeProperties {
    #[doc = "The relative URL to the resource that the RESTful API provides. Type: string (or Expression with resultType string)."]
    #[serde(rename = "relativeUrl", default, skip_serializing_if = "Option::is_none")]
    pub relative_url: Option<serde_json::Value>,
    #[doc = "The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string)."]
    #[serde(rename = "requestMethod", default, skip_serializing_if = "Option::is_none")]
    pub request_method: Option<serde_json::Value>,
    #[doc = "The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string)."]
    #[serde(rename = "requestBody", default, skip_serializing_if = "Option::is_none")]
    pub request_body: Option<serde_json::Value>,
    #[doc = "The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string)."]
    #[serde(rename = "additionalHeaders", default, skip_serializing_if = "Option::is_none")]
    pub additional_headers: Option<serde_json::Value>,
    #[doc = "The pagination rules to compose next page requests. Type: string (or Expression with resultType string)."]
    #[serde(rename = "paginationRules", default, skip_serializing_if = "Option::is_none")]
    pub pagination_rules: Option<serde_json::Value>,
}
impl RestResourceDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Rest Service linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RestServiceLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Rest Service linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: RestServiceLinkedServiceTypeProperties,
}
impl RestServiceLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: RestServiceLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Rest Service linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RestServiceLinkedServiceTypeProperties {
    #[doc = "The base URL of the REST service."]
    pub url: serde_json::Value,
    #[doc = "Whether to validate server side SSL certificate when connecting to the endpoint.The default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "enableServerCertificateValidation", default, skip_serializing_if = "Option::is_none")]
    pub enable_server_certificate_validation: Option<serde_json::Value>,
    #[doc = "Type of authentication used to connect to the REST service."]
    #[serde(rename = "authenticationType")]
    pub authentication_type: rest_service_linked_service_type_properties::AuthenticationType,
    #[doc = "The user name used in Basic authentication type."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The application's client ID used in AadServicePrincipal authentication type."]
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<SecretBase>,
    #[doc = "The tenant information (domain name or tenant ID) used in AadServicePrincipal authentication type under which your application resides."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<serde_json::Value>,
    #[doc = "Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "azureCloudType", default, skip_serializing_if = "Option::is_none")]
    pub azure_cloud_type: Option<serde_json::Value>,
    #[doc = "The resource you are requesting authorization to use."]
    #[serde(rename = "aadResourceId", default, skip_serializing_if = "Option::is_none")]
    pub aad_resource_id: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl RestServiceLinkedServiceTypeProperties {
    pub fn new(url: serde_json::Value, authentication_type: rest_service_linked_service_type_properties::AuthenticationType) -> Self {
        Self {
            url,
            enable_server_certificate_validation: None,
            authentication_type,
            user_name: None,
            password: None,
            service_principal_id: None,
            service_principal_key: None,
            tenant: None,
            azure_cloud_type: None,
            aad_resource_id: None,
            encrypted_credential: None,
        }
    }
}
pub mod rest_service_linked_service_type_properties {
    use super::*;
    #[doc = "Type of authentication used to connect to the REST service."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Anonymous,
        Basic,
        AadServicePrincipal,
        ManagedServiceIdentity,
    }
}
#[doc = "A copy activity Rest service Sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RestSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "The HTTP method used to call the RESTful API. The default is POST. Type: string (or Expression with resultType string)."]
    #[serde(rename = "requestMethod", default, skip_serializing_if = "Option::is_none")]
    pub request_method: Option<serde_json::Value>,
    #[doc = "The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string)."]
    #[serde(rename = "additionalHeaders", default, skip_serializing_if = "Option::is_none")]
    pub additional_headers: Option<serde_json::Value>,
    #[doc = "The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data. Default value: 00:01:40. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
    #[doc = "The time to await before sending next request, in milliseconds "]
    #[serde(rename = "requestInterval", default, skip_serializing_if = "Option::is_none")]
    pub request_interval: Option<serde_json::Value>,
    #[doc = "Http Compression Type to Send data in compressed format with Optimal Compression Level, Default is None. And The Only Supported option is Gzip. "]
    #[serde(rename = "httpCompressionType", default, skip_serializing_if = "Option::is_none")]
    pub http_compression_type: Option<serde_json::Value>,
}
impl RestSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            request_method: None,
            additional_headers: None,
            http_request_timeout: None,
            request_interval: None,
            http_compression_type: None,
        }
    }
}
#[doc = "A copy activity Rest service source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RestSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string)."]
    #[serde(rename = "requestMethod", default, skip_serializing_if = "Option::is_none")]
    pub request_method: Option<serde_json::Value>,
    #[doc = "The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string)."]
    #[serde(rename = "requestBody", default, skip_serializing_if = "Option::is_none")]
    pub request_body: Option<serde_json::Value>,
    #[doc = "The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string)."]
    #[serde(rename = "additionalHeaders", default, skip_serializing_if = "Option::is_none")]
    pub additional_headers: Option<serde_json::Value>,
    #[doc = "The pagination rules to compose next page requests. Type: string (or Expression with resultType string)."]
    #[serde(rename = "paginationRules", default, skip_serializing_if = "Option::is_none")]
    pub pagination_rules: Option<serde_json::Value>,
    #[doc = "The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data. Default value: 00:01:40. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
    #[doc = "The time to await before sending next page request. "]
    #[serde(rename = "requestInterval", default, skip_serializing_if = "Option::is_none")]
    pub request_interval: Option<serde_json::Value>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl RestSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            request_method: None,
            request_body: None,
            additional_headers: None,
            pagination_rules: None,
            http_request_timeout: None,
            request_interval: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "Execution policy for an activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RetryPolicy {
    #[doc = "Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<serde_json::Value>,
    #[doc = "Interval between retries in seconds. Default is 30."]
    #[serde(rename = "intervalInSeconds", default, skip_serializing_if = "Option::is_none")]
    pub interval_in_seconds: Option<i64>,
}
impl RetryPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Query parameters for listing runs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RunFilterParameters {
    #[doc = "The continuation token for getting the next page of results. Null for first page."]
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
    #[doc = "The time at or after which the run event was updated in 'ISO 8601' format."]
    #[serde(rename = "lastUpdatedAfter")]
    pub last_updated_after: String,
    #[doc = "The time at or before which the run event was updated in 'ISO 8601' format."]
    #[serde(rename = "lastUpdatedBefore")]
    pub last_updated_before: String,
    #[doc = "List of filters."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub filters: Vec<RunQueryFilter>,
    #[doc = "List of OrderBy option."]
    #[serde(rename = "orderBy", default, skip_serializing_if = "Vec::is_empty")]
    pub order_by: Vec<RunQueryOrderBy>,
}
impl RunFilterParameters {
    pub fn new(last_updated_after: String, last_updated_before: String) -> Self {
        Self {
            continuation_token: None,
            last_updated_after,
            last_updated_before,
            filters: Vec::new(),
            order_by: Vec::new(),
        }
    }
}
#[doc = "Query filter option for listing runs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RunQueryFilter {
    #[doc = "Parameter name to be used for filter. The allowed operands to query pipeline runs are PipelineName, RunStart, RunEnd and Status; to query activity runs are ActivityName, ActivityRunStart, ActivityRunEnd, ActivityType and Status, and to query trigger runs are TriggerName, TriggerRunTimestamp and Status."]
    pub operand: run_query_filter::Operand,
    #[doc = "Operator to be used for filter."]
    pub operator: run_query_filter::Operator,
    #[doc = "List of filter values."]
    pub values: Vec<String>,
}
impl RunQueryFilter {
    pub fn new(operand: run_query_filter::Operand, operator: run_query_filter::Operator, values: Vec<String>) -> Self {
        Self { operand, operator, values }
    }
}
pub mod run_query_filter {
    use super::*;
    #[doc = "Parameter name to be used for filter. The allowed operands to query pipeline runs are PipelineName, RunStart, RunEnd and Status; to query activity runs are ActivityName, ActivityRunStart, ActivityRunEnd, ActivityType and Status, and to query trigger runs are TriggerName, TriggerRunTimestamp and Status."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operand {
        PipelineName,
        Status,
        RunStart,
        RunEnd,
        ActivityName,
        ActivityRunStart,
        ActivityRunEnd,
        ActivityType,
        TriggerName,
        TriggerRunTimestamp,
        RunGroupId,
        LatestOnly,
    }
    #[doc = "Operator to be used for filter."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Operator {
        Equals,
        NotEquals,
        In,
        NotIn,
    }
}
#[doc = "An object to provide order by options for listing runs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RunQueryOrderBy {
    #[doc = "Parameter name to be used for order by. The allowed parameters to order by for pipeline runs are PipelineName, RunStart, RunEnd and Status; for activity runs are ActivityName, ActivityRunStart, ActivityRunEnd and Status; for trigger runs are TriggerName, TriggerRunTimestamp and Status."]
    #[serde(rename = "orderBy")]
    pub order_by: run_query_order_by::OrderBy,
    #[doc = "Sorting order of the parameter."]
    pub order: run_query_order_by::Order,
}
impl RunQueryOrderBy {
    pub fn new(order_by: run_query_order_by::OrderBy, order: run_query_order_by::Order) -> Self {
        Self { order_by, order }
    }
}
pub mod run_query_order_by {
    use super::*;
    #[doc = "Parameter name to be used for order by. The allowed parameters to order by for pipeline runs are PipelineName, RunStart, RunEnd and Status; for activity runs are ActivityName, ActivityRunStart, ActivityRunEnd and Status; for trigger runs are TriggerName, TriggerRunTimestamp and Status."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OrderBy {
        RunStart,
        RunEnd,
        PipelineName,
        Status,
        ActivityName,
        ActivityRunStart,
        ActivityRunEnd,
        TriggerName,
        TriggerRunTimestamp,
    }
    #[doc = "Sorting order of the parameter."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Order {
        #[serde(rename = "ASC")]
        Asc,
        #[serde(rename = "DESC")]
        Desc,
    }
}
#[doc = "SSIS access credential."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisAccessCredential {
    #[doc = "Domain for windows authentication."]
    pub domain: serde_json::Value,
    #[doc = "UseName for windows authentication."]
    #[serde(rename = "userName")]
    pub user_name: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    pub password: SecretBase,
}
impl SsisAccessCredential {
    pub fn new(domain: serde_json::Value, user_name: serde_json::Value, password: SecretBase) -> Self {
        Self {
            domain,
            user_name,
            password,
        }
    }
}
#[doc = "SSIS embedded child package."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisChildPackage {
    #[doc = "Path for embedded child package. Type: string (or Expression with resultType string)."]
    #[serde(rename = "packagePath")]
    pub package_path: serde_json::Value,
    #[doc = "Name for embedded child package."]
    #[serde(rename = "packageName", default, skip_serializing_if = "Option::is_none")]
    pub package_name: Option<String>,
    #[doc = "Content for embedded child package. Type: string (or Expression with resultType string)."]
    #[serde(rename = "packageContent")]
    pub package_content: serde_json::Value,
    #[doc = "Last modified date for embedded child package."]
    #[serde(rename = "packageLastModifiedDate", default, skip_serializing_if = "Option::is_none")]
    pub package_last_modified_date: Option<String>,
}
impl SsisChildPackage {
    pub fn new(package_path: serde_json::Value, package_content: serde_json::Value) -> Self {
        Self {
            package_path,
            package_name: None,
            package_content,
            package_last_modified_date: None,
        }
    }
}
#[doc = "SSIS Connection Manager."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SsisConnectionManager {}
impl SsisConnectionManager {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SSIS package execution credential."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisExecutionCredential {
    #[doc = "Domain for windows authentication."]
    pub domain: serde_json::Value,
    #[doc = "UseName for windows authentication."]
    #[serde(rename = "userName")]
    pub user_name: serde_json::Value,
    #[doc = "Azure Synapse secure string definition. The string value will be masked with asterisks '*' during Get or List API calls."]
    pub password: SecureString,
}
impl SsisExecutionCredential {
    pub fn new(domain: serde_json::Value, user_name: serde_json::Value, password: SecureString) -> Self {
        Self {
            domain,
            user_name,
            password,
        }
    }
}
#[doc = "SSIS execution parameter."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisExecutionParameter {
    #[doc = "SSIS package execution parameter value. Type: string (or Expression with resultType string)."]
    pub value: serde_json::Value,
}
impl SsisExecutionParameter {
    pub fn new(value: serde_json::Value) -> Self {
        Self { value }
    }
}
#[doc = "SSIS package execution log location"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisLogLocation {
    #[doc = "The SSIS package execution log path. Type: string (or Expression with resultType string)."]
    #[serde(rename = "logPath")]
    pub log_path: serde_json::Value,
    #[doc = "The type of SSIS log location."]
    #[serde(rename = "type")]
    pub type_: ssis_log_location::Type,
    #[doc = "SSIS package execution log location properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SsisLogLocationTypeProperties,
}
impl SsisLogLocation {
    pub fn new(log_path: serde_json::Value, type_: ssis_log_location::Type, type_properties: SsisLogLocationTypeProperties) -> Self {
        Self {
            log_path,
            type_,
            type_properties,
        }
    }
}
pub mod ssis_log_location {
    use super::*;
    #[doc = "The type of SSIS log location."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        File,
    }
}
#[doc = "SSIS package execution log location properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SsisLogLocationTypeProperties {
    #[doc = "SSIS access credential."]
    #[serde(rename = "accessCredential", default, skip_serializing_if = "Option::is_none")]
    pub access_credential: Option<SsisAccessCredential>,
    #[doc = "Specifies the interval to refresh log. The default interval is 5 minutes. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "logRefreshInterval", default, skip_serializing_if = "Option::is_none")]
    pub log_refresh_interval: Option<serde_json::Value>,
}
impl SsisLogLocationTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SSIS package location."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SsisPackageLocation {
    #[doc = "The SSIS package path. Type: string (or Expression with resultType string)."]
    #[serde(rename = "packagePath", default, skip_serializing_if = "Option::is_none")]
    pub package_path: Option<serde_json::Value>,
    #[doc = "The type of SSIS package location."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<ssis_package_location::Type>,
    #[doc = "SSIS package location properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SsisPackageLocationTypeProperties>,
}
impl SsisPackageLocation {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod ssis_package_location {
    use super::*;
    #[doc = "The type of SSIS package location."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "SSISDB")]
        Ssisdb,
        File,
        InlinePackage,
        PackageStore,
    }
}
#[doc = "SSIS package location properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SsisPackageLocationTypeProperties {
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "packagePassword", default, skip_serializing_if = "Option::is_none")]
    pub package_password: Option<SecretBase>,
    #[doc = "SSIS access credential."]
    #[serde(rename = "accessCredential", default, skip_serializing_if = "Option::is_none")]
    pub access_credential: Option<SsisAccessCredential>,
    #[doc = "The configuration file of the package execution. Type: string (or Expression with resultType string)."]
    #[serde(rename = "configurationPath", default, skip_serializing_if = "Option::is_none")]
    pub configuration_path: Option<serde_json::Value>,
    #[doc = "SSIS access credential."]
    #[serde(rename = "configurationAccessCredential", default, skip_serializing_if = "Option::is_none")]
    pub configuration_access_credential: Option<SsisAccessCredential>,
    #[doc = "The package name."]
    #[serde(rename = "packageName", default, skip_serializing_if = "Option::is_none")]
    pub package_name: Option<String>,
    #[doc = "The embedded package content. Type: string (or Expression with resultType string)."]
    #[serde(rename = "packageContent", default, skip_serializing_if = "Option::is_none")]
    pub package_content: Option<serde_json::Value>,
    #[doc = "The embedded package last modified date."]
    #[serde(rename = "packageLastModifiedDate", default, skip_serializing_if = "Option::is_none")]
    pub package_last_modified_date: Option<String>,
    #[doc = "The embedded child package list."]
    #[serde(rename = "childPackages", default, skip_serializing_if = "Vec::is_empty")]
    pub child_packages: Vec<SsisChildPackage>,
}
impl SsisPackageLocationTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SSIS property override."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SsisPropertyOverride {
    #[doc = "SSIS package property override value. Type: string (or Expression with resultType string)."]
    pub value: serde_json::Value,
    #[doc = "Whether SSIS package property override value is sensitive data. Value will be encrypted in SSISDB if it is true"]
    #[serde(rename = "isSensitive", default, skip_serializing_if = "Option::is_none")]
    pub is_sensitive: Option<bool>,
}
impl SsisPropertyOverride {
    pub fn new(value: serde_json::Value) -> Self {
        Self { value, is_sensitive: None }
    }
}
#[doc = "Linked service for Salesforce."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Salesforce linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SalesforceLinkedServiceTypeProperties,
}
impl SalesforceLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SalesforceLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Salesforce linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SalesforceLinkedServiceTypeProperties {
    #[doc = "The URL of Salesforce instance. Default is 'https://login.salesforce.com'. To copy data from sandbox, specify 'https://test.salesforce.com'. To copy data from custom domain, specify, for example, 'https://[domain].my.salesforce.com'. Type: string (or Expression with resultType string)."]
    #[serde(rename = "environmentUrl", default, skip_serializing_if = "Option::is_none")]
    pub environment_url: Option<serde_json::Value>,
    #[doc = "The username for Basic authentication of the Salesforce instance. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "securityToken", default, skip_serializing_if = "Option::is_none")]
    pub security_token: Option<SecretBase>,
    #[doc = "The Salesforce API version used in ADF. Type: string (or Expression with resultType string)."]
    #[serde(rename = "apiVersion", default, skip_serializing_if = "Option::is_none")]
    pub api_version: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SalesforceLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Salesforce Marketing Cloud linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceMarketingCloudLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Salesforce Marketing Cloud linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SalesforceMarketingCloudLinkedServiceTypeProperties,
}
impl SalesforceMarketingCloudLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SalesforceMarketingCloudLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Salesforce Marketing Cloud linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceMarketingCloudLinkedServiceTypeProperties {
    #[doc = "Properties used to connect to Salesforce Marketing Cloud. It is mutually exclusive with any other properties in the linked service. Type: object."]
    #[serde(rename = "connectionProperties", default, skip_serializing_if = "Option::is_none")]
    pub connection_properties: Option<serde_json::Value>,
    #[doc = "The client ID associated with the Salesforce Marketing Cloud application. Type: string (or Expression with resultType string)."]
    #[serde(rename = "clientId")]
    pub client_id: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[doc = "Specifies whether to verify the identity of the server when connecting over SSL. The default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SalesforceMarketingCloudLinkedServiceTypeProperties {
    pub fn new(client_id: serde_json::Value) -> Self {
        Self {
            connection_properties: None,
            client_id,
            client_secret: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Salesforce Marketing Cloud dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceMarketingCloudObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl SalesforceMarketingCloudObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Salesforce Marketing Cloud source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceMarketingCloudSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl SalesforceMarketingCloudSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "The Salesforce object dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Salesforce object dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SalesforceObjectDatasetTypeProperties>,
}
impl SalesforceObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Salesforce object dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SalesforceObjectDatasetTypeProperties {
    #[doc = "The Salesforce object API name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "objectApiName", default, skip_serializing_if = "Option::is_none")]
    pub object_api_name: Option<serde_json::Value>,
}
impl SalesforceObjectDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Linked service for Salesforce Service Cloud."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceServiceCloudLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Salesforce Service Cloud linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SalesforceServiceCloudLinkedServiceTypeProperties,
}
impl SalesforceServiceCloudLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SalesforceServiceCloudLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Salesforce Service Cloud linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SalesforceServiceCloudLinkedServiceTypeProperties {
    #[doc = "The URL of Salesforce Service Cloud instance. Default is 'https://login.salesforce.com'. To copy data from sandbox, specify 'https://test.salesforce.com'. To copy data from custom domain, specify, for example, 'https://[domain].my.salesforce.com'. Type: string (or Expression with resultType string)."]
    #[serde(rename = "environmentUrl", default, skip_serializing_if = "Option::is_none")]
    pub environment_url: Option<serde_json::Value>,
    #[doc = "The username for Basic authentication of the Salesforce instance. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "securityToken", default, skip_serializing_if = "Option::is_none")]
    pub security_token: Option<SecretBase>,
    #[doc = "The Salesforce API version used in ADF. Type: string (or Expression with resultType string)."]
    #[serde(rename = "apiVersion", default, skip_serializing_if = "Option::is_none")]
    pub api_version: Option<serde_json::Value>,
    #[doc = "Extended properties appended to the connection string. Type: string (or Expression with resultType string)."]
    #[serde(rename = "extendedProperties", default, skip_serializing_if = "Option::is_none")]
    pub extended_properties: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SalesforceServiceCloudLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The Salesforce Service Cloud object dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceServiceCloudObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Salesforce Service Cloud object dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SalesforceServiceCloudObjectDatasetTypeProperties>,
}
impl SalesforceServiceCloudObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Salesforce Service Cloud object dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SalesforceServiceCloudObjectDatasetTypeProperties {
    #[doc = "The Salesforce Service Cloud object API name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "objectApiName", default, skip_serializing_if = "Option::is_none")]
    pub object_api_name: Option<serde_json::Value>,
}
impl SalesforceServiceCloudObjectDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A copy activity Salesforce Service Cloud sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceServiceCloudSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "The write behavior for the operation. Default is Insert."]
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<salesforce_service_cloud_sink::WriteBehavior>,
    #[doc = "The name of the external ID field for upsert operation. Default value is 'Id' column. Type: string (or Expression with resultType string)."]
    #[serde(rename = "externalIdFieldName", default, skip_serializing_if = "Option::is_none")]
    pub external_id_field_name: Option<serde_json::Value>,
    #[doc = "The flag indicating whether or not to ignore null values from input dataset (except key fields) during write operation. Default value is false. If set it to true, it means ADF will leave the data in the destination object unchanged when doing upsert/update operation and insert defined default value when doing insert operation, versus ADF will update the data in the destination object to NULL when doing upsert/update operation and insert NULL value when doing insert operation. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "ignoreNullValues", default, skip_serializing_if = "Option::is_none")]
    pub ignore_null_values: Option<serde_json::Value>,
}
impl SalesforceServiceCloudSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            write_behavior: None,
            external_id_field_name: None,
            ignore_null_values: None,
        }
    }
}
pub mod salesforce_service_cloud_sink {
    use super::*;
    #[doc = "The write behavior for the operation. Default is Insert."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WriteBehavior {
        Insert,
        Upsert,
    }
}
#[doc = "A copy activity Salesforce Service Cloud source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceServiceCloudSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Database query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "The read behavior for the operation. Default is Query."]
    #[serde(rename = "readBehavior", default, skip_serializing_if = "Option::is_none")]
    pub read_behavior: Option<salesforce_service_cloud_source::ReadBehavior>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl SalesforceServiceCloudSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            read_behavior: None,
            additional_columns: Vec::new(),
        }
    }
}
pub mod salesforce_service_cloud_source {
    use super::*;
    #[doc = "The read behavior for the operation. Default is Query."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReadBehavior {
        Query,
        QueryAll,
    }
}
#[doc = "A copy activity Salesforce sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "The write behavior for the operation. Default is Insert."]
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<salesforce_sink::WriteBehavior>,
    #[doc = "The name of the external ID field for upsert operation. Default value is 'Id' column. Type: string (or Expression with resultType string)."]
    #[serde(rename = "externalIdFieldName", default, skip_serializing_if = "Option::is_none")]
    pub external_id_field_name: Option<serde_json::Value>,
    #[doc = "The flag indicating whether or not to ignore null values from input dataset (except key fields) during write operation. Default value is false. If set it to true, it means ADF will leave the data in the destination object unchanged when doing upsert/update operation and insert defined default value when doing insert operation, versus ADF will update the data in the destination object to NULL when doing upsert/update operation and insert NULL value when doing insert operation. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "ignoreNullValues", default, skip_serializing_if = "Option::is_none")]
    pub ignore_null_values: Option<serde_json::Value>,
}
impl SalesforceSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            write_behavior: None,
            external_id_field_name: None,
            ignore_null_values: None,
        }
    }
}
pub mod salesforce_sink {
    use super::*;
    #[doc = "The write behavior for the operation. Default is Insert."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WriteBehavior {
        Insert,
        Upsert,
    }
}
#[doc = "A copy activity Salesforce source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SalesforceSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "Database query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "The read behavior for the operation. Default is Query."]
    #[serde(rename = "readBehavior", default, skip_serializing_if = "Option::is_none")]
    pub read_behavior: Option<salesforce_source::ReadBehavior>,
}
impl SalesforceSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            read_behavior: None,
        }
    }
}
pub mod salesforce_source {
    use super::*;
    #[doc = "The read behavior for the operation. Default is Query."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ReadBehavior {
        Query,
        QueryAll,
    }
}
#[doc = "SAP Business Warehouse Linked Service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapBwLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Properties specific to this linked service type."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SapBwLinkedServiceTypeProperties,
}
impl SapBwLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SapBwLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Properties specific to this linked service type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapBwLinkedServiceTypeProperties {
    #[doc = "Host name of the SAP BW instance. Type: string (or Expression with resultType string)."]
    pub server: serde_json::Value,
    #[doc = "System number of the BW system. (Usually a two-digit decimal number represented as a string.) Type: string (or Expression with resultType string)."]
    #[serde(rename = "systemNumber")]
    pub system_number: serde_json::Value,
    #[doc = "Client ID of the client on the BW system. (Usually a three-digit decimal number represented as a string) Type: string (or Expression with resultType string)."]
    #[serde(rename = "clientId")]
    pub client_id: serde_json::Value,
    #[doc = "Username to access the SAP BW server. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SapBwLinkedServiceTypeProperties {
    pub fn new(server: serde_json::Value, system_number: serde_json::Value, client_id: serde_json::Value) -> Self {
        Self {
            server,
            system_number,
            client_id,
            user_name: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "The SAP BW cube dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapBwCubeDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
}
impl SapBwCubeDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self { dataset }
    }
}
#[doc = "A copy activity source for SapBW server via MDX."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapBwSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "MDX query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl SapBwSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Linked service for SAP Cloud for Customer."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapCloudForCustomerLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "SAP Cloud for Customer linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SapCloudForCustomerLinkedServiceTypeProperties,
}
impl SapCloudForCustomerLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SapCloudForCustomerLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "SAP Cloud for Customer linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapCloudForCustomerLinkedServiceTypeProperties {
    #[doc = "The URL of SAP Cloud for Customer OData API. For example, '[https://[tenantname].crm.ondemand.com/sap/c4c/odata/v1]'. Type: string (or Expression with resultType string)."]
    pub url: serde_json::Value,
    #[doc = "The username for Basic authentication. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Either encryptedCredential or username/password must be provided. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SapCloudForCustomerLinkedServiceTypeProperties {
    pub fn new(url: serde_json::Value) -> Self {
        Self {
            url,
            username: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "The path of the SAP Cloud for Customer OData entity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapCloudForCustomerResourceDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Sap Cloud For Customer OData resource dataset properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SapCloudForCustomerResourceDatasetTypeProperties,
}
impl SapCloudForCustomerResourceDataset {
    pub fn new(dataset: Dataset, type_properties: SapCloudForCustomerResourceDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "Sap Cloud For Customer OData resource dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapCloudForCustomerResourceDatasetTypeProperties {
    #[doc = "The path of the SAP Cloud for Customer OData entity. Type: string (or Expression with resultType string)."]
    pub path: serde_json::Value,
}
impl SapCloudForCustomerResourceDatasetTypeProperties {
    pub fn new(path: serde_json::Value) -> Self {
        Self { path }
    }
}
#[doc = "A copy activity SAP Cloud for Customer sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapCloudForCustomerSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "The write behavior for the operation. Default is 'Insert'."]
    #[serde(rename = "writeBehavior", default, skip_serializing_if = "Option::is_none")]
    pub write_behavior: Option<sap_cloud_for_customer_sink::WriteBehavior>,
    #[doc = "The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data. Default value: 00:05:00. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
}
impl SapCloudForCustomerSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            write_behavior: None,
            http_request_timeout: None,
        }
    }
}
pub mod sap_cloud_for_customer_sink {
    use super::*;
    #[doc = "The write behavior for the operation. Default is 'Insert'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum WriteBehavior {
        Insert,
        Update,
    }
}
#[doc = "A copy activity source for SAP Cloud for Customer source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapCloudForCustomerSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "SAP Cloud for Customer OData query. For example, \"$top=1\". Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data. Default value: 00:05:00. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
}
impl SapCloudForCustomerSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            http_request_timeout: None,
        }
    }
}
#[doc = "Linked service for SAP ERP Central Component(SAP ECC)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapEccLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "SAP ECC linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SapEccLinkedServiceTypeProperties,
}
impl SapEccLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SapEccLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "SAP ECC linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapEccLinkedServiceTypeProperties {
    #[doc = "The URL of SAP ECC OData API. For example, '[https://hostname:port/sap/opu/odata/sap/servicename/]'. Type: string (or Expression with resultType string)."]
    pub url: String,
    #[doc = "The username for Basic authentication. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Either encryptedCredential or username/password must be provided. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<String>,
}
impl SapEccLinkedServiceTypeProperties {
    pub fn new(url: String) -> Self {
        Self {
            url,
            username: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "The path of the SAP ECC OData entity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapEccResourceDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Sap ECC OData resource dataset properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SapEccResourceDatasetTypeProperties,
}
impl SapEccResourceDataset {
    pub fn new(dataset: Dataset, type_properties: SapEccResourceDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "Sap ECC OData resource dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapEccResourceDatasetTypeProperties {
    #[doc = "The path of the SAP ECC OData entity. Type: string (or Expression with resultType string)."]
    pub path: serde_json::Value,
}
impl SapEccResourceDatasetTypeProperties {
    pub fn new(path: serde_json::Value) -> Self {
        Self { path }
    }
}
#[doc = "A copy activity source for SAP ECC source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapEccSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "SAP ECC OData query. For example, \"$top=1\". Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data. Default value: 00:05:00. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
}
impl SapEccSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            http_request_timeout: None,
        }
    }
}
#[doc = "SAP HANA Linked Service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapHanaLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Properties specific to this linked service type."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SapHanaLinkedServiceProperties,
}
impl SapHanaLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SapHanaLinkedServiceProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Properties specific to this linked service type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapHanaLinkedServiceProperties {
    #[doc = "SAP HANA ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[doc = "Host name of the SAP HANA server. Type: string (or Expression with resultType string)."]
    pub server: serde_json::Value,
    #[doc = "The authentication type to be used to connect to the SAP HANA server."]
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<sap_hana_linked_service_properties::AuthenticationType>,
    #[doc = "Username to access the SAP HANA server. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SapHanaLinkedServiceProperties {
    pub fn new(server: serde_json::Value) -> Self {
        Self {
            connection_string: None,
            server,
            authentication_type: None,
            user_name: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
pub mod sap_hana_linked_service_properties {
    use super::*;
    #[doc = "The authentication type to be used to connect to the SAP HANA server."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        Windows,
    }
}
#[doc = "The partition mechanism that will be used for SAP HANA read in parallel."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SapHanaPartitionOption {
    None,
    PhysicalPartitionsOfTable,
    SapHanaDynamicRange,
}
#[doc = "The settings that will be leveraged for SAP HANA source partitioning."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapHanaPartitionSettings {
    #[doc = "The name of the column that will be used for proceeding range partitioning. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionColumnName", default, skip_serializing_if = "Option::is_none")]
    pub partition_column_name: Option<serde_json::Value>,
}
impl SapHanaPartitionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A copy activity source for SAP HANA source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapHanaSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "SAP HANA Sql query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "The packet size of data read from SAP HANA. Type: integer(or Expression with resultType integer)."]
    #[serde(rename = "packetSize", default, skip_serializing_if = "Option::is_none")]
    pub packet_size: Option<serde_json::Value>,
    #[doc = "The partition mechanism that will be used for SAP HANA read in parallel."]
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<sap_hana_source::PartitionOption>,
    #[doc = "The settings that will be leveraged for SAP HANA source partitioning."]
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<SapHanaPartitionSettings>,
}
impl SapHanaSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            packet_size: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
pub mod sap_hana_source {
    use super::*;
    #[doc = "The partition mechanism that will be used for SAP HANA read in parallel."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PartitionOption {
        None,
        PhysicalPartitionsOfTable,
        SapHanaDynamicRange,
    }
}
#[doc = "SAP HANA Table properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapHanaTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "SAP HANA Table properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SapHanaTableDatasetTypeProperties>,
}
impl SapHanaTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "SAP HANA Table properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapHanaTableDatasetTypeProperties {
    #[doc = "The schema name of SAP HANA. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[doc = "The table name of SAP HANA. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl SapHanaTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SAP Business Warehouse Open Hub Destination Linked Service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapOpenHubLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Properties specific to SAP Business Warehouse Open Hub Destination linked service type."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SapOpenHubLinkedServiceTypeProperties,
}
impl SapOpenHubLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SapOpenHubLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Properties specific to SAP Business Warehouse Open Hub Destination linked service type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapOpenHubLinkedServiceTypeProperties {
    #[doc = "Host name of the SAP BW instance where the open hub destination is located. Type: string (or Expression with resultType string)."]
    pub server: serde_json::Value,
    #[doc = "System number of the BW system where the open hub destination is located. (Usually a two-digit decimal number represented as a string.) Type: string (or Expression with resultType string)."]
    #[serde(rename = "systemNumber")]
    pub system_number: serde_json::Value,
    #[doc = "Client ID of the client on the BW system where the open hub destination is located. (Usually a three-digit decimal number represented as a string) Type: string (or Expression with resultType string)."]
    #[serde(rename = "clientId")]
    pub client_id: serde_json::Value,
    #[doc = "Language of the BW system where the open hub destination is located. The default value is EN. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub language: Option<serde_json::Value>,
    #[doc = "SystemID of the SAP system where the table is located. Type: string (or Expression with resultType string)."]
    #[serde(rename = "systemId", default, skip_serializing_if = "Option::is_none")]
    pub system_id: Option<serde_json::Value>,
    #[doc = "Username to access the SAP BW server where the open hub destination is located. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The hostname of the SAP Message Server. Type: string (or Expression with resultType string)."]
    #[serde(rename = "messageServer", default, skip_serializing_if = "Option::is_none")]
    pub message_server: Option<serde_json::Value>,
    #[doc = "The service name or port number of the Message Server. Type: string (or Expression with resultType string)."]
    #[serde(rename = "messageServerService", default, skip_serializing_if = "Option::is_none")]
    pub message_server_service: Option<serde_json::Value>,
    #[doc = "The Logon Group for the SAP System. Type: string (or Expression with resultType string)."]
    #[serde(rename = "logonGroup", default, skip_serializing_if = "Option::is_none")]
    pub logon_group: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SapOpenHubLinkedServiceTypeProperties {
    pub fn new(server: serde_json::Value, system_number: serde_json::Value, client_id: serde_json::Value) -> Self {
        Self {
            server,
            system_number,
            client_id,
            language: None,
            system_id: None,
            user_name: None,
            password: None,
            message_server: None,
            message_server_service: None,
            logon_group: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "A copy activity source for SAP Business Warehouse Open Hub Destination source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapOpenHubSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "Whether to exclude the records of the last request. The default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "excludeLastRequest", default, skip_serializing_if = "Option::is_none")]
    pub exclude_last_request: Option<serde_json::Value>,
    #[doc = "The ID of request for delta loading. Once it is set, only data with requestId larger than the value of this property will be retrieved. The default value is 0. Type: integer (or Expression with resultType integer )."]
    #[serde(rename = "baseRequestId", default, skip_serializing_if = "Option::is_none")]
    pub base_request_id: Option<serde_json::Value>,
    #[doc = "Specifies the custom RFC function module that will be used to read data from SAP Table. Type: string (or Expression with resultType string)."]
    #[serde(rename = "customRfcReadTableFunctionModule", default, skip_serializing_if = "Option::is_none")]
    pub custom_rfc_read_table_function_module: Option<serde_json::Value>,
    #[doc = "The single character that will be used as delimiter passed to SAP RFC as well as splitting the output data retrieved. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sapDataColumnDelimiter", default, skip_serializing_if = "Option::is_none")]
    pub sap_data_column_delimiter: Option<serde_json::Value>,
}
impl SapOpenHubSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            exclude_last_request: None,
            base_request_id: None,
            custom_rfc_read_table_function_module: None,
            sap_data_column_delimiter: None,
        }
    }
}
#[doc = "Sap Business Warehouse Open Hub Destination Table properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapOpenHubTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Sap Business Warehouse Open Hub Destination Table properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SapOpenHubTableDatasetTypeProperties,
}
impl SapOpenHubTableDataset {
    pub fn new(dataset: Dataset, type_properties: SapOpenHubTableDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "Sap Business Warehouse Open Hub Destination Table properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapOpenHubTableDatasetTypeProperties {
    #[doc = "The name of the Open Hub Destination with destination type as Database Table. Type: string (or Expression with resultType string)."]
    #[serde(rename = "openHubDestinationName")]
    pub open_hub_destination_name: serde_json::Value,
    #[doc = "Whether to exclude the records of the last request. The default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "excludeLastRequest", default, skip_serializing_if = "Option::is_none")]
    pub exclude_last_request: Option<serde_json::Value>,
    #[doc = "The ID of request for delta loading. Once it is set, only data with requestId larger than the value of this property will be retrieved. The default value is 0. Type: integer (or Expression with resultType integer )."]
    #[serde(rename = "baseRequestId", default, skip_serializing_if = "Option::is_none")]
    pub base_request_id: Option<serde_json::Value>,
}
impl SapOpenHubTableDatasetTypeProperties {
    pub fn new(open_hub_destination_name: serde_json::Value) -> Self {
        Self {
            open_hub_destination_name,
            exclude_last_request: None,
            base_request_id: None,
        }
    }
}
#[doc = "SAP Table Linked Service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapTableLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Properties specific to this linked service type."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SapTableLinkedServiceTypeProperties,
}
impl SapTableLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SapTableLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Properties specific to this linked service type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapTableLinkedServiceTypeProperties {
    #[doc = "Host name of the SAP instance where the table is located. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub server: Option<serde_json::Value>,
    #[doc = "System number of the SAP system where the table is located. (Usually a two-digit decimal number represented as a string.) Type: string (or Expression with resultType string)."]
    #[serde(rename = "systemNumber", default, skip_serializing_if = "Option::is_none")]
    pub system_number: Option<serde_json::Value>,
    #[doc = "Client ID of the client on the SAP system where the table is located. (Usually a three-digit decimal number represented as a string) Type: string (or Expression with resultType string)."]
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<serde_json::Value>,
    #[doc = "Language of the SAP system where the table is located. The default value is EN. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub language: Option<serde_json::Value>,
    #[doc = "SystemID of the SAP system where the table is located. Type: string (or Expression with resultType string)."]
    #[serde(rename = "systemId", default, skip_serializing_if = "Option::is_none")]
    pub system_id: Option<serde_json::Value>,
    #[doc = "Username to access the SAP server where the table is located. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The hostname of the SAP Message Server. Type: string (or Expression with resultType string)."]
    #[serde(rename = "messageServer", default, skip_serializing_if = "Option::is_none")]
    pub message_server: Option<serde_json::Value>,
    #[doc = "The service name or port number of the Message Server. Type: string (or Expression with resultType string)."]
    #[serde(rename = "messageServerService", default, skip_serializing_if = "Option::is_none")]
    pub message_server_service: Option<serde_json::Value>,
    #[doc = "SNC activation indicator to access the SAP server where the table is located. Must be either 0 (off) or 1 (on). Type: string (or Expression with resultType string)."]
    #[serde(rename = "sncMode", default, skip_serializing_if = "Option::is_none")]
    pub snc_mode: Option<serde_json::Value>,
    #[doc = "Initiator's SNC name to access the SAP server where the table is located. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sncMyName", default, skip_serializing_if = "Option::is_none")]
    pub snc_my_name: Option<serde_json::Value>,
    #[doc = "Communication partner's SNC name to access the SAP server where the table is located. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sncPartnerName", default, skip_serializing_if = "Option::is_none")]
    pub snc_partner_name: Option<serde_json::Value>,
    #[doc = "External security product's library to access the SAP server where the table is located. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sncLibraryPath", default, skip_serializing_if = "Option::is_none")]
    pub snc_library_path: Option<serde_json::Value>,
    #[doc = "SNC Quality of Protection. Allowed value include: 1, 2, 3, 8, 9. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sncQop", default, skip_serializing_if = "Option::is_none")]
    pub snc_qop: Option<serde_json::Value>,
    #[doc = "The Logon Group for the SAP System. Type: string (or Expression with resultType string)."]
    #[serde(rename = "logonGroup", default, skip_serializing_if = "Option::is_none")]
    pub logon_group: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SapTableLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The partition mechanism that will be used for SAP table read in parallel."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SapTablePartitionOption {
    None,
    PartitionOnInt,
    PartitionOnCalendarYear,
    PartitionOnCalendarMonth,
    PartitionOnCalendarDate,
    PartitionOnTime,
}
#[doc = "The settings that will be leveraged for SAP table source partitioning."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapTablePartitionSettings {
    #[doc = "The name of the column that will be used for proceeding range partitioning. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionColumnName", default, skip_serializing_if = "Option::is_none")]
    pub partition_column_name: Option<serde_json::Value>,
    #[doc = "The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionUpperBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_upper_bound: Option<serde_json::Value>,
    #[doc = "The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionLowerBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_lower_bound: Option<serde_json::Value>,
    #[doc = "The maximum value of partitions the table will be split into. Type: integer (or Expression with resultType string)."]
    #[serde(rename = "maxPartitionsNumber", default, skip_serializing_if = "Option::is_none")]
    pub max_partitions_number: Option<serde_json::Value>,
}
impl SapTablePartitionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SAP Table Resource properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapTableResourceDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "SAP Table Resource properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SapTableResourceDatasetTypeProperties,
}
impl SapTableResourceDataset {
    pub fn new(dataset: Dataset, type_properties: SapTableResourceDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "SAP Table Resource properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapTableResourceDatasetTypeProperties {
    #[doc = "The name of the SAP Table. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableName")]
    pub table_name: serde_json::Value,
}
impl SapTableResourceDatasetTypeProperties {
    pub fn new(table_name: serde_json::Value) -> Self {
        Self { table_name }
    }
}
#[doc = "A copy activity source for SAP Table source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapTableSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "The number of rows to be retrieved. Type: integer(or Expression with resultType integer)."]
    #[serde(rename = "rowCount", default, skip_serializing_if = "Option::is_none")]
    pub row_count: Option<serde_json::Value>,
    #[doc = "The number of rows that will be skipped. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "rowSkips", default, skip_serializing_if = "Option::is_none")]
    pub row_skips: Option<serde_json::Value>,
    #[doc = "The fields of the SAP table that will be retrieved. For example, column0, column1. Type: string (or Expression with resultType string)."]
    #[serde(rename = "rfcTableFields", default, skip_serializing_if = "Option::is_none")]
    pub rfc_table_fields: Option<serde_json::Value>,
    #[doc = "The options for the filtering of the SAP Table. For example, COLUMN0 EQ SOME VALUE. Type: string (or Expression with resultType string)."]
    #[serde(rename = "rfcTableOptions", default, skip_serializing_if = "Option::is_none")]
    pub rfc_table_options: Option<serde_json::Value>,
    #[doc = "Specifies the maximum number of rows that will be retrieved at a time when retrieving data from SAP Table. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "batchSize", default, skip_serializing_if = "Option::is_none")]
    pub batch_size: Option<serde_json::Value>,
    #[doc = "Specifies the custom RFC function module that will be used to read data from SAP Table. Type: string (or Expression with resultType string)."]
    #[serde(rename = "customRfcReadTableFunctionModule", default, skip_serializing_if = "Option::is_none")]
    pub custom_rfc_read_table_function_module: Option<serde_json::Value>,
    #[doc = "The single character that will be used as delimiter passed to SAP RFC as well as splitting the output data retrieved. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sapDataColumnDelimiter", default, skip_serializing_if = "Option::is_none")]
    pub sap_data_column_delimiter: Option<serde_json::Value>,
    #[doc = "The partition mechanism that will be used for SAP table read in parallel."]
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<sap_table_source::PartitionOption>,
    #[doc = "The settings that will be leveraged for SAP table source partitioning."]
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<SapTablePartitionSettings>,
}
impl SapTableSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            row_count: None,
            row_skips: None,
            rfc_table_fields: None,
            rfc_table_options: None,
            batch_size: None,
            custom_rfc_read_table_function_module: None,
            sap_data_column_delimiter: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
pub mod sap_table_source {
    use super::*;
    #[doc = "The partition mechanism that will be used for SAP table read in parallel."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PartitionOption {
        None,
        PartitionOnInt,
        PartitionOnCalendarYear,
        PartitionOnCalendarMonth,
        PartitionOnCalendarDate,
        PartitionOnTime,
    }
}
#[doc = "Trigger that creates pipeline runs periodically, on schedule."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScheduleTrigger {
    #[serde(flatten)]
    pub multiple_pipeline_trigger: MultiplePipelineTrigger,
    #[doc = "Schedule Trigger properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: schedule_trigger::TypeProperties,
}
impl ScheduleTrigger {
    pub fn new(multiple_pipeline_trigger: MultiplePipelineTrigger, type_properties: schedule_trigger::TypeProperties) -> Self {
        Self {
            multiple_pipeline_trigger,
            type_properties,
        }
    }
}
pub mod schedule_trigger {
    use super::*;
    #[doc = "Schedule Trigger properties."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct TypeProperties {
        #[doc = "The workflow trigger recurrence."]
        pub recurrence: ScheduleTriggerRecurrence,
    }
    impl TypeProperties {
        pub fn new(recurrence: ScheduleTriggerRecurrence) -> Self {
            Self { recurrence }
        }
    }
}
#[doc = "The workflow trigger recurrence."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScheduleTriggerRecurrence {
    #[doc = "Enumerates possible frequency option for the schedule trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub frequency: Option<RecurrenceFrequency>,
    #[doc = "The interval."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interval: Option<i32>,
    #[doc = "The start time."]
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[doc = "The end time."]
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[doc = "The time zone."]
    #[serde(rename = "timeZone", default, skip_serializing_if = "Option::is_none")]
    pub time_zone: Option<String>,
    #[doc = "The recurrence schedule."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schedule: Option<RecurrenceSchedule>,
}
impl ScheduleTriggerRecurrence {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Custom script action to run on HDI ondemand cluster once it's up."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScriptAction {
    #[doc = "The user provided name of the script action."]
    pub name: String,
    #[doc = "The URI for the script action."]
    pub uri: String,
    #[doc = "The node types on which the script action should be executed."]
    pub roles: script_action::Roles,
    #[doc = "The parameters for the script action."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<String>,
}
impl ScriptAction {
    pub fn new(name: String, uri: String, roles: script_action::Roles) -> Self {
        Self {
            name,
            uri,
            roles,
            parameters: None,
        }
    }
}
pub mod script_action {
    use super::*;
    #[doc = "The node types on which the script action should be executed."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Roles {
        Headnode,
        Workernode,
        Zookeeper,
    }
}
#[doc = "The base definition of a secret type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecretBase {
    #[doc = "Type of the secret."]
    #[serde(rename = "type")]
    pub type_: String,
}
impl SecretBase {
    pub fn new(type_: String) -> Self {
        Self { type_ }
    }
}
#[doc = "Azure Synapse secure string definition. The string value will be masked with asterisks '*' during Get or List API calls."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SecureString {
    #[serde(flatten)]
    pub secret_base: SecretBase,
    #[doc = "Value of secure string."]
    pub value: String,
}
impl SecureString {
    pub fn new(secret_base: SecretBase, value: String) -> Self {
        Self { secret_base, value }
    }
}
#[doc = "Self referenced tumbling window trigger dependency."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SelfDependencyTumblingWindowTriggerReference {
    #[serde(flatten)]
    pub dependency_reference: DependencyReference,
    #[doc = "Timespan applied to the start time of a tumbling window when evaluating dependency."]
    pub offset: String,
    #[doc = "The size of the window when evaluating the dependency. If undefined the frequency of the tumbling window will be used."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<String>,
}
impl SelfDependencyTumblingWindowTriggerReference {
    pub fn new(dependency_reference: DependencyReference, offset: String) -> Self {
        Self {
            dependency_reference,
            offset,
            size: None,
        }
    }
}
#[doc = "ServiceNow server linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceNowLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "ServiceNow server linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: ServiceNowLinkedServiceTypeProperties,
}
impl ServiceNowLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: ServiceNowLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "ServiceNow server linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceNowLinkedServiceTypeProperties {
    #[doc = "The endpoint of the ServiceNow server. (i.e. <instance>.service-now.com)"]
    pub endpoint: serde_json::Value,
    #[doc = "The authentication type to use."]
    #[serde(rename = "authenticationType")]
    pub authentication_type: service_now_linked_service_type_properties::AuthenticationType,
    #[doc = "The user name used to connect to the ServiceNow server for Basic and OAuth2 authentication."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The client id for OAuth2 authentication."]
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[doc = "Specifies whether to verify the identity of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl ServiceNowLinkedServiceTypeProperties {
    pub fn new(endpoint: serde_json::Value, authentication_type: service_now_linked_service_type_properties::AuthenticationType) -> Self {
        Self {
            endpoint,
            authentication_type,
            username: None,
            password: None,
            client_id: None,
            client_secret: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
pub mod service_now_linked_service_type_properties {
    use super::*;
    #[doc = "The authentication type to use."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        OAuth2,
    }
}
#[doc = "ServiceNow server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceNowObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl ServiceNowObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity ServiceNow server source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceNowSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl ServiceNowSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with resultType string)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ServicePrincipalCredentialEnum {
    ServicePrincipalKey,
    ServicePrincipalCert,
}
#[doc = "Set value for a Variable."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SetVariableActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[doc = "SetVariable activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SetVariableActivityTypeProperties,
}
impl SetVariableActivity {
    pub fn new(control_activity: ControlActivity, type_properties: SetVariableActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[doc = "SetVariable activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SetVariableActivityTypeProperties {
    #[doc = "Name of the variable whose value needs to be set."]
    #[serde(rename = "variableName", default, skip_serializing_if = "Option::is_none")]
    pub variable_name: Option<String>,
    #[doc = "Value to be set. Could be a static value or Expression"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<serde_json::Value>,
}
impl SetVariableActivityTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The location of SFTP dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SftpLocation {
    #[serde(flatten)]
    pub dataset_location: DatasetLocation,
}
impl SftpLocation {
    pub fn new(dataset_location: DatasetLocation) -> Self {
        Self { dataset_location }
    }
}
#[doc = "Sftp read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SftpReadSettings {
    #[serde(flatten)]
    pub store_read_settings: StoreReadSettings,
    #[doc = "If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<serde_json::Value>,
    #[doc = "Sftp wildcardFolderPath. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFolderPath", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_folder_path: Option<serde_json::Value>,
    #[doc = "Sftp wildcardFileName. Type: string (or Expression with resultType string)."]
    #[serde(rename = "wildcardFileName", default, skip_serializing_if = "Option::is_none")]
    pub wildcard_file_name: Option<serde_json::Value>,
    #[doc = "Indicates whether to enable partition discovery."]
    #[serde(rename = "enablePartitionDiscovery", default, skip_serializing_if = "Option::is_none")]
    pub enable_partition_discovery: Option<bool>,
    #[doc = "Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionRootPath", default, skip_serializing_if = "Option::is_none")]
    pub partition_root_path: Option<serde_json::Value>,
    #[doc = "Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string)."]
    #[serde(rename = "fileListPath", default, skip_serializing_if = "Option::is_none")]
    pub file_list_path: Option<serde_json::Value>,
    #[doc = "Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "deleteFilesAfterCompletion", default, skip_serializing_if = "Option::is_none")]
    pub delete_files_after_completion: Option<serde_json::Value>,
    #[doc = "The start of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeStart", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_start: Option<serde_json::Value>,
    #[doc = "The end of file's modified datetime. Type: string (or Expression with resultType string)."]
    #[serde(rename = "modifiedDatetimeEnd", default, skip_serializing_if = "Option::is_none")]
    pub modified_datetime_end: Option<serde_json::Value>,
}
impl SftpReadSettings {
    pub fn new(store_read_settings: StoreReadSettings) -> Self {
        Self {
            store_read_settings,
            recursive: None,
            wildcard_folder_path: None,
            wildcard_file_name: None,
            enable_partition_discovery: None,
            partition_root_path: None,
            file_list_path: None,
            delete_files_after_completion: None,
            modified_datetime_start: None,
            modified_datetime_end: None,
        }
    }
}
#[doc = "A linked service for an SSH File Transfer Protocol (SFTP) server. "]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SftpServerLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Properties specific to this linked service type."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SftpServerLinkedServiceTypeProperties,
}
impl SftpServerLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SftpServerLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Properties specific to this linked service type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SftpServerLinkedServiceTypeProperties {
    #[doc = "The SFTP server host name. Type: string (or Expression with resultType string)."]
    pub host: serde_json::Value,
    #[doc = "The TCP port number that the SFTP server uses to listen for client connections. Default value is 22. Type: integer (or Expression with resultType integer), minimum: 0."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<serde_json::Value>,
    #[doc = "The authentication type to be used to connect to the FTP server."]
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<sftp_server_linked_service_type_properties::AuthenticationType>,
    #[doc = "The username used to log on to the SFTP server. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
    #[doc = "The SSH private key file path for SshPublicKey authentication. Only valid for on-premises copy. For on-premises copy with SshPublicKey authentication, either PrivateKeyPath or PrivateKeyContent should be specified. SSH private key should be OpenSSH format. Type: string (or Expression with resultType string)."]
    #[serde(rename = "privateKeyPath", default, skip_serializing_if = "Option::is_none")]
    pub private_key_path: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "privateKeyContent", default, skip_serializing_if = "Option::is_none")]
    pub private_key_content: Option<SecretBase>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "passPhrase", default, skip_serializing_if = "Option::is_none")]
    pub pass_phrase: Option<SecretBase>,
    #[doc = "If true, skip the SSH host key validation. Default value is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "skipHostKeyValidation", default, skip_serializing_if = "Option::is_none")]
    pub skip_host_key_validation: Option<serde_json::Value>,
    #[doc = "The host key finger-print of the SFTP server. When SkipHostKeyValidation is false, HostKeyFingerprint should be specified. Type: string (or Expression with resultType string)."]
    #[serde(rename = "hostKeyFingerprint", default, skip_serializing_if = "Option::is_none")]
    pub host_key_fingerprint: Option<serde_json::Value>,
}
impl SftpServerLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value) -> Self {
        Self {
            host,
            port: None,
            authentication_type: None,
            user_name: None,
            password: None,
            encrypted_credential: None,
            private_key_path: None,
            private_key_content: None,
            pass_phrase: None,
            skip_host_key_validation: None,
            host_key_fingerprint: None,
        }
    }
}
pub mod sftp_server_linked_service_type_properties {
    use super::*;
    #[doc = "The authentication type to be used to connect to the FTP server."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        SshPublicKey,
    }
}
#[doc = "Sftp write settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SftpWriteSettings {
    #[serde(flatten)]
    pub store_write_settings: StoreWriteSettings,
    #[doc = "Specifies the timeout for writing each chunk to SFTP server. Default value: 01:00:00 (one hour). Type: string (or Expression with resultType string)."]
    #[serde(rename = "operationTimeout", default, skip_serializing_if = "Option::is_none")]
    pub operation_timeout: Option<serde_json::Value>,
    #[doc = "Upload to temporary file(s) and rename. Disable this option if your SFTP server doesn't support rename operation. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "useTempFileRename", default, skip_serializing_if = "Option::is_none")]
    pub use_temp_file_rename: Option<serde_json::Value>,
}
impl SftpWriteSettings {
    pub fn new(store_write_settings: StoreWriteSettings) -> Self {
        Self {
            store_write_settings,
            operation_timeout: None,
            use_temp_file_rename: None,
        }
    }
}
#[doc = "Sharepoint online list dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SharePointOnlineListDatasetTypeProperties {
    #[doc = "The name of the SharePoint Online list. Type: string (or Expression with resultType string)."]
    #[serde(rename = "listName", default, skip_serializing_if = "Option::is_none")]
    pub list_name: Option<serde_json::Value>,
}
impl SharePointOnlineListDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SharePoint Online List linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SharePointOnlineListLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "SharePoint Online List linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SharePointOnlineListLinkedServiceTypeProperties,
}
impl SharePointOnlineListLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SharePointOnlineListLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "SharePoint Online List linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SharePointOnlineListLinkedServiceTypeProperties {
    #[doc = "The URL of the SharePoint Online site. For example, https://contoso.sharepoint.com/sites/siteName. Type: string (or Expression with resultType string)."]
    #[serde(rename = "siteUrl")]
    pub site_url: serde_json::Value,
    #[doc = "The tenant ID under which your application resides. You can find it from Azure portal Active Directory overview page. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tenantId")]
    pub tenant_id: serde_json::Value,
    #[doc = "The application (client) ID of your application registered in Azure Active Directory. Make sure to grant SharePoint site permission to this application. Type: string (or Expression with resultType string)."]
    #[serde(rename = "servicePrincipalId")]
    pub service_principal_id: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "servicePrincipalKey")]
    pub service_principal_key: SecretBase,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SharePointOnlineListLinkedServiceTypeProperties {
    pub fn new(
        site_url: serde_json::Value,
        tenant_id: serde_json::Value,
        service_principal_id: serde_json::Value,
        service_principal_key: SecretBase,
    ) -> Self {
        Self {
            site_url,
            tenant_id,
            service_principal_id,
            service_principal_key,
            encrypted_credential: None,
        }
    }
}
#[doc = "The sharepoint online list resource dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SharePointOnlineListResourceDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Sharepoint online list dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SharePointOnlineListDatasetTypeProperties>,
}
impl SharePointOnlineListResourceDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity source for sharePoint online list source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SharePointOnlineListSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "The OData query to filter the data in SharePoint Online list. For example, \"$top=1\". Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "The wait time to get a response from SharePoint Online. Default value is 5 minutes (00:05:00). Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "httpRequestTimeout", default, skip_serializing_if = "Option::is_none")]
    pub http_request_timeout: Option<serde_json::Value>,
}
impl SharePointOnlineListSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            http_request_timeout: None,
        }
    }
}
#[doc = "Shopify Service linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShopifyLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Shopify Service linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: ShopifyLinkedServiceTypeProperties,
}
impl ShopifyLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: ShopifyLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Shopify Service linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShopifyLinkedServiceTypeProperties {
    #[doc = "The endpoint of the Shopify server. (i.e. mystore.myshopify.com)"]
    pub host: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "accessToken", default, skip_serializing_if = "Option::is_none")]
    pub access_token: Option<SecretBase>,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[doc = "Specifies whether to verify the identity of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl ShopifyLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value) -> Self {
        Self {
            host,
            access_token: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Shopify Service dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShopifyObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl ShopifyObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Shopify Service source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShopifySource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl ShopifySource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Skip error file."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SkipErrorFile {
    #[doc = "Skip if file is deleted by other client during copy. Default is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "fileMissing", default, skip_serializing_if = "Option::is_none")]
    pub file_missing: Option<serde_json::Value>,
    #[doc = "Skip if source/sink file changed by other concurrent write. Default is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "dataInconsistency", default, skip_serializing_if = "Option::is_none")]
    pub data_inconsistency: Option<serde_json::Value>,
}
impl SkipErrorFile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SQL pool SKU"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Sku {
    #[doc = "The service tier"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tier: Option<String>,
    #[doc = "The SKU name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capacity: Option<i32>,
}
impl Sku {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The snowflake dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnowflakeDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Snowflake dataset properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SnowflakeDatasetTypeProperties,
}
impl SnowflakeDataset {
    pub fn new(dataset: Dataset, type_properties: SnowflakeDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "Snowflake dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SnowflakeDatasetTypeProperties {
    #[doc = "The schema name of the Snowflake database. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[doc = "The table name of the Snowflake database. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl SnowflakeDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Snowflake export command settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnowflakeExportCopyCommand {
    #[serde(flatten)]
    pub export_settings: ExportSettings,
    #[doc = "Additional copy options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: \"additionalCopyOptions\": { \"DATE_FORMAT\": \"MM/DD/YYYY\", \"TIME_FORMAT\": \"'HH24:MI:SS.FF'\" }"]
    #[serde(rename = "additionalCopyOptions", default, skip_serializing_if = "Option::is_none")]
    pub additional_copy_options: Option<serde_json::Value>,
    #[doc = "Additional format options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: \"additionalFormatOptions\": { \"OVERWRITE\": \"TRUE\", \"MAX_FILE_SIZE\": \"'FALSE'\" }"]
    #[serde(rename = "additionalFormatOptions", default, skip_serializing_if = "Option::is_none")]
    pub additional_format_options: Option<serde_json::Value>,
}
impl SnowflakeExportCopyCommand {
    pub fn new(export_settings: ExportSettings) -> Self {
        Self {
            export_settings,
            additional_copy_options: None,
            additional_format_options: None,
        }
    }
}
#[doc = "Snowflake import command settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnowflakeImportCopyCommand {
    #[serde(flatten)]
    pub import_settings: ImportSettings,
    #[doc = "Additional copy options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: \"additionalCopyOptions\": { \"DATE_FORMAT\": \"MM/DD/YYYY\", \"TIME_FORMAT\": \"'HH24:MI:SS.FF'\" }"]
    #[serde(rename = "additionalCopyOptions", default, skip_serializing_if = "Option::is_none")]
    pub additional_copy_options: Option<serde_json::Value>,
    #[doc = "Additional format options directly passed to snowflake Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: \"additionalFormatOptions\": { \"FORCE\": \"TRUE\", \"LOAD_UNCERTAIN_FILES\": \"'FALSE'\" }"]
    #[serde(rename = "additionalFormatOptions", default, skip_serializing_if = "Option::is_none")]
    pub additional_format_options: Option<serde_json::Value>,
}
impl SnowflakeImportCopyCommand {
    pub fn new(import_settings: ImportSettings) -> Self {
        Self {
            import_settings,
            additional_copy_options: None,
            additional_format_options: None,
        }
    }
}
#[doc = "Snowflake linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnowflakeLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Snowflake linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SnowflakeLinkedServiceTypeProperties,
}
impl SnowflakeLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SnowflakeLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Snowflake linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnowflakeLinkedServiceTypeProperties {
    #[doc = "The connection string of snowflake. Type: string, SecureString."]
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<AzureKeyVaultSecretReference>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SnowflakeLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "A copy activity snowflake sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnowflakeSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "SQL pre-copy script. Type: string (or Expression with resultType string)."]
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
    #[doc = "Snowflake import command settings."]
    #[serde(rename = "importSettings", default, skip_serializing_if = "Option::is_none")]
    pub import_settings: Option<SnowflakeImportCopyCommand>,
}
impl SnowflakeSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
            import_settings: None,
        }
    }
}
#[doc = "A copy activity snowflake source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SnowflakeSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Snowflake Sql query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "Snowflake export command settings."]
    #[serde(rename = "exportSettings", default, skip_serializing_if = "Option::is_none")]
    pub export_settings: Option<SnowflakeExportCopyCommand>,
}
impl SnowflakeSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query: None,
            export_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SparkBatchJob {
    #[serde(rename = "livyInfo", default, skip_serializing_if = "Option::is_none")]
    pub livy_info: Option<SparkBatchJobState>,
    #[doc = "The batch name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The workspace name."]
    #[serde(rename = "workspaceName", default, skip_serializing_if = "Option::is_none")]
    pub workspace_name: Option<String>,
    #[doc = "The Spark pool name."]
    #[serde(rename = "sparkPoolName", default, skip_serializing_if = "Option::is_none")]
    pub spark_pool_name: Option<String>,
    #[doc = "The submitter name."]
    #[serde(rename = "submitterName", default, skip_serializing_if = "Option::is_none")]
    pub submitter_name: Option<String>,
    #[doc = "The submitter identifier."]
    #[serde(rename = "submitterId", default, skip_serializing_if = "Option::is_none")]
    pub submitter_id: Option<String>,
    #[doc = "The artifact identifier."]
    #[serde(rename = "artifactId", default, skip_serializing_if = "Option::is_none")]
    pub artifact_id: Option<String>,
    #[doc = "The job type."]
    #[serde(rename = "jobType", default, skip_serializing_if = "Option::is_none")]
    pub job_type: Option<spark_batch_job::JobType>,
    #[doc = "The Spark batch job result."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub result: Option<spark_batch_job::Result>,
    #[serde(rename = "schedulerInfo", default, skip_serializing_if = "Option::is_none")]
    pub scheduler_info: Option<SparkScheduler>,
    #[serde(rename = "pluginInfo", default, skip_serializing_if = "Option::is_none")]
    pub plugin_info: Option<SparkServicePlugin>,
    #[doc = "The error information."]
    #[serde(rename = "errorInfo", default, skip_serializing_if = "Vec::is_empty")]
    pub error_info: Vec<SparkServiceError>,
    #[doc = "The tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "The session Id."]
    pub id: i32,
    #[doc = "The application id of this session"]
    #[serde(rename = "appId", default, skip_serializing_if = "Option::is_none")]
    pub app_id: Option<String>,
    #[doc = "The detailed application info."]
    #[serde(rename = "appInfo", default, skip_serializing_if = "Option::is_none")]
    pub app_info: Option<serde_json::Value>,
    #[doc = "The batch state"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[doc = "The log lines."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub log: Vec<String>,
}
impl SparkBatchJob {
    pub fn new(id: i32) -> Self {
        Self {
            livy_info: None,
            name: None,
            workspace_name: None,
            spark_pool_name: None,
            submitter_name: None,
            submitter_id: None,
            artifact_id: None,
            job_type: None,
            result: None,
            scheduler_info: None,
            plugin_info: None,
            error_info: Vec::new(),
            tags: None,
            id,
            app_id: None,
            app_info: None,
            state: None,
            log: Vec::new(),
        }
    }
}
pub mod spark_batch_job {
    use super::*;
    #[doc = "The job type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum JobType {
        SparkBatch,
        SparkSession,
    }
    #[doc = "The Spark batch job result."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Result {
        Uncertain,
        Succeeded,
        Failed,
        Cancelled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SparkBatchJobState {
    #[doc = "the time that at which \"not_started\" livy state was first seen."]
    #[serde(rename = "notStartedAt", default, skip_serializing_if = "Option::is_none")]
    pub not_started_at: Option<String>,
    #[doc = "the time that at which \"starting\" livy state was first seen."]
    #[serde(rename = "startingAt", default, skip_serializing_if = "Option::is_none")]
    pub starting_at: Option<String>,
    #[doc = "the time that at which \"running\" livy state was first seen."]
    #[serde(rename = "runningAt", default, skip_serializing_if = "Option::is_none")]
    pub running_at: Option<String>,
    #[doc = "time that at which \"dead\" livy state was first seen."]
    #[serde(rename = "deadAt", default, skip_serializing_if = "Option::is_none")]
    pub dead_at: Option<String>,
    #[doc = "the time that at which \"success\" livy state was first seen."]
    #[serde(rename = "successAt", default, skip_serializing_if = "Option::is_none")]
    pub success_at: Option<String>,
    #[doc = "the time that at which \"killed\" livy state was first seen."]
    #[serde(rename = "killedAt", default, skip_serializing_if = "Option::is_none")]
    pub killed_at: Option<String>,
    #[doc = "the time that at which \"recovering\" livy state was first seen."]
    #[serde(rename = "recoveringAt", default, skip_serializing_if = "Option::is_none")]
    pub recovering_at: Option<String>,
    #[doc = "the Spark job state."]
    #[serde(rename = "currentState", default, skip_serializing_if = "Option::is_none")]
    pub current_state: Option<String>,
    #[serde(rename = "jobCreationRequest", default, skip_serializing_if = "Option::is_none")]
    pub job_creation_request: Option<SparkRequest>,
}
impl SparkBatchJobState {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Spark Properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SparkDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The table name of the Spark. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[doc = "The schema name of the Spark. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl SparkDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Spark job definition."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SparkJobDefinition {
    #[doc = "The description of the Spark job definition."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Big data pool reference."]
    #[serde(rename = "targetBigDataPool")]
    pub target_big_data_pool: BigDataPoolReference,
    #[doc = "The required Spark version of the application."]
    #[serde(rename = "requiredSparkVersion", default, skip_serializing_if = "Option::is_none")]
    pub required_spark_version: Option<String>,
    #[doc = "The language of the Spark application."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub language: Option<String>,
    #[doc = "The properties of the Spark job."]
    #[serde(rename = "jobProperties")]
    pub job_properties: SparkJobProperties,
}
impl SparkJobDefinition {
    pub fn new(target_big_data_pool: BigDataPoolReference, job_properties: SparkJobProperties) -> Self {
        Self {
            description: None,
            target_big_data_pool,
            required_spark_version: None,
            language: None,
            job_properties,
        }
    }
}
#[doc = "Spark job definition resource type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SparkJobDefinitionResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Spark job definition."]
    pub properties: SparkJobDefinition,
}
impl SparkJobDefinitionResource {
    pub fn new(properties: SparkJobDefinition) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[doc = "A list of spark job definitions resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SparkJobDefinitionsListResponse {
    #[doc = "List of spark job definitions."]
    pub value: Vec<SparkJobDefinitionResource>,
    #[doc = "The link to the next page of results, if any remaining results exist."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SparkJobDefinitionsListResponse {
    pub fn new(value: Vec<SparkJobDefinitionResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "The properties of the Spark job."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SparkJobProperties {
    #[doc = "The name of the job."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "File containing the application to execute."]
    pub file: String,
    #[doc = "Main class for Java/Scala application."]
    #[serde(rename = "className", default, skip_serializing_if = "Option::is_none")]
    pub class_name: Option<String>,
    #[doc = "Spark configuration properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub conf: Option<serde_json::Value>,
    #[doc = "Command line arguments for the application."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub args: Vec<String>,
    #[doc = "Jars to be used in this job."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub jars: Vec<String>,
    #[doc = "files to be used in this job."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub files: Vec<String>,
    #[doc = "Archives to be used in this job."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub archives: Vec<String>,
    #[doc = "Amount of memory to use for the driver process."]
    #[serde(rename = "driverMemory")]
    pub driver_memory: String,
    #[doc = "Number of cores to use for the driver."]
    #[serde(rename = "driverCores")]
    pub driver_cores: i64,
    #[doc = "Amount of memory to use per executor process."]
    #[serde(rename = "executorMemory")]
    pub executor_memory: String,
    #[doc = "Number of cores to use for each executor."]
    #[serde(rename = "executorCores")]
    pub executor_cores: i64,
    #[doc = "Number of executors to launch for this job."]
    #[serde(rename = "numExecutors")]
    pub num_executors: i64,
}
impl SparkJobProperties {
    pub fn new(
        file: String,
        driver_memory: String,
        driver_cores: i64,
        executor_memory: String,
        executor_cores: i64,
        num_executors: i64,
    ) -> Self {
        Self {
            name: None,
            file,
            class_name: None,
            conf: None,
            args: Vec::new(),
            jars: Vec::new(),
            files: Vec::new(),
            archives: Vec::new(),
            driver_memory,
            driver_cores,
            executor_memory,
            executor_cores,
            num_executors,
        }
    }
}
#[doc = "Spark Server linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SparkLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Spark Server linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SparkLinkedServiceTypeProperties,
}
impl SparkLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SparkLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Spark Server linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SparkLinkedServiceTypeProperties {
    #[doc = "IP address or host name of the Spark server"]
    pub host: serde_json::Value,
    #[doc = "The TCP port that the Spark server uses to listen for client connections."]
    pub port: serde_json::Value,
    #[doc = "The type of Spark server."]
    #[serde(rename = "serverType", default, skip_serializing_if = "Option::is_none")]
    pub server_type: Option<spark_linked_service_type_properties::ServerType>,
    #[doc = "The transport protocol to use in the Thrift layer."]
    #[serde(rename = "thriftTransportProtocol", default, skip_serializing_if = "Option::is_none")]
    pub thrift_transport_protocol: Option<spark_linked_service_type_properties::ThriftTransportProtocol>,
    #[doc = "The authentication method used to access the Spark server."]
    #[serde(rename = "authenticationType")]
    pub authentication_type: spark_linked_service_type_properties::AuthenticationType,
    #[doc = "The user name that you use to access Spark Server."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The partial URL corresponding to the Spark server."]
    #[serde(rename = "httpPath", default, skip_serializing_if = "Option::is_none")]
    pub http_path: Option<serde_json::Value>,
    #[doc = "Specifies whether the connections to the server are encrypted using SSL. The default value is false."]
    #[serde(rename = "enableSsl", default, skip_serializing_if = "Option::is_none")]
    pub enable_ssl: Option<serde_json::Value>,
    #[doc = "The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR."]
    #[serde(rename = "trustedCertPath", default, skip_serializing_if = "Option::is_none")]
    pub trusted_cert_path: Option<serde_json::Value>,
    #[doc = "Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false."]
    #[serde(rename = "useSystemTrustStore", default, skip_serializing_if = "Option::is_none")]
    pub use_system_trust_store: Option<serde_json::Value>,
    #[doc = "Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false."]
    #[serde(rename = "allowHostNameCNMismatch", default, skip_serializing_if = "Option::is_none")]
    pub allow_host_name_cn_mismatch: Option<serde_json::Value>,
    #[doc = "Specifies whether to allow self-signed certificates from the server. The default value is false."]
    #[serde(rename = "allowSelfSignedServerCert", default, skip_serializing_if = "Option::is_none")]
    pub allow_self_signed_server_cert: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SparkLinkedServiceTypeProperties {
    pub fn new(
        host: serde_json::Value,
        port: serde_json::Value,
        authentication_type: spark_linked_service_type_properties::AuthenticationType,
    ) -> Self {
        Self {
            host,
            port,
            server_type: None,
            thrift_transport_protocol: None,
            authentication_type,
            username: None,
            password: None,
            http_path: None,
            enable_ssl: None,
            trusted_cert_path: None,
            use_system_trust_store: None,
            allow_host_name_cn_mismatch: None,
            allow_self_signed_server_cert: None,
            encrypted_credential: None,
        }
    }
}
pub mod spark_linked_service_type_properties {
    use super::*;
    #[doc = "The type of Spark server."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ServerType {
        SharkServer,
        SharkServer2,
        SparkThriftServer,
    }
    #[doc = "The transport protocol to use in the Thrift layer."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ThriftTransportProtocol {
        Binary,
        #[serde(rename = "SASL")]
        Sasl,
        #[serde(rename = "HTTP ")]
        Http,
    }
    #[doc = "The authentication method used to access the Spark server."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Anonymous,
        Username,
        UsernameAndPassword,
        #[serde(rename = "WindowsAzureHDInsightService")]
        WindowsAzureHdInsightService,
    }
}
#[doc = "Spark Server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SparkObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Spark Properties"]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SparkDatasetTypeProperties>,
}
impl SparkObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SparkRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub file: Option<String>,
    #[serde(rename = "className", default, skip_serializing_if = "Option::is_none")]
    pub class_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub args: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub jars: Vec<String>,
    #[serde(rename = "pyFiles", default, skip_serializing_if = "Vec::is_empty")]
    pub py_files: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub files: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub archives: Vec<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub conf: Option<serde_json::Value>,
    #[serde(rename = "driverMemory", default, skip_serializing_if = "Option::is_none")]
    pub driver_memory: Option<String>,
    #[serde(rename = "driverCores", default, skip_serializing_if = "Option::is_none")]
    pub driver_cores: Option<i32>,
    #[serde(rename = "executorMemory", default, skip_serializing_if = "Option::is_none")]
    pub executor_memory: Option<String>,
    #[serde(rename = "executorCores", default, skip_serializing_if = "Option::is_none")]
    pub executor_cores: Option<i32>,
    #[serde(rename = "numExecutors", default, skip_serializing_if = "Option::is_none")]
    pub num_executors: Option<i32>,
}
impl SparkRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SparkScheduler {
    #[serde(rename = "submittedAt", default, skip_serializing_if = "Option::is_none")]
    pub submitted_at: Option<String>,
    #[serde(rename = "scheduledAt", default, skip_serializing_if = "Option::is_none")]
    pub scheduled_at: Option<String>,
    #[serde(rename = "endedAt", default, skip_serializing_if = "Option::is_none")]
    pub ended_at: Option<String>,
    #[serde(rename = "cancellationRequestedAt", default, skip_serializing_if = "Option::is_none")]
    pub cancellation_requested_at: Option<String>,
    #[serde(rename = "currentState", default, skip_serializing_if = "Option::is_none")]
    pub current_state: Option<spark_scheduler::CurrentState>,
}
impl SparkScheduler {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod spark_scheduler {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CurrentState {
        Queued,
        Scheduled,
        Ended,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SparkServiceError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<spark_service_error::Source>,
}
impl SparkServiceError {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod spark_service_error {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Source {
        System,
        User,
        Unknown,
        Dependency,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SparkServicePlugin {
    #[serde(rename = "preparationStartedAt", default, skip_serializing_if = "Option::is_none")]
    pub preparation_started_at: Option<String>,
    #[serde(rename = "resourceAcquisitionStartedAt", default, skip_serializing_if = "Option::is_none")]
    pub resource_acquisition_started_at: Option<String>,
    #[serde(rename = "submissionStartedAt", default, skip_serializing_if = "Option::is_none")]
    pub submission_started_at: Option<String>,
    #[serde(rename = "monitoringStartedAt", default, skip_serializing_if = "Option::is_none")]
    pub monitoring_started_at: Option<String>,
    #[serde(rename = "cleanupStartedAt", default, skip_serializing_if = "Option::is_none")]
    pub cleanup_started_at: Option<String>,
    #[serde(rename = "currentState", default, skip_serializing_if = "Option::is_none")]
    pub current_state: Option<spark_service_plugin::CurrentState>,
}
impl SparkServicePlugin {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod spark_service_plugin {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CurrentState {
        Preparation,
        ResourceAcquisition,
        Queued,
        Submission,
        Monitoring,
        Cleanup,
        Ended,
    }
}
#[doc = "A copy activity Spark Server source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SparkSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl SparkSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "The connection used to execute the SQL script."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlConnection {
    #[doc = "The type of the connection."]
    #[serde(rename = "type")]
    pub type_: sql_connection::Type,
    #[doc = "The identifier of the connection."]
    pub name: String,
}
impl SqlConnection {
    pub fn new(type_: sql_connection::Type, name: String) -> Self {
        Self { type_, name }
    }
}
pub mod sql_connection {
    use super::*;
    #[doc = "The type of the connection."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SqlOnDemand,
        SqlPool,
    }
}
#[doc = "A copy activity SQL Data Warehouse sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDwSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "SQL pre-copy script. Type: string (or Expression with resultType string)."]
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
    #[doc = "Indicates to use PolyBase to copy data into SQL Data Warehouse when applicable. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "allowPolyBase", default, skip_serializing_if = "Option::is_none")]
    pub allow_poly_base: Option<serde_json::Value>,
    #[doc = "PolyBase settings."]
    #[serde(rename = "polyBaseSettings", default, skip_serializing_if = "Option::is_none")]
    pub poly_base_settings: Option<PolybaseSettings>,
    #[doc = "Indicates to use Copy Command to copy data into SQL Data Warehouse. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "allowCopyCommand", default, skip_serializing_if = "Option::is_none")]
    pub allow_copy_command: Option<serde_json::Value>,
    #[doc = "DW Copy Command settings."]
    #[serde(rename = "copyCommandSettings", default, skip_serializing_if = "Option::is_none")]
    pub copy_command_settings: Option<DwCopyCommandSettings>,
    #[doc = "The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableOption", default, skip_serializing_if = "Option::is_none")]
    pub table_option: Option<serde_json::Value>,
}
impl SqlDwSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            pre_copy_script: None,
            allow_poly_base: None,
            poly_base_settings: None,
            allow_copy_command: None,
            copy_command_settings: None,
            table_option: None,
        }
    }
}
#[doc = "A copy activity SQL Data Warehouse source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlDwSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "SQL Data Warehouse reader query. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlReaderQuery", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_query: Option<serde_json::Value>,
    #[doc = "Name of the stored procedure for a SQL Data Warehouse source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlReaderStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_stored_procedure_name: Option<serde_json::Value>,
    #[doc = "Value and type setting for stored procedure parameters. Example: \"{Parameter1: {value: \"1\", type: \"int\"}}\". Type: object (or Expression with resultType object), itemType: StoredProcedureParameter."]
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[doc = "The partition mechanism that will be used for Sql read in parallel. Possible values include: \"None\", \"PhysicalPartitionsOfTable\", \"DynamicRange\"."]
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[doc = "The settings that will be leveraged for Sql source partitioning."]
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<SqlPartitionSettings>,
}
impl SqlDwSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            sql_reader_query: None,
            sql_reader_stored_procedure_name: None,
            stored_procedure_parameters: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
#[doc = "A copy activity Azure SQL Managed Instance sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlMiSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "SQL writer stored procedure name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlWriterStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_stored_procedure_name: Option<serde_json::Value>,
    #[doc = "SQL writer table type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlWriterTableType", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_table_type: Option<serde_json::Value>,
    #[doc = "SQL pre-copy script. Type: string (or Expression with resultType string)."]
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
    #[doc = "SQL stored procedure parameters."]
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[doc = "The stored procedure parameter name of the table type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "storedProcedureTableTypeParameterName", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_table_type_parameter_name: Option<serde_json::Value>,
    #[doc = "The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableOption", default, skip_serializing_if = "Option::is_none")]
    pub table_option: Option<serde_json::Value>,
}
impl SqlMiSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            sql_writer_stored_procedure_name: None,
            sql_writer_table_type: None,
            pre_copy_script: None,
            stored_procedure_parameters: None,
            stored_procedure_table_type_parameter_name: None,
            table_option: None,
        }
    }
}
#[doc = "A copy activity Azure SQL Managed Instance source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlMiSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "SQL reader query. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlReaderQuery", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_query: Option<serde_json::Value>,
    #[doc = "Name of the stored procedure for a Azure SQL Managed Instance source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlReaderStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_stored_procedure_name: Option<serde_json::Value>,
    #[doc = "Value and type setting for stored procedure parameters. Example: \"{Parameter1: {value: \"1\", type: \"int\"}}\"."]
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[doc = "Which additional types to produce."]
    #[serde(rename = "produceAdditionalTypes", default, skip_serializing_if = "Option::is_none")]
    pub produce_additional_types: Option<serde_json::Value>,
    #[doc = "The partition mechanism that will be used for Sql read in parallel. Possible values include: \"None\", \"PhysicalPartitionsOfTable\", \"DynamicRange\"."]
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[doc = "The settings that will be leveraged for Sql source partitioning."]
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<SqlPartitionSettings>,
}
impl SqlMiSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            sql_reader_query: None,
            sql_reader_stored_procedure_name: None,
            stored_procedure_parameters: None,
            produce_additional_types: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
#[doc = "The partition mechanism that will be used for Sql read in parallel."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SqlPartitionOption {
    None,
    PhysicalPartitionsOfTable,
    DynamicRange,
}
#[doc = "The settings that will be leveraged for Sql source partitioning."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlPartitionSettings {
    #[doc = "The name of the column in integer or datetime type that will be used for proceeding partitioning. If not specified, the primary key of the table is auto-detected and used as the partition column. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionColumnName", default, skip_serializing_if = "Option::is_none")]
    pub partition_column_name: Option<serde_json::Value>,
    #[doc = "The maximum value of the partition column for partition range splitting. This value is used to decide the partition stride, not for filtering the rows in table. All rows in the table or query result will be partitioned and copied. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionUpperBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_upper_bound: Option<serde_json::Value>,
    #[doc = "The minimum value of the partition column for partition range splitting. This value is used to decide the partition stride, not for filtering the rows in table. All rows in the table or query result will be partitioned and copied. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionLowerBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_lower_bound: Option<serde_json::Value>,
}
impl SqlPartitionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A SQL Analytics pool"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlPool {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "SQL pool SKU"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<Sku>,
    #[doc = "Properties of a SQL Analytics pool"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<SqlPoolResourceProperties>,
}
impl SqlPool {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            sku: None,
            properties: None,
        }
    }
}
#[doc = "List of SQL pools"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlPoolInfoListResult {
    #[doc = "Link to the next page of results"]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[doc = "List of SQL pools"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SqlPool>,
}
impl SqlPoolInfoListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "SQL pool reference type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlPoolReference {
    #[doc = "SQL pool reference type."]
    #[serde(rename = "type")]
    pub type_: sql_pool_reference::Type,
    #[doc = "Reference SQL pool name."]
    #[serde(rename = "referenceName")]
    pub reference_name: String,
}
impl SqlPoolReference {
    pub fn new(type_: sql_pool_reference::Type, reference_name: String) -> Self {
        Self { type_, reference_name }
    }
}
pub mod sql_pool_reference {
    use super::*;
    #[doc = "SQL pool reference type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SqlPoolReference,
    }
}
#[doc = "Properties of a SQL Analytics pool"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlPoolResourceProperties {
    #[doc = "Maximum size in bytes"]
    #[serde(rename = "maxSizeBytes", default, skip_serializing_if = "Option::is_none")]
    pub max_size_bytes: Option<i64>,
    #[doc = "Collation mode"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub collation: Option<String>,
    #[doc = "Source database to create from"]
    #[serde(rename = "sourceDatabaseId", default, skip_serializing_if = "Option::is_none")]
    pub source_database_id: Option<String>,
    #[doc = "Backup database to restore from"]
    #[serde(rename = "recoverableDatabaseId", default, skip_serializing_if = "Option::is_none")]
    pub recoverable_database_id: Option<String>,
    #[doc = "Resource state"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "Resource status"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "Snapshot time to restore"]
    #[serde(rename = "restorePointInTime", default, skip_serializing_if = "Option::is_none")]
    pub restore_point_in_time: Option<String>,
    #[doc = "Specifies the mode of sql pool creation.\n\nDefault: regular sql pool creation.\n\nPointInTimeRestore: Creates a sql pool by restoring a point in time backup of an existing sql pool. sourceDatabaseId must be specified as the resource ID of the existing sql pool, and restorePointInTime must be specified.\n\nRecovery: Creates a sql pool by a geo-replicated backup. sourceDatabaseId  must be specified as the recoverableDatabaseId to restore.\n\nRestore: Creates a sql pool by restoring a backup of a deleted sql  pool. SourceDatabaseId should be the sql pool's original resource ID. SourceDatabaseId and sourceDatabaseDeletionDate must be specified."]
    #[serde(rename = "createMode", default, skip_serializing_if = "Option::is_none")]
    pub create_mode: Option<sql_pool_resource_properties::CreateMode>,
    #[doc = "Date the SQL pool was created"]
    #[serde(rename = "creationDate", default, skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
}
impl SqlPoolResourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod sql_pool_resource_properties {
    use super::*;
    #[doc = "Specifies the mode of sql pool creation.\n\nDefault: regular sql pool creation.\n\nPointInTimeRestore: Creates a sql pool by restoring a point in time backup of an existing sql pool. sourceDatabaseId must be specified as the resource ID of the existing sql pool, and restorePointInTime must be specified.\n\nRecovery: Creates a sql pool by a geo-replicated backup. sourceDatabaseId  must be specified as the recoverableDatabaseId to restore.\n\nRestore: Creates a sql pool by restoring a backup of a deleted sql  pool. SourceDatabaseId should be the sql pool's original resource ID. SourceDatabaseId and sourceDatabaseDeletionDate must be specified."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CreateMode {
        Default,
        PointInTimeRestore,
        Recovery,
        Restore,
    }
}
#[doc = "Execute SQL pool stored procedure activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlPoolStoredProcedureActivity {
    #[serde(flatten)]
    pub activity: Activity,
    #[doc = "SQL pool reference type."]
    #[serde(rename = "sqlPool")]
    pub sql_pool: SqlPoolReference,
    #[doc = "SQL stored procedure activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SqlPoolStoredProcedureActivityTypeProperties,
}
impl SqlPoolStoredProcedureActivity {
    pub fn new(activity: Activity, sql_pool: SqlPoolReference, type_properties: SqlPoolStoredProcedureActivityTypeProperties) -> Self {
        Self {
            activity,
            sql_pool,
            type_properties,
        }
    }
}
#[doc = "SQL stored procedure activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlPoolStoredProcedureActivityTypeProperties {
    #[doc = "Stored procedure name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "storedProcedureName")]
    pub stored_procedure_name: serde_json::Value,
    #[doc = "Value and type setting for stored procedure parameters. Example: \"{Parameter1: {value: \"1\", type: \"int\"}}\"."]
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
}
impl SqlPoolStoredProcedureActivityTypeProperties {
    pub fn new(stored_procedure_name: serde_json::Value) -> Self {
        Self {
            stored_procedure_name,
            stored_procedure_parameters: None,
        }
    }
}
#[doc = "SQL script."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlScript {
    #[doc = "The description of the SQL script."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "The type of the SQL script."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<sql_script::Type>,
    #[doc = "The content of the SQL script."]
    pub content: SqlScriptContent,
}
impl SqlScript {
    pub fn new(content: SqlScriptContent) -> Self {
        Self {
            description: None,
            type_: None,
            content,
        }
    }
}
pub mod sql_script {
    use super::*;
    #[doc = "The type of the SQL script."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SqlQuery,
    }
}
#[doc = "The content of the SQL script."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlScriptContent {
    #[doc = "SQL query to execute."]
    pub query: String,
    #[doc = "The connection used to execute the SQL script."]
    #[serde(rename = "currentConnection")]
    pub current_connection: SqlConnection,
    #[doc = "The metadata of the SQL script."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<SqlScriptMetadata>,
}
impl SqlScriptContent {
    pub fn new(query: String, current_connection: SqlConnection) -> Self {
        Self {
            query,
            current_connection,
            metadata: None,
        }
    }
}
#[doc = "The metadata of the SQL script."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlScriptMetadata {
    #[doc = "The language of the SQL script."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub language: Option<String>,
}
impl SqlScriptMetadata {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Sql Script resource type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlScriptResource {
    #[doc = "Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[doc = "The name of the resource"]
    pub name: String,
    #[doc = "The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "Resource Etag."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[doc = "SQL script."]
    pub properties: SqlScript,
}
impl SqlScriptResource {
    pub fn new(name: String, properties: SqlScript) -> Self {
        Self {
            id: None,
            name,
            type_: None,
            etag: None,
            properties,
        }
    }
}
#[doc = "A list of sql scripts resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlScriptsListResponse {
    #[doc = "List of sql scripts."]
    pub value: Vec<SqlScriptResource>,
    #[doc = "The link to the next page of results, if any remaining results exist."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SqlScriptsListResponse {
    pub fn new(value: Vec<SqlScriptResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "SQL Server linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "SQL Server linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SqlServerLinkedServiceTypeProperties,
}
impl SqlServerLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SqlServerLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "SQL Server linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerLinkedServiceTypeProperties {
    #[doc = "The connection string. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString")]
    pub connection_string: serde_json::Value,
    #[doc = "The on-premises Windows authentication user name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SqlServerLinkedServiceTypeProperties {
    pub fn new(connection_string: serde_json::Value) -> Self {
        Self {
            connection_string,
            user_name: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "A copy activity SQL server sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "SQL writer stored procedure name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlWriterStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_stored_procedure_name: Option<serde_json::Value>,
    #[doc = "SQL writer table type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlWriterTableType", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_table_type: Option<serde_json::Value>,
    #[doc = "SQL pre-copy script. Type: string (or Expression with resultType string)."]
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
    #[doc = "SQL stored procedure parameters."]
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[doc = "The stored procedure parameter name of the table type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "storedProcedureTableTypeParameterName", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_table_type_parameter_name: Option<serde_json::Value>,
    #[doc = "The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableOption", default, skip_serializing_if = "Option::is_none")]
    pub table_option: Option<serde_json::Value>,
}
impl SqlServerSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            sql_writer_stored_procedure_name: None,
            sql_writer_table_type: None,
            pre_copy_script: None,
            stored_procedure_parameters: None,
            stored_procedure_table_type_parameter_name: None,
            table_option: None,
        }
    }
}
#[doc = "A copy activity SQL server source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "SQL reader query. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlReaderQuery", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_query: Option<serde_json::Value>,
    #[doc = "Name of the stored procedure for a SQL Database source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlReaderStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_stored_procedure_name: Option<serde_json::Value>,
    #[doc = "Value and type setting for stored procedure parameters. Example: \"{Parameter1: {value: \"1\", type: \"int\"}}\"."]
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[doc = "Which additional types to produce."]
    #[serde(rename = "produceAdditionalTypes", default, skip_serializing_if = "Option::is_none")]
    pub produce_additional_types: Option<serde_json::Value>,
    #[doc = "The partition mechanism that will be used for Sql read in parallel. Possible values include: \"None\", \"PhysicalPartitionsOfTable\", \"DynamicRange\"."]
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[doc = "The settings that will be leveraged for Sql source partitioning."]
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<SqlPartitionSettings>,
}
impl SqlServerSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            sql_reader_query: None,
            sql_reader_stored_procedure_name: None,
            stored_procedure_parameters: None,
            produce_additional_types: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
#[doc = "SQL stored procedure activity type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerStoredProcedureActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "SQL stored procedure activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SqlServerStoredProcedureActivityTypeProperties,
}
impl SqlServerStoredProcedureActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: SqlServerStoredProcedureActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "SQL stored procedure activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerStoredProcedureActivityTypeProperties {
    #[doc = "Stored procedure name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "storedProcedureName")]
    pub stored_procedure_name: serde_json::Value,
    #[doc = "Value and type setting for stored procedure parameters. Example: \"{Parameter1: {value: \"1\", type: \"int\"}}\"."]
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
}
impl SqlServerStoredProcedureActivityTypeProperties {
    pub fn new(stored_procedure_name: serde_json::Value) -> Self {
        Self {
            stored_procedure_name,
            stored_procedure_parameters: None,
        }
    }
}
#[doc = "The on-premises SQL Server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "On-premises SQL Server dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SqlServerTableDatasetTypeProperties>,
}
impl SqlServerTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "On-premises SQL Server dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlServerTableDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The schema name of the SQL Server dataset. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[doc = "The table name of the SQL Server dataset. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl SqlServerTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A copy activity SQL sink."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlSink {
    #[serde(flatten)]
    pub copy_sink: CopySink,
    #[doc = "SQL writer stored procedure name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlWriterStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_stored_procedure_name: Option<serde_json::Value>,
    #[doc = "SQL writer table type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlWriterTableType", default, skip_serializing_if = "Option::is_none")]
    pub sql_writer_table_type: Option<serde_json::Value>,
    #[doc = "SQL pre-copy script. Type: string (or Expression with resultType string)."]
    #[serde(rename = "preCopyScript", default, skip_serializing_if = "Option::is_none")]
    pub pre_copy_script: Option<serde_json::Value>,
    #[doc = "SQL stored procedure parameters."]
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[doc = "The stored procedure parameter name of the table type. Type: string (or Expression with resultType string)."]
    #[serde(rename = "storedProcedureTableTypeParameterName", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_table_type_parameter_name: Option<serde_json::Value>,
    #[doc = "The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableOption", default, skip_serializing_if = "Option::is_none")]
    pub table_option: Option<serde_json::Value>,
}
impl SqlSink {
    pub fn new(copy_sink: CopySink) -> Self {
        Self {
            copy_sink,
            sql_writer_stored_procedure_name: None,
            sql_writer_table_type: None,
            pre_copy_script: None,
            stored_procedure_parameters: None,
            stored_procedure_table_type_parameter_name: None,
            table_option: None,
        }
    }
}
#[doc = "A copy activity SQL source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "SQL reader query. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlReaderQuery", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_query: Option<serde_json::Value>,
    #[doc = "Name of the stored procedure for a SQL Database source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression with resultType string)."]
    #[serde(rename = "sqlReaderStoredProcedureName", default, skip_serializing_if = "Option::is_none")]
    pub sql_reader_stored_procedure_name: Option<serde_json::Value>,
    #[doc = "Value and type setting for stored procedure parameters. Example: \"{Parameter1: {value: \"1\", type: \"int\"}}\"."]
    #[serde(rename = "storedProcedureParameters", default, skip_serializing_if = "Option::is_none")]
    pub stored_procedure_parameters: Option<serde_json::Value>,
    #[doc = "Specifies the transaction locking behavior for the SQL source. Allowed values: ReadCommitted/ReadUncommitted/RepeatableRead/Serializable/Snapshot. The default value is ReadCommitted. Type: string (or Expression with resultType string)."]
    #[serde(rename = "isolationLevel", default, skip_serializing_if = "Option::is_none")]
    pub isolation_level: Option<serde_json::Value>,
    #[doc = "The partition mechanism that will be used for Sql read in parallel. Possible values include: \"None\", \"PhysicalPartitionsOfTable\", \"DynamicRange\"."]
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<serde_json::Value>,
    #[doc = "The settings that will be leveraged for Sql source partitioning."]
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<SqlPartitionSettings>,
}
impl SqlSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            sql_reader_query: None,
            sql_reader_stored_procedure_name: None,
            stored_procedure_parameters: None,
            isolation_level: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
#[doc = "Square Service linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SquareLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Square Service linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SquareLinkedServiceTypeProperties,
}
impl SquareLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SquareLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Square Service linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SquareLinkedServiceTypeProperties {
    #[doc = "Properties used to connect to Square. It is mutually exclusive with any other properties in the linked service. Type: object."]
    #[serde(rename = "connectionProperties", default, skip_serializing_if = "Option::is_none")]
    pub connection_properties: Option<serde_json::Value>,
    #[doc = "The URL\u{a0}of the Square instance. (i.e. mystore.mysquare.com)"]
    pub host: serde_json::Value,
    #[doc = "The client ID associated with your Square application."]
    #[serde(rename = "clientId")]
    pub client_id: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<SecretBase>,
    #[doc = "The redirect URL assigned in the Square application dashboard. (i.e. http://localhost:2500)"]
    #[serde(rename = "redirectUri")]
    pub redirect_uri: serde_json::Value,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[doc = "Specifies whether to verify the identity of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SquareLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value, client_id: serde_json::Value, redirect_uri: serde_json::Value) -> Self {
        Self {
            connection_properties: None,
            host,
            client_id,
            client_secret: None,
            redirect_uri,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Square Service dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SquareObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl SquareObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Square Service source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SquareSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl SquareSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "The status of the operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SsisObjectMetadataStatusResponse {
    #[doc = "The status of the operation."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[doc = "The operation name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "The operation properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<String>,
    #[doc = "The operation error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<String>,
}
impl SsisObjectMetadataStatusResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Staging settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StagingSettings {
    #[doc = "Linked service reference type."]
    #[serde(rename = "linkedServiceName")]
    pub linked_service_name: LinkedServiceReference,
    #[doc = "The path to storage for storing the interim data. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<serde_json::Value>,
    #[doc = "Specifies whether to use compression when copying data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "enableCompression", default, skip_serializing_if = "Option::is_none")]
    pub enable_compression: Option<serde_json::Value>,
}
impl StagingSettings {
    pub fn new(linked_service_name: LinkedServiceReference) -> Self {
        Self {
            linked_service_name,
            path: None,
            enable_compression: None,
        }
    }
}
#[doc = "Request body structure for starting data flow debug session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StartDataFlowDebugSessionRequest {
    #[doc = "The ID of data flow debug session."]
    #[serde(rename = "sessionId", default, skip_serializing_if = "Option::is_none")]
    pub session_id: Option<String>,
    #[doc = "Data flow resource type."]
    #[serde(rename = "dataFlow", default, skip_serializing_if = "Option::is_none")]
    pub data_flow: Option<DataFlowResource>,
    #[doc = "List of Data flows"]
    #[serde(rename = "dataFlows", default, skip_serializing_if = "Vec::is_empty")]
    pub data_flows: Vec<DataFlowResource>,
    #[doc = "List of datasets."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub datasets: Vec<DatasetResource>,
    #[doc = "List of linked services."]
    #[serde(rename = "linkedServices", default, skip_serializing_if = "Vec::is_empty")]
    pub linked_services: Vec<LinkedServiceResource>,
    #[doc = "Staging info for debug session."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub staging: Option<serde_json::Value>,
    #[doc = "Data flow debug settings."]
    #[serde(rename = "debugSettings", default, skip_serializing_if = "Option::is_none")]
    pub debug_settings: Option<serde_json::Value>,
    #[doc = "The type of new Databricks cluster."]
    #[serde(rename = "incrementalDebug", default, skip_serializing_if = "Option::is_none")]
    pub incremental_debug: Option<bool>,
}
impl StartDataFlowDebugSessionRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Response body structure for starting data flow debug session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StartDataFlowDebugSessionResponse {
    #[doc = "The ID of data flow debug job version."]
    #[serde(rename = "jobVersion", default, skip_serializing_if = "Option::is_none")]
    pub job_version: Option<String>,
}
impl StartDataFlowDebugSessionResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Connector read setting."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StoreReadSettings {
    #[doc = "The read setting type."]
    #[serde(rename = "type")]
    pub type_: String,
    #[doc = "The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "maxConcurrentConnections", default, skip_serializing_if = "Option::is_none")]
    pub max_concurrent_connections: Option<serde_json::Value>,
}
impl StoreReadSettings {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            max_concurrent_connections: None,
        }
    }
}
#[doc = "Connector write settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StoreWriteSettings {
    #[doc = "The write setting type."]
    #[serde(rename = "type")]
    pub type_: String,
    #[doc = "The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "maxConcurrentConnections", default, skip_serializing_if = "Option::is_none")]
    pub max_concurrent_connections: Option<serde_json::Value>,
    #[doc = "The type of copy behavior for copy sink."]
    #[serde(rename = "copyBehavior", default, skip_serializing_if = "Option::is_none")]
    pub copy_behavior: Option<serde_json::Value>,
}
impl StoreWriteSettings {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            max_concurrent_connections: None,
            copy_behavior: None,
        }
    }
}
#[doc = "SQL stored procedure parameter."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StoredProcedureParameter {
    #[doc = "Stored procedure parameter value. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<serde_json::Value>,
    #[doc = "Stored procedure parameter type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<StoredProcedureParameterType>,
}
impl StoredProcedureParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Stored procedure parameter type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum StoredProcedureParameterType {
    String,
    Int,
    Int64,
    Decimal,
    Guid,
    Boolean,
    Date,
}
#[doc = "Azure Synapse nested resource, which belongs to a workspace."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResource {
    #[serde(flatten)]
    pub azure_entity_resource: AzureEntityResource,
}
impl SubResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Azure Synapse nested debug resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubResourceDebugResource {
    #[doc = "The resource name."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl SubResourceDebugResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This activity evaluates an expression and executes activities under the cases property that correspond to the expression evaluation expected in the equals property."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SwitchActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[doc = "Switch activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SwitchActivityTypeProperties,
}
impl SwitchActivity {
    pub fn new(control_activity: ControlActivity, type_properties: SwitchActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[doc = "Switch activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SwitchActivityTypeProperties {
    #[doc = "Azure Synapse expression definition."]
    pub on: Expression,
    #[doc = "List of cases that correspond to expected values of the 'on' property. This is an optional property and if not provided, the activity will execute activities provided in defaultActivities."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub cases: Vec<SwitchCase>,
    #[doc = "List of activities to execute if no case condition is satisfied. This is an optional property and if not provided, the activity will exit without any action."]
    #[serde(rename = "defaultActivities", default, skip_serializing_if = "Vec::is_empty")]
    pub default_activities: Vec<Activity>,
}
impl SwitchActivityTypeProperties {
    pub fn new(on: Expression) -> Self {
        Self {
            on,
            cases: Vec::new(),
            default_activities: Vec::new(),
        }
    }
}
#[doc = "Switch cases with have a value and corresponding activities."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SwitchCase {
    #[doc = "Expected value that satisfies the expression result of the 'on' property."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    #[doc = "List of activities to execute for satisfied case condition."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub activities: Vec<Activity>,
}
impl SwitchCase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Linked service for Sybase data source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SybaseLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Sybase linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SybaseLinkedServiceTypeProperties,
}
impl SybaseLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: SybaseLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Sybase linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SybaseLinkedServiceTypeProperties {
    #[doc = "Server name for connection. Type: string (or Expression with resultType string)."]
    pub server: serde_json::Value,
    #[doc = "Database name for connection. Type: string (or Expression with resultType string)."]
    pub database: serde_json::Value,
    #[doc = "Schema name for connection. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
    #[doc = "AuthenticationType to be used for connection."]
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<sybase_linked_service_type_properties::AuthenticationType>,
    #[doc = "Username for authentication. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl SybaseLinkedServiceTypeProperties {
    pub fn new(server: serde_json::Value, database: serde_json::Value) -> Self {
        Self {
            server,
            database,
            schema: None,
            authentication_type: None,
            username: None,
            password: None,
            encrypted_credential: None,
        }
    }
}
pub mod sybase_linked_service_type_properties {
    use super::*;
    #[doc = "AuthenticationType to be used for connection."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        Windows,
    }
}
#[doc = "A copy activity source for Sybase databases."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SybaseSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "Database query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl SybaseSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "The Sybase table dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SybaseTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Sybase table dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<SybaseTableDatasetTypeProperties>,
}
impl SybaseTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Sybase table dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SybaseTableDatasetTypeProperties {
    #[doc = "The Sybase table name. Type: string (or Expression with resultType string)."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
}
impl SybaseTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Execute Synapse notebook activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SynapseNotebookActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Execute Synapse notebook activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SynapseNotebookActivityTypeProperties,
}
impl SynapseNotebookActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: SynapseNotebookActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "Execute Synapse notebook activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SynapseNotebookActivityTypeProperties {
    #[doc = "Synapse notebook reference type."]
    pub notebook: SynapseNotebookReference,
    #[doc = "An object mapping parameter names to argument values."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterValueSpecification>,
}
impl SynapseNotebookActivityTypeProperties {
    pub fn new(notebook: SynapseNotebookReference) -> Self {
        Self {
            notebook,
            parameters: None,
        }
    }
}
#[doc = "Synapse notebook reference type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SynapseNotebookReference {
    #[doc = "Synapse notebook reference type."]
    #[serde(rename = "type")]
    pub type_: synapse_notebook_reference::Type,
    #[doc = "Reference notebook name."]
    #[serde(rename = "referenceName")]
    pub reference_name: String,
}
impl SynapseNotebookReference {
    pub fn new(type_: synapse_notebook_reference::Type, reference_name: String) -> Self {
        Self { type_, reference_name }
    }
}
pub mod synapse_notebook_reference {
    use super::*;
    #[doc = "Synapse notebook reference type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        NotebookReference,
    }
}
#[doc = "Execute spark job activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SynapseSparkJobActivityTypeProperties {
    #[doc = "Synapse spark job reference type."]
    #[serde(rename = "sparkJob")]
    pub spark_job: SynapseSparkJobReference,
    #[doc = "User specified arguments to SynapseSparkJobDefinitionActivity."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub args: Vec<serde_json::Value>,
}
impl SynapseSparkJobActivityTypeProperties {
    pub fn new(spark_job: SynapseSparkJobReference) -> Self {
        Self {
            spark_job,
            args: Vec::new(),
        }
    }
}
#[doc = "Execute spark job activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SynapseSparkJobDefinitionActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Execute spark job activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: SynapseSparkJobActivityTypeProperties,
}
impl SynapseSparkJobDefinitionActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: SynapseSparkJobActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "Synapse spark job reference type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SynapseSparkJobReference {
    #[doc = "Synapse spark job reference type."]
    #[serde(rename = "type")]
    pub type_: synapse_spark_job_reference::Type,
    #[doc = "Reference spark job name."]
    #[serde(rename = "referenceName")]
    pub reference_name: String,
}
impl SynapseSparkJobReference {
    pub fn new(type_: synapse_spark_job_reference::Type, reference_name: String) -> Self {
        Self { type_, reference_name }
    }
}
pub mod synapse_spark_job_reference {
    use super::*;
    #[doc = "Synapse spark job reference type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SparkJobDefinitionReference,
    }
}
#[doc = "Copy activity sources of tabular type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TabularSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Query timeout. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(rename = "queryTimeout", default, skip_serializing_if = "Option::is_none")]
    pub query_timeout: Option<serde_json::Value>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl TabularSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            query_timeout: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "A copy activity tabular translator."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TabularTranslator {
    #[serde(flatten)]
    pub copy_translator: CopyTranslator,
    #[doc = "Column mappings. Example: \"UserId: MyUserId, Group: MyGroup, Name: MyName\" Type: string (or Expression with resultType string). This property will be retired. Please use mappings property."]
    #[serde(rename = "columnMappings", default, skip_serializing_if = "Option::is_none")]
    pub column_mappings: Option<serde_json::Value>,
    #[doc = "The schema mapping to map between tabular data and hierarchical data. Example: {\"Column1\": \"$.Column1\", \"Column2\": \"$.Column2.Property1\", \"Column3\": \"$.Column2.Property2\"}. Type: object (or Expression with resultType object). This property will be retired. Please use mappings property."]
    #[serde(rename = "schemaMapping", default, skip_serializing_if = "Option::is_none")]
    pub schema_mapping: Option<serde_json::Value>,
    #[doc = "The JSON Path of the Nested Array that is going to do cross-apply. Type: object (or Expression with resultType object)."]
    #[serde(rename = "collectionReference", default, skip_serializing_if = "Option::is_none")]
    pub collection_reference: Option<serde_json::Value>,
    #[doc = "Whether to map complex (array and object) values to simple strings in json format. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "mapComplexValuesToString", default, skip_serializing_if = "Option::is_none")]
    pub map_complex_values_to_string: Option<serde_json::Value>,
    #[doc = "Column mappings with logical types. Tabular->tabular example: [{\"source\":{\"name\":\"CustomerName\",\"type\":\"String\"},\"sink\":{\"name\":\"ClientName\",\"type\":\"String\"}},{\"source\":{\"name\":\"CustomerAddress\",\"type\":\"String\"},\"sink\":{\"name\":\"ClientAddress\",\"type\":\"String\"}}].  Hierarchical->tabular example: [{\"source\":{\"path\":\"$.CustomerName\",\"type\":\"String\"},\"sink\":{\"name\":\"ClientName\",\"type\":\"String\"}},{\"source\":{\"path\":\"$.CustomerAddress\",\"type\":\"String\"},\"sink\":{\"name\":\"ClientAddress\",\"type\":\"String\"}}]. Type: object (or Expression with resultType object)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub mappings: Option<serde_json::Value>,
    #[doc = "Whether to enable the advanced type conversion feature in the Copy activity. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "typeConversion", default, skip_serializing_if = "Option::is_none")]
    pub type_conversion: Option<serde_json::Value>,
    #[doc = "Type conversion settings"]
    #[serde(rename = "typeConversionSettings", default, skip_serializing_if = "Option::is_none")]
    pub type_conversion_settings: Option<TypeConversionSettings>,
}
impl TabularTranslator {
    pub fn new(copy_translator: CopyTranslator) -> Self {
        Self {
            copy_translator,
            column_mappings: None,
            schema_mapping: None,
            collection_reference: None,
            map_complex_values_to_string: None,
            mappings: None,
            type_conversion: None,
            type_conversion_settings: None,
        }
    }
}
#[doc = "The TarGZip compression read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TarGZipReadSettings {
    #[serde(flatten)]
    pub compression_read_settings: CompressionReadSettings,
    #[doc = "Preserve the compression file name as folder path. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "preserveCompressionFileNameAsFolder", default, skip_serializing_if = "Option::is_none")]
    pub preserve_compression_file_name_as_folder: Option<serde_json::Value>,
}
impl TarGZipReadSettings {
    pub fn new(compression_read_settings: CompressionReadSettings) -> Self {
        Self {
            compression_read_settings,
            preserve_compression_file_name_as_folder: None,
        }
    }
}
#[doc = "The Tar compression read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TarReadSettings {
    #[serde(flatten)]
    pub compression_read_settings: CompressionReadSettings,
    #[doc = "Preserve the compression file name as folder path. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "preserveCompressionFileNameAsFolder", default, skip_serializing_if = "Option::is_none")]
    pub preserve_compression_file_name_as_folder: Option<serde_json::Value>,
}
impl TarReadSettings {
    pub fn new(compression_read_settings: CompressionReadSettings) -> Self {
        Self {
            compression_read_settings,
            preserve_compression_file_name_as_folder: None,
        }
    }
}
#[doc = "Linked service for Teradata data source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TeradataLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Teradata linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: TeradataLinkedServiceTypeProperties,
}
impl TeradataLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: TeradataLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Teradata linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TeradataLinkedServiceTypeProperties {
    #[doc = "Teradata ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[doc = "Server name for connection. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub server: Option<serde_json::Value>,
    #[doc = "AuthenticationType to be used for connection."]
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<teradata_linked_service_type_properties::AuthenticationType>,
    #[doc = "Username for authentication. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<serde_json::Value>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl TeradataLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod teradata_linked_service_type_properties {
    use super::*;
    #[doc = "AuthenticationType to be used for connection."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        Windows,
    }
}
#[doc = "The partition mechanism that will be used for teradata read in parallel."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TeradataPartitionOption {
    None,
    Hash,
    DynamicRange,
}
#[doc = "The settings that will be leveraged for teradata source partitioning."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TeradataPartitionSettings {
    #[doc = "The name of the column that will be used for proceeding range or hash partitioning. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionColumnName", default, skip_serializing_if = "Option::is_none")]
    pub partition_column_name: Option<serde_json::Value>,
    #[doc = "The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionUpperBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_upper_bound: Option<serde_json::Value>,
    #[doc = "The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string)."]
    #[serde(rename = "partitionLowerBound", default, skip_serializing_if = "Option::is_none")]
    pub partition_lower_bound: Option<serde_json::Value>,
}
impl TeradataPartitionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A copy activity Teradata source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TeradataSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "Teradata query. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
    #[doc = "The partition mechanism that will be used for teradata read in parallel."]
    #[serde(rename = "partitionOption", default, skip_serializing_if = "Option::is_none")]
    pub partition_option: Option<teradata_source::PartitionOption>,
    #[doc = "The settings that will be leveraged for teradata source partitioning."]
    #[serde(rename = "partitionSettings", default, skip_serializing_if = "Option::is_none")]
    pub partition_settings: Option<TeradataPartitionSettings>,
}
impl TeradataSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
            partition_option: None,
            partition_settings: None,
        }
    }
}
pub mod teradata_source {
    use super::*;
    #[doc = "The partition mechanism that will be used for teradata read in parallel."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PartitionOption {
        None,
        Hash,
        DynamicRange,
    }
}
#[doc = "The Teradata database dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TeradataTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Teradata dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<TeradataTableDatasetTypeProperties>,
}
impl TeradataTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Teradata dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TeradataTableDatasetTypeProperties {
    #[doc = "The database name of Teradata. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub database: Option<serde_json::Value>,
    #[doc = "The table name of Teradata. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
}
impl TeradataTableDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "The data stored in text format."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TextFormat {
    #[serde(flatten)]
    pub dataset_storage_format: DatasetStorageFormat,
    #[doc = "The column delimiter. Type: string (or Expression with resultType string)."]
    #[serde(rename = "columnDelimiter", default, skip_serializing_if = "Option::is_none")]
    pub column_delimiter: Option<serde_json::Value>,
    #[doc = "The row delimiter. Type: string (or Expression with resultType string)."]
    #[serde(rename = "rowDelimiter", default, skip_serializing_if = "Option::is_none")]
    pub row_delimiter: Option<serde_json::Value>,
    #[doc = "The escape character. Type: string (or Expression with resultType string)."]
    #[serde(rename = "escapeChar", default, skip_serializing_if = "Option::is_none")]
    pub escape_char: Option<serde_json::Value>,
    #[doc = "The quote character. Type: string (or Expression with resultType string)."]
    #[serde(rename = "quoteChar", default, skip_serializing_if = "Option::is_none")]
    pub quote_char: Option<serde_json::Value>,
    #[doc = "The null value string. Type: string (or Expression with resultType string)."]
    #[serde(rename = "nullValue", default, skip_serializing_if = "Option::is_none")]
    pub null_value: Option<serde_json::Value>,
    #[doc = "The code page name of the preferred encoding. If miss, the default value is ΓÇ£utf-8ΓÇ¥, unless BOM denotes another Unicode encoding. Refer to the ΓÇ£NameΓÇ¥ column of the table in the following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encodingName", default, skip_serializing_if = "Option::is_none")]
    pub encoding_name: Option<serde_json::Value>,
    #[doc = "Treat empty column values in the text file as null. The default value is true. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "treatEmptyAsNull", default, skip_serializing_if = "Option::is_none")]
    pub treat_empty_as_null: Option<serde_json::Value>,
    #[doc = "The number of lines/rows to be skipped when parsing text files. The default value is 0. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "skipLineCount", default, skip_serializing_if = "Option::is_none")]
    pub skip_line_count: Option<serde_json::Value>,
    #[doc = "When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "firstRowAsHeader", default, skip_serializing_if = "Option::is_none")]
    pub first_row_as_header: Option<serde_json::Value>,
}
impl TextFormat {
    pub fn new(dataset_storage_format: DatasetStorageFormat) -> Self {
        Self {
            dataset_storage_format,
            column_delimiter: None,
            row_delimiter: None,
            escape_char: None,
            quote_char: None,
            null_value: None,
            encoding_name: None,
            treat_empty_as_null: None,
            skip_line_count: None,
            first_row_as_header: None,
        }
    }
}
#[doc = "The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TrackedResource {
    #[serde(flatten)]
    pub resource: Resource,
    #[doc = "Resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "The geo-location where the resource lives"]
    pub location: String,
}
impl TrackedResource {
    pub fn new(location: String) -> Self {
        Self {
            resource: Resource::default(),
            tags: None,
            location,
        }
    }
}
#[doc = "A data flow transformation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Transformation {
    #[doc = "Transformation name."]
    pub name: String,
    #[doc = "Transformation description."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Data flow reference type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub flowlet: Option<DataFlowReference>,
}
impl Transformation {
    pub fn new(name: String) -> Self {
        Self {
            name,
            description: None,
            flowlet: None,
        }
    }
}
#[doc = "Azure Synapse nested object which contains information about creating pipeline run"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Trigger {
    #[doc = "Trigger type."]
    #[serde(rename = "type")]
    pub type_: String,
    #[doc = "Trigger description."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[doc = "Enumerates possible state of Triggers."]
    #[serde(rename = "runtimeState", default, skip_serializing_if = "Option::is_none")]
    pub runtime_state: Option<TriggerRuntimeState>,
    #[doc = "List of tags that can be used for describing the trigger."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub annotations: Vec<serde_json::Value>,
}
impl Trigger {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            description: None,
            runtime_state: None,
            annotations: Vec::new(),
        }
    }
}
#[doc = "Defines the response of a provision trigger dependency operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggerDependencyProvisioningStatus {
    #[doc = "Trigger name."]
    #[serde(rename = "triggerName")]
    pub trigger_name: String,
    #[doc = "Provisioning status."]
    #[serde(rename = "provisioningStatus")]
    pub provisioning_status: String,
}
impl TriggerDependencyProvisioningStatus {
    pub fn new(trigger_name: String, provisioning_status: String) -> Self {
        Self {
            trigger_name,
            provisioning_status,
        }
    }
}
#[doc = "Trigger referenced dependency."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggerDependencyReference {
    #[serde(flatten)]
    pub dependency_reference: DependencyReference,
    #[doc = "Trigger reference type."]
    #[serde(rename = "referenceTrigger")]
    pub reference_trigger: TriggerReference,
}
impl TriggerDependencyReference {
    pub fn new(dependency_reference: DependencyReference, reference_trigger: TriggerReference) -> Self {
        Self {
            dependency_reference,
            reference_trigger,
        }
    }
}
#[doc = "A list of trigger resources."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggerListResponse {
    #[doc = "List of triggers."]
    pub value: Vec<TriggerResource>,
    #[doc = "The link to the next page of results, if any remaining results exist."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl TriggerListResponse {
    pub fn new(value: Vec<TriggerResource>) -> Self {
        Self { value, next_link: None }
    }
}
#[doc = "Pipeline that needs to be triggered with the given parameters."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggerPipelineReference {
    #[doc = "Pipeline reference type."]
    #[serde(rename = "pipelineReference", default, skip_serializing_if = "Option::is_none")]
    pub pipeline_reference: Option<PipelineReference>,
    #[doc = "An object mapping parameter names to argument values."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub parameters: Option<ParameterValueSpecification>,
}
impl TriggerPipelineReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Trigger reference type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggerReference {
    #[doc = "Trigger reference type."]
    #[serde(rename = "type")]
    pub type_: trigger_reference::Type,
    #[doc = "Reference trigger name."]
    #[serde(rename = "referenceName")]
    pub reference_name: String,
}
impl TriggerReference {
    pub fn new(type_: trigger_reference::Type, reference_name: String) -> Self {
        Self { type_, reference_name }
    }
}
pub mod trigger_reference {
    use super::*;
    #[doc = "Trigger reference type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        TriggerReference,
    }
}
#[doc = "Trigger resource type."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggerResource {
    #[serde(flatten)]
    pub sub_resource: SubResource,
    #[doc = "Azure Synapse nested object which contains information about creating pipeline run"]
    pub properties: Trigger,
}
impl TriggerResource {
    pub fn new(properties: Trigger) -> Self {
        Self {
            sub_resource: SubResource::default(),
            properties,
        }
    }
}
#[doc = "Trigger runs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggerRun {
    #[doc = "Trigger run id."]
    #[serde(rename = "triggerRunId", default, skip_serializing_if = "Option::is_none")]
    pub trigger_run_id: Option<String>,
    #[doc = "Trigger name."]
    #[serde(rename = "triggerName", default, skip_serializing_if = "Option::is_none")]
    pub trigger_name: Option<String>,
    #[doc = "Trigger type."]
    #[serde(rename = "triggerType", default, skip_serializing_if = "Option::is_none")]
    pub trigger_type: Option<String>,
    #[doc = "Trigger run start time."]
    #[serde(rename = "triggerRunTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub trigger_run_timestamp: Option<String>,
    #[doc = "Trigger run status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<trigger_run::Status>,
    #[doc = "Trigger error message."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[doc = "List of property name and value related to trigger run. Name, value pair depends on type of trigger."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[doc = "List of pipeline name and run Id triggered by the trigger run."]
    #[serde(rename = "triggeredPipelines", default, skip_serializing_if = "Option::is_none")]
    pub triggered_pipelines: Option<serde_json::Value>,
}
impl TriggerRun {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod trigger_run {
    use super::*;
    #[doc = "Trigger run status."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Succeeded,
        Failed,
        Inprogress,
    }
}
#[doc = "A list of trigger runs."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TriggerRunsQueryResponse {
    #[doc = "List of trigger runs."]
    pub value: Vec<TriggerRun>,
    #[doc = "The continuation token for getting the next page of results, if any remaining results exist, null otherwise."]
    #[serde(rename = "continuationToken", default, skip_serializing_if = "Option::is_none")]
    pub continuation_token: Option<String>,
}
impl TriggerRunsQueryResponse {
    pub fn new(value: Vec<TriggerRun>) -> Self {
        Self {
            value,
            continuation_token: None,
        }
    }
}
#[doc = "Enumerates possible state of Triggers."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TriggerRuntimeState {
    Started,
    Stopped,
    Disabled,
}
#[doc = "Defines the response of a trigger subscription operation."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggerSubscriptionOperationStatus {
    #[doc = "Trigger name."]
    #[serde(rename = "triggerName", default, skip_serializing_if = "Option::is_none")]
    pub trigger_name: Option<String>,
    #[doc = "Event Subscription Status."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<trigger_subscription_operation_status::Status>,
}
impl TriggerSubscriptionOperationStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod trigger_subscription_operation_status {
    use super::*;
    #[doc = "Event Subscription Status."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Enabled,
        Provisioning,
        Deprovisioning,
        Disabled,
        Unknown,
    }
}
#[doc = "Enumerates possible frequency option for the tumbling window trigger."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TumblingWindowFrequency {
    Minute,
    Hour,
    Month,
}
#[doc = "Trigger that schedules pipeline runs for all fixed time interval windows from a start time without gaps and also supports backfill scenarios (when start time is in the past)."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TumblingWindowTrigger {
    #[serde(flatten)]
    pub trigger: Trigger,
    #[doc = "Pipeline that needs to be triggered with the given parameters."]
    pub pipeline: TriggerPipelineReference,
    #[doc = "Tumbling Window Trigger properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: tumbling_window_trigger::TypeProperties,
}
impl TumblingWindowTrigger {
    pub fn new(trigger: Trigger, pipeline: TriggerPipelineReference, type_properties: tumbling_window_trigger::TypeProperties) -> Self {
        Self {
            trigger,
            pipeline,
            type_properties,
        }
    }
}
pub mod tumbling_window_trigger {
    use super::*;
    #[doc = "Tumbling Window Trigger properties."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub struct TypeProperties {
        #[doc = "Enumerates possible frequency option for the tumbling window trigger."]
        pub frequency: TumblingWindowFrequency,
        #[doc = "The interval of the time windows. The minimum interval allowed is 15 Minutes."]
        pub interval: i32,
        #[doc = "The start time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported."]
        #[serde(rename = "startTime")]
        pub start_time: String,
        #[doc = "The end time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported."]
        #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
        pub end_time: Option<String>,
        #[doc = "Specifies how long the trigger waits past due time before triggering new run. It doesn't alter window start and end time. The default is 0. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub delay: Option<serde_json::Value>,
        #[doc = "The max number of parallel time windows (ready for execution) for which a new run is triggered."]
        #[serde(rename = "maxConcurrency")]
        pub max_concurrency: i64,
        #[doc = "Execution policy for an activity."]
        #[serde(rename = "retryPolicy", default, skip_serializing_if = "Option::is_none")]
        pub retry_policy: Option<RetryPolicy>,
        #[doc = "Triggers that this trigger depends on. Only tumbling window triggers are supported."]
        #[serde(rename = "dependsOn", default, skip_serializing_if = "Vec::is_empty")]
        pub depends_on: Vec<DependencyReference>,
    }
    impl TypeProperties {
        pub fn new(frequency: TumblingWindowFrequency, interval: i32, start_time: String, max_concurrency: i64) -> Self {
            Self {
                frequency,
                interval,
                start_time,
                end_time: None,
                delay: None,
                max_concurrency,
                retry_policy: None,
                depends_on: Vec::new(),
            }
        }
    }
}
#[doc = "Referenced tumbling window trigger dependency."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TumblingWindowTriggerDependencyReference {
    #[serde(flatten)]
    pub trigger_dependency_reference: TriggerDependencyReference,
    #[doc = "Timespan applied to the start time of a tumbling window when evaluating dependency."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub offset: Option<String>,
    #[doc = "The size of the window when evaluating the dependency. If undefined the frequency of the tumbling window will be used."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<String>,
}
impl TumblingWindowTriggerDependencyReference {
    pub fn new(trigger_dependency_reference: TriggerDependencyReference) -> Self {
        Self {
            trigger_dependency_reference,
            offset: None,
            size: None,
        }
    }
}
#[doc = "Type conversion settings"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TypeConversionSettings {
    #[doc = "Whether to allow data truncation when converting the data. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "allowDataTruncation", default, skip_serializing_if = "Option::is_none")]
    pub allow_data_truncation: Option<serde_json::Value>,
    #[doc = "Whether to treat boolean values as numbers. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "treatBooleanAsNumber", default, skip_serializing_if = "Option::is_none")]
    pub treat_boolean_as_number: Option<serde_json::Value>,
    #[doc = "The format for DateTime values. Type: string (or Expression with resultType string)."]
    #[serde(rename = "dateTimeFormat", default, skip_serializing_if = "Option::is_none")]
    pub date_time_format: Option<serde_json::Value>,
    #[doc = "The format for DateTimeOffset values. Type: string (or Expression with resultType string)."]
    #[serde(rename = "dateTimeOffsetFormat", default, skip_serializing_if = "Option::is_none")]
    pub date_time_offset_format: Option<serde_json::Value>,
    #[doc = "The format for TimeSpan values. Type: string (or Expression with resultType string)."]
    #[serde(rename = "timeSpanFormat", default, skip_serializing_if = "Option::is_none")]
    pub time_span_format: Option<serde_json::Value>,
    #[doc = "The culture used to convert data from/to string. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub culture: Option<serde_json::Value>,
}
impl TypeConversionSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This activity executes inner activities until the specified boolean expression results to true or timeout is reached, whichever is earlier."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UntilActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[doc = "Until activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: UntilActivityTypeProperties,
}
impl UntilActivity {
    pub fn new(control_activity: ControlActivity, type_properties: UntilActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[doc = "Until activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UntilActivityTypeProperties {
    #[doc = "Azure Synapse expression definition."]
    pub expression: Expression,
    #[doc = "Specifies the timeout for the activity to run. If there is no value specified, it takes the value of TimeSpan.FromDays(7) which is 1 week as default. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])). Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<serde_json::Value>,
    #[doc = "List of activities to execute."]
    pub activities: Vec<Activity>,
}
impl UntilActivityTypeProperties {
    pub fn new(expression: Expression, activities: Vec<Activity>) -> Self {
        Self {
            expression,
            timeout: None,
            activities,
        }
    }
}
#[doc = "User property."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserProperty {
    #[doc = "User property name."]
    pub name: String,
    #[doc = "User property value. Type: string (or Expression with resultType string)."]
    pub value: serde_json::Value,
}
impl UserProperty {
    pub fn new(name: String, value: serde_json::Value) -> Self {
        Self { name, value }
    }
}
#[doc = "This activity verifies that an external resource exists."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ValidationActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[doc = "Validation activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: ValidationActivityTypeProperties,
}
impl ValidationActivity {
    pub fn new(control_activity: ControlActivity, type_properties: ValidationActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[doc = "Validation activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ValidationActivityTypeProperties {
    #[doc = "Specifies the timeout for the activity to run. If there is no value specified, it takes the value of TimeSpan.FromDays(7) which is 1 week as default. Type: string (or Expression with resultType string), pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<serde_json::Value>,
    #[doc = "A delay in seconds between validation attempts. If no value is specified, 10 seconds will be used as the default. Type: integer (or Expression with resultType integer)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sleep: Option<serde_json::Value>,
    #[doc = "Can be used if dataset points to a file. The file must be greater than or equal in size to the value specified. Type: integer (or Expression with resultType integer)."]
    #[serde(rename = "minimumSize", default, skip_serializing_if = "Option::is_none")]
    pub minimum_size: Option<serde_json::Value>,
    #[doc = "Can be used if dataset points to a folder. If set to true, the folder must have at least one file. If set to false, the folder must be empty. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "childItems", default, skip_serializing_if = "Option::is_none")]
    pub child_items: Option<serde_json::Value>,
    #[doc = "Dataset reference type."]
    pub dataset: DatasetReference,
}
impl ValidationActivityTypeProperties {
    pub fn new(dataset: DatasetReference) -> Self {
        Self {
            timeout: None,
            sleep: None,
            minimum_size: None,
            child_items: None,
            dataset,
        }
    }
}
#[doc = "Definition of variable for a Pipeline."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VariableDefinitionSpecification {}
impl VariableDefinitionSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Definition of a single variable for a Pipeline."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VariableSpecification {
    #[doc = "Variable type."]
    #[serde(rename = "type")]
    pub type_: variable_specification::Type,
    #[doc = "Default value of variable."]
    #[serde(rename = "defaultValue", default, skip_serializing_if = "Option::is_none")]
    pub default_value: Option<serde_json::Value>,
}
impl VariableSpecification {
    pub fn new(type_: variable_specification::Type) -> Self {
        Self {
            type_,
            default_value: None,
        }
    }
}
pub mod variable_specification {
    use super::*;
    #[doc = "Variable type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        String,
        Bool,
        Boolean,
        Array,
    }
}
#[doc = "Vertica Properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VerticaDatasetTypeProperties {
    #[doc = "This property will be retired. Please consider using schema + table properties instead."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<serde_json::Value>,
    #[doc = "The table name of the Vertica. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub table: Option<serde_json::Value>,
    #[doc = "The schema name of the Vertica. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}
impl VerticaDatasetTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Vertica linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VerticaLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Vertica linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: VerticaLinkedServiceTypeProperties,
}
impl VerticaLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: VerticaLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Vertica linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VerticaLinkedServiceTypeProperties {
    #[doc = "An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference."]
    #[serde(rename = "connectionString", default, skip_serializing_if = "Option::is_none")]
    pub connection_string: Option<serde_json::Value>,
    #[doc = "Azure Key Vault secret reference."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pwd: Option<AzureKeyVaultSecretReference>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl VerticaLinkedServiceTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A copy activity Vertica source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VerticaSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl VerticaSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Vertica dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VerticaTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Vertica Properties"]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<VerticaDatasetTypeProperties>,
}
impl VerticaTableDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Virtual Network Profile"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VirtualNetworkProfile {
    #[doc = "Subnet ID used for computes in workspace"]
    #[serde(rename = "computeSubnetId", default, skip_serializing_if = "Option::is_none")]
    pub compute_subnet_id: Option<String>,
}
impl VirtualNetworkProfile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "This activity suspends pipeline execution for the specified interval."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WaitActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[doc = "Wait activity properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: WaitActivityTypeProperties,
}
impl WaitActivity {
    pub fn new(control_activity: ControlActivity, type_properties: WaitActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[doc = "Wait activity properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WaitActivityTypeProperties {
    #[doc = "Duration in seconds."]
    #[serde(rename = "waitTimeInSeconds")]
    pub wait_time_in_seconds: serde_json::Value,
}
impl WaitActivityTypeProperties {
    pub fn new(wait_time_in_seconds: serde_json::Value) -> Self {
        Self { wait_time_in_seconds }
    }
}
#[doc = "Web activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebActivity {
    #[serde(flatten)]
    pub execution_activity: ExecutionActivity,
    #[doc = "Web activity type properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: WebActivityTypeProperties,
}
impl WebActivity {
    pub fn new(execution_activity: ExecutionActivity, type_properties: WebActivityTypeProperties) -> Self {
        Self {
            execution_activity,
            type_properties,
        }
    }
}
#[doc = "Web activity authentication properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebActivityAuthentication {
    #[doc = "Web activity authentication (Basic/ClientCertificate/MSI)"]
    #[serde(rename = "type")]
    pub type_: String,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pfx: Option<SecretBase>,
    #[doc = "Web activity authentication user name for basic authentication."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[doc = "The base definition of a secret type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<SecretBase>,
    #[doc = "Resource for which Azure Auth token will be requested when using MSI Authentication."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub resource: Option<String>,
}
impl WebActivityAuthentication {
    pub fn new(type_: String) -> Self {
        Self {
            type_,
            pfx: None,
            username: None,
            password: None,
            resource: None,
        }
    }
}
#[doc = "The list of HTTP methods supported by a WebActivity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum WebActivityMethod {
    #[serde(rename = "GET")]
    Get,
    #[serde(rename = "POST")]
    Post,
    #[serde(rename = "PUT")]
    Put,
    #[serde(rename = "DELETE")]
    Delete,
}
#[doc = "Web activity type properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebActivityTypeProperties {
    #[doc = "The list of HTTP methods supported by a WebActivity."]
    pub method: WebActivityMethod,
    #[doc = "Web activity target endpoint and path. Type: string (or Expression with resultType string)."]
    pub url: serde_json::Value,
    #[doc = "Represents the headers that will be sent to the request. For example, to set the language and type on a request: \"headers\" : { \"Accept-Language\": \"en-us\", \"Content-Type\": \"application/json\" }. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub headers: Option<serde_json::Value>,
    #[doc = "Represents the payload that will be sent to the endpoint. Required for POST/PUT method, not allowed for GET method Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<serde_json::Value>,
    #[doc = "Web activity authentication properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authentication: Option<WebActivityAuthentication>,
    #[doc = "List of datasets passed to web endpoint."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub datasets: Vec<DatasetReference>,
    #[doc = "List of linked services passed to web endpoint."]
    #[serde(rename = "linkedServices", default, skip_serializing_if = "Vec::is_empty")]
    pub linked_services: Vec<LinkedServiceReference>,
    #[doc = "Integration runtime reference type."]
    #[serde(rename = "connectVia", default, skip_serializing_if = "Option::is_none")]
    pub connect_via: Option<IntegrationRuntimeReference>,
}
impl WebActivityTypeProperties {
    pub fn new(method: WebActivityMethod, url: serde_json::Value) -> Self {
        Self {
            method,
            url,
            headers: None,
            body: None,
            authentication: None,
            datasets: Vec::new(),
            linked_services: Vec::new(),
            connect_via: None,
        }
    }
}
#[doc = "A WebLinkedService that uses anonymous authentication to communicate with an HTTP endpoint."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebAnonymousAuthentication {
    #[serde(flatten)]
    pub web_linked_service_type_properties: WebLinkedServiceTypeProperties,
}
impl WebAnonymousAuthentication {
    pub fn new(web_linked_service_type_properties: WebLinkedServiceTypeProperties) -> Self {
        Self {
            web_linked_service_type_properties,
        }
    }
}
#[doc = "A WebLinkedService that uses basic authentication to communicate with an HTTP endpoint."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebBasicAuthentication {
    #[serde(flatten)]
    pub web_linked_service_type_properties: WebLinkedServiceTypeProperties,
    #[doc = "User name for Basic authentication. Type: string (or Expression with resultType string)."]
    pub username: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    pub password: SecretBase,
}
impl WebBasicAuthentication {
    pub fn new(
        web_linked_service_type_properties: WebLinkedServiceTypeProperties,
        username: serde_json::Value,
        password: SecretBase,
    ) -> Self {
        Self {
            web_linked_service_type_properties,
            username,
            password,
        }
    }
}
#[doc = "A WebLinkedService that uses client certificate based authentication to communicate with an HTTP endpoint. This scheme follows mutual authentication; the server must also provide valid credentials to the client."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebClientCertificateAuthentication {
    #[serde(flatten)]
    pub web_linked_service_type_properties: WebLinkedServiceTypeProperties,
    #[doc = "The base definition of a secret type."]
    pub pfx: SecretBase,
    #[doc = "The base definition of a secret type."]
    pub password: SecretBase,
}
impl WebClientCertificateAuthentication {
    pub fn new(web_linked_service_type_properties: WebLinkedServiceTypeProperties, pfx: SecretBase, password: SecretBase) -> Self {
        Self {
            web_linked_service_type_properties,
            pfx,
            password,
        }
    }
}
#[doc = "WebHook activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebHookActivity {
    #[serde(flatten)]
    pub control_activity: ControlActivity,
    #[doc = "WebHook activity type properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: WebHookActivityTypeProperties,
}
impl WebHookActivity {
    pub fn new(control_activity: ControlActivity, type_properties: WebHookActivityTypeProperties) -> Self {
        Self {
            control_activity,
            type_properties,
        }
    }
}
#[doc = "The list of HTTP methods supported by a WebHook activity."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum WebHookActivityMethod {
    #[serde(rename = "POST")]
    Post,
}
#[doc = "WebHook activity type properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebHookActivityTypeProperties {
    #[doc = "The list of HTTP methods supported by a WebHook activity."]
    pub method: WebHookActivityMethod,
    #[doc = "WebHook activity target endpoint and path. Type: string (or Expression with resultType string)."]
    pub url: serde_json::Value,
    #[doc = "The timeout within which the webhook should be called back. If there is no value specified, it defaults to 10 minutes. Type: string. Pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9]))."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timeout: Option<String>,
    #[doc = "Represents the headers that will be sent to the request. For example, to set the language and type on a request: \"headers\" : { \"Accept-Language\": \"en-us\", \"Content-Type\": \"application/json\" }. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub headers: Option<serde_json::Value>,
    #[doc = "Represents the payload that will be sent to the endpoint. Required for POST/PUT method, not allowed for GET method Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<serde_json::Value>,
    #[doc = "Web activity authentication properties."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authentication: Option<WebActivityAuthentication>,
    #[doc = "When set to true, statusCode, output and error in callback request body will be consumed by activity. The activity can be marked as failed by setting statusCode >= 400 in callback request. Default is false. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "reportStatusOnCallBack", default, skip_serializing_if = "Option::is_none")]
    pub report_status_on_call_back: Option<serde_json::Value>,
}
impl WebHookActivityTypeProperties {
    pub fn new(method: WebHookActivityMethod, url: serde_json::Value) -> Self {
        Self {
            method,
            url,
            timeout: None,
            headers: None,
            body: None,
            authentication: None,
            report_status_on_call_back: None,
        }
    }
}
#[doc = "Web linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Base definition of WebLinkedServiceTypeProperties, this typeProperties is polymorphic based on authenticationType, so not flattened in SDK models."]
    #[serde(rename = "typeProperties")]
    pub type_properties: WebLinkedServiceTypeProperties,
}
impl WebLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: WebLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Base definition of WebLinkedServiceTypeProperties, this typeProperties is polymorphic based on authenticationType, so not flattened in SDK models."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebLinkedServiceTypeProperties {
    #[doc = "The URL of the web service endpoint, e.g. http://www.microsoft.com . Type: string (or Expression with resultType string)."]
    pub url: serde_json::Value,
    #[doc = "Type of authentication used to connect to the web table source."]
    #[serde(rename = "authenticationType")]
    pub authentication_type: web_linked_service_type_properties::AuthenticationType,
}
impl WebLinkedServiceTypeProperties {
    pub fn new(url: serde_json::Value, authentication_type: web_linked_service_type_properties::AuthenticationType) -> Self {
        Self { url, authentication_type }
    }
}
pub mod web_linked_service_type_properties {
    use super::*;
    #[doc = "Type of authentication used to connect to the web table source."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AuthenticationType {
        Basic,
        Anonymous,
        ClientCertificate,
    }
}
#[doc = "A copy activity source for web page table."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl WebSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "The dataset points to a HTML table in the web page."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebTableDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Web table dataset properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: WebTableDatasetTypeProperties,
}
impl WebTableDataset {
    pub fn new(dataset: Dataset, type_properties: WebTableDatasetTypeProperties) -> Self {
        Self { dataset, type_properties }
    }
}
#[doc = "Web table dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebTableDatasetTypeProperties {
    #[doc = "The zero-based index of the table in the web page. Type: integer (or Expression with resultType integer), minimum: 0."]
    pub index: serde_json::Value,
    #[doc = "The relative URL to the web page from the linked service URL. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<serde_json::Value>,
}
impl WebTableDatasetTypeProperties {
    pub fn new(index: serde_json::Value) -> Self {
        Self { index, path: None }
    }
}
#[doc = "A workspace"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Workspace {
    #[serde(flatten)]
    pub tracked_resource: TrackedResource,
    #[doc = "Workspace properties"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<WorkspaceProperties>,
    #[doc = "The workspace managed identity"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<ManagedIdentity>,
}
impl Workspace {
    pub fn new(tracked_resource: TrackedResource) -> Self {
        Self {
            tracked_resource,
            properties: None,
            identity: None,
        }
    }
}
#[doc = "Identity properties of the workspace resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WorkspaceIdentity {
    #[doc = "The identity type. Currently the only supported type is 'SystemAssigned'."]
    #[serde(rename = "type")]
    pub type_: workspace_identity::Type,
    #[doc = "The principal id of the identity."]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[doc = "The client tenant id of the identity."]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
}
impl WorkspaceIdentity {
    pub fn new(type_: workspace_identity::Type) -> Self {
        Self {
            type_,
            principal_id: None,
            tenant_id: None,
        }
    }
}
pub mod workspace_identity {
    use super::*;
    #[doc = "The identity type. Currently the only supported type is 'SystemAssigned'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        SystemAssigned,
    }
}
#[doc = "Details of the customer managed key associated with the workspace"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceKeyDetails {
    #[doc = "Workspace Key sub-resource name"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "Workspace Key sub-resource key vault url"]
    #[serde(rename = "keyVaultUrl", default, skip_serializing_if = "Option::is_none")]
    pub key_vault_url: Option<String>,
}
impl WorkspaceKeyDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Workspace properties"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceProperties {
    #[doc = "Details of the data lake storage account associated with the workspace"]
    #[serde(rename = "defaultDataLakeStorage", default, skip_serializing_if = "Option::is_none")]
    pub default_data_lake_storage: Option<DataLakeStorageAccountDetails>,
    #[doc = "SQL administrator login password"]
    #[serde(rename = "sqlAdministratorLoginPassword", default, skip_serializing_if = "Option::is_none")]
    pub sql_administrator_login_password: Option<String>,
    #[doc = "Workspace managed resource group. The resource group name uniquely identifies the resource group within the user subscriptionId. The resource group name must be no longer than 90 characters long, and must be alphanumeric characters (Char.IsLetterOrDigit()) and '-', '_', '(', ')' and'.'. Note that the name cannot end with '.'"]
    #[serde(rename = "managedResourceGroupName", default, skip_serializing_if = "Option::is_none")]
    pub managed_resource_group_name: Option<String>,
    #[doc = "Resource provisioning state"]
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[doc = "Login for workspace SQL active directory administrator"]
    #[serde(rename = "sqlAdministratorLogin", default, skip_serializing_if = "Option::is_none")]
    pub sql_administrator_login: Option<String>,
    #[doc = "Virtual Network Profile"]
    #[serde(rename = "virtualNetworkProfile", default, skip_serializing_if = "Option::is_none")]
    pub virtual_network_profile: Option<VirtualNetworkProfile>,
    #[doc = "Connectivity endpoints"]
    #[serde(rename = "connectivityEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub connectivity_endpoints: Option<serde_json::Value>,
    #[doc = "Setting this to 'default' will ensure that all compute for this workspace is in a virtual network managed on behalf of the user."]
    #[serde(rename = "managedVirtualNetwork", default, skip_serializing_if = "Option::is_none")]
    pub managed_virtual_network: Option<String>,
    #[doc = "Private endpoint connections to the workspace"]
    #[serde(rename = "privateEndpointConnections", default, skip_serializing_if = "Vec::is_empty")]
    pub private_endpoint_connections: Vec<PrivateEndpointConnection>,
    #[doc = "Details of the encryption associated with the workspace"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub encryption: Option<EncryptionDetails>,
    #[doc = "The workspace unique identifier"]
    #[serde(rename = "workspaceUID", default, skip_serializing_if = "Option::is_none")]
    pub workspace_uid: Option<String>,
    #[doc = "Workspace level configs and feature flags"]
    #[serde(rename = "extraProperties", default, skip_serializing_if = "Option::is_none")]
    pub extra_properties: Option<serde_json::Value>,
    #[doc = "Managed Virtual Network Settings"]
    #[serde(rename = "managedVirtualNetworkSettings", default, skip_serializing_if = "Option::is_none")]
    pub managed_virtual_network_settings: Option<ManagedVirtualNetworkSettings>,
    #[doc = "Git integration settings"]
    #[serde(rename = "workspaceRepositoryConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub workspace_repository_configuration: Option<WorkspaceRepositoryConfiguration>,
    #[doc = "Purview Configuration"]
    #[serde(rename = "purviewConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub purview_configuration: Option<PurviewConfiguration>,
    #[doc = "The ADLA resource ID."]
    #[serde(rename = "adlaResourceId", default, skip_serializing_if = "Option::is_none")]
    pub adla_resource_id: Option<String>,
}
impl WorkspaceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Git integration settings"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceRepositoryConfiguration {
    #[doc = "Type of workspace repositoryID configuration. Example WorkspaceVSTSConfiguration, WorkspaceGitHubConfiguration"]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[doc = "GitHub Enterprise host name. For example: https://github.mydomain.com"]
    #[serde(rename = "hostName", default, skip_serializing_if = "Option::is_none")]
    pub host_name: Option<String>,
    #[doc = "Account name"]
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
    #[doc = "VSTS project name"]
    #[serde(rename = "projectName", default, skip_serializing_if = "Option::is_none")]
    pub project_name: Option<String>,
    #[doc = "Repository name"]
    #[serde(rename = "repositoryName", default, skip_serializing_if = "Option::is_none")]
    pub repository_name: Option<String>,
    #[doc = "Collaboration branch"]
    #[serde(rename = "collaborationBranch", default, skip_serializing_if = "Option::is_none")]
    pub collaboration_branch: Option<String>,
    #[doc = "Root folder to use in the repository"]
    #[serde(rename = "rootFolder", default, skip_serializing_if = "Option::is_none")]
    pub root_folder: Option<String>,
    #[doc = "The last commit ID"]
    #[serde(rename = "lastCommitId", default, skip_serializing_if = "Option::is_none")]
    pub last_commit_id: Option<String>,
    #[doc = "The VSTS tenant ID"]
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[doc = "GitHub bring your own app client id"]
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[doc = "Client secret information for factory's bring your own app repository configuration"]
    #[serde(rename = "clientSecret", default, skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<GitHubClientSecret>,
}
impl WorkspaceRepositoryConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Parameters for updating a workspace resource."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WorkspaceUpdateParameters {
    #[doc = "The resource tags."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<serde_json::Value>,
    #[doc = "Identity properties of the workspace resource."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<WorkspaceIdentity>,
}
impl WorkspaceUpdateParameters {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Xero Service linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct XeroLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Xero Service linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: XeroLinkedServiceTypeProperties,
}
impl XeroLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: XeroLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Xero Service linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct XeroLinkedServiceTypeProperties {
    #[doc = "Properties used to connect to Xero. It is mutually exclusive with any other properties in the linked service. Type: object."]
    #[serde(rename = "connectionProperties", default, skip_serializing_if = "Option::is_none")]
    pub connection_properties: Option<serde_json::Value>,
    #[doc = "The endpoint of the Xero server. (i.e. api.xero.com)"]
    pub host: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "consumerKey", default, skip_serializing_if = "Option::is_none")]
    pub consumer_key: Option<SecretBase>,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "privateKey", default, skip_serializing_if = "Option::is_none")]
    pub private_key: Option<SecretBase>,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[doc = "Specifies whether to verify the identity of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl XeroLinkedServiceTypeProperties {
    pub fn new(host: serde_json::Value) -> Self {
        Self {
            connection_properties: None,
            host,
            consumer_key: None,
            private_key: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Xero Service dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct XeroObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl XeroObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Xero Service source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct XeroSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl XeroSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
#[doc = "Xml dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct XmlDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Xml dataset properties."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<XmlDatasetTypeProperties>,
}
impl XmlDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "Xml dataset properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct XmlDatasetTypeProperties {
    #[doc = "Dataset location."]
    pub location: DatasetLocation,
    #[doc = "The code page name of the preferred encoding. If not specified, the default value is UTF-8, unless BOM denotes another Unicode encoding. Refer to the name column of the table in the following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encodingName", default, skip_serializing_if = "Option::is_none")]
    pub encoding_name: Option<serde_json::Value>,
    #[doc = "The null value string. Type: string (or Expression with resultType string)."]
    #[serde(rename = "nullValue", default, skip_serializing_if = "Option::is_none")]
    pub null_value: Option<serde_json::Value>,
    #[doc = "The compression method used on a dataset."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub compression: Option<DatasetCompression>,
}
impl XmlDatasetTypeProperties {
    pub fn new(location: DatasetLocation) -> Self {
        Self {
            location,
            encoding_name: None,
            null_value: None,
            compression: None,
        }
    }
}
#[doc = "Xml read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct XmlReadSettings {
    #[serde(flatten)]
    pub format_read_settings: FormatReadSettings,
    #[doc = "Compression read settings."]
    #[serde(rename = "compressionProperties", default, skip_serializing_if = "Option::is_none")]
    pub compression_properties: Option<CompressionReadSettings>,
    #[doc = "Indicates what validation method is used when reading the xml files. Allowed values: 'none', 'xsd', or 'dtd'. Type: string (or Expression with resultType string)."]
    #[serde(rename = "validationMode", default, skip_serializing_if = "Option::is_none")]
    pub validation_mode: Option<serde_json::Value>,
    #[doc = "Indicates whether type detection is enabled when reading the xml files. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "detectDataType", default, skip_serializing_if = "Option::is_none")]
    pub detect_data_type: Option<serde_json::Value>,
    #[doc = "Indicates whether namespace is enabled when reading the xml files. Type: boolean (or Expression with resultType boolean)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub namespaces: Option<serde_json::Value>,
    #[doc = "Namespace uri to prefix mappings to override the prefixes in column names when namespace is enabled, if no prefix is defined for a namespace uri, the prefix of xml element/attribute name in the xml data file will be used. Example: \"{\"http://www.example.com/xml\":\"prefix\"}\" Type: object (or Expression with resultType object)."]
    #[serde(rename = "namespacePrefixes", default, skip_serializing_if = "Option::is_none")]
    pub namespace_prefixes: Option<serde_json::Value>,
}
impl XmlReadSettings {
    pub fn new(format_read_settings: FormatReadSettings) -> Self {
        Self {
            format_read_settings,
            compression_properties: None,
            validation_mode: None,
            detect_data_type: None,
            namespaces: None,
            namespace_prefixes: None,
        }
    }
}
#[doc = "A copy activity Xml source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct XmlSource {
    #[serde(flatten)]
    pub copy_source: CopySource,
    #[doc = "Connector read setting."]
    #[serde(rename = "storeSettings", default, skip_serializing_if = "Option::is_none")]
    pub store_settings: Option<StoreReadSettings>,
    #[doc = "Xml read settings."]
    #[serde(rename = "formatSettings", default, skip_serializing_if = "Option::is_none")]
    pub format_settings: Option<XmlReadSettings>,
    #[doc = "Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects)."]
    #[serde(rename = "additionalColumns", default, skip_serializing_if = "Vec::is_empty")]
    pub additional_columns: Vec<AdditionalColumns>,
}
impl XmlSource {
    pub fn new(copy_source: CopySource) -> Self {
        Self {
            copy_source,
            store_settings: None,
            format_settings: None,
            additional_columns: Vec::new(),
        }
    }
}
#[doc = "The ZipDeflate compression read settings."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ZipDeflateReadSettings {
    #[serde(flatten)]
    pub compression_read_settings: CompressionReadSettings,
    #[doc = "Preserve the zip file name as folder path. Type: boolean (or Expression with resultType boolean)."]
    #[serde(rename = "preserveZipFileNameAsFolder", default, skip_serializing_if = "Option::is_none")]
    pub preserve_zip_file_name_as_folder: Option<serde_json::Value>,
}
impl ZipDeflateReadSettings {
    pub fn new(compression_read_settings: CompressionReadSettings) -> Self {
        Self {
            compression_read_settings,
            preserve_zip_file_name_as_folder: None,
        }
    }
}
#[doc = "Zoho server linked service."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ZohoLinkedService {
    #[serde(flatten)]
    pub linked_service: LinkedService,
    #[doc = "Zoho server linked service properties."]
    #[serde(rename = "typeProperties")]
    pub type_properties: ZohoLinkedServiceTypeProperties,
}
impl ZohoLinkedService {
    pub fn new(linked_service: LinkedService, type_properties: ZohoLinkedServiceTypeProperties) -> Self {
        Self {
            linked_service,
            type_properties,
        }
    }
}
#[doc = "Zoho server linked service properties."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ZohoLinkedServiceTypeProperties {
    #[doc = "Properties used to connect to Zoho. It is mutually exclusive with any other properties in the linked service. Type: object."]
    #[serde(rename = "connectionProperties", default, skip_serializing_if = "Option::is_none")]
    pub connection_properties: Option<serde_json::Value>,
    #[doc = "The endpoint of the Zoho server. (i.e. crm.zoho.com/crm/private)"]
    pub endpoint: serde_json::Value,
    #[doc = "The base definition of a secret type."]
    #[serde(rename = "accessToken", default, skip_serializing_if = "Option::is_none")]
    pub access_token: Option<SecretBase>,
    #[doc = "Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true."]
    #[serde(rename = "useEncryptedEndpoints", default, skip_serializing_if = "Option::is_none")]
    pub use_encrypted_endpoints: Option<serde_json::Value>,
    #[doc = "Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "useHostVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_host_verification: Option<serde_json::Value>,
    #[doc = "Specifies whether to verify the identity of the server when connecting over SSL. The default value is true."]
    #[serde(rename = "usePeerVerification", default, skip_serializing_if = "Option::is_none")]
    pub use_peer_verification: Option<serde_json::Value>,
    #[doc = "The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string)."]
    #[serde(rename = "encryptedCredential", default, skip_serializing_if = "Option::is_none")]
    pub encrypted_credential: Option<serde_json::Value>,
}
impl ZohoLinkedServiceTypeProperties {
    pub fn new(endpoint: serde_json::Value) -> Self {
        Self {
            connection_properties: None,
            endpoint,
            access_token: None,
            use_encrypted_endpoints: None,
            use_host_verification: None,
            use_peer_verification: None,
            encrypted_credential: None,
        }
    }
}
#[doc = "Zoho server dataset."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ZohoObjectDataset {
    #[serde(flatten)]
    pub dataset: Dataset,
    #[doc = "Properties specific to this dataset type."]
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<GenericDatasetTypeProperties>,
}
impl ZohoObjectDataset {
    pub fn new(dataset: Dataset) -> Self {
        Self {
            dataset,
            type_properties: None,
        }
    }
}
#[doc = "A copy activity Zoho server source."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ZohoSource {
    #[serde(flatten)]
    pub tabular_source: TabularSource,
    #[doc = "A query to retrieve data from source. Type: string (or Expression with resultType string)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub query: Option<serde_json::Value>,
}
impl ZohoSource {
    pub fn new(tabular_source: TabularSource) -> Self {
        Self {
            tabular_source,
            query: None,
        }
    }
}
