#![doc = "generated by AutoRust"]
#![allow(unused_mut)]
#![allow(unused_variables)]
#![allow(unused_imports)]
use super::models;
#[derive(Clone)]
pub struct Client {
    endpoint: String,
    credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
    scopes: Vec<String>,
    pipeline: azure_core::Pipeline,
}
#[derive(Clone)]
pub struct ClientBuilder {
    credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
    endpoint: Option<String>,
    scopes: Option<Vec<String>>,
}
pub const DEFAULT_ENDPOINT: &str = "https://localhost:19080";
impl ClientBuilder {
    pub fn new(credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>) -> Self {
        Self {
            credential,
            endpoint: None,
            scopes: None,
        }
    }
    pub fn endpoint(mut self, endpoint: impl Into<String>) -> Self {
        self.endpoint = Some(endpoint.into());
        self
    }
    pub fn scopes(mut self, scopes: &[&str]) -> Self {
        self.scopes = Some(scopes.iter().map(|scope| (*scope).to_owned()).collect());
        self
    }
    pub fn build(self) -> Client {
        let endpoint = self.endpoint.unwrap_or_else(|| DEFAULT_ENDPOINT.to_owned());
        let scopes = self.scopes.unwrap_or_else(|| vec![format!("{}/", endpoint)]);
        Client::new(endpoint, self.credential, scopes)
    }
}
impl Client {
    pub(crate) fn endpoint(&self) -> &str {
        self.endpoint.as_str()
    }
    pub(crate) fn token_credential(&self) -> &dyn azure_core::auth::TokenCredential {
        self.credential.as_ref()
    }
    pub(crate) fn scopes(&self) -> Vec<&str> {
        self.scopes.iter().map(String::as_str).collect()
    }
    pub(crate) async fn send(&self, request: impl Into<azure_core::Request>) -> azure_core::error::Result<azure_core::Response> {
        let mut context = azure_core::Context::default();
        let mut request = request.into();
        self.pipeline.send(&mut context, &mut request).await
    }
    pub fn new(
        endpoint: impl Into<String>,
        credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
        scopes: Vec<String>,
    ) -> Self {
        let endpoint = endpoint.into();
        let pipeline = azure_core::Pipeline::new(
            option_env!("CARGO_PKG_NAME"),
            option_env!("CARGO_PKG_VERSION"),
            azure_core::ClientOptions::default(),
            Vec::new(),
            Vec::new(),
        );
        Self {
            endpoint,
            credential,
            scopes,
            pipeline,
        }
    }
    pub fn mesh_application(&self) -> mesh_application::Client {
        mesh_application::Client(self.clone())
    }
    pub fn mesh_code_package(&self) -> mesh_code_package::Client {
        mesh_code_package::Client(self.clone())
    }
    pub fn mesh_gateway(&self) -> mesh_gateway::Client {
        mesh_gateway::Client(self.clone())
    }
    pub fn mesh_network(&self) -> mesh_network::Client {
        mesh_network::Client(self.clone())
    }
    pub fn mesh_secret(&self) -> mesh_secret::Client {
        mesh_secret::Client(self.clone())
    }
    pub fn mesh_secret_value(&self) -> mesh_secret_value::Client {
        mesh_secret_value::Client(self.clone())
    }
    pub fn mesh_service(&self) -> mesh_service::Client {
        mesh_service::Client(self.clone())
    }
    pub fn mesh_service_replica(&self) -> mesh_service_replica::Client {
        mesh_service_replica::Client(self.clone())
    }
    pub fn mesh_volume(&self) -> mesh_volume::Client {
        mesh_volume::Client(self.clone())
    }
}
#[non_exhaustive]
#[derive(Debug, thiserror :: Error)]
#[allow(non_camel_case_types)]
pub enum Error {
    #[error(transparent)]
    GetClusterManifest(#[from] get_cluster_manifest::Error),
    #[error(transparent)]
    GetClusterHealth(#[from] get_cluster_health::Error),
    #[error(transparent)]
    GetClusterHealthUsingPolicy(#[from] get_cluster_health_using_policy::Error),
    #[error(transparent)]
    GetClusterHealthChunk(#[from] get_cluster_health_chunk::Error),
    #[error(transparent)]
    GetClusterHealthChunkUsingPolicyAndAdvancedFilters(#[from] get_cluster_health_chunk_using_policy_and_advanced_filters::Error),
    #[error(transparent)]
    ReportClusterHealth(#[from] report_cluster_health::Error),
    #[error(transparent)]
    GetProvisionedFabricCodeVersionInfoList(#[from] get_provisioned_fabric_code_version_info_list::Error),
    #[error(transparent)]
    GetProvisionedFabricConfigVersionInfoList(#[from] get_provisioned_fabric_config_version_info_list::Error),
    #[error(transparent)]
    GetClusterUpgradeProgress(#[from] get_cluster_upgrade_progress::Error),
    #[error(transparent)]
    GetClusterConfiguration(#[from] get_cluster_configuration::Error),
    #[error(transparent)]
    GetClusterConfigurationUpgradeStatus(#[from] get_cluster_configuration_upgrade_status::Error),
    #[error(transparent)]
    GetUpgradeOrchestrationServiceState(#[from] get_upgrade_orchestration_service_state::Error),
    #[error(transparent)]
    SetUpgradeOrchestrationServiceState(#[from] set_upgrade_orchestration_service_state::Error),
    #[error(transparent)]
    ProvisionCluster(#[from] provision_cluster::Error),
    #[error(transparent)]
    UnprovisionCluster(#[from] unprovision_cluster::Error),
    #[error(transparent)]
    RollbackClusterUpgrade(#[from] rollback_cluster_upgrade::Error),
    #[error(transparent)]
    ResumeClusterUpgrade(#[from] resume_cluster_upgrade::Error),
    #[error(transparent)]
    StartClusterUpgrade(#[from] start_cluster_upgrade::Error),
    #[error(transparent)]
    StartClusterConfigurationUpgrade(#[from] start_cluster_configuration_upgrade::Error),
    #[error(transparent)]
    UpdateClusterUpgrade(#[from] update_cluster_upgrade::Error),
    #[error(transparent)]
    GetAadMetadata(#[from] get_aad_metadata::Error),
    #[error(transparent)]
    GetClusterVersion(#[from] get_cluster_version::Error),
    #[error(transparent)]
    GetClusterLoad(#[from] get_cluster_load::Error),
    #[error(transparent)]
    ToggleVerboseServicePlacementHealthReporting(#[from] toggle_verbose_service_placement_health_reporting::Error),
    #[error(transparent)]
    GetNodeInfoList(#[from] get_node_info_list::Error),
    #[error(transparent)]
    GetNodeInfo(#[from] get_node_info::Error),
    #[error(transparent)]
    GetNodeHealth(#[from] get_node_health::Error),
    #[error(transparent)]
    GetNodeHealthUsingPolicy(#[from] get_node_health_using_policy::Error),
    #[error(transparent)]
    ReportNodeHealth(#[from] report_node_health::Error),
    #[error(transparent)]
    GetNodeLoadInfo(#[from] get_node_load_info::Error),
    #[error(transparent)]
    DisableNode(#[from] disable_node::Error),
    #[error(transparent)]
    EnableNode(#[from] enable_node::Error),
    #[error(transparent)]
    RemoveNodeState(#[from] remove_node_state::Error),
    #[error(transparent)]
    RestartNode(#[from] restart_node::Error),
    #[error(transparent)]
    RemoveConfigurationOverrides(#[from] remove_configuration_overrides::Error),
    #[error(transparent)]
    GetConfigurationOverrides(#[from] get_configuration_overrides::Error),
    #[error(transparent)]
    AddConfigurationParameterOverrides(#[from] add_configuration_parameter_overrides::Error),
    #[error(transparent)]
    GetApplicationTypeInfoList(#[from] get_application_type_info_list::Error),
    #[error(transparent)]
    GetApplicationTypeInfoListByName(#[from] get_application_type_info_list_by_name::Error),
    #[error(transparent)]
    ProvisionApplicationType(#[from] provision_application_type::Error),
    #[error(transparent)]
    UnprovisionApplicationType(#[from] unprovision_application_type::Error),
    #[error(transparent)]
    GetServiceTypeInfoList(#[from] get_service_type_info_list::Error),
    #[error(transparent)]
    GetServiceTypeInfoByName(#[from] get_service_type_info_by_name::Error),
    #[error(transparent)]
    GetServiceManifest(#[from] get_service_manifest::Error),
    #[error(transparent)]
    GetDeployedServiceTypeInfoList(#[from] get_deployed_service_type_info_list::Error),
    #[error(transparent)]
    GetDeployedServiceTypeInfoByName(#[from] get_deployed_service_type_info_by_name::Error),
    #[error(transparent)]
    CreateApplication(#[from] create_application::Error),
    #[error(transparent)]
    DeleteApplication(#[from] delete_application::Error),
    #[error(transparent)]
    GetApplicationLoadInfo(#[from] get_application_load_info::Error),
    #[error(transparent)]
    GetApplicationInfoList(#[from] get_application_info_list::Error),
    #[error(transparent)]
    GetApplicationInfo(#[from] get_application_info::Error),
    #[error(transparent)]
    GetApplicationHealth(#[from] get_application_health::Error),
    #[error(transparent)]
    GetApplicationHealthUsingPolicy(#[from] get_application_health_using_policy::Error),
    #[error(transparent)]
    ReportApplicationHealth(#[from] report_application_health::Error),
    #[error(transparent)]
    StartApplicationUpgrade(#[from] start_application_upgrade::Error),
    #[error(transparent)]
    GetApplicationUpgrade(#[from] get_application_upgrade::Error),
    #[error(transparent)]
    UpdateApplicationUpgrade(#[from] update_application_upgrade::Error),
    #[error(transparent)]
    ResumeApplicationUpgrade(#[from] resume_application_upgrade::Error),
    #[error(transparent)]
    RollbackApplicationUpgrade(#[from] rollback_application_upgrade::Error),
    #[error(transparent)]
    GetDeployedApplicationInfoList(#[from] get_deployed_application_info_list::Error),
    #[error(transparent)]
    GetDeployedApplicationInfo(#[from] get_deployed_application_info::Error),
    #[error(transparent)]
    GetDeployedApplicationHealth(#[from] get_deployed_application_health::Error),
    #[error(transparent)]
    GetDeployedApplicationHealthUsingPolicy(#[from] get_deployed_application_health_using_policy::Error),
    #[error(transparent)]
    ReportDeployedApplicationHealth(#[from] report_deployed_application_health::Error),
    #[error(transparent)]
    GetApplicationManifest(#[from] get_application_manifest::Error),
    #[error(transparent)]
    GetServiceInfoList(#[from] get_service_info_list::Error),
    #[error(transparent)]
    GetServiceInfo(#[from] get_service_info::Error),
    #[error(transparent)]
    GetApplicationNameInfo(#[from] get_application_name_info::Error),
    #[error(transparent)]
    CreateService(#[from] create_service::Error),
    #[error(transparent)]
    CreateServiceFromTemplate(#[from] create_service_from_template::Error),
    #[error(transparent)]
    DeleteService(#[from] delete_service::Error),
    #[error(transparent)]
    UpdateService(#[from] update_service::Error),
    #[error(transparent)]
    GetServiceDescription(#[from] get_service_description::Error),
    #[error(transparent)]
    GetServiceHealth(#[from] get_service_health::Error),
    #[error(transparent)]
    GetServiceHealthUsingPolicy(#[from] get_service_health_using_policy::Error),
    #[error(transparent)]
    ReportServiceHealth(#[from] report_service_health::Error),
    #[error(transparent)]
    ResolveService(#[from] resolve_service::Error),
    #[error(transparent)]
    GetUnplacedReplicaInformation(#[from] get_unplaced_replica_information::Error),
    #[error(transparent)]
    GetPartitionInfoList(#[from] get_partition_info_list::Error),
    #[error(transparent)]
    GetPartitionInfo(#[from] get_partition_info::Error),
    #[error(transparent)]
    GetServiceNameInfo(#[from] get_service_name_info::Error),
    #[error(transparent)]
    GetPartitionHealth(#[from] get_partition_health::Error),
    #[error(transparent)]
    GetPartitionHealthUsingPolicy(#[from] get_partition_health_using_policy::Error),
    #[error(transparent)]
    ReportPartitionHealth(#[from] report_partition_health::Error),
    #[error(transparent)]
    GetPartitionLoadInformation(#[from] get_partition_load_information::Error),
    #[error(transparent)]
    ResetPartitionLoad(#[from] reset_partition_load::Error),
    #[error(transparent)]
    RecoverPartition(#[from] recover_partition::Error),
    #[error(transparent)]
    RecoverServicePartitions(#[from] recover_service_partitions::Error),
    #[error(transparent)]
    RecoverSystemPartitions(#[from] recover_system_partitions::Error),
    #[error(transparent)]
    RecoverAllPartitions(#[from] recover_all_partitions::Error),
    #[error(transparent)]
    MovePrimaryReplica(#[from] move_primary_replica::Error),
    #[error(transparent)]
    MoveSecondaryReplica(#[from] move_secondary_replica::Error),
    #[error(transparent)]
    CreateRepairTask(#[from] create_repair_task::Error),
    #[error(transparent)]
    CancelRepairTask(#[from] cancel_repair_task::Error),
    #[error(transparent)]
    DeleteRepairTask(#[from] delete_repair_task::Error),
    #[error(transparent)]
    GetRepairTaskList(#[from] get_repair_task_list::Error),
    #[error(transparent)]
    ForceApproveRepairTask(#[from] force_approve_repair_task::Error),
    #[error(transparent)]
    UpdateRepairTaskHealthPolicy(#[from] update_repair_task_health_policy::Error),
    #[error(transparent)]
    UpdateRepairExecutionState(#[from] update_repair_execution_state::Error),
    #[error(transparent)]
    GetReplicaInfoList(#[from] get_replica_info_list::Error),
    #[error(transparent)]
    GetReplicaInfo(#[from] get_replica_info::Error),
    #[error(transparent)]
    GetReplicaHealth(#[from] get_replica_health::Error),
    #[error(transparent)]
    GetReplicaHealthUsingPolicy(#[from] get_replica_health_using_policy::Error),
    #[error(transparent)]
    ReportReplicaHealth(#[from] report_replica_health::Error),
    #[error(transparent)]
    GetDeployedServiceReplicaInfoList(#[from] get_deployed_service_replica_info_list::Error),
    #[error(transparent)]
    GetDeployedServiceReplicaDetailInfo(#[from] get_deployed_service_replica_detail_info::Error),
    #[error(transparent)]
    GetDeployedServiceReplicaDetailInfoByPartitionId(#[from] get_deployed_service_replica_detail_info_by_partition_id::Error),
    #[error(transparent)]
    RestartReplica(#[from] restart_replica::Error),
    #[error(transparent)]
    RemoveReplica(#[from] remove_replica::Error),
    #[error(transparent)]
    GetDeployedServicePackageInfoList(#[from] get_deployed_service_package_info_list::Error),
    #[error(transparent)]
    GetDeployedServicePackageInfoListByName(#[from] get_deployed_service_package_info_list_by_name::Error),
    #[error(transparent)]
    GetDeployedServicePackageHealth(#[from] get_deployed_service_package_health::Error),
    #[error(transparent)]
    GetDeployedServicePackageHealthUsingPolicy(#[from] get_deployed_service_package_health_using_policy::Error),
    #[error(transparent)]
    ReportDeployedServicePackageHealth(#[from] report_deployed_service_package_health::Error),
    #[error(transparent)]
    DeployServicePackageToNode(#[from] deploy_service_package_to_node::Error),
    #[error(transparent)]
    GetDeployedCodePackageInfoList(#[from] get_deployed_code_package_info_list::Error),
    #[error(transparent)]
    RestartDeployedCodePackage(#[from] restart_deployed_code_package::Error),
    #[error(transparent)]
    GetContainerLogsDeployedOnNode(#[from] get_container_logs_deployed_on_node::Error),
    #[error(transparent)]
    InvokeContainerApi(#[from] invoke_container_api::Error),
    #[error(transparent)]
    CreateComposeDeployment(#[from] create_compose_deployment::Error),
    #[error(transparent)]
    GetComposeDeploymentStatus(#[from] get_compose_deployment_status::Error),
    #[error(transparent)]
    GetComposeDeploymentStatusList(#[from] get_compose_deployment_status_list::Error),
    #[error(transparent)]
    GetComposeDeploymentUpgradeProgress(#[from] get_compose_deployment_upgrade_progress::Error),
    #[error(transparent)]
    RemoveComposeDeployment(#[from] remove_compose_deployment::Error),
    #[error(transparent)]
    StartComposeDeploymentUpgrade(#[from] start_compose_deployment_upgrade::Error),
    #[error(transparent)]
    StartRollbackComposeDeploymentUpgrade(#[from] start_rollback_compose_deployment_upgrade::Error),
    #[error(transparent)]
    GetChaos(#[from] get_chaos::Error),
    #[error(transparent)]
    StartChaos(#[from] start_chaos::Error),
    #[error(transparent)]
    StopChaos(#[from] stop_chaos::Error),
    #[error(transparent)]
    GetChaosEvents(#[from] get_chaos_events::Error),
    #[error(transparent)]
    GetChaosSchedule(#[from] get_chaos_schedule::Error),
    #[error(transparent)]
    PostChaosSchedule(#[from] post_chaos_schedule::Error),
    #[error(transparent)]
    GetImageStoreContent(#[from] get_image_store_content::Error),
    #[error(transparent)]
    UploadFile(#[from] upload_file::Error),
    #[error(transparent)]
    DeleteImageStoreContent(#[from] delete_image_store_content::Error),
    #[error(transparent)]
    GetImageStoreRootContent(#[from] get_image_store_root_content::Error),
    #[error(transparent)]
    CopyImageStoreContent(#[from] copy_image_store_content::Error),
    #[error(transparent)]
    DeleteImageStoreUploadSession(#[from] delete_image_store_upload_session::Error),
    #[error(transparent)]
    CommitImageStoreUploadSession(#[from] commit_image_store_upload_session::Error),
    #[error(transparent)]
    GetImageStoreUploadSessionById(#[from] get_image_store_upload_session_by_id::Error),
    #[error(transparent)]
    GetImageStoreUploadSessionByPath(#[from] get_image_store_upload_session_by_path::Error),
    #[error(transparent)]
    UploadFileChunk(#[from] upload_file_chunk::Error),
    #[error(transparent)]
    GetImageStoreRootFolderSize(#[from] get_image_store_root_folder_size::Error),
    #[error(transparent)]
    GetImageStoreFolderSize(#[from] get_image_store_folder_size::Error),
    #[error(transparent)]
    GetImageStoreInfo(#[from] get_image_store_info::Error),
    #[error(transparent)]
    InvokeInfrastructureCommand(#[from] invoke_infrastructure_command::Error),
    #[error(transparent)]
    InvokeInfrastructureQuery(#[from] invoke_infrastructure_query::Error),
    #[error(transparent)]
    StartDataLoss(#[from] start_data_loss::Error),
    #[error(transparent)]
    GetDataLossProgress(#[from] get_data_loss_progress::Error),
    #[error(transparent)]
    StartQuorumLoss(#[from] start_quorum_loss::Error),
    #[error(transparent)]
    GetQuorumLossProgress(#[from] get_quorum_loss_progress::Error),
    #[error(transparent)]
    StartPartitionRestart(#[from] start_partition_restart::Error),
    #[error(transparent)]
    GetPartitionRestartProgress(#[from] get_partition_restart_progress::Error),
    #[error(transparent)]
    StartNodeTransition(#[from] start_node_transition::Error),
    #[error(transparent)]
    GetNodeTransitionProgress(#[from] get_node_transition_progress::Error),
    #[error(transparent)]
    GetFaultOperationList(#[from] get_fault_operation_list::Error),
    #[error(transparent)]
    CancelOperation(#[from] cancel_operation::Error),
    #[error(transparent)]
    CreateBackupPolicy(#[from] create_backup_policy::Error),
    #[error(transparent)]
    DeleteBackupPolicy(#[from] delete_backup_policy::Error),
    #[error(transparent)]
    GetBackupPolicyList(#[from] get_backup_policy_list::Error),
    #[error(transparent)]
    GetBackupPolicyByName(#[from] get_backup_policy_by_name::Error),
    #[error(transparent)]
    GetAllEntitiesBackedUpByPolicy(#[from] get_all_entities_backed_up_by_policy::Error),
    #[error(transparent)]
    UpdateBackupPolicy(#[from] update_backup_policy::Error),
    #[error(transparent)]
    EnableApplicationBackup(#[from] enable_application_backup::Error),
    #[error(transparent)]
    DisableApplicationBackup(#[from] disable_application_backup::Error),
    #[error(transparent)]
    GetApplicationBackupConfigurationInfo(#[from] get_application_backup_configuration_info::Error),
    #[error(transparent)]
    GetApplicationBackupList(#[from] get_application_backup_list::Error),
    #[error(transparent)]
    SuspendApplicationBackup(#[from] suspend_application_backup::Error),
    #[error(transparent)]
    ResumeApplicationBackup(#[from] resume_application_backup::Error),
    #[error(transparent)]
    EnableServiceBackup(#[from] enable_service_backup::Error),
    #[error(transparent)]
    DisableServiceBackup(#[from] disable_service_backup::Error),
    #[error(transparent)]
    GetServiceBackupConfigurationInfo(#[from] get_service_backup_configuration_info::Error),
    #[error(transparent)]
    GetServiceBackupList(#[from] get_service_backup_list::Error),
    #[error(transparent)]
    SuspendServiceBackup(#[from] suspend_service_backup::Error),
    #[error(transparent)]
    ResumeServiceBackup(#[from] resume_service_backup::Error),
    #[error(transparent)]
    EnablePartitionBackup(#[from] enable_partition_backup::Error),
    #[error(transparent)]
    DisablePartitionBackup(#[from] disable_partition_backup::Error),
    #[error(transparent)]
    GetPartitionBackupConfigurationInfo(#[from] get_partition_backup_configuration_info::Error),
    #[error(transparent)]
    GetPartitionBackupList(#[from] get_partition_backup_list::Error),
    #[error(transparent)]
    SuspendPartitionBackup(#[from] suspend_partition_backup::Error),
    #[error(transparent)]
    ResumePartitionBackup(#[from] resume_partition_backup::Error),
    #[error(transparent)]
    BackupPartition(#[from] backup_partition::Error),
    #[error(transparent)]
    GetPartitionBackupProgress(#[from] get_partition_backup_progress::Error),
    #[error(transparent)]
    RestorePartition(#[from] restore_partition::Error),
    #[error(transparent)]
    GetPartitionRestoreProgress(#[from] get_partition_restore_progress::Error),
    #[error(transparent)]
    GetBackupsFromBackupLocation(#[from] get_backups_from_backup_location::Error),
    #[error(transparent)]
    CreateName(#[from] create_name::Error),
    #[error(transparent)]
    GetNameExistsInfo(#[from] get_name_exists_info::Error),
    #[error(transparent)]
    DeleteName(#[from] delete_name::Error),
    #[error(transparent)]
    GetSubNameInfoList(#[from] get_sub_name_info_list::Error),
    #[error(transparent)]
    GetPropertyInfoList(#[from] get_property_info_list::Error),
    #[error(transparent)]
    GetPropertyInfo(#[from] get_property_info::Error),
    #[error(transparent)]
    PutProperty(#[from] put_property::Error),
    #[error(transparent)]
    DeleteProperty(#[from] delete_property::Error),
    #[error(transparent)]
    SubmitPropertyBatch(#[from] submit_property_batch::Error),
    #[error(transparent)]
    GetClusterEventList(#[from] get_cluster_event_list::Error),
    #[error(transparent)]
    GetContainersEventList(#[from] get_containers_event_list::Error),
    #[error(transparent)]
    GetNodeEventList(#[from] get_node_event_list::Error),
    #[error(transparent)]
    GetNodesEventList(#[from] get_nodes_event_list::Error),
    #[error(transparent)]
    GetApplicationEventList(#[from] get_application_event_list::Error),
    #[error(transparent)]
    GetApplicationsEventList(#[from] get_applications_event_list::Error),
    #[error(transparent)]
    GetServiceEventList(#[from] get_service_event_list::Error),
    #[error(transparent)]
    GetServicesEventList(#[from] get_services_event_list::Error),
    #[error(transparent)]
    GetPartitionEventList(#[from] get_partition_event_list::Error),
    #[error(transparent)]
    GetPartitionsEventList(#[from] get_partitions_event_list::Error),
    #[error(transparent)]
    GetPartitionReplicaEventList(#[from] get_partition_replica_event_list::Error),
    #[error(transparent)]
    GetPartitionReplicasEventList(#[from] get_partition_replicas_event_list::Error),
    #[error(transparent)]
    GetCorrelatedEventList(#[from] get_correlated_event_list::Error),
    #[error(transparent)]
    MeshSecret_Get(#[from] mesh_secret::get::Error),
    #[error(transparent)]
    MeshSecret_CreateOrUpdate(#[from] mesh_secret::create_or_update::Error),
    #[error(transparent)]
    MeshSecret_Delete(#[from] mesh_secret::delete::Error),
    #[error(transparent)]
    MeshSecret_List(#[from] mesh_secret::list::Error),
    #[error(transparent)]
    MeshSecretValue_Get(#[from] mesh_secret_value::get::Error),
    #[error(transparent)]
    MeshSecretValue_AddValue(#[from] mesh_secret_value::add_value::Error),
    #[error(transparent)]
    MeshSecretValue_Delete(#[from] mesh_secret_value::delete::Error),
    #[error(transparent)]
    MeshSecretValue_List(#[from] mesh_secret_value::list::Error),
    #[error(transparent)]
    MeshSecretValue_Show(#[from] mesh_secret_value::show::Error),
    #[error(transparent)]
    MeshVolume_Get(#[from] mesh_volume::get::Error),
    #[error(transparent)]
    MeshVolume_CreateOrUpdate(#[from] mesh_volume::create_or_update::Error),
    #[error(transparent)]
    MeshVolume_Delete(#[from] mesh_volume::delete::Error),
    #[error(transparent)]
    MeshVolume_List(#[from] mesh_volume::list::Error),
    #[error(transparent)]
    MeshNetwork_Get(#[from] mesh_network::get::Error),
    #[error(transparent)]
    MeshNetwork_CreateOrUpdate(#[from] mesh_network::create_or_update::Error),
    #[error(transparent)]
    MeshNetwork_Delete(#[from] mesh_network::delete::Error),
    #[error(transparent)]
    MeshNetwork_List(#[from] mesh_network::list::Error),
    #[error(transparent)]
    MeshApplication_Get(#[from] mesh_application::get::Error),
    #[error(transparent)]
    MeshApplication_CreateOrUpdate(#[from] mesh_application::create_or_update::Error),
    #[error(transparent)]
    MeshApplication_Delete(#[from] mesh_application::delete::Error),
    #[error(transparent)]
    MeshApplication_List(#[from] mesh_application::list::Error),
    #[error(transparent)]
    MeshApplication_GetUpgradeProgress(#[from] mesh_application::get_upgrade_progress::Error),
    #[error(transparent)]
    MeshService_Get(#[from] mesh_service::get::Error),
    #[error(transparent)]
    MeshService_List(#[from] mesh_service::list::Error),
    #[error(transparent)]
    MeshCodePackage_GetContainerLogs(#[from] mesh_code_package::get_container_logs::Error),
    #[error(transparent)]
    MeshServiceReplica_Get(#[from] mesh_service_replica::get::Error),
    #[error(transparent)]
    MeshServiceReplica_List(#[from] mesh_service_replica::list::Error),
    #[error(transparent)]
    MeshGateway_Get(#[from] mesh_gateway::get::Error),
    #[error(transparent)]
    MeshGateway_CreateOrUpdate(#[from] mesh_gateway::create_or_update::Error),
    #[error(transparent)]
    MeshGateway_Delete(#[from] mesh_gateway::delete::Error),
    #[error(transparent)]
    MeshGateway_List(#[from] mesh_gateway::list::Error),
}
impl Client {
    #[doc = "Get the Service Fabric cluster manifest."]
    pub fn get_cluster_manifest(&self) -> get_cluster_manifest::Builder {
        get_cluster_manifest::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Gets the health of a Service Fabric cluster."]
    pub fn get_cluster_health(&self) -> get_cluster_health::Builder {
        get_cluster_health::Builder {
            client: self.clone(),
            nodes_health_state_filter: None,
            applications_health_state_filter: None,
            events_health_state_filter: None,
            exclude_health_statistics: None,
            include_system_application_health_statistics: None,
            timeout: None,
        }
    }
    #[doc = "Gets the health of a Service Fabric cluster using the specified policy."]
    pub fn get_cluster_health_using_policy(&self) -> get_cluster_health_using_policy::Builder {
        get_cluster_health_using_policy::Builder {
            client: self.clone(),
            nodes_health_state_filter: None,
            applications_health_state_filter: None,
            events_health_state_filter: None,
            exclude_health_statistics: None,
            include_system_application_health_statistics: None,
            cluster_health_policies: None,
            timeout: None,
        }
    }
    #[doc = "Gets the health of a Service Fabric cluster using health chunks."]
    pub fn get_cluster_health_chunk(&self) -> get_cluster_health_chunk::Builder {
        get_cluster_health_chunk::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Gets the health of a Service Fabric cluster using health chunks."]
    pub fn get_cluster_health_chunk_using_policy_and_advanced_filters(
        &self,
    ) -> get_cluster_health_chunk_using_policy_and_advanced_filters::Builder {
        get_cluster_health_chunk_using_policy_and_advanced_filters::Builder {
            client: self.clone(),
            cluster_health_chunk_query_description: None,
            timeout: None,
        }
    }
    #[doc = "Sends a health report on the Service Fabric cluster."]
    pub fn report_cluster_health(&self, health_information: impl Into<models::HealthInformation>) -> report_cluster_health::Builder {
        report_cluster_health::Builder {
            client: self.clone(),
            health_information: health_information.into(),
            immediate: None,
            timeout: None,
        }
    }
    #[doc = "Gets a list of fabric code versions that are provisioned in a Service Fabric cluster."]
    pub fn get_provisioned_fabric_code_version_info_list(&self) -> get_provisioned_fabric_code_version_info_list::Builder {
        get_provisioned_fabric_code_version_info_list::Builder {
            client: self.clone(),
            code_version: None,
            timeout: None,
        }
    }
    #[doc = "Gets a list of fabric config versions that are provisioned in a Service Fabric cluster."]
    pub fn get_provisioned_fabric_config_version_info_list(&self) -> get_provisioned_fabric_config_version_info_list::Builder {
        get_provisioned_fabric_config_version_info_list::Builder {
            client: self.clone(),
            config_version: None,
            timeout: None,
        }
    }
    #[doc = "Gets the progress of the current cluster upgrade."]
    pub fn get_cluster_upgrade_progress(&self) -> get_cluster_upgrade_progress::Builder {
        get_cluster_upgrade_progress::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Get the Service Fabric standalone cluster configuration."]
    pub fn get_cluster_configuration(&self, configuration_api_version: impl Into<String>) -> get_cluster_configuration::Builder {
        get_cluster_configuration::Builder {
            client: self.clone(),
            configuration_api_version: configuration_api_version.into(),
            timeout: None,
        }
    }
    #[doc = "Get the cluster configuration upgrade status of a Service Fabric standalone cluster."]
    pub fn get_cluster_configuration_upgrade_status(&self) -> get_cluster_configuration_upgrade_status::Builder {
        get_cluster_configuration_upgrade_status::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Get the service state of Service Fabric Upgrade Orchestration Service."]
    pub fn get_upgrade_orchestration_service_state(&self) -> get_upgrade_orchestration_service_state::Builder {
        get_upgrade_orchestration_service_state::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Update the service state of Service Fabric Upgrade Orchestration Service."]
    pub fn set_upgrade_orchestration_service_state(
        &self,
        upgrade_orchestration_service_state: impl Into<models::UpgradeOrchestrationServiceState>,
    ) -> set_upgrade_orchestration_service_state::Builder {
        set_upgrade_orchestration_service_state::Builder {
            client: self.clone(),
            upgrade_orchestration_service_state: upgrade_orchestration_service_state.into(),
            timeout: None,
        }
    }
    #[doc = "Provision the code or configuration packages of a Service Fabric cluster."]
    pub fn provision_cluster(
        &self,
        provision_fabric_description: impl Into<models::ProvisionFabricDescription>,
    ) -> provision_cluster::Builder {
        provision_cluster::Builder {
            client: self.clone(),
            provision_fabric_description: provision_fabric_description.into(),
            timeout: None,
        }
    }
    #[doc = "Unprovision the code or configuration packages of a Service Fabric cluster."]
    pub fn unprovision_cluster(
        &self,
        unprovision_fabric_description: impl Into<models::UnprovisionFabricDescription>,
    ) -> unprovision_cluster::Builder {
        unprovision_cluster::Builder {
            client: self.clone(),
            unprovision_fabric_description: unprovision_fabric_description.into(),
            timeout: None,
        }
    }
    #[doc = "Roll back the upgrade of a Service Fabric cluster."]
    pub fn rollback_cluster_upgrade(&self) -> rollback_cluster_upgrade::Builder {
        rollback_cluster_upgrade::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Make the cluster upgrade move on to the next upgrade domain."]
    pub fn resume_cluster_upgrade(
        &self,
        resume_cluster_upgrade_description: impl Into<models::ResumeClusterUpgradeDescription>,
    ) -> resume_cluster_upgrade::Builder {
        resume_cluster_upgrade::Builder {
            client: self.clone(),
            resume_cluster_upgrade_description: resume_cluster_upgrade_description.into(),
            timeout: None,
        }
    }
    #[doc = "Start upgrading the code or configuration version of a Service Fabric cluster."]
    pub fn start_cluster_upgrade(
        &self,
        start_cluster_upgrade_description: impl Into<models::StartClusterUpgradeDescription>,
    ) -> start_cluster_upgrade::Builder {
        start_cluster_upgrade::Builder {
            client: self.clone(),
            start_cluster_upgrade_description: start_cluster_upgrade_description.into(),
            timeout: None,
        }
    }
    #[doc = "Start upgrading the configuration of a Service Fabric standalone cluster."]
    pub fn start_cluster_configuration_upgrade(
        &self,
        cluster_configuration_upgrade_description: impl Into<models::ClusterConfigurationUpgradeDescription>,
    ) -> start_cluster_configuration_upgrade::Builder {
        start_cluster_configuration_upgrade::Builder {
            client: self.clone(),
            cluster_configuration_upgrade_description: cluster_configuration_upgrade_description.into(),
            timeout: None,
        }
    }
    #[doc = "Update the upgrade parameters of a Service Fabric cluster upgrade."]
    pub fn update_cluster_upgrade(
        &self,
        update_cluster_upgrade_description: impl Into<models::UpdateClusterUpgradeDescription>,
    ) -> update_cluster_upgrade::Builder {
        update_cluster_upgrade::Builder {
            client: self.clone(),
            update_cluster_upgrade_description: update_cluster_upgrade_description.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the Azure Active Directory metadata used for secured connection to cluster."]
    pub fn get_aad_metadata(&self) -> get_aad_metadata::Builder {
        get_aad_metadata::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Get the current Service Fabric cluster version."]
    pub fn get_cluster_version(&self) -> get_cluster_version::Builder {
        get_cluster_version::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Gets the load of a Service Fabric cluster."]
    pub fn get_cluster_load(&self) -> get_cluster_load::Builder {
        get_cluster_load::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Changes the verbosity of service placement health reporting."]
    pub fn toggle_verbose_service_placement_health_reporting(
        &self,
        enabled: bool,
    ) -> toggle_verbose_service_placement_health_reporting::Builder {
        toggle_verbose_service_placement_health_reporting::Builder {
            client: self.clone(),
            enabled,
            timeout: None,
        }
    }
    #[doc = "Gets the list of nodes in the Service Fabric cluster."]
    pub fn get_node_info_list(&self) -> get_node_info_list::Builder {
        get_node_info_list::Builder {
            client: self.clone(),
            continuation_token: None,
            node_status_filter: None,
            max_results: None,
            timeout: None,
        }
    }
    #[doc = "Gets the information about a specific node in the Service Fabric cluster."]
    pub fn get_node_info(&self, node_name: impl Into<String>) -> get_node_info::Builder {
        get_node_info::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the health of a Service Fabric node."]
    pub fn get_node_health(&self, node_name: impl Into<String>) -> get_node_health::Builder {
        get_node_health::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            events_health_state_filter: None,
            timeout: None,
        }
    }
    #[doc = "Gets the health of a Service Fabric node, by using the specified health policy."]
    pub fn get_node_health_using_policy(&self, node_name: impl Into<String>) -> get_node_health_using_policy::Builder {
        get_node_health_using_policy::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            events_health_state_filter: None,
            cluster_health_policy: None,
            timeout: None,
        }
    }
    #[doc = "Sends a health report on the Service Fabric node."]
    pub fn report_node_health(
        &self,
        node_name: impl Into<String>,
        health_information: impl Into<models::HealthInformation>,
    ) -> report_node_health::Builder {
        report_node_health::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            health_information: health_information.into(),
            immediate: None,
            timeout: None,
        }
    }
    #[doc = "Gets the load information of a Service Fabric node."]
    pub fn get_node_load_info(&self, node_name: impl Into<String>) -> get_node_load_info::Builder {
        get_node_load_info::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            timeout: None,
        }
    }
    #[doc = "Deactivate a Service Fabric cluster node with the specified deactivation intent."]
    pub fn disable_node(
        &self,
        node_name: impl Into<String>,
        deactivation_intent_description: impl Into<models::DeactivationIntentDescription>,
    ) -> disable_node::Builder {
        disable_node::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            deactivation_intent_description: deactivation_intent_description.into(),
            timeout: None,
        }
    }
    #[doc = "Activate a Service Fabric cluster node that is currently deactivated."]
    pub fn enable_node(&self, node_name: impl Into<String>) -> enable_node::Builder {
        enable_node::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            timeout: None,
        }
    }
    #[doc = "Notifies Service Fabric that the persisted state on a node has been permanently removed or lost."]
    pub fn remove_node_state(&self, node_name: impl Into<String>) -> remove_node_state::Builder {
        remove_node_state::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            timeout: None,
        }
    }
    #[doc = "Restarts a Service Fabric cluster node."]
    pub fn restart_node(
        &self,
        node_name: impl Into<String>,
        restart_node_description: impl Into<models::RestartNodeDescription>,
    ) -> restart_node::Builder {
        restart_node::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            restart_node_description: restart_node_description.into(),
            timeout: None,
        }
    }
    #[doc = "Removes configuration overrides on the specified node."]
    pub fn remove_configuration_overrides(&self, node_name: impl Into<String>) -> remove_configuration_overrides::Builder {
        remove_configuration_overrides::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the list of configuration overrides on the specified node."]
    pub fn get_configuration_overrides(&self, node_name: impl Into<String>) -> get_configuration_overrides::Builder {
        get_configuration_overrides::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            timeout: None,
        }
    }
    #[doc = "Adds the list of configuration overrides on the specified node."]
    pub fn add_configuration_parameter_overrides(
        &self,
        node_name: impl Into<String>,
        config_parameter_override_list: impl Into<models::ConfigParameterOverrideList>,
    ) -> add_configuration_parameter_overrides::Builder {
        add_configuration_parameter_overrides::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            config_parameter_override_list: config_parameter_override_list.into(),
            force: None,
            timeout: None,
        }
    }
    #[doc = "Gets the list of application types in the Service Fabric cluster."]
    pub fn get_application_type_info_list(&self) -> get_application_type_info_list::Builder {
        get_application_type_info_list::Builder {
            client: self.clone(),
            application_type_definition_kind_filter: None,
            exclude_application_parameters: None,
            continuation_token: None,
            max_results: None,
            timeout: None,
        }
    }
    #[doc = "Gets the list of application types in the Service Fabric cluster matching exactly the specified name."]
    pub fn get_application_type_info_list_by_name(
        &self,
        application_type_name: impl Into<String>,
    ) -> get_application_type_info_list_by_name::Builder {
        get_application_type_info_list_by_name::Builder {
            client: self.clone(),
            application_type_name: application_type_name.into(),
            application_type_version: None,
            exclude_application_parameters: None,
            continuation_token: None,
            max_results: None,
            timeout: None,
        }
    }
    #[doc = "Provisions or registers a Service Fabric application type with the cluster using the '.sfpkg' package in the external store or using the application package in the image store."]
    pub fn provision_application_type(
        &self,
        provision_application_type_description_base_required_body_param: impl Into<models::ProvisionApplicationTypeDescriptionBase>,
    ) -> provision_application_type::Builder {
        provision_application_type::Builder {
            client: self.clone(),
            provision_application_type_description_base_required_body_param:
                provision_application_type_description_base_required_body_param.into(),
            timeout: None,
        }
    }
    #[doc = "Removes or unregisters a Service Fabric application type from the cluster."]
    pub fn unprovision_application_type(
        &self,
        application_type_name: impl Into<String>,
        unprovision_application_type_description_info: impl Into<models::UnprovisionApplicationTypeDescriptionInfo>,
    ) -> unprovision_application_type::Builder {
        unprovision_application_type::Builder {
            client: self.clone(),
            application_type_name: application_type_name.into(),
            unprovision_application_type_description_info: unprovision_application_type_description_info.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the list containing the information about service types that are supported by a provisioned application type in a Service Fabric cluster."]
    pub fn get_service_type_info_list(
        &self,
        application_type_name: impl Into<String>,
        application_type_version: impl Into<String>,
    ) -> get_service_type_info_list::Builder {
        get_service_type_info_list::Builder {
            client: self.clone(),
            application_type_name: application_type_name.into(),
            application_type_version: application_type_version.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the information about a specific service type that is supported by a provisioned application type in a Service Fabric cluster."]
    pub fn get_service_type_info_by_name(
        &self,
        application_type_name: impl Into<String>,
        application_type_version: impl Into<String>,
        service_type_name: impl Into<String>,
    ) -> get_service_type_info_by_name::Builder {
        get_service_type_info_by_name::Builder {
            client: self.clone(),
            application_type_name: application_type_name.into(),
            application_type_version: application_type_version.into(),
            service_type_name: service_type_name.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the manifest describing a service type."]
    pub fn get_service_manifest(
        &self,
        application_type_name: impl Into<String>,
        application_type_version: impl Into<String>,
        service_manifest_name: impl Into<String>,
    ) -> get_service_manifest::Builder {
        get_service_manifest::Builder {
            client: self.clone(),
            application_type_name: application_type_name.into(),
            application_type_version: application_type_version.into(),
            service_manifest_name: service_manifest_name.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the list containing the information about service types from the applications deployed on a node in a Service Fabric cluster."]
    pub fn get_deployed_service_type_info_list(
        &self,
        node_name: impl Into<String>,
        application_id: impl Into<String>,
    ) -> get_deployed_service_type_info_list::Builder {
        get_deployed_service_type_info_list::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            application_id: application_id.into(),
            service_manifest_name: None,
            timeout: None,
        }
    }
    #[doc = "Gets the information about a specified service type of the application deployed on a node in a Service Fabric cluster."]
    pub fn get_deployed_service_type_info_by_name(
        &self,
        node_name: impl Into<String>,
        application_id: impl Into<String>,
        service_type_name: impl Into<String>,
    ) -> get_deployed_service_type_info_by_name::Builder {
        get_deployed_service_type_info_by_name::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            application_id: application_id.into(),
            service_type_name: service_type_name.into(),
            service_manifest_name: None,
            timeout: None,
        }
    }
    #[doc = "Creates a Service Fabric application."]
    pub fn create_application(&self, application_description: impl Into<models::ApplicationDescription>) -> create_application::Builder {
        create_application::Builder {
            client: self.clone(),
            application_description: application_description.into(),
            timeout: None,
        }
    }
    #[doc = "Deletes an existing Service Fabric application."]
    pub fn delete_application(&self, application_id: impl Into<String>) -> delete_application::Builder {
        delete_application::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            force_remove: None,
            timeout: None,
        }
    }
    #[doc = "Gets load information about a Service Fabric application."]
    pub fn get_application_load_info(&self, application_id: impl Into<String>) -> get_application_load_info::Builder {
        get_application_load_info::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the list of applications created in the Service Fabric cluster that match the specified filters."]
    pub fn get_application_info_list(&self) -> get_application_info_list::Builder {
        get_application_info_list::Builder {
            client: self.clone(),
            application_definition_kind_filter: None,
            application_type_name: None,
            exclude_application_parameters: None,
            continuation_token: None,
            max_results: None,
            timeout: None,
        }
    }
    #[doc = "Gets information about a Service Fabric application."]
    pub fn get_application_info(&self, application_id: impl Into<String>) -> get_application_info::Builder {
        get_application_info::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            exclude_application_parameters: None,
            timeout: None,
        }
    }
    #[doc = "Gets the health of the service fabric application."]
    pub fn get_application_health(&self, application_id: impl Into<String>) -> get_application_health::Builder {
        get_application_health::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            events_health_state_filter: None,
            deployed_applications_health_state_filter: None,
            services_health_state_filter: None,
            exclude_health_statistics: None,
            timeout: None,
        }
    }
    #[doc = "Gets the health of a Service Fabric application using the specified policy."]
    pub fn get_application_health_using_policy(&self, application_id: impl Into<String>) -> get_application_health_using_policy::Builder {
        get_application_health_using_policy::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            events_health_state_filter: None,
            deployed_applications_health_state_filter: None,
            services_health_state_filter: None,
            exclude_health_statistics: None,
            application_health_policy: None,
            timeout: None,
        }
    }
    #[doc = "Sends a health report on the Service Fabric application."]
    pub fn report_application_health(
        &self,
        application_id: impl Into<String>,
        health_information: impl Into<models::HealthInformation>,
    ) -> report_application_health::Builder {
        report_application_health::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            health_information: health_information.into(),
            immediate: None,
            timeout: None,
        }
    }
    #[doc = "Starts upgrading an application in the Service Fabric cluster."]
    pub fn start_application_upgrade(
        &self,
        application_id: impl Into<String>,
        application_upgrade_description: impl Into<models::ApplicationUpgradeDescription>,
    ) -> start_application_upgrade::Builder {
        start_application_upgrade::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            application_upgrade_description: application_upgrade_description.into(),
            timeout: None,
        }
    }
    #[doc = "Gets details for the latest upgrade performed on this application."]
    pub fn get_application_upgrade(&self, application_id: impl Into<String>) -> get_application_upgrade::Builder {
        get_application_upgrade::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            timeout: None,
        }
    }
    #[doc = "Updates an ongoing application upgrade in the Service Fabric cluster."]
    pub fn update_application_upgrade(
        &self,
        application_id: impl Into<String>,
        application_upgrade_update_description: impl Into<models::ApplicationUpgradeUpdateDescription>,
    ) -> update_application_upgrade::Builder {
        update_application_upgrade::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            application_upgrade_update_description: application_upgrade_update_description.into(),
            timeout: None,
        }
    }
    #[doc = "Resumes upgrading an application in the Service Fabric cluster."]
    pub fn resume_application_upgrade(
        &self,
        application_id: impl Into<String>,
        resume_application_upgrade_description: impl Into<models::ResumeApplicationUpgradeDescription>,
    ) -> resume_application_upgrade::Builder {
        resume_application_upgrade::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            resume_application_upgrade_description: resume_application_upgrade_description.into(),
            timeout: None,
        }
    }
    #[doc = "Starts rolling back the currently on-going upgrade of an application in the Service Fabric cluster."]
    pub fn rollback_application_upgrade(&self, application_id: impl Into<String>) -> rollback_application_upgrade::Builder {
        rollback_application_upgrade::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the list of applications deployed on a Service Fabric node."]
    pub fn get_deployed_application_info_list(&self, node_name: impl Into<String>) -> get_deployed_application_info_list::Builder {
        get_deployed_application_info_list::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            timeout: None,
            include_health_state: None,
            continuation_token: None,
            max_results: None,
        }
    }
    #[doc = "Gets the information about an application deployed on a Service Fabric node."]
    pub fn get_deployed_application_info(
        &self,
        node_name: impl Into<String>,
        application_id: impl Into<String>,
    ) -> get_deployed_application_info::Builder {
        get_deployed_application_info::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            application_id: application_id.into(),
            timeout: None,
            include_health_state: None,
        }
    }
    #[doc = "Gets the information about health of an application deployed on a Service Fabric node."]
    pub fn get_deployed_application_health(
        &self,
        node_name: impl Into<String>,
        application_id: impl Into<String>,
    ) -> get_deployed_application_health::Builder {
        get_deployed_application_health::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            application_id: application_id.into(),
            events_health_state_filter: None,
            deployed_service_packages_health_state_filter: None,
            exclude_health_statistics: None,
            timeout: None,
        }
    }
    #[doc = "Gets the information about health of an application deployed on a Service Fabric node. using the specified policy."]
    pub fn get_deployed_application_health_using_policy(
        &self,
        node_name: impl Into<String>,
        application_id: impl Into<String>,
    ) -> get_deployed_application_health_using_policy::Builder {
        get_deployed_application_health_using_policy::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            application_id: application_id.into(),
            events_health_state_filter: None,
            deployed_service_packages_health_state_filter: None,
            application_health_policy: None,
            exclude_health_statistics: None,
            timeout: None,
        }
    }
    #[doc = "Sends a health report on the Service Fabric application deployed on a Service Fabric node."]
    pub fn report_deployed_application_health(
        &self,
        node_name: impl Into<String>,
        application_id: impl Into<String>,
        health_information: impl Into<models::HealthInformation>,
    ) -> report_deployed_application_health::Builder {
        report_deployed_application_health::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            application_id: application_id.into(),
            health_information: health_information.into(),
            immediate: None,
            timeout: None,
        }
    }
    #[doc = "Gets the manifest describing an application type."]
    pub fn get_application_manifest(
        &self,
        application_type_name: impl Into<String>,
        application_type_version: impl Into<String>,
    ) -> get_application_manifest::Builder {
        get_application_manifest::Builder {
            client: self.clone(),
            application_type_name: application_type_name.into(),
            application_type_version: application_type_version.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the information about all services belonging to the application specified by the application ID."]
    pub fn get_service_info_list(&self, application_id: impl Into<String>) -> get_service_info_list::Builder {
        get_service_info_list::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            service_type_name: None,
            continuation_token: None,
            timeout: None,
        }
    }
    #[doc = "Gets the information about the specific service belonging to the Service Fabric application."]
    pub fn get_service_info(&self, application_id: impl Into<String>, service_id: impl Into<String>) -> get_service_info::Builder {
        get_service_info::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            service_id: service_id.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the name of the Service Fabric application for a service."]
    pub fn get_application_name_info(&self, service_id: impl Into<String>) -> get_application_name_info::Builder {
        get_application_name_info::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            timeout: None,
        }
    }
    #[doc = "Creates the specified Service Fabric service."]
    pub fn create_service(
        &self,
        application_id: impl Into<String>,
        service_description: impl Into<models::ServiceDescription>,
    ) -> create_service::Builder {
        create_service::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            service_description: service_description.into(),
            timeout: None,
        }
    }
    #[doc = "Creates a Service Fabric service from the service template."]
    pub fn create_service_from_template(
        &self,
        application_id: impl Into<String>,
        service_from_template_description: impl Into<models::ServiceFromTemplateDescription>,
    ) -> create_service_from_template::Builder {
        create_service_from_template::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            service_from_template_description: service_from_template_description.into(),
            timeout: None,
        }
    }
    #[doc = "Deletes an existing Service Fabric service."]
    pub fn delete_service(&self, service_id: impl Into<String>) -> delete_service::Builder {
        delete_service::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            force_remove: None,
            timeout: None,
        }
    }
    #[doc = "Updates a Service Fabric service using the specified update description."]
    pub fn update_service(
        &self,
        service_id: impl Into<String>,
        service_update_description: impl Into<models::ServiceUpdateDescription>,
    ) -> update_service::Builder {
        update_service::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            service_update_description: service_update_description.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the description of an existing Service Fabric service."]
    pub fn get_service_description(&self, service_id: impl Into<String>) -> get_service_description::Builder {
        get_service_description::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the health of the specified Service Fabric service."]
    pub fn get_service_health(&self, service_id: impl Into<String>) -> get_service_health::Builder {
        get_service_health::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            events_health_state_filter: None,
            partitions_health_state_filter: None,
            exclude_health_statistics: None,
            timeout: None,
        }
    }
    #[doc = "Gets the health of the specified Service Fabric service, by using the specified health policy."]
    pub fn get_service_health_using_policy(&self, service_id: impl Into<String>) -> get_service_health_using_policy::Builder {
        get_service_health_using_policy::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            events_health_state_filter: None,
            partitions_health_state_filter: None,
            application_health_policy: None,
            exclude_health_statistics: None,
            timeout: None,
        }
    }
    #[doc = "Sends a health report on the Service Fabric service."]
    pub fn report_service_health(
        &self,
        service_id: impl Into<String>,
        health_information: impl Into<models::HealthInformation>,
    ) -> report_service_health::Builder {
        report_service_health::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            health_information: health_information.into(),
            immediate: None,
            timeout: None,
        }
    }
    #[doc = "Resolve a Service Fabric partition."]
    pub fn resolve_service(&self, service_id: impl Into<String>) -> resolve_service::Builder {
        resolve_service::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            partition_key_type: None,
            partition_key_value: None,
            previous_rsp_version: None,
            timeout: None,
        }
    }
    #[doc = "Gets the information about unplaced replica of the service."]
    pub fn get_unplaced_replica_information(&self, service_id: impl Into<String>) -> get_unplaced_replica_information::Builder {
        get_unplaced_replica_information::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            partition_id: None,
            only_query_primaries: None,
            timeout: None,
        }
    }
    #[doc = "Gets the list of partitions of a Service Fabric service."]
    pub fn get_partition_info_list(&self, service_id: impl Into<String>) -> get_partition_info_list::Builder {
        get_partition_info_list::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            continuation_token: None,
            timeout: None,
        }
    }
    #[doc = "Gets the information about a Service Fabric partition."]
    pub fn get_partition_info(&self, partition_id: impl Into<String>) -> get_partition_info::Builder {
        get_partition_info::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the name of the Service Fabric service for a partition."]
    pub fn get_service_name_info(&self, partition_id: impl Into<String>) -> get_service_name_info::Builder {
        get_service_name_info::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the health of the specified Service Fabric partition."]
    pub fn get_partition_health(&self, partition_id: impl Into<String>) -> get_partition_health::Builder {
        get_partition_health::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            events_health_state_filter: None,
            replicas_health_state_filter: None,
            exclude_health_statistics: None,
            timeout: None,
        }
    }
    #[doc = "Gets the health of the specified Service Fabric partition, by using the specified health policy."]
    pub fn get_partition_health_using_policy(&self, partition_id: impl Into<String>) -> get_partition_health_using_policy::Builder {
        get_partition_health_using_policy::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            events_health_state_filter: None,
            replicas_health_state_filter: None,
            application_health_policy: None,
            exclude_health_statistics: None,
            timeout: None,
        }
    }
    #[doc = "Sends a health report on the Service Fabric partition."]
    pub fn report_partition_health(
        &self,
        partition_id: impl Into<String>,
        health_information: impl Into<models::HealthInformation>,
    ) -> report_partition_health::Builder {
        report_partition_health::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            health_information: health_information.into(),
            immediate: None,
            timeout: None,
        }
    }
    #[doc = "Gets the load information of the specified Service Fabric partition."]
    pub fn get_partition_load_information(&self, partition_id: impl Into<String>) -> get_partition_load_information::Builder {
        get_partition_load_information::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            timeout: None,
        }
    }
    #[doc = "Resets the current load of a Service Fabric partition."]
    pub fn reset_partition_load(&self, partition_id: impl Into<String>) -> reset_partition_load::Builder {
        reset_partition_load::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            timeout: None,
        }
    }
    #[doc = "Indicates to the Service Fabric cluster that it should attempt to recover a specific partition that is currently stuck in quorum loss."]
    pub fn recover_partition(&self, partition_id: impl Into<String>) -> recover_partition::Builder {
        recover_partition::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            timeout: None,
        }
    }
    #[doc = "Indicates to the Service Fabric cluster that it should attempt to recover the specified service that is currently stuck in quorum loss."]
    pub fn recover_service_partitions(&self, service_id: impl Into<String>) -> recover_service_partitions::Builder {
        recover_service_partitions::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            timeout: None,
        }
    }
    #[doc = "Indicates to the Service Fabric cluster that it should attempt to recover the system services that are currently stuck in quorum loss."]
    pub fn recover_system_partitions(&self) -> recover_system_partitions::Builder {
        recover_system_partitions::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Indicates to the Service Fabric cluster that it should attempt to recover any services (including system services) which are currently stuck in quorum loss."]
    pub fn recover_all_partitions(&self) -> recover_all_partitions::Builder {
        recover_all_partitions::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Moves the primary replica of a partition of a stateful service."]
    pub fn move_primary_replica(&self, partition_id: impl Into<String>) -> move_primary_replica::Builder {
        move_primary_replica::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            node_name: None,
            ignore_constraints: None,
            timeout: None,
        }
    }
    #[doc = "Moves the secondary replica of a partition of a stateful service."]
    pub fn move_secondary_replica(
        &self,
        partition_id: impl Into<String>,
        current_node_name: impl Into<String>,
    ) -> move_secondary_replica::Builder {
        move_secondary_replica::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            current_node_name: current_node_name.into(),
            new_node_name: None,
            ignore_constraints: None,
            timeout: None,
        }
    }
    #[doc = "Creates a new repair task."]
    pub fn create_repair_task(&self, repair_task: impl Into<models::RepairTask>) -> create_repair_task::Builder {
        create_repair_task::Builder {
            client: self.clone(),
            repair_task: repair_task.into(),
        }
    }
    #[doc = "Requests the cancellation of the given repair task."]
    pub fn cancel_repair_task(
        &self,
        repair_task_cancel_description: impl Into<models::RepairTaskCancelDescription>,
    ) -> cancel_repair_task::Builder {
        cancel_repair_task::Builder {
            client: self.clone(),
            repair_task_cancel_description: repair_task_cancel_description.into(),
        }
    }
    #[doc = "Deletes a completed repair task."]
    pub fn delete_repair_task(
        &self,
        repair_task_delete_description: impl Into<models::RepairTaskDeleteDescription>,
    ) -> delete_repair_task::Builder {
        delete_repair_task::Builder {
            client: self.clone(),
            repair_task_delete_description: repair_task_delete_description.into(),
        }
    }
    #[doc = "Gets a list of repair tasks matching the given filters."]
    pub fn get_repair_task_list(&self) -> get_repair_task_list::Builder {
        get_repair_task_list::Builder {
            client: self.clone(),
            task_id_filter: None,
            state_filter: None,
            executor_filter: None,
        }
    }
    #[doc = "Forces the approval of the given repair task."]
    pub fn force_approve_repair_task(
        &self,
        repair_task_approve_description: impl Into<models::RepairTaskApproveDescription>,
    ) -> force_approve_repair_task::Builder {
        force_approve_repair_task::Builder {
            client: self.clone(),
            repair_task_approve_description: repair_task_approve_description.into(),
        }
    }
    #[doc = "Updates the health policy of the given repair task."]
    pub fn update_repair_task_health_policy(
        &self,
        repair_task_update_health_policy_description: impl Into<models::RepairTaskUpdateHealthPolicyDescription>,
    ) -> update_repair_task_health_policy::Builder {
        update_repair_task_health_policy::Builder {
            client: self.clone(),
            repair_task_update_health_policy_description: repair_task_update_health_policy_description.into(),
        }
    }
    #[doc = "Updates the execution state of a repair task."]
    pub fn update_repair_execution_state(&self, repair_task: impl Into<models::RepairTask>) -> update_repair_execution_state::Builder {
        update_repair_execution_state::Builder {
            client: self.clone(),
            repair_task: repair_task.into(),
        }
    }
    #[doc = "Gets the information about replicas of a Service Fabric service partition."]
    pub fn get_replica_info_list(&self, partition_id: impl Into<String>) -> get_replica_info_list::Builder {
        get_replica_info_list::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            continuation_token: None,
            timeout: None,
        }
    }
    #[doc = "Gets the information about a replica of a Service Fabric partition."]
    pub fn get_replica_info(&self, partition_id: impl Into<String>, replica_id: impl Into<String>) -> get_replica_info::Builder {
        get_replica_info::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            replica_id: replica_id.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the health of a Service Fabric stateful service replica or stateless service instance."]
    pub fn get_replica_health(&self, partition_id: impl Into<String>, replica_id: impl Into<String>) -> get_replica_health::Builder {
        get_replica_health::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            replica_id: replica_id.into(),
            events_health_state_filter: None,
            timeout: None,
        }
    }
    #[doc = "Gets the health of a Service Fabric stateful service replica or stateless service instance using the specified policy."]
    pub fn get_replica_health_using_policy(
        &self,
        partition_id: impl Into<String>,
        replica_id: impl Into<String>,
    ) -> get_replica_health_using_policy::Builder {
        get_replica_health_using_policy::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            replica_id: replica_id.into(),
            events_health_state_filter: None,
            application_health_policy: None,
            timeout: None,
        }
    }
    #[doc = "Sends a health report on the Service Fabric replica."]
    pub fn report_replica_health(
        &self,
        partition_id: impl Into<String>,
        replica_id: impl Into<String>,
        service_kind: impl Into<String>,
        health_information: impl Into<models::HealthInformation>,
    ) -> report_replica_health::Builder {
        report_replica_health::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            replica_id: replica_id.into(),
            service_kind: service_kind.into(),
            health_information: health_information.into(),
            immediate: None,
            timeout: None,
        }
    }
    #[doc = "Gets the list of replicas deployed on a Service Fabric node."]
    pub fn get_deployed_service_replica_info_list(
        &self,
        node_name: impl Into<String>,
        application_id: impl Into<String>,
    ) -> get_deployed_service_replica_info_list::Builder {
        get_deployed_service_replica_info_list::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            application_id: application_id.into(),
            partition_id: None,
            service_manifest_name: None,
            timeout: None,
        }
    }
    #[doc = "Gets the details of replica deployed on a Service Fabric node."]
    pub fn get_deployed_service_replica_detail_info(
        &self,
        node_name: impl Into<String>,
        partition_id: impl Into<String>,
        replica_id: impl Into<String>,
    ) -> get_deployed_service_replica_detail_info::Builder {
        get_deployed_service_replica_detail_info::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            partition_id: partition_id.into(),
            replica_id: replica_id.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the details of replica deployed on a Service Fabric node."]
    pub fn get_deployed_service_replica_detail_info_by_partition_id(
        &self,
        node_name: impl Into<String>,
        partition_id: impl Into<String>,
    ) -> get_deployed_service_replica_detail_info_by_partition_id::Builder {
        get_deployed_service_replica_detail_info_by_partition_id::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            partition_id: partition_id.into(),
            timeout: None,
        }
    }
    #[doc = "Restarts a service replica of a persisted service running on a node."]
    pub fn restart_replica(
        &self,
        node_name: impl Into<String>,
        partition_id: impl Into<String>,
        replica_id: impl Into<String>,
    ) -> restart_replica::Builder {
        restart_replica::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            partition_id: partition_id.into(),
            replica_id: replica_id.into(),
            timeout: None,
        }
    }
    #[doc = "Removes a service replica running on a node."]
    pub fn remove_replica(
        &self,
        node_name: impl Into<String>,
        partition_id: impl Into<String>,
        replica_id: impl Into<String>,
    ) -> remove_replica::Builder {
        remove_replica::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            partition_id: partition_id.into(),
            replica_id: replica_id.into(),
            force_remove: None,
            timeout: None,
        }
    }
    #[doc = "Gets the list of service packages deployed on a Service Fabric node."]
    pub fn get_deployed_service_package_info_list(
        &self,
        node_name: impl Into<String>,
        application_id: impl Into<String>,
    ) -> get_deployed_service_package_info_list::Builder {
        get_deployed_service_package_info_list::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            application_id: application_id.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the list of service packages deployed on a Service Fabric node matching exactly the specified name."]
    pub fn get_deployed_service_package_info_list_by_name(
        &self,
        node_name: impl Into<String>,
        application_id: impl Into<String>,
        service_package_name: impl Into<String>,
    ) -> get_deployed_service_package_info_list_by_name::Builder {
        get_deployed_service_package_info_list_by_name::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            application_id: application_id.into(),
            service_package_name: service_package_name.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the information about health of a service package for a specific application deployed for a Service Fabric node and application."]
    pub fn get_deployed_service_package_health(
        &self,
        node_name: impl Into<String>,
        application_id: impl Into<String>,
        service_package_name: impl Into<String>,
    ) -> get_deployed_service_package_health::Builder {
        get_deployed_service_package_health::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            application_id: application_id.into(),
            service_package_name: service_package_name.into(),
            events_health_state_filter: None,
            timeout: None,
        }
    }
    #[doc = "Gets the information about health of service package for a specific application deployed on a Service Fabric node using the specified policy."]
    pub fn get_deployed_service_package_health_using_policy(
        &self,
        node_name: impl Into<String>,
        application_id: impl Into<String>,
        service_package_name: impl Into<String>,
    ) -> get_deployed_service_package_health_using_policy::Builder {
        get_deployed_service_package_health_using_policy::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            application_id: application_id.into(),
            service_package_name: service_package_name.into(),
            events_health_state_filter: None,
            application_health_policy: None,
            timeout: None,
        }
    }
    #[doc = "Sends a health report on the Service Fabric deployed service package."]
    pub fn report_deployed_service_package_health(
        &self,
        node_name: impl Into<String>,
        application_id: impl Into<String>,
        service_package_name: impl Into<String>,
        health_information: impl Into<models::HealthInformation>,
    ) -> report_deployed_service_package_health::Builder {
        report_deployed_service_package_health::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            application_id: application_id.into(),
            service_package_name: service_package_name.into(),
            health_information: health_information.into(),
            immediate: None,
            timeout: None,
        }
    }
    #[doc = "Downloads all of the code packages associated with specified service manifest on the specified node."]
    pub fn deploy_service_package_to_node(
        &self,
        node_name: impl Into<String>,
        deploy_service_package_to_node_description: impl Into<models::DeployServicePackageToNodeDescription>,
    ) -> deploy_service_package_to_node::Builder {
        deploy_service_package_to_node::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            deploy_service_package_to_node_description: deploy_service_package_to_node_description.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the list of code packages deployed on a Service Fabric node."]
    pub fn get_deployed_code_package_info_list(
        &self,
        node_name: impl Into<String>,
        application_id: impl Into<String>,
    ) -> get_deployed_code_package_info_list::Builder {
        get_deployed_code_package_info_list::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            application_id: application_id.into(),
            service_manifest_name: None,
            code_package_name: None,
            timeout: None,
        }
    }
    #[doc = "Restarts a code package deployed on a Service Fabric node in a cluster."]
    pub fn restart_deployed_code_package(
        &self,
        node_name: impl Into<String>,
        application_id: impl Into<String>,
        restart_deployed_code_package_description: impl Into<models::RestartDeployedCodePackageDescription>,
    ) -> restart_deployed_code_package::Builder {
        restart_deployed_code_package::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            application_id: application_id.into(),
            restart_deployed_code_package_description: restart_deployed_code_package_description.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the container logs for container deployed on a Service Fabric node."]
    pub fn get_container_logs_deployed_on_node(
        &self,
        node_name: impl Into<String>,
        application_id: impl Into<String>,
        service_manifest_name: impl Into<String>,
        code_package_name: impl Into<String>,
    ) -> get_container_logs_deployed_on_node::Builder {
        get_container_logs_deployed_on_node::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            application_id: application_id.into(),
            service_manifest_name: service_manifest_name.into(),
            code_package_name: code_package_name.into(),
            tail: None,
            previous: None,
            timeout: None,
        }
    }
    #[doc = "Invoke container API on a container deployed on a Service Fabric node."]
    pub fn invoke_container_api(
        &self,
        node_name: impl Into<String>,
        application_id: impl Into<String>,
        service_manifest_name: impl Into<String>,
        code_package_name: impl Into<String>,
        code_package_instance_id: impl Into<String>,
        container_api_request_body: impl Into<models::ContainerApiRequestBody>,
    ) -> invoke_container_api::Builder {
        invoke_container_api::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            application_id: application_id.into(),
            service_manifest_name: service_manifest_name.into(),
            code_package_name: code_package_name.into(),
            code_package_instance_id: code_package_instance_id.into(),
            container_api_request_body: container_api_request_body.into(),
            timeout: None,
        }
    }
    #[doc = "Creates a Service Fabric compose deployment."]
    pub fn create_compose_deployment(
        &self,
        create_compose_deployment_description: impl Into<models::CreateComposeDeploymentDescription>,
    ) -> create_compose_deployment::Builder {
        create_compose_deployment::Builder {
            client: self.clone(),
            create_compose_deployment_description: create_compose_deployment_description.into(),
            timeout: None,
        }
    }
    #[doc = "Gets information about a Service Fabric compose deployment."]
    pub fn get_compose_deployment_status(&self, deployment_name: impl Into<String>) -> get_compose_deployment_status::Builder {
        get_compose_deployment_status::Builder {
            client: self.clone(),
            deployment_name: deployment_name.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the list of compose deployments created in the Service Fabric cluster."]
    pub fn get_compose_deployment_status_list(&self) -> get_compose_deployment_status_list::Builder {
        get_compose_deployment_status_list::Builder {
            client: self.clone(),
            continuation_token: None,
            max_results: None,
            timeout: None,
        }
    }
    #[doc = "Gets details for the latest upgrade performed on this Service Fabric compose deployment."]
    pub fn get_compose_deployment_upgrade_progress(
        &self,
        deployment_name: impl Into<String>,
    ) -> get_compose_deployment_upgrade_progress::Builder {
        get_compose_deployment_upgrade_progress::Builder {
            client: self.clone(),
            deployment_name: deployment_name.into(),
            timeout: None,
        }
    }
    #[doc = "Deletes an existing Service Fabric compose deployment from cluster."]
    pub fn remove_compose_deployment(&self, deployment_name: impl Into<String>) -> remove_compose_deployment::Builder {
        remove_compose_deployment::Builder {
            client: self.clone(),
            deployment_name: deployment_name.into(),
            timeout: None,
        }
    }
    #[doc = "Starts upgrading a compose deployment in the Service Fabric cluster."]
    pub fn start_compose_deployment_upgrade(
        &self,
        deployment_name: impl Into<String>,
        compose_deployment_upgrade_description: impl Into<models::ComposeDeploymentUpgradeDescription>,
    ) -> start_compose_deployment_upgrade::Builder {
        start_compose_deployment_upgrade::Builder {
            client: self.clone(),
            deployment_name: deployment_name.into(),
            compose_deployment_upgrade_description: compose_deployment_upgrade_description.into(),
            timeout: None,
        }
    }
    #[doc = "Starts rolling back a compose deployment upgrade in the Service Fabric cluster."]
    pub fn start_rollback_compose_deployment_upgrade(
        &self,
        deployment_name: impl Into<String>,
    ) -> start_rollback_compose_deployment_upgrade::Builder {
        start_rollback_compose_deployment_upgrade::Builder {
            client: self.clone(),
            deployment_name: deployment_name.into(),
            timeout: None,
        }
    }
    #[doc = "Get the status of Chaos."]
    pub fn get_chaos(&self) -> get_chaos::Builder {
        get_chaos::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Starts Chaos in the cluster."]
    pub fn start_chaos(&self, chaos_parameters: impl Into<models::ChaosParameters>) -> start_chaos::Builder {
        start_chaos::Builder {
            client: self.clone(),
            chaos_parameters: chaos_parameters.into(),
            timeout: None,
        }
    }
    #[doc = "Stops Chaos if it is running in the cluster and put the Chaos Schedule in a stopped state."]
    pub fn stop_chaos(&self) -> stop_chaos::Builder {
        stop_chaos::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Gets the next segment of the Chaos events based on the continuation token or the time range."]
    pub fn get_chaos_events(&self) -> get_chaos_events::Builder {
        get_chaos_events::Builder {
            client: self.clone(),
            continuation_token: None,
            start_time_utc: None,
            end_time_utc: None,
            max_results: None,
            timeout: None,
        }
    }
    #[doc = "Get the Chaos Schedule defining when and how to run Chaos."]
    pub fn get_chaos_schedule(&self) -> get_chaos_schedule::Builder {
        get_chaos_schedule::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Set the schedule used by Chaos."]
    pub fn post_chaos_schedule(&self, chaos_schedule: impl Into<models::ChaosScheduleDescription>) -> post_chaos_schedule::Builder {
        post_chaos_schedule::Builder {
            client: self.clone(),
            chaos_schedule: chaos_schedule.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the image store content information."]
    pub fn get_image_store_content(&self, content_path: impl Into<String>) -> get_image_store_content::Builder {
        get_image_store_content::Builder {
            client: self.clone(),
            content_path: content_path.into(),
            timeout: None,
        }
    }
    #[doc = "Uploads contents of the file to the image store."]
    pub fn upload_file(&self, content_path: impl Into<String>) -> upload_file::Builder {
        upload_file::Builder {
            client: self.clone(),
            content_path: content_path.into(),
            timeout: None,
        }
    }
    #[doc = "Deletes existing image store content."]
    pub fn delete_image_store_content(&self, content_path: impl Into<String>) -> delete_image_store_content::Builder {
        delete_image_store_content::Builder {
            client: self.clone(),
            content_path: content_path.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the content information at the root of the image store."]
    pub fn get_image_store_root_content(&self) -> get_image_store_root_content::Builder {
        get_image_store_root_content::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Copies image store content internally"]
    pub fn copy_image_store_content(
        &self,
        image_store_copy_description: impl Into<models::ImageStoreCopyDescription>,
    ) -> copy_image_store_content::Builder {
        copy_image_store_content::Builder {
            client: self.clone(),
            image_store_copy_description: image_store_copy_description.into(),
            timeout: None,
        }
    }
    #[doc = "Cancels an image store upload session."]
    pub fn delete_image_store_upload_session(&self, session_id: impl Into<String>) -> delete_image_store_upload_session::Builder {
        delete_image_store_upload_session::Builder {
            client: self.clone(),
            session_id: session_id.into(),
            timeout: None,
        }
    }
    #[doc = "Commit an image store upload session."]
    pub fn commit_image_store_upload_session(&self, session_id: impl Into<String>) -> commit_image_store_upload_session::Builder {
        commit_image_store_upload_session::Builder {
            client: self.clone(),
            session_id: session_id.into(),
            timeout: None,
        }
    }
    #[doc = "Get the image store upload session by ID."]
    pub fn get_image_store_upload_session_by_id(&self, session_id: impl Into<String>) -> get_image_store_upload_session_by_id::Builder {
        get_image_store_upload_session_by_id::Builder {
            client: self.clone(),
            session_id: session_id.into(),
            timeout: None,
        }
    }
    #[doc = "Get the image store upload session by relative path."]
    pub fn get_image_store_upload_session_by_path(
        &self,
        content_path: impl Into<String>,
    ) -> get_image_store_upload_session_by_path::Builder {
        get_image_store_upload_session_by_path::Builder {
            client: self.clone(),
            content_path: content_path.into(),
            timeout: None,
        }
    }
    #[doc = "Uploads a file chunk to the image store relative path."]
    pub fn upload_file_chunk(
        &self,
        content_path: impl Into<String>,
        session_id: impl Into<String>,
        content_range: impl Into<String>,
    ) -> upload_file_chunk::Builder {
        upload_file_chunk::Builder {
            client: self.clone(),
            content_path: content_path.into(),
            session_id: session_id.into(),
            content_range: content_range.into(),
            timeout: None,
        }
    }
    #[doc = "Get the folder size at the root of the image store."]
    pub fn get_image_store_root_folder_size(&self) -> get_image_store_root_folder_size::Builder {
        get_image_store_root_folder_size::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Get the size of a folder in image store"]
    pub fn get_image_store_folder_size(&self, content_path: impl Into<String>) -> get_image_store_folder_size::Builder {
        get_image_store_folder_size::Builder {
            client: self.clone(),
            content_path: content_path.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the overall ImageStore information"]
    pub fn get_image_store_info(&self) -> get_image_store_info::Builder {
        get_image_store_info::Builder {
            client: self.clone(),
            timeout: None,
        }
    }
    #[doc = "Invokes an administrative command on the given Infrastructure Service instance."]
    pub fn invoke_infrastructure_command(&self, command: impl Into<String>) -> invoke_infrastructure_command::Builder {
        invoke_infrastructure_command::Builder {
            client: self.clone(),
            command: command.into(),
            service_id: None,
            timeout: None,
        }
    }
    #[doc = "Invokes a read-only query on the given infrastructure service instance."]
    pub fn invoke_infrastructure_query(&self, command: impl Into<String>) -> invoke_infrastructure_query::Builder {
        invoke_infrastructure_query::Builder {
            client: self.clone(),
            command: command.into(),
            service_id: None,
            timeout: None,
        }
    }
    #[doc = "This API will induce data loss for the specified partition. It will trigger a call to the OnDataLossAsync API of the partition."]
    pub fn start_data_loss(
        &self,
        service_id: impl Into<String>,
        partition_id: impl Into<String>,
        operation_id: impl Into<String>,
        data_loss_mode: impl Into<String>,
    ) -> start_data_loss::Builder {
        start_data_loss::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            partition_id: partition_id.into(),
            operation_id: operation_id.into(),
            data_loss_mode: data_loss_mode.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the progress of a partition data loss operation started using the StartDataLoss API."]
    pub fn get_data_loss_progress(
        &self,
        service_id: impl Into<String>,
        partition_id: impl Into<String>,
        operation_id: impl Into<String>,
    ) -> get_data_loss_progress::Builder {
        get_data_loss_progress::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            partition_id: partition_id.into(),
            operation_id: operation_id.into(),
            timeout: None,
        }
    }
    #[doc = "Induces quorum loss for a given stateful service partition."]
    pub fn start_quorum_loss(
        &self,
        service_id: impl Into<String>,
        partition_id: impl Into<String>,
        operation_id: impl Into<String>,
        quorum_loss_mode: impl Into<String>,
        quorum_loss_duration: i64,
    ) -> start_quorum_loss::Builder {
        start_quorum_loss::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            partition_id: partition_id.into(),
            operation_id: operation_id.into(),
            quorum_loss_mode: quorum_loss_mode.into(),
            quorum_loss_duration,
            timeout: None,
        }
    }
    #[doc = "Gets the progress of a quorum loss operation on a partition started using the StartQuorumLoss API."]
    pub fn get_quorum_loss_progress(
        &self,
        service_id: impl Into<String>,
        partition_id: impl Into<String>,
        operation_id: impl Into<String>,
    ) -> get_quorum_loss_progress::Builder {
        get_quorum_loss_progress::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            partition_id: partition_id.into(),
            operation_id: operation_id.into(),
            timeout: None,
        }
    }
    #[doc = "This API will restart some or all replicas or instances of the specified partition."]
    pub fn start_partition_restart(
        &self,
        service_id: impl Into<String>,
        partition_id: impl Into<String>,
        operation_id: impl Into<String>,
        restart_partition_mode: impl Into<String>,
    ) -> start_partition_restart::Builder {
        start_partition_restart::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            partition_id: partition_id.into(),
            operation_id: operation_id.into(),
            restart_partition_mode: restart_partition_mode.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the progress of a PartitionRestart operation started using StartPartitionRestart."]
    pub fn get_partition_restart_progress(
        &self,
        service_id: impl Into<String>,
        partition_id: impl Into<String>,
        operation_id: impl Into<String>,
    ) -> get_partition_restart_progress::Builder {
        get_partition_restart_progress::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            partition_id: partition_id.into(),
            operation_id: operation_id.into(),
            timeout: None,
        }
    }
    #[doc = "Starts or stops a cluster node."]
    pub fn start_node_transition(
        &self,
        node_name: impl Into<String>,
        operation_id: impl Into<String>,
        node_transition_type: impl Into<String>,
        node_instance_id: impl Into<String>,
        stop_duration_in_seconds: i32,
    ) -> start_node_transition::Builder {
        start_node_transition::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            operation_id: operation_id.into(),
            node_transition_type: node_transition_type.into(),
            node_instance_id: node_instance_id.into(),
            stop_duration_in_seconds,
            timeout: None,
        }
    }
    #[doc = "Gets the progress of an operation started using StartNodeTransition."]
    pub fn get_node_transition_progress(
        &self,
        node_name: impl Into<String>,
        operation_id: impl Into<String>,
    ) -> get_node_transition_progress::Builder {
        get_node_transition_progress::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            operation_id: operation_id.into(),
            timeout: None,
        }
    }
    #[doc = "Gets a list of user-induced fault operations filtered by provided input."]
    pub fn get_fault_operation_list(&self, type_filter: i64, state_filter: i64) -> get_fault_operation_list::Builder {
        get_fault_operation_list::Builder {
            client: self.clone(),
            type_filter,
            state_filter,
            timeout: None,
        }
    }
    #[doc = "Cancels a user-induced fault operation."]
    pub fn cancel_operation(&self, operation_id: impl Into<String>, force: bool) -> cancel_operation::Builder {
        cancel_operation::Builder {
            client: self.clone(),
            operation_id: operation_id.into(),
            force,
            timeout: None,
        }
    }
    #[doc = "Creates a backup policy."]
    pub fn create_backup_policy(
        &self,
        backup_policy_description: impl Into<models::BackupPolicyDescription>,
    ) -> create_backup_policy::Builder {
        create_backup_policy::Builder {
            client: self.clone(),
            backup_policy_description: backup_policy_description.into(),
            timeout: None,
        }
    }
    #[doc = "Deletes the backup policy."]
    pub fn delete_backup_policy(&self, backup_policy_name: impl Into<String>) -> delete_backup_policy::Builder {
        delete_backup_policy::Builder {
            client: self.clone(),
            backup_policy_name: backup_policy_name.into(),
            timeout: None,
        }
    }
    #[doc = "Gets all the backup policies configured."]
    pub fn get_backup_policy_list(&self) -> get_backup_policy_list::Builder {
        get_backup_policy_list::Builder {
            client: self.clone(),
            continuation_token: None,
            max_results: None,
            timeout: None,
        }
    }
    #[doc = "Gets a particular backup policy by name."]
    pub fn get_backup_policy_by_name(&self, backup_policy_name: impl Into<String>) -> get_backup_policy_by_name::Builder {
        get_backup_policy_by_name::Builder {
            client: self.clone(),
            backup_policy_name: backup_policy_name.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the list of backup entities that are associated with this policy."]
    pub fn get_all_entities_backed_up_by_policy(
        &self,
        backup_policy_name: impl Into<String>,
    ) -> get_all_entities_backed_up_by_policy::Builder {
        get_all_entities_backed_up_by_policy::Builder {
            client: self.clone(),
            backup_policy_name: backup_policy_name.into(),
            continuation_token: None,
            max_results: None,
            timeout: None,
        }
    }
    #[doc = "Updates the backup policy."]
    pub fn update_backup_policy(
        &self,
        backup_policy_description: impl Into<models::BackupPolicyDescription>,
        backup_policy_name: impl Into<String>,
    ) -> update_backup_policy::Builder {
        update_backup_policy::Builder {
            client: self.clone(),
            backup_policy_description: backup_policy_description.into(),
            backup_policy_name: backup_policy_name.into(),
            timeout: None,
        }
    }
    #[doc = "Enables periodic backup of stateful partitions under this Service Fabric application."]
    pub fn enable_application_backup(
        &self,
        application_id: impl Into<String>,
        enable_backup_description: impl Into<models::EnableBackupDescription>,
    ) -> enable_application_backup::Builder {
        enable_application_backup::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            enable_backup_description: enable_backup_description.into(),
            timeout: None,
        }
    }
    #[doc = "Disables periodic backup of Service Fabric application."]
    pub fn disable_application_backup(&self, application_id: impl Into<String>) -> disable_application_backup::Builder {
        disable_application_backup::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            timeout: None,
            disable_backup_description: None,
        }
    }
    #[doc = "Gets the Service Fabric application backup configuration information."]
    pub fn get_application_backup_configuration_info(
        &self,
        application_id: impl Into<String>,
    ) -> get_application_backup_configuration_info::Builder {
        get_application_backup_configuration_info::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            continuation_token: None,
            max_results: None,
            timeout: None,
        }
    }
    #[doc = "Gets the list of backups available for every partition in this application."]
    pub fn get_application_backup_list(&self, application_id: impl Into<String>) -> get_application_backup_list::Builder {
        get_application_backup_list::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            timeout: None,
            latest: None,
            start_date_time_filter: None,
            end_date_time_filter: None,
            continuation_token: None,
            max_results: None,
        }
    }
    #[doc = "Suspends periodic backup for the specified Service Fabric application."]
    pub fn suspend_application_backup(&self, application_id: impl Into<String>) -> suspend_application_backup::Builder {
        suspend_application_backup::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            timeout: None,
        }
    }
    #[doc = "Resumes periodic backup of a Service Fabric application which was previously suspended."]
    pub fn resume_application_backup(&self, application_id: impl Into<String>) -> resume_application_backup::Builder {
        resume_application_backup::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            timeout: None,
        }
    }
    #[doc = "Enables periodic backup of stateful partitions under this Service Fabric service."]
    pub fn enable_service_backup(
        &self,
        service_id: impl Into<String>,
        enable_backup_description: impl Into<models::EnableBackupDescription>,
    ) -> enable_service_backup::Builder {
        enable_service_backup::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            enable_backup_description: enable_backup_description.into(),
            timeout: None,
        }
    }
    #[doc = "Disables periodic backup of Service Fabric service which was previously enabled."]
    pub fn disable_service_backup(&self, service_id: impl Into<String>) -> disable_service_backup::Builder {
        disable_service_backup::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            disable_backup_description: None,
            timeout: None,
        }
    }
    #[doc = "Gets the Service Fabric service backup configuration information."]
    pub fn get_service_backup_configuration_info(&self, service_id: impl Into<String>) -> get_service_backup_configuration_info::Builder {
        get_service_backup_configuration_info::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            continuation_token: None,
            max_results: None,
            timeout: None,
        }
    }
    #[doc = "Gets the list of backups available for every partition in this service."]
    pub fn get_service_backup_list(&self, service_id: impl Into<String>) -> get_service_backup_list::Builder {
        get_service_backup_list::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            timeout: None,
            latest: None,
            start_date_time_filter: None,
            end_date_time_filter: None,
            continuation_token: None,
            max_results: None,
        }
    }
    #[doc = "Suspends periodic backup for the specified Service Fabric service."]
    pub fn suspend_service_backup(&self, service_id: impl Into<String>) -> suspend_service_backup::Builder {
        suspend_service_backup::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            timeout: None,
        }
    }
    #[doc = "Resumes periodic backup of a Service Fabric service which was previously suspended."]
    pub fn resume_service_backup(&self, service_id: impl Into<String>) -> resume_service_backup::Builder {
        resume_service_backup::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            timeout: None,
        }
    }
    #[doc = "Enables periodic backup of the stateful persisted partition."]
    pub fn enable_partition_backup(
        &self,
        partition_id: impl Into<String>,
        enable_backup_description: impl Into<models::EnableBackupDescription>,
    ) -> enable_partition_backup::Builder {
        enable_partition_backup::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            enable_backup_description: enable_backup_description.into(),
            timeout: None,
        }
    }
    #[doc = "Disables periodic backup of Service Fabric partition which was previously enabled."]
    pub fn disable_partition_backup(&self, partition_id: impl Into<String>) -> disable_partition_backup::Builder {
        disable_partition_backup::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            disable_backup_description: None,
            timeout: None,
        }
    }
    #[doc = "Gets the partition backup configuration information"]
    pub fn get_partition_backup_configuration_info(
        &self,
        partition_id: impl Into<String>,
    ) -> get_partition_backup_configuration_info::Builder {
        get_partition_backup_configuration_info::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the list of backups available for the specified partition."]
    pub fn get_partition_backup_list(&self, partition_id: impl Into<String>) -> get_partition_backup_list::Builder {
        get_partition_backup_list::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            timeout: None,
            latest: None,
            start_date_time_filter: None,
            end_date_time_filter: None,
        }
    }
    #[doc = "Suspends periodic backup for the specified partition."]
    pub fn suspend_partition_backup(&self, partition_id: impl Into<String>) -> suspend_partition_backup::Builder {
        suspend_partition_backup::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            timeout: None,
        }
    }
    #[doc = "Resumes periodic backup of partition which was previously suspended."]
    pub fn resume_partition_backup(&self, partition_id: impl Into<String>) -> resume_partition_backup::Builder {
        resume_partition_backup::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            timeout: None,
        }
    }
    #[doc = "Triggers backup of the partition's state."]
    pub fn backup_partition(&self, partition_id: impl Into<String>) -> backup_partition::Builder {
        backup_partition::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            backup_partition_description: None,
            backup_timeout: None,
            timeout: None,
        }
    }
    #[doc = "Gets details for the latest backup triggered for this partition."]
    pub fn get_partition_backup_progress(&self, partition_id: impl Into<String>) -> get_partition_backup_progress::Builder {
        get_partition_backup_progress::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            timeout: None,
        }
    }
    #[doc = "Triggers restore of the state of the partition using the specified restore partition description."]
    pub fn restore_partition(
        &self,
        partition_id: impl Into<String>,
        restore_partition_description: impl Into<models::RestorePartitionDescription>,
    ) -> restore_partition::Builder {
        restore_partition::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            restore_partition_description: restore_partition_description.into(),
            restore_timeout: None,
            timeout: None,
        }
    }
    #[doc = "Gets details for the latest restore operation triggered for this partition."]
    pub fn get_partition_restore_progress(&self, partition_id: impl Into<String>) -> get_partition_restore_progress::Builder {
        get_partition_restore_progress::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            timeout: None,
        }
    }
    #[doc = "Gets the list of backups available for the specified backed up entity at the specified backup location."]
    pub fn get_backups_from_backup_location(
        &self,
        get_backup_by_storage_query_description: impl Into<models::GetBackupByStorageQueryDescription>,
    ) -> get_backups_from_backup_location::Builder {
        get_backups_from_backup_location::Builder {
            client: self.clone(),
            get_backup_by_storage_query_description: get_backup_by_storage_query_description.into(),
            timeout: None,
            continuation_token: None,
            max_results: None,
        }
    }
    #[doc = "Creates a Service Fabric name."]
    pub fn create_name(&self, name_description: impl Into<models::NameDescription>) -> create_name::Builder {
        create_name::Builder {
            client: self.clone(),
            name_description: name_description.into(),
            timeout: None,
        }
    }
    #[doc = "Returns whether the Service Fabric name exists."]
    pub fn get_name_exists_info(&self, name_id: impl Into<String>) -> get_name_exists_info::Builder {
        get_name_exists_info::Builder {
            client: self.clone(),
            name_id: name_id.into(),
            timeout: None,
        }
    }
    #[doc = "Deletes a Service Fabric name."]
    pub fn delete_name(&self, name_id: impl Into<String>) -> delete_name::Builder {
        delete_name::Builder {
            client: self.clone(),
            name_id: name_id.into(),
            timeout: None,
        }
    }
    #[doc = "Enumerates all the Service Fabric names under a given name."]
    pub fn get_sub_name_info_list(&self, name_id: impl Into<String>) -> get_sub_name_info_list::Builder {
        get_sub_name_info_list::Builder {
            client: self.clone(),
            name_id: name_id.into(),
            recursive: None,
            continuation_token: None,
            timeout: None,
        }
    }
    #[doc = "Gets information on all Service Fabric properties under a given name."]
    pub fn get_property_info_list(&self, name_id: impl Into<String>) -> get_property_info_list::Builder {
        get_property_info_list::Builder {
            client: self.clone(),
            name_id: name_id.into(),
            include_values: None,
            continuation_token: None,
            timeout: None,
        }
    }
    #[doc = "Gets the specified Service Fabric property."]
    pub fn get_property_info(&self, name_id: impl Into<String>, property_name: impl Into<String>) -> get_property_info::Builder {
        get_property_info::Builder {
            client: self.clone(),
            name_id: name_id.into(),
            property_name: property_name.into(),
            timeout: None,
        }
    }
    #[doc = "Creates or updates a Service Fabric property."]
    pub fn put_property(
        &self,
        name_id: impl Into<String>,
        property_description: impl Into<models::PropertyDescription>,
    ) -> put_property::Builder {
        put_property::Builder {
            client: self.clone(),
            name_id: name_id.into(),
            property_description: property_description.into(),
            timeout: None,
        }
    }
    #[doc = "Deletes the specified Service Fabric property."]
    pub fn delete_property(&self, name_id: impl Into<String>, property_name: impl Into<String>) -> delete_property::Builder {
        delete_property::Builder {
            client: self.clone(),
            name_id: name_id.into(),
            property_name: property_name.into(),
            timeout: None,
        }
    }
    #[doc = "Submits a property batch."]
    pub fn submit_property_batch(
        &self,
        name_id: impl Into<String>,
        property_batch_description_list: impl Into<models::PropertyBatchDescriptionList>,
    ) -> submit_property_batch::Builder {
        submit_property_batch::Builder {
            client: self.clone(),
            name_id: name_id.into(),
            property_batch_description_list: property_batch_description_list.into(),
            timeout: None,
        }
    }
    #[doc = "Gets all Cluster-related events."]
    pub fn get_cluster_event_list(
        &self,
        start_time_utc: impl Into<String>,
        end_time_utc: impl Into<String>,
    ) -> get_cluster_event_list::Builder {
        get_cluster_event_list::Builder {
            client: self.clone(),
            start_time_utc: start_time_utc.into(),
            end_time_utc: end_time_utc.into(),
            timeout: None,
            events_types_filter: None,
            exclude_analysis_events: None,
            skip_correlation_lookup: None,
        }
    }
    #[doc = "Gets all Containers-related events."]
    pub fn get_containers_event_list(
        &self,
        start_time_utc: impl Into<String>,
        end_time_utc: impl Into<String>,
    ) -> get_containers_event_list::Builder {
        get_containers_event_list::Builder {
            client: self.clone(),
            start_time_utc: start_time_utc.into(),
            end_time_utc: end_time_utc.into(),
            timeout: None,
            events_types_filter: None,
            exclude_analysis_events: None,
            skip_correlation_lookup: None,
        }
    }
    #[doc = "Gets a Node-related events."]
    pub fn get_node_event_list(
        &self,
        node_name: impl Into<String>,
        start_time_utc: impl Into<String>,
        end_time_utc: impl Into<String>,
    ) -> get_node_event_list::Builder {
        get_node_event_list::Builder {
            client: self.clone(),
            node_name: node_name.into(),
            start_time_utc: start_time_utc.into(),
            end_time_utc: end_time_utc.into(),
            timeout: None,
            events_types_filter: None,
            exclude_analysis_events: None,
            skip_correlation_lookup: None,
        }
    }
    #[doc = "Gets all Nodes-related Events."]
    pub fn get_nodes_event_list(
        &self,
        start_time_utc: impl Into<String>,
        end_time_utc: impl Into<String>,
    ) -> get_nodes_event_list::Builder {
        get_nodes_event_list::Builder {
            client: self.clone(),
            start_time_utc: start_time_utc.into(),
            end_time_utc: end_time_utc.into(),
            timeout: None,
            events_types_filter: None,
            exclude_analysis_events: None,
            skip_correlation_lookup: None,
        }
    }
    #[doc = "Gets an Application-related events."]
    pub fn get_application_event_list(
        &self,
        application_id: impl Into<String>,
        start_time_utc: impl Into<String>,
        end_time_utc: impl Into<String>,
    ) -> get_application_event_list::Builder {
        get_application_event_list::Builder {
            client: self.clone(),
            application_id: application_id.into(),
            start_time_utc: start_time_utc.into(),
            end_time_utc: end_time_utc.into(),
            timeout: None,
            events_types_filter: None,
            exclude_analysis_events: None,
            skip_correlation_lookup: None,
        }
    }
    #[doc = "Gets all Applications-related events."]
    pub fn get_applications_event_list(
        &self,
        start_time_utc: impl Into<String>,
        end_time_utc: impl Into<String>,
    ) -> get_applications_event_list::Builder {
        get_applications_event_list::Builder {
            client: self.clone(),
            start_time_utc: start_time_utc.into(),
            end_time_utc: end_time_utc.into(),
            timeout: None,
            events_types_filter: None,
            exclude_analysis_events: None,
            skip_correlation_lookup: None,
        }
    }
    #[doc = "Gets a Service-related events."]
    pub fn get_service_event_list(
        &self,
        service_id: impl Into<String>,
        start_time_utc: impl Into<String>,
        end_time_utc: impl Into<String>,
    ) -> get_service_event_list::Builder {
        get_service_event_list::Builder {
            client: self.clone(),
            service_id: service_id.into(),
            start_time_utc: start_time_utc.into(),
            end_time_utc: end_time_utc.into(),
            timeout: None,
            events_types_filter: None,
            exclude_analysis_events: None,
            skip_correlation_lookup: None,
        }
    }
    #[doc = "Gets all Services-related events."]
    pub fn get_services_event_list(
        &self,
        start_time_utc: impl Into<String>,
        end_time_utc: impl Into<String>,
    ) -> get_services_event_list::Builder {
        get_services_event_list::Builder {
            client: self.clone(),
            start_time_utc: start_time_utc.into(),
            end_time_utc: end_time_utc.into(),
            timeout: None,
            events_types_filter: None,
            exclude_analysis_events: None,
            skip_correlation_lookup: None,
        }
    }
    #[doc = "Gets a Partition-related events."]
    pub fn get_partition_event_list(
        &self,
        partition_id: impl Into<String>,
        start_time_utc: impl Into<String>,
        end_time_utc: impl Into<String>,
    ) -> get_partition_event_list::Builder {
        get_partition_event_list::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            start_time_utc: start_time_utc.into(),
            end_time_utc: end_time_utc.into(),
            timeout: None,
            events_types_filter: None,
            exclude_analysis_events: None,
            skip_correlation_lookup: None,
        }
    }
    #[doc = "Gets all Partitions-related events."]
    pub fn get_partitions_event_list(
        &self,
        start_time_utc: impl Into<String>,
        end_time_utc: impl Into<String>,
    ) -> get_partitions_event_list::Builder {
        get_partitions_event_list::Builder {
            client: self.clone(),
            start_time_utc: start_time_utc.into(),
            end_time_utc: end_time_utc.into(),
            timeout: None,
            events_types_filter: None,
            exclude_analysis_events: None,
            skip_correlation_lookup: None,
        }
    }
    #[doc = "Gets a Partition Replica-related events."]
    pub fn get_partition_replica_event_list(
        &self,
        partition_id: impl Into<String>,
        replica_id: impl Into<String>,
        start_time_utc: impl Into<String>,
        end_time_utc: impl Into<String>,
    ) -> get_partition_replica_event_list::Builder {
        get_partition_replica_event_list::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            replica_id: replica_id.into(),
            start_time_utc: start_time_utc.into(),
            end_time_utc: end_time_utc.into(),
            timeout: None,
            events_types_filter: None,
            exclude_analysis_events: None,
            skip_correlation_lookup: None,
        }
    }
    #[doc = "Gets all Replicas-related events for a Partition."]
    pub fn get_partition_replicas_event_list(
        &self,
        partition_id: impl Into<String>,
        start_time_utc: impl Into<String>,
        end_time_utc: impl Into<String>,
    ) -> get_partition_replicas_event_list::Builder {
        get_partition_replicas_event_list::Builder {
            client: self.clone(),
            partition_id: partition_id.into(),
            start_time_utc: start_time_utc.into(),
            end_time_utc: end_time_utc.into(),
            timeout: None,
            events_types_filter: None,
            exclude_analysis_events: None,
            skip_correlation_lookup: None,
        }
    }
    #[doc = "Gets all correlated events for a given event."]
    pub fn get_correlated_event_list(&self, event_instance_id: impl Into<String>) -> get_correlated_event_list::Builder {
        get_correlated_event_list::Builder {
            client: self.clone(),
            event_instance_id: event_instance_id.into(),
            timeout: None,
        }
    }
}
pub mod get_cluster_manifest {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ClusterManifest, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/GetClusterManifest", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ClusterManifest =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_cluster_health {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) nodes_health_state_filter: Option<i64>,
        pub(crate) applications_health_state_filter: Option<i64>,
        pub(crate) events_health_state_filter: Option<i64>,
        pub(crate) exclude_health_statistics: Option<bool>,
        pub(crate) include_system_application_health_statistics: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn nodes_health_state_filter(mut self, nodes_health_state_filter: i64) -> Self {
            self.nodes_health_state_filter = Some(nodes_health_state_filter);
            self
        }
        pub fn applications_health_state_filter(mut self, applications_health_state_filter: i64) -> Self {
            self.applications_health_state_filter = Some(applications_health_state_filter);
            self
        }
        pub fn events_health_state_filter(mut self, events_health_state_filter: i64) -> Self {
            self.events_health_state_filter = Some(events_health_state_filter);
            self
        }
        pub fn exclude_health_statistics(mut self, exclude_health_statistics: bool) -> Self {
            self.exclude_health_statistics = Some(exclude_health_statistics);
            self
        }
        pub fn include_system_application_health_statistics(mut self, include_system_application_health_statistics: bool) -> Self {
            self.include_system_application_health_statistics = Some(include_system_application_health_statistics);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ClusterHealth, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/GetClusterHealth", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(nodes_health_state_filter) = &self.nodes_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("NodesHealthStateFilter", &nodes_health_state_filter.to_string());
                }
                if let Some(applications_health_state_filter) = &self.applications_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("ApplicationsHealthStateFilter", &applications_health_state_filter.to_string());
                }
                if let Some(events_health_state_filter) = &self.events_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("EventsHealthStateFilter", &events_health_state_filter.to_string());
                }
                if let Some(exclude_health_statistics) = &self.exclude_health_statistics {
                    url.query_pairs_mut()
                        .append_pair("ExcludeHealthStatistics", &exclude_health_statistics.to_string());
                }
                if let Some(include_system_application_health_statistics) = &self.include_system_application_health_statistics {
                    url.query_pairs_mut().append_pair(
                        "IncludeSystemApplicationHealthStatistics",
                        &include_system_application_health_statistics.to_string(),
                    );
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ClusterHealth =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_cluster_health_using_policy {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) nodes_health_state_filter: Option<i64>,
        pub(crate) applications_health_state_filter: Option<i64>,
        pub(crate) events_health_state_filter: Option<i64>,
        pub(crate) exclude_health_statistics: Option<bool>,
        pub(crate) include_system_application_health_statistics: Option<bool>,
        pub(crate) cluster_health_policies: Option<models::ClusterHealthPolicies>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn nodes_health_state_filter(mut self, nodes_health_state_filter: i64) -> Self {
            self.nodes_health_state_filter = Some(nodes_health_state_filter);
            self
        }
        pub fn applications_health_state_filter(mut self, applications_health_state_filter: i64) -> Self {
            self.applications_health_state_filter = Some(applications_health_state_filter);
            self
        }
        pub fn events_health_state_filter(mut self, events_health_state_filter: i64) -> Self {
            self.events_health_state_filter = Some(events_health_state_filter);
            self
        }
        pub fn exclude_health_statistics(mut self, exclude_health_statistics: bool) -> Self {
            self.exclude_health_statistics = Some(exclude_health_statistics);
            self
        }
        pub fn include_system_application_health_statistics(mut self, include_system_application_health_statistics: bool) -> Self {
            self.include_system_application_health_statistics = Some(include_system_application_health_statistics);
            self
        }
        pub fn cluster_health_policies(mut self, cluster_health_policies: impl Into<models::ClusterHealthPolicies>) -> Self {
            self.cluster_health_policies = Some(cluster_health_policies.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ClusterHealth, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/GetClusterHealth", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(nodes_health_state_filter) = &self.nodes_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("NodesHealthStateFilter", &nodes_health_state_filter.to_string());
                }
                if let Some(applications_health_state_filter) = &self.applications_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("ApplicationsHealthStateFilter", &applications_health_state_filter.to_string());
                }
                if let Some(events_health_state_filter) = &self.events_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("EventsHealthStateFilter", &events_health_state_filter.to_string());
                }
                if let Some(exclude_health_statistics) = &self.exclude_health_statistics {
                    url.query_pairs_mut()
                        .append_pair("ExcludeHealthStatistics", &exclude_health_statistics.to_string());
                }
                if let Some(include_system_application_health_statistics) = &self.include_system_application_health_statistics {
                    url.query_pairs_mut().append_pair(
                        "IncludeSystemApplicationHealthStatistics",
                        &include_system_application_health_statistics.to_string(),
                    );
                }
                let req_body = if let Some(cluster_health_policies) = &self.cluster_health_policies {
                    req_builder = req_builder.header("content-type", "application/json");
                    azure_core::to_json(cluster_health_policies).map_err(Error::Serialize)?
                } else {
                    azure_core::EMPTY_BODY
                };
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ClusterHealth =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_cluster_health_chunk {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ClusterHealthChunk, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/GetClusterHealthChunk", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ClusterHealthChunk =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_cluster_health_chunk_using_policy_and_advanced_filters {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) cluster_health_chunk_query_description: Option<models::ClusterHealthChunkQueryDescription>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn cluster_health_chunk_query_description(
            mut self,
            cluster_health_chunk_query_description: impl Into<models::ClusterHealthChunkQueryDescription>,
        ) -> Self {
            self.cluster_health_chunk_query_description = Some(cluster_health_chunk_query_description.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ClusterHealthChunk, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/GetClusterHealthChunk", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let req_body = if let Some(cluster_health_chunk_query_description) = &self.cluster_health_chunk_query_description {
                    req_builder = req_builder.header("content-type", "application/json");
                    azure_core::to_json(cluster_health_chunk_query_description).map_err(Error::Serialize)?
                } else {
                    azure_core::EMPTY_BODY
                };
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ClusterHealthChunk =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod report_cluster_health {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) health_information: models::HealthInformation,
        pub(crate) immediate: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn immediate(mut self, immediate: bool) -> Self {
            self.immediate = Some(immediate);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/ReportClusterHealth", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.health_information).map_err(Error::Serialize)?;
                if let Some(immediate) = &self.immediate {
                    url.query_pairs_mut().append_pair("Immediate", &immediate.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_provisioned_fabric_code_version_info_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) code_version: Option<String>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn code_version(mut self, code_version: impl Into<String>) -> Self {
            self.code_version = Some(code_version.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::FabricCodeVersionInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/GetProvisionedCodeVersions", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(code_version) = &self.code_version {
                    url.query_pairs_mut().append_pair("CodeVersion", code_version);
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricCodeVersionInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_provisioned_fabric_config_version_info_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) config_version: Option<String>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn config_version(mut self, config_version: impl Into<String>) -> Self {
            self.config_version = Some(config_version.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::FabricConfigVersionInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/GetProvisionedConfigVersions", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(config_version) = &self.config_version {
                    url.query_pairs_mut().append_pair("ConfigVersion", config_version);
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricConfigVersionInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_cluster_upgrade_progress {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ClusterUpgradeProgressObject, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/GetUpgradeProgress", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ClusterUpgradeProgressObject =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_cluster_configuration {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) configuration_api_version: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ClusterConfiguration, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/GetClusterConfiguration", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let configuration_api_version = &self.configuration_api_version;
                url.query_pairs_mut()
                    .append_pair("ConfigurationApiVersion", configuration_api_version);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ClusterConfiguration =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_cluster_configuration_upgrade_status {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(
            self,
        ) -> futures::future::BoxFuture<'static, std::result::Result<models::ClusterConfigurationUpgradeStatusInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/GetClusterConfigurationUpgradeStatus", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ClusterConfigurationUpgradeStatusInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_upgrade_orchestration_service_state {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(
            self,
        ) -> futures::future::BoxFuture<'static, std::result::Result<models::UpgradeOrchestrationServiceState, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/GetUpgradeOrchestrationServiceState", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::UpgradeOrchestrationServiceState =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod set_upgrade_orchestration_service_state {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) upgrade_orchestration_service_state: models::UpgradeOrchestrationServiceState,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(
            self,
        ) -> futures::future::BoxFuture<'static, std::result::Result<models::UpgradeOrchestrationServiceStateSummary, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/SetUpgradeOrchestrationServiceState", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.upgrade_orchestration_service_state).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::UpgradeOrchestrationServiceStateSummary =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod provision_cluster {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) provision_fabric_description: models::ProvisionFabricDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/Provision", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.provision_fabric_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod unprovision_cluster {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) unprovision_fabric_description: models::UnprovisionFabricDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/Unprovision", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.unprovision_fabric_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod rollback_cluster_upgrade {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/RollbackUpgrade", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod resume_cluster_upgrade {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) resume_cluster_upgrade_description: models::ResumeClusterUpgradeDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/MoveToNextUpgradeDomain", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.resume_cluster_upgrade_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod start_cluster_upgrade {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) start_cluster_upgrade_description: models::StartClusterUpgradeDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/Upgrade", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.start_cluster_upgrade_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod start_cluster_configuration_upgrade {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) cluster_configuration_upgrade_description: models::ClusterConfigurationUpgradeDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/StartClusterConfigurationUpgrade", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.cluster_configuration_upgrade_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod update_cluster_upgrade {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) update_cluster_upgrade_description: models::UpdateClusterUpgradeDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/UpdateUpgrade", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.update_cluster_upgrade_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_aad_metadata {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::AadMetadataObject, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/GetAadMetadata", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::AadMetadataObject =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_cluster_version {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ClusterVersion, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/GetClusterVersion", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ClusterVersion =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_cluster_load {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ClusterLoadInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/GetLoadInformation", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ClusterLoadInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod toggle_verbose_service_placement_health_reporting {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) enabled: bool,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/ToggleVerboseServicePlacementHealthReporting", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let enabled = &self.enabled;
                url.query_pairs_mut().append_pair("Enabled", &enabled.to_string());
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_node_info_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) continuation_token: Option<String>,
        pub(crate) node_status_filter: Option<String>,
        pub(crate) max_results: Option<i64>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn node_status_filter(mut self, node_status_filter: impl Into<String>) -> Self {
            self.node_status_filter = Some(node_status_filter.into());
            self
        }
        pub fn max_results(mut self, max_results: i64) -> Self {
            self.max_results = Some(max_results);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedNodeInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Nodes", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(node_status_filter) = &self.node_status_filter {
                    url.query_pairs_mut().append_pair("NodeStatusFilter", node_status_filter);
                }
                if let Some(max_results) = &self.max_results {
                    url.query_pairs_mut().append_pair("MaxResults", &max_results.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedNodeInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_node_info {
    use super::models;
    #[derive(Debug)]
    pub enum Response {
        Ok200(models::NodeInfo),
        NoContent204,
    }
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Nodes/{}", self.client.endpoint(), &self.node_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::NodeInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(Response::Ok200(rsp_value))
                    }
                    http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_node_health {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) events_health_state_filter: Option<i64>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn events_health_state_filter(mut self, events_health_state_filter: i64) -> Self {
            self.events_health_state_filter = Some(events_health_state_filter);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::NodeHealth, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Nodes/{}/$/GetHealth", self.client.endpoint(), &self.node_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(events_health_state_filter) = &self.events_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("EventsHealthStateFilter", &events_health_state_filter.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::NodeHealth =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_node_health_using_policy {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) events_health_state_filter: Option<i64>,
        pub(crate) cluster_health_policy: Option<models::ClusterHealthPolicy>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn events_health_state_filter(mut self, events_health_state_filter: i64) -> Self {
            self.events_health_state_filter = Some(events_health_state_filter);
            self
        }
        pub fn cluster_health_policy(mut self, cluster_health_policy: impl Into<models::ClusterHealthPolicy>) -> Self {
            self.cluster_health_policy = Some(cluster_health_policy.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::NodeHealth, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Nodes/{}/$/GetHealth", self.client.endpoint(), &self.node_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(events_health_state_filter) = &self.events_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("EventsHealthStateFilter", &events_health_state_filter.to_string());
                }
                let req_body = if let Some(cluster_health_policy) = &self.cluster_health_policy {
                    req_builder = req_builder.header("content-type", "application/json");
                    azure_core::to_json(cluster_health_policy).map_err(Error::Serialize)?
                } else {
                    azure_core::EMPTY_BODY
                };
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::NodeHealth =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod report_node_health {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) health_information: models::HealthInformation,
        pub(crate) immediate: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn immediate(mut self, immediate: bool) -> Self {
            self.immediate = Some(immediate);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Nodes/{}/$/ReportHealth", self.client.endpoint(), &self.node_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.health_information).map_err(Error::Serialize)?;
                if let Some(immediate) = &self.immediate {
                    url.query_pairs_mut().append_pair("Immediate", &immediate.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_node_load_info {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::NodeLoadInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Nodes/{}/$/GetLoadInformation", self.client.endpoint(), &self.node_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::NodeLoadInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod disable_node {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) deactivation_intent_description: models::DeactivationIntentDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Nodes/{}/$/Deactivate", self.client.endpoint(), &self.node_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.deactivation_intent_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod enable_node {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Nodes/{}/$/Activate", self.client.endpoint(), &self.node_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod remove_node_state {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Nodes/{}/$/RemoveNodeState", self.client.endpoint(), &self.node_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod restart_node {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) restart_node_description: models::RestartNodeDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Nodes/{}/$/Restart", self.client.endpoint(), &self.node_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.restart_node_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod remove_configuration_overrides {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/RemoveConfigurationOverrides",
                    self.client.endpoint(),
                    &self.node_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::DELETE);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_configuration_overrides {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ConfigParameterOverrideList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Nodes/{}/$/GetConfigurationOverrides", self.client.endpoint(), &self.node_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ConfigParameterOverrideList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod add_configuration_parameter_overrides {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) config_parameter_override_list: models::ConfigParameterOverrideList,
        pub(crate) force: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn force(mut self, force: bool) -> Self {
            self.force = Some(force);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/AddConfigurationParameterOverrides",
                    self.client.endpoint(),
                    &self.node_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.config_parameter_override_list).map_err(Error::Serialize)?;
                if let Some(force) = &self.force {
                    url.query_pairs_mut().append_pair("Force", &force.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_application_type_info_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_type_definition_kind_filter: Option<i64>,
        pub(crate) exclude_application_parameters: Option<bool>,
        pub(crate) continuation_token: Option<String>,
        pub(crate) max_results: Option<i64>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn application_type_definition_kind_filter(mut self, application_type_definition_kind_filter: i64) -> Self {
            self.application_type_definition_kind_filter = Some(application_type_definition_kind_filter);
            self
        }
        pub fn exclude_application_parameters(mut self, exclude_application_parameters: bool) -> Self {
            self.exclude_application_parameters = Some(exclude_application_parameters);
            self
        }
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn max_results(mut self, max_results: i64) -> Self {
            self.max_results = Some(max_results);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedApplicationTypeInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ApplicationTypes", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(application_type_definition_kind_filter) = &self.application_type_definition_kind_filter {
                    url.query_pairs_mut().append_pair(
                        "ApplicationTypeDefinitionKindFilter",
                        &application_type_definition_kind_filter.to_string(),
                    );
                }
                if let Some(exclude_application_parameters) = &self.exclude_application_parameters {
                    url.query_pairs_mut()
                        .append_pair("ExcludeApplicationParameters", &exclude_application_parameters.to_string());
                }
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(max_results) = &self.max_results {
                    url.query_pairs_mut().append_pair("MaxResults", &max_results.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedApplicationTypeInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_application_type_info_list_by_name {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_type_name: String,
        pub(crate) application_type_version: Option<String>,
        pub(crate) exclude_application_parameters: Option<bool>,
        pub(crate) continuation_token: Option<String>,
        pub(crate) max_results: Option<i64>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn application_type_version(mut self, application_type_version: impl Into<String>) -> Self {
            self.application_type_version = Some(application_type_version.into());
            self
        }
        pub fn exclude_application_parameters(mut self, exclude_application_parameters: bool) -> Self {
            self.exclude_application_parameters = Some(exclude_application_parameters);
            self
        }
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn max_results(mut self, max_results: i64) -> Self {
            self.max_results = Some(max_results);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedApplicationTypeInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ApplicationTypes/{}", self.client.endpoint(), &self.application_type_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(application_type_version) = &self.application_type_version {
                    url.query_pairs_mut()
                        .append_pair("ApplicationTypeVersion", application_type_version);
                }
                if let Some(exclude_application_parameters) = &self.exclude_application_parameters {
                    url.query_pairs_mut()
                        .append_pair("ExcludeApplicationParameters", &exclude_application_parameters.to_string());
                }
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(max_results) = &self.max_results {
                    url.query_pairs_mut().append_pair("MaxResults", &max_results.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedApplicationTypeInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod provision_application_type {
    use super::models;
    #[derive(Debug)]
    pub enum Response {
        Ok200,
        Accepted202,
    }
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) provision_application_type_description_base_required_body_param: models::ProvisionApplicationTypeDescriptionBase,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ApplicationTypes/$/Provision", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body =
                    azure_core::to_json(&self.provision_application_type_description_base_required_body_param).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(Response::Ok200),
                    http::StatusCode::ACCEPTED => Ok(Response::Accepted202),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod unprovision_application_type {
    use super::models;
    #[derive(Debug)]
    pub enum Response {
        Ok200,
        Accepted202,
    }
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_type_name: String,
        pub(crate) unprovision_application_type_description_info: models::UnprovisionApplicationTypeDescriptionInfo,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/ApplicationTypes/{}/$/Unprovision",
                    self.client.endpoint(),
                    &self.application_type_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.unprovision_application_type_description_info).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(Response::Ok200),
                    http::StatusCode::ACCEPTED => Ok(Response::Accepted202),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_service_type_info_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_type_name: String,
        pub(crate) application_type_version: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ServiceTypeInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/ApplicationTypes/{}/$/GetServiceTypes",
                    self.client.endpoint(),
                    &self.application_type_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let application_type_version = &self.application_type_version;
                url.query_pairs_mut()
                    .append_pair("ApplicationTypeVersion", application_type_version);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ServiceTypeInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_service_type_info_by_name {
    use super::models;
    #[derive(Debug)]
    pub enum Response {
        Ok200(models::ServiceTypeInfo),
        NoContent204,
    }
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_type_name: String,
        pub(crate) application_type_version: String,
        pub(crate) service_type_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/ApplicationTypes/{}/$/GetServiceTypes/{}",
                    self.client.endpoint(),
                    &self.application_type_name,
                    &self.service_type_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let application_type_version = &self.application_type_version;
                url.query_pairs_mut()
                    .append_pair("ApplicationTypeVersion", application_type_version);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ServiceTypeInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(Response::Ok200(rsp_value))
                    }
                    http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_service_manifest {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_type_name: String,
        pub(crate) application_type_version: String,
        pub(crate) service_manifest_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ServiceTypeManifest, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/ApplicationTypes/{}/$/GetServiceManifest",
                    self.client.endpoint(),
                    &self.application_type_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let application_type_version = &self.application_type_version;
                url.query_pairs_mut()
                    .append_pair("ApplicationTypeVersion", application_type_version);
                let service_manifest_name = &self.service_manifest_name;
                url.query_pairs_mut().append_pair("ServiceManifestName", service_manifest_name);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ServiceTypeManifest =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_deployed_service_type_info_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) application_id: String,
        pub(crate) service_manifest_name: Option<String>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn service_manifest_name(mut self, service_manifest_name: impl Into<String>) -> Self {
            self.service_manifest_name = Some(service_manifest_name.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DeployedServiceTypeInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetApplications/{}/$/GetServiceTypes",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(service_manifest_name) = &self.service_manifest_name {
                    url.query_pairs_mut().append_pair("ServiceManifestName", service_manifest_name);
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DeployedServiceTypeInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_deployed_service_type_info_by_name {
    use super::models;
    #[derive(Debug)]
    pub enum Response {
        Ok200(models::DeployedServiceTypeInfoList),
        NoContent204,
    }
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) application_id: String,
        pub(crate) service_type_name: String,
        pub(crate) service_manifest_name: Option<String>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn service_manifest_name(mut self, service_manifest_name: impl Into<String>) -> Self {
            self.service_manifest_name = Some(service_manifest_name.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetApplications/{}/$/GetServiceTypes/{}",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.application_id,
                    &self.service_type_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(service_manifest_name) = &self.service_manifest_name {
                    url.query_pairs_mut().append_pair("ServiceManifestName", service_manifest_name);
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DeployedServiceTypeInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(Response::Ok200(rsp_value))
                    }
                    http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod create_application {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_description: models::ApplicationDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Applications/$/Create", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.application_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::CREATED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod delete_application {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) force_remove: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn force_remove(mut self, force_remove: bool) -> Self {
            self.force_remove = Some(force_remove);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Applications/{}/$/Delete", self.client.endpoint(), &self.application_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(force_remove) = &self.force_remove {
                    url.query_pairs_mut().append_pair("ForceRemove", &force_remove.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_application_load_info {
    use super::models;
    #[derive(Debug)]
    pub enum Response {
        Ok200(models::ApplicationLoadInfo),
        NoContent204,
    }
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Applications/{}/$/GetLoadInformation",
                    self.client.endpoint(),
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ApplicationLoadInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(Response::Ok200(rsp_value))
                    }
                    http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_application_info_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_definition_kind_filter: Option<i64>,
        pub(crate) application_type_name: Option<String>,
        pub(crate) exclude_application_parameters: Option<bool>,
        pub(crate) continuation_token: Option<String>,
        pub(crate) max_results: Option<i64>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn application_definition_kind_filter(mut self, application_definition_kind_filter: i64) -> Self {
            self.application_definition_kind_filter = Some(application_definition_kind_filter);
            self
        }
        pub fn application_type_name(mut self, application_type_name: impl Into<String>) -> Self {
            self.application_type_name = Some(application_type_name.into());
            self
        }
        pub fn exclude_application_parameters(mut self, exclude_application_parameters: bool) -> Self {
            self.exclude_application_parameters = Some(exclude_application_parameters);
            self
        }
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn max_results(mut self, max_results: i64) -> Self {
            self.max_results = Some(max_results);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedApplicationInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Applications", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(application_definition_kind_filter) = &self.application_definition_kind_filter {
                    url.query_pairs_mut()
                        .append_pair("ApplicationDefinitionKindFilter", &application_definition_kind_filter.to_string());
                }
                if let Some(application_type_name) = &self.application_type_name {
                    url.query_pairs_mut().append_pair("ApplicationTypeName", application_type_name);
                }
                if let Some(exclude_application_parameters) = &self.exclude_application_parameters {
                    url.query_pairs_mut()
                        .append_pair("ExcludeApplicationParameters", &exclude_application_parameters.to_string());
                }
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(max_results) = &self.max_results {
                    url.query_pairs_mut().append_pair("MaxResults", &max_results.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedApplicationInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_application_info {
    use super::models;
    #[derive(Debug)]
    pub enum Response {
        Ok200(models::ApplicationInfo),
        NoContent204,
    }
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) exclude_application_parameters: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn exclude_application_parameters(mut self, exclude_application_parameters: bool) -> Self {
            self.exclude_application_parameters = Some(exclude_application_parameters);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Applications/{}", self.client.endpoint(), &self.application_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(exclude_application_parameters) = &self.exclude_application_parameters {
                    url.query_pairs_mut()
                        .append_pair("ExcludeApplicationParameters", &exclude_application_parameters.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ApplicationInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(Response::Ok200(rsp_value))
                    }
                    http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_application_health {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) events_health_state_filter: Option<i64>,
        pub(crate) deployed_applications_health_state_filter: Option<i64>,
        pub(crate) services_health_state_filter: Option<i64>,
        pub(crate) exclude_health_statistics: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn events_health_state_filter(mut self, events_health_state_filter: i64) -> Self {
            self.events_health_state_filter = Some(events_health_state_filter);
            self
        }
        pub fn deployed_applications_health_state_filter(mut self, deployed_applications_health_state_filter: i64) -> Self {
            self.deployed_applications_health_state_filter = Some(deployed_applications_health_state_filter);
            self
        }
        pub fn services_health_state_filter(mut self, services_health_state_filter: i64) -> Self {
            self.services_health_state_filter = Some(services_health_state_filter);
            self
        }
        pub fn exclude_health_statistics(mut self, exclude_health_statistics: bool) -> Self {
            self.exclude_health_statistics = Some(exclude_health_statistics);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ApplicationHealth, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Applications/{}/$/GetHealth", self.client.endpoint(), &self.application_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(events_health_state_filter) = &self.events_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("EventsHealthStateFilter", &events_health_state_filter.to_string());
                }
                if let Some(deployed_applications_health_state_filter) = &self.deployed_applications_health_state_filter {
                    url.query_pairs_mut().append_pair(
                        "DeployedApplicationsHealthStateFilter",
                        &deployed_applications_health_state_filter.to_string(),
                    );
                }
                if let Some(services_health_state_filter) = &self.services_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("ServicesHealthStateFilter", &services_health_state_filter.to_string());
                }
                if let Some(exclude_health_statistics) = &self.exclude_health_statistics {
                    url.query_pairs_mut()
                        .append_pair("ExcludeHealthStatistics", &exclude_health_statistics.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ApplicationHealth =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_application_health_using_policy {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) events_health_state_filter: Option<i64>,
        pub(crate) deployed_applications_health_state_filter: Option<i64>,
        pub(crate) services_health_state_filter: Option<i64>,
        pub(crate) exclude_health_statistics: Option<bool>,
        pub(crate) application_health_policy: Option<models::ApplicationHealthPolicy>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn events_health_state_filter(mut self, events_health_state_filter: i64) -> Self {
            self.events_health_state_filter = Some(events_health_state_filter);
            self
        }
        pub fn deployed_applications_health_state_filter(mut self, deployed_applications_health_state_filter: i64) -> Self {
            self.deployed_applications_health_state_filter = Some(deployed_applications_health_state_filter);
            self
        }
        pub fn services_health_state_filter(mut self, services_health_state_filter: i64) -> Self {
            self.services_health_state_filter = Some(services_health_state_filter);
            self
        }
        pub fn exclude_health_statistics(mut self, exclude_health_statistics: bool) -> Self {
            self.exclude_health_statistics = Some(exclude_health_statistics);
            self
        }
        pub fn application_health_policy(mut self, application_health_policy: impl Into<models::ApplicationHealthPolicy>) -> Self {
            self.application_health_policy = Some(application_health_policy.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ApplicationHealth, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Applications/{}/$/GetHealth", self.client.endpoint(), &self.application_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(events_health_state_filter) = &self.events_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("EventsHealthStateFilter", &events_health_state_filter.to_string());
                }
                if let Some(deployed_applications_health_state_filter) = &self.deployed_applications_health_state_filter {
                    url.query_pairs_mut().append_pair(
                        "DeployedApplicationsHealthStateFilter",
                        &deployed_applications_health_state_filter.to_string(),
                    );
                }
                if let Some(services_health_state_filter) = &self.services_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("ServicesHealthStateFilter", &services_health_state_filter.to_string());
                }
                if let Some(exclude_health_statistics) = &self.exclude_health_statistics {
                    url.query_pairs_mut()
                        .append_pair("ExcludeHealthStatistics", &exclude_health_statistics.to_string());
                }
                let req_body = if let Some(application_health_policy) = &self.application_health_policy {
                    req_builder = req_builder.header("content-type", "application/json");
                    azure_core::to_json(application_health_policy).map_err(Error::Serialize)?
                } else {
                    azure_core::EMPTY_BODY
                };
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ApplicationHealth =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod report_application_health {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) health_information: models::HealthInformation,
        pub(crate) immediate: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn immediate(mut self, immediate: bool) -> Self {
            self.immediate = Some(immediate);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Applications/{}/$/ReportHealth", self.client.endpoint(), &self.application_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.health_information).map_err(Error::Serialize)?;
                if let Some(immediate) = &self.immediate {
                    url.query_pairs_mut().append_pair("Immediate", &immediate.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod start_application_upgrade {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) application_upgrade_description: models::ApplicationUpgradeDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Applications/{}/$/Upgrade", self.client.endpoint(), &self.application_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.application_upgrade_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_application_upgrade {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(
            self,
        ) -> futures::future::BoxFuture<'static, std::result::Result<models::ApplicationUpgradeProgressInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Applications/{}/$/GetUpgradeProgress",
                    self.client.endpoint(),
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ApplicationUpgradeProgressInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod update_application_upgrade {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) application_upgrade_update_description: models::ApplicationUpgradeUpdateDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Applications/{}/$/UpdateUpgrade", self.client.endpoint(), &self.application_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.application_upgrade_update_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod resume_application_upgrade {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) resume_application_upgrade_description: models::ResumeApplicationUpgradeDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Applications/{}/$/MoveToNextUpgradeDomain",
                    self.client.endpoint(),
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.resume_application_upgrade_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod rollback_application_upgrade {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Applications/{}/$/RollbackUpgrade", self.client.endpoint(), &self.application_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_deployed_application_info_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) timeout: Option<i64>,
        pub(crate) include_health_state: Option<bool>,
        pub(crate) continuation_token: Option<String>,
        pub(crate) max_results: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn include_health_state(mut self, include_health_state: bool) -> Self {
            self.include_health_state = Some(include_health_state);
            self
        }
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn max_results(mut self, max_results: i64) -> Self {
            self.max_results = Some(max_results);
            self
        }
        pub fn into_future(
            self,
        ) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedDeployedApplicationInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Nodes/{}/$/GetApplications", self.client.endpoint(), &self.node_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                if let Some(include_health_state) = &self.include_health_state {
                    url.query_pairs_mut()
                        .append_pair("IncludeHealthState", &include_health_state.to_string());
                }
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(max_results) = &self.max_results {
                    url.query_pairs_mut().append_pair("MaxResults", &max_results.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedDeployedApplicationInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_deployed_application_info {
    use super::models;
    #[derive(Debug)]
    pub enum Response {
        Ok200(models::DeployedApplicationInfo),
        NoContent204,
    }
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) application_id: String,
        pub(crate) timeout: Option<i64>,
        pub(crate) include_health_state: Option<bool>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn include_health_state(mut self, include_health_state: bool) -> Self {
            self.include_health_state = Some(include_health_state);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetApplications/{}",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                if let Some(include_health_state) = &self.include_health_state {
                    url.query_pairs_mut()
                        .append_pair("IncludeHealthState", &include_health_state.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DeployedApplicationInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(Response::Ok200(rsp_value))
                    }
                    http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_deployed_application_health {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) application_id: String,
        pub(crate) events_health_state_filter: Option<i64>,
        pub(crate) deployed_service_packages_health_state_filter: Option<i64>,
        pub(crate) exclude_health_statistics: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn events_health_state_filter(mut self, events_health_state_filter: i64) -> Self {
            self.events_health_state_filter = Some(events_health_state_filter);
            self
        }
        pub fn deployed_service_packages_health_state_filter(mut self, deployed_service_packages_health_state_filter: i64) -> Self {
            self.deployed_service_packages_health_state_filter = Some(deployed_service_packages_health_state_filter);
            self
        }
        pub fn exclude_health_statistics(mut self, exclude_health_statistics: bool) -> Self {
            self.exclude_health_statistics = Some(exclude_health_statistics);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DeployedApplicationHealth, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetApplications/{}/$/GetHealth",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(events_health_state_filter) = &self.events_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("EventsHealthStateFilter", &events_health_state_filter.to_string());
                }
                if let Some(deployed_service_packages_health_state_filter) = &self.deployed_service_packages_health_state_filter {
                    url.query_pairs_mut().append_pair(
                        "DeployedServicePackagesHealthStateFilter",
                        &deployed_service_packages_health_state_filter.to_string(),
                    );
                }
                if let Some(exclude_health_statistics) = &self.exclude_health_statistics {
                    url.query_pairs_mut()
                        .append_pair("ExcludeHealthStatistics", &exclude_health_statistics.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DeployedApplicationHealth =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_deployed_application_health_using_policy {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) application_id: String,
        pub(crate) events_health_state_filter: Option<i64>,
        pub(crate) deployed_service_packages_health_state_filter: Option<i64>,
        pub(crate) application_health_policy: Option<models::ApplicationHealthPolicy>,
        pub(crate) exclude_health_statistics: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn events_health_state_filter(mut self, events_health_state_filter: i64) -> Self {
            self.events_health_state_filter = Some(events_health_state_filter);
            self
        }
        pub fn deployed_service_packages_health_state_filter(mut self, deployed_service_packages_health_state_filter: i64) -> Self {
            self.deployed_service_packages_health_state_filter = Some(deployed_service_packages_health_state_filter);
            self
        }
        pub fn application_health_policy(mut self, application_health_policy: impl Into<models::ApplicationHealthPolicy>) -> Self {
            self.application_health_policy = Some(application_health_policy.into());
            self
        }
        pub fn exclude_health_statistics(mut self, exclude_health_statistics: bool) -> Self {
            self.exclude_health_statistics = Some(exclude_health_statistics);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DeployedApplicationHealth, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetApplications/{}/$/GetHealth",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(events_health_state_filter) = &self.events_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("EventsHealthStateFilter", &events_health_state_filter.to_string());
                }
                if let Some(deployed_service_packages_health_state_filter) = &self.deployed_service_packages_health_state_filter {
                    url.query_pairs_mut().append_pair(
                        "DeployedServicePackagesHealthStateFilter",
                        &deployed_service_packages_health_state_filter.to_string(),
                    );
                }
                let req_body = if let Some(application_health_policy) = &self.application_health_policy {
                    req_builder = req_builder.header("content-type", "application/json");
                    azure_core::to_json(application_health_policy).map_err(Error::Serialize)?
                } else {
                    azure_core::EMPTY_BODY
                };
                if let Some(exclude_health_statistics) = &self.exclude_health_statistics {
                    url.query_pairs_mut()
                        .append_pair("ExcludeHealthStatistics", &exclude_health_statistics.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DeployedApplicationHealth =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod report_deployed_application_health {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) application_id: String,
        pub(crate) health_information: models::HealthInformation,
        pub(crate) immediate: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn immediate(mut self, immediate: bool) -> Self {
            self.immediate = Some(immediate);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetApplications/{}/$/ReportHealth",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.health_information).map_err(Error::Serialize)?;
                if let Some(immediate) = &self.immediate {
                    url.query_pairs_mut().append_pair("Immediate", &immediate.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_application_manifest {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_type_name: String,
        pub(crate) application_type_version: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ApplicationTypeManifest, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/ApplicationTypes/{}/$/GetApplicationManifest",
                    self.client.endpoint(),
                    &self.application_type_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let application_type_version = &self.application_type_version;
                url.query_pairs_mut()
                    .append_pair("ApplicationTypeVersion", application_type_version);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ApplicationTypeManifest =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_service_info_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) service_type_name: Option<String>,
        pub(crate) continuation_token: Option<String>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn service_type_name(mut self, service_type_name: impl Into<String>) -> Self {
            self.service_type_name = Some(service_type_name.into());
            self
        }
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedServiceInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Applications/{}/$/GetServices", self.client.endpoint(), &self.application_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(service_type_name) = &self.service_type_name {
                    url.query_pairs_mut().append_pair("ServiceTypeName", service_type_name);
                }
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedServiceInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_service_info {
    use super::models;
    #[derive(Debug)]
    pub enum Response {
        Ok200(models::ServiceInfo),
        NoContent204,
    }
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) service_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Applications/{}/$/GetServices/{}",
                    self.client.endpoint(),
                    &self.application_id,
                    &self.service_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ServiceInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(Response::Ok200(rsp_value))
                    }
                    http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_application_name_info {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ApplicationNameInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Services/{}/$/GetApplicationName", self.client.endpoint(), &self.service_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ApplicationNameInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod create_service {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) service_description: models::ServiceDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Applications/{}/$/GetServices/$/Create",
                    self.client.endpoint(),
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.service_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod create_service_from_template {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) service_from_template_description: models::ServiceFromTemplateDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Applications/{}/$/GetServices/$/CreateFromTemplate",
                    self.client.endpoint(),
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.service_from_template_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod delete_service {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) force_remove: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn force_remove(mut self, force_remove: bool) -> Self {
            self.force_remove = Some(force_remove);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Services/{}/$/Delete", self.client.endpoint(), &self.service_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(force_remove) = &self.force_remove {
                    url.query_pairs_mut().append_pair("ForceRemove", &force_remove.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod update_service {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) service_update_description: models::ServiceUpdateDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Services/{}/$/Update", self.client.endpoint(), &self.service_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.service_update_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_service_description {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ServiceDescription, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Services/{}/$/GetDescription", self.client.endpoint(), &self.service_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ServiceDescription =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_service_health {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) events_health_state_filter: Option<i64>,
        pub(crate) partitions_health_state_filter: Option<i64>,
        pub(crate) exclude_health_statistics: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn events_health_state_filter(mut self, events_health_state_filter: i64) -> Self {
            self.events_health_state_filter = Some(events_health_state_filter);
            self
        }
        pub fn partitions_health_state_filter(mut self, partitions_health_state_filter: i64) -> Self {
            self.partitions_health_state_filter = Some(partitions_health_state_filter);
            self
        }
        pub fn exclude_health_statistics(mut self, exclude_health_statistics: bool) -> Self {
            self.exclude_health_statistics = Some(exclude_health_statistics);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ServiceHealth, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Services/{}/$/GetHealth", self.client.endpoint(), &self.service_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(events_health_state_filter) = &self.events_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("EventsHealthStateFilter", &events_health_state_filter.to_string());
                }
                if let Some(partitions_health_state_filter) = &self.partitions_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("PartitionsHealthStateFilter", &partitions_health_state_filter.to_string());
                }
                if let Some(exclude_health_statistics) = &self.exclude_health_statistics {
                    url.query_pairs_mut()
                        .append_pair("ExcludeHealthStatistics", &exclude_health_statistics.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ServiceHealth =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_service_health_using_policy {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) events_health_state_filter: Option<i64>,
        pub(crate) partitions_health_state_filter: Option<i64>,
        pub(crate) application_health_policy: Option<models::ApplicationHealthPolicy>,
        pub(crate) exclude_health_statistics: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn events_health_state_filter(mut self, events_health_state_filter: i64) -> Self {
            self.events_health_state_filter = Some(events_health_state_filter);
            self
        }
        pub fn partitions_health_state_filter(mut self, partitions_health_state_filter: i64) -> Self {
            self.partitions_health_state_filter = Some(partitions_health_state_filter);
            self
        }
        pub fn application_health_policy(mut self, application_health_policy: impl Into<models::ApplicationHealthPolicy>) -> Self {
            self.application_health_policy = Some(application_health_policy.into());
            self
        }
        pub fn exclude_health_statistics(mut self, exclude_health_statistics: bool) -> Self {
            self.exclude_health_statistics = Some(exclude_health_statistics);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ServiceHealth, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Services/{}/$/GetHealth", self.client.endpoint(), &self.service_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(events_health_state_filter) = &self.events_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("EventsHealthStateFilter", &events_health_state_filter.to_string());
                }
                if let Some(partitions_health_state_filter) = &self.partitions_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("PartitionsHealthStateFilter", &partitions_health_state_filter.to_string());
                }
                let req_body = if let Some(application_health_policy) = &self.application_health_policy {
                    req_builder = req_builder.header("content-type", "application/json");
                    azure_core::to_json(application_health_policy).map_err(Error::Serialize)?
                } else {
                    azure_core::EMPTY_BODY
                };
                if let Some(exclude_health_statistics) = &self.exclude_health_statistics {
                    url.query_pairs_mut()
                        .append_pair("ExcludeHealthStatistics", &exclude_health_statistics.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ServiceHealth =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod report_service_health {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) health_information: models::HealthInformation,
        pub(crate) immediate: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn immediate(mut self, immediate: bool) -> Self {
            self.immediate = Some(immediate);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Services/{}/$/ReportHealth", self.client.endpoint(), &self.service_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.health_information).map_err(Error::Serialize)?;
                if let Some(immediate) = &self.immediate {
                    url.query_pairs_mut().append_pair("Immediate", &immediate.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod resolve_service {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) partition_key_type: Option<i64>,
        pub(crate) partition_key_value: Option<String>,
        pub(crate) previous_rsp_version: Option<String>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn partition_key_type(mut self, partition_key_type: i64) -> Self {
            self.partition_key_type = Some(partition_key_type);
            self
        }
        pub fn partition_key_value(mut self, partition_key_value: impl Into<String>) -> Self {
            self.partition_key_value = Some(partition_key_value.into());
            self
        }
        pub fn previous_rsp_version(mut self, previous_rsp_version: impl Into<String>) -> Self {
            self.previous_rsp_version = Some(previous_rsp_version.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ResolvedServicePartition, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Services/{}/$/ResolvePartition", self.client.endpoint(), &self.service_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(partition_key_type) = &self.partition_key_type {
                    url.query_pairs_mut()
                        .append_pair("PartitionKeyType", &partition_key_type.to_string());
                }
                if let Some(partition_key_value) = &self.partition_key_value {
                    url.query_pairs_mut().append_pair("PartitionKeyValue", partition_key_value);
                }
                if let Some(previous_rsp_version) = &self.previous_rsp_version {
                    url.query_pairs_mut().append_pair("PreviousRspVersion", previous_rsp_version);
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ResolvedServicePartition =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_unplaced_replica_information {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) partition_id: Option<String>,
        pub(crate) only_query_primaries: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn partition_id(mut self, partition_id: impl Into<String>) -> Self {
            self.partition_id = Some(partition_id.into());
            self
        }
        pub fn only_query_primaries(mut self, only_query_primaries: bool) -> Self {
            self.only_query_primaries = Some(only_query_primaries);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::UnplacedReplicaInformation, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Services/{}/$/GetUnplacedReplicaInformation",
                    self.client.endpoint(),
                    &self.service_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(partition_id) = &self.partition_id {
                    url.query_pairs_mut().append_pair("PartitionId", partition_id);
                }
                if let Some(only_query_primaries) = &self.only_query_primaries {
                    url.query_pairs_mut()
                        .append_pair("OnlyQueryPrimaries", &only_query_primaries.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::UnplacedReplicaInformation =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_partition_info_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) continuation_token: Option<String>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedServicePartitionInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Services/{}/$/GetPartitions", self.client.endpoint(), &self.service_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedServicePartitionInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_partition_info {
    use super::models;
    #[derive(Debug)]
    pub enum Response {
        Ok200(models::ServicePartitionInfo),
        NoContent204,
    }
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ServicePartitionInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(Response::Ok200(rsp_value))
                    }
                    http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_service_name_info {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ServiceNameInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/GetServiceName", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ServiceNameInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_partition_health {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) events_health_state_filter: Option<i64>,
        pub(crate) replicas_health_state_filter: Option<i64>,
        pub(crate) exclude_health_statistics: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn events_health_state_filter(mut self, events_health_state_filter: i64) -> Self {
            self.events_health_state_filter = Some(events_health_state_filter);
            self
        }
        pub fn replicas_health_state_filter(mut self, replicas_health_state_filter: i64) -> Self {
            self.replicas_health_state_filter = Some(replicas_health_state_filter);
            self
        }
        pub fn exclude_health_statistics(mut self, exclude_health_statistics: bool) -> Self {
            self.exclude_health_statistics = Some(exclude_health_statistics);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PartitionHealth, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/GetHealth", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(events_health_state_filter) = &self.events_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("EventsHealthStateFilter", &events_health_state_filter.to_string());
                }
                if let Some(replicas_health_state_filter) = &self.replicas_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("ReplicasHealthStateFilter", &replicas_health_state_filter.to_string());
                }
                if let Some(exclude_health_statistics) = &self.exclude_health_statistics {
                    url.query_pairs_mut()
                        .append_pair("ExcludeHealthStatistics", &exclude_health_statistics.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PartitionHealth =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_partition_health_using_policy {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) events_health_state_filter: Option<i64>,
        pub(crate) replicas_health_state_filter: Option<i64>,
        pub(crate) application_health_policy: Option<models::ApplicationHealthPolicy>,
        pub(crate) exclude_health_statistics: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn events_health_state_filter(mut self, events_health_state_filter: i64) -> Self {
            self.events_health_state_filter = Some(events_health_state_filter);
            self
        }
        pub fn replicas_health_state_filter(mut self, replicas_health_state_filter: i64) -> Self {
            self.replicas_health_state_filter = Some(replicas_health_state_filter);
            self
        }
        pub fn application_health_policy(mut self, application_health_policy: impl Into<models::ApplicationHealthPolicy>) -> Self {
            self.application_health_policy = Some(application_health_policy.into());
            self
        }
        pub fn exclude_health_statistics(mut self, exclude_health_statistics: bool) -> Self {
            self.exclude_health_statistics = Some(exclude_health_statistics);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PartitionHealth, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/GetHealth", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(events_health_state_filter) = &self.events_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("EventsHealthStateFilter", &events_health_state_filter.to_string());
                }
                if let Some(replicas_health_state_filter) = &self.replicas_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("ReplicasHealthStateFilter", &replicas_health_state_filter.to_string());
                }
                let req_body = if let Some(application_health_policy) = &self.application_health_policy {
                    req_builder = req_builder.header("content-type", "application/json");
                    azure_core::to_json(application_health_policy).map_err(Error::Serialize)?
                } else {
                    azure_core::EMPTY_BODY
                };
                if let Some(exclude_health_statistics) = &self.exclude_health_statistics {
                    url.query_pairs_mut()
                        .append_pair("ExcludeHealthStatistics", &exclude_health_statistics.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PartitionHealth =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod report_partition_health {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) health_information: models::HealthInformation,
        pub(crate) immediate: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn immediate(mut self, immediate: bool) -> Self {
            self.immediate = Some(immediate);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/ReportHealth", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.health_information).map_err(Error::Serialize)?;
                if let Some(immediate) = &self.immediate {
                    url.query_pairs_mut().append_pair("Immediate", &immediate.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_partition_load_information {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PartitionLoadInformation, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/GetLoadInformation", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PartitionLoadInformation =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod reset_partition_load {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/ResetLoad", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod recover_partition {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/Recover", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod recover_service_partitions {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Services/$/{}/$/GetPartitions/$/Recover",
                    self.client.endpoint(),
                    &self.service_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod recover_system_partitions {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/RecoverSystemPartitions", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod recover_all_partitions {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/RecoverAllPartitions", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod move_primary_replica {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) node_name: Option<String>,
        pub(crate) ignore_constraints: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn node_name(mut self, node_name: impl Into<String>) -> Self {
            self.node_name = Some(node_name.into());
            self
        }
        pub fn ignore_constraints(mut self, ignore_constraints: bool) -> Self {
            self.ignore_constraints = Some(ignore_constraints);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/MovePrimaryReplica", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(node_name) = &self.node_name {
                    url.query_pairs_mut().append_pair("NodeName", node_name);
                }
                if let Some(ignore_constraints) = &self.ignore_constraints {
                    url.query_pairs_mut()
                        .append_pair("IgnoreConstraints", &ignore_constraints.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod move_secondary_replica {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) current_node_name: String,
        pub(crate) new_node_name: Option<String>,
        pub(crate) ignore_constraints: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn new_node_name(mut self, new_node_name: impl Into<String>) -> Self {
            self.new_node_name = Some(new_node_name.into());
            self
        }
        pub fn ignore_constraints(mut self, ignore_constraints: bool) -> Self {
            self.ignore_constraints = Some(ignore_constraints);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Partitions/{}/$/MoveSecondaryReplica",
                    self.client.endpoint(),
                    &self.partition_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let current_node_name = &self.current_node_name;
                url.query_pairs_mut().append_pair("CurrentNodeName", current_node_name);
                if let Some(new_node_name) = &self.new_node_name {
                    url.query_pairs_mut().append_pair("NewNodeName", new_node_name);
                }
                if let Some(ignore_constraints) = &self.ignore_constraints {
                    url.query_pairs_mut()
                        .append_pair("IgnoreConstraints", &ignore_constraints.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod create_repair_task {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) repair_task: models::RepairTask,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RepairTaskUpdateInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/CreateRepairTask", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.repair_task).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::RepairTaskUpdateInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod cancel_repair_task {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) repair_task_cancel_description: models::RepairTaskCancelDescription,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RepairTaskUpdateInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/CancelRepairTask", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.repair_task_cancel_description).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::RepairTaskUpdateInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod delete_repair_task {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) repair_task_delete_description: models::RepairTaskDeleteDescription,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/DeleteRepairTask", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.repair_task_delete_description).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_repair_task_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) task_id_filter: Option<String>,
        pub(crate) state_filter: Option<i64>,
        pub(crate) executor_filter: Option<String>,
    }
    impl Builder {
        pub fn task_id_filter(mut self, task_id_filter: impl Into<String>) -> Self {
            self.task_id_filter = Some(task_id_filter.into());
            self
        }
        pub fn state_filter(mut self, state_filter: i64) -> Self {
            self.state_filter = Some(state_filter);
            self
        }
        pub fn executor_filter(mut self, executor_filter: impl Into<String>) -> Self {
            self.executor_filter = Some(executor_filter.into());
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RepairTaskList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/GetRepairTaskList", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(task_id_filter) = &self.task_id_filter {
                    url.query_pairs_mut().append_pair("TaskIdFilter", task_id_filter);
                }
                if let Some(state_filter) = &self.state_filter {
                    url.query_pairs_mut().append_pair("StateFilter", &state_filter.to_string());
                }
                if let Some(executor_filter) = &self.executor_filter {
                    url.query_pairs_mut().append_pair("ExecutorFilter", executor_filter);
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::RepairTaskList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod force_approve_repair_task {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) repair_task_approve_description: models::RepairTaskApproveDescription,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RepairTaskUpdateInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/ForceApproveRepairTask", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.repair_task_approve_description).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::RepairTaskUpdateInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod update_repair_task_health_policy {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) repair_task_update_health_policy_description: models::RepairTaskUpdateHealthPolicyDescription,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RepairTaskUpdateInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/UpdateRepairTaskHealthPolicy", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.repair_task_update_health_policy_description).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::RepairTaskUpdateInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod update_repair_execution_state {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) repair_task: models::RepairTask,
    }
    impl Builder {
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RepairTaskUpdateInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/UpdateRepairExecutionState", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.repair_task).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::RepairTaskUpdateInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_replica_info_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) continuation_token: Option<String>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedReplicaInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/GetReplicas", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedReplicaInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_replica_info {
    use super::models;
    #[derive(Debug)]
    pub enum Response {
        Ok200(models::ReplicaInfo),
        NoContent204,
    }
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) replica_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Partitions/{}/$/GetReplicas/{}",
                    self.client.endpoint(),
                    &self.partition_id,
                    &self.replica_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ReplicaInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(Response::Ok200(rsp_value))
                    }
                    http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_replica_health {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) replica_id: String,
        pub(crate) events_health_state_filter: Option<i64>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn events_health_state_filter(mut self, events_health_state_filter: i64) -> Self {
            self.events_health_state_filter = Some(events_health_state_filter);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ReplicaHealth, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Partitions/{}/$/GetReplicas/{}/$/GetHealth",
                    self.client.endpoint(),
                    &self.partition_id,
                    &self.replica_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(events_health_state_filter) = &self.events_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("EventsHealthStateFilter", &events_health_state_filter.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ReplicaHealth =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_replica_health_using_policy {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) replica_id: String,
        pub(crate) events_health_state_filter: Option<i64>,
        pub(crate) application_health_policy: Option<models::ApplicationHealthPolicy>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn events_health_state_filter(mut self, events_health_state_filter: i64) -> Self {
            self.events_health_state_filter = Some(events_health_state_filter);
            self
        }
        pub fn application_health_policy(mut self, application_health_policy: impl Into<models::ApplicationHealthPolicy>) -> Self {
            self.application_health_policy = Some(application_health_policy.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ReplicaHealth, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Partitions/{}/$/GetReplicas/{}/$/GetHealth",
                    self.client.endpoint(),
                    &self.partition_id,
                    &self.replica_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(events_health_state_filter) = &self.events_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("EventsHealthStateFilter", &events_health_state_filter.to_string());
                }
                let req_body = if let Some(application_health_policy) = &self.application_health_policy {
                    req_builder = req_builder.header("content-type", "application/json");
                    azure_core::to_json(application_health_policy).map_err(Error::Serialize)?
                } else {
                    azure_core::EMPTY_BODY
                };
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ReplicaHealth =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod report_replica_health {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) replica_id: String,
        pub(crate) service_kind: String,
        pub(crate) health_information: models::HealthInformation,
        pub(crate) immediate: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn immediate(mut self, immediate: bool) -> Self {
            self.immediate = Some(immediate);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Partitions/{}/$/GetReplicas/{}/$/ReportHealth",
                    self.client.endpoint(),
                    &self.partition_id,
                    &self.replica_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let service_kind = &self.service_kind;
                url.query_pairs_mut().append_pair("ServiceKind", service_kind);
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.health_information).map_err(Error::Serialize)?;
                if let Some(immediate) = &self.immediate {
                    url.query_pairs_mut().append_pair("Immediate", &immediate.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_deployed_service_replica_info_list {
    use super::models;
    #[derive(Debug)]
    pub enum Response {
        Ok200(models::DeployedServiceReplicaInfoList),
        NoContent204,
    }
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) application_id: String,
        pub(crate) partition_id: Option<String>,
        pub(crate) service_manifest_name: Option<String>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn partition_id(mut self, partition_id: impl Into<String>) -> Self {
            self.partition_id = Some(partition_id.into());
            self
        }
        pub fn service_manifest_name(mut self, service_manifest_name: impl Into<String>) -> Self {
            self.service_manifest_name = Some(service_manifest_name.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetApplications/{}/$/GetReplicas",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(partition_id) = &self.partition_id {
                    url.query_pairs_mut().append_pair("PartitionId", partition_id);
                }
                if let Some(service_manifest_name) = &self.service_manifest_name {
                    url.query_pairs_mut().append_pair("ServiceManifestName", service_manifest_name);
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DeployedServiceReplicaInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(Response::Ok200(rsp_value))
                    }
                    http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_deployed_service_replica_detail_info {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) partition_id: String,
        pub(crate) replica_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(
            self,
        ) -> futures::future::BoxFuture<'static, std::result::Result<models::DeployedServiceReplicaDetailInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetPartitions/{}/$/GetReplicas/{}/$/GetDetail",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.partition_id,
                    &self.replica_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DeployedServiceReplicaDetailInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_deployed_service_replica_detail_info_by_partition_id {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) partition_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(
            self,
        ) -> futures::future::BoxFuture<'static, std::result::Result<models::DeployedServiceReplicaDetailInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetPartitions/{}/$/GetReplicas",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.partition_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DeployedServiceReplicaDetailInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod restart_replica {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) partition_id: String,
        pub(crate) replica_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetPartitions/{}/$/GetReplicas/{}/$/Restart",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.partition_id,
                    &self.replica_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod remove_replica {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) partition_id: String,
        pub(crate) replica_id: String,
        pub(crate) force_remove: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn force_remove(mut self, force_remove: bool) -> Self {
            self.force_remove = Some(force_remove);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetPartitions/{}/$/GetReplicas/{}/$/Delete",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.partition_id,
                    &self.replica_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(force_remove) = &self.force_remove {
                    url.query_pairs_mut().append_pair("ForceRemove", &force_remove.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_deployed_service_package_info_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) application_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(
            self,
        ) -> futures::future::BoxFuture<'static, std::result::Result<models::DeployedServicePackageInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetApplications/{}/$/GetServicePackages",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DeployedServicePackageInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_deployed_service_package_info_list_by_name {
    use super::models;
    #[derive(Debug)]
    pub enum Response {
        Ok200(models::DeployedServicePackageInfoList),
        NoContent204,
    }
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) application_id: String,
        pub(crate) service_package_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetApplications/{}/$/GetServicePackages/{}",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.application_id,
                    &self.service_package_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DeployedServicePackageInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(Response::Ok200(rsp_value))
                    }
                    http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_deployed_service_package_health {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) application_id: String,
        pub(crate) service_package_name: String,
        pub(crate) events_health_state_filter: Option<i64>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn events_health_state_filter(mut self, events_health_state_filter: i64) -> Self {
            self.events_health_state_filter = Some(events_health_state_filter);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DeployedServicePackageHealth, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetApplications/{}/$/GetServicePackages/{}/$/GetHealth",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.application_id,
                    &self.service_package_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(events_health_state_filter) = &self.events_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("EventsHealthStateFilter", &events_health_state_filter.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DeployedServicePackageHealth =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_deployed_service_package_health_using_policy {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) application_id: String,
        pub(crate) service_package_name: String,
        pub(crate) events_health_state_filter: Option<i64>,
        pub(crate) application_health_policy: Option<models::ApplicationHealthPolicy>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn events_health_state_filter(mut self, events_health_state_filter: i64) -> Self {
            self.events_health_state_filter = Some(events_health_state_filter);
            self
        }
        pub fn application_health_policy(mut self, application_health_policy: impl Into<models::ApplicationHealthPolicy>) -> Self {
            self.application_health_policy = Some(application_health_policy.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DeployedServicePackageHealth, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetApplications/{}/$/GetServicePackages/{}/$/GetHealth",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.application_id,
                    &self.service_package_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(events_health_state_filter) = &self.events_health_state_filter {
                    url.query_pairs_mut()
                        .append_pair("EventsHealthStateFilter", &events_health_state_filter.to_string());
                }
                let req_body = if let Some(application_health_policy) = &self.application_health_policy {
                    req_builder = req_builder.header("content-type", "application/json");
                    azure_core::to_json(application_health_policy).map_err(Error::Serialize)?
                } else {
                    azure_core::EMPTY_BODY
                };
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DeployedServicePackageHealth =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod report_deployed_service_package_health {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) application_id: String,
        pub(crate) service_package_name: String,
        pub(crate) health_information: models::HealthInformation,
        pub(crate) immediate: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn immediate(mut self, immediate: bool) -> Self {
            self.immediate = Some(immediate);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetApplications/{}/$/GetServicePackages/{}/$/ReportHealth",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.application_id,
                    &self.service_package_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.health_information).map_err(Error::Serialize)?;
                if let Some(immediate) = &self.immediate {
                    url.query_pairs_mut().append_pair("Immediate", &immediate.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod deploy_service_package_to_node {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) deploy_service_package_to_node_description: models::DeployServicePackageToNodeDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Nodes/{}/$/DeployServicePackage", self.client.endpoint(), &self.node_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.deploy_service_package_to_node_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_deployed_code_package_info_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) application_id: String,
        pub(crate) service_manifest_name: Option<String>,
        pub(crate) code_package_name: Option<String>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn service_manifest_name(mut self, service_manifest_name: impl Into<String>) -> Self {
            self.service_manifest_name = Some(service_manifest_name.into());
            self
        }
        pub fn code_package_name(mut self, code_package_name: impl Into<String>) -> Self {
            self.code_package_name = Some(code_package_name.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::DeployedCodePackageInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetApplications/{}/$/GetCodePackages",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(service_manifest_name) = &self.service_manifest_name {
                    url.query_pairs_mut().append_pair("ServiceManifestName", service_manifest_name);
                }
                if let Some(code_package_name) = &self.code_package_name {
                    url.query_pairs_mut().append_pair("CodePackageName", code_package_name);
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::DeployedCodePackageInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod restart_deployed_code_package {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) application_id: String,
        pub(crate) restart_deployed_code_package_description: models::RestartDeployedCodePackageDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetApplications/{}/$/GetCodePackages/$/Restart",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.restart_deployed_code_package_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_container_logs_deployed_on_node {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) application_id: String,
        pub(crate) service_manifest_name: String,
        pub(crate) code_package_name: String,
        pub(crate) tail: Option<String>,
        pub(crate) previous: Option<bool>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn tail(mut self, tail: impl Into<String>) -> Self {
            self.tail = Some(tail.into());
            self
        }
        pub fn previous(mut self, previous: bool) -> Self {
            self.previous = Some(previous);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ContainerLogs, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetApplications/{}/$/GetCodePackages/$/ContainerLogs",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let service_manifest_name = &self.service_manifest_name;
                url.query_pairs_mut().append_pair("ServiceManifestName", service_manifest_name);
                let code_package_name = &self.code_package_name;
                url.query_pairs_mut().append_pair("CodePackageName", code_package_name);
                if let Some(tail) = &self.tail {
                    url.query_pairs_mut().append_pair("Tail", tail);
                }
                if let Some(previous) = &self.previous {
                    url.query_pairs_mut().append_pair("Previous", &previous.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ContainerLogs =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod invoke_container_api {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) application_id: String,
        pub(crate) service_manifest_name: String,
        pub(crate) code_package_name: String,
        pub(crate) code_package_instance_id: String,
        pub(crate) container_api_request_body: models::ContainerApiRequestBody,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ContainerApiResponse, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Nodes/{}/$/GetApplications/{}/$/GetCodePackages/$/ContainerApi",
                    self.client.endpoint(),
                    &self.node_name,
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let service_manifest_name = &self.service_manifest_name;
                url.query_pairs_mut().append_pair("ServiceManifestName", service_manifest_name);
                let code_package_name = &self.code_package_name;
                url.query_pairs_mut().append_pair("CodePackageName", code_package_name);
                let code_package_instance_id = &self.code_package_instance_id;
                url.query_pairs_mut().append_pair("CodePackageInstanceId", code_package_instance_id);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.container_api_request_body).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ContainerApiResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod create_compose_deployment {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) create_compose_deployment_description: models::CreateComposeDeploymentDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ComposeDeployments/$/Create", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::PUT);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.create_compose_deployment_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_compose_deployment_status {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) deployment_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ComposeDeploymentStatusInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ComposeDeployments/{}", self.client.endpoint(), &self.deployment_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ComposeDeploymentStatusInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_compose_deployment_status_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) continuation_token: Option<String>,
        pub(crate) max_results: Option<i64>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn max_results(mut self, max_results: i64) -> Self {
            self.max_results = Some(max_results);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(
            self,
        ) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedComposeDeploymentStatusInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ComposeDeployments", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(max_results) = &self.max_results {
                    url.query_pairs_mut().append_pair("MaxResults", &max_results.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedComposeDeploymentStatusInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_compose_deployment_upgrade_progress {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) deployment_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(
            self,
        ) -> futures::future::BoxFuture<'static, std::result::Result<models::ComposeDeploymentUpgradeProgressInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/ComposeDeployments/{}/$/GetUpgradeProgress",
                    self.client.endpoint(),
                    &self.deployment_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ComposeDeploymentUpgradeProgressInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod remove_compose_deployment {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) deployment_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ComposeDeployments/{}/$/Delete", self.client.endpoint(), &self.deployment_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod start_compose_deployment_upgrade {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) deployment_name: String,
        pub(crate) compose_deployment_upgrade_description: models::ComposeDeploymentUpgradeDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ComposeDeployments/{}/$/Upgrade", self.client.endpoint(), &self.deployment_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.compose_deployment_upgrade_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod start_rollback_compose_deployment_upgrade {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) deployment_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/ComposeDeployments/{}/$/RollbackUpgrade",
                    self.client.endpoint(),
                    &self.deployment_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_chaos {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Chaos, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Tools/Chaos", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::Chaos =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod start_chaos {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) chaos_parameters: models::ChaosParameters,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Tools/Chaos/$/Start", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.chaos_parameters).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod stop_chaos {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Tools/Chaos/$/Stop", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_chaos_events {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) continuation_token: Option<String>,
        pub(crate) start_time_utc: Option<String>,
        pub(crate) end_time_utc: Option<String>,
        pub(crate) max_results: Option<i64>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn start_time_utc(mut self, start_time_utc: impl Into<String>) -> Self {
            self.start_time_utc = Some(start_time_utc.into());
            self
        }
        pub fn end_time_utc(mut self, end_time_utc: impl Into<String>) -> Self {
            self.end_time_utc = Some(end_time_utc.into());
            self
        }
        pub fn max_results(mut self, max_results: i64) -> Self {
            self.max_results = Some(max_results);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ChaosEventsSegment, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Tools/Chaos/Events", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(start_time_utc) = &self.start_time_utc {
                    url.query_pairs_mut().append_pair("StartTimeUtc", start_time_utc);
                }
                if let Some(end_time_utc) = &self.end_time_utc {
                    url.query_pairs_mut().append_pair("EndTimeUtc", end_time_utc);
                }
                if let Some(max_results) = &self.max_results {
                    url.query_pairs_mut().append_pair("MaxResults", &max_results.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ChaosEventsSegment =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_chaos_schedule {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ChaosScheduleDescription, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Tools/Chaos/Schedule", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ChaosScheduleDescription =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod post_chaos_schedule {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) chaos_schedule: models::ChaosScheduleDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Tools/Chaos/Schedule", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.chaos_schedule).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_image_store_content {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) content_path: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ImageStoreContent, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ImageStore/{}", self.client.endpoint(), &self.content_path);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ImageStoreContent =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod upload_file {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) content_path: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ImageStore/{}", self.client.endpoint(), &self.content_path);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::PUT);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod delete_image_store_content {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) content_path: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ImageStore/{}", self.client.endpoint(), &self.content_path);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::DELETE);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_image_store_root_content {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ImageStoreContent, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ImageStore", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ImageStoreContent =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod copy_image_store_content {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) image_store_copy_description: models::ImageStoreCopyDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ImageStore/$/Copy", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.image_store_copy_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod delete_image_store_upload_session {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) session_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ImageStore/$/DeleteUploadSession", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::DELETE);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let session_id = &self.session_id;
                url.query_pairs_mut().append_pair("session-id", session_id);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod commit_image_store_upload_session {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) session_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ImageStore/$/CommitUploadSession", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let session_id = &self.session_id;
                url.query_pairs_mut().append_pair("session-id", session_id);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_image_store_upload_session_by_id {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) session_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::UploadSession, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ImageStore/$/GetUploadSession", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let session_id = &self.session_id;
                url.query_pairs_mut().append_pair("session-id", session_id);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::UploadSession =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_image_store_upload_session_by_path {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) content_path: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::UploadSession, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ImageStore/{}/$/GetUploadSession", self.client.endpoint(), &self.content_path);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::UploadSession =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod upload_file_chunk {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) content_path: String,
        pub(crate) session_id: String,
        pub(crate) content_range: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ImageStore/{}/$/UploadChunk", self.client.endpoint(), &self.content_path);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::PUT);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let session_id = &self.session_id;
                url.query_pairs_mut().append_pair("session-id", session_id);
                req_builder = req_builder.header("Content-Range", &self.content_range);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_image_store_root_folder_size {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::FolderSizeInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ImageStore/$/FolderSize", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FolderSizeInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_image_store_folder_size {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) content_path: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::FolderSizeInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ImageStore/{}/$/FolderSize", self.client.endpoint(), &self.content_path);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FolderSizeInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_image_store_info {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ImageStoreInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/ImageStore/$/Info", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ImageStoreInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod invoke_infrastructure_command {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) command: String,
        pub(crate) service_id: Option<String>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn service_id(mut self, service_id: impl Into<String>) -> Self {
            self.service_id = Some(service_id.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::InfrastructureServiceResponse, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/InvokeInfrastructureCommand", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let command = &self.command;
                url.query_pairs_mut().append_pair("Command", command);
                if let Some(service_id) = &self.service_id {
                    url.query_pairs_mut().append_pair("ServiceId", service_id);
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::InfrastructureServiceResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod invoke_infrastructure_query {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) command: String,
        pub(crate) service_id: Option<String>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn service_id(mut self, service_id: impl Into<String>) -> Self {
            self.service_id = Some(service_id.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::InfrastructureServiceResponse, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/$/InvokeInfrastructureQuery", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let command = &self.command;
                url.query_pairs_mut().append_pair("Command", command);
                if let Some(service_id) = &self.service_id {
                    url.query_pairs_mut().append_pair("ServiceId", service_id);
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::InfrastructureServiceResponse =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod start_data_loss {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) partition_id: String,
        pub(crate) operation_id: String,
        pub(crate) data_loss_mode: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Faults/Services/{}/$/GetPartitions/{}/$/StartDataLoss",
                    self.client.endpoint(),
                    &self.service_id,
                    &self.partition_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let operation_id = &self.operation_id;
                url.query_pairs_mut().append_pair("OperationId", operation_id);
                let data_loss_mode = &self.data_loss_mode;
                url.query_pairs_mut().append_pair("DataLossMode", data_loss_mode);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_data_loss_progress {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) partition_id: String,
        pub(crate) operation_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PartitionDataLossProgress, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Faults/Services/{}/$/GetPartitions/{}/$/GetDataLossProgress",
                    self.client.endpoint(),
                    &self.service_id,
                    &self.partition_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let operation_id = &self.operation_id;
                url.query_pairs_mut().append_pair("OperationId", operation_id);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PartitionDataLossProgress =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod start_quorum_loss {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) partition_id: String,
        pub(crate) operation_id: String,
        pub(crate) quorum_loss_mode: String,
        pub(crate) quorum_loss_duration: i64,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Faults/Services/{}/$/GetPartitions/{}/$/StartQuorumLoss",
                    self.client.endpoint(),
                    &self.service_id,
                    &self.partition_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let operation_id = &self.operation_id;
                url.query_pairs_mut().append_pair("OperationId", operation_id);
                let quorum_loss_mode = &self.quorum_loss_mode;
                url.query_pairs_mut().append_pair("QuorumLossMode", quorum_loss_mode);
                let quorum_loss_duration = &self.quorum_loss_duration;
                url.query_pairs_mut()
                    .append_pair("QuorumLossDuration", &quorum_loss_duration.to_string());
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_quorum_loss_progress {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) partition_id: String,
        pub(crate) operation_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PartitionQuorumLossProgress, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Faults/Services/{}/$/GetPartitions/{}/$/GetQuorumLossProgress",
                    self.client.endpoint(),
                    &self.service_id,
                    &self.partition_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let operation_id = &self.operation_id;
                url.query_pairs_mut().append_pair("OperationId", operation_id);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PartitionQuorumLossProgress =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod start_partition_restart {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) partition_id: String,
        pub(crate) operation_id: String,
        pub(crate) restart_partition_mode: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Faults/Services/{}/$/GetPartitions/{}/$/StartRestart",
                    self.client.endpoint(),
                    &self.service_id,
                    &self.partition_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let operation_id = &self.operation_id;
                url.query_pairs_mut().append_pair("OperationId", operation_id);
                let restart_partition_mode = &self.restart_partition_mode;
                url.query_pairs_mut().append_pair("RestartPartitionMode", restart_partition_mode);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_partition_restart_progress {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) partition_id: String,
        pub(crate) operation_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PartitionRestartProgress, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Faults/Services/{}/$/GetPartitions/{}/$/GetRestartProgress",
                    self.client.endpoint(),
                    &self.service_id,
                    &self.partition_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let operation_id = &self.operation_id;
                url.query_pairs_mut().append_pair("OperationId", operation_id);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PartitionRestartProgress =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod start_node_transition {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) operation_id: String,
        pub(crate) node_transition_type: String,
        pub(crate) node_instance_id: String,
        pub(crate) stop_duration_in_seconds: i32,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Faults/Nodes/{}/$/StartTransition/", self.client.endpoint(), &self.node_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let operation_id = &self.operation_id;
                url.query_pairs_mut().append_pair("OperationId", operation_id);
                let node_transition_type = &self.node_transition_type;
                url.query_pairs_mut().append_pair("NodeTransitionType", node_transition_type);
                let node_instance_id = &self.node_instance_id;
                url.query_pairs_mut().append_pair("NodeInstanceId", node_instance_id);
                let stop_duration_in_seconds = &self.stop_duration_in_seconds;
                url.query_pairs_mut()
                    .append_pair("StopDurationInSeconds", &stop_duration_in_seconds.to_string());
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_node_transition_progress {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) operation_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::NodeTransitionProgress, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Faults/Nodes/{}/$/GetTransitionProgress",
                    self.client.endpoint(),
                    &self.node_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let operation_id = &self.operation_id;
                url.query_pairs_mut().append_pair("OperationId", operation_id);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::NodeTransitionProgress =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_fault_operation_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) type_filter: i64,
        pub(crate) state_filter: i64,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::OperationStatusList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Faults/", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let type_filter = &self.type_filter;
                url.query_pairs_mut().append_pair("TypeFilter", &type_filter.to_string());
                let state_filter = &self.state_filter;
                url.query_pairs_mut().append_pair("StateFilter", &state_filter.to_string());
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::OperationStatusList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod cancel_operation {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) operation_id: String,
        pub(crate) force: bool,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Faults/$/Cancel", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let operation_id = &self.operation_id;
                url.query_pairs_mut().append_pair("OperationId", operation_id);
                let force = &self.force;
                url.query_pairs_mut().append_pair("Force", &force.to_string());
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod create_backup_policy {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) backup_policy_description: models::BackupPolicyDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/BackupRestore/BackupPolicies/$/Create", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.backup_policy_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::CREATED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod delete_backup_policy {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) backup_policy_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/BackupRestore/BackupPolicies/{}/$/Delete",
                    self.client.endpoint(),
                    &self.backup_policy_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_backup_policy_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) continuation_token: Option<String>,
        pub(crate) max_results: Option<i64>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn max_results(mut self, max_results: i64) -> Self {
            self.max_results = Some(max_results);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(
            self,
        ) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedBackupPolicyDescriptionList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/BackupRestore/BackupPolicies", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(max_results) = &self.max_results {
                    url.query_pairs_mut().append_pair("MaxResults", &max_results.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedBackupPolicyDescriptionList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_backup_policy_by_name {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) backup_policy_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupPolicyDescription, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/BackupRestore/BackupPolicies/{}",
                    self.client.endpoint(),
                    &self.backup_policy_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::BackupPolicyDescription =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_all_entities_backed_up_by_policy {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) backup_policy_name: String,
        pub(crate) continuation_token: Option<String>,
        pub(crate) max_results: Option<i64>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn max_results(mut self, max_results: i64) -> Self {
            self.max_results = Some(max_results);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedBackupEntityList, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/BackupRestore/BackupPolicies/{}/$/GetBackupEnabledEntities",
                    self.client.endpoint(),
                    &self.backup_policy_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(max_results) = &self.max_results {
                    url.query_pairs_mut().append_pair("MaxResults", &max_results.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedBackupEntityList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod update_backup_policy {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) backup_policy_description: models::BackupPolicyDescription,
        pub(crate) backup_policy_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/BackupRestore/BackupPolicies/{}/$/Update",
                    self.client.endpoint(),
                    &self.backup_policy_name
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.backup_policy_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod enable_application_backup {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) enable_backup_description: models::EnableBackupDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Applications/{}/$/EnableBackup", self.client.endpoint(), &self.application_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.enable_backup_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod disable_application_backup {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) timeout: Option<i64>,
        pub(crate) disable_backup_description: Option<models::DisableBackupDescription>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn disable_backup_description(mut self, disable_backup_description: impl Into<models::DisableBackupDescription>) -> Self {
            self.disable_backup_description = Some(disable_backup_description.into());
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Applications/{}/$/DisableBackup", self.client.endpoint(), &self.application_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = if let Some(disable_backup_description) = &self.disable_backup_description {
                    req_builder = req_builder.header("content-type", "application/json");
                    azure_core::to_json(disable_backup_description).map_err(Error::Serialize)?
                } else {
                    azure_core::EMPTY_BODY
                };
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_application_backup_configuration_info {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) continuation_token: Option<String>,
        pub(crate) max_results: Option<i64>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn max_results(mut self, max_results: i64) -> Self {
            self.max_results = Some(max_results);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(
            self,
        ) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedBackupConfigurationInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Applications/{}/$/GetBackupConfigurationInfo",
                    self.client.endpoint(),
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(max_results) = &self.max_results {
                    url.query_pairs_mut().append_pair("MaxResults", &max_results.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedBackupConfigurationInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_application_backup_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) timeout: Option<i64>,
        pub(crate) latest: Option<bool>,
        pub(crate) start_date_time_filter: Option<String>,
        pub(crate) end_date_time_filter: Option<String>,
        pub(crate) continuation_token: Option<String>,
        pub(crate) max_results: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn latest(mut self, latest: bool) -> Self {
            self.latest = Some(latest);
            self
        }
        pub fn start_date_time_filter(mut self, start_date_time_filter: impl Into<String>) -> Self {
            self.start_date_time_filter = Some(start_date_time_filter.into());
            self
        }
        pub fn end_date_time_filter(mut self, end_date_time_filter: impl Into<String>) -> Self {
            self.end_date_time_filter = Some(end_date_time_filter.into());
            self
        }
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn max_results(mut self, max_results: i64) -> Self {
            self.max_results = Some(max_results);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedBackupInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Applications/{}/$/GetBackups", self.client.endpoint(), &self.application_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                if let Some(latest) = &self.latest {
                    url.query_pairs_mut().append_pair("Latest", &latest.to_string());
                }
                if let Some(start_date_time_filter) = &self.start_date_time_filter {
                    url.query_pairs_mut().append_pair("StartDateTimeFilter", start_date_time_filter);
                }
                if let Some(end_date_time_filter) = &self.end_date_time_filter {
                    url.query_pairs_mut().append_pair("EndDateTimeFilter", end_date_time_filter);
                }
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(max_results) = &self.max_results {
                    url.query_pairs_mut().append_pair("MaxResults", &max_results.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedBackupInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod suspend_application_backup {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Applications/{}/$/SuspendBackup", self.client.endpoint(), &self.application_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod resume_application_backup {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Applications/{}/$/ResumeBackup", self.client.endpoint(), &self.application_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod enable_service_backup {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) enable_backup_description: models::EnableBackupDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Services/{}/$/EnableBackup", self.client.endpoint(), &self.service_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.enable_backup_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod disable_service_backup {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) disable_backup_description: Option<models::DisableBackupDescription>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn disable_backup_description(mut self, disable_backup_description: impl Into<models::DisableBackupDescription>) -> Self {
            self.disable_backup_description = Some(disable_backup_description.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Services/{}/$/DisableBackup", self.client.endpoint(), &self.service_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let req_body = if let Some(disable_backup_description) = &self.disable_backup_description {
                    req_builder = req_builder.header("content-type", "application/json");
                    azure_core::to_json(disable_backup_description).map_err(Error::Serialize)?
                } else {
                    azure_core::EMPTY_BODY
                };
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_service_backup_configuration_info {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) continuation_token: Option<String>,
        pub(crate) max_results: Option<i64>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn max_results(mut self, max_results: i64) -> Self {
            self.max_results = Some(max_results);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(
            self,
        ) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedBackupConfigurationInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Services/{}/$/GetBackupConfigurationInfo",
                    self.client.endpoint(),
                    &self.service_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(max_results) = &self.max_results {
                    url.query_pairs_mut().append_pair("MaxResults", &max_results.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedBackupConfigurationInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_service_backup_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) timeout: Option<i64>,
        pub(crate) latest: Option<bool>,
        pub(crate) start_date_time_filter: Option<String>,
        pub(crate) end_date_time_filter: Option<String>,
        pub(crate) continuation_token: Option<String>,
        pub(crate) max_results: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn latest(mut self, latest: bool) -> Self {
            self.latest = Some(latest);
            self
        }
        pub fn start_date_time_filter(mut self, start_date_time_filter: impl Into<String>) -> Self {
            self.start_date_time_filter = Some(start_date_time_filter.into());
            self
        }
        pub fn end_date_time_filter(mut self, end_date_time_filter: impl Into<String>) -> Self {
            self.end_date_time_filter = Some(end_date_time_filter.into());
            self
        }
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn max_results(mut self, max_results: i64) -> Self {
            self.max_results = Some(max_results);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedBackupInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Services/{}/$/GetBackups", self.client.endpoint(), &self.service_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                if let Some(latest) = &self.latest {
                    url.query_pairs_mut().append_pair("Latest", &latest.to_string());
                }
                if let Some(start_date_time_filter) = &self.start_date_time_filter {
                    url.query_pairs_mut().append_pair("StartDateTimeFilter", start_date_time_filter);
                }
                if let Some(end_date_time_filter) = &self.end_date_time_filter {
                    url.query_pairs_mut().append_pair("EndDateTimeFilter", end_date_time_filter);
                }
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(max_results) = &self.max_results {
                    url.query_pairs_mut().append_pair("MaxResults", &max_results.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedBackupInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod suspend_service_backup {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Services/{}/$/SuspendBackup", self.client.endpoint(), &self.service_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod resume_service_backup {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Services/{}/$/ResumeBackup", self.client.endpoint(), &self.service_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod enable_partition_backup {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) enable_backup_description: models::EnableBackupDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/EnableBackup", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.enable_backup_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod disable_partition_backup {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) disable_backup_description: Option<models::DisableBackupDescription>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn disable_backup_description(mut self, disable_backup_description: impl Into<models::DisableBackupDescription>) -> Self {
            self.disable_backup_description = Some(disable_backup_description.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/DisableBackup", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let req_body = if let Some(disable_backup_description) = &self.disable_backup_description {
                    req_builder = req_builder.header("content-type", "application/json");
                    azure_core::to_json(disable_backup_description).map_err(Error::Serialize)?
                } else {
                    azure_core::EMPTY_BODY
                };
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_partition_backup_configuration_info {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(
            self,
        ) -> futures::future::BoxFuture<'static, std::result::Result<models::PartitionBackupConfigurationInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/Partitions/{}/$/GetBackupConfigurationInfo",
                    self.client.endpoint(),
                    &self.partition_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PartitionBackupConfigurationInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_partition_backup_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) timeout: Option<i64>,
        pub(crate) latest: Option<bool>,
        pub(crate) start_date_time_filter: Option<String>,
        pub(crate) end_date_time_filter: Option<String>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn latest(mut self, latest: bool) -> Self {
            self.latest = Some(latest);
            self
        }
        pub fn start_date_time_filter(mut self, start_date_time_filter: impl Into<String>) -> Self {
            self.start_date_time_filter = Some(start_date_time_filter.into());
            self
        }
        pub fn end_date_time_filter(mut self, end_date_time_filter: impl Into<String>) -> Self {
            self.end_date_time_filter = Some(end_date_time_filter.into());
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedBackupInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/GetBackups", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                if let Some(latest) = &self.latest {
                    url.query_pairs_mut().append_pair("Latest", &latest.to_string());
                }
                if let Some(start_date_time_filter) = &self.start_date_time_filter {
                    url.query_pairs_mut().append_pair("StartDateTimeFilter", start_date_time_filter);
                }
                if let Some(end_date_time_filter) = &self.end_date_time_filter {
                    url.query_pairs_mut().append_pair("EndDateTimeFilter", end_date_time_filter);
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedBackupInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod suspend_partition_backup {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/SuspendBackup", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod resume_partition_backup {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/ResumeBackup", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod backup_partition {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) backup_partition_description: Option<models::BackupPartitionDescription>,
        pub(crate) backup_timeout: Option<i64>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn backup_partition_description(mut self, backup_partition_description: impl Into<models::BackupPartitionDescription>) -> Self {
            self.backup_partition_description = Some(backup_partition_description.into());
            self
        }
        pub fn backup_timeout(mut self, backup_timeout: i64) -> Self {
            self.backup_timeout = Some(backup_timeout);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/Backup", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let req_body = if let Some(backup_partition_description) = &self.backup_partition_description {
                    req_builder = req_builder.header("content-type", "application/json");
                    azure_core::to_json(backup_partition_description).map_err(Error::Serialize)?
                } else {
                    azure_core::EMPTY_BODY
                };
                if let Some(backup_timeout) = &self.backup_timeout {
                    url.query_pairs_mut().append_pair("BackupTimeout", &backup_timeout.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_partition_backup_progress {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BackupProgressInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/GetBackupProgress", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::BackupProgressInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod restore_partition {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) restore_partition_description: models::RestorePartitionDescription,
        pub(crate) restore_timeout: Option<i64>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn restore_timeout(mut self, restore_timeout: i64) -> Self {
            self.restore_timeout = Some(restore_timeout);
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/Restore", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.restore_partition_description).map_err(Error::Serialize)?;
                if let Some(restore_timeout) = &self.restore_timeout {
                    url.query_pairs_mut().append_pair("RestoreTimeout", &restore_timeout.to_string());
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::ACCEPTED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_partition_restore_progress {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::RestoreProgressInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Partitions/{}/$/GetRestoreProgress", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::RestoreProgressInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_backups_from_backup_location {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) get_backup_by_storage_query_description: models::GetBackupByStorageQueryDescription,
        pub(crate) timeout: Option<i64>,
        pub(crate) continuation_token: Option<String>,
        pub(crate) max_results: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn max_results(mut self, max_results: i64) -> Self {
            self.max_results = Some(max_results);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedBackupInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/BackupRestore/$/GetBackups", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(max_results) = &self.max_results {
                    url.query_pairs_mut().append_pair("MaxResults", &max_results.to_string());
                }
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.get_backup_by_storage_query_description).map_err(Error::Serialize)?;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedBackupInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod create_name {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) name_description: models::NameDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Names/$/Create", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.name_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::CREATED => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_name_exists_info {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) name_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Names/{}", self.client.endpoint(), &self.name_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod delete_name {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) name_id: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Names/{}", self.client.endpoint(), &self.name_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::DELETE);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_sub_name_info_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) name_id: String,
        pub(crate) recursive: Option<bool>,
        pub(crate) continuation_token: Option<String>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn recursive(mut self, recursive: bool) -> Self {
            self.recursive = Some(recursive);
            self
        }
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedSubNameInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Names/{}/$/GetSubNames", self.client.endpoint(), &self.name_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(recursive) = &self.recursive {
                    url.query_pairs_mut().append_pair("Recursive", &recursive.to_string());
                }
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedSubNameInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_property_info_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) name_id: String,
        pub(crate) include_values: Option<bool>,
        pub(crate) continuation_token: Option<String>,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn include_values(mut self, include_values: bool) -> Self {
            self.include_values = Some(include_values);
            self
        }
        pub fn continuation_token(mut self, continuation_token: impl Into<String>) -> Self {
            self.continuation_token = Some(continuation_token.into());
            self
        }
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PagedPropertyInfoList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Names/{}/$/GetProperties", self.client.endpoint(), &self.name_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(include_values) = &self.include_values {
                    url.query_pairs_mut().append_pair("IncludeValues", &include_values.to_string());
                }
                if let Some(continuation_token) = &self.continuation_token {
                    url.query_pairs_mut().append_pair("ContinuationToken", continuation_token);
                }
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PagedPropertyInfoList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_property_info {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) name_id: String,
        pub(crate) property_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PropertyInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Names/{}/$/GetProperty", self.client.endpoint(), &self.name_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let property_name = &self.property_name;
                url.query_pairs_mut().append_pair("PropertyName", property_name);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PropertyInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod put_property {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) name_id: String,
        pub(crate) property_description: models::PropertyDescription,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Names/{}/$/GetProperty", self.client.endpoint(), &self.name_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::PUT);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.property_description).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod delete_property {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) name_id: String,
        pub(crate) property_name: String,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Names/{}/$/GetProperty", self.client.endpoint(), &self.name_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::DELETE);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                let property_name = &self.property_name;
                url.query_pairs_mut().append_pair("PropertyName", property_name);
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod submit_property_batch {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("Error response #response_type")]
        Conflict409 { value: models::FailedPropertyBatchInfo },
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) name_id: String,
        pub(crate) property_batch_description_list: models::PropertyBatchDescriptionList,
        pub(crate) timeout: Option<i64>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SuccessfulPropertyBatchInfo, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/Names/{}/$/GetProperties/$/SubmitBatch", self.client.endpoint(), &self.name_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::POST);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                req_builder = req_builder.header("content-type", "application/json");
                let req_body = azure_core::to_json(&self.property_batch_description_list).map_err(Error::Serialize)?;
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::SuccessfulPropertyBatchInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    http::StatusCode::CONFLICT => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FailedPropertyBatchInfo =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::Conflict409 { value: rsp_value })
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_cluster_event_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) start_time_utc: String,
        pub(crate) end_time_utc: String,
        pub(crate) timeout: Option<i64>,
        pub(crate) events_types_filter: Option<String>,
        pub(crate) exclude_analysis_events: Option<bool>,
        pub(crate) skip_correlation_lookup: Option<bool>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn events_types_filter(mut self, events_types_filter: impl Into<String>) -> Self {
            self.events_types_filter = Some(events_types_filter.into());
            self
        }
        pub fn exclude_analysis_events(mut self, exclude_analysis_events: bool) -> Self {
            self.exclude_analysis_events = Some(exclude_analysis_events);
            self
        }
        pub fn skip_correlation_lookup(mut self, skip_correlation_lookup: bool) -> Self {
            self.skip_correlation_lookup = Some(skip_correlation_lookup);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ClusterEventList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/EventsStore/Cluster/Events", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let start_time_utc = &self.start_time_utc;
                url.query_pairs_mut().append_pair("StartTimeUtc", start_time_utc);
                let end_time_utc = &self.end_time_utc;
                url.query_pairs_mut().append_pair("EndTimeUtc", end_time_utc);
                if let Some(events_types_filter) = &self.events_types_filter {
                    url.query_pairs_mut().append_pair("EventsTypesFilter", events_types_filter);
                }
                if let Some(exclude_analysis_events) = &self.exclude_analysis_events {
                    url.query_pairs_mut()
                        .append_pair("ExcludeAnalysisEvents", &exclude_analysis_events.to_string());
                }
                if let Some(skip_correlation_lookup) = &self.skip_correlation_lookup {
                    url.query_pairs_mut()
                        .append_pair("SkipCorrelationLookup", &skip_correlation_lookup.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ClusterEventList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_containers_event_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) start_time_utc: String,
        pub(crate) end_time_utc: String,
        pub(crate) timeout: Option<i64>,
        pub(crate) events_types_filter: Option<String>,
        pub(crate) exclude_analysis_events: Option<bool>,
        pub(crate) skip_correlation_lookup: Option<bool>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn events_types_filter(mut self, events_types_filter: impl Into<String>) -> Self {
            self.events_types_filter = Some(events_types_filter.into());
            self
        }
        pub fn exclude_analysis_events(mut self, exclude_analysis_events: bool) -> Self {
            self.exclude_analysis_events = Some(exclude_analysis_events);
            self
        }
        pub fn skip_correlation_lookup(mut self, skip_correlation_lookup: bool) -> Self {
            self.skip_correlation_lookup = Some(skip_correlation_lookup);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ContainerInstanceEventList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/EventsStore/Containers/Events", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let start_time_utc = &self.start_time_utc;
                url.query_pairs_mut().append_pair("StartTimeUtc", start_time_utc);
                let end_time_utc = &self.end_time_utc;
                url.query_pairs_mut().append_pair("EndTimeUtc", end_time_utc);
                if let Some(events_types_filter) = &self.events_types_filter {
                    url.query_pairs_mut().append_pair("EventsTypesFilter", events_types_filter);
                }
                if let Some(exclude_analysis_events) = &self.exclude_analysis_events {
                    url.query_pairs_mut()
                        .append_pair("ExcludeAnalysisEvents", &exclude_analysis_events.to_string());
                }
                if let Some(skip_correlation_lookup) = &self.skip_correlation_lookup {
                    url.query_pairs_mut()
                        .append_pair("SkipCorrelationLookup", &skip_correlation_lookup.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ContainerInstanceEventList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_node_event_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) node_name: String,
        pub(crate) start_time_utc: String,
        pub(crate) end_time_utc: String,
        pub(crate) timeout: Option<i64>,
        pub(crate) events_types_filter: Option<String>,
        pub(crate) exclude_analysis_events: Option<bool>,
        pub(crate) skip_correlation_lookup: Option<bool>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn events_types_filter(mut self, events_types_filter: impl Into<String>) -> Self {
            self.events_types_filter = Some(events_types_filter.into());
            self
        }
        pub fn exclude_analysis_events(mut self, exclude_analysis_events: bool) -> Self {
            self.exclude_analysis_events = Some(exclude_analysis_events);
            self
        }
        pub fn skip_correlation_lookup(mut self, skip_correlation_lookup: bool) -> Self {
            self.skip_correlation_lookup = Some(skip_correlation_lookup);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::NodeEventList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/EventsStore/Nodes/{}/$/Events", self.client.endpoint(), &self.node_name);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let start_time_utc = &self.start_time_utc;
                url.query_pairs_mut().append_pair("StartTimeUtc", start_time_utc);
                let end_time_utc = &self.end_time_utc;
                url.query_pairs_mut().append_pair("EndTimeUtc", end_time_utc);
                if let Some(events_types_filter) = &self.events_types_filter {
                    url.query_pairs_mut().append_pair("EventsTypesFilter", events_types_filter);
                }
                if let Some(exclude_analysis_events) = &self.exclude_analysis_events {
                    url.query_pairs_mut()
                        .append_pair("ExcludeAnalysisEvents", &exclude_analysis_events.to_string());
                }
                if let Some(skip_correlation_lookup) = &self.skip_correlation_lookup {
                    url.query_pairs_mut()
                        .append_pair("SkipCorrelationLookup", &skip_correlation_lookup.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::NodeEventList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_nodes_event_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) start_time_utc: String,
        pub(crate) end_time_utc: String,
        pub(crate) timeout: Option<i64>,
        pub(crate) events_types_filter: Option<String>,
        pub(crate) exclude_analysis_events: Option<bool>,
        pub(crate) skip_correlation_lookup: Option<bool>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn events_types_filter(mut self, events_types_filter: impl Into<String>) -> Self {
            self.events_types_filter = Some(events_types_filter.into());
            self
        }
        pub fn exclude_analysis_events(mut self, exclude_analysis_events: bool) -> Self {
            self.exclude_analysis_events = Some(exclude_analysis_events);
            self
        }
        pub fn skip_correlation_lookup(mut self, skip_correlation_lookup: bool) -> Self {
            self.skip_correlation_lookup = Some(skip_correlation_lookup);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::NodeEventList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/EventsStore/Nodes/Events", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let start_time_utc = &self.start_time_utc;
                url.query_pairs_mut().append_pair("StartTimeUtc", start_time_utc);
                let end_time_utc = &self.end_time_utc;
                url.query_pairs_mut().append_pair("EndTimeUtc", end_time_utc);
                if let Some(events_types_filter) = &self.events_types_filter {
                    url.query_pairs_mut().append_pair("EventsTypesFilter", events_types_filter);
                }
                if let Some(exclude_analysis_events) = &self.exclude_analysis_events {
                    url.query_pairs_mut()
                        .append_pair("ExcludeAnalysisEvents", &exclude_analysis_events.to_string());
                }
                if let Some(skip_correlation_lookup) = &self.skip_correlation_lookup {
                    url.query_pairs_mut()
                        .append_pair("SkipCorrelationLookup", &skip_correlation_lookup.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::NodeEventList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_application_event_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) application_id: String,
        pub(crate) start_time_utc: String,
        pub(crate) end_time_utc: String,
        pub(crate) timeout: Option<i64>,
        pub(crate) events_types_filter: Option<String>,
        pub(crate) exclude_analysis_events: Option<bool>,
        pub(crate) skip_correlation_lookup: Option<bool>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn events_types_filter(mut self, events_types_filter: impl Into<String>) -> Self {
            self.events_types_filter = Some(events_types_filter.into());
            self
        }
        pub fn exclude_analysis_events(mut self, exclude_analysis_events: bool) -> Self {
            self.exclude_analysis_events = Some(exclude_analysis_events);
            self
        }
        pub fn skip_correlation_lookup(mut self, skip_correlation_lookup: bool) -> Self {
            self.skip_correlation_lookup = Some(skip_correlation_lookup);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ApplicationEventList, Error>> {
            Box::pin(async move {
                let url_str = &format!(
                    "{}/EventsStore/Applications/{}/$/Events",
                    self.client.endpoint(),
                    &self.application_id
                );
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let start_time_utc = &self.start_time_utc;
                url.query_pairs_mut().append_pair("StartTimeUtc", start_time_utc);
                let end_time_utc = &self.end_time_utc;
                url.query_pairs_mut().append_pair("EndTimeUtc", end_time_utc);
                if let Some(events_types_filter) = &self.events_types_filter {
                    url.query_pairs_mut().append_pair("EventsTypesFilter", events_types_filter);
                }
                if let Some(exclude_analysis_events) = &self.exclude_analysis_events {
                    url.query_pairs_mut()
                        .append_pair("ExcludeAnalysisEvents", &exclude_analysis_events.to_string());
                }
                if let Some(skip_correlation_lookup) = &self.skip_correlation_lookup {
                    url.query_pairs_mut()
                        .append_pair("SkipCorrelationLookup", &skip_correlation_lookup.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ApplicationEventList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_applications_event_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) start_time_utc: String,
        pub(crate) end_time_utc: String,
        pub(crate) timeout: Option<i64>,
        pub(crate) events_types_filter: Option<String>,
        pub(crate) exclude_analysis_events: Option<bool>,
        pub(crate) skip_correlation_lookup: Option<bool>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn events_types_filter(mut self, events_types_filter: impl Into<String>) -> Self {
            self.events_types_filter = Some(events_types_filter.into());
            self
        }
        pub fn exclude_analysis_events(mut self, exclude_analysis_events: bool) -> Self {
            self.exclude_analysis_events = Some(exclude_analysis_events);
            self
        }
        pub fn skip_correlation_lookup(mut self, skip_correlation_lookup: bool) -> Self {
            self.skip_correlation_lookup = Some(skip_correlation_lookup);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ApplicationEventList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/EventsStore/Applications/Events", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let start_time_utc = &self.start_time_utc;
                url.query_pairs_mut().append_pair("StartTimeUtc", start_time_utc);
                let end_time_utc = &self.end_time_utc;
                url.query_pairs_mut().append_pair("EndTimeUtc", end_time_utc);
                if let Some(events_types_filter) = &self.events_types_filter {
                    url.query_pairs_mut().append_pair("EventsTypesFilter", events_types_filter);
                }
                if let Some(exclude_analysis_events) = &self.exclude_analysis_events {
                    url.query_pairs_mut()
                        .append_pair("ExcludeAnalysisEvents", &exclude_analysis_events.to_string());
                }
                if let Some(skip_correlation_lookup) = &self.skip_correlation_lookup {
                    url.query_pairs_mut()
                        .append_pair("SkipCorrelationLookup", &skip_correlation_lookup.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ApplicationEventList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_service_event_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) service_id: String,
        pub(crate) start_time_utc: String,
        pub(crate) end_time_utc: String,
        pub(crate) timeout: Option<i64>,
        pub(crate) events_types_filter: Option<String>,
        pub(crate) exclude_analysis_events: Option<bool>,
        pub(crate) skip_correlation_lookup: Option<bool>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn events_types_filter(mut self, events_types_filter: impl Into<String>) -> Self {
            self.events_types_filter = Some(events_types_filter.into());
            self
        }
        pub fn exclude_analysis_events(mut self, exclude_analysis_events: bool) -> Self {
            self.exclude_analysis_events = Some(exclude_analysis_events);
            self
        }
        pub fn skip_correlation_lookup(mut self, skip_correlation_lookup: bool) -> Self {
            self.skip_correlation_lookup = Some(skip_correlation_lookup);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ServiceEventList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/EventsStore/Services/{}/$/Events", self.client.endpoint(), &self.service_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let start_time_utc = &self.start_time_utc;
                url.query_pairs_mut().append_pair("StartTimeUtc", start_time_utc);
                let end_time_utc = &self.end_time_utc;
                url.query_pairs_mut().append_pair("EndTimeUtc", end_time_utc);
                if let Some(events_types_filter) = &self.events_types_filter {
                    url.query_pairs_mut().append_pair("EventsTypesFilter", events_types_filter);
                }
                if let Some(exclude_analysis_events) = &self.exclude_analysis_events {
                    url.query_pairs_mut()
                        .append_pair("ExcludeAnalysisEvents", &exclude_analysis_events.to_string());
                }
                if let Some(skip_correlation_lookup) = &self.skip_correlation_lookup {
                    url.query_pairs_mut()
                        .append_pair("SkipCorrelationLookup", &skip_correlation_lookup.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ServiceEventList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_services_event_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) start_time_utc: String,
        pub(crate) end_time_utc: String,
        pub(crate) timeout: Option<i64>,
        pub(crate) events_types_filter: Option<String>,
        pub(crate) exclude_analysis_events: Option<bool>,
        pub(crate) skip_correlation_lookup: Option<bool>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn events_types_filter(mut self, events_types_filter: impl Into<String>) -> Self {
            self.events_types_filter = Some(events_types_filter.into());
            self
        }
        pub fn exclude_analysis_events(mut self, exclude_analysis_events: bool) -> Self {
            self.exclude_analysis_events = Some(exclude_analysis_events);
            self
        }
        pub fn skip_correlation_lookup(mut self, skip_correlation_lookup: bool) -> Self {
            self.skip_correlation_lookup = Some(skip_correlation_lookup);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ServiceEventList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/EventsStore/Services/Events", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let start_time_utc = &self.start_time_utc;
                url.query_pairs_mut().append_pair("StartTimeUtc", start_time_utc);
                let end_time_utc = &self.end_time_utc;
                url.query_pairs_mut().append_pair("EndTimeUtc", end_time_utc);
                if let Some(events_types_filter) = &self.events_types_filter {
                    url.query_pairs_mut().append_pair("EventsTypesFilter", events_types_filter);
                }
                if let Some(exclude_analysis_events) = &self.exclude_analysis_events {
                    url.query_pairs_mut()
                        .append_pair("ExcludeAnalysisEvents", &exclude_analysis_events.to_string());
                }
                if let Some(skip_correlation_lookup) = &self.skip_correlation_lookup {
                    url.query_pairs_mut()
                        .append_pair("SkipCorrelationLookup", &skip_correlation_lookup.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::ServiceEventList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_partition_event_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) partition_id: String,
        pub(crate) start_time_utc: String,
        pub(crate) end_time_utc: String,
        pub(crate) timeout: Option<i64>,
        pub(crate) events_types_filter: Option<String>,
        pub(crate) exclude_analysis_events: Option<bool>,
        pub(crate) skip_correlation_lookup: Option<bool>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn events_types_filter(mut self, events_types_filter: impl Into<String>) -> Self {
            self.events_types_filter = Some(events_types_filter.into());
            self
        }
        pub fn exclude_analysis_events(mut self, exclude_analysis_events: bool) -> Self {
            self.exclude_analysis_events = Some(exclude_analysis_events);
            self
        }
        pub fn skip_correlation_lookup(mut self, skip_correlation_lookup: bool) -> Self {
            self.skip_correlation_lookup = Some(skip_correlation_lookup);
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PartitionEventList, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/EventsStore/Partitions/{}/$/Events", self.client.endpoint(), &self.partition_id);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "7.0.0.42");
                if let Some(timeout) = &self.timeout {
                    url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                }
                let start_time_utc = &self.start_time_utc;
                url.query_pairs_mut().append_pair("StartTimeUtc", start_time_utc);
                let end_time_utc = &self.end_time_utc;
                url.query_pairs_mut().append_pair("EndTimeUtc", end_time_utc);
                if let Some(events_types_filter) = &self.events_types_filter {
                    url.query_pairs_mut().append_pair("EventsTypesFilter", events_types_filter);
                }
                if let Some(exclude_analysis_events) = &self.exclude_analysis_events {
                    url.query_pairs_mut()
                        .append_pair("ExcludeAnalysisEvents", &exclude_analysis_events.to_string());
                }
                if let Some(skip_correlation_lookup) = &self.skip_correlation_lookup {
                    url.query_pairs_mut()
                        .append_pair("SkipCorrelationLookup", &skip_correlation_lookup.to_string());
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::PartitionEventList =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::FabricError =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_partitions_event_list {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::FabricError,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) start_time_utc: String,
        pub(crate) end_time_utc: String,
        pub(crate) timeout: Option<i64>,
        pub(crate) events_types_filter: Option<String>,
        pub(crate) exclude_analysis_events: Option<bool>,
        pub(crate) skip_correlation_lookup: Option<bool>,
    }
    impl Builder {
        pub fn timeout(mut self, timeout: i64) -> Self {
            self.timeout = Some(timeout);
            self
        }
        pub fn events_types_filter(mut self, events_types_filter: impl Into<String>) -> Self {
            self.events_types_filter = Some(events_types_filter.into());
            self
        }
        pub fn exclude_analysis_events(mut self, exclude_analysis_events: bool) -> Se