#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobDetails {
    #[serde(rename = "containerName")]
    pub container_name: String,
    #[serde(rename = "blobName", default, skip_serializing_if = "Option::is_none")]
    pub blob_name: Option<String>,
}
impl BlobDetails {
    pub fn new(container_name: String) -> Self {
        Self {
            container_name,
            blob_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ErrorData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobDetails {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "containerUri")]
    pub container_uri: String,
    #[serde(rename = "inputDataUri", default, skip_serializing_if = "Option::is_none")]
    pub input_data_uri: Option<String>,
    #[serde(rename = "inputDataFormat")]
    pub input_data_format: String,
    #[serde(rename = "inputParams", default, skip_serializing_if = "Option::is_none")]
    pub input_params: Option<serde_json::Value>,
    #[serde(rename = "providerId")]
    pub provider_id: String,
    pub target: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
    #[serde(rename = "outputDataUri", default, skip_serializing_if = "Option::is_none")]
    pub output_data_uri: Option<String>,
    #[serde(rename = "outputDataFormat", default, skip_serializing_if = "Option::is_none")]
    pub output_data_format: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<job_details::Status>,
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[serde(rename = "beginExecutionTime", default, skip_serializing_if = "Option::is_none")]
    pub begin_execution_time: Option<String>,
    #[serde(rename = "endExecutionTime", default, skip_serializing_if = "Option::is_none")]
    pub end_execution_time: Option<String>,
    #[serde(rename = "cancellationTime", default, skip_serializing_if = "Option::is_none")]
    pub cancellation_time: Option<String>,
    #[serde(rename = "errorData", default, skip_serializing_if = "Option::is_none")]
    pub error_data: Option<ErrorData>,
}
impl JobDetails {
    pub fn new(container_uri: String, input_data_format: String, provider_id: String, target: String) -> Self {
        Self {
            id: None,
            name: None,
            container_uri,
            input_data_uri: None,
            input_data_format,
            input_params: None,
            provider_id,
            target,
            metadata: None,
            output_data_uri: None,
            output_data_format: None,
            status: None,
            creation_time: None,
            begin_execution_time: None,
            end_execution_time: None,
            cancellation_time: None,
            error_data: None,
        }
    }
}
pub mod job_details {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Waiting,
        Executing,
        Succeeded,
        Failed,
        Cancelled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobDetailsList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JobDetails>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl JobDetailsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProviderStatus {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "currentAvailability", default, skip_serializing_if = "Option::is_none")]
    pub current_availability: Option<provider_status::CurrentAvailability>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub targets: Vec<TargetStatus>,
}
impl ProviderStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod provider_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CurrentAvailability {
        Available,
        Degraded,
        Unavailable,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProviderStatusList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ProviderStatus>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ProviderStatusList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Quota {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dimension: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<quota::Scope>,
    #[serde(rename = "providerId", default, skip_serializing_if = "Option::is_none")]
    pub provider_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub utilization: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub holds: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub limit: Option<f64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub period: Option<quota::Period>,
}
impl Quota {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod quota {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Scope {
        Workspace,
        Subscription,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Period {
        None,
        Monthly,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct QuotaList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Quota>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl QuotaList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SasUriResponse {
    #[serde(rename = "sasUri", default, skip_serializing_if = "Option::is_none")]
    pub sas_uri: Option<String>,
}
impl SasUriResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TargetStatus {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "currentAvailability", default, skip_serializing_if = "Option::is_none")]
    pub current_availability: Option<target_status::CurrentAvailability>,
    #[serde(rename = "averageQueueTime", default, skip_serializing_if = "Option::is_none")]
    pub average_queue_time: Option<i64>,
    #[serde(rename = "statusPage", default, skip_serializing_if = "Option::is_none")]
    pub status_page: Option<String>,
}
impl TargetStatus {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod target_status {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CurrentAvailability {
        Available,
        Degraded,
        Unavailable,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RestError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ErrorData>,
}
impl RestError {
    pub fn new() -> Self {
        Self::default()
    }
}
