#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "Credential type that uses Account Key for authentication."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AccountKeyAuthAzureKeyVaultCredential {
    #[serde(flatten)]
    pub credential: Credential,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AccountKeyAuthAzureKeyVaultCredential {
    pub fn new(credential: Credential) -> Self {
        Self {
            credential,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccountKeyCredentialProperties {
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl AccountKeyCredentialProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen1CredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AdlsGen1CredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdlsGen1CredentialScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
}
impl AdlsGen1CredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen1DataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AdlsGen1DataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen1MsiScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AdlsGen1MsiScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdlsGen1MsiScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
}
impl AdlsGen1MsiScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdlsGen1Properties {
    #[serde(flatten)]
    pub azure_data_source_properties: AzureDataSourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<String>,
}
impl AdlsGen1Properties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen1ScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AdlsGen1ScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdlsGen1ScanRulesetProperties {
    #[serde(flatten)]
    pub scanning_rule_scan_ruleset_properties: ScanningRuleScanRulesetProperties,
}
impl AdlsGen1ScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen1SystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AdlsGen1SystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2CredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AdlsGen2CredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdlsGen2CredentialScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
}
impl AdlsGen2CredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2DataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AdlsGen2DataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2MsiScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AdlsGen2MsiScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdlsGen2MsiScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
}
impl AdlsGen2MsiScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdlsGen2Properties {
    #[serde(flatten)]
    pub azure_data_source_properties: AzureDataSourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<String>,
}
impl AdlsGen2Properties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2ScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AdlsGen2ScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AdlsGen2ScanRulesetProperties {
    #[serde(flatten)]
    pub scanning_rule_scan_ruleset_properties: ScanningRuleScanRulesetProperties,
}
impl AdlsGen2ScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AdlsGen2SystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AdlsGen2SystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonAccountCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonAccountCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonAccountCredentialScanProperties {
    #[serde(flatten)]
    pub expanding_resource_scan_properties: ExpandingResourceScanProperties,
}
impl AmazonAccountCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonAccountDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonAccountDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonAccountProperties {
    #[serde(flatten)]
    pub data_source_properties: DataSourceProperties,
    #[serde(rename = "awsAccountId", default, skip_serializing_if = "Option::is_none")]
    pub aws_account_id: Option<String>,
    #[serde(rename = "roleARN", default, skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}
impl AmazonAccountProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonAccountScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonAccountScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonAccountScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl AmazonAccountScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonAccountSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonAccountSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonPostgreSqlCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonPostgreSqlCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonPostgreSqlCredentialScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
    #[serde(rename = "serverEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub server_endpoint: Option<String>,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[serde(rename = "vpcEndpointServiceName", default, skip_serializing_if = "Option::is_none")]
    pub vpc_endpoint_service_name: Option<String>,
}
impl AmazonPostgreSqlCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonPostgreSqlDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonPostgreSqlDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonPostgreSqlProperties {
    #[serde(flatten)]
    pub data_source_properties: DataSourceProperties,
    #[serde(rename = "serverEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub server_endpoint: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[serde(rename = "vpcEndpointServiceName", default, skip_serializing_if = "Option::is_none")]
    pub vpc_endpoint_service_name: Option<String>,
}
impl AmazonPostgreSqlProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonPostgreSqlRoleArnScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonPostgreSqlRoleArnScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonPostgreSqlRoleArnScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
    #[serde(rename = "serverEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub server_endpoint: Option<String>,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[serde(rename = "vpcEndpointServiceName", default, skip_serializing_if = "Option::is_none")]
    pub vpc_endpoint_service_name: Option<String>,
}
impl AmazonPostgreSqlRoleArnScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonPostgreSqlScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonPostgreSqlScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonPostgreSqlScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl AmazonPostgreSqlScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonPostgreSqlSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonPostgreSqlSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3CredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonS3CredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonS3CredentialScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
    #[serde(rename = "roleARN", default, skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    #[serde(rename = "isMauiScan", default, skip_serializing_if = "Option::is_none")]
    pub is_maui_scan: Option<bool>,
}
impl AmazonS3CredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3DataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonS3DataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonS3Properties {
    #[serde(flatten)]
    pub data_source_properties: DataSourceProperties,
    #[serde(rename = "serviceUrl", default, skip_serializing_if = "Option::is_none")]
    pub service_url: Option<String>,
    #[serde(rename = "roleARN", default, skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}
impl AmazonS3Properties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3RoleArnScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonS3RoleArnScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonS3RoleArnScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
    #[serde(rename = "roleARN", default, skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    #[serde(rename = "isMauiScan", default, skip_serializing_if = "Option::is_none")]
    pub is_maui_scan: Option<bool>,
}
impl AmazonS3RoleArnScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3ScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonS3ScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonS3ScanRulesetProperties {
    #[serde(flatten)]
    pub scanning_rule_scan_ruleset_properties: ScanningRuleScanRulesetProperties,
}
impl AmazonS3ScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonS3SystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonS3SystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonSqlCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonSqlCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonSqlCredentialScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
    #[serde(rename = "serverEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub server_endpoint: Option<String>,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[serde(rename = "vpcEndpointServiceName", default, skip_serializing_if = "Option::is_none")]
    pub vpc_endpoint_service_name: Option<String>,
}
impl AmazonSqlCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonSqlDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonSqlDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonSqlProperties {
    #[serde(flatten)]
    pub data_source_properties: DataSourceProperties,
    #[serde(rename = "serverEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub server_endpoint: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[serde(rename = "vpcEndpointServiceName", default, skip_serializing_if = "Option::is_none")]
    pub vpc_endpoint_service_name: Option<String>,
}
impl AmazonSqlProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonSqlScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonSqlScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AmazonSqlScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl AmazonSqlScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AmazonSqlSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AmazonSqlSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureCosmosDbCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureCosmosDbCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureCosmosDbCredentialScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
}
impl AzureCosmosDbCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureCosmosDbDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureCosmosDbDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureCosmosDbProperties {
    #[serde(flatten)]
    pub azure_data_source_properties: AzureDataSourceProperties,
    #[serde(rename = "accountUri", default, skip_serializing_if = "Option::is_none")]
    pub account_uri: Option<String>,
}
impl AzureCosmosDbProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureCosmosDbScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureCosmosDbScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureCosmosDbScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl AzureCosmosDbScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureCosmosDbSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureCosmosDbSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureDataExplorerCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureDataExplorerCredentialScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub database: Option<String>,
}
impl AzureDataExplorerCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureDataExplorerDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerMsiScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureDataExplorerMsiScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureDataExplorerMsiScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub database: Option<String>,
}
impl AzureDataExplorerMsiScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureDataExplorerProperties {
    #[serde(flatten)]
    pub azure_data_source_properties: AzureDataSourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<String>,
}
impl AzureDataExplorerProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureDataExplorerScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureDataExplorerScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl AzureDataExplorerScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureDataExplorerSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureDataExplorerSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureDataSourceProperties {
    #[serde(flatten)]
    pub data_source_properties: DataSourceProperties,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "resourceName", default, skip_serializing_if = "Option::is_none")]
    pub resource_name: Option<String>,
}
impl AzureDataSourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileServiceCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureFileServiceCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFileServiceCredentialScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
    #[serde(rename = "shareName", default, skip_serializing_if = "Option::is_none")]
    pub share_name: Option<String>,
}
impl AzureFileServiceCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileServiceDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureFileServiceDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFileServiceProperties {
    #[serde(flatten)]
    pub azure_data_source_properties: AzureDataSourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<String>,
}
impl AzureFileServiceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileServiceScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureFileServiceScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureFileServiceScanRulesetProperties {
    #[serde(flatten)]
    pub scanning_rule_scan_ruleset_properties: ScanningRuleScanRulesetProperties,
}
impl AzureFileServiceScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureFileServiceSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureFileServiceSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureKeyVault {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureKeyVault {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureKeyVaultList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<AzureKeyVault>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
}
impl AzureKeyVaultList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureKeyVaultProperties {
    #[serde(rename = "baseUrl", default, skip_serializing_if = "Option::is_none")]
    pub base_url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl AzureKeyVaultProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMySqlCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureMySqlCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureMySqlCredentialScanProperties {
    #[serde(flatten)]
    pub azure_my_sql_scan_properties: AzureMySqlScanProperties,
}
impl AzureMySqlCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMySqlDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureMySqlDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureMySqlProperties {
    #[serde(flatten)]
    pub azure_data_source_properties: AzureDataSourceProperties,
    #[serde(rename = "serverEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub server_endpoint: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
}
impl AzureMySqlProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureMySqlScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(rename = "serverEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub server_endpoint: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
}
impl AzureMySqlScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMySqlScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureMySqlScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureMySqlScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl AzureMySqlScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMySqlSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureMySqlSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzurePostgreSqlCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzurePostgreSqlCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzurePostgreSqlCredentialScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
    #[serde(rename = "serverEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub server_endpoint: Option<String>,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
    #[serde(rename = "sslMode", default, skip_serializing_if = "Option::is_none")]
    pub ssl_mode: Option<i32>,
}
impl AzurePostgreSqlCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzurePostgreSqlDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzurePostgreSqlDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzurePostgreSqlProperties {
    #[serde(flatten)]
    pub azure_data_source_properties: AzureDataSourceProperties,
    #[serde(rename = "serverEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub server_endpoint: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
}
impl AzurePostgreSqlProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzurePostgreSqlScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzurePostgreSqlScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzurePostgreSqlScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl AzurePostgreSqlScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzurePostgreSqlSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzurePostgreSqlSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureResourceGroupCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureResourceGroupCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureResourceGroupCredentialScanProperties {
    #[serde(flatten)]
    pub expanding_resource_scan_properties: ExpandingResourceScanProperties,
}
impl AzureResourceGroupCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureResourceGroupDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureResourceGroupDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureResourceGroupMsiScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureResourceGroupMsiScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureResourceGroupMsiScanProperties {
    #[serde(flatten)]
    pub expanding_resource_scan_properties: ExpandingResourceScanProperties,
}
impl AzureResourceGroupMsiScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureResourceGroupProperties {
    #[serde(flatten)]
    pub data_source_properties: DataSourceProperties,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
}
impl AzureResourceGroupProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureResourceGroupScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureResourceGroupScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureResourceGroupScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl AzureResourceGroupScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureResourceGroupSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureResourceGroupSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlCredentialScanProperties {
    #[serde(flatten)]
    pub azure_sql_scan_properties: AzureSqlScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
}
impl AzureSqlCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDataWarehouseCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSqlDataWarehouseCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlDataWarehouseCredentialScanProperties {
    #[serde(flatten)]
    pub azure_sql_credential_scan_properties: AzureSqlCredentialScanProperties,
}
impl AzureSqlDataWarehouseCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDataWarehouseDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSqlDataWarehouseDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDataWarehouseMsiScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSqlDataWarehouseMsiScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlDataWarehouseMsiScanProperties {
    #[serde(flatten)]
    pub azure_sql_scan_properties: AzureSqlScanProperties,
}
impl AzureSqlDataWarehouseMsiScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlDataWarehouseProperties {
    #[serde(flatten)]
    pub azure_data_source_properties: AzureDataSourceProperties,
    #[serde(rename = "serverEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub server_endpoint: Option<String>,
}
impl AzureSqlDataWarehouseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDataWarehouseScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSqlDataWarehouseScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlDataWarehouseScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl AzureSqlDataWarehouseScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDataWarehouseSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSqlDataWarehouseSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDatabaseCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSqlDatabaseCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlDatabaseCredentialScanProperties {
    #[serde(flatten)]
    pub azure_sql_credential_scan_properties: AzureSqlCredentialScanProperties,
}
impl AzureSqlDatabaseCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDatabaseDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSqlDatabaseDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDatabaseManagedInstanceCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSqlDatabaseManagedInstanceCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlDatabaseManagedInstanceCredentialScanProperties {
    #[serde(flatten)]
    pub azure_sql_credential_scan_properties: AzureSqlCredentialScanProperties,
}
impl AzureSqlDatabaseManagedInstanceCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDatabaseManagedInstanceDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSqlDatabaseManagedInstanceDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDatabaseManagedInstanceMsiScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSqlDatabaseManagedInstanceMsiScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlDatabaseManagedInstanceMsiScanProperties {
    #[serde(flatten)]
    pub azure_sql_scan_properties: AzureSqlScanProperties,
}
impl AzureSqlDatabaseManagedInstanceMsiScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlDatabaseManagedInstanceProperties {
    #[serde(flatten)]
    pub azure_data_source_properties: AzureDataSourceProperties,
    #[serde(rename = "serverEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub server_endpoint: Option<String>,
}
impl AzureSqlDatabaseManagedInstanceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDatabaseManagedInstanceScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSqlDatabaseManagedInstanceScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlDatabaseManagedInstanceScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl AzureSqlDatabaseManagedInstanceScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDatabaseManagedInstanceSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSqlDatabaseManagedInstanceSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDatabaseMsiScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSqlDatabaseMsiScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlDatabaseMsiScanProperties {
    #[serde(flatten)]
    pub azure_sql_scan_properties: AzureSqlScanProperties,
}
impl AzureSqlDatabaseMsiScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlDatabaseProperties {
    #[serde(flatten)]
    pub azure_data_source_properties: AzureDataSourceProperties,
    #[serde(rename = "serverEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub server_endpoint: Option<String>,
}
impl AzureSqlDatabaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDatabaseScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSqlDatabaseScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlDatabaseScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl AzureSqlDatabaseScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSqlDatabaseSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSqlDatabaseSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSqlScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(rename = "serverEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub server_endpoint: Option<String>,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
}
impl AzureSqlScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureStorageCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureStorageCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageCredentialScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
}
impl AzureStorageCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureStorageDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureStorageDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureStorageMsiScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureStorageMsiScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageMsiScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
}
impl AzureStorageMsiScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageProperties {
    #[serde(flatten)]
    pub azure_data_source_properties: AzureDataSourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<String>,
}
impl AzureStorageProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureStorageScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureStorageScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureStorageScanRulesetProperties {
    #[serde(flatten)]
    pub scanning_rule_scan_ruleset_properties: ScanningRuleScanRulesetProperties,
}
impl AzureStorageScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureStorageSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureStorageSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSubscriptionCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSubscriptionCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSubscriptionCredentialScanProperties {
    #[serde(flatten)]
    pub expanding_resource_scan_properties: ExpandingResourceScanProperties,
}
impl AzureSubscriptionCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSubscriptionDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSubscriptionDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSubscriptionMsiScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSubscriptionMsiScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSubscriptionMsiScanProperties {
    #[serde(flatten)]
    pub expanding_resource_scan_properties: ExpandingResourceScanProperties,
}
impl AzureSubscriptionMsiScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSubscriptionProperties {
    #[serde(flatten)]
    pub data_source_properties: DataSourceProperties,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
}
impl AzureSubscriptionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSubscriptionScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSubscriptionScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSubscriptionScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl AzureSubscriptionScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSubscriptionSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSubscriptionSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSynapseCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSynapseCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSynapseCredentialScanProperties {
    #[serde(flatten)]
    pub expanding_resource_scan_properties: ExpandingResourceScanProperties,
}
impl AzureSynapseCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSynapseDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSynapseDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSynapseMsiScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSynapseMsiScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSynapseMsiScanProperties {
    #[serde(flatten)]
    pub expanding_resource_scan_properties: ExpandingResourceScanProperties,
}
impl AzureSynapseMsiScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSynapseProperties {
    #[serde(flatten)]
    pub azure_data_source_properties: AzureDataSourceProperties,
    #[serde(rename = "sqlEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub sql_endpoint: Option<String>,
    #[serde(rename = "sqlOnDemandEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub sql_on_demand_endpoint: Option<String>,
}
impl AzureSynapseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSynapseScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSynapseScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSynapseScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl AzureSynapseScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSynapseSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSynapseSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSynapseWorkspaceCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSynapseWorkspaceCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSynapseWorkspaceCredentialScanProperties {
    #[serde(flatten)]
    pub expanding_resource_scan_properties: ExpandingResourceScanProperties,
}
impl AzureSynapseWorkspaceCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSynapseWorkspaceDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSynapseWorkspaceDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSynapseWorkspaceMsiScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSynapseWorkspaceMsiScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSynapseWorkspaceMsiScanProperties {
    #[serde(flatten)]
    pub expanding_resource_scan_properties: ExpandingResourceScanProperties,
}
impl AzureSynapseWorkspaceMsiScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSynapseWorkspaceProperties {
    #[serde(flatten)]
    pub azure_data_source_properties: AzureDataSourceProperties,
    #[serde(rename = "dedicatedSqlEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub dedicated_sql_endpoint: Option<String>,
    #[serde(rename = "serverlessSqlEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub serverless_sql_endpoint: Option<String>,
}
impl AzureSynapseWorkspaceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSynapseWorkspaceScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSynapseWorkspaceScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureSynapseWorkspaceScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl AzureSynapseWorkspaceScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureSynapseWorkspaceSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AzureSynapseWorkspaceSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[doc = "Credential type that uses Basic authentication."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BasicAuthAzureKeyVaultCredential {
    #[serde(flatten)]
    pub credential: Credential,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl BasicAuthAzureKeyVaultCredential {
    pub fn new(credential: Credential) -> Self {
        Self {
            credential,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ClassificationRule {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    pub kind: classification_rule::Kind,
}
impl ClassificationRule {
    pub fn new(kind: classification_rule::Kind) -> Self {
        Self {
            proxy_resource: ProxyResource::default(),
            kind,
        }
    }
}
pub mod classification_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        System,
        Custom,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ClassificationRuleList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ClassificationRule>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
}
impl ClassificationRuleList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ClassificationRulePattern {
    pub kind: classification_rule_pattern::Kind,
}
impl ClassificationRulePattern {
    pub fn new(kind: classification_rule_pattern::Kind) -> Self {
        Self { kind }
    }
}
pub mod classification_rule_pattern {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        Regex,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CollectionReference {
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
    #[serde(rename = "referenceName", default, skip_serializing_if = "Option::is_none")]
    pub reference_name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl CollectionReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConnectedVia {
    #[serde(rename = "referenceName", default, skip_serializing_if = "Option::is_none")]
    pub reference_name: Option<String>,
    #[serde(rename = "integrationRuntimeType", default, skip_serializing_if = "Option::is_none")]
    pub integration_runtime_type: Option<String>,
}
impl ConnectedVia {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Credential type that uses consumer provided key and secret for authentication."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConsumerKeyAuthAzureKeyVaultCredential {
    #[serde(flatten)]
    pub credential: Credential,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl ConsumerKeyAuthAzureKeyVaultCredential {
    pub fn new(credential: Credential) -> Self {
        Self {
            credential,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ConsumerKeyCredentialProperties {
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl ConsumerKeyCredentialProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Credential {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    pub kind: credential::Kind,
}
impl Credential {
    pub fn new(kind: credential::Kind) -> Self {
        Self {
            proxy_resource: ProxyResource::default(),
            kind,
        }
    }
}
pub mod credential {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        AccountKey,
        ServicePrincipal,
        BasicAuth,
        SqlAuth,
        #[serde(rename = "AmazonARN")]
        AmazonArn,
        ConsumerKeyAuth,
        DelegatedAuth,
        ManagedIdentity,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CredentialList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Credential>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
}
impl CredentialList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CredentialReference {
    #[serde(rename = "referenceName", default, skip_serializing_if = "Option::is_none")]
    pub reference_name: Option<String>,
    #[serde(rename = "credentialType", default, skip_serializing_if = "Option::is_none")]
    pub credential_type: Option<credential_reference::CredentialType>,
}
impl CredentialReference {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod credential_reference {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CredentialType {
        AccountKey,
        ServicePrincipal,
        BasicAuth,
        SqlAuth,
        #[serde(rename = "AmazonARN")]
        AmazonArn,
        ConsumerKeyAuth,
        DelegatedAuth,
        ManagedIdentity,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomClassificationRule {
    #[serde(flatten)]
    pub classification_rule: ClassificationRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl CustomClassificationRule {
    pub fn new(classification_rule: ClassificationRule) -> Self {
        Self {
            classification_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomClassificationRuleProperties {
    #[serde(rename = "minimumPercentageMatch", default, skip_serializing_if = "Option::is_none")]
    pub minimum_percentage_match: Option<f64>,
    #[serde(rename = "classificationAction", default, skip_serializing_if = "Option::is_none")]
    pub classification_action: Option<custom_classification_rule_properties::ClassificationAction>,
    #[serde(rename = "dataPatterns", default, skip_serializing_if = "Vec::is_empty")]
    pub data_patterns: Vec<ClassificationRulePattern>,
    #[serde(rename = "columnPatterns", default, skip_serializing_if = "Vec::is_empty")]
    pub column_patterns: Vec<ClassificationRulePattern>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i32>,
    #[serde(rename = "classificationName", default, skip_serializing_if = "Option::is_none")]
    pub classification_name: Option<String>,
    #[serde(rename = "ruleStatus", default, skip_serializing_if = "Option::is_none")]
    pub rule_status: Option<custom_classification_rule_properties::RuleStatus>,
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl CustomClassificationRuleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod custom_classification_rule_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ClassificationAction {
        Keep,
        Delete,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RuleStatus {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomFileExtension {
    #[serde(rename = "customFileType", default, skip_serializing_if = "Option::is_none")]
    pub custom_file_type: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "fileExtension", default, skip_serializing_if = "Option::is_none")]
    pub file_extension: Option<String>,
}
impl CustomFileExtension {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomFileType {
    #[serde(rename = "builtInType", default, skip_serializing_if = "Option::is_none")]
    pub built_in_type: Option<custom_file_type::BuiltInType>,
    #[serde(rename = "customDelimiter", default, skip_serializing_if = "Option::is_none")]
    pub custom_delimiter: Option<String>,
}
impl CustomFileType {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod custom_file_type {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum BuiltInType {
        #[serde(rename = "AVRO")]
        Avro,
        #[serde(rename = "ORC")]
        Orc,
        #[serde(rename = "PARQUET")]
        Parquet,
        #[serde(rename = "JSON")]
        Json,
        #[serde(rename = "TXT")]
        Txt,
        #[serde(rename = "XML")]
        Xml,
        Documents,
        #[serde(rename = "CSV")]
        Csv,
        #[serde(rename = "PSV")]
        Psv,
        #[serde(rename = "SSV")]
        Ssv,
        #[serde(rename = "TSV")]
        Tsv,
        #[serde(rename = "GZ")]
        Gz,
        #[serde(rename = "DOC")]
        Doc,
        #[serde(rename = "DOCM")]
        Docm,
        #[serde(rename = "DOCX")]
        Docx,
        #[serde(rename = "DOT")]
        Dot,
        #[serde(rename = "ODP")]
        Odp,
        #[serde(rename = "ODS")]
        Ods,
        #[serde(rename = "ODT")]
        Odt,
        #[serde(rename = "PDF")]
        Pdf,
        #[serde(rename = "POT")]
        Pot,
        #[serde(rename = "PPS")]
        Pps,
        #[serde(rename = "PPSX")]
        Ppsx,
        #[serde(rename = "PPT")]
        Ppt,
        #[serde(rename = "PPTM")]
        Pptm,
        #[serde(rename = "PPTX")]
        Pptx,
        #[serde(rename = "XLC")]
        Xlc,
        #[serde(rename = "XLS")]
        Xls,
        #[serde(rename = "XLSB")]
        Xlsb,
        #[serde(rename = "XLSM")]
        Xlsm,
        #[serde(rename = "XLSX")]
        Xlsx,
        #[serde(rename = "XLT")]
        Xlt,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataSource {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    pub kind: data_source::Kind,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub scans: Vec<Scan>,
}
impl DataSource {
    pub fn new(kind: data_source::Kind) -> Self {
        Self {
            proxy_resource: ProxyResource::default(),
            kind,
            scans: Vec::new(),
        }
    }
}
pub mod data_source {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        None,
        AzureSubscription,
        AzureResourceGroup,
        AzureSynapseWorkspace,
        AzureSynapse,
        AdlsGen1,
        AdlsGen2,
        AmazonAccount,
        AmazonS3,
        AmazonSql,
        AzureCosmosDb,
        AzureDataExplorer,
        AzureFileService,
        AzureSqlDatabase,
        AmazonPostgreSql,
        AzurePostgreSql,
        SqlServerDatabase,
        AzureSqlDatabaseManagedInstance,
        AzureSqlDataWarehouse,
        AzureMySql,
        AzureStorage,
        Teradata,
        Oracle,
        SapS4Hana,
        SapEcc,
        #[serde(rename = "PowerBI")]
        PowerBi,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataSourceList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<DataSource>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
}
impl DataSourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DataSourceProperties {
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub collection: Option<serde_json::Value>,
}
impl DataSourceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Credential type that uses Client ID for authentication."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DelegatedAuthAzureKeyVaultCredential {
    #[serde(flatten)]
    pub credential: Credential,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl DelegatedAuthAzureKeyVaultCredential {
    pub fn new(credential: Credential) -> Self {
        Self {
            credential,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DelegatedAuthCredentialProperties {
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl DelegatedAuthCredentialProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorInfo>,
}
impl ErrorInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorModel {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorModel>,
}
impl ErrorModel {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponseModel {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<serde_json::Value>,
}
impl ErrorResponseModel {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExpandingResourceScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(rename = "resourceTypes", default, skip_serializing_if = "Option::is_none")]
    pub resource_types: Option<expanding_resource_scan_properties::ResourceTypes>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
}
impl ExpandingResourceScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod expanding_resource_scan_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct ResourceTypes {
        #[serde(rename = "None", default, skip_serializing_if = "Option::is_none")]
        pub none: Option<ResourceTypeFilter>,
        #[serde(rename = "AzureSubscription", default, skip_serializing_if = "Option::is_none")]
        pub azure_subscription: Option<ResourceTypeFilter>,
        #[serde(rename = "AzureResourceGroup", default, skip_serializing_if = "Option::is_none")]
        pub azure_resource_group: Option<ResourceTypeFilter>,
        #[serde(rename = "AzureSynapseWorkspace", default, skip_serializing_if = "Option::is_none")]
        pub azure_synapse_workspace: Option<ResourceTypeFilter>,
        #[serde(rename = "AzureSynapse", default, skip_serializing_if = "Option::is_none")]
        pub azure_synapse: Option<ResourceTypeFilter>,
        #[serde(rename = "AdlsGen1", default, skip_serializing_if = "Option::is_none")]
        pub adls_gen1: Option<ResourceTypeFilter>,
        #[serde(rename = "AdlsGen2", default, skip_serializing_if = "Option::is_none")]
        pub adls_gen2: Option<ResourceTypeFilter>,
        #[serde(rename = "AmazonAccount", default, skip_serializing_if = "Option::is_none")]
        pub amazon_account: Option<ResourceTypeFilter>,
        #[serde(rename = "AmazonS3", default, skip_serializing_if = "Option::is_none")]
        pub amazon_s3: Option<ResourceTypeFilter>,
        #[serde(rename = "AmazonSql", default, skip_serializing_if = "Option::is_none")]
        pub amazon_sql: Option<ResourceTypeFilter>,
        #[serde(rename = "AzureCosmosDb", default, skip_serializing_if = "Option::is_none")]
        pub azure_cosmos_db: Option<ResourceTypeFilter>,
        #[serde(rename = "AzureDataExplorer", default, skip_serializing_if = "Option::is_none")]
        pub azure_data_explorer: Option<ResourceTypeFilter>,
        #[serde(rename = "AzureFileService", default, skip_serializing_if = "Option::is_none")]
        pub azure_file_service: Option<ResourceTypeFilter>,
        #[serde(rename = "AzureSqlDatabase", default, skip_serializing_if = "Option::is_none")]
        pub azure_sql_database: Option<ResourceTypeFilter>,
        #[serde(rename = "AmazonPostgreSql", default, skip_serializing_if = "Option::is_none")]
        pub amazon_postgre_sql: Option<ResourceTypeFilter>,
        #[serde(rename = "AzurePostgreSql", default, skip_serializing_if = "Option::is_none")]
        pub azure_postgre_sql: Option<ResourceTypeFilter>,
        #[serde(rename = "SqlServerDatabase", default, skip_serializing_if = "Option::is_none")]
        pub sql_server_database: Option<ResourceTypeFilter>,
        #[serde(rename = "AzureSqlDatabaseManagedInstance", default, skip_serializing_if = "Option::is_none")]
        pub azure_sql_database_managed_instance: Option<ResourceTypeFilter>,
        #[serde(rename = "AzureSqlDataWarehouse", default, skip_serializing_if = "Option::is_none")]
        pub azure_sql_data_warehouse: Option<ResourceTypeFilter>,
        #[serde(rename = "AzureMySql", default, skip_serializing_if = "Option::is_none")]
        pub azure_my_sql: Option<ResourceTypeFilter>,
        #[serde(rename = "AzureStorage", default, skip_serializing_if = "Option::is_none")]
        pub azure_storage: Option<ResourceTypeFilter>,
        #[serde(rename = "Teradata", default, skip_serializing_if = "Option::is_none")]
        pub teradata: Option<ResourceTypeFilter>,
        #[serde(rename = "Oracle", default, skip_serializing_if = "Option::is_none")]
        pub oracle: Option<ResourceTypeFilter>,
        #[serde(rename = "SapS4Hana", default, skip_serializing_if = "Option::is_none")]
        pub sap_s4_hana: Option<ResourceTypeFilter>,
        #[serde(rename = "SapEcc", default, skip_serializing_if = "Option::is_none")]
        pub sap_ecc: Option<ResourceTypeFilter>,
        #[serde(rename = "PowerBI", default, skip_serializing_if = "Option::is_none")]
        pub power_bi: Option<ResourceTypeFilter>,
    }
    impl ResourceTypes {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Filter {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl Filter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct FilterProperties {
    #[serde(rename = "excludeUriPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub exclude_uri_prefixes: Vec<String>,
    #[serde(rename = "includeUriPrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub include_uri_prefixes: Vec<String>,
}
impl FilterProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultSecret {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "secretName", default, skip_serializing_if = "Option::is_none")]
    pub secret_name: Option<String>,
    #[serde(rename = "secretVersion", default, skip_serializing_if = "Option::is_none")]
    pub secret_version: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub store: Option<serde_json::Value>,
}
impl KeyVaultSecret {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultSecretAccountKeyCredentialTypeProperties {
    #[serde(rename = "accountKey", default, skip_serializing_if = "Option::is_none")]
    pub account_key: Option<serde_json::Value>,
}
impl KeyVaultSecretAccountKeyCredentialTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultSecretConsumerKeyCredentialTypeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub user: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<serde_json::Value>,
    #[serde(rename = "consumerKey", default, skip_serializing_if = "Option::is_none")]
    pub consumer_key: Option<String>,
    #[serde(rename = "consumerSecret", default, skip_serializing_if = "Option::is_none")]
    pub consumer_secret: Option<serde_json::Value>,
}
impl KeyVaultSecretConsumerKeyCredentialTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultSecretDelegatedAuthCredentialTypeProperties {
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub user: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<serde_json::Value>,
}
impl KeyVaultSecretDelegatedAuthCredentialTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultSecretManagedIdentityAzureKeyVaultCredentialTypeProperties {
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<String>,
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
}
impl KeyVaultSecretManagedIdentityAzureKeyVaultCredentialTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultSecretServicePrinipalCredentialTypeProperties {
    #[serde(rename = "servicePrincipalId", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_id: Option<String>,
    #[serde(rename = "servicePrincipalKey", default, skip_serializing_if = "Option::is_none")]
    pub service_principal_key: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<String>,
}
impl KeyVaultSecretServicePrinipalCredentialTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultSecretUserPassCredentialTypeProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub user: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<serde_json::Value>,
}
impl KeyVaultSecretUserPassCredentialTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Credential type that uses User assigned managed identities for authentication."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ManagedIdentityAzureKeyVaultCredential {
    #[serde(flatten)]
    pub credential: Credential,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl ManagedIdentityAzureKeyVaultCredential {
    pub fn new(credential: Credential) -> Self {
        Self {
            credential,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ManagedIdentityAzureKeyVaultCredentialProperties {
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl ManagedIdentityAzureKeyVaultCredentialProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MitiScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(rename = "maximumMemoryAllowedInGb", default, skip_serializing_if = "Option::is_none")]
    pub maximum_memory_allowed_in_gb: Option<String>,
    #[serde(rename = "mitiCache", default, skip_serializing_if = "Option::is_none")]
    pub miti_cache: Option<String>,
}
impl MitiScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Notification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<i32>,
}
impl Notification {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OperationResponse {
    #[serde(rename = "scanResultId", default, skip_serializing_if = "Option::is_none")]
    pub scan_result_id: Option<String>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<operation_response::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<serde_json::Value>,
}
impl OperationResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod operation_response {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Accepted,
        InProgress,
        TransientFailure,
        Succeeded,
        Failed,
        Canceled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl OracleDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleOracleCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl OracleOracleCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OracleOracleCredentialScanProperties {
    #[serde(flatten)]
    pub miti_scan_properties: MitiScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<String>,
    #[serde(rename = "driverLocation", default, skip_serializing_if = "Option::is_none")]
    pub driver_location: Option<String>,
}
impl OracleOracleCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleOracleUserPassScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl OracleOracleUserPassScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OracleOracleUserPassScanProperties {
    #[serde(flatten)]
    pub miti_scan_properties: MitiScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<String>,
    #[serde(rename = "driverLocation", default, skip_serializing_if = "Option::is_none")]
    pub driver_location: Option<String>,
}
impl OracleOracleUserPassScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OracleProperties {
    #[serde(flatten)]
    pub data_source_properties: DataSourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub host: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub port: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub service: Option<String>,
}
impl OracleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl OracleScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OracleScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl OracleScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OracleSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl OracleSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PowerBiDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl PowerBiDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PowerBiDelegatedScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl PowerBiDelegatedScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PowerBiDelegatedScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<String>,
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<String>,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(rename = "includePersonalWorkspaces", default, skip_serializing_if = "Option::is_none")]
    pub include_personal_workspaces: Option<bool>,
}
impl PowerBiDelegatedScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PowerBiMsiScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl PowerBiMsiScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PowerBiMsiScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(rename = "includePersonalWorkspaces", default, skip_serializing_if = "Option::is_none")]
    pub include_personal_workspaces: Option<bool>,
}
impl PowerBiMsiScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PowerBiProperties {
    #[serde(flatten)]
    pub data_source_properties: DataSourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tenant: Option<String>,
}
impl PowerBiProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PowerBiScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl PowerBiScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PowerBiScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl PowerBiScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PowerBiSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl PowerBiSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProxyResource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl ProxyResource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecurrenceSchedule {
    #[serde(rename = "additionalProperties", default, skip_serializing_if = "Option::is_none")]
    pub additional_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub minutes: Vec<i32>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub hours: Vec<i32>,
    #[serde(rename = "weekDays", default, skip_serializing_if = "Vec::is_empty")]
    pub week_days: Vec<String>,
    #[serde(rename = "monthDays", default, skip_serializing_if = "Vec::is_empty")]
    pub month_days: Vec<i32>,
    #[serde(rename = "monthlyOccurrences", default, skip_serializing_if = "Vec::is_empty")]
    pub monthly_occurrences: Vec<RecurrenceScheduleOccurrence>,
}
impl RecurrenceSchedule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecurrenceScheduleOccurrence {
    #[serde(rename = "additionalProperties", default, skip_serializing_if = "Option::is_none")]
    pub additional_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub day: Option<recurrence_schedule_occurrence::Day>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub occurrence: Option<i32>,
}
impl RecurrenceScheduleOccurrence {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod recurrence_schedule_occurrence {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Day {
        Sunday,
        Monday,
        Tuesday,
        Wednesday,
        Thursday,
        Friday,
        Saturday,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RegexClassificationRulePattern {
    #[serde(flatten)]
    pub classification_rule_pattern: ClassificationRulePattern,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pattern: Option<String>,
}
impl RegexClassificationRulePattern {
    pub fn new(classification_rule_pattern: ClassificationRulePattern) -> Self {
        Self {
            classification_rule_pattern,
            pattern: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceNameFilter {
    #[serde(rename = "excludePrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub exclude_prefixes: Vec<String>,
    #[serde(rename = "includePrefixes", default, skip_serializing_if = "Vec::is_empty")]
    pub include_prefixes: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub resources: Vec<String>,
}
impl ResourceNameFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceTypeFilter {
    #[serde(rename = "scanRulesetName", default, skip_serializing_if = "Option::is_none")]
    pub scan_ruleset_name: Option<String>,
    #[serde(rename = "scanRulesetType", default, skip_serializing_if = "Option::is_none")]
    pub scan_ruleset_type: Option<resource_type_filter::ScanRulesetType>,
    #[serde(rename = "resourceNameFilter", default, skip_serializing_if = "Option::is_none")]
    pub resource_name_filter: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
}
impl ResourceTypeFilter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod resource_type_filter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScanRulesetType {
        Custom,
        System,
    }
}
#[doc = "Credential type that uses Account ID, External ID and Role ARN for authentication."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RoleArnCredential {
    #[serde(flatten)]
    pub credential: Credential,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl RoleArnCredential {
    pub fn new(credential: Credential) -> Self {
        Self {
            credential,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RoleArnCredentialProperties {
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl RoleArnCredentialProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RoleArnCredentialTypeProperties {
    #[serde(rename = "roleARN", default, skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}
impl RoleArnCredentialTypeProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapEccDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SapEccDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapEccProperties {
    #[serde(flatten)]
    pub data_source_properties: DataSourceProperties,
    #[serde(rename = "applicationServer", default, skip_serializing_if = "Option::is_none")]
    pub application_server: Option<String>,
    #[serde(rename = "systemNumber", default, skip_serializing_if = "Option::is_none")]
    pub system_number: Option<String>,
}
impl SapEccProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapEccSapEccCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SapEccSapEccCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapEccSapEccCredentialScanProperties {
    #[serde(flatten)]
    pub miti_scan_properties: MitiScanProperties,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
    #[serde(rename = "jCoLibraryPath", default, skip_serializing_if = "Option::is_none")]
    pub j_co_library_path: Option<String>,
}
impl SapEccSapEccCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapEccSapEccUserPassScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SapEccSapEccUserPassScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapEccSapEccUserPassScanProperties {
    #[serde(flatten)]
    pub miti_scan_properties: MitiScanProperties,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(rename = "jCoLibraryPath", default, skip_serializing_if = "Option::is_none")]
    pub j_co_library_path: Option<String>,
}
impl SapEccSapEccUserPassScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapEccScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SapEccScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapEccScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl SapEccScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapEccSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SapEccSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapS4HanaDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SapS4HanaDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapS4HanaProperties {
    #[serde(flatten)]
    pub data_source_properties: DataSourceProperties,
    #[serde(rename = "applicationServer", default, skip_serializing_if = "Option::is_none")]
    pub application_server: Option<String>,
    #[serde(rename = "systemNumber", default, skip_serializing_if = "Option::is_none")]
    pub system_number: Option<String>,
}
impl SapS4HanaProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapS4HanaSapS4HanaCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SapS4HanaSapS4HanaCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapS4HanaSapS4HanaCredentialScanProperties {
    #[serde(flatten)]
    pub miti_scan_properties: MitiScanProperties,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
    #[serde(rename = "jCoLibraryPath", default, skip_serializing_if = "Option::is_none")]
    pub j_co_library_path: Option<String>,
}
impl SapS4HanaSapS4HanaCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapS4HanaSapS4HanaUserPassScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SapS4HanaSapS4HanaUserPassScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapS4HanaSapS4HanaUserPassScanProperties {
    #[serde(flatten)]
    pub miti_scan_properties: MitiScanProperties,
    #[serde(rename = "clientId", default, skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(rename = "jCoLibraryPath", default, skip_serializing_if = "Option::is_none")]
    pub j_co_library_path: Option<String>,
}
impl SapS4HanaSapS4HanaUserPassScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapS4HanaScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SapS4HanaScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SapS4HanaScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl SapS4HanaScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SapS4HanaSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SapS4HanaSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Scan {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    pub kind: scan::Kind,
    #[serde(rename = "scanResults", default, skip_serializing_if = "Vec::is_empty")]
    pub scan_results: Vec<ScanResult>,
}
impl Scan {
    pub fn new(kind: scan::Kind) -> Self {
        Self {
            proxy_resource: ProxyResource::default(),
            kind,
            scan_results: Vec::new(),
        }
    }
}
pub mod scan {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        AzureSubscriptionCredential,
        AzureSubscriptionMsi,
        AzureResourceGroupCredential,
        AzureResourceGroupMsi,
        AzureSynapseWorkspaceCredential,
        AzureSynapseWorkspaceMsi,
        AzureSynapseCredential,
        AzureSynapseMsi,
        AdlsGen1Credential,
        AdlsGen1Msi,
        AdlsGen2Credential,
        AdlsGen2Msi,
        AmazonAccountCredential,
        AmazonS3Credential,
        #[serde(rename = "AmazonS3RoleARN")]
        AmazonS3RoleArn,
        AmazonSqlCredential,
        AzureCosmosDbCredential,
        AzureDataExplorerCredential,
        AzureDataExplorerMsi,
        AzureFileServiceCredential,
        AzureSqlDatabaseCredential,
        AzureSqlDatabaseMsi,
        AmazonPostgreSqlCredential,
        #[serde(rename = "AmazonPostgreSqlRoleARN")]
        AmazonPostgreSqlRoleArn,
        AzurePostgreSqlCredential,
        SqlServerDatabaseCredential,
        AzureSqlDatabaseManagedInstanceCredential,
        AzureSqlDatabaseManagedInstanceMsi,
        AzureSqlDataWarehouseCredential,
        AzureSqlDataWarehouseMsi,
        AzureMySqlCredential,
        AzureStorageCredential,
        AzureStorageMsi,
        TeradataTeradataCredential,
        TeradataTeradataUserPass,
        TeradataUserPass,
        OracleOracleCredential,
        OracleOracleUserPass,
        SapS4HanaSapS4HanaCredential,
        SapS4HanaSapS4HanaUserPass,
        SapEccSapEccCredential,
        SapEccSapEccUserPass,
        #[serde(rename = "PowerBIDelegated")]
        PowerBiDelegated,
        #[serde(rename = "PowerBIMsi")]
        PowerBiMsi,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScanDiagnostics {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub notifications: Vec<Notification>,
    #[serde(rename = "exceptionCountMap", default, skip_serializing_if = "Option::is_none")]
    pub exception_count_map: Option<serde_json::Value>,
}
impl ScanDiagnostics {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScanHistoryList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ScanResult>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
}
impl ScanHistoryList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScanList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Scan>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
}
impl ScanList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScanProperties {
    #[serde(rename = "scanRulesetName", default, skip_serializing_if = "Option::is_none")]
    pub scan_ruleset_name: Option<String>,
    #[serde(rename = "scanRulesetType", default, skip_serializing_if = "Option::is_none")]
    pub scan_ruleset_type: Option<scan_properties::ScanRulesetType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub collection: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub workers: Option<i32>,
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
    #[serde(rename = "connectedVia", default, skip_serializing_if = "Option::is_none")]
    pub connected_via: Option<serde_json::Value>,
}
impl ScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod scan_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScanRulesetType {
        Custom,
        System,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScanResult {
    #[serde(rename = "parentId", default, skip_serializing_if = "Option::is_none")]
    pub parent_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "resourceId", default, skip_serializing_if = "Option::is_none")]
    pub resource_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "assetsDiscovered", default, skip_serializing_if = "Option::is_none")]
    pub assets_discovered: Option<i64>,
    #[serde(rename = "assetsClassified", default, skip_serializing_if = "Option::is_none")]
    pub assets_classified: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub diagnostics: Option<serde_json::Value>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "queuedTime", default, skip_serializing_if = "Option::is_none")]
    pub queued_time: Option<String>,
    #[serde(rename = "pipelineStartTime", default, skip_serializing_if = "Option::is_none")]
    pub pipeline_start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "scanRulesetVersion", default, skip_serializing_if = "Option::is_none")]
    pub scan_ruleset_version: Option<i32>,
    #[serde(rename = "scanRulesetType", default, skip_serializing_if = "Option::is_none")]
    pub scan_ruleset_type: Option<scan_result::ScanRulesetType>,
    #[serde(rename = "scanLevelType", default, skip_serializing_if = "Option::is_none")]
    pub scan_level_type: Option<scan_result::ScanLevelType>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<serde_json::Value>,
    #[serde(rename = "runType", default, skip_serializing_if = "Option::is_none")]
    pub run_type: Option<String>,
    #[serde(rename = "dataSourceType", default, skip_serializing_if = "Option::is_none")]
    pub data_source_type: Option<scan_result::DataSourceType>,
}
impl ScanResult {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod scan_result {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScanRulesetType {
        Custom,
        System,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScanLevelType {
        Full,
        Incremental,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DataSourceType {
        None,
        AzureSubscription,
        AzureResourceGroup,
        AzureSynapseWorkspace,
        AzureSynapse,
        AdlsGen1,
        AdlsGen2,
        AmazonAccount,
        AmazonS3,
        AmazonSql,
        AzureCosmosDb,
        AzureDataExplorer,
        AzureFileService,
        AzureSqlDatabase,
        AmazonPostgreSql,
        AzurePostgreSql,
        SqlServerDatabase,
        AzureSqlDatabaseManagedInstance,
        AzureSqlDataWarehouse,
        AzureMySql,
        AzureStorage,
        Teradata,
        Oracle,
        SapS4Hana,
        SapEcc,
        #[serde(rename = "PowerBI")]
        PowerBi,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScanRuleset {
    #[serde(flatten)]
    pub versioned_scan_ruleset: VersionedScanRuleset,
    pub kind: scan_ruleset::Kind,
}
impl ScanRuleset {
    pub fn new(kind: scan_ruleset::Kind) -> Self {
        Self {
            versioned_scan_ruleset: VersionedScanRuleset::default(),
            kind,
        }
    }
}
pub mod scan_ruleset {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        None,
        AzureSubscription,
        AzureResourceGroup,
        AzureSynapseWorkspace,
        AzureSynapse,
        AdlsGen1,
        AdlsGen2,
        AmazonAccount,
        AmazonS3,
        AmazonSql,
        AzureCosmosDb,
        AzureDataExplorer,
        AzureFileService,
        AzureSqlDatabase,
        AmazonPostgreSql,
        AzurePostgreSql,
        SqlServerDatabase,
        AzureSqlDatabaseManagedInstance,
        AzureSqlDataWarehouse,
        AzureMySql,
        AzureStorage,
        Teradata,
        Oracle,
        SapS4Hana,
        SapEcc,
        #[serde(rename = "PowerBI")]
        PowerBi,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScanRulesetList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ScanRuleset>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
}
impl ScanRulesetList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScanRulesetProperties {
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "excludedSystemClassifications", default, skip_serializing_if = "Vec::is_empty")]
    pub excluded_system_classifications: Vec<String>,
    #[serde(rename = "includedCustomClassificationRuleNames", default, skip_serializing_if = "Vec::is_empty")]
    pub included_custom_classification_rule_names: Vec<String>,
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl ScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScanningRule {
    #[serde(rename = "fileExtensions", default, skip_serializing_if = "Vec::is_empty")]
    pub file_extensions: Vec<String>,
    #[serde(rename = "customFileExtensions", default, skip_serializing_if = "Vec::is_empty")]
    pub custom_file_extensions: Vec<CustomFileExtension>,
}
impl ScanningRule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ScanningRuleScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
    #[serde(rename = "scanningRule", default, skip_serializing_if = "Option::is_none")]
    pub scanning_rule: Option<serde_json::Value>,
}
impl ScanningRuleScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Credential type that uses Tenant ID and Service principal ID for authentication."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServicePrincipalAzureKeyVaultCredential {
    #[serde(flatten)]
    pub credential: Credential,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl ServicePrincipalAzureKeyVaultCredential {
    pub fn new(credential: Credential) -> Self {
        Self {
            credential,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServicePrincipalAzureKeyVaultCredentialProperties {
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl ServicePrincipalAzureKeyVaultCredentialProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Credential type that uses Sql for authentication."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlAuthAzureKeyVaultCredential {
    #[serde(flatten)]
    pub credential: Credential,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SqlAuthAzureKeyVaultCredential {
    pub fn new(credential: Credential) -> Self {
        Self {
            credential,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerDatabaseCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SqlServerDatabaseCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlServerDatabaseCredentialScanProperties {
    #[serde(flatten)]
    pub azure_sql_credential_scan_properties: AzureSqlCredentialScanProperties,
}
impl SqlServerDatabaseCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerDatabaseDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SqlServerDatabaseDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlServerDatabaseProperties {
    #[serde(flatten)]
    pub azure_data_source_properties: AzureDataSourceProperties,
    #[serde(rename = "serverEndpoint", default, skip_serializing_if = "Option::is_none")]
    pub server_endpoint: Option<String>,
}
impl SqlServerDatabaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerDatabaseScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SqlServerDatabaseScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SqlServerDatabaseScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl SqlServerDatabaseScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SqlServerDatabaseSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SqlServerDatabaseSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Store {
    #[serde(rename = "referenceName", default, skip_serializing_if = "Option::is_none")]
    pub reference_name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl Store {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SystemClassificationRule {
    #[serde(flatten)]
    pub classification_rule: ClassificationRule,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl SystemClassificationRule {
    pub fn new(classification_rule: ClassificationRule) -> Self {
        Self {
            classification_rule,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemClassificationRuleProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i32>,
    #[serde(rename = "classificationName", default, skip_serializing_if = "Option::is_none")]
    pub classification_name: Option<String>,
    #[serde(rename = "ruleStatus", default, skip_serializing_if = "Option::is_none")]
    pub rule_status: Option<system_classification_rule_properties::RuleStatus>,
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
}
impl SystemClassificationRuleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod system_classification_rule_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RuleStatus {
        Enabled,
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SystemScanRuleset {
    #[serde(flatten)]
    pub versioned_scan_ruleset: VersionedScanRuleset,
    pub kind: system_scan_ruleset::Kind,
}
impl SystemScanRuleset {
    pub fn new(kind: system_scan_ruleset::Kind) -> Self {
        Self {
            versioned_scan_ruleset: VersionedScanRuleset::default(),
            kind,
        }
    }
}
pub mod system_scan_ruleset {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        None,
        AzureSubscription,
        AzureResourceGroup,
        AzureSynapseWorkspace,
        AzureSynapse,
        AdlsGen1,
        AdlsGen2,
        AmazonAccount,
        AmazonS3,
        AmazonSql,
        AzureCosmosDb,
        AzureDataExplorer,
        AzureFileService,
        AzureSqlDatabase,
        AmazonPostgreSql,
        AzurePostgreSql,
        SqlServerDatabase,
        AzureSqlDatabaseManagedInstance,
        AzureSqlDataWarehouse,
        AzureMySql,
        AzureStorage,
        Teradata,
        Oracle,
        SapS4Hana,
        SapEcc,
        #[serde(rename = "PowerBI")]
        PowerBi,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SystemScanRulesetList {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SystemScanRuleset>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
}
impl SystemScanRulesetList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TeradataDataSource {
    #[serde(flatten)]
    pub data_source: DataSource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl TeradataDataSource {
    pub fn new(data_source: DataSource) -> Self {
        Self {
            data_source,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TeradataProperties {
    #[serde(flatten)]
    pub data_source_properties: DataSourceProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub host: Option<String>,
}
impl TeradataProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TeradataScanRuleset {
    #[serde(flatten)]
    pub scan_ruleset: ScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl TeradataScanRuleset {
    pub fn new(scan_ruleset: ScanRuleset) -> Self {
        Self {
            scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TeradataScanRulesetProperties {
    #[serde(flatten)]
    pub scan_ruleset_properties: ScanRulesetProperties,
}
impl TeradataScanRulesetProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TeradataSystemScanRuleset {
    #[serde(flatten)]
    pub system_scan_ruleset: SystemScanRuleset,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl TeradataSystemScanRuleset {
    pub fn new(system_scan_ruleset: SystemScanRuleset) -> Self {
        Self {
            system_scan_ruleset,
            properties: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TeradataTeradataCredentialScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl TeradataTeradataCredentialScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TeradataTeradataCredentialScanProperties {
    #[serde(flatten)]
    pub miti_scan_properties: MitiScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub credential: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<String>,
    #[serde(rename = "driverLocation", default, skip_serializing_if = "Option::is_none")]
    pub driver_location: Option<String>,
}
impl TeradataTeradataCredentialScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TeradataTeradataUserPassScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl TeradataTeradataUserPassScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TeradataTeradataUserPassScanProperties {
    #[serde(flatten)]
    pub miti_scan_properties: MitiScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schema: Option<String>,
    #[serde(rename = "driverLocation", default, skip_serializing_if = "Option::is_none")]
    pub driver_location: Option<String>,
}
impl TeradataTeradataUserPassScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TeradataUserPassScan {
    #[serde(flatten)]
    pub scan: Scan,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl TeradataUserPassScan {
    pub fn new(scan: Scan) -> Self {
        Self { scan, properties: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TeradataUserPassScanProperties {
    #[serde(flatten)]
    pub scan_properties: ScanProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
}
impl TeradataUserPassScanProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Trigger {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl Trigger {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggerProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recurrence: Option<serde_json::Value>,
    #[serde(rename = "recurrenceInterval", default, skip_serializing_if = "Option::is_none")]
    pub recurrence_interval: Option<String>,
    #[serde(rename = "createdAt", default, skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "lastModifiedAt", default, skip_serializing_if = "Option::is_none")]
    pub last_modified_at: Option<String>,
    #[serde(rename = "lastScheduled", default, skip_serializing_if = "Option::is_none")]
    pub last_scheduled: Option<String>,
    #[serde(rename = "scanLevel", default, skip_serializing_if = "Option::is_none")]
    pub scan_level: Option<trigger_properties::ScanLevel>,
    #[serde(rename = "incrementalScanStartTime", default, skip_serializing_if = "Option::is_none")]
    pub incremental_scan_start_time: Option<String>,
}
impl TriggerProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod trigger_properties {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScanLevel {
        Full,
        Incremental,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TriggerRecurrence {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub frequency: Option<trigger_recurrence::Frequency>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub interval: Option<i32>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schedule: Option<serde_json::Value>,
    #[serde(rename = "timeZone", default, skip_serializing_if = "Option::is_none")]
    pub time_zone: Option<String>,
}
impl TriggerRecurrence {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod trigger_recurrence {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Frequency {
        Week,
        Month,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserPassCredentialProperties {
    #[serde(rename = "typeProperties", default, skip_serializing_if = "Option::is_none")]
    pub type_properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}
impl UserPassCredentialProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct VersionedScanRuleset {
    #[serde(flatten)]
    pub proxy_resource: ProxyResource,
    #[serde(rename = "scanRulesetType", default, skip_serializing_if = "Option::is_none")]
    pub scan_ruleset_type: Option<versioned_scan_ruleset::ScanRulesetType>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<versioned_scan_ruleset::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i32>,
}
impl VersionedScanRuleset {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod versioned_scan_ruleset {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ScanRulesetType {
        Custom,
        System,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        Enabled,
        Disabled,
    }
}
