#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AttributeMatcher {
    #[serde(rename = "attributeName", default, skip_serializing_if = "Option::is_none")]
    pub attribute_name: Option<String>,
    #[serde(rename = "attributeValueIncludes", default, skip_serializing_if = "Option::is_none")]
    pub attribute_value_includes: Option<String>,
    #[serde(rename = "attributeValueIncludedIn", default, skip_serializing_if = "Vec::is_empty")]
    pub attribute_value_included_in: Vec<String>,
    #[serde(rename = "attributeValueExcludes", default, skip_serializing_if = "Option::is_none")]
    pub attribute_value_excludes: Option<String>,
    #[serde(rename = "attributeValueExcludedIn", default, skip_serializing_if = "Vec::is_empty")]
    pub attribute_value_excluded_in: Vec<String>,
}
impl AttributeMatcher {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AttributeRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<attribute_rule::Kind>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "dnfCondition", default, skip_serializing_if = "Option::is_none")]
    pub dnf_condition: Option<DnfCondition>,
}
impl AttributeRule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod attribute_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        #[serde(rename = "attributerule")]
        Attributerule,
    }
}
pub type CnfCondition = Vec<Vec<AttributeMatcher>>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CollectionReference {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(rename = "referenceName", default, skip_serializing_if = "Option::is_none")]
    pub reference_name: Option<String>,
}
impl CollectionReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DecisionRule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub kind: Option<decision_rule::Kind>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub effect: Option<decision_rule::Effect>,
    #[serde(rename = "dnfCondition", default, skip_serializing_if = "Option::is_none")]
    pub dnf_condition: Option<DnfCondition>,
}
impl DecisionRule {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod decision_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Kind {
        #[serde(rename = "decisionrule")]
        Decisionrule,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Effect {
        Deny,
        Permit,
    }
}
pub type DnfCondition = Vec<Vec<AttributeMatcher>>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ErrorModel {
    pub code: String,
    pub message: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<ErrorModel>,
}
impl ErrorModel {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            target: None,
            details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ErrorResponseModel {
    pub error: ErrorModel,
}
impl ErrorResponseModel {
    pub fn new(error: ErrorModel) -> Self {
        Self { error }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataPolicy {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MetadataPolicyProperties>,
}
impl MetadataPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetadataPolicyList {
    pub values: Vec<MetadataPolicy>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl MetadataPolicyList {
    pub fn new(values: Vec<MetadataPolicy>) -> Self {
        Self { values, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataPolicyProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "decisionRules", default, skip_serializing_if = "Vec::is_empty")]
    pub decision_rules: Vec<DecisionRule>,
    #[serde(rename = "attributeRules", default, skip_serializing_if = "Vec::is_empty")]
    pub attribute_rules: Vec<AttributeRule>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub collection: Option<CollectionReference>,
    #[serde(rename = "parentCollectionName", default, skip_serializing_if = "Option::is_none")]
    pub parent_collection_name: Option<String>,
}
impl MetadataPolicyProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataRole {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<MetadataRoleProperties>,
}
impl MetadataRole {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetadataRoleList {
    pub values: Vec<MetadataRole>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl MetadataRoleList {
    pub fn new(values: Vec<MetadataRole>) -> Self {
        Self { values, next_link: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MetadataRoleProperties {
    #[serde(rename = "provisioningState", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_state: Option<String>,
    #[serde(rename = "roleType", default, skip_serializing_if = "Option::is_none")]
    pub role_type: Option<String>,
    #[serde(rename = "friendlyName", default, skip_serializing_if = "Option::is_none")]
    pub friendly_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "cnfCondition", default, skip_serializing_if = "Option::is_none")]
    pub cnf_condition: Option<CnfCondition>,
    #[serde(rename = "dnfCondition", default, skip_serializing_if = "Option::is_none")]
    pub dnf_condition: Option<DnfCondition>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}
impl MetadataRoleProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
