#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl ApiError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiFailureResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<ApiError>,
}
impl ApiFailureResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMetricsBaseData {
    pub metric: String,
    pub namespace: String,
    #[serde(rename = "dimNames", default, skip_serializing_if = "Vec::is_empty")]
    pub dim_names: Vec<String>,
    pub series: Vec<AzureTimeSeriesData>,
}
impl AzureMetricsBaseData {
    pub fn new(metric: String, namespace: String, series: Vec<AzureTimeSeriesData>) -> Self {
        Self {
            metric,
            namespace,
            dim_names: Vec::new(),
            series,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMetricsData {
    #[serde(rename = "baseData")]
    pub base_data: AzureMetricsBaseData,
}
impl AzureMetricsData {
    pub fn new(base_data: AzureMetricsBaseData) -> Self {
        Self { base_data }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureMetricsDocument {
    pub time: String,
    pub data: AzureMetricsData,
}
impl AzureMetricsDocument {
    pub fn new(time: String, data: AzureMetricsData) -> Self {
        Self { time, data }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AzureMetricsResult {
    #[serde(rename = "statusCode", default, skip_serializing_if = "Option::is_none")]
    pub status_code: Option<i32>,
    #[serde(rename = "apiFailureResponse", default, skip_serializing_if = "Option::is_none")]
    pub api_failure_response: Option<ApiFailureResponse>,
}
impl AzureMetricsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AzureTimeSeriesData {
    #[serde(rename = "dimValues", default, skip_serializing_if = "Vec::is_empty")]
    pub dim_values: Vec<String>,
    pub min: f64,
    pub max: f64,
    pub sum: f64,
    pub count: i32,
}
impl AzureTimeSeriesData {
    pub fn new(min: f64, max: f64, sum: f64, count: i32) -> Self {
        Self {
            dim_values: Vec::new(),
            min,
            max,
            sum,
            count,
        }
    }
}
