#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Error {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl Error {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorResponse {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<Error>,
}
impl ErrorResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "Represents an ingestion configuration."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IngestionConfiguration {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dimensions: Option<Vector3>,
    #[serde(rename = "boundingBoxCenter", default, skip_serializing_if = "Option::is_none")]
    pub bounding_box_center: Option<Vector3>,
    pub gravity: Vector3,
    #[doc = "Indices of Key Frames."]
    #[serde(rename = "keyFrameIndexes", default, skip_serializing_if = "Vec::is_empty")]
    pub key_frame_indexes: Vec<i32>,
    #[doc = "Ground truth trajectory."]
    #[serde(rename = "gtTrajectory", default, skip_serializing_if = "Vec::is_empty")]
    pub gt_trajectory: Vec<Pose>,
    #[serde(rename = "principalAxis", default, skip_serializing_if = "Option::is_none")]
    pub principal_axis: Option<Quaternion>,
    #[doc = "Scale of transformation of asset units into meter space."]
    pub scale: f32,
    #[serde(rename = "supportingPlane", default, skip_serializing_if = "Option::is_none")]
    pub supporting_plane: Option<Vector4>,
    #[doc = "Test Trajectory."]
    #[serde(rename = "testTrajectory", default, skip_serializing_if = "Vec::is_empty")]
    pub test_trajectory: Vec<Pose>,
}
impl IngestionConfiguration {
    pub fn new(gravity: Vector3, scale: f32) -> Self {
        Self {
            dimensions: None,
            bounding_box_center: None,
            gravity,
            key_frame_indexes: Vec::new(),
            gt_trajectory: Vec::new(),
            principal_axis: None,
            scale,
            supporting_plane: None,
            test_trajectory: Vec::new(),
        }
    }
}
#[doc = "Represents the status of an AOA ingestion job."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IngestionProperties {
    #[doc = "Information about the cause of a ClientError JobStatus."]
    #[serde(rename = "clientErrorDetails", default, skip_serializing_if = "Option::is_none")]
    pub client_error_details: Option<String>,
    #[doc = "Information about the cause of a ServerError JobStatus."]
    #[serde(rename = "serverErrorDetails", default, skip_serializing_if = "Option::is_none")]
    pub server_error_details: Option<String>,
    #[doc = "Identifier for the AOA Ingestion Job."]
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[doc = "The URI for downloading the generated AOA Model"]
    #[serde(rename = "outputModelUri", default, skip_serializing_if = "Option::is_none")]
    pub output_model_uri: Option<String>,
    #[serde(rename = "jobStatus", default, skip_serializing_if = "Option::is_none")]
    pub job_status: Option<JobStatus>,
    #[doc = "The file type of the original 3D asset. Examples include: \"ply\", \"obj\", \"fbx\", \"glb\", \"gltf\", etc."]
    #[serde(rename = "assetFileType", default, skip_serializing_if = "Option::is_none")]
    pub asset_file_type: Option<String>,
    #[doc = "The Uri to the Asset to be ingested by the AOA Ingestion Service. This asset needs to have been uploaded to the service using an endpoint provided from a call to the GetUploadUri API."]
    #[serde(rename = "inputAssetUri", default, skip_serializing_if = "Option::is_none")]
    pub input_asset_uri: Option<String>,
    #[doc = "Identifier for the Account owning the AOA Ingestion Job."]
    #[serde(rename = "accountId", default, skip_serializing_if = "Option::is_none")]
    pub account_id: Option<String>,
    #[doc = "Represents an ingestion configuration."]
    #[serde(rename = "ingestionConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub ingestion_configuration: Option<IngestionConfiguration>,
}
impl IngestionProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum JobStatus {
    NotStarted,
    Running,
    Succeeded,
    Failed,
    Cancelled,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Pose {
    pub rotation: Quaternion,
    pub translation: Vector3,
}
impl Pose {
    pub fn new(rotation: Quaternion, translation: Vector3) -> Self {
        Self { rotation, translation }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Quaternion {
    pub x: f32,
    pub y: f32,
    pub z: f32,
    pub w: f32,
    #[serde(rename = "isIdentity", default, skip_serializing_if = "Option::is_none")]
    pub is_identity: Option<bool>,
}
impl Quaternion {
    pub fn new(x: f32, y: f32, z: f32, w: f32) -> Self {
        Self {
            x,
            y,
            z,
            w,
            is_identity: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UploadLocation {
    #[doc = "The blob upload URI where a model should be uploaded to the service for ingestion."]
    #[serde(rename = "inputAssetUri")]
    pub input_asset_uri: String,
}
impl UploadLocation {
    pub fn new(input_asset_uri: String) -> Self {
        Self { input_asset_uri }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Vector3 {
    pub x: f32,
    pub y: f32,
    pub z: f32,
}
impl Vector3 {
    pub fn new(x: f32, y: f32, z: f32) -> Self {
        Self { x, y, z }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Vector4 {
    pub x: f32,
    pub y: f32,
    pub z: f32,
    pub w: f32,
}
impl Vector4 {
    pub fn new(x: f32, y: f32, z: f32, w: f32) -> Self {
        Self { x, y, z, w }
    }
}
