#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "The properties of the conversion."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Conversion {
    #[doc = "The ID of the conversion supplied when the conversion was created."]
    pub id: String,
    #[doc = "Conversion settings describe the origin of input files and destination of output files."]
    pub settings: ConversionSettings,
    #[doc = "Information about the output of a successful conversion. Only present when the status of the conversion is 'Succeeded'."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub output: Option<conversion::Output>,
    #[doc = "The error object containing details of why the request failed."]
    pub error: Error,
    #[doc = "The status of the conversion. Terminal states are 'Cancelled', 'Failed', and 'Succeeded'."]
    pub status: ConversionStatus,
    #[doc = "The time when the conversion was created. Date and time in ISO 8601 format."]
    #[serde(rename = "creationTime")]
    pub creation_time: String,
}
impl Conversion {
    pub fn new(id: String, settings: ConversionSettings, error: Error, status: ConversionStatus, creation_time: String) -> Self {
        Self {
            id,
            settings,
            output: None,
            error,
            status,
            creation_time,
        }
    }
}
pub mod conversion {
    use super::*;
    #[doc = "Information about the output of a successful conversion. Only present when the status of the conversion is 'Succeeded'."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Output {
        #[doc = "URI of the asset generated by the conversion process."]
        #[serde(rename = "outputAssetUri", default, skip_serializing_if = "Option::is_none")]
        pub output_asset_uri: Option<String>,
    }
    impl Output {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[doc = "Conversion input settings describe the origin of conversion input."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConversionInputSettings {
    #[doc = "The URI of the Azure blob storage container containing the input model."]
    #[serde(rename = "storageContainerUri")]
    pub storage_container_uri: String,
    #[doc = "An Azure blob storage container shared access signature giving read and list access to the storage container. Optional. If not provided, the Azure Remote Rendering account needs to be linked with the storage account containing the blob container. See https://docs.microsoft.com/azure/remote-rendering/how-tos/create-an-account#link-storage-accounts for details. For security purposes this field will never be filled out in responses bodies."]
    #[serde(rename = "storageContainerReadListSas", default, skip_serializing_if = "Option::is_none")]
    pub storage_container_read_list_sas: Option<String>,
    #[doc = "Only Blobs starting with this prefix will be downloaded to perform the conversion. Optional. If not provided, all Blobs from the container will be downloaded."]
    #[serde(rename = "blobPrefix", default, skip_serializing_if = "Option::is_none")]
    pub blob_prefix: Option<String>,
    #[doc = "The relative path starting at blobPrefix (or at the container root if blobPrefix is not provided) to the input model. Must point to a file with a supported file format ending. See https://docs.microsoft.com/azure/remote-rendering/how-tos/conversion/model-conversion for details."]
    #[serde(rename = "relativeInputAssetPath")]
    pub relative_input_asset_path: String,
}
impl ConversionInputSettings {
    pub fn new(storage_container_uri: String, relative_input_asset_path: String) -> Self {
        Self {
            storage_container_uri,
            storage_container_read_list_sas: None,
            blob_prefix: None,
            relative_input_asset_path,
        }
    }
}
#[doc = "List of conversions."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConversionList {
    #[doc = "The list of conversions."]
    pub conversions: Vec<Conversion>,
    #[doc = "If more conversions are available this field will contain a URL where the next batch of conversions can be requested. This URL will need the same authentication as all calls to the Azure Remote Rendering API."]
    #[serde(rename = "@nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl ConversionList {
    pub fn new(conversions: Vec<Conversion>) -> Self {
        Self {
            conversions,
            next_link: None,
        }
    }
}
#[doc = "Conversion output settings describe the destination of conversion output."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConversionOutputSettings {
    #[doc = "The URI of the Azure blob storage container where the result of the conversion should be written to."]
    #[serde(rename = "storageContainerUri")]
    pub storage_container_uri: String,
    #[doc = "An Azure blob storage container shared access signature giving write access to the storage container. Optional. If not provided, the Azure Remote Rendering account needs to be linked with the storage account containing the blob container. See https://docs.microsoft.com/azure/remote-rendering/how-tos/create-an-account#link-storage-accounts for details. For security purposes this field will never be filled out in responses bodies."]
    #[serde(rename = "storageContainerWriteSas", default, skip_serializing_if = "Option::is_none")]
    pub storage_container_write_sas: Option<String>,
    #[doc = "A prefix which gets prepended in front of all files produced by the conversion process. Will be treated as a virtual folder. Optional. If not provided, output files will be stored at the container root."]
    #[serde(rename = "blobPrefix", default, skip_serializing_if = "Option::is_none")]
    pub blob_prefix: Option<String>,
    #[doc = "The file name of the output asset. Must end in '.arrAsset'. Optional. If not provided, file name will the same name as the input asset, with '.arrAsset' extension"]
    #[serde(rename = "outputAssetFilename", default, skip_serializing_if = "Option::is_none")]
    pub output_asset_filename: Option<String>,
}
impl ConversionOutputSettings {
    pub fn new(storage_container_uri: String) -> Self {
        Self {
            storage_container_uri,
            storage_container_write_sas: None,
            blob_prefix: None,
            output_asset_filename: None,
        }
    }
}
#[doc = "Conversion settings describe the origin of input files and destination of output files."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ConversionSettings {
    #[doc = "Conversion input settings describe the origin of conversion input."]
    #[serde(rename = "inputLocation")]
    pub input_location: ConversionInputSettings,
    #[doc = "Conversion output settings describe the destination of conversion output."]
    #[serde(rename = "outputLocation")]
    pub output_location: ConversionOutputSettings,
}
impl ConversionSettings {
    pub fn new(input_location: ConversionInputSettings, output_location: ConversionOutputSettings) -> Self {
        Self {
            input_location,
            output_location,
        }
    }
}
#[doc = "The status of the conversion. Terminal states are 'Cancelled', 'Failed', and 'Succeeded'."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ConversionStatus {
    NotStarted,
    Running,
    Cancelled,
    Failed,
    Succeeded,
}
#[doc = "Request to start a conversion"]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateConversionSettings {
    #[doc = "Conversion settings describe the origin of input files and destination of output files."]
    pub settings: ConversionSettings,
}
impl CreateConversionSettings {
    pub fn new(settings: ConversionSettings) -> Self {
        Self { settings }
    }
}
#[doc = "Settings of the session to be created."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateSessionSettings {
    #[doc = "The time in minutes the session will run after reaching the 'Ready' state. It has to be between 0 and 1440."]
    #[serde(rename = "maxLeaseTimeMinutes")]
    pub max_lease_time_minutes: i64,
    #[doc = "The size of the server used for the rendering session. The size impacts the number of polygons the server can render. Refer to https://docs.microsoft.com/azure/remote-rendering/reference/vm-sizes for details."]
    pub size: SessionSize,
}
impl CreateSessionSettings {
    pub fn new(max_lease_time_minutes: i64, size: SessionSize) -> Self {
        Self {
            max_lease_time_minutes,
            size,
        }
    }
}
#[doc = "The error object containing details of why the request failed."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Error {
    #[doc = "Error code."]
    pub code: String,
    #[doc = "A human-readable representation of the error."]
    pub message: String,
    #[doc = "An array of details about specific errors that led to this reported error."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<Error>,
    #[doc = "The target of the particular error (e.g., the name of the property in error)."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<String>,
    #[doc = "The error object containing details of why the request failed."]
    #[serde(rename = "innerError", default, skip_serializing_if = "Option::is_none")]
    pub inner_error: Box<Option<Error>>,
}
impl Error {
    pub fn new(code: String, message: String) -> Self {
        Self {
            code,
            message,
            details: Vec::new(),
            target: None,
            inner_error: Box::new(None),
        }
    }
}
#[doc = "The error response containing details of why the request failed."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ErrorResponse {
    #[doc = "The error object containing details of why the request failed."]
    pub error: Error,
}
impl ErrorResponse {
    pub fn new(error: Error) -> Self {
        Self { error }
    }
}
#[doc = "The properties of a rendering session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SessionProperties {
    #[doc = "The ID of the session supplied when the session was created."]
    pub id: String,
    #[doc = "The TCP port at which the Azure Remote Rendering Inspector tool is hosted."]
    #[serde(rename = "arrInspectorPort", default, skip_serializing_if = "Option::is_none")]
    pub arr_inspector_port: Option<i64>,
    #[doc = "The TCP port used for the handshake when establishing a connection."]
    #[serde(rename = "handshakePort", default, skip_serializing_if = "Option::is_none")]
    pub handshake_port: Option<i64>,
    #[doc = "Amount of time in minutes the session is or was in the 'Ready' state. Time is rounded down to a full minute."]
    #[serde(rename = "elapsedTimeMinutes", default, skip_serializing_if = "Option::is_none")]
    pub elapsed_time_minutes: Option<i64>,
    #[doc = "The hostname under which the rendering session is reachable."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub hostname: Option<String>,
    #[doc = "The time in minutes the session will run after reaching the 'Ready' state."]
    #[serde(rename = "maxLeaseTimeMinutes", default, skip_serializing_if = "Option::is_none")]
    pub max_lease_time_minutes: Option<i64>,
    #[doc = "The size of the server used for the rendering session. The size impacts the number of polygons the server can render. Refer to https://docs.microsoft.com/azure/remote-rendering/reference/vm-sizes for details."]
    pub size: SessionSize,
    #[doc = "The status of the rendering session. Terminal states are 'Error', 'Expired', and 'Stopped'."]
    pub status: SessionStatus,
    #[doc = "The computational power of the rendering session GPU measured in teraflops."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub teraflops: Option<f32>,
    #[doc = "The error object containing details of why the request failed."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<Error>,
    #[doc = "The time when the rendering session was created. Date and time in ISO 8601 format."]
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
}
impl SessionProperties {
    pub fn new(id: String, size: SessionSize, status: SessionStatus) -> Self {
        Self {
            id,
            arr_inspector_port: None,
            handshake_port: None,
            elapsed_time_minutes: None,
            hostname: None,
            max_lease_time_minutes: None,
            size,
            status,
            teraflops: None,
            error: None,
            creation_time: None,
        }
    }
}
#[doc = "The size of the server used for the rendering session. The size impacts the number of polygons the server can render. Refer to https://docs.microsoft.com/azure/remote-rendering/reference/vm-sizes for details."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SessionSize {
    Standard,
    Premium,
}
#[doc = "The status of the rendering session. Terminal states are 'Error', 'Expired', and 'Stopped'."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SessionStatus {
    Error,
    Expired,
    Starting,
    Ready,
    Stopped,
}
#[doc = "The result of a list sessions request."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SessionsList {
    #[doc = "The list of rendering sessions. Does not include sessions in 'Stopped' state."]
    pub sessions: Vec<SessionProperties>,
    #[doc = "If more rendering sessions are available this field will contain a URL where the next batch of sessions can be requested. This URL will need the same authentication as all calls to the Azure Remote Rendering API."]
    #[serde(rename = "@nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl SessionsList {
    pub fn new(sessions: Vec<SessionProperties>) -> Self {
        Self { sessions, next_link: None }
    }
}
#[doc = "Settings used to update the session."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UpdateSessionSettings {
    #[doc = "Update to the time the session will run after it reached the 'Ready' state. It has to be larger than the current value of maxLeaseTimeMinutes and less than 1440."]
    #[serde(rename = "maxLeaseTimeMinutes")]
    pub max_lease_time_minutes: i64,
}
impl UpdateSessionSettings {
    pub fn new(max_lease_time_minutes: i64) -> Self {
        Self { max_lease_time_minutes }
    }
}
