#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccessPolicy {
    #[serde(rename = "Start", default, skip_serializing_if = "Option::is_none")]
    pub start: Option<String>,
    #[serde(rename = "Expiry", default, skip_serializing_if = "Option::is_none")]
    pub expiry: Option<String>,
    #[serde(rename = "Permission", default, skip_serializing_if = "Option::is_none")]
    pub permission: Option<String>,
}
impl AccessPolicy {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ClearRange {
    #[serde(rename = "Start")]
    pub start: i64,
    #[serde(rename = "End")]
    pub end: i64,
}
impl ClearRange {
    pub fn new(start: i64, end: i64) -> Self {
        Self { start, end }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CorsRule {
    #[serde(rename = "AllowedOrigins")]
    pub allowed_origins: String,
    #[serde(rename = "AllowedMethods")]
    pub allowed_methods: String,
    #[serde(rename = "AllowedHeaders")]
    pub allowed_headers: String,
    #[serde(rename = "ExposedHeaders")]
    pub exposed_headers: String,
    #[serde(rename = "MaxAgeInSeconds")]
    pub max_age_in_seconds: i64,
}
impl CorsRule {
    pub fn new(
        allowed_origins: String,
        allowed_methods: String,
        allowed_headers: String,
        exposed_headers: String,
        max_age_in_seconds: i64,
    ) -> Self {
        Self {
            allowed_origins,
            allowed_methods,
            allowed_headers,
            exposed_headers,
            max_age_in_seconds,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DirectoryItem {
    #[serde(rename = "Name")]
    pub name: String,
    #[serde(rename = "FileId", default, skip_serializing_if = "Option::is_none")]
    pub file_id: Option<String>,
    #[serde(rename = "Properties", default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FileProperty>,
    #[serde(rename = "Attributes", default, skip_serializing_if = "Option::is_none")]
    pub attributes: Option<String>,
    #[serde(rename = "PermissionKey", default, skip_serializing_if = "Option::is_none")]
    pub permission_key: Option<String>,
}
impl DirectoryItem {
    pub fn new(name: String) -> Self {
        Self {
            name,
            file_id: None,
            properties: None,
            attributes: None,
            permission_key: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ErrorCode {
    AccountAlreadyExists,
    AccountBeingCreated,
    AccountIsDisabled,
    AuthenticationFailed,
    AuthorizationFailure,
    ConditionHeadersNotSupported,
    ConditionNotMet,
    EmptyMetadataKey,
    InsufficientAccountPermissions,
    InternalError,
    InvalidAuthenticationInfo,
    InvalidHeaderValue,
    InvalidHttpVerb,
    InvalidInput,
    InvalidMd5,
    InvalidMetadata,
    InvalidQueryParameterValue,
    InvalidRange,
    InvalidResourceName,
    InvalidUri,
    InvalidXmlDocument,
    InvalidXmlNodeValue,
    Md5Mismatch,
    MetadataTooLarge,
    MissingContentLengthHeader,
    MissingRequiredQueryParameter,
    MissingRequiredHeader,
    MissingRequiredXmlNode,
    MultipleConditionHeadersNotSupported,
    OperationTimedOut,
    OutOfRangeInput,
    OutOfRangeQueryParameterValue,
    RequestBodyTooLarge,
    ResourceTypeMismatch,
    RequestUrlFailedToParse,
    ResourceAlreadyExists,
    ResourceNotFound,
    ServerBusy,
    UnsupportedHeader,
    UnsupportedXmlNode,
    UnsupportedQueryParameter,
    UnsupportedHttpVerb,
    CannotDeleteFileOrDirectory,
    ClientCacheFlushDelay,
    DeletePending,
    DirectoryNotEmpty,
    FileLockConflict,
    InvalidFileOrDirectoryPathName,
    ParentNotFound,
    ReadOnlyAttribute,
    ShareAlreadyExists,
    ShareBeingDeleted,
    ShareDisabled,
    ShareNotFound,
    SharingViolation,
    ShareSnapshotInProgress,
    ShareSnapshotCountExceeded,
    ShareSnapshotOperationNotSupported,
    ShareHasSnapshots,
    ContainerQuotaDowngradeNotAllowed,
    #[serde(rename = "AuthorizationSourceIPMismatch")]
    AuthorizationSourceIpMismatch,
    AuthorizationProtocolMismatch,
    AuthorizationPermissionMismatch,
    AuthorizationServiceMismatch,
    AuthorizationResourceTypeMismatch,
    FeatureVersionMismatch,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileItem {
    #[serde(rename = "Name")]
    pub name: String,
    #[serde(rename = "FileId", default, skip_serializing_if = "Option::is_none")]
    pub file_id: Option<String>,
    #[serde(rename = "Properties")]
    pub properties: FileProperty,
    #[serde(rename = "Attributes", default, skip_serializing_if = "Option::is_none")]
    pub attributes: Option<String>,
    #[serde(rename = "PermissionKey", default, skip_serializing_if = "Option::is_none")]
    pub permission_key: Option<String>,
}
impl FileItem {
    pub fn new(name: String, properties: FileProperty) -> Self {
        Self {
            name,
            file_id: None,
            properties,
            attributes: None,
            permission_key: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileProperty {
    #[serde(rename = "Content-Length")]
    pub content_length: i64,
    #[serde(rename = "CreationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[serde(rename = "LastAccessTime", default, skip_serializing_if = "Option::is_none")]
    pub last_access_time: Option<String>,
    #[serde(rename = "LastWriteTime", default, skip_serializing_if = "Option::is_none")]
    pub last_write_time: Option<String>,
    #[serde(rename = "ChangeTime", default, skip_serializing_if = "Option::is_none")]
    pub change_time: Option<String>,
    #[serde(rename = "Last-Modified", default, skip_serializing_if = "Option::is_none")]
    pub last_modified: Option<String>,
    #[serde(rename = "Etag", default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
}
impl FileProperty {
    pub fn new(content_length: i64) -> Self {
        Self {
            content_length,
            creation_time: None,
            last_access_time: None,
            last_write_time: None,
            change_time: None,
            last_modified: None,
            etag: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileRange {
    #[serde(rename = "Start")]
    pub start: i64,
    #[serde(rename = "End")]
    pub end: i64,
}
impl FileRange {
    pub fn new(start: i64, end: i64) -> Self {
        Self { start, end }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FilesAndDirectoriesListSegment {
    #[serde(rename = "DirectoryItems")]
    pub directory_items: Vec<DirectoryItem>,
    #[serde(rename = "FileItems")]
    pub file_items: Vec<FileItem>,
}
impl FilesAndDirectoriesListSegment {
    pub fn new(directory_items: Vec<DirectoryItem>, file_items: Vec<FileItem>) -> Self {
        Self {
            directory_items,
            file_items,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct HandleItem {
    #[serde(rename = "HandleId")]
    pub handle_id: String,
    #[serde(rename = "Path")]
    pub path: String,
    #[serde(rename = "FileId")]
    pub file_id: String,
    #[serde(rename = "ParentId", default, skip_serializing_if = "Option::is_none")]
    pub parent_id: Option<String>,
    #[serde(rename = "SessionId")]
    pub session_id: String,
    #[serde(rename = "ClientIp")]
    pub client_ip: String,
    #[serde(rename = "OpenTime")]
    pub open_time: String,
    #[serde(rename = "LastReconnectTime", default, skip_serializing_if = "Option::is_none")]
    pub last_reconnect_time: Option<String>,
}
impl HandleItem {
    pub fn new(handle_id: String, path: String, file_id: String, session_id: String, client_ip: String, open_time: String) -> Self {
        Self {
            handle_id,
            path,
            file_id,
            parent_id: None,
            session_id,
            client_ip,
            open_time,
            last_reconnect_time: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum LeaseDuration {
    #[serde(rename = "infinite")]
    Infinite,
    #[serde(rename = "fixed")]
    Fixed,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum LeaseState {
    #[serde(rename = "available")]
    Available,
    #[serde(rename = "leased")]
    Leased,
    #[serde(rename = "expired")]
    Expired,
    #[serde(rename = "breaking")]
    Breaking,
    #[serde(rename = "broken")]
    Broken,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum LeaseStatus {
    #[serde(rename = "locked")]
    Locked,
    #[serde(rename = "unlocked")]
    Unlocked,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListFilesAndDirectoriesSegmentResponse {
    #[serde(rename = "ServiceEndpoint")]
    pub service_endpoint: String,
    #[serde(rename = "ShareName")]
    pub share_name: String,
    #[serde(rename = "ShareSnapshot", default, skip_serializing_if = "Option::is_none")]
    pub share_snapshot: Option<String>,
    #[serde(rename = "DirectoryPath")]
    pub directory_path: String,
    #[serde(rename = "Prefix")]
    pub prefix: String,
    #[serde(rename = "Marker", default, skip_serializing_if = "Option::is_none")]
    pub marker: Option<String>,
    #[serde(rename = "MaxResults", default, skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    #[serde(rename = "Segment")]
    pub segment: FilesAndDirectoriesListSegment,
    #[serde(rename = "NextMarker")]
    pub next_marker: String,
    #[serde(rename = "DirectoryId", default, skip_serializing_if = "Option::is_none")]
    pub directory_id: Option<String>,
}
impl ListFilesAndDirectoriesSegmentResponse {
    pub fn new(
        service_endpoint: String,
        share_name: String,
        directory_path: String,
        prefix: String,
        segment: FilesAndDirectoriesListSegment,
        next_marker: String,
    ) -> Self {
        Self {
            service_endpoint,
            share_name,
            share_snapshot: None,
            directory_path,
            prefix,
            marker: None,
            max_results: None,
            segment,
            next_marker,
            directory_id: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListHandlesResponse {
    #[serde(rename = "HandleList", default, skip_serializing_if = "Vec::is_empty")]
    pub handle_list: Vec<HandleItem>,
    #[serde(rename = "NextMarker")]
    pub next_marker: String,
}
impl ListHandlesResponse {
    pub fn new(next_marker: String) -> Self {
        Self {
            handle_list: Vec::new(),
            next_marker,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListSharesResponse {
    #[serde(rename = "ServiceEndpoint")]
    pub service_endpoint: String,
    #[serde(rename = "Prefix", default, skip_serializing_if = "Option::is_none")]
    pub prefix: Option<String>,
    #[serde(rename = "Marker", default, skip_serializing_if = "Option::is_none")]
    pub marker: Option<String>,
    #[serde(rename = "MaxResults", default, skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    #[serde(rename = "ShareItems", default, skip_serializing_if = "Vec::is_empty")]
    pub share_items: Vec<ShareItemInternal>,
    #[serde(rename = "NextMarker")]
    pub next_marker: String,
}
impl ListSharesResponse {
    pub fn new(service_endpoint: String, next_marker: String) -> Self {
        Self {
            service_endpoint,
            prefix: None,
            marker: None,
            max_results: None,
            share_items: Vec::new(),
            next_marker,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Metadata {}
impl Metadata {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Metrics {
    #[serde(rename = "Version")]
    pub version: String,
    #[serde(rename = "Enabled")]
    pub enabled: bool,
    #[serde(rename = "IncludeAPIs", default, skip_serializing_if = "Option::is_none")]
    pub include_ap_is: Option<bool>,
    #[serde(rename = "RetentionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub retention_policy: Option<RetentionPolicy>,
}
impl Metrics {
    pub fn new(version: String, enabled: bool) -> Self {
        Self {
            version,
            enabled,
            include_ap_is: None,
            retention_policy: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RetentionPolicy {
    #[serde(rename = "Enabled")]
    pub enabled: bool,
    #[serde(rename = "Days", default, skip_serializing_if = "Option::is_none")]
    pub days: Option<i64>,
}
impl RetentionPolicy {
    pub fn new(enabled: bool) -> Self {
        Self { enabled, days: None }
    }
}
pub type ShareEnabledProtocols = String;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ShareFileRangeList {
    #[serde(rename = "Ranges", default, skip_serializing_if = "Vec::is_empty")]
    pub ranges: Vec<FileRange>,
    #[serde(rename = "ClearRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub clear_ranges: Vec<ClearRange>,
}
impl ShareFileRangeList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShareItemInternal {
    #[serde(rename = "Name")]
    pub name: String,
    #[serde(rename = "Snapshot", default, skip_serializing_if = "Option::is_none")]
    pub snapshot: Option<String>,
    #[serde(rename = "Deleted", default, skip_serializing_if = "Option::is_none")]
    pub deleted: Option<bool>,
    #[serde(rename = "Version", default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "Properties")]
    pub properties: SharePropertiesInternal,
    #[serde(rename = "Metadata", default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<Metadata>,
}
impl ShareItemInternal {
    pub fn new(name: String, properties: SharePropertiesInternal) -> Self {
        Self {
            name,
            snapshot: None,
            deleted: None,
            version: None,
            properties,
            metadata: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SharePermission {
    pub permission: String,
}
impl SharePermission {
    pub fn new(permission: String) -> Self {
        Self { permission }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SharePropertiesInternal {
    #[serde(rename = "Last-Modified")]
    pub last_modified: String,
    #[serde(rename = "Etag")]
    pub etag: String,
    #[serde(rename = "Quota")]
    pub quota: i64,
    #[serde(rename = "ProvisionedIops", default, skip_serializing_if = "Option::is_none")]
    pub provisioned_iops: Option<i64>,
    #[serde(rename = "ProvisionedIngressMBps", default, skip_serializing_if = "Option::is_none")]
    pub provisioned_ingress_m_bps: Option<i64>,
    #[serde(rename = "ProvisionedEgressMBps", default, skip_serializing_if = "Option::is_none")]
    pub provisioned_egress_m_bps: Option<i64>,
    #[serde(rename = "ProvisionedBandwidthMiBps", default, skip_serializing_if = "Option::is_none")]
    pub provisioned_bandwidth_mi_bps: Option<i64>,
    #[serde(rename = "NextAllowedQuotaDowngradeTime", default, skip_serializing_if = "Option::is_none")]
    pub next_allowed_quota_downgrade_time: Option<String>,
    #[serde(rename = "DeletedTime", default, skip_serializing_if = "Option::is_none")]
    pub deleted_time: Option<String>,
    #[serde(rename = "RemainingRetentionDays", default, skip_serializing_if = "Option::is_none")]
    pub remaining_retention_days: Option<i64>,
    #[serde(rename = "AccessTier", default, skip_serializing_if = "Option::is_none")]
    pub access_tier: Option<String>,
    #[serde(rename = "AccessTierChangeTime", default, skip_serializing_if = "Option::is_none")]
    pub access_tier_change_time: Option<String>,
    #[serde(rename = "AccessTierTransitionState", default, skip_serializing_if = "Option::is_none")]
    pub access_tier_transition_state: Option<String>,
    #[serde(rename = "LeaseStatus", default, skip_serializing_if = "Option::is_none")]
    pub lease_status: Option<LeaseStatus>,
    #[serde(rename = "LeaseState", default, skip_serializing_if = "Option::is_none")]
    pub lease_state: Option<LeaseState>,
    #[serde(rename = "LeaseDuration", default, skip_serializing_if = "Option::is_none")]
    pub lease_duration: Option<LeaseDuration>,
    #[serde(rename = "EnabledProtocols", default, skip_serializing_if = "Option::is_none")]
    pub enabled_protocols: Option<ShareEnabledProtocols>,
    #[serde(rename = "RootSquash", default, skip_serializing_if = "Option::is_none")]
    pub root_squash: Option<ShareRootSquash>,
}
impl SharePropertiesInternal {
    pub fn new(last_modified: String, etag: String, quota: i64) -> Self {
        Self {
            last_modified,
            etag,
            quota,
            provisioned_iops: None,
            provisioned_ingress_m_bps: None,
            provisioned_egress_m_bps: None,
            provisioned_bandwidth_mi_bps: None,
            next_allowed_quota_downgrade_time: None,
            deleted_time: None,
            remaining_retention_days: None,
            access_tier: None,
            access_tier_change_time: None,
            access_tier_transition_state: None,
            lease_status: None,
            lease_state: None,
            lease_duration: None,
            enabled_protocols: None,
            root_squash: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ShareProtocolSettings {
    #[serde(rename = "Smb", default, skip_serializing_if = "Option::is_none")]
    pub smb: Option<ShareSmbSettings>,
}
impl ShareProtocolSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ShareRootSquash {
    NoRootSquash,
    RootSquash,
    AllSquash,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ShareSmbSettings {
    #[serde(rename = "Multichannel", default, skip_serializing_if = "Option::is_none")]
    pub multichannel: Option<SmbMultichannel>,
}
impl ShareSmbSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ShareStats {
    #[serde(rename = "ShareUsageBytes")]
    pub share_usage_bytes: i64,
}
impl ShareStats {
    pub fn new(share_usage_bytes: i64) -> Self {
        Self { share_usage_bytes }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SignedIdentifier {
    #[serde(rename = "Id")]
    pub id: String,
    #[serde(rename = "AccessPolicy", default, skip_serializing_if = "Option::is_none")]
    pub access_policy: Option<AccessPolicy>,
}
impl SignedIdentifier {
    pub fn new(id: String) -> Self {
        Self { id, access_policy: None }
    }
}
pub type SignedIdentifiers = Vec<SignedIdentifier>;
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SmbMultichannel {
    #[serde(rename = "Enabled", default, skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
}
impl SmbMultichannel {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageError {
    #[serde(rename = "Message", default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl StorageError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageServiceProperties {
    #[serde(rename = "HourMetrics", default, skip_serializing_if = "Option::is_none")]
    pub hour_metrics: Option<Metrics>,
    #[serde(rename = "MinuteMetrics", default, skip_serializing_if = "Option::is_none")]
    pub minute_metrics: Option<Metrics>,
    #[serde(rename = "Cors", default, skip_serializing_if = "Vec::is_empty")]
    pub cors: Vec<CorsRule>,
    #[serde(rename = "Protocol", default, skip_serializing_if = "Option::is_none")]
    pub protocol: Option<ShareProtocolSettings>,
}
impl StorageServiceProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
