#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatEventBaseProperties {
    #[serde(rename = "recipientCommunicationIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub recipient_communication_identifier: Option<CommunicationIdentifierModel>,
    #[serde(rename = "transactionId", default, skip_serializing_if = "Option::is_none")]
    pub transaction_id: Option<String>,
    #[serde(rename = "threadId", default, skip_serializing_if = "Option::is_none")]
    pub thread_id: Option<String>,
}
impl AcsChatEventBaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatEventInThreadBaseProperties {
    #[serde(rename = "transactionId", default, skip_serializing_if = "Option::is_none")]
    pub transaction_id: Option<String>,
    #[serde(rename = "threadId", default, skip_serializing_if = "Option::is_none")]
    pub thread_id: Option<String>,
}
impl AcsChatEventInThreadBaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatMessageDeletedEventData {
    #[serde(flatten)]
    pub acs_chat_message_event_base_properties: AcsChatMessageEventBaseProperties,
    #[serde(rename = "deleteTime", default, skip_serializing_if = "Option::is_none")]
    pub delete_time: Option<String>,
}
impl AcsChatMessageDeletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatMessageDeletedInThreadEventData {
    #[serde(flatten)]
    pub acs_chat_message_event_in_thread_base_properties: AcsChatMessageEventInThreadBaseProperties,
    #[serde(rename = "deleteTime", default, skip_serializing_if = "Option::is_none")]
    pub delete_time: Option<String>,
}
impl AcsChatMessageDeletedInThreadEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatMessageEditedEventData {
    #[serde(flatten)]
    pub acs_chat_message_event_base_properties: AcsChatMessageEventBaseProperties,
    #[serde(rename = "messageBody", default, skip_serializing_if = "Option::is_none")]
    pub message_body: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
    #[serde(rename = "editTime", default, skip_serializing_if = "Option::is_none")]
    pub edit_time: Option<String>,
}
impl AcsChatMessageEditedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatMessageEditedInThreadEventData {
    #[serde(flatten)]
    pub acs_chat_message_event_in_thread_base_properties: AcsChatMessageEventInThreadBaseProperties,
    #[serde(rename = "messageBody", default, skip_serializing_if = "Option::is_none")]
    pub message_body: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
    #[serde(rename = "editTime", default, skip_serializing_if = "Option::is_none")]
    pub edit_time: Option<String>,
}
impl AcsChatMessageEditedInThreadEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatMessageEventBaseProperties {
    #[serde(flatten)]
    pub acs_chat_event_base_properties: AcsChatEventBaseProperties,
    #[serde(rename = "messageId", default, skip_serializing_if = "Option::is_none")]
    pub message_id: Option<String>,
    #[serde(rename = "senderCommunicationIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub sender_communication_identifier: Option<CommunicationIdentifierModel>,
    #[serde(rename = "senderDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub sender_display_name: Option<String>,
    #[serde(rename = "composeTime", default, skip_serializing_if = "Option::is_none")]
    pub compose_time: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}
impl AcsChatMessageEventBaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatMessageEventInThreadBaseProperties {
    #[serde(flatten)]
    pub acs_chat_event_in_thread_base_properties: AcsChatEventInThreadBaseProperties,
    #[serde(rename = "messageId", default, skip_serializing_if = "Option::is_none")]
    pub message_id: Option<String>,
    #[serde(rename = "senderCommunicationIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub sender_communication_identifier: Option<CommunicationIdentifierModel>,
    #[serde(rename = "senderDisplayName", default, skip_serializing_if = "Option::is_none")]
    pub sender_display_name: Option<String>,
    #[serde(rename = "composeTime", default, skip_serializing_if = "Option::is_none")]
    pub compose_time: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}
impl AcsChatMessageEventInThreadBaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatMessageReceivedEventData {
    #[serde(flatten)]
    pub acs_chat_message_event_base_properties: AcsChatMessageEventBaseProperties,
    #[serde(rename = "messageBody", default, skip_serializing_if = "Option::is_none")]
    pub message_body: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
}
impl AcsChatMessageReceivedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatMessageReceivedInThreadEventData {
    #[serde(flatten)]
    pub acs_chat_message_event_in_thread_base_properties: AcsChatMessageEventInThreadBaseProperties,
    #[serde(rename = "messageBody", default, skip_serializing_if = "Option::is_none")]
    pub message_body: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
}
impl AcsChatMessageReceivedInThreadEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatParticipantAddedToThreadEventData {
    #[serde(flatten)]
    pub acs_chat_event_in_thread_base_properties: AcsChatEventInThreadBaseProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
    #[serde(rename = "addedByCommunicationIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub added_by_communication_identifier: Option<CommunicationIdentifierModel>,
    #[serde(rename = "participantAdded", default, skip_serializing_if = "Option::is_none")]
    pub participant_added: Option<AcsChatThreadParticipantProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}
impl AcsChatParticipantAddedToThreadEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatParticipantAddedToThreadWithUserEventData {
    #[serde(flatten)]
    pub acs_chat_thread_event_base_properties: AcsChatThreadEventBaseProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
    #[serde(rename = "addedByCommunicationIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub added_by_communication_identifier: Option<CommunicationIdentifierModel>,
    #[serde(rename = "participantAdded", default, skip_serializing_if = "Option::is_none")]
    pub participant_added: Option<AcsChatThreadParticipantProperties>,
}
impl AcsChatParticipantAddedToThreadWithUserEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatParticipantRemovedFromThreadEventData {
    #[serde(flatten)]
    pub acs_chat_event_in_thread_base_properties: AcsChatEventInThreadBaseProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
    #[serde(rename = "removedByCommunicationIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub removed_by_communication_identifier: Option<CommunicationIdentifierModel>,
    #[serde(rename = "participantRemoved", default, skip_serializing_if = "Option::is_none")]
    pub participant_removed: Option<AcsChatThreadParticipantProperties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}
impl AcsChatParticipantRemovedFromThreadEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatParticipantRemovedFromThreadWithUserEventData {
    #[serde(flatten)]
    pub acs_chat_thread_event_base_properties: AcsChatThreadEventBaseProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
    #[serde(rename = "removedByCommunicationIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub removed_by_communication_identifier: Option<CommunicationIdentifierModel>,
    #[serde(rename = "participantRemoved", default, skip_serializing_if = "Option::is_none")]
    pub participant_removed: Option<AcsChatThreadParticipantProperties>,
}
impl AcsChatParticipantRemovedFromThreadWithUserEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatThreadCreatedEventData {
    #[serde(flatten)]
    pub acs_chat_thread_event_in_thread_base_properties: AcsChatThreadEventInThreadBaseProperties,
    #[serde(rename = "createdByCommunicationIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub created_by_communication_identifier: Option<CommunicationIdentifierModel>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub participants: Vec<AcsChatThreadParticipantProperties>,
}
impl AcsChatThreadCreatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatThreadCreatedWithUserEventData {
    #[serde(flatten)]
    pub acs_chat_thread_event_base_properties: AcsChatThreadEventBaseProperties,
    #[serde(rename = "createdByCommunicationIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub created_by_communication_identifier: Option<CommunicationIdentifierModel>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub participants: Vec<AcsChatThreadParticipantProperties>,
}
impl AcsChatThreadCreatedWithUserEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatThreadDeletedEventData {
    #[serde(flatten)]
    pub acs_chat_thread_event_in_thread_base_properties: AcsChatThreadEventInThreadBaseProperties,
    #[serde(rename = "deletedByCommunicationIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub deleted_by_communication_identifier: Option<CommunicationIdentifierModel>,
    #[serde(rename = "deleteTime", default, skip_serializing_if = "Option::is_none")]
    pub delete_time: Option<String>,
}
impl AcsChatThreadDeletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatThreadEventBaseProperties {
    #[serde(flatten)]
    pub acs_chat_event_base_properties: AcsChatEventBaseProperties,
    #[serde(rename = "createTime", default, skip_serializing_if = "Option::is_none")]
    pub create_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}
impl AcsChatThreadEventBaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatThreadEventInThreadBaseProperties {
    #[serde(flatten)]
    pub acs_chat_event_in_thread_base_properties: AcsChatEventInThreadBaseProperties,
    #[serde(rename = "createTime", default, skip_serializing_if = "Option::is_none")]
    pub create_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}
impl AcsChatThreadEventInThreadBaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatThreadParticipantProperties {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "participantCommunicationIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub participant_communication_identifier: Option<CommunicationIdentifierModel>,
}
impl AcsChatThreadParticipantProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatThreadPropertiesUpdatedEventData {
    #[serde(flatten)]
    pub acs_chat_thread_event_in_thread_base_properties: AcsChatThreadEventInThreadBaseProperties,
    #[serde(rename = "editedByCommunicationIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub edited_by_communication_identifier: Option<CommunicationIdentifierModel>,
    #[serde(rename = "editTime", default, skip_serializing_if = "Option::is_none")]
    pub edit_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AcsChatThreadPropertiesUpdatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatThreadPropertiesUpdatedPerUserEventData {
    #[serde(flatten)]
    pub acs_chat_thread_event_base_properties: AcsChatThreadEventBaseProperties,
    #[serde(rename = "editedByCommunicationIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub edited_by_communication_identifier: Option<CommunicationIdentifierModel>,
    #[serde(rename = "editTime", default, skip_serializing_if = "Option::is_none")]
    pub edit_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
}
impl AcsChatThreadPropertiesUpdatedPerUserEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsChatThreadWithUserDeletedEventData {
    #[serde(flatten)]
    pub acs_chat_thread_event_base_properties: AcsChatThreadEventBaseProperties,
    #[serde(rename = "deletedByCommunicationIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub deleted_by_communication_identifier: Option<CommunicationIdentifierModel>,
    #[serde(rename = "deleteTime", default, skip_serializing_if = "Option::is_none")]
    pub delete_time: Option<String>,
}
impl AcsChatThreadWithUserDeletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsRecordingChunkInfoProperties {
    #[serde(rename = "documentId", default, skip_serializing_if = "Option::is_none")]
    pub document_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub index: Option<i64>,
    #[serde(rename = "endReason", default, skip_serializing_if = "Option::is_none")]
    pub end_reason: Option<String>,
    #[serde(rename = "metadataLocation", default, skip_serializing_if = "Option::is_none")]
    pub metadata_location: Option<String>,
    #[serde(rename = "contentLocation", default, skip_serializing_if = "Option::is_none")]
    pub content_location: Option<String>,
    #[serde(rename = "deleteLocation", default, skip_serializing_if = "Option::is_none")]
    pub delete_location: Option<String>,
}
impl AcsRecordingChunkInfoProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsRecordingFileStatusUpdatedEventData {
    #[serde(rename = "recordingStorageInfo", default, skip_serializing_if = "Option::is_none")]
    pub recording_storage_info: Option<AcsRecordingStorageInfoProperties>,
    #[serde(rename = "recordingStartTime", default, skip_serializing_if = "Option::is_none")]
    pub recording_start_time: Option<String>,
    #[serde(rename = "recordingDurationMs", default, skip_serializing_if = "Option::is_none")]
    pub recording_duration_ms: Option<i64>,
    #[serde(rename = "recordingContentType", default, skip_serializing_if = "Option::is_none")]
    pub recording_content_type: Option<acs_recording_file_status_updated_event_data::RecordingContentType>,
    #[serde(rename = "recordingChannelType", default, skip_serializing_if = "Option::is_none")]
    pub recording_channel_type: Option<acs_recording_file_status_updated_event_data::RecordingChannelType>,
    #[serde(rename = "recordingFormatType", default, skip_serializing_if = "Option::is_none")]
    pub recording_format_type: Option<acs_recording_file_status_updated_event_data::RecordingFormatType>,
    #[serde(rename = "sessionEndReason", default, skip_serializing_if = "Option::is_none")]
    pub session_end_reason: Option<String>,
}
impl AcsRecordingFileStatusUpdatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod acs_recording_file_status_updated_event_data {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecordingContentType {
        AudioVideo,
        Audio,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecordingChannelType {
        Mixed,
        Unmixed,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum RecordingFormatType {
        Wav,
        Mp3,
        Mp4,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsRecordingStorageInfoProperties {
    #[serde(rename = "recordingChunks", default, skip_serializing_if = "Vec::is_empty")]
    pub recording_chunks: Vec<AcsRecordingChunkInfoProperties>,
}
impl AcsRecordingStorageInfoProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsSmsDeliveryAttemptProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(rename = "segmentsSucceeded", default, skip_serializing_if = "Option::is_none")]
    pub segments_succeeded: Option<i64>,
    #[serde(rename = "segmentsFailed", default, skip_serializing_if = "Option::is_none")]
    pub segments_failed: Option<i64>,
}
impl AcsSmsDeliveryAttemptProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsSmsDeliveryReportReceivedEventData {
    #[serde(flatten)]
    pub acs_sms_event_base_properties: AcsSmsEventBaseProperties,
    #[serde(rename = "deliveryStatus", default, skip_serializing_if = "Option::is_none")]
    pub delivery_status: Option<String>,
    #[serde(rename = "deliveryStatusDetails", default, skip_serializing_if = "Option::is_none")]
    pub delivery_status_details: Option<String>,
    #[serde(rename = "deliveryAttempts", default, skip_serializing_if = "Vec::is_empty")]
    pub delivery_attempts: Vec<AcsSmsDeliveryAttemptProperties>,
    #[serde(rename = "receivedTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub received_timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
}
impl AcsSmsDeliveryReportReceivedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsSmsEventBaseProperties {
    #[serde(rename = "messageId", default, skip_serializing_if = "Option::is_none")]
    pub message_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub from: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub to: Option<String>,
}
impl AcsSmsEventBaseProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsSmsReceivedEventData {
    #[serde(flatten)]
    pub acs_sms_event_base_properties: AcsSmsEventBaseProperties,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(rename = "receivedTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub received_timestamp: Option<String>,
}
impl AcsSmsReceivedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AcsUserDisconnectedEventData {
    #[serde(rename = "userCommunicationIdentifier", default, skip_serializing_if = "Option::is_none")]
    pub user_communication_identifier: Option<CommunicationIdentifierModel>,
}
impl AcsUserDisconnectedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementApiCreatedEventData {
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
}
impl ApiManagementApiCreatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementApiDeletedEventData {
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
}
impl ApiManagementApiDeletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementApiReleaseCreatedEventData {
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
}
impl ApiManagementApiReleaseCreatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementApiReleaseDeletedEventData {
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
}
impl ApiManagementApiReleaseDeletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementApiReleaseUpdatedEventData {
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
}
impl ApiManagementApiReleaseUpdatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementApiUpdatedEventData {
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
}
impl ApiManagementApiUpdatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementProductCreatedEventData {
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
}
impl ApiManagementProductCreatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementProductDeletedEventData {
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
}
impl ApiManagementProductDeletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementProductUpdatedEventData {
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
}
impl ApiManagementProductUpdatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementSubscriptionCreatedEventData {
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
}
impl ApiManagementSubscriptionCreatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementSubscriptionDeletedEventData {
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
}
impl ApiManagementSubscriptionDeletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementSubscriptionUpdatedEventData {
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
}
impl ApiManagementSubscriptionUpdatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementUserCreatedEventData {
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
}
impl ApiManagementUserCreatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementUserDeletedEventData {
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
}
impl ApiManagementUserDeletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApiManagementUserUpdatedEventData {
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
}
impl ApiManagementUserUpdatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppConfigurationKeyValueDeletedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub label: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "syncToken", default, skip_serializing_if = "Option::is_none")]
    pub sync_token: Option<String>,
}
impl AppConfigurationKeyValueDeletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppConfigurationKeyValueModifiedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub label: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "syncToken", default, skip_serializing_if = "Option::is_none")]
    pub sync_token: Option<String>,
}
impl AppConfigurationKeyValueModifiedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppEventTypeDetail {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<app_event_type_detail::Action>,
}
impl AppEventTypeDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod app_event_type_detail {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Restarted,
        Stopped,
        ChangedAppSettings,
        Started,
        Completed,
        Failed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AppServicePlanEventTypeDetail {
    #[serde(rename = "stampKind", default, skip_serializing_if = "Option::is_none")]
    pub stamp_kind: Option<app_service_plan_event_type_detail::StampKind>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<app_service_plan_event_type_detail::Action>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<AsyncStatus>,
}
impl AppServicePlanEventTypeDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod app_service_plan_event_type_detail {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StampKind {
        Public,
        AseV1,
        AseV2,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Action {
        Updated,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum AsyncStatus {
    Started,
    Completed,
    Failed,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloudEventEvent {
    pub id: String,
    pub source: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub data_base64: Option<String>,
    #[serde(rename = "type")]
    pub type_: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub time: Option<String>,
    pub specversion: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dataschema: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub datacontenttype: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
}
impl CloudEventEvent {
    pub fn new(id: String, source: String, type_: String, specversion: String) -> Self {
        Self {
            id,
            source,
            data: None,
            data_base64: None,
            type_,
            time: None,
            specversion,
            dataschema: None,
            datacontenttype: None,
            subject: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CommunicationCloudEnvironmentModel {
    #[serde(rename = "public")]
    Public,
    #[serde(rename = "dod")]
    Dod,
    #[serde(rename = "gcch")]
    Gcch,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CommunicationIdentifierModel {
    #[serde(rename = "rawId", default, skip_serializing_if = "Option::is_none")]
    pub raw_id: Option<String>,
    #[serde(rename = "communicationUser", default, skip_serializing_if = "Option::is_none")]
    pub communication_user: Option<CommunicationUserIdentifierModel>,
    #[serde(rename = "phoneNumber", default, skip_serializing_if = "Option::is_none")]
    pub phone_number: Option<PhoneNumberIdentifierModel>,
    #[serde(rename = "microsoftTeamsUser", default, skip_serializing_if = "Option::is_none")]
    pub microsoft_teams_user: Option<MicrosoftTeamsUserIdentifierModel>,
}
impl CommunicationIdentifierModel {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CommunicationUserIdentifierModel {
    pub id: String,
}
impl CommunicationUserIdentifierModel {
    pub fn new(id: String) -> Self {
        Self { id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerRegistryArtifactEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<ContainerRegistryArtifactEventTarget>,
    #[serde(rename = "connectedRegistry", default, skip_serializing_if = "Option::is_none")]
    pub connected_registry: Option<ContainerRegistryEventConnectedRegistry>,
}
impl ContainerRegistryArtifactEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerRegistryArtifactEventTarget {
    #[serde(rename = "mediaType", default, skip_serializing_if = "Option::is_none")]
    pub media_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub digest: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub repository: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl ContainerRegistryArtifactEventTarget {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerRegistryChartDeletedEventData {
    #[serde(flatten)]
    pub container_registry_artifact_event_data: ContainerRegistryArtifactEventData,
}
impl ContainerRegistryChartDeletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerRegistryChartPushedEventData {
    #[serde(flatten)]
    pub container_registry_artifact_event_data: ContainerRegistryArtifactEventData,
}
impl ContainerRegistryChartPushedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerRegistryEventActor {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl ContainerRegistryEventActor {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerRegistryEventConnectedRegistry {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
}
impl ContainerRegistryEventConnectedRegistry {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerRegistryEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub target: Option<ContainerRegistryEventTarget>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub request: Option<ContainerRegistryEventRequest>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub actor: Option<ContainerRegistryEventActor>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub source: Option<ContainerRegistryEventSource>,
    #[serde(rename = "connectedRegistry", default, skip_serializing_if = "Option::is_none")]
    pub connected_registry: Option<ContainerRegistryEventConnectedRegistry>,
}
impl ContainerRegistryEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerRegistryEventRequest {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub addr: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub host: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub method: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub useragent: Option<String>,
}
impl ContainerRegistryEventRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerRegistryEventSource {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub addr: Option<String>,
    #[serde(rename = "instanceID", default, skip_serializing_if = "Option::is_none")]
    pub instance_id: Option<String>,
}
impl ContainerRegistryEventSource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerRegistryEventTarget {
    #[serde(rename = "mediaType", default, skip_serializing_if = "Option::is_none")]
    pub media_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub size: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub digest: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub length: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub repository: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tag: Option<String>,
}
impl ContainerRegistryEventTarget {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerRegistryImageDeletedEventData {
    #[serde(flatten)]
    pub container_registry_event_data: ContainerRegistryEventData,
}
impl ContainerRegistryImageDeletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerRegistryImagePushedEventData {
    #[serde(flatten)]
    pub container_registry_event_data: ContainerRegistryEventData,
}
impl ContainerRegistryImagePushedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ContainerServiceNewKubernetesVersionAvailableEventData {
    #[serde(rename = "latestSupportedKubernetesVersion", default, skip_serializing_if = "Option::is_none")]
    pub latest_supported_kubernetes_version: Option<String>,
    #[serde(rename = "latestStableKubernetesVersion", default, skip_serializing_if = "Option::is_none")]
    pub latest_stable_kubernetes_version: Option<String>,
    #[serde(rename = "lowestMinorKubernetesVersion", default, skip_serializing_if = "Option::is_none")]
    pub lowest_minor_kubernetes_version: Option<String>,
    #[serde(rename = "latestPreviewKubernetesVersion", default, skip_serializing_if = "Option::is_none")]
    pub latest_preview_kubernetes_version: Option<String>,
}
impl ContainerServiceNewKubernetesVersionAvailableEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CustomEventEvent {}
impl CustomEventEvent {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeviceConnectionStateEventInfo {
    #[serde(rename = "sequenceNumber", default, skip_serializing_if = "Option::is_none")]
    pub sequence_number: Option<String>,
}
impl DeviceConnectionStateEventInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeviceConnectionStateEventProperties {
    #[serde(rename = "deviceId", default, skip_serializing_if = "Option::is_none")]
    pub device_id: Option<String>,
    #[serde(rename = "moduleId", default, skip_serializing_if = "Option::is_none")]
    pub module_id: Option<String>,
    #[serde(rename = "hubName", default, skip_serializing_if = "Option::is_none")]
    pub hub_name: Option<String>,
    #[serde(rename = "deviceConnectionStateEventInfo", default, skip_serializing_if = "Option::is_none")]
    pub device_connection_state_event_info: Option<DeviceConnectionStateEventInfo>,
}
impl DeviceConnectionStateEventProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeviceLifeCycleEventProperties {
    #[serde(rename = "deviceId", default, skip_serializing_if = "Option::is_none")]
    pub device_id: Option<String>,
    #[serde(rename = "hubName", default, skip_serializing_if = "Option::is_none")]
    pub hub_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub twin: Option<DeviceTwinInfo>,
}
impl DeviceLifeCycleEventProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeviceTelemetryEventProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub body: Option<serde_json::Value>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<serde_json::Value>,
    #[serde(rename = "systemProperties", default, skip_serializing_if = "Option::is_none")]
    pub system_properties: Option<serde_json::Value>,
}
impl DeviceTelemetryEventProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeviceTwinInfo {
    #[serde(rename = "authenticationType", default, skip_serializing_if = "Option::is_none")]
    pub authentication_type: Option<String>,
    #[serde(rename = "cloudToDeviceMessageCount", default, skip_serializing_if = "Option::is_none")]
    pub cloud_to_device_message_count: Option<f64>,
    #[serde(rename = "connectionState", default, skip_serializing_if = "Option::is_none")]
    pub connection_state: Option<String>,
    #[serde(rename = "deviceId", default, skip_serializing_if = "Option::is_none")]
    pub device_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "lastActivityTime", default, skip_serializing_if = "Option::is_none")]
    pub last_activity_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<device_twin_info::Properties>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(rename = "statusUpdateTime", default, skip_serializing_if = "Option::is_none")]
    pub status_update_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<f64>,
    #[serde(rename = "x509Thumbprint", default, skip_serializing_if = "Option::is_none")]
    pub x509_thumbprint: Option<device_twin_info::X509Thumbprint>,
}
impl DeviceTwinInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod device_twin_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Properties {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub desired: Option<DeviceTwinProperties>,
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub reported: Option<DeviceTwinProperties>,
    }
    impl Properties {
        pub fn new() -> Self {
            Self::default()
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct X509Thumbprint {
        #[serde(rename = "primaryThumbprint", default, skip_serializing_if = "Option::is_none")]
        pub primary_thumbprint: Option<String>,
        #[serde(rename = "secondaryThumbprint", default, skip_serializing_if = "Option::is_none")]
        pub secondary_thumbprint: Option<String>,
    }
    impl X509Thumbprint {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeviceTwinMetadata {
    #[serde(rename = "lastUpdated", default, skip_serializing_if = "Option::is_none")]
    pub last_updated: Option<String>,
}
impl DeviceTwinMetadata {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeviceTwinProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<DeviceTwinMetadata>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<f64>,
}
impl DeviceTwinProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EventGridEvent {
    pub id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub topic: Option<String>,
    pub subject: String,
    pub data: serde_json::Value,
    #[serde(rename = "eventType")]
    pub event_type: String,
    #[serde(rename = "eventTime")]
    pub event_time: String,
    #[serde(rename = "metadataVersion", default, skip_serializing_if = "Option::is_none")]
    pub metadata_version: Option<String>,
    #[serde(rename = "dataVersion")]
    pub data_version: String,
}
impl EventGridEvent {
    pub fn new(id: String, subject: String, data: serde_json::Value, event_type: String, event_time: String, data_version: String) -> Self {
        Self {
            id,
            topic: None,
            subject,
            data,
            event_type,
            event_time,
            metadata_version: None,
            data_version,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EventHubCaptureFileCreatedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub fileurl: Option<String>,
    #[serde(rename = "fileType", default, skip_serializing_if = "Option::is_none")]
    pub file_type: Option<String>,
    #[serde(rename = "partitionId", default, skip_serializing_if = "Option::is_none")]
    pub partition_id: Option<String>,
    #[serde(rename = "sizeInBytes", default, skip_serializing_if = "Option::is_none")]
    pub size_in_bytes: Option<i64>,
    #[serde(rename = "eventCount", default, skip_serializing_if = "Option::is_none")]
    pub event_count: Option<i64>,
    #[serde(rename = "firstSequenceNumber", default, skip_serializing_if = "Option::is_none")]
    pub first_sequence_number: Option<i64>,
    #[serde(rename = "lastSequenceNumber", default, skip_serializing_if = "Option::is_none")]
    pub last_sequence_number: Option<i64>,
    #[serde(rename = "firstEnqueueTime", default, skip_serializing_if = "Option::is_none")]
    pub first_enqueue_time: Option<String>,
    #[serde(rename = "lastEnqueueTime", default, skip_serializing_if = "Option::is_none")]
    pub last_enqueue_time: Option<String>,
}
impl EventHubCaptureFileCreatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubDeviceConnectedEventData {
    #[serde(flatten)]
    pub device_connection_state_event_properties: DeviceConnectionStateEventProperties,
}
impl IotHubDeviceConnectedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubDeviceCreatedEventData {
    #[serde(flatten)]
    pub device_life_cycle_event_properties: DeviceLifeCycleEventProperties,
}
impl IotHubDeviceCreatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubDeviceDeletedEventData {
    #[serde(flatten)]
    pub device_life_cycle_event_properties: DeviceLifeCycleEventProperties,
}
impl IotHubDeviceDeletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubDeviceDisconnectedEventData {
    #[serde(flatten)]
    pub device_connection_state_event_properties: DeviceConnectionStateEventProperties,
}
impl IotHubDeviceDisconnectedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct IotHubDeviceTelemetryEventData {
    #[serde(flatten)]
    pub device_telemetry_event_properties: DeviceTelemetryEventProperties,
}
impl IotHubDeviceTelemetryEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultCertificateExpiredEventData {
    #[serde(rename = "Id", default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "VaultName", default, skip_serializing_if = "Option::is_none")]
    pub vault_name: Option<String>,
    #[serde(rename = "ObjectType", default, skip_serializing_if = "Option::is_none")]
    pub object_type: Option<String>,
    #[serde(rename = "ObjectName", default, skip_serializing_if = "Option::is_none")]
    pub object_name: Option<String>,
    #[serde(rename = "Version", default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "NBF", default, skip_serializing_if = "Option::is_none")]
    pub nbf: Option<f64>,
    #[serde(rename = "EXP", default, skip_serializing_if = "Option::is_none")]
    pub exp: Option<f64>,
}
impl KeyVaultCertificateExpiredEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultCertificateNearExpiryEventData {
    #[serde(rename = "Id", default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "VaultName", default, skip_serializing_if = "Option::is_none")]
    pub vault_name: Option<String>,
    #[serde(rename = "ObjectType", default, skip_serializing_if = "Option::is_none")]
    pub object_type: Option<String>,
    #[serde(rename = "ObjectName", default, skip_serializing_if = "Option::is_none")]
    pub object_name: Option<String>,
    #[serde(rename = "Version", default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "NBF", default, skip_serializing_if = "Option::is_none")]
    pub nbf: Option<f64>,
    #[serde(rename = "EXP", default, skip_serializing_if = "Option::is_none")]
    pub exp: Option<f64>,
}
impl KeyVaultCertificateNearExpiryEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultCertificateNewVersionCreatedEventData {
    #[serde(rename = "Id", default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "VaultName", default, skip_serializing_if = "Option::is_none")]
    pub vault_name: Option<String>,
    #[serde(rename = "ObjectType", default, skip_serializing_if = "Option::is_none")]
    pub object_type: Option<String>,
    #[serde(rename = "ObjectName", default, skip_serializing_if = "Option::is_none")]
    pub object_name: Option<String>,
    #[serde(rename = "Version", default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "NBF", default, skip_serializing_if = "Option::is_none")]
    pub nbf: Option<f64>,
    #[serde(rename = "EXP", default, skip_serializing_if = "Option::is_none")]
    pub exp: Option<f64>,
}
impl KeyVaultCertificateNewVersionCreatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultKeyExpiredEventData {
    #[serde(rename = "Id", default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "VaultName", default, skip_serializing_if = "Option::is_none")]
    pub vault_name: Option<String>,
    #[serde(rename = "ObjectType", default, skip_serializing_if = "Option::is_none")]
    pub object_type: Option<String>,
    #[serde(rename = "ObjectName", default, skip_serializing_if = "Option::is_none")]
    pub object_name: Option<String>,
    #[serde(rename = "Version", default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "NBF", default, skip_serializing_if = "Option::is_none")]
    pub nbf: Option<f64>,
    #[serde(rename = "EXP", default, skip_serializing_if = "Option::is_none")]
    pub exp: Option<f64>,
}
impl KeyVaultKeyExpiredEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultKeyNearExpiryEventData {
    #[serde(rename = "Id", default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "VaultName", default, skip_serializing_if = "Option::is_none")]
    pub vault_name: Option<String>,
    #[serde(rename = "ObjectType", default, skip_serializing_if = "Option::is_none")]
    pub object_type: Option<String>,
    #[serde(rename = "ObjectName", default, skip_serializing_if = "Option::is_none")]
    pub object_name: Option<String>,
    #[serde(rename = "Version", default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "NBF", default, skip_serializing_if = "Option::is_none")]
    pub nbf: Option<f64>,
    #[serde(rename = "EXP", default, skip_serializing_if = "Option::is_none")]
    pub exp: Option<f64>,
}
impl KeyVaultKeyNearExpiryEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultKeyNewVersionCreatedEventData {
    #[serde(rename = "Id", default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "VaultName", default, skip_serializing_if = "Option::is_none")]
    pub vault_name: Option<String>,
    #[serde(rename = "ObjectType", default, skip_serializing_if = "Option::is_none")]
    pub object_type: Option<String>,
    #[serde(rename = "ObjectName", default, skip_serializing_if = "Option::is_none")]
    pub object_name: Option<String>,
    #[serde(rename = "Version", default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "NBF", default, skip_serializing_if = "Option::is_none")]
    pub nbf: Option<f64>,
    #[serde(rename = "EXP", default, skip_serializing_if = "Option::is_none")]
    pub exp: Option<f64>,
}
impl KeyVaultKeyNewVersionCreatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultSecretExpiredEventData {
    #[serde(rename = "Id", default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "VaultName", default, skip_serializing_if = "Option::is_none")]
    pub vault_name: Option<String>,
    #[serde(rename = "ObjectType", default, skip_serializing_if = "Option::is_none")]
    pub object_type: Option<String>,
    #[serde(rename = "ObjectName", default, skip_serializing_if = "Option::is_none")]
    pub object_name: Option<String>,
    #[serde(rename = "Version", default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "NBF", default, skip_serializing_if = "Option::is_none")]
    pub nbf: Option<f64>,
    #[serde(rename = "EXP", default, skip_serializing_if = "Option::is_none")]
    pub exp: Option<f64>,
}
impl KeyVaultSecretExpiredEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultSecretNearExpiryEventData {
    #[serde(rename = "Id", default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "VaultName", default, skip_serializing_if = "Option::is_none")]
    pub vault_name: Option<String>,
    #[serde(rename = "ObjectType", default, skip_serializing_if = "Option::is_none")]
    pub object_type: Option<String>,
    #[serde(rename = "ObjectName", default, skip_serializing_if = "Option::is_none")]
    pub object_name: Option<String>,
    #[serde(rename = "Version", default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "NBF", default, skip_serializing_if = "Option::is_none")]
    pub nbf: Option<f64>,
    #[serde(rename = "EXP", default, skip_serializing_if = "Option::is_none")]
    pub exp: Option<f64>,
}
impl KeyVaultSecretNearExpiryEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultSecretNewVersionCreatedEventData {
    #[serde(rename = "Id", default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "VaultName", default, skip_serializing_if = "Option::is_none")]
    pub vault_name: Option<String>,
    #[serde(rename = "ObjectType", default, skip_serializing_if = "Option::is_none")]
    pub object_type: Option<String>,
    #[serde(rename = "ObjectName", default, skip_serializing_if = "Option::is_none")]
    pub object_name: Option<String>,
    #[serde(rename = "Version", default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "NBF", default, skip_serializing_if = "Option::is_none")]
    pub nbf: Option<f64>,
    #[serde(rename = "EXP", default, skip_serializing_if = "Option::is_none")]
    pub exp: Option<f64>,
}
impl KeyVaultSecretNewVersionCreatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct KeyVaultVaultAccessPolicyChangedEventData {
    #[serde(rename = "Id", default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "VaultName", default, skip_serializing_if = "Option::is_none")]
    pub vault_name: Option<String>,
    #[serde(rename = "ObjectType", default, skip_serializing_if = "Option::is_none")]
    pub object_type: Option<String>,
    #[serde(rename = "ObjectName", default, skip_serializing_if = "Option::is_none")]
    pub object_name: Option<String>,
    #[serde(rename = "Version", default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "NBF", default, skip_serializing_if = "Option::is_none")]
    pub nbf: Option<f64>,
    #[serde(rename = "EXP", default, skip_serializing_if = "Option::is_none")]
    pub exp: Option<f64>,
}
impl KeyVaultVaultAccessPolicyChangedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MachineLearningServicesDatasetDriftDetectedEventData {
    #[serde(rename = "dataDriftId", default, skip_serializing_if = "Option::is_none")]
    pub data_drift_id: Option<String>,
    #[serde(rename = "dataDriftName", default, skip_serializing_if = "Option::is_none")]
    pub data_drift_name: Option<String>,
    #[serde(rename = "runId", default, skip_serializing_if = "Option::is_none")]
    pub run_id: Option<String>,
    #[serde(rename = "baseDatasetId", default, skip_serializing_if = "Option::is_none")]
    pub base_dataset_id: Option<String>,
    #[serde(rename = "targetDatasetId", default, skip_serializing_if = "Option::is_none")]
    pub target_dataset_id: Option<String>,
    #[serde(rename = "driftCoefficient", default, skip_serializing_if = "Option::is_none")]
    pub drift_coefficient: Option<f64>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
}
impl MachineLearningServicesDatasetDriftDetectedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MachineLearningServicesModelDeployedEventData {
    #[serde(rename = "serviceName", default, skip_serializing_if = "Option::is_none")]
    pub service_name: Option<String>,
    #[serde(rename = "serviceComputeType", default, skip_serializing_if = "Option::is_none")]
    pub service_compute_type: Option<String>,
    #[serde(rename = "modelIds", default, skip_serializing_if = "Option::is_none")]
    pub model_ids: Option<String>,
    #[serde(rename = "serviceTags", default, skip_serializing_if = "Option::is_none")]
    pub service_tags: Option<serde_json::Value>,
    #[serde(rename = "serviceProperties", default, skip_serializing_if = "Option::is_none")]
    pub service_properties: Option<serde_json::Value>,
}
impl MachineLearningServicesModelDeployedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MachineLearningServicesModelRegisteredEventData {
    #[serde(rename = "modelName", default, skip_serializing_if = "Option::is_none")]
    pub model_name: Option<String>,
    #[serde(rename = "modelVersion", default, skip_serializing_if = "Option::is_none")]
    pub model_version: Option<String>,
    #[serde(rename = "modelTags", default, skip_serializing_if = "Option::is_none")]
    pub model_tags: Option<serde_json::Value>,
    #[serde(rename = "modelProperties", default, skip_serializing_if = "Option::is_none")]
    pub model_properties: Option<serde_json::Value>,
}
impl MachineLearningServicesModelRegisteredEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MachineLearningServicesRunCompletedEventData {
    #[serde(rename = "experimentId", default, skip_serializing_if = "Option::is_none")]
    pub experiment_id: Option<String>,
    #[serde(rename = "experimentName", default, skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<String>,
    #[serde(rename = "runId", default, skip_serializing_if = "Option::is_none")]
    pub run_id: Option<String>,
    #[serde(rename = "runType", default, skip_serializing_if = "Option::is_none")]
    pub run_type: Option<String>,
    #[serde(rename = "runTags", default, skip_serializing_if = "Option::is_none")]
    pub run_tags: Option<serde_json::Value>,
    #[serde(rename = "runProperties", default, skip_serializing_if = "Option::is_none")]
    pub run_properties: Option<serde_json::Value>,
}
impl MachineLearningServicesRunCompletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MachineLearningServicesRunStatusChangedEventData {
    #[serde(rename = "experimentId", default, skip_serializing_if = "Option::is_none")]
    pub experiment_id: Option<String>,
    #[serde(rename = "experimentName", default, skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<String>,
    #[serde(rename = "runId", default, skip_serializing_if = "Option::is_none")]
    pub run_id: Option<String>,
    #[serde(rename = "runType", default, skip_serializing_if = "Option::is_none")]
    pub run_type: Option<String>,
    #[serde(rename = "runTags", default, skip_serializing_if = "Option::is_none")]
    pub run_tags: Option<serde_json::Value>,
    #[serde(rename = "runProperties", default, skip_serializing_if = "Option::is_none")]
    pub run_properties: Option<serde_json::Value>,
    #[serde(rename = "runStatus", default, skip_serializing_if = "Option::is_none")]
    pub run_status: Option<String>,
}
impl MachineLearningServicesRunStatusChangedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MapsGeofenceEnteredEventData {
    #[serde(flatten)]
    pub maps_geofence_event_properties: MapsGeofenceEventProperties,
}
impl MapsGeofenceEnteredEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MapsGeofenceEventProperties {
    #[serde(rename = "expiredGeofenceGeometryId", default, skip_serializing_if = "Vec::is_empty")]
    pub expired_geofence_geometry_id: Vec<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub geometries: Vec<MapsGeofenceGeometry>,
    #[serde(rename = "invalidPeriodGeofenceGeometryId", default, skip_serializing_if = "Vec::is_empty")]
    pub invalid_period_geofence_geometry_id: Vec<String>,
    #[serde(rename = "isEventPublished", default, skip_serializing_if = "Option::is_none")]
    pub is_event_published: Option<bool>,
}
impl MapsGeofenceEventProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MapsGeofenceExitedEventData {
    #[serde(flatten)]
    pub maps_geofence_event_properties: MapsGeofenceEventProperties,
}
impl MapsGeofenceExitedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MapsGeofenceGeometry {
    #[serde(rename = "deviceId", default, skip_serializing_if = "Option::is_none")]
    pub device_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub distance: Option<f64>,
    #[serde(rename = "geometryId", default, skip_serializing_if = "Option::is_none")]
    pub geometry_id: Option<String>,
    #[serde(rename = "nearestLat", default, skip_serializing_if = "Option::is_none")]
    pub nearest_lat: Option<f64>,
    #[serde(rename = "nearestLon", default, skip_serializing_if = "Option::is_none")]
    pub nearest_lon: Option<f64>,
    #[serde(rename = "udId", default, skip_serializing_if = "Option::is_none")]
    pub ud_id: Option<String>,
}
impl MapsGeofenceGeometry {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MapsGeofenceResultEventData {
    #[serde(flatten)]
    pub maps_geofence_event_properties: MapsGeofenceEventProperties,
}
impl MapsGeofenceResultEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobCanceledEventData {
    #[serde(flatten)]
    pub media_job_state_change_event_data: MediaJobStateChangeEventData,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub outputs: Vec<MediaJobOutput>,
}
impl MediaJobCanceledEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobCancelingEventData {
    #[serde(flatten)]
    pub media_job_state_change_event_data: MediaJobStateChangeEventData,
}
impl MediaJobCancelingEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<media_job_error::Code>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub category: Option<media_job_error::Category>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub retry: Option<media_job_error::Retry>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<MediaJobErrorDetail>,
}
impl MediaJobError {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod media_job_error {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Code {
        ServiceError,
        ServiceTransientError,
        DownloadNotAccessible,
        DownloadTransientError,
        UploadNotAccessible,
        UploadTransientError,
        ConfigurationUnsupported,
        ContentMalformed,
        ContentUnsupported,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Category {
        Service,
        Download,
        Upload,
        Configuration,
        Content,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Retry {
        DoNotRetry,
        MayRetry,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobErrorDetail {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}
impl MediaJobErrorDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobErroredEventData {
    #[serde(flatten)]
    pub media_job_state_change_event_data: MediaJobStateChangeEventData,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub outputs: Vec<MediaJobOutput>,
}
impl MediaJobErroredEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobFinishedEventData {
    #[serde(flatten)]
    pub media_job_state_change_event_data: MediaJobStateChangeEventData,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub outputs: Vec<MediaJobOutput>,
}
impl MediaJobFinishedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MediaJobOutput {
    #[serde(rename = "@odata.type", default, skip_serializing_if = "Option::is_none")]
    pub odata_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<MediaJobError>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub label: Option<String>,
    pub progress: i64,
    pub state: media_job_output::State,
}
impl MediaJobOutput {
    pub fn new(progress: i64, state: media_job_output::State) -> Self {
        Self {
            odata_type: None,
            error: None,
            label: None,
            progress,
            state,
        }
    }
}
pub mod media_job_output {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Canceled,
        Canceling,
        Error,
        Finished,
        Processing,
        Queued,
        Scheduled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MediaJobOutputAsset {
    #[serde(flatten)]
    pub media_job_output: MediaJobOutput,
    #[serde(rename = "assetName", default, skip_serializing_if = "Option::is_none")]
    pub asset_name: Option<String>,
}
impl MediaJobOutputAsset {
    pub fn new(media_job_output: MediaJobOutput) -> Self {
        Self {
            media_job_output,
            asset_name: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobOutputCanceledEventData {
    #[serde(flatten)]
    pub media_job_output_state_change_event_data: MediaJobOutputStateChangeEventData,
}
impl MediaJobOutputCanceledEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobOutputCancelingEventData {
    #[serde(flatten)]
    pub media_job_output_state_change_event_data: MediaJobOutputStateChangeEventData,
}
impl MediaJobOutputCancelingEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobOutputErroredEventData {
    #[serde(flatten)]
    pub media_job_output_state_change_event_data: MediaJobOutputStateChangeEventData,
}
impl MediaJobOutputErroredEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobOutputFinishedEventData {
    #[serde(flatten)]
    pub media_job_output_state_change_event_data: MediaJobOutputStateChangeEventData,
}
impl MediaJobOutputFinishedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobOutputProcessingEventData {
    #[serde(flatten)]
    pub media_job_output_state_change_event_data: MediaJobOutputStateChangeEventData,
}
impl MediaJobOutputProcessingEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobOutputProgressEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub label: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub progress: Option<i64>,
    #[serde(rename = "jobCorrelationData", default, skip_serializing_if = "Option::is_none")]
    pub job_correlation_data: Option<serde_json::Value>,
}
impl MediaJobOutputProgressEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobOutputScheduledEventData {
    #[serde(flatten)]
    pub media_job_output_state_change_event_data: MediaJobOutputStateChangeEventData,
}
impl MediaJobOutputScheduledEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobOutputStateChangeEventData {
    #[serde(rename = "previousState", default, skip_serializing_if = "Option::is_none")]
    pub previous_state: Option<media_job_output_state_change_event_data::PreviousState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub output: Option<MediaJobOutput>,
    #[serde(rename = "jobCorrelationData", default, skip_serializing_if = "Option::is_none")]
    pub job_correlation_data: Option<serde_json::Value>,
}
impl MediaJobOutputStateChangeEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod media_job_output_state_change_event_data {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PreviousState {
        Canceled,
        Canceling,
        Error,
        Finished,
        Processing,
        Queued,
        Scheduled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobProcessingEventData {
    #[serde(flatten)]
    pub media_job_state_change_event_data: MediaJobStateChangeEventData,
}
impl MediaJobProcessingEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobScheduledEventData {
    #[serde(flatten)]
    pub media_job_state_change_event_data: MediaJobStateChangeEventData,
}
impl MediaJobScheduledEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaJobStateChangeEventData {
    #[serde(rename = "previousState", default, skip_serializing_if = "Option::is_none")]
    pub previous_state: Option<media_job_state_change_event_data::PreviousState>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<media_job_state_change_event_data::State>,
    #[serde(rename = "correlationData", default, skip_serializing_if = "Option::is_none")]
    pub correlation_data: Option<serde_json::Value>,
}
impl MediaJobStateChangeEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod media_job_state_change_event_data {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PreviousState {
        Canceled,
        Canceling,
        Error,
        Finished,
        Processing,
        Queued,
        Scheduled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        Canceled,
        Canceling,
        Error,
        Finished,
        Processing,
        Queued,
        Scheduled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MediaLiveEventChannelArchiveHeartbeatEventData {
    #[serde(rename = "channelLatencyMs")]
    pub channel_latency_ms: String,
    #[serde(rename = "latencyResultCode")]
    pub latency_result_code: String,
}
impl MediaLiveEventChannelArchiveHeartbeatEventData {
    pub fn new(channel_latency_ms: String, latency_result_code: String) -> Self {
        Self {
            channel_latency_ms,
            latency_result_code,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaLiveEventConnectionRejectedEventData {
    #[serde(rename = "ingestUrl", default, skip_serializing_if = "Option::is_none")]
    pub ingest_url: Option<String>,
    #[serde(rename = "streamId", default, skip_serializing_if = "Option::is_none")]
    pub stream_id: Option<String>,
    #[serde(rename = "encoderIp", default, skip_serializing_if = "Option::is_none")]
    pub encoder_ip: Option<String>,
    #[serde(rename = "encoderPort", default, skip_serializing_if = "Option::is_none")]
    pub encoder_port: Option<String>,
    #[serde(rename = "resultCode", default, skip_serializing_if = "Option::is_none")]
    pub result_code: Option<String>,
}
impl MediaLiveEventConnectionRejectedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaLiveEventEncoderConnectedEventData {
    #[serde(rename = "ingestUrl", default, skip_serializing_if = "Option::is_none")]
    pub ingest_url: Option<String>,
    #[serde(rename = "streamId", default, skip_serializing_if = "Option::is_none")]
    pub stream_id: Option<String>,
    #[serde(rename = "encoderIp", default, skip_serializing_if = "Option::is_none")]
    pub encoder_ip: Option<String>,
    #[serde(rename = "encoderPort", default, skip_serializing_if = "Option::is_none")]
    pub encoder_port: Option<String>,
}
impl MediaLiveEventEncoderConnectedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaLiveEventEncoderDisconnectedEventData {
    #[serde(rename = "ingestUrl", default, skip_serializing_if = "Option::is_none")]
    pub ingest_url: Option<String>,
    #[serde(rename = "streamId", default, skip_serializing_if = "Option::is_none")]
    pub stream_id: Option<String>,
    #[serde(rename = "encoderIp", default, skip_serializing_if = "Option::is_none")]
    pub encoder_ip: Option<String>,
    #[serde(rename = "encoderPort", default, skip_serializing_if = "Option::is_none")]
    pub encoder_port: Option<String>,
    #[serde(rename = "resultCode", default, skip_serializing_if = "Option::is_none")]
    pub result_code: Option<String>,
}
impl MediaLiveEventEncoderDisconnectedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaLiveEventIncomingDataChunkDroppedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(rename = "trackType", default, skip_serializing_if = "Option::is_none")]
    pub track_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub bitrate: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timescale: Option<String>,
    #[serde(rename = "resultCode", default, skip_serializing_if = "Option::is_none")]
    pub result_code: Option<String>,
    #[serde(rename = "trackName", default, skip_serializing_if = "Option::is_none")]
    pub track_name: Option<String>,
}
impl MediaLiveEventIncomingDataChunkDroppedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaLiveEventIncomingStreamReceivedEventData {
    #[serde(rename = "ingestUrl", default, skip_serializing_if = "Option::is_none")]
    pub ingest_url: Option<String>,
    #[serde(rename = "trackType", default, skip_serializing_if = "Option::is_none")]
    pub track_type: Option<String>,
    #[serde(rename = "trackName", default, skip_serializing_if = "Option::is_none")]
    pub track_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub bitrate: Option<i64>,
    #[serde(rename = "encoderIp", default, skip_serializing_if = "Option::is_none")]
    pub encoder_ip: Option<String>,
    #[serde(rename = "encoderPort", default, skip_serializing_if = "Option::is_none")]
    pub encoder_port: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub duration: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timescale: Option<String>,
}
impl MediaLiveEventIncomingStreamReceivedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaLiveEventIncomingStreamsOutOfSyncEventData {
    #[serde(rename = "minLastTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub min_last_timestamp: Option<String>,
    #[serde(rename = "typeOfStreamWithMinLastTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub type_of_stream_with_min_last_timestamp: Option<String>,
    #[serde(rename = "maxLastTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub max_last_timestamp: Option<String>,
    #[serde(rename = "typeOfStreamWithMaxLastTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub type_of_stream_with_max_last_timestamp: Option<String>,
    #[serde(rename = "timescaleOfMinLastTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub timescale_of_min_last_timestamp: Option<String>,
    #[serde(rename = "timescaleOfMaxLastTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub timescale_of_max_last_timestamp: Option<String>,
}
impl MediaLiveEventIncomingStreamsOutOfSyncEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaLiveEventIncomingVideoStreamsOutOfSyncEventData {
    #[serde(rename = "firstTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub first_timestamp: Option<String>,
    #[serde(rename = "firstDuration", default, skip_serializing_if = "Option::is_none")]
    pub first_duration: Option<String>,
    #[serde(rename = "secondTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub second_timestamp: Option<String>,
    #[serde(rename = "secondDuration", default, skip_serializing_if = "Option::is_none")]
    pub second_duration: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timescale: Option<String>,
}
impl MediaLiveEventIncomingVideoStreamsOutOfSyncEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaLiveEventIngestHeartbeatEventData {
    #[serde(rename = "trackType", default, skip_serializing_if = "Option::is_none")]
    pub track_type: Option<String>,
    #[serde(rename = "trackName", default, skip_serializing_if = "Option::is_none")]
    pub track_name: Option<String>,
    #[serde(rename = "transcriptionLanguage", default, skip_serializing_if = "Option::is_none")]
    pub transcription_language: Option<String>,
    #[serde(rename = "transcriptionState", default, skip_serializing_if = "Option::is_none")]
    pub transcription_state: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub bitrate: Option<i64>,
    #[serde(rename = "incomingBitrate", default, skip_serializing_if = "Option::is_none")]
    pub incoming_bitrate: Option<i64>,
    #[serde(rename = "ingestDriftValue", default, skip_serializing_if = "Option::is_none")]
    pub ingest_drift_value: Option<String>,
    #[serde(rename = "lastFragmentArrivalTime", default, skip_serializing_if = "Option::is_none")]
    pub last_fragment_arrival_time: Option<String>,
    #[serde(rename = "lastTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub last_timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timescale: Option<String>,
    #[serde(rename = "overlapCount", default, skip_serializing_if = "Option::is_none")]
    pub overlap_count: Option<i64>,
    #[serde(rename = "discontinuityCount", default, skip_serializing_if = "Option::is_none")]
    pub discontinuity_count: Option<i64>,
    #[serde(rename = "nonincreasingCount", default, skip_serializing_if = "Option::is_none")]
    pub nonincreasing_count: Option<i64>,
    #[serde(rename = "unexpectedBitrate", default, skip_serializing_if = "Option::is_none")]
    pub unexpected_bitrate: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub healthy: Option<bool>,
}
impl MediaLiveEventIngestHeartbeatEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct MediaLiveEventTrackDiscontinuityDetectedEventData {
    #[serde(rename = "trackType", default, skip_serializing_if = "Option::is_none")]
    pub track_type: Option<String>,
    #[serde(rename = "trackName", default, skip_serializing_if = "Option::is_none")]
    pub track_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub bitrate: Option<i64>,
    #[serde(rename = "previousTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub previous_timestamp: Option<String>,
    #[serde(rename = "newTimestamp", default, skip_serializing_if = "Option::is_none")]
    pub new_timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timescale: Option<String>,
    #[serde(rename = "discontinuityGap", default, skip_serializing_if = "Option::is_none")]
    pub discontinuity_gap: Option<String>,
}
impl MediaLiveEventTrackDiscontinuityDetectedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MicrosoftTeamsUserIdentifierModel {
    #[serde(rename = "userId")]
    pub user_id: String,
    #[serde(rename = "isAnonymous", default, skip_serializing_if = "Option::is_none")]
    pub is_anonymous: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub cloud: Option<CommunicationCloudEnvironmentModel>,
}
impl MicrosoftTeamsUserIdentifierModel {
    pub fn new(user_id: String) -> Self {
        Self {
            user_id,
            is_anonymous: None,
            cloud: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PhoneNumberIdentifierModel {
    pub value: String,
}
impl PhoneNumberIdentifierModel {
    pub fn new(value: String) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyInsightsPolicyStateChangedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(rename = "policyAssignmentId", default, skip_serializing_if = "Option::is_none")]
    pub policy_assignment_id: Option<String>,
    #[serde(rename = "policyDefinitionId", default, skip_serializing_if = "Option::is_none")]
    pub policy_definition_id: Option<String>,
    #[serde(rename = "policyDefinitionReferenceId", default, skip_serializing_if = "Option::is_none")]
    pub policy_definition_reference_id: Option<String>,
    #[serde(rename = "complianceState", default, skip_serializing_if = "Option::is_none")]
    pub compliance_state: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "complianceReasonCode", default, skip_serializing_if = "Option::is_none")]
    pub compliance_reason_code: Option<String>,
}
impl PolicyInsightsPolicyStateChangedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyInsightsPolicyStateCreatedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(rename = "policyAssignmentId", default, skip_serializing_if = "Option::is_none")]
    pub policy_assignment_id: Option<String>,
    #[serde(rename = "policyDefinitionId", default, skip_serializing_if = "Option::is_none")]
    pub policy_definition_id: Option<String>,
    #[serde(rename = "policyDefinitionReferenceId", default, skip_serializing_if = "Option::is_none")]
    pub policy_definition_reference_id: Option<String>,
    #[serde(rename = "complianceState", default, skip_serializing_if = "Option::is_none")]
    pub compliance_state: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "complianceReasonCode", default, skip_serializing_if = "Option::is_none")]
    pub compliance_reason_code: Option<String>,
}
impl PolicyInsightsPolicyStateCreatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PolicyInsightsPolicyStateDeletedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(rename = "policyAssignmentId", default, skip_serializing_if = "Option::is_none")]
    pub policy_assignment_id: Option<String>,
    #[serde(rename = "policyDefinitionId", default, skip_serializing_if = "Option::is_none")]
    pub policy_definition_id: Option<String>,
    #[serde(rename = "policyDefinitionReferenceId", default, skip_serializing_if = "Option::is_none")]
    pub policy_definition_reference_id: Option<String>,
    #[serde(rename = "complianceState", default, skip_serializing_if = "Option::is_none")]
    pub compliance_state: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "complianceReasonCode", default, skip_serializing_if = "Option::is_none")]
    pub compliance_reason_code: Option<String>,
}
impl PolicyInsightsPolicyStateDeletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RedisExportRdbCompletedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl RedisExportRdbCompletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RedisImportRdbCompletedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl RedisImportRdbCompletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RedisPatchingCompletedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl RedisPatchingCompletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RedisScalingCompletedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}
impl RedisScalingCompletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceActionCancelData {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "resourceProvider", default, skip_serializing_if = "Option::is_none")]
    pub resource_provider: Option<String>,
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
    #[serde(rename = "operationName", default, skip_serializing_if = "Option::is_none")]
    pub operation_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authorization: Option<ResourceAuthorization>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub claims: Option<serde_json::Value>,
    #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_id: Option<String>,
    #[serde(rename = "httpRequest", default, skip_serializing_if = "Option::is_none")]
    pub http_request: Option<ResourceHttpRequest>,
}
impl ResourceActionCancelData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceActionFailureData {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "resourceProvider", default, skip_serializing_if = "Option::is_none")]
    pub resource_provider: Option<String>,
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
    #[serde(rename = "operationName", default, skip_serializing_if = "Option::is_none")]
    pub operation_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authorization: Option<ResourceAuthorization>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub claims: Option<serde_json::Value>,
    #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_id: Option<String>,
    #[serde(rename = "httpRequest", default, skip_serializing_if = "Option::is_none")]
    pub http_request: Option<ResourceHttpRequest>,
}
impl ResourceActionFailureData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceActionSuccessData {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "resourceProvider", default, skip_serializing_if = "Option::is_none")]
    pub resource_provider: Option<String>,
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
    #[serde(rename = "operationName", default, skip_serializing_if = "Option::is_none")]
    pub operation_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authorization: Option<ResourceAuthorization>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub claims: Option<serde_json::Value>,
    #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_id: Option<String>,
    #[serde(rename = "httpRequest", default, skip_serializing_if = "Option::is_none")]
    pub http_request: Option<ResourceHttpRequest>,
}
impl ResourceActionSuccessData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceAuthorization {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub action: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub evidence: Option<serde_json::Value>,
}
impl ResourceAuthorization {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceDeleteCancelData {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "resourceProvider", default, skip_serializing_if = "Option::is_none")]
    pub resource_provider: Option<String>,
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
    #[serde(rename = "operationName", default, skip_serializing_if = "Option::is_none")]
    pub operation_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authorization: Option<ResourceAuthorization>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub claims: Option<serde_json::Value>,
    #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_id: Option<String>,
    #[serde(rename = "httpRequest", default, skip_serializing_if = "Option::is_none")]
    pub http_request: Option<ResourceHttpRequest>,
}
impl ResourceDeleteCancelData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceDeleteFailureData {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "resourceProvider", default, skip_serializing_if = "Option::is_none")]
    pub resource_provider: Option<String>,
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
    #[serde(rename = "operationName", default, skip_serializing_if = "Option::is_none")]
    pub operation_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authorization: Option<ResourceAuthorization>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub claims: Option<serde_json::Value>,
    #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_id: Option<String>,
    #[serde(rename = "httpRequest", default, skip_serializing_if = "Option::is_none")]
    pub http_request: Option<ResourceHttpRequest>,
}
impl ResourceDeleteFailureData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceDeleteSuccessData {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "resourceProvider", default, skip_serializing_if = "Option::is_none")]
    pub resource_provider: Option<String>,
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
    #[serde(rename = "operationName", default, skip_serializing_if = "Option::is_none")]
    pub operation_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authorization: Option<ResourceAuthorization>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub claims: Option<serde_json::Value>,
    #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_id: Option<String>,
    #[serde(rename = "httpRequest", default, skip_serializing_if = "Option::is_none")]
    pub http_request: Option<ResourceHttpRequest>,
}
impl ResourceDeleteSuccessData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceHttpRequest {
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "clientIpAddress", default, skip_serializing_if = "Option::is_none")]
    pub client_ip_address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub method: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}
impl ResourceHttpRequest {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceWriteCancelData {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "resourceProvider", default, skip_serializing_if = "Option::is_none")]
    pub resource_provider: Option<String>,
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
    #[serde(rename = "operationName", default, skip_serializing_if = "Option::is_none")]
    pub operation_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authorization: Option<ResourceAuthorization>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub claims: Option<serde_json::Value>,
    #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_id: Option<String>,
    #[serde(rename = "httpRequest", default, skip_serializing_if = "Option::is_none")]
    pub http_request: Option<ResourceHttpRequest>,
}
impl ResourceWriteCancelData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceWriteFailureData {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "resourceProvider", default, skip_serializing_if = "Option::is_none")]
    pub resource_provider: Option<String>,
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
    #[serde(rename = "operationName", default, skip_serializing_if = "Option::is_none")]
    pub operation_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authorization: Option<ResourceAuthorization>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub claims: Option<serde_json::Value>,
    #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_id: Option<String>,
    #[serde(rename = "httpRequest", default, skip_serializing_if = "Option::is_none")]
    pub http_request: Option<ResourceHttpRequest>,
}
impl ResourceWriteFailureData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResourceWriteSuccessData {
    #[serde(rename = "tenantId", default, skip_serializing_if = "Option::is_none")]
    pub tenant_id: Option<String>,
    #[serde(rename = "subscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub subscription_id: Option<String>,
    #[serde(rename = "resourceGroup", default, skip_serializing_if = "Option::is_none")]
    pub resource_group: Option<String>,
    #[serde(rename = "resourceProvider", default, skip_serializing_if = "Option::is_none")]
    pub resource_provider: Option<String>,
    #[serde(rename = "resourceUri", default, skip_serializing_if = "Option::is_none")]
    pub resource_uri: Option<String>,
    #[serde(rename = "operationName", default, skip_serializing_if = "Option::is_none")]
    pub operation_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub authorization: Option<ResourceAuthorization>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub claims: Option<serde_json::Value>,
    #[serde(rename = "correlationId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_id: Option<String>,
    #[serde(rename = "httpRequest", default, skip_serializing_if = "Option::is_none")]
    pub http_request: Option<ResourceHttpRequest>,
}
impl ResourceWriteSuccessData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceBusActiveMessagesAvailablePeriodicNotificationsEventData {
    #[serde(rename = "namespaceName", default, skip_serializing_if = "Option::is_none")]
    pub namespace_name: Option<String>,
    #[serde(rename = "requestUri", default, skip_serializing_if = "Option::is_none")]
    pub request_uri: Option<String>,
    #[serde(rename = "entityType", default, skip_serializing_if = "Option::is_none")]
    pub entity_type: Option<String>,
    #[serde(rename = "queueName", default, skip_serializing_if = "Option::is_none")]
    pub queue_name: Option<String>,
    #[serde(rename = "topicName", default, skip_serializing_if = "Option::is_none")]
    pub topic_name: Option<String>,
    #[serde(rename = "subscriptionName", default, skip_serializing_if = "Option::is_none")]
    pub subscription_name: Option<String>,
}
impl ServiceBusActiveMessagesAvailablePeriodicNotificationsEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceBusActiveMessagesAvailableWithNoListenersEventData {
    #[serde(rename = "namespaceName", default, skip_serializing_if = "Option::is_none")]
    pub namespace_name: Option<String>,
    #[serde(rename = "requestUri", default, skip_serializing_if = "Option::is_none")]
    pub request_uri: Option<String>,
    #[serde(rename = "entityType", default, skip_serializing_if = "Option::is_none")]
    pub entity_type: Option<String>,
    #[serde(rename = "queueName", default, skip_serializing_if = "Option::is_none")]
    pub queue_name: Option<String>,
    #[serde(rename = "topicName", default, skip_serializing_if = "Option::is_none")]
    pub topic_name: Option<String>,
    #[serde(rename = "subscriptionName", default, skip_serializing_if = "Option::is_none")]
    pub subscription_name: Option<String>,
}
impl ServiceBusActiveMessagesAvailableWithNoListenersEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceBusDeadletterMessagesAvailablePeriodicNotificationsEventData {
    #[serde(rename = "namespaceName", default, skip_serializing_if = "Option::is_none")]
    pub namespace_name: Option<String>,
    #[serde(rename = "requestUri", default, skip_serializing_if = "Option::is_none")]
    pub request_uri: Option<String>,
    #[serde(rename = "entityType", default, skip_serializing_if = "Option::is_none")]
    pub entity_type: Option<String>,
    #[serde(rename = "queueName", default, skip_serializing_if = "Option::is_none")]
    pub queue_name: Option<String>,
    #[serde(rename = "topicName", default, skip_serializing_if = "Option::is_none")]
    pub topic_name: Option<String>,
    #[serde(rename = "subscriptionName", default, skip_serializing_if = "Option::is_none")]
    pub subscription_name: Option<String>,
}
impl ServiceBusDeadletterMessagesAvailablePeriodicNotificationsEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ServiceBusDeadletterMessagesAvailableWithNoListenersEventData {
    #[serde(rename = "namespaceName", default, skip_serializing_if = "Option::is_none")]
    pub namespace_name: Option<String>,
    #[serde(rename = "requestUri", default, skip_serializing_if = "Option::is_none")]
    pub request_uri: Option<String>,
    #[serde(rename = "entityType", default, skip_serializing_if = "Option::is_none")]
    pub entity_type: Option<String>,
    #[serde(rename = "queueName", default, skip_serializing_if = "Option::is_none")]
    pub queue_name: Option<String>,
    #[serde(rename = "topicName", default, skip_serializing_if = "Option::is_none")]
    pub topic_name: Option<String>,
    #[serde(rename = "subscriptionName", default, skip_serializing_if = "Option::is_none")]
    pub subscription_name: Option<String>,
}
impl ServiceBusDeadletterMessagesAvailableWithNoListenersEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SignalRServiceClientConnectionConnectedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(rename = "hubName", default, skip_serializing_if = "Option::is_none")]
    pub hub_name: Option<String>,
    #[serde(rename = "connectionId", default, skip_serializing_if = "Option::is_none")]
    pub connection_id: Option<String>,
    #[serde(rename = "userId", default, skip_serializing_if = "Option::is_none")]
    pub user_id: Option<String>,
}
impl SignalRServiceClientConnectionConnectedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SignalRServiceClientConnectionDisconnectedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<String>,
    #[serde(rename = "hubName", default, skip_serializing_if = "Option::is_none")]
    pub hub_name: Option<String>,
    #[serde(rename = "connectionId", default, skip_serializing_if = "Option::is_none")]
    pub connection_id: Option<String>,
    #[serde(rename = "userId", default, skip_serializing_if = "Option::is_none")]
    pub user_id: Option<String>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
}
impl SignalRServiceClientConnectionDisconnectedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageAsyncOperationInitiatedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub api: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(rename = "contentType", default, skip_serializing_if = "Option::is_none")]
    pub content_type: Option<String>,
    #[serde(rename = "contentLength", default, skip_serializing_if = "Option::is_none")]
    pub content_length: Option<i64>,
    #[serde(rename = "blobType", default, skip_serializing_if = "Option::is_none")]
    pub blob_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sequencer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<String>,
    #[serde(rename = "storageDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub storage_diagnostics: Option<serde_json::Value>,
}
impl StorageAsyncOperationInitiatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageBlobCreatedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub api: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[serde(rename = "contentType", default, skip_serializing_if = "Option::is_none")]
    pub content_type: Option<String>,
    #[serde(rename = "contentLength", default, skip_serializing_if = "Option::is_none")]
    pub content_length: Option<i64>,
    #[serde(rename = "contentOffset", default, skip_serializing_if = "Option::is_none")]
    pub content_offset: Option<i64>,
    #[serde(rename = "blobType", default, skip_serializing_if = "Option::is_none")]
    pub blob_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sequencer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<String>,
    #[serde(rename = "storageDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub storage_diagnostics: Option<serde_json::Value>,
}
impl StorageBlobCreatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageBlobDeletedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub api: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(rename = "contentType", default, skip_serializing_if = "Option::is_none")]
    pub content_type: Option<String>,
    #[serde(rename = "blobType", default, skip_serializing_if = "Option::is_none")]
    pub blob_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sequencer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<String>,
    #[serde(rename = "storageDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub storage_diagnostics: Option<serde_json::Value>,
}
impl StorageBlobDeletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageBlobInventoryPolicyCompletedEventData {
    #[serde(rename = "scheduleDateTime", default, skip_serializing_if = "Option::is_none")]
    pub schedule_date_time: Option<String>,
    #[serde(rename = "accountName", default, skip_serializing_if = "Option::is_none")]
    pub account_name: Option<String>,
    #[serde(rename = "ruleName", default, skip_serializing_if = "Option::is_none")]
    pub rule_name: Option<String>,
    #[serde(rename = "policyRunStatus", default, skip_serializing_if = "Option::is_none")]
    pub policy_run_status: Option<String>,
    #[serde(rename = "policyRunStatusMessage", default, skip_serializing_if = "Option::is_none")]
    pub policy_run_status_message: Option<String>,
    #[serde(rename = "policyRunId", default, skip_serializing_if = "Option::is_none")]
    pub policy_run_id: Option<String>,
    #[serde(rename = "manifestBlobUrl", default, skip_serializing_if = "Option::is_none")]
    pub manifest_blob_url: Option<String>,
}
impl StorageBlobInventoryPolicyCompletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageBlobRenamedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub api: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(rename = "sourceUrl", default, skip_serializing_if = "Option::is_none")]
    pub source_url: Option<String>,
    #[serde(rename = "destinationUrl", default, skip_serializing_if = "Option::is_none")]
    pub destination_url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sequencer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<String>,
    #[serde(rename = "storageDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub storage_diagnostics: Option<serde_json::Value>,
}
impl StorageBlobRenamedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageBlobTierChangedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub api: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(rename = "contentType", default, skip_serializing_if = "Option::is_none")]
    pub content_type: Option<String>,
    #[serde(rename = "contentLength", default, skip_serializing_if = "Option::is_none")]
    pub content_length: Option<i64>,
    #[serde(rename = "blobType", default, skip_serializing_if = "Option::is_none")]
    pub blob_type: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sequencer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<String>,
    #[serde(rename = "storageDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub storage_diagnostics: Option<serde_json::Value>,
}
impl StorageBlobTierChangedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageDirectoryCreatedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub api: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sequencer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<String>,
    #[serde(rename = "storageDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub storage_diagnostics: Option<serde_json::Value>,
}
impl StorageDirectoryCreatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageDirectoryDeletedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub api: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub recursive: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sequencer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<String>,
    #[serde(rename = "storageDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub storage_diagnostics: Option<serde_json::Value>,
}
impl StorageDirectoryDeletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageDirectoryRenamedEventData {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub api: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(rename = "sourceUrl", default, skip_serializing_if = "Option::is_none")]
    pub source_url: Option<String>,
    #[serde(rename = "destinationUrl", default, skip_serializing_if = "Option::is_none")]
    pub destination_url: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sequencer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<String>,
    #[serde(rename = "storageDiagnostics", default, skip_serializing_if = "Option::is_none")]
    pub storage_diagnostics: Option<serde_json::Value>,
}
impl StorageDirectoryRenamedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageLifecyclePolicyActionSummaryDetail {
    #[serde(rename = "totalObjectsCount", default, skip_serializing_if = "Option::is_none")]
    pub total_objects_count: Option<i64>,
    #[serde(rename = "successCount", default, skip_serializing_if = "Option::is_none")]
    pub success_count: Option<i64>,
    #[serde(rename = "errorList", default, skip_serializing_if = "Option::is_none")]
    pub error_list: Option<String>,
}
impl StorageLifecyclePolicyActionSummaryDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct StorageLifecyclePolicyCompletedEventData {
    #[serde(rename = "scheduleTime", default, skip_serializing_if = "Option::is_none")]
    pub schedule_time: Option<String>,
    #[serde(rename = "deleteSummary", default, skip_serializing_if = "Option::is_none")]
    pub delete_summary: Option<StorageLifecyclePolicyActionSummaryDetail>,
    #[serde(rename = "tierToCoolSummary", default, skip_serializing_if = "Option::is_none")]
    pub tier_to_cool_summary: Option<StorageLifecyclePolicyActionSummaryDetail>,
    #[serde(rename = "tierToArchiveSummary", default, skip_serializing_if = "Option::is_none")]
    pub tier_to_archive_summary: Option<StorageLifecyclePolicyActionSummaryDetail>,
}
impl StorageLifecyclePolicyCompletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubscriptionDeletedEventData {
    #[serde(rename = "eventSubscriptionId", default, skip_serializing_if = "Option::is_none")]
    pub event_subscription_id: Option<String>,
}
impl SubscriptionDeletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubscriptionValidationEventData {
    #[serde(rename = "validationCode", default, skip_serializing_if = "Option::is_none")]
    pub validation_code: Option<String>,
    #[serde(rename = "validationUrl", default, skip_serializing_if = "Option::is_none")]
    pub validation_url: Option<String>,
}
impl SubscriptionValidationEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubscriptionValidationResponse {
    #[serde(rename = "validationResponse", default, skip_serializing_if = "Option::is_none")]
    pub validation_response: Option<String>,
}
impl SubscriptionValidationResponse {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebAppServicePlanUpdatedEventData {
    #[serde(rename = "appServicePlanEventTypeDetail", default, skip_serializing_if = "Option::is_none")]
    pub app_service_plan_event_type_detail: Option<AppServicePlanEventTypeDetail>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<web_app_service_plan_updated_event_data::Sku>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "correlationRequestId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub verb: Option<String>,
}
impl WebAppServicePlanUpdatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod web_app_service_plan_updated_event_data {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
    pub struct Sku {
        #[serde(default, skip_serializing_if = "Option::is_none")]
        pub name: Option<String>,
        #[serde(rename = "Tier", default, skip_serializing_if = "Option::is_none")]
        pub tier: Option<String>,
        #[serde(rename = "Size", default, skip_serializing_if = "Option::is_none")]
        pub size: Option<String>,
        #[serde(rename = "Family", default, skip_serializing_if = "Option::is_none")]
        pub family: Option<String>,
        #[serde(rename = "Capacity", default, skip_serializing_if = "Option::is_none")]
        pub capacity: Option<String>,
    }
    impl Sku {
        pub fn new() -> Self {
            Self::default()
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebAppUpdatedEventData {
    #[serde(rename = "appEventTypeDetail", default, skip_serializing_if = "Option::is_none")]
    pub app_event_type_detail: Option<AppEventTypeDetail>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "correlationRequestId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub verb: Option<String>,
}
impl WebAppUpdatedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebBackupOperationCompletedEventData {
    #[serde(rename = "appEventTypeDetail", default, skip_serializing_if = "Option::is_none")]
    pub app_event_type_detail: Option<AppEventTypeDetail>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "correlationRequestId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub verb: Option<String>,
}
impl WebBackupOperationCompletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebBackupOperationFailedEventData {
    #[serde(rename = "appEventTypeDetail", default, skip_serializing_if = "Option::is_none")]
    pub app_event_type_detail: Option<AppEventTypeDetail>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "correlationRequestId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub verb: Option<String>,
}
impl WebBackupOperationFailedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebBackupOperationStartedEventData {
    #[serde(rename = "appEventTypeDetail", default, skip_serializing_if = "Option::is_none")]
    pub app_event_type_detail: Option<AppEventTypeDetail>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "correlationRequestId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub verb: Option<String>,
}
impl WebBackupOperationStartedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebRestoreOperationCompletedEventData {
    #[serde(rename = "appEventTypeDetail", default, skip_serializing_if = "Option::is_none")]
    pub app_event_type_detail: Option<AppEventTypeDetail>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "correlationRequestId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub verb: Option<String>,
}
impl WebRestoreOperationCompletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebRestoreOperationFailedEventData {
    #[serde(rename = "appEventTypeDetail", default, skip_serializing_if = "Option::is_none")]
    pub app_event_type_detail: Option<AppEventTypeDetail>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "correlationRequestId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub verb: Option<String>,
}
impl WebRestoreOperationFailedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebRestoreOperationStartedEventData {
    #[serde(rename = "appEventTypeDetail", default, skip_serializing_if = "Option::is_none")]
    pub app_event_type_detail: Option<AppEventTypeDetail>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "correlationRequestId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub verb: Option<String>,
}
impl WebRestoreOperationStartedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebSlotSwapCompletedEventData {
    #[serde(rename = "appEventTypeDetail", default, skip_serializing_if = "Option::is_none")]
    pub app_event_type_detail: Option<AppEventTypeDetail>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "correlationRequestId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub verb: Option<String>,
}
impl WebSlotSwapCompletedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebSlotSwapFailedEventData {
    #[serde(rename = "appEventTypeDetail", default, skip_serializing_if = "Option::is_none")]
    pub app_event_type_detail: Option<AppEventTypeDetail>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "correlationRequestId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub verb: Option<String>,
}
impl WebSlotSwapFailedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebSlotSwapStartedEventData {
    #[serde(rename = "appEventTypeDetail", default, skip_serializing_if = "Option::is_none")]
    pub app_event_type_detail: Option<AppEventTypeDetail>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "correlationRequestId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub verb: Option<String>,
}
impl WebSlotSwapStartedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebSlotSwapWithPreviewCancelledEventData {
    #[serde(rename = "appEventTypeDetail", default, skip_serializing_if = "Option::is_none")]
    pub app_event_type_detail: Option<AppEventTypeDetail>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "correlationRequestId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub verb: Option<String>,
}
impl WebSlotSwapWithPreviewCancelledEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WebSlotSwapWithPreviewStartedEventData {
    #[serde(rename = "appEventTypeDetail", default, skip_serializing_if = "Option::is_none")]
    pub app_event_type_detail: Option<AppEventTypeDetail>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "clientRequestId", default, skip_serializing_if = "Option::is_none")]
    pub client_request_id: Option<String>,
    #[serde(rename = "correlationRequestId", default, skip_serializing_if = "Option::is_none")]
    pub correlation_request_id: Option<String>,
    #[serde(rename = "requestId", default, skip_serializing_if = "Option::is_none")]
    pub request_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub verb: Option<String>,
}
impl WebSlotSwapWithPreviewStartedEventData {
    pub fn new() -> Self {
        Self::default()
    }
}
