#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AttestationMechanism {
    #[serde(rename = "type")]
    pub type_: attestation_mechanism::Type,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tpm: Option<TpmAttestation>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub x509: Option<X509Attestation>,
    #[serde(rename = "symmetricKey", default, skip_serializing_if = "Option::is_none")]
    pub symmetric_key: Option<SymmetricKeyAttestation>,
}
impl AttestationMechanism {
    pub fn new(type_: attestation_mechanism::Type) -> Self {
        Self {
            type_,
            tpm: None,
            x509: None,
            symmetric_key: None,
        }
    }
}
pub mod attestation_mechanism {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "none")]
        None,
        #[serde(rename = "tpm")]
        Tpm,
        #[serde(rename = "x509")]
        X509,
        #[serde(rename = "symmetricKey")]
        SymmetricKey,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BulkEnrollmentGroupOperation {
    #[serde(rename = "enrollmentGroups")]
    pub enrollment_groups: Vec<EnrollmentGroup>,
    pub mode: bulk_enrollment_group_operation::Mode,
}
impl BulkEnrollmentGroupOperation {
    pub fn new(enrollment_groups: Vec<EnrollmentGroup>, mode: bulk_enrollment_group_operation::Mode) -> Self {
        Self { enrollment_groups, mode }
    }
}
pub mod bulk_enrollment_group_operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Mode {
        #[serde(rename = "create")]
        Create,
        #[serde(rename = "update")]
        Update,
        #[serde(rename = "updateIfMatchETag")]
        UpdateIfMatchETag,
        #[serde(rename = "delete")]
        Delete,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BulkEnrollmentGroupOperationError {
    #[serde(rename = "enrollmentGroupId")]
    pub enrollment_group_id: String,
    #[serde(rename = "errorCode")]
    pub error_code: i32,
    #[serde(rename = "errorStatus")]
    pub error_status: String,
}
impl BulkEnrollmentGroupOperationError {
    pub fn new(enrollment_group_id: String, error_code: i32, error_status: String) -> Self {
        Self {
            enrollment_group_id,
            error_code,
            error_status,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BulkEnrollmentGroupOperationResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<BulkEnrollmentGroupOperationError>,
    #[serde(rename = "isSuccessful")]
    pub is_successful: bool,
}
impl BulkEnrollmentGroupOperationResult {
    pub fn new(is_successful: bool) -> Self {
        Self {
            errors: Vec::new(),
            is_successful,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BulkEnrollmentOperation {
    pub enrollments: Vec<IndividualEnrollment>,
    pub mode: bulk_enrollment_operation::Mode,
}
impl BulkEnrollmentOperation {
    pub fn new(enrollments: Vec<IndividualEnrollment>, mode: bulk_enrollment_operation::Mode) -> Self {
        Self { enrollments, mode }
    }
}
pub mod bulk_enrollment_operation {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Mode {
        #[serde(rename = "create")]
        Create,
        #[serde(rename = "update")]
        Update,
        #[serde(rename = "updateIfMatchETag")]
        UpdateIfMatchETag,
        #[serde(rename = "delete")]
        Delete,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BulkEnrollmentOperationError {
    #[serde(rename = "registrationId")]
    pub registration_id: String,
    #[serde(rename = "errorCode")]
    pub error_code: i32,
    #[serde(rename = "errorStatus")]
    pub error_status: String,
}
impl BulkEnrollmentOperationError {
    pub fn new(registration_id: String, error_code: i32, error_status: String) -> Self {
        Self {
            registration_id,
            error_code,
            error_status,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BulkEnrollmentOperationResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<BulkEnrollmentOperationError>,
    #[serde(rename = "isSuccessful")]
    pub is_successful: bool,
}
impl BulkEnrollmentOperationResult {
    pub fn new(is_successful: bool) -> Self {
        Self {
            errors: Vec::new(),
            is_successful,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CustomAllocationDefinition {
    #[serde(rename = "webhookUrl")]
    pub webhook_url: String,
    #[serde(rename = "apiVersion")]
    pub api_version: String,
}
impl CustomAllocationDefinition {
    pub fn new(webhook_url: String, api_version: String) -> Self {
        Self { webhook_url, api_version }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeviceCapabilities {
    #[serde(rename = "iotEdge")]
    pub iot_edge: bool,
}
impl DeviceCapabilities {
    pub fn new(iot_edge: bool) -> Self {
        Self { iot_edge }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeviceRegistrationState {
    #[serde(rename = "registrationId", default, skip_serializing_if = "Option::is_none")]
    pub registration_id: Option<String>,
    #[serde(rename = "createdDateTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_date_time_utc: Option<String>,
    #[serde(rename = "assignedHub", default, skip_serializing_if = "Option::is_none")]
    pub assigned_hub: Option<String>,
    #[serde(rename = "deviceId", default, skip_serializing_if = "Option::is_none")]
    pub device_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub status: Option<device_registration_state::Status>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub substatus: Option<device_registration_state::Substatus>,
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<i32>,
    #[serde(rename = "errorMessage", default, skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[serde(rename = "lastUpdatedDateTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_date_time_utc: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub payload: Option<serde_json::Value>,
}
impl DeviceRegistrationState {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod device_registration_state {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        #[serde(rename = "unassigned")]
        Unassigned,
        #[serde(rename = "assigning")]
        Assigning,
        #[serde(rename = "assigned")]
        Assigned,
        #[serde(rename = "failed")]
        Failed,
        #[serde(rename = "disabled")]
        Disabled,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Substatus {
        #[serde(rename = "initialAssignment")]
        InitialAssignment,
        #[serde(rename = "deviceDataMigrated")]
        DeviceDataMigrated,
        #[serde(rename = "deviceDataReset")]
        DeviceDataReset,
        #[serde(rename = "reprovisionedToInitialAssignment")]
        ReprovisionedToInitialAssignment,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnrollmentGroup {
    #[serde(rename = "enrollmentGroupId")]
    pub enrollment_group_id: String,
    pub attestation: AttestationMechanism,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capabilities: Option<DeviceCapabilities>,
    #[serde(rename = "iotHubHostName", default, skip_serializing_if = "Option::is_none")]
    pub iot_hub_host_name: Option<String>,
    #[serde(rename = "initialTwin", default, skip_serializing_if = "Option::is_none")]
    pub initial_twin: Option<InitialTwin>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "provisioningStatus", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_status: Option<enrollment_group::ProvisioningStatus>,
    #[serde(rename = "reprovisionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub reprovision_policy: Option<ReprovisionPolicy>,
    #[serde(rename = "createdDateTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_date_time_utc: Option<String>,
    #[serde(rename = "lastUpdatedDateTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_date_time_utc: Option<String>,
    #[serde(rename = "allocationPolicy", default, skip_serializing_if = "Option::is_none")]
    pub allocation_policy: Option<enrollment_group::AllocationPolicy>,
    #[serde(rename = "iotHubs", default, skip_serializing_if = "Vec::is_empty")]
    pub iot_hubs: Vec<String>,
    #[serde(rename = "customAllocationDefinition", default, skip_serializing_if = "Option::is_none")]
    pub custom_allocation_definition: Option<CustomAllocationDefinition>,
}
impl EnrollmentGroup {
    pub fn new(enrollment_group_id: String, attestation: AttestationMechanism) -> Self {
        Self {
            enrollment_group_id,
            attestation,
            capabilities: None,
            iot_hub_host_name: None,
            initial_twin: None,
            etag: None,
            provisioning_status: None,
            reprovision_policy: None,
            created_date_time_utc: None,
            last_updated_date_time_utc: None,
            allocation_policy: None,
            iot_hubs: Vec::new(),
            custom_allocation_definition: None,
        }
    }
}
pub mod enrollment_group {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningStatus {
        #[serde(rename = "enabled")]
        Enabled,
        #[serde(rename = "disabled")]
        Disabled,
    }
    impl Default for ProvisioningStatus {
        fn default() -> Self {
            Self::Enabled
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AllocationPolicy {
        #[serde(rename = "hashed")]
        Hashed,
        #[serde(rename = "geoLatency")]
        GeoLatency,
        #[serde(rename = "static")]
        Static,
        #[serde(rename = "custom")]
        Custom,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct IndividualEnrollment {
    #[serde(rename = "registrationId")]
    pub registration_id: String,
    #[serde(rename = "deviceId", default, skip_serializing_if = "Option::is_none")]
    pub device_id: Option<String>,
    #[serde(rename = "registrationState", default, skip_serializing_if = "Option::is_none")]
    pub registration_state: Option<DeviceRegistrationState>,
    #[serde(rename = "optionalDeviceInformation", default, skip_serializing_if = "Option::is_none")]
    pub optional_device_information: Option<TwinCollection>,
    pub attestation: AttestationMechanism,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub capabilities: Option<DeviceCapabilities>,
    #[serde(rename = "iotHubHostName", default, skip_serializing_if = "Option::is_none")]
    pub iot_hub_host_name: Option<String>,
    #[serde(rename = "initialTwin", default, skip_serializing_if = "Option::is_none")]
    pub initial_twin: Option<InitialTwin>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub etag: Option<String>,
    #[serde(rename = "provisioningStatus", default, skip_serializing_if = "Option::is_none")]
    pub provisioning_status: Option<individual_enrollment::ProvisioningStatus>,
    #[serde(rename = "reprovisionPolicy", default, skip_serializing_if = "Option::is_none")]
    pub reprovision_policy: Option<ReprovisionPolicy>,
    #[serde(rename = "createdDateTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub created_date_time_utc: Option<String>,
    #[serde(rename = "lastUpdatedDateTimeUtc", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_date_time_utc: Option<String>,
    #[serde(rename = "allocationPolicy", default, skip_serializing_if = "Option::is_none")]
    pub allocation_policy: Option<individual_enrollment::AllocationPolicy>,
    #[serde(rename = "iotHubs", default, skip_serializing_if = "Vec::is_empty")]
    pub iot_hubs: Vec<String>,
    #[serde(rename = "customAllocationDefinition", default, skip_serializing_if = "Option::is_none")]
    pub custom_allocation_definition: Option<CustomAllocationDefinition>,
}
impl IndividualEnrollment {
    pub fn new(registration_id: String, attestation: AttestationMechanism) -> Self {
        Self {
            registration_id,
            device_id: None,
            registration_state: None,
            optional_device_information: None,
            attestation,
            capabilities: None,
            iot_hub_host_name: None,
            initial_twin: None,
            etag: None,
            provisioning_status: None,
            reprovision_policy: None,
            created_date_time_utc: None,
            last_updated_date_time_utc: None,
            allocation_policy: None,
            iot_hubs: Vec::new(),
            custom_allocation_definition: None,
        }
    }
}
pub mod individual_enrollment {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum ProvisioningStatus {
        #[serde(rename = "enabled")]
        Enabled,
        #[serde(rename = "disabled")]
        Disabled,
    }
    impl Default for ProvisioningStatus {
        fn default() -> Self {
            Self::Enabled
        }
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AllocationPolicy {
        #[serde(rename = "hashed")]
        Hashed,
        #[serde(rename = "geoLatency")]
        GeoLatency,
        #[serde(rename = "static")]
        Static,
        #[serde(rename = "custom")]
        Custom,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InitialTwin {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub tags: Option<TwinCollection>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<InitialTwinProperties>,
}
impl InitialTwin {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct InitialTwinProperties {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub desired: Option<TwinCollection>,
}
impl InitialTwinProperties {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Metadata {
    #[serde(rename = "lastUpdated", default, skip_serializing_if = "Option::is_none")]
    pub last_updated: Option<String>,
    #[serde(rename = "lastUpdatedVersion", default, skip_serializing_if = "Option::is_none")]
    pub last_updated_version: Option<i64>,
}
impl Metadata {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ProvisioningServiceErrorDetails {
    #[serde(rename = "errorCode", default, skip_serializing_if = "Option::is_none")]
    pub error_code: Option<i32>,
    #[serde(rename = "trackingId", default, skip_serializing_if = "Option::is_none")]
    pub tracking_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<serde_json::Value>,
    #[serde(rename = "timestampUtc", default, skip_serializing_if = "Option::is_none")]
    pub timestamp_utc: Option<String>,
}
impl ProvisioningServiceErrorDetails {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct QuerySpecification {
    pub query: String,
}
impl QuerySpecification {
    pub fn new(query: String) -> Self {
        Self { query }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReprovisionPolicy {
    #[serde(rename = "updateHubAssignment")]
    pub update_hub_assignment: bool,
    #[serde(rename = "migrateDeviceData")]
    pub migrate_device_data: bool,
}
impl ReprovisionPolicy {
    pub fn new(update_hub_assignment: bool, migrate_device_data: bool) -> Self {
        Self {
            update_hub_assignment,
            migrate_device_data,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SymmetricKeyAttestation {
    #[serde(rename = "primaryKey", default, skip_serializing_if = "Option::is_none")]
    pub primary_key: Option<String>,
    #[serde(rename = "secondaryKey", default, skip_serializing_if = "Option::is_none")]
    pub secondary_key: Option<String>,
}
impl SymmetricKeyAttestation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TpmAttestation {
    #[serde(rename = "endorsementKey")]
    pub endorsement_key: String,
    #[serde(rename = "storageRootKey", default, skip_serializing_if = "Option::is_none")]
    pub storage_root_key: Option<String>,
}
impl TpmAttestation {
    pub fn new(endorsement_key: String) -> Self {
        Self {
            endorsement_key,
            storage_root_key: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TwinCollection {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub metadata: Option<Metadata>,
}
impl TwinCollection {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct X509Attestation {
    #[serde(rename = "clientCertificates", default, skip_serializing_if = "Option::is_none")]
    pub client_certificates: Option<X509Certificates>,
    #[serde(rename = "signingCertificates", default, skip_serializing_if = "Option::is_none")]
    pub signing_certificates: Option<X509Certificates>,
    #[serde(rename = "caReferences", default, skip_serializing_if = "Option::is_none")]
    pub ca_references: Option<X509caReferences>,
}
impl X509Attestation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct X509caReferences {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub secondary: Option<String>,
}
impl X509caReferences {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct X509CertificateInfo {
    #[serde(rename = "subjectName")]
    pub subject_name: String,
    #[serde(rename = "sha1Thumbprint")]
    pub sha1_thumbprint: String,
    #[serde(rename = "sha256Thumbprint")]
    pub sha256_thumbprint: String,
    #[serde(rename = "issuerName")]
    pub issuer_name: String,
    #[serde(rename = "notBeforeUtc")]
    pub not_before_utc: String,
    #[serde(rename = "notAfterUtc")]
    pub not_after_utc: String,
    #[serde(rename = "serialNumber")]
    pub serial_number: String,
    pub version: i32,
}
impl X509CertificateInfo {
    pub fn new(
        subject_name: String,
        sha1_thumbprint: String,
        sha256_thumbprint: String,
        issuer_name: String,
        not_before_utc: String,
        not_after_utc: String,
        serial_number: String,
        version: i32,
    ) -> Self {
        Self {
            subject_name,
            sha1_thumbprint,
            sha256_thumbprint,
            issuer_name,
            not_before_utc,
            not_after_utc,
            serial_number,
            version,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct X509CertificateWithInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub certificate: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub info: Option<X509CertificateInfo>,
}
impl X509CertificateWithInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct X509Certificates {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub primary: Option<X509CertificateWithInfo>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub secondary: Option<X509CertificateWithInfo>,
}
impl X509Certificates {
    pub fn new() -> Self {
        Self::default()
    }
}
