#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[doc = "A Data Lake Analytics catalog item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CatalogItem {
    #[doc = "the name of the Data Lake Analytics account."]
    #[serde(rename = "computeAccountName", default, skip_serializing_if = "Option::is_none")]
    pub compute_account_name: Option<String>,
    #[doc = "the version of the catalog item."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl CatalogItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog item list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CatalogItemList {
    #[doc = "the count of items in the list."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[doc = "the link to the next page of results."]
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CatalogItemList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "DataLakeAnalytics DataLakeAnalyticsAccount information."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters {
    #[doc = "the password for the secret to pass in"]
    pub password: String,
    #[doc = "the URI identifier for the secret in the format <hostname>:<port>"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uri: Option<String>,
}
impl DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters {
    pub fn new(password: String) -> Self {
        Self { password, uri: None }
    }
}
#[doc = "A Data Lake Analytics DDL name item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdlName {
    #[doc = "the name of the table associated with this database and schema."]
    #[serde(rename = "firstPart", default, skip_serializing_if = "Option::is_none")]
    pub first_part: Option<String>,
    #[doc = "the name of the table associated with this database and schema."]
    #[serde(rename = "secondPart", default, skip_serializing_if = "Option::is_none")]
    pub second_part: Option<String>,
    #[doc = "the name of the table associated with this database and schema."]
    #[serde(rename = "thirdPart", default, skip_serializing_if = "Option::is_none")]
    pub third_part: Option<String>,
    #[doc = "the name of the table associated with this database and schema."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub server: Option<String>,
}
impl DdlName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog entity identifier object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EntityId {
    #[doc = "A Data Lake Analytics DDL name item."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<DdlName>,
    #[doc = "the version of the external data source."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl EntityId {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog external table item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalTable {
    #[doc = "the name of the table associated with this database and schema."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<String>,
    #[doc = "A Data Lake Analytics catalog entity identifier object."]
    #[serde(rename = "dataSource", default, skip_serializing_if = "Option::is_none")]
    pub data_source: Option<EntityId>,
}
impl ExternalTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog type field information item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TypeFieldInfo {
    #[doc = "the name of the field associated with this type."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "the type of the field."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl TypeFieldInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL Assembly."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlAssembly {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[doc = "the name of the database."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "the name of the assembly."]
    #[serde(rename = "assemblyName", default, skip_serializing_if = "Option::is_none")]
    pub assembly_name: Option<String>,
    #[doc = "the name of the CLR."]
    #[serde(rename = "clrName", default, skip_serializing_if = "Option::is_none")]
    pub clr_name: Option<String>,
    #[doc = "the switch indicating if this assembly is visible or not."]
    #[serde(rename = "isVisible", default, skip_serializing_if = "Option::is_none")]
    pub is_visible: Option<bool>,
    #[doc = "the switch indicating if this assembly is user defined or not."]
    #[serde(rename = "isUserDefined", default, skip_serializing_if = "Option::is_none")]
    pub is_user_defined: Option<bool>,
    #[doc = "the list of files associated with the assembly"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub files: Vec<USqlAssemblyFileInfo>,
    #[doc = "the list of dependencies associated with the assembly"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub dependencies: Vec<USqlAssemblyDependencyInfo>,
}
impl USqlAssembly {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL assembly CLR item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlAssemblyClr {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[doc = "the name of the database."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "the name of the assembly."]
    #[serde(rename = "assemblyClrName", default, skip_serializing_if = "Option::is_none")]
    pub assembly_clr_name: Option<String>,
    #[doc = "the name of the CLR."]
    #[serde(rename = "clrName", default, skip_serializing_if = "Option::is_none")]
    pub clr_name: Option<String>,
}
impl USqlAssemblyClr {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL dependency information item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlAssemblyDependencyInfo {
    #[doc = "A Data Lake Analytics catalog entity identifier object."]
    #[serde(rename = "entityId", default, skip_serializing_if = "Option::is_none")]
    pub entity_id: Option<EntityId>,
}
impl USqlAssemblyDependencyInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL assembly file information item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlAssemblyFileInfo {
    #[doc = "the assembly file type."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<u_sql_assembly_file_info::Type>,
    #[doc = "The original path to the assembly file."]
    #[serde(rename = "originalPath", default, skip_serializing_if = "Option::is_none")]
    pub original_path: Option<String>,
    #[doc = "The content path to the assembly file."]
    #[serde(rename = "contentPath", default, skip_serializing_if = "Option::is_none")]
    pub content_path: Option<String>,
}
impl USqlAssemblyFileInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod u_sql_assembly_file_info {
    use super::*;
    #[doc = "the assembly file type."]
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Assembly,
        Resource,
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL assembly CLR item list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlAssemblyList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[doc = "the list of assemblies in the database"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlAssemblyClr>,
}
impl USqlAssemblyList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL credential item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlCredential {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[doc = "the name of the database the credential is in."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "the name of the secret associated with the credential."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<String>,
    #[doc = "the name of the credential."]
    #[serde(rename = "credentialName", default, skip_serializing_if = "Option::is_none")]
    pub credential_name: Option<String>,
    #[doc = "the user name associated with the credential."]
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
}
impl USqlCredential {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL credential item list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlCredentialList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[doc = "the list of credentials in the database"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlCredential>,
}
impl USqlCredentialList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL database item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlDatabase {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[doc = "the name of the database."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
}
impl USqlDatabase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL database item list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlDatabaseList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[doc = "the list of databases"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlDatabase>,
}
impl USqlDatabaseList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL directed column item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlDirectedColumn {
    #[doc = "the name of the index in the table."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "the switch indicating if the index is descending or not."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub descending: Option<bool>,
}
impl USqlDirectedColumn {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL distribution information object."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlDistributionInfo {
    #[doc = "the type of this distribution."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<i32>,
    #[doc = "the list of directed columns in the distribution"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub keys: Vec<USqlDirectedColumn>,
    #[doc = "the count of indices using this distribution."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[doc = "the dynamic count of indices using this distribution."]
    #[serde(rename = "dynamicCount", default, skip_serializing_if = "Option::is_none")]
    pub dynamic_count: Option<i32>,
}
impl USqlDistributionInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL external datasource item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlExternalDataSource {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[doc = "the name of the database."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "the name of the external data source."]
    #[serde(rename = "externalDataSourceName", default, skip_serializing_if = "Option::is_none")]
    pub external_data_source_name: Option<String>,
    #[doc = "the name of the provider for the external data source."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[doc = "the name of the provider string for the external data source."]
    #[serde(rename = "providerString", default, skip_serializing_if = "Option::is_none")]
    pub provider_string: Option<String>,
    #[doc = "the list of types to push down from the external data source."]
    #[serde(rename = "pushdownTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub pushdown_types: Vec<String>,
}
impl USqlExternalDataSource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL external datasource item list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlExternalDataSourceList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[doc = "the list of external data sources in the database"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlExternalDataSource>,
}
impl USqlExternalDataSourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL table index item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlIndex {
    #[doc = "the name of the index in the table."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "the list of directed columns in the index"]
    #[serde(rename = "indexKeys", default, skip_serializing_if = "Vec::is_empty")]
    pub index_keys: Vec<USqlDirectedColumn>,
    #[doc = "the list of columns in the index"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<String>,
    #[doc = "A Data Lake Analytics catalog U-SQL distribution information object."]
    #[serde(rename = "distributionInfo", default, skip_serializing_if = "Option::is_none")]
    pub distribution_info: Option<USqlDistributionInfo>,
    #[doc = "partition function ID for the index."]
    #[serde(rename = "partitionFunction", default, skip_serializing_if = "Option::is_none")]
    pub partition_function: Option<String>,
    #[doc = "the list of partition keys in the index"]
    #[serde(rename = "partitionKeyList", default, skip_serializing_if = "Vec::is_empty")]
    pub partition_key_list: Vec<String>,
    #[doc = "the list of full paths to the streams that contain this index in the DataLake account."]
    #[serde(rename = "streamNames", default, skip_serializing_if = "Vec::is_empty")]
    pub stream_names: Vec<String>,
    #[doc = "the switch indicating if this index is a columnstore index."]
    #[serde(rename = "isColumnstore", default, skip_serializing_if = "Option::is_none")]
    pub is_columnstore: Option<bool>,
    #[doc = "the ID of this index within the table."]
    #[serde(rename = "indexId", default, skip_serializing_if = "Option::is_none")]
    pub index_id: Option<i32>,
    #[doc = "the switch indicating if this index is a unique index."]
    #[serde(rename = "isUnique", default, skip_serializing_if = "Option::is_none")]
    pub is_unique: Option<bool>,
}
impl USqlIndex {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL procedure item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlProcedure {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[doc = "the name of the database."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "the name of the schema associated with this procedure and database."]
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
    #[doc = "the name of the procedure."]
    #[serde(rename = "procName", default, skip_serializing_if = "Option::is_none")]
    pub proc_name: Option<String>,
    #[doc = "the defined query of the procedure."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub definition: Option<String>,
}
impl USqlProcedure {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL procedure item list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlProcedureList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[doc = "the list of procedure in the database and schema combination"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlProcedure>,
}
impl USqlProcedureList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL schema item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlSchema {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[doc = "the name of the database."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "the name of the schema."]
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
}
impl USqlSchema {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL schema item list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlSchemaList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[doc = "the list of schemas in the database"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlSchema>,
}
impl USqlSchemaList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL secret item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlSecret {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[doc = "the name of the database."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "the name of the secret."]
    #[serde(rename = "secretName", default, skip_serializing_if = "Option::is_none")]
    pub secret_name: Option<String>,
    #[doc = "the creation time of the credential object. This is the only information returned about a secret from a GET."]
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[doc = "the URI identifier for the secret in the format <hostname>:<port>"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uri: Option<String>,
    #[doc = "the password for the secret to pass in"]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
}
impl USqlSecret {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL table item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTable {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[doc = "the name of the database."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "the name of the schema associated with this table and database."]
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
    #[doc = "the name of the table."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<String>,
    #[doc = "the list of columns in this table"]
    #[serde(rename = "columnList", default, skip_serializing_if = "Vec::is_empty")]
    pub column_list: Vec<USqlTableColumn>,
    #[doc = "the list of indices in this table"]
    #[serde(rename = "indexList", default, skip_serializing_if = "Vec::is_empty")]
    pub index_list: Vec<USqlIndex>,
    #[doc = "the list of partition keys in the table"]
    #[serde(rename = "partitionKeyList", default, skip_serializing_if = "Vec::is_empty")]
    pub partition_key_list: Vec<String>,
    #[doc = "A Data Lake Analytics catalog external table item."]
    #[serde(rename = "externalTable", default, skip_serializing_if = "Option::is_none")]
    pub external_table: Option<ExternalTable>,
    #[doc = "A Data Lake Analytics catalog U-SQL distribution information object."]
    #[serde(rename = "distributionInfo", default, skip_serializing_if = "Option::is_none")]
    pub distribution_info: Option<USqlDistributionInfo>,
}
impl USqlTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL table column item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTableColumn {
    #[doc = "the name of the column in the table."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[doc = "the object type of the specified column (such as System.String)."]
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl USqlTableColumn {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL table item list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTableList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[doc = "the list of tables in the database and schema combination"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlTable>,
}
impl USqlTableList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL table partition item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTablePartition {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[doc = "the name of the database."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "the name of the schema associated with this table partition and database."]
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
    #[doc = "the name of the table partition."]
    #[serde(rename = "partitionName", default, skip_serializing_if = "Option::is_none")]
    pub partition_name: Option<String>,
    #[doc = "A Data Lake Analytics DDL name item."]
    #[serde(rename = "parentName", default, skip_serializing_if = "Option::is_none")]
    pub parent_name: Option<DdlName>,
    #[doc = "the index ID for this partition."]
    #[serde(rename = "indexId", default, skip_serializing_if = "Option::is_none")]
    pub index_id: Option<i32>,
    #[doc = "the list of labels associated with this partition."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub label: Vec<String>,
    #[doc = "the creation time of the partition"]
    #[serde(rename = "createDate", default, skip_serializing_if = "Option::is_none")]
    pub create_date: Option<String>,
}
impl USqlTablePartition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL table partition item list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTablePartitionList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[doc = "the list of table partitions in the database, schema and table combination"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlTablePartition>,
}
impl USqlTablePartitionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL table statistics item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTableStatistics {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[doc = "the name of the database."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "the name of the schema associated with this table and database."]
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
    #[doc = "the name of the table."]
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<String>,
    #[doc = "the name of the table statistics."]
    #[serde(rename = "statisticsName", default, skip_serializing_if = "Option::is_none")]
    pub statistics_name: Option<String>,
    #[doc = "the name of the user statistics."]
    #[serde(rename = "userStatName", default, skip_serializing_if = "Option::is_none")]
    pub user_stat_name: Option<String>,
    #[doc = "the path to the statistics data."]
    #[serde(rename = "statDataPath", default, skip_serializing_if = "Option::is_none")]
    pub stat_data_path: Option<String>,
    #[doc = "the creation time of the statistics."]
    #[serde(rename = "createTime", default, skip_serializing_if = "Option::is_none")]
    pub create_time: Option<String>,
    #[doc = "the last time the statistics were updated."]
    #[serde(rename = "updateTime", default, skip_serializing_if = "Option::is_none")]
    pub update_time: Option<String>,
    #[doc = "the switch indicating if these statistics are user created."]
    #[serde(rename = "isUserCreated", default, skip_serializing_if = "Option::is_none")]
    pub is_user_created: Option<bool>,
    #[doc = "the switch indicating if these statistics are automatically created."]
    #[serde(rename = "isAutoCreated", default, skip_serializing_if = "Option::is_none")]
    pub is_auto_created: Option<bool>,
    #[doc = "the switch indicating if these statistics have a filter."]
    #[serde(rename = "hasFilter", default, skip_serializing_if = "Option::is_none")]
    pub has_filter: Option<bool>,
    #[doc = "the filter definition for the statistics."]
    #[serde(rename = "filterDefinition", default, skip_serializing_if = "Option::is_none")]
    pub filter_definition: Option<String>,
    #[doc = "the list of column names associated with these statistics."]
    #[serde(rename = "colNames", default, skip_serializing_if = "Vec::is_empty")]
    pub col_names: Vec<String>,
}
impl USqlTableStatistics {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL table statistics item list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTableStatisticsList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[doc = "the list of table statistics in the database, schema and table combination"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlTableStatistics>,
}
impl USqlTableStatisticsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL table type item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTableType {
    #[serde(flatten)]
    pub u_sql_type: USqlType,
    #[doc = "the type field information associated with this table type."]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<TypeFieldInfo>,
}
impl USqlTableType {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL table type item list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTableTypeList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[doc = "the list of table types in the database and schema combination"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlTableType>,
}
impl USqlTableTypeList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL table valued function item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTableValuedFunction {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[doc = "the name of the database."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "the name of the schema associated with this database."]
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
    #[doc = "the name of the table valued function."]
    #[serde(rename = "tvfName", default, skip_serializing_if = "Option::is_none")]
    pub tvf_name: Option<String>,
    #[doc = "the definition of the table valued function."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub definition: Option<String>,
}
impl USqlTableValuedFunction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL table valued function item list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTableValuedFunctionList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[doc = "the list of table valued functions in the database and schema combination"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlTableValuedFunction>,
}
impl USqlTableValuedFunctionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL type item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlType {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[doc = "the name of the database."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "the name of the schema associated with this table and database."]
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
    #[doc = "the name of type for this type."]
    #[serde(rename = "typeName", default, skip_serializing_if = "Option::is_none")]
    pub type_name: Option<String>,
    #[doc = "the type family for this type."]
    #[serde(rename = "typeFamily", default, skip_serializing_if = "Option::is_none")]
    pub type_family: Option<String>,
    #[doc = "the C# name for this type."]
    #[serde(rename = "cSharpName", default, skip_serializing_if = "Option::is_none")]
    pub c_sharp_name: Option<String>,
    #[doc = "the fully qualified C# name for this type."]
    #[serde(rename = "fullCSharpName", default, skip_serializing_if = "Option::is_none")]
    pub full_c_sharp_name: Option<String>,
    #[doc = "the system type ID for this type."]
    #[serde(rename = "systemTypeId", default, skip_serializing_if = "Option::is_none")]
    pub system_type_id: Option<i32>,
    #[doc = "the user type ID for this type."]
    #[serde(rename = "userTypeId", default, skip_serializing_if = "Option::is_none")]
    pub user_type_id: Option<i32>,
    #[doc = "the schema ID for this type."]
    #[serde(rename = "schemaId", default, skip_serializing_if = "Option::is_none")]
    pub schema_id: Option<i32>,
    #[doc = "the principal ID for this type."]
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<i32>,
    #[doc = "The switch indicating if this type is nullable."]
    #[serde(rename = "isNullable", default, skip_serializing_if = "Option::is_none")]
    pub is_nullable: Option<bool>,
    #[doc = "The switch indicating if this type is user defined."]
    #[serde(rename = "isUserDefined", default, skip_serializing_if = "Option::is_none")]
    pub is_user_defined: Option<bool>,
    #[doc = "The switch indicating if this type is an assembly type."]
    #[serde(rename = "isAssemblyType", default, skip_serializing_if = "Option::is_none")]
    pub is_assembly_type: Option<bool>,
    #[doc = "The switch indicating if this type is a table type."]
    #[serde(rename = "isTableType", default, skip_serializing_if = "Option::is_none")]
    pub is_table_type: Option<bool>,
    #[doc = "The switch indicating if this type is a complex type."]
    #[serde(rename = "isComplexType", default, skip_serializing_if = "Option::is_none")]
    pub is_complex_type: Option<bool>,
}
impl USqlType {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL type item list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTypeList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[doc = "the list of types in the database and schema combination"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlType>,
}
impl USqlTypeList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL view item."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlView {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[doc = "the name of the database."]
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[doc = "the name of the schema associated with this view and database."]
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
    #[doc = "the name of the view."]
    #[serde(rename = "viewName", default, skip_serializing_if = "Option::is_none")]
    pub view_name: Option<String>,
    #[doc = "the defined query of the view."]
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub definition: Option<String>,
}
impl USqlView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[doc = "A Data Lake Analytics catalog U-SQL view item list."]
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlViewList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[doc = "the list of view in the database and schema combination"]
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlView>,
}
impl USqlViewList {
    pub fn new() -> Self {
        Self::default()
    }
}
