#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CatalogItem {
    #[serde(rename = "computeAccountName", default, skip_serializing_if = "Option::is_none")]
    pub compute_account_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl CatalogItem {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CatalogItemList {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[serde(rename = "nextLink", default, skip_serializing_if = "Option::is_none")]
    pub next_link: Option<String>,
}
impl CatalogItemList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters {
    pub password: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uri: Option<String>,
}
impl DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters {
    pub fn new(password: String) -> Self {
        Self { password, uri: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DdlName {
    #[serde(rename = "firstPart", default, skip_serializing_if = "Option::is_none")]
    pub first_part: Option<String>,
    #[serde(rename = "secondPart", default, skip_serializing_if = "Option::is_none")]
    pub second_part: Option<String>,
    #[serde(rename = "thirdPart", default, skip_serializing_if = "Option::is_none")]
    pub third_part: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub server: Option<String>,
}
impl DdlName {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct EntityId {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<DdlName>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl EntityId {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExternalTable {
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<String>,
    #[serde(rename = "dataSource", default, skip_serializing_if = "Option::is_none")]
    pub data_source: Option<EntityId>,
}
impl ExternalTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TypeFieldInfo {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl TypeFieldInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlAssembly {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "assemblyName", default, skip_serializing_if = "Option::is_none")]
    pub assembly_name: Option<String>,
    #[serde(rename = "clrName", default, skip_serializing_if = "Option::is_none")]
    pub clr_name: Option<String>,
    #[serde(rename = "isVisible", default, skip_serializing_if = "Option::is_none")]
    pub is_visible: Option<bool>,
    #[serde(rename = "isUserDefined", default, skip_serializing_if = "Option::is_none")]
    pub is_user_defined: Option<bool>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub files: Vec<USqlAssemblyFileInfo>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub dependencies: Vec<USqlAssemblyDependencyInfo>,
}
impl USqlAssembly {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlAssemblyClr {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "assemblyClrName", default, skip_serializing_if = "Option::is_none")]
    pub assembly_clr_name: Option<String>,
    #[serde(rename = "clrName", default, skip_serializing_if = "Option::is_none")]
    pub clr_name: Option<String>,
}
impl USqlAssemblyClr {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlAssemblyDependencyInfo {
    #[serde(rename = "entityId", default, skip_serializing_if = "Option::is_none")]
    pub entity_id: Option<EntityId>,
}
impl USqlAssemblyDependencyInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlAssemblyFileInfo {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<u_sql_assembly_file_info::Type>,
    #[serde(rename = "originalPath", default, skip_serializing_if = "Option::is_none")]
    pub original_path: Option<String>,
    #[serde(rename = "contentPath", default, skip_serializing_if = "Option::is_none")]
    pub content_path: Option<String>,
}
impl USqlAssemblyFileInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod u_sql_assembly_file_info {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        Assembly,
        Resource,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlAssemblyList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlAssemblyClr>,
}
impl USqlAssemblyList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlCredential {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub identity: Option<String>,
    #[serde(rename = "credentialName", default, skip_serializing_if = "Option::is_none")]
    pub credential_name: Option<String>,
    #[serde(rename = "userName", default, skip_serializing_if = "Option::is_none")]
    pub user_name: Option<String>,
}
impl USqlCredential {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlCredentialList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlCredential>,
}
impl USqlCredentialList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlDatabase {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
}
impl USqlDatabase {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlDatabaseList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlDatabase>,
}
impl USqlDatabaseList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlDirectedColumn {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub descending: Option<bool>,
}
impl USqlDirectedColumn {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlDistributionInfo {
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<i32>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub keys: Vec<USqlDirectedColumn>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub count: Option<i32>,
    #[serde(rename = "dynamicCount", default, skip_serializing_if = "Option::is_none")]
    pub dynamic_count: Option<i32>,
}
impl USqlDistributionInfo {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlExternalDataSource {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "externalDataSourceName", default, skip_serializing_if = "Option::is_none")]
    pub external_data_source_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(rename = "providerString", default, skip_serializing_if = "Option::is_none")]
    pub provider_string: Option<String>,
    #[serde(rename = "pushdownTypes", default, skip_serializing_if = "Vec::is_empty")]
    pub pushdown_types: Vec<String>,
}
impl USqlExternalDataSource {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlExternalDataSourceList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlExternalDataSource>,
}
impl USqlExternalDataSourceList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlIndex {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "indexKeys", default, skip_serializing_if = "Vec::is_empty")]
    pub index_keys: Vec<USqlDirectedColumn>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<String>,
    #[serde(rename = "distributionInfo", default, skip_serializing_if = "Option::is_none")]
    pub distribution_info: Option<USqlDistributionInfo>,
    #[serde(rename = "partitionFunction", default, skip_serializing_if = "Option::is_none")]
    pub partition_function: Option<String>,
    #[serde(rename = "partitionKeyList", default, skip_serializing_if = "Vec::is_empty")]
    pub partition_key_list: Vec<String>,
    #[serde(rename = "streamNames", default, skip_serializing_if = "Vec::is_empty")]
    pub stream_names: Vec<String>,
    #[serde(rename = "isColumnstore", default, skip_serializing_if = "Option::is_none")]
    pub is_columnstore: Option<bool>,
    #[serde(rename = "indexId", default, skip_serializing_if = "Option::is_none")]
    pub index_id: Option<i32>,
    #[serde(rename = "isUnique", default, skip_serializing_if = "Option::is_none")]
    pub is_unique: Option<bool>,
}
impl USqlIndex {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlProcedure {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
    #[serde(rename = "procName", default, skip_serializing_if = "Option::is_none")]
    pub proc_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub definition: Option<String>,
}
impl USqlProcedure {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlProcedureList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlProcedure>,
}
impl USqlProcedureList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlSchema {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
}
impl USqlSchema {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlSchemaList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlSchema>,
}
impl USqlSchemaList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlSecret {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "secretName", default, skip_serializing_if = "Option::is_none")]
    pub secret_name: Option<String>,
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uri: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
}
impl USqlSecret {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTable {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<String>,
    #[serde(rename = "columnList", default, skip_serializing_if = "Vec::is_empty")]
    pub column_list: Vec<USqlTableColumn>,
    #[serde(rename = "indexList", default, skip_serializing_if = "Vec::is_empty")]
    pub index_list: Vec<USqlIndex>,
    #[serde(rename = "partitionKeyList", default, skip_serializing_if = "Vec::is_empty")]
    pub partition_key_list: Vec<String>,
    #[serde(rename = "externalTable", default, skip_serializing_if = "Option::is_none")]
    pub external_table: Option<ExternalTable>,
    #[serde(rename = "distributionInfo", default, skip_serializing_if = "Option::is_none")]
    pub distribution_info: Option<USqlDistributionInfo>,
}
impl USqlTable {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTableColumn {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "type", default, skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
}
impl USqlTableColumn {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTableList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlTable>,
}
impl USqlTableList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTablePartition {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
    #[serde(rename = "partitionName", default, skip_serializing_if = "Option::is_none")]
    pub partition_name: Option<String>,
    #[serde(rename = "parentName", default, skip_serializing_if = "Option::is_none")]
    pub parent_name: Option<DdlName>,
    #[serde(rename = "indexId", default, skip_serializing_if = "Option::is_none")]
    pub index_id: Option<i32>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub label: Vec<String>,
    #[serde(rename = "createDate", default, skip_serializing_if = "Option::is_none")]
    pub create_date: Option<String>,
}
impl USqlTablePartition {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTablePartitionList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlTablePartition>,
}
impl USqlTablePartitionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTableStatistics {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
    #[serde(rename = "tableName", default, skip_serializing_if = "Option::is_none")]
    pub table_name: Option<String>,
    #[serde(rename = "statisticsName", default, skip_serializing_if = "Option::is_none")]
    pub statistics_name: Option<String>,
    #[serde(rename = "userStatName", default, skip_serializing_if = "Option::is_none")]
    pub user_stat_name: Option<String>,
    #[serde(rename = "statDataPath", default, skip_serializing_if = "Option::is_none")]
    pub stat_data_path: Option<String>,
    #[serde(rename = "createTime", default, skip_serializing_if = "Option::is_none")]
    pub create_time: Option<String>,
    #[serde(rename = "updateTime", default, skip_serializing_if = "Option::is_none")]
    pub update_time: Option<String>,
    #[serde(rename = "isUserCreated", default, skip_serializing_if = "Option::is_none")]
    pub is_user_created: Option<bool>,
    #[serde(rename = "isAutoCreated", default, skip_serializing_if = "Option::is_none")]
    pub is_auto_created: Option<bool>,
    #[serde(rename = "hasFilter", default, skip_serializing_if = "Option::is_none")]
    pub has_filter: Option<bool>,
    #[serde(rename = "filterDefinition", default, skip_serializing_if = "Option::is_none")]
    pub filter_definition: Option<String>,
    #[serde(rename = "colNames", default, skip_serializing_if = "Vec::is_empty")]
    pub col_names: Vec<String>,
}
impl USqlTableStatistics {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTableStatisticsList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlTableStatistics>,
}
impl USqlTableStatisticsList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTableType {
    #[serde(flatten)]
    pub u_sql_type: USqlType,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub columns: Vec<TypeFieldInfo>,
}
impl USqlTableType {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTableTypeList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlTableType>,
}
impl USqlTableTypeList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTableValuedFunction {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
    #[serde(rename = "tvfName", default, skip_serializing_if = "Option::is_none")]
    pub tvf_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub definition: Option<String>,
}
impl USqlTableValuedFunction {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTableValuedFunctionList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlTableValuedFunction>,
}
impl USqlTableValuedFunctionList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlType {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
    #[serde(rename = "typeName", default, skip_serializing_if = "Option::is_none")]
    pub type_name: Option<String>,
    #[serde(rename = "typeFamily", default, skip_serializing_if = "Option::is_none")]
    pub type_family: Option<String>,
    #[serde(rename = "cSharpName", default, skip_serializing_if = "Option::is_none")]
    pub c_sharp_name: Option<String>,
    #[serde(rename = "fullCSharpName", default, skip_serializing_if = "Option::is_none")]
    pub full_c_sharp_name: Option<String>,
    #[serde(rename = "systemTypeId", default, skip_serializing_if = "Option::is_none")]
    pub system_type_id: Option<i32>,
    #[serde(rename = "userTypeId", default, skip_serializing_if = "Option::is_none")]
    pub user_type_id: Option<i32>,
    #[serde(rename = "schemaId", default, skip_serializing_if = "Option::is_none")]
    pub schema_id: Option<i32>,
    #[serde(rename = "principalId", default, skip_serializing_if = "Option::is_none")]
    pub principal_id: Option<i32>,
    #[serde(rename = "isNullable", default, skip_serializing_if = "Option::is_none")]
    pub is_nullable: Option<bool>,
    #[serde(rename = "isUserDefined", default, skip_serializing_if = "Option::is_none")]
    pub is_user_defined: Option<bool>,
    #[serde(rename = "isAssemblyType", default, skip_serializing_if = "Option::is_none")]
    pub is_assembly_type: Option<bool>,
    #[serde(rename = "isTableType", default, skip_serializing_if = "Option::is_none")]
    pub is_table_type: Option<bool>,
    #[serde(rename = "isComplexType", default, skip_serializing_if = "Option::is_none")]
    pub is_complex_type: Option<bool>,
}
impl USqlType {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlTypeList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlType>,
}
impl USqlTypeList {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlView {
    #[serde(flatten)]
    pub catalog_item: CatalogItem,
    #[serde(rename = "databaseName", default, skip_serializing_if = "Option::is_none")]
    pub database_name: Option<String>,
    #[serde(rename = "schemaName", default, skip_serializing_if = "Option::is_none")]
    pub schema_name: Option<String>,
    #[serde(rename = "viewName", default, skip_serializing_if = "Option::is_none")]
    pub view_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub definition: Option<String>,
}
impl USqlView {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct USqlViewList {
    #[serde(flatten)]
    pub catalog_item_list: CatalogItemList,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<USqlView>,
}
impl USqlViewList {
    pub fn new() -> Self {
        Self::default()
    }
}
