#![doc = "generated by AutoRust"]
#![allow(unused_mut)]
#![allow(unused_variables)]
#![allow(unused_imports)]
use super::models;
#[derive(Clone)]
pub struct Client {
    endpoint: String,
    credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
    scopes: Vec<String>,
    pipeline: azure_core::Pipeline,
}
#[derive(Clone)]
pub struct ClientBuilder {
    credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
    endpoint: Option<String>,
    scopes: Option<Vec<String>>,
}
pub const DEFAULT_ENDPOINT: &str = azure_core::resource_manager_endpoint::AZURE_PUBLIC_CLOUD;
impl ClientBuilder {
    pub fn new(credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>) -> Self {
        Self {
            credential,
            endpoint: None,
            scopes: None,
        }
    }
    pub fn endpoint(mut self, endpoint: impl Into<String>) -> Self {
        self.endpoint = Some(endpoint.into());
        self
    }
    pub fn scopes(mut self, scopes: &[&str]) -> Self {
        self.scopes = Some(scopes.iter().map(|scope| (*scope).to_owned()).collect());
        self
    }
    pub fn build(self) -> Client {
        let endpoint = self.endpoint.unwrap_or_else(|| DEFAULT_ENDPOINT.to_owned());
        let scopes = self.scopes.unwrap_or_else(|| vec![format!("{}/", endpoint)]);
        Client::new(endpoint, self.credential, scopes)
    }
}
impl Client {
    pub(crate) fn endpoint(&self) -> &str {
        self.endpoint.as_str()
    }
    pub(crate) fn token_credential(&self) -> &dyn azure_core::auth::TokenCredential {
        self.credential.as_ref()
    }
    pub(crate) fn scopes(&self) -> Vec<&str> {
        self.scopes.iter().map(String::as_str).collect()
    }
    pub(crate) async fn send(&self, request: impl Into<azure_core::Request>) -> Result<azure_core::Response, azure_core::Error> {
        let mut context = azure_core::Context::default();
        let mut request = request.into();
        self.pipeline.send(&mut context, &mut request).await
    }
    pub fn new(
        endpoint: impl Into<String>,
        credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
        scopes: Vec<String>,
    ) -> Self {
        let endpoint = endpoint.into();
        let pipeline = azure_core::Pipeline::new(
            option_env!("CARGO_PKG_NAME"),
            option_env!("CARGO_PKG_VERSION"),
            azure_core::ClientOptions::default(),
            Vec::new(),
            Vec::new(),
        );
        Self {
            endpoint,
            credential,
            scopes,
            pipeline,
        }
    }
    pub fn append_blob(&self) -> append_blob::Client {
        append_blob::Client(self.clone())
    }
    pub fn blob(&self) -> blob::Client {
        blob::Client(self.clone())
    }
    pub fn block_blob(&self) -> block_blob::Client {
        block_blob::Client(self.clone())
    }
    pub fn container(&self) -> container::Client {
        container::Client(self.clone())
    }
    pub fn page_blob(&self) -> page_blob::Client {
        page_blob::Client(self.clone())
    }
    pub fn service(&self) -> service::Client {
        service::Client(self.clone())
    }
}
#[non_exhaustive]
#[derive(Debug, thiserror :: Error)]
#[allow(non_camel_case_types)]
pub enum Error {
    #[error(transparent)]
    Service_GetProperties(#[from] service::get_properties::Error),
    #[error(transparent)]
    Service_SetProperties(#[from] service::set_properties::Error),
    #[error(transparent)]
    Service_GetStatistics(#[from] service::get_statistics::Error),
    #[error(transparent)]
    Service_ListContainersSegment(#[from] service::list_containers_segment::Error),
    #[error(transparent)]
    Service_GetUserDelegationKey(#[from] service::get_user_delegation_key::Error),
    #[error(transparent)]
    Service_GetAccountInfo(#[from] service::get_account_info::Error),
    #[error(transparent)]
    Service_SubmitBatch(#[from] service::submit_batch::Error),
    #[error(transparent)]
    Service_FilterBlobs(#[from] service::filter_blobs::Error),
    #[error(transparent)]
    Container_GetProperties(#[from] container::get_properties::Error),
    #[error(transparent)]
    Container_Create(#[from] container::create::Error),
    #[error(transparent)]
    Container_Delete(#[from] container::delete::Error),
    #[error(transparent)]
    Container_SetMetadata(#[from] container::set_metadata::Error),
    #[error(transparent)]
    Container_GetAccessPolicy(#[from] container::get_access_policy::Error),
    #[error(transparent)]
    Container_SetAccessPolicy(#[from] container::set_access_policy::Error),
    #[error(transparent)]
    Container_Restore(#[from] container::restore::Error),
    #[error(transparent)]
    Container_Rename(#[from] container::rename::Error),
    #[error(transparent)]
    Container_SubmitBatch(#[from] container::submit_batch::Error),
    #[error(transparent)]
    Container_AcquireLease(#[from] container::acquire_lease::Error),
    #[error(transparent)]
    Container_ReleaseLease(#[from] container::release_lease::Error),
    #[error(transparent)]
    Container_RenewLease(#[from] container::renew_lease::Error),
    #[error(transparent)]
    Container_BreakLease(#[from] container::break_lease::Error),
    #[error(transparent)]
    Container_ChangeLease(#[from] container::change_lease::Error),
    #[error(transparent)]
    Container_ListBlobFlatSegment(#[from] container::list_blob_flat_segment::Error),
    #[error(transparent)]
    Container_ListBlobHierarchySegment(#[from] container::list_blob_hierarchy_segment::Error),
    #[error(transparent)]
    Container_GetAccountInfo(#[from] container::get_account_info::Error),
    #[error(transparent)]
    Blob_Download(#[from] blob::download::Error),
    #[error(transparent)]
    Blob_Delete(#[from] blob::delete::Error),
    #[error(transparent)]
    Blob_GetProperties(#[from] blob::get_properties::Error),
    #[error(transparent)]
    PageBlob_Create(#[from] page_blob::create::Error),
    #[error(transparent)]
    AppendBlob_Create(#[from] append_blob::create::Error),
    #[error(transparent)]
    BlockBlob_Upload(#[from] block_blob::upload::Error),
    #[error(transparent)]
    BlockBlob_PutBlobFromUrl(#[from] block_blob::put_blob_from_url::Error),
    #[error(transparent)]
    Blob_Undelete(#[from] blob::undelete::Error),
    #[error(transparent)]
    Blob_SetExpiry(#[from] blob::set_expiry::Error),
    #[error(transparent)]
    Blob_SetHttpHeaders(#[from] blob::set_http_headers::Error),
    #[error(transparent)]
    Blob_SetImmutabilityPolicy(#[from] blob::set_immutability_policy::Error),
    #[error(transparent)]
    Blob_DeleteImmutabilityPolicy(#[from] blob::delete_immutability_policy::Error),
    #[error(transparent)]
    Blob_SetLegalHold(#[from] blob::set_legal_hold::Error),
    #[error(transparent)]
    Blob_SetMetadata(#[from] blob::set_metadata::Error),
    #[error(transparent)]
    Blob_AcquireLease(#[from] blob::acquire_lease::Error),
    #[error(transparent)]
    Blob_ReleaseLease(#[from] blob::release_lease::Error),
    #[error(transparent)]
    Blob_RenewLease(#[from] blob::renew_lease::Error),
    #[error(transparent)]
    Blob_ChangeLease(#[from] blob::change_lease::Error),
    #[error(transparent)]
    Blob_BreakLease(#[from] blob::break_lease::Error),
    #[error(transparent)]
    Blob_CreateSnapshot(#[from] blob::create_snapshot::Error),
    #[error(transparent)]
    Blob_StartCopyFromUrl(#[from] blob::start_copy_from_url::Error),
    #[error(transparent)]
    Blob_CopyFromUrl(#[from] blob::copy_from_url::Error),
    #[error(transparent)]
    Blob_AbortCopyFromUrl(#[from] blob::abort_copy_from_url::Error),
    #[error(transparent)]
    Blob_SetTier(#[from] blob::set_tier::Error),
    #[error(transparent)]
    Blob_GetAccountInfo(#[from] blob::get_account_info::Error),
    #[error(transparent)]
    BlockBlob_StageBlock(#[from] block_blob::stage_block::Error),
    #[error(transparent)]
    BlockBlob_StageBlockFromUrl(#[from] block_blob::stage_block_from_url::Error),
    #[error(transparent)]
    BlockBlob_GetBlockList(#[from] block_blob::get_block_list::Error),
    #[error(transparent)]
    BlockBlob_CommitBlockList(#[from] block_blob::commit_block_list::Error),
    #[error(transparent)]
    PageBlob_UploadPages(#[from] page_blob::upload_pages::Error),
    #[error(transparent)]
    PageBlob_ClearPages(#[from] page_blob::clear_pages::Error),
    #[error(transparent)]
    PageBlob_UploadPagesFromUrl(#[from] page_blob::upload_pages_from_url::Error),
    #[error(transparent)]
    PageBlob_GetPageRanges(#[from] page_blob::get_page_ranges::Error),
    #[error(transparent)]
    PageBlob_GetPageRangesDiff(#[from] page_blob::get_page_ranges_diff::Error),
    #[error(transparent)]
    PageBlob_Resize(#[from] page_blob::resize::Error),
    #[error(transparent)]
    PageBlob_UpdateSequenceNumber(#[from] page_blob::update_sequence_number::Error),
    #[error(transparent)]
    PageBlob_CopyIncremental(#[from] page_blob::copy_incremental::Error),
    #[error(transparent)]
    AppendBlob_AppendBlock(#[from] append_blob::append_block::Error),
    #[error(transparent)]
    AppendBlob_AppendBlockFromUrl(#[from] append_blob::append_block_from_url::Error),
    #[error(transparent)]
    AppendBlob_Seal(#[from] append_blob::seal::Error),
    #[error(transparent)]
    Blob_Query(#[from] blob::query::Error),
    #[error(transparent)]
    Blob_GetTags(#[from] blob::get_tags::Error),
    #[error(transparent)]
    Blob_SetTags(#[from] blob::set_tags::Error),
}
pub mod service {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        pub fn get_properties(
            &self,
            restype: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> get_properties::Builder {
            get_properties::Builder {
                client: self.0.clone(),
                restype: restype.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn set_properties(
            &self,
            restype: impl Into<String>,
            comp: impl Into<String>,
            storage_service_properties: impl Into<models::StorageServiceProperties>,
            x_ms_version: impl Into<String>,
        ) -> set_properties::Builder {
            set_properties::Builder {
                client: self.0.clone(),
                restype: restype.into(),
                comp: comp.into(),
                storage_service_properties: storage_service_properties.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn get_statistics(
            &self,
            restype: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> get_statistics::Builder {
            get_statistics::Builder {
                client: self.0.clone(),
                restype: restype.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn list_containers_segment(
            &self,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> list_containers_segment::Builder {
            list_containers_segment::Builder {
                client: self.0.clone(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                prefix: None,
                marker: None,
                maxresults: None,
                include: Vec::new(),
                timeout: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn get_user_delegation_key(
            &self,
            restype: impl Into<String>,
            comp: impl Into<String>,
            key_info: impl Into<models::KeyInfo>,
            x_ms_version: impl Into<String>,
        ) -> get_user_delegation_key::Builder {
            get_user_delegation_key::Builder {
                client: self.0.clone(),
                restype: restype.into(),
                comp: comp.into(),
                key_info: key_info.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn get_account_info(
            &self,
            restype: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> get_account_info::Builder {
            get_account_info::Builder {
                client: self.0.clone(),
                restype: restype.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
            }
        }
        pub fn submit_batch(
            &self,
            comp: impl Into<String>,
            body: impl Into<serde_json::Value>,
            content_length: i64,
            content_type: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> submit_batch::Builder {
            submit_batch::Builder {
                client: self.0.clone(),
                comp: comp.into(),
                body: body.into(),
                content_length,
                content_type: content_type.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn filter_blobs(&self, comp: impl Into<String>, x_ms_version: impl Into<String>) -> filter_blobs::Builder {
            filter_blobs::Builder {
                client: self.0.clone(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_client_request_id: None,
                where_: None,
                marker: None,
                maxresults: None,
            }
        }
    }
    pub mod get_properties {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) restype: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::StorageServiceProperties, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/?restype=service&comp=properties", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageServiceProperties =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod set_properties {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) restype: String,
            pub(crate) comp: String,
            pub(crate) storage_service_properties: models::StorageServiceProperties,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/?restype=service&comp=properties", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.storage_service_properties).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_statistics {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) restype: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::StorageServiceStats, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/?restype=service&comp=stats", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageServiceStats =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_containers_segment {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) prefix: Option<String>,
            pub(crate) marker: Option<String>,
            pub(crate) maxresults: Option<i64>,
            pub(crate) include: Vec<String>,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn prefix(mut self, prefix: impl Into<String>) -> Self {
                self.prefix = Some(prefix.into());
                self
            }
            pub fn marker(mut self, marker: impl Into<String>) -> Self {
                self.marker = Some(marker.into());
                self
            }
            pub fn maxresults(mut self, maxresults: i64) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn include(mut self, include: Vec<String>) -> Self {
                self.include = include;
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ListContainersSegmentResponse, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/?comp=list", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(prefix) = &self.prefix {
                        url.query_pairs_mut().append_pair("prefix", prefix);
                    }
                    if let Some(marker) = &self.marker {
                        url.query_pairs_mut().append_pair("marker", marker);
                    }
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ListContainersSegmentResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_user_delegation_key {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) restype: String,
            pub(crate) comp: String,
            pub(crate) key_info: models::KeyInfo,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::UserDelegationKey, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/?restype=service&comp=userdelegationkey", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.key_info).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::UserDelegationKey =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_account_info {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) restype: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/?restype=account&comp=properties", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod submit_batch {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) comp: String,
            pub(crate) body: serde_json::Value,
            pub(crate) content_length: i64,
            pub(crate) content_type: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<serde_json::Value, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/?comp=batch", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    let req_body = azure_core::to_json(&self.body).map_err(Error::Serialize)?;
                    req_builder = req_builder.header("Content-Length", &self.content_length.to_string());
                    req_builder = req_builder.header("Content-Type", &self.content_type);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: serde_json::Value =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod filter_blobs {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) where_: Option<String>,
            pub(crate) marker: Option<String>,
            pub(crate) maxresults: Option<i64>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn where_(mut self, where_: impl Into<String>) -> Self {
                self.where_ = Some(where_.into());
                self
            }
            pub fn marker(mut self, marker: impl Into<String>) -> Self {
                self.marker = Some(marker.into());
                self
            }
            pub fn maxresults(mut self, maxresults: i64) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::FilterBlobSegment, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/?comp=blobs", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(where_) = &self.where_ {
                        url.query_pairs_mut().append_pair("where", where_);
                    }
                    if let Some(marker) = &self.marker {
                        url.query_pairs_mut().append_pair("marker", marker);
                    }
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::FilterBlobSegment =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod container {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        pub fn get_properties(
            &self,
            container_name: impl Into<String>,
            restype: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> get_properties::Builder {
            get_properties::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                restype: restype.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_lease_id: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn create(
            &self,
            container_name: impl Into<String>,
            restype: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> create::Builder {
            create::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                restype: restype.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_meta: None,
                x_ms_blob_public_access: None,
                x_ms_client_request_id: None,
                x_ms_default_encryption_scope: None,
                x_ms_deny_encryption_scope_override: None,
            }
        }
        pub fn delete(
            &self,
            container_name: impl Into<String>,
            restype: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> delete::Builder {
            delete::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                restype: restype.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_lease_id: None,
                if_modified_since: None,
                if_unmodified_since: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn set_metadata(
            &self,
            container_name: impl Into<String>,
            restype: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> set_metadata::Builder {
            set_metadata::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                restype: restype.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_lease_id: None,
                x_ms_meta: None,
                if_modified_since: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn get_access_policy(
            &self,
            container_name: impl Into<String>,
            restype: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> get_access_policy::Builder {
            get_access_policy::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                restype: restype.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_lease_id: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn set_access_policy(
            &self,
            container_name: impl Into<String>,
            restype: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> set_access_policy::Builder {
            set_access_policy::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                restype: restype.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                container_acl: None,
                timeout: None,
                x_ms_lease_id: None,
                x_ms_blob_public_access: None,
                if_modified_since: None,
                if_unmodified_since: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn restore(
            &self,
            container_name: impl Into<String>,
            restype: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> restore::Builder {
            restore::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                restype: restype.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_client_request_id: None,
                x_ms_deleted_container_name: None,
                x_ms_deleted_container_version: None,
            }
        }
        pub fn rename(
            &self,
            container_name: impl Into<String>,
            restype: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
            x_ms_source_container_name: impl Into<String>,
        ) -> rename::Builder {
            rename::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                restype: restype.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                x_ms_source_container_name: x_ms_source_container_name.into(),
                timeout: None,
                x_ms_client_request_id: None,
                x_ms_source_lease_id: None,
            }
        }
        pub fn submit_batch(
            &self,
            container_name: impl Into<String>,
            restype: impl Into<String>,
            comp: impl Into<String>,
            body: impl Into<serde_json::Value>,
            content_length: i64,
            content_type: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> submit_batch::Builder {
            submit_batch::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                restype: restype.into(),
                comp: comp.into(),
                body: body.into(),
                content_length,
                content_type: content_type.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn acquire_lease(
            &self,
            container_name: impl Into<String>,
            comp: impl Into<String>,
            restype: impl Into<String>,
            x_ms_lease_action: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> acquire_lease::Builder {
            acquire_lease::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                comp: comp.into(),
                restype: restype.into(),
                x_ms_lease_action: x_ms_lease_action.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_lease_duration: None,
                x_ms_proposed_lease_id: None,
                if_modified_since: None,
                if_unmodified_since: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn release_lease(
            &self,
            container_name: impl Into<String>,
            comp: impl Into<String>,
            restype: impl Into<String>,
            x_ms_lease_action: impl Into<String>,
            x_ms_lease_id: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> release_lease::Builder {
            release_lease::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                comp: comp.into(),
                restype: restype.into(),
                x_ms_lease_action: x_ms_lease_action.into(),
                x_ms_lease_id: x_ms_lease_id.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                if_modified_since: None,
                if_unmodified_since: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn renew_lease(
            &self,
            container_name: impl Into<String>,
            comp: impl Into<String>,
            restype: impl Into<String>,
            x_ms_lease_action: impl Into<String>,
            x_ms_lease_id: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> renew_lease::Builder {
            renew_lease::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                comp: comp.into(),
                restype: restype.into(),
                x_ms_lease_action: x_ms_lease_action.into(),
                x_ms_lease_id: x_ms_lease_id.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                if_modified_since: None,
                if_unmodified_since: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn break_lease(
            &self,
            container_name: impl Into<String>,
            comp: impl Into<String>,
            restype: impl Into<String>,
            x_ms_lease_action: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> break_lease::Builder {
            break_lease::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                comp: comp.into(),
                restype: restype.into(),
                x_ms_lease_action: x_ms_lease_action.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_lease_break_period: None,
                if_modified_since: None,
                if_unmodified_since: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn change_lease(
            &self,
            container_name: impl Into<String>,
            comp: impl Into<String>,
            restype: impl Into<String>,
            x_ms_lease_action: impl Into<String>,
            x_ms_lease_id: impl Into<String>,
            x_ms_proposed_lease_id: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> change_lease::Builder {
            change_lease::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                comp: comp.into(),
                restype: restype.into(),
                x_ms_lease_action: x_ms_lease_action.into(),
                x_ms_lease_id: x_ms_lease_id.into(),
                x_ms_proposed_lease_id: x_ms_proposed_lease_id.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                if_modified_since: None,
                if_unmodified_since: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn list_blob_flat_segment(
            &self,
            container_name: impl Into<String>,
            restype: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> list_blob_flat_segment::Builder {
            list_blob_flat_segment::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                restype: restype.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                prefix: None,
                marker: None,
                maxresults: None,
                include: Vec::new(),
                timeout: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn list_blob_hierarchy_segment(
            &self,
            container_name: impl Into<String>,
            restype: impl Into<String>,
            comp: impl Into<String>,
            delimiter: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> list_blob_hierarchy_segment::Builder {
            list_blob_hierarchy_segment::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                restype: restype.into(),
                comp: comp.into(),
                delimiter: delimiter.into(),
                x_ms_version: x_ms_version.into(),
                prefix: None,
                marker: None,
                maxresults: None,
                include: Vec::new(),
                timeout: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn get_account_info(
            &self,
            container_name: impl Into<String>,
            restype: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> get_account_info::Builder {
            get_account_info::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                restype: restype.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
            }
        }
    }
    pub mod get_properties {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) restype: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}?restype=container", self.client.endpoint(), &self.container_name);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) restype: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_meta: Option<String>,
            pub(crate) x_ms_blob_public_access: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_default_encryption_scope: Option<String>,
            pub(crate) x_ms_deny_encryption_scope_override: Option<bool>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_meta(mut self, x_ms_meta: impl Into<String>) -> Self {
                self.x_ms_meta = Some(x_ms_meta.into());
                self
            }
            pub fn x_ms_blob_public_access(mut self, x_ms_blob_public_access: impl Into<String>) -> Self {
                self.x_ms_blob_public_access = Some(x_ms_blob_public_access.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_default_encryption_scope(mut self, x_ms_default_encryption_scope: impl Into<String>) -> Self {
                self.x_ms_default_encryption_scope = Some(x_ms_default_encryption_scope.into());
                self
            }
            pub fn x_ms_deny_encryption_scope_override(mut self, x_ms_deny_encryption_scope_override: bool) -> Self {
                self.x_ms_deny_encryption_scope_override = Some(x_ms_deny_encryption_scope_override);
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}?restype=container", self.client.endpoint(), &self.container_name);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_meta) = &self.x_ms_meta {
                        req_builder = req_builder.header("x-ms-meta", x_ms_meta);
                    }
                    if let Some(x_ms_blob_public_access) = &self.x_ms_blob_public_access {
                        req_builder = req_builder.header("x-ms-blob-public-access", x_ms_blob_public_access);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(x_ms_default_encryption_scope) = &self.x_ms_default_encryption_scope {
                        req_builder = req_builder.header("x-ms-default-encryption-scope", x_ms_default_encryption_scope);
                    }
                    if let Some(x_ms_deny_encryption_scope_override) = &self.x_ms_deny_encryption_scope_override {
                        req_builder = req_builder.header(
                            "x-ms-deny-encryption-scope-override",
                            &x_ms_deny_encryption_scope_override.to_string(),
                        );
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) restype: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}?restype=container", self.client.endpoint(), &self.container_name);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod set_metadata {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) restype: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_meta: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_meta(mut self, x_ms_meta: impl Into<String>) -> Self {
                self.x_ms_meta = Some(x_ms_meta.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}?restype=container&comp=metadata",
                        self.client.endpoint(),
                        &self.container_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_meta) = &self.x_ms_meta {
                        req_builder = req_builder.header("x-ms-meta", x_ms_meta);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_access_policy {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) restype: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::SignedIdentifiers, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}?restype=container&comp=acl", self.client.endpoint(), &self.container_name);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::SignedIdentifiers =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod set_access_policy {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) restype: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) container_acl: Option<models::SignedIdentifiers>,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_blob_public_access: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn container_acl(mut self, container_acl: impl Into<models::SignedIdentifiers>) -> Self {
                self.container_acl = Some(container_acl.into());
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_blob_public_access(mut self, x_ms_blob_public_access: impl Into<String>) -> Self {
                self.x_ms_blob_public_access = Some(x_ms_blob_public_access.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}?restype=container&comp=acl", self.client.endpoint(), &self.container_name);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    let req_body = if let Some(container_acl) = &self.container_acl {
                        req_builder = req_builder.header("content-type", "application/json");
                        azure_core::to_json(container_acl).map_err(Error::Serialize)?
                    } else {
                        azure_core::EMPTY_BODY
                    };
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_blob_public_access) = &self.x_ms_blob_public_access {
                        req_builder = req_builder.header("x-ms-blob-public-access", x_ms_blob_public_access);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod restore {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) restype: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_deleted_container_name: Option<String>,
            pub(crate) x_ms_deleted_container_version: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_deleted_container_name(mut self, x_ms_deleted_container_name: impl Into<String>) -> Self {
                self.x_ms_deleted_container_name = Some(x_ms_deleted_container_name.into());
                self
            }
            pub fn x_ms_deleted_container_version(mut self, x_ms_deleted_container_version: impl Into<String>) -> Self {
                self.x_ms_deleted_container_version = Some(x_ms_deleted_container_version.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}?restype=container&comp=undelete",
                        self.client.endpoint(),
                        &self.container_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(x_ms_deleted_container_name) = &self.x_ms_deleted_container_name {
                        req_builder = req_builder.header("x-ms-deleted-container-name", x_ms_deleted_container_name);
                    }
                    if let Some(x_ms_deleted_container_version) = &self.x_ms_deleted_container_version {
                        req_builder = req_builder.header("x-ms-deleted-container-version", x_ms_deleted_container_version);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod rename {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) restype: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) x_ms_source_container_name: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_source_lease_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_source_lease_id(mut self, x_ms_source_lease_id: impl Into<String>) -> Self {
                self.x_ms_source_lease_id = Some(x_ms_source_lease_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}?restype=container&comp=rename", self.client.endpoint(), &self.container_name);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    req_builder = req_builder.header("x-ms-source-container-name", &self.x_ms_source_container_name);
                    if let Some(x_ms_source_lease_id) = &self.x_ms_source_lease_id {
                        req_builder = req_builder.header("x-ms-source-lease-id", x_ms_source_lease_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod submit_batch {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) restype: String,
            pub(crate) comp: String,
            pub(crate) body: serde_json::Value,
            pub(crate) content_length: i64,
            pub(crate) content_type: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<serde_json::Value, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}?restype=container&comp=batch", self.client.endpoint(), &self.container_name);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    let req_body = azure_core::to_json(&self.body).map_err(Error::Serialize)?;
                    req_builder = req_builder.header("Content-Length", &self.content_length.to_string());
                    req_builder = req_builder.header("Content-Type", &self.content_type);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: serde_json::Value =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod acquire_lease {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) comp: String,
            pub(crate) restype: String,
            pub(crate) x_ms_lease_action: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_duration: Option<i64>,
            pub(crate) x_ms_proposed_lease_id: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_duration(mut self, x_ms_lease_duration: i64) -> Self {
                self.x_ms_lease_duration = Some(x_ms_lease_duration);
                self
            }
            pub fn x_ms_proposed_lease_id(mut self, x_ms_proposed_lease_id: impl Into<String>) -> Self {
                self.x_ms_proposed_lease_id = Some(x_ms_proposed_lease_id.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}?comp=lease&restype=container&acquire",
                        self.client.endpoint(),
                        &self.container_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    req_builder = req_builder.header("x-ms-lease-action", &self.x_ms_lease_action);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_duration) = &self.x_ms_lease_duration {
                        req_builder = req_builder.header("x-ms-lease-duration", &x_ms_lease_duration.to_string());
                    }
                    if let Some(x_ms_proposed_lease_id) = &self.x_ms_proposed_lease_id {
                        req_builder = req_builder.header("x-ms-proposed-lease-id", x_ms_proposed_lease_id);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod release_lease {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) comp: String,
            pub(crate) restype: String,
            pub(crate) x_ms_lease_action: String,
            pub(crate) x_ms_lease_id: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}?comp=lease&restype=container&release",
                        self.client.endpoint(),
                        &self.container_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    req_builder = req_builder.header("x-ms-lease-action", &self.x_ms_lease_action);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-lease-id", &self.x_ms_lease_id);
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod renew_lease {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) comp: String,
            pub(crate) restype: String,
            pub(crate) x_ms_lease_action: String,
            pub(crate) x_ms_lease_id: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}?comp=lease&restype=container&renew",
                        self.client.endpoint(),
                        &self.container_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    req_builder = req_builder.header("x-ms-lease-action", &self.x_ms_lease_action);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-lease-id", &self.x_ms_lease_id);
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod break_lease {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) comp: String,
            pub(crate) restype: String,
            pub(crate) x_ms_lease_action: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_break_period: Option<i64>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_break_period(mut self, x_ms_lease_break_period: i64) -> Self {
                self.x_ms_lease_break_period = Some(x_ms_lease_break_period);
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}?comp=lease&restype=container&break",
                        self.client.endpoint(),
                        &self.container_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    req_builder = req_builder.header("x-ms-lease-action", &self.x_ms_lease_action);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_break_period) = &self.x_ms_lease_break_period {
                        req_builder = req_builder.header("x-ms-lease-break-period", &x_ms_lease_break_period.to_string());
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod change_lease {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) comp: String,
            pub(crate) restype: String,
            pub(crate) x_ms_lease_action: String,
            pub(crate) x_ms_lease_id: String,
            pub(crate) x_ms_proposed_lease_id: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}?comp=lease&restype=container&change",
                        self.client.endpoint(),
                        &self.container_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    req_builder = req_builder.header("x-ms-lease-action", &self.x_ms_lease_action);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-lease-id", &self.x_ms_lease_id);
                    req_builder = req_builder.header("x-ms-proposed-lease-id", &self.x_ms_proposed_lease_id);
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_blob_flat_segment {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) restype: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) prefix: Option<String>,
            pub(crate) marker: Option<String>,
            pub(crate) maxresults: Option<i64>,
            pub(crate) include: Vec<String>,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn prefix(mut self, prefix: impl Into<String>) -> Self {
                self.prefix = Some(prefix.into());
                self
            }
            pub fn marker(mut self, marker: impl Into<String>) -> Self {
                self.marker = Some(marker.into());
                self
            }
            pub fn maxresults(mut self, maxresults: i64) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn include(mut self, include: Vec<String>) -> Self {
                self.include = include;
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ListBlobsFlatSegmentResponse, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}?restype=container&comp=list&flat",
                        self.client.endpoint(),
                        &self.container_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(prefix) = &self.prefix {
                        url.query_pairs_mut().append_pair("prefix", prefix);
                    }
                    if let Some(marker) = &self.marker {
                        url.query_pairs_mut().append_pair("marker", marker);
                    }
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ListBlobsFlatSegmentResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_blob_hierarchy_segment {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) restype: String,
            pub(crate) comp: String,
            pub(crate) delimiter: String,
            pub(crate) x_ms_version: String,
            pub(crate) prefix: Option<String>,
            pub(crate) marker: Option<String>,
            pub(crate) maxresults: Option<i64>,
            pub(crate) include: Vec<String>,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn prefix(mut self, prefix: impl Into<String>) -> Self {
                self.prefix = Some(prefix.into());
                self
            }
            pub fn marker(mut self, marker: impl Into<String>) -> Self {
                self.marker = Some(marker.into());
                self
            }
            pub fn maxresults(mut self, maxresults: i64) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn include(mut self, include: Vec<String>) -> Self {
                self.include = include;
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ListBlobsHierarchySegmentResponse, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}?restype=container&comp=list&hierarchy",
                        self.client.endpoint(),
                        &self.container_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(prefix) = &self.prefix {
                        url.query_pairs_mut().append_pair("prefix", prefix);
                    }
                    let delimiter = &self.delimiter;
                    url.query_pairs_mut().append_pair("delimiter", delimiter);
                    if let Some(marker) = &self.marker {
                        url.query_pairs_mut().append_pair("marker", marker);
                    }
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ListBlobsHierarchySegmentResponse =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_account_info {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) restype: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}?restype=account&comp=properties",
                        self.client.endpoint(),
                        &self.container_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod blob {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        pub fn download(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> download::Builder {
            download::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                x_ms_version: x_ms_version.into(),
                snapshot: None,
                versionid: None,
                timeout: None,
                x_ms_range: None,
                x_ms_lease_id: None,
                x_ms_range_get_content_md5: None,
                x_ms_range_get_content_crc64: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn delete(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> delete::Builder {
            delete::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                x_ms_version: x_ms_version.into(),
                snapshot: None,
                versionid: None,
                timeout: None,
                x_ms_lease_id: None,
                x_ms_delete_snapshots: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
                deletetype: None,
            }
        }
        pub fn get_properties(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> get_properties::Builder {
            get_properties::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                x_ms_version: x_ms_version.into(),
                snapshot: None,
                versionid: None,
                timeout: None,
                x_ms_lease_id: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn undelete(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> undelete::Builder {
            undelete::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn set_expiry(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
            x_ms_expiry_option: impl Into<String>,
        ) -> set_expiry::Builder {
            set_expiry::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                x_ms_expiry_option: x_ms_expiry_option.into(),
                timeout: None,
                x_ms_client_request_id: None,
                x_ms_expiry_time: None,
            }
        }
        pub fn set_http_headers(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> set_http_headers::Builder {
            set_http_headers::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_blob_cache_control: None,
                x_ms_blob_content_type: None,
                x_ms_blob_content_md5: None,
                x_ms_blob_content_encoding: None,
                x_ms_blob_content_language: None,
                x_ms_lease_id: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_blob_content_disposition: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn set_immutability_policy(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> set_immutability_policy::Builder {
            set_immutability_policy::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_client_request_id: None,
                if_unmodified_since: None,
                x_ms_immutability_policy_until_date: None,
                x_ms_immutability_policy_mode: None,
            }
        }
        pub fn delete_immutability_policy(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> delete_immutability_policy::Builder {
            delete_immutability_policy::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn set_legal_hold(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
            x_ms_legal_hold: bool,
        ) -> set_legal_hold::Builder {
            set_legal_hold::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                x_ms_legal_hold,
                timeout: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn set_metadata(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> set_metadata::Builder {
            set_metadata::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_meta: None,
                x_ms_lease_id: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                x_ms_encryption_scope: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn acquire_lease(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_lease_action: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> acquire_lease::Builder {
            acquire_lease::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_lease_action: x_ms_lease_action.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_lease_duration: None,
                x_ms_proposed_lease_id: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn release_lease(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_lease_action: impl Into<String>,
            x_ms_lease_id: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> release_lease::Builder {
            release_lease::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_lease_action: x_ms_lease_action.into(),
                x_ms_lease_id: x_ms_lease_id.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn renew_lease(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_lease_action: impl Into<String>,
            x_ms_lease_id: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> renew_lease::Builder {
            renew_lease::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_lease_action: x_ms_lease_action.into(),
                x_ms_lease_id: x_ms_lease_id.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn change_lease(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_lease_action: impl Into<String>,
            x_ms_lease_id: impl Into<String>,
            x_ms_proposed_lease_id: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> change_lease::Builder {
            change_lease::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_lease_action: x_ms_lease_action.into(),
                x_ms_lease_id: x_ms_lease_id.into(),
                x_ms_proposed_lease_id: x_ms_proposed_lease_id.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn break_lease(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_lease_action: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> break_lease::Builder {
            break_lease::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_lease_action: x_ms_lease_action.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_lease_break_period: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn create_snapshot(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> create_snapshot::Builder {
            create_snapshot::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_meta: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                x_ms_encryption_scope: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_lease_id: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn start_copy_from_url(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            x_ms_copy_source: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> start_copy_from_url::Builder {
            start_copy_from_url::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                x_ms_copy_source: x_ms_copy_source.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_meta: None,
                x_ms_access_tier: None,
                x_ms_rehydrate_priority: None,
                x_ms_source_if_modified_since: None,
                x_ms_source_if_unmodified_since: None,
                x_ms_source_if_match: None,
                x_ms_source_if_none_match: None,
                x_ms_source_if_tags: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_lease_id: None,
                x_ms_client_request_id: None,
                x_ms_tags: None,
                x_ms_seal_blob: None,
                x_ms_immutability_policy_until_date: None,
                x_ms_immutability_policy_mode: None,
                x_ms_legal_hold: None,
            }
        }
        pub fn copy_from_url(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            x_ms_requires_sync: impl Into<String>,
            x_ms_copy_source: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> copy_from_url::Builder {
            copy_from_url::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                x_ms_requires_sync: x_ms_requires_sync.into(),
                x_ms_copy_source: x_ms_copy_source.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_meta: None,
                x_ms_access_tier: None,
                x_ms_source_if_modified_since: None,
                x_ms_source_if_unmodified_since: None,
                x_ms_source_if_match: None,
                x_ms_source_if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_lease_id: None,
                x_ms_client_request_id: None,
                x_ms_source_content_md5: None,
                x_ms_tags: None,
                x_ms_immutability_policy_until_date: None,
                x_ms_immutability_policy_mode: None,
                x_ms_legal_hold: None,
                x_ms_copy_source_authorization: None,
            }
        }
        pub fn abort_copy_from_url(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_copy_action: impl Into<String>,
            copyid: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> abort_copy_from_url::Builder {
            abort_copy_from_url::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_copy_action: x_ms_copy_action.into(),
                copyid: copyid.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_lease_id: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn set_tier(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_access_tier: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> set_tier::Builder {
            set_tier::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_access_tier: x_ms_access_tier.into(),
                x_ms_version: x_ms_version.into(),
                snapshot: None,
                versionid: None,
                timeout: None,
                x_ms_rehydrate_priority: None,
                x_ms_client_request_id: None,
                x_ms_lease_id: None,
                x_ms_if_tags: None,
            }
        }
        pub fn get_account_info(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            restype: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> get_account_info::Builder {
            get_account_info::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                restype: restype.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
            }
        }
        pub fn query(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> query::Builder {
            query::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                query_request: None,
                snapshot: None,
                timeout: None,
                x_ms_lease_id: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn get_tags(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> get_tags::Builder {
            get_tags::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_client_request_id: None,
                snapshot: None,
                versionid: None,
                x_ms_if_tags: None,
                x_ms_lease_id: None,
            }
        }
        pub fn set_tags(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> set_tags::Builder {
            set_tags::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                versionid: None,
                content_md5: None,
                x_ms_content_crc64: None,
                x_ms_client_request_id: None,
                x_ms_if_tags: None,
                x_ms_lease_id: None,
                tags: None,
            }
        }
    }
    pub mod download {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200(serde_json::Value),
            PartialContent206(serde_json::Value),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) x_ms_version: String,
            pub(crate) snapshot: Option<String>,
            pub(crate) versionid: Option<String>,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_range: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_range_get_content_md5: Option<bool>,
            pub(crate) x_ms_range_get_content_crc64: Option<bool>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn snapshot(mut self, snapshot: impl Into<String>) -> Self {
                self.snapshot = Some(snapshot.into());
                self
            }
            pub fn versionid(mut self, versionid: impl Into<String>) -> Self {
                self.versionid = Some(versionid.into());
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_range(mut self, x_ms_range: impl Into<String>) -> Self {
                self.x_ms_range = Some(x_ms_range.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_range_get_content_md5(mut self, x_ms_range_get_content_md5: bool) -> Self {
                self.x_ms_range_get_content_md5 = Some(x_ms_range_get_content_md5);
                self
            }
            pub fn x_ms_range_get_content_crc64(mut self, x_ms_range_get_content_crc64: bool) -> Self {
                self.x_ms_range_get_content_crc64 = Some(x_ms_range_get_content_crc64);
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    if let Some(snapshot) = &self.snapshot {
                        url.query_pairs_mut().append_pair("snapshot", snapshot);
                    }
                    if let Some(versionid) = &self.versionid {
                        url.query_pairs_mut().append_pair("versionid", versionid);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_range) = &self.x_ms_range {
                        req_builder = req_builder.header("x-ms-range", x_ms_range);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_range_get_content_md5) = &self.x_ms_range_get_content_md5 {
                        req_builder = req_builder.header("x-ms-range-get-content-md5", &x_ms_range_get_content_md5.to_string());
                    }
                    if let Some(x_ms_range_get_content_crc64) = &self.x_ms_range_get_content_crc64 {
                        req_builder = req_builder.header("x-ms-range-get-content-crc64", &x_ms_range_get_content_crc64.to_string());
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: serde_json::Value =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Ok200(rsp_value))
                        }
                        http::StatusCode::PARTIAL_CONTENT => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: serde_json::Value =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::PartialContent206(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) x_ms_version: String,
            pub(crate) snapshot: Option<String>,
            pub(crate) versionid: Option<String>,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_delete_snapshots: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) deletetype: Option<String>,
        }
        impl Builder {
            pub fn snapshot(mut self, snapshot: impl Into<String>) -> Self {
                self.snapshot = Some(snapshot.into());
                self
            }
            pub fn versionid(mut self, versionid: impl Into<String>) -> Self {
                self.versionid = Some(versionid.into());
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_delete_snapshots(mut self, x_ms_delete_snapshots: impl Into<String>) -> Self {
                self.x_ms_delete_snapshots = Some(x_ms_delete_snapshots.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn deletetype(mut self, deletetype: impl Into<String>) -> Self {
                self.deletetype = Some(deletetype.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    if let Some(snapshot) = &self.snapshot {
                        url.query_pairs_mut().append_pair("snapshot", snapshot);
                    }
                    if let Some(versionid) = &self.versionid {
                        url.query_pairs_mut().append_pair("versionid", versionid);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_delete_snapshots) = &self.x_ms_delete_snapshots {
                        req_builder = req_builder.header("x-ms-delete-snapshots", x_ms_delete_snapshots);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(deletetype) = &self.deletetype {
                        url.query_pairs_mut().append_pair("deletetype", deletetype);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_properties {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) x_ms_version: String,
            pub(crate) snapshot: Option<String>,
            pub(crate) versionid: Option<String>,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn snapshot(mut self, snapshot: impl Into<String>) -> Self {
                self.snapshot = Some(snapshot.into());
                self
            }
            pub fn versionid(mut self, versionid: impl Into<String>) -> Self {
                self.versionid = Some(versionid.into());
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::HEAD);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    if let Some(snapshot) = &self.snapshot {
                        url.query_pairs_mut().append_pair("snapshot", snapshot);
                    }
                    if let Some(versionid) = &self.versionid {
                        url.query_pairs_mut().append_pair("versionid", versionid);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod undelete {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=undelete", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod set_expiry {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) x_ms_expiry_option: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_expiry_time: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_expiry_time(mut self, x_ms_expiry_time: impl Into<String>) -> Self {
                self.x_ms_expiry_time = Some(x_ms_expiry_time.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=expiry", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    req_builder = req_builder.header("x-ms-expiry-option", &self.x_ms_expiry_option);
                    if let Some(x_ms_expiry_time) = &self.x_ms_expiry_time {
                        req_builder = req_builder.header("x-ms-expiry-time", x_ms_expiry_time);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod set_http_headers {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_blob_cache_control: Option<String>,
            pub(crate) x_ms_blob_content_type: Option<String>,
            pub(crate) x_ms_blob_content_md5: Option<String>,
            pub(crate) x_ms_blob_content_encoding: Option<String>,
            pub(crate) x_ms_blob_content_language: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_blob_content_disposition: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_blob_cache_control(mut self, x_ms_blob_cache_control: impl Into<String>) -> Self {
                self.x_ms_blob_cache_control = Some(x_ms_blob_cache_control.into());
                self
            }
            pub fn x_ms_blob_content_type(mut self, x_ms_blob_content_type: impl Into<String>) -> Self {
                self.x_ms_blob_content_type = Some(x_ms_blob_content_type.into());
                self
            }
            pub fn x_ms_blob_content_md5(mut self, x_ms_blob_content_md5: impl Into<String>) -> Self {
                self.x_ms_blob_content_md5 = Some(x_ms_blob_content_md5.into());
                self
            }
            pub fn x_ms_blob_content_encoding(mut self, x_ms_blob_content_encoding: impl Into<String>) -> Self {
                self.x_ms_blob_content_encoding = Some(x_ms_blob_content_encoding.into());
                self
            }
            pub fn x_ms_blob_content_language(mut self, x_ms_blob_content_language: impl Into<String>) -> Self {
                self.x_ms_blob_content_language = Some(x_ms_blob_content_language.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_blob_content_disposition(mut self, x_ms_blob_content_disposition: impl Into<String>) -> Self {
                self.x_ms_blob_content_disposition = Some(x_ms_blob_content_disposition.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=properties&SetHTTPHeaders",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_blob_cache_control) = &self.x_ms_blob_cache_control {
                        req_builder = req_builder.header("x-ms-blob-cache-control", x_ms_blob_cache_control);
                    }
                    if let Some(x_ms_blob_content_type) = &self.x_ms_blob_content_type {
                        req_builder = req_builder.header("x-ms-blob-content-type", x_ms_blob_content_type);
                    }
                    if let Some(x_ms_blob_content_md5) = &self.x_ms_blob_content_md5 {
                        req_builder = req_builder.header("x-ms-blob-content-md5", x_ms_blob_content_md5);
                    }
                    if let Some(x_ms_blob_content_encoding) = &self.x_ms_blob_content_encoding {
                        req_builder = req_builder.header("x-ms-blob-content-encoding", x_ms_blob_content_encoding);
                    }
                    if let Some(x_ms_blob_content_language) = &self.x_ms_blob_content_language {
                        req_builder = req_builder.header("x-ms-blob-content-language", x_ms_blob_content_language);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    if let Some(x_ms_blob_content_disposition) = &self.x_ms_blob_content_disposition {
                        req_builder = req_builder.header("x-ms-blob-content-disposition", x_ms_blob_content_disposition);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod set_immutability_policy {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) x_ms_immutability_policy_until_date: Option<String>,
            pub(crate) x_ms_immutability_policy_mode: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn x_ms_immutability_policy_until_date(mut self, x_ms_immutability_policy_until_date: impl Into<String>) -> Self {
                self.x_ms_immutability_policy_until_date = Some(x_ms_immutability_policy_until_date.into());
                self
            }
            pub fn x_ms_immutability_policy_mode(mut self, x_ms_immutability_policy_mode: impl Into<String>) -> Self {
                self.x_ms_immutability_policy_mode = Some(x_ms_immutability_policy_mode.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=immutabilityPolicies",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(x_ms_immutability_policy_until_date) = &self.x_ms_immutability_policy_until_date {
                        req_builder = req_builder.header("x-ms-immutability-policy-until-date", x_ms_immutability_policy_until_date);
                    }
                    if let Some(x_ms_immutability_policy_mode) = &self.x_ms_immutability_policy_mode {
                        req_builder = req_builder.header("x-ms-immutability-policy-mode", x_ms_immutability_policy_mode);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_immutability_policy {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=immutabilityPolicies",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod set_legal_hold {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) x_ms_legal_hold: bool,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=legalhold", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    req_builder = req_builder.header("x-ms-legal-hold", &self.x_ms_legal_hold.to_string());
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod set_metadata {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_meta: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) x_ms_encryption_scope: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_meta(mut self, x_ms_meta: impl Into<String>) -> Self {
                self.x_ms_meta = Some(x_ms_meta.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn x_ms_encryption_scope(mut self, x_ms_encryption_scope: impl Into<String>) -> Self {
                self.x_ms_encryption_scope = Some(x_ms_encryption_scope.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=metadata", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_meta) = &self.x_ms_meta {
                        req_builder = req_builder.header("x-ms-meta", x_ms_meta);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(x_ms_encryption_scope) = &self.x_ms_encryption_scope {
                        req_builder = req_builder.header("x-ms-encryption-scope", x_ms_encryption_scope);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod acquire_lease {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_lease_action: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_duration: Option<i64>,
            pub(crate) x_ms_proposed_lease_id: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_duration(mut self, x_ms_lease_duration: i64) -> Self {
                self.x_ms_lease_duration = Some(x_ms_lease_duration);
                self
            }
            pub fn x_ms_proposed_lease_id(mut self, x_ms_proposed_lease_id: impl Into<String>) -> Self {
                self.x_ms_proposed_lease_id = Some(x_ms_proposed_lease_id.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=lease&acquire",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("x-ms-lease-action", &self.x_ms_lease_action);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_duration) = &self.x_ms_lease_duration {
                        req_builder = req_builder.header("x-ms-lease-duration", &x_ms_lease_duration.to_string());
                    }
                    if let Some(x_ms_proposed_lease_id) = &self.x_ms_proposed_lease_id {
                        req_builder = req_builder.header("x-ms-proposed-lease-id", x_ms_proposed_lease_id);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod release_lease {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_lease_action: String,
            pub(crate) x_ms_lease_id: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=lease&release",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("x-ms-lease-action", &self.x_ms_lease_action);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-lease-id", &self.x_ms_lease_id);
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod renew_lease {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_lease_action: String,
            pub(crate) x_ms_lease_id: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=lease&renew",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("x-ms-lease-action", &self.x_ms_lease_action);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-lease-id", &self.x_ms_lease_id);
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod change_lease {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_lease_action: String,
            pub(crate) x_ms_lease_id: String,
            pub(crate) x_ms_proposed_lease_id: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=lease&change",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("x-ms-lease-action", &self.x_ms_lease_action);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-lease-id", &self.x_ms_lease_id);
                    req_builder = req_builder.header("x-ms-proposed-lease-id", &self.x_ms_proposed_lease_id);
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod break_lease {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_lease_action: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_break_period: Option<i64>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_break_period(mut self, x_ms_lease_break_period: i64) -> Self {
                self.x_ms_lease_break_period = Some(x_ms_lease_break_period);
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=lease&break",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("x-ms-lease-action", &self.x_ms_lease_action);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_break_period) = &self.x_ms_lease_break_period {
                        req_builder = req_builder.header("x-ms-lease-break-period", &x_ms_lease_break_period.to_string());
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod create_snapshot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_meta: Option<String>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) x_ms_encryption_scope: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_meta(mut self, x_ms_meta: impl Into<String>) -> Self {
                self.x_ms_meta = Some(x_ms_meta.into());
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn x_ms_encryption_scope(mut self, x_ms_encryption_scope: impl Into<String>) -> Self {
                self.x_ms_encryption_scope = Some(x_ms_encryption_scope.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=snapshot", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_meta) = &self.x_ms_meta {
                        req_builder = req_builder.header("x-ms-meta", x_ms_meta);
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(x_ms_encryption_scope) = &self.x_ms_encryption_scope {
                        req_builder = req_builder.header("x-ms-encryption-scope", x_ms_encryption_scope);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod start_copy_from_url {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) x_ms_copy_source: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_meta: Option<String>,
            pub(crate) x_ms_access_tier: Option<String>,
            pub(crate) x_ms_rehydrate_priority: Option<String>,
            pub(crate) x_ms_source_if_modified_since: Option<String>,
            pub(crate) x_ms_source_if_unmodified_since: Option<String>,
            pub(crate) x_ms_source_if_match: Option<String>,
            pub(crate) x_ms_source_if_none_match: Option<String>,
            pub(crate) x_ms_source_if_tags: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_tags: Option<String>,
            pub(crate) x_ms_seal_blob: Option<bool>,
            pub(crate) x_ms_immutability_policy_until_date: Option<String>,
            pub(crate) x_ms_immutability_policy_mode: Option<String>,
            pub(crate) x_ms_legal_hold: Option<bool>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_meta(mut self, x_ms_meta: impl Into<String>) -> Self {
                self.x_ms_meta = Some(x_ms_meta.into());
                self
            }
            pub fn x_ms_access_tier(mut self, x_ms_access_tier: impl Into<String>) -> Self {
                self.x_ms_access_tier = Some(x_ms_access_tier.into());
                self
            }
            pub fn x_ms_rehydrate_priority(mut self, x_ms_rehydrate_priority: impl Into<String>) -> Self {
                self.x_ms_rehydrate_priority = Some(x_ms_rehydrate_priority.into());
                self
            }
            pub fn x_ms_source_if_modified_since(mut self, x_ms_source_if_modified_since: impl Into<String>) -> Self {
                self.x_ms_source_if_modified_since = Some(x_ms_source_if_modified_since.into());
                self
            }
            pub fn x_ms_source_if_unmodified_since(mut self, x_ms_source_if_unmodified_since: impl Into<String>) -> Self {
                self.x_ms_source_if_unmodified_since = Some(x_ms_source_if_unmodified_since.into());
                self
            }
            pub fn x_ms_source_if_match(mut self, x_ms_source_if_match: impl Into<String>) -> Self {
                self.x_ms_source_if_match = Some(x_ms_source_if_match.into());
                self
            }
            pub fn x_ms_source_if_none_match(mut self, x_ms_source_if_none_match: impl Into<String>) -> Self {
                self.x_ms_source_if_none_match = Some(x_ms_source_if_none_match.into());
                self
            }
            pub fn x_ms_source_if_tags(mut self, x_ms_source_if_tags: impl Into<String>) -> Self {
                self.x_ms_source_if_tags = Some(x_ms_source_if_tags.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_tags(mut self, x_ms_tags: impl Into<String>) -> Self {
                self.x_ms_tags = Some(x_ms_tags.into());
                self
            }
            pub fn x_ms_seal_blob(mut self, x_ms_seal_blob: bool) -> Self {
                self.x_ms_seal_blob = Some(x_ms_seal_blob);
                self
            }
            pub fn x_ms_immutability_policy_until_date(mut self, x_ms_immutability_policy_until_date: impl Into<String>) -> Self {
                self.x_ms_immutability_policy_until_date = Some(x_ms_immutability_policy_until_date.into());
                self
            }
            pub fn x_ms_immutability_policy_mode(mut self, x_ms_immutability_policy_mode: impl Into<String>) -> Self {
                self.x_ms_immutability_policy_mode = Some(x_ms_immutability_policy_mode.into());
                self
            }
            pub fn x_ms_legal_hold(mut self, x_ms_legal_hold: bool) -> Self {
                self.x_ms_legal_hold = Some(x_ms_legal_hold);
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=copy", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_meta) = &self.x_ms_meta {
                        req_builder = req_builder.header("x-ms-meta", x_ms_meta);
                    }
                    if let Some(x_ms_access_tier) = &self.x_ms_access_tier {
                        req_builder = req_builder.header("x-ms-access-tier", x_ms_access_tier);
                    }
                    if let Some(x_ms_rehydrate_priority) = &self.x_ms_rehydrate_priority {
                        req_builder = req_builder.header("x-ms-rehydrate-priority", x_ms_rehydrate_priority);
                    }
                    if let Some(x_ms_source_if_modified_since) = &self.x_ms_source_if_modified_since {
                        req_builder = req_builder.header("x-ms-source-if-modified-since", x_ms_source_if_modified_since);
                    }
                    if let Some(x_ms_source_if_unmodified_since) = &self.x_ms_source_if_unmodified_since {
                        req_builder = req_builder.header("x-ms-source-if-unmodified-since", x_ms_source_if_unmodified_since);
                    }
                    if let Some(x_ms_source_if_match) = &self.x_ms_source_if_match {
                        req_builder = req_builder.header("x-ms-source-if-match", x_ms_source_if_match);
                    }
                    if let Some(x_ms_source_if_none_match) = &self.x_ms_source_if_none_match {
                        req_builder = req_builder.header("x-ms-source-if-none-match", x_ms_source_if_none_match);
                    }
                    if let Some(x_ms_source_if_tags) = &self.x_ms_source_if_tags {
                        req_builder = req_builder.header("x-ms-source-if-tags", x_ms_source_if_tags);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-copy-source", &self.x_ms_copy_source);
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(x_ms_tags) = &self.x_ms_tags {
                        req_builder = req_builder.header("x-ms-tags", x_ms_tags);
                    }
                    if let Some(x_ms_seal_blob) = &self.x_ms_seal_blob {
                        req_builder = req_builder.header("x-ms-seal-blob", &x_ms_seal_blob.to_string());
                    }
                    if let Some(x_ms_immutability_policy_until_date) = &self.x_ms_immutability_policy_until_date {
                        req_builder = req_builder.header("x-ms-immutability-policy-until-date", x_ms_immutability_policy_until_date);
                    }
                    if let Some(x_ms_immutability_policy_mode) = &self.x_ms_immutability_policy_mode {
                        req_builder = req_builder.header("x-ms-immutability-policy-mode", x_ms_immutability_policy_mode);
                    }
                    if let Some(x_ms_legal_hold) = &self.x_ms_legal_hold {
                        req_builder = req_builder.header("x-ms-legal-hold", &x_ms_legal_hold.to_string());
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod copy_from_url {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) x_ms_requires_sync: String,
            pub(crate) x_ms_copy_source: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_meta: Option<String>,
            pub(crate) x_ms_access_tier: Option<String>,
            pub(crate) x_ms_source_if_modified_since: Option<String>,
            pub(crate) x_ms_source_if_unmodified_since: Option<String>,
            pub(crate) x_ms_source_if_match: Option<String>,
            pub(crate) x_ms_source_if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_source_content_md5: Option<String>,
            pub(crate) x_ms_tags: Option<String>,
            pub(crate) x_ms_immutability_policy_until_date: Option<String>,
            pub(crate) x_ms_immutability_policy_mode: Option<String>,
            pub(crate) x_ms_legal_hold: Option<bool>,
            pub(crate) x_ms_copy_source_authorization: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_meta(mut self, x_ms_meta: impl Into<String>) -> Self {
                self.x_ms_meta = Some(x_ms_meta.into());
                self
            }
            pub fn x_ms_access_tier(mut self, x_ms_access_tier: impl Into<String>) -> Self {
                self.x_ms_access_tier = Some(x_ms_access_tier.into());
                self
            }
            pub fn x_ms_source_if_modified_since(mut self, x_ms_source_if_modified_since: impl Into<String>) -> Self {
                self.x_ms_source_if_modified_since = Some(x_ms_source_if_modified_since.into());
                self
            }
            pub fn x_ms_source_if_unmodified_since(mut self, x_ms_source_if_unmodified_since: impl Into<String>) -> Self {
                self.x_ms_source_if_unmodified_since = Some(x_ms_source_if_unmodified_since.into());
                self
            }
            pub fn x_ms_source_if_match(mut self, x_ms_source_if_match: impl Into<String>) -> Self {
                self.x_ms_source_if_match = Some(x_ms_source_if_match.into());
                self
            }
            pub fn x_ms_source_if_none_match(mut self, x_ms_source_if_none_match: impl Into<String>) -> Self {
                self.x_ms_source_if_none_match = Some(x_ms_source_if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_source_content_md5(mut self, x_ms_source_content_md5: impl Into<String>) -> Self {
                self.x_ms_source_content_md5 = Some(x_ms_source_content_md5.into());
                self
            }
            pub fn x_ms_tags(mut self, x_ms_tags: impl Into<String>) -> Self {
                self.x_ms_tags = Some(x_ms_tags.into());
                self
            }
            pub fn x_ms_immutability_policy_until_date(mut self, x_ms_immutability_policy_until_date: impl Into<String>) -> Self {
                self.x_ms_immutability_policy_until_date = Some(x_ms_immutability_policy_until_date.into());
                self
            }
            pub fn x_ms_immutability_policy_mode(mut self, x_ms_immutability_policy_mode: impl Into<String>) -> Self {
                self.x_ms_immutability_policy_mode = Some(x_ms_immutability_policy_mode.into());
                self
            }
            pub fn x_ms_legal_hold(mut self, x_ms_legal_hold: bool) -> Self {
                self.x_ms_legal_hold = Some(x_ms_legal_hold);
                self
            }
            pub fn x_ms_copy_source_authorization(mut self, x_ms_copy_source_authorization: impl Into<String>) -> Self {
                self.x_ms_copy_source_authorization = Some(x_ms_copy_source_authorization.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=copy&sync", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    req_builder = req_builder.header("x-ms-requires-sync", &self.x_ms_requires_sync);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_meta) = &self.x_ms_meta {
                        req_builder = req_builder.header("x-ms-meta", x_ms_meta);
                    }
                    if let Some(x_ms_access_tier) = &self.x_ms_access_tier {
                        req_builder = req_builder.header("x-ms-access-tier", x_ms_access_tier);
                    }
                    if let Some(x_ms_source_if_modified_since) = &self.x_ms_source_if_modified_since {
                        req_builder = req_builder.header("x-ms-source-if-modified-since", x_ms_source_if_modified_since);
                    }
                    if let Some(x_ms_source_if_unmodified_since) = &self.x_ms_source_if_unmodified_since {
                        req_builder = req_builder.header("x-ms-source-if-unmodified-since", x_ms_source_if_unmodified_since);
                    }
                    if let Some(x_ms_source_if_match) = &self.x_ms_source_if_match {
                        req_builder = req_builder.header("x-ms-source-if-match", x_ms_source_if_match);
                    }
                    if let Some(x_ms_source_if_none_match) = &self.x_ms_source_if_none_match {
                        req_builder = req_builder.header("x-ms-source-if-none-match", x_ms_source_if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-copy-source", &self.x_ms_copy_source);
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(x_ms_source_content_md5) = &self.x_ms_source_content_md5 {
                        req_builder = req_builder.header("x-ms-source-content-md5", x_ms_source_content_md5);
                    }
                    if let Some(x_ms_tags) = &self.x_ms_tags {
                        req_builder = req_builder.header("x-ms-tags", x_ms_tags);
                    }
                    if let Some(x_ms_immutability_policy_until_date) = &self.x_ms_immutability_policy_until_date {
                        req_builder = req_builder.header("x-ms-immutability-policy-until-date", x_ms_immutability_policy_until_date);
                    }
                    if let Some(x_ms_immutability_policy_mode) = &self.x_ms_immutability_policy_mode {
                        req_builder = req_builder.header("x-ms-immutability-policy-mode", x_ms_immutability_policy_mode);
                    }
                    if let Some(x_ms_legal_hold) = &self.x_ms_legal_hold {
                        req_builder = req_builder.header("x-ms-legal-hold", &x_ms_legal_hold.to_string());
                    }
                    if let Some(x_ms_copy_source_authorization) = &self.x_ms_copy_source_authorization {
                        req_builder = req_builder.header("x-ms-copy-source-authorization", x_ms_copy_source_authorization);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod abort_copy_from_url {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_copy_action: String,
            pub(crate) copyid: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=copy&copyid",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("x-ms-copy-action", &self.x_ms_copy_action);
                    let copyid = &self.copyid;
                    url.query_pairs_mut().append_pair("copyid", copyid);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod set_tier {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200,
            Accepted202,
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_access_tier: String,
            pub(crate) x_ms_version: String,
            pub(crate) snapshot: Option<String>,
            pub(crate) versionid: Option<String>,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_rehydrate_priority: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
        }
        impl Builder {
            pub fn snapshot(mut self, snapshot: impl Into<String>) -> Self {
                self.snapshot = Some(snapshot.into());
                self
            }
            pub fn versionid(mut self, versionid: impl Into<String>) -> Self {
                self.versionid = Some(versionid.into());
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_rehydrate_priority(mut self, x_ms_rehydrate_priority: impl Into<String>) -> Self {
                self.x_ms_rehydrate_priority = Some(x_ms_rehydrate_priority.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=tier", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(snapshot) = &self.snapshot {
                        url.query_pairs_mut().append_pair("snapshot", snapshot);
                    }
                    if let Some(versionid) = &self.versionid {
                        url.query_pairs_mut().append_pair("versionid", versionid);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-access-tier", &self.x_ms_access_tier);
                    if let Some(x_ms_rehydrate_priority) = &self.x_ms_rehydrate_priority {
                        req_builder = req_builder.header("x-ms-rehydrate-priority", x_ms_rehydrate_priority);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(Response::Ok200),
                        http::StatusCode::ACCEPTED => Ok(Response::Accepted202),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_account_info {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) restype: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
        }
        impl Builder {
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?restype=account&comp=properties",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let restype = &self.restype;
                    url.query_pairs_mut().append_pair("restype", restype);
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod query {
        use super::models;
        #[derive(Debug)]
        pub enum Response {
            Ok200(serde_json::Value),
            PartialContent206(serde_json::Value),
        }
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) query_request: Option<models::QueryRequest>,
            pub(crate) snapshot: Option<String>,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn query_request(mut self, query_request: impl Into<models::QueryRequest>) -> Self {
                self.query_request = Some(query_request.into());
                self
            }
            pub fn snapshot(mut self, snapshot: impl Into<String>) -> Self {
                self.snapshot = Some(snapshot.into());
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=query", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    let req_body = if let Some(query_request) = &self.query_request {
                        req_builder = req_builder.header("content-type", "application/json");
                        azure_core::to_json(query_request).map_err(Error::Serialize)?
                    } else {
                        azure_core::EMPTY_BODY
                    };
                    if let Some(snapshot) = &self.snapshot {
                        url.query_pairs_mut().append_pair("snapshot", snapshot);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: serde_json::Value =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::Ok200(rsp_value))
                        }
                        http::StatusCode::PARTIAL_CONTENT => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: serde_json::Value =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(Response::PartialContent206(rsp_value))
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_tags {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) snapshot: Option<String>,
            pub(crate) versionid: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn snapshot(mut self, snapshot: impl Into<String>) -> Self {
                self.snapshot = Some(snapshot.into());
                self
            }
            pub fn versionid(mut self, versionid: impl Into<String>) -> Self {
                self.versionid = Some(versionid.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BlobTags, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=tags", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(snapshot) = &self.snapshot {
                        url.query_pairs_mut().append_pair("snapshot", snapshot);
                    }
                    if let Some(versionid) = &self.versionid {
                        url.query_pairs_mut().append_pair("versionid", versionid);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BlobTags =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod set_tags {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) versionid: Option<String>,
            pub(crate) content_md5: Option<String>,
            pub(crate) x_ms_content_crc64: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) tags: Option<models::BlobTags>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn versionid(mut self, versionid: impl Into<String>) -> Self {
                self.versionid = Some(versionid.into());
                self
            }
            pub fn content_md5(mut self, content_md5: impl Into<String>) -> Self {
                self.content_md5 = Some(content_md5.into());
                self
            }
            pub fn x_ms_content_crc64(mut self, x_ms_content_crc64: impl Into<String>) -> Self {
                self.x_ms_content_crc64 = Some(x_ms_content_crc64.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn tags(mut self, tags: impl Into<models::BlobTags>) -> Self {
                self.tags = Some(tags.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=tags", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(versionid) = &self.versionid {
                        url.query_pairs_mut().append_pair("versionid", versionid);
                    }
                    if let Some(content_md5) = &self.content_md5 {
                        req_builder = req_builder.header("Content-MD5", content_md5);
                    }
                    if let Some(x_ms_content_crc64) = &self.x_ms_content_crc64 {
                        req_builder = req_builder.header("x-ms-content-crc64", x_ms_content_crc64);
                    }
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    let req_body = if let Some(tags) = &self.tags {
                        req_builder = req_builder.header("content-type", "application/json");
                        azure_core::to_json(tags).map_err(Error::Serialize)?
                    } else {
                        azure_core::EMPTY_BODY
                    };
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod page_blob {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        pub fn create(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            x_ms_blob_type: impl Into<String>,
            content_length: i64,
            x_ms_blob_content_length: i64,
            x_ms_version: impl Into<String>,
        ) -> create::Builder {
            create::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                x_ms_blob_type: x_ms_blob_type.into(),
                content_length,
                x_ms_blob_content_length,
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_access_tier: None,
                x_ms_blob_content_type: None,
                x_ms_blob_content_encoding: None,
                x_ms_blob_content_language: None,
                x_ms_blob_content_md5: None,
                x_ms_blob_cache_control: None,
                x_ms_meta: None,
                x_ms_lease_id: None,
                x_ms_blob_content_disposition: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                x_ms_encryption_scope: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_blob_sequence_number: None,
                x_ms_client_request_id: None,
                x_ms_tags: None,
                x_ms_immutability_policy_until_date: None,
                x_ms_immutability_policy_mode: None,
                x_ms_legal_hold: None,
            }
        }
        pub fn upload_pages(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_page_write: impl Into<String>,
            body: impl Into<serde_json::Value>,
            content_length: i64,
            x_ms_version: impl Into<String>,
        ) -> upload_pages::Builder {
            upload_pages::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_page_write: x_ms_page_write.into(),
                body: body.into(),
                content_length,
                x_ms_version: x_ms_version.into(),
                content_md5: None,
                x_ms_content_crc64: None,
                timeout: None,
                x_ms_range: None,
                x_ms_lease_id: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                x_ms_encryption_scope: None,
                x_ms_if_sequence_number_le: None,
                x_ms_if_sequence_number_lt: None,
                x_ms_if_sequence_number_eq: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn clear_pages(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_page_write: impl Into<String>,
            content_length: i64,
            x_ms_version: impl Into<String>,
        ) -> clear_pages::Builder {
            clear_pages::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_page_write: x_ms_page_write.into(),
                content_length,
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_range: None,
                x_ms_lease_id: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                x_ms_encryption_scope: None,
                x_ms_if_sequence_number_le: None,
                x_ms_if_sequence_number_lt: None,
                x_ms_if_sequence_number_eq: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn upload_pages_from_url(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_page_write: impl Into<String>,
            x_ms_copy_source: impl Into<String>,
            x_ms_source_range: impl Into<String>,
            content_length: i64,
            x_ms_range: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> upload_pages_from_url::Builder {
            upload_pages_from_url::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_page_write: x_ms_page_write.into(),
                x_ms_copy_source: x_ms_copy_source.into(),
                x_ms_source_range: x_ms_source_range.into(),
                content_length,
                x_ms_range: x_ms_range.into(),
                x_ms_version: x_ms_version.into(),
                x_ms_source_content_md5: None,
                x_ms_source_content_crc64: None,
                timeout: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                x_ms_encryption_scope: None,
                x_ms_lease_id: None,
                x_ms_if_sequence_number_le: None,
                x_ms_if_sequence_number_lt: None,
                x_ms_if_sequence_number_eq: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_source_if_modified_since: None,
                x_ms_source_if_unmodified_since: None,
                x_ms_source_if_match: None,
                x_ms_source_if_none_match: None,
                x_ms_client_request_id: None,
                x_ms_copy_source_authorization: None,
            }
        }
        pub fn get_page_ranges(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> get_page_ranges::Builder {
            get_page_ranges::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                snapshot: None,
                timeout: None,
                x_ms_range: None,
                x_ms_lease_id: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn get_page_ranges_diff(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> get_page_ranges_diff::Builder {
            get_page_ranges_diff::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                snapshot: None,
                timeout: None,
                prevsnapshot: None,
                x_ms_previous_snapshot_url: None,
                x_ms_range: None,
                x_ms_lease_id: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn resize(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_blob_content_length: i64,
            x_ms_version: impl Into<String>,
        ) -> resize::Builder {
            resize::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_blob_content_length,
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_lease_id: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                x_ms_encryption_scope: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn update_sequence_number(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_sequence_number_action: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> update_sequence_number::Builder {
            update_sequence_number::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_sequence_number_action: x_ms_sequence_number_action.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_lease_id: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_blob_sequence_number: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn copy_incremental(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_copy_source: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> copy_incremental::Builder {
            copy_incremental::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_copy_source: x_ms_copy_source.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
    }
    pub mod create {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) x_ms_blob_type: String,
            pub(crate) content_length: i64,
            pub(crate) x_ms_blob_content_length: i64,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_access_tier: Option<String>,
            pub(crate) x_ms_blob_content_type: Option<String>,
            pub(crate) x_ms_blob_content_encoding: Option<String>,
            pub(crate) x_ms_blob_content_language: Option<String>,
            pub(crate) x_ms_blob_content_md5: Option<String>,
            pub(crate) x_ms_blob_cache_control: Option<String>,
            pub(crate) x_ms_meta: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_blob_content_disposition: Option<String>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) x_ms_encryption_scope: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_blob_sequence_number: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_tags: Option<String>,
            pub(crate) x_ms_immutability_policy_until_date: Option<String>,
            pub(crate) x_ms_immutability_policy_mode: Option<String>,
            pub(crate) x_ms_legal_hold: Option<bool>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_access_tier(mut self, x_ms_access_tier: impl Into<String>) -> Self {
                self.x_ms_access_tier = Some(x_ms_access_tier.into());
                self
            }
            pub fn x_ms_blob_content_type(mut self, x_ms_blob_content_type: impl Into<String>) -> Self {
                self.x_ms_blob_content_type = Some(x_ms_blob_content_type.into());
                self
            }
            pub fn x_ms_blob_content_encoding(mut self, x_ms_blob_content_encoding: impl Into<String>) -> Self {
                self.x_ms_blob_content_encoding = Some(x_ms_blob_content_encoding.into());
                self
            }
            pub fn x_ms_blob_content_language(mut self, x_ms_blob_content_language: impl Into<String>) -> Self {
                self.x_ms_blob_content_language = Some(x_ms_blob_content_language.into());
                self
            }
            pub fn x_ms_blob_content_md5(mut self, x_ms_blob_content_md5: impl Into<String>) -> Self {
                self.x_ms_blob_content_md5 = Some(x_ms_blob_content_md5.into());
                self
            }
            pub fn x_ms_blob_cache_control(mut self, x_ms_blob_cache_control: impl Into<String>) -> Self {
                self.x_ms_blob_cache_control = Some(x_ms_blob_cache_control.into());
                self
            }
            pub fn x_ms_meta(mut self, x_ms_meta: impl Into<String>) -> Self {
                self.x_ms_meta = Some(x_ms_meta.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_blob_content_disposition(mut self, x_ms_blob_content_disposition: impl Into<String>) -> Self {
                self.x_ms_blob_content_disposition = Some(x_ms_blob_content_disposition.into());
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn x_ms_encryption_scope(mut self, x_ms_encryption_scope: impl Into<String>) -> Self {
                self.x_ms_encryption_scope = Some(x_ms_encryption_scope.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_blob_sequence_number(mut self, x_ms_blob_sequence_number: i64) -> Self {
                self.x_ms_blob_sequence_number = Some(x_ms_blob_sequence_number);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_tags(mut self, x_ms_tags: impl Into<String>) -> Self {
                self.x_ms_tags = Some(x_ms_tags.into());
                self
            }
            pub fn x_ms_immutability_policy_until_date(mut self, x_ms_immutability_policy_until_date: impl Into<String>) -> Self {
                self.x_ms_immutability_policy_until_date = Some(x_ms_immutability_policy_until_date.into());
                self
            }
            pub fn x_ms_immutability_policy_mode(mut self, x_ms_immutability_policy_mode: impl Into<String>) -> Self {
                self.x_ms_immutability_policy_mode = Some(x_ms_immutability_policy_mode.into());
                self
            }
            pub fn x_ms_legal_hold(mut self, x_ms_legal_hold: bool) -> Self {
                self.x_ms_legal_hold = Some(x_ms_legal_hold);
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?PageBlob", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    req_builder = req_builder.header("x-ms-blob-type", &self.x_ms_blob_type);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("Content-Length", &self.content_length.to_string());
                    if let Some(x_ms_access_tier) = &self.x_ms_access_tier {
                        req_builder = req_builder.header("x-ms-access-tier", x_ms_access_tier);
                    }
                    if let Some(x_ms_blob_content_type) = &self.x_ms_blob_content_type {
                        req_builder = req_builder.header("x-ms-blob-content-type", x_ms_blob_content_type);
                    }
                    if let Some(x_ms_blob_content_encoding) = &self.x_ms_blob_content_encoding {
                        req_builder = req_builder.header("x-ms-blob-content-encoding", x_ms_blob_content_encoding);
                    }
                    if let Some(x_ms_blob_content_language) = &self.x_ms_blob_content_language {
                        req_builder = req_builder.header("x-ms-blob-content-language", x_ms_blob_content_language);
                    }
                    if let Some(x_ms_blob_content_md5) = &self.x_ms_blob_content_md5 {
                        req_builder = req_builder.header("x-ms-blob-content-md5", x_ms_blob_content_md5);
                    }
                    if let Some(x_ms_blob_cache_control) = &self.x_ms_blob_cache_control {
                        req_builder = req_builder.header("x-ms-blob-cache-control", x_ms_blob_cache_control);
                    }
                    if let Some(x_ms_meta) = &self.x_ms_meta {
                        req_builder = req_builder.header("x-ms-meta", x_ms_meta);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_blob_content_disposition) = &self.x_ms_blob_content_disposition {
                        req_builder = req_builder.header("x-ms-blob-content-disposition", x_ms_blob_content_disposition);
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(x_ms_encryption_scope) = &self.x_ms_encryption_scope {
                        req_builder = req_builder.header("x-ms-encryption-scope", x_ms_encryption_scope);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-blob-content-length", &self.x_ms_blob_content_length.to_string());
                    if let Some(x_ms_blob_sequence_number) = &self.x_ms_blob_sequence_number {
                        req_builder = req_builder.header("x-ms-blob-sequence-number", &x_ms_blob_sequence_number.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(x_ms_tags) = &self.x_ms_tags {
                        req_builder = req_builder.header("x-ms-tags", x_ms_tags);
                    }
                    if let Some(x_ms_immutability_policy_until_date) = &self.x_ms_immutability_policy_until_date {
                        req_builder = req_builder.header("x-ms-immutability-policy-until-date", x_ms_immutability_policy_until_date);
                    }
                    if let Some(x_ms_immutability_policy_mode) = &self.x_ms_immutability_policy_mode {
                        req_builder = req_builder.header("x-ms-immutability-policy-mode", x_ms_immutability_policy_mode);
                    }
                    if let Some(x_ms_legal_hold) = &self.x_ms_legal_hold {
                        req_builder = req_builder.header("x-ms-legal-hold", &x_ms_legal_hold.to_string());
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod upload_pages {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_page_write: String,
            pub(crate) body: serde_json::Value,
            pub(crate) content_length: i64,
            pub(crate) x_ms_version: String,
            pub(crate) content_md5: Option<String>,
            pub(crate) x_ms_content_crc64: Option<String>,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_range: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) x_ms_encryption_scope: Option<String>,
            pub(crate) x_ms_if_sequence_number_le: Option<i64>,
            pub(crate) x_ms_if_sequence_number_lt: Option<i64>,
            pub(crate) x_ms_if_sequence_number_eq: Option<i64>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn content_md5(mut self, content_md5: impl Into<String>) -> Self {
                self.content_md5 = Some(content_md5.into());
                self
            }
            pub fn x_ms_content_crc64(mut self, x_ms_content_crc64: impl Into<String>) -> Self {
                self.x_ms_content_crc64 = Some(x_ms_content_crc64.into());
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_range(mut self, x_ms_range: impl Into<String>) -> Self {
                self.x_ms_range = Some(x_ms_range.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn x_ms_encryption_scope(mut self, x_ms_encryption_scope: impl Into<String>) -> Self {
                self.x_ms_encryption_scope = Some(x_ms_encryption_scope.into());
                self
            }
            pub fn x_ms_if_sequence_number_le(mut self, x_ms_if_sequence_number_le: i64) -> Self {
                self.x_ms_if_sequence_number_le = Some(x_ms_if_sequence_number_le);
                self
            }
            pub fn x_ms_if_sequence_number_lt(mut self, x_ms_if_sequence_number_lt: i64) -> Self {
                self.x_ms_if_sequence_number_lt = Some(x_ms_if_sequence_number_lt);
                self
            }
            pub fn x_ms_if_sequence_number_eq(mut self, x_ms_if_sequence_number_eq: i64) -> Self {
                self.x_ms_if_sequence_number_eq = Some(x_ms_if_sequence_number_eq);
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=page&update",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("x-ms-page-write", &self.x_ms_page_write);
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.body).map_err(Error::Serialize)?;
                    req_builder = req_builder.header("Content-Length", &self.content_length.to_string());
                    if let Some(content_md5) = &self.content_md5 {
                        req_builder = req_builder.header("Content-MD5", content_md5);
                    }
                    if let Some(x_ms_content_crc64) = &self.x_ms_content_crc64 {
                        req_builder = req_builder.header("x-ms-content-crc64", x_ms_content_crc64);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_range) = &self.x_ms_range {
                        req_builder = req_builder.header("x-ms-range", x_ms_range);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(x_ms_encryption_scope) = &self.x_ms_encryption_scope {
                        req_builder = req_builder.header("x-ms-encryption-scope", x_ms_encryption_scope);
                    }
                    if let Some(x_ms_if_sequence_number_le) = &self.x_ms_if_sequence_number_le {
                        req_builder = req_builder.header("x-ms-if-sequence-number-le", &x_ms_if_sequence_number_le.to_string());
                    }
                    if let Some(x_ms_if_sequence_number_lt) = &self.x_ms_if_sequence_number_lt {
                        req_builder = req_builder.header("x-ms-if-sequence-number-lt", &x_ms_if_sequence_number_lt.to_string());
                    }
                    if let Some(x_ms_if_sequence_number_eq) = &self.x_ms_if_sequence_number_eq {
                        req_builder = req_builder.header("x-ms-if-sequence-number-eq", &x_ms_if_sequence_number_eq.to_string());
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod clear_pages {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_page_write: String,
            pub(crate) content_length: i64,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_range: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) x_ms_encryption_scope: Option<String>,
            pub(crate) x_ms_if_sequence_number_le: Option<i64>,
            pub(crate) x_ms_if_sequence_number_lt: Option<i64>,
            pub(crate) x_ms_if_sequence_number_eq: Option<i64>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_range(mut self, x_ms_range: impl Into<String>) -> Self {
                self.x_ms_range = Some(x_ms_range.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn x_ms_encryption_scope(mut self, x_ms_encryption_scope: impl Into<String>) -> Self {
                self.x_ms_encryption_scope = Some(x_ms_encryption_scope.into());
                self
            }
            pub fn x_ms_if_sequence_number_le(mut self, x_ms_if_sequence_number_le: i64) -> Self {
                self.x_ms_if_sequence_number_le = Some(x_ms_if_sequence_number_le);
                self
            }
            pub fn x_ms_if_sequence_number_lt(mut self, x_ms_if_sequence_number_lt: i64) -> Self {
                self.x_ms_if_sequence_number_lt = Some(x_ms_if_sequence_number_lt);
                self
            }
            pub fn x_ms_if_sequence_number_eq(mut self, x_ms_if_sequence_number_eq: i64) -> Self {
                self.x_ms_if_sequence_number_eq = Some(x_ms_if_sequence_number_eq);
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=page&clear", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("x-ms-page-write", &self.x_ms_page_write);
                    req_builder = req_builder.header("Content-Length", &self.content_length.to_string());
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_range) = &self.x_ms_range {
                        req_builder = req_builder.header("x-ms-range", x_ms_range);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(x_ms_encryption_scope) = &self.x_ms_encryption_scope {
                        req_builder = req_builder.header("x-ms-encryption-scope", x_ms_encryption_scope);
                    }
                    if let Some(x_ms_if_sequence_number_le) = &self.x_ms_if_sequence_number_le {
                        req_builder = req_builder.header("x-ms-if-sequence-number-le", &x_ms_if_sequence_number_le.to_string());
                    }
                    if let Some(x_ms_if_sequence_number_lt) = &self.x_ms_if_sequence_number_lt {
                        req_builder = req_builder.header("x-ms-if-sequence-number-lt", &x_ms_if_sequence_number_lt.to_string());
                    }
                    if let Some(x_ms_if_sequence_number_eq) = &self.x_ms_if_sequence_number_eq {
                        req_builder = req_builder.header("x-ms-if-sequence-number-eq", &x_ms_if_sequence_number_eq.to_string());
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod upload_pages_from_url {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_page_write: String,
            pub(crate) x_ms_copy_source: String,
            pub(crate) x_ms_source_range: String,
            pub(crate) content_length: i64,
            pub(crate) x_ms_range: String,
            pub(crate) x_ms_version: String,
            pub(crate) x_ms_source_content_md5: Option<String>,
            pub(crate) x_ms_source_content_crc64: Option<String>,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) x_ms_encryption_scope: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_if_sequence_number_le: Option<i64>,
            pub(crate) x_ms_if_sequence_number_lt: Option<i64>,
            pub(crate) x_ms_if_sequence_number_eq: Option<i64>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_source_if_modified_since: Option<String>,
            pub(crate) x_ms_source_if_unmodified_since: Option<String>,
            pub(crate) x_ms_source_if_match: Option<String>,
            pub(crate) x_ms_source_if_none_match: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_copy_source_authorization: Option<String>,
        }
        impl Builder {
            pub fn x_ms_source_content_md5(mut self, x_ms_source_content_md5: impl Into<String>) -> Self {
                self.x_ms_source_content_md5 = Some(x_ms_source_content_md5.into());
                self
            }
            pub fn x_ms_source_content_crc64(mut self, x_ms_source_content_crc64: impl Into<String>) -> Self {
                self.x_ms_source_content_crc64 = Some(x_ms_source_content_crc64.into());
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn x_ms_encryption_scope(mut self, x_ms_encryption_scope: impl Into<String>) -> Self {
                self.x_ms_encryption_scope = Some(x_ms_encryption_scope.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_if_sequence_number_le(mut self, x_ms_if_sequence_number_le: i64) -> Self {
                self.x_ms_if_sequence_number_le = Some(x_ms_if_sequence_number_le);
                self
            }
            pub fn x_ms_if_sequence_number_lt(mut self, x_ms_if_sequence_number_lt: i64) -> Self {
                self.x_ms_if_sequence_number_lt = Some(x_ms_if_sequence_number_lt);
                self
            }
            pub fn x_ms_if_sequence_number_eq(mut self, x_ms_if_sequence_number_eq: i64) -> Self {
                self.x_ms_if_sequence_number_eq = Some(x_ms_if_sequence_number_eq);
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_source_if_modified_since(mut self, x_ms_source_if_modified_since: impl Into<String>) -> Self {
                self.x_ms_source_if_modified_since = Some(x_ms_source_if_modified_since.into());
                self
            }
            pub fn x_ms_source_if_unmodified_since(mut self, x_ms_source_if_unmodified_since: impl Into<String>) -> Self {
                self.x_ms_source_if_unmodified_since = Some(x_ms_source_if_unmodified_since.into());
                self
            }
            pub fn x_ms_source_if_match(mut self, x_ms_source_if_match: impl Into<String>) -> Self {
                self.x_ms_source_if_match = Some(x_ms_source_if_match.into());
                self
            }
            pub fn x_ms_source_if_none_match(mut self, x_ms_source_if_none_match: impl Into<String>) -> Self {
                self.x_ms_source_if_none_match = Some(x_ms_source_if_none_match.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_copy_source_authorization(mut self, x_ms_copy_source_authorization: impl Into<String>) -> Self {
                self.x_ms_copy_source_authorization = Some(x_ms_copy_source_authorization.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=page&update&fromUrl",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("x-ms-page-write", &self.x_ms_page_write);
                    req_builder = req_builder.header("x-ms-copy-source", &self.x_ms_copy_source);
                    req_builder = req_builder.header("x-ms-source-range", &self.x_ms_source_range);
                    if let Some(x_ms_source_content_md5) = &self.x_ms_source_content_md5 {
                        req_builder = req_builder.header("x-ms-source-content-md5", x_ms_source_content_md5);
                    }
                    if let Some(x_ms_source_content_crc64) = &self.x_ms_source_content_crc64 {
                        req_builder = req_builder.header("x-ms-source-content-crc64", x_ms_source_content_crc64);
                    }
                    req_builder = req_builder.header("Content-Length", &self.content_length.to_string());
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-range", &self.x_ms_range);
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(x_ms_encryption_scope) = &self.x_ms_encryption_scope {
                        req_builder = req_builder.header("x-ms-encryption-scope", x_ms_encryption_scope);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_if_sequence_number_le) = &self.x_ms_if_sequence_number_le {
                        req_builder = req_builder.header("x-ms-if-sequence-number-le", &x_ms_if_sequence_number_le.to_string());
                    }
                    if let Some(x_ms_if_sequence_number_lt) = &self.x_ms_if_sequence_number_lt {
                        req_builder = req_builder.header("x-ms-if-sequence-number-lt", &x_ms_if_sequence_number_lt.to_string());
                    }
                    if let Some(x_ms_if_sequence_number_eq) = &self.x_ms_if_sequence_number_eq {
                        req_builder = req_builder.header("x-ms-if-sequence-number-eq", &x_ms_if_sequence_number_eq.to_string());
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    if let Some(x_ms_source_if_modified_since) = &self.x_ms_source_if_modified_since {
                        req_builder = req_builder.header("x-ms-source-if-modified-since", x_ms_source_if_modified_since);
                    }
                    if let Some(x_ms_source_if_unmodified_since) = &self.x_ms_source_if_unmodified_since {
                        req_builder = req_builder.header("x-ms-source-if-unmodified-since", x_ms_source_if_unmodified_since);
                    }
                    if let Some(x_ms_source_if_match) = &self.x_ms_source_if_match {
                        req_builder = req_builder.header("x-ms-source-if-match", x_ms_source_if_match);
                    }
                    if let Some(x_ms_source_if_none_match) = &self.x_ms_source_if_none_match {
                        req_builder = req_builder.header("x-ms-source-if-none-match", x_ms_source_if_none_match);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(x_ms_copy_source_authorization) = &self.x_ms_copy_source_authorization {
                        req_builder = req_builder.header("x-ms-copy-source-authorization", x_ms_copy_source_authorization);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_page_ranges {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) snapshot: Option<String>,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_range: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn snapshot(mut self, snapshot: impl Into<String>) -> Self {
                self.snapshot = Some(snapshot.into());
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_range(mut self, x_ms_range: impl Into<String>) -> Self {
                self.x_ms_range = Some(x_ms_range.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PageList, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=pagelist", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(snapshot) = &self.snapshot {
                        url.query_pairs_mut().append_pair("snapshot", snapshot);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_range) = &self.x_ms_range {
                        req_builder = req_builder.header("x-ms-range", x_ms_range);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PageList =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_page_ranges_diff {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) snapshot: Option<String>,
            pub(crate) timeout: Option<i64>,
            pub(crate) prevsnapshot: Option<String>,
            pub(crate) x_ms_previous_snapshot_url: Option<String>,
            pub(crate) x_ms_range: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn snapshot(mut self, snapshot: impl Into<String>) -> Self {
                self.snapshot = Some(snapshot.into());
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn prevsnapshot(mut self, prevsnapshot: impl Into<String>) -> Self {
                self.prevsnapshot = Some(prevsnapshot.into());
                self
            }
            pub fn x_ms_previous_snapshot_url(mut self, x_ms_previous_snapshot_url: impl Into<String>) -> Self {
                self.x_ms_previous_snapshot_url = Some(x_ms_previous_snapshot_url.into());
                self
            }
            pub fn x_ms_range(mut self, x_ms_range: impl Into<String>) -> Self {
                self.x_ms_range = Some(x_ms_range.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PageList, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=pagelist&diff",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(snapshot) = &self.snapshot {
                        url.query_pairs_mut().append_pair("snapshot", snapshot);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(prevsnapshot) = &self.prevsnapshot {
                        url.query_pairs_mut().append_pair("prevsnapshot", prevsnapshot);
                    }
                    if let Some(x_ms_previous_snapshot_url) = &self.x_ms_previous_snapshot_url {
                        req_builder = req_builder.header("x-ms-previous-snapshot-url", x_ms_previous_snapshot_url);
                    }
                    if let Some(x_ms_range) = &self.x_ms_range {
                        req_builder = req_builder.header("x-ms-range", x_ms_range);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PageList =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod resize {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_blob_content_length: i64,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) x_ms_encryption_scope: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn x_ms_encryption_scope(mut self, x_ms_encryption_scope: impl Into<String>) -> Self {
                self.x_ms_encryption_scope = Some(x_ms_encryption_scope.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=properties&Resize",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(x_ms_encryption_scope) = &self.x_ms_encryption_scope {
                        req_builder = req_builder.header("x-ms-encryption-scope", x_ms_encryption_scope);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-blob-content-length", &self.x_ms_blob_content_length.to_string());
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_sequence_number {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_sequence_number_action: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_blob_sequence_number: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_blob_sequence_number(mut self, x_ms_blob_sequence_number: i64) -> Self {
                self.x_ms_blob_sequence_number = Some(x_ms_blob_sequence_number);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=properties&UpdateSequenceNumber",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-sequence-number-action", &self.x_ms_sequence_number_action);
                    if let Some(x_ms_blob_sequence_number) = &self.x_ms_blob_sequence_number {
                        req_builder = req_builder.header("x-ms-blob-sequence-number", &x_ms_blob_sequence_number.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod copy_incremental {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_copy_source: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=incrementalcopy",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-copy-source", &self.x_ms_copy_source);
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod append_blob {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        pub fn create(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            x_ms_blob_type: impl Into<String>,
            content_length: i64,
            x_ms_version: impl Into<String>,
        ) -> create::Builder {
            create::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                x_ms_blob_type: x_ms_blob_type.into(),
                content_length,
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_blob_content_type: None,
                x_ms_blob_content_encoding: None,
                x_ms_blob_content_language: None,
                x_ms_blob_content_md5: None,
                x_ms_blob_cache_control: None,
                x_ms_meta: None,
                x_ms_lease_id: None,
                x_ms_blob_content_disposition: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                x_ms_encryption_scope: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
                x_ms_tags: None,
                x_ms_immutability_policy_until_date: None,
                x_ms_immutability_policy_mode: None,
                x_ms_legal_hold: None,
            }
        }
        pub fn append_block(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            body: impl Into<serde_json::Value>,
            content_length: i64,
            x_ms_version: impl Into<String>,
        ) -> append_block::Builder {
            append_block::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                body: body.into(),
                content_length,
                x_ms_version: x_ms_version.into(),
                timeout: None,
                content_md5: None,
                x_ms_content_crc64: None,
                x_ms_lease_id: None,
                x_ms_blob_condition_maxsize: None,
                x_ms_blob_condition_appendpos: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                x_ms_encryption_scope: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn append_block_from_url(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_copy_source: impl Into<String>,
            content_length: i64,
            x_ms_version: impl Into<String>,
        ) -> append_block_from_url::Builder {
            append_block_from_url::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_copy_source: x_ms_copy_source.into(),
                content_length,
                x_ms_version: x_ms_version.into(),
                x_ms_source_range: None,
                x_ms_source_content_md5: None,
                x_ms_source_content_crc64: None,
                timeout: None,
                content_md5: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                x_ms_encryption_scope: None,
                x_ms_lease_id: None,
                x_ms_blob_condition_maxsize: None,
                x_ms_blob_condition_appendpos: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_source_if_modified_since: None,
                x_ms_source_if_unmodified_since: None,
                x_ms_source_if_match: None,
                x_ms_source_if_none_match: None,
                x_ms_client_request_id: None,
                x_ms_copy_source_authorization: None,
            }
        }
        pub fn seal(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> seal::Builder {
            seal::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_client_request_id: None,
                x_ms_lease_id: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_blob_condition_appendpos: None,
            }
        }
    }
    pub mod create {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) x_ms_blob_type: String,
            pub(crate) content_length: i64,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_blob_content_type: Option<String>,
            pub(crate) x_ms_blob_content_encoding: Option<String>,
            pub(crate) x_ms_blob_content_language: Option<String>,
            pub(crate) x_ms_blob_content_md5: Option<String>,
            pub(crate) x_ms_blob_cache_control: Option<String>,
            pub(crate) x_ms_meta: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_blob_content_disposition: Option<String>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) x_ms_encryption_scope: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_tags: Option<String>,
            pub(crate) x_ms_immutability_policy_until_date: Option<String>,
            pub(crate) x_ms_immutability_policy_mode: Option<String>,
            pub(crate) x_ms_legal_hold: Option<bool>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_blob_content_type(mut self, x_ms_blob_content_type: impl Into<String>) -> Self {
                self.x_ms_blob_content_type = Some(x_ms_blob_content_type.into());
                self
            }
            pub fn x_ms_blob_content_encoding(mut self, x_ms_blob_content_encoding: impl Into<String>) -> Self {
                self.x_ms_blob_content_encoding = Some(x_ms_blob_content_encoding.into());
                self
            }
            pub fn x_ms_blob_content_language(mut self, x_ms_blob_content_language: impl Into<String>) -> Self {
                self.x_ms_blob_content_language = Some(x_ms_blob_content_language.into());
                self
            }
            pub fn x_ms_blob_content_md5(mut self, x_ms_blob_content_md5: impl Into<String>) -> Self {
                self.x_ms_blob_content_md5 = Some(x_ms_blob_content_md5.into());
                self
            }
            pub fn x_ms_blob_cache_control(mut self, x_ms_blob_cache_control: impl Into<String>) -> Self {
                self.x_ms_blob_cache_control = Some(x_ms_blob_cache_control.into());
                self
            }
            pub fn x_ms_meta(mut self, x_ms_meta: impl Into<String>) -> Self {
                self.x_ms_meta = Some(x_ms_meta.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_blob_content_disposition(mut self, x_ms_blob_content_disposition: impl Into<String>) -> Self {
                self.x_ms_blob_content_disposition = Some(x_ms_blob_content_disposition.into());
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn x_ms_encryption_scope(mut self, x_ms_encryption_scope: impl Into<String>) -> Self {
                self.x_ms_encryption_scope = Some(x_ms_encryption_scope.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_tags(mut self, x_ms_tags: impl Into<String>) -> Self {
                self.x_ms_tags = Some(x_ms_tags.into());
                self
            }
            pub fn x_ms_immutability_policy_until_date(mut self, x_ms_immutability_policy_until_date: impl Into<String>) -> Self {
                self.x_ms_immutability_policy_until_date = Some(x_ms_immutability_policy_until_date.into());
                self
            }
            pub fn x_ms_immutability_policy_mode(mut self, x_ms_immutability_policy_mode: impl Into<String>) -> Self {
                self.x_ms_immutability_policy_mode = Some(x_ms_immutability_policy_mode.into());
                self
            }
            pub fn x_ms_legal_hold(mut self, x_ms_legal_hold: bool) -> Self {
                self.x_ms_legal_hold = Some(x_ms_legal_hold);
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?AppendBlob", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    req_builder = req_builder.header("x-ms-blob-type", &self.x_ms_blob_type);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("Content-Length", &self.content_length.to_string());
                    if let Some(x_ms_blob_content_type) = &self.x_ms_blob_content_type {
                        req_builder = req_builder.header("x-ms-blob-content-type", x_ms_blob_content_type);
                    }
                    if let Some(x_ms_blob_content_encoding) = &self.x_ms_blob_content_encoding {
                        req_builder = req_builder.header("x-ms-blob-content-encoding", x_ms_blob_content_encoding);
                    }
                    if let Some(x_ms_blob_content_language) = &self.x_ms_blob_content_language {
                        req_builder = req_builder.header("x-ms-blob-content-language", x_ms_blob_content_language);
                    }
                    if let Some(x_ms_blob_content_md5) = &self.x_ms_blob_content_md5 {
                        req_builder = req_builder.header("x-ms-blob-content-md5", x_ms_blob_content_md5);
                    }
                    if let Some(x_ms_blob_cache_control) = &self.x_ms_blob_cache_control {
                        req_builder = req_builder.header("x-ms-blob-cache-control", x_ms_blob_cache_control);
                    }
                    if let Some(x_ms_meta) = &self.x_ms_meta {
                        req_builder = req_builder.header("x-ms-meta", x_ms_meta);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_blob_content_disposition) = &self.x_ms_blob_content_disposition {
                        req_builder = req_builder.header("x-ms-blob-content-disposition", x_ms_blob_content_disposition);
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(x_ms_encryption_scope) = &self.x_ms_encryption_scope {
                        req_builder = req_builder.header("x-ms-encryption-scope", x_ms_encryption_scope);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(x_ms_tags) = &self.x_ms_tags {
                        req_builder = req_builder.header("x-ms-tags", x_ms_tags);
                    }
                    if let Some(x_ms_immutability_policy_until_date) = &self.x_ms_immutability_policy_until_date {
                        req_builder = req_builder.header("x-ms-immutability-policy-until-date", x_ms_immutability_policy_until_date);
                    }
                    if let Some(x_ms_immutability_policy_mode) = &self.x_ms_immutability_policy_mode {
                        req_builder = req_builder.header("x-ms-immutability-policy-mode", x_ms_immutability_policy_mode);
                    }
                    if let Some(x_ms_legal_hold) = &self.x_ms_legal_hold {
                        req_builder = req_builder.header("x-ms-legal-hold", &x_ms_legal_hold.to_string());
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod append_block {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) body: serde_json::Value,
            pub(crate) content_length: i64,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) content_md5: Option<String>,
            pub(crate) x_ms_content_crc64: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_blob_condition_maxsize: Option<i64>,
            pub(crate) x_ms_blob_condition_appendpos: Option<i64>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) x_ms_encryption_scope: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn content_md5(mut self, content_md5: impl Into<String>) -> Self {
                self.content_md5 = Some(content_md5.into());
                self
            }
            pub fn x_ms_content_crc64(mut self, x_ms_content_crc64: impl Into<String>) -> Self {
                self.x_ms_content_crc64 = Some(x_ms_content_crc64.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_blob_condition_maxsize(mut self, x_ms_blob_condition_maxsize: i64) -> Self {
                self.x_ms_blob_condition_maxsize = Some(x_ms_blob_condition_maxsize);
                self
            }
            pub fn x_ms_blob_condition_appendpos(mut self, x_ms_blob_condition_appendpos: i64) -> Self {
                self.x_ms_blob_condition_appendpos = Some(x_ms_blob_condition_appendpos);
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn x_ms_encryption_scope(mut self, x_ms_encryption_scope: impl Into<String>) -> Self {
                self.x_ms_encryption_scope = Some(x_ms_encryption_scope.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=appendblock",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.body).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("Content-Length", &self.content_length.to_string());
                    if let Some(content_md5) = &self.content_md5 {
                        req_builder = req_builder.header("Content-MD5", content_md5);
                    }
                    if let Some(x_ms_content_crc64) = &self.x_ms_content_crc64 {
                        req_builder = req_builder.header("x-ms-content-crc64", x_ms_content_crc64);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_blob_condition_maxsize) = &self.x_ms_blob_condition_maxsize {
                        req_builder = req_builder.header("x-ms-blob-condition-maxsize", &x_ms_blob_condition_maxsize.to_string());
                    }
                    if let Some(x_ms_blob_condition_appendpos) = &self.x_ms_blob_condition_appendpos {
                        req_builder = req_builder.header("x-ms-blob-condition-appendpos", &x_ms_blob_condition_appendpos.to_string());
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(x_ms_encryption_scope) = &self.x_ms_encryption_scope {
                        req_builder = req_builder.header("x-ms-encryption-scope", x_ms_encryption_scope);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod append_block_from_url {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_copy_source: String,
            pub(crate) content_length: i64,
            pub(crate) x_ms_version: String,
            pub(crate) x_ms_source_range: Option<String>,
            pub(crate) x_ms_source_content_md5: Option<String>,
            pub(crate) x_ms_source_content_crc64: Option<String>,
            pub(crate) timeout: Option<i64>,
            pub(crate) content_md5: Option<String>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) x_ms_encryption_scope: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_blob_condition_maxsize: Option<i64>,
            pub(crate) x_ms_blob_condition_appendpos: Option<i64>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_source_if_modified_since: Option<String>,
            pub(crate) x_ms_source_if_unmodified_since: Option<String>,
            pub(crate) x_ms_source_if_match: Option<String>,
            pub(crate) x_ms_source_if_none_match: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_copy_source_authorization: Option<String>,
        }
        impl Builder {
            pub fn x_ms_source_range(mut self, x_ms_source_range: impl Into<String>) -> Self {
                self.x_ms_source_range = Some(x_ms_source_range.into());
                self
            }
            pub fn x_ms_source_content_md5(mut self, x_ms_source_content_md5: impl Into<String>) -> Self {
                self.x_ms_source_content_md5 = Some(x_ms_source_content_md5.into());
                self
            }
            pub fn x_ms_source_content_crc64(mut self, x_ms_source_content_crc64: impl Into<String>) -> Self {
                self.x_ms_source_content_crc64 = Some(x_ms_source_content_crc64.into());
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn content_md5(mut self, content_md5: impl Into<String>) -> Self {
                self.content_md5 = Some(content_md5.into());
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn x_ms_encryption_scope(mut self, x_ms_encryption_scope: impl Into<String>) -> Self {
                self.x_ms_encryption_scope = Some(x_ms_encryption_scope.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_blob_condition_maxsize(mut self, x_ms_blob_condition_maxsize: i64) -> Self {
                self.x_ms_blob_condition_maxsize = Some(x_ms_blob_condition_maxsize);
                self
            }
            pub fn x_ms_blob_condition_appendpos(mut self, x_ms_blob_condition_appendpos: i64) -> Self {
                self.x_ms_blob_condition_appendpos = Some(x_ms_blob_condition_appendpos);
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_source_if_modified_since(mut self, x_ms_source_if_modified_since: impl Into<String>) -> Self {
                self.x_ms_source_if_modified_since = Some(x_ms_source_if_modified_since.into());
                self
            }
            pub fn x_ms_source_if_unmodified_since(mut self, x_ms_source_if_unmodified_since: impl Into<String>) -> Self {
                self.x_ms_source_if_unmodified_since = Some(x_ms_source_if_unmodified_since.into());
                self
            }
            pub fn x_ms_source_if_match(mut self, x_ms_source_if_match: impl Into<String>) -> Self {
                self.x_ms_source_if_match = Some(x_ms_source_if_match.into());
                self
            }
            pub fn x_ms_source_if_none_match(mut self, x_ms_source_if_none_match: impl Into<String>) -> Self {
                self.x_ms_source_if_none_match = Some(x_ms_source_if_none_match.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_copy_source_authorization(mut self, x_ms_copy_source_authorization: impl Into<String>) -> Self {
                self.x_ms_copy_source_authorization = Some(x_ms_copy_source_authorization.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=appendblock&fromUrl",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    req_builder = req_builder.header("x-ms-copy-source", &self.x_ms_copy_source);
                    if let Some(x_ms_source_range) = &self.x_ms_source_range {
                        req_builder = req_builder.header("x-ms-source-range", x_ms_source_range);
                    }
                    if let Some(x_ms_source_content_md5) = &self.x_ms_source_content_md5 {
                        req_builder = req_builder.header("x-ms-source-content-md5", x_ms_source_content_md5);
                    }
                    if let Some(x_ms_source_content_crc64) = &self.x_ms_source_content_crc64 {
                        req_builder = req_builder.header("x-ms-source-content-crc64", x_ms_source_content_crc64);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("Content-Length", &self.content_length.to_string());
                    if let Some(content_md5) = &self.content_md5 {
                        req_builder = req_builder.header("Content-MD5", content_md5);
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(x_ms_encryption_scope) = &self.x_ms_encryption_scope {
                        req_builder = req_builder.header("x-ms-encryption-scope", x_ms_encryption_scope);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_blob_condition_maxsize) = &self.x_ms_blob_condition_maxsize {
                        req_builder = req_builder.header("x-ms-blob-condition-maxsize", &x_ms_blob_condition_maxsize.to_string());
                    }
                    if let Some(x_ms_blob_condition_appendpos) = &self.x_ms_blob_condition_appendpos {
                        req_builder = req_builder.header("x-ms-blob-condition-appendpos", &x_ms_blob_condition_appendpos.to_string());
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    if let Some(x_ms_source_if_modified_since) = &self.x_ms_source_if_modified_since {
                        req_builder = req_builder.header("x-ms-source-if-modified-since", x_ms_source_if_modified_since);
                    }
                    if let Some(x_ms_source_if_unmodified_since) = &self.x_ms_source_if_unmodified_since {
                        req_builder = req_builder.header("x-ms-source-if-unmodified-since", x_ms_source_if_unmodified_since);
                    }
                    if let Some(x_ms_source_if_match) = &self.x_ms_source_if_match {
                        req_builder = req_builder.header("x-ms-source-if-match", x_ms_source_if_match);
                    }
                    if let Some(x_ms_source_if_none_match) = &self.x_ms_source_if_none_match {
                        req_builder = req_builder.header("x-ms-source-if-none-match", x_ms_source_if_none_match);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(x_ms_copy_source_authorization) = &self.x_ms_copy_source_authorization {
                        req_builder = req_builder.header("x-ms-copy-source-authorization", x_ms_copy_source_authorization);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod seal {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_blob_condition_appendpos: Option<i64>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_blob_condition_appendpos(mut self, x_ms_blob_condition_appendpos: i64) -> Self {
                self.x_ms_blob_condition_appendpos = Some(x_ms_blob_condition_appendpos);
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=seal", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_blob_condition_appendpos) = &self.x_ms_blob_condition_appendpos {
                        req_builder = req_builder.header("x-ms-blob-condition-appendpos", &x_ms_blob_condition_appendpos.to_string());
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod block_blob {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        pub fn upload(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            x_ms_blob_type: impl Into<String>,
            body: impl Into<serde_json::Value>,
            content_length: i64,
            x_ms_version: impl Into<String>,
        ) -> upload::Builder {
            upload::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                x_ms_blob_type: x_ms_blob_type.into(),
                body: body.into(),
                content_length,
                x_ms_version: x_ms_version.into(),
                timeout: None,
                content_md5: None,
                x_ms_blob_content_type: None,
                x_ms_blob_content_encoding: None,
                x_ms_blob_content_language: None,
                x_ms_blob_content_md5: None,
                x_ms_blob_cache_control: None,
                x_ms_meta: None,
                x_ms_lease_id: None,
                x_ms_blob_content_disposition: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                x_ms_encryption_scope: None,
                x_ms_access_tier: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
                x_ms_tags: None,
                x_ms_immutability_policy_until_date: None,
                x_ms_immutability_policy_mode: None,
                x_ms_legal_hold: None,
            }
        }
        pub fn put_blob_from_url(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            x_ms_blob_type: impl Into<String>,
            content_length: i64,
            x_ms_version: impl Into<String>,
            x_ms_copy_source: impl Into<String>,
        ) -> put_blob_from_url::Builder {
            put_blob_from_url::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                x_ms_blob_type: x_ms_blob_type.into(),
                content_length,
                x_ms_version: x_ms_version.into(),
                x_ms_copy_source: x_ms_copy_source.into(),
                timeout: None,
                content_md5: None,
                x_ms_blob_content_type: None,
                x_ms_blob_content_encoding: None,
                x_ms_blob_content_language: None,
                x_ms_blob_content_md5: None,
                x_ms_blob_cache_control: None,
                x_ms_meta: None,
                x_ms_lease_id: None,
                x_ms_blob_content_disposition: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                x_ms_encryption_scope: None,
                x_ms_access_tier: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_source_if_modified_since: None,
                x_ms_source_if_unmodified_since: None,
                x_ms_source_if_match: None,
                x_ms_source_if_none_match: None,
                x_ms_source_if_tags: None,
                x_ms_client_request_id: None,
                x_ms_source_content_md5: None,
                x_ms_tags: None,
                x_ms_copy_source_blob_properties: None,
                x_ms_copy_source_authorization: None,
            }
        }
        pub fn stage_block(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            blockid: impl Into<String>,
            content_length: i64,
            body: impl Into<serde_json::Value>,
            x_ms_version: impl Into<String>,
        ) -> stage_block::Builder {
            stage_block::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                blockid: blockid.into(),
                content_length,
                body: body.into(),
                x_ms_version: x_ms_version.into(),
                content_md5: None,
                x_ms_content_crc64: None,
                timeout: None,
                x_ms_lease_id: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                x_ms_encryption_scope: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn stage_block_from_url(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            blockid: impl Into<String>,
            content_length: i64,
            x_ms_copy_source: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> stage_block_from_url::Builder {
            stage_block_from_url::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                blockid: blockid.into(),
                content_length,
                x_ms_copy_source: x_ms_copy_source.into(),
                x_ms_version: x_ms_version.into(),
                x_ms_source_range: None,
                x_ms_source_content_md5: None,
                x_ms_source_content_crc64: None,
                timeout: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                x_ms_encryption_scope: None,
                x_ms_lease_id: None,
                x_ms_source_if_modified_since: None,
                x_ms_source_if_unmodified_since: None,
                x_ms_source_if_match: None,
                x_ms_source_if_none_match: None,
                x_ms_client_request_id: None,
                x_ms_copy_source_authorization: None,
            }
        }
        pub fn get_block_list(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            blocklisttype: impl Into<String>,
            x_ms_version: impl Into<String>,
        ) -> get_block_list::Builder {
            get_block_list::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                blocklisttype: blocklisttype.into(),
                x_ms_version: x_ms_version.into(),
                snapshot: None,
                timeout: None,
                x_ms_lease_id: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
            }
        }
        pub fn commit_block_list(
            &self,
            container_name: impl Into<String>,
            blob: impl Into<String>,
            comp: impl Into<String>,
            blocks: impl Into<models::BlockLookupList>,
            x_ms_version: impl Into<String>,
        ) -> commit_block_list::Builder {
            commit_block_list::Builder {
                client: self.0.clone(),
                container_name: container_name.into(),
                blob: blob.into(),
                comp: comp.into(),
                blocks: blocks.into(),
                x_ms_version: x_ms_version.into(),
                timeout: None,
                x_ms_blob_cache_control: None,
                x_ms_blob_content_type: None,
                x_ms_blob_content_encoding: None,
                x_ms_blob_content_language: None,
                x_ms_blob_content_md5: None,
                content_md5: None,
                x_ms_content_crc64: None,
                x_ms_meta: None,
                x_ms_lease_id: None,
                x_ms_blob_content_disposition: None,
                x_ms_encryption_key: None,
                x_ms_encryption_key_sha256: None,
                x_ms_encryption_algorithm: None,
                x_ms_encryption_scope: None,
                x_ms_access_tier: None,
                if_modified_since: None,
                if_unmodified_since: None,
                if_match: None,
                if_none_match: None,
                x_ms_if_tags: None,
                x_ms_client_request_id: None,
                x_ms_tags: None,
                x_ms_immutability_policy_until_date: None,
                x_ms_immutability_policy_mode: None,
                x_ms_legal_hold: None,
            }
        }
    }
    pub mod upload {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) x_ms_blob_type: String,
            pub(crate) body: serde_json::Value,
            pub(crate) content_length: i64,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) content_md5: Option<String>,
            pub(crate) x_ms_blob_content_type: Option<String>,
            pub(crate) x_ms_blob_content_encoding: Option<String>,
            pub(crate) x_ms_blob_content_language: Option<String>,
            pub(crate) x_ms_blob_content_md5: Option<String>,
            pub(crate) x_ms_blob_cache_control: Option<String>,
            pub(crate) x_ms_meta: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_blob_content_disposition: Option<String>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) x_ms_encryption_scope: Option<String>,
            pub(crate) x_ms_access_tier: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_tags: Option<String>,
            pub(crate) x_ms_immutability_policy_until_date: Option<String>,
            pub(crate) x_ms_immutability_policy_mode: Option<String>,
            pub(crate) x_ms_legal_hold: Option<bool>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn content_md5(mut self, content_md5: impl Into<String>) -> Self {
                self.content_md5 = Some(content_md5.into());
                self
            }
            pub fn x_ms_blob_content_type(mut self, x_ms_blob_content_type: impl Into<String>) -> Self {
                self.x_ms_blob_content_type = Some(x_ms_blob_content_type.into());
                self
            }
            pub fn x_ms_blob_content_encoding(mut self, x_ms_blob_content_encoding: impl Into<String>) -> Self {
                self.x_ms_blob_content_encoding = Some(x_ms_blob_content_encoding.into());
                self
            }
            pub fn x_ms_blob_content_language(mut self, x_ms_blob_content_language: impl Into<String>) -> Self {
                self.x_ms_blob_content_language = Some(x_ms_blob_content_language.into());
                self
            }
            pub fn x_ms_blob_content_md5(mut self, x_ms_blob_content_md5: impl Into<String>) -> Self {
                self.x_ms_blob_content_md5 = Some(x_ms_blob_content_md5.into());
                self
            }
            pub fn x_ms_blob_cache_control(mut self, x_ms_blob_cache_control: impl Into<String>) -> Self {
                self.x_ms_blob_cache_control = Some(x_ms_blob_cache_control.into());
                self
            }
            pub fn x_ms_meta(mut self, x_ms_meta: impl Into<String>) -> Self {
                self.x_ms_meta = Some(x_ms_meta.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_blob_content_disposition(mut self, x_ms_blob_content_disposition: impl Into<String>) -> Self {
                self.x_ms_blob_content_disposition = Some(x_ms_blob_content_disposition.into());
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn x_ms_encryption_scope(mut self, x_ms_encryption_scope: impl Into<String>) -> Self {
                self.x_ms_encryption_scope = Some(x_ms_encryption_scope.into());
                self
            }
            pub fn x_ms_access_tier(mut self, x_ms_access_tier: impl Into<String>) -> Self {
                self.x_ms_access_tier = Some(x_ms_access_tier.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_tags(mut self, x_ms_tags: impl Into<String>) -> Self {
                self.x_ms_tags = Some(x_ms_tags.into());
                self
            }
            pub fn x_ms_immutability_policy_until_date(mut self, x_ms_immutability_policy_until_date: impl Into<String>) -> Self {
                self.x_ms_immutability_policy_until_date = Some(x_ms_immutability_policy_until_date.into());
                self
            }
            pub fn x_ms_immutability_policy_mode(mut self, x_ms_immutability_policy_mode: impl Into<String>) -> Self {
                self.x_ms_immutability_policy_mode = Some(x_ms_immutability_policy_mode.into());
                self
            }
            pub fn x_ms_legal_hold(mut self, x_ms_legal_hold: bool) -> Self {
                self.x_ms_legal_hold = Some(x_ms_legal_hold);
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?BlockBlob", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    req_builder = req_builder.header("x-ms-blob-type", &self.x_ms_blob_type);
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.body).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(content_md5) = &self.content_md5 {
                        req_builder = req_builder.header("Content-MD5", content_md5);
                    }
                    req_builder = req_builder.header("Content-Length", &self.content_length.to_string());
                    if let Some(x_ms_blob_content_type) = &self.x_ms_blob_content_type {
                        req_builder = req_builder.header("x-ms-blob-content-type", x_ms_blob_content_type);
                    }
                    if let Some(x_ms_blob_content_encoding) = &self.x_ms_blob_content_encoding {
                        req_builder = req_builder.header("x-ms-blob-content-encoding", x_ms_blob_content_encoding);
                    }
                    if let Some(x_ms_blob_content_language) = &self.x_ms_blob_content_language {
                        req_builder = req_builder.header("x-ms-blob-content-language", x_ms_blob_content_language);
                    }
                    if let Some(x_ms_blob_content_md5) = &self.x_ms_blob_content_md5 {
                        req_builder = req_builder.header("x-ms-blob-content-md5", x_ms_blob_content_md5);
                    }
                    if let Some(x_ms_blob_cache_control) = &self.x_ms_blob_cache_control {
                        req_builder = req_builder.header("x-ms-blob-cache-control", x_ms_blob_cache_control);
                    }
                    if let Some(x_ms_meta) = &self.x_ms_meta {
                        req_builder = req_builder.header("x-ms-meta", x_ms_meta);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_blob_content_disposition) = &self.x_ms_blob_content_disposition {
                        req_builder = req_builder.header("x-ms-blob-content-disposition", x_ms_blob_content_disposition);
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(x_ms_encryption_scope) = &self.x_ms_encryption_scope {
                        req_builder = req_builder.header("x-ms-encryption-scope", x_ms_encryption_scope);
                    }
                    if let Some(x_ms_access_tier) = &self.x_ms_access_tier {
                        req_builder = req_builder.header("x-ms-access-tier", x_ms_access_tier);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(x_ms_tags) = &self.x_ms_tags {
                        req_builder = req_builder.header("x-ms-tags", x_ms_tags);
                    }
                    if let Some(x_ms_immutability_policy_until_date) = &self.x_ms_immutability_policy_until_date {
                        req_builder = req_builder.header("x-ms-immutability-policy-until-date", x_ms_immutability_policy_until_date);
                    }
                    if let Some(x_ms_immutability_policy_mode) = &self.x_ms_immutability_policy_mode {
                        req_builder = req_builder.header("x-ms-immutability-policy-mode", x_ms_immutability_policy_mode);
                    }
                    if let Some(x_ms_legal_hold) = &self.x_ms_legal_hold {
                        req_builder = req_builder.header("x-ms-legal-hold", &x_ms_legal_hold.to_string());
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod put_blob_from_url {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) x_ms_blob_type: String,
            pub(crate) content_length: i64,
            pub(crate) x_ms_version: String,
            pub(crate) x_ms_copy_source: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) content_md5: Option<String>,
            pub(crate) x_ms_blob_content_type: Option<String>,
            pub(crate) x_ms_blob_content_encoding: Option<String>,
            pub(crate) x_ms_blob_content_language: Option<String>,
            pub(crate) x_ms_blob_content_md5: Option<String>,
            pub(crate) x_ms_blob_cache_control: Option<String>,
            pub(crate) x_ms_meta: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_blob_content_disposition: Option<String>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) x_ms_encryption_scope: Option<String>,
            pub(crate) x_ms_access_tier: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_source_if_modified_since: Option<String>,
            pub(crate) x_ms_source_if_unmodified_since: Option<String>,
            pub(crate) x_ms_source_if_match: Option<String>,
            pub(crate) x_ms_source_if_none_match: Option<String>,
            pub(crate) x_ms_source_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_source_content_md5: Option<String>,
            pub(crate) x_ms_tags: Option<String>,
            pub(crate) x_ms_copy_source_blob_properties: Option<bool>,
            pub(crate) x_ms_copy_source_authorization: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn content_md5(mut self, content_md5: impl Into<String>) -> Self {
                self.content_md5 = Some(content_md5.into());
                self
            }
            pub fn x_ms_blob_content_type(mut self, x_ms_blob_content_type: impl Into<String>) -> Self {
                self.x_ms_blob_content_type = Some(x_ms_blob_content_type.into());
                self
            }
            pub fn x_ms_blob_content_encoding(mut self, x_ms_blob_content_encoding: impl Into<String>) -> Self {
                self.x_ms_blob_content_encoding = Some(x_ms_blob_content_encoding.into());
                self
            }
            pub fn x_ms_blob_content_language(mut self, x_ms_blob_content_language: impl Into<String>) -> Self {
                self.x_ms_blob_content_language = Some(x_ms_blob_content_language.into());
                self
            }
            pub fn x_ms_blob_content_md5(mut self, x_ms_blob_content_md5: impl Into<String>) -> Self {
                self.x_ms_blob_content_md5 = Some(x_ms_blob_content_md5.into());
                self
            }
            pub fn x_ms_blob_cache_control(mut self, x_ms_blob_cache_control: impl Into<String>) -> Self {
                self.x_ms_blob_cache_control = Some(x_ms_blob_cache_control.into());
                self
            }
            pub fn x_ms_meta(mut self, x_ms_meta: impl Into<String>) -> Self {
                self.x_ms_meta = Some(x_ms_meta.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_blob_content_disposition(mut self, x_ms_blob_content_disposition: impl Into<String>) -> Self {
                self.x_ms_blob_content_disposition = Some(x_ms_blob_content_disposition.into());
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn x_ms_encryption_scope(mut self, x_ms_encryption_scope: impl Into<String>) -> Self {
                self.x_ms_encryption_scope = Some(x_ms_encryption_scope.into());
                self
            }
            pub fn x_ms_access_tier(mut self, x_ms_access_tier: impl Into<String>) -> Self {
                self.x_ms_access_tier = Some(x_ms_access_tier.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_source_if_modified_since(mut self, x_ms_source_if_modified_since: impl Into<String>) -> Self {
                self.x_ms_source_if_modified_since = Some(x_ms_source_if_modified_since.into());
                self
            }
            pub fn x_ms_source_if_unmodified_since(mut self, x_ms_source_if_unmodified_since: impl Into<String>) -> Self {
                self.x_ms_source_if_unmodified_since = Some(x_ms_source_if_unmodified_since.into());
                self
            }
            pub fn x_ms_source_if_match(mut self, x_ms_source_if_match: impl Into<String>) -> Self {
                self.x_ms_source_if_match = Some(x_ms_source_if_match.into());
                self
            }
            pub fn x_ms_source_if_none_match(mut self, x_ms_source_if_none_match: impl Into<String>) -> Self {
                self.x_ms_source_if_none_match = Some(x_ms_source_if_none_match.into());
                self
            }
            pub fn x_ms_source_if_tags(mut self, x_ms_source_if_tags: impl Into<String>) -> Self {
                self.x_ms_source_if_tags = Some(x_ms_source_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_source_content_md5(mut self, x_ms_source_content_md5: impl Into<String>) -> Self {
                self.x_ms_source_content_md5 = Some(x_ms_source_content_md5.into());
                self
            }
            pub fn x_ms_tags(mut self, x_ms_tags: impl Into<String>) -> Self {
                self.x_ms_tags = Some(x_ms_tags.into());
                self
            }
            pub fn x_ms_copy_source_blob_properties(mut self, x_ms_copy_source_blob_properties: bool) -> Self {
                self.x_ms_copy_source_blob_properties = Some(x_ms_copy_source_blob_properties);
                self
            }
            pub fn x_ms_copy_source_authorization(mut self, x_ms_copy_source_authorization: impl Into<String>) -> Self {
                self.x_ms_copy_source_authorization = Some(x_ms_copy_source_authorization.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?BlockBlob&fromUrl",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    req_builder = req_builder.header("x-ms-blob-type", &self.x_ms_blob_type);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(content_md5) = &self.content_md5 {
                        req_builder = req_builder.header("Content-MD5", content_md5);
                    }
                    req_builder = req_builder.header("Content-Length", &self.content_length.to_string());
                    if let Some(x_ms_blob_content_type) = &self.x_ms_blob_content_type {
                        req_builder = req_builder.header("x-ms-blob-content-type", x_ms_blob_content_type);
                    }
                    if let Some(x_ms_blob_content_encoding) = &self.x_ms_blob_content_encoding {
                        req_builder = req_builder.header("x-ms-blob-content-encoding", x_ms_blob_content_encoding);
                    }
                    if let Some(x_ms_blob_content_language) = &self.x_ms_blob_content_language {
                        req_builder = req_builder.header("x-ms-blob-content-language", x_ms_blob_content_language);
                    }
                    if let Some(x_ms_blob_content_md5) = &self.x_ms_blob_content_md5 {
                        req_builder = req_builder.header("x-ms-blob-content-md5", x_ms_blob_content_md5);
                    }
                    if let Some(x_ms_blob_cache_control) = &self.x_ms_blob_cache_control {
                        req_builder = req_builder.header("x-ms-blob-cache-control", x_ms_blob_cache_control);
                    }
                    if let Some(x_ms_meta) = &self.x_ms_meta {
                        req_builder = req_builder.header("x-ms-meta", x_ms_meta);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_blob_content_disposition) = &self.x_ms_blob_content_disposition {
                        req_builder = req_builder.header("x-ms-blob-content-disposition", x_ms_blob_content_disposition);
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(x_ms_encryption_scope) = &self.x_ms_encryption_scope {
                        req_builder = req_builder.header("x-ms-encryption-scope", x_ms_encryption_scope);
                    }
                    if let Some(x_ms_access_tier) = &self.x_ms_access_tier {
                        req_builder = req_builder.header("x-ms-access-tier", x_ms_access_tier);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    if let Some(x_ms_source_if_modified_since) = &self.x_ms_source_if_modified_since {
                        req_builder = req_builder.header("x-ms-source-if-modified-since", x_ms_source_if_modified_since);
                    }
                    if let Some(x_ms_source_if_unmodified_since) = &self.x_ms_source_if_unmodified_since {
                        req_builder = req_builder.header("x-ms-source-if-unmodified-since", x_ms_source_if_unmodified_since);
                    }
                    if let Some(x_ms_source_if_match) = &self.x_ms_source_if_match {
                        req_builder = req_builder.header("x-ms-source-if-match", x_ms_source_if_match);
                    }
                    if let Some(x_ms_source_if_none_match) = &self.x_ms_source_if_none_match {
                        req_builder = req_builder.header("x-ms-source-if-none-match", x_ms_source_if_none_match);
                    }
                    if let Some(x_ms_source_if_tags) = &self.x_ms_source_if_tags {
                        req_builder = req_builder.header("x-ms-source-if-tags", x_ms_source_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(x_ms_source_content_md5) = &self.x_ms_source_content_md5 {
                        req_builder = req_builder.header("x-ms-source-content-md5", x_ms_source_content_md5);
                    }
                    if let Some(x_ms_tags) = &self.x_ms_tags {
                        req_builder = req_builder.header("x-ms-tags", x_ms_tags);
                    }
                    req_builder = req_builder.header("x-ms-copy-source", &self.x_ms_copy_source);
                    if let Some(x_ms_copy_source_blob_properties) = &self.x_ms_copy_source_blob_properties {
                        req_builder = req_builder.header("x-ms-copy-source-blob-properties", &x_ms_copy_source_blob_properties.to_string());
                    }
                    if let Some(x_ms_copy_source_authorization) = &self.x_ms_copy_source_authorization {
                        req_builder = req_builder.header("x-ms-copy-source-authorization", x_ms_copy_source_authorization);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod stage_block {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) blockid: String,
            pub(crate) content_length: i64,
            pub(crate) body: serde_json::Value,
            pub(crate) x_ms_version: String,
            pub(crate) content_md5: Option<String>,
            pub(crate) x_ms_content_crc64: Option<String>,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) x_ms_encryption_scope: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn content_md5(mut self, content_md5: impl Into<String>) -> Self {
                self.content_md5 = Some(content_md5.into());
                self
            }
            pub fn x_ms_content_crc64(mut self, x_ms_content_crc64: impl Into<String>) -> Self {
                self.x_ms_content_crc64 = Some(x_ms_content_crc64.into());
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn x_ms_encryption_scope(mut self, x_ms_encryption_scope: impl Into<String>) -> Self {
                self.x_ms_encryption_scope = Some(x_ms_encryption_scope.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=block", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    let blockid = &self.blockid;
                    url.query_pairs_mut().append_pair("blockid", blockid);
                    req_builder = req_builder.header("Content-Length", &self.content_length.to_string());
                    if let Some(content_md5) = &self.content_md5 {
                        req_builder = req_builder.header("Content-MD5", content_md5);
                    }
                    if let Some(x_ms_content_crc64) = &self.x_ms_content_crc64 {
                        req_builder = req_builder.header("x-ms-content-crc64", x_ms_content_crc64);
                    }
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.body).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(x_ms_encryption_scope) = &self.x_ms_encryption_scope {
                        req_builder = req_builder.header("x-ms-encryption-scope", x_ms_encryption_scope);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod stage_block_from_url {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) blockid: String,
            pub(crate) content_length: i64,
            pub(crate) x_ms_copy_source: String,
            pub(crate) x_ms_version: String,
            pub(crate) x_ms_source_range: Option<String>,
            pub(crate) x_ms_source_content_md5: Option<String>,
            pub(crate) x_ms_source_content_crc64: Option<String>,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) x_ms_encryption_scope: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_source_if_modified_since: Option<String>,
            pub(crate) x_ms_source_if_unmodified_since: Option<String>,
            pub(crate) x_ms_source_if_match: Option<String>,
            pub(crate) x_ms_source_if_none_match: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_copy_source_authorization: Option<String>,
        }
        impl Builder {
            pub fn x_ms_source_range(mut self, x_ms_source_range: impl Into<String>) -> Self {
                self.x_ms_source_range = Some(x_ms_source_range.into());
                self
            }
            pub fn x_ms_source_content_md5(mut self, x_ms_source_content_md5: impl Into<String>) -> Self {
                self.x_ms_source_content_md5 = Some(x_ms_source_content_md5.into());
                self
            }
            pub fn x_ms_source_content_crc64(mut self, x_ms_source_content_crc64: impl Into<String>) -> Self {
                self.x_ms_source_content_crc64 = Some(x_ms_source_content_crc64.into());
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn x_ms_encryption_scope(mut self, x_ms_encryption_scope: impl Into<String>) -> Self {
                self.x_ms_encryption_scope = Some(x_ms_encryption_scope.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_source_if_modified_since(mut self, x_ms_source_if_modified_since: impl Into<String>) -> Self {
                self.x_ms_source_if_modified_since = Some(x_ms_source_if_modified_since.into());
                self
            }
            pub fn x_ms_source_if_unmodified_since(mut self, x_ms_source_if_unmodified_since: impl Into<String>) -> Self {
                self.x_ms_source_if_unmodified_since = Some(x_ms_source_if_unmodified_since.into());
                self
            }
            pub fn x_ms_source_if_match(mut self, x_ms_source_if_match: impl Into<String>) -> Self {
                self.x_ms_source_if_match = Some(x_ms_source_if_match.into());
                self
            }
            pub fn x_ms_source_if_none_match(mut self, x_ms_source_if_none_match: impl Into<String>) -> Self {
                self.x_ms_source_if_none_match = Some(x_ms_source_if_none_match.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_copy_source_authorization(mut self, x_ms_copy_source_authorization: impl Into<String>) -> Self {
                self.x_ms_copy_source_authorization = Some(x_ms_copy_source_authorization.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/{}/{}?comp=block&fromURL",
                        self.client.endpoint(),
                        &self.container_name,
                        &self.blob
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    let blockid = &self.blockid;
                    url.query_pairs_mut().append_pair("blockid", blockid);
                    req_builder = req_builder.header("Content-Length", &self.content_length.to_string());
                    req_builder = req_builder.header("x-ms-copy-source", &self.x_ms_copy_source);
                    if let Some(x_ms_source_range) = &self.x_ms_source_range {
                        req_builder = req_builder.header("x-ms-source-range", x_ms_source_range);
                    }
                    if let Some(x_ms_source_content_md5) = &self.x_ms_source_content_md5 {
                        req_builder = req_builder.header("x-ms-source-content-md5", x_ms_source_content_md5);
                    }
                    if let Some(x_ms_source_content_crc64) = &self.x_ms_source_content_crc64 {
                        req_builder = req_builder.header("x-ms-source-content-crc64", x_ms_source_content_crc64);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(x_ms_encryption_scope) = &self.x_ms_encryption_scope {
                        req_builder = req_builder.header("x-ms-encryption-scope", x_ms_encryption_scope);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_source_if_modified_since) = &self.x_ms_source_if_modified_since {
                        req_builder = req_builder.header("x-ms-source-if-modified-since", x_ms_source_if_modified_since);
                    }
                    if let Some(x_ms_source_if_unmodified_since) = &self.x_ms_source_if_unmodified_since {
                        req_builder = req_builder.header("x-ms-source-if-unmodified-since", x_ms_source_if_unmodified_since);
                    }
                    if let Some(x_ms_source_if_match) = &self.x_ms_source_if_match {
                        req_builder = req_builder.header("x-ms-source-if-match", x_ms_source_if_match);
                    }
                    if let Some(x_ms_source_if_none_match) = &self.x_ms_source_if_none_match {
                        req_builder = req_builder.header("x-ms-source-if-none-match", x_ms_source_if_none_match);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(x_ms_copy_source_authorization) = &self.x_ms_copy_source_authorization {
                        req_builder = req_builder.header("x-ms-copy-source-authorization", x_ms_copy_source_authorization);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_block_list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) blocklisttype: String,
            pub(crate) x_ms_version: String,
            pub(crate) snapshot: Option<String>,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
        }
        impl Builder {
            pub fn snapshot(mut self, snapshot: impl Into<String>) -> Self {
                self.snapshot = Some(snapshot.into());
                self
            }
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::BlockList, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=blocklist", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(snapshot) = &self.snapshot {
                        url.query_pairs_mut().append_pair("snapshot", snapshot);
                    }
                    let blocklisttype = &self.blocklisttype;
                    url.query_pairs_mut().append_pair("blocklisttype", blocklisttype);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BlockList =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod commit_block_list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::StorageError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::StreamError),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) container_name: String,
            pub(crate) blob: String,
            pub(crate) comp: String,
            pub(crate) blocks: models::BlockLookupList,
            pub(crate) x_ms_version: String,
            pub(crate) timeout: Option<i64>,
            pub(crate) x_ms_blob_cache_control: Option<String>,
            pub(crate) x_ms_blob_content_type: Option<String>,
            pub(crate) x_ms_blob_content_encoding: Option<String>,
            pub(crate) x_ms_blob_content_language: Option<String>,
            pub(crate) x_ms_blob_content_md5: Option<String>,
            pub(crate) content_md5: Option<String>,
            pub(crate) x_ms_content_crc64: Option<String>,
            pub(crate) x_ms_meta: Option<String>,
            pub(crate) x_ms_lease_id: Option<String>,
            pub(crate) x_ms_blob_content_disposition: Option<String>,
            pub(crate) x_ms_encryption_key: Option<String>,
            pub(crate) x_ms_encryption_key_sha256: Option<String>,
            pub(crate) x_ms_encryption_algorithm: Option<String>,
            pub(crate) x_ms_encryption_scope: Option<String>,
            pub(crate) x_ms_access_tier: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) x_ms_if_tags: Option<String>,
            pub(crate) x_ms_client_request_id: Option<String>,
            pub(crate) x_ms_tags: Option<String>,
            pub(crate) x_ms_immutability_policy_until_date: Option<String>,
            pub(crate) x_ms_immutability_policy_mode: Option<String>,
            pub(crate) x_ms_legal_hold: Option<bool>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i64) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn x_ms_blob_cache_control(mut self, x_ms_blob_cache_control: impl Into<String>) -> Self {
                self.x_ms_blob_cache_control = Some(x_ms_blob_cache_control.into());
                self
            }
            pub fn x_ms_blob_content_type(mut self, x_ms_blob_content_type: impl Into<String>) -> Self {
                self.x_ms_blob_content_type = Some(x_ms_blob_content_type.into());
                self
            }
            pub fn x_ms_blob_content_encoding(mut self, x_ms_blob_content_encoding: impl Into<String>) -> Self {
                self.x_ms_blob_content_encoding = Some(x_ms_blob_content_encoding.into());
                self
            }
            pub fn x_ms_blob_content_language(mut self, x_ms_blob_content_language: impl Into<String>) -> Self {
                self.x_ms_blob_content_language = Some(x_ms_blob_content_language.into());
                self
            }
            pub fn x_ms_blob_content_md5(mut self, x_ms_blob_content_md5: impl Into<String>) -> Self {
                self.x_ms_blob_content_md5 = Some(x_ms_blob_content_md5.into());
                self
            }
            pub fn content_md5(mut self, content_md5: impl Into<String>) -> Self {
                self.content_md5 = Some(content_md5.into());
                self
            }
            pub fn x_ms_content_crc64(mut self, x_ms_content_crc64: impl Into<String>) -> Self {
                self.x_ms_content_crc64 = Some(x_ms_content_crc64.into());
                self
            }
            pub fn x_ms_meta(mut self, x_ms_meta: impl Into<String>) -> Self {
                self.x_ms_meta = Some(x_ms_meta.into());
                self
            }
            pub fn x_ms_lease_id(mut self, x_ms_lease_id: impl Into<String>) -> Self {
                self.x_ms_lease_id = Some(x_ms_lease_id.into());
                self
            }
            pub fn x_ms_blob_content_disposition(mut self, x_ms_blob_content_disposition: impl Into<String>) -> Self {
                self.x_ms_blob_content_disposition = Some(x_ms_blob_content_disposition.into());
                self
            }
            pub fn x_ms_encryption_key(mut self, x_ms_encryption_key: impl Into<String>) -> Self {
                self.x_ms_encryption_key = Some(x_ms_encryption_key.into());
                self
            }
            pub fn x_ms_encryption_key_sha256(mut self, x_ms_encryption_key_sha256: impl Into<String>) -> Self {
                self.x_ms_encryption_key_sha256 = Some(x_ms_encryption_key_sha256.into());
                self
            }
            pub fn x_ms_encryption_algorithm(mut self, x_ms_encryption_algorithm: impl Into<String>) -> Self {
                self.x_ms_encryption_algorithm = Some(x_ms_encryption_algorithm.into());
                self
            }
            pub fn x_ms_encryption_scope(mut self, x_ms_encryption_scope: impl Into<String>) -> Self {
                self.x_ms_encryption_scope = Some(x_ms_encryption_scope.into());
                self
            }
            pub fn x_ms_access_tier(mut self, x_ms_access_tier: impl Into<String>) -> Self {
                self.x_ms_access_tier = Some(x_ms_access_tier.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn x_ms_if_tags(mut self, x_ms_if_tags: impl Into<String>) -> Self {
                self.x_ms_if_tags = Some(x_ms_if_tags.into());
                self
            }
            pub fn x_ms_client_request_id(mut self, x_ms_client_request_id: impl Into<String>) -> Self {
                self.x_ms_client_request_id = Some(x_ms_client_request_id.into());
                self
            }
            pub fn x_ms_tags(mut self, x_ms_tags: impl Into<String>) -> Self {
                self.x_ms_tags = Some(x_ms_tags.into());
                self
            }
            pub fn x_ms_immutability_policy_until_date(mut self, x_ms_immutability_policy_until_date: impl Into<String>) -> Self {
                self.x_ms_immutability_policy_until_date = Some(x_ms_immutability_policy_until_date.into());
                self
            }
            pub fn x_ms_immutability_policy_mode(mut self, x_ms_immutability_policy_mode: impl Into<String>) -> Self {
                self.x_ms_immutability_policy_mode = Some(x_ms_immutability_policy_mode.into());
                self
            }
            pub fn x_ms_legal_hold(mut self, x_ms_legal_hold: bool) -> Self {
                self.x_ms_legal_hold = Some(x_ms_legal_hold);
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/{}/{}?comp=blocklist", self.client.endpoint(), &self.container_name, &self.blob);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    let comp = &self.comp;
                    url.query_pairs_mut().append_pair("comp", comp);
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(x_ms_blob_cache_control) = &self.x_ms_blob_cache_control {
                        req_builder = req_builder.header("x-ms-blob-cache-control", x_ms_blob_cache_control);
                    }
                    if let Some(x_ms_blob_content_type) = &self.x_ms_blob_content_type {
                        req_builder = req_builder.header("x-ms-blob-content-type", x_ms_blob_content_type);
                    }
                    if let Some(x_ms_blob_content_encoding) = &self.x_ms_blob_content_encoding {
                        req_builder = req_builder.header("x-ms-blob-content-encoding", x_ms_blob_content_encoding);
                    }
                    if let Some(x_ms_blob_content_language) = &self.x_ms_blob_content_language {
                        req_builder = req_builder.header("x-ms-blob-content-language", x_ms_blob_content_language);
                    }
                    if let Some(x_ms_blob_content_md5) = &self.x_ms_blob_content_md5 {
                        req_builder = req_builder.header("x-ms-blob-content-md5", x_ms_blob_content_md5);
                    }
                    if let Some(content_md5) = &self.content_md5 {
                        req_builder = req_builder.header("Content-MD5", content_md5);
                    }
                    if let Some(x_ms_content_crc64) = &self.x_ms_content_crc64 {
                        req_builder = req_builder.header("x-ms-content-crc64", x_ms_content_crc64);
                    }
                    if let Some(x_ms_meta) = &self.x_ms_meta {
                        req_builder = req_builder.header("x-ms-meta", x_ms_meta);
                    }
                    if let Some(x_ms_lease_id) = &self.x_ms_lease_id {
                        req_builder = req_builder.header("x-ms-lease-id", x_ms_lease_id);
                    }
                    if let Some(x_ms_blob_content_disposition) = &self.x_ms_blob_content_disposition {
                        req_builder = req_builder.header("x-ms-blob-content-disposition", x_ms_blob_content_disposition);
                    }
                    if let Some(x_ms_encryption_key) = &self.x_ms_encryption_key {
                        req_builder = req_builder.header("x-ms-encryption-key", x_ms_encryption_key);
                    }
                    if let Some(x_ms_encryption_key_sha256) = &self.x_ms_encryption_key_sha256 {
                        req_builder = req_builder.header("x-ms-encryption-key-sha256", x_ms_encryption_key_sha256);
                    }
                    if let Some(x_ms_encryption_algorithm) = &self.x_ms_encryption_algorithm {
                        req_builder = req_builder.header("x-ms-encryption-algorithm", x_ms_encryption_algorithm);
                    }
                    if let Some(x_ms_encryption_scope) = &self.x_ms_encryption_scope {
                        req_builder = req_builder.header("x-ms-encryption-scope", x_ms_encryption_scope);
                    }
                    if let Some(x_ms_access_tier) = &self.x_ms_access_tier {
                        req_builder = req_builder.header("x-ms-access-tier", x_ms_access_tier);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(x_ms_if_tags) = &self.x_ms_if_tags {
                        req_builder = req_builder.header("x-ms-if-tags", x_ms_if_tags);
                    }
                    req_builder = req_builder.header("content-type", "application/json");
                    let req_body = azure_core::to_json(&self.blocks).map_err(Error::Serialize)?;
                    req_builder = req_builder.header("x-ms-version", &self.x_ms_version);
                    if let Some(x_ms_client_request_id) = &self.x_ms_client_request_id {
                        req_builder = req_builder.header("x-ms-client-request-id", x_ms_client_request_id);
                    }
                    if let Some(x_ms_tags) = &self.x_ms_tags {
                        req_builder = req_builder.header("x-ms-tags", x_ms_tags);
                    }
                    if let Some(x_ms_immutability_policy_until_date) = &self.x_ms_immutability_policy_until_date {
                        req_builder = req_builder.header("x-ms-immutability-policy-until-date", x_ms_immutability_policy_until_date);
                    }
                    if let Some(x_ms_immutability_policy_mode) = &self.x_ms_immutability_policy_mode {
                        req_builder = req_builder.header("x-ms-immutability-policy-mode", x_ms_immutability_policy_mode);
                    }
                    if let Some(x_ms_legal_hold) = &self.x_ms_legal_hold {
                        req_builder = req_builder.header("x-ms-legal-hold", &x_ms_legal_hold.to_string());
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::StorageError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
