#![doc = "generated by AutoRust"]
#![allow(unused_mut)]
#![allow(unused_variables)]
#![allow(unused_imports)]
use super::models;
#[derive(Clone)]
pub struct Client {
    endpoint: String,
    credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
    scopes: Vec<String>,
    pipeline: azure_core::Pipeline,
}
#[derive(Clone)]
pub struct ClientBuilder {
    credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
    endpoint: Option<String>,
    scopes: Option<Vec<String>>,
}
pub const DEFAULT_ENDPOINT: &str = "https://batch.core.windows.net";
impl ClientBuilder {
    pub fn new(credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>) -> Self {
        Self {
            credential,
            endpoint: None,
            scopes: None,
        }
    }
    pub fn endpoint(mut self, endpoint: impl Into<String>) -> Self {
        self.endpoint = Some(endpoint.into());
        self
    }
    pub fn scopes(mut self, scopes: &[&str]) -> Self {
        self.scopes = Some(scopes.iter().map(|scope| (*scope).to_owned()).collect());
        self
    }
    pub fn build(self) -> Client {
        let endpoint = self.endpoint.unwrap_or_else(|| DEFAULT_ENDPOINT.to_owned());
        let scopes = self.scopes.unwrap_or_else(|| vec![format!("{}/", endpoint)]);
        Client::new(endpoint, self.credential, scopes)
    }
}
impl Client {
    pub(crate) fn endpoint(&self) -> &str {
        self.endpoint.as_str()
    }
    pub(crate) fn token_credential(&self) -> &dyn azure_core::auth::TokenCredential {
        self.credential.as_ref()
    }
    pub(crate) fn scopes(&self) -> Vec<&str> {
        self.scopes.iter().map(String::as_str).collect()
    }
    pub(crate) async fn send(&self, request: impl Into<azure_core::Request>) -> azure_core::error::Result<azure_core::Response> {
        let mut context = azure_core::Context::default();
        let mut request = request.into();
        self.pipeline.send(&mut context, &mut request).await
    }
    pub fn new(
        endpoint: impl Into<String>,
        credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
        scopes: Vec<String>,
    ) -> Self {
        let endpoint = endpoint.into();
        let pipeline = azure_core::Pipeline::new(
            option_env!("CARGO_PKG_NAME"),
            option_env!("CARGO_PKG_VERSION"),
            azure_core::ClientOptions::default(),
            Vec::new(),
            Vec::new(),
        );
        Self {
            endpoint,
            credential,
            scopes,
            pipeline,
        }
    }
    pub fn account(&self) -> account::Client {
        account::Client(self.clone())
    }
    pub fn application(&self) -> application::Client {
        application::Client(self.clone())
    }
    pub fn certificate(&self) -> certificate::Client {
        certificate::Client(self.clone())
    }
    pub fn compute_node(&self) -> compute_node::Client {
        compute_node::Client(self.clone())
    }
    pub fn file(&self) -> file::Client {
        file::Client(self.clone())
    }
    pub fn job(&self) -> job::Client {
        job::Client(self.clone())
    }
    pub fn job_schedule(&self) -> job_schedule::Client {
        job_schedule::Client(self.clone())
    }
    pub fn pool(&self) -> pool::Client {
        pool::Client(self.clone())
    }
    pub fn task(&self) -> task::Client {
        task::Client(self.clone())
    }
}
#[non_exhaustive]
#[derive(Debug, thiserror :: Error)]
#[allow(non_camel_case_types)]
pub enum Error {
    #[error(transparent)]
    Application_List(#[from] application::list::Error),
    #[error(transparent)]
    Application_Get(#[from] application::get::Error),
    #[error(transparent)]
    Pool_ListUsageMetrics(#[from] pool::list_usage_metrics::Error),
    #[error(transparent)]
    Account_ListNodeAgentSkus(#[from] account::list_node_agent_skus::Error),
    #[error(transparent)]
    Pool_GetAllLifetimeStatistics(#[from] pool::get_all_lifetime_statistics::Error),
    #[error(transparent)]
    Job_GetAllLifetimeStatistics(#[from] job::get_all_lifetime_statistics::Error),
    #[error(transparent)]
    Certificate_List(#[from] certificate::list::Error),
    #[error(transparent)]
    Certificate_Add(#[from] certificate::add::Error),
    #[error(transparent)]
    Certificate_CancelDeletion(#[from] certificate::cancel_deletion::Error),
    #[error(transparent)]
    Certificate_Get(#[from] certificate::get::Error),
    #[error(transparent)]
    Certificate_Delete(#[from] certificate::delete::Error),
    #[error(transparent)]
    File_GetFromTask(#[from] file::get_from_task::Error),
    #[error(transparent)]
    File_DeleteFromTask(#[from] file::delete_from_task::Error),
    #[error(transparent)]
    File_GetPropertiesFromTask(#[from] file::get_properties_from_task::Error),
    #[error(transparent)]
    File_GetFromComputeNode(#[from] file::get_from_compute_node::Error),
    #[error(transparent)]
    File_DeleteFromComputeNode(#[from] file::delete_from_compute_node::Error),
    #[error(transparent)]
    File_GetPropertiesFromComputeNode(#[from] file::get_properties_from_compute_node::Error),
    #[error(transparent)]
    File_ListFromTask(#[from] file::list_from_task::Error),
    #[error(transparent)]
    File_ListFromComputeNode(#[from] file::list_from_compute_node::Error),
    #[error(transparent)]
    JobSchedule_Get(#[from] job_schedule::get::Error),
    #[error(transparent)]
    JobSchedule_Update(#[from] job_schedule::update::Error),
    #[error(transparent)]
    JobSchedule_Patch(#[from] job_schedule::patch::Error),
    #[error(transparent)]
    JobSchedule_Delete(#[from] job_schedule::delete::Error),
    #[error(transparent)]
    JobSchedule_Exists(#[from] job_schedule::exists::Error),
    #[error(transparent)]
    JobSchedule_Disable(#[from] job_schedule::disable::Error),
    #[error(transparent)]
    JobSchedule_Enable(#[from] job_schedule::enable::Error),
    #[error(transparent)]
    JobSchedule_Terminate(#[from] job_schedule::terminate::Error),
    #[error(transparent)]
    JobSchedule_List(#[from] job_schedule::list::Error),
    #[error(transparent)]
    JobSchedule_Add(#[from] job_schedule::add::Error),
    #[error(transparent)]
    Job_Get(#[from] job::get::Error),
    #[error(transparent)]
    Job_Update(#[from] job::update::Error),
    #[error(transparent)]
    Job_Patch(#[from] job::patch::Error),
    #[error(transparent)]
    Job_Delete(#[from] job::delete::Error),
    #[error(transparent)]
    Job_Disable(#[from] job::disable::Error),
    #[error(transparent)]
    Job_Enable(#[from] job::enable::Error),
    #[error(transparent)]
    Job_Terminate(#[from] job::terminate::Error),
    #[error(transparent)]
    Job_List(#[from] job::list::Error),
    #[error(transparent)]
    Job_Add(#[from] job::add::Error),
    #[error(transparent)]
    Job_ListFromJobSchedule(#[from] job::list_from_job_schedule::Error),
    #[error(transparent)]
    Job_ListPreparationAndReleaseTaskStatus(#[from] job::list_preparation_and_release_task_status::Error),
    #[error(transparent)]
    Job_GetTaskCounts(#[from] job::get_task_counts::Error),
    #[error(transparent)]
    Pool_List(#[from] pool::list::Error),
    #[error(transparent)]
    Pool_Add(#[from] pool::add::Error),
    #[error(transparent)]
    Pool_Get(#[from] pool::get::Error),
    #[error(transparent)]
    Pool_Patch(#[from] pool::patch::Error),
    #[error(transparent)]
    Pool_Delete(#[from] pool::delete::Error),
    #[error(transparent)]
    Pool_Exists(#[from] pool::exists::Error),
    #[error(transparent)]
    Pool_DisableAutoScale(#[from] pool::disable_auto_scale::Error),
    #[error(transparent)]
    Pool_EnableAutoScale(#[from] pool::enable_auto_scale::Error),
    #[error(transparent)]
    Pool_EvaluateAutoScale(#[from] pool::evaluate_auto_scale::Error),
    #[error(transparent)]
    Pool_Resize(#[from] pool::resize::Error),
    #[error(transparent)]
    Pool_StopResize(#[from] pool::stop_resize::Error),
    #[error(transparent)]
    Pool_UpdateProperties(#[from] pool::update_properties::Error),
    #[error(transparent)]
    Pool_UpgradeOs(#[from] pool::upgrade_os::Error),
    #[error(transparent)]
    Pool_RemoveNodes(#[from] pool::remove_nodes::Error),
    #[error(transparent)]
    Task_List(#[from] task::list::Error),
    #[error(transparent)]
    Task_Add(#[from] task::add::Error),
    #[error(transparent)]
    Task_AddCollection(#[from] task::add_collection::Error),
    #[error(transparent)]
    Task_Get(#[from] task::get::Error),
    #[error(transparent)]
    Task_Update(#[from] task::update::Error),
    #[error(transparent)]
    Task_Delete(#[from] task::delete::Error),
    #[error(transparent)]
    Task_ListSubtasks(#[from] task::list_subtasks::Error),
    #[error(transparent)]
    Task_Terminate(#[from] task::terminate::Error),
    #[error(transparent)]
    Task_Reactivate(#[from] task::reactivate::Error),
    #[error(transparent)]
    ComputeNode_AddUser(#[from] compute_node::add_user::Error),
    #[error(transparent)]
    ComputeNode_UpdateUser(#[from] compute_node::update_user::Error),
    #[error(transparent)]
    ComputeNode_DeleteUser(#[from] compute_node::delete_user::Error),
    #[error(transparent)]
    ComputeNode_Get(#[from] compute_node::get::Error),
    #[error(transparent)]
    ComputeNode_Reboot(#[from] compute_node::reboot::Error),
    #[error(transparent)]
    ComputeNode_Reimage(#[from] compute_node::reimage::Error),
    #[error(transparent)]
    ComputeNode_DisableScheduling(#[from] compute_node::disable_scheduling::Error),
    #[error(transparent)]
    ComputeNode_EnableScheduling(#[from] compute_node::enable_scheduling::Error),
    #[error(transparent)]
    ComputeNode_GetRemoteLoginSettings(#[from] compute_node::get_remote_login_settings::Error),
    #[error(transparent)]
    ComputeNode_GetRemoteDesktop(#[from] compute_node::get_remote_desktop::Error),
    #[error(transparent)]
    ComputeNode_List(#[from] compute_node::list::Error),
}
pub mod application {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "Lists all of the applications available in the specified account."]
        pub fn list(&self) -> list::Builder {
            list::Builder {
                client: self.0.clone(),
                maxresults: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Gets information about the specified application."]
        pub fn get(&self, application_id: impl Into<String>) -> get::Builder {
            get::Builder {
                client: self.0.clone(),
                application_id: application_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
    }
    pub mod list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) maxresults: Option<i32>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn maxresults(mut self, maxresults: i32) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ApplicationListResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/applications", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ApplicationListResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) application_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ApplicationSummary, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/applications/{}", self.client.endpoint(), &self.application_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ApplicationSummary =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod pool {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "Lists the usage metrics, aggregated by pool across individual time intervals, for the specified account."]
        pub fn list_usage_metrics(&self) -> list_usage_metrics::Builder {
            list_usage_metrics::Builder {
                client: self.0.clone(),
                starttime: None,
                endtime: None,
                filter: None,
                maxresults: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Gets lifetime summary statistics for all of the pools in the specified account."]
        pub fn get_all_lifetime_statistics(&self) -> get_all_lifetime_statistics::Builder {
            get_all_lifetime_statistics::Builder {
                client: self.0.clone(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Lists all of the pools in the specified account."]
        pub fn list(&self) -> list::Builder {
            list::Builder {
                client: self.0.clone(),
                filter: None,
                select: None,
                expand: None,
                maxresults: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Adds a pool to the specified account."]
        pub fn add(&self, pool: impl Into<models::PoolAddParameter>) -> add::Builder {
            add::Builder {
                client: self.0.clone(),
                pool: pool.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        pub fn get(&self, pool_id: impl Into<String>) -> get::Builder {
            get::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                select: None,
                expand: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Updates the properties of the specified pool."]
        pub fn patch(&self, pool_id: impl Into<String>, pool_patch_parameter: impl Into<models::PoolPatchParameter>) -> patch::Builder {
            patch::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                pool_patch_parameter: pool_patch_parameter.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Deletes a pool from the specified account."]
        pub fn delete(&self, pool_id: impl Into<String>) -> delete::Builder {
            delete::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        pub fn exists(&self, pool_id: impl Into<String>) -> exists::Builder {
            exists::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Disables automatic scaling for a pool."]
        pub fn disable_auto_scale(&self, pool_id: impl Into<String>) -> disable_auto_scale::Builder {
            disable_auto_scale::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Enables automatic scaling for a pool."]
        pub fn enable_auto_scale(
            &self,
            pool_id: impl Into<String>,
            pool_enable_auto_scale_parameter: impl Into<models::PoolEnableAutoScaleParameter>,
        ) -> enable_auto_scale::Builder {
            enable_auto_scale::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                pool_enable_auto_scale_parameter: pool_enable_auto_scale_parameter.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Gets the result of evaluating an automatic scaling formula on the pool."]
        pub fn evaluate_auto_scale(
            &self,
            pool_id: impl Into<String>,
            pool_evaluate_auto_scale_parameter: impl Into<models::PoolEvaluateAutoScaleParameter>,
        ) -> evaluate_auto_scale::Builder {
            evaluate_auto_scale::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                pool_evaluate_auto_scale_parameter: pool_evaluate_auto_scale_parameter.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Changes the number of compute nodes that are assigned to a pool."]
        pub fn resize(&self, pool_id: impl Into<String>, pool_resize_parameter: impl Into<models::PoolResizeParameter>) -> resize::Builder {
            resize::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                pool_resize_parameter: pool_resize_parameter.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Stops an ongoing resize operation on the pool."]
        pub fn stop_resize(&self, pool_id: impl Into<String>) -> stop_resize::Builder {
            stop_resize::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Updates the properties of the specified pool."]
        pub fn update_properties(
            &self,
            pool_id: impl Into<String>,
            pool_update_properties_parameter: impl Into<models::PoolUpdatePropertiesParameter>,
        ) -> update_properties::Builder {
            update_properties::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                pool_update_properties_parameter: pool_update_properties_parameter.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Upgrades the operating system of the specified pool."]
        pub fn upgrade_os(
            &self,
            pool_id: impl Into<String>,
            pool_upgrade_os_parameter: impl Into<models::PoolUpgradeOsParameter>,
        ) -> upgrade_os::Builder {
            upgrade_os::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                pool_upgrade_os_parameter: pool_upgrade_os_parameter.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Removes compute nodes from the specified pool."]
        pub fn remove_nodes(
            &self,
            pool_id: impl Into<String>,
            node_remove_parameter: impl Into<models::NodeRemoveParameter>,
        ) -> remove_nodes::Builder {
            remove_nodes::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                node_remove_parameter: node_remove_parameter.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
    }
    pub mod list_usage_metrics {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) starttime: Option<String>,
            pub(crate) endtime: Option<String>,
            pub(crate) filter: Option<String>,
            pub(crate) maxresults: Option<i32>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn starttime(mut self, starttime: impl Into<String>) -> Self {
                self.starttime = Some(starttime.into());
                self
            }
            pub fn endtime(mut self, endtime: impl Into<String>) -> Self {
                self.endtime = Some(endtime.into());
                self
            }
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn maxresults(mut self, maxresults: i32) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::PoolListUsageMetricsResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/poolusagemetrics", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(starttime) = &self.starttime {
                        url.query_pairs_mut().append_pair("starttime", starttime);
                    }
                    if let Some(endtime) = &self.endtime {
                        url.query_pairs_mut().append_pair("endtime", endtime);
                    }
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PoolListUsageMetricsResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_all_lifetime_statistics {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::PoolStatistics, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/lifetimepoolstats", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::PoolStatistics =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) filter: Option<String>,
            pub(crate) select: Option<String>,
            pub(crate) expand: Option<String>,
            pub(crate) maxresults: Option<i32>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn select(mut self, select: impl Into<String>) -> Self {
                self.select = Some(select.into());
                self
            }
            pub fn expand(mut self, expand: impl Into<String>) -> Self {
                self.expand = Some(expand.into());
                self
            }
            pub fn maxresults(mut self, maxresults: i32) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::CloudPoolListResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    if let Some(select) = &self.select {
                        url.query_pairs_mut().append_pair("$select", select);
                    }
                    if let Some(expand) = &self.expand {
                        url.query_pairs_mut().append_pair("$expand", expand);
                    }
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CloudPoolListResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod add {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool: models::PoolAddParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.pool).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) select: Option<String>,
            pub(crate) expand: Option<String>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn select(mut self, select: impl Into<String>) -> Self {
                self.select = Some(select.into());
                self
            }
            pub fn expand(mut self, expand: impl Into<String>) -> Self {
                self.expand = Some(expand.into());
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::CloudPool, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}", self.client.endpoint(), &self.pool_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(select) = &self.select {
                        url.query_pairs_mut().append_pair("$select", select);
                    }
                    if let Some(expand) = &self.expand {
                        url.query_pairs_mut().append_pair("$expand", expand);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CloudPool =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod patch {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) pool_patch_parameter: models::PoolPatchParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}", self.client.endpoint(), &self.pool_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.pool_patch_parameter).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}", self.client.endpoint(), &self.pool_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod exists {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}", self.client.endpoint(), &self.pool_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::HEAD);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod disable_auto_scale {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}/disableautoscale", self.client.endpoint(), &self.pool_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod enable_auto_scale {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) pool_enable_auto_scale_parameter: models::PoolEnableAutoScaleParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}/enableautoscale", self.client.endpoint(), &self.pool_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.pool_enable_auto_scale_parameter).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod evaluate_auto_scale {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) pool_evaluate_auto_scale_parameter: models::PoolEvaluateAutoScaleParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::AutoScaleRun, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}/evaluateautoscale", self.client.endpoint(), &self.pool_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.pool_evaluate_auto_scale_parameter).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AutoScaleRun =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod resize {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) pool_resize_parameter: models::PoolResizeParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}/resize", self.client.endpoint(), &self.pool_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.pool_resize_parameter).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod stop_resize {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}/stopresize", self.client.endpoint(), &self.pool_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_properties {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) pool_update_properties_parameter: models::PoolUpdatePropertiesParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}/updateproperties", self.client.endpoint(), &self.pool_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.pool_update_properties_parameter).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod upgrade_os {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) pool_upgrade_os_parameter: models::PoolUpgradeOsParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}/upgradeos", self.client.endpoint(), &self.pool_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.pool_upgrade_os_parameter).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod remove_nodes {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) node_remove_parameter: models::NodeRemoveParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}/removenodes", self.client.endpoint(), &self.pool_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.node_remove_parameter).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod account {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "Lists all node agent SKUs supported by the Azure Batch service."]
        pub fn list_node_agent_skus(&self) -> list_node_agent_skus::Builder {
            list_node_agent_skus::Builder {
                client: self.0.clone(),
                filter: None,
                maxresults: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
    }
    pub mod list_node_agent_skus {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) filter: Option<String>,
            pub(crate) maxresults: Option<i32>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn maxresults(mut self, maxresults: i32) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::AccountListNodeAgentSkusResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/nodeagentskus", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::AccountListNodeAgentSkusResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod job {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "Gets lifetime summary statistics for all of the jobs in the specified account."]
        pub fn get_all_lifetime_statistics(&self) -> get_all_lifetime_statistics::Builder {
            get_all_lifetime_statistics::Builder {
                client: self.0.clone(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Gets information about the specified job."]
        pub fn get(&self, job_id: impl Into<String>) -> get::Builder {
            get::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                select: None,
                expand: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Updates the properties of the specified job."]
        pub fn update(&self, job_id: impl Into<String>, job_update_parameter: impl Into<models::JobUpdateParameter>) -> update::Builder {
            update::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                job_update_parameter: job_update_parameter.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Updates the properties of the specified job."]
        pub fn patch(&self, job_id: impl Into<String>, job_patch_parameter: impl Into<models::JobPatchParameter>) -> patch::Builder {
            patch::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                job_patch_parameter: job_patch_parameter.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Deletes a job."]
        pub fn delete(&self, job_id: impl Into<String>) -> delete::Builder {
            delete::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Disables the specified job, preventing new tasks from running."]
        pub fn disable(
            &self,
            job_id: impl Into<String>,
            job_disable_parameter: impl Into<models::JobDisableParameter>,
        ) -> disable::Builder {
            disable::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                job_disable_parameter: job_disable_parameter.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Enables the specified job, allowing new tasks to run."]
        pub fn enable(&self, job_id: impl Into<String>) -> enable::Builder {
            enable::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Terminates the specified job, marking it as completed."]
        pub fn terminate(&self, job_id: impl Into<String>) -> terminate::Builder {
            terminate::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                job_terminate_parameter: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Lists all of the jobs in the specified account."]
        pub fn list(&self) -> list::Builder {
            list::Builder {
                client: self.0.clone(),
                filter: None,
                select: None,
                expand: None,
                maxresults: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Adds a job to the specified account."]
        pub fn add(&self, job: impl Into<models::JobAddParameter>) -> add::Builder {
            add::Builder {
                client: self.0.clone(),
                job: job.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Lists the jobs that have been created under the specified job schedule."]
        pub fn list_from_job_schedule(&self, job_schedule_id: impl Into<String>) -> list_from_job_schedule::Builder {
            list_from_job_schedule::Builder {
                client: self.0.clone(),
                job_schedule_id: job_schedule_id.into(),
                filter: None,
                select: None,
                expand: None,
                maxresults: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Lists the execution status of the Job Preparation and Job Release task for the specified job across the compute nodes where the job has run."]
        pub fn list_preparation_and_release_task_status(
            &self,
            job_id: impl Into<String>,
        ) -> list_preparation_and_release_task_status::Builder {
            list_preparation_and_release_task_status::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                filter: None,
                select: None,
                maxresults: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Gets the task counts for the specified job."]
        pub fn get_task_counts(&self, job_id: impl Into<String>) -> get_task_counts::Builder {
            get_task_counts::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
    }
    pub mod get_all_lifetime_statistics {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::JobStatistics, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/lifetimejobstats", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::JobStatistics =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) select: Option<String>,
            pub(crate) expand: Option<String>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn select(mut self, select: impl Into<String>) -> Self {
                self.select = Some(select.into());
                self
            }
            pub fn expand(mut self, expand: impl Into<String>) -> Self {
                self.expand = Some(expand.into());
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::CloudJob, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs/{}", self.client.endpoint(), &self.job_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(select) = &self.select {
                        url.query_pairs_mut().append_pair("$select", select);
                    }
                    if let Some(expand) = &self.expand {
                        url.query_pairs_mut().append_pair("$expand", expand);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CloudJob =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) job_update_parameter: models::JobUpdateParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs/{}", self.client.endpoint(), &self.job_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.job_update_parameter).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod patch {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) job_patch_parameter: models::JobPatchParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs/{}", self.client.endpoint(), &self.job_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.job_patch_parameter).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs/{}", self.client.endpoint(), &self.job_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod disable {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) job_disable_parameter: models::JobDisableParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs/{}/disable", self.client.endpoint(), &self.job_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.job_disable_parameter).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod enable {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs/{}/enable", self.client.endpoint(), &self.job_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod terminate {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) job_terminate_parameter: Option<models::JobTerminateParameter>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn job_terminate_parameter(mut self, job_terminate_parameter: impl Into<models::JobTerminateParameter>) -> Self {
                self.job_terminate_parameter = Some(job_terminate_parameter.into());
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs/{}/terminate", self.client.endpoint(), &self.job_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    let req_body = if let Some(job_terminate_parameter) = &self.job_terminate_parameter {
                        req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                        azure_core::to_json(job_terminate_parameter).map_err(Error::Serialize)?
                    } else {
                        azure_core::EMPTY_BODY
                    };
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) filter: Option<String>,
            pub(crate) select: Option<String>,
            pub(crate) expand: Option<String>,
            pub(crate) maxresults: Option<i32>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn select(mut self, select: impl Into<String>) -> Self {
                self.select = Some(select.into());
                self
            }
            pub fn expand(mut self, expand: impl Into<String>) -> Self {
                self.expand = Some(expand.into());
                self
            }
            pub fn maxresults(mut self, maxresults: i32) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::CloudJobListResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    if let Some(select) = &self.select {
                        url.query_pairs_mut().append_pair("$select", select);
                    }
                    if let Some(expand) = &self.expand {
                        url.query_pairs_mut().append_pair("$expand", expand);
                    }
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CloudJobListResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod add {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job: models::JobAddParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.job).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_from_job_schedule {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_schedule_id: String,
            pub(crate) filter: Option<String>,
            pub(crate) select: Option<String>,
            pub(crate) expand: Option<String>,
            pub(crate) maxresults: Option<i32>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn select(mut self, select: impl Into<String>) -> Self {
                self.select = Some(select.into());
                self
            }
            pub fn expand(mut self, expand: impl Into<String>) -> Self {
                self.expand = Some(expand.into());
                self
            }
            pub fn maxresults(mut self, maxresults: i32) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::CloudJobListResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobschedules/{}/jobs", self.client.endpoint(), &self.job_schedule_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    if let Some(select) = &self.select {
                        url.query_pairs_mut().append_pair("$select", select);
                    }
                    if let Some(expand) = &self.expand {
                        url.query_pairs_mut().append_pair("$expand", expand);
                    }
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CloudJobListResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_preparation_and_release_task_status {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) filter: Option<String>,
            pub(crate) select: Option<String>,
            pub(crate) maxresults: Option<i32>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn select(mut self, select: impl Into<String>) -> Self {
                self.select = Some(select.into());
                self
            }
            pub fn maxresults(mut self, maxresults: i32) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::CloudJobListPreparationAndReleaseTaskStatusResult, Error>>
            {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/jobs/{}/jobpreparationandreleasetaskstatus",
                        self.client.endpoint(),
                        &self.job_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    if let Some(select) = &self.select {
                        url.query_pairs_mut().append_pair("$select", select);
                    }
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CloudJobListPreparationAndReleaseTaskStatusResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_task_counts {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::TaskCounts, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs/{}/taskcounts", self.client.endpoint(), &self.job_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::TaskCounts =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod certificate {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "Lists all of the certificates that have been added to the specified account."]
        pub fn list(&self) -> list::Builder {
            list::Builder {
                client: self.0.clone(),
                filter: None,
                select: None,
                maxresults: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Adds a certificate to the specified account."]
        pub fn add(&self, certificate: impl Into<models::CertificateAddParameter>) -> add::Builder {
            add::Builder {
                client: self.0.clone(),
                certificate: certificate.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Cancels a failed deletion of a certificate from the specified account."]
        pub fn cancel_deletion(&self, thumbprint_algorithm: impl Into<String>, thumbprint: impl Into<String>) -> cancel_deletion::Builder {
            cancel_deletion::Builder {
                client: self.0.clone(),
                thumbprint_algorithm: thumbprint_algorithm.into(),
                thumbprint: thumbprint.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        pub fn get(&self, thumbprint_algorithm: impl Into<String>, thumbprint: impl Into<String>) -> get::Builder {
            get::Builder {
                client: self.0.clone(),
                thumbprint_algorithm: thumbprint_algorithm.into(),
                thumbprint: thumbprint.into(),
                select: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Deletes a certificate from the specified account."]
        pub fn delete(&self, thumbprint_algorithm: impl Into<String>, thumbprint: impl Into<String>) -> delete::Builder {
            delete::Builder {
                client: self.0.clone(),
                thumbprint_algorithm: thumbprint_algorithm.into(),
                thumbprint: thumbprint.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
    }
    pub mod list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) filter: Option<String>,
            pub(crate) select: Option<String>,
            pub(crate) maxresults: Option<i32>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn select(mut self, select: impl Into<String>) -> Self {
                self.select = Some(select.into());
                self
            }
            pub fn maxresults(mut self, maxresults: i32) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::CertificateListResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/certificates", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    if let Some(select) = &self.select {
                        url.query_pairs_mut().append_pair("$select", select);
                    }
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CertificateListResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod add {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) certificate: models::CertificateAddParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/certificates", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.certificate).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod cancel_deletion {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) thumbprint_algorithm: String,
            pub(crate) thumbprint: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/certificates(thumbprintAlgorithm={},thumbprint={})/canceldelete",
                        self.client.endpoint(),
                        &self.thumbprint_algorithm,
                        &self.thumbprint
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) thumbprint_algorithm: String,
            pub(crate) thumbprint: String,
            pub(crate) select: Option<String>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn select(mut self, select: impl Into<String>) -> Self {
                self.select = Some(select.into());
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::Certificate, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/certificates(thumbprintAlgorithm={},thumbprint={})",
                        self.client.endpoint(),
                        &self.thumbprint_algorithm,
                        &self.thumbprint
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(select) = &self.select {
                        url.query_pairs_mut().append_pair("$select", select);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::Certificate =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) thumbprint_algorithm: String,
            pub(crate) thumbprint: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/certificates(thumbprintAlgorithm={},thumbprint={})",
                        self.client.endpoint(),
                        &self.thumbprint_algorithm,
                        &self.thumbprint
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod file {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        pub fn get_from_task(
            &self,
            job_id: impl Into<String>,
            task_id: impl Into<String>,
            file_path: impl Into<String>,
        ) -> get_from_task::Builder {
            get_from_task::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                task_id: task_id.into(),
                file_path: file_path.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                ocp_range: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Deletes the specified task file from the compute node where the task ran."]
        pub fn delete_from_task(
            &self,
            job_id: impl Into<String>,
            task_id: impl Into<String>,
            file_path: impl Into<String>,
        ) -> delete_from_task::Builder {
            delete_from_task::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                task_id: task_id.into(),
                file_path: file_path.into(),
                recursive: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        pub fn get_properties_from_task(
            &self,
            job_id: impl Into<String>,
            task_id: impl Into<String>,
            file_path: impl Into<String>,
        ) -> get_properties_from_task::Builder {
            get_properties_from_task::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                task_id: task_id.into(),
                file_path: file_path.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        pub fn get_from_compute_node(
            &self,
            pool_id: impl Into<String>,
            node_id: impl Into<String>,
            file_path: impl Into<String>,
        ) -> get_from_compute_node::Builder {
            get_from_compute_node::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                node_id: node_id.into(),
                file_path: file_path.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                ocp_range: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Deletes the specified file from the compute node."]
        pub fn delete_from_compute_node(
            &self,
            pool_id: impl Into<String>,
            node_id: impl Into<String>,
            file_path: impl Into<String>,
        ) -> delete_from_compute_node::Builder {
            delete_from_compute_node::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                node_id: node_id.into(),
                file_path: file_path.into(),
                recursive: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        pub fn get_properties_from_compute_node(
            &self,
            pool_id: impl Into<String>,
            node_id: impl Into<String>,
            file_path: impl Into<String>,
        ) -> get_properties_from_compute_node::Builder {
            get_properties_from_compute_node::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                node_id: node_id.into(),
                file_path: file_path.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Lists the files in a task's directory on its compute node."]
        pub fn list_from_task(&self, job_id: impl Into<String>, task_id: impl Into<String>) -> list_from_task::Builder {
            list_from_task::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                task_id: task_id.into(),
                filter: None,
                recursive: None,
                maxresults: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Lists all of the files in task directories on the specified compute node."]
        pub fn list_from_compute_node(&self, pool_id: impl Into<String>, node_id: impl Into<String>) -> list_from_compute_node::Builder {
            list_from_compute_node::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                node_id: node_id.into(),
                filter: None,
                recursive: None,
                maxresults: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
    }
    pub mod get_from_task {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) task_id: String,
            pub(crate) file_path: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) ocp_range: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn ocp_range(mut self, ocp_range: impl Into<String>) -> Self {
                self.ocp_range = Some(ocp_range.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<bytes::Bytes, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/jobs/{}/tasks/{}/files/{}",
                        self.client.endpoint(),
                        &self.job_id,
                        &self.task_id,
                        &self.file_path
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(ocp_range) = &self.ocp_range {
                        req_builder = req_builder.header("ocp-range", ocp_range);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value = rsp_body;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_from_task {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) task_id: String,
            pub(crate) file_path: String,
            pub(crate) recursive: Option<bool>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn recursive(mut self, recursive: bool) -> Self {
                self.recursive = Some(recursive);
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/jobs/{}/tasks/{}/files/{}",
                        self.client.endpoint(),
                        &self.job_id,
                        &self.task_id,
                        &self.file_path
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(recursive) = &self.recursive {
                        url.query_pairs_mut().append_pair("recursive", &recursive.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_properties_from_task {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) task_id: String,
            pub(crate) file_path: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/jobs/{}/tasks/{}/files/{}",
                        self.client.endpoint(),
                        &self.job_id,
                        &self.task_id,
                        &self.file_path
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::HEAD);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_from_compute_node {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) node_id: String,
            pub(crate) file_path: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) ocp_range: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn ocp_range(mut self, ocp_range: impl Into<String>) -> Self {
                self.ocp_range = Some(ocp_range.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<bytes::Bytes, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/pools/{}/nodes/{}/files/{}",
                        self.client.endpoint(),
                        &self.pool_id,
                        &self.node_id,
                        &self.file_path
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(ocp_range) = &self.ocp_range {
                        req_builder = req_builder.header("ocp-range", ocp_range);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value = rsp_body;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_from_compute_node {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) node_id: String,
            pub(crate) file_path: String,
            pub(crate) recursive: Option<bool>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn recursive(mut self, recursive: bool) -> Self {
                self.recursive = Some(recursive);
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/pools/{}/nodes/{}/files/{}",
                        self.client.endpoint(),
                        &self.pool_id,
                        &self.node_id,
                        &self.file_path
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(recursive) = &self.recursive {
                        url.query_pairs_mut().append_pair("recursive", &recursive.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_properties_from_compute_node {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) node_id: String,
            pub(crate) file_path: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/pools/{}/nodes/{}/files/{}",
                        self.client.endpoint(),
                        &self.pool_id,
                        &self.node_id,
                        &self.file_path
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::HEAD);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_from_task {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) task_id: String,
            pub(crate) filter: Option<String>,
            pub(crate) recursive: Option<bool>,
            pub(crate) maxresults: Option<i32>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn recursive(mut self, recursive: bool) -> Self {
                self.recursive = Some(recursive);
                self
            }
            pub fn maxresults(mut self, maxresults: i32) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::NodeFileListResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs/{}/tasks/{}/files", self.client.endpoint(), &self.job_id, &self.task_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    if let Some(recursive) = &self.recursive {
                        url.query_pairs_mut().append_pair("recursive", &recursive.to_string());
                    }
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::NodeFileListResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_from_compute_node {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) node_id: String,
            pub(crate) filter: Option<String>,
            pub(crate) recursive: Option<bool>,
            pub(crate) maxresults: Option<i32>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn recursive(mut self, recursive: bool) -> Self {
                self.recursive = Some(recursive);
                self
            }
            pub fn maxresults(mut self, maxresults: i32) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::NodeFileListResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}/nodes/{}/files", self.client.endpoint(), &self.pool_id, &self.node_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    if let Some(recursive) = &self.recursive {
                        url.query_pairs_mut().append_pair("recursive", &recursive.to_string());
                    }
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::NodeFileListResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod job_schedule {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        pub fn get(&self, job_schedule_id: impl Into<String>) -> get::Builder {
            get::Builder {
                client: self.0.clone(),
                job_schedule_id: job_schedule_id.into(),
                select: None,
                expand: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Updates the properties of the specified job schedule."]
        pub fn update(
            &self,
            job_schedule_id: impl Into<String>,
            job_schedule_update_parameter: impl Into<models::JobScheduleUpdateParameter>,
        ) -> update::Builder {
            update::Builder {
                client: self.0.clone(),
                job_schedule_id: job_schedule_id.into(),
                job_schedule_update_parameter: job_schedule_update_parameter.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Updates the properties of the specified job schedule."]
        pub fn patch(
            &self,
            job_schedule_id: impl Into<String>,
            job_schedule_patch_parameter: impl Into<models::JobSchedulePatchParameter>,
        ) -> patch::Builder {
            patch::Builder {
                client: self.0.clone(),
                job_schedule_id: job_schedule_id.into(),
                job_schedule_patch_parameter: job_schedule_patch_parameter.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Deletes a job schedule from the specified account."]
        pub fn delete(&self, job_schedule_id: impl Into<String>) -> delete::Builder {
            delete::Builder {
                client: self.0.clone(),
                job_schedule_id: job_schedule_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Checks the specified job schedule exists."]
        pub fn exists(&self, job_schedule_id: impl Into<String>) -> exists::Builder {
            exists::Builder {
                client: self.0.clone(),
                job_schedule_id: job_schedule_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Disables a job schedule."]
        pub fn disable(&self, job_schedule_id: impl Into<String>) -> disable::Builder {
            disable::Builder {
                client: self.0.clone(),
                job_schedule_id: job_schedule_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Enables a job schedule."]
        pub fn enable(&self, job_schedule_id: impl Into<String>) -> enable::Builder {
            enable::Builder {
                client: self.0.clone(),
                job_schedule_id: job_schedule_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Terminates a job schedule."]
        pub fn terminate(&self, job_schedule_id: impl Into<String>) -> terminate::Builder {
            terminate::Builder {
                client: self.0.clone(),
                job_schedule_id: job_schedule_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Lists all of the job schedules in the specified account."]
        pub fn list(&self) -> list::Builder {
            list::Builder {
                client: self.0.clone(),
                filter: None,
                select: None,
                expand: None,
                maxresults: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Adds a job schedule to the specified account."]
        pub fn add(&self, cloud_job_schedule: impl Into<models::JobScheduleAddParameter>) -> add::Builder {
            add::Builder {
                client: self.0.clone(),
                cloud_job_schedule: cloud_job_schedule.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
    }
    pub mod get {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_schedule_id: String,
            pub(crate) select: Option<String>,
            pub(crate) expand: Option<String>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn select(mut self, select: impl Into<String>) -> Self {
                self.select = Some(select.into());
                self
            }
            pub fn expand(mut self, expand: impl Into<String>) -> Self {
                self.expand = Some(expand.into());
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::CloudJobSchedule, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobschedules/{}", self.client.endpoint(), &self.job_schedule_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(select) = &self.select {
                        url.query_pairs_mut().append_pair("$select", select);
                    }
                    if let Some(expand) = &self.expand {
                        url.query_pairs_mut().append_pair("$expand", expand);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CloudJobSchedule =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_schedule_id: String,
            pub(crate) job_schedule_update_parameter: models::JobScheduleUpdateParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobschedules/{}", self.client.endpoint(), &self.job_schedule_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.job_schedule_update_parameter).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod patch {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_schedule_id: String,
            pub(crate) job_schedule_patch_parameter: models::JobSchedulePatchParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobschedules/{}", self.client.endpoint(), &self.job_schedule_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PATCH);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.job_schedule_patch_parameter).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_schedule_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobschedules/{}", self.client.endpoint(), &self.job_schedule_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod exists {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("Error response #response_type")]
            NotFound404 {},
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_schedule_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobschedules/{}", self.client.endpoint(), &self.job_schedule_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::HEAD);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        http::StatusCode::NOT_FOUND => Err(Error::NotFound404 {}),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod disable {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_schedule_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobschedules/{}/disable", self.client.endpoint(), &self.job_schedule_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod enable {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_schedule_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobschedules/{}/enable", self.client.endpoint(), &self.job_schedule_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod terminate {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_schedule_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobschedules/{}/terminate", self.client.endpoint(), &self.job_schedule_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) filter: Option<String>,
            pub(crate) select: Option<String>,
            pub(crate) expand: Option<String>,
            pub(crate) maxresults: Option<i32>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn select(mut self, select: impl Into<String>) -> Self {
                self.select = Some(select.into());
                self
            }
            pub fn expand(mut self, expand: impl Into<String>) -> Self {
                self.expand = Some(expand.into());
                self
            }
            pub fn maxresults(mut self, maxresults: i32) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::CloudJobScheduleListResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobschedules", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    if let Some(select) = &self.select {
                        url.query_pairs_mut().append_pair("$select", select);
                    }
                    if let Some(expand) = &self.expand {
                        url.query_pairs_mut().append_pair("$expand", expand);
                    }
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CloudJobScheduleListResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod add {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) cloud_job_schedule: models::JobScheduleAddParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobschedules", self.client.endpoint(),);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.cloud_job_schedule).map_err(Error::Serialize)?;
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod task {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "Lists all of the tasks that are associated with the specified job."]
        pub fn list(&self, job_id: impl Into<String>) -> list::Builder {
            list::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                filter: None,
                select: None,
                expand: None,
                maxresults: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Adds a task to the specified job."]
        pub fn add(&self, job_id: impl Into<String>, task: impl Into<models::TaskAddParameter>) -> add::Builder {
            add::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                task: task.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Adds a collection of tasks to the specified job."]
        pub fn add_collection(
            &self,
            job_id: impl Into<String>,
            task_collection: impl Into<models::TaskAddCollectionParameter>,
        ) -> add_collection::Builder {
            add_collection::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                task_collection: task_collection.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Gets information about the specified task."]
        pub fn get(&self, job_id: impl Into<String>, task_id: impl Into<String>) -> get::Builder {
            get::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                task_id: task_id.into(),
                select: None,
                expand: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        pub fn update(
            &self,
            job_id: impl Into<String>,
            task_id: impl Into<String>,
            task_update_parameter: impl Into<models::TaskUpdateParameter>,
        ) -> update::Builder {
            update::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                task_id: task_id.into(),
                task_update_parameter: task_update_parameter.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Deletes a task from the specified job."]
        pub fn delete(&self, job_id: impl Into<String>, task_id: impl Into<String>) -> delete::Builder {
            delete::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                task_id: task_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Lists all of the subtasks that are associated with the specified multi-instance task."]
        pub fn list_subtasks(&self, job_id: impl Into<String>, task_id: impl Into<String>) -> list_subtasks::Builder {
            list_subtasks::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                task_id: task_id.into(),
                select: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Terminates the specified task."]
        pub fn terminate(&self, job_id: impl Into<String>, task_id: impl Into<String>) -> terminate::Builder {
            terminate::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                task_id: task_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
        #[doc = "Reactivates a task, allowing it to run again even if its retry count has been exhausted."]
        pub fn reactivate(&self, job_id: impl Into<String>, task_id: impl Into<String>) -> reactivate::Builder {
            reactivate::Builder {
                client: self.0.clone(),
                job_id: job_id.into(),
                task_id: task_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
                if_match: None,
                if_none_match: None,
                if_modified_since: None,
                if_unmodified_since: None,
            }
        }
    }
    pub mod list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) filter: Option<String>,
            pub(crate) select: Option<String>,
            pub(crate) expand: Option<String>,
            pub(crate) maxresults: Option<i32>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn select(mut self, select: impl Into<String>) -> Self {
                self.select = Some(select.into());
                self
            }
            pub fn expand(mut self, expand: impl Into<String>) -> Self {
                self.expand = Some(expand.into());
                self
            }
            pub fn maxresults(mut self, maxresults: i32) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::CloudTaskListResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs/{}/tasks", self.client.endpoint(), &self.job_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    if let Some(select) = &self.select {
                        url.query_pairs_mut().append_pair("$select", select);
                    }
                    if let Some(expand) = &self.expand {
                        url.query_pairs_mut().append_pair("$expand", expand);
                    }
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CloudTaskListResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod add {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) task: models::TaskAddParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs/{}/tasks", self.client.endpoint(), &self.job_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.task).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod add_collection {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) task_collection: models::TaskAddCollectionParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::TaskAddCollectionResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs/{}/addtaskcollection", self.client.endpoint(), &self.job_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.task_collection).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::TaskAddCollectionResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) task_id: String,
            pub(crate) select: Option<String>,
            pub(crate) expand: Option<String>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn select(mut self, select: impl Into<String>) -> Self {
                self.select = Some(select.into());
                self
            }
            pub fn expand(mut self, expand: impl Into<String>) -> Self {
                self.expand = Some(expand.into());
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::CloudTask, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs/{}/tasks/{}", self.client.endpoint(), &self.job_id, &self.task_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(select) = &self.select {
                        url.query_pairs_mut().append_pair("$select", select);
                    }
                    if let Some(expand) = &self.expand {
                        url.query_pairs_mut().append_pair("$expand", expand);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CloudTask =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) task_id: String,
            pub(crate) task_update_parameter: models::TaskUpdateParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs/{}/tasks/{}", self.client.endpoint(), &self.job_id, &self.task_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.task_update_parameter).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) task_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs/{}/tasks/{}", self.client.endpoint(), &self.job_id, &self.task_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list_subtasks {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) task_id: String,
            pub(crate) select: Option<String>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn select(mut self, select: impl Into<String>) -> Self {
                self.select = Some(select.into());
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::CloudTaskListSubtasksResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/jobs/{}/tasks/{}/subtasksinfo",
                        self.client.endpoint(),
                        &self.job_id,
                        &self.task_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(select) = &self.select {
                        url.query_pairs_mut().append_pair("$select", select);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::CloudTaskListSubtasksResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod terminate {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) task_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/jobs/{}/tasks/{}/terminate", self.client.endpoint(), &self.job_id, &self.task_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod reactivate {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) job_id: String,
            pub(crate) task_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
            pub(crate) if_match: Option<String>,
            pub(crate) if_none_match: Option<String>,
            pub(crate) if_modified_since: Option<String>,
            pub(crate) if_unmodified_since: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
                self.if_match = Some(if_match.into());
                self
            }
            pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
                self.if_none_match = Some(if_none_match.into());
                self
            }
            pub fn if_modified_since(mut self, if_modified_since: impl Into<String>) -> Self {
                self.if_modified_since = Some(if_modified_since.into());
                self
            }
            pub fn if_unmodified_since(mut self, if_unmodified_since: impl Into<String>) -> Self {
                self.if_unmodified_since = Some(if_unmodified_since.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/jobs/{}/tasks/{}/reactivate",
                        self.client.endpoint(),
                        &self.job_id,
                        &self.task_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    if let Some(if_match) = &self.if_match {
                        req_builder = req_builder.header("If-Match", if_match);
                    }
                    if let Some(if_none_match) = &self.if_none_match {
                        req_builder = req_builder.header("If-None-Match", if_none_match);
                    }
                    if let Some(if_modified_since) = &self.if_modified_since {
                        req_builder = req_builder.header("If-Modified-Since", if_modified_since);
                    }
                    if let Some(if_unmodified_since) = &self.if_unmodified_since {
                        req_builder = req_builder.header("If-Unmodified-Since", if_unmodified_since);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::NO_CONTENT => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
pub mod compute_node {
    use super::models;
    pub struct Client(pub(crate) super::Client);
    impl Client {
        #[doc = "Adds a user account to the specified compute node."]
        pub fn add_user(
            &self,
            pool_id: impl Into<String>,
            node_id: impl Into<String>,
            user: impl Into<models::ComputeNodeUser>,
        ) -> add_user::Builder {
            add_user::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                node_id: node_id.into(),
                user: user.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Updates the password and expiration time of a user account on the specified compute node."]
        pub fn update_user(
            &self,
            pool_id: impl Into<String>,
            node_id: impl Into<String>,
            user_name: impl Into<String>,
            node_update_user_parameter: impl Into<models::NodeUpdateUserParameter>,
        ) -> update_user::Builder {
            update_user::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                node_id: node_id.into(),
                user_name: user_name.into(),
                node_update_user_parameter: node_update_user_parameter.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Deletes a user account from the specified compute node."]
        pub fn delete_user(
            &self,
            pool_id: impl Into<String>,
            node_id: impl Into<String>,
            user_name: impl Into<String>,
        ) -> delete_user::Builder {
            delete_user::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                node_id: node_id.into(),
                user_name: user_name.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Gets information about the specified compute node."]
        pub fn get(&self, pool_id: impl Into<String>, node_id: impl Into<String>) -> get::Builder {
            get::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                node_id: node_id.into(),
                select: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Restarts the specified compute node."]
        pub fn reboot(&self, pool_id: impl Into<String>, node_id: impl Into<String>) -> reboot::Builder {
            reboot::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                node_id: node_id.into(),
                node_reboot_parameter: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Reinstalls the operating system on the specified compute node."]
        pub fn reimage(&self, pool_id: impl Into<String>, node_id: impl Into<String>) -> reimage::Builder {
            reimage::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                node_id: node_id.into(),
                node_reimage_parameter: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Disables task scheduling on the specified compute node."]
        pub fn disable_scheduling(&self, pool_id: impl Into<String>, node_id: impl Into<String>) -> disable_scheduling::Builder {
            disable_scheduling::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                node_id: node_id.into(),
                node_disable_scheduling_parameter: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Enables task scheduling on the specified compute node."]
        pub fn enable_scheduling(&self, pool_id: impl Into<String>, node_id: impl Into<String>) -> enable_scheduling::Builder {
            enable_scheduling::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                node_id: node_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Gets the settings required for remote login to a compute node."]
        pub fn get_remote_login_settings(
            &self,
            pool_id: impl Into<String>,
            node_id: impl Into<String>,
        ) -> get_remote_login_settings::Builder {
            get_remote_login_settings::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                node_id: node_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Gets the Remote Desktop Protocol file for the specified compute node."]
        pub fn get_remote_desktop(&self, pool_id: impl Into<String>, node_id: impl Into<String>) -> get_remote_desktop::Builder {
            get_remote_desktop::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                node_id: node_id.into(),
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
        #[doc = "Lists the compute nodes in the specified pool."]
        pub fn list(&self, pool_id: impl Into<String>) -> list::Builder {
            list::Builder {
                client: self.0.clone(),
                pool_id: pool_id.into(),
                filter: None,
                select: None,
                maxresults: None,
                timeout: None,
                client_request_id: None,
                return_client_request_id: None,
                ocp_date: None,
            }
        }
    }
    pub mod add_user {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) node_id: String,
            pub(crate) user: models::ComputeNodeUser,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}/nodes/{}/users", self.client.endpoint(), &self.pool_id, &self.node_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.user).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::CREATED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod update_user {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) node_id: String,
            pub(crate) user_name: String,
            pub(crate) node_update_user_parameter: models::NodeUpdateUserParameter,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/pools/{}/nodes/{}/users/{}",
                        self.client.endpoint(),
                        &self.pool_id,
                        &self.node_id,
                        &self.user_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::PUT);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                    let req_body = azure_core::to_json(&self.node_update_user_parameter).map_err(Error::Serialize)?;
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod delete_user {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) node_id: String,
            pub(crate) user_name: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/pools/{}/nodes/{}/users/{}",
                        self.client.endpoint(),
                        &self.pool_id,
                        &self.node_id,
                        &self.user_name
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::DELETE);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) node_id: String,
            pub(crate) select: Option<String>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn select(mut self, select: impl Into<String>) -> Self {
                self.select = Some(select.into());
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ComputeNode, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}/nodes/{}", self.client.endpoint(), &self.pool_id, &self.node_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(select) = &self.select {
                        url.query_pairs_mut().append_pair("$select", select);
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ComputeNode =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod reboot {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) node_id: String,
            pub(crate) node_reboot_parameter: Option<models::NodeRebootParameter>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn node_reboot_parameter(mut self, node_reboot_parameter: impl Into<models::NodeRebootParameter>) -> Self {
                self.node_reboot_parameter = Some(node_reboot_parameter.into());
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}/nodes/{}/reboot", self.client.endpoint(), &self.pool_id, &self.node_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    let req_body = if let Some(node_reboot_parameter) = &self.node_reboot_parameter {
                        req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                        azure_core::to_json(node_reboot_parameter).map_err(Error::Serialize)?
                    } else {
                        azure_core::EMPTY_BODY
                    };
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod reimage {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) node_id: String,
            pub(crate) node_reimage_parameter: Option<models::NodeReimageParameter>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn node_reimage_parameter(mut self, node_reimage_parameter: impl Into<models::NodeReimageParameter>) -> Self {
                self.node_reimage_parameter = Some(node_reimage_parameter.into());
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}/nodes/{}/reimage", self.client.endpoint(), &self.pool_id, &self.node_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    let req_body = if let Some(node_reimage_parameter) = &self.node_reimage_parameter {
                        req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                        azure_core::to_json(node_reimage_parameter).map_err(Error::Serialize)?
                    } else {
                        azure_core::EMPTY_BODY
                    };
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::ACCEPTED => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod disable_scheduling {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) node_id: String,
            pub(crate) node_disable_scheduling_parameter: Option<models::NodeDisableSchedulingParameter>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn node_disable_scheduling_parameter(
                mut self,
                node_disable_scheduling_parameter: impl Into<models::NodeDisableSchedulingParameter>,
            ) -> Self {
                self.node_disable_scheduling_parameter = Some(node_disable_scheduling_parameter.into());
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/pools/{}/nodes/{}/disablescheduling",
                        self.client.endpoint(),
                        &self.pool_id,
                        &self.node_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    let req_body = if let Some(node_disable_scheduling_parameter) = &self.node_disable_scheduling_parameter {
                        req_builder = req_builder.header("content-type", "application/json; odata=minimalmetadata");
                        azure_core::to_json(node_disable_scheduling_parameter).map_err(Error::Serialize)?
                    } else {
                        azure_core::EMPTY_BODY
                    };
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod enable_scheduling {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) node_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/pools/{}/nodes/{}/enablescheduling",
                        self.client.endpoint(),
                        &self.pool_id,
                        &self.node_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::POST);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.header(http::header::CONTENT_LENGTH, 0);
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => Ok(()),
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_remote_login_settings {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) node_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(
                self,
            ) -> futures::future::BoxFuture<'static, std::result::Result<models::ComputeNodeGetRemoteLoginSettingsResult, Error>>
            {
                Box::pin(async move {
                    let url_str = &format!(
                        "{}/pools/{}/nodes/{}/remoteloginsettings",
                        self.client.endpoint(),
                        &self.pool_id,
                        &self.node_id
                    );
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ComputeNodeGetRemoteLoginSettingsResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod get_remote_desktop {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) node_id: String,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<bytes::Bytes, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}/nodes/{}/rdp", self.client.endpoint(), &self.pool_id, &self.node_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value = rsp_body;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
    pub mod list {
        use super::models;
        #[derive(Debug, thiserror :: Error)]
        pub enum Error {
            #[error("HTTP status code {}", status_code)]
            DefaultResponse {
                status_code: http::StatusCode,
                value: models::BatchError,
            },
            #[error("Failed to parse request URL")]
            ParseUrl(#[source] url::ParseError),
            #[error("Failed to build request")]
            BuildRequest(#[source] http::Error),
            #[error("Failed to serialize request body")]
            Serialize(#[source] serde_json::Error),
            #[error("Failed to get access token")]
            GetToken(#[source] azure_core::Error),
            #[error("Failed to execute request")]
            SendRequest(#[source] azure_core::error::Error),
            #[error("Failed to get response bytes")]
            ResponseBytes(#[source] azure_core::error::Error),
            #[error("Failed to deserialize response, body: {1:?}")]
            Deserialize(#[source] serde_json::Error, bytes::Bytes),
        }
        #[derive(Clone)]
        pub struct Builder {
            pub(crate) client: super::super::Client,
            pub(crate) pool_id: String,
            pub(crate) filter: Option<String>,
            pub(crate) select: Option<String>,
            pub(crate) maxresults: Option<i32>,
            pub(crate) timeout: Option<i32>,
            pub(crate) client_request_id: Option<String>,
            pub(crate) return_client_request_id: Option<bool>,
            pub(crate) ocp_date: Option<String>,
        }
        impl Builder {
            pub fn filter(mut self, filter: impl Into<String>) -> Self {
                self.filter = Some(filter.into());
                self
            }
            pub fn select(mut self, select: impl Into<String>) -> Self {
                self.select = Some(select.into());
                self
            }
            pub fn maxresults(mut self, maxresults: i32) -> Self {
                self.maxresults = Some(maxresults);
                self
            }
            pub fn timeout(mut self, timeout: i32) -> Self {
                self.timeout = Some(timeout);
                self
            }
            pub fn client_request_id(mut self, client_request_id: impl Into<String>) -> Self {
                self.client_request_id = Some(client_request_id.into());
                self
            }
            pub fn return_client_request_id(mut self, return_client_request_id: bool) -> Self {
                self.return_client_request_id = Some(return_client_request_id);
                self
            }
            pub fn ocp_date(mut self, ocp_date: impl Into<String>) -> Self {
                self.ocp_date = Some(ocp_date.into());
                self
            }
            pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::ComputeNodeListResult, Error>> {
                Box::pin(async move {
                    let url_str = &format!("{}/pools/{}/nodes", self.client.endpoint(), &self.pool_id);
                    let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                    let mut req_builder = http::request::Builder::new();
                    req_builder = req_builder.method(http::Method::GET);
                    let credential = self.client.token_credential();
                    let token_response = credential
                        .get_token(&self.client.scopes().join(" "))
                        .await
                        .map_err(Error::GetToken)?;
                    req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                    url.query_pairs_mut().append_pair("api-version", "2017-06-01.5.1");
                    if let Some(filter) = &self.filter {
                        url.query_pairs_mut().append_pair("$filter", filter);
                    }
                    if let Some(select) = &self.select {
                        url.query_pairs_mut().append_pair("$select", select);
                    }
                    if let Some(maxresults) = &self.maxresults {
                        url.query_pairs_mut().append_pair("maxresults", &maxresults.to_string());
                    }
                    if let Some(timeout) = &self.timeout {
                        url.query_pairs_mut().append_pair("timeout", &timeout.to_string());
                    }
                    if let Some(client_request_id) = &self.client_request_id {
                        req_builder = req_builder.header("client-request-id", client_request_id);
                    }
                    if let Some(return_client_request_id) = &self.return_client_request_id {
                        req_builder = req_builder.header("return-client-request-id", &return_client_request_id.to_string());
                    }
                    if let Some(ocp_date) = &self.ocp_date {
                        req_builder = req_builder.header("ocp-date", ocp_date);
                    }
                    let req_body = azure_core::EMPTY_BODY;
                    req_builder = req_builder.uri(url.as_str());
                    let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                    let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                    let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                    match rsp_status {
                        http::StatusCode::OK => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::ComputeNodeListResult =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Ok(rsp_value)
                        }
                        status_code => {
                            let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                            let rsp_value: models::BatchError =
                                serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                            Err(Error::DefaultResponse {
                                status_code,
                                value: rsp_value,
                            })
                        }
                    }
                })
            }
        }
    }
}
