#![doc = "generated by AutoRust"]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
use azure_core::util::case_insensitive_deserialize;
use serde::{Deserialize, Serialize};
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AccountListNodeAgentSkusResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NodeAgentSku>,
    #[serde(rename = "odata.nextLink", default, skip_serializing_if = "Option::is_none")]
    pub odata_next_link: Option<String>,
}
impl AccountListNodeAgentSkusResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AffinityInformation {
    #[serde(rename = "affinityId")]
    pub affinity_id: String,
}
impl AffinityInformation {
    pub fn new(affinity_id: String) -> Self {
        Self { affinity_id }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ApplicationListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ApplicationSummary>,
    #[serde(rename = "odata.nextLink", default, skip_serializing_if = "Option::is_none")]
    pub odata_next_link: Option<String>,
}
impl ApplicationListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationPackageReference {
    #[serde(rename = "applicationId")]
    pub application_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
}
impl ApplicationPackageReference {
    pub fn new(application_id: String) -> Self {
        Self {
            application_id,
            version: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ApplicationSummary {
    pub id: String,
    #[serde(rename = "displayName")]
    pub display_name: String,
    pub versions: Vec<String>,
}
impl ApplicationSummary {
    pub fn new(id: String, display_name: String, versions: Vec<String>) -> Self {
        Self {
            id,
            display_name,
            versions,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AuthenticationTokenSettings {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub access: Vec<String>,
}
impl AuthenticationTokenSettings {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutoPoolSpecification {
    #[serde(rename = "autoPoolIdPrefix", default, skip_serializing_if = "Option::is_none")]
    pub auto_pool_id_prefix: Option<String>,
    #[serde(rename = "poolLifetimeOption", deserialize_with = "case_insensitive_deserialize")]
    pub pool_lifetime_option: auto_pool_specification::PoolLifetimeOption,
    #[serde(rename = "keepAlive", default, skip_serializing_if = "Option::is_none")]
    pub keep_alive: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub pool: Option<PoolSpecification>,
}
impl AutoPoolSpecification {
    pub fn new(pool_lifetime_option: auto_pool_specification::PoolLifetimeOption) -> Self {
        Self {
            auto_pool_id_prefix: None,
            pool_lifetime_option,
            keep_alive: None,
            pool: None,
        }
    }
}
pub mod auto_pool_specification {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum PoolLifetimeOption {
        #[serde(rename = "jobschedule")]
        Jobschedule,
        #[serde(rename = "job")]
        Job,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AutoScaleRun {
    pub timestamp: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub results: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<AutoScaleRunError>,
}
impl AutoScaleRun {
    pub fn new(timestamp: String) -> Self {
        Self {
            timestamp,
            results: None,
            error: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoScaleRunError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<NameValuePair>,
}
impl AutoScaleRunError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct AutoUserSpecification {
    #[serde(
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub scope: Option<auto_user_specification::Scope>,
    #[serde(
        rename = "elevationLevel",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub elevation_level: Option<ElevationLevel>,
}
impl AutoUserSpecification {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod auto_user_specification {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Scope {
        #[serde(rename = "task")]
        Task,
        #[serde(rename = "pool")]
        Pool,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<ErrorMessage>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<BatchErrorDetail>,
}
impl BatchError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct BatchErrorDetail {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl BatchErrorDetail {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CachingType {
    #[serde(rename = "none")]
    None,
    #[serde(rename = "readonly")]
    Readonly,
    #[serde(rename = "readwrite")]
    Readwrite,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Certificate {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub thumbprint: Option<String>,
    #[serde(rename = "thumbprintAlgorithm", default, skip_serializing_if = "Option::is_none")]
    pub thumbprint_algorithm: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub state: Option<CertificateState>,
    #[serde(rename = "stateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub state_transition_time: Option<String>,
    #[serde(
        rename = "previousState",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub previous_state: Option<CertificateState>,
    #[serde(rename = "previousStateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub previous_state_transition_time: Option<String>,
    #[serde(rename = "publicData", default, skip_serializing_if = "Option::is_none")]
    pub public_data: Option<String>,
    #[serde(rename = "deleteCertificateError", default, skip_serializing_if = "Option::is_none")]
    pub delete_certificate_error: Option<DeleteCertificateError>,
}
impl Certificate {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateAddParameter {
    pub thumbprint: String,
    #[serde(rename = "thumbprintAlgorithm")]
    pub thumbprint_algorithm: String,
    pub data: String,
    #[serde(
        rename = "certificateFormat",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub certificate_format: Option<certificate_add_parameter::CertificateFormat>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
}
impl CertificateAddParameter {
    pub fn new(thumbprint: String, thumbprint_algorithm: String, data: String) -> Self {
        Self {
            thumbprint,
            thumbprint_algorithm,
            data,
            certificate_format: None,
            password: None,
        }
    }
}
pub mod certificate_add_parameter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum CertificateFormat {
        #[serde(rename = "pfx")]
        Pfx,
        #[serde(rename = "cer")]
        Cer,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CertificateListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<Certificate>,
    #[serde(rename = "odata.nextLink", default, skip_serializing_if = "Option::is_none")]
    pub odata_next_link: Option<String>,
}
impl CertificateListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CertificateReference {
    pub thumbprint: String,
    #[serde(rename = "thumbprintAlgorithm")]
    pub thumbprint_algorithm: String,
    #[serde(
        rename = "storeLocation",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub store_location: Option<certificate_reference::StoreLocation>,
    #[serde(rename = "storeName", default, skip_serializing_if = "Option::is_none")]
    pub store_name: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub visibility: Vec<String>,
}
impl CertificateReference {
    pub fn new(thumbprint: String, thumbprint_algorithm: String) -> Self {
        Self {
            thumbprint,
            thumbprint_algorithm,
            store_location: None,
            store_name: None,
            visibility: Vec::new(),
        }
    }
}
pub mod certificate_reference {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum StoreLocation {
        #[serde(rename = "currentuser")]
        Currentuser,
        #[serde(rename = "localmachine")]
        Localmachine,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum CertificateState {
    #[serde(rename = "active")]
    Active,
    #[serde(rename = "deleting")]
    Deleting,
    #[serde(rename = "deletefailed")]
    Deletefailed,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudJob {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "usesTaskDependencies", default, skip_serializing_if = "Option::is_none")]
    pub uses_task_dependencies: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[serde(rename = "lastModified", default, skip_serializing_if = "Option::is_none")]
    pub last_modified: Option<String>,
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[serde(
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub state: Option<JobState>,
    #[serde(rename = "stateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub state_transition_time: Option<String>,
    #[serde(
        rename = "previousState",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub previous_state: Option<JobState>,
    #[serde(rename = "previousStateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub previous_state_transition_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub constraints: Option<JobConstraints>,
    #[serde(rename = "jobManagerTask", default, skip_serializing_if = "Option::is_none")]
    pub job_manager_task: Option<JobManagerTask>,
    #[serde(rename = "jobPreparationTask", default, skip_serializing_if = "Option::is_none")]
    pub job_preparation_task: Option<JobPreparationTask>,
    #[serde(rename = "jobReleaseTask", default, skip_serializing_if = "Option::is_none")]
    pub job_release_task: Option<JobReleaseTask>,
    #[serde(rename = "commonEnvironmentSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub common_environment_settings: Vec<EnvironmentSetting>,
    #[serde(rename = "poolInfo", default, skip_serializing_if = "Option::is_none")]
    pub pool_info: Option<PoolInformation>,
    #[serde(
        rename = "onAllTasksComplete",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub on_all_tasks_complete: Option<OnAllTasksComplete>,
    #[serde(
        rename = "onTaskFailure",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub on_task_failure: Option<OnTaskFailure>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
    #[serde(rename = "executionInfo", default, skip_serializing_if = "Option::is_none")]
    pub execution_info: Option<JobExecutionInformation>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub stats: Option<JobStatistics>,
}
impl CloudJob {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudJobListPreparationAndReleaseTaskStatusResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<JobPreparationAndReleaseTaskExecutionInformation>,
    #[serde(rename = "odata.nextLink", default, skip_serializing_if = "Option::is_none")]
    pub odata_next_link: Option<String>,
}
impl CloudJobListPreparationAndReleaseTaskStatusResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudJobListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CloudJob>,
    #[serde(rename = "odata.nextLink", default, skip_serializing_if = "Option::is_none")]
    pub odata_next_link: Option<String>,
}
impl CloudJobListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudJobSchedule {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[serde(rename = "lastModified", default, skip_serializing_if = "Option::is_none")]
    pub last_modified: Option<String>,
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[serde(
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub state: Option<JobScheduleState>,
    #[serde(rename = "stateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub state_transition_time: Option<String>,
    #[serde(
        rename = "previousState",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub previous_state: Option<JobScheduleState>,
    #[serde(rename = "previousStateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub previous_state_transition_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schedule: Option<Schedule>,
    #[serde(rename = "jobSpecification", default, skip_serializing_if = "Option::is_none")]
    pub job_specification: Option<JobSpecification>,
    #[serde(rename = "executionInfo", default, skip_serializing_if = "Option::is_none")]
    pub execution_info: Option<JobScheduleExecutionInformation>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub stats: Option<JobScheduleStatistics>,
}
impl CloudJobSchedule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudJobScheduleListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CloudJobSchedule>,
    #[serde(rename = "odata.nextLink", default, skip_serializing_if = "Option::is_none")]
    pub odata_next_link: Option<String>,
}
impl CloudJobScheduleListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudPool {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[serde(rename = "lastModified", default, skip_serializing_if = "Option::is_none")]
    pub last_modified: Option<String>,
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[serde(
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub state: Option<cloud_pool::State>,
    #[serde(rename = "stateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub state_transition_time: Option<String>,
    #[serde(
        rename = "allocationState",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub allocation_state: Option<cloud_pool::AllocationState>,
    #[serde(rename = "allocationStateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub allocation_state_transition_time: Option<String>,
    #[serde(rename = "vmSize", default, skip_serializing_if = "Option::is_none")]
    pub vm_size: Option<String>,
    #[serde(rename = "cloudServiceConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub cloud_service_configuration: Option<CloudServiceConfiguration>,
    #[serde(rename = "virtualMachineConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_configuration: Option<VirtualMachineConfiguration>,
    #[serde(rename = "resizeTimeout", default, skip_serializing_if = "Option::is_none")]
    pub resize_timeout: Option<String>,
    #[serde(rename = "resizeErrors", default, skip_serializing_if = "Vec::is_empty")]
    pub resize_errors: Vec<ResizeError>,
    #[serde(rename = "currentDedicatedNodes", default, skip_serializing_if = "Option::is_none")]
    pub current_dedicated_nodes: Option<i32>,
    #[serde(rename = "currentLowPriorityNodes", default, skip_serializing_if = "Option::is_none")]
    pub current_low_priority_nodes: Option<i32>,
    #[serde(rename = "targetDedicatedNodes", default, skip_serializing_if = "Option::is_none")]
    pub target_dedicated_nodes: Option<i32>,
    #[serde(rename = "targetLowPriorityNodes", default, skip_serializing_if = "Option::is_none")]
    pub target_low_priority_nodes: Option<i32>,
    #[serde(rename = "enableAutoScale", default, skip_serializing_if = "Option::is_none")]
    pub enable_auto_scale: Option<bool>,
    #[serde(rename = "autoScaleFormula", default, skip_serializing_if = "Option::is_none")]
    pub auto_scale_formula: Option<String>,
    #[serde(rename = "autoScaleEvaluationInterval", default, skip_serializing_if = "Option::is_none")]
    pub auto_scale_evaluation_interval: Option<String>,
    #[serde(rename = "autoScaleRun", default, skip_serializing_if = "Option::is_none")]
    pub auto_scale_run: Option<AutoScaleRun>,
    #[serde(rename = "enableInterNodeCommunication", default, skip_serializing_if = "Option::is_none")]
    pub enable_inter_node_communication: Option<bool>,
    #[serde(rename = "networkConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub network_configuration: Option<NetworkConfiguration>,
    #[serde(rename = "startTask", default, skip_serializing_if = "Option::is_none")]
    pub start_task: Option<StartTask>,
    #[serde(rename = "certificateReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub certificate_references: Vec<CertificateReference>,
    #[serde(rename = "applicationPackageReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub application_package_references: Vec<ApplicationPackageReference>,
    #[serde(rename = "applicationLicenses", default, skip_serializing_if = "Vec::is_empty")]
    pub application_licenses: Vec<String>,
    #[serde(rename = "maxTasksPerNode", default, skip_serializing_if = "Option::is_none")]
    pub max_tasks_per_node: Option<i32>,
    #[serde(rename = "taskSchedulingPolicy", default, skip_serializing_if = "Option::is_none")]
    pub task_scheduling_policy: Option<TaskSchedulingPolicy>,
    #[serde(rename = "userAccounts", default, skip_serializing_if = "Vec::is_empty")]
    pub user_accounts: Vec<UserAccount>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub stats: Option<PoolStatistics>,
}
impl CloudPool {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod cloud_pool {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        #[serde(rename = "active")]
        Active,
        #[serde(rename = "deleting")]
        Deleting,
        #[serde(rename = "upgrading")]
        Upgrading,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum AllocationState {
        #[serde(rename = "steady")]
        Steady,
        #[serde(rename = "resizing")]
        Resizing,
        #[serde(rename = "stopping")]
        Stopping,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudPoolListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CloudPool>,
    #[serde(rename = "odata.nextLink", default, skip_serializing_if = "Option::is_none")]
    pub odata_next_link: Option<String>,
}
impl CloudPoolListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloudServiceConfiguration {
    #[serde(rename = "osFamily")]
    pub os_family: String,
    #[serde(rename = "targetOSVersion", default, skip_serializing_if = "Option::is_none")]
    pub target_os_version: Option<String>,
    #[serde(rename = "currentOSVersion", default, skip_serializing_if = "Option::is_none")]
    pub current_os_version: Option<String>,
}
impl CloudServiceConfiguration {
    pub fn new(os_family: String) -> Self {
        Self {
            os_family,
            target_os_version: None,
            current_os_version: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudTask {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[serde(rename = "lastModified", default, skip_serializing_if = "Option::is_none")]
    pub last_modified: Option<String>,
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[serde(rename = "exitConditions", default, skip_serializing_if = "Option::is_none")]
    pub exit_conditions: Option<ExitConditions>,
    #[serde(
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub state: Option<TaskState>,
    #[serde(rename = "stateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub state_transition_time: Option<String>,
    #[serde(
        rename = "previousState",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub previous_state: Option<TaskState>,
    #[serde(rename = "previousStateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub previous_state_transition_time: Option<String>,
    #[serde(rename = "commandLine", default, skip_serializing_if = "Option::is_none")]
    pub command_line: Option<String>,
    #[serde(rename = "containerSettings", default, skip_serializing_if = "Option::is_none")]
    pub container_settings: Option<TaskContainerSettings>,
    #[serde(rename = "resourceFiles", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_files: Vec<ResourceFile>,
    #[serde(rename = "outputFiles", default, skip_serializing_if = "Vec::is_empty")]
    pub output_files: Vec<OutputFile>,
    #[serde(rename = "environmentSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub environment_settings: Vec<EnvironmentSetting>,
    #[serde(rename = "affinityInfo", default, skip_serializing_if = "Option::is_none")]
    pub affinity_info: Option<AffinityInformation>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub constraints: Option<TaskConstraints>,
    #[serde(rename = "userIdentity", default, skip_serializing_if = "Option::is_none")]
    pub user_identity: Option<UserIdentity>,
    #[serde(rename = "executionInfo", default, skip_serializing_if = "Option::is_none")]
    pub execution_info: Option<TaskExecutionInformation>,
    #[serde(rename = "nodeInfo", default, skip_serializing_if = "Option::is_none")]
    pub node_info: Option<ComputeNodeInformation>,
    #[serde(rename = "multiInstanceSettings", default, skip_serializing_if = "Option::is_none")]
    pub multi_instance_settings: Option<MultiInstanceSettings>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub stats: Option<TaskStatistics>,
    #[serde(rename = "dependsOn", default, skip_serializing_if = "Option::is_none")]
    pub depends_on: Option<TaskDependencies>,
    #[serde(rename = "applicationPackageReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub application_package_references: Vec<ApplicationPackageReference>,
    #[serde(rename = "authenticationTokenSettings", default, skip_serializing_if = "Option::is_none")]
    pub authentication_token_settings: Option<AuthenticationTokenSettings>,
}
impl CloudTask {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudTaskListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<CloudTask>,
    #[serde(rename = "odata.nextLink", default, skip_serializing_if = "Option::is_none")]
    pub odata_next_link: Option<String>,
}
impl CloudTaskListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct CloudTaskListSubtasksResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<SubtaskInformation>,
}
impl CloudTaskListSubtasksResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeNode {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub state: Option<compute_node::State>,
    #[serde(
        rename = "schedulingState",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub scheduling_state: Option<compute_node::SchedulingState>,
    #[serde(rename = "stateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub state_transition_time: Option<String>,
    #[serde(rename = "lastBootTime", default, skip_serializing_if = "Option::is_none")]
    pub last_boot_time: Option<String>,
    #[serde(rename = "allocationTime", default, skip_serializing_if = "Option::is_none")]
    pub allocation_time: Option<String>,
    #[serde(rename = "ipAddress", default, skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    #[serde(rename = "affinityId", default, skip_serializing_if = "Option::is_none")]
    pub affinity_id: Option<String>,
    #[serde(rename = "vmSize", default, skip_serializing_if = "Option::is_none")]
    pub vm_size: Option<String>,
    #[serde(rename = "totalTasksRun", default, skip_serializing_if = "Option::is_none")]
    pub total_tasks_run: Option<i32>,
    #[serde(rename = "runningTasksCount", default, skip_serializing_if = "Option::is_none")]
    pub running_tasks_count: Option<i32>,
    #[serde(rename = "totalTasksSucceeded", default, skip_serializing_if = "Option::is_none")]
    pub total_tasks_succeeded: Option<i32>,
    #[serde(rename = "recentTasks", default, skip_serializing_if = "Vec::is_empty")]
    pub recent_tasks: Vec<TaskInformation>,
    #[serde(rename = "startTask", default, skip_serializing_if = "Option::is_none")]
    pub start_task: Option<StartTask>,
    #[serde(rename = "startTaskInfo", default, skip_serializing_if = "Option::is_none")]
    pub start_task_info: Option<StartTaskInformation>,
    #[serde(rename = "certificateReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub certificate_references: Vec<CertificateReference>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub errors: Vec<ComputeNodeError>,
    #[serde(rename = "isDedicated", default, skip_serializing_if = "Option::is_none")]
    pub is_dedicated: Option<bool>,
    #[serde(rename = "endpointConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_configuration: Option<ComputeNodeEndpointConfiguration>,
    #[serde(rename = "nodeAgentInfo", default, skip_serializing_if = "Option::is_none")]
    pub node_agent_info: Option<NodeAgentInformation>,
}
impl ComputeNode {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod compute_node {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        #[serde(rename = "idle")]
        Idle,
        #[serde(rename = "rebooting")]
        Rebooting,
        #[serde(rename = "reimaging")]
        Reimaging,
        #[serde(rename = "running")]
        Running,
        #[serde(rename = "unusable")]
        Unusable,
        #[serde(rename = "creating")]
        Creating,
        #[serde(rename = "starting")]
        Starting,
        #[serde(rename = "waitingforstarttask")]
        Waitingforstarttask,
        #[serde(rename = "starttaskfailed")]
        Starttaskfailed,
        #[serde(rename = "unknown")]
        Unknown,
        #[serde(rename = "leavingpool")]
        Leavingpool,
        #[serde(rename = "offline")]
        Offline,
        #[serde(rename = "preempted")]
        Preempted,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum SchedulingState {
        #[serde(rename = "enabled")]
        Enabled,
        #[serde(rename = "disabled")]
        Disabled,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ComputeNodeDeallocationOption {
    #[serde(rename = "requeue")]
    Requeue,
    #[serde(rename = "terminate")]
    Terminate,
    #[serde(rename = "taskcompletion")]
    Taskcompletion,
    #[serde(rename = "retaineddata")]
    Retaineddata,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ComputeNodeEndpointConfiguration {
    #[serde(rename = "inboundEndpoints")]
    pub inbound_endpoints: Vec<InboundEndpoint>,
}
impl ComputeNodeEndpointConfiguration {
    pub fn new(inbound_endpoints: Vec<InboundEndpoint>) -> Self {
        Self { inbound_endpoints }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeNodeError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(rename = "errorDetails", default, skip_serializing_if = "Vec::is_empty")]
    pub error_details: Vec<NameValuePair>,
}
impl ComputeNodeError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ComputeNodeGetRemoteLoginSettingsResult {
    #[serde(rename = "remoteLoginIPAddress")]
    pub remote_login_ip_address: String,
    #[serde(rename = "remoteLoginPort")]
    pub remote_login_port: i32,
}
impl ComputeNodeGetRemoteLoginSettingsResult {
    pub fn new(remote_login_ip_address: String, remote_login_port: i32) -> Self {
        Self {
            remote_login_ip_address,
            remote_login_port,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeNodeInformation {
    #[serde(rename = "affinityId", default, skip_serializing_if = "Option::is_none")]
    pub affinity_id: Option<String>,
    #[serde(rename = "nodeUrl", default, skip_serializing_if = "Option::is_none")]
    pub node_url: Option<String>,
    #[serde(rename = "poolId", default, skip_serializing_if = "Option::is_none")]
    pub pool_id: Option<String>,
    #[serde(rename = "nodeId", default, skip_serializing_if = "Option::is_none")]
    pub node_id: Option<String>,
    #[serde(rename = "taskRootDirectory", default, skip_serializing_if = "Option::is_none")]
    pub task_root_directory: Option<String>,
    #[serde(rename = "taskRootDirectoryUrl", default, skip_serializing_if = "Option::is_none")]
    pub task_root_directory_url: Option<String>,
}
impl ComputeNodeInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ComputeNodeListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<ComputeNode>,
    #[serde(rename = "odata.nextLink", default, skip_serializing_if = "Option::is_none")]
    pub odata_next_link: Option<String>,
}
impl ComputeNodeListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ComputeNodeUser {
    pub name: String,
    #[serde(rename = "isAdmin", default, skip_serializing_if = "Option::is_none")]
    pub is_admin: Option<bool>,
    #[serde(rename = "expiryTime", default, skip_serializing_if = "Option::is_none")]
    pub expiry_time: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(rename = "sshPublicKey", default, skip_serializing_if = "Option::is_none")]
    pub ssh_public_key: Option<String>,
}
impl ComputeNodeUser {
    pub fn new(name: String) -> Self {
        Self {
            name,
            is_admin: None,
            expiry_time: None,
            password: None,
            ssh_public_key: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerConfiguration {
    #[serde(rename = "type", deserialize_with = "case_insensitive_deserialize")]
    pub type_: container_configuration::Type,
    #[serde(rename = "containerImageNames", default, skip_serializing_if = "Vec::is_empty")]
    pub container_image_names: Vec<String>,
    #[serde(rename = "containerRegistries", default, skip_serializing_if = "Vec::is_empty")]
    pub container_registries: Vec<ContainerRegistry>,
}
impl ContainerConfiguration {
    pub fn new(type_: container_configuration::Type) -> Self {
        Self {
            type_,
            container_image_names: Vec::new(),
            container_registries: Vec::new(),
        }
    }
}
pub mod container_configuration {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Type {
        #[serde(rename = "dockerCompatible", alias = "dockercompatible")]
        DockerCompatible,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ContainerRegistry {
    #[serde(rename = "registryServer", default, skip_serializing_if = "Option::is_none")]
    pub registry_server: Option<String>,
    pub username: String,
    pub password: String,
}
impl ContainerRegistry {
    pub fn new(username: String, password: String) -> Self {
        Self {
            registry_server: None,
            username,
            password,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataDisk {
    pub lun: i32,
    #[serde(
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub caching: Option<CachingType>,
    #[serde(rename = "diskSizeGB")]
    pub disk_size_gb: i32,
    #[serde(
        rename = "storageAccountType",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub storage_account_type: Option<StorageAccountType>,
}
impl DataDisk {
    pub fn new(lun: i32, disk_size_gb: i32) -> Self {
        Self {
            lun,
            caching: None,
            disk_size_gb,
            storage_account_type: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct DeleteCertificateError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<NameValuePair>,
}
impl DeleteCertificateError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ElevationLevel {
    #[serde(rename = "nonadmin")]
    Nonadmin,
    #[serde(rename = "admin")]
    Admin,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EnvironmentSetting {
    pub name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl EnvironmentSetting {
    pub fn new(name: String) -> Self {
        Self { name, value: None }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum ErrorCategory {
    #[serde(rename = "usererror")]
    Usererror,
    #[serde(rename = "servererror")]
    Servererror,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ErrorMessage {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub lang: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl ErrorMessage {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExitCodeMapping {
    pub code: i32,
    #[serde(rename = "exitOptions")]
    pub exit_options: ExitOptions,
}
impl ExitCodeMapping {
    pub fn new(code: i32, exit_options: ExitOptions) -> Self {
        Self { code, exit_options }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExitCodeRangeMapping {
    pub start: i32,
    pub end: i32,
    #[serde(rename = "exitOptions")]
    pub exit_options: ExitOptions,
}
impl ExitCodeRangeMapping {
    pub fn new(start: i32, end: i32, exit_options: ExitOptions) -> Self {
        Self { start, end, exit_options }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExitConditions {
    #[serde(rename = "exitCodes", default, skip_serializing_if = "Vec::is_empty")]
    pub exit_codes: Vec<ExitCodeMapping>,
    #[serde(rename = "exitCodeRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub exit_code_ranges: Vec<ExitCodeRangeMapping>,
    #[serde(rename = "preProcessingError", default, skip_serializing_if = "Option::is_none")]
    pub pre_processing_error: Option<ExitOptions>,
    #[serde(rename = "fileUploadError", default, skip_serializing_if = "Option::is_none")]
    pub file_upload_error: Option<ExitOptions>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub default: Option<ExitOptions>,
}
impl ExitConditions {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ExitOptions {
    #[serde(
        rename = "jobAction",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub job_action: Option<exit_options::JobAction>,
    #[serde(
        rename = "dependencyAction",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub dependency_action: Option<exit_options::DependencyAction>,
}
impl ExitOptions {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod exit_options {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum JobAction {
        #[serde(rename = "none")]
        None,
        #[serde(rename = "disable")]
        Disable,
        #[serde(rename = "terminate")]
        Terminate,
    }
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DependencyAction {
        #[serde(rename = "satisfy")]
        Satisfy,
        #[serde(rename = "block")]
        Block,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileProperties {
    #[serde(rename = "creationTime", default, skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<String>,
    #[serde(rename = "lastModified")]
    pub last_modified: String,
    #[serde(rename = "contentLength")]
    pub content_length: i64,
    #[serde(rename = "contentType", default, skip_serializing_if = "Option::is_none")]
    pub content_type: Option<String>,
    #[serde(rename = "fileMode", default, skip_serializing_if = "Option::is_none")]
    pub file_mode: Option<String>,
}
impl FileProperties {
    pub fn new(last_modified: String, content_length: i64) -> Self {
        Self {
            creation_time: None,
            last_modified,
            content_length,
            content_type: None,
            file_mode: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ImageReference {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub publisher: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub offer: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub sku: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "virtualMachineImageId", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_image_id: Option<String>,
}
impl ImageReference {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InboundEndpoint {
    pub name: String,
    #[serde(deserialize_with = "case_insensitive_deserialize")]
    pub protocol: InboundEndpointProtocol,
    #[serde(rename = "publicIPAddress")]
    pub public_ip_address: String,
    #[serde(rename = "publicFQDN")]
    pub public_fqdn: String,
    #[serde(rename = "frontendPort")]
    pub frontend_port: i32,
    #[serde(rename = "backendPort")]
    pub backend_port: i32,
}
impl InboundEndpoint {
    pub fn new(
        name: String,
        protocol: InboundEndpointProtocol,
        public_ip_address: String,
        public_fqdn: String,
        frontend_port: i32,
        backend_port: i32,
    ) -> Self {
        Self {
            name,
            protocol,
            public_ip_address,
            public_fqdn,
            frontend_port,
            backend_port,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum InboundEndpointProtocol {
    #[serde(rename = "tcp")]
    Tcp,
    #[serde(rename = "udp")]
    Udp,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InboundNatPool {
    pub name: String,
    #[serde(deserialize_with = "case_insensitive_deserialize")]
    pub protocol: InboundEndpointProtocol,
    #[serde(rename = "backendPort")]
    pub backend_port: i32,
    #[serde(rename = "frontendPortRangeStart")]
    pub frontend_port_range_start: i32,
    #[serde(rename = "frontendPortRangeEnd")]
    pub frontend_port_range_end: i32,
    #[serde(rename = "networkSecurityGroupRules", default, skip_serializing_if = "Vec::is_empty")]
    pub network_security_group_rules: Vec<NetworkSecurityGroupRule>,
}
impl InboundNatPool {
    pub fn new(
        name: String,
        protocol: InboundEndpointProtocol,
        backend_port: i32,
        frontend_port_range_start: i32,
        frontend_port_range_end: i32,
    ) -> Self {
        Self {
            name,
            protocol,
            backend_port,
            frontend_port_range_start,
            frontend_port_range_end,
            network_security_group_rules: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobAddParameter {
    pub id: String,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub constraints: Option<JobConstraints>,
    #[serde(rename = "jobManagerTask", default, skip_serializing_if = "Option::is_none")]
    pub job_manager_task: Option<JobManagerTask>,
    #[serde(rename = "jobPreparationTask", default, skip_serializing_if = "Option::is_none")]
    pub job_preparation_task: Option<JobPreparationTask>,
    #[serde(rename = "jobReleaseTask", default, skip_serializing_if = "Option::is_none")]
    pub job_release_task: Option<JobReleaseTask>,
    #[serde(rename = "commonEnvironmentSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub common_environment_settings: Vec<EnvironmentSetting>,
    #[serde(rename = "poolInfo")]
    pub pool_info: PoolInformation,
    #[serde(
        rename = "onAllTasksComplete",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub on_all_tasks_complete: Option<OnAllTasksComplete>,
    #[serde(
        rename = "onTaskFailure",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub on_task_failure: Option<OnTaskFailure>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
    #[serde(rename = "usesTaskDependencies", default, skip_serializing_if = "Option::is_none")]
    pub uses_task_dependencies: Option<bool>,
}
impl JobAddParameter {
    pub fn new(id: String, pool_info: PoolInformation) -> Self {
        Self {
            id,
            display_name: None,
            priority: None,
            constraints: None,
            job_manager_task: None,
            job_preparation_task: None,
            job_release_task: None,
            common_environment_settings: Vec::new(),
            pool_info,
            on_all_tasks_complete: None,
            on_task_failure: None,
            metadata: Vec::new(),
            uses_task_dependencies: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobConstraints {
    #[serde(rename = "maxWallClockTime", default, skip_serializing_if = "Option::is_none")]
    pub max_wall_clock_time: Option<String>,
    #[serde(rename = "maxTaskRetryCount", default, skip_serializing_if = "Option::is_none")]
    pub max_task_retry_count: Option<i32>,
}
impl JobConstraints {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobDisableParameter {
    #[serde(rename = "disableTasks", deserialize_with = "case_insensitive_deserialize")]
    pub disable_tasks: job_disable_parameter::DisableTasks,
}
impl JobDisableParameter {
    pub fn new(disable_tasks: job_disable_parameter::DisableTasks) -> Self {
        Self { disable_tasks }
    }
}
pub mod job_disable_parameter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum DisableTasks {
        #[serde(rename = "requeue")]
        Requeue,
        #[serde(rename = "terminate")]
        Terminate,
        #[serde(rename = "wait")]
        Wait,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobExecutionInformation {
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "poolId", default, skip_serializing_if = "Option::is_none")]
    pub pool_id: Option<String>,
    #[serde(rename = "schedulingError", default, skip_serializing_if = "Option::is_none")]
    pub scheduling_error: Option<JobSchedulingError>,
    #[serde(rename = "terminateReason", default, skip_serializing_if = "Option::is_none")]
    pub terminate_reason: Option<String>,
}
impl JobExecutionInformation {
    pub fn new(start_time: String) -> Self {
        Self {
            start_time,
            end_time: None,
            pool_id: None,
            scheduling_error: None,
            terminate_reason: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobManagerTask {
    pub id: String,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "commandLine")]
    pub command_line: String,
    #[serde(rename = "containerSettings", default, skip_serializing_if = "Option::is_none")]
    pub container_settings: Option<TaskContainerSettings>,
    #[serde(rename = "resourceFiles", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_files: Vec<ResourceFile>,
    #[serde(rename = "outputFiles", default, skip_serializing_if = "Vec::is_empty")]
    pub output_files: Vec<OutputFile>,
    #[serde(rename = "environmentSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub environment_settings: Vec<EnvironmentSetting>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub constraints: Option<TaskConstraints>,
    #[serde(rename = "killJobOnCompletion", default, skip_serializing_if = "Option::is_none")]
    pub kill_job_on_completion: Option<bool>,
    #[serde(rename = "userIdentity", default, skip_serializing_if = "Option::is_none")]
    pub user_identity: Option<UserIdentity>,
    #[serde(rename = "runExclusive", default, skip_serializing_if = "Option::is_none")]
    pub run_exclusive: Option<bool>,
    #[serde(rename = "applicationPackageReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub application_package_references: Vec<ApplicationPackageReference>,
    #[serde(rename = "authenticationTokenSettings", default, skip_serializing_if = "Option::is_none")]
    pub authentication_token_settings: Option<AuthenticationTokenSettings>,
    #[serde(rename = "allowLowPriorityNode", default, skip_serializing_if = "Option::is_none")]
    pub allow_low_priority_node: Option<bool>,
}
impl JobManagerTask {
    pub fn new(id: String, command_line: String) -> Self {
        Self {
            id,
            display_name: None,
            command_line,
            container_settings: None,
            resource_files: Vec::new(),
            output_files: Vec::new(),
            environment_settings: Vec::new(),
            constraints: None,
            kill_job_on_completion: None,
            user_identity: None,
            run_exclusive: None,
            application_package_references: Vec::new(),
            authentication_token_settings: None,
            allow_low_priority_node: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobPatchParameter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[serde(
        rename = "onAllTasksComplete",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub on_all_tasks_complete: Option<OnAllTasksComplete>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub constraints: Option<JobConstraints>,
    #[serde(rename = "poolInfo", default, skip_serializing_if = "Option::is_none")]
    pub pool_info: Option<PoolInformation>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
}
impl JobPatchParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobPreparationAndReleaseTaskExecutionInformation {
    #[serde(rename = "poolId", default, skip_serializing_if = "Option::is_none")]
    pub pool_id: Option<String>,
    #[serde(rename = "nodeId", default, skip_serializing_if = "Option::is_none")]
    pub node_id: Option<String>,
    #[serde(rename = "nodeUrl", default, skip_serializing_if = "Option::is_none")]
    pub node_url: Option<String>,
    #[serde(rename = "jobPreparationTaskExecutionInfo", default, skip_serializing_if = "Option::is_none")]
    pub job_preparation_task_execution_info: Option<JobPreparationTaskExecutionInformation>,
    #[serde(rename = "jobReleaseTaskExecutionInfo", default, skip_serializing_if = "Option::is_none")]
    pub job_release_task_execution_info: Option<JobReleaseTaskExecutionInformation>,
}
impl JobPreparationAndReleaseTaskExecutionInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobPreparationTask {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "commandLine")]
    pub command_line: String,
    #[serde(rename = "containerSettings", default, skip_serializing_if = "Option::is_none")]
    pub container_settings: Option<TaskContainerSettings>,
    #[serde(rename = "resourceFiles", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_files: Vec<ResourceFile>,
    #[serde(rename = "environmentSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub environment_settings: Vec<EnvironmentSetting>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub constraints: Option<TaskConstraints>,
    #[serde(rename = "waitForSuccess", default, skip_serializing_if = "Option::is_none")]
    pub wait_for_success: Option<bool>,
    #[serde(rename = "userIdentity", default, skip_serializing_if = "Option::is_none")]
    pub user_identity: Option<UserIdentity>,
    #[serde(rename = "rerunOnNodeRebootAfterSuccess", default, skip_serializing_if = "Option::is_none")]
    pub rerun_on_node_reboot_after_success: Option<bool>,
}
impl JobPreparationTask {
    pub fn new(command_line: String) -> Self {
        Self {
            id: None,
            command_line,
            container_settings: None,
            resource_files: Vec::new(),
            environment_settings: Vec::new(),
            constraints: None,
            wait_for_success: None,
            user_identity: None,
            rerun_on_node_reboot_after_success: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobPreparationTaskExecutionInformation {
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(deserialize_with = "case_insensitive_deserialize")]
    pub state: job_preparation_task_execution_information::State,
    #[serde(rename = "taskRootDirectory", default, skip_serializing_if = "Option::is_none")]
    pub task_root_directory: Option<String>,
    #[serde(rename = "taskRootDirectoryUrl", default, skip_serializing_if = "Option::is_none")]
    pub task_root_directory_url: Option<String>,
    #[serde(rename = "exitCode", default, skip_serializing_if = "Option::is_none")]
    pub exit_code: Option<i32>,
    #[serde(rename = "containerInfo", default, skip_serializing_if = "Option::is_none")]
    pub container_info: Option<TaskContainerExecutionInformation>,
    #[serde(rename = "failureInfo", default, skip_serializing_if = "Option::is_none")]
    pub failure_info: Option<TaskFailureInformation>,
    #[serde(rename = "retryCount")]
    pub retry_count: i32,
    #[serde(rename = "lastRetryTime", default, skip_serializing_if = "Option::is_none")]
    pub last_retry_time: Option<String>,
    #[serde(
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub result: Option<TaskExecutionResult>,
}
impl JobPreparationTaskExecutionInformation {
    pub fn new(start_time: String, state: job_preparation_task_execution_information::State, retry_count: i32) -> Self {
        Self {
            start_time,
            end_time: None,
            state,
            task_root_directory: None,
            task_root_directory_url: None,
            exit_code: None,
            container_info: None,
            failure_info: None,
            retry_count,
            last_retry_time: None,
            result: None,
        }
    }
}
pub mod job_preparation_task_execution_information {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        #[serde(rename = "running")]
        Running,
        #[serde(rename = "completed")]
        Completed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobReleaseTask {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "commandLine")]
    pub command_line: String,
    #[serde(rename = "containerSettings", default, skip_serializing_if = "Option::is_none")]
    pub container_settings: Option<TaskContainerSettings>,
    #[serde(rename = "resourceFiles", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_files: Vec<ResourceFile>,
    #[serde(rename = "environmentSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub environment_settings: Vec<EnvironmentSetting>,
    #[serde(rename = "maxWallClockTime", default, skip_serializing_if = "Option::is_none")]
    pub max_wall_clock_time: Option<String>,
    #[serde(rename = "retentionTime", default, skip_serializing_if = "Option::is_none")]
    pub retention_time: Option<String>,
    #[serde(rename = "userIdentity", default, skip_serializing_if = "Option::is_none")]
    pub user_identity: Option<UserIdentity>,
}
impl JobReleaseTask {
    pub fn new(command_line: String) -> Self {
        Self {
            id: None,
            command_line,
            container_settings: None,
            resource_files: Vec::new(),
            environment_settings: Vec::new(),
            max_wall_clock_time: None,
            retention_time: None,
            user_identity: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobReleaseTaskExecutionInformation {
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(deserialize_with = "case_insensitive_deserialize")]
    pub state: job_release_task_execution_information::State,
    #[serde(rename = "taskRootDirectory", default, skip_serializing_if = "Option::is_none")]
    pub task_root_directory: Option<String>,
    #[serde(rename = "taskRootDirectoryUrl", default, skip_serializing_if = "Option::is_none")]
    pub task_root_directory_url: Option<String>,
    #[serde(rename = "exitCode", default, skip_serializing_if = "Option::is_none")]
    pub exit_code: Option<i32>,
    #[serde(rename = "containerInfo", default, skip_serializing_if = "Option::is_none")]
    pub container_info: Option<TaskContainerExecutionInformation>,
    #[serde(rename = "failureInfo", default, skip_serializing_if = "Option::is_none")]
    pub failure_info: Option<TaskFailureInformation>,
    #[serde(
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub result: Option<TaskExecutionResult>,
}
impl JobReleaseTaskExecutionInformation {
    pub fn new(start_time: String, state: job_release_task_execution_information::State) -> Self {
        Self {
            start_time,
            end_time: None,
            state,
            task_root_directory: None,
            task_root_directory_url: None,
            exit_code: None,
            container_info: None,
            failure_info: None,
            result: None,
        }
    }
}
pub mod job_release_task_execution_information {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        #[serde(rename = "running")]
        Running,
        #[serde(rename = "completed")]
        Completed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobScheduleAddParameter {
    pub id: String,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    pub schedule: Schedule,
    #[serde(rename = "jobSpecification")]
    pub job_specification: JobSpecification,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
}
impl JobScheduleAddParameter {
    pub fn new(id: String, schedule: Schedule, job_specification: JobSpecification) -> Self {
        Self {
            id,
            display_name: None,
            schedule,
            job_specification,
            metadata: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobScheduleExecutionInformation {
    #[serde(rename = "nextRunTime", default, skip_serializing_if = "Option::is_none")]
    pub next_run_time: Option<String>,
    #[serde(rename = "recentJob", default, skip_serializing_if = "Option::is_none")]
    pub recent_job: Option<RecentJob>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
}
impl JobScheduleExecutionInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobSchedulePatchParameter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub schedule: Option<Schedule>,
    #[serde(rename = "jobSpecification", default, skip_serializing_if = "Option::is_none")]
    pub job_specification: Option<JobSpecification>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
}
impl JobSchedulePatchParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum JobScheduleState {
    #[serde(rename = "active")]
    Active,
    #[serde(rename = "completed")]
    Completed,
    #[serde(rename = "disabled")]
    Disabled,
    #[serde(rename = "terminating")]
    Terminating,
    #[serde(rename = "deleting")]
    Deleting,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobScheduleStatistics {
    pub url: String,
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[serde(rename = "lastUpdateTime")]
    pub last_update_time: String,
    #[serde(rename = "userCPUTime")]
    pub user_cpu_time: String,
    #[serde(rename = "kernelCPUTime")]
    pub kernel_cpu_time: String,
    #[serde(rename = "wallClockTime")]
    pub wall_clock_time: String,
    #[serde(rename = "readIOps")]
    pub read_i_ops: i64,
    #[serde(rename = "writeIOps")]
    pub write_i_ops: i64,
    #[serde(rename = "readIOGiB")]
    pub read_io_gi_b: f64,
    #[serde(rename = "writeIOGiB")]
    pub write_io_gi_b: f64,
    #[serde(rename = "numSucceededTasks")]
    pub num_succeeded_tasks: i64,
    #[serde(rename = "numFailedTasks")]
    pub num_failed_tasks: i64,
    #[serde(rename = "numTaskRetries")]
    pub num_task_retries: i64,
    #[serde(rename = "waitTime")]
    pub wait_time: String,
}
impl JobScheduleStatistics {
    pub fn new(
        url: String,
        start_time: String,
        last_update_time: String,
        user_cpu_time: String,
        kernel_cpu_time: String,
        wall_clock_time: String,
        read_i_ops: i64,
        write_i_ops: i64,
        read_io_gi_b: f64,
        write_io_gi_b: f64,
        num_succeeded_tasks: i64,
        num_failed_tasks: i64,
        num_task_retries: i64,
        wait_time: String,
    ) -> Self {
        Self {
            url,
            start_time,
            last_update_time,
            user_cpu_time,
            kernel_cpu_time,
            wall_clock_time,
            read_i_ops,
            write_i_ops,
            read_io_gi_b,
            write_io_gi_b,
            num_succeeded_tasks,
            num_failed_tasks,
            num_task_retries,
            wait_time,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobScheduleUpdateParameter {
    pub schedule: Schedule,
    #[serde(rename = "jobSpecification")]
    pub job_specification: JobSpecification,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
}
impl JobScheduleUpdateParameter {
    pub fn new(schedule: Schedule, job_specification: JobSpecification) -> Self {
        Self {
            schedule,
            job_specification,
            metadata: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobSchedulingError {
    #[serde(deserialize_with = "case_insensitive_deserialize")]
    pub category: ErrorCategory,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<NameValuePair>,
}
impl JobSchedulingError {
    pub fn new(category: ErrorCategory) -> Self {
        Self {
            category,
            code: None,
            message: None,
            details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobSpecification {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "usesTaskDependencies", default, skip_serializing_if = "Option::is_none")]
    pub uses_task_dependencies: Option<bool>,
    #[serde(
        rename = "onAllTasksComplete",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub on_all_tasks_complete: Option<OnAllTasksComplete>,
    #[serde(
        rename = "onTaskFailure",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub on_task_failure: Option<OnTaskFailure>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub constraints: Option<JobConstraints>,
    #[serde(rename = "jobManagerTask", default, skip_serializing_if = "Option::is_none")]
    pub job_manager_task: Option<JobManagerTask>,
    #[serde(rename = "jobPreparationTask", default, skip_serializing_if = "Option::is_none")]
    pub job_preparation_task: Option<JobPreparationTask>,
    #[serde(rename = "jobReleaseTask", default, skip_serializing_if = "Option::is_none")]
    pub job_release_task: Option<JobReleaseTask>,
    #[serde(rename = "commonEnvironmentSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub common_environment_settings: Vec<EnvironmentSetting>,
    #[serde(rename = "poolInfo")]
    pub pool_info: PoolInformation,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
}
impl JobSpecification {
    pub fn new(pool_info: PoolInformation) -> Self {
        Self {
            priority: None,
            display_name: None,
            uses_task_dependencies: None,
            on_all_tasks_complete: None,
            on_task_failure: None,
            constraints: None,
            job_manager_task: None,
            job_preparation_task: None,
            job_release_task: None,
            common_environment_settings: Vec::new(),
            pool_info,
            metadata: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum JobState {
    #[serde(rename = "active")]
    Active,
    #[serde(rename = "disabling")]
    Disabling,
    #[serde(rename = "disabled")]
    Disabled,
    #[serde(rename = "enabling")]
    Enabling,
    #[serde(rename = "terminating")]
    Terminating,
    #[serde(rename = "completed")]
    Completed,
    #[serde(rename = "deleting")]
    Deleting,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobStatistics {
    pub url: String,
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[serde(rename = "lastUpdateTime")]
    pub last_update_time: String,
    #[serde(rename = "userCPUTime")]
    pub user_cpu_time: String,
    #[serde(rename = "kernelCPUTime")]
    pub kernel_cpu_time: String,
    #[serde(rename = "wallClockTime")]
    pub wall_clock_time: String,
    #[serde(rename = "readIOps")]
    pub read_i_ops: i64,
    #[serde(rename = "writeIOps")]
    pub write_i_ops: i64,
    #[serde(rename = "readIOGiB")]
    pub read_io_gi_b: f64,
    #[serde(rename = "writeIOGiB")]
    pub write_io_gi_b: f64,
    #[serde(rename = "numSucceededTasks")]
    pub num_succeeded_tasks: i64,
    #[serde(rename = "numFailedTasks")]
    pub num_failed_tasks: i64,
    #[serde(rename = "numTaskRetries")]
    pub num_task_retries: i64,
    #[serde(rename = "waitTime")]
    pub wait_time: String,
}
impl JobStatistics {
    pub fn new(
        url: String,
        start_time: String,
        last_update_time: String,
        user_cpu_time: String,
        kernel_cpu_time: String,
        wall_clock_time: String,
        read_i_ops: i64,
        write_i_ops: i64,
        read_io_gi_b: f64,
        write_io_gi_b: f64,
        num_succeeded_tasks: i64,
        num_failed_tasks: i64,
        num_task_retries: i64,
        wait_time: String,
    ) -> Self {
        Self {
            url,
            start_time,
            last_update_time,
            user_cpu_time,
            kernel_cpu_time,
            wall_clock_time,
            read_i_ops,
            write_i_ops,
            read_io_gi_b,
            write_io_gi_b,
            num_succeeded_tasks,
            num_failed_tasks,
            num_task_retries,
            wait_time,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct JobTerminateParameter {
    #[serde(rename = "terminateReason", default, skip_serializing_if = "Option::is_none")]
    pub terminate_reason: Option<String>,
}
impl JobTerminateParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct JobUpdateParameter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub priority: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub constraints: Option<JobConstraints>,
    #[serde(rename = "poolInfo")]
    pub pool_info: PoolInformation,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
    #[serde(
        rename = "onAllTasksComplete",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub on_all_tasks_complete: Option<OnAllTasksComplete>,
}
impl JobUpdateParameter {
    pub fn new(pool_info: PoolInformation) -> Self {
        Self {
            priority: None,
            constraints: None,
            pool_info,
            metadata: Vec::new(),
            on_all_tasks_complete: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct LinuxUserConfiguration {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub uid: Option<i32>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub gid: Option<i32>,
    #[serde(rename = "sshPrivateKey", default, skip_serializing_if = "Option::is_none")]
    pub ssh_private_key: Option<String>,
}
impl LinuxUserConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MetadataItem {
    pub name: String,
    pub value: String,
}
impl MetadataItem {
    pub fn new(name: String, value: String) -> Self {
        Self { name, value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MultiInstanceSettings {
    #[serde(rename = "numberOfInstances", default, skip_serializing_if = "Option::is_none")]
    pub number_of_instances: Option<i32>,
    #[serde(rename = "coordinationCommandLine")]
    pub coordination_command_line: String,
    #[serde(rename = "commonResourceFiles", default, skip_serializing_if = "Vec::is_empty")]
    pub common_resource_files: Vec<ResourceFile>,
}
impl MultiInstanceSettings {
    pub fn new(coordination_command_line: String) -> Self {
        Self {
            number_of_instances: None,
            coordination_command_line,
            common_resource_files: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NameValuePair {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}
impl NameValuePair {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NetworkConfiguration {
    #[serde(rename = "subnetId", default, skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
    #[serde(rename = "endpointConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub endpoint_configuration: Option<PoolEndpointConfiguration>,
}
impl NetworkConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkSecurityGroupRule {
    pub priority: i32,
    #[serde(deserialize_with = "case_insensitive_deserialize")]
    pub access: network_security_group_rule::Access,
    #[serde(rename = "sourceAddressPrefix")]
    pub source_address_prefix: String,
}
impl NetworkSecurityGroupRule {
    pub fn new(priority: i32, access: network_security_group_rule::Access, source_address_prefix: String) -> Self {
        Self {
            priority,
            access,
            source_address_prefix,
        }
    }
}
pub mod network_security_group_rule {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Access {
        #[serde(rename = "allow")]
        Allow,
        #[serde(rename = "deny")]
        Deny,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NodeAgentInformation {
    pub version: String,
    #[serde(rename = "lastUpdateTime")]
    pub last_update_time: String,
}
impl NodeAgentInformation {
    pub fn new(version: String, last_update_time: String) -> Self {
        Self { version, last_update_time }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NodeAgentSku {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "verifiedImageReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub verified_image_references: Vec<ImageReference>,
    #[serde(
        rename = "osType",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub os_type: Option<node_agent_sku::OsType>,
}
impl NodeAgentSku {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod node_agent_sku {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum OsType {
        #[serde(rename = "linux")]
        Linux,
        #[serde(rename = "windows")]
        Windows,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NodeCounts {
    pub creating: i32,
    pub idle: i32,
    pub offline: i32,
    pub preempted: i32,
    pub rebooting: i32,
    pub reimaging: i32,
    pub running: i32,
    pub starting: i32,
    #[serde(rename = "startTaskFailed")]
    pub start_task_failed: i32,
    #[serde(rename = "leavingPool")]
    pub leaving_pool: i32,
    pub unknown: i32,
    pub unusable: i32,
    #[serde(rename = "waitingForStartTask")]
    pub waiting_for_start_task: i32,
    pub total: i32,
}
impl NodeCounts {
    pub fn new(
        creating: i32,
        idle: i32,
        offline: i32,
        preempted: i32,
        rebooting: i32,
        reimaging: i32,
        running: i32,
        starting: i32,
        start_task_failed: i32,
        leaving_pool: i32,
        unknown: i32,
        unusable: i32,
        waiting_for_start_task: i32,
        total: i32,
    ) -> Self {
        Self {
            creating,
            idle,
            offline,
            preempted,
            rebooting,
            reimaging,
            running,
            starting,
            start_task_failed,
            leaving_pool,
            unknown,
            unusable,
            waiting_for_start_task,
            total,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NodeDisableSchedulingParameter {
    #[serde(
        rename = "nodeDisableSchedulingOption",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub node_disable_scheduling_option: Option<node_disable_scheduling_parameter::NodeDisableSchedulingOption>,
}
impl NodeDisableSchedulingParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod node_disable_scheduling_parameter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NodeDisableSchedulingOption {
        #[serde(rename = "requeue")]
        Requeue,
        #[serde(rename = "terminate")]
        Terminate,
        #[serde(rename = "taskcompletion")]
        Taskcompletion,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NodeFile {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "isDirectory", default, skip_serializing_if = "Option::is_none")]
    pub is_directory: Option<bool>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub properties: Option<FileProperties>,
}
impl NodeFile {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NodeFileListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<NodeFile>,
    #[serde(rename = "odata.nextLink", default, skip_serializing_if = "Option::is_none")]
    pub odata_next_link: Option<String>,
}
impl NodeFileListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NodeRebootParameter {
    #[serde(
        rename = "nodeRebootOption",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub node_reboot_option: Option<node_reboot_parameter::NodeRebootOption>,
}
impl NodeRebootParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod node_reboot_parameter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NodeRebootOption {
        #[serde(rename = "requeue")]
        Requeue,
        #[serde(rename = "terminate")]
        Terminate,
        #[serde(rename = "taskcompletion")]
        Taskcompletion,
        #[serde(rename = "retaineddata")]
        Retaineddata,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NodeReimageParameter {
    #[serde(
        rename = "nodeReimageOption",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub node_reimage_option: Option<node_reimage_parameter::NodeReimageOption>,
}
impl NodeReimageParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
pub mod node_reimage_parameter {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NodeReimageOption {
        #[serde(rename = "requeue")]
        Requeue,
        #[serde(rename = "terminate")]
        Terminate,
        #[serde(rename = "taskcompletion")]
        Taskcompletion,
        #[serde(rename = "retaineddata")]
        Retaineddata,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NodeRemoveParameter {
    #[serde(rename = "nodeList")]
    pub node_list: Vec<String>,
    #[serde(rename = "resizeTimeout", default, skip_serializing_if = "Option::is_none")]
    pub resize_timeout: Option<String>,
    #[serde(
        rename = "nodeDeallocationOption",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub node_deallocation_option: Option<ComputeNodeDeallocationOption>,
}
impl NodeRemoveParameter {
    pub fn new(node_list: Vec<String>) -> Self {
        Self {
            node_list,
            resize_timeout: None,
            node_deallocation_option: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct NodeUpdateUserParameter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    #[serde(rename = "expiryTime", default, skip_serializing_if = "Option::is_none")]
    pub expiry_time: Option<String>,
    #[serde(rename = "sshPublicKey", default, skip_serializing_if = "Option::is_none")]
    pub ssh_public_key: Option<String>,
}
impl NodeUpdateUserParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OsDisk {
    #[serde(
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub caching: Option<CachingType>,
}
impl OsDisk {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum OnAllTasksComplete {
    #[serde(rename = "noaction")]
    Noaction,
    #[serde(rename = "terminatejob")]
    Terminatejob,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum OnTaskFailure {
    #[serde(rename = "noaction")]
    Noaction,
    #[serde(rename = "performexitoptionsjobaction")]
    Performexitoptionsjobaction,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OutputFile {
    #[serde(rename = "filePattern")]
    pub file_pattern: String,
    pub destination: OutputFileDestination,
    #[serde(rename = "uploadOptions")]
    pub upload_options: OutputFileUploadOptions,
}
impl OutputFile {
    pub fn new(file_pattern: String, destination: OutputFileDestination, upload_options: OutputFileUploadOptions) -> Self {
        Self {
            file_pattern,
            destination,
            upload_options,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OutputFileBlobContainerDestination {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    #[serde(rename = "containerUrl")]
    pub container_url: String,
}
impl OutputFileBlobContainerDestination {
    pub fn new(container_url: String) -> Self {
        Self { path: None, container_url }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct OutputFileDestination {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub container: Option<OutputFileBlobContainerDestination>,
}
impl OutputFileDestination {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum OutputFileUploadCondition {
    #[serde(rename = "tasksuccess")]
    Tasksuccess,
    #[serde(rename = "taskfailure")]
    Taskfailure,
    #[serde(rename = "taskcompletion")]
    Taskcompletion,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OutputFileUploadOptions {
    #[serde(rename = "uploadCondition", deserialize_with = "case_insensitive_deserialize")]
    pub upload_condition: OutputFileUploadCondition,
}
impl OutputFileUploadOptions {
    pub fn new(upload_condition: OutputFileUploadCondition) -> Self {
        Self { upload_condition }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PoolAddParameter {
    pub id: String,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "vmSize")]
    pub vm_size: String,
    #[serde(rename = "cloudServiceConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub cloud_service_configuration: Option<CloudServiceConfiguration>,
    #[serde(rename = "virtualMachineConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_configuration: Option<VirtualMachineConfiguration>,
    #[serde(rename = "resizeTimeout", default, skip_serializing_if = "Option::is_none")]
    pub resize_timeout: Option<String>,
    #[serde(rename = "targetDedicatedNodes", default, skip_serializing_if = "Option::is_none")]
    pub target_dedicated_nodes: Option<i32>,
    #[serde(rename = "targetLowPriorityNodes", default, skip_serializing_if = "Option::is_none")]
    pub target_low_priority_nodes: Option<i32>,
    #[serde(rename = "enableAutoScale", default, skip_serializing_if = "Option::is_none")]
    pub enable_auto_scale: Option<bool>,
    #[serde(rename = "autoScaleFormula", default, skip_serializing_if = "Option::is_none")]
    pub auto_scale_formula: Option<String>,
    #[serde(rename = "autoScaleEvaluationInterval", default, skip_serializing_if = "Option::is_none")]
    pub auto_scale_evaluation_interval: Option<String>,
    #[serde(rename = "enableInterNodeCommunication", default, skip_serializing_if = "Option::is_none")]
    pub enable_inter_node_communication: Option<bool>,
    #[serde(rename = "networkConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub network_configuration: Option<NetworkConfiguration>,
    #[serde(rename = "startTask", default, skip_serializing_if = "Option::is_none")]
    pub start_task: Option<StartTask>,
    #[serde(rename = "certificateReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub certificate_references: Vec<CertificateReference>,
    #[serde(rename = "applicationPackageReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub application_package_references: Vec<ApplicationPackageReference>,
    #[serde(rename = "applicationLicenses", default, skip_serializing_if = "Vec::is_empty")]
    pub application_licenses: Vec<String>,
    #[serde(rename = "maxTasksPerNode", default, skip_serializing_if = "Option::is_none")]
    pub max_tasks_per_node: Option<i32>,
    #[serde(rename = "taskSchedulingPolicy", default, skip_serializing_if = "Option::is_none")]
    pub task_scheduling_policy: Option<TaskSchedulingPolicy>,
    #[serde(rename = "userAccounts", default, skip_serializing_if = "Vec::is_empty")]
    pub user_accounts: Vec<UserAccount>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
}
impl PoolAddParameter {
    pub fn new(id: String, vm_size: String) -> Self {
        Self {
            id,
            display_name: None,
            vm_size,
            cloud_service_configuration: None,
            virtual_machine_configuration: None,
            resize_timeout: None,
            target_dedicated_nodes: None,
            target_low_priority_nodes: None,
            enable_auto_scale: None,
            auto_scale_formula: None,
            auto_scale_evaluation_interval: None,
            enable_inter_node_communication: None,
            network_configuration: None,
            start_task: None,
            certificate_references: Vec::new(),
            application_package_references: Vec::new(),
            application_licenses: Vec::new(),
            max_tasks_per_node: None,
            task_scheduling_policy: None,
            user_accounts: Vec::new(),
            metadata: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PoolEnableAutoScaleParameter {
    #[serde(rename = "autoScaleFormula", default, skip_serializing_if = "Option::is_none")]
    pub auto_scale_formula: Option<String>,
    #[serde(rename = "autoScaleEvaluationInterval", default, skip_serializing_if = "Option::is_none")]
    pub auto_scale_evaluation_interval: Option<String>,
}
impl PoolEnableAutoScaleParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PoolEndpointConfiguration {
    #[serde(rename = "inboundNATPools")]
    pub inbound_nat_pools: Vec<InboundNatPool>,
}
impl PoolEndpointConfiguration {
    pub fn new(inbound_nat_pools: Vec<InboundNatPool>) -> Self {
        Self { inbound_nat_pools }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PoolEvaluateAutoScaleParameter {
    #[serde(rename = "autoScaleFormula")]
    pub auto_scale_formula: String,
}
impl PoolEvaluateAutoScaleParameter {
    pub fn new(auto_scale_formula: String) -> Self {
        Self { auto_scale_formula }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PoolInformation {
    #[serde(rename = "poolId", default, skip_serializing_if = "Option::is_none")]
    pub pool_id: Option<String>,
    #[serde(rename = "autoPoolSpecification", default, skip_serializing_if = "Option::is_none")]
    pub auto_pool_specification: Option<AutoPoolSpecification>,
}
impl PoolInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PoolListUsageMetricsResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PoolUsageMetrics>,
    #[serde(rename = "odata.nextLink", default, skip_serializing_if = "Option::is_none")]
    pub odata_next_link: Option<String>,
}
impl PoolListUsageMetricsResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PoolNodeCounts {
    #[serde(rename = "poolId")]
    pub pool_id: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub dedicated: Option<NodeCounts>,
    #[serde(rename = "lowPriority", default, skip_serializing_if = "Option::is_none")]
    pub low_priority: Option<NodeCounts>,
}
impl PoolNodeCounts {
    pub fn new(pool_id: String) -> Self {
        Self {
            pool_id,
            dedicated: None,
            low_priority: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PoolNodeCountsListResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<PoolNodeCounts>,
    #[serde(rename = "odata.nextLink", default, skip_serializing_if = "Option::is_none")]
    pub odata_next_link: Option<String>,
}
impl PoolNodeCountsListResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PoolPatchParameter {
    #[serde(rename = "startTask", default, skip_serializing_if = "Option::is_none")]
    pub start_task: Option<StartTask>,
    #[serde(rename = "certificateReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub certificate_references: Vec<CertificateReference>,
    #[serde(rename = "applicationPackageReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub application_package_references: Vec<ApplicationPackageReference>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
}
impl PoolPatchParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct PoolResizeParameter {
    #[serde(rename = "targetDedicatedNodes", default, skip_serializing_if = "Option::is_none")]
    pub target_dedicated_nodes: Option<i32>,
    #[serde(rename = "targetLowPriorityNodes", default, skip_serializing_if = "Option::is_none")]
    pub target_low_priority_nodes: Option<i32>,
    #[serde(rename = "resizeTimeout", default, skip_serializing_if = "Option::is_none")]
    pub resize_timeout: Option<String>,
    #[serde(
        rename = "nodeDeallocationOption",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub node_deallocation_option: Option<ComputeNodeDeallocationOption>,
}
impl PoolResizeParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PoolSpecification {
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "vmSize")]
    pub vm_size: String,
    #[serde(rename = "cloudServiceConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub cloud_service_configuration: Option<CloudServiceConfiguration>,
    #[serde(rename = "virtualMachineConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub virtual_machine_configuration: Option<VirtualMachineConfiguration>,
    #[serde(rename = "maxTasksPerNode", default, skip_serializing_if = "Option::is_none")]
    pub max_tasks_per_node: Option<i32>,
    #[serde(rename = "taskSchedulingPolicy", default, skip_serializing_if = "Option::is_none")]
    pub task_scheduling_policy: Option<TaskSchedulingPolicy>,
    #[serde(rename = "resizeTimeout", default, skip_serializing_if = "Option::is_none")]
    pub resize_timeout: Option<String>,
    #[serde(rename = "targetDedicatedNodes", default, skip_serializing_if = "Option::is_none")]
    pub target_dedicated_nodes: Option<i32>,
    #[serde(rename = "targetLowPriorityNodes", default, skip_serializing_if = "Option::is_none")]
    pub target_low_priority_nodes: Option<i32>,
    #[serde(rename = "enableAutoScale", default, skip_serializing_if = "Option::is_none")]
    pub enable_auto_scale: Option<bool>,
    #[serde(rename = "autoScaleFormula", default, skip_serializing_if = "Option::is_none")]
    pub auto_scale_formula: Option<String>,
    #[serde(rename = "autoScaleEvaluationInterval", default, skip_serializing_if = "Option::is_none")]
    pub auto_scale_evaluation_interval: Option<String>,
    #[serde(rename = "enableInterNodeCommunication", default, skip_serializing_if = "Option::is_none")]
    pub enable_inter_node_communication: Option<bool>,
    #[serde(rename = "networkConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub network_configuration: Option<NetworkConfiguration>,
    #[serde(rename = "startTask", default, skip_serializing_if = "Option::is_none")]
    pub start_task: Option<StartTask>,
    #[serde(rename = "certificateReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub certificate_references: Vec<CertificateReference>,
    #[serde(rename = "applicationPackageReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub application_package_references: Vec<ApplicationPackageReference>,
    #[serde(rename = "applicationLicenses", default, skip_serializing_if = "Vec::is_empty")]
    pub application_licenses: Vec<String>,
    #[serde(rename = "userAccounts", default, skip_serializing_if = "Vec::is_empty")]
    pub user_accounts: Vec<UserAccount>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub metadata: Vec<MetadataItem>,
}
impl PoolSpecification {
    pub fn new(vm_size: String) -> Self {
        Self {
            display_name: None,
            vm_size,
            cloud_service_configuration: None,
            virtual_machine_configuration: None,
            max_tasks_per_node: None,
            task_scheduling_policy: None,
            resize_timeout: None,
            target_dedicated_nodes: None,
            target_low_priority_nodes: None,
            enable_auto_scale: None,
            auto_scale_formula: None,
            auto_scale_evaluation_interval: None,
            enable_inter_node_communication: None,
            network_configuration: None,
            start_task: None,
            certificate_references: Vec::new(),
            application_package_references: Vec::new(),
            application_licenses: Vec::new(),
            user_accounts: Vec::new(),
            metadata: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PoolStatistics {
    pub url: String,
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[serde(rename = "lastUpdateTime")]
    pub last_update_time: String,
    #[serde(rename = "usageStats", default, skip_serializing_if = "Option::is_none")]
    pub usage_stats: Option<UsageStatistics>,
    #[serde(rename = "resourceStats", default, skip_serializing_if = "Option::is_none")]
    pub resource_stats: Option<ResourceStatistics>,
}
impl PoolStatistics {
    pub fn new(url: String, start_time: String, last_update_time: String) -> Self {
        Self {
            url,
            start_time,
            last_update_time,
            usage_stats: None,
            resource_stats: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PoolUpdatePropertiesParameter {
    #[serde(rename = "startTask", default, skip_serializing_if = "Option::is_none")]
    pub start_task: Option<StartTask>,
    #[serde(rename = "certificateReferences")]
    pub certificate_references: Vec<CertificateReference>,
    #[serde(rename = "applicationPackageReferences")]
    pub application_package_references: Vec<ApplicationPackageReference>,
    pub metadata: Vec<MetadataItem>,
}
impl PoolUpdatePropertiesParameter {
    pub fn new(
        certificate_references: Vec<CertificateReference>,
        application_package_references: Vec<ApplicationPackageReference>,
        metadata: Vec<MetadataItem>,
    ) -> Self {
        Self {
            start_task: None,
            certificate_references,
            application_package_references,
            metadata,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PoolUpgradeOsParameter {
    #[serde(rename = "targetOSVersion")]
    pub target_os_version: String,
}
impl PoolUpgradeOsParameter {
    pub fn new(target_os_version: String) -> Self {
        Self { target_os_version }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct PoolUsageMetrics {
    #[serde(rename = "poolId")]
    pub pool_id: String,
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[serde(rename = "endTime")]
    pub end_time: String,
    #[serde(rename = "vmSize")]
    pub vm_size: String,
    #[serde(rename = "totalCoreHours")]
    pub total_core_hours: f64,
    #[serde(rename = "dataIngressGiB")]
    pub data_ingress_gi_b: f64,
    #[serde(rename = "dataEgressGiB")]
    pub data_egress_gi_b: f64,
}
impl PoolUsageMetrics {
    pub fn new(
        pool_id: String,
        start_time: String,
        end_time: String,
        vm_size: String,
        total_core_hours: f64,
        data_ingress_gi_b: f64,
        data_egress_gi_b: f64,
    ) -> Self {
        Self {
            pool_id,
            start_time,
            end_time,
            vm_size,
            total_core_hours,
            data_ingress_gi_b,
            data_egress_gi_b,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct RecentJob {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}
impl RecentJob {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct ResizeError {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub values: Vec<NameValuePair>,
}
impl ResizeError {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceFile {
    #[serde(rename = "blobSource")]
    pub blob_source: String,
    #[serde(rename = "filePath")]
    pub file_path: String,
    #[serde(rename = "fileMode", default, skip_serializing_if = "Option::is_none")]
    pub file_mode: Option<String>,
}
impl ResourceFile {
    pub fn new(blob_source: String, file_path: String) -> Self {
        Self {
            blob_source,
            file_path,
            file_mode: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ResourceStatistics {
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[serde(rename = "lastUpdateTime")]
    pub last_update_time: String,
    #[serde(rename = "avgCPUPercentage")]
    pub avg_cpu_percentage: f64,
    #[serde(rename = "avgMemoryGiB")]
    pub avg_memory_gi_b: f64,
    #[serde(rename = "peakMemoryGiB")]
    pub peak_memory_gi_b: f64,
    #[serde(rename = "avgDiskGiB")]
    pub avg_disk_gi_b: f64,
    #[serde(rename = "peakDiskGiB")]
    pub peak_disk_gi_b: f64,
    #[serde(rename = "diskReadIOps")]
    pub disk_read_i_ops: i64,
    #[serde(rename = "diskWriteIOps")]
    pub disk_write_i_ops: i64,
    #[serde(rename = "diskReadGiB")]
    pub disk_read_gi_b: f64,
    #[serde(rename = "diskWriteGiB")]
    pub disk_write_gi_b: f64,
    #[serde(rename = "networkReadGiB")]
    pub network_read_gi_b: f64,
    #[serde(rename = "networkWriteGiB")]
    pub network_write_gi_b: f64,
}
impl ResourceStatistics {
    pub fn new(
        start_time: String,
        last_update_time: String,
        avg_cpu_percentage: f64,
        avg_memory_gi_b: f64,
        peak_memory_gi_b: f64,
        avg_disk_gi_b: f64,
        peak_disk_gi_b: f64,
        disk_read_i_ops: i64,
        disk_write_i_ops: i64,
        disk_read_gi_b: f64,
        disk_write_gi_b: f64,
        network_read_gi_b: f64,
        network_write_gi_b: f64,
    ) -> Self {
        Self {
            start_time,
            last_update_time,
            avg_cpu_percentage,
            avg_memory_gi_b,
            peak_memory_gi_b,
            avg_disk_gi_b,
            peak_disk_gi_b,
            disk_read_i_ops,
            disk_write_i_ops,
            disk_read_gi_b,
            disk_write_gi_b,
            network_read_gi_b,
            network_write_gi_b,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct Schedule {
    #[serde(rename = "doNotRunUntil", default, skip_serializing_if = "Option::is_none")]
    pub do_not_run_until: Option<String>,
    #[serde(rename = "doNotRunAfter", default, skip_serializing_if = "Option::is_none")]
    pub do_not_run_after: Option<String>,
    #[serde(rename = "startWindow", default, skip_serializing_if = "Option::is_none")]
    pub start_window: Option<String>,
    #[serde(rename = "recurrenceInterval", default, skip_serializing_if = "Option::is_none")]
    pub recurrence_interval: Option<String>,
}
impl Schedule {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StartTask {
    #[serde(rename = "commandLine")]
    pub command_line: String,
    #[serde(rename = "containerSettings", default, skip_serializing_if = "Option::is_none")]
    pub container_settings: Option<TaskContainerSettings>,
    #[serde(rename = "resourceFiles", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_files: Vec<ResourceFile>,
    #[serde(rename = "environmentSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub environment_settings: Vec<EnvironmentSetting>,
    #[serde(rename = "userIdentity", default, skip_serializing_if = "Option::is_none")]
    pub user_identity: Option<UserIdentity>,
    #[serde(rename = "maxTaskRetryCount", default, skip_serializing_if = "Option::is_none")]
    pub max_task_retry_count: Option<i32>,
    #[serde(rename = "waitForSuccess", default, skip_serializing_if = "Option::is_none")]
    pub wait_for_success: Option<bool>,
}
impl StartTask {
    pub fn new(command_line: String) -> Self {
        Self {
            command_line,
            container_settings: None,
            resource_files: Vec::new(),
            environment_settings: Vec::new(),
            user_identity: None,
            max_task_retry_count: None,
            wait_for_success: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct StartTaskInformation {
    #[serde(deserialize_with = "case_insensitive_deserialize")]
    pub state: start_task_information::State,
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "exitCode", default, skip_serializing_if = "Option::is_none")]
    pub exit_code: Option<i32>,
    #[serde(rename = "containerInfo", default, skip_serializing_if = "Option::is_none")]
    pub container_info: Option<TaskContainerExecutionInformation>,
    #[serde(rename = "failureInfo", default, skip_serializing_if = "Option::is_none")]
    pub failure_info: Option<TaskFailureInformation>,
    #[serde(rename = "retryCount")]
    pub retry_count: i32,
    #[serde(rename = "lastRetryTime", default, skip_serializing_if = "Option::is_none")]
    pub last_retry_time: Option<String>,
    #[serde(
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub result: Option<TaskExecutionResult>,
}
impl StartTaskInformation {
    pub fn new(state: start_task_information::State, start_time: String, retry_count: i32) -> Self {
        Self {
            state,
            start_time,
            end_time: None,
            exit_code: None,
            container_info: None,
            failure_info: None,
            retry_count,
            last_retry_time: None,
            result: None,
        }
    }
}
pub mod start_task_information {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum State {
        #[serde(rename = "running")]
        Running,
        #[serde(rename = "completed")]
        Completed,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum StorageAccountType {
    #[serde(rename = "standard_lrs")]
    StandardLrs,
    #[serde(rename = "premium_lrs")]
    PremiumLrs,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct SubtaskInformation {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub id: Option<i32>,
    #[serde(rename = "nodeInfo", default, skip_serializing_if = "Option::is_none")]
    pub node_info: Option<ComputeNodeInformation>,
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "exitCode", default, skip_serializing_if = "Option::is_none")]
    pub exit_code: Option<i32>,
    #[serde(rename = "containerInfo", default, skip_serializing_if = "Option::is_none")]
    pub container_info: Option<TaskContainerExecutionInformation>,
    #[serde(rename = "failureInfo", default, skip_serializing_if = "Option::is_none")]
    pub failure_info: Option<TaskFailureInformation>,
    #[serde(
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub state: Option<SubtaskState>,
    #[serde(rename = "stateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub state_transition_time: Option<String>,
    #[serde(
        rename = "previousState",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub previous_state: Option<SubtaskState>,
    #[serde(rename = "previousStateTransitionTime", default, skip_serializing_if = "Option::is_none")]
    pub previous_state_transition_time: Option<String>,
    #[serde(
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub result: Option<TaskExecutionResult>,
}
impl SubtaskInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum SubtaskState {
    #[serde(rename = "preparing")]
    Preparing,
    #[serde(rename = "running")]
    Running,
    #[serde(rename = "completed")]
    Completed,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskAddCollectionParameter {
    pub value: Vec<TaskAddParameter>,
}
impl TaskAddCollectionParameter {
    pub fn new(value: Vec<TaskAddParameter>) -> Self {
        Self { value }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskAddCollectionResult {
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub value: Vec<TaskAddResult>,
}
impl TaskAddCollectionResult {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskAddParameter {
    pub id: String,
    #[serde(rename = "displayName", default, skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "commandLine")]
    pub command_line: String,
    #[serde(rename = "containerSettings", default, skip_serializing_if = "Option::is_none")]
    pub container_settings: Option<TaskContainerSettings>,
    #[serde(rename = "exitConditions", default, skip_serializing_if = "Option::is_none")]
    pub exit_conditions: Option<ExitConditions>,
    #[serde(rename = "resourceFiles", default, skip_serializing_if = "Vec::is_empty")]
    pub resource_files: Vec<ResourceFile>,
    #[serde(rename = "outputFiles", default, skip_serializing_if = "Vec::is_empty")]
    pub output_files: Vec<OutputFile>,
    #[serde(rename = "environmentSettings", default, skip_serializing_if = "Vec::is_empty")]
    pub environment_settings: Vec<EnvironmentSetting>,
    #[serde(rename = "affinityInfo", default, skip_serializing_if = "Option::is_none")]
    pub affinity_info: Option<AffinityInformation>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub constraints: Option<TaskConstraints>,
    #[serde(rename = "userIdentity", default, skip_serializing_if = "Option::is_none")]
    pub user_identity: Option<UserIdentity>,
    #[serde(rename = "multiInstanceSettings", default, skip_serializing_if = "Option::is_none")]
    pub multi_instance_settings: Option<MultiInstanceSettings>,
    #[serde(rename = "dependsOn", default, skip_serializing_if = "Option::is_none")]
    pub depends_on: Option<TaskDependencies>,
    #[serde(rename = "applicationPackageReferences", default, skip_serializing_if = "Vec::is_empty")]
    pub application_package_references: Vec<ApplicationPackageReference>,
    #[serde(rename = "authenticationTokenSettings", default, skip_serializing_if = "Option::is_none")]
    pub authentication_token_settings: Option<AuthenticationTokenSettings>,
}
impl TaskAddParameter {
    pub fn new(id: String, command_line: String) -> Self {
        Self {
            id,
            display_name: None,
            command_line,
            container_settings: None,
            exit_conditions: None,
            resource_files: Vec::new(),
            output_files: Vec::new(),
            environment_settings: Vec::new(),
            affinity_info: None,
            constraints: None,
            user_identity: None,
            multi_instance_settings: None,
            depends_on: None,
            application_package_references: Vec::new(),
            authentication_token_settings: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskAddResult {
    #[serde(deserialize_with = "case_insensitive_deserialize")]
    pub status: task_add_result::Status,
    #[serde(rename = "taskId")]
    pub task_id: String,
    #[serde(rename = "eTag", default, skip_serializing_if = "Option::is_none")]
    pub e_tag: Option<String>,
    #[serde(rename = "lastModified", default, skip_serializing_if = "Option::is_none")]
    pub last_modified: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<BatchError>,
}
impl TaskAddResult {
    pub fn new(status: task_add_result::Status, task_id: String) -> Self {
        Self {
            status,
            task_id,
            e_tag: None,
            last_modified: None,
            location: None,
            error: None,
        }
    }
}
pub mod task_add_result {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum Status {
        #[serde(rename = "success")]
        Success,
        #[serde(rename = "clienterror")]
        Clienterror,
        #[serde(rename = "servererror")]
        Servererror,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskConstraints {
    #[serde(rename = "maxWallClockTime", default, skip_serializing_if = "Option::is_none")]
    pub max_wall_clock_time: Option<String>,
    #[serde(rename = "retentionTime", default, skip_serializing_if = "Option::is_none")]
    pub retention_time: Option<String>,
    #[serde(rename = "maxTaskRetryCount", default, skip_serializing_if = "Option::is_none")]
    pub max_task_retry_count: Option<i32>,
}
impl TaskConstraints {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskContainerExecutionInformation {
    #[serde(rename = "containerId", default, skip_serializing_if = "Option::is_none")]
    pub container_id: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub error: Option<String>,
}
impl TaskContainerExecutionInformation {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskContainerSettings {
    #[serde(rename = "containerRunOptions", default, skip_serializing_if = "Option::is_none")]
    pub container_run_options: Option<String>,
    #[serde(rename = "imageName")]
    pub image_name: String,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub registry: Option<ContainerRegistry>,
}
impl TaskContainerSettings {
    pub fn new(image_name: String) -> Self {
        Self {
            container_run_options: None,
            image_name,
            registry: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskCounts {
    pub active: i32,
    pub running: i32,
    pub completed: i32,
    pub succeeded: i32,
    pub failed: i32,
}
impl TaskCounts {
    pub fn new(active: i32, running: i32, completed: i32, succeeded: i32, failed: i32) -> Self {
        Self {
            active,
            running,
            completed,
            succeeded,
            failed,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskDependencies {
    #[serde(rename = "taskIds", default, skip_serializing_if = "Vec::is_empty")]
    pub task_ids: Vec<String>,
    #[serde(rename = "taskIdRanges", default, skip_serializing_if = "Vec::is_empty")]
    pub task_id_ranges: Vec<TaskIdRange>,
}
impl TaskDependencies {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskExecutionInformation {
    #[serde(rename = "startTime", default, skip_serializing_if = "Option::is_none")]
    pub start_time: Option<String>,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
    #[serde(rename = "exitCode", default, skip_serializing_if = "Option::is_none")]
    pub exit_code: Option<i32>,
    #[serde(rename = "containerInfo", default, skip_serializing_if = "Option::is_none")]
    pub container_info: Option<TaskContainerExecutionInformation>,
    #[serde(rename = "failureInfo", default, skip_serializing_if = "Option::is_none")]
    pub failure_info: Option<TaskFailureInformation>,
    #[serde(rename = "retryCount")]
    pub retry_count: i32,
    #[serde(rename = "lastRetryTime", default, skip_serializing_if = "Option::is_none")]
    pub last_retry_time: Option<String>,
    #[serde(rename = "requeueCount")]
    pub requeue_count: i32,
    #[serde(rename = "lastRequeueTime", default, skip_serializing_if = "Option::is_none")]
    pub last_requeue_time: Option<String>,
    #[serde(
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub result: Option<TaskExecutionResult>,
}
impl TaskExecutionInformation {
    pub fn new(retry_count: i32, requeue_count: i32) -> Self {
        Self {
            start_time: None,
            end_time: None,
            exit_code: None,
            container_info: None,
            failure_info: None,
            retry_count,
            last_retry_time: None,
            requeue_count,
            last_requeue_time: None,
            result: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TaskExecutionResult {
    #[serde(rename = "success")]
    Success,
    #[serde(rename = "failure")]
    Failure,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskFailureInformation {
    #[serde(deserialize_with = "case_insensitive_deserialize")]
    pub category: ErrorCategory,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub code: Option<String>,
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(default, skip_serializing_if = "Vec::is_empty")]
    pub details: Vec<NameValuePair>,
}
impl TaskFailureInformation {
    pub fn new(category: ErrorCategory) -> Self {
        Self {
            category,
            code: None,
            message: None,
            details: Vec::new(),
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskIdRange {
    pub start: i32,
    pub end: i32,
}
impl TaskIdRange {
    pub fn new(start: i32, end: i32) -> Self {
        Self { start, end }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskInformation {
    #[serde(rename = "taskUrl", default, skip_serializing_if = "Option::is_none")]
    pub task_url: Option<String>,
    #[serde(rename = "jobId", default, skip_serializing_if = "Option::is_none")]
    pub job_id: Option<String>,
    #[serde(rename = "taskId", default, skip_serializing_if = "Option::is_none")]
    pub task_id: Option<String>,
    #[serde(rename = "subtaskId", default, skip_serializing_if = "Option::is_none")]
    pub subtask_id: Option<i32>,
    #[serde(rename = "taskState", deserialize_with = "case_insensitive_deserialize")]
    pub task_state: TaskState,
    #[serde(rename = "executionInfo", default, skip_serializing_if = "Option::is_none")]
    pub execution_info: Option<TaskExecutionInformation>,
}
impl TaskInformation {
    pub fn new(task_state: TaskState) -> Self {
        Self {
            task_url: None,
            job_id: None,
            task_id: None,
            subtask_id: None,
            task_state,
            execution_info: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskSchedulingPolicy {
    #[serde(rename = "nodeFillType", deserialize_with = "case_insensitive_deserialize")]
    pub node_fill_type: task_scheduling_policy::NodeFillType,
}
impl TaskSchedulingPolicy {
    pub fn new(node_fill_type: task_scheduling_policy::NodeFillType) -> Self {
        Self { node_fill_type }
    }
}
pub mod task_scheduling_policy {
    use super::*;
    #[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
    pub enum NodeFillType {
        #[serde(rename = "spread")]
        Spread,
        #[serde(rename = "pack")]
        Pack,
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub enum TaskState {
    #[serde(rename = "active")]
    Active,
    #[serde(rename = "preparing")]
    Preparing,
    #[serde(rename = "running")]
    Running,
    #[serde(rename = "completed")]
    Completed,
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct TaskStatistics {
    pub url: String,
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[serde(rename = "lastUpdateTime")]
    pub last_update_time: String,
    #[serde(rename = "userCPUTime")]
    pub user_cpu_time: String,
    #[serde(rename = "kernelCPUTime")]
    pub kernel_cpu_time: String,
    #[serde(rename = "wallClockTime")]
    pub wall_clock_time: String,
    #[serde(rename = "readIOps")]
    pub read_i_ops: i64,
    #[serde(rename = "writeIOps")]
    pub write_i_ops: i64,
    #[serde(rename = "readIOGiB")]
    pub read_io_gi_b: f64,
    #[serde(rename = "writeIOGiB")]
    pub write_io_gi_b: f64,
    #[serde(rename = "waitTime")]
    pub wait_time: String,
}
impl TaskStatistics {
    pub fn new(
        url: String,
        start_time: String,
        last_update_time: String,
        user_cpu_time: String,
        kernel_cpu_time: String,
        wall_clock_time: String,
        read_i_ops: i64,
        write_i_ops: i64,
        read_io_gi_b: f64,
        write_io_gi_b: f64,
        wait_time: String,
    ) -> Self {
        Self {
            url,
            start_time,
            last_update_time,
            user_cpu_time,
            kernel_cpu_time,
            wall_clock_time,
            read_i_ops,
            write_i_ops,
            read_io_gi_b,
            write_io_gi_b,
            wait_time,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct TaskUpdateParameter {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub constraints: Option<TaskConstraints>,
}
impl TaskUpdateParameter {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UploadBatchServiceLogsConfiguration {
    #[serde(rename = "containerUrl")]
    pub container_url: String,
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[serde(rename = "endTime", default, skip_serializing_if = "Option::is_none")]
    pub end_time: Option<String>,
}
impl UploadBatchServiceLogsConfiguration {
    pub fn new(container_url: String, start_time: String) -> Self {
        Self {
            container_url,
            start_time,
            end_time: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UploadBatchServiceLogsResult {
    #[serde(rename = "virtualDirectoryName")]
    pub virtual_directory_name: String,
    #[serde(rename = "numberOfFilesUploaded")]
    pub number_of_files_uploaded: i32,
}
impl UploadBatchServiceLogsResult {
    pub fn new(virtual_directory_name: String, number_of_files_uploaded: i32) -> Self {
        Self {
            virtual_directory_name,
            number_of_files_uploaded,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UsageStatistics {
    #[serde(rename = "startTime")]
    pub start_time: String,
    #[serde(rename = "lastUpdateTime")]
    pub last_update_time: String,
    #[serde(rename = "dedicatedCoreTime")]
    pub dedicated_core_time: String,
}
impl UsageStatistics {
    pub fn new(start_time: String, last_update_time: String, dedicated_core_time: String) -> Self {
        Self {
            start_time,
            last_update_time,
            dedicated_core_time,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserAccount {
    pub name: String,
    pub password: String,
    #[serde(
        rename = "elevationLevel",
        default,
        skip_serializing_if = "Option::is_none",
        deserialize_with = "case_insensitive_deserialize"
    )]
    pub elevation_level: Option<ElevationLevel>,
    #[serde(rename = "linuxUserConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub linux_user_configuration: Option<LinuxUserConfiguration>,
}
impl UserAccount {
    pub fn new(name: String, password: String) -> Self {
        Self {
            name,
            password,
            elevation_level: None,
            linux_user_configuration: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct UserIdentity {
    #[serde(default, skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    #[serde(rename = "autoUser", default, skip_serializing_if = "Option::is_none")]
    pub auto_user: Option<AutoUserSpecification>,
}
impl UserIdentity {
    pub fn new() -> Self {
        Self::default()
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VirtualMachineConfiguration {
    #[serde(rename = "imageReference")]
    pub image_reference: ImageReference,
    #[serde(rename = "osDisk", default, skip_serializing_if = "Option::is_none")]
    pub os_disk: Option<OsDisk>,
    #[serde(rename = "nodeAgentSKUId")]
    pub node_agent_sku_id: String,
    #[serde(rename = "windowsConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub windows_configuration: Option<WindowsConfiguration>,
    #[serde(rename = "dataDisks", default, skip_serializing_if = "Vec::is_empty")]
    pub data_disks: Vec<DataDisk>,
    #[serde(rename = "licenseType", default, skip_serializing_if = "Option::is_none")]
    pub license_type: Option<String>,
    #[serde(rename = "containerConfiguration", default, skip_serializing_if = "Option::is_none")]
    pub container_configuration: Option<ContainerConfiguration>,
}
impl VirtualMachineConfiguration {
    pub fn new(image_reference: ImageReference, node_agent_sku_id: String) -> Self {
        Self {
            image_reference,
            os_disk: None,
            node_agent_sku_id,
            windows_configuration: None,
            data_disks: Vec::new(),
            license_type: None,
            container_configuration: None,
        }
    }
}
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize, Default)]
pub struct WindowsConfiguration {
    #[serde(rename = "enableAutomaticUpdates", default, skip_serializing_if = "Option::is_none")]
    pub enable_automatic_updates: Option<bool>,
}
impl WindowsConfiguration {
    pub fn new() -> Self {
        Self::default()
    }
}
