#![doc = "generated by AutoRust"]
#![allow(unused_mut)]
#![allow(unused_variables)]
#![allow(unused_imports)]
use super::models;
#[derive(Clone)]
pub struct Client {
    endpoint: String,
    credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
    scopes: Vec<String>,
    pipeline: azure_core::Pipeline,
}
#[derive(Clone)]
pub struct ClientBuilder {
    credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
    endpoint: Option<String>,
    scopes: Option<Vec<String>>,
}
pub const DEFAULT_ENDPOINT: &str = azure_core::resource_manager_endpoint::AZURE_PUBLIC_CLOUD;
impl ClientBuilder {
    pub fn new(credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>) -> Self {
        Self {
            credential,
            endpoint: None,
            scopes: None,
        }
    }
    pub fn endpoint(mut self, endpoint: impl Into<String>) -> Self {
        self.endpoint = Some(endpoint.into());
        self
    }
    pub fn scopes(mut self, scopes: &[&str]) -> Self {
        self.scopes = Some(scopes.iter().map(|scope| (*scope).to_owned()).collect());
        self
    }
    pub fn build(self) -> Client {
        let endpoint = self.endpoint.unwrap_or_else(|| DEFAULT_ENDPOINT.to_owned());
        let scopes = self.scopes.unwrap_or_else(|| vec![format!("{}/", endpoint)]);
        Client::new(endpoint, self.credential, scopes)
    }
}
impl Client {
    pub(crate) fn endpoint(&self) -> &str {
        self.endpoint.as_str()
    }
    pub(crate) fn token_credential(&self) -> &dyn azure_core::auth::TokenCredential {
        self.credential.as_ref()
    }
    pub(crate) fn scopes(&self) -> Vec<&str> {
        self.scopes.iter().map(String::as_str).collect()
    }
    pub(crate) async fn send(&self, request: impl Into<azure_core::Request>) -> azure_core::error::Result<azure_core::Response> {
        let mut context = azure_core::Context::default();
        let mut request = request.into();
        self.pipeline.send(&mut context, &mut request).await
    }
    pub fn new(
        endpoint: impl Into<String>,
        credential: std::sync::Arc<dyn azure_core::auth::TokenCredential>,
        scopes: Vec<String>,
    ) -> Self {
        let endpoint = endpoint.into();
        let pipeline = azure_core::Pipeline::new(
            option_env!("CARGO_PKG_NAME"),
            option_env!("CARGO_PKG_VERSION"),
            azure_core::ClientOptions::default(),
            Vec::new(),
            Vec::new(),
        );
        Self {
            endpoint,
            credential,
            scopes,
            pipeline,
        }
    }
}
#[non_exhaustive]
#[derive(Debug, thiserror :: Error)]
#[allow(non_camel_case_types)]
pub enum Error {
    #[error(transparent)]
    GetKeys(#[from] get_keys::Error),
    #[error(transparent)]
    CheckKeys(#[from] check_keys::Error),
    #[error(transparent)]
    GetKeyValues(#[from] get_key_values::Error),
    #[error(transparent)]
    CheckKeyValues(#[from] check_key_values::Error),
    #[error(transparent)]
    GetKeyValue(#[from] get_key_value::Error),
    #[error(transparent)]
    PutKeyValue(#[from] put_key_value::Error),
    #[error(transparent)]
    DeleteKeyValue(#[from] delete_key_value::Error),
    #[error(transparent)]
    CheckKeyValue(#[from] check_key_value::Error),
    #[error(transparent)]
    GetLabels(#[from] get_labels::Error),
    #[error(transparent)]
    CheckLabels(#[from] check_labels::Error),
    #[error(transparent)]
    PutLock(#[from] put_lock::Error),
    #[error(transparent)]
    DeleteLock(#[from] delete_lock::Error),
    #[error(transparent)]
    GetRevisions(#[from] get_revisions::Error),
    #[error(transparent)]
    CheckRevisions(#[from] check_revisions::Error),
}
impl Client {
    #[doc = "Gets a list of keys."]
    pub fn get_keys(&self) -> get_keys::Builder {
        get_keys::Builder {
            client: self.clone(),
            name: None,
            sync_token: None,
            after: None,
            accept_datetime: None,
        }
    }
    #[doc = "Requests the headers and status of the given resource."]
    pub fn check_keys(&self) -> check_keys::Builder {
        check_keys::Builder {
            client: self.clone(),
            name: None,
            sync_token: None,
            after: None,
            accept_datetime: None,
        }
    }
    #[doc = "Gets a list of key-values."]
    pub fn get_key_values(&self) -> get_key_values::Builder {
        get_key_values::Builder {
            client: self.clone(),
            key: None,
            label: None,
            sync_token: None,
            after: None,
            accept_datetime: None,
            select: Vec::new(),
        }
    }
    #[doc = "Requests the headers and status of the given resource."]
    pub fn check_key_values(&self) -> check_key_values::Builder {
        check_key_values::Builder {
            client: self.clone(),
            key: None,
            label: None,
            sync_token: None,
            after: None,
            accept_datetime: None,
            select: Vec::new(),
        }
    }
    #[doc = "Gets a single key-value."]
    pub fn get_key_value(&self, key: impl Into<String>) -> get_key_value::Builder {
        get_key_value::Builder {
            client: self.clone(),
            key: key.into(),
            label: None,
            sync_token: None,
            accept_datetime: None,
            if_match: None,
            if_none_match: None,
            select: Vec::new(),
        }
    }
    #[doc = "Creates a key-value."]
    pub fn put_key_value(&self, key: impl Into<String>) -> put_key_value::Builder {
        put_key_value::Builder {
            client: self.clone(),
            key: key.into(),
            label: None,
            entity: None,
            sync_token: None,
            if_match: None,
            if_none_match: None,
        }
    }
    #[doc = "Deletes a key-value."]
    pub fn delete_key_value(&self, key: impl Into<String>) -> delete_key_value::Builder {
        delete_key_value::Builder {
            client: self.clone(),
            key: key.into(),
            label: None,
            sync_token: None,
            if_match: None,
        }
    }
    #[doc = "Requests the headers and status of the given resource."]
    pub fn check_key_value(&self, key: impl Into<String>) -> check_key_value::Builder {
        check_key_value::Builder {
            client: self.clone(),
            key: key.into(),
            label: None,
            sync_token: None,
            accept_datetime: None,
            if_match: None,
            if_none_match: None,
            select: Vec::new(),
        }
    }
    #[doc = "Gets a list of labels."]
    pub fn get_labels(&self) -> get_labels::Builder {
        get_labels::Builder {
            client: self.clone(),
            name: None,
            sync_token: None,
            after: None,
            accept_datetime: None,
            select: Vec::new(),
        }
    }
    #[doc = "Requests the headers and status of the given resource."]
    pub fn check_labels(&self) -> check_labels::Builder {
        check_labels::Builder {
            client: self.clone(),
            name: None,
            sync_token: None,
            after: None,
            accept_datetime: None,
            select: Vec::new(),
        }
    }
    #[doc = "Locks a key-value."]
    pub fn put_lock(&self, key: impl Into<String>) -> put_lock::Builder {
        put_lock::Builder {
            client: self.clone(),
            key: key.into(),
            label: None,
            sync_token: None,
            if_match: None,
            if_none_match: None,
        }
    }
    #[doc = "Unlocks a key-value."]
    pub fn delete_lock(&self, key: impl Into<String>) -> delete_lock::Builder {
        delete_lock::Builder {
            client: self.clone(),
            key: key.into(),
            label: None,
            sync_token: None,
            if_match: None,
            if_none_match: None,
        }
    }
    #[doc = "Gets a list of key-value revisions."]
    pub fn get_revisions(&self) -> get_revisions::Builder {
        get_revisions::Builder {
            client: self.clone(),
            key: None,
            label: None,
            sync_token: None,
            after: None,
            accept_datetime: None,
            select: Vec::new(),
        }
    }
    #[doc = "Requests the headers and status of the given resource."]
    pub fn check_revisions(&self) -> check_revisions::Builder {
        check_revisions::Builder {
            client: self.clone(),
            key: None,
            label: None,
            sync_token: None,
            after: None,
            accept_datetime: None,
            select: Vec::new(),
        }
    }
}
pub mod get_keys {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::Error,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) name: Option<String>,
        pub(crate) sync_token: Option<String>,
        pub(crate) after: Option<String>,
        pub(crate) accept_datetime: Option<String>,
    }
    impl Builder {
        pub fn name(mut self, name: impl Into<String>) -> Self {
            self.name = Some(name.into());
            self
        }
        pub fn sync_token(mut self, sync_token: impl Into<String>) -> Self {
            self.sync_token = Some(sync_token.into());
            self
        }
        pub fn after(mut self, after: impl Into<String>) -> Self {
            self.after = Some(after.into());
            self
        }
        pub fn accept_datetime(mut self, accept_datetime: impl Into<String>) -> Self {
            self.accept_datetime = Some(accept_datetime.into());
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::KeyListResult, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/keys", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "1.0");
                if let Some(name) = &self.name {
                    url.query_pairs_mut().append_pair("name", name);
                }
                if let Some(sync_token) = &self.sync_token {
                    req_builder = req_builder.header("Sync-Token", sync_token);
                }
                if let Some(after) = &self.after {
                    url.query_pairs_mut().append_pair("After", after);
                }
                if let Some(accept_datetime) = &self.accept_datetime {
                    req_builder = req_builder.header("Accept-Datetime", accept_datetime);
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::KeyListResult =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::Error =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod check_keys {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse { status_code: http::StatusCode },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) name: Option<String>,
        pub(crate) sync_token: Option<String>,
        pub(crate) after: Option<String>,
        pub(crate) accept_datetime: Option<String>,
    }
    impl Builder {
        pub fn name(mut self, name: impl Into<String>) -> Self {
            self.name = Some(name.into());
            self
        }
        pub fn sync_token(mut self, sync_token: impl Into<String>) -> Self {
            self.sync_token = Some(sync_token.into());
            self
        }
        pub fn after(mut self, after: impl Into<String>) -> Self {
            self.after = Some(after.into());
            self
        }
        pub fn accept_datetime(mut self, accept_datetime: impl Into<String>) -> Self {
            self.accept_datetime = Some(accept_datetime.into());
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/keys", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::HEAD);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "1.0");
                if let Some(name) = &self.name {
                    url.query_pairs_mut().append_pair("name", name);
                }
                if let Some(sync_token) = &self.sync_token {
                    req_builder = req_builder.header("Sync-Token", sync_token);
                }
                if let Some(after) = &self.after {
                    url.query_pairs_mut().append_pair("After", after);
                }
                if let Some(accept_datetime) = &self.accept_datetime {
                    req_builder = req_builder.header("Accept-Datetime", accept_datetime);
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => Err(Error::DefaultResponse { status_code }),
                }
            })
        }
    }
}
pub mod get_key_values {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::Error,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) key: Option<String>,
        pub(crate) label: Option<String>,
        pub(crate) sync_token: Option<String>,
        pub(crate) after: Option<String>,
        pub(crate) accept_datetime: Option<String>,
        pub(crate) select: Vec<String>,
    }
    impl Builder {
        pub fn key(mut self, key: impl Into<String>) -> Self {
            self.key = Some(key.into());
            self
        }
        pub fn label(mut self, label: impl Into<String>) -> Self {
            self.label = Some(label.into());
            self
        }
        pub fn sync_token(mut self, sync_token: impl Into<String>) -> Self {
            self.sync_token = Some(sync_token.into());
            self
        }
        pub fn after(mut self, after: impl Into<String>) -> Self {
            self.after = Some(after.into());
            self
        }
        pub fn accept_datetime(mut self, accept_datetime: impl Into<String>) -> Self {
            self.accept_datetime = Some(accept_datetime.into());
            self
        }
        pub fn select(mut self, select: Vec<String>) -> Self {
            self.select = select;
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::KeyValueListResult, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/kv", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "1.0");
                if let Some(key) = &self.key {
                    url.query_pairs_mut().append_pair("key", key);
                }
                if let Some(label) = &self.label {
                    url.query_pairs_mut().append_pair("label", label);
                }
                if let Some(sync_token) = &self.sync_token {
                    req_builder = req_builder.header("Sync-Token", sync_token);
                }
                if let Some(after) = &self.after {
                    url.query_pairs_mut().append_pair("After", after);
                }
                if let Some(accept_datetime) = &self.accept_datetime {
                    req_builder = req_builder.header("Accept-Datetime", accept_datetime);
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::KeyValueListResult =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::Error =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod check_key_values {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse { status_code: http::StatusCode },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) key: Option<String>,
        pub(crate) label: Option<String>,
        pub(crate) sync_token: Option<String>,
        pub(crate) after: Option<String>,
        pub(crate) accept_datetime: Option<String>,
        pub(crate) select: Vec<String>,
    }
    impl Builder {
        pub fn key(mut self, key: impl Into<String>) -> Self {
            self.key = Some(key.into());
            self
        }
        pub fn label(mut self, label: impl Into<String>) -> Self {
            self.label = Some(label.into());
            self
        }
        pub fn sync_token(mut self, sync_token: impl Into<String>) -> Self {
            self.sync_token = Some(sync_token.into());
            self
        }
        pub fn after(mut self, after: impl Into<String>) -> Self {
            self.after = Some(after.into());
            self
        }
        pub fn accept_datetime(mut self, accept_datetime: impl Into<String>) -> Self {
            self.accept_datetime = Some(accept_datetime.into());
            self
        }
        pub fn select(mut self, select: Vec<String>) -> Self {
            self.select = select;
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/kv", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::HEAD);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "1.0");
                if let Some(key) = &self.key {
                    url.query_pairs_mut().append_pair("key", key);
                }
                if let Some(label) = &self.label {
                    url.query_pairs_mut().append_pair("label", label);
                }
                if let Some(sync_token) = &self.sync_token {
                    req_builder = req_builder.header("Sync-Token", sync_token);
                }
                if let Some(after) = &self.after {
                    url.query_pairs_mut().append_pair("After", after);
                }
                if let Some(accept_datetime) = &self.accept_datetime {
                    req_builder = req_builder.header("Accept-Datetime", accept_datetime);
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => Err(Error::DefaultResponse { status_code }),
                }
            })
        }
    }
}
pub mod get_key_value {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::Error,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) key: String,
        pub(crate) label: Option<String>,
        pub(crate) sync_token: Option<String>,
        pub(crate) accept_datetime: Option<String>,
        pub(crate) if_match: Option<String>,
        pub(crate) if_none_match: Option<String>,
        pub(crate) select: Vec<String>,
    }
    impl Builder {
        pub fn label(mut self, label: impl Into<String>) -> Self {
            self.label = Some(label.into());
            self
        }
        pub fn sync_token(mut self, sync_token: impl Into<String>) -> Self {
            self.sync_token = Some(sync_token.into());
            self
        }
        pub fn accept_datetime(mut self, accept_datetime: impl Into<String>) -> Self {
            self.accept_datetime = Some(accept_datetime.into());
            self
        }
        pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
            self.if_match = Some(if_match.into());
            self
        }
        pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
            self.if_none_match = Some(if_none_match.into());
            self
        }
        pub fn select(mut self, select: Vec<String>) -> Self {
            self.select = select;
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::KeyValue, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/kv/{}", self.client.endpoint(), &self.key);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "1.0");
                if let Some(label) = &self.label {
                    url.query_pairs_mut().append_pair("label", label);
                }
                if let Some(sync_token) = &self.sync_token {
                    req_builder = req_builder.header("Sync-Token", sync_token);
                }
                if let Some(accept_datetime) = &self.accept_datetime {
                    req_builder = req_builder.header("Accept-Datetime", accept_datetime);
                }
                if let Some(if_match) = &self.if_match {
                    req_builder = req_builder.header("If-Match", if_match);
                }
                if let Some(if_none_match) = &self.if_none_match {
                    req_builder = req_builder.header("If-None-Match", if_none_match);
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::KeyValue =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::Error =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod put_key_value {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::Error,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) key: String,
        pub(crate) label: Option<String>,
        pub(crate) entity: Option<models::KeyValue>,
        pub(crate) sync_token: Option<String>,
        pub(crate) if_match: Option<String>,
        pub(crate) if_none_match: Option<String>,
    }
    impl Builder {
        pub fn label(mut self, label: impl Into<String>) -> Self {
            self.label = Some(label.into());
            self
        }
        pub fn entity(mut self, entity: impl Into<models::KeyValue>) -> Self {
            self.entity = Some(entity.into());
            self
        }
        pub fn sync_token(mut self, sync_token: impl Into<String>) -> Self {
            self.sync_token = Some(sync_token.into());
            self
        }
        pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
            self.if_match = Some(if_match.into());
            self
        }
        pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
            self.if_none_match = Some(if_none_match.into());
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::KeyValue, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/kv/{}", self.client.endpoint(), &self.key);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::PUT);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "1.0");
                if let Some(label) = &self.label {
                    url.query_pairs_mut().append_pair("label", label);
                }
                let req_body = if let Some(entity) = &self.entity {
                    req_builder = req_builder.header("content-type", "application/json");
                    azure_core::to_json(entity).map_err(Error::Serialize)?
                } else {
                    azure_core::EMPTY_BODY
                };
                if let Some(sync_token) = &self.sync_token {
                    req_builder = req_builder.header("Sync-Token", sync_token);
                }
                if let Some(if_match) = &self.if_match {
                    req_builder = req_builder.header("If-Match", if_match);
                }
                if let Some(if_none_match) = &self.if_none_match {
                    req_builder = req_builder.header("If-None-Match", if_none_match);
                }
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::KeyValue =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::Error =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod delete_key_value {
    use super::models;
    #[derive(Debug)]
    pub enum Response {
        Ok200(models::KeyValue),
        NoContent204,
    }
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::Error,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) key: String,
        pub(crate) label: Option<String>,
        pub(crate) sync_token: Option<String>,
        pub(crate) if_match: Option<String>,
    }
    impl Builder {
        pub fn label(mut self, label: impl Into<String>) -> Self {
            self.label = Some(label.into());
            self
        }
        pub fn sync_token(mut self, sync_token: impl Into<String>) -> Self {
            self.sync_token = Some(sync_token.into());
            self
        }
        pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
            self.if_match = Some(if_match.into());
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<Response, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/kv/{}", self.client.endpoint(), &self.key);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::DELETE);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "1.0");
                if let Some(label) = &self.label {
                    url.query_pairs_mut().append_pair("label", label);
                }
                if let Some(sync_token) = &self.sync_token {
                    req_builder = req_builder.header("Sync-Token", sync_token);
                }
                if let Some(if_match) = &self.if_match {
                    req_builder = req_builder.header("If-Match", if_match);
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::KeyValue =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(Response::Ok200(rsp_value))
                    }
                    http::StatusCode::NO_CONTENT => Ok(Response::NoContent204),
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::Error =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod check_key_value {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse { status_code: http::StatusCode },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) key: String,
        pub(crate) label: Option<String>,
        pub(crate) sync_token: Option<String>,
        pub(crate) accept_datetime: Option<String>,
        pub(crate) if_match: Option<String>,
        pub(crate) if_none_match: Option<String>,
        pub(crate) select: Vec<String>,
    }
    impl Builder {
        pub fn label(mut self, label: impl Into<String>) -> Self {
            self.label = Some(label.into());
            self
        }
        pub fn sync_token(mut self, sync_token: impl Into<String>) -> Self {
            self.sync_token = Some(sync_token.into());
            self
        }
        pub fn accept_datetime(mut self, accept_datetime: impl Into<String>) -> Self {
            self.accept_datetime = Some(accept_datetime.into());
            self
        }
        pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
            self.if_match = Some(if_match.into());
            self
        }
        pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
            self.if_none_match = Some(if_none_match.into());
            self
        }
        pub fn select(mut self, select: Vec<String>) -> Self {
            self.select = select;
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/kv/{}", self.client.endpoint(), &self.key);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::HEAD);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "1.0");
                if let Some(label) = &self.label {
                    url.query_pairs_mut().append_pair("label", label);
                }
                if let Some(sync_token) = &self.sync_token {
                    req_builder = req_builder.header("Sync-Token", sync_token);
                }
                if let Some(accept_datetime) = &self.accept_datetime {
                    req_builder = req_builder.header("Accept-Datetime", accept_datetime);
                }
                if let Some(if_match) = &self.if_match {
                    req_builder = req_builder.header("If-Match", if_match);
                }
                if let Some(if_none_match) = &self.if_none_match {
                    req_builder = req_builder.header("If-None-Match", if_none_match);
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => Err(Error::DefaultResponse { status_code }),
                }
            })
        }
    }
}
pub mod get_labels {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::Error,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) name: Option<String>,
        pub(crate) sync_token: Option<String>,
        pub(crate) after: Option<String>,
        pub(crate) accept_datetime: Option<String>,
        pub(crate) select: Vec<String>,
    }
    impl Builder {
        pub fn name(mut self, name: impl Into<String>) -> Self {
            self.name = Some(name.into());
            self
        }
        pub fn sync_token(mut self, sync_token: impl Into<String>) -> Self {
            self.sync_token = Some(sync_token.into());
            self
        }
        pub fn after(mut self, after: impl Into<String>) -> Self {
            self.after = Some(after.into());
            self
        }
        pub fn accept_datetime(mut self, accept_datetime: impl Into<String>) -> Self {
            self.accept_datetime = Some(accept_datetime.into());
            self
        }
        pub fn select(mut self, select: Vec<String>) -> Self {
            self.select = select;
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::LabelListResult, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/labels", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "1.0");
                if let Some(name) = &self.name {
                    url.query_pairs_mut().append_pair("name", name);
                }
                if let Some(sync_token) = &self.sync_token {
                    req_builder = req_builder.header("Sync-Token", sync_token);
                }
                if let Some(after) = &self.after {
                    url.query_pairs_mut().append_pair("After", after);
                }
                if let Some(accept_datetime) = &self.accept_datetime {
                    req_builder = req_builder.header("Accept-Datetime", accept_datetime);
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::LabelListResult =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::Error =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod check_labels {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse { status_code: http::StatusCode },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) name: Option<String>,
        pub(crate) sync_token: Option<String>,
        pub(crate) after: Option<String>,
        pub(crate) accept_datetime: Option<String>,
        pub(crate) select: Vec<String>,
    }
    impl Builder {
        pub fn name(mut self, name: impl Into<String>) -> Self {
            self.name = Some(name.into());
            self
        }
        pub fn sync_token(mut self, sync_token: impl Into<String>) -> Self {
            self.sync_token = Some(sync_token.into());
            self
        }
        pub fn after(mut self, after: impl Into<String>) -> Self {
            self.after = Some(after.into());
            self
        }
        pub fn accept_datetime(mut self, accept_datetime: impl Into<String>) -> Self {
            self.accept_datetime = Some(accept_datetime.into());
            self
        }
        pub fn select(mut self, select: Vec<String>) -> Self {
            self.select = select;
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/labels", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::HEAD);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "1.0");
                if let Some(name) = &self.name {
                    url.query_pairs_mut().append_pair("name", name);
                }
                if let Some(sync_token) = &self.sync_token {
                    req_builder = req_builder.header("Sync-Token", sync_token);
                }
                if let Some(after) = &self.after {
                    url.query_pairs_mut().append_pair("After", after);
                }
                if let Some(accept_datetime) = &self.accept_datetime {
                    req_builder = req_builder.header("Accept-Datetime", accept_datetime);
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => Err(Error::DefaultResponse { status_code }),
                }
            })
        }
    }
}
pub mod put_lock {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::Error,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) key: String,
        pub(crate) label: Option<String>,
        pub(crate) sync_token: Option<String>,
        pub(crate) if_match: Option<String>,
        pub(crate) if_none_match: Option<String>,
    }
    impl Builder {
        pub fn label(mut self, label: impl Into<String>) -> Self {
            self.label = Some(label.into());
            self
        }
        pub fn sync_token(mut self, sync_token: impl Into<String>) -> Self {
            self.sync_token = Some(sync_token.into());
            self
        }
        pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
            self.if_match = Some(if_match.into());
            self
        }
        pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
            self.if_none_match = Some(if_none_match.into());
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::KeyValue, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/locks/{}", self.client.endpoint(), &self.key);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::PUT);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "1.0");
                if let Some(label) = &self.label {
                    url.query_pairs_mut().append_pair("label", label);
                }
                if let Some(sync_token) = &self.sync_token {
                    req_builder = req_builder.header("Sync-Token", sync_token);
                }
                if let Some(if_match) = &self.if_match {
                    req_builder = req_builder.header("If-Match", if_match);
                }
                if let Some(if_none_match) = &self.if_none_match {
                    req_builder = req_builder.header("If-None-Match", if_none_match);
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::KeyValue =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::Error =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod delete_lock {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::Error,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) key: String,
        pub(crate) label: Option<String>,
        pub(crate) sync_token: Option<String>,
        pub(crate) if_match: Option<String>,
        pub(crate) if_none_match: Option<String>,
    }
    impl Builder {
        pub fn label(mut self, label: impl Into<String>) -> Self {
            self.label = Some(label.into());
            self
        }
        pub fn sync_token(mut self, sync_token: impl Into<String>) -> Self {
            self.sync_token = Some(sync_token.into());
            self
        }
        pub fn if_match(mut self, if_match: impl Into<String>) -> Self {
            self.if_match = Some(if_match.into());
            self
        }
        pub fn if_none_match(mut self, if_none_match: impl Into<String>) -> Self {
            self.if_none_match = Some(if_none_match.into());
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::KeyValue, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/locks/{}", self.client.endpoint(), &self.key);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::DELETE);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "1.0");
                if let Some(label) = &self.label {
                    url.query_pairs_mut().append_pair("label", label);
                }
                if let Some(sync_token) = &self.sync_token {
                    req_builder = req_builder.header("Sync-Token", sync_token);
                }
                if let Some(if_match) = &self.if_match {
                    req_builder = req_builder.header("If-Match", if_match);
                }
                if let Some(if_none_match) = &self.if_none_match {
                    req_builder = req_builder.header("If-None-Match", if_none_match);
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::KeyValue =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::Error =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod get_revisions {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse {
            status_code: http::StatusCode,
            value: models::Error,
        },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) key: Option<String>,
        pub(crate) label: Option<String>,
        pub(crate) sync_token: Option<String>,
        pub(crate) after: Option<String>,
        pub(crate) accept_datetime: Option<String>,
        pub(crate) select: Vec<String>,
    }
    impl Builder {
        pub fn key(mut self, key: impl Into<String>) -> Self {
            self.key = Some(key.into());
            self
        }
        pub fn label(mut self, label: impl Into<String>) -> Self {
            self.label = Some(label.into());
            self
        }
        pub fn sync_token(mut self, sync_token: impl Into<String>) -> Self {
            self.sync_token = Some(sync_token.into());
            self
        }
        pub fn after(mut self, after: impl Into<String>) -> Self {
            self.after = Some(after.into());
            self
        }
        pub fn accept_datetime(mut self, accept_datetime: impl Into<String>) -> Self {
            self.accept_datetime = Some(accept_datetime.into());
            self
        }
        pub fn select(mut self, select: Vec<String>) -> Self {
            self.select = select;
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<models::KeyValueListResult, Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/revisions", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::GET);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "1.0");
                if let Some(key) = &self.key {
                    url.query_pairs_mut().append_pair("key", key);
                }
                if let Some(label) = &self.label {
                    url.query_pairs_mut().append_pair("label", label);
                }
                if let Some(sync_token) = &self.sync_token {
                    req_builder = req_builder.header("Sync-Token", sync_token);
                }
                if let Some(after) = &self.after {
                    url.query_pairs_mut().append_pair("After", after);
                }
                if let Some(accept_datetime) = &self.accept_datetime {
                    req_builder = req_builder.header("Accept-Datetime", accept_datetime);
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::KeyValueListResult =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Ok(rsp_value)
                    }
                    status_code => {
                        let rsp_body = azure_core::collect_pinned_stream(rsp_stream).await.map_err(Error::ResponseBytes)?;
                        let rsp_value: models::Error =
                            serde_json::from_slice(&rsp_body).map_err(|source| Error::Deserialize(source, rsp_body.clone()))?;
                        Err(Error::DefaultResponse {
                            status_code,
                            value: rsp_value,
                        })
                    }
                }
            })
        }
    }
}
pub mod check_revisions {
    use super::models;
    #[derive(Debug, thiserror :: Error)]
    pub enum Error {
        #[error("HTTP status code {}", status_code)]
        DefaultResponse { status_code: http::StatusCode },
        #[error("Failed to parse request URL")]
        ParseUrl(#[source] url::ParseError),
        #[error("Failed to build request")]
        BuildRequest(#[source] http::Error),
        #[error("Failed to serialize request body")]
        Serialize(#[source] serde_json::Error),
        #[error("Failed to get access token")]
        GetToken(#[source] azure_core::Error),
        #[error("Failed to execute request")]
        SendRequest(#[source] azure_core::error::Error),
        #[error("Failed to get response bytes")]
        ResponseBytes(#[source] azure_core::error::Error),
        #[error("Failed to deserialize response, body: {1:?}")]
        Deserialize(#[source] serde_json::Error, bytes::Bytes),
    }
    #[derive(Clone)]
    pub struct Builder {
        pub(crate) client: super::Client,
        pub(crate) key: Option<String>,
        pub(crate) label: Option<String>,
        pub(crate) sync_token: Option<String>,
        pub(crate) after: Option<String>,
        pub(crate) accept_datetime: Option<String>,
        pub(crate) select: Vec<String>,
    }
    impl Builder {
        pub fn key(mut self, key: impl Into<String>) -> Self {
            self.key = Some(key.into());
            self
        }
        pub fn label(mut self, label: impl Into<String>) -> Self {
            self.label = Some(label.into());
            self
        }
        pub fn sync_token(mut self, sync_token: impl Into<String>) -> Self {
            self.sync_token = Some(sync_token.into());
            self
        }
        pub fn after(mut self, after: impl Into<String>) -> Self {
            self.after = Some(after.into());
            self
        }
        pub fn accept_datetime(mut self, accept_datetime: impl Into<String>) -> Self {
            self.accept_datetime = Some(accept_datetime.into());
            self
        }
        pub fn select(mut self, select: Vec<String>) -> Self {
            self.select = select;
            self
        }
        pub fn into_future(self) -> futures::future::BoxFuture<'static, std::result::Result<(), Error>> {
            Box::pin(async move {
                let url_str = &format!("{}/revisions", self.client.endpoint(),);
                let mut url = url::Url::parse(url_str).map_err(Error::ParseUrl)?;
                let mut req_builder = http::request::Builder::new();
                req_builder = req_builder.method(http::Method::HEAD);
                let credential = self.client.token_credential();
                let token_response = credential
                    .get_token(&self.client.scopes().join(" "))
                    .await
                    .map_err(Error::GetToken)?;
                req_builder = req_builder.header(http::header::AUTHORIZATION, format!("Bearer {}", token_response.token.secret()));
                url.query_pairs_mut().append_pair("api-version", "1.0");
                if let Some(key) = &self.key {
                    url.query_pairs_mut().append_pair("key", key);
                }
                if let Some(label) = &self.label {
                    url.query_pairs_mut().append_pair("label", label);
                }
                if let Some(sync_token) = &self.sync_token {
                    req_builder = req_builder.header("Sync-Token", sync_token);
                }
                if let Some(after) = &self.after {
                    url.query_pairs_mut().append_pair("After", after);
                }
                if let Some(accept_datetime) = &self.accept_datetime {
                    req_builder = req_builder.header("Accept-Datetime", accept_datetime);
                }
                let req_body = azure_core::EMPTY_BODY;
                req_builder = req_builder.uri(url.as_str());
                let req = req_builder.body(req_body).map_err(Error::BuildRequest)?;
                let rsp = self.client.send(req).await.map_err(Error::SendRequest)?;
                let (rsp_status, rsp_headers, rsp_stream) = rsp.deconstruct();
                match rsp_status {
                    http::StatusCode::OK => Ok(()),
                    status_code => Err(Error::DefaultResponse { status_code }),
                }
            })
        }
    }
}
